/* history-button.c generated by valac 0.56.3, the Vala compiler
 * generated from history-button.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of a GNOME game

   Copyright (C) 2019 – Arnaud Bonatti <arnaud.bonatti@gmail.com>

   This application is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this application.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#define HISTORY_BUTTON_usual_best_score_string _ ("Bravo! You finished the game!")
#define HISTORY_BUTTON_usual_best_score_string_untranslated "Bravo! You finished the game!"
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_HISTORY_BUTTON (history_button_get_type ())
#define HISTORY_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_BUTTON, HistoryButton))
#define HISTORY_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_BUTTON, HistoryButtonClass))
#define IS_HISTORY_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_BUTTON))
#define IS_HISTORY_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_BUTTON))
#define HISTORY_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_BUTTON, HistoryButtonClass))

typedef struct _HistoryButton HistoryButton;
typedef struct _HistoryButtonClass HistoryButtonClass;
typedef struct _HistoryButtonPrivate HistoryButtonPrivate;
enum  {
	HISTORY_BUTTON_0_PROPERTY,
	HISTORY_BUTTON_NUM_PROPERTIES
};
static GParamSpec* history_button_properties[HISTORY_BUTTON_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _HistoryButton {
	GtkMenuButton parent_instance;
	HistoryButtonPrivate * priv;
};

struct _HistoryButtonClass {
	GtkMenuButtonClass parent_class;
};

struct _HistoryButtonPrivate {
	guint best_score;
	guint last_moves_count;
};

static gint HistoryButton_private_offset;
static gpointer history_button_parent_class = NULL;

VALA_EXTERN GType history_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryButton, g_object_unref)
static void history_button_update_state (HistoryButton* self,
                                  const gchar* label,
                                  gboolean sensitive);
static gchar* history_button_get_moves_count_string (guint* moves_count);
static void history_button_generate_moves_menu (HistoryButton* self);
static inline void history_button_generate_undo_actions_section (GMenu** menu);
static inline void history_button_generate_best_score_section (guint* best_score,
                                                 GMenu** menu);
VALA_EXTERN void history_button_save_best_score (HistoryButton* self,
                                     gchar** best_score_string);
static inline void history_button_get_best_score_string (guint* best_score,
                                           guint* last_moves_count,
                                           gchar** best_score_string);
VALA_EXTERN void history_button_new_game (HistoryButton* self);
VALA_EXTERN void history_button_set_moves_count (HistoryButton* self,
                                     guint moves_count);
VALA_EXTERN HistoryButton* history_button_new (void);
VALA_EXTERN HistoryButton* history_button_construct (GType object_type);
static GObject * history_button_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static void history_button_finalize (GObject * obj);
static GType history_button_get_type_once (void);

static inline gpointer
history_button_get_instance_private (HistoryButton* self)
{
	return G_STRUCT_MEMBER_P (self, HistoryButton_private_offset);
}

static void
history_button_update_state (HistoryButton* self,
                             const gchar* label,
                             gboolean sensitive)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	gtk_button_set_label ((GtkButton*) self, label);
	gtk_widget_set_sensitive ((GtkWidget*) self, sensitive);
}

static gchar*
history_button_get_moves_count_string (guint* moves_count)
{
	gchar* moves_count_string = NULL;
	gchar* result;
	if ((*moves_count) != G_MAXUINT) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup_printf ("%u", *moves_count);
		_g_free0 (moves_count_string);
		moves_count_string = _tmp0_;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("∞");
		_g_free0 (moves_count_string);
		moves_count_string = _tmp1_;
	}
	result = moves_count_string;
	return result;
}

static void
history_button_generate_moves_menu (HistoryButton* self)
{
	GMenu* menu = NULL;
	GMenu* _tmp0_;
	GMenu* _tmp1_;
	GMenu* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_menu_new ();
	menu = _tmp0_;
	history_button_generate_undo_actions_section (&menu);
	if (self->priv->best_score != ((guint) 0)) {
		history_button_generate_best_score_section (&self->priv->best_score, &menu);
	}
	_tmp1_ = menu;
	g_menu_freeze (_tmp1_);
	_tmp2_ = menu;
	gtk_menu_button_set_menu_model ((GtkMenuButton*) self, (GMenuModel*) _tmp2_);
	_g_object_unref0 (menu);
}

static inline void
history_button_generate_undo_actions_section (GMenu** menu)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	g_return_if_fail (*menu != NULL);
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	g_menu_append (section, _ ("_Undo"), "ui.undo");
	g_menu_append (section, _ ("_Restart"), "ui.restart");
	g_menu_freeze (section);
	g_menu_append_section (*menu, NULL, (GMenuModel*) section);
	_g_object_unref0 (section);
}

static inline void
history_button_generate_best_score_section (guint* best_score,
                                            GMenu** menu)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (*menu != NULL);
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	_tmp1_ = history_button_get_moves_count_string (best_score);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup_printf (_ ("Best score: %s"), _tmp2_);
	_tmp4_ = _tmp3_;
	g_menu_append (section, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	g_menu_freeze (section);
	g_menu_append_section (*menu, NULL, (GMenuModel*) section);
	_g_object_unref0 (section);
}

void
history_button_save_best_score (HistoryButton* self,
                                gchar** best_score_string)
{
	gchar* _vala_best_score_string = NULL;
	gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	history_button_get_best_score_string (&self->priv->best_score, &self->priv->last_moves_count, &_tmp0_);
	_g_free0 (_vala_best_score_string);
	_vala_best_score_string = _tmp0_;
	if (self->priv->best_score == ((guint) 0)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->last_moves_count < self->priv->best_score;
	}
	if (_tmp1_) {
		self->priv->best_score = self->priv->last_moves_count;
	}
	history_button_generate_moves_menu (self);
	if (best_score_string) {
		*best_score_string = _vala_best_score_string;
	} else {
		_g_free0 (_vala_best_score_string);
	}
}

static inline void
history_button_get_best_score_string (guint* best_score,
                                      guint* last_moves_count,
                                      gchar** best_score_string)
{
	gchar* _vala_best_score_string = NULL;
	if ((*best_score) == ((guint) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (HISTORY_BUTTON_usual_best_score_string);
		_g_free0 (_vala_best_score_string);
		_vala_best_score_string = _tmp0_;
		if (best_score_string) {
			*best_score_string = _vala_best_score_string;
		} else {
			_g_free0 (_vala_best_score_string);
		}
		return;
	}
	if ((*last_moves_count) < (*best_score)) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = g_strdup (_ ("Bravo! You improved your best score!"));
		_g_free0 (_vala_best_score_string);
		_vala_best_score_string = _tmp1_;
		_tmp2_ = _vala_best_score_string;
		if (g_strcmp0 (_tmp2_, "Bravo! You improved your best score!") != 0) {
			if (best_score_string) {
				*best_score_string = _vala_best_score_string;
			} else {
				_g_free0 (_vala_best_score_string);
			}
			return;
		}
	} else {
		if ((*last_moves_count) == (*best_score)) {
			gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = g_strdup (_ ("Bravo! You equalized your best score."));
			_g_free0 (_vala_best_score_string);
			_vala_best_score_string = _tmp3_;
			_tmp4_ = _vala_best_score_string;
			if (g_strcmp0 (_tmp4_, "Bravo! You equalized your best score.") != 0) {
				if (best_score_string) {
					*best_score_string = _vala_best_score_string;
				} else {
					_g_free0 (_vala_best_score_string);
				}
				return;
			}
		} else {
			gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = g_strdup (_ ("Bravo! You finished the game again."));
			_g_free0 (_vala_best_score_string);
			_vala_best_score_string = _tmp5_;
			_tmp6_ = _vala_best_score_string;
			if (g_strcmp0 (_tmp6_, "Bravo! You finished the game again.") != 0) {
				if (best_score_string) {
					*best_score_string = _vala_best_score_string;
				} else {
					_g_free0 (_vala_best_score_string);
				}
				return;
			}
		}
	}
	if (g_strcmp0 (HISTORY_BUTTON_usual_best_score_string_untranslated, HISTORY_BUTTON_usual_best_score_string) != 0) {
		gchar* _tmp7_;
		_tmp7_ = g_strdup (HISTORY_BUTTON_usual_best_score_string);
		_g_free0 (_vala_best_score_string);
		_vala_best_score_string = _tmp7_;
	}
	if (best_score_string) {
		*best_score_string = _vala_best_score_string;
	} else {
		_g_free0 (_vala_best_score_string);
	}
}

void
history_button_new_game (HistoryButton* self)
{
	g_return_if_fail (self != NULL);
	self->priv->best_score = (guint) 0;
	self->priv->last_moves_count = (guint) 0;
	history_button_generate_moves_menu (self);
}

void
history_button_set_moves_count (HistoryButton* self,
                                guint moves_count)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	if (moves_count != ((guint) 0)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->best_score != ((guint) 0);
	}
	_tmp1_ = history_button_get_moves_count_string (&moves_count);
	_tmp2_ = _tmp1_;
	history_button_update_state (self, _tmp2_, _tmp0_);
	_g_free0 (_tmp2_);
	self->priv->last_moves_count = moves_count;
}

HistoryButton*
history_button_construct (GType object_type)
{
	HistoryButton * self = NULL;
	self = (HistoryButton*) g_object_new (object_type, NULL);
	return self;
}

HistoryButton*
history_button_new (void)
{
	return history_button_construct (TYPE_HISTORY_BUTTON);
}

static GObject *
history_button_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	HistoryButton * self;
	parent_class = G_OBJECT_CLASS (history_button_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY_BUTTON, HistoryButton);
	history_button_update_state (self, "0", FALSE);
	history_button_generate_moves_menu (self);
	return obj;
}

static void
history_button_class_init (HistoryButtonClass * klass,
                           gpointer klass_data)
{
	history_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &HistoryButton_private_offset);
	G_OBJECT_CLASS (klass)->constructor = history_button_constructor;
	G_OBJECT_CLASS (klass)->finalize = history_button_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Taquin/ui/history-button.ui");
}

static void
history_button_instance_init (HistoryButton * self,
                              gpointer klass)
{
	self->priv = history_button_get_instance_private (self);
	self->priv->best_score = (guint) 0;
	self->priv->last_moves_count = (guint) 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
history_button_finalize (GObject * obj)
{
	HistoryButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY_BUTTON, HistoryButton);
	G_OBJECT_CLASS (history_button_parent_class)->finalize (obj);
}

static GType
history_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (HistoryButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryButton), 0, (GInstanceInitFunc) history_button_instance_init, NULL };
	GType history_button_type_id;
	history_button_type_id = g_type_register_static (gtk_menu_button_get_type (), "HistoryButton", &g_define_type_info, 0);
	HistoryButton_private_offset = g_type_add_instance_private (history_button_type_id, sizeof (HistoryButtonPrivate));
	return history_button_type_id;
}

GType
history_button_get_type (void)
{
	static volatile gsize history_button_type_id__once = 0;
	if (g_once_init_enter (&history_button_type_id__once)) {
		GType history_button_type_id;
		history_button_type_id = history_button_get_type_once ();
		g_once_init_leave (&history_button_type_id__once, history_button_type_id);
	}
	return history_button_type_id__once;
}

