/* game-view.c generated by valac 0.56.3, the Vala compiler
 * generated from game-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of a GNOME game.

   Copyright 2019 Arnaud Bonatti

   This game is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This game is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this game.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_BASE_VIEW (base_view_get_type ())
#define BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_VIEW, BaseView))
#define BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_VIEW, BaseViewClass))
#define IS_BASE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_VIEW))
#define IS_BASE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_VIEW))
#define BASE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_VIEW, BaseViewClass))

typedef struct _BaseView BaseView;
typedef struct _BaseViewClass BaseViewClass;
typedef struct _BaseViewPrivate BaseViewPrivate;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;
enum  {
	GAME_VIEW_0_PROPERTY,
	GAME_VIEW_NUM_PROPERTIES
};
static GParamSpec* game_view_properties[GAME_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	GAME_WINDOW_FLAGS_HAS_SOUND = 1 << 0,
	GAME_WINDOW_FLAGS_SHORTCUTS = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HELP = 1 << 2,
	GAME_WINDOW_FLAGS_SHOW_START_BUTTON = 1 << 3
} GameWindowFlags;

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())

#define TYPE_GAME_ACTION_BAR_PLACE_HOLDER (game_action_bar_place_holder_get_type ())
#define GAME_ACTION_BAR_PLACE_HOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_ACTION_BAR_PLACE_HOLDER, GameActionBarPlaceHolder))
#define GAME_ACTION_BAR_PLACE_HOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_ACTION_BAR_PLACE_HOLDER, GameActionBarPlaceHolderClass))
#define IS_GAME_ACTION_BAR_PLACE_HOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_ACTION_BAR_PLACE_HOLDER))
#define IS_GAME_ACTION_BAR_PLACE_HOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_ACTION_BAR_PLACE_HOLDER))
#define GAME_ACTION_BAR_PLACE_HOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_ACTION_BAR_PLACE_HOLDER, GameActionBarPlaceHolderClass))

typedef struct _GameActionBarPlaceHolder GameActionBarPlaceHolder;
typedef struct _GameActionBarPlaceHolderClass GameActionBarPlaceHolderClass;

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _BaseView {
	GtkStack parent_instance;
	BaseViewPrivate * priv;
	GtkGrid* main_grid;
};

struct _BaseViewClass {
	GtkStackClass parent_class;
	gboolean (*handle_copy_text) (BaseView* self, gchar** copy_text);
	void (*close_popovers) (BaseView* self);
	void (*set_window_size) (BaseView* self, AdaptativeWidgetWindowSize new_size);
	void (*show_default_view) (BaseView* self);
	gboolean (*is_in_in_window_mode) (BaseView* self);
};

struct _GameView {
	BaseView parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	BaseViewClass parent_class;
};

struct _GameViewPrivate {
	GtkStack* game_stack;
	GtkBox* game_box;
	GtkWidget* game_content;
	GtkScrolledWindow* scrolled;
	GtkBox* new_game_box;
	GtkButton* start_game_button;
};

static gint GameView_private_offset;
static gpointer game_view_parent_class = NULL;
static AdaptativeWidgetIface * game_view_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType base_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseView, g_object_unref)
VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
VALA_EXTERN GType game_window_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType game_action_bar_place_holder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameActionBarPlaceHolder, g_object_unref)
VALA_EXTERN GameView* game_view_new (GameWindowFlags flags,
                         GtkBox* new_game_screen,
                         GtkWidget* content,
                         GameActionBarPlaceHolder* actionbar_placeholder);
VALA_EXTERN GameView* game_view_construct (GType object_type,
                               GameWindowFlags flags,
                               GtkBox* new_game_screen,
                               GtkWidget* content,
                               GameActionBarPlaceHolder* actionbar_placeholder);
VALA_EXTERN BaseView* base_view_new (void);
VALA_EXTERN BaseView* base_view_construct (GType object_type);
VALA_EXTERN void game_view_show_new_game_box (GameView* self,
                                  gboolean grab_focus);
VALA_EXTERN void game_view_show_game_content (GameView* self,
                                  gboolean grab_focus);
VALA_EXTERN gboolean game_view_game_content_visible_if_true (GameView* self);
VALA_EXTERN void game_view_configure_transition (GameView* self,
                                     GtkStackTransitionType transition_type,
                                     guint transition_duration);
static GObject * game_view_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties);
static void game_view_finalize (GObject * obj);
static GType game_view_get_type_once (void);

static inline gpointer
game_view_get_instance_private (GameView* self)
{
	return G_STRUCT_MEMBER_P (self, GameView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GameView*
game_view_construct (GType object_type,
                     GameWindowFlags flags,
                     GtkBox* new_game_screen,
                     GtkWidget* content,
                     GameActionBarPlaceHolder* actionbar_placeholder)
{
	GameView * self = NULL;
	GtkBox* _tmp0_;
	GtkWidget* _tmp14_;
	GtkBox* _tmp15_;
	GtkWidget* _tmp16_;
	GtkWidget* _tmp17_;
	GtkWidget* _tmp18_;
	GtkBox* _tmp19_;
	GtkWidget* _tmp20_;
	GtkBox* _tmp21_;
	GtkBox* _tmp22_;
	GtkBox* _tmp23_;
	GtkStyleContext* _tmp24_;
	GtkStack* _tmp25_;
	GtkBox* _tmp26_;
	g_return_val_if_fail (new_game_screen != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (actionbar_placeholder != NULL, NULL);
	self = (GameView*) base_view_construct (object_type);
	_tmp0_ = self->priv->new_game_box;
	gtk_box_pack_start (_tmp0_, (GtkWidget*) new_game_screen, TRUE, TRUE, (guint) 0);
	if ((flags & GAME_WINDOW_FLAGS_SHOW_START_BUTTON) == GAME_WINDOW_FLAGS_SHOW_START_BUTTON) {
		GtkButton* _start_game_button = NULL;
		GtkButton* _tmp1_;
		GtkButton* _tmp2_;
		GtkButton* _tmp3_;
		GtkStyleContext* context = NULL;
		GtkButton* _tmp4_;
		GtkStyleContext* _tmp5_;
		GtkStyleContext* _tmp6_;
		GtkStyleContext* _tmp7_;
		GtkStyleContext* _tmp8_;
		GtkButton* _tmp9_;
		GtkBox* _tmp10_;
		GtkButton* _tmp11_;
		GtkButton* _tmp12_;
		GtkButton* _tmp13_;
		_tmp1_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Start Game"));
		g_object_ref_sink (_tmp1_);
		_start_game_button = _tmp1_;
		_tmp2_ = _start_game_button;
		gtk_widget_set_halign ((GtkWidget*) _tmp2_, GTK_ALIGN_CENTER);
		_tmp3_ = _start_game_button;
		gtk_actionable_set_action_name ((GtkActionable*) _tmp3_, "ui.start-or-restart");
		_tmp4_ = _start_game_button;
		_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) _tmp4_);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		context = _tmp6_;
		_tmp7_ = context;
		gtk_style_context_add_class (_tmp7_, "start-game-button");
		_tmp8_ = context;
		gtk_style_context_add_class (_tmp8_, "suggested-action");
		_tmp9_ = _start_game_button;
		gtk_widget_show ((GtkWidget*) _tmp9_);
		_tmp10_ = self->priv->new_game_box;
		_tmp11_ = _start_game_button;
		gtk_box_pack_end (_tmp10_, (GtkWidget*) _tmp11_, FALSE, FALSE, (guint) 0);
		_tmp12_ = _start_game_button;
		_tmp13_ = _g_object_ref0 (_tmp12_);
		_g_object_unref0 (self->priv->start_game_button);
		self->priv->start_game_button = _tmp13_;
		_g_object_unref0 (context);
		_g_object_unref0 (_start_game_button);
	}
	_tmp14_ = _g_object_ref0 (content);
	_g_object_unref0 (self->priv->game_content);
	self->priv->game_content = _tmp14_;
	_tmp15_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->game_box);
	self->priv->game_box = _tmp15_;
	_tmp16_ = self->priv->game_content;
	gtk_widget_set_hexpand (_tmp16_, TRUE);
	_tmp17_ = self->priv->game_content;
	gtk_widget_set_vexpand (_tmp17_, TRUE);
	_tmp18_ = self->priv->game_content;
	gtk_widget_show (_tmp18_);
	_tmp19_ = self->priv->game_box;
	_tmp20_ = self->priv->game_content;
	gtk_box_pack_start (_tmp19_, _tmp20_, TRUE, TRUE, (guint) 0);
	_tmp21_ = self->priv->game_box;
	gtk_box_pack_end (_tmp21_, (GtkWidget*) actionbar_placeholder, FALSE, FALSE, (guint) 0);
	_tmp22_ = self->priv->game_box;
	gtk_widget_show ((GtkWidget*) _tmp22_);
	_tmp23_ = self->priv->game_box;
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) _tmp23_);
	gtk_style_context_add_class (_tmp24_, "game-box");
	_tmp25_ = self->priv->game_stack;
	_tmp26_ = self->priv->game_box;
	gtk_container_add_with_properties ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_, "position", 0, NULL);
	gtk_widget_set_can_focus (content, TRUE);
	return self;
}

GameView*
game_view_new (GameWindowFlags flags,
               GtkBox* new_game_screen,
               GtkWidget* content,
               GameActionBarPlaceHolder* actionbar_placeholder)
{
	return game_view_construct (TYPE_GAME_VIEW, flags, new_game_screen, content, actionbar_placeholder);
}

void
game_view_show_new_game_box (GameView* self,
                             gboolean grab_focus)
{
	GtkStack* _tmp0_;
	GtkScrolledWindow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_stack;
	_tmp1_ = self->priv->scrolled;
	gtk_stack_set_visible_child (_tmp0_, (GtkWidget*) _tmp1_);
	if (grab_focus) {
		GtkButton* _tmp3_;
		_tmp3_ = self->priv->start_game_button;
		_tmp2_ = _tmp3_ != NULL;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkButton* _tmp4_;
		_tmp4_ = self->priv->start_game_button;
		gtk_widget_grab_focus ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_button_get_type (), GtkButton));
	}
}

void
game_view_show_game_content (GameView* self,
                             gboolean grab_focus)
{
	GtkStack* _tmp0_;
	GtkBox* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_stack;
	_tmp1_ = self->priv->game_box;
	gtk_stack_set_visible_child (_tmp0_, (GtkWidget*) _tmp1_);
	if (grab_focus) {
		GtkWidget* _tmp2_;
		_tmp2_ = self->priv->game_content;
		gtk_widget_grab_focus (_tmp2_);
	}
}

gboolean
game_view_game_content_visible_if_true (GameView* self)
{
	GtkWidget* visible_child = NULL;
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkBox* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->game_stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	visible_child = _tmp2_;
	if (visible_child == NULL) {
		g_assert_not_reached ();
	}
	_tmp3_ = self->priv->game_box;
	result = G_TYPE_CHECK_INSTANCE_CAST (visible_child, gtk_widget_get_type (), GtkWidget) == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget);
	_g_object_unref0 (visible_child);
	return result;
}

void
game_view_configure_transition (GameView* self,
                                GtkStackTransitionType transition_type,
                                guint transition_duration)
{
	GtkStack* _tmp0_;
	GtkStack* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_stack;
	gtk_stack_set_transition_type (_tmp0_, transition_type);
	_tmp1_ = self->priv->game_stack;
	gtk_stack_set_transition_duration (_tmp1_, transition_duration);
}

static GObject *
game_view_constructor (GType type,
                       guint n_construct_properties,
                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GameView * self;
	GtkStack* _tmp0_;
	GtkStack* _tmp1_;
	GtkStack* _tmp2_;
	GtkStack* _tmp3_;
	GtkGrid* _tmp4_;
	GtkStack* _tmp5_;
	GtkScrolledWindow* _tmp6_;
	GtkScrolledWindow* _tmp7_;
	GtkStack* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkBox* _tmp10_;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	GtkBox* _tmp13_;
	GtkScrolledWindow* _tmp14_;
	GtkBox* _tmp15_;
	parent_class = G_OBJECT_CLASS (game_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_tmp0_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->game_stack);
	self->priv->game_stack = _tmp0_;
	_tmp1_ = self->priv->game_stack;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->game_stack;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->game_stack;
	gtk_widget_show ((GtkWidget*) _tmp3_);
	_tmp4_ = ((BaseView*) self)->main_grid;
	_tmp5_ = self->priv->game_stack;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->scrolled);
	self->priv->scrolled = _tmp6_;
	_tmp7_ = self->priv->scrolled;
	gtk_widget_set_visible ((GtkWidget*) _tmp7_, TRUE);
	_tmp8_ = self->priv->game_stack;
	_tmp9_ = self->priv->scrolled;
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->new_game_box);
	self->priv->new_game_box = _tmp10_;
	_tmp11_ = self->priv->new_game_box;
	gtk_widget_set_halign ((GtkWidget*) _tmp11_, GTK_ALIGN_CENTER);
	_tmp12_ = self->priv->new_game_box;
	gtk_widget_set_valign ((GtkWidget*) _tmp12_, GTK_ALIGN_CENTER);
	_tmp13_ = self->priv->new_game_box;
	gtk_widget_show ((GtkWidget*) _tmp13_);
	_tmp14_ = self->priv->scrolled;
	_tmp15_ = self->priv->new_game_box;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	return obj;
}

static void
game_view_class_init (GameViewClass * klass,
                      gpointer klass_data)
{
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameView_private_offset);
	G_OBJECT_CLASS (klass)->constructor = game_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
}

static void
game_view_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                            gpointer iface_data)
{
	game_view_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
}

static void
game_view_instance_init (GameView * self,
                         gpointer klass)
{
	self->priv = game_view_get_instance_private (self);
	self->priv->start_game_button = NULL;
}

static void
game_view_finalize (GObject * obj)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_g_object_unref0 (self->priv->game_stack);
	_g_object_unref0 (self->priv->game_box);
	_g_object_unref0 (self->priv->game_content);
	_g_object_unref0 (self->priv->scrolled);
	_g_object_unref0 (self->priv->new_game_box);
	_g_object_unref0 (self->priv->start_game_button);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}

static GType
game_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) game_view_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType game_view_type_id;
	game_view_type_id = g_type_register_static (TYPE_BASE_VIEW, "GameView", &g_define_type_info, 0);
	g_type_add_interface_static (game_view_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	GameView_private_offset = g_type_add_instance_private (game_view_type_id, sizeof (GameViewPrivate));
	return game_view_type_id;
}

GType
game_view_get_type (void)
{
	static volatile gsize game_view_type_id__once = 0;
	if (g_once_init_enter (&game_view_type_id__once)) {
		GType game_view_type_id;
		game_view_type_id = game_view_get_type_once ();
		g_once_init_leave (&game_view_type_id__once, game_view_type_id);
	}
	return game_view_type_id__once;
}

