/* game-headerbar.c generated by valac 0.56.3, the Vala compiler
 * generated from game-headerbar.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-

   This file is part of a GNOME game

   Copyright (C) 2019 – Arnaud Bonatti <arnaud.bonatti@gmail.com>

   This application is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this application.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#define BASE_HEADER_BAR_default_mode_id ((guint8) 0)
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NIGHT_TIME_AWARE_HEADER_BAR (night_time_aware_header_bar_get_type ())
#define NIGHT_TIME_AWARE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBar))
#define NIGHT_TIME_AWARE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBarClass))
#define IS_NIGHT_TIME_AWARE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR))
#define IS_NIGHT_TIME_AWARE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIGHT_TIME_AWARE_HEADER_BAR))
#define NIGHT_TIME_AWARE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIGHT_TIME_AWARE_HEADER_BAR, NightTimeAwareHeaderBarClass))

typedef struct _NightTimeAwareHeaderBar NightTimeAwareHeaderBar;
typedef struct _NightTimeAwareHeaderBarClass NightTimeAwareHeaderBarClass;
typedef struct _NightTimeAwareHeaderBarPrivate NightTimeAwareHeaderBarPrivate;

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_BASE_HEADER_BAR (base_header_bar_get_type ())
#define BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBar))
#define BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))
#define IS_BASE_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BASE_HEADER_BAR))
#define IS_BASE_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BASE_HEADER_BAR))
#define BASE_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BASE_HEADER_BAR, BaseHeaderBarClass))

typedef struct _BaseHeaderBar BaseHeaderBar;
typedef struct _BaseHeaderBarClass BaseHeaderBarClass;
typedef struct _BaseHeaderBarPrivate BaseHeaderBarPrivate;

#define TYPE_GAME_HEADER_BAR (game_header_bar_get_type ())
#define GAME_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_HEADER_BAR, GameHeaderBar))
#define GAME_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_HEADER_BAR, GameHeaderBarClass))
#define IS_GAME_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_HEADER_BAR))
#define IS_GAME_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_HEADER_BAR))
#define GAME_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_HEADER_BAR, GameHeaderBarClass))

typedef struct _GameHeaderBar GameHeaderBar;
typedef struct _GameHeaderBarClass GameHeaderBarClass;
typedef struct _GameHeaderBarPrivate GameHeaderBarPrivate;
enum  {
	GAME_HEADER_BAR_0_PROPERTY,
	GAME_HEADER_BAR_WINDOW_HAS_NAME_PROPERTY,
	GAME_HEADER_BAR_WINDOW_NAME_PROPERTY,
	GAME_HEADER_BAR_HAS_SOUND_PROPERTY,
	GAME_HEADER_BAR_GAME_WIDGET_PROPERTY,
	GAME_HEADER_BAR_APPEARANCE_MENU_PROPERTY,
	GAME_HEADER_BAR_NUM_PROPERTIES
};
static GParamSpec* game_header_bar_properties[GAME_HEADER_BAR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	GAME_WINDOW_FLAGS_HAS_SOUND = 1 << 0,
	GAME_WINDOW_FLAGS_SHORTCUTS = 1 << 1,
	GAME_WINDOW_FLAGS_SHOW_HELP = 1 << 2,
	GAME_WINDOW_FLAGS_SHOW_START_BUTTON = 1 << 3
} GameWindowFlags;

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())

#define TYPE_NIGHT_LIGHT_MONITOR (night_light_monitor_get_type ())
#define NIGHT_LIGHT_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitor))
#define NIGHT_LIGHT_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitorClass))
#define IS_NIGHT_LIGHT_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIGHT_LIGHT_MONITOR))
#define IS_NIGHT_LIGHT_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIGHT_LIGHT_MONITOR))
#define NIGHT_LIGHT_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIGHT_LIGHT_MONITOR, NightLightMonitorClass))

typedef struct _NightLightMonitor NightLightMonitor;
typedef struct _NightLightMonitorClass NightLightMonitorClass;

struct _NightTimeAwareHeaderBar {
	GtkHeaderBar parent_instance;
	NightTimeAwareHeaderBarPrivate * priv;
};

struct _NightTimeAwareHeaderBarClass {
	GtkHeaderBarClass parent_class;
	void (*update_hamburger_menu) (NightTimeAwareHeaderBar* self);
};

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _BaseHeaderBar {
	NightTimeAwareHeaderBar parent_instance;
	BaseHeaderBarPrivate * priv;
	GtkBox* center_box;
	gboolean disable_popovers;
	gboolean disable_action_bar;
	GtkStack* quit_button_stack;
};

struct _BaseHeaderBarClass {
	NightTimeAwareHeaderBarClass parent_class;
	void (*set_window_size) (BaseHeaderBar* self, AdaptativeWidgetWindowSize new_size);
	void (*populate_menu) (BaseHeaderBar* self, GMenu** menu);
	void (*toggle_view_menu) (BaseHeaderBar* self);
	void (*set_default_widgets_default_states) (BaseHeaderBar* self, BaseHeaderBar* _this);
	void (*close_popovers) (BaseHeaderBar* self);
	gboolean (*has_popover) (BaseHeaderBar* self);
};

struct _GameHeaderBar {
	BaseHeaderBar parent_instance;
	GameHeaderBarPrivate * priv;
};

struct _GameHeaderBarClass {
	BaseHeaderBarClass parent_class;
};

struct _GameHeaderBarPrivate {
	GtkButton* new_game_button;
	GtkButton* back_button;
	gboolean _window_has_name;
	gchar* _window_name;
	gboolean _has_sound;
	GtkWidget* _game_widget;
	gboolean is_extra_thin;
	gboolean current_view_is_new_game_screen;
	GMenu* _appearance_menu;
};

static gint GameHeaderBar_private_offset;
static gpointer game_header_bar_parent_class = NULL;
static AdaptativeWidgetIface * game_header_bar_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType night_time_aware_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NightTimeAwareHeaderBar, g_object_unref)
VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType base_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BaseHeaderBar, g_object_unref)
VALA_EXTERN GType game_header_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameHeaderBar, g_object_unref)
VALA_EXTERN void base_header_bar_set_window_size (BaseHeaderBar* self,
                                      AdaptativeWidgetWindowSize new_size);
VALA_EXTERN void base_header_bar_set_default_widgets_default_states (BaseHeaderBar* self,
                                                         BaseHeaderBar* _this);
VALA_EXTERN void base_header_bar_populate_menu (BaseHeaderBar* self,
                                    GMenu** menu);
VALA_EXTERN GType game_window_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType night_light_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NightLightMonitor, g_object_unref)
VALA_EXTERN GameHeaderBar* game_header_bar_new (const gchar* _window_name,
                                    const gchar* _about_action_label,
                                    GameWindowFlags flags,
                                    GMenu* _appearance_menu,
                                    GtkWidget* _game_widget,
                                    NightLightMonitor* _night_light_monitor);
VALA_EXTERN GameHeaderBar* game_header_bar_construct (GType object_type,
                                          const gchar* _window_name,
                                          const gchar* _about_action_label,
                                          GameWindowFlags flags,
                                          GMenu* _appearance_menu,
                                          GtkWidget* _game_widget,
                                          NightLightMonitor* _night_light_monitor);
static void game_header_bar_real_set_window_size (AdaptativeWidget* base,
                                           AdaptativeWidgetWindowSize new_size);
static gboolean game_header_bar_get_window_has_name (GameHeaderBar* self);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_thin (AdaptativeWidgetWindowSize window_size);
static void game_header_bar_real_set_default_widgets_default_states (BaseHeaderBar* base,
                                                              BaseHeaderBar* _this);
static const gchar* game_header_bar_get_window_name (GameHeaderBar* self);
VALA_EXTERN void base_header_bar_set_default_widgets_states (BaseHeaderBar* self,
                                                 const gchar* title_label_text_or_null,
                                                 gboolean show_go_back_button,
                                                 gboolean show_ltr_left_separator,
                                                 gboolean show_info_button,
                                                 gboolean show_ltr_right_separator,
                                                 gboolean show_quit_button_stack);
static void game_header_bar_update_game_widget_visibility (GameHeaderBar* self);
static GtkWidget* game_header_bar_get_game_widget (GameHeaderBar* self);
VALA_EXTERN gboolean game_header_bar_show_new_game_screen (GameHeaderBar* self,
                                               gboolean game_finished);
VALA_EXTERN gboolean game_header_bar_show_view (GameHeaderBar* self,
                                    gboolean game_finished);
VALA_EXTERN void game_header_bar_new_game (GameHeaderBar* self);
VALA_EXTERN void game_header_bar_new_game_button_grab_focus (GameHeaderBar* self);
VALA_EXTERN void game_header_bar_update_title (GameHeaderBar* self,
                                   const gchar* new_title);
VALA_EXTERN void game_header_bar_set_window_name (GameHeaderBar* self,
                                      const gchar* value);
VALA_EXTERN void game_header_bar_set_window_has_name (GameHeaderBar* self,
                                          gboolean value);
static void game_header_bar_real_populate_menu (BaseHeaderBar* base,
                                         GMenu** menu);
static inline void game_header_bar_append_options_section (GMenu** menu,
                                             GMenu* appearance_menu,
                                             gboolean has_sound);
static GMenu* game_header_bar_get_appearance_menu (GameHeaderBar* self);
static gboolean game_header_bar_get_has_sound (GameHeaderBar* self);
static void game_header_bar_init_modes (GameHeaderBar* self);
static void game_header_bar_mode_changed_game (BaseHeaderBar* _this,
                                        guint8 mode_id);
static void _game_header_bar_mode_changed_game_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                     guint8 mode_id,
                                                                     gpointer self);
static void game_header_bar_set_has_sound (GameHeaderBar* self,
                                    gboolean value);
static void game_header_bar_set_game_widget (GameHeaderBar* self,
                                      GtkWidget* value);
static void game_header_bar_set_appearance_menu (GameHeaderBar* self,
                                          GMenu* value);
static GObject * game_header_bar_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void game_header_bar_finalize (GObject * obj);
static GType game_header_bar_get_type_once (void);
static void _vala_game_header_bar_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_game_header_bar_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);

static inline gpointer
game_header_bar_get_instance_private (GameHeaderBar* self)
{
	return G_STRUCT_MEMBER_P (self, GameHeaderBar_private_offset);
}

GameHeaderBar*
game_header_bar_construct (GType object_type,
                           const gchar* _window_name,
                           const gchar* _about_action_label,
                           GameWindowFlags flags,
                           GMenu* _appearance_menu,
                           GtkWidget* _game_widget,
                           NightLightMonitor* _night_light_monitor)
{
	GameHeaderBar * self = NULL;
	g_return_val_if_fail (_window_name != NULL, NULL);
	g_return_val_if_fail (_about_action_label != NULL, NULL);
	g_return_val_if_fail (_night_light_monitor != NULL, NULL);
	self = (GameHeaderBar*) g_object_new (object_type, "about-action-label", _about_action_label, "night-light-monitor", _night_light_monitor, "has-keyboard-shortcuts", (flags & GAME_WINDOW_FLAGS_SHORTCUTS) == GAME_WINDOW_FLAGS_SHORTCUTS, "has-sound", (flags & GAME_WINDOW_FLAGS_HAS_SOUND) == GAME_WINDOW_FLAGS_HAS_SOUND, "has-help", (flags & GAME_WINDOW_FLAGS_SHOW_HELP) == GAME_WINDOW_FLAGS_SHOW_HELP, "appearance-menu", _appearance_menu, "game-widget", _game_widget, "window-name", _window_name, NULL);
	return self;
}

GameHeaderBar*
game_header_bar_new (const gchar* _window_name,
                     const gchar* _about_action_label,
                     GameWindowFlags flags,
                     GMenu* _appearance_menu,
                     GtkWidget* _game_widget,
                     NightLightMonitor* _night_light_monitor)
{
	return game_header_bar_construct (TYPE_GAME_HEADER_BAR, _window_name, _about_action_label, flags, _appearance_menu, _game_widget, _night_light_monitor);
}

static void
game_header_bar_real_set_window_size (AdaptativeWidget* base,
                                      AdaptativeWidgetWindowSize new_size)
{
	GameHeaderBar * self;
	gboolean _tmp0_;
	gboolean _is_extra_thin = FALSE;
	self = (GameHeaderBar*) base;
	BASE_HEADER_BAR_CLASS (game_header_bar_parent_class)->set_window_size (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_BASE_HEADER_BAR, BaseHeaderBar), new_size);
	_tmp0_ = self->priv->_window_has_name;
	if (!_tmp0_) {
		return;
	}
	_is_extra_thin = adaptative_widget_window_size_is_extra_thin (new_size);
	if (_is_extra_thin == self->priv->is_extra_thin) {
		return;
	}
	self->priv->is_extra_thin = _is_extra_thin;
	base_header_bar_set_default_widgets_default_states ((BaseHeaderBar*) self, (BaseHeaderBar*) self);
}

static void
game_header_bar_real_set_default_widgets_default_states (BaseHeaderBar* base,
                                                         BaseHeaderBar* _this)
{
	GameHeaderBar * self;
	gchar* headerbar_label_text = NULL;
	const gchar* _tmp2_;
	self = (GameHeaderBar*) base;
	g_return_if_fail (_this != NULL);
	if (G_TYPE_CHECK_INSTANCE_CAST (_this, TYPE_GAME_HEADER_BAR, GameHeaderBar)->priv->is_extra_thin) {
		_g_free0 (headerbar_label_text);
		headerbar_label_text = NULL;
	} else {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (_this, TYPE_GAME_HEADER_BAR, GameHeaderBar)->priv->_window_name;
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (headerbar_label_text);
		headerbar_label_text = _tmp1_;
	}
	_tmp2_ = headerbar_label_text;
	base_header_bar_set_default_widgets_states (_this, _tmp2_, FALSE, FALSE, TRUE, _this->disable_action_bar, _this->disable_action_bar);
	game_header_bar_update_game_widget_visibility (self);
	_g_free0 (headerbar_label_text);
}

static void
game_header_bar_update_game_widget_visibility (GameHeaderBar* self)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_game_widget;
	if (_tmp0_ != NULL) {
		gboolean _tmp1_ = FALSE;
		GtkWidget* _tmp2_;
		if (!self->priv->is_extra_thin) {
			_tmp1_ = !self->priv->current_view_is_new_game_screen;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp2_ = self->priv->_game_widget;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), _tmp1_);
	}
}

gboolean
game_header_bar_show_new_game_screen (GameHeaderBar* self,
                                      gboolean game_finished)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->current_view_is_new_game_screen = TRUE;
	game_header_bar_update_game_widget_visibility (self);
	if (!game_finished) {
		GtkButton* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->back_button;
		_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkButton* _tmp4_;
		_tmp4_ = self->priv->back_button;
		gtk_widget_grab_focus ((GtkWidget*) _tmp4_);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

gboolean
game_header_bar_show_view (GameHeaderBar* self,
                           gboolean game_finished)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->current_view_is_new_game_screen = FALSE;
	_tmp0_ = self->priv->back_button;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->new_game_button;
	gtk_widget_show ((GtkWidget*) _tmp1_);
	game_header_bar_update_game_widget_visibility (self);
	if (game_finished) {
		GtkButton* _tmp2_;
		_tmp2_ = self->priv->new_game_button;
		gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

void
game_header_bar_new_game (GameHeaderBar* self)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->back_button;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->new_game_button;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
}

void
game_header_bar_new_game_button_grab_focus (GameHeaderBar* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->new_game_button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

void
game_header_bar_update_title (GameHeaderBar* self,
                              const gchar* new_title)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (new_title != NULL);
	game_header_bar_set_window_name (self, new_title);
	game_header_bar_set_window_has_name (self, g_strcmp0 (new_title, "") != 0);
	base_header_bar_set_default_widgets_default_states ((BaseHeaderBar*) self, (BaseHeaderBar*) self);
}

static void
game_header_bar_real_populate_menu (BaseHeaderBar* base,
                                    GMenu** menu)
{
	GameHeaderBar * self;
	GMenu* _tmp0_;
	gboolean _tmp1_;
	self = (GameHeaderBar*) base;
	g_return_if_fail (*menu != NULL);
	_tmp0_ = self->priv->_appearance_menu;
	_tmp1_ = self->priv->_has_sound;
	game_header_bar_append_options_section (menu, _tmp0_, _tmp1_);
}

static inline void
game_header_bar_append_options_section (GMenu** menu,
                                        GMenu* appearance_menu,
                                        gboolean has_sound)
{
	GMenu* section = NULL;
	GMenu* _tmp0_;
	GMenu* _tmp2_;
	GMenu* _tmp3_;
	g_return_if_fail (*menu != NULL);
	_tmp0_ = g_menu_new ();
	section = _tmp0_;
	if (has_sound) {
		GMenu* _tmp1_;
		_tmp1_ = section;
		g_menu_append (_tmp1_, _ ("_Sound"), "app.sound");
	}
	_tmp2_ = section;
	g_menu_freeze (_tmp2_);
	_tmp3_ = section;
	g_menu_append_section (*menu, NULL, (GMenuModel*) _tmp3_);
	_g_object_unref0 (section);
}

static void
_game_header_bar_mode_changed_game_base_header_bar_change_mode (BaseHeaderBar* _sender,
                                                                guint8 mode_id,
                                                                gpointer self)
{
	game_header_bar_mode_changed_game (_sender, mode_id);
}

static void
game_header_bar_init_modes (GameHeaderBar* self)
{
	g_return_if_fail (self != NULL);
	g_signal_connect ((BaseHeaderBar*) self, "change-mode", (GCallback) _game_header_bar_mode_changed_game_base_header_bar_change_mode, NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
game_header_bar_mode_changed_game (BaseHeaderBar* _this,
                                   guint8 mode_id)
{
	GameHeaderBar* real_this = NULL;
	GameHeaderBar* _tmp0_;
	g_return_if_fail (_this != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_this, TYPE_GAME_HEADER_BAR, GameHeaderBar));
	real_this = _tmp0_;
	if (mode_id == BASE_HEADER_BAR_default_mode_id) {
		GameHeaderBar* _tmp1_;
		_tmp1_ = real_this;
		if (_tmp1_->priv->current_view_is_new_game_screen) {
			GameHeaderBar* _tmp2_;
			GtkButton* _tmp3_;
			_tmp2_ = real_this;
			_tmp3_ = _tmp2_->priv->back_button;
			gtk_widget_show ((GtkWidget*) _tmp3_);
		} else {
			GameHeaderBar* _tmp4_;
			GameHeaderBar* _tmp5_;
			GtkButton* _tmp6_;
			_tmp4_ = real_this;
			game_header_bar_update_game_widget_visibility (_tmp4_);
			_tmp5_ = real_this;
			_tmp6_ = _tmp5_->priv->new_game_button;
			gtk_widget_show ((GtkWidget*) _tmp6_);
		}
	} else {
		GameHeaderBar* _tmp7_;
		GtkButton* _tmp8_;
		GameHeaderBar* _tmp9_;
		GameHeaderBar* _tmp10_;
		GtkButton* _tmp11_;
		_tmp7_ = real_this;
		_tmp8_ = _tmp7_->priv->back_button;
		gtk_widget_hide ((GtkWidget*) _tmp8_);
		_tmp9_ = real_this;
		game_header_bar_update_game_widget_visibility (_tmp9_);
		_tmp10_ = real_this;
		_tmp11_ = _tmp10_->priv->new_game_button;
		gtk_widget_hide ((GtkWidget*) _tmp11_);
	}
	_g_object_unref0 (real_this);
}

static gboolean
game_header_bar_get_window_has_name (GameHeaderBar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_window_has_name;
	return result;
}

void
game_header_bar_set_window_has_name (GameHeaderBar* self,
                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_window_has_name = value;
}

static const gchar*
game_header_bar_get_window_name (GameHeaderBar* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window_name;
	result = _tmp0_;
	return result;
}

void
game_header_bar_set_window_name (GameHeaderBar* self,
                                 const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_window_name);
	self->priv->_window_name = _tmp0_;
}

static gboolean
game_header_bar_get_has_sound (GameHeaderBar* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_sound;
	return result;
}

static void
game_header_bar_set_has_sound (GameHeaderBar* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_sound = value;
}

static GtkWidget*
game_header_bar_get_game_widget (GameHeaderBar* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game_widget;
	result = _tmp0_;
	return result;
}

static void
game_header_bar_set_game_widget (GameHeaderBar* self,
                                 GtkWidget* value)
{
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game_widget);
	self->priv->_game_widget = _tmp0_;
}

static GMenu*
game_header_bar_get_appearance_menu (GameHeaderBar* self)
{
	GMenu* result;
	GMenu* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_appearance_menu;
	result = _tmp0_;
	return result;
}

static void
game_header_bar_set_appearance_menu (GameHeaderBar* self,
                                     GMenu* value)
{
	GMenu* old_value;
	g_return_if_fail (self != NULL);
	old_value = game_header_bar_get_appearance_menu (self);
	if (old_value != value) {
		GMenu* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_appearance_menu);
		self->priv->_appearance_menu = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, game_header_bar_properties[GAME_HEADER_BAR_APPEARANCE_MENU_PROPERTY]);
	}
}

static GObject *
game_header_bar_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GameHeaderBar * self;
	const gchar* _tmp0_;
	GtkWidget* _tmp1_;
	parent_class = G_OBJECT_CLASS (game_header_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_HEADER_BAR, GameHeaderBar);
	game_header_bar_init_modes (self);
	_tmp0_ = self->priv->_window_name;
	if (g_strcmp0 (_tmp0_, "") != 0) {
		game_header_bar_set_window_has_name (self, TRUE);
	}
	_tmp1_ = self->priv->_game_widget;
	if (_tmp1_ != NULL) {
		GtkWidget* _tmp2_;
		_tmp2_ = self->priv->_game_widget;
		gtk_header_bar_pack_end ((GtkHeaderBar*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget));
	}
	return obj;
}

static void
game_header_bar_class_init (GameHeaderBarClass * klass,
                            gpointer klass_data)
{
	game_header_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameHeaderBar_private_offset);
	((BaseHeaderBarClass *) klass)->set_window_size = (void (*) (BaseHeaderBar*, AdaptativeWidgetWindowSize)) game_header_bar_real_set_window_size;
	((BaseHeaderBarClass *) klass)->set_default_widgets_default_states = (void (*) (BaseHeaderBar*, BaseHeaderBar*)) game_header_bar_real_set_default_widgets_default_states;
	((BaseHeaderBarClass *) klass)->populate_menu = (void (*) (BaseHeaderBar*, GMenu**)) game_header_bar_real_populate_menu;
	G_OBJECT_CLASS (klass)->get_property = _vala_game_header_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_header_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = game_header_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_header_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HEADER_BAR_WINDOW_HAS_NAME_PROPERTY, game_header_bar_properties[GAME_HEADER_BAR_WINDOW_HAS_NAME_PROPERTY] = g_param_spec_boolean ("window-has-name", "window-has-name", "window-has-name", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HEADER_BAR_WINDOW_NAME_PROPERTY, game_header_bar_properties[GAME_HEADER_BAR_WINDOW_NAME_PROPERTY] = g_param_spec_string ("window-name", "window-name", "window-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HEADER_BAR_HAS_SOUND_PROPERTY, game_header_bar_properties[GAME_HEADER_BAR_HAS_SOUND_PROPERTY] = g_param_spec_boolean ("has-sound", "has-sound", "has-sound", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HEADER_BAR_GAME_WIDGET_PROPERTY, game_header_bar_properties[GAME_HEADER_BAR_GAME_WIDGET_PROPERTY] = g_param_spec_object ("game-widget", "game-widget", "game-widget", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HEADER_BAR_APPEARANCE_MENU_PROPERTY, game_header_bar_properties[GAME_HEADER_BAR_APPEARANCE_MENU_PROPERTY] = g_param_spec_object ("appearance-menu", "appearance-menu", "appearance-menu", g_menu_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Taquin/ui/game-headerbar.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_game_button", FALSE, GameHeaderBar_private_offset + G_STRUCT_OFFSET (GameHeaderBarPrivate, new_game_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_button", FALSE, GameHeaderBar_private_offset + G_STRUCT_OFFSET (GameHeaderBarPrivate, back_button));
}

static void
game_header_bar_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                                  gpointer iface_data)
{
	game_header_bar_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) game_header_bar_real_set_window_size;
}

static void
game_header_bar_instance_init (GameHeaderBar * self,
                               gpointer klass)
{
	gchar* _tmp0_;
	self->priv = game_header_bar_get_instance_private (self);
	self->priv->_window_has_name = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->_window_name = _tmp0_;
	self->priv->_has_sound = FALSE;
	self->priv->_game_widget = NULL;
	self->priv->is_extra_thin = TRUE;
	self->priv->current_view_is_new_game_screen = FALSE;
	self->priv->_appearance_menu = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
game_header_bar_finalize (GObject * obj)
{
	GameHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_HEADER_BAR, GameHeaderBar);
	_g_free0 (self->priv->_window_name);
	_g_object_unref0 (self->priv->_game_widget);
	_g_object_unref0 (self->priv->_appearance_menu);
	G_OBJECT_CLASS (game_header_bar_parent_class)->finalize (obj);
}

static GType
game_header_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameHeaderBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_header_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameHeaderBar), 0, (GInstanceInitFunc) game_header_bar_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) game_header_bar_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType game_header_bar_type_id;
	game_header_bar_type_id = g_type_register_static (TYPE_BASE_HEADER_BAR, "GameHeaderBar", &g_define_type_info, 0);
	g_type_add_interface_static (game_header_bar_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	GameHeaderBar_private_offset = g_type_add_instance_private (game_header_bar_type_id, sizeof (GameHeaderBarPrivate));
	return game_header_bar_type_id;
}

GType
game_header_bar_get_type (void)
{
	static volatile gsize game_header_bar_type_id__once = 0;
	if (g_once_init_enter (&game_header_bar_type_id__once)) {
		GType game_header_bar_type_id;
		game_header_bar_type_id = game_header_bar_get_type_once ();
		g_once_init_leave (&game_header_bar_type_id__once, game_header_bar_type_id);
	}
	return game_header_bar_type_id__once;
}

static void
_vala_game_header_bar_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	GameHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_HEADER_BAR, GameHeaderBar);
	switch (property_id) {
		case GAME_HEADER_BAR_WINDOW_HAS_NAME_PROPERTY:
		g_value_set_boolean (value, game_header_bar_get_window_has_name (self));
		break;
		case GAME_HEADER_BAR_WINDOW_NAME_PROPERTY:
		g_value_set_string (value, game_header_bar_get_window_name (self));
		break;
		case GAME_HEADER_BAR_HAS_SOUND_PROPERTY:
		g_value_set_boolean (value, game_header_bar_get_has_sound (self));
		break;
		case GAME_HEADER_BAR_GAME_WIDGET_PROPERTY:
		g_value_set_object (value, game_header_bar_get_game_widget (self));
		break;
		case GAME_HEADER_BAR_APPEARANCE_MENU_PROPERTY:
		g_value_set_object (value, game_header_bar_get_appearance_menu (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_header_bar_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	GameHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_HEADER_BAR, GameHeaderBar);
	switch (property_id) {
		case GAME_HEADER_BAR_WINDOW_HAS_NAME_PROPERTY:
		game_header_bar_set_window_has_name (self, g_value_get_boolean (value));
		break;
		case GAME_HEADER_BAR_WINDOW_NAME_PROPERTY:
		game_header_bar_set_window_name (self, g_value_get_string (value));
		break;
		case GAME_HEADER_BAR_HAS_SOUND_PROPERTY:
		game_header_bar_set_has_sound (self, g_value_get_boolean (value));
		break;
		case GAME_HEADER_BAR_GAME_WIDGET_PROPERTY:
		game_header_bar_set_game_widget (self, g_value_get_object (value));
		break;
		case GAME_HEADER_BAR_APPEARANCE_MENU_PROPERTY:
		game_header_bar_set_appearance_menu (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

