/* about-list.c generated by valac 0.56.3, the Vala compiler
 * generated from about-list.vala, do not modify */

/*
  This file is part of GNOME Taquin

  GNOME Taquin is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  GNOME Taquin is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with GNOME Taquin.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_OVERLAYED_LIST (overlayed_list_get_type ())
#define OVERLAYED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OVERLAYED_LIST, OverlayedList))
#define OVERLAYED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OVERLAYED_LIST, OverlayedListClass))
#define IS_OVERLAYED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OVERLAYED_LIST))
#define IS_OVERLAYED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OVERLAYED_LIST))
#define OVERLAYED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OVERLAYED_LIST, OverlayedListClass))

typedef struct _OverlayedList OverlayedList;
typedef struct _OverlayedListClass OverlayedListClass;
typedef struct _OverlayedListPrivate OverlayedListPrivate;

#define TYPE_ABOUT_LIST (about_list_get_type ())
#define ABOUT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABOUT_LIST, AboutList))
#define ABOUT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABOUT_LIST, AboutListClass))
#define IS_ABOUT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABOUT_LIST))
#define IS_ABOUT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABOUT_LIST))
#define ABOUT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABOUT_LIST, AboutListClass))

typedef struct _AboutList AboutList;
typedef struct _AboutListClass AboutListClass;
typedef struct _AboutListPrivate AboutListPrivate;
enum  {
	ABOUT_LIST_0_PROPERTY,
	ABOUT_LIST_ARTISTS_PROPERTY,
	ABOUT_LIST_AUTHORS_PROPERTY,
	ABOUT_LIST_COMMENTS_PROPERTY,
	ABOUT_LIST_COPYRIGHT_PROPERTY,
	ABOUT_LIST_DOCUMENTERS_PROPERTY,
	ABOUT_LIST_LOGO_ICON_NAME_PROPERTY,
	ABOUT_LIST_PROGRAM_NAME_PROPERTY,
	ABOUT_LIST_TRANSLATOR_CREDITS_PROPERTY,
	ABOUT_LIST_VERSION_PROPERTY,
	ABOUT_LIST_WEBSITE_PROPERTY,
	ABOUT_LIST_WEBSITE_LABEL_PROPERTY,
	ABOUT_LIST_NUM_PROPERTIES
};
static GParamSpec* about_list_properties[ABOUT_LIST_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

#define TYPE_OVERLAYED_LIST_ROW (overlayed_list_row_get_type ())
#define OVERLAYED_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OVERLAYED_LIST_ROW, OverlayedListRow))
#define OVERLAYED_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OVERLAYED_LIST_ROW, OverlayedListRowClass))
#define IS_OVERLAYED_LIST_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OVERLAYED_LIST_ROW))
#define IS_OVERLAYED_LIST_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OVERLAYED_LIST_ROW))
#define OVERLAYED_LIST_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OVERLAYED_LIST_ROW, OverlayedListRowClass))

typedef struct _OverlayedListRow OverlayedListRow;
typedef struct _OverlayedListRowClass OverlayedListRowClass;

#define TYPE_ABOUT_LIST_ITEM (about_list_item_get_type ())
#define ABOUT_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABOUT_LIST_ITEM, AboutListItem))
#define ABOUT_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABOUT_LIST_ITEM, AboutListItemClass))
#define IS_ABOUT_LIST_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABOUT_LIST_ITEM))
#define IS_ABOUT_LIST_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABOUT_LIST_ITEM))
#define ABOUT_LIST_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABOUT_LIST_ITEM, AboutListItemClass))

typedef struct _AboutListItem AboutListItem;
typedef struct _AboutListItemClass AboutListItemClass;
typedef struct _OverlayedListRowPrivate OverlayedListRowPrivate;
typedef struct _AboutListItemPrivate AboutListItemPrivate;
enum  {
	ABOUT_LIST_ITEM_0_PROPERTY,
	ABOUT_LIST_ITEM_COPY_TEXT_PROPERTY,
	ABOUT_LIST_ITEM_NUM_PROPERTIES
};
static GParamSpec* about_list_item_properties[ABOUT_LIST_ITEM_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _OverlayedList {
	GtkOverlay parent_instance;
	OverlayedListPrivate * priv;
	GtkListBox* main_list_box;
	GListStore* main_list_store;
	gchar* placeholder_icon;
	gchar* placeholder_text;
	gulong content_changed_handler;
};

struct _OverlayedListClass {
	GtkOverlayClass parent_class;
	void (*reset) (OverlayedList* self);
};

struct _AboutList {
	OverlayedList parent_instance;
	AboutListPrivate * priv;
};

struct _AboutListClass {
	OverlayedListClass parent_class;
};

struct _AboutListPrivate {
	gchar** _artists;
	gint _artists_length1;
	gint __artists_size_;
	gchar** _authors;
	gint _authors_length1;
	gint __authors_size_;
	gchar* _comments;
	gchar* _copyright;
	gchar** _documenters;
	gint _documenters_length1;
	gint __documenters_size_;
	gchar* _logo_icon_name;
	gchar* _program_name;
	gchar* _translator_credits;
	gchar* _version;
	gchar* _website;
	gchar* _website_label;
	GSimpleAction* edit_mode_action;
};

struct _OverlayedListRow {
	GtkListBoxRow parent_instance;
	OverlayedListRowPrivate * priv;
};

struct _OverlayedListRowClass {
	GtkListBoxRowClass parent_class;
	gboolean (*handle_copy_text) (OverlayedListRow* self, gchar** copy_text);
};

struct _AboutListItem {
	OverlayedListRow parent_instance;
	AboutListItemPrivate * priv;
};

struct _AboutListItemClass {
	OverlayedListRowClass parent_class;
};

struct _AboutListItemPrivate {
	gchar* _copy_text;
};

static gint AboutList_private_offset;
static gpointer about_list_parent_class = NULL;
static gint AboutListItem_private_offset;
static gpointer about_list_item_parent_class = NULL;

VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType overlayed_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OverlayedList, g_object_unref)
VALA_EXTERN GType about_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AboutList, g_object_unref)
VALA_EXTERN void overlayed_list_reset (OverlayedList* self);
static void about_list_set_edit_mode (AboutList* self,
                               GSimpleAction* action,
                               GVariant* variant);
static void _about_list_set_edit_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
VALA_EXTERN AboutList* about_list_new (gboolean needs_shadows,
                           gboolean big_placeholder,
                           gchar*** artists,
                           gint* artists_length1,
                           gchar*** authors,
                           gint* authors_length1,
                           gchar** comments,
                           gchar** copyright,
                           gchar*** documenters,
                           gint* documenters_length1,
                           gchar** logo_icon_name,
                           gchar** program_name,
                           gchar** translator_credits,
                           gchar** version,
                           gchar** website,
                           gchar** website_label);
VALA_EXTERN AboutList* about_list_construct (GType object_type,
                                 gboolean needs_shadows,
                                 gboolean big_placeholder,
                                 gchar*** artists,
                                 gint* artists_length1,
                                 gchar*** authors,
                                 gint* authors_length1,
                                 gchar** comments,
                                 gchar** copyright,
                                 gchar*** documenters,
                                 gint* documenters_length1,
                                 gchar** logo_icon_name,
                                 gchar** program_name,
                                 gchar** translator_credits,
                                 gchar** version,
                                 gchar** website,
                                 gchar** website_label);
static void about_list_real_reset (OverlayedList* base);
static GVariant* _variant_new1 (gboolean value);
static inline void about_list_show_apropos (AboutList* self,
                              GListStore** main_list_store);
VALA_EXTERN void overlayed_list_scroll_top (OverlayedList* self);
static void about_list_install_action_entries (AboutList* self);
static GVariant* _variant_new2 (gboolean value);
static inline void about_list_show_credits (AboutList* self,
                              GListStore** main_list_store);
static const gchar* about_list_get_program_name (AboutList* self);
static const gchar* about_list_get_logo_icon_name (AboutList* self);
VALA_EXTERN AboutListItem* about_list_item_new_from_icon_name (const gchar* icon_name,
                                                   const gchar* copy_text);
VALA_EXTERN AboutListItem* about_list_item_construct_from_icon_name (GType object_type,
                                                         const gchar* icon_name,
                                                         const gchar* copy_text);
VALA_EXTERN GType overlayed_list_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OverlayedListRow, g_object_unref)
VALA_EXTERN GType about_list_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AboutListItem, g_object_unref)
VALA_EXTERN AboutListItem* about_list_item_new_from_label (const gchar* text,
                                               const gchar* css_class);
VALA_EXTERN AboutListItem* about_list_item_construct_from_label (GType object_type,
                                                     const gchar* text,
                                                     const gchar* css_class);
static const gchar* about_list_get_version (AboutList* self);
static const gchar* about_list_get_comments (AboutList* self);
static const gchar* about_list_get_website (AboutList* self);
static const gchar* about_list_get_website_label (AboutList* self);
VALA_EXTERN AboutListItem* about_list_item_new_from_link (const gchar* link,
                                              const gchar* text_or_empty);
VALA_EXTERN AboutListItem* about_list_item_construct_from_link (GType object_type,
                                                    const gchar* link,
                                                    const gchar* text_or_empty);
static const gchar* about_list_get_copyright (AboutList* self);
static GtkLicense about_list_get_license_type (AboutList* self);
static gchar** about_list_get_authors (AboutList* self,
                                gint* result_length1);
static gchar* about_list_get_multiline_string_from_string_array (gchar** string_array,
                                                          gint string_array_length1);
VALA_EXTERN AboutListItem* about_list_item_new_with_title (const gchar* text,
                                               const gchar* title);
VALA_EXTERN AboutListItem* about_list_item_construct_with_title (GType object_type,
                                                     const gchar* text,
                                                     const gchar* title);
static gchar** about_list_get_documenters (AboutList* self,
                                    gint* result_length1);
static const gchar* about_list_get_translator_credits (AboutList* self);
static gchar** about_list_get_artists (AboutList* self,
                                gint* result_length1);
static void about_list_set_artists (AboutList* self,
                             gchar** value,
                             gint value_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void about_list_set_authors (AboutList* self,
                             gchar** value,
                             gint value_length1);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
static void about_list_set_comments (AboutList* self,
                              const gchar* value);
static void about_list_set_copyright (AboutList* self,
                               const gchar* value);
static void about_list_set_documenters (AboutList* self,
                                 gchar** value,
                                 gint value_length1);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
static void about_list_set_logo_icon_name (AboutList* self,
                                    const gchar* value);
static void about_list_set_program_name (AboutList* self,
                                  const gchar* value);
static void about_list_set_translator_credits (AboutList* self,
                                        const gchar* value);
static void about_list_set_version (AboutList* self,
                             const gchar* value);
static void about_list_set_website (AboutList* self,
                             const gchar* value);
static void about_list_set_website_label (AboutList* self,
                                   const gchar* value);
static GObject * about_list_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties);
VALA_EXTERN void overlayed_list_set_first_mode_name (OverlayedList* self,
                                         const gchar* value);
VALA_EXTERN void overlayed_list_set_second_mode_name (OverlayedList* self,
                                          const gchar* value);
VALA_EXTERN void overlayed_list_change_editability (OverlayedList* self,
                                        gboolean new_value);
static void about_list_finalize (GObject * obj);
static GType about_list_get_type_once (void);
static void _vala_about_list_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_about_list_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
VALA_EXTERN gboolean overlayed_list_row_handle_copy_text (OverlayedListRow* self,
                                              gchar** copy_text);
static gboolean about_list_item_real_handle_copy_text (OverlayedListRow* base,
                                                gchar** text);
VALA_EXTERN const gchar* about_list_item_get_copy_text (AboutListItem* self);
VALA_EXTERN AboutListItem* about_list_item_new (void);
VALA_EXTERN AboutListItem* about_list_item_construct (GType object_type);
VALA_EXTERN OverlayedListRow* overlayed_list_row_construct (GType object_type);
static void about_list_item_set_copy_text (AboutListItem* self,
                                    const gchar* value);
static void about_list_item_finalize (GObject * obj);
static GType about_list_item_get_type_once (void);
static void _vala_about_list_item_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_about_list_item_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry ABOUT_LIST_action_entries[1] = {{"set-edit-mode", _about_list_set_edit_mode_gsimple_action_activate_callback, "b", "false"}};

static inline gpointer
about_list_get_instance_private (AboutList* self)
{
	return G_STRUCT_MEMBER_P (self, AboutList_private_offset);
}

static void
_about_list_set_edit_mode_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	about_list_set_edit_mode ((AboutList*) self, action, parameter);
}

AboutList*
about_list_construct (GType object_type,
                      gboolean needs_shadows,
                      gboolean big_placeholder,
                      gchar*** artists,
                      gint* artists_length1,
                      gchar*** authors,
                      gint* authors_length1,
                      gchar** comments,
                      gchar** copyright,
                      gchar*** documenters,
                      gint* documenters_length1,
                      gchar** logo_icon_name,
                      gchar** program_name,
                      gchar** translator_credits,
                      gchar** version,
                      gchar** website,
                      gchar** website_label)
{
	AboutList * self = NULL;
	g_return_val_if_fail (*comments != NULL, NULL);
	g_return_val_if_fail (*copyright != NULL, NULL);
	g_return_val_if_fail (*logo_icon_name != NULL, NULL);
	g_return_val_if_fail (*program_name != NULL, NULL);
	g_return_val_if_fail (*translator_credits != NULL, NULL);
	g_return_val_if_fail (*version != NULL, NULL);
	g_return_val_if_fail (*website != NULL, NULL);
	g_return_val_if_fail (*website_label != NULL, NULL);
	self = (AboutList*) g_object_new (object_type, "needs-shadows", needs_shadows, "big-placeholder", big_placeholder, "edit-mode-action-prefix", "about", "artists", *artists, "authors", *authors, "comments", *comments, "copyright", *copyright, "documenters", *documenters, "logo-icon-name", *logo_icon_name, "program-name", *program_name, "translator-credits", *translator_credits, "version", *version, "website", *website, "website-label", *website_label, NULL);
	return self;
}

AboutList*
about_list_new (gboolean needs_shadows,
                gboolean big_placeholder,
                gchar*** artists,
                gint* artists_length1,
                gchar*** authors,
                gint* authors_length1,
                gchar** comments,
                gchar** copyright,
                gchar*** documenters,
                gint* documenters_length1,
                gchar** logo_icon_name,
                gchar** program_name,
                gchar** translator_credits,
                gchar** version,
                gchar** website,
                gchar** website_label)
{
	return about_list_construct (TYPE_ABOUT_LIST, needs_shadows, big_placeholder, artists, artists_length1, authors, authors_length1, comments, copyright, documenters, documenters_length1, logo_icon_name, program_name, translator_credits, version, website, website_label);
}

static GVariant*
_variant_new1 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
about_list_real_reset (OverlayedList* base)
{
	AboutList * self;
	GSimpleAction* _tmp0_;
	GVariant* _tmp1_;
	self = (AboutList*) base;
	_tmp0_ = self->priv->edit_mode_action;
	_tmp1_ = _variant_new1 (FALSE);
	g_simple_action_set_state (_tmp0_, _tmp1_);
	_g_variant_unref0 (_tmp1_);
	about_list_show_apropos (self, &((OverlayedList*) self)->main_list_store);
	overlayed_list_scroll_top ((OverlayedList*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
about_list_install_action_entries (AboutList* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) action_group, ABOUT_LIST_action_entries, (gint) G_N_ELEMENTS (ABOUT_LIST_action_entries), self);
	gtk_widget_insert_action_group ((GtkWidget*) self, "about", (GActionGroup*) action_group);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) action_group, "set-edit-mode");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->edit_mode_action);
	self->priv->edit_mode_action = _tmp2_;
	_g_object_unref0 (action_group);
}

static GVariant*
_variant_new2 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
about_list_set_edit_mode (AboutList* self,
                          GSimpleAction* action,
                          GVariant* variant)
{
	gboolean new_state = FALSE;
	GVariant* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_vala_return_if_fail (variant != NULL, "variant != null");
	new_state = g_variant_get_boolean ((GVariant*) variant);
	_tmp0_ = _variant_new2 (new_state);
	g_simple_action_set_state (action, _tmp0_);
	_g_variant_unref0 (_tmp0_);
	if (new_state) {
		about_list_show_credits (self, &((OverlayedList*) self)->main_list_store);
	} else {
		about_list_show_apropos (self, &((OverlayedList*) self)->main_list_store);
	}
}

static inline void
about_list_show_apropos (AboutList* self,
                         GListStore** main_list_store)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	AboutListItem* program = NULL;
	const gchar* _tmp6_;
	AboutListItem* _tmp7_;
	AboutListItem* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp13_;
	const gchar* _tmp17_;
	const gchar* _tmp22_;
	GtkLicense _tmp26_;
	GtkLicense _tmp27_;
	AboutListItem* _tmp28_;
	AboutListItem* _tmp29_;
	AboutListItem* _tmp30_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*main_list_store != NULL);
	g_list_store_remove_all (*main_list_store);
	_tmp0_ = self->priv->_program_name;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		g_assert_not_reached ();
	}
	_tmp1_ = self->priv->_logo_icon_name;
	if (g_strcmp0 (_tmp1_, "") != 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		AboutListItem* _tmp4_;
		AboutListItem* _tmp5_;
		_tmp2_ = self->priv->_logo_icon_name;
		_tmp3_ = self->priv->_program_name;
		_tmp4_ = about_list_item_new_from_icon_name (_tmp2_, _tmp3_);
		g_object_ref_sink (_tmp4_);
		_tmp5_ = _tmp4_;
		g_list_store_append (*main_list_store, (GObject*) _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp6_ = self->priv->_program_name;
	_tmp7_ = about_list_item_new_from_label (_tmp6_, "bold-label");
	g_object_ref_sink (_tmp7_);
	program = _tmp7_;
	_tmp8_ = program;
	g_list_store_append (*main_list_store, (GObject*) _tmp8_);
	_tmp9_ = self->priv->_version;
	if (g_strcmp0 (_tmp9_, "") != 0) {
		const gchar* _tmp10_;
		AboutListItem* _tmp11_;
		AboutListItem* _tmp12_;
		_tmp10_ = self->priv->_version;
		_tmp11_ = about_list_item_new_from_label (_tmp10_, NULL);
		g_object_ref_sink (_tmp11_);
		_tmp12_ = _tmp11_;
		g_list_store_append (*main_list_store, (GObject*) _tmp12_);
		_g_object_unref0 (_tmp12_);
	}
	_tmp13_ = self->priv->_comments;
	if (g_strcmp0 (_tmp13_, "") != 0) {
		const gchar* _tmp14_;
		AboutListItem* _tmp15_;
		AboutListItem* _tmp16_;
		_tmp14_ = self->priv->_comments;
		_tmp15_ = about_list_item_new_from_label (_tmp14_, NULL);
		g_object_ref_sink (_tmp15_);
		_tmp16_ = _tmp15_;
		g_list_store_append (*main_list_store, (GObject*) _tmp16_);
		_g_object_unref0 (_tmp16_);
	}
	_tmp17_ = self->priv->_website;
	if (g_strcmp0 (_tmp17_, "") != 0) {
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		AboutListItem* _tmp20_;
		AboutListItem* _tmp21_;
		_tmp18_ = self->priv->_website;
		_tmp19_ = self->priv->_website_label;
		_tmp20_ = about_list_item_new_from_link (_tmp18_, _tmp19_);
		g_object_ref_sink (_tmp20_);
		_tmp21_ = _tmp20_;
		g_list_store_append (*main_list_store, (GObject*) _tmp21_);
		_g_object_unref0 (_tmp21_);
	}
	_tmp22_ = self->priv->_copyright;
	if (g_strcmp0 (_tmp22_, "") != 0) {
		const gchar* _tmp23_;
		AboutListItem* _tmp24_;
		AboutListItem* _tmp25_;
		_tmp23_ = self->priv->_copyright;
		_tmp24_ = about_list_item_new_from_label (_tmp23_, "small-label");
		g_object_ref_sink (_tmp24_);
		_tmp25_ = _tmp24_;
		g_list_store_append (*main_list_store, (GObject*) _tmp25_);
		_g_object_unref0 (_tmp25_);
	}
	_tmp26_ = about_list_get_license_type (self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ != GTK_LICENSE_GPL_3_0) {
		g_assert_not_reached ();
	}
	_tmp28_ = about_list_item_new_from_link ("https://www.gnu.org/licenses/gpl-3.0.html", _ ("GNU General Public License\nversion 3 or later"));
	g_object_ref_sink (_tmp28_);
	_tmp29_ = _tmp28_;
	g_list_store_append (*main_list_store, (GObject*) _tmp29_);
	_g_object_unref0 (_tmp29_);
	_tmp30_ = program;
	gtk_widget_grab_focus ((GtkWidget*) _tmp30_);
	_g_object_unref0 (program);
}

static inline void
about_list_show_credits (AboutList* self,
                         GListStore** main_list_store)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	AboutListItem* program = NULL;
	const gchar* _tmp6_;
	AboutListItem* _tmp7_;
	AboutListItem* _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gint _tmp10_ = 0;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gint _tmp20_ = 0;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp29_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	gint _tmp34_ = 0;
	gchar** _tmp35_;
	gint _tmp35__length1;
	AboutListItem* _tmp43_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*main_list_store != NULL);
	g_list_store_remove_all (*main_list_store);
	_tmp0_ = self->priv->_program_name;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		g_assert_not_reached ();
	}
	_tmp1_ = self->priv->_logo_icon_name;
	if (g_strcmp0 (_tmp1_, "") != 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		AboutListItem* _tmp4_;
		AboutListItem* _tmp5_;
		_tmp2_ = self->priv->_logo_icon_name;
		_tmp3_ = self->priv->_program_name;
		_tmp4_ = about_list_item_new_from_icon_name (_tmp2_, _tmp3_);
		g_object_ref_sink (_tmp4_);
		_tmp5_ = _tmp4_;
		g_list_store_append (*main_list_store, (GObject*) _tmp5_);
		_g_object_unref0 (_tmp5_);
	}
	_tmp6_ = self->priv->_program_name;
	_tmp7_ = about_list_item_new_from_label (_tmp6_, "bold-label");
	g_object_ref_sink (_tmp7_);
	program = _tmp7_;
	_tmp8_ = program;
	g_list_store_append (*main_list_store, (GObject*) _tmp8_);
	_tmp9_ = about_list_get_authors (self, &_tmp10_);
	_tmp9__length1 = _tmp10_;
	_tmp11_ = _tmp9_;
	_tmp11__length1 = _tmp9__length1;
	if (_tmp11__length1 > 0) {
		gchar* authors_string = NULL;
		gchar** _tmp12_;
		gint _tmp12__length1;
		gint _tmp13_ = 0;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		AboutListItem* _tmp17_;
		AboutListItem* _tmp18_;
		_tmp12_ = about_list_get_authors (self, &_tmp13_);
		_tmp12__length1 = _tmp13_;
		_tmp14_ = _tmp12_;
		_tmp14__length1 = _tmp12__length1;
		_tmp15_ = about_list_get_multiline_string_from_string_array (_tmp14_, (gint) _tmp14__length1);
		authors_string = _tmp15_;
		_tmp16_ = authors_string;
		_tmp17_ = about_list_item_new_with_title (_tmp16_, _ ("Creators"));
		g_object_ref_sink (_tmp17_);
		_tmp18_ = _tmp17_;
		g_list_store_append (*main_list_store, (GObject*) _tmp18_);
		_g_object_unref0 (_tmp18_);
		_g_free0 (authors_string);
	}
	_tmp19_ = about_list_get_documenters (self, &_tmp20_);
	_tmp19__length1 = _tmp20_;
	_tmp21_ = _tmp19_;
	_tmp21__length1 = _tmp19__length1;
	if (_tmp21__length1 > 0) {
		gchar* documenters_string = NULL;
		gchar** _tmp22_;
		gint _tmp22__length1;
		gint _tmp23_ = 0;
		gchar** _tmp24_;
		gint _tmp24__length1;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		AboutListItem* _tmp27_;
		AboutListItem* _tmp28_;
		_tmp22_ = about_list_get_documenters (self, &_tmp23_);
		_tmp22__length1 = _tmp23_;
		_tmp24_ = _tmp22_;
		_tmp24__length1 = _tmp22__length1;
		_tmp25_ = about_list_get_multiline_string_from_string_array (_tmp24_, (gint) _tmp24__length1);
		documenters_string = _tmp25_;
		_tmp26_ = documenters_string;
		_tmp27_ = about_list_item_new_with_title (_tmp26_, _ ("Documenters"));
		g_object_ref_sink (_tmp27_);
		_tmp28_ = _tmp27_;
		g_list_store_append (*main_list_store, (GObject*) _tmp28_);
		_g_object_unref0 (_tmp28_);
		_g_free0 (documenters_string);
	}
	_tmp29_ = self->priv->_translator_credits;
	if (g_strcmp0 (_tmp29_, "") != 0) {
		const gchar* _tmp30_;
		AboutListItem* _tmp31_;
		AboutListItem* _tmp32_;
		_tmp30_ = self->priv->_translator_credits;
		_tmp31_ = about_list_item_new_with_title (_tmp30_, _ ("Translators"));
		g_object_ref_sink (_tmp31_);
		_tmp32_ = _tmp31_;
		g_list_store_append (*main_list_store, (GObject*) _tmp32_);
		_g_object_unref0 (_tmp32_);
	}
	_tmp33_ = about_list_get_artists (self, &_tmp34_);
	_tmp33__length1 = _tmp34_;
	_tmp35_ = _tmp33_;
	_tmp35__length1 = _tmp33__length1;
	if (_tmp35__length1 > 0) {
		gchar* artists_string = NULL;
		gchar** _tmp36_;
		gint _tmp36__length1;
		gint _tmp37_ = 0;
		gchar** _tmp38_;
		gint _tmp38__length1;
		gchar* _tmp39_;
		const gchar* _tmp40_;
		AboutListItem* _tmp41_;
		AboutListItem* _tmp42_;
		_tmp36_ = about_list_get_artists (self, &_tmp37_);
		_tmp36__length1 = _tmp37_;
		_tmp38_ = _tmp36_;
		_tmp38__length1 = _tmp36__length1;
		_tmp39_ = about_list_get_multiline_string_from_string_array (_tmp38_, (gint) _tmp38__length1);
		artists_string = _tmp39_;
		_tmp40_ = artists_string;
		_tmp41_ = about_list_item_new_with_title (_tmp40_, _ ("Artists"));
		g_object_ref_sink (_tmp41_);
		_tmp42_ = _tmp41_;
		g_list_store_append (*main_list_store, (GObject*) _tmp42_);
		_g_object_unref0 (_tmp42_);
		_g_free0 (artists_string);
	}
	_tmp43_ = program;
	gtk_widget_grab_focus ((GtkWidget*) _tmp43_);
	_g_object_unref0 (program);
}

static gchar*
about_list_get_multiline_string_from_string_array (gchar** string_array,
                                                   gint string_array_length1)
{
	gchar* multiline_string = NULL;
	gchar* _tmp1_;
	guint position = 0U;
	guint max_position = 0U;
	gchar* result;
	if (string_array_length1 <= 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_strdup ("");
	multiline_string = _tmp1_;
	position = (guint) 0;
	max_position = (guint) (string_array_length1 - 1);
	{
		gchar** string_item_collection = NULL;
		gint string_item_collection_length1 = 0;
		gint _string_item_collection_size_ = 0;
		gint string_item_it = 0;
		string_item_collection = string_array;
		string_item_collection_length1 = string_array_length1;
		for (string_item_it = 0; string_item_it < string_item_collection_length1; string_item_it = string_item_it + 1) {
			gchar* _tmp2_;
			gchar* string_item = NULL;
			_tmp2_ = g_strdup (string_item_collection[string_item_it]);
			string_item = _tmp2_;
			{
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				gchar* _tmp5_;
				guint _tmp8_;
				_tmp3_ = multiline_string;
				_tmp4_ = string_item;
				_tmp5_ = g_strconcat (_tmp3_, _tmp4_, NULL);
				_g_free0 (multiline_string);
				multiline_string = _tmp5_;
				if (position < max_position) {
					const gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp6_ = multiline_string;
					_tmp7_ = g_strconcat (_tmp6_, "\n", NULL);
					_g_free0 (multiline_string);
					multiline_string = _tmp7_;
				}
				_tmp8_ = position;
				position = _tmp8_ + 1;
				_g_free0 (string_item);
			}
		}
	}
	result = multiline_string;
	return result;
}

static gchar**
about_list_get_artists (AboutList* self,
                        gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_artists;
	_tmp0__length1 = self->priv->_artists_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
about_list_set_artists (AboutList* self,
                        gchar** value,
                        gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup1 (value, value_length1) : value;
	_tmp0__length1 = value_length1;
	self->priv->_artists = (_vala_array_free (self->priv->_artists, self->priv->_artists_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_artists = _tmp0_;
	self->priv->_artists_length1 = _tmp0__length1;
	self->priv->__artists_size_ = self->priv->_artists_length1;
}

static gchar**
about_list_get_authors (AboutList* self,
                        gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_authors;
	_tmp0__length1 = self->priv->_authors_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
about_list_set_authors (AboutList* self,
                        gchar** value,
                        gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup2 (value, value_length1) : value;
	_tmp0__length1 = value_length1;
	self->priv->_authors = (_vala_array_free (self->priv->_authors, self->priv->_authors_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_authors = _tmp0_;
	self->priv->_authors_length1 = _tmp0__length1;
	self->priv->__authors_size_ = self->priv->_authors_length1;
}

static const gchar*
about_list_get_comments (AboutList* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comments;
	result = _tmp0_;
	return result;
}

static void
about_list_set_comments (AboutList* self,
                         const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_comments);
	self->priv->_comments = _tmp0_;
}

static const gchar*
about_list_get_copyright (AboutList* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_copyright;
	result = _tmp0_;
	return result;
}

static void
about_list_set_copyright (AboutList* self,
                          const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_copyright);
	self->priv->_copyright = _tmp0_;
}

static gchar**
about_list_get_documenters (AboutList* self,
                            gint* result_length1)
{
	gchar** result;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_documenters;
	_tmp0__length1 = self->priv->_documenters_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
about_list_set_documenters (AboutList* self,
                            gchar** value,
                            gint value_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (value != NULL) ? _vala_array_dup3 (value, value_length1) : value;
	_tmp0__length1 = value_length1;
	self->priv->_documenters = (_vala_array_free (self->priv->_documenters, self->priv->_documenters_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_documenters = _tmp0_;
	self->priv->_documenters_length1 = _tmp0__length1;
	self->priv->__documenters_size_ = self->priv->_documenters_length1;
}

static GtkLicense
about_list_get_license_type (AboutList* self)
{
	GtkLicense result;
	g_return_val_if_fail (self != NULL, 0);
	result = GTK_LICENSE_GPL_3_0;
	return result;
}

static const gchar*
about_list_get_logo_icon_name (AboutList* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_logo_icon_name;
	result = _tmp0_;
	return result;
}

static void
about_list_set_logo_icon_name (AboutList* self,
                               const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_logo_icon_name);
	self->priv->_logo_icon_name = _tmp0_;
}

static const gchar*
about_list_get_program_name (AboutList* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_program_name;
	result = _tmp0_;
	return result;
}

static void
about_list_set_program_name (AboutList* self,
                             const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_program_name);
	self->priv->_program_name = _tmp0_;
}

static const gchar*
about_list_get_translator_credits (AboutList* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_translator_credits;
	result = _tmp0_;
	return result;
}

static void
about_list_set_translator_credits (AboutList* self,
                                   const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_translator_credits);
	self->priv->_translator_credits = _tmp0_;
}

static const gchar*
about_list_get_version (AboutList* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_version;
	result = _tmp0_;
	return result;
}

static void
about_list_set_version (AboutList* self,
                        const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_version);
	self->priv->_version = _tmp0_;
}

static const gchar*
about_list_get_website (AboutList* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_website;
	result = _tmp0_;
	return result;
}

static void
about_list_set_website (AboutList* self,
                        const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_website);
	self->priv->_website = _tmp0_;
}

static const gchar*
about_list_get_website_label (AboutList* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_website_label;
	result = _tmp0_;
	return result;
}

static void
about_list_set_website_label (AboutList* self,
                              const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_website_label);
	self->priv->_website_label = _tmp0_;
}

static GObject *
about_list_constructor (GType type,
                        guint n_construct_properties,
                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	AboutList * self;
	GtkListBox* _tmp0_;
	GtkStyleContext* _tmp1_;
	parent_class = G_OBJECT_CLASS (about_list_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ABOUT_LIST, AboutList);
	about_list_install_action_entries (self);
	_tmp0_ = ((OverlayedList*) self)->main_list_box;
	gtk_list_box_set_selection_mode (_tmp0_, GTK_SELECTION_NONE);
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp1_, "about-list");
	overlayed_list_set_first_mode_name ((OverlayedList*) self, _ ("About"));
	overlayed_list_set_second_mode_name ((OverlayedList*) self, _ ("Credits"));
	overlayed_list_change_editability ((OverlayedList*) self, TRUE);
	about_list_show_apropos (self, &((OverlayedList*) self)->main_list_store);
	return obj;
}

static void
about_list_class_init (AboutListClass * klass,
                       gpointer klass_data)
{
	about_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutList_private_offset);
	((OverlayedListClass *) klass)->reset = (void (*) (OverlayedList*)) about_list_real_reset;
	G_OBJECT_CLASS (klass)->get_property = _vala_about_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_about_list_set_property;
	G_OBJECT_CLASS (klass)->constructor = about_list_constructor;
	G_OBJECT_CLASS (klass)->finalize = about_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_LIST_ARTISTS_PROPERTY, about_list_properties[ABOUT_LIST_ARTISTS_PROPERTY] = g_param_spec_boxed ("artists", "artists", "artists", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_LIST_AUTHORS_PROPERTY, about_list_properties[ABOUT_LIST_AUTHORS_PROPERTY] = g_param_spec_boxed ("authors", "authors", "authors", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_LIST_COMMENTS_PROPERTY, about_list_properties[ABOUT_LIST_COMMENTS_PROPERTY] = g_param_spec_string ("comments", "comments", "comments", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_LIST_COPYRIGHT_PROPERTY, about_list_properties[ABOUT_LIST_COPYRIGHT_PROPERTY] = g_param_spec_string ("copyright", "copyright", "copyright", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_LIST_DOCUMENTERS_PROPERTY, about_list_properties[ABOUT_LIST_DOCUMENTERS_PROPERTY] = g_param_spec_boxed ("documenters", "documenters", "documenters", G_TYPE_STRV, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_LIST_LOGO_ICON_NAME_PROPERTY, about_list_properties[ABOUT_LIST_LOGO_ICON_NAME_PROPERTY] = g_param_spec_string ("logo-icon-name", "logo-icon-name", "logo-icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_LIST_PROGRAM_NAME_PROPERTY, about_list_properties[ABOUT_LIST_PROGRAM_NAME_PROPERTY] = g_param_spec_string ("program-name", "program-name", "program-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_LIST_TRANSLATOR_CREDITS_PROPERTY, about_list_properties[ABOUT_LIST_TRANSLATOR_CREDITS_PROPERTY] = g_param_spec_string ("translator-credits", "translator-credits", "translator-credits", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_LIST_VERSION_PROPERTY, about_list_properties[ABOUT_LIST_VERSION_PROPERTY] = g_param_spec_string ("version", "version", "version", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_LIST_WEBSITE_PROPERTY, about_list_properties[ABOUT_LIST_WEBSITE_PROPERTY] = g_param_spec_string ("website", "website", "website", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_LIST_WEBSITE_LABEL_PROPERTY, about_list_properties[ABOUT_LIST_WEBSITE_LABEL_PROPERTY] = g_param_spec_string ("website-label", "website-label", "website-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
}

static void
about_list_instance_init (AboutList * self,
                          gpointer klass)
{
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	self->priv = about_list_get_instance_private (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->_artists = _tmp0_;
	self->priv->_artists_length1 = 0;
	self->priv->__artists_size_ = self->priv->_artists_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	self->priv->_authors = _tmp1_;
	self->priv->_authors_length1 = 0;
	self->priv->__authors_size_ = self->priv->_authors_length1;
	_tmp2_ = g_strdup ("");
	self->priv->_comments = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->priv->_copyright = _tmp3_;
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	self->priv->_documenters = _tmp4_;
	self->priv->_documenters_length1 = 0;
	self->priv->__documenters_size_ = self->priv->_documenters_length1;
	_tmp5_ = g_strdup ("");
	self->priv->_logo_icon_name = _tmp5_;
	_tmp6_ = g_strdup ("");
	self->priv->_program_name = _tmp6_;
	_tmp7_ = g_strdup ("");
	self->priv->_translator_credits = _tmp7_;
	_tmp8_ = g_strdup ("");
	self->priv->_version = _tmp8_;
	_tmp9_ = g_strdup ("");
	self->priv->_website = _tmp9_;
	_tmp10_ = g_strdup ("");
	self->priv->_website_label = _tmp10_;
}

static void
about_list_finalize (GObject * obj)
{
	AboutList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ABOUT_LIST, AboutList);
	self->priv->_artists = (_vala_array_free (self->priv->_artists, self->priv->_artists_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_authors = (_vala_array_free (self->priv->_authors, self->priv->_authors_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_comments);
	_g_free0 (self->priv->_copyright);
	self->priv->_documenters = (_vala_array_free (self->priv->_documenters, self->priv->_documenters_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_logo_icon_name);
	_g_free0 (self->priv->_program_name);
	_g_free0 (self->priv->_translator_credits);
	_g_free0 (self->priv->_version);
	_g_free0 (self->priv->_website);
	_g_free0 (self->priv->_website_label);
	_g_object_unref0 (self->priv->edit_mode_action);
	G_OBJECT_CLASS (about_list_parent_class)->finalize (obj);
}

static GType
about_list_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutList), 0, (GInstanceInitFunc) about_list_instance_init, NULL };
	GType about_list_type_id;
	about_list_type_id = g_type_register_static (TYPE_OVERLAYED_LIST, "AboutList", &g_define_type_info, 0);
	AboutList_private_offset = g_type_add_instance_private (about_list_type_id, sizeof (AboutListPrivate));
	return about_list_type_id;
}

GType
about_list_get_type (void)
{
	static volatile gsize about_list_type_id__once = 0;
	if (g_once_init_enter (&about_list_type_id__once)) {
		GType about_list_type_id;
		about_list_type_id = about_list_get_type_once ();
		g_once_init_leave (&about_list_type_id__once, about_list_type_id);
	}
	return about_list_type_id__once;
}

static void
_vala_about_list_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	AboutList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ABOUT_LIST, AboutList);
	switch (property_id) {
		case ABOUT_LIST_ARTISTS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, about_list_get_artists (self, &length));
		}
		break;
		case ABOUT_LIST_AUTHORS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, about_list_get_authors (self, &length));
		}
		break;
		case ABOUT_LIST_COMMENTS_PROPERTY:
		g_value_set_string (value, about_list_get_comments (self));
		break;
		case ABOUT_LIST_COPYRIGHT_PROPERTY:
		g_value_set_string (value, about_list_get_copyright (self));
		break;
		case ABOUT_LIST_DOCUMENTERS_PROPERTY:
		{
			int length;
			g_value_set_boxed (value, about_list_get_documenters (self, &length));
		}
		break;
		case ABOUT_LIST_LOGO_ICON_NAME_PROPERTY:
		g_value_set_string (value, about_list_get_logo_icon_name (self));
		break;
		case ABOUT_LIST_PROGRAM_NAME_PROPERTY:
		g_value_set_string (value, about_list_get_program_name (self));
		break;
		case ABOUT_LIST_TRANSLATOR_CREDITS_PROPERTY:
		g_value_set_string (value, about_list_get_translator_credits (self));
		break;
		case ABOUT_LIST_VERSION_PROPERTY:
		g_value_set_string (value, about_list_get_version (self));
		break;
		case ABOUT_LIST_WEBSITE_PROPERTY:
		g_value_set_string (value, about_list_get_website (self));
		break;
		case ABOUT_LIST_WEBSITE_LABEL_PROPERTY:
		g_value_set_string (value, about_list_get_website_label (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_about_list_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	AboutList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ABOUT_LIST, AboutList);
	switch (property_id) {
		case ABOUT_LIST_ARTISTS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			about_list_set_artists (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case ABOUT_LIST_AUTHORS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			about_list_set_authors (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case ABOUT_LIST_COMMENTS_PROPERTY:
		about_list_set_comments (self, g_value_get_string (value));
		break;
		case ABOUT_LIST_COPYRIGHT_PROPERTY:
		about_list_set_copyright (self, g_value_get_string (value));
		break;
		case ABOUT_LIST_DOCUMENTERS_PROPERTY:
		{
			gpointer boxed;
			boxed = g_value_get_boxed (value);
			about_list_set_documenters (self, boxed, (boxed == NULL) ? 0 : g_strv_length (boxed));
		}
		break;
		case ABOUT_LIST_LOGO_ICON_NAME_PROPERTY:
		about_list_set_logo_icon_name (self, g_value_get_string (value));
		break;
		case ABOUT_LIST_PROGRAM_NAME_PROPERTY:
		about_list_set_program_name (self, g_value_get_string (value));
		break;
		case ABOUT_LIST_TRANSLATOR_CREDITS_PROPERTY:
		about_list_set_translator_credits (self, g_value_get_string (value));
		break;
		case ABOUT_LIST_VERSION_PROPERTY:
		about_list_set_version (self, g_value_get_string (value));
		break;
		case ABOUT_LIST_WEBSITE_PROPERTY:
		about_list_set_website (self, g_value_get_string (value));
		break;
		case ABOUT_LIST_WEBSITE_LABEL_PROPERTY:
		about_list_set_website_label (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
about_list_item_get_instance_private (AboutListItem* self)
{
	return G_STRUCT_MEMBER_P (self, AboutListItem_private_offset);
}

static gboolean
about_list_item_real_handle_copy_text (OverlayedListRow* base,
                                       gchar** text)
{
	AboutListItem * self;
	gchar* _vala_text = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean result;
	self = (AboutListItem*) base;
	_tmp0_ = self->priv->_copy_text;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_vala_text);
	_vala_text = _tmp1_;
	result = TRUE;
	if (text) {
		*text = _vala_text;
	} else {
		_g_free0 (_vala_text);
	}
	return result;
}

AboutListItem*
about_list_item_construct_from_label (GType object_type,
                                      const gchar* text,
                                      const gchar* css_class)
{
	AboutListItem * self = NULL;
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp10_;
	g_return_val_if_fail (text != NULL, NULL);
	self = (AboutListItem*) g_object_new (object_type, "copy-text", text, NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (text);
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	_tmp1_ = label;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = label;
	g_object_set (_tmp3_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	_tmp4_ = label;
	g_object_set (_tmp4_, "wrap", TRUE, NULL);
	_tmp5_ = label;
	gtk_label_set_justify (_tmp5_, GTK_JUSTIFY_CENTER);
	_tmp6_ = label;
	gtk_label_set_selectable (_tmp6_, TRUE);
	_tmp7_ = label;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp7_, FALSE);
	if (css_class != NULL) {
		GtkLabel* _tmp8_;
		GtkStyleContext* _tmp9_;
		_tmp8_ = label;
		_tmp9_ = gtk_widget_get_style_context ((GtkWidget*) _tmp8_);
		gtk_style_context_add_class (_tmp9_, (const gchar*) css_class);
	}
	_tmp10_ = label;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp10_);
	_g_object_unref0 (label);
	return self;
}

AboutListItem*
about_list_item_new_from_label (const gchar* text,
                                const gchar* css_class)
{
	return about_list_item_construct_from_label (TYPE_ABOUT_LIST_ITEM, text, css_class);
}

AboutListItem*
about_list_item_construct_from_icon_name (GType object_type,
                                          const gchar* icon_name,
                                          const gchar* copy_text)
{
	AboutListItem * self = NULL;
	GtkImage* image = NULL;
	GtkImage* _tmp0_;
	g_return_val_if_fail (icon_name != NULL, NULL);
	g_return_val_if_fail (copy_text != NULL, NULL);
	self = (AboutListItem*) g_object_new (object_type, "copy-text", copy_text, NULL);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name (icon_name, (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp0_);
	image = _tmp0_;
	gtk_image_set_pixel_size (image, 128);
	gtk_widget_set_visible ((GtkWidget*) image, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) image, TRUE);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) image);
	_g_object_unref0 (image);
	return self;
}

AboutListItem*
about_list_item_new_from_icon_name (const gchar* icon_name,
                                    const gchar* copy_text)
{
	return about_list_item_construct_from_icon_name (TYPE_ABOUT_LIST_ITEM, icon_name, copy_text);
}

AboutListItem*
about_list_item_construct_from_link (GType object_type,
                                     const gchar* link,
                                     const gchar* text_or_empty)
{
	AboutListItem * self = NULL;
	GtkLinkButton* button = NULL;
	GtkLinkButton* _tmp2_;
	GtkLinkButton* _tmp3_;
	GtkWidget* widget = NULL;
	GtkLinkButton* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GtkWidget* _tmp8_;
	GtkLabel* label = NULL;
	GtkWidget* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLinkButton* _tmp12_;
	g_return_val_if_fail (link != NULL, NULL);
	g_return_val_if_fail (text_or_empty != NULL, NULL);
	self = (AboutListItem*) g_object_new (object_type, "copy-text", link, NULL);
	if (g_strcmp0 (text_or_empty, "") == 0) {
		GtkLinkButton* _tmp0_;
		_tmp0_ = (GtkLinkButton*) gtk_link_button_new (link);
		g_object_ref_sink (_tmp0_);
		_g_object_unref0 (button);
		button = _tmp0_;
	} else {
		GtkLinkButton* _tmp1_;
		_tmp1_ = (GtkLinkButton*) gtk_link_button_new_with_label (link, text_or_empty);
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (button);
		button = _tmp1_;
	}
	_tmp2_ = button;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = button;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = button;
	_tmp5_ = gtk_bin_get_child ((GtkBin*) _tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	widget = _tmp6_;
	_tmp8_ = widget;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		GtkWidget* _tmp9_;
		_tmp9_ = widget;
		_tmp7_ = !G_TYPE_CHECK_INSTANCE_TYPE (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), gtk_label_get_type ());
	}
	if (_tmp7_) {
		g_assert_not_reached ();
	}
	_tmp10_ = widget;
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), gtk_label_get_type (), GtkLabel));
	label = _tmp11_;
	g_object_set (label, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	g_object_set (label, "wrap", TRUE, NULL);
	gtk_label_set_justify (label, GTK_JUSTIFY_CENTER);
	_tmp12_ = button;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp12_);
	_g_object_unref0 (label);
	_g_object_unref0 (widget);
	_g_object_unref0 (button);
	return self;
}

AboutListItem*
about_list_item_new_from_link (const gchar* link,
                               const gchar* text_or_empty)
{
	return about_list_item_construct_from_link (TYPE_ABOUT_LIST_ITEM, link, text_or_empty);
}

AboutListItem*
about_list_item_construct_with_title (GType object_type,
                                      const gchar* text,
                                      const gchar* title)
{
	AboutListItem * self = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp0_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkStyleContext* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkLabel* _tmp13_;
	GtkLabel* _tmp14_;
	GtkLabel* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	g_return_val_if_fail (text != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (AboutListItem*) g_object_new (object_type, "copy-text", text, NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	gtk_orientable_set_orientation ((GtkOrientable*) grid, GTK_ORIENTATION_VERTICAL);
	gtk_widget_set_visible ((GtkWidget*) grid, TRUE);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) grid);
	_tmp1_ = (GtkLabel*) gtk_label_new (title);
	g_object_ref_sink (_tmp1_);
	label = _tmp1_;
	_tmp2_ = label;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = label;
	g_object_set (_tmp4_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	_tmp5_ = label;
	g_object_set (_tmp5_, "wrap", TRUE, NULL);
	_tmp6_ = label;
	_tmp7_ = gtk_widget_get_style_context ((GtkWidget*) _tmp6_);
	gtk_style_context_add_class (_tmp7_, "bold-label");
	_tmp8_ = label;
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) _tmp8_);
	_tmp9_ = (GtkLabel*) gtk_label_new (text);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (label);
	label = _tmp9_;
	_tmp10_ = label;
	gtk_widget_set_visible ((GtkWidget*) _tmp10_, TRUE);
	_tmp11_ = label;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp11_, TRUE);
	_tmp12_ = label;
	g_object_set (_tmp12_, "wrap-mode", PANGO_WRAP_WORD_CHAR, NULL);
	_tmp13_ = label;
	g_object_set (_tmp13_, "wrap", TRUE, NULL);
	_tmp14_ = label;
	gtk_label_set_selectable (_tmp14_, TRUE);
	_tmp15_ = label;
	_tmp16_ = gtk_widget_get_style_context ((GtkWidget*) _tmp15_);
	gtk_style_context_add_class (_tmp16_, "small-label");
	_tmp17_ = label;
	gtk_label_set_justify (_tmp17_, GTK_JUSTIFY_CENTER);
	_tmp18_ = label;
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) _tmp18_);
	_g_object_unref0 (label);
	_g_object_unref0 (grid);
	return self;
}

AboutListItem*
about_list_item_new_with_title (const gchar* text,
                                const gchar* title)
{
	return about_list_item_construct_with_title (TYPE_ABOUT_LIST_ITEM, text, title);
}

AboutListItem*
about_list_item_construct (GType object_type)
{
	AboutListItem * self = NULL;
	self = (AboutListItem*) overlayed_list_row_construct (object_type);
	return self;
}

AboutListItem*
about_list_item_new (void)
{
	return about_list_item_construct (TYPE_ABOUT_LIST_ITEM);
}

const gchar*
about_list_item_get_copy_text (AboutListItem* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_copy_text;
	result = _tmp0_;
	return result;
}

static void
about_list_item_set_copy_text (AboutListItem* self,
                               const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_copy_text);
	self->priv->_copy_text = _tmp0_;
}

static void
about_list_item_class_init (AboutListItemClass * klass,
                            gpointer klass_data)
{
	about_list_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutListItem_private_offset);
	((OverlayedListRowClass *) klass)->handle_copy_text = (gboolean (*) (OverlayedListRow*, gchar**)) about_list_item_real_handle_copy_text;
	G_OBJECT_CLASS (klass)->get_property = _vala_about_list_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_about_list_item_set_property;
	G_OBJECT_CLASS (klass)->finalize = about_list_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ABOUT_LIST_ITEM_COPY_TEXT_PROPERTY, about_list_item_properties[ABOUT_LIST_ITEM_COPY_TEXT_PROPERTY] = g_param_spec_string ("copy-text", "copy-text", "copy-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
}

static void
about_list_item_instance_init (AboutListItem * self,
                               gpointer klass)
{
	gchar* _tmp0_;
	self->priv = about_list_item_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_copy_text = _tmp0_;
}

static void
about_list_item_finalize (GObject * obj)
{
	AboutListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ABOUT_LIST_ITEM, AboutListItem);
	_g_free0 (self->priv->_copy_text);
	G_OBJECT_CLASS (about_list_item_parent_class)->finalize (obj);
}

static GType
about_list_item_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutListItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_list_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutListItem), 0, (GInstanceInitFunc) about_list_item_instance_init, NULL };
	GType about_list_item_type_id;
	about_list_item_type_id = g_type_register_static (TYPE_OVERLAYED_LIST_ROW, "AboutListItem", &g_define_type_info, 0);
	AboutListItem_private_offset = g_type_add_instance_private (about_list_item_type_id, sizeof (AboutListItemPrivate));
	return about_list_item_type_id;
}

GType
about_list_item_get_type (void)
{
	static volatile gsize about_list_item_type_id__once = 0;
	if (g_once_init_enter (&about_list_item_type_id__once)) {
		GType about_list_item_type_id;
		about_list_item_type_id = about_list_item_get_type_once ();
		g_once_init_leave (&about_list_item_type_id__once, about_list_item_type_id);
	}
	return about_list_item_type_id__once;
}

static void
_vala_about_list_item_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	AboutListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ABOUT_LIST_ITEM, AboutListItem);
	switch (property_id) {
		case ABOUT_LIST_ITEM_COPY_TEXT_PROPERTY:
		g_value_set_string (value, about_list_item_get_copy_text (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_about_list_item_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	AboutListItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ABOUT_LIST_ITEM, AboutListItem);
	switch (property_id) {
		case ABOUT_LIST_ITEM_COPY_TEXT_PROPERTY:
		about_list_item_set_copy_text (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

