/* sudoku-view.c generated by valac 0.56.17, the Vala compiler
 * generated from sudoku-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 * Copyright © 2023 Jamie Murphy <jmurphy@gnome.org>
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include "libsudoku.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
typedef struct _SudokuViewPrivate SudokuViewPrivate;

#define TYPE_SUDOKU_CELL (sudoku_cell_get_type ())
#define SUDOKU_CELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_CELL, SudokuCell))
#define SUDOKU_CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_CELL, SudokuCellClass))
#define IS_SUDOKU_CELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_CELL))
#define IS_SUDOKU_CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_CELL))
#define SUDOKU_CELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_CELL, SudokuCellClass))

typedef struct _SudokuCell SudokuCell;
typedef struct _SudokuCellClass SudokuCellClass;

#define TYPE_SUDOKU_FRAME (sudoku_frame_get_type ())
#define SUDOKU_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_FRAME, SudokuFrame))
#define SUDOKU_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_FRAME, SudokuFrameClass))
#define IS_SUDOKU_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_FRAME))
#define IS_SUDOKU_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_FRAME))
#define SUDOKU_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_FRAME, SudokuFrameClass))

typedef struct _SudokuFrame SudokuFrame;
typedef struct _SudokuFrameClass SudokuFrameClass;
enum  {
	SUDOKU_VIEW_0_PROPERTY,
	SUDOKU_VIEW_SELECTED_ROW_PROPERTY,
	SUDOKU_VIEW_SELECTED_COL_PROPERTY,
	SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY,
	SUDOKU_VIEW_SHOW_EXTRA_WARNINGS_PROPERTY,
	SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY,
	SUDOKU_VIEW_HIGHLIGHTER_PROPERTY,
	SUDOKU_VIEW_HAS_SELECTION_PROPERTY,
	SUDOKU_VIEW_NUM_PROPERTIES
};
static GParamSpec* sudoku_view_properties[SUDOKU_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
enum  {
	SUDOKU_VIEW_SELECTION_CHANGED_SIGNAL,
	SUDOKU_VIEW_NUM_SIGNALS
};
static guint sudoku_view_signals[SUDOKU_VIEW_NUM_SIGNALS] = {0};

struct _SudokuView {
	AdwBin parent_instance;
	SudokuViewPrivate * priv;
};

struct _SudokuViewClass {
	AdwBinClass parent_class;
};

struct _SudokuViewPrivate {
	SudokuGame* game;
	SudokuCell** cells;
	gint cells_length1;
	gint cells_length2;
	SudokuFrame* frame;
	GtkLabel* paused_label;
	gint _selected_row;
	gint _selected_col;
	gboolean _show_warnings;
	gboolean _show_extra_warnings;
	gboolean _show_possibilities;
	gboolean _highlighter;
	gboolean _has_selection;
};

static gint SudokuView_private_offset;
static gpointer sudoku_view_parent_class = NULL;

VALA_EXTERN GType sudoku_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuView, g_object_unref)
VALA_EXTERN GType sudoku_cell_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuCell, g_object_unref)
VALA_EXTERN GType sudoku_frame_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuFrame, g_object_unref)
VALA_EXTERN void sudoku_view_set_selected (SudokuView* self,
                               gint cell_row,
                               gint cell_col);
VALA_EXTERN gint sudoku_view_get_selected_row (SudokuView* self);
VALA_EXTERN gint sudoku_view_get_selected_col (SudokuView* self);
VALA_EXTERN void sudoku_cell_set_selected (SudokuCell* self,
                               gboolean value);
static void sudoku_view_set_selected_row (SudokuView* self,
                                   gint value);
static void sudoku_view_set_selected_col (SudokuView* self,
                                   gint value);
VALA_EXTERN SudokuView* sudoku_view_new (SudokuGame* game,
                             GSettings* settings);
VALA_EXTERN SudokuView* sudoku_view_construct (GType object_type,
                                   SudokuGame* game,
                                   GSettings* settings);
VALA_EXTERN SudokuFrame* sudoku_frame_new (GtkWidget* child);
VALA_EXTERN SudokuFrame* sudoku_frame_construct (GType object_type,
                                     GtkWidget* child);
static void __lambda8_ (SudokuView* self);
static void sudoku_view_mask_view (SudokuView* self);
static void sudoku_view_clear_all_warnings (SudokuView* self);
static void sudoku_view_unmask_view (SudokuView* self);
static void sudoku_view_update_warnings (SudokuView* self);
VALA_EXTERN void sudoku_view_set_has_selection (SudokuView* self,
                                    gboolean value);
static void ___lambda8__sudoku_game_paused_changed (SudokuGame* _sender,
                                             gpointer self);
VALA_EXTERN SudokuCell* sudoku_cell_new (gint row,
                             gint col,
                             SudokuGame* game,
                             SudokuView* view);
VALA_EXTERN SudokuCell* sudoku_cell_construct (GType object_type,
                                   gint row,
                                   gint col,
                                   SudokuGame* game,
                                   SudokuView* view);
VALA_EXTERN void sudoku_cell_initialize_earmarks (SudokuCell* self,
                                      gboolean show_possibilities,
                                      gboolean force);
VALA_EXTERN gboolean sudoku_view_get_show_possibilities (SudokuView* self);
static void sudoku_view_cell_changed_cb (SudokuView* self,
                                  gint row,
                                  gint col,
                                  gint old_val,
                                  gint new_val);
static void _sudoku_view_cell_changed_cb_sudoku_board_cell_changed (SudokuBoard* _sender,
                                                             gint row,
                                                             gint col,
                                                             gint old_val,
                                                             gint new_val,
                                                             gpointer self);
static void sudoku_view_earmark_changed_cb (SudokuView* self,
                                     gint row,
                                     gint col,
                                     gint num,
                                     gboolean enabled);
static void _sudoku_view_earmark_changed_cb_sudoku_board_earmark_changed (SudokuBoard* _sender,
                                                                   gint row,
                                                                   gint col,
                                                                   gint num,
                                                                   gboolean enabled,
                                                                   gpointer self);
static void sudoku_view_selection_changed_cb (SudokuView* self,
                                       gint old_row,
                                       gint old_col,
                                       gint new_row,
                                       gint new_col);
static void _sudoku_view_selection_changed_cb_sudoku_view_selection_changed (SudokuView* _sender,
                                                                      gint old_row,
                                                                      gint old_col,
                                                                      gint new_row,
                                                                      gint new_col,
                                                                      gpointer self);
static void sudoku_view_set_cell_highlighter (SudokuView* self,
                                       gint row,
                                       gint col,
                                       gboolean enabled);
VALA_EXTERN void sudoku_cell_dismiss_popover (SudokuCell* self);
VALA_EXTERN void sudoku_cell_update_value (SudokuCell* self);
static void sudoku_view_set_value_highlighter (SudokuView* self,
                                        gint val,
                                        gboolean enabled);
VALA_EXTERN void sudoku_cell_update_earmark (SudokuCell* self,
                                 gint num);
VALA_EXTERN void sudoku_cell_check_earmark_warnings (SudokuCell* self,
                                         gint num);
VALA_EXTERN gboolean sudoku_view_get_highlighter (SudokuView* self);
VALA_EXTERN gint sudoku_cell_get_value (SudokuCell* self);
VALA_EXTERN void sudoku_cell_set_highlighted_value (SudokuCell* self,
                                        gboolean value);
VALA_EXTERN void sudoku_cell_set_earmark_highlight (SudokuCell* self,
                                        gint val,
                                        gboolean enabled);
VALA_EXTERN gboolean sudoku_cell_get_is_fixed (SudokuCell* self);
VALA_EXTERN void sudoku_cell_set_highlighted_background (SudokuCell* self,
                                             gboolean value);
VALA_EXTERN gboolean sudoku_view_get_show_warnings (SudokuView* self);
VALA_EXTERN void sudoku_cell_check_value_warnings (SudokuCell* self,
                                       gboolean show_extra_warnings);
VALA_EXTERN gboolean sudoku_view_get_show_extra_warnings (SudokuView* self);
VALA_EXTERN void sudoku_cell_check_earmarks_warnings (SudokuCell* self);
VALA_EXTERN void sudoku_view_clear (SudokuView* self);
VALA_EXTERN void sudoku_cell_clear_warnings (SudokuCell* self);
VALA_EXTERN void sudoku_cell_set_paused (SudokuCell* self,
                             gboolean value);
VALA_EXTERN void sudoku_view_dismiss_popovers (SudokuView* self);
static void sudoku_view_real_dispose (GObject* base);
VALA_EXTERN void sudoku_view_set_show_warnings (SudokuView* self,
                                    gboolean value);
VALA_EXTERN void sudoku_view_set_show_extra_warnings (SudokuView* self,
                                          gboolean value);
VALA_EXTERN void sudoku_view_set_show_possibilities (SudokuView* self,
                                         gboolean value);
VALA_EXTERN void sudoku_view_set_highlighter (SudokuView* self,
                                  gboolean value);
VALA_EXTERN gboolean sudoku_view_get_has_selection (SudokuView* self);
static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static gboolean _sudoku_view___lambda9_ (GtkWidget* _self_);
static gboolean __sudoku_view___lambda9__gtk_shortcut_func (GtkWidget* widget,
                                                     GVariant* args,
                                                     gpointer self);
static gboolean _sudoku_view___lambda10_ (GtkWidget* _self_);
static gboolean __sudoku_view___lambda10__gtk_shortcut_func (GtkWidget* widget,
                                                      GVariant* args,
                                                      gpointer self);
static gboolean _sudoku_view___lambda11_ (GtkWidget* _self_);
static gboolean __sudoku_view___lambda11__gtk_shortcut_func (GtkWidget* widget,
                                                      GVariant* args,
                                                      gpointer self);
static gboolean _sudoku_view___lambda12_ (GtkWidget* _self_);
static gboolean __sudoku_view___lambda12__gtk_shortcut_func (GtkWidget* widget,
                                                      GVariant* args,
                                                      gpointer self);
static void sudoku_view_finalize (GObject * obj);
static GType sudoku_view_get_type_once (void);
static void _vala_sudoku_view_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_sudoku_view_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
sudoku_view_get_instance_private (SudokuView* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuView_private_offset);
}

void
sudoku_view_set_selected (SudokuView* self,
                          gint cell_row,
                          gint cell_col)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_;
	gint old_row = 0;
	gint _tmp10_;
	gint old_col = 0;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_selected_row;
	if (_tmp1_ == cell_row) {
		gint _tmp2_;
		_tmp2_ = self->priv->_selected_col;
		_tmp0_ = _tmp2_ == cell_col;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = self->priv->_selected_row;
	if (_tmp4_ >= 0) {
		gint _tmp5_;
		_tmp5_ = self->priv->_selected_col;
		_tmp3_ = _tmp5_ >= 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		SudokuCell** _tmp6_;
		gint _tmp6__length1;
		gint _tmp6__length2;
		gint _tmp7_;
		gint _tmp8_;
		SudokuCell* _tmp9_;
		_tmp6_ = self->priv->cells;
		_tmp6__length1 = self->priv->cells_length1;
		_tmp6__length2 = self->priv->cells_length2;
		_tmp7_ = self->priv->_selected_row;
		_tmp8_ = self->priv->_selected_col;
		_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
		sudoku_cell_set_selected (_tmp9_, FALSE);
	}
	_tmp10_ = self->priv->_selected_row;
	old_row = _tmp10_;
	_tmp11_ = self->priv->_selected_col;
	old_col = _tmp11_;
	sudoku_view_set_selected_row (self, cell_row);
	sudoku_view_set_selected_col (self, cell_col);
	_tmp12_ = self->priv->_selected_row;
	_tmp13_ = self->priv->_selected_col;
	g_signal_emit (self, sudoku_view_signals[SUDOKU_VIEW_SELECTION_CHANGED_SIGNAL], 0, old_row, old_col, _tmp12_, _tmp13_);
	_tmp15_ = self->priv->_selected_row;
	if (_tmp15_ >= 0) {
		gint _tmp16_;
		_tmp16_ = self->priv->_selected_col;
		_tmp14_ = _tmp16_ >= 0;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		SudokuCell** _tmp17_;
		gint _tmp17__length1;
		gint _tmp17__length2;
		gint _tmp18_;
		gint _tmp19_;
		SudokuCell* _tmp20_;
		_tmp17_ = self->priv->cells;
		_tmp17__length1 = self->priv->cells_length1;
		_tmp17__length2 = self->priv->cells_length2;
		_tmp18_ = self->priv->_selected_row;
		_tmp19_ = self->priv->_selected_col;
		_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
		sudoku_cell_set_selected (_tmp20_, TRUE);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_pango_attr_list_ref0 (gpointer self)
{
	return self ? pango_attr_list_ref (self) : NULL;
}

static void
__lambda8_ (SudokuView* self)
{
	PangoAttrList* attr_list = NULL;
	GtkLabel* _tmp0_;
	PangoAttrList* _tmp1_;
	PangoAttrList* _tmp2_;
	PangoAttrList* _tmp3_;
	PangoAttrList* _tmp5_;
	PangoAttribute* _tmp6_;
	GtkLabel* _tmp7_;
	PangoAttrList* _tmp8_;
	GtkLabel* _tmp9_;
	SudokuGame* _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	SudokuGame* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	SudokuGame* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	_tmp0_ = self->priv->paused_label;
	_tmp1_ = gtk_label_get_attributes (_tmp0_);
	_tmp2_ = _pango_attr_list_ref0 (_tmp1_);
	attr_list = _tmp2_;
	_tmp3_ = attr_list;
	if (_tmp3_ == NULL) {
		PangoAttrList* _tmp4_;
		_tmp4_ = pango_attr_list_new ();
		_pango_attr_list_unref0 (attr_list);
		attr_list = _tmp4_;
	}
	_tmp5_ = attr_list;
	_tmp6_ = pango_attr_size_new_absolute (((gint) (gtk_widget_get_width ((GtkWidget*) self) * 0.125)) * PANGO_SCALE);
	pango_attr_list_change (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->paused_label;
	_tmp8_ = attr_list;
	gtk_label_set_attributes (_tmp7_, _tmp8_);
	_tmp9_ = self->priv->paused_label;
	_tmp10_ = self->priv->game;
	_tmp11_ = sudoku_game_get_paused (_tmp10_);
	_tmp12_ = _tmp11_;
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, _tmp12_);
	_tmp13_ = self->priv->game;
	_tmp14_ = sudoku_game_get_paused (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		sudoku_view_mask_view (self);
		sudoku_view_clear_all_warnings (self);
	} else {
		sudoku_view_unmask_view (self);
		sudoku_view_update_warnings (self);
	}
	_tmp16_ = self->priv->game;
	_tmp17_ = sudoku_game_get_paused (_tmp16_);
	_tmp18_ = _tmp17_;
	sudoku_view_set_has_selection (self, !_tmp18_);
	_pango_attr_list_unref0 (attr_list);
}

static void
___lambda8__sudoku_game_paused_changed (SudokuGame* _sender,
                                        gpointer self)
{
	__lambda8_ ((SudokuView*) self);
}

static void
_sudoku_view_cell_changed_cb_sudoku_board_cell_changed (SudokuBoard* _sender,
                                                        gint row,
                                                        gint col,
                                                        gint old_val,
                                                        gint new_val,
                                                        gpointer self)
{
	sudoku_view_cell_changed_cb ((SudokuView*) self, row, col, old_val, new_val);
}

static void
_sudoku_view_earmark_changed_cb_sudoku_board_earmark_changed (SudokuBoard* _sender,
                                                              gint row,
                                                              gint col,
                                                              gint num,
                                                              gboolean enabled,
                                                              gpointer self)
{
	sudoku_view_earmark_changed_cb ((SudokuView*) self, row, col, num, enabled);
}

static void
_sudoku_view_selection_changed_cb_sudoku_view_selection_changed (SudokuView* _sender,
                                                                 gint old_row,
                                                                 gint old_col,
                                                                 gint new_row,
                                                                 gint new_col,
                                                                 gpointer self)
{
	sudoku_view_selection_changed_cb ((SudokuView*) self, old_row, old_col, new_row, new_col);
}

SudokuView*
sudoku_view_construct (GType object_type,
                       SudokuGame* game,
                       GSettings* settings)
{
	SudokuView * self = NULL;
	SudokuGame* _tmp0_;
	GameMode _tmp1_;
	GameMode _tmp2_;
	GtkOverlay* overlay = NULL;
	GtkOverlay* _tmp3_;
	GtkOverlay* _tmp4_;
	SudokuFrame* _tmp5_;
	SudokuFrame* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	GtkOverlay* _tmp10_;
	GtkLabel* _tmp11_;
	SudokuGame* _tmp12_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkGrid* _tmp14_;
	GtkOverlay* _tmp15_;
	GtkGrid* _tmp16_;
	GtkGrid** blocks = NULL;
	SudokuBoard* _tmp17_;
	SudokuBoard* _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	SudokuBoard* _tmp21_;
	SudokuBoard* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GtkGrid** _tmp25_;
	gint blocks_length1;
	gint blocks_length2;
	SudokuBoard* _tmp49_;
	SudokuBoard* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	SudokuBoard* _tmp53_;
	SudokuBoard* _tmp54_;
	gint _tmp55_;
	gint _tmp56_;
	SudokuCell** _tmp57_;
	SudokuGame* _tmp96_;
	SudokuBoard* _tmp97_;
	SudokuBoard* _tmp98_;
	SudokuGame* _tmp99_;
	SudokuBoard* _tmp100_;
	SudokuBoard* _tmp101_;
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	self = (SudokuView*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp0_;
	gtk_widget_set_vexpand ((GtkWidget*) self, TRUE);
	gtk_widget_set_focusable ((GtkWidget*) self, TRUE);
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	_tmp1_ = sudoku_game_get_mode (game);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == GAME_MODE_CREATE) {
		self->priv->_show_warnings = TRUE;
	} else {
		self->priv->_show_warnings = g_settings_get_boolean (settings, "show-warnings");
	}
	self->priv->_show_possibilities = g_settings_get_boolean (settings, "show-possibilities");
	self->priv->_show_extra_warnings = g_settings_get_boolean (settings, "show-extra-warnings");
	self->priv->_highlighter = g_settings_get_boolean (settings, "highlighter");
	_tmp3_ = (GtkOverlay*) gtk_overlay_new ();
	g_object_ref_sink (_tmp3_);
	overlay = _tmp3_;
	_tmp4_ = overlay;
	_tmp5_ = sudoku_frame_new ((GtkWidget*) _tmp4_);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->frame);
	self->priv->frame = _tmp5_;
	_tmp6_ = self->priv->frame;
	adw_bin_set_child ((AdwBin*) self, (GtkWidget*) _tmp6_);
	_tmp7_ = (GtkLabel*) gtk_label_new ("Paused");
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->paused_label);
	self->priv->paused_label = _tmp7_;
	_tmp8_ = self->priv->paused_label;
	gtk_widget_add_css_class ((GtkWidget*) _tmp8_, "paused");
	_tmp9_ = self->priv->paused_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp9_, FALSE);
	_tmp10_ = overlay;
	_tmp11_ = self->priv->paused_label;
	gtk_overlay_add_overlay (_tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = self->priv->game;
	g_signal_connect_object (_tmp12_, "paused-changed", (GCallback) ___lambda8__sudoku_game_paused_changed, self, 0);
	_tmp13_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_row_spacing (_tmp13_, 2);
	gtk_grid_set_column_spacing (_tmp13_, 2);
	gtk_grid_set_column_homogeneous (_tmp13_, TRUE);
	gtk_grid_set_row_homogeneous (_tmp13_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp13_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp13_, TRUE);
	g_object_ref_sink (_tmp13_);
	grid = _tmp13_;
	_tmp14_ = grid;
	gtk_widget_add_css_class ((GtkWidget*) _tmp14_, "board");
	_tmp15_ = overlay;
	_tmp16_ = grid;
	gtk_overlay_set_child (_tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = sudoku_game_get_board (game);
	_tmp18_ = _tmp17_;
	_tmp19_ = sudoku_board_get_block_rows (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = sudoku_game_get_board (game);
	_tmp22_ = _tmp21_;
	_tmp23_ = sudoku_board_get_block_cols (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_new0 (GtkGrid*, (_tmp20_ * _tmp24_) + 1);
	blocks = _tmp25_;
	blocks_length1 = _tmp20_;
	blocks_length2 = _tmp24_;
	{
		gint block_row = 0;
		block_row = 0;
		{
			gboolean _tmp26_ = FALSE;
			_tmp26_ = TRUE;
			while (TRUE) {
				SudokuBoard* _tmp28_;
				SudokuBoard* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				if (!_tmp26_) {
					gint _tmp27_;
					_tmp27_ = block_row;
					block_row = _tmp27_ + 1;
				}
				_tmp26_ = FALSE;
				_tmp28_ = sudoku_game_get_board (game);
				_tmp29_ = _tmp28_;
				_tmp30_ = sudoku_board_get_block_rows (_tmp29_);
				_tmp31_ = _tmp30_;
				if (!(block_row < _tmp31_)) {
					break;
				}
				{
					gint block_col = 0;
					block_col = 0;
					{
						gboolean _tmp32_ = FALSE;
						_tmp32_ = TRUE;
						while (TRUE) {
							SudokuBoard* _tmp34_;
							SudokuBoard* _tmp35_;
							gint _tmp36_;
							gint _tmp37_;
							GtkGrid* block_grid = NULL;
							GtkGrid* _tmp38_;
							GtkGrid* _tmp39_;
							GtkGrid* _tmp40_;
							GtkGrid* _tmp41_;
							GtkGrid* _tmp42_;
							GtkGrid* _tmp43_;
							GtkGrid* _tmp44_;
							GtkGrid* _tmp45_;
							GtkGrid** _tmp46_;
							gint _tmp46__length1;
							gint _tmp46__length2;
							GtkGrid* _tmp47_;
							GtkGrid* _tmp48_;
							if (!_tmp32_) {
								gint _tmp33_;
								_tmp33_ = block_col;
								block_col = _tmp33_ + 1;
							}
							_tmp32_ = FALSE;
							_tmp34_ = sudoku_game_get_board (game);
							_tmp35_ = _tmp34_;
							_tmp36_ = sudoku_board_get_block_cols (_tmp35_);
							_tmp37_ = _tmp36_;
							if (!(block_col < _tmp37_)) {
								break;
							}
							_tmp38_ = (GtkGrid*) gtk_grid_new ();
							g_object_ref_sink (_tmp38_);
							block_grid = _tmp38_;
							_tmp39_ = block_grid;
							gtk_grid_set_row_spacing (_tmp39_, 1);
							_tmp40_ = block_grid;
							gtk_grid_set_column_spacing (_tmp40_, 1);
							_tmp41_ = block_grid;
							gtk_grid_set_column_homogeneous (_tmp41_, TRUE);
							_tmp42_ = block_grid;
							gtk_grid_set_row_homogeneous (_tmp42_, TRUE);
							_tmp43_ = block_grid;
							gtk_widget_add_css_class ((GtkWidget*) _tmp43_, "block");
							_tmp44_ = grid;
							_tmp45_ = block_grid;
							gtk_grid_attach (_tmp44_, (GtkWidget*) _tmp45_, block_col, block_row, 1, 1);
							_tmp46_ = blocks;
							_tmp46__length1 = blocks_length1;
							_tmp46__length2 = blocks_length2;
							_tmp47_ = block_grid;
							_tmp48_ = _g_object_ref0 (_tmp47_);
							_g_object_unref0 (_tmp46_[(block_row * _tmp46__length2) + block_col]);
							_tmp46_[(block_row * _tmp46__length2) + block_col] = _tmp48_;
							_g_object_unref0 (block_grid);
						}
					}
				}
			}
		}
	}
	_tmp49_ = sudoku_game_get_board (game);
	_tmp50_ = _tmp49_;
	_tmp51_ = sudoku_board_get_rows (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = sudoku_game_get_board (game);
	_tmp54_ = _tmp53_;
	_tmp55_ = sudoku_board_get_cols (_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = g_new0 (SudokuCell*, (_tmp52_ * _tmp56_) + 1);
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
	self->priv->cells = _tmp57_;
	self->priv->cells_length1 = _tmp52_;
	self->priv->cells_length2 = _tmp56_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp58_ = FALSE;
			_tmp58_ = TRUE;
			while (TRUE) {
				SudokuBoard* _tmp60_;
				SudokuBoard* _tmp61_;
				gint _tmp62_;
				gint _tmp63_;
				if (!_tmp58_) {
					gint _tmp59_;
					_tmp59_ = row;
					row = _tmp59_ + 1;
				}
				_tmp58_ = FALSE;
				_tmp60_ = sudoku_game_get_board (game);
				_tmp61_ = _tmp60_;
				_tmp62_ = sudoku_board_get_rows (_tmp61_);
				_tmp63_ = _tmp62_;
				if (!(row < _tmp63_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp64_ = FALSE;
						_tmp64_ = TRUE;
						while (TRUE) {
							SudokuBoard* _tmp66_;
							SudokuBoard* _tmp67_;
							gint _tmp68_;
							gint _tmp69_;
							SudokuCell* cell = NULL;
							SudokuCell* _tmp70_;
							SudokuCell* _tmp71_;
							gboolean _tmp72_;
							gboolean _tmp73_;
							GtkGrid** _tmp74_;
							gint _tmp74__length1;
							gint _tmp74__length2;
							SudokuBoard* _tmp75_;
							SudokuBoard* _tmp76_;
							gint _tmp77_;
							gint _tmp78_;
							SudokuBoard* _tmp79_;
							SudokuBoard* _tmp80_;
							gint _tmp81_;
							gint _tmp82_;
							GtkGrid* _tmp83_;
							SudokuCell* _tmp84_;
							SudokuBoard* _tmp85_;
							SudokuBoard* _tmp86_;
							gint _tmp87_;
							gint _tmp88_;
							SudokuBoard* _tmp89_;
							SudokuBoard* _tmp90_;
							gint _tmp91_;
							gint _tmp92_;
							SudokuCell** _tmp93_;
							gint _tmp93__length1;
							gint _tmp93__length2;
							SudokuCell* _tmp94_;
							SudokuCell* _tmp95_;
							if (!_tmp64_) {
								gint _tmp65_;
								_tmp65_ = col;
								col = _tmp65_ + 1;
							}
							_tmp64_ = FALSE;
							_tmp66_ = sudoku_game_get_board (game);
							_tmp67_ = _tmp66_;
							_tmp68_ = sudoku_board_get_cols (_tmp67_);
							_tmp69_ = _tmp68_;
							if (!(col < _tmp69_)) {
								break;
							}
							_tmp70_ = sudoku_cell_new (row, col, game, self);
							g_object_ref_sink (_tmp70_);
							cell = _tmp70_;
							_tmp71_ = cell;
							_tmp72_ = sudoku_view_get_show_possibilities (self);
							_tmp73_ = _tmp72_;
							sudoku_cell_initialize_earmarks (_tmp71_, _tmp73_, FALSE);
							_tmp74_ = blocks;
							_tmp74__length1 = blocks_length1;
							_tmp74__length2 = blocks_length2;
							_tmp75_ = sudoku_game_get_board (game);
							_tmp76_ = _tmp75_;
							_tmp77_ = sudoku_board_get_block_rows (_tmp76_);
							_tmp78_ = _tmp77_;
							_tmp79_ = sudoku_game_get_board (game);
							_tmp80_ = _tmp79_;
							_tmp81_ = sudoku_board_get_block_cols (_tmp80_);
							_tmp82_ = _tmp81_;
							_tmp83_ = _tmp74_[((row / _tmp78_) * _tmp74__length2) + (col / _tmp82_)];
							_tmp84_ = cell;
							_tmp85_ = sudoku_game_get_board (game);
							_tmp86_ = _tmp85_;
							_tmp87_ = sudoku_board_get_block_cols (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp89_ = sudoku_game_get_board (game);
							_tmp90_ = _tmp89_;
							_tmp91_ = sudoku_board_get_block_rows (_tmp90_);
							_tmp92_ = _tmp91_;
							gtk_grid_attach (_tmp83_, (GtkWidget*) _tmp84_, col % _tmp88_, row % _tmp92_, 1, 1);
							_tmp93_ = self->priv->cells;
							_tmp93__length1 = self->priv->cells_length1;
							_tmp93__length2 = self->priv->cells_length2;
							_tmp94_ = cell;
							_tmp95_ = _g_object_ref0 (_tmp94_);
							_g_object_unref0 (_tmp93_[(row * _tmp93__length2) + col]);
							_tmp93_[(row * _tmp93__length2) + col] = _tmp95_;
							_g_object_unref0 (cell);
						}
					}
				}
			}
		}
	}
	_tmp96_ = self->priv->game;
	_tmp97_ = sudoku_game_get_board (_tmp96_);
	_tmp98_ = _tmp97_;
	g_signal_connect_object (_tmp98_, "cell-changed", (GCallback) _sudoku_view_cell_changed_cb_sudoku_board_cell_changed, self, 0);
	_tmp99_ = self->priv->game;
	_tmp100_ = sudoku_game_get_board (_tmp99_);
	_tmp101_ = _tmp100_;
	g_signal_connect_object (_tmp101_, "earmark-changed", (GCallback) _sudoku_view_earmark_changed_cb_sudoku_board_earmark_changed, self, 0);
	g_signal_connect_object (self, "selection-changed", (GCallback) _sudoku_view_selection_changed_cb_sudoku_view_selection_changed, self, 0);
	sudoku_view_update_warnings (self);
	blocks = (_vala_array_free (blocks, blocks_length1 * blocks_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (grid);
	_g_object_unref0 (overlay);
	return self;
}

SudokuView*
sudoku_view_new (SudokuGame* game,
                 GSettings* settings)
{
	return sudoku_view_construct (TYPE_SUDOKU_VIEW, game, settings);
}

static void
sudoku_view_selection_changed_cb (SudokuView* self,
                                  gint old_row,
                                  gint old_col,
                                  gint new_row,
                                  gint new_col)
{
	SudokuCell** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	SudokuCell* _tmp1_;
	g_return_if_fail (self != NULL);
	sudoku_view_set_cell_highlighter (self, old_row, old_col, FALSE);
	sudoku_view_set_cell_highlighter (self, new_row, new_col, TRUE);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(old_row * _tmp0__length2) + old_col];
	sudoku_cell_dismiss_popover (_tmp1_);
}

static void
sudoku_view_cell_changed_cb (SudokuView* self,
                             gint row,
                             gint col,
                             gint old_val,
                             gint new_val)
{
	SudokuCell** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	SudokuCell* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	SudokuCell** _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	SudokuCell* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	g_object_get ((GtkWidget*) _tmp1_, "has-focus", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		SudokuCell** _tmp4_;
		gint _tmp4__length1;
		gint _tmp4__length2;
		SudokuCell* _tmp5_;
		_tmp4_ = self->priv->cells;
		_tmp4__length1 = self->priv->cells_length1;
		_tmp4__length2 = self->priv->cells_length2;
		_tmp5_ = _tmp4_[(row * _tmp4__length2) + col];
		gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
	}
	_tmp6_ = self->priv->cells;
	_tmp6__length1 = self->priv->cells_length1;
	_tmp6__length2 = self->priv->cells_length2;
	_tmp7_ = _tmp6_[(row * _tmp6__length2) + col];
	sudoku_cell_update_value (_tmp7_);
	sudoku_view_update_warnings (self);
	sudoku_view_set_value_highlighter (self, old_val, FALSE);
	sudoku_view_set_value_highlighter (self, new_val, TRUE);
}

static void
sudoku_view_earmark_changed_cb (SudokuView* self,
                                gint row,
                                gint col,
                                gint num,
                                gboolean enabled)
{
	SudokuCell** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	SudokuCell* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	SudokuCell** _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	SudokuCell* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	g_object_get ((GtkWidget*) _tmp1_, "has-focus", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (!_tmp3_) {
		SudokuCell** _tmp4_;
		gint _tmp4__length1;
		gint _tmp4__length2;
		SudokuCell* _tmp5_;
		_tmp4_ = self->priv->cells;
		_tmp4__length1 = self->priv->cells_length1;
		_tmp4__length2 = self->priv->cells_length2;
		_tmp5_ = _tmp4_[(row * _tmp4__length2) + col];
		gtk_widget_grab_focus ((GtkWidget*) _tmp5_);
	}
	_tmp6_ = self->priv->cells;
	_tmp6__length1 = self->priv->cells_length1;
	_tmp6__length2 = self->priv->cells_length2;
	_tmp7_ = _tmp6_[(row * _tmp6__length2) + col];
	sudoku_cell_update_earmark (_tmp7_, num);
	if (enabled) {
		SudokuCell** _tmp8_;
		gint _tmp8__length1;
		gint _tmp8__length2;
		SudokuCell* _tmp9_;
		_tmp8_ = self->priv->cells;
		_tmp8__length1 = self->priv->cells_length1;
		_tmp8__length2 = self->priv->cells_length2;
		_tmp9_ = _tmp8_[(row * _tmp8__length2) + col];
		sudoku_cell_check_earmark_warnings (_tmp9_, num);
	}
}

static void
sudoku_view_set_cell_highlighter (SudokuView* self,
                                  gint row,
                                  gint col,
                                  gboolean enabled)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	SudokuCell* cell = NULL;
	SudokuCell** _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	SudokuCell* _tmp3_;
	SudokuCell* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_view_get_highlighter (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->cells;
	_tmp2__length1 = self->priv->cells_length1;
	_tmp2__length2 = self->priv->cells_length2;
	_tmp3_ = _tmp2_[(row * _tmp2__length2) + col];
	_tmp4_ = _g_object_ref0 (_tmp3_);
	cell = _tmp4_;
	{
		gint col_tmp = 0;
		col_tmp = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp7_;
				SudokuBoard* _tmp8_;
				SudokuBoard* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = col_tmp;
					col_tmp = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = self->priv->game;
				_tmp8_ = sudoku_game_get_board (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = sudoku_board_get_cols (_tmp9_);
				_tmp11_ = _tmp10_;
				if (!(col_tmp < _tmp11_)) {
					break;
				}
				{
					gint row_tmp = 0;
					row_tmp = 0;
					{
						gboolean _tmp12_ = FALSE;
						_tmp12_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp14_;
							SudokuBoard* _tmp15_;
							SudokuBoard* _tmp16_;
							gint _tmp17_;
							gint _tmp18_;
							SudokuCell* cell_tmp = NULL;
							SudokuCell** _tmp19_;
							gint _tmp19__length1;
							gint _tmp19__length2;
							SudokuCell* _tmp20_;
							SudokuCell* _tmp21_;
							SudokuCell* _tmp22_;
							SudokuCell* _tmp23_;
							SudokuCell* _tmp24_;
							gint _tmp25_;
							gint _tmp26_;
							gboolean _tmp41_ = FALSE;
							SudokuCell* _tmp42_;
							gboolean _tmp43_;
							gboolean _tmp44_;
							if (!_tmp12_) {
								gint _tmp13_;
								_tmp13_ = row_tmp;
								row_tmp = _tmp13_ + 1;
							}
							_tmp12_ = FALSE;
							_tmp14_ = self->priv->game;
							_tmp15_ = sudoku_game_get_board (_tmp14_);
							_tmp16_ = _tmp15_;
							_tmp17_ = sudoku_board_get_rows (_tmp16_);
							_tmp18_ = _tmp17_;
							if (!(row_tmp < _tmp18_)) {
								break;
							}
							_tmp19_ = self->priv->cells;
							_tmp19__length1 = self->priv->cells_length1;
							_tmp19__length2 = self->priv->cells_length2;
							_tmp20_ = _tmp19_[(row_tmp * _tmp19__length2) + col_tmp];
							_tmp21_ = _g_object_ref0 (_tmp20_);
							cell_tmp = _tmp21_;
							_tmp22_ = cell;
							_tmp23_ = cell_tmp;
							if (_tmp22_ == _tmp23_) {
								_g_object_unref0 (cell_tmp);
								continue;
							}
							_tmp24_ = cell;
							_tmp25_ = sudoku_cell_get_value (_tmp24_);
							_tmp26_ = _tmp25_;
							if (_tmp26_ > 0) {
								SudokuCell* _tmp27_;
								gint _tmp28_;
								gint _tmp29_;
								SudokuCell* _tmp30_;
								gint _tmp31_;
								gint _tmp32_;
								_tmp27_ = cell;
								_tmp28_ = sudoku_cell_get_value (_tmp27_);
								_tmp29_ = _tmp28_;
								_tmp30_ = cell_tmp;
								_tmp31_ = sudoku_cell_get_value (_tmp30_);
								_tmp32_ = _tmp31_;
								if (_tmp29_ == _tmp32_) {
									SudokuCell* _tmp33_;
									_tmp33_ = cell_tmp;
									sudoku_cell_set_highlighted_value (_tmp33_, enabled);
								} else {
									SudokuCell* _tmp34_;
									gint _tmp35_;
									gint _tmp36_;
									_tmp34_ = cell_tmp;
									_tmp35_ = sudoku_cell_get_value (_tmp34_);
									_tmp36_ = _tmp35_;
									if (_tmp36_ == 0) {
										SudokuCell* _tmp37_;
										SudokuCell* _tmp38_;
										gint _tmp39_;
										gint _tmp40_;
										_tmp37_ = cell_tmp;
										_tmp38_ = cell;
										_tmp39_ = sudoku_cell_get_value (_tmp38_);
										_tmp40_ = _tmp39_;
										sudoku_cell_set_earmark_highlight (_tmp37_, _tmp40_, enabled);
									}
								}
							}
							_tmp42_ = cell_tmp;
							_tmp43_ = sudoku_cell_get_is_fixed (_tmp42_);
							_tmp44_ = _tmp43_;
							if (!_tmp44_) {
								gboolean _tmp45_ = FALSE;
								gboolean _tmp46_ = FALSE;
								if (row_tmp == row) {
									_tmp46_ = TRUE;
								} else {
									_tmp46_ = col_tmp == col;
								}
								if (_tmp46_) {
									_tmp45_ = TRUE;
								} else {
									gboolean _tmp47_ = FALSE;
									SudokuGame* _tmp48_;
									SudokuBoard* _tmp49_;
									SudokuBoard* _tmp50_;
									gint _tmp51_;
									gint _tmp52_;
									SudokuGame* _tmp53_;
									SudokuBoard* _tmp54_;
									SudokuBoard* _tmp55_;
									gint _tmp56_;
									gint _tmp57_;
									_tmp48_ = self->priv->game;
									_tmp49_ = sudoku_game_get_board (_tmp48_);
									_tmp50_ = _tmp49_;
									_tmp51_ = sudoku_board_get_block_cols (_tmp50_);
									_tmp52_ = _tmp51_;
									_tmp53_ = self->priv->game;
									_tmp54_ = sudoku_game_get_board (_tmp53_);
									_tmp55_ = _tmp54_;
									_tmp56_ = sudoku_board_get_block_cols (_tmp55_);
									_tmp57_ = _tmp56_;
									if ((row_tmp / _tmp52_) == (row / _tmp57_)) {
										SudokuGame* _tmp58_;
										SudokuBoard* _tmp59_;
										SudokuBoard* _tmp60_;
										gint _tmp61_;
										gint _tmp62_;
										SudokuGame* _tmp63_;
										SudokuBoard* _tmp64_;
										SudokuBoard* _tmp65_;
										gint _tmp66_;
										gint _tmp67_;
										_tmp58_ = self->priv->game;
										_tmp59_ = sudoku_game_get_board (_tmp58_);
										_tmp60_ = _tmp59_;
										_tmp61_ = sudoku_board_get_block_rows (_tmp60_);
										_tmp62_ = _tmp61_;
										_tmp63_ = self->priv->game;
										_tmp64_ = sudoku_game_get_board (_tmp63_);
										_tmp65_ = _tmp64_;
										_tmp66_ = sudoku_board_get_block_rows (_tmp65_);
										_tmp67_ = _tmp66_;
										_tmp47_ = (col_tmp / _tmp62_) == (col / _tmp67_);
									} else {
										_tmp47_ = FALSE;
									}
									_tmp45_ = _tmp47_;
								}
								_tmp41_ = _tmp45_;
							} else {
								_tmp41_ = FALSE;
							}
							if (_tmp41_) {
								SudokuCell* _tmp68_;
								_tmp68_ = cell_tmp;
								sudoku_cell_set_highlighted_background (_tmp68_, enabled);
							}
							_g_object_unref0 (cell_tmp);
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (cell);
}

static void
sudoku_view_set_value_highlighter (SudokuView* self,
                                   gint val,
                                   gboolean enabled)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	SudokuCell* cell = NULL;
	SudokuCell** _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	gint _tmp4_;
	gint _tmp5_;
	SudokuCell* _tmp6_;
	SudokuCell* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp1_ = sudoku_view_get_highlighter (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = val == 0;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = self->priv->cells;
	_tmp3__length1 = self->priv->cells_length1;
	_tmp3__length2 = self->priv->cells_length2;
	_tmp4_ = self->priv->_selected_row;
	_tmp5_ = self->priv->_selected_col;
	_tmp6_ = _tmp3_[(_tmp4_ * _tmp3__length2) + _tmp5_];
	_tmp7_ = _g_object_ref0 (_tmp6_);
	cell = _tmp7_;
	{
		gint col_tmp = 0;
		col_tmp = 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp10_;
				SudokuBoard* _tmp11_;
				SudokuBoard* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = col_tmp;
					col_tmp = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = self->priv->game;
				_tmp11_ = sudoku_game_get_board (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = sudoku_board_get_cols (_tmp12_);
				_tmp14_ = _tmp13_;
				if (!(col_tmp < _tmp14_)) {
					break;
				}
				{
					gint row_tmp = 0;
					row_tmp = 0;
					{
						gboolean _tmp15_ = FALSE;
						_tmp15_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp17_;
							SudokuBoard* _tmp18_;
							SudokuBoard* _tmp19_;
							gint _tmp20_;
							gint _tmp21_;
							SudokuCell* cell_tmp = NULL;
							SudokuCell** _tmp22_;
							gint _tmp22__length1;
							gint _tmp22__length2;
							SudokuCell* _tmp23_;
							SudokuCell* _tmp24_;
							SudokuCell* _tmp25_;
							SudokuCell* _tmp26_;
							SudokuCell* _tmp27_;
							gint _tmp28_;
							gint _tmp29_;
							if (!_tmp15_) {
								gint _tmp16_;
								_tmp16_ = row_tmp;
								row_tmp = _tmp16_ + 1;
							}
							_tmp15_ = FALSE;
							_tmp17_ = self->priv->game;
							_tmp18_ = sudoku_game_get_board (_tmp17_);
							_tmp19_ = _tmp18_;
							_tmp20_ = sudoku_board_get_rows (_tmp19_);
							_tmp21_ = _tmp20_;
							if (!(row_tmp < _tmp21_)) {
								break;
							}
							_tmp22_ = self->priv->cells;
							_tmp22__length1 = self->priv->cells_length1;
							_tmp22__length2 = self->priv->cells_length2;
							_tmp23_ = _tmp22_[(row_tmp * _tmp22__length2) + col_tmp];
							_tmp24_ = _g_object_ref0 (_tmp23_);
							cell_tmp = _tmp24_;
							_tmp25_ = cell;
							_tmp26_ = cell_tmp;
							if (_tmp25_ == _tmp26_) {
								_g_object_unref0 (cell_tmp);
								continue;
							}
							_tmp27_ = cell_tmp;
							_tmp28_ = sudoku_cell_get_value (_tmp27_);
							_tmp29_ = _tmp28_;
							if (val == _tmp29_) {
								SudokuCell* _tmp30_;
								_tmp30_ = cell_tmp;
								sudoku_cell_set_highlighted_value (_tmp30_, enabled);
							} else {
								SudokuCell* _tmp31_;
								gint _tmp32_;
								gint _tmp33_;
								_tmp31_ = cell_tmp;
								_tmp32_ = sudoku_cell_get_value (_tmp31_);
								_tmp33_ = _tmp32_;
								if (_tmp33_ == 0) {
									SudokuCell* _tmp34_;
									_tmp34_ = cell_tmp;
									sudoku_cell_set_earmark_highlight (_tmp34_, val, enabled);
								}
							}
							_g_object_unref0 (cell_tmp);
						}
					}
				}
			}
		}
	}
	_g_object_unref0 (cell);
}

static void
sudoku_view_update_warnings (SudokuView* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_view_get_show_warnings (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp4_;
				SudokuBoard* _tmp5_;
				SudokuBoard* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = col;
					col = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = self->priv->game;
				_tmp5_ = sudoku_game_get_board (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = sudoku_board_get_cols (_tmp6_);
				_tmp8_ = _tmp7_;
				if (!(col < _tmp8_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp11_;
							SudokuBoard* _tmp12_;
							SudokuBoard* _tmp13_;
							gint _tmp14_;
							gint _tmp15_;
							SudokuCell** _tmp16_;
							gint _tmp16__length1;
							gint _tmp16__length2;
							SudokuCell* _tmp17_;
							gboolean _tmp18_;
							gboolean _tmp19_;
							SudokuCell** _tmp20_;
							gint _tmp20__length1;
							gint _tmp20__length2;
							SudokuCell* _tmp21_;
							if (!_tmp9_) {
								gint _tmp10_;
								_tmp10_ = row;
								row = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = self->priv->game;
							_tmp12_ = sudoku_game_get_board (_tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = sudoku_board_get_rows (_tmp13_);
							_tmp15_ = _tmp14_;
							if (!(row < _tmp15_)) {
								break;
							}
							_tmp16_ = self->priv->cells;
							_tmp16__length1 = self->priv->cells_length1;
							_tmp16__length2 = self->priv->cells_length2;
							_tmp17_ = _tmp16_[(row * _tmp16__length2) + col];
							_tmp18_ = sudoku_view_get_show_extra_warnings (self);
							_tmp19_ = _tmp18_;
							sudoku_cell_check_value_warnings (_tmp17_, _tmp19_);
							_tmp20_ = self->priv->cells;
							_tmp20__length1 = self->priv->cells_length1;
							_tmp20__length2 = self->priv->cells_length2;
							_tmp21_ = _tmp20_[(row * _tmp20__length2) + col];
							sudoku_cell_check_earmarks_warnings (_tmp21_);
						}
					}
				}
			}
		}
	}
}

void
sudoku_view_clear (SudokuView* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp2_;
				SudokuBoard* _tmp3_;
				SudokuBoard* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->game;
				_tmp3_ = sudoku_game_get_board (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(i < _tmp6_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp9_;
							SudokuBoard* _tmp10_;
							SudokuBoard* _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							SudokuGame* _tmp14_;
							SudokuBoard* _tmp15_;
							SudokuBoard* _tmp16_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = j;
								j = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = self->priv->game;
							_tmp10_ = sudoku_game_get_board (_tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(j < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->game;
							_tmp15_ = sudoku_game_get_board (_tmp14_);
							_tmp16_ = _tmp15_;
							sudoku_board_disable_all_earmarks (_tmp16_, i, j);
						}
					}
				}
			}
		}
	}
}

static void
sudoku_view_clear_all_warnings (SudokuView* self)
{
	g_return_if_fail (self != NULL);
	{
		gint col_tmp = 0;
		col_tmp = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp2_;
				SudokuBoard* _tmp3_;
				SudokuBoard* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = col_tmp;
					col_tmp = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->game;
				_tmp3_ = sudoku_game_get_board (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = sudoku_board_get_cols (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(col_tmp < _tmp6_)) {
					break;
				}
				{
					gint row_tmp = 0;
					row_tmp = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp9_;
							SudokuBoard* _tmp10_;
							SudokuBoard* _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							SudokuCell** _tmp14_;
							gint _tmp14__length1;
							gint _tmp14__length2;
							SudokuCell* _tmp15_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = row_tmp;
								row_tmp = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = self->priv->game;
							_tmp10_ = sudoku_game_get_board (_tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = sudoku_board_get_rows (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(row_tmp < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->cells;
							_tmp14__length1 = self->priv->cells_length1;
							_tmp14__length2 = self->priv->cells_length2;
							_tmp15_ = _tmp14_[(row_tmp * _tmp14__length2) + col_tmp];
							sudoku_cell_clear_warnings (_tmp15_);
						}
					}
				}
			}
		}
	}
}

static void
sudoku_view_mask_view (SudokuView* self)
{
	g_return_if_fail (self != NULL);
	{
		gint col_tmp = 0;
		col_tmp = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp2_;
				SudokuBoard* _tmp3_;
				SudokuBoard* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = col_tmp;
					col_tmp = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->game;
				_tmp3_ = sudoku_game_get_board (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = sudoku_board_get_cols (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(col_tmp < _tmp6_)) {
					break;
				}
				{
					gint row_tmp = 0;
					row_tmp = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp9_;
							SudokuBoard* _tmp10_;
							SudokuBoard* _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							SudokuCell** _tmp14_;
							gint _tmp14__length1;
							gint _tmp14__length2;
							SudokuCell* _tmp15_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = row_tmp;
								row_tmp = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = self->priv->game;
							_tmp10_ = sudoku_game_get_board (_tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = sudoku_board_get_rows (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(row_tmp < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->cells;
							_tmp14__length1 = self->priv->cells_length1;
							_tmp14__length2 = self->priv->cells_length2;
							_tmp15_ = _tmp14_[(row_tmp * _tmp14__length2) + col_tmp];
							sudoku_cell_set_paused (_tmp15_, TRUE);
						}
					}
				}
			}
		}
	}
}

static void
sudoku_view_unmask_view (SudokuView* self)
{
	g_return_if_fail (self != NULL);
	{
		gint col_tmp = 0;
		col_tmp = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp2_;
				SudokuBoard* _tmp3_;
				SudokuBoard* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = col_tmp;
					col_tmp = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->game;
				_tmp3_ = sudoku_game_get_board (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = sudoku_board_get_cols (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(col_tmp < _tmp6_)) {
					break;
				}
				{
					gint row_tmp = 0;
					row_tmp = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp9_;
							SudokuBoard* _tmp10_;
							SudokuBoard* _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							SudokuCell** _tmp14_;
							gint _tmp14__length1;
							gint _tmp14__length2;
							SudokuCell* _tmp15_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = row_tmp;
								row_tmp = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = self->priv->game;
							_tmp10_ = sudoku_game_get_board (_tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = sudoku_board_get_rows (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(row_tmp < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->cells;
							_tmp14__length1 = self->priv->cells_length1;
							_tmp14__length2 = self->priv->cells_length2;
							_tmp15_ = _tmp14_[(row_tmp * _tmp14__length2) + col_tmp];
							sudoku_cell_set_paused (_tmp15_, FALSE);
						}
					}
				}
			}
		}
	}
}

void
sudoku_view_dismiss_popovers (SudokuView* self)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp2_;
				SudokuBoard* _tmp3_;
				SudokuBoard* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->game;
				_tmp3_ = sudoku_game_get_board (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(i < _tmp6_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp9_;
							SudokuBoard* _tmp10_;
							SudokuBoard* _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							SudokuCell** _tmp14_;
							gint _tmp14__length1;
							gint _tmp14__length2;
							SudokuCell* _tmp15_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = j;
								j = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = self->priv->game;
							_tmp10_ = sudoku_game_get_board (_tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(j < _tmp13_)) {
								break;
							}
							_tmp14_ = self->priv->cells;
							_tmp14__length1 = self->priv->cells_length1;
							_tmp14__length2 = self->priv->cells_length2;
							_tmp15_ = _tmp14_[(i * _tmp14__length2) + j];
							sudoku_cell_dismiss_popover (_tmp15_);
						}
					}
				}
			}
		}
	}
}

static void
sudoku_view_real_dispose (GObject* base)
{
	SudokuView * self;
	SudokuFrame* _tmp0_;
	self = (SudokuView*) base;
	_tmp0_ = self->priv->frame;
	gtk_widget_unparent ((GtkWidget*) _tmp0_);
	G_OBJECT_CLASS (sudoku_view_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_bin_get_type (), AdwBin));
}

gint
sudoku_view_get_selected_row (SudokuView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_selected_row;
	return result;
}

static void
sudoku_view_set_selected_row (SudokuView* self,
                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_view_get_selected_row (self);
	if (old_value != value) {
		self->priv->_selected_row = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_SELECTED_ROW_PROPERTY]);
	}
}

gint
sudoku_view_get_selected_col (SudokuView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_selected_col;
	return result;
}

static void
sudoku_view_set_selected_col (SudokuView* self,
                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_view_get_selected_col (self);
	if (old_value != value) {
		self->priv->_selected_col = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_SELECTED_COL_PROPERTY]);
	}
}

gboolean
sudoku_view_get_show_warnings (SudokuView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_warnings;
	return result;
}

void
sudoku_view_set_show_warnings (SudokuView* self,
                               gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	self->priv->_show_warnings = value;
	_tmp0_ = sudoku_view_get_show_warnings (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		sudoku_view_update_warnings (self);
	} else {
		sudoku_view_clear_all_warnings (self);
	}
	_tmp2_ = self->priv->_selected_row;
	_tmp3_ = self->priv->_selected_col;
	sudoku_view_set_cell_highlighter (self, _tmp2_, _tmp3_, TRUE);
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY]);
}

gboolean
sudoku_view_get_show_extra_warnings (SudokuView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_extra_warnings;
	return result;
}

void
sudoku_view_set_show_extra_warnings (SudokuView* self,
                                     gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_show_extra_warnings = value;
	_tmp0_ = sudoku_view_get_show_warnings (self);
	_tmp1_ = _tmp0_;
	sudoku_view_set_show_warnings (self, _tmp1_);
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_SHOW_EXTRA_WARNINGS_PROPERTY]);
}

gboolean
sudoku_view_get_show_possibilities (SudokuView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_possibilities;
	return result;
}

void
sudoku_view_set_show_possibilities (SudokuView* self,
                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_show_possibilities = value;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp2_;
				SudokuBoard* _tmp3_;
				SudokuBoard* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = row;
					row = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->game;
				_tmp3_ = sudoku_game_get_board (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(row < _tmp6_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp9_;
							SudokuBoard* _tmp10_;
							SudokuBoard* _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							gboolean _tmp14_;
							gboolean _tmp15_;
							if (!_tmp7_) {
								gint _tmp8_;
								_tmp8_ = col;
								col = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = self->priv->game;
							_tmp10_ = sudoku_game_get_board (_tmp9_);
							_tmp11_ = _tmp10_;
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
							_tmp13_ = _tmp12_;
							if (!(col < _tmp13_)) {
								break;
							}
							_tmp14_ = sudoku_view_get_show_possibilities (self);
							_tmp15_ = _tmp14_;
							if (_tmp15_) {
								SudokuCell** _tmp16_;
								gint _tmp16__length1;
								gint _tmp16__length2;
								SudokuCell* _tmp17_;
								gboolean _tmp18_;
								gboolean _tmp19_;
								_tmp16_ = self->priv->cells;
								_tmp16__length1 = self->priv->cells_length1;
								_tmp16__length2 = self->priv->cells_length2;
								_tmp17_ = _tmp16_[(row * _tmp16__length2) + col];
								_tmp18_ = sudoku_view_get_show_possibilities (self);
								_tmp19_ = _tmp18_;
								sudoku_cell_initialize_earmarks (_tmp17_, _tmp19_, TRUE);
							} else {
								SudokuGame* _tmp20_;
								_tmp20_ = self->priv->game;
								sudoku_game_disable_all_earmarks (_tmp20_, row, col);
							}
						}
					}
				}
			}
		}
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY]);
}

gboolean
sudoku_view_get_highlighter (SudokuView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_highlighter;
	return result;
}

void
sudoku_view_set_highlighter (SudokuView* self,
                             gboolean value)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_selected_row;
	_tmp1_ = self->priv->_selected_col;
	sudoku_view_set_cell_highlighter (self, _tmp0_, _tmp1_, FALSE);
	self->priv->_highlighter = value;
	_tmp2_ = self->priv->_selected_row;
	_tmp3_ = self->priv->_selected_col;
	sudoku_view_set_cell_highlighter (self, _tmp2_, _tmp3_, TRUE);
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_HIGHLIGHTER_PROPERTY]);
}

gboolean
sudoku_view_get_has_selection (SudokuView* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_has_selection;
	return result;
}

void
sudoku_view_set_has_selection (SudokuView* self,
                               gboolean value)
{
	SudokuCell* cell = NULL;
	SudokuCell** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint _tmp2_;
	SudokuCell* _tmp3_;
	SudokuCell* _tmp4_;
	SudokuCell* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gint _tmp12_;
	gint _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	g_return_if_fail (self != NULL);
	self->priv->_has_selection = value;
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = self->priv->_selected_row;
	_tmp2_ = self->priv->_selected_col;
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp4_ = _g_object_ref0 (_tmp3_);
	cell = _tmp4_;
	_tmp5_ = cell;
	_tmp6_ = sudoku_view_get_has_selection (self);
	_tmp7_ = _tmp6_;
	sudoku_cell_set_selected (_tmp5_, _tmp7_);
	_tmp8_ = sudoku_view_get_has_selection (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		SudokuCell* _tmp10_;
		_tmp10_ = cell;
		gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
	} else {
		SudokuCell* _tmp11_;
		_tmp11_ = cell;
		sudoku_cell_dismiss_popover (_tmp11_);
	}
	_tmp12_ = self->priv->_selected_row;
	_tmp13_ = self->priv->_selected_col;
	_tmp14_ = sudoku_view_get_has_selection (self);
	_tmp15_ = _tmp14_;
	sudoku_view_set_cell_highlighter (self, _tmp12_, _tmp13_, _tmp15_);
	_g_object_unref0 (cell);
	g_object_notify_by_pspec ((GObject *) self, sudoku_view_properties[SUDOKU_VIEW_HAS_SELECTION_PROPERTY]);
}

static void
g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
}

static gboolean
_sudoku_view___lambda9_ (GtkWidget* _self_)
{
	SudokuView* view = NULL;
	SudokuView* _tmp0_;
	gboolean _tmp1_ = FALSE;
	SudokuView* _tmp2_;
	gint _tmp3_;
	SudokuView* _tmp6_;
	gint _tmp7_;
	gboolean result;
	g_return_val_if_fail (_self_ != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_self_, TYPE_SUDOKU_VIEW, SudokuView));
	view = _tmp0_;
	_tmp2_ = view;
	_tmp3_ = _tmp2_->priv->_selected_row;
	if (_tmp3_ == -1) {
		_tmp1_ = TRUE;
	} else {
		SudokuView* _tmp4_;
		gint _tmp5_;
		_tmp4_ = view;
		_tmp5_ = _tmp4_->priv->_selected_col;
		_tmp1_ = _tmp5_ == -1;
	}
	if (_tmp1_) {
		result = GDK_EVENT_PROPAGATE;
		_g_object_unref0 (view);
		return result;
	}
	_tmp6_ = view;
	_tmp7_ = _tmp6_->priv->_selected_row;
	if (_tmp7_ == 0) {
		SudokuView* _tmp8_;
		SudokuCell** _tmp9_;
		gint _tmp9__length1;
		gint _tmp9__length2;
		SudokuView* _tmp10_;
		gint _tmp11_;
		SudokuCell* _tmp12_;
		_tmp8_ = view;
		_tmp9_ = _tmp8_->priv->cells;
		_tmp9__length1 = _tmp8_->priv->cells_length1;
		_tmp9__length2 = _tmp8_->priv->cells_length2;
		_tmp10_ = view;
		_tmp11_ = _tmp10_->priv->_selected_col;
		_tmp12_ = _tmp9_[(8 * _tmp9__length2) + _tmp11_];
		gtk_widget_grab_focus ((GtkWidget*) _tmp12_);
	} else {
		SudokuView* _tmp13_;
		SudokuCell** _tmp14_;
		gint _tmp14__length1;
		gint _tmp14__length2;
		SudokuView* _tmp15_;
		gint _tmp16_;
		SudokuView* _tmp17_;
		gint _tmp18_;
		SudokuCell* _tmp19_;
		_tmp13_ = view;
		_tmp14_ = _tmp13_->priv->cells;
		_tmp14__length1 = _tmp13_->priv->cells_length1;
		_tmp14__length2 = _tmp13_->priv->cells_length2;
		_tmp15_ = view;
		_tmp16_ = _tmp15_->priv->_selected_row;
		_tmp17_ = view;
		_tmp18_ = _tmp17_->priv->_selected_col;
		_tmp19_ = _tmp14_[((_tmp16_ - 1) * _tmp14__length2) + _tmp18_];
		gtk_widget_grab_focus ((GtkWidget*) _tmp19_);
	}
	result = GDK_EVENT_STOP;
	_g_object_unref0 (view);
	return result;
}

static gboolean
__sudoku_view___lambda9__gtk_shortcut_func (GtkWidget* widget,
                                            GVariant* args,
                                            gpointer self)
{
	gboolean result;
	result = _sudoku_view___lambda9_ (widget);
	return result;
}

static gboolean
_sudoku_view___lambda10_ (GtkWidget* _self_)
{
	SudokuView* view = NULL;
	SudokuView* _tmp0_;
	gboolean _tmp1_ = FALSE;
	SudokuView* _tmp2_;
	gint _tmp3_;
	SudokuView* _tmp6_;
	gint _tmp7_;
	gboolean result;
	g_return_val_if_fail (_self_ != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_self_, TYPE_SUDOKU_VIEW, SudokuView));
	view = _tmp0_;
	_tmp2_ = view;
	_tmp3_ = _tmp2_->priv->_selected_row;
	if (_tmp3_ == -1) {
		_tmp1_ = TRUE;
	} else {
		SudokuView* _tmp4_;
		gint _tmp5_;
		_tmp4_ = view;
		_tmp5_ = _tmp4_->priv->_selected_col;
		_tmp1_ = _tmp5_ == -1;
	}
	if (_tmp1_) {
		result = GDK_EVENT_PROPAGATE;
		_g_object_unref0 (view);
		return result;
	}
	_tmp6_ = view;
	_tmp7_ = _tmp6_->priv->_selected_row;
	if (_tmp7_ == 8) {
		SudokuView* _tmp8_;
		SudokuCell** _tmp9_;
		gint _tmp9__length1;
		gint _tmp9__length2;
		SudokuView* _tmp10_;
		gint _tmp11_;
		SudokuCell* _tmp12_;
		_tmp8_ = view;
		_tmp9_ = _tmp8_->priv->cells;
		_tmp9__length1 = _tmp8_->priv->cells_length1;
		_tmp9__length2 = _tmp8_->priv->cells_length2;
		_tmp10_ = view;
		_tmp11_ = _tmp10_->priv->_selected_col;
		_tmp12_ = _tmp9_[(0 * _tmp9__length2) + _tmp11_];
		gtk_widget_grab_focus ((GtkWidget*) _tmp12_);
	} else {
		SudokuView* _tmp13_;
		SudokuCell** _tmp14_;
		gint _tmp14__length1;
		gint _tmp14__length2;
		SudokuView* _tmp15_;
		gint _tmp16_;
		SudokuView* _tmp17_;
		gint _tmp18_;
		SudokuCell* _tmp19_;
		_tmp13_ = view;
		_tmp14_ = _tmp13_->priv->cells;
		_tmp14__length1 = _tmp13_->priv->cells_length1;
		_tmp14__length2 = _tmp13_->priv->cells_length2;
		_tmp15_ = view;
		_tmp16_ = _tmp15_->priv->_selected_row;
		_tmp17_ = view;
		_tmp18_ = _tmp17_->priv->_selected_col;
		_tmp19_ = _tmp14_[((_tmp16_ + 1) * _tmp14__length2) + _tmp18_];
		gtk_widget_grab_focus ((GtkWidget*) _tmp19_);
	}
	result = GDK_EVENT_STOP;
	_g_object_unref0 (view);
	return result;
}

static gboolean
__sudoku_view___lambda10__gtk_shortcut_func (GtkWidget* widget,
                                             GVariant* args,
                                             gpointer self)
{
	gboolean result;
	result = _sudoku_view___lambda10_ (widget);
	return result;
}

static gboolean
_sudoku_view___lambda11_ (GtkWidget* _self_)
{
	SudokuView* view = NULL;
	SudokuView* _tmp0_;
	gboolean _tmp1_ = FALSE;
	SudokuView* _tmp2_;
	gint _tmp3_;
	SudokuView* _tmp6_;
	gint _tmp7_;
	gboolean result;
	g_return_val_if_fail (_self_ != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_self_, TYPE_SUDOKU_VIEW, SudokuView));
	view = _tmp0_;
	_tmp2_ = view;
	_tmp3_ = _tmp2_->priv->_selected_row;
	if (_tmp3_ == -1) {
		_tmp1_ = TRUE;
	} else {
		SudokuView* _tmp4_;
		gint _tmp5_;
		_tmp4_ = view;
		_tmp5_ = _tmp4_->priv->_selected_col;
		_tmp1_ = _tmp5_ == -1;
	}
	if (_tmp1_) {
		result = GDK_EVENT_PROPAGATE;
		_g_object_unref0 (view);
		return result;
	}
	_tmp6_ = view;
	_tmp7_ = _tmp6_->priv->_selected_col;
	if (_tmp7_ == 0) {
		SudokuView* _tmp8_;
		SudokuCell** _tmp9_;
		gint _tmp9__length1;
		gint _tmp9__length2;
		SudokuView* _tmp10_;
		gint _tmp11_;
		SudokuCell* _tmp12_;
		_tmp8_ = view;
		_tmp9_ = _tmp8_->priv->cells;
		_tmp9__length1 = _tmp8_->priv->cells_length1;
		_tmp9__length2 = _tmp8_->priv->cells_length2;
		_tmp10_ = view;
		_tmp11_ = _tmp10_->priv->_selected_row;
		_tmp12_ = _tmp9_[(_tmp11_ * _tmp9__length2) + 8];
		gtk_widget_grab_focus ((GtkWidget*) _tmp12_);
	} else {
		SudokuView* _tmp13_;
		SudokuCell** _tmp14_;
		gint _tmp14__length1;
		gint _tmp14__length2;
		SudokuView* _tmp15_;
		gint _tmp16_;
		SudokuView* _tmp17_;
		gint _tmp18_;
		SudokuCell* _tmp19_;
		_tmp13_ = view;
		_tmp14_ = _tmp13_->priv->cells;
		_tmp14__length1 = _tmp13_->priv->cells_length1;
		_tmp14__length2 = _tmp13_->priv->cells_length2;
		_tmp15_ = view;
		_tmp16_ = _tmp15_->priv->_selected_row;
		_tmp17_ = view;
		_tmp18_ = _tmp17_->priv->_selected_col;
		_tmp19_ = _tmp14_[(_tmp16_ * _tmp14__length2) + (_tmp18_ - 1)];
		gtk_widget_grab_focus ((GtkWidget*) _tmp19_);
	}
	result = GDK_EVENT_STOP;
	_g_object_unref0 (view);
	return result;
}

static gboolean
__sudoku_view___lambda11__gtk_shortcut_func (GtkWidget* widget,
                                             GVariant* args,
                                             gpointer self)
{
	gboolean result;
	result = _sudoku_view___lambda11_ (widget);
	return result;
}

static gboolean
_sudoku_view___lambda12_ (GtkWidget* _self_)
{
	SudokuView* view = NULL;
	SudokuView* _tmp0_;
	gboolean _tmp1_ = FALSE;
	SudokuView* _tmp2_;
	gint _tmp3_;
	SudokuView* _tmp6_;
	gint _tmp7_;
	gboolean result;
	g_return_val_if_fail (_self_ != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_self_, TYPE_SUDOKU_VIEW, SudokuView));
	view = _tmp0_;
	_tmp2_ = view;
	_tmp3_ = _tmp2_->priv->_selected_row;
	if (_tmp3_ == -1) {
		_tmp1_ = TRUE;
	} else {
		SudokuView* _tmp4_;
		gint _tmp5_;
		_tmp4_ = view;
		_tmp5_ = _tmp4_->priv->_selected_col;
		_tmp1_ = _tmp5_ == -1;
	}
	if (_tmp1_) {
		result = GDK_EVENT_PROPAGATE;
		_g_object_unref0 (view);
		return result;
	}
	_tmp6_ = view;
	_tmp7_ = _tmp6_->priv->_selected_col;
	if (_tmp7_ == 8) {
		SudokuView* _tmp8_;
		SudokuCell** _tmp9_;
		gint _tmp9__length1;
		gint _tmp9__length2;
		SudokuView* _tmp10_;
		gint _tmp11_;
		SudokuCell* _tmp12_;
		_tmp8_ = view;
		_tmp9_ = _tmp8_->priv->cells;
		_tmp9__length1 = _tmp8_->priv->cells_length1;
		_tmp9__length2 = _tmp8_->priv->cells_length2;
		_tmp10_ = view;
		_tmp11_ = _tmp10_->priv->_selected_row;
		_tmp12_ = _tmp9_[(_tmp11_ * _tmp9__length2) + 0];
		gtk_widget_grab_focus ((GtkWidget*) _tmp12_);
	} else {
		SudokuView* _tmp13_;
		SudokuCell** _tmp14_;
		gint _tmp14__length1;
		gint _tmp14__length2;
		SudokuView* _tmp15_;
		gint _tmp16_;
		SudokuView* _tmp17_;
		gint _tmp18_;
		SudokuCell* _tmp19_;
		_tmp13_ = view;
		_tmp14_ = _tmp13_->priv->cells;
		_tmp14__length1 = _tmp13_->priv->cells_length1;
		_tmp14__length2 = _tmp13_->priv->cells_length2;
		_tmp15_ = view;
		_tmp16_ = _tmp15_->priv->_selected_row;
		_tmp17_ = view;
		_tmp18_ = _tmp17_->priv->_selected_col;
		_tmp19_ = _tmp14_[(_tmp16_ * _tmp14__length2) + (_tmp18_ + 1)];
		gtk_widget_grab_focus ((GtkWidget*) _tmp19_);
	}
	result = GDK_EVENT_STOP;
	_g_object_unref0 (view);
	return result;
}

static gboolean
__sudoku_view___lambda12__gtk_shortcut_func (GtkWidget* widget,
                                             GVariant* args,
                                             gpointer self)
{
	gboolean result;
	result = _sudoku_view___lambda12_ (widget);
	return result;
}

static void
sudoku_view_class_init (SudokuViewClass * klass,
                        gpointer klass_data)
{
	GtkShortcutFunc up_func = NULL;
	gpointer up_func_target;
	GDestroyNotify up_func_target_destroy_notify;
	GtkShortcutFunc down_func = NULL;
	gpointer down_func_target;
	GDestroyNotify down_func_target_destroy_notify;
	GtkShortcutFunc left_func = NULL;
	gpointer left_func_target;
	GDestroyNotify left_func_target_destroy_notify;
	GtkShortcutFunc right_func = NULL;
	gpointer right_func_target;
	GDestroyNotify right_func_target_destroy_notify;
	GtkShortcutFunc _tmp0_;
	gpointer _tmp0__target;
	GtkShortcutFunc _tmp1_;
	gpointer _tmp1__target;
	GtkShortcutFunc _tmp2_;
	gpointer _tmp2__target;
	GtkShortcutFunc _tmp3_;
	gpointer _tmp3__target;
	GtkShortcutFunc _tmp4_;
	gpointer _tmp4__target;
	GtkShortcutFunc _tmp5_;
	gpointer _tmp5__target;
	GtkShortcutFunc _tmp6_;
	gpointer _tmp6__target;
	GtkShortcutFunc _tmp7_;
	gpointer _tmp7__target;
	GtkShortcutFunc _tmp8_;
	gpointer _tmp8__target;
	GtkShortcutFunc _tmp9_;
	gpointer _tmp9__target;
	GtkShortcutFunc _tmp10_;
	gpointer _tmp10__target;
	GtkShortcutFunc _tmp11_;
	gpointer _tmp11__target;
	sudoku_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuView_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) sudoku_view_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SELECTED_ROW_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_SELECTED_ROW_PROPERTY] = g_param_spec_int ("selected-row", "selected-row", "selected-row", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SELECTED_COL_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_SELECTED_COL_PROPERTY] = g_param_spec_int ("selected-col", "selected-col", "selected-col", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY] = g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_EXTRA_WARNINGS_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_SHOW_EXTRA_WARNINGS_PROPERTY] = g_param_spec_boolean ("show-extra-warnings", "show-extra-warnings", "show-extra-warnings", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY] = g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_HIGHLIGHTER_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_HIGHLIGHTER_PROPERTY] = g_param_spec_boolean ("highlighter", "highlighter", "highlighter", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_HAS_SELECTION_PROPERTY, sudoku_view_properties[SUDOKU_VIEW_HAS_SELECTION_PROPERTY] = g_param_spec_boolean ("has-selection", "has-selection", "has-selection", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	sudoku_view_signals[SUDOKU_VIEW_SELECTION_CHANGED_SIGNAL] = g_signal_new ("selection-changed", TYPE_SUDOKU_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
	up_func = __sudoku_view___lambda9__gtk_shortcut_func;
	up_func_target = NULL;
	up_func_target_destroy_notify = NULL;
	down_func = __sudoku_view___lambda10__gtk_shortcut_func;
	down_func_target = NULL;
	down_func_target_destroy_notify = NULL;
	left_func = __sudoku_view___lambda11__gtk_shortcut_func;
	left_func_target = NULL;
	left_func_target_destroy_notify = NULL;
	right_func = __sudoku_view___lambda12__gtk_shortcut_func;
	right_func_target = NULL;
	right_func_target_destroy_notify = NULL;
	_tmp0_ = up_func;
	_tmp0__target = up_func_target;
	gtk_widget_class_add_binding (GTK_WIDGET_CLASS (klass), GDK_KEY_Up, 0, _tmp0_, _tmp0__target, NULL, NULL);
	_tmp1_ = up_func;
	_tmp1__target = up_func_target;
	gtk_widget_class_add_binding (GTK_WIDGET_CLASS (klass), GDK_KEY_KP_Up, 0, _tmp1_, _tmp1__target, NULL, NULL);
	_tmp2_ = up_func;
	_tmp2__target = up_func_target;
	gtk_widget_class_add_binding (GTK_WIDGET_CLASS (klass), GDK_KEY_w, 0, _tmp2_, _tmp2__target, NULL, NULL);
	_tmp3_ = down_func;
	_tmp3__target = down_func_target;
	gtk_widget_class_add_binding (GTK_WIDGET_CLASS (klass), GDK_KEY_Down, 0, _tmp3_, _tmp3__target, NULL, NULL);
	_tmp4_ = down_func;
	_tmp4__target = down_func_target;
	gtk_widget_class_add_binding (GTK_WIDGET_CLASS (klass), GDK_KEY_KP_Down, 0, _tmp4_, _tmp4__target, NULL, NULL);
	_tmp5_ = down_func;
	_tmp5__target = down_func_target;
	gtk_widget_class_add_binding (GTK_WIDGET_CLASS (klass), GDK_KEY_s, 0, _tmp5_, _tmp5__target, NULL, NULL);
	_tmp6_ = left_func;
	_tmp6__target = left_func_target;
	gtk_widget_class_add_binding (GTK_WIDGET_CLASS (klass), GDK_KEY_Left, 0, _tmp6_, _tmp6__target, NULL, NULL);
	_tmp7_ = left_func;
	_tmp7__target = left_func_target;
	gtk_widget_class_add_binding (GTK_WIDGET_CLASS (klass), GDK_KEY_KP_Left, 0, _tmp7_, _tmp7__target, NULL, NULL);
	_tmp8_ = left_func;
	_tmp8__target = left_func_target;
	gtk_widget_class_add_binding (GTK_WIDGET_CLASS (klass), GDK_KEY_a, 0, _tmp8_, _tmp8__target, NULL, NULL);
	_tmp9_ = right_func;
	_tmp9__target = right_func_target;
	gtk_widget_class_add_binding (GTK_WIDGET_CLASS (klass), GDK_KEY_Right, 0, _tmp9_, _tmp9__target, NULL, NULL);
	_tmp10_ = right_func;
	_tmp10__target = right_func_target;
	gtk_widget_class_add_binding (GTK_WIDGET_CLASS (klass), GDK_KEY_KP_Right, 0, _tmp10_, _tmp10__target, NULL, NULL);
	_tmp11_ = right_func;
	_tmp11__target = right_func_target;
	gtk_widget_class_add_binding (GTK_WIDGET_CLASS (klass), GDK_KEY_d, 0, _tmp11_, _tmp11__target, NULL, NULL);
	(right_func_target_destroy_notify == NULL) ? NULL : (right_func_target_destroy_notify (right_func_target), NULL);
	right_func = NULL;
	right_func_target = NULL;
	right_func_target_destroy_notify = NULL;
	(left_func_target_destroy_notify == NULL) ? NULL : (left_func_target_destroy_notify (left_func_target), NULL);
	left_func = NULL;
	left_func_target = NULL;
	left_func_target_destroy_notify = NULL;
	(down_func_target_destroy_notify == NULL) ? NULL : (down_func_target_destroy_notify (down_func_target), NULL);
	down_func = NULL;
	down_func_target = NULL;
	down_func_target_destroy_notify = NULL;
	(up_func_target_destroy_notify == NULL) ? NULL : (up_func_target_destroy_notify (up_func_target), NULL);
	up_func = NULL;
	up_func_target = NULL;
	up_func_target_destroy_notify = NULL;
}

static void
sudoku_view_instance_init (SudokuView * self,
                           gpointer klass)
{
	self->priv = sudoku_view_get_instance_private (self);
	self->priv->_selected_row = 0;
	self->priv->_selected_col = 0;
	self->priv->_has_selection = TRUE;
}

static void
sudoku_view_finalize (GObject * obj)
{
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_VIEW, SudokuView);
	_g_object_unref0 (self->priv->game);
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->frame);
	_g_object_unref0 (self->priv->paused_label);
	G_OBJECT_CLASS (sudoku_view_parent_class)->finalize (obj);
}

static GType
sudoku_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuView), 0, (GInstanceInitFunc) sudoku_view_instance_init, NULL };
	GType sudoku_view_type_id;
	sudoku_view_type_id = g_type_register_static (adw_bin_get_type (), "SudokuView", &g_define_type_info, 0);
	SudokuView_private_offset = g_type_add_instance_private (sudoku_view_type_id, sizeof (SudokuViewPrivate));
	return sudoku_view_type_id;
}

GType
sudoku_view_get_type (void)
{
	static volatile gsize sudoku_view_type_id__once = 0;
	if (g_once_init_enter (&sudoku_view_type_id__once)) {
		GType sudoku_view_type_id;
		sudoku_view_type_id = sudoku_view_get_type_once ();
		g_once_init_leave (&sudoku_view_type_id__once, sudoku_view_type_id);
	}
	return sudoku_view_type_id__once;
}

static void
_vala_sudoku_view_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
	switch (property_id) {
		case SUDOKU_VIEW_SELECTED_ROW_PROPERTY:
		g_value_set_int (value, sudoku_view_get_selected_row (self));
		break;
		case SUDOKU_VIEW_SELECTED_COL_PROPERTY:
		g_value_set_int (value, sudoku_view_get_selected_col (self));
		break;
		case SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY:
		g_value_set_boolean (value, sudoku_view_get_show_warnings (self));
		break;
		case SUDOKU_VIEW_SHOW_EXTRA_WARNINGS_PROPERTY:
		g_value_set_boolean (value, sudoku_view_get_show_extra_warnings (self));
		break;
		case SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY:
		g_value_set_boolean (value, sudoku_view_get_show_possibilities (self));
		break;
		case SUDOKU_VIEW_HIGHLIGHTER_PROPERTY:
		g_value_set_boolean (value, sudoku_view_get_highlighter (self));
		break;
		case SUDOKU_VIEW_HAS_SELECTION_PROPERTY:
		g_value_set_boolean (value, sudoku_view_get_has_selection (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sudoku_view_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
	switch (property_id) {
		case SUDOKU_VIEW_SELECTED_ROW_PROPERTY:
		sudoku_view_set_selected_row (self, g_value_get_int (value));
		break;
		case SUDOKU_VIEW_SELECTED_COL_PROPERTY:
		sudoku_view_set_selected_col (self, g_value_get_int (value));
		break;
		case SUDOKU_VIEW_SHOW_WARNINGS_PROPERTY:
		sudoku_view_set_show_warnings (self, g_value_get_boolean (value));
		break;
		case SUDOKU_VIEW_SHOW_EXTRA_WARNINGS_PROPERTY:
		sudoku_view_set_show_extra_warnings (self, g_value_get_boolean (value));
		break;
		case SUDOKU_VIEW_SHOW_POSSIBILITIES_PROPERTY:
		sudoku_view_set_show_possibilities (self, g_value_get_boolean (value));
		break;
		case SUDOKU_VIEW_HIGHLIGHTER_PROPERTY:
		sudoku_view_set_highlighter (self, g_value_get_boolean (value));
		break;
		case SUDOKU_VIEW_HAS_SELECTION_PROPERTY:
		sudoku_view_set_has_selection (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

