/* number-picker.c generated by valac 0.56.17, the Vala compiler
 * generated from number-picker.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "libsudoku.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NUMBER_PICKER (number_picker_get_type ())
#define NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER_PICKER, NumberPicker))
#define NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER_PICKER, NumberPickerClass))
#define IS_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER_PICKER))
#define IS_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER_PICKER))
#define NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER_PICKER, NumberPickerClass))

typedef struct _NumberPicker NumberPicker;
typedef struct _NumberPickerClass NumberPickerClass;
typedef struct _NumberPickerPrivate NumberPickerPrivate;
enum  {
	NUMBER_PICKER_0_PROPERTY,
	NUMBER_PICKER_IS_EARMARK_PICKER_PROPERTY,
	NUMBER_PICKER_NUM_PROPERTIES
};
static GParamSpec* number_picker_properties[NUMBER_PICKER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	NUMBER_PICKER_VALUE_PICKED_SIGNAL,
	NUMBER_PICKER_EARMARK_STATE_CHANGED_SIGNAL,
	NUMBER_PICKER_NUM_SIGNALS
};
static guint number_picker_signals[NUMBER_PICKER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NumberPicker {
	GtkGrid parent_instance;
	NumberPickerPrivate * priv;
};

struct _NumberPickerClass {
	GtkGridClass parent_class;
};

struct _NumberPickerPrivate {
	SudokuBoard* board;
	GtkButton* clear_button;
	GtkButton** value_buttons;
	gint value_buttons_length1;
	gint _value_buttons_size_;
	GtkToggleButton** earmark_buttons;
	gint earmark_buttons_length1;
	gint _earmark_buttons_size_;
	gboolean _is_earmark_picker;
};

static gint NumberPicker_private_offset;
static gpointer number_picker_parent_class = NULL;

VALA_EXTERN GType number_picker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NumberPicker, g_object_unref)
VALA_EXTERN NumberPicker* number_picker_new (SudokuGame* game,
                                 gboolean for_earmarks);
VALA_EXTERN NumberPicker* number_picker_construct (GType object_type,
                                       SudokuGame* game,
                                       gboolean for_earmarks);
static void number_picker_set_is_earmark_picker (NumberPicker* self,
                                          gboolean value);
VALA_EXTERN gboolean number_picker_get_is_earmark_picker (NumberPicker* self);
static void _________lambda4_ (NumberPicker* self,
                        GtkButton* this_button);
static void __________lambda4__gtk_button_clicked (GtkButton* _sender,
                                            gpointer self);
static void _________lambda5_ (NumberPicker* self,
                        GtkToggleButton* this_button);
static void __________lambda5__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                   gpointer self);
static void _________lambda6_ (NumberPicker* self,
                        GtkWidget* this_button);
static void __________lambda6__gtk_widget_realize (GtkWidget* _sender,
                                            gpointer self);
static void __lambda7_ (NumberPicker* self,
                 GtkButton* this_button);
static void ___lambda7__gtk_button_clicked (GtkButton* _sender,
                                     gpointer self);
VALA_EXTERN void number_picker_set_clear_button_visibility (NumberPicker* self,
                                                gboolean visible);
VALA_EXTERN void number_picker_set_clear_button_enabled (NumberPicker* self,
                                             gboolean enabled);
VALA_EXTERN void number_picker_set_earmark_buttons (NumberPicker* self,
                                        gint row,
                                        gint col);
VALA_EXTERN void number_picker_set_earmark_button (NumberPicker* self,
                                       gint num,
                                       gboolean state);
static void number_picker_real_dispose (GObject* base);
static void g_cclosure_user_marshal_VOID__INT_BOOLEAN (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void number_picker_finalize (GObject * obj);
static GType number_picker_get_type_once (void);
static void _vala_number_picker_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_number_picker_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
number_picker_get_instance_private (NumberPicker* self)
{
	return G_STRUCT_MEMBER_P (self, NumberPicker_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_________lambda4_ (NumberPicker* self,
                   GtkButton* this_button)
{
	gconstpointer _tmp0_;
	g_return_if_fail (this_button != NULL);
	_tmp0_ = g_object_get_data ((GObject*) this_button, "number-contained");
	g_signal_emit (self, number_picker_signals[NUMBER_PICKER_VALUE_PICKED_SIGNAL], 0, (gint) ((gintptr) _tmp0_));
}

static void
__________lambda4__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self)
{
	_________lambda4_ ((NumberPicker*) self, _sender);
}

static void
_________lambda5_ (NumberPicker* self,
                   GtkToggleButton* this_button)
{
	gint number_contained = 0;
	gconstpointer _tmp0_;
	gboolean toggle_active = FALSE;
	g_return_if_fail (this_button != NULL);
	_tmp0_ = g_object_get_data ((GObject*) this_button, "number-contained");
	number_contained = (gint) ((gintptr) _tmp0_);
	toggle_active = gtk_toggle_button_get_active (this_button);
	g_signal_emit (self, number_picker_signals[NUMBER_PICKER_EARMARK_STATE_CHANGED_SIGNAL], 0, number_contained, toggle_active);
}

static void
__________lambda5__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                              gpointer self)
{
	_________lambda5_ ((NumberPicker*) self, _sender);
}

static void
_________lambda6_ (NumberPicker* self,
                   GtkWidget* this_button)
{
	g_return_if_fail (this_button != NULL);
	gtk_widget_grab_focus (this_button);
}

static void
__________lambda6__gtk_widget_realize (GtkWidget* _sender,
                                       gpointer self)
{
	_________lambda6_ ((NumberPicker*) self, _sender);
}

static void
__lambda7_ (NumberPicker* self,
            GtkButton* this_button)
{
	gboolean _tmp0_;
	g_return_if_fail (this_button != NULL);
	g_signal_emit (self, number_picker_signals[NUMBER_PICKER_VALUE_PICKED_SIGNAL], 0, 0);
	g_signal_emit (self, number_picker_signals[NUMBER_PICKER_EARMARK_STATE_CHANGED_SIGNAL], 0, 0, FALSE);
	_tmp0_ = self->priv->_is_earmark_picker;
	if (_tmp0_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp1_ = FALSE;
				_tmp1_ = TRUE;
				while (TRUE) {
					GtkToggleButton** _tmp3_;
					gint _tmp3__length1;
					GtkToggleButton* _tmp4_;
					if (!_tmp1_) {
						gint _tmp2_;
						_tmp2_ = i;
						i = _tmp2_ + 1;
					}
					_tmp1_ = FALSE;
					if (!(i < 9)) {
						break;
					}
					_tmp3_ = self->priv->earmark_buttons;
					_tmp3__length1 = self->priv->earmark_buttons_length1;
					_tmp4_ = _tmp3_[i];
					gtk_toggle_button_set_active (_tmp4_, FALSE);
				}
			}
		}
	}
}

static void
___lambda7__gtk_button_clicked (GtkButton* _sender,
                                gpointer self)
{
	__lambda7_ ((NumberPicker*) self, _sender);
}

NumberPicker*
number_picker_construct (GType object_type,
                         SudokuGame* game,
                         gboolean for_earmarks)
{
	NumberPicker * self = NULL;
	SudokuBoard* _tmp0_;
	SudokuBoard* _tmp1_;
	SudokuBoard* _tmp2_;
	gboolean _tmp3_;
	GtkButton* _tmp68_;
	GtkButton* _tmp69_;
	GtkButton* _tmp70_;
	GtkLabel* label = NULL;
	gchar* _tmp71_;
	gchar* _tmp72_;
	GtkLabel* _tmp73_;
	GtkLabel* _tmp74_;
	GtkButton* _tmp75_;
	GtkButton* _tmp76_;
	g_return_val_if_fail (game != NULL, NULL);
	self = (NumberPicker*) g_object_new (object_type, NULL);
	_tmp0_ = sudoku_game_get_board (game);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->board);
	self->priv->board = _tmp2_;
	number_picker_set_is_earmark_picker (self, for_earmarks);
	_tmp3_ = self->priv->_is_earmark_picker;
	if (_tmp3_) {
		SudokuBoard* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		SudokuBoard* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		GtkToggleButton** _tmp10_;
		_tmp4_ = self->priv->board;
		_tmp5_ = sudoku_board_get_block_cols (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->board;
		_tmp8_ = sudoku_board_get_block_rows (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_new0 (GtkToggleButton*, (_tmp6_ * _tmp9_) + 1);
		self->priv->earmark_buttons = (_vala_array_free (self->priv->earmark_buttons, self->priv->earmark_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->earmark_buttons = _tmp10_;
		self->priv->earmark_buttons_length1 = _tmp6_ * _tmp9_;
		self->priv->_earmark_buttons_size_ = self->priv->earmark_buttons_length1;
	} else {
		SudokuBoard* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		SudokuBoard* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		GtkButton** _tmp17_;
		_tmp11_ = self->priv->board;
		_tmp12_ = sudoku_board_get_block_cols (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = self->priv->board;
		_tmp15_ = sudoku_board_get_block_rows (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_new0 (GtkButton*, (_tmp13_ * _tmp16_) + 1);
		self->priv->value_buttons = (_vala_array_free (self->priv->value_buttons, self->priv->value_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->value_buttons = _tmp17_;
		self->priv->value_buttons_length1 = _tmp13_ * _tmp16_;
		self->priv->_value_buttons_size_ = self->priv->value_buttons_length1;
	}
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				SudokuBoard* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = col;
					col = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp20_ = self->priv->board;
				_tmp21_ = sudoku_board_get_block_cols (_tmp20_);
				_tmp22_ = _tmp21_;
				if (!(col < _tmp22_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							SudokuBoard* _tmp25_;
							gint _tmp26_;
							gint _tmp27_;
							gint n = 0;
							SudokuBoard* _tmp28_;
							gint _tmp29_;
							gint _tmp30_;
							SudokuBoard* _tmp31_;
							gint _tmp32_;
							gint _tmp33_;
							GtkButton* _tmp34_ = NULL;
							GtkButton* button = NULL;
							GtkButton* _tmp37_;
							GtkButton* _tmp38_;
							GtkButton* _tmp39_;
							GtkLabel* label = NULL;
							gchar* _tmp40_;
							gchar* _tmp41_;
							GtkLabel* _tmp42_;
							GtkLabel* _tmp43_;
							GtkLabel* _tmp44_;
							gint _tmp45_ = 0;
							GtkLabel* _tmp46_;
							gint _tmp47_ = 0;
							GtkLabel* _tmp48_;
							gint _tmp49_ = 0;
							GtkLabel* _tmp50_;
							gint _tmp51_ = 0;
							GtkLabel* _tmp52_;
							GtkButton* _tmp53_;
							GtkLabel* _tmp54_;
							GtkLabel* _tmp55_;
							GtkButton* _tmp56_;
							GtkButton* _tmp67_;
							if (!_tmp23_) {
								gint _tmp24_;
								_tmp24_ = row;
								row = _tmp24_ + 1;
							}
							_tmp23_ = FALSE;
							_tmp25_ = self->priv->board;
							_tmp26_ = sudoku_board_get_block_rows (_tmp25_);
							_tmp27_ = _tmp26_;
							if (!(row < _tmp27_)) {
								break;
							}
							_tmp28_ = self->priv->board;
							_tmp29_ = sudoku_board_get_block_rows (_tmp28_);
							_tmp30_ = _tmp29_;
							_tmp31_ = self->priv->board;
							_tmp32_ = sudoku_board_get_block_cols (_tmp31_);
							_tmp33_ = _tmp32_;
							n = (col + (((_tmp30_ - 1) - row) * _tmp33_)) + 1;
							if (for_earmarks) {
								GtkToggleButton* _tmp35_;
								_tmp35_ = (GtkToggleButton*) gtk_toggle_button_new ();
								g_object_ref_sink (_tmp35_);
								_g_object_unref0 (_tmp34_);
								_tmp34_ = (GtkButton*) _tmp35_;
							} else {
								GtkButton* _tmp36_;
								_tmp36_ = (GtkButton*) gtk_button_new ();
								g_object_ref_sink (_tmp36_);
								_g_object_unref0 (_tmp34_);
								_tmp34_ = _tmp36_;
							}
							_tmp37_ = _g_object_ref0 (_tmp34_);
							button = _tmp37_;
							_tmp38_ = button;
							gtk_widget_set_focus_on_click ((GtkWidget*) _tmp38_, FALSE);
							_tmp39_ = button;
							gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp39_, col, row, 1, 1);
							_tmp40_ = g_strdup_printf ("<big>%d</big>", n);
							_tmp41_ = _tmp40_;
							_tmp42_ = (GtkLabel*) gtk_label_new (_tmp41_);
							g_object_ref_sink (_tmp42_);
							_tmp43_ = _tmp42_;
							_g_free0 (_tmp41_);
							label = _tmp43_;
							_tmp44_ = label;
							gtk_label_set_use_markup (_tmp44_, TRUE);
							if (for_earmarks) {
								_tmp45_ = 0;
							} else {
								_tmp45_ = 8;
							}
							_tmp46_ = label;
							gtk_widget_set_margin_start ((GtkWidget*) _tmp46_, _tmp45_);
							if (for_earmarks) {
								_tmp47_ = 16;
							} else {
								_tmp47_ = 8;
							}
							_tmp48_ = label;
							gtk_widget_set_margin_end ((GtkWidget*) _tmp48_, _tmp47_);
							if (for_earmarks) {
								_tmp49_ = 0;
							} else {
								_tmp49_ = 4;
							}
							_tmp50_ = label;
							gtk_widget_set_margin_top ((GtkWidget*) _tmp50_, _tmp49_);
							if (for_earmarks) {
								_tmp51_ = 8;
							} else {
								_tmp51_ = 4;
							}
							_tmp52_ = label;
							gtk_widget_set_margin_bottom ((GtkWidget*) _tmp52_, _tmp51_);
							_tmp53_ = button;
							_tmp54_ = label;
							gtk_button_set_child (_tmp53_, (GtkWidget*) _tmp54_);
							_tmp55_ = label;
							gtk_widget_show ((GtkWidget*) _tmp55_);
							_tmp56_ = button;
							g_object_set_data_full ((GObject*) _tmp56_, "number-contained", (gpointer) ((gintptr) n), NULL);
							if (!for_earmarks) {
								GtkButton** _tmp57_;
								gint _tmp57__length1;
								GtkButton* _tmp58_;
								GtkButton* _tmp59_;
								GtkButton* _tmp60_;
								_tmp57_ = self->priv->value_buttons;
								_tmp57__length1 = self->priv->value_buttons_length1;
								_tmp58_ = button;
								_tmp59_ = _g_object_ref0 (_tmp58_);
								_g_object_unref0 (_tmp57_[n - 1]);
								_tmp57_[n - 1] = _tmp59_;
								_tmp60_ = button;
								g_signal_connect_object (_tmp60_, "clicked", (GCallback) __________lambda4__gtk_button_clicked, self, 0);
							} else {
								GtkToggleButton** _tmp61_;
								gint _tmp61__length1;
								GtkButton* _tmp62_;
								GtkToggleButton* _tmp63_;
								GtkToggleButton** _tmp64_;
								gint _tmp64__length1;
								GtkToggleButton* _tmp65_;
								_tmp61_ = self->priv->earmark_buttons;
								_tmp61__length1 = self->priv->earmark_buttons_length1;
								_tmp62_ = button;
								_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_toggle_button_get_type (), GtkToggleButton));
								_g_object_unref0 (_tmp61_[n - 1]);
								_tmp61_[n - 1] = _tmp63_;
								_tmp64_ = self->priv->earmark_buttons;
								_tmp64__length1 = self->priv->earmark_buttons_length1;
								_tmp65_ = _tmp64_[n - 1];
								g_signal_connect_object (_tmp65_, "toggled", (GCallback) __________lambda5__gtk_toggle_button_toggled, self, 0);
							}
							if (n == 5) {
								GtkButton* _tmp66_;
								_tmp66_ = button;
								g_signal_connect_object ((GtkWidget*) _tmp66_, "realize", (GCallback) __________lambda6__gtk_widget_realize, self, 0);
							}
							_tmp67_ = button;
							gtk_widget_show ((GtkWidget*) _tmp67_);
							_g_object_unref0 (label);
							_g_object_unref0 (button);
							_g_object_unref0 (_tmp34_);
						}
					}
				}
			}
		}
	}
	_tmp68_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp68_);
	_g_object_unref0 (self->priv->clear_button);
	self->priv->clear_button = _tmp68_;
	_tmp69_ = self->priv->clear_button;
	gtk_widget_set_focus_on_click ((GtkWidget*) _tmp69_, FALSE);
	_tmp70_ = self->priv->clear_button;
	gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp70_, 0, 4, 3, 1);
	_tmp71_ = g_strdup_printf ("<big>%s</big>", _ ("Clear"));
	_tmp72_ = _tmp71_;
	_tmp73_ = (GtkLabel*) gtk_label_new (_tmp72_);
	g_object_ref_sink (_tmp73_);
	_tmp74_ = _tmp73_;
	_g_free0 (_tmp72_);
	label = _tmp74_;
	gtk_label_set_use_markup (label, TRUE);
	_tmp75_ = self->priv->clear_button;
	gtk_button_set_child (_tmp75_, (GtkWidget*) label);
	gtk_widget_show ((GtkWidget*) label);
	_tmp76_ = self->priv->clear_button;
	g_signal_connect_object (_tmp76_, "clicked", (GCallback) ___lambda7__gtk_button_clicked, self, 0);
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
	gtk_widget_set_margin_top ((GtkWidget*) self, 2);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 2);
	gtk_widget_set_margin_start ((GtkWidget*) self, 2);
	gtk_widget_set_margin_end ((GtkWidget*) self, 2);
	gtk_grid_set_row_spacing ((GtkGrid*) self, 3);
	gtk_grid_set_column_spacing ((GtkGrid*) self, 3);
	gtk_widget_show ((GtkWidget*) self);
	_g_object_unref0 (label);
	return self;
}

NumberPicker*
number_picker_new (SudokuGame* game,
                   gboolean for_earmarks)
{
	return number_picker_construct (TYPE_NUMBER_PICKER, game, for_earmarks);
}

void
number_picker_set_clear_button_visibility (NumberPicker* self,
                                           gboolean visible)
{
	g_return_if_fail (self != NULL);
	if (visible) {
		GtkButton* _tmp0_;
		_tmp0_ = self->priv->clear_button;
		gtk_widget_show ((GtkWidget*) _tmp0_);
	} else {
		GtkButton* _tmp1_;
		_tmp1_ = self->priv->clear_button;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
}

void
number_picker_set_clear_button_enabled (NumberPicker* self,
                                        gboolean enabled)
{
	g_return_if_fail (self != NULL);
	if (enabled) {
		GtkButton* _tmp0_;
		_tmp0_ = self->priv->clear_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, TRUE);
	} else {
		GtkButton* _tmp1_;
		_tmp1_ = self->priv->clear_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
	}
}

void
number_picker_set_earmark_buttons (NumberPicker* self,
                                   gint row,
                                   gint col)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_earmark_picker;
	_vala_return_if_fail (_tmp0_, "is_earmark_picker");
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				SudokuBoard* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				SudokuBoard* _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->board;
				_tmp4_ = sudoku_board_get_max_val (_tmp3_);
				_tmp5_ = _tmp4_;
				if (!(i <= _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->board;
				number_picker_set_earmark_button (self, i, sudoku_board_is_earmark_enabled (_tmp6_, row, col, i));
			}
		}
	}
}

void
number_picker_set_earmark_button (NumberPicker* self,
                                  gint num,
                                  gboolean state)
{
	gboolean _tmp0_;
	GtkToggleButton** _tmp1_;
	gint _tmp1__length1;
	GtkToggleButton* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_earmark_picker;
	_vala_return_if_fail (_tmp0_, "is_earmark_picker");
	_tmp1_ = self->priv->earmark_buttons;
	_tmp1__length1 = self->priv->earmark_buttons_length1;
	_tmp2_ = _tmp1_[num - 1];
	gtk_toggle_button_set_active (_tmp2_, state);
}

static void
number_picker_real_dispose (GObject* base)
{
	NumberPicker * self;
	GtkButton* _tmp0_;
	GtkToggleButton** _tmp1_;
	gint _tmp1__length1;
	GtkButton** _tmp4_;
	gint _tmp4__length1;
	self = (NumberPicker*) base;
	_tmp0_ = self->priv->clear_button;
	gtk_widget_unparent ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->earmark_buttons;
	_tmp1__length1 = self->priv->earmark_buttons_length1;
	{
		GtkToggleButton** button_collection = NULL;
		gint button_collection_length1 = 0;
		gint _button_collection_size_ = 0;
		gint button_it = 0;
		button_collection = _tmp1_;
		button_collection_length1 = _tmp1__length1;
		for (button_it = 0; button_it < button_collection_length1; button_it = button_it + 1) {
			GtkToggleButton* _tmp2_;
			GtkToggleButton* button = NULL;
			_tmp2_ = _g_object_ref0 (button_collection[button_it]);
			button = _tmp2_;
			{
				GtkToggleButton* _tmp3_;
				_tmp3_ = button;
				gtk_widget_unparent ((GtkWidget*) _tmp3_);
				_g_object_unref0 (button);
			}
		}
	}
	_tmp4_ = self->priv->value_buttons;
	_tmp4__length1 = self->priv->value_buttons_length1;
	{
		GtkButton** button_collection = NULL;
		gint button_collection_length1 = 0;
		gint _button_collection_size_ = 0;
		gint button_it = 0;
		button_collection = _tmp4_;
		button_collection_length1 = _tmp4__length1;
		for (button_it = 0; button_it < button_collection_length1; button_it = button_it + 1) {
			GtkButton* _tmp5_;
			GtkButton* button = NULL;
			_tmp5_ = _g_object_ref0 (button_collection[button_it]);
			button = _tmp5_;
			{
				GtkButton* _tmp6_;
				_tmp6_ = button;
				gtk_widget_unparent ((GtkWidget*) _tmp6_);
				_g_object_unref0 (button);
			}
		}
	}
}

gboolean
number_picker_get_is_earmark_picker (NumberPicker* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_earmark_picker;
	return result;
}

static void
number_picker_set_is_earmark_picker (NumberPicker* self,
                                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = number_picker_get_is_earmark_picker (self);
	if (old_value != value) {
		self->priv->_is_earmark_picker = value;
		g_object_notify_by_pspec ((GObject *) self, number_picker_properties[NUMBER_PICKER_IS_EARMARK_PICKER_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__INT_BOOLEAN (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_BOOLEAN) (gpointer data1, gint arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}

static void
number_picker_class_init (NumberPickerClass * klass,
                          gpointer klass_data)
{
	number_picker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NumberPicker_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) number_picker_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_number_picker_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_number_picker_set_property;
	G_OBJECT_CLASS (klass)->finalize = number_picker_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NUMBER_PICKER_IS_EARMARK_PICKER_PROPERTY, number_picker_properties[NUMBER_PICKER_IS_EARMARK_PICKER_PROPERTY] = g_param_spec_boolean ("is-earmark-picker", "is-earmark-picker", "is-earmark-picker", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	number_picker_signals[NUMBER_PICKER_VALUE_PICKED_SIGNAL] = g_signal_new ("value-picked", TYPE_NUMBER_PICKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
	number_picker_signals[NUMBER_PICKER_EARMARK_STATE_CHANGED_SIGNAL] = g_signal_new ("earmark-state-changed", TYPE_NUMBER_PICKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_BOOLEAN);
}

static void
number_picker_instance_init (NumberPicker * self,
                             gpointer klass)
{
	self->priv = number_picker_get_instance_private (self);
}

static void
number_picker_finalize (GObject * obj)
{
	NumberPicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NUMBER_PICKER, NumberPicker);
	_g_object_unref0 (self->priv->board);
	_g_object_unref0 (self->priv->clear_button);
	self->priv->value_buttons = (_vala_array_free (self->priv->value_buttons, self->priv->value_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->earmark_buttons = (_vala_array_free (self->priv->earmark_buttons, self->priv->earmark_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (number_picker_parent_class)->finalize (obj);
}

static GType
number_picker_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NumberPickerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) number_picker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NumberPicker), 0, (GInstanceInitFunc) number_picker_instance_init, NULL };
	GType number_picker_type_id;
	number_picker_type_id = g_type_register_static (gtk_grid_get_type (), "NumberPicker", &g_define_type_info, 0);
	NumberPicker_private_offset = g_type_add_instance_private (number_picker_type_id, sizeof (NumberPickerPrivate));
	return number_picker_type_id;
}

GType
number_picker_get_type (void)
{
	static volatile gsize number_picker_type_id__once = 0;
	if (g_once_init_enter (&number_picker_type_id__once)) {
		GType number_picker_type_id;
		number_picker_type_id = number_picker_get_type_once ();
		g_once_init_leave (&number_picker_type_id__once, number_picker_type_id);
	}
	return number_picker_type_id__once;
}

static void
_vala_number_picker_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	NumberPicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER_PICKER, NumberPicker);
	switch (property_id) {
		case NUMBER_PICKER_IS_EARMARK_PICKER_PROPERTY:
		g_value_set_boolean (value, number_picker_get_is_earmark_picker (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_number_picker_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	NumberPicker * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER_PICKER, NumberPicker);
	switch (property_id) {
		case NUMBER_PICKER_IS_EARMARK_PICKER_PROPERTY:
		number_picker_set_is_earmark_picker (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

