/* sudoku-board.c generated by valac 0.56.17, the Vala compiler
 * generated from sudoku-board.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libsudoku.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <glib-object.h>
#include <qqwing-wrapper.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SUDOKU_BOARD_0_PROPERTY,
	SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY,
	SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY,
	SUDOKU_BOARD_BLOCK_ROWS_PROPERTY,
	SUDOKU_BOARD_BLOCK_COLS_PROPERTY,
	SUDOKU_BOARD_ROWS_PROPERTY,
	SUDOKU_BOARD_COLS_PROPERTY,
	SUDOKU_BOARD_MAX_VAL_PROPERTY,
	SUDOKU_BOARD_BROKEN_PROPERTY,
	SUDOKU_BOARD_FILLED_PROPERTY,
	SUDOKU_BOARD_FIXED_PROPERTY,
	SUDOKU_BOARD_SIZE_PROPERTY,
	SUDOKU_BOARD_COMPLETE_PROPERTY,
	SUDOKU_BOARD_BROKEN_COORDS_PROPERTY,
	SUDOKU_BOARD_COORDS_FOR_COL_PROPERTY,
	SUDOKU_BOARD_COORDS_FOR_ROW_PROPERTY,
	SUDOKU_BOARD_COORDS_FOR_BLOCK_PROPERTY,
	SUDOKU_BOARD_NUM_PROPERTIES
};
static GParamSpec* sudoku_board_properties[SUDOKU_BOARD_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _coord_free0(var) ((var == NULL) ? NULL : (var = (coord_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SUDOKU_BOARD_COMPLETED_SIGNAL,
	SUDOKU_BOARD_EARMARK_CHANGED_SIGNAL,
	SUDOKU_BOARD_CELL_CHANGED_SIGNAL,
	SUDOKU_BOARD_NUM_SIGNALS
};
static guint sudoku_board_signals[SUDOKU_BOARD_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SudokuBoardPrivate {
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gint* solution;
	gint solution_length1;
	gint solution_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	gint* occurences_in_row;
	gint occurences_in_row_length1;
	gint occurences_in_row_length2;
	gint* occurences_in_col;
	gint occurences_in_col_length1;
	gint occurences_in_col_length2;
	gint* occurences_in_block;
	gint occurences_in_block_length1;
	gint occurences_in_block_length2;
	gint occurences_in_block_length3;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	gint n_earmarks;
	gdouble _previous_played_time;
	DifficultyCategory _difficulty_category;
	gint _block_rows;
	gint _block_cols;
	gint _rows;
	gint _cols;
	gint _filled;
	gint _fixed;
	GeeSet* _broken_coords;
	GeeList* _coords_for_col;
	GeeList* _coords_for_row;
	GeeMap* _coords_for_block;
};

static gint SudokuBoard_private_offset;
static gpointer sudoku_board_parent_class = NULL;

static void sudoku_board_set_cols (SudokuBoard* self,
                            gint value);
static void sudoku_board_set_rows (SudokuBoard* self,
                            gint value);
static void sudoku_board_set_block_rows (SudokuBoard* self,
                                  gint value);
static void sudoku_board_set_block_cols (SudokuBoard* self,
                                  gint value);
static void sudoku_board_set_broken_coords (SudokuBoard* self,
                                     GeeSet* value);
static void sudoku_board_set_coords_for_col (SudokuBoard* self,
                                      GeeList* value);
static void sudoku_board_set_coords_for_row (SudokuBoard* self,
                                      GeeList* value);
static void sudoku_board_set_coords_for_block (SudokuBoard* self,
                                        GeeMap* value);
static gint* _vala_array_dup1 (gint* self,
                        gssize length);
static gint* _vala_array_dup2 (gint* self,
                        gssize length);
static gboolean* _vala_array_dup3 (gboolean* self,
                            gssize length);
static gint* _vala_array_dup4 (gint* self,
                        gssize length);
static gint* _vala_array_dup5 (gint* self,
                        gssize length);
static gint* _vala_array_dup6 (gint* self,
                        gssize length);
static void sudoku_board_set_filled (SudokuBoard* self,
                              gint value);
static void sudoku_board_set_fixed (SudokuBoard* self,
                             gint value);
static gboolean* _vala_array_dup7 (gboolean* self,
                            gssize length);
static gint* _vala_array_dup8 (gint* self,
                        gssize length);
static void sudoku_board_update_old_breakages (SudokuBoard* self,
                                        gint row,
                                        gint col,
                                        gint val);
static void sudoku_board_mark_breakages (SudokuBoard* self,
                                  gint row,
                                  gint col,
                                  gint val);
static void sudoku_board_add_to_occurences (SudokuBoard* self,
                                     gint row,
                                     gint col,
                                     gint val,
                                     gint add);
static void sudoku_board_remove_breakages_for (SudokuBoard* self,
                                        GeeList* coords,
                                        gint val);
static void sudoku_board_mark_breakages_for (SudokuBoard* self,
                                      GeeList* coords,
                                      gint val);
static gint* sudoku_board_fixed_cells_only (SudokuBoard* self,
                                     gint* result_length1,
                                     gint* result_length2);
static gint* sudoku_board_convert_2d_to_1d (SudokuBoard* self,
                                     gint* ints_2d,
                                     gint ints_2d_length1,
                                     gint ints_2d_length2,
                                     gint* result_length1);
static gint* sudoku_board_convert_1d_to_2d (SudokuBoard* self,
                                     gint* ints_1d,
                                     gint ints_1d_length1,
                                     gint* result_length1,
                                     gint* result_length2);
static gint* _vala_array_dup9 (gint* self,
                        gssize length);
static void g_cclosure_user_marshal_VOID__INT_INT_INT_BOOLEAN (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static void sudoku_board_finalize (GObject * obj);
static GType sudoku_board_get_type_once (void);
static void _vala_sudoku_board_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_sudoku_board_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sudoku_board_get_instance_private (SudokuBoard* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuBoard_private_offset);
}

void
sudoku_board_set_all_is_fixed (SudokuBoard* self)
{
	g_return_if_fail (self != NULL);
	{
		gint r = 0;
		r = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = r;
					r = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_rows;
				if (!(r < _tmp2_)) {
					break;
				}
				{
					gint c = 0;
					c = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							gint* _tmp6_;
							gint _tmp6__length1;
							gint _tmp6__length2;
							gint _tmp7_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = c;
								c = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = self->priv->_cols;
							if (!(c < _tmp5_)) {
								break;
							}
							_tmp6_ = self->priv->cells;
							_tmp6__length1 = self->priv->cells_length1;
							_tmp6__length2 = self->priv->cells_length2;
							_tmp7_ = _tmp6_[(r * _tmp6__length2) + c];
							if (_tmp7_ > 0) {
								gboolean* _tmp8_;
								gint _tmp8__length1;
								gint _tmp8__length2;
								_tmp8_ = self->priv->is_fixed;
								_tmp8__length1 = self->priv->is_fixed_length1;
								_tmp8__length2 = self->priv->is_fixed_length2;
								_tmp8_[(r * _tmp8__length2) + c] = TRUE;
							}
						}
					}
				}
			}
		}
	}
}

gboolean
sudoku_board_is_empty (SudokuBoard* self)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_filled;
	_tmp2_ = self->priv->_fixed;
	if (_tmp1_ == _tmp2_) {
		_tmp0_ = self->priv->n_earmarks == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
sudoku_board_is_fully_filled (SudokuBoard* self)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_filled;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = self->priv->_rows;
	result = _tmp0_ == (_tmp1_ * _tmp2_);
	return result;
}

SudokuBoard*
sudoku_board_construct (GType object_type,
                        gint block_rows,
                        gint block_cols)
{
	SudokuBoard * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint* _tmp11_;
	gint* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gboolean* _tmp17_;
	GeeHashSet* _tmp37_;
	GeeHashSet* _tmp38_;
	GeeArrayList* _tmp39_;
	GeeArrayList* _tmp40_;
	GeeList* _tmp61_;
	GeeList* _tmp62_;
	GeeList* _tmp63_;
	GeeList* _tmp64_;
	GeeArrayList* _tmp65_;
	GeeArrayList* _tmp66_;
	GeeList* _tmp87_;
	GeeList* _tmp88_;
	GeeList* _tmp89_;
	GeeList* _tmp90_;
	GeeHashMap* _tmp91_;
	GeeHashMap* _tmp92_;
	GeeMap* _tmp125_;
	GeeMap* _tmp126_;
	GeeMap* _tmp127_;
	GeeMap* _tmp128_;
	self = (SudokuBoard*) g_object_new (object_type, NULL);
	sudoku_board_set_cols (self, block_rows * block_cols);
	sudoku_board_set_rows (self, block_rows * block_cols);
	sudoku_board_set_block_rows (self, block_rows);
	sudoku_board_set_block_cols (self, block_cols);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = g_new0 (gint, _tmp0_ * _tmp1_);
	self->priv->cells = (g_free (self->priv->cells), NULL);
	self->priv->cells = _tmp2_;
	self->priv->cells_length1 = _tmp0_;
	self->priv->cells_length2 = _tmp1_;
	_tmp3_ = self->priv->_rows;
	_tmp4_ = self->priv->_cols;
	_tmp5_ = g_new0 (gboolean, _tmp3_ * _tmp4_);
	self->priv->is_fixed = (g_free (self->priv->is_fixed), NULL);
	self->priv->is_fixed = _tmp5_;
	self->priv->is_fixed_length1 = _tmp3_;
	self->priv->is_fixed_length2 = _tmp4_;
	_tmp6_ = self->priv->_rows;
	_tmp7_ = self->priv->_cols;
	_tmp8_ = g_new0 (gint, _tmp6_ * _tmp7_);
	self->priv->occurences_in_row = (g_free (self->priv->occurences_in_row), NULL);
	self->priv->occurences_in_row = _tmp8_;
	self->priv->occurences_in_row_length1 = _tmp6_;
	self->priv->occurences_in_row_length2 = _tmp7_;
	_tmp9_ = self->priv->_cols;
	_tmp10_ = self->priv->_rows;
	_tmp11_ = g_new0 (gint, _tmp9_ * _tmp10_);
	self->priv->occurences_in_col = (g_free (self->priv->occurences_in_col), NULL);
	self->priv->occurences_in_col = _tmp11_;
	self->priv->occurences_in_col_length1 = _tmp9_;
	self->priv->occurences_in_col_length2 = _tmp10_;
	_tmp12_ = g_new0 (gint, (block_rows * block_cols) * (block_rows * block_cols));
	self->priv->occurences_in_block = (g_free (self->priv->occurences_in_block), NULL);
	self->priv->occurences_in_block = _tmp12_;
	self->priv->occurences_in_block_length1 = block_rows;
	self->priv->occurences_in_block_length2 = block_cols;
	self->priv->occurences_in_block_length3 = block_rows * block_cols;
	_tmp13_ = self->priv->_rows;
	_tmp14_ = self->priv->_cols;
	_tmp15_ = sudoku_board_get_max_val (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_new0 (gboolean, (_tmp13_ * _tmp14_) * _tmp16_);
	self->priv->earmarks = (g_free (self->priv->earmarks), NULL);
	self->priv->earmarks = _tmp17_;
	self->priv->earmarks_length1 = _tmp13_;
	self->priv->earmarks_length2 = _tmp14_;
	self->priv->earmarks_length3 = _tmp16_;
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp18_ = FALSE;
			_tmp18_ = TRUE;
			while (TRUE) {
				gint _tmp20_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = l1;
					l1 = _tmp19_ + 1;
				}
				_tmp18_ = FALSE;
				_tmp20_ = self->priv->_rows;
				if (!(l1 < _tmp20_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp21_ = FALSE;
						_tmp21_ = TRUE;
						while (TRUE) {
							gint _tmp23_;
							gint* _tmp24_;
							gint _tmp24__length1;
							gint _tmp24__length2;
							gboolean* _tmp25_;
							gint _tmp25__length1;
							gint _tmp25__length2;
							gint* _tmp26_;
							gint _tmp26__length1;
							gint _tmp26__length2;
							gint* _tmp27_;
							gint _tmp27__length1;
							gint _tmp27__length2;
							if (!_tmp21_) {
								gint _tmp22_;
								_tmp22_ = l2;
								l2 = _tmp22_ + 1;
							}
							_tmp21_ = FALSE;
							_tmp23_ = self->priv->_cols;
							if (!(l2 < _tmp23_)) {
								break;
							}
							_tmp24_ = self->priv->cells;
							_tmp24__length1 = self->priv->cells_length1;
							_tmp24__length2 = self->priv->cells_length2;
							_tmp24_[(l1 * _tmp24__length2) + l2] = 0;
							_tmp25_ = self->priv->is_fixed;
							_tmp25__length1 = self->priv->is_fixed_length1;
							_tmp25__length2 = self->priv->is_fixed_length2;
							_tmp25_[(l1 * _tmp25__length2) + l2] = FALSE;
							_tmp26_ = self->priv->occurences_in_row;
							_tmp26__length1 = self->priv->occurences_in_row_length1;
							_tmp26__length2 = self->priv->occurences_in_row_length2;
							_tmp26_[(l1 * _tmp26__length2) + l2] = 0;
							_tmp27_ = self->priv->occurences_in_col;
							_tmp27__length1 = self->priv->occurences_in_col_length1;
							_tmp27__length2 = self->priv->occurences_in_col_length2;
							_tmp27_[(l2 * _tmp27__length2) + l1] = 0;
						}
					}
				}
			}
		}
	}
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				if (!_tmp28_) {
					gint _tmp29_;
					_tmp29_ = l1;
					l1 = _tmp29_ + 1;
				}
				_tmp28_ = FALSE;
				if (!(l1 < block_rows)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp30_ = FALSE;
						_tmp30_ = TRUE;
						while (TRUE) {
							if (!_tmp30_) {
								gint _tmp31_;
								_tmp31_ = l2;
								l2 = _tmp31_ + 1;
							}
							_tmp30_ = FALSE;
							if (!(l2 < block_cols)) {
								break;
							}
							{
								gint l3 = 0;
								l3 = 0;
								{
									gboolean _tmp32_ = FALSE;
									_tmp32_ = TRUE;
									while (TRUE) {
										gint _tmp34_;
										gint _tmp35_;
										gint* _tmp36_;
										gint _tmp36__length1;
										gint _tmp36__length2;
										gint _tmp36__length3;
										if (!_tmp32_) {
											gint _tmp33_;
											_tmp33_ = l3;
											l3 = _tmp33_ + 1;
										}
										_tmp32_ = FALSE;
										_tmp34_ = sudoku_board_get_max_val (self);
										_tmp35_ = _tmp34_;
										if (!(l3 < _tmp35_)) {
											break;
										}
										_tmp36_ = self->priv->occurences_in_block;
										_tmp36__length1 = self->priv->occurences_in_block_length1;
										_tmp36__length2 = self->priv->occurences_in_block_length2;
										_tmp36__length3 = self->priv->occurences_in_block_length3;
										_tmp36_[(((l1 * _tmp36__length2) + l2) * _tmp36__length3) + l3] = 0;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp37_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
	_tmp38_ = _tmp37_;
	sudoku_board_set_broken_coords (self, (GeeSet*) _tmp38_);
	_g_object_unref0 (_tmp38_);
	_tmp39_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp40_ = _tmp39_;
	sudoku_board_set_coords_for_col (self, (GeeList*) _tmp40_);
	_g_object_unref0 (_tmp40_);
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp41_ = FALSE;
			_tmp41_ = TRUE;
			while (TRUE) {
				gint _tmp43_;
				GeeList* _tmp44_;
				GeeArrayList* _tmp45_;
				GeeArrayList* _tmp46_;
				GeeList* _tmp54_;
				GeeList* _tmp55_;
				gpointer _tmp56_;
				GeeList* _tmp57_;
				GeeList* _tmp58_;
				GeeList* _tmp59_;
				GeeList* _tmp60_;
				if (!_tmp41_) {
					gint _tmp42_;
					_tmp42_ = col;
					col = _tmp42_ + 1;
				}
				_tmp41_ = FALSE;
				_tmp43_ = self->priv->_cols;
				if (!(col < _tmp43_)) {
					break;
				}
				_tmp44_ = self->priv->_coords_for_col;
				_tmp45_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
				_tmp46_ = _tmp45_;
				gee_collection_add ((GeeCollection*) _tmp44_, (GeeList*) _tmp46_);
				_g_object_unref0 (_tmp46_);
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp47_ = FALSE;
						_tmp47_ = TRUE;
						while (TRUE) {
							gint _tmp49_;
							GeeList* _tmp50_;
							gpointer _tmp51_;
							GeeList* _tmp52_;
							Coord _tmp53_ = {0};
							if (!_tmp47_) {
								gint _tmp48_;
								_tmp48_ = row;
								row = _tmp48_ + 1;
							}
							_tmp47_ = FALSE;
							_tmp49_ = self->priv->_rows;
							if (!(row < _tmp49_)) {
								break;
							}
							_tmp50_ = self->priv->_coords_for_col;
							_tmp51_ = gee_list_get (_tmp50_, col);
							_tmp52_ = (GeeList*) _tmp51_;
							coord_init (&_tmp53_, row, col);
							gee_collection_add ((GeeCollection*) _tmp52_, &_tmp53_);
							_g_object_unref0 (_tmp52_);
						}
					}
				}
				_tmp54_ = self->priv->_coords_for_col;
				_tmp55_ = self->priv->_coords_for_col;
				_tmp56_ = gee_list_get (_tmp55_, col);
				_tmp57_ = (GeeList*) _tmp56_;
				_tmp58_ = gee_list_get_read_only_view (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = _tmp59_;
				gee_list_set (_tmp54_, col, _tmp60_);
				_g_object_unref0 (_tmp60_);
				_g_object_unref0 (_tmp57_);
			}
		}
	}
	_tmp61_ = self->priv->_coords_for_col;
	_tmp62_ = gee_list_get_read_only_view (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = _tmp63_;
	sudoku_board_set_coords_for_col (self, _tmp64_);
	_g_object_unref0 (_tmp64_);
	_tmp65_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp66_ = _tmp65_;
	sudoku_board_set_coords_for_row (self, (GeeList*) _tmp66_);
	_g_object_unref0 (_tmp66_);
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp67_ = FALSE;
			_tmp67_ = TRUE;
			while (TRUE) {
				gint _tmp69_;
				GeeList* _tmp70_;
				GeeArrayList* _tmp71_;
				GeeArrayList* _tmp72_;
				GeeList* _tmp80_;
				GeeList* _tmp81_;
				gpointer _tmp82_;
				GeeList* _tmp83_;
				GeeList* _tmp84_;
				GeeList* _tmp85_;
				GeeList* _tmp86_;
				if (!_tmp67_) {
					gint _tmp68_;
					_tmp68_ = row;
					row = _tmp68_ + 1;
				}
				_tmp67_ = FALSE;
				_tmp69_ = self->priv->_rows;
				if (!(row < _tmp69_)) {
					break;
				}
				_tmp70_ = self->priv->_coords_for_row;
				_tmp71_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
				_tmp72_ = _tmp71_;
				gee_collection_add ((GeeCollection*) _tmp70_, (GeeList*) _tmp72_);
				_g_object_unref0 (_tmp72_);
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp73_ = FALSE;
						_tmp73_ = TRUE;
						while (TRUE) {
							gint _tmp75_;
							GeeList* _tmp76_;
							gpointer _tmp77_;
							GeeList* _tmp78_;
							Coord _tmp79_ = {0};
							if (!_tmp73_) {
								gint _tmp74_;
								_tmp74_ = col;
								col = _tmp74_ + 1;
							}
							_tmp73_ = FALSE;
							_tmp75_ = self->priv->_cols;
							if (!(col < _tmp75_)) {
								break;
							}
							_tmp76_ = self->priv->_coords_for_row;
							_tmp77_ = gee_list_get (_tmp76_, row);
							_tmp78_ = (GeeList*) _tmp77_;
							coord_init (&_tmp79_, row, col);
							gee_collection_add ((GeeCollection*) _tmp78_, &_tmp79_);
							_g_object_unref0 (_tmp78_);
						}
					}
				}
				_tmp80_ = self->priv->_coords_for_row;
				_tmp81_ = self->priv->_coords_for_row;
				_tmp82_ = gee_list_get (_tmp81_, row);
				_tmp83_ = (GeeList*) _tmp82_;
				_tmp84_ = gee_list_get_read_only_view (_tmp83_);
				_tmp85_ = _tmp84_;
				_tmp86_ = _tmp85_;
				gee_list_set (_tmp80_, row, _tmp86_);
				_g_object_unref0 (_tmp86_);
				_g_object_unref0 (_tmp83_);
			}
		}
	}
	_tmp87_ = self->priv->_coords_for_row;
	_tmp88_ = gee_list_get_read_only_view (_tmp87_);
	_tmp89_ = _tmp88_;
	_tmp90_ = _tmp89_;
	sudoku_board_set_coords_for_row (self, _tmp90_);
	_g_object_unref0 (_tmp90_);
	_tmp91_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
	_tmp92_ = _tmp91_;
	sudoku_board_set_coords_for_block (self, (GeeMap*) _tmp92_);
	_g_object_unref0 (_tmp92_);
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp93_ = FALSE;
			_tmp93_ = TRUE;
			while (TRUE) {
				if (!_tmp93_) {
					gint _tmp94_;
					_tmp94_ = col;
					col = _tmp94_ + 1;
				}
				_tmp93_ = FALSE;
				if (!(col < block_cols)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp95_ = FALSE;
						_tmp95_ = TRUE;
						while (TRUE) {
							GeeMap* _tmp97_;
							Coord _tmp98_ = {0};
							GeeArrayList* _tmp99_;
							GeeArrayList* _tmp100_;
							if (!_tmp95_) {
								gint _tmp96_;
								_tmp96_ = row;
								row = _tmp96_ + 1;
							}
							_tmp95_ = FALSE;
							if (!(row < block_rows)) {
								break;
							}
							_tmp97_ = self->priv->_coords_for_block;
							coord_init (&_tmp98_, row, col);
							_tmp99_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
							_tmp100_ = _tmp99_;
							gee_map_set (_tmp97_, &_tmp98_, (GeeList*) _tmp100_);
							_g_object_unref0 (_tmp100_);
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp101_ = FALSE;
			_tmp101_ = TRUE;
			while (TRUE) {
				gint _tmp103_;
				if (!_tmp101_) {
					gint _tmp102_;
					_tmp102_ = col;
					col = _tmp102_ + 1;
				}
				_tmp101_ = FALSE;
				_tmp103_ = self->priv->_cols;
				if (!(col < _tmp103_)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp104_ = FALSE;
						_tmp104_ = TRUE;
						while (TRUE) {
							gint _tmp106_;
							GeeMap* _tmp107_;
							Coord _tmp108_ = {0};
							gpointer _tmp109_;
							GeeList* _tmp110_;
							Coord _tmp111_ = {0};
							if (!_tmp104_) {
								gint _tmp105_;
								_tmp105_ = row;
								row = _tmp105_ + 1;
							}
							_tmp104_ = FALSE;
							_tmp106_ = self->priv->_rows;
							if (!(row < _tmp106_)) {
								break;
							}
							_tmp107_ = self->priv->_coords_for_block;
							coord_init (&_tmp108_, row / block_rows, col / block_cols);
							_tmp109_ = gee_map_get (_tmp107_, &_tmp108_);
							_tmp110_ = (GeeList*) _tmp109_;
							coord_init (&_tmp111_, row, col);
							gee_collection_add ((GeeCollection*) _tmp110_, &_tmp111_);
							_g_object_unref0 (_tmp110_);
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
		col = 0;
		{
			gboolean _tmp112_ = FALSE;
			_tmp112_ = TRUE;
			while (TRUE) {
				if (!_tmp112_) {
					gint _tmp113_;
					_tmp113_ = col;
					col = _tmp113_ + 1;
				}
				_tmp112_ = FALSE;
				if (!(col < block_cols)) {
					break;
				}
				{
					gint row = 0;
					row = 0;
					{
						gboolean _tmp114_ = FALSE;
						_tmp114_ = TRUE;
						while (TRUE) {
							GeeMap* _tmp116_;
							Coord _tmp117_ = {0};
							GeeMap* _tmp118_;
							Coord _tmp119_ = {0};
							gpointer _tmp120_;
							GeeList* _tmp121_;
							GeeList* _tmp122_;
							GeeList* _tmp123_;
							GeeList* _tmp124_;
							if (!_tmp114_) {
								gint _tmp115_;
								_tmp115_ = row;
								row = _tmp115_ + 1;
							}
							_tmp114_ = FALSE;
							if (!(row < block_rows)) {
								break;
							}
							_tmp116_ = self->priv->_coords_for_block;
							coord_init (&_tmp117_, row, col);
							_tmp118_ = self->priv->_coords_for_block;
							coord_init (&_tmp119_, row, col);
							_tmp120_ = gee_map_get (_tmp118_, &_tmp119_);
							_tmp121_ = (GeeList*) _tmp120_;
							_tmp122_ = gee_list_get_read_only_view (_tmp121_);
							_tmp123_ = _tmp122_;
							_tmp124_ = _tmp123_;
							gee_map_set (_tmp116_, &_tmp117_, _tmp124_);
							_g_object_unref0 (_tmp124_);
							_g_object_unref0 (_tmp121_);
						}
					}
				}
			}
		}
	}
	_tmp125_ = self->priv->_coords_for_block;
	_tmp126_ = gee_map_get_read_only_view (_tmp125_);
	_tmp127_ = _tmp126_;
	_tmp128_ = _tmp127_;
	sudoku_board_set_coords_for_block (self, _tmp128_);
	_g_object_unref0 (_tmp128_);
	return self;
}

SudokuBoard*
sudoku_board_new (gint block_rows,
                  gint block_cols)
{
	return sudoku_board_construct (TYPE_SUDOKU_BOARD, block_rows, block_cols);
}

static gint*
_vala_array_dup1 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gint*
_vala_array_dup2 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gboolean*
_vala_array_dup3 (gboolean* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gboolean));
	}
	return NULL;
}

static gint*
_vala_array_dup4 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gint*
_vala_array_dup5 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gint*
_vala_array_dup6 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

static gboolean*
_vala_array_dup7 (gboolean* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gboolean));
	}
	return NULL;
}

SudokuBoard*
sudoku_board_clone (SudokuBoard* self)
{
	SudokuBoard* board = NULL;
	gint _tmp0_;
	gint _tmp1_;
	SudokuBoard* _tmp2_;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint* _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	gboolean* _tmp7_;
	gint _tmp7__length1;
	gint _tmp7__length2;
	gboolean* _tmp8_;
	gint _tmp8__length1;
	gint _tmp8__length2;
	gint* _tmp9_;
	gint _tmp9__length1;
	gint _tmp9__length2;
	gint* _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	gint* _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	gint* _tmp12_;
	gint _tmp12__length1;
	gint _tmp12__length2;
	gint* _tmp13_;
	gint _tmp13__length1;
	gint _tmp13__length2;
	gint _tmp13__length3;
	gint* _tmp14_;
	gint _tmp14__length1;
	gint _tmp14__length2;
	gint _tmp14__length3;
	gint _tmp15_;
	gint _tmp16_;
	GeeSet* _tmp17_;
	GeeSet* _tmp18_;
	gboolean* _tmp19_;
	gint _tmp19__length1;
	gint _tmp19__length2;
	gint _tmp19__length3;
	gboolean* _tmp20_;
	gint _tmp20__length1;
	gint _tmp20__length2;
	gint _tmp20__length3;
	DifficultyCategory _tmp21_;
	SudokuBoard* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_block_rows;
	_tmp1_ = self->priv->_block_cols;
	_tmp2_ = sudoku_board_new (_tmp0_, _tmp1_);
	board = _tmp2_;
	_tmp3_ = self->priv->cells;
	_tmp3__length1 = self->priv->cells_length1;
	_tmp3__length2 = self->priv->cells_length2;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1 * _tmp3__length2) : _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	_tmp4__length2 = _tmp3__length2;
	board->priv->cells = (g_free (board->priv->cells), NULL);
	board->priv->cells = _tmp4_;
	board->priv->cells_length1 = _tmp4__length1;
	board->priv->cells_length2 = _tmp4__length2;
	_tmp5_ = self->priv->solution;
	_tmp5__length1 = self->priv->solution_length1;
	_tmp5__length2 = self->priv->solution_length2;
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1 * _tmp5__length2) : _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	_tmp6__length2 = _tmp5__length2;
	board->priv->solution = (g_free (board->priv->solution), NULL);
	board->priv->solution = _tmp6_;
	board->priv->solution_length1 = _tmp6__length1;
	board->priv->solution_length2 = _tmp6__length2;
	_tmp7_ = self->priv->is_fixed;
	_tmp7__length1 = self->priv->is_fixed_length1;
	_tmp7__length2 = self->priv->is_fixed_length2;
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup3 (_tmp7_, _tmp7__length1 * _tmp7__length2) : _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	_tmp8__length2 = _tmp7__length2;
	board->priv->is_fixed = (g_free (board->priv->is_fixed), NULL);
	board->priv->is_fixed = _tmp8_;
	board->priv->is_fixed_length1 = _tmp8__length1;
	board->priv->is_fixed_length2 = _tmp8__length2;
	_tmp9_ = self->priv->occurences_in_row;
	_tmp9__length1 = self->priv->occurences_in_row_length1;
	_tmp9__length2 = self->priv->occurences_in_row_length2;
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup4 (_tmp9_, _tmp9__length1 * _tmp9__length2) : _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	_tmp10__length2 = _tmp9__length2;
	board->priv->occurences_in_row = (g_free (board->priv->occurences_in_row), NULL);
	board->priv->occurences_in_row = _tmp10_;
	board->priv->occurences_in_row_length1 = _tmp10__length1;
	board->priv->occurences_in_row_length2 = _tmp10__length2;
	_tmp11_ = self->priv->occurences_in_col;
	_tmp11__length1 = self->priv->occurences_in_col_length1;
	_tmp11__length2 = self->priv->occurences_in_col_length2;
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup5 (_tmp11_, _tmp11__length1 * _tmp11__length2) : _tmp11_;
	_tmp12__length1 = _tmp11__length1;
	_tmp12__length2 = _tmp11__length2;
	board->priv->occurences_in_col = (g_free (board->priv->occurences_in_col), NULL);
	board->priv->occurences_in_col = _tmp12_;
	board->priv->occurences_in_col_length1 = _tmp12__length1;
	board->priv->occurences_in_col_length2 = _tmp12__length2;
	_tmp13_ = self->priv->occurences_in_block;
	_tmp13__length1 = self->priv->occurences_in_block_length1;
	_tmp13__length2 = self->priv->occurences_in_block_length2;
	_tmp13__length3 = self->priv->occurences_in_block_length3;
	_tmp14_ = (_tmp13_ != NULL) ? _vala_array_dup6 (_tmp13_, (_tmp13__length1 * _tmp13__length2) * _tmp13__length3) : _tmp13_;
	_tmp14__length1 = _tmp13__length1;
	_tmp14__length2 = _tmp13__length2;
	_tmp14__length3 = _tmp13__length3;
	board->priv->occurences_in_block = (g_free (board->priv->occurences_in_block), NULL);
	board->priv->occurences_in_block = _tmp14_;
	board->priv->occurences_in_block_length1 = _tmp14__length1;
	board->priv->occurences_in_block_length2 = _tmp14__length2;
	board->priv->occurences_in_block_length3 = _tmp14__length3;
	_tmp15_ = self->priv->_filled;
	sudoku_board_set_filled (board, _tmp15_);
	_tmp16_ = self->priv->_fixed;
	sudoku_board_set_fixed (board, _tmp16_);
	board->priv->n_earmarks = self->priv->n_earmarks;
	_tmp17_ = board->priv->_broken_coords;
	_tmp18_ = self->priv->_broken_coords;
	gee_collection_add_all ((GeeCollection*) _tmp17_, (GeeCollection*) _tmp18_);
	_tmp19_ = self->priv->earmarks;
	_tmp19__length1 = self->priv->earmarks_length1;
	_tmp19__length2 = self->priv->earmarks_length2;
	_tmp19__length3 = self->priv->earmarks_length3;
	_tmp20_ = (_tmp19_ != NULL) ? _vala_array_dup7 (_tmp19_, (_tmp19__length1 * _tmp19__length2) * _tmp19__length3) : _tmp19_;
	_tmp20__length1 = _tmp19__length1;
	_tmp20__length2 = _tmp19__length2;
	_tmp20__length3 = _tmp19__length3;
	board->priv->earmarks = (g_free (board->priv->earmarks), NULL);
	board->priv->earmarks = _tmp20_;
	board->priv->earmarks_length1 = _tmp20__length1;
	board->priv->earmarks_length2 = _tmp20__length2;
	board->priv->earmarks_length3 = _tmp20__length3;
	_tmp21_ = self->priv->_difficulty_category;
	sudoku_board_set_difficulty_category (board, _tmp21_);
	result = board;
	return result;
}

gboolean
sudoku_board_get_is_fixed (SudokuBoard* self,
                           gint row,
                           gint column)
{
	gboolean* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->is_fixed;
	_tmp0__length1 = self->priv->is_fixed_length1;
	_tmp0__length2 = self->priv->is_fixed_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + column];
	result = _tmp1_;
	return result;
}

void
sudoku_board_set_is_fixed (SudokuBoard* self,
                           gint row,
                           gint column,
                           gboolean _value)
{
	gboolean* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_fixed;
	_tmp0__length1 = self->priv->is_fixed_length1;
	_tmp0__length2 = self->priv->is_fixed_length2;
	_tmp0_[(row * _tmp0__length2) + column] = _value;
}

void
sudoku_board_enable_earmark (SudokuBoard* self,
                             gint row,
                             gint column,
                             gint num)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gboolean* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	gint _tmp2__length3;
	gboolean _tmp3_;
	gboolean* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint _tmp4__length3;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + column];
	_vala_return_if_fail (_tmp1_ == 0, "cells[row, column] == 0");
	_tmp2_ = self->priv->earmarks;
	_tmp2__length1 = self->priv->earmarks_length1;
	_tmp2__length2 = self->priv->earmarks_length2;
	_tmp2__length3 = self->priv->earmarks_length3;
	_tmp3_ = _tmp2_[(((row * _tmp2__length2) + column) * _tmp2__length3) + (num - 1)];
	_vala_return_if_fail (!_tmp3_, "!earmarks[row, column, num-1]");
	_tmp4_ = self->priv->earmarks;
	_tmp4__length1 = self->priv->earmarks_length1;
	_tmp4__length2 = self->priv->earmarks_length2;
	_tmp4__length3 = self->priv->earmarks_length3;
	_tmp4_[(((row * _tmp4__length2) + column) * _tmp4__length3) + (num - 1)] = TRUE;
	_tmp5_ = self->priv->n_earmarks;
	self->priv->n_earmarks = _tmp5_ + 1;
	g_signal_emit (self, sudoku_board_signals[SUDOKU_BOARD_EARMARK_CHANGED_SIGNAL], 0, row, column, num, TRUE);
}

void
sudoku_board_disable_earmark (SudokuBoard* self,
                              gint row,
                              gint column,
                              gint num)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gboolean* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	gint _tmp2__length3;
	gboolean _tmp3_;
	gboolean* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint _tmp4__length3;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + column];
	_vala_return_if_fail (_tmp1_ == 0, "cells[row, column] == 0");
	_tmp2_ = self->priv->earmarks;
	_tmp2__length1 = self->priv->earmarks_length1;
	_tmp2__length2 = self->priv->earmarks_length2;
	_tmp2__length3 = self->priv->earmarks_length3;
	_tmp3_ = _tmp2_[(((row * _tmp2__length2) + column) * _tmp2__length3) + (num - 1)];
	_vala_return_if_fail (_tmp3_, "earmarks[row, column, num-1]");
	_tmp4_ = self->priv->earmarks;
	_tmp4__length1 = self->priv->earmarks_length1;
	_tmp4__length2 = self->priv->earmarks_length2;
	_tmp4__length3 = self->priv->earmarks_length3;
	_tmp4_[(((row * _tmp4__length2) + column) * _tmp4__length3) + (num - 1)] = FALSE;
	_tmp5_ = self->priv->n_earmarks;
	self->priv->n_earmarks = _tmp5_ - 1;
	g_signal_emit (self, sudoku_board_signals[SUDOKU_BOARD_EARMARK_CHANGED_SIGNAL], 0, row, column, num, FALSE);
}

void
sudoku_board_disable_all_earmarks (SudokuBoard* self,
                                   gint row,
                                   gint column)
{
	g_return_if_fail (self != NULL);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				gboolean* _tmp4_;
				gint _tmp4__length1;
				gint _tmp4__length2;
				gint _tmp4__length3;
				gboolean _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = sudoku_board_get_max_val (self);
				_tmp3_ = _tmp2_;
				if (!(i <= _tmp3_)) {
					break;
				}
				_tmp4_ = self->priv->earmarks;
				_tmp4__length1 = self->priv->earmarks_length1;
				_tmp4__length2 = self->priv->earmarks_length2;
				_tmp4__length3 = self->priv->earmarks_length3;
				_tmp5_ = _tmp4_[(((row * _tmp4__length2) + column) * _tmp4__length3) + (i - 1)];
				if (_tmp5_) {
					sudoku_board_disable_earmark (self, row, column, i);
				}
			}
		}
	}
}

gboolean
sudoku_board_is_earmark_enabled (SudokuBoard* self,
                                 gint row,
                                 gint column,
                                 gint num)
{
	gboolean* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp0__length3;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->earmarks;
	_tmp0__length1 = self->priv->earmarks_length1;
	_tmp0__length2 = self->priv->earmarks_length2;
	_tmp0__length3 = self->priv->earmarks_length3;
	_tmp1_ = _tmp0_[(((row * _tmp0__length2) + column) * _tmp0__length3) + (num - 1)];
	result = _tmp1_;
	return result;
}

gboolean
sudoku_board_is_possible (SudokuBoard* self,
                          gint row,
                          gint col,
                          gint val)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	gint _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp2_ = self->priv->occurences_in_row;
	_tmp2__length1 = self->priv->occurences_in_row_length1;
	_tmp2__length2 = self->priv->occurences_in_row_length2;
	_tmp3_ = _tmp2_[(row * _tmp2__length2) + (val - 1)];
	if (_tmp3_ == 0) {
		gint* _tmp4_;
		gint _tmp4__length1;
		gint _tmp4__length2;
		gint _tmp5_;
		_tmp4_ = self->priv->occurences_in_col;
		_tmp4__length1 = self->priv->occurences_in_col_length1;
		_tmp4__length2 = self->priv->occurences_in_col_length2;
		_tmp5_ = _tmp4_[(col * _tmp4__length2) + (val - 1)];
		_tmp1_ = _tmp5_ == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint* _tmp6_;
		gint _tmp6__length1;
		gint _tmp6__length2;
		gint _tmp6__length3;
		gint _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp6_ = self->priv->occurences_in_block;
		_tmp6__length1 = self->priv->occurences_in_block_length1;
		_tmp6__length2 = self->priv->occurences_in_block_length2;
		_tmp6__length3 = self->priv->occurences_in_block_length3;
		_tmp7_ = self->priv->_block_cols;
		_tmp8_ = self->priv->_block_rows;
		_tmp9_ = _tmp6_[((((row / _tmp7_) * _tmp6__length2) + (col / _tmp8_)) * _tmp6__length3) + (val - 1)];
		_tmp0_ = _tmp9_ == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gint
sudoku_board_count_possibilities (SudokuBoard* self,
                                  gint row,
                                  gint col)
{
	gint _tmp0_ = 0;
	gint* _tmp1_;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = sudoku_board_get_possibilities (self, row, col, &_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp0_;
	_tmp3_ = _tmp0_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	result = _tmp3_;
	return result;
}

static gint*
_vala_array_dup8 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

gint*
sudoku_board_get_possibilities (SudokuBoard* self,
                                gint row,
                                gint col,
                                gint* result_length1)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint* possibilities = NULL;
	gint* _tmp4_;
	gint possibilities_length1;
	gint _possibilities_size_;
	gint count = 0;
	gint* _tmp11_;
	gint _tmp11__length1;
	gint* _tmp12_;
	gint _tmp12__length1;
	gint* _tmp13_;
	gint _tmp13__length1;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	if (_tmp1_ != 0) {
		gint* _tmp2_;
		gint* _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = g_new0 (gint, 0);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		return result;
	}
	_tmp4_ = g_new0 (gint, 9);
	possibilities = _tmp4_;
	possibilities_length1 = 9;
	_possibilities_size_ = possibilities_length1;
	count = 0;
	{
		gint l = 0;
		l = 1;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = l;
					l = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = sudoku_board_get_max_val (self);
				_tmp8_ = _tmp7_;
				if (!(l <= _tmp8_)) {
					break;
				}
				if (sudoku_board_is_possible (self, row, col, l)) {
					gint* _tmp9_;
					gint _tmp9__length1;
					gint _tmp10_;
					_tmp9_ = possibilities;
					_tmp9__length1 = possibilities_length1;
					_tmp9_[count] = l;
					_tmp10_ = count;
					count = _tmp10_ + 1;
				}
			}
		}
	}
	_tmp11_ = possibilities;
	_tmp11__length1 = possibilities_length1;
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup8 (_tmp11_ + 0, count - 0) : _tmp11_;
	_tmp12__length1 = count - 0;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _tmp12__length1;
	if (result_length1) {
		*result_length1 = _tmp13__length1;
	}
	result = _tmp13_;
	possibilities = (g_free (possibilities), NULL);
	return result;
}

gboolean*
sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self,
                                              gint row,
                                              gint col,
                                              gint* result_length1)
{
	gboolean* possibilities = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gboolean* _tmp2_;
	gint possibilities_length1;
	gint _possibilities_size_;
	gboolean* _tmp8_;
	gint _tmp8__length1;
	gboolean* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_board_get_max_val (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gboolean, _tmp1_);
	possibilities = _tmp2_;
	possibilities_length1 = _tmp1_;
	_possibilities_size_ = possibilities_length1;
	{
		gint l = 0;
		l = 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				gboolean* _tmp7_;
				gint _tmp7__length1;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = l;
					l = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = sudoku_board_get_max_val (self);
				_tmp6_ = _tmp5_;
				if (!(l <= _tmp6_)) {
					break;
				}
				_tmp7_ = possibilities;
				_tmp7__length1 = possibilities_length1;
				_tmp7_[l - 1] = sudoku_board_is_possible (self, row, col, l);
			}
		}
	}
	_tmp8_ = possibilities;
	_tmp8__length1 = possibilities_length1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	return result;
}

void
sudoku_board_get_block_for (SudokuBoard* self,
                            gint row,
                            gint col,
                            Coord* result)
{
	gint _tmp0_;
	gint _tmp1_;
	Coord _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_block_rows;
	_tmp1_ = self->priv->_block_cols;
	coord_init (&_tmp2_, row / _tmp0_, col / _tmp1_);
	*result = _tmp2_;
	return;
}

void
sudoku_board_insert (SudokuBoard* self,
                     gint row,
                     gint col,
                     gint val,
                     gboolean is_fixed)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	gboolean _tmp3_;
	gint old_val = 0;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint _tmp5_;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	gboolean* _tmp7_;
	gint _tmp7__length1;
	gint _tmp7__length2;
	gboolean _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_board_get_max_val (self);
	_tmp1_ = _tmp0_;
	_vala_return_if_fail ((val > 0) && (val <= _tmp1_), "val > 0 && val <= max_val");
	_tmp2_ = self->priv->is_fixed;
	_tmp2__length1 = self->priv->is_fixed_length1;
	_tmp2__length2 = self->priv->is_fixed_length2;
	_tmp3_ = _tmp2_[(row * _tmp2__length2) + col];
	_vala_return_if_fail (!_tmp3_, "!this.is_fixed[row, col]");
	_tmp4_ = self->priv->cells;
	_tmp4__length1 = self->priv->cells_length1;
	_tmp4__length2 = self->priv->cells_length2;
	_tmp5_ = _tmp4_[(row * _tmp4__length2) + col];
	old_val = _tmp5_;
	_tmp6_ = self->priv->cells;
	_tmp6__length1 = self->priv->cells_length1;
	_tmp6__length2 = self->priv->cells_length2;
	_tmp6_[(row * _tmp6__length2) + col] = val;
	_tmp7_ = self->priv->is_fixed;
	_tmp7__length1 = self->priv->is_fixed_length1;
	_tmp7__length2 = self->priv->is_fixed_length2;
	_tmp7_[(row * _tmp7__length2) + col] = is_fixed;
	if (is_fixed) {
		gint _tmp8_;
		_tmp8_ = self->priv->_fixed;
		sudoku_board_set_fixed (self, _tmp8_ + 1);
	}
	if (old_val != 0) {
		sudoku_board_update_old_breakages (self, row, col, old_val);
	} else {
		gint _tmp9_;
		_tmp9_ = self->priv->_filled;
		sudoku_board_set_filled (self, _tmp9_ + 1);
	}
	sudoku_board_mark_breakages (self, row, col, val);
	sudoku_board_add_to_occurences (self, row, col, val, 1);
	_tmp10_ = sudoku_board_get_complete (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		g_signal_emit (self, sudoku_board_signals[SUDOKU_BOARD_COMPLETED_SIGNAL], 0);
	}
	g_signal_emit (self, sudoku_board_signals[SUDOKU_BOARD_CELL_CHANGED_SIGNAL], 0, row, col, old_val, val);
}

void
sudoku_board_remove (SudokuBoard* self,
                     gint row,
                     gint col)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gboolean* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	gboolean _tmp3_;
	gint old_val = 0;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint _tmp5_;
	gint* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	_vala_return_if_fail (_tmp1_ > 0, "cells[row, col] > 0");
	_tmp2_ = self->priv->is_fixed;
	_tmp2__length1 = self->priv->is_fixed_length1;
	_tmp2__length2 = self->priv->is_fixed_length2;
	_tmp3_ = _tmp2_[(row * _tmp2__length2) + col];
	_vala_return_if_fail (!_tmp3_, "!this.is_fixed[row, col]");
	_tmp4_ = self->priv->cells;
	_tmp4__length1 = self->priv->cells_length1;
	_tmp4__length2 = self->priv->cells_length2;
	_tmp5_ = _tmp4_[(row * _tmp4__length2) + col];
	old_val = _tmp5_;
	_tmp6_ = self->priv->cells;
	_tmp6__length1 = self->priv->cells_length1;
	_tmp6__length2 = self->priv->cells_length2;
	_tmp6_[(row * _tmp6__length2) + col] = 0;
	_tmp7_ = self->priv->_filled;
	sudoku_board_set_filled (self, _tmp7_ - 1);
	sudoku_board_update_old_breakages (self, row, col, old_val);
	g_signal_emit (self, sudoku_board_signals[SUDOKU_BOARD_CELL_CHANGED_SIGNAL], 0, row, col, old_val, 0);
}

gint
sudoku_board_get (SudokuBoard* self,
                  gint row,
                  gint col)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + col];
	result = _tmp1_;
	return result;
}

void
sudoku_board_set (SudokuBoard* self,
                  gint row,
                  gint col,
                  gint val)
{
	g_return_if_fail (self != NULL);
	if (val == 0) {
		sudoku_board_remove (self, row, col);
	} else {
		gboolean _tmp0_ = FALSE;
		if (val > 0) {
			gint _tmp1_;
			gint _tmp2_;
			_tmp1_ = sudoku_board_get_max_val (self);
			_tmp2_ = _tmp1_;
			_tmp0_ = val <= _tmp2_;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			sudoku_board_insert (self, row, col, val, FALSE);
		} else {
			g_assert_not_reached ();
		}
	}
}

static void
sudoku_board_update_old_breakages (SudokuBoard* self,
                                   gint row,
                                   gint col,
                                   gint val)
{
	GeeSet* _tmp0_;
	Coord _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	sudoku_board_add_to_occurences (self, row, col, val, -1);
	_tmp0_ = self->priv->_broken_coords;
	coord_init (&_tmp1_, row, col);
	if (gee_collection_contains ((GeeCollection*) _tmp0_, &_tmp1_)) {
		GeeSet* _tmp2_;
		Coord _tmp3_ = {0};
		GeeList* _tmp4_;
		gpointer _tmp5_;
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		gpointer _tmp8_;
		GeeList* _tmp9_;
		GeeMap* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		Coord _tmp13_ = {0};
		gpointer _tmp14_;
		GeeList* _tmp15_;
		_tmp2_ = self->priv->_broken_coords;
		coord_init (&_tmp3_, row, col);
		gee_collection_remove ((GeeCollection*) _tmp2_, &_tmp3_);
		_tmp4_ = self->priv->_coords_for_row;
		_tmp5_ = gee_list_get (_tmp4_, row);
		_tmp6_ = (GeeList*) _tmp5_;
		sudoku_board_remove_breakages_for (self, _tmp6_, val);
		_g_object_unref0 (_tmp6_);
		_tmp7_ = self->priv->_coords_for_col;
		_tmp8_ = gee_list_get (_tmp7_, col);
		_tmp9_ = (GeeList*) _tmp8_;
		sudoku_board_remove_breakages_for (self, _tmp9_, val);
		_g_object_unref0 (_tmp9_);
		_tmp10_ = self->priv->_coords_for_block;
		_tmp11_ = self->priv->_block_rows;
		_tmp12_ = self->priv->_block_cols;
		coord_init (&_tmp13_, row / _tmp11_, col / _tmp12_);
		_tmp14_ = gee_map_get (_tmp10_, &_tmp13_);
		_tmp15_ = (GeeList*) _tmp14_;
		sudoku_board_remove_breakages_for (self, _tmp15_, val);
		_g_object_unref0 (_tmp15_);
	}
}

static void
sudoku_board_add_to_occurences (SudokuBoard* self,
                                gint row,
                                gint col,
                                gint val,
                                gint add)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	gint _tmp2__length3;
	gint _tmp3_;
	gint _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->occurences_in_row;
	_tmp0__length1 = self->priv->occurences_in_row_length1;
	_tmp0__length2 = self->priv->occurences_in_row_length2;
	_tmp0_[(row * _tmp0__length2) + (val - 1)] += add;
	_tmp1_ = self->priv->occurences_in_col;
	_tmp1__length1 = self->priv->occurences_in_col_length1;
	_tmp1__length2 = self->priv->occurences_in_col_length2;
	_tmp1_[(col * _tmp1__length2) + (val - 1)] += add;
	_tmp2_ = self->priv->occurences_in_block;
	_tmp2__length1 = self->priv->occurences_in_block_length1;
	_tmp2__length2 = self->priv->occurences_in_block_length2;
	_tmp2__length3 = self->priv->occurences_in_block_length3;
	_tmp3_ = self->priv->_block_cols;
	_tmp4_ = self->priv->_block_rows;
	_tmp2_[((((row / _tmp3_) * _tmp2__length2) + (col / _tmp4_)) * _tmp2__length3) + (val - 1)] += add;
}

static void
sudoku_board_mark_breakages (SudokuBoard* self,
                             gint row,
                             gint col,
                             gint val)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint* _tmp5_;
	gint _tmp5__length1;
	gint _tmp5__length2;
	gint _tmp6_;
	gint* _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	gint _tmp10__length3;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->occurences_in_row;
	_tmp0__length1 = self->priv->occurences_in_row_length1;
	_tmp0__length2 = self->priv->occurences_in_row_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + (val - 1)];
	if (_tmp1_ > 0) {
		GeeList* _tmp2_;
		gpointer _tmp3_;
		GeeList* _tmp4_;
		_tmp2_ = self->priv->_coords_for_row;
		_tmp3_ = gee_list_get (_tmp2_, row);
		_tmp4_ = (GeeList*) _tmp3_;
		sudoku_board_mark_breakages_for (self, _tmp4_, val);
		_g_object_unref0 (_tmp4_);
	}
	_tmp5_ = self->priv->occurences_in_col;
	_tmp5__length1 = self->priv->occurences_in_col_length1;
	_tmp5__length2 = self->priv->occurences_in_col_length2;
	_tmp6_ = _tmp5_[(col * _tmp5__length2) + (val - 1)];
	if (_tmp6_ > 0) {
		GeeList* _tmp7_;
		gpointer _tmp8_;
		GeeList* _tmp9_;
		_tmp7_ = self->priv->_coords_for_col;
		_tmp8_ = gee_list_get (_tmp7_, col);
		_tmp9_ = (GeeList*) _tmp8_;
		sudoku_board_mark_breakages_for (self, _tmp9_, val);
		_g_object_unref0 (_tmp9_);
	}
	_tmp10_ = self->priv->occurences_in_block;
	_tmp10__length1 = self->priv->occurences_in_block_length1;
	_tmp10__length2 = self->priv->occurences_in_block_length2;
	_tmp10__length3 = self->priv->occurences_in_block_length3;
	_tmp11_ = self->priv->_block_rows;
	_tmp12_ = self->priv->_block_cols;
	_tmp13_ = _tmp10_[((((row / _tmp11_) * _tmp10__length2) + (col / _tmp12_)) * _tmp10__length3) + (val - 1)];
	if (_tmp13_ > 0) {
		GeeMap* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		Coord _tmp17_ = {0};
		gpointer _tmp18_;
		GeeList* _tmp19_;
		_tmp14_ = self->priv->_coords_for_block;
		_tmp15_ = self->priv->_block_rows;
		_tmp16_ = self->priv->_block_cols;
		coord_init (&_tmp17_, row / _tmp15_, col / _tmp16_);
		_tmp18_ = gee_map_get (_tmp14_, &_tmp17_);
		_tmp19_ = (GeeList*) _tmp18_;
		sudoku_board_mark_breakages_for (self, _tmp19_, val);
		_g_object_unref0 (_tmp19_);
	}
}

void
sudoku_board_set_solution (SudokuBoard* self,
                           gint row,
                           gint col,
                           gint val)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->solution;
	_tmp0__length1 = self->priv->solution_length1;
	_tmp0__length2 = self->priv->solution_length2;
	_vala_return_if_fail (_tmp0_ != NULL, "solution != null");
	_tmp1_ = self->priv->solution;
	_tmp1__length1 = self->priv->solution_length1;
	_tmp1__length2 = self->priv->solution_length2;
	_tmp1_[(row * _tmp1__length2) + col] = val;
}

gint
sudoku_board_get_solution (SudokuBoard* self,
                           gint row,
                           gint col)
{
	gint _tmp0_ = 0;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp1_ = self->priv->solution;
	_tmp1__length1 = self->priv->solution_length1;
	_tmp1__length2 = self->priv->solution_length2;
	if (_tmp1_ == NULL) {
		_tmp0_ = 0;
	} else {
		gint* _tmp2_;
		gint _tmp2__length1;
		gint _tmp2__length2;
		gint _tmp3_;
		_tmp2_ = self->priv->solution;
		_tmp2__length1 = self->priv->solution_length1;
		_tmp2__length2 = self->priv->solution_length2;
		_tmp3_ = _tmp2_[(row * _tmp2__length2) + col];
		_tmp0_ = _tmp3_;
	}
	result = _tmp0_;
	return result;
}

static gint*
sudoku_board_fixed_cells_only (SudokuBoard* self,
                               gint* result_length1,
                               gint* result_length2)
{
	gint* _result_ = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint _result__length1;
	gint _result__length2;
	gint* _tmp15_;
	gint _tmp15__length1;
	gint _tmp15__length2;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = g_new0 (gint, _tmp0_ * _tmp1_);
	_result_ = _tmp2_;
	_result__length1 = _tmp0_;
	_result__length2 = _tmp1_;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = row;
					row = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_rows;
				if (!(row < _tmp5_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_;
							gboolean* _tmp9_;
							gint _tmp9__length1;
							gint _tmp9__length2;
							gboolean _tmp10_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = col;
								col = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->priv->_cols;
							if (!(col < _tmp8_)) {
								break;
							}
							_tmp9_ = self->priv->is_fixed;
							_tmp9__length1 = self->priv->is_fixed_length1;
							_tmp9__length2 = self->priv->is_fixed_length2;
							_tmp10_ = _tmp9_[(row * _tmp9__length2) + col];
							if (_tmp10_) {
								gint* _tmp11_;
								gint _tmp11__length1;
								gint _tmp11__length2;
								gint* _tmp12_;
								gint _tmp12__length1;
								gint _tmp12__length2;
								gint _tmp13_;
								_tmp11_ = _result_;
								_tmp11__length1 = _result__length1;
								_tmp11__length2 = _result__length2;
								_tmp12_ = self->priv->cells;
								_tmp12__length1 = self->priv->cells_length1;
								_tmp12__length2 = self->priv->cells_length2;
								_tmp13_ = _tmp12_[(row * _tmp12__length2) + col];
								_tmp11_[(row * _tmp11__length2) + col] = _tmp13_;
							} else {
								gint* _tmp14_;
								gint _tmp14__length1;
								gint _tmp14__length2;
								_tmp14_ = _result_;
								_tmp14__length1 = _result__length1;
								_tmp14__length2 = _result__length2;
								_tmp14_[(row * _tmp14__length2) + col] = 0;
							}
						}
					}
				}
			}
		}
	}
	_tmp15_ = _result_;
	_tmp15__length1 = _result__length1;
	_tmp15__length2 = _result__length2;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp15__length2;
	}
	result = _tmp15_;
	return result;
}

void
sudoku_board_solve (SudokuBoard* self)
{
	gint* fixed_cells = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint* _tmp2_;
	gint fixed_cells_length1;
	gint fixed_cells_length2;
	gint* solution_1d = NULL;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp3__length2;
	gint _tmp4_ = 0;
	gint* _tmp5_;
	gint solution_1d_length1;
	gint _solution_1d_size_;
	gint* _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	_tmp2_ = sudoku_board_fixed_cells_only (self, &_tmp0_, &_tmp1_);
	fixed_cells = _tmp2_;
	fixed_cells_length1 = _tmp0_;
	fixed_cells_length2 = _tmp1_;
	_tmp3_ = fixed_cells;
	_tmp3__length1 = fixed_cells_length1;
	_tmp3__length2 = fixed_cells_length2;
	_tmp5_ = sudoku_board_convert_2d_to_1d (self, _tmp3_, (gint) _tmp3__length1, (gint) _tmp3__length2, &_tmp4_);
	solution_1d = _tmp5_;
	solution_1d_length1 = _tmp4_;
	_solution_1d_size_ = solution_1d_length1;
	_tmp6_ = solution_1d;
	_tmp6__length1 = solution_1d_length1;
	if (qqwing_solve_puzzle (_tmp6_)) {
		gint* _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint* _tmp10_;
		_tmp7_ = solution_1d;
		_tmp7__length1 = solution_1d_length1;
		_tmp10_ = sudoku_board_convert_1d_to_2d (self, _tmp7_, (gint) _tmp7__length1, &_tmp8_, &_tmp9_);
		self->priv->solution = (g_free (self->priv->solution), NULL);
		self->priv->solution = _tmp10_;
		self->priv->solution_length1 = _tmp8_;
		self->priv->solution_length2 = _tmp9_;
	} else {
		self->priv->solution = (g_free (self->priv->solution), NULL);
		self->priv->solution = NULL;
		self->priv->solution_length1 = 0;
		self->priv->solution_length2 = 0;
	}
	solution_1d = (g_free (solution_1d), NULL);
	fixed_cells = (g_free (fixed_cells), NULL);
}

gboolean
sudoku_board_solved (SudokuBoard* self)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->solution;
	_tmp0__length1 = self->priv->solution_length1;
	_tmp0__length2 = self->priv->solution_length2;
	result = _tmp0_ != NULL;
	return result;
}

gint
sudoku_board_count_solutions_limited (SudokuBoard* self)
{
	gint* cells_1d = NULL;
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_ = 0;
	gint* _tmp2_;
	gint cells_1d_length1;
	gint _cells_1d_size_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp2_ = sudoku_board_convert_2d_to_1d (self, _tmp0_, (gint) _tmp0__length1, (gint) _tmp0__length2, &_tmp1_);
	cells_1d = _tmp2_;
	cells_1d_length1 = _tmp1_;
	_cells_1d_size_ = cells_1d_length1;
	result = qqwing_count_solutions_limited (cells_1d);
	cells_1d = (g_free (cells_1d), NULL);
	return result;
}

GeeSet*
sudoku_board_get_occurences (SudokuBoard* self,
                             GeeList* coords,
                             gint val)
{
	GeeSet* occurences = NULL;
	GeeHashSet* _tmp0_;
	GeeSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (coords != NULL, NULL);
	_tmp0_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
	occurences = (GeeSet*) _tmp0_;
	{
		GeeList* _coord_list = NULL;
		gint _coord_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _coord_index = 0;
		_coord_list = coords;
		_tmp1_ = _coord_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_coord_size = _tmp3_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Coord coord = {0};
			GeeList* _tmp6_;
			gpointer _tmp7_;
			Coord* _tmp8_;
			Coord _tmp9_;
			gint* _tmp10_;
			gint _tmp10__length1;
			gint _tmp10__length2;
			Coord _tmp11_;
			Coord _tmp12_;
			gint _tmp13_;
			_coord_index = _coord_index + 1;
			_tmp4_ = _coord_index;
			_tmp5_ = _coord_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _coord_list;
			_tmp7_ = gee_list_get (_tmp6_, _coord_index);
			_tmp8_ = (Coord*) _tmp7_;
			_tmp9_ = *_tmp8_;
			_coord_free0 (_tmp8_);
			coord = _tmp9_;
			_tmp10_ = self->priv->cells;
			_tmp10__length1 = self->priv->cells_length1;
			_tmp10__length2 = self->priv->cells_length2;
			_tmp11_ = coord;
			_tmp12_ = coord;
			_tmp13_ = _tmp10_[(_tmp11_.row * _tmp10__length2) + _tmp12_.col];
			if (_tmp13_ == val) {
				GeeSet* _tmp14_;
				Coord _tmp15_;
				_tmp14_ = occurences;
				_tmp15_ = coord;
				gee_collection_add ((GeeCollection*) _tmp14_, &_tmp15_);
			}
		}
	}
	result = occurences;
	return result;
}

gboolean
sudoku_board_row_contains (SudokuBoard* self,
                           gint row,
                           gint val)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->occurences_in_row;
	_tmp0__length1 = self->priv->occurences_in_row_length1;
	_tmp0__length2 = self->priv->occurences_in_row_length2;
	_tmp1_ = _tmp0_[(row * _tmp0__length2) + (val - 1)];
	result = _tmp1_ > 0;
	return result;
}

gboolean
sudoku_board_col_contains (SudokuBoard* self,
                           gint col,
                           gint val)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->occurences_in_col;
	_tmp0__length1 = self->priv->occurences_in_col_length1;
	_tmp0__length2 = self->priv->occurences_in_col_length2;
	_tmp1_ = _tmp0_[(col * _tmp0__length2) + (val - 1)];
	result = _tmp1_ > 0;
	return result;
}

gboolean
sudoku_board_block_contains (SudokuBoard* self,
                             gint row_block,
                             gint col_block,
                             gint val)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp0__length3;
	gint _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->occurences_in_block;
	_tmp0__length1 = self->priv->occurences_in_block_length1;
	_tmp0__length2 = self->priv->occurences_in_block_length2;
	_tmp0__length3 = self->priv->occurences_in_block_length3;
	_tmp1_ = _tmp0_[(((row_block * _tmp0__length2) + col_block) * _tmp0__length3) + (val - 1)];
	result = _tmp1_ > 0;
	return result;
}

static void
sudoku_board_remove_breakages_for (SudokuBoard* self,
                                   GeeList* coords,
                                   gint val)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (coords != NULL);
	{
		GeeList* _coord_list = NULL;
		gint _coord_size = 0;
		GeeList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		gint _coord_index = 0;
		_coord_list = coords;
		_tmp0_ = _coord_list;
		_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		_coord_size = _tmp2_;
		_coord_index = -1;
		while (TRUE) {
			gint _tmp3_;
			gint _tmp4_;
			Coord coord = {0};
			GeeList* _tmp5_;
			gpointer _tmp6_;
			Coord* _tmp7_;
			Coord _tmp8_;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			gint* _tmp13_;
			gint _tmp13__length1;
			gint _tmp13__length2;
			Coord _tmp14_;
			Coord _tmp15_;
			gint _tmp16_;
			_coord_index = _coord_index + 1;
			_tmp3_ = _coord_index;
			_tmp4_ = _coord_size;
			if (!(_tmp3_ < _tmp4_)) {
				break;
			}
			_tmp5_ = _coord_list;
			_tmp6_ = gee_list_get (_tmp5_, _coord_index);
			_tmp7_ = (Coord*) _tmp6_;
			_tmp8_ = *_tmp7_;
			_coord_free0 (_tmp7_);
			coord = _tmp8_;
			_tmp13_ = self->priv->cells;
			_tmp13__length1 = self->priv->cells_length1;
			_tmp13__length2 = self->priv->cells_length2;
			_tmp14_ = coord;
			_tmp15_ = coord;
			_tmp16_ = _tmp13_[(_tmp14_.row * _tmp13__length2) + _tmp15_.col];
			if (_tmp16_ == val) {
				GeeSet* _tmp17_;
				Coord _tmp18_;
				_tmp17_ = self->priv->_broken_coords;
				_tmp18_ = coord;
				_tmp12_ = gee_collection_contains ((GeeCollection*) _tmp17_, &_tmp18_);
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				gint* _tmp19_;
				gint _tmp19__length1;
				gint _tmp19__length2;
				Coord _tmp20_;
				gint _tmp21_;
				_tmp19_ = self->priv->occurences_in_row;
				_tmp19__length1 = self->priv->occurences_in_row_length1;
				_tmp19__length2 = self->priv->occurences_in_row_length2;
				_tmp20_ = coord;
				_tmp21_ = _tmp19_[(_tmp20_.row * _tmp19__length2) + (val - 1)];
				_tmp11_ = _tmp21_ <= 1;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				gint* _tmp22_;
				gint _tmp22__length1;
				gint _tmp22__length2;
				Coord _tmp23_;
				gint _tmp24_;
				_tmp22_ = self->priv->occurences_in_col;
				_tmp22__length1 = self->priv->occurences_in_col_length1;
				_tmp22__length2 = self->priv->occurences_in_col_length2;
				_tmp23_ = coord;
				_tmp24_ = _tmp22_[(_tmp23_.col * _tmp22__length2) + (val - 1)];
				_tmp10_ = _tmp24_ <= 1;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				gint* _tmp25_;
				gint _tmp25__length1;
				gint _tmp25__length2;
				gint _tmp25__length3;
				Coord _tmp26_;
				gint _tmp27_;
				Coord _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				_tmp25_ = self->priv->occurences_in_block;
				_tmp25__length1 = self->priv->occurences_in_block_length1;
				_tmp25__length2 = self->priv->occurences_in_block_length2;
				_tmp25__length3 = self->priv->occurences_in_block_length3;
				_tmp26_ = coord;
				_tmp27_ = self->priv->_block_cols;
				_tmp28_ = coord;
				_tmp29_ = self->priv->_block_rows;
				_tmp30_ = _tmp25_[((((_tmp26_.row / _tmp27_) * _tmp25__length2) + (_tmp28_.col / _tmp29_)) * _tmp25__length3) + (val - 1)];
				_tmp9_ = _tmp30_ <= 1;
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				GeeSet* _tmp31_;
				Coord _tmp32_;
				_tmp31_ = self->priv->_broken_coords;
				_tmp32_ = coord;
				gee_collection_remove ((GeeCollection*) _tmp31_, &_tmp32_);
			}
		}
	}
}

static void
sudoku_board_mark_breakages_for (SudokuBoard* self,
                                 GeeList* coords,
                                 gint val)
{
	GeeSet* occurences = NULL;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (coords != NULL);
	_tmp0_ = sudoku_board_get_occurences (self, coords, val);
	occurences = _tmp0_;
	_tmp1_ = occurences;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != 1) {
		GeeSet* _tmp4_;
		GeeSet* _tmp5_;
		_tmp4_ = self->priv->_broken_coords;
		_tmp5_ = occurences;
		gee_collection_add_all ((GeeCollection*) _tmp4_, (GeeCollection*) _tmp5_);
	}
	_g_object_unref0 (occurences);
}

void
sudoku_board_to_initial_state (SudokuBoard* self)
{
	g_return_if_fail (self != NULL);
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = l1;
					l1 = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_rows;
				if (!(l1 < _tmp2_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint _tmp5_;
							gboolean* _tmp6_;
							gint _tmp6__length1;
							gint _tmp6__length2;
							gboolean _tmp7_;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = l2;
								l2 = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							_tmp5_ = self->priv->_cols;
							if (!(l2 < _tmp5_)) {
								break;
							}
							_tmp6_ = self->priv->is_fixed;
							_tmp6__length1 = self->priv->is_fixed_length1;
							_tmp6__length2 = self->priv->is_fixed_length2;
							_tmp7_ = _tmp6_[(l1 * _tmp6__length2) + l2];
							if (!_tmp7_) {
								sudoku_board_remove (self, l1, l2);
							}
						}
					}
				}
			}
		}
	}
}

void
sudoku_board_print (SudokuBoard* self,
                    gint indent)
{
	FILE* _tmp14_;
	g_return_if_fail (self != NULL);
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				FILE* _tmp13_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = l1;
					l1 = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(l1 < 9)) {
					break;
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp2_ = FALSE;
						_tmp2_ = TRUE;
						while (TRUE) {
							FILE* _tmp4_;
							if (!_tmp2_) {
								gint _tmp3_;
								_tmp3_ = i;
								i = _tmp3_ + 1;
							}
							_tmp2_ = FALSE;
							if (!(i < indent)) {
								break;
							}
							_tmp4_ = stdout;
							fprintf (_tmp4_, " ");
						}
					}
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint* _tmp7_;
							gint _tmp7__length1;
							gint _tmp7__length2;
							gint _tmp8_;
							if (!_tmp5_) {
								gint _tmp6_;
								_tmp6_ = l2;
								l2 = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							if (!(l2 < 9)) {
								break;
							}
							_tmp7_ = self->priv->cells;
							_tmp7__length1 = self->priv->cells_length1;
							_tmp7__length2 = self->priv->cells_length2;
							_tmp8_ = _tmp7_[(l1 * _tmp7__length2) + l2];
							if (_tmp8_ != 0) {
								FILE* _tmp9_;
								gint* _tmp10_;
								gint _tmp10__length1;
								gint _tmp10__length2;
								gint _tmp11_;
								_tmp9_ = stdout;
								_tmp10_ = self->priv->cells;
								_tmp10__length1 = self->priv->cells_length1;
								_tmp10__length2 = self->priv->cells_length2;
								_tmp11_ = _tmp10_[(l1 * _tmp10__length2) + l2];
								fprintf (_tmp9_, "%d ", _tmp11_);
							} else {
								FILE* _tmp12_;
								_tmp12_ = stdout;
								fprintf (_tmp12_, "  ");
							}
						}
					}
				}
				_tmp13_ = stdout;
				fprintf (_tmp13_, "\n");
			}
		}
	}
	_tmp14_ = stdout;
	fflush (_tmp14_);
}

void
sudoku_board_get_string (SudokuBoard* self)
{
	FILE* _tmp0_;
	FILE* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = stdout;
	fprintf (_tmp0_, "[ ");
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				FILE* _tmp3_;
				FILE* _tmp10_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = l1;
					l1 = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(l1 < 9)) {
					break;
				}
				_tmp3_ = stdout;
				fprintf (_tmp3_, "[ ");
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							FILE* _tmp6_;
							gint* _tmp7_;
							gint _tmp7__length1;
							gint _tmp7__length2;
							gint _tmp8_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = l2;
								l2 = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							if (!(l2 < 9)) {
								break;
							}
							_tmp6_ = stdout;
							_tmp7_ = self->priv->cells;
							_tmp7__length1 = self->priv->cells_length1;
							_tmp7__length2 = self->priv->cells_length2;
							_tmp8_ = _tmp7_[(l1 * _tmp7__length2) + l2];
							fprintf (_tmp6_, "%d", _tmp8_);
							if (l2 != 8) {
								FILE* _tmp9_;
								_tmp9_ = stdout;
								fprintf (_tmp9_, ",");
							}
						}
					}
				}
				_tmp10_ = stdout;
				fprintf (_tmp10_, " ]");
				if (l1 != 8) {
					FILE* _tmp11_;
					_tmp11_ = stdout;
					fprintf (_tmp11_, ",");
				}
			}
		}
	}
	_tmp12_ = stdout;
	fprintf (_tmp12_, " ]");
}

gchar*
sudoku_board_to_string (SudokuBoard* self,
                        gboolean get_original_state)
{
	gchar* board_string = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	board_string = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_rows;
				if (!(i < _tmp3_)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							gboolean* _tmp7_;
							gint _tmp7__length1;
							gint _tmp7__length2;
							gboolean _tmp8_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = j;
								j = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = self->priv->_cols;
							if (!(j < _tmp6_)) {
								break;
							}
							_tmp7_ = self->priv->is_fixed;
							_tmp7__length1 = self->priv->is_fixed_length1;
							_tmp7__length2 = self->priv->is_fixed_length2;
							_tmp8_ = _tmp7_[(i * _tmp7__length2) + j];
							if (_tmp8_) {
								const gchar* _tmp9_;
								gint* _tmp10_;
								gint _tmp10__length1;
								gint _tmp10__length2;
								gint _tmp11_;
								gchar* _tmp12_;
								gchar* _tmp13_;
								gchar* _tmp14_;
								_tmp9_ = board_string;
								_tmp10_ = self->priv->cells;
								_tmp10__length1 = self->priv->cells_length1;
								_tmp10__length2 = self->priv->cells_length2;
								_tmp11_ = _tmp10_[(i * _tmp10__length2) + j];
								_tmp12_ = g_strdup_printf ("%i", _tmp11_);
								_tmp13_ = _tmp12_;
								_tmp14_ = g_strconcat (_tmp9_, _tmp13_, NULL);
								_g_free0 (board_string);
								board_string = _tmp14_;
								_g_free0 (_tmp13_);
							} else {
								gchar* _tmp15_ = NULL;
								const gchar* _tmp20_;
								gchar* _tmp21_;
								if (get_original_state) {
									gchar* _tmp16_;
									_tmp16_ = g_strdup ("0");
									_g_free0 (_tmp15_);
									_tmp15_ = _tmp16_;
								} else {
									gint* _tmp17_;
									gint _tmp17__length1;
									gint _tmp17__length2;
									gint _tmp18_;
									gchar* _tmp19_;
									_tmp17_ = self->priv->cells;
									_tmp17__length1 = self->priv->cells_length1;
									_tmp17__length2 = self->priv->cells_length2;
									_tmp18_ = _tmp17_[(i * _tmp17__length2) + j];
									_tmp19_ = g_strdup_printf ("%i", _tmp18_);
									_g_free0 (_tmp15_);
									_tmp15_ = _tmp19_;
								}
								_tmp20_ = board_string;
								_tmp21_ = g_strconcat (_tmp20_, _tmp15_, NULL);
								_g_free0 (board_string);
								board_string = _tmp21_;
								_g_free0 (_tmp15_);
							}
						}
					}
				}
			}
		}
	}
	result = board_string;
	return result;
}

static gint*
_vala_array_dup9 (gint* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gint));
	}
	return NULL;
}

gint*
sudoku_board_get_cells (SudokuBoard* self,
                        gint* result_length1,
                        gint* result_length2)
{
	gint* _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	gint* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->cells;
	_tmp0__length1 = self->priv->cells_length1;
	_tmp0__length2 = self->priv->cells_length2;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup9 (_tmp0_, _tmp0__length1 * _tmp0__length2) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp1__length2 = _tmp0__length2;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp2__length2 = _tmp1__length2;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp2__length2;
	}
	result = _tmp2_;
	return result;
}

GeeHashMap*
sudoku_board_calculate_open_squares (SudokuBoard* self)
{
	GeeHashMap* possibilities = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, (GDestroyNotify) coord_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
	possibilities = _tmp0_;
	{
		gint l1 = 0;
		l1 = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = l1;
					l1 = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_rows;
				if (!(l1 < _tmp3_)) {
					break;
				}
				{
					gint l2 = 0;
					l2 = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_;
							gint* _tmp7_;
							gint _tmp7__length1;
							gint _tmp7__length2;
							gint _tmp8_;
							if (!_tmp4_) {
								gint _tmp5_;
								_tmp5_ = l2;
								l2 = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = self->priv->_cols;
							if (!(l2 < _tmp6_)) {
								break;
							}
							_tmp7_ = self->priv->cells;
							_tmp7__length1 = self->priv->cells_length1;
							_tmp7__length2 = self->priv->cells_length2;
							_tmp8_ = _tmp7_[(l1 * _tmp7__length2) + l2];
							if (_tmp8_ == 0) {
								GeeList* possArrayList = NULL;
								GeeArrayList* _tmp9_;
								gint* possArray = NULL;
								gint _tmp10_ = 0;
								gint* _tmp11_;
								gint possArray_length1;
								gint _possArray_size_;
								gint* _tmp12_;
								gint _tmp12__length1;
								GeeHashMap* _tmp14_;
								Coord _tmp15_ = {0};
								GeeList* _tmp16_;
								_tmp9_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
								possArrayList = (GeeList*) _tmp9_;
								_tmp11_ = sudoku_board_get_possibilities (self, l1, l2, &_tmp10_);
								possArray = _tmp11_;
								possArray_length1 = _tmp10_;
								_possArray_size_ = possArray_length1;
								_tmp12_ = possArray;
								_tmp12__length1 = possArray_length1;
								{
									gint* i_collection = NULL;
									gint i_collection_length1 = 0;
									gint _i_collection_size_ = 0;
									gint i_it = 0;
									i_collection = _tmp12_;
									i_collection_length1 = _tmp12__length1;
									for (i_it = 0; i_it < i_collection_length1; i_it = i_it + 1) {
										gint i = 0;
										i = i_collection[i_it];
										{
											GeeList* _tmp13_;
											_tmp13_ = possArrayList;
											gee_collection_add ((GeeCollection*) _tmp13_, (gpointer) ((gintptr) i));
										}
									}
								}
								_tmp14_ = possibilities;
								coord_init (&_tmp15_, l1, l2);
								_tmp16_ = possArrayList;
								gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, &_tmp15_, _tmp16_);
								possArray = (g_free (possArray), NULL);
								_g_object_unref0 (possArrayList);
							}
						}
					}
				}
			}
		}
	}
	result = possibilities;
	return result;
}

gboolean
sudoku_board_is_finished (SudokuBoard* self)
{
	gchar* board_string = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* finishgame_file = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GFile* file = NULL;
	GFile* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = sudoku_board_to_string (self, TRUE);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ".save", NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	board_string = _tmp3_;
	_tmp4_ = sudoku_saver_get_finishgame_dir ();
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_path (G_DIR_SEPARATOR_S, _tmp5_, board_string, NULL);
	finishgame_file = _tmp6_;
	_tmp7_ = g_file_new_for_path (finishgame_file);
	file = _tmp7_;
	result = g_file_query_exists (file, NULL);
	_g_object_unref0 (file);
	_g_free0 (finishgame_file);
	_g_free0 (board_string);
	return result;
}

gboolean*
sudoku_board_get_earmarks (SudokuBoard* self,
                           gint row,
                           gint col,
                           gint* result_length1)
{
	gboolean* the_earmarks = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gboolean* _tmp2_;
	gint the_earmarks_length1;
	gint _the_earmarks_size_;
	gboolean* _tmp10_;
	gint _tmp10__length1;
	gboolean* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sudoku_board_get_max_val (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gboolean, _tmp1_);
	the_earmarks = _tmp2_;
	the_earmarks_length1 = _tmp1_;
	_the_earmarks_size_ = the_earmarks_length1;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				gint _tmp6_;
				gboolean* _tmp7_;
				gint _tmp7__length1;
				gboolean* _tmp8_;
				gint _tmp8__length1;
				gint _tmp8__length2;
				gint _tmp8__length3;
				gboolean _tmp9_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = sudoku_board_get_max_val (self);
				_tmp6_ = _tmp5_;
				if (!(i <= _tmp6_)) {
					break;
				}
				_tmp7_ = the_earmarks;
				_tmp7__length1 = the_earmarks_length1;
				_tmp8_ = self->priv->earmarks;
				_tmp8__length1 = self->priv->earmarks_length1;
				_tmp8__length2 = self->priv->earmarks_length2;
				_tmp8__length3 = self->priv->earmarks_length3;
				_tmp9_ = _tmp8_[(((row * _tmp8__length2) + col) * _tmp8__length3) + (i - 1)];
				_tmp7_[i - 1] = _tmp9_;
			}
		}
	}
	_tmp10_ = the_earmarks;
	_tmp10__length1 = the_earmarks_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}

gboolean
sudoku_board_has_earmarks (SudokuBoard* self,
                           gint row,
                           gint col)
{
	gboolean* current_earmarks = NULL;
	gint _tmp0_ = 0;
	gboolean* _tmp1_;
	gint current_earmarks_length1;
	gint _current_earmarks_size_;
	gboolean has_earmarks = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = sudoku_board_get_earmarks (self, row, col, &_tmp0_);
	current_earmarks = _tmp1_;
	current_earmarks_length1 = _tmp0_;
	_current_earmarks_size_ = current_earmarks_length1;
	has_earmarks = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean* _tmp4_;
				gint _tmp4__length1;
				gboolean _tmp5_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < 9)) {
					break;
				}
				_tmp4_ = current_earmarks;
				_tmp4__length1 = current_earmarks_length1;
				_tmp5_ = _tmp4_[i];
				if (_tmp5_) {
					has_earmarks = TRUE;
					break;
				}
			}
		}
	}
	result = has_earmarks;
	current_earmarks = (g_free (current_earmarks), NULL);
	return result;
}

gchar*
sudoku_board_get_earmarks_string (SudokuBoard* self,
                                  gint row,
                                  gint col)
{
	gchar* s = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	s = _tmp0_;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				gboolean* _tmp5_;
				gint _tmp5__length1;
				gint _tmp5__length2;
				gint _tmp5__length3;
				gboolean _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = sudoku_board_get_max_val (self);
				_tmp4_ = _tmp3_;
				if (!(i <= _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->earmarks;
				_tmp5__length1 = self->priv->earmarks_length1;
				_tmp5__length2 = self->priv->earmarks_length2;
				_tmp5__length3 = self->priv->earmarks_length3;
				_tmp6_ = _tmp5_[(((row * _tmp5__length2) + col) * _tmp5__length3) + (i - 1)];
				if (_tmp6_) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					_tmp7_ = s;
					_tmp8_ = g_strdup_printf ("%i", i);
					_tmp9_ = _tmp8_;
					_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
					_g_free0 (s);
					s = _tmp10_;
					_g_free0 (_tmp9_);
				}
			}
		}
	}
	result = s;
	return result;
}

static gint*
sudoku_board_convert_2d_to_1d (SudokuBoard* self,
                               gint* ints_2d,
                               gint ints_2d_length1,
                               gint ints_2d_length2,
                               gint* result_length1)
{
	gint* ints_1d = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint ints_1d_length1;
	gint _ints_1d_size_;
	gint i = 0;
	gint* _tmp12_;
	gint _tmp12__length1;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = g_new0 (gint, _tmp0_ * _tmp1_);
	ints_1d = _tmp2_;
	ints_1d_length1 = _tmp0_ * _tmp1_;
	_ints_1d_size_ = ints_1d_length1;
	i = 0;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = row;
					row = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_rows;
				if (!(row < _tmp5_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_;
							gint* _tmp9_;
							gint _tmp9__length1;
							gint _tmp10_;
							gint _tmp11_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = col;
								col = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->priv->_cols;
							if (!(col < _tmp8_)) {
								break;
							}
							_tmp9_ = ints_1d;
							_tmp9__length1 = ints_1d_length1;
							_tmp10_ = i;
							i = _tmp10_ + 1;
							_tmp11_ = ints_2d[(row * ints_2d_length2) + col];
							_tmp9_[_tmp10_] = _tmp11_;
						}
					}
				}
			}
		}
	}
	_tmp12_ = ints_1d;
	_tmp12__length1 = ints_1d_length1;
	if (result_length1) {
		*result_length1 = _tmp12__length1;
	}
	result = _tmp12_;
	return result;
}

static gint*
sudoku_board_convert_1d_to_2d (SudokuBoard* self,
                               gint* ints_1d,
                               gint ints_1d_length1,
                               gint* result_length1,
                               gint* result_length2)
{
	gint* ints_2d = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint ints_2d_length1;
	gint ints_2d_length2;
	gint i = 0;
	gint* _tmp12_;
	gint _tmp12__length1;
	gint _tmp12__length2;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	_tmp2_ = g_new0 (gint, _tmp0_ * _tmp1_);
	ints_2d = _tmp2_;
	ints_2d_length1 = _tmp0_;
	ints_2d_length2 = _tmp1_;
	i = 0;
	{
		gint row = 0;
		row = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = row;
					row = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_rows;
				if (!(row < _tmp5_)) {
					break;
				}
				{
					gint col = 0;
					col = 0;
					{
						gboolean _tmp6_ = FALSE;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp8_;
							gint* _tmp9_;
							gint _tmp9__length1;
							gint _tmp9__length2;
							gint _tmp10_;
							gint _tmp11_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = col;
								col = _tmp7_ + 1;
							}
							_tmp6_ = FALSE;
							_tmp8_ = self->priv->_cols;
							if (!(col < _tmp8_)) {
								break;
							}
							_tmp9_ = ints_2d;
							_tmp9__length1 = ints_2d_length1;
							_tmp9__length2 = ints_2d_length2;
							_tmp10_ = i;
							i = _tmp10_ + 1;
							_tmp11_ = ints_1d[_tmp10_];
							_tmp9_[(row * _tmp9__length2) + col] = _tmp11_;
						}
					}
				}
			}
		}
	}
	_tmp12_ = ints_2d;
	_tmp12__length1 = ints_2d_length1;
	_tmp12__length2 = ints_2d_length2;
	if (result_length1) {
		*result_length1 = _tmp12__length1;
	}
	if (result_length2) {
		*result_length2 = _tmp12__length2;
	}
	result = _tmp12_;
	return result;
}

gdouble
sudoku_board_get_previous_played_time (SudokuBoard* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_previous_played_time;
	return result;
}

void
sudoku_board_set_previous_played_time (SudokuBoard* self,
                                       gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_previous_played_time (self);
	if (old_value != value) {
		self->priv->_previous_played_time = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY]);
	}
}

DifficultyCategory
sudoku_board_get_difficulty_category (SudokuBoard* self)
{
	DifficultyCategory result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_difficulty_category;
	return result;
}

void
sudoku_board_set_difficulty_category (SudokuBoard* self,
                                      DifficultyCategory value)
{
	DifficultyCategory old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_difficulty_category (self);
	if (old_value != value) {
		self->priv->_difficulty_category = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY]);
	}
}

gint
sudoku_board_get_block_rows (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_block_rows;
	return result;
}

static void
sudoku_board_set_block_rows (SudokuBoard* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_block_rows (self);
	if (old_value != value) {
		self->priv->_block_rows = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_BLOCK_ROWS_PROPERTY]);
	}
}

gint
sudoku_board_get_block_cols (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_block_cols;
	return result;
}

static void
sudoku_board_set_block_cols (SudokuBoard* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_block_cols (self);
	if (old_value != value) {
		self->priv->_block_cols = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_BLOCK_COLS_PROPERTY]);
	}
}

gint
sudoku_board_get_rows (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rows;
	return result;
}

static void
sudoku_board_set_rows (SudokuBoard* self,
                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_rows (self);
	if (old_value != value) {
		self->priv->_rows = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_ROWS_PROPERTY]);
	}
}

gint
sudoku_board_get_cols (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_cols;
	return result;
}

static void
sudoku_board_set_cols (SudokuBoard* self,
                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_cols (self);
	if (old_value != value) {
		self->priv->_cols = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_COLS_PROPERTY]);
	}
}

gint
sudoku_board_get_max_val (SudokuBoard* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_block_rows;
	_tmp1_ = self->priv->_block_cols;
	result = _tmp0_ * _tmp1_;
	return result;
}

gboolean
sudoku_board_get_broken (SudokuBoard* self)
{
	gboolean result;
	GeeSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_broken_coords;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_ != 0;
	return result;
}

gint
sudoku_board_get_filled (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_filled;
	return result;
}

static void
sudoku_board_set_filled (SudokuBoard* self,
                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_filled (self);
	if (old_value != value) {
		self->priv->_filled = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_FILLED_PROPERTY]);
	}
}

gint
sudoku_board_get_fixed (SudokuBoard* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_fixed;
	return result;
}

static void
sudoku_board_set_fixed (SudokuBoard* self,
                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_fixed (self);
	if (old_value != value) {
		self->priv->_fixed = value;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_FIXED_PROPERTY]);
	}
}

gint
sudoku_board_get_size (SudokuBoard* self)
{
	gint result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_rows;
	_tmp1_ = self->priv->_cols;
	result = _tmp0_ * _tmp1_;
	return result;
}

gboolean
sudoku_board_get_complete (SudokuBoard* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_filled;
	_tmp2_ = self->priv->_cols;
	_tmp3_ = self->priv->_rows;
	if (_tmp1_ == (_tmp2_ * _tmp3_)) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = sudoku_board_get_broken (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

GeeSet*
sudoku_board_get_broken_coords (SudokuBoard* self)
{
	GeeSet* result;
	GeeSet* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_broken_coords;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sudoku_board_set_broken_coords (SudokuBoard* self,
                                GeeSet* value)
{
	GeeSet* old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_broken_coords (self);
	if (old_value != value) {
		GeeSet* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_broken_coords);
		self->priv->_broken_coords = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_BROKEN_COORDS_PROPERTY]);
	}
}

GeeList*
sudoku_board_get_coords_for_col (SudokuBoard* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coords_for_col;
	result = _tmp0_;
	return result;
}

static void
sudoku_board_set_coords_for_col (SudokuBoard* self,
                                 GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_coords_for_col (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_coords_for_col);
		self->priv->_coords_for_col = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_COORDS_FOR_COL_PROPERTY]);
	}
}

GeeList*
sudoku_board_get_coords_for_row (SudokuBoard* self)
{
	GeeList* result;
	GeeList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coords_for_row;
	result = _tmp0_;
	return result;
}

static void
sudoku_board_set_coords_for_row (SudokuBoard* self,
                                 GeeList* value)
{
	GeeList* old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_coords_for_row (self);
	if (old_value != value) {
		GeeList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_coords_for_row);
		self->priv->_coords_for_row = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_COORDS_FOR_ROW_PROPERTY]);
	}
}

GeeMap*
sudoku_board_get_coords_for_block (SudokuBoard* self)
{
	GeeMap* result;
	GeeMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coords_for_block;
	result = _tmp0_;
	return result;
}

static void
sudoku_board_set_coords_for_block (SudokuBoard* self,
                                   GeeMap* value)
{
	GeeMap* old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_board_get_coords_for_block (self);
	if (old_value != value) {
		GeeMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_coords_for_block);
		self->priv->_coords_for_block = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sudoku_board_properties[SUDOKU_BOARD_COORDS_FOR_BLOCK_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__INT_INT_INT_BOOLEAN (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT_INT_BOOLEAN) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gboolean arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_INT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_boolean (param_values + 4), data2);
}

static void
g_cclosure_user_marshal_VOID__INT_INT_INT_INT (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT_INT_INT) (gpointer data1, gint arg_1, gint arg_2, gint arg_3, gint arg_4, gpointer data2);
	register GMarshalFunc_VOID__INT_INT_INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT_INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), data2);
}

static void
sudoku_board_class_init (SudokuBoardClass * klass,
                         gpointer klass_data)
{
	sudoku_board_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuBoard_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_board_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_board_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_board_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY] = g_param_spec_double ("previous-played-time", "previous-played-time", "previous-played-time", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY] = g_param_spec_enum ("difficulty-category", "difficulty-category", "difficulty-category", TYPE_DIFFICULTY_CATEGORY, DIFFICULTY_CATEGORY_UNKNOWN, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_ROWS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_BLOCK_ROWS_PROPERTY] = g_param_spec_int ("block-rows", "block-rows", "block-rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_COLS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_BLOCK_COLS_PROPERTY] = g_param_spec_int ("block-cols", "block-cols", "block-cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_ROWS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_ROWS_PROPERTY] = g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COLS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_COLS_PROPERTY] = g_param_spec_int ("cols", "cols", "cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_MAX_VAL_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_MAX_VAL_PROPERTY] = g_param_spec_int ("max-val", "max-val", "max-val", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BROKEN_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_BROKEN_PROPERTY] = g_param_spec_boolean ("broken", "broken", "broken", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FILLED_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_FILLED_PROPERTY] = g_param_spec_int ("filled", "filled", "filled", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FIXED_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_FIXED_PROPERTY] = g_param_spec_int ("fixed", "fixed", "fixed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_SIZE_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COMPLETE_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_COMPLETE_PROPERTY] = g_param_spec_boolean ("complete", "complete", "complete", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BROKEN_COORDS_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_BROKEN_COORDS_PROPERTY] = g_param_spec_object ("broken-coords", "broken-coords", "broken-coords", GEE_TYPE_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COORDS_FOR_COL_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_COORDS_FOR_COL_PROPERTY] = g_param_spec_object ("coords-for-col", "coords-for-col", "coords-for-col", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COORDS_FOR_ROW_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_COORDS_FOR_ROW_PROPERTY] = g_param_spec_object ("coords-for-row", "coords-for-row", "coords-for-row", GEE_TYPE_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COORDS_FOR_BLOCK_PROPERTY, sudoku_board_properties[SUDOKU_BOARD_COORDS_FOR_BLOCK_PROPERTY] = g_param_spec_object ("coords-for-block", "coords-for-block", "coords-for-block", GEE_TYPE_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	sudoku_board_signals[SUDOKU_BOARD_COMPLETED_SIGNAL] = g_signal_new ("completed", TYPE_SUDOKU_BOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	sudoku_board_signals[SUDOKU_BOARD_EARMARK_CHANGED_SIGNAL] = g_signal_new ("earmark-changed", TYPE_SUDOKU_BOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT_BOOLEAN, G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_BOOLEAN);
	sudoku_board_signals[SUDOKU_BOARD_CELL_CHANGED_SIGNAL] = g_signal_new ("cell-changed", TYPE_SUDOKU_BOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT_INT_INT, G_TYPE_NONE, 4, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT, G_TYPE_INT);
}

static void
sudoku_board_instance_init (SudokuBoard * self,
                            gpointer klass)
{
	self->priv = sudoku_board_get_instance_private (self);
	self->priv->_previous_played_time = (gdouble) 0;
	self->priv->_difficulty_category = DIFFICULTY_CATEGORY_UNKNOWN;
}

static void
sudoku_board_finalize (GObject * obj)
{
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_BOARD, SudokuBoard);
	self->priv->cells = (g_free (self->priv->cells), NULL);
	self->priv->solution = (g_free (self->priv->solution), NULL);
	self->priv->is_fixed = (g_free (self->priv->is_fixed), NULL);
	self->priv->occurences_in_row = (g_free (self->priv->occurences_in_row), NULL);
	self->priv->occurences_in_col = (g_free (self->priv->occurences_in_col), NULL);
	self->priv->occurences_in_block = (g_free (self->priv->occurences_in_block), NULL);
	self->priv->earmarks = (g_free (self->priv->earmarks), NULL);
	_g_object_unref0 (self->priv->_broken_coords);
	_g_object_unref0 (self->priv->_coords_for_col);
	_g_object_unref0 (self->priv->_coords_for_row);
	_g_object_unref0 (self->priv->_coords_for_block);
	G_OBJECT_CLASS (sudoku_board_parent_class)->finalize (obj);
}

static GType
sudoku_board_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuBoardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_board_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuBoard), 0, (GInstanceInitFunc) sudoku_board_instance_init, NULL };
	GType sudoku_board_type_id;
	sudoku_board_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuBoard", &g_define_type_info, 0);
	SudokuBoard_private_offset = g_type_add_instance_private (sudoku_board_type_id, sizeof (SudokuBoardPrivate));
	return sudoku_board_type_id;
}

GType
sudoku_board_get_type (void)
{
	static volatile gsize sudoku_board_type_id__once = 0;
	if (g_once_init_enter (&sudoku_board_type_id__once)) {
		GType sudoku_board_type_id;
		sudoku_board_type_id = sudoku_board_get_type_once ();
		g_once_init_leave (&sudoku_board_type_id__once, sudoku_board_type_id);
	}
	return sudoku_board_type_id__once;
}

static void
_vala_sudoku_board_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
	switch (property_id) {
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY:
		g_value_set_double (value, sudoku_board_get_previous_played_time (self));
		break;
		case SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY:
		g_value_set_enum (value, sudoku_board_get_difficulty_category (self));
		break;
		case SUDOKU_BOARD_BLOCK_ROWS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_block_rows (self));
		break;
		case SUDOKU_BOARD_BLOCK_COLS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_block_cols (self));
		break;
		case SUDOKU_BOARD_ROWS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_rows (self));
		break;
		case SUDOKU_BOARD_COLS_PROPERTY:
		g_value_set_int (value, sudoku_board_get_cols (self));
		break;
		case SUDOKU_BOARD_MAX_VAL_PROPERTY:
		g_value_set_int (value, sudoku_board_get_max_val (self));
		break;
		case SUDOKU_BOARD_BROKEN_PROPERTY:
		g_value_set_boolean (value, sudoku_board_get_broken (self));
		break;
		case SUDOKU_BOARD_FILLED_PROPERTY:
		g_value_set_int (value, sudoku_board_get_filled (self));
		break;
		case SUDOKU_BOARD_FIXED_PROPERTY:
		g_value_set_int (value, sudoku_board_get_fixed (self));
		break;
		case SUDOKU_BOARD_SIZE_PROPERTY:
		g_value_set_int (value, sudoku_board_get_size (self));
		break;
		case SUDOKU_BOARD_COMPLETE_PROPERTY:
		g_value_set_boolean (value, sudoku_board_get_complete (self));
		break;
		case SUDOKU_BOARD_BROKEN_COORDS_PROPERTY:
		g_value_set_object (value, sudoku_board_get_broken_coords (self));
		break;
		case SUDOKU_BOARD_COORDS_FOR_COL_PROPERTY:
		g_value_set_object (value, sudoku_board_get_coords_for_col (self));
		break;
		case SUDOKU_BOARD_COORDS_FOR_ROW_PROPERTY:
		g_value_set_object (value, sudoku_board_get_coords_for_row (self));
		break;
		case SUDOKU_BOARD_COORDS_FOR_BLOCK_PROPERTY:
		g_value_set_object (value, sudoku_board_get_coords_for_block (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sudoku_board_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
	switch (property_id) {
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME_PROPERTY:
		sudoku_board_set_previous_played_time (self, g_value_get_double (value));
		break;
		case SUDOKU_BOARD_DIFFICULTY_CATEGORY_PROPERTY:
		sudoku_board_set_difficulty_category (self, g_value_get_enum (value));
		break;
		case SUDOKU_BOARD_BLOCK_ROWS_PROPERTY:
		sudoku_board_set_block_rows (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_BLOCK_COLS_PROPERTY:
		sudoku_board_set_block_cols (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_ROWS_PROPERTY:
		sudoku_board_set_rows (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_COLS_PROPERTY:
		sudoku_board_set_cols (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_FILLED_PROPERTY:
		sudoku_board_set_filled (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_FIXED_PROPERTY:
		sudoku_board_set_fixed (self, g_value_get_int (value));
		break;
		case SUDOKU_BOARD_BROKEN_COORDS_PROPERTY:
		sudoku_board_set_broken_coords (self, g_value_get_object (value));
		break;
		case SUDOKU_BOARD_COORDS_FOR_COL_PROPERTY:
		sudoku_board_set_coords_for_col (self, g_value_get_object (value));
		break;
		case SUDOKU_BOARD_COORDS_FOR_ROW_PROPERTY:
		sudoku_board_set_coords_for_row (self, g_value_get_object (value));
		break;
		case SUDOKU_BOARD_COORDS_FOR_BLOCK_PROPERTY:
		sudoku_board_set_coords_for_block (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static GType
house_get_type_once (void)
{
	static const GEnumValue values[] = {{HOUSE_ROW, "HOUSE_ROW", "row"}, {HOUSE_COLUMN, "HOUSE_COLUMN", "column"}, {HOUSE_BLOCK, "HOUSE_BLOCK", "block"}, {0, NULL, NULL}};
	GType house_type_id;
	house_type_id = g_enum_register_static ("House", values);
	return house_type_id;
}

GType
house_get_type (void)
{
	static volatile gsize house_type_id__once = 0;
	if (g_once_init_enter (&house_type_id__once)) {
		GType house_type_id;
		house_type_id = house_get_type_once ();
		g_once_init_leave (&house_type_id__once, house_type_id);
	}
	return house_type_id__once;
}

void
coord_init (Coord *self,
            gint row,
            gint col)
{
	memset (self, 0, sizeof (Coord));
	(*self).row = row;
	(*self).col = col;
}

gint
coord_hash (Coord* coord)
{
	Coord _tmp0_;
	Coord _tmp1_;
	gint result;
	g_return_val_if_fail (coord != NULL, 0);
	_tmp0_ = *coord;
	_tmp1_ = *coord;
	result = (_tmp0_.row * 33) ^ _tmp1_.col;
	return result;
}

gboolean
coord_equal (Coord* a,
             Coord* b)
{
	gboolean _tmp0_ = FALSE;
	Coord _tmp1_;
	Coord _tmp2_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = *a;
	_tmp2_ = *b;
	if (_tmp1_.row == _tmp2_.row) {
		Coord _tmp3_;
		Coord _tmp4_;
		_tmp3_ = *a;
		_tmp4_ = *b;
		_tmp0_ = _tmp3_.col == _tmp4_.col;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

Coord*
coord_dup (const Coord* self)
{
	Coord* dup;
	dup = g_new0 (Coord, 1);
	memcpy (dup, self, sizeof (Coord));
	return dup;
}

void
coord_free (Coord* self)
{
	g_free (self);
}

static GType
coord_get_type_once (void)
{
	GType coord_type_id;
	coord_type_id = g_boxed_type_register_static ("Coord", (GBoxedCopyFunc) coord_dup, (GBoxedFreeFunc) coord_free);
	return coord_type_id;
}

GType
coord_get_type (void)
{
	static volatile gsize coord_type_id__once = 0;
	if (g_once_init_enter (&coord_type_id__once)) {
		GType coord_type_id;
		coord_type_id = coord_get_type_once ();
		g_once_init_leave (&coord_type_id__once, coord_type_id);
	}
	return coord_type_id__once;
}

void
cell_init (Cell *self,
           Coord* coord,
           gint val)
{
	Coord _tmp0_;
	g_return_if_fail (coord != NULL);
	memset (self, 0, sizeof (Cell));
	_tmp0_ = *coord;
	(*self).coord = _tmp0_;
	(*self).val = val;
}

gint
cell_hash (Cell* cell)
{
	Cell _tmp0_;
	Coord _tmp1_;
	Cell _tmp2_;
	gint result;
	g_return_val_if_fail (cell != NULL, 0);
	_tmp0_ = *cell;
	_tmp1_ = _tmp0_.coord;
	_tmp2_ = *cell;
	result = (coord_hash (&_tmp1_) * 33) ^ _tmp2_.val;
	return result;
}

gboolean
cell_equal (Cell* a,
            Cell* b)
{
	gboolean _tmp0_ = FALSE;
	Cell _tmp1_;
	Coord _tmp2_;
	Cell _tmp3_;
	Coord _tmp4_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = *a;
	_tmp2_ = _tmp1_.coord;
	_tmp3_ = *b;
	_tmp4_ = _tmp3_.coord;
	if (coord_equal (&_tmp2_, &_tmp4_)) {
		Cell _tmp5_;
		Cell _tmp6_;
		_tmp5_ = *a;
		_tmp6_ = *b;
		_tmp0_ = _tmp5_.val == _tmp6_.val;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

Cell*
cell_dup (const Cell* self)
{
	Cell* dup;
	dup = g_new0 (Cell, 1);
	memcpy (dup, self, sizeof (Cell));
	return dup;
}

void
cell_free (Cell* self)
{
	g_free (self);
}

static GType
cell_get_type_once (void)
{
	GType cell_type_id;
	cell_type_id = g_boxed_type_register_static ("Cell", (GBoxedCopyFunc) cell_dup, (GBoxedFreeFunc) cell_free);
	return cell_type_id;
}

GType
cell_get_type (void)
{
	static volatile gsize cell_type_id__once = 0;
	if (g_once_init_enter (&cell_type_id__once)) {
		GType cell_type_id;
		cell_type_id = cell_get_type_once ();
		g_once_init_leave (&cell_type_id__once, cell_type_id);
	}
	return cell_type_id__once;
}

gchar*
difficulty_category_to_string (DifficultyCategory self)
{
	gchar* result;
	switch (self) {
		case DIFFICULTY_CATEGORY_UNKNOWN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Unknown Difficulty"));
			result = _tmp0_;
			return result;
		}
		case DIFFICULTY_CATEGORY_EASY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Easy Difficulty"));
			result = _tmp1_;
			return result;
		}
		case DIFFICULTY_CATEGORY_MEDIUM:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Medium Difficulty"));
			result = _tmp2_;
			return result;
		}
		case DIFFICULTY_CATEGORY_HARD:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Hard Difficulty"));
			result = _tmp3_;
			return result;
		}
		case DIFFICULTY_CATEGORY_VERY_HARD:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Very Hard Difficulty"));
			result = _tmp4_;
			return result;
		}
		case DIFFICULTY_CATEGORY_CUSTOM:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Custom Puzzle"));
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

gchar*
difficulty_category_to_untranslated_string (DifficultyCategory self)
{
	gchar* result;
	switch (self) {
		case DIFFICULTY_CATEGORY_UNKNOWN:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("Unknown Difficulty");
			result = _tmp0_;
			return result;
		}
		case DIFFICULTY_CATEGORY_EASY:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("Easy Difficulty");
			result = _tmp1_;
			return result;
		}
		case DIFFICULTY_CATEGORY_MEDIUM:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("Medium Difficulty");
			result = _tmp2_;
			return result;
		}
		case DIFFICULTY_CATEGORY_HARD:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("Hard Difficulty");
			result = _tmp3_;
			return result;
		}
		case DIFFICULTY_CATEGORY_VERY_HARD:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("Very Hard Difficulty");
			result = _tmp4_;
			return result;
		}
		case DIFFICULTY_CATEGORY_CUSTOM:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("Custom Puzzle");
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

DifficultyCategory
difficulty_category_from_string (const gchar* input)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	DifficultyCategory result;
	g_return_val_if_fail (input != NULL, 0);
	_tmp0_ = input;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("Unknown Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_UNKNOWN;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("Easy Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_EASY;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("Medium Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_MEDIUM;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("Hard Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_HARD;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("Very Hard Difficulty")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_VERY_HARD;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("Custom Puzzle")))) {
		switch (0) {
			default:
			{
				result = DIFFICULTY_CATEGORY_CUSTOM;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_warning ("sudoku-board.vala:742: Could not parse difficulty level. Falling back " \
"to Easy difficulty");
				result = DIFFICULTY_CATEGORY_EASY;
				return result;
			}
		}
	}
}

static GType
difficulty_category_get_type_once (void)
{
	static const GEnumValue values[] = {{DIFFICULTY_CATEGORY_UNKNOWN, "DIFFICULTY_CATEGORY_UNKNOWN", "unknown"}, {DIFFICULTY_CATEGORY_EASY, "DIFFICULTY_CATEGORY_EASY", "easy"}, {DIFFICULTY_CATEGORY_MEDIUM, "DIFFICULTY_CATEGORY_MEDIUM", "medium"}, {DIFFICULTY_CATEGORY_HARD, "DIFFICULTY_CATEGORY_HARD", "hard"}, {DIFFICULTY_CATEGORY_VERY_HARD, "DIFFICULTY_CATEGORY_VERY_HARD", "very-hard"}, {DIFFICULTY_CATEGORY_CUSTOM, "DIFFICULTY_CATEGORY_CUSTOM", "custom"}, {0, NULL, NULL}};
	GType difficulty_category_type_id;
	difficulty_category_type_id = g_enum_register_static ("DifficultyCategory", values);
	return difficulty_category_type_id;
}

GType
difficulty_category_get_type (void)
{
	static volatile gsize difficulty_category_type_id__once = 0;
	if (g_once_init_enter (&difficulty_category_type_id__once)) {
		GType difficulty_category_type_id;
		difficulty_category_type_id = difficulty_category_get_type_once ();
		g_once_init_leave (&difficulty_category_type_id__once, difficulty_category_type_id);
	}
	return difficulty_category_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

