/* sudoku-window.c generated by valac 0.56.17, the Vala compiler
 * generated from sudoku-window.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014, 2020 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include "libsudoku.h"
#include <float.h>
#include <math.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <gdk/gdk.h>

#define SUDOKU_WINDOW_board_size 140
#define SUDOKU_WINDOW_clock_in_headerbar_min_width 450
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU_WINDOW (sudoku_window_get_type ())
#define SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_WINDOW, SudokuWindow))
#define SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_WINDOW, SudokuWindowClass))
#define IS_SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_WINDOW))
#define IS_SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_WINDOW))
#define SUDOKU_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_WINDOW, SudokuWindowClass))

typedef struct _SudokuWindow SudokuWindow;
typedef struct _SudokuWindowClass SudokuWindowClass;
typedef struct _SudokuWindowPrivate SudokuWindowPrivate;

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
enum  {
	SUDOKU_WINDOW_0_PROPERTY,
	SUDOKU_WINDOW_VIEW_PROPERTY,
	SUDOKU_WINDOW_SHOW_TIMER_PROPERTY,
	SUDOKU_WINDOW_NUM_PROPERTIES
};
static GParamSpec* sudoku_window_properties[SUDOKU_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SudokuWindow {
	AdwApplicationWindow parent_instance;
	SudokuWindowPrivate * priv;
};

struct _SudokuWindowClass {
	AdwApplicationWindowClass parent_class;
};

struct _SudokuWindowPrivate {
	AdwHeaderBar* headerbar;
	AdwWindowTitle* windowtitle;
	GtkBox* start_box;
	GtkButton* start_button;
	GtkCheckButton* easy_check;
	GtkCheckButton* medium_check;
	GtkCheckButton* hard_check;
	GtkCheckButton* very_hard_check;
	GtkBox* game_box;
	GtkMenuButton* main_menu;
	GtkButton* undo_button;
	GtkButton* redo_button;
	GtkButton* back_button;
	GtkButton* unfullscreen_button;
	GtkBox* clock_box;
	GtkLabel* clock_label;
	GtkImage* clock_image;
	GtkButton* play_custom_game_button;
	GtkButton* play_pause_button;
	gboolean window_is_maximized;
	gboolean window_is_fullscreen;
	gint window_width;
	gint window_height;
	gboolean clock_in_headerbar;
	GSettings* settings;
	SudokuGame* game;
	SudokuView* _view;
	GtkGestureClick* button_controller;
	GtkGestureLongPress* long_press_controller;
	gboolean _show_timer;
};

static gint SudokuWindow_private_offset;
static gpointer sudoku_window_parent_class = NULL;

VALA_EXTERN GType sudoku_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuWindow, g_object_unref)
VALA_EXTERN GType sudoku_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuView, g_object_unref)
VALA_EXTERN gboolean sudoku_window_get_show_timer (SudokuWindow* self);
VALA_EXTERN SudokuWindow* sudoku_window_new (GSettings* settings);
VALA_EXTERN SudokuWindow* sudoku_window_construct (GType object_type,
                                       GSettings* settings);
VALA_EXTERN void sudoku_window_set_show_timer (SudokuWindow* self,
                                   gboolean value);
static void __lambda13_ (SudokuWindow* self);
static void ___lambda13__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda14_ (SudokuWindow* self);
static void ___lambda14__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda15_ (SudokuWindow* self);
VALA_EXTERN SudokuView* sudoku_window_get_view (SudokuWindow* self);
VALA_EXTERN void sudoku_view_set_has_selection (SudokuView* self,
                                    gboolean value);
static void ___lambda15__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void sudoku_window_button_released_cb (SudokuWindow* self,
                                       GtkGestureClick* gesture,
                                       gint n_press,
                                       gdouble x,
                                       gdouble y);
static void _sudoku_window_button_released_cb_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                   gint n_press,
                                                                   gdouble x,
                                                                   gdouble y,
                                                                   gpointer self);
static void sudoku_window_long_press_cb (SudokuWindow* self,
                                  GtkGestureLongPress* gesture,
                                  gdouble x,
                                  gdouble y);
static void _sudoku_window_long_press_cb_gtk_gesture_long_press_pressed (GtkGestureLongPress* _sender,
                                                                  gdouble x,
                                                                  gdouble y,
                                                                  gpointer self);
static void sudoku_window_real_size_allocate (GtkWidget* base,
                                       gint width,
                                       gint height,
                                       gint baseline);
static void sudoku_window_set_clock_placed_in_headerbar (SudokuWindow* self,
                                                  gboolean value);
static void sudoku_window_start_game_cb (SudokuWindow* self,
                                  GtkButton* btn);
static gboolean* _bool_dup (gboolean* self);
static void _sudoku_window_start_game_cb_gtk_button_clicked (GtkButton* _sender,
                                                      gpointer self);
VALA_EXTERN void sudoku_window_will_start_game (SudokuWindow* self);
VALA_EXTERN void sudoku_window_start_game (SudokuWindow* self,
                               SudokuGame* game);
static void sudoku_window_tick_cb (SudokuWindow* self);
static void _sudoku_window_tick_cb_sudoku_game_tick (SudokuGame* _sender,
                                              gpointer self);
VALA_EXTERN void sudoku_window_show_game_view (SudokuWindow* self);
VALA_EXTERN SudokuView* sudoku_view_new (SudokuGame* game,
                             GSettings* settings);
VALA_EXTERN SudokuView* sudoku_view_construct (GType object_type,
                                   SudokuGame* game,
                                   GSettings* settings);
static void sudoku_window_set_view (SudokuWindow* self,
                             SudokuView* value);
VALA_EXTERN void sudoku_window_show_new_game_screen (SudokuWindow* self);
VALA_EXTERN void sudoku_window_set_board_visible (SudokuWindow* self,
                                      gboolean visible);
VALA_EXTERN void sudoku_window_activate_difficulty_checkbutton (SudokuWindow* self,
                                                    DifficultyCategory difficulty);
VALA_EXTERN void sudoku_window_display_pause_button (SudokuWindow* self);
VALA_EXTERN gboolean sudoku_window_is_board_visible (SudokuWindow* self);
VALA_EXTERN void sudoku_window_set_headerbar_title (SudokuWindow* self);
VALA_EXTERN void sudoku_window_board_completed (SudokuWindow* self);
VALA_EXTERN void sudoku_view_dismiss_popovers (SudokuView* self);
static void sudoku_window_finalize (GObject * obj);
static GType sudoku_window_get_type_once (void);
static void _vala_sudoku_window_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);
static void _vala_sudoku_window_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec);

static inline gpointer
sudoku_window_get_instance_private (SudokuWindow* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuWindow_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda13_ (SudokuWindow* self)
{
	self->priv->window_is_maximized = !self->priv->window_is_maximized;
}

static void
___lambda13__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda13_ ((SudokuWindow*) self);
}

static void
__lambda14_ (SudokuWindow* self)
{
	self->priv->window_is_fullscreen = !self->priv->window_is_fullscreen;
	if (self->priv->window_is_fullscreen) {
		AdwHeaderBar* _tmp0_;
		GtkButton* _tmp1_;
		_tmp0_ = self->priv->headerbar;
		adw_header_bar_set_decoration_layout (_tmp0_, ":close");
		_tmp1_ = self->priv->unfullscreen_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp1_, TRUE);
	} else {
		AdwHeaderBar* _tmp2_;
		GtkButton* _tmp3_;
		_tmp2_ = self->priv->headerbar;
		adw_header_bar_set_decoration_layout (_tmp2_, NULL);
		_tmp3_ = self->priv->unfullscreen_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
		if (self->priv->window_is_maximized) {
			gtk_window_maximize ((GtkWindow*) self);
			return;
		}
	}
}

static void
___lambda14__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda14_ ((SudokuWindow*) self);
}

static void
__lambda15_ (SudokuWindow* self)
{
	SudokuView* _tmp0_;
	_tmp0_ = self->priv->_view;
	if (_tmp0_ != NULL) {
		SudokuView* _tmp1_;
		GtkMenuButton* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp1_ = self->priv->_view;
		_tmp2_ = self->priv->main_menu;
		_tmp3_ = gtk_menu_button_get_active (_tmp2_);
		_tmp4_ = _tmp3_;
		sudoku_view_set_has_selection (_tmp1_, !_tmp4_);
	}
}

static void
___lambda15__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda15_ ((SudokuWindow*) self);
}

static void
_sudoku_window_button_released_cb_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                              gint n_press,
                                                              gdouble x,
                                                              gdouble y,
                                                              gpointer self)
{
	sudoku_window_button_released_cb ((SudokuWindow*) self, _sender, n_press, x, y);
}

static void
_sudoku_window_long_press_cb_gtk_gesture_long_press_pressed (GtkGestureLongPress* _sender,
                                                             gdouble x,
                                                             gdouble y,
                                                             gpointer self)
{
	sudoku_window_long_press_cb ((SudokuWindow*) self, _sender, x, y);
}

SudokuWindow*
sudoku_window_construct (GType object_type,
                         GSettings* settings)
{
	SudokuWindow * self = NULL;
	GSettings* _tmp0_;
	GtkMenuButton* _tmp1_;
	GtkGestureClick* _tmp2_;
	GtkGestureClick* _tmp3_;
	GtkGestureClick* _tmp4_;
	GtkEventController* _tmp5_;
	GtkGestureLongPress* _tmp6_;
	GtkGestureLongPress* _tmp7_;
	GtkEventController* _tmp8_;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (SudokuWindow*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	sudoku_window_set_show_timer (self, g_settings_get_boolean (settings, "show-timer"));
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (settings, "window-width"), g_settings_get_int (settings, "window-height"));
	self->priv->window_is_maximized = g_settings_get_boolean (settings, "window-is-maximized");
	self->priv->window_is_fullscreen = g_settings_get_boolean (settings, "window-is-fullscreen");
	g_signal_connect_object ((GObject*) self, "notify::maximized", (GCallback) ___lambda13__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::fullscreened", (GCallback) ___lambda14__g_object_notify, self, 0);
	_tmp1_ = self->priv->main_menu;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::active", (GCallback) ___lambda15__g_object_notify, self, 0);
	if (self->priv->window_is_fullscreen) {
		gtk_window_fullscreen ((GtkWindow*) self);
	} else {
		if (self->priv->window_is_maximized) {
			gtk_window_maximize ((GtkWindow*) self);
		}
	}
	_tmp2_ = self->priv->button_controller;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp2_, (guint) 0);
	_tmp3_ = self->priv->button_controller;
	g_signal_connect_object (_tmp3_, "released", (GCallback) _sudoku_window_button_released_cb_gtk_gesture_click_released, self, 0);
	_tmp4_ = self->priv->button_controller;
	_tmp5_ = _g_object_ref0 ((GtkEventController*) _tmp4_);
	gtk_widget_add_controller (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp5_);
	_tmp6_ = self->priv->long_press_controller;
	g_signal_connect_object (_tmp6_, "pressed", (GCallback) _sudoku_window_long_press_cb_gtk_gesture_long_press_pressed, self, 0);
	_tmp7_ = self->priv->long_press_controller;
	_tmp8_ = _g_object_ref0 ((GtkEventController*) _tmp7_);
	gtk_widget_add_controller (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp8_);
	return self;
}

SudokuWindow*
sudoku_window_new (GSettings* settings)
{
	return sudoku_window_construct (TYPE_SUDOKU_WINDOW, settings);
}

static void
sudoku_window_real_size_allocate (GtkWidget* base,
                                  gint width,
                                  gint height,
                                  gint baseline)
{
	SudokuWindow * self;
	gboolean _tmp0_ = FALSE;
	self = (SudokuWindow*) base;
	GTK_WIDGET_CLASS (sudoku_window_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_window_get_type (), AdwApplicationWindow), width, height, baseline);
	sudoku_window_set_clock_placed_in_headerbar (self, width > SUDOKU_WINDOW_clock_in_headerbar_min_width);
	if (self->priv->window_is_maximized) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->window_is_fullscreen;
	}
	if (_tmp0_) {
		return;
	}
	self->priv->window_width = width;
	self->priv->window_height = height;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static void
sudoku_window_start_game_cb (SudokuWindow* self,
                             GtkButton* btn)
{
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (btn != NULL);
	_tmp0_ = self->priv->easy_check;
	_tmp1_ = gtk_check_button_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GtkWidget* _tmp3_ = NULL;
		gboolean* _tmp4_ = NULL;
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_widget_get_type ()) ? ((GtkWidget*) self) : NULL;
		_tmp4_ = NULL;
		if (_tmp3_ != NULL) {
			gboolean _tmp5_;
			gboolean* _tmp6_;
			_tmp5_ = gtk_widget_activate_action (_tmp3_, "app.start-game", "i", 1, NULL);
			_tmp6_ = __bool_dup0 (&_tmp5_);
			_g_free0 (_tmp4_);
			_tmp4_ = _tmp6_;
		}
		_g_free0 (_tmp4_);
	} else {
		GtkCheckButton* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp7_ = self->priv->medium_check;
		_tmp8_ = gtk_check_button_get_active (_tmp7_);
		_tmp9_ = _tmp8_;
		if (_tmp9_) {
			GtkWidget* _tmp10_ = NULL;
			gboolean* _tmp11_ = NULL;
			_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_widget_get_type ()) ? ((GtkWidget*) self) : NULL;
			_tmp11_ = NULL;
			if (_tmp10_ != NULL) {
				gboolean _tmp12_;
				gboolean* _tmp13_;
				_tmp12_ = gtk_widget_activate_action (_tmp10_, "app.start-game", "i", 2, NULL);
				_tmp13_ = __bool_dup0 (&_tmp12_);
				_g_free0 (_tmp11_);
				_tmp11_ = _tmp13_;
			}
			_g_free0 (_tmp11_);
		} else {
			GtkCheckButton* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp14_ = self->priv->hard_check;
			_tmp15_ = gtk_check_button_get_active (_tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_) {
				GtkWidget* _tmp17_ = NULL;
				gboolean* _tmp18_ = NULL;
				_tmp17_ = G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_widget_get_type ()) ? ((GtkWidget*) self) : NULL;
				_tmp18_ = NULL;
				if (_tmp17_ != NULL) {
					gboolean _tmp19_;
					gboolean* _tmp20_;
					_tmp19_ = gtk_widget_activate_action (_tmp17_, "app.start-game", "i", 3, NULL);
					_tmp20_ = __bool_dup0 (&_tmp19_);
					_g_free0 (_tmp18_);
					_tmp18_ = _tmp20_;
				}
				_g_free0 (_tmp18_);
			} else {
				GtkCheckButton* _tmp21_;
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp21_ = self->priv->very_hard_check;
				_tmp22_ = gtk_check_button_get_active (_tmp21_);
				_tmp23_ = _tmp22_;
				if (_tmp23_) {
					GtkWidget* _tmp24_ = NULL;
					gboolean* _tmp25_ = NULL;
					_tmp24_ = G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_widget_get_type ()) ? ((GtkWidget*) self) : NULL;
					_tmp25_ = NULL;
					if (_tmp24_ != NULL) {
						gboolean _tmp26_;
						gboolean* _tmp27_;
						_tmp26_ = gtk_widget_activate_action (_tmp24_, "app.start-game", "i", 4, NULL);
						_tmp27_ = __bool_dup0 (&_tmp26_);
						_g_free0 (_tmp25_);
						_tmp25_ = _tmp27_;
					}
					_g_free0 (_tmp25_);
				}
			}
		}
	}
}

static void
_sudoku_window_start_game_cb_gtk_button_clicked (GtkButton* _sender,
                                                 gpointer self)
{
	sudoku_window_start_game_cb ((SudokuWindow*) self, _sender);
}

void
sudoku_window_will_start_game (SudokuWindow* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->back_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
}

static void
_sudoku_window_tick_cb_sudoku_game_tick (SudokuGame* _sender,
                                         gpointer self)
{
	sudoku_window_tick_cb ((SudokuWindow*) self);
}

void
sudoku_window_start_game (SudokuWindow* self,
                          SudokuGame* game)
{
	SudokuGame* _tmp0_;
	SudokuView* _tmp1_;
	GSettings* _tmp4_;
	SudokuView* _tmp5_;
	SudokuView* _tmp6_;
	SudokuView* _tmp7_;
	GtkBox* _tmp8_;
	SudokuView* _tmp9_;
	SudokuView* _tmp10_;
	GtkButton* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp0_;
	g_signal_connect_object (game, "tick", (GCallback) _sudoku_window_tick_cb_sudoku_game_tick, self, 0);
	sudoku_game_start_clock (game);
	_tmp1_ = self->priv->_view;
	if (_tmp1_ != NULL) {
		GtkBox* _tmp2_;
		SudokuView* _tmp3_;
		_tmp2_ = self->priv->game_box;
		_tmp3_ = self->priv->_view;
		gtk_box_remove (_tmp2_, (GtkWidget*) _tmp3_);
	}
	sudoku_window_show_game_view (self);
	_tmp4_ = self->priv->settings;
	_tmp5_ = sudoku_view_new (game, _tmp4_);
	g_object_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	sudoku_window_set_view (self, _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->_view;
	gtk_widget_show ((GtkWidget*) _tmp7_);
	_tmp8_ = self->priv->game_box;
	_tmp9_ = self->priv->_view;
	gtk_box_prepend (_tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = self->priv->_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp10_);
	_tmp11_ = self->priv->back_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, TRUE);
}

void
sudoku_window_show_new_game_screen (SudokuWindow* self)
{
	AdwWindowTitle* _tmp0_;
	GtkButton* _tmp1_;
	SudokuGame* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkLabel* _tmp5_;
	GtkImage* _tmp6_;
	GtkButton* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->windowtitle;
	adw_window_title_set_title (_tmp0_, _ ("Select Difficulty"));
	sudoku_window_set_board_visible (self, FALSE);
	_tmp1_ = self->priv->back_button;
	_tmp2_ = self->priv->game;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, _tmp2_ != NULL);
	_tmp3_ = self->priv->undo_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->priv->redo_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp4_, FALSE);
	_tmp5_ = self->priv->clock_label;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, FALSE);
	_tmp6_ = self->priv->clock_image;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, FALSE);
	_tmp7_ = self->priv->start_button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp7_);
}

void
sudoku_window_activate_difficulty_checkbutton (SudokuWindow* self,
                                               DifficultyCategory difficulty)
{
	g_return_if_fail (self != NULL);
	switch (difficulty) {
		case DIFFICULTY_CATEGORY_EASY:
		{
			GtkCheckButton* _tmp0_;
			_tmp0_ = self->priv->easy_check;
			g_signal_emit_by_name (_tmp0_, "activate");
			return;
		}
		case DIFFICULTY_CATEGORY_MEDIUM:
		{
			GtkCheckButton* _tmp1_;
			_tmp1_ = self->priv->medium_check;
			g_signal_emit_by_name (_tmp1_, "activate");
			return;
		}
		case DIFFICULTY_CATEGORY_HARD:
		{
			GtkCheckButton* _tmp2_;
			_tmp2_ = self->priv->hard_check;
			g_signal_emit_by_name (_tmp2_, "activate");
			return;
		}
		case DIFFICULTY_CATEGORY_VERY_HARD:
		{
			GtkCheckButton* _tmp3_;
			_tmp3_ = self->priv->very_hard_check;
			g_signal_emit_by_name (_tmp3_, "activate");
			return;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

void
sudoku_window_set_board_visible (SudokuWindow* self,
                                 gboolean visible)
{
	GtkBox* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GtkButton* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkBox* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->start_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, !visible);
	if (visible) {
		SudokuGame* _tmp2_;
		GameMode _tmp3_;
		GameMode _tmp4_;
		_tmp2_ = self->priv->game;
		_tmp3_ = sudoku_game_get_mode (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp1_ = _tmp4_ == GAME_MODE_CREATE;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp5_ = self->priv->play_custom_game_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, _tmp1_);
	if (visible) {
		SudokuGame* _tmp8_;
		GameMode _tmp9_;
		GameMode _tmp10_;
		_tmp8_ = self->priv->game;
		_tmp9_ = sudoku_game_get_mode (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp7_ = _tmp10_ != GAME_MODE_CREATE;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gboolean _tmp11_;
		gboolean _tmp12_;
		_tmp11_ = sudoku_window_get_show_timer (self);
		_tmp12_ = _tmp11_;
		_tmp6_ = _tmp12_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		sudoku_window_display_pause_button (self);
	} else {
		GtkButton* _tmp13_;
		_tmp13_ = self->priv->play_pause_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp13_, FALSE);
	}
	_tmp14_ = self->priv->game_box;
	gtk_widget_set_visible ((GtkWidget*) _tmp14_, visible);
}

gboolean
sudoku_window_is_board_visible (SudokuWindow* self)
{
	GtkBox* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->game_box;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
sudoku_window_show_game_view (SudokuWindow* self)
{
	SudokuGame* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	SudokuGame* _tmp4_;
	GameMode _tmp5_;
	GameMode _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_vala_return_if_fail (_tmp0_ != NULL, "game != null");
	sudoku_window_set_board_visible (self, TRUE);
	_tmp1_ = self->priv->back_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->undo_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
	_tmp3_ = self->priv->redo_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = self->priv->game;
	_tmp5_ = sudoku_game_get_mode (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == GAME_MODE_PLAY) {
		GtkButton* _tmp7_;
		GtkButton* _tmp8_;
		gboolean _tmp9_;
		gboolean _tmp10_;
		GtkLabel* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		GtkImage* _tmp14_;
		gboolean _tmp15_;
		gboolean _tmp16_;
		_tmp7_ = self->priv->play_custom_game_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp7_, FALSE);
		_tmp8_ = self->priv->play_pause_button;
		_tmp9_ = sudoku_window_get_show_timer (self);
		_tmp10_ = _tmp9_;
		gtk_widget_set_visible ((GtkWidget*) _tmp8_, _tmp10_);
		_tmp11_ = self->priv->clock_label;
		_tmp12_ = sudoku_window_get_show_timer (self);
		_tmp13_ = _tmp12_;
		gtk_widget_set_visible ((GtkWidget*) _tmp11_, _tmp13_);
		_tmp14_ = self->priv->clock_image;
		_tmp15_ = sudoku_window_get_show_timer (self);
		_tmp16_ = _tmp15_;
		gtk_widget_set_visible ((GtkWidget*) _tmp14_, _tmp16_);
	} else {
		GtkLabel* _tmp17_;
		GtkImage* _tmp18_;
		GtkButton* _tmp19_;
		GtkButton* _tmp20_;
		_tmp17_ = self->priv->clock_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp17_, FALSE);
		_tmp18_ = self->priv->clock_image;
		gtk_widget_set_visible ((GtkWidget*) _tmp18_, FALSE);
		_tmp19_ = self->priv->play_custom_game_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp19_, TRUE);
		_tmp20_ = self->priv->play_pause_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp20_, FALSE);
	}
	sudoku_window_set_headerbar_title (self);
}

void
sudoku_window_board_completed (SudokuWindow* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->play_custom_game_button;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
}

void
sudoku_window_set_headerbar_title (SudokuWindow* self)
{
	SudokuGame* _tmp0_;
	SudokuGame* _tmp1_;
	GameMode _tmp2_;
	GameMode _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_vala_return_if_fail (_tmp0_ != NULL, "game != null");
	_tmp1_ = self->priv->game;
	_tmp2_ = sudoku_game_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == GAME_MODE_PLAY) {
		AdwWindowTitle* _tmp4_;
		_tmp4_ = self->priv->windowtitle;
		adw_window_title_set_title (_tmp4_, _ ("Sudoku"));
	} else {
		AdwWindowTitle* _tmp5_;
		_tmp5_ = self->priv->windowtitle;
		adw_window_title_set_title (_tmp5_, _ ("Create Puzzle"));
	}
}

void
sudoku_window_display_pause_button (SudokuWindow* self)
{
	GtkButton* _tmp0_;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkButton* _tmp5_;
	const gchar* _tmp6_ = NULL;
	SudokuGame* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GtkButton* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->play_pause_button;
	gtk_widget_show ((GtkWidget*) _tmp0_);
	_tmp2_ = self->priv->game;
	_tmp3_ = sudoku_game_get_paused (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp1_ = "media-playback-start-symbolic";
	} else {
		_tmp1_ = "media-playback-pause-symbolic";
	}
	_tmp5_ = self->priv->play_pause_button;
	gtk_button_set_icon_name (_tmp5_, _tmp1_);
	_tmp7_ = self->priv->game;
	_tmp8_ = sudoku_game_get_paused (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		_tmp6_ = _ ("Play");
	} else {
		_tmp6_ = _ ("Pause");
	}
	_tmp10_ = self->priv->play_pause_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _tmp6_);
}

static void
sudoku_window_tick_cb (SudokuWindow* self)
{
	gint elapsed_time = 0;
	SudokuGame* _tmp0_;
	gint hours = 0;
	gint minutes = 0;
	gint seconds = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	elapsed_time = (gint) sudoku_game_get_total_time_played (_tmp0_);
	hours = elapsed_time / 3600;
	minutes = (elapsed_time - (hours * 3600)) / 60;
	seconds = (elapsed_time - (hours * 3600)) - (minutes * 60);
	if (hours > 0) {
		GtkLabel* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->clock_label;
		_tmp2_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", hours, minutes, seconds);
		_tmp3_ = _tmp2_;
		gtk_label_set_text (_tmp1_, _tmp3_);
		_g_free0 (_tmp3_);
	} else {
		GtkLabel* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->clock_label;
		_tmp5_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", minutes, seconds);
		_tmp6_ = _tmp5_;
		gtk_label_set_text (_tmp4_, _tmp6_);
		_g_free0 (_tmp6_);
	}
}

static void
sudoku_window_set_clock_placed_in_headerbar (SudokuWindow* self,
                                             gboolean value)
{
	g_return_if_fail (self != NULL);
	if (value == self->priv->clock_in_headerbar) {
		return;
	}
	self->priv->clock_in_headerbar = value;
	if (value) {
		GtkBox* _tmp0_;
		GtkBox* _tmp1_;
		AdwHeaderBar* _tmp2_;
		GtkBox* _tmp3_;
		_tmp0_ = self->priv->game_box;
		_tmp1_ = self->priv->clock_box;
		gtk_box_remove (_tmp0_, (GtkWidget*) _tmp1_);
		_tmp2_ = self->priv->headerbar;
		_tmp3_ = self->priv->clock_box;
		adw_header_bar_pack_end (_tmp2_, (GtkWidget*) _tmp3_);
	} else {
		AdwHeaderBar* _tmp4_;
		GtkBox* _tmp5_;
		GtkBox* _tmp6_;
		GtkBox* _tmp7_;
		_tmp4_ = self->priv->headerbar;
		_tmp5_ = self->priv->clock_box;
		adw_header_bar_remove (_tmp4_, (GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->game_box;
		_tmp7_ = self->priv->clock_box;
		gtk_box_append (_tmp6_, (GtkWidget*) _tmp7_);
	}
}

static void
sudoku_window_button_released_cb (SudokuWindow* self,
                                  GtkGestureClick* gesture,
                                  gint n_press,
                                  gdouble x,
                                  gdouble y)
{
	gboolean _tmp0_ = FALSE;
	SudokuView* _tmp1_ = NULL;
	SudokuView* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	if (gtk_gesture_single_get_current_button ((GtkGestureSingle*) gesture) != ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp0_ = gtk_gesture_single_get_current_button ((GtkGestureSingle*) gesture) != ((guint) GDK_BUTTON_SECONDARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp2_ = self->priv->_view;
	_tmp1_ = _tmp2_;
	if (_tmp1_ != NULL) {
		sudoku_view_dismiss_popovers (_tmp1_);
	}
	gtk_gesture_set_state ((GtkGesture*) gesture, GTK_EVENT_SEQUENCE_CLAIMED);
}

static void
sudoku_window_long_press_cb (SudokuWindow* self,
                             GtkGestureLongPress* gesture,
                             gdouble x,
                             gdouble y)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	gtk_gesture_set_state ((GtkGesture*) gesture, GTK_EVENT_SEQUENCE_CLAIMED);
}

SudokuView*
sudoku_window_get_view (SudokuWindow* self)
{
	SudokuView* result;
	SudokuView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_view;
	result = _tmp0_;
	return result;
}

static void
sudoku_window_set_view (SudokuWindow* self,
                        SudokuView* value)
{
	SudokuView* old_value;
	g_return_if_fail (self != NULL);
	old_value = sudoku_window_get_view (self);
	if (old_value != value) {
		SudokuView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_view);
		self->priv->_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sudoku_window_properties[SUDOKU_WINDOW_VIEW_PROPERTY]);
	}
}

gboolean
sudoku_window_get_show_timer (SudokuWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_timer;
	return result;
}

void
sudoku_window_set_show_timer (SudokuWindow* self,
                              gboolean value)
{
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_show_timer = value;
	_tmp1_ = self->priv->game;
	if (_tmp1_ != NULL) {
		SudokuGame* _tmp2_;
		GameMode _tmp3_;
		GameMode _tmp4_;
		_tmp2_ = self->priv->game;
		_tmp3_ = sudoku_game_get_mode (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ != GAME_MODE_CREATE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkLabel* _tmp5_;
		GtkImage* _tmp6_;
		_tmp5_ = self->priv->clock_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp5_, value);
		_tmp6_ = self->priv->clock_image;
		gtk_widget_set_visible ((GtkWidget*) _tmp6_, value);
		if (value) {
			sudoku_window_display_pause_button (self);
		} else {
			GtkButton* _tmp7_;
			_tmp7_ = self->priv->play_pause_button;
			gtk_widget_set_visible ((GtkWidget*) _tmp7_, FALSE);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_window_properties[SUDOKU_WINDOW_SHOW_TIMER_PROPERTY]);
}

static void
sudoku_window_class_init (SudokuWindowClass * klass,
                          gpointer klass_data)
{
	sudoku_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuWindow_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) sudoku_window_real_size_allocate;
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_WINDOW_VIEW_PROPERTY, sudoku_window_properties[SUDOKU_WINDOW_VIEW_PROPERTY] = g_param_spec_object ("view", "view", "view", TYPE_SUDOKU_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_WINDOW_SHOW_TIMER_PROPERTY, sudoku_window_properties[SUDOKU_WINDOW_SHOW_TIMER_PROPERTY] = g_param_spec_boolean ("show-timer", "show-timer", "show-timer", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Sudoku/ui/sudoku-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "windowtitle", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, windowtitle));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "start_box", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, start_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "start_button", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, start_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "easy_check", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, easy_check));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "medium_check", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, medium_check));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hard_check", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, hard_check));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "very_hard_check", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, very_hard_check));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "game_box", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, game_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_menu", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, main_menu));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "undo_button", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, undo_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "redo_button", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, redo_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_button", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, back_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "unfullscreen_button", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, unfullscreen_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clock_box", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, clock_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clock_label", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, clock_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "clock_image", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, clock_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "play_custom_game_button", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, play_custom_game_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "play_pause_button", FALSE, SudokuWindow_private_offset + G_STRUCT_OFFSET (SudokuWindowPrivate, play_pause_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "start_game_cb", G_CALLBACK(_sudoku_window_start_game_cb_gtk_button_clicked));
}

static void
sudoku_window_instance_init (SudokuWindow * self,
                             gpointer klass)
{
	GtkGestureClick* _tmp0_;
	GtkGestureLongPress* _tmp1_;
	self->priv = sudoku_window_get_instance_private (self);
	self->priv->game = NULL;
	self->priv->_view = NULL;
	_tmp0_ = (GtkGestureClick*) gtk_gesture_click_new ();
	self->priv->button_controller = _tmp0_;
	_tmp1_ = (GtkGestureLongPress*) gtk_gesture_long_press_new ();
	self->priv->long_press_controller = _tmp1_;
	self->priv->_show_timer = TRUE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
sudoku_window_finalize (GObject * obj)
{
	SudokuWindow * self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GSettings* _tmp8_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_WINDOW, SudokuWindow);
	_tmp0_ = self->priv->settings;
	g_settings_delay (_tmp0_);
	_tmp1_ = self->priv->settings;
	g_settings_set_int (_tmp1_, "window-width", self->priv->window_width);
	_tmp2_ = self->priv->settings;
	g_settings_set_int (_tmp2_, "window-height", self->priv->window_height);
	_tmp3_ = self->priv->settings;
	g_settings_set_boolean (_tmp3_, "window-is-maximized", self->priv->window_is_maximized);
	_tmp4_ = self->priv->settings;
	g_settings_set_boolean (_tmp4_, "window-is-fullscreen", self->priv->window_is_fullscreen);
	_tmp5_ = self->priv->settings;
	_tmp6_ = sudoku_window_get_show_timer (self);
	_tmp7_ = _tmp6_;
	g_settings_set_boolean (_tmp5_, "show-timer", _tmp7_);
	_tmp8_ = self->priv->settings;
	g_settings_apply (_tmp8_);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->_view);
	_g_object_unref0 (self->priv->button_controller);
	_g_object_unref0 (self->priv->long_press_controller);
	G_OBJECT_CLASS (sudoku_window_parent_class)->finalize (obj);
}

static GType
sudoku_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuWindow), 0, (GInstanceInitFunc) sudoku_window_instance_init, NULL };
	GType sudoku_window_type_id;
	sudoku_window_type_id = g_type_register_static (adw_application_window_get_type (), "SudokuWindow", &g_define_type_info, 0);
	SudokuWindow_private_offset = g_type_add_instance_private (sudoku_window_type_id, sizeof (SudokuWindowPrivate));
	return sudoku_window_type_id;
}

GType
sudoku_window_get_type (void)
{
	static volatile gsize sudoku_window_type_id__once = 0;
	if (g_once_init_enter (&sudoku_window_type_id__once)) {
		GType sudoku_window_type_id;
		sudoku_window_type_id = sudoku_window_get_type_once ();
		g_once_init_leave (&sudoku_window_type_id__once, sudoku_window_type_id);
	}
	return sudoku_window_type_id__once;
}

static void
_vala_sudoku_window_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	SudokuWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_WINDOW, SudokuWindow);
	switch (property_id) {
		case SUDOKU_WINDOW_VIEW_PROPERTY:
		g_value_set_object (value, sudoku_window_get_view (self));
		break;
		case SUDOKU_WINDOW_SHOW_TIMER_PROPERTY:
		g_value_set_boolean (value, sudoku_window_get_show_timer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sudoku_window_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec)
{
	SudokuWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_WINDOW, SudokuWindow);
	switch (property_id) {
		case SUDOKU_WINDOW_VIEW_PROPERTY:
		sudoku_window_set_view (self, g_value_get_object (value));
		break;
		case SUDOKU_WINDOW_SHOW_TIMER_PROPERTY:
		sudoku_window_set_show_timer (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

