/* sudoku-cell.c generated by valac 0.56.17, the Vala compiler
 * generated from sudoku-cell.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2023 Jamie Murphy <jmurphy@gnome.org>
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include "libsudoku.h"
#include <adwaita.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <gsk/gsk.h>
#include <graphene-gobject.h>
#include <pango/pango.h>

#define SUDOKU_CELL_size_ratio 2
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU_CELL (sudoku_cell_get_type ())
#define SUDOKU_CELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_CELL, SudokuCell))
#define SUDOKU_CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_CELL, SudokuCellClass))
#define IS_SUDOKU_CELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_CELL))
#define IS_SUDOKU_CELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_CELL))
#define SUDOKU_CELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_CELL, SudokuCellClass))

typedef struct _SudokuCell SudokuCell;
typedef struct _SudokuCellClass SudokuCellClass;
typedef struct _SudokuCellPrivate SudokuCellPrivate;

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;

#define TYPE_NUMBER_PICKER (number_picker_get_type ())
#define NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER_PICKER, NumberPicker))
#define NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER_PICKER, NumberPickerClass))
#define IS_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER_PICKER))
#define IS_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER_PICKER))
#define NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER_PICKER, NumberPickerClass))

typedef struct _NumberPicker NumberPicker;
typedef struct _NumberPickerClass NumberPickerClass;
enum  {
	SUDOKU_CELL_0_PROPERTY,
	SUDOKU_CELL_VALUE_PROPERTY,
	SUDOKU_CELL_IS_FIXED_PROPERTY,
	SUDOKU_CELL_SELECTED_PROPERTY,
	SUDOKU_CELL_HIGHLIGHTED_BACKGROUND_PROPERTY,
	SUDOKU_CELL_HIGHLIGHTED_VALUE_PROPERTY,
	SUDOKU_CELL_PAUSED_PROPERTY,
	SUDOKU_CELL_NUM_PROPERTIES
};
static GParamSpec* sudoku_cell_properties[SUDOKU_CELL_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gsk_transform_unref0(var) ((var == NULL) ? NULL : (var = (gsk_transform_unref (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
enum  {
	SUDOKU_CELL_WILL_OPEN_POPOVER_SIGNAL,
	SUDOKU_CELL_NUM_SIGNALS
};
static guint sudoku_cell_signals[SUDOKU_CELL_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _SudokuCell {
	GtkWidget parent_instance;
	SudokuCellPrivate * priv;
};

struct _SudokuCellClass {
	GtkWidgetClass parent_class;
};

struct _SudokuCellPrivate {
	gint row;
	gint col;
	SudokuGame* game;
	SudokuView* view;
	GtkGestureClick* button_controller;
	GtkGestureLongPress* long_press_controller;
	gboolean control_key_pressed;
	GtkPopover* popover;
	GtkEventControllerKey* key_controller;
	NumberPicker* earmark_picker;
	NumberPicker* value_picker;
	GtkLabel* value_label;
	GtkLabel** earmark_labels;
	gint earmark_labels_length1;
	gint _earmark_labels_size_;
	gboolean _selected;
	gboolean _highlighted_background;
	gboolean _highlighted_value;
	gboolean _paused;
};

static gint SudokuCell_private_offset;
static gpointer sudoku_cell_parent_class = NULL;

VALA_EXTERN GType sudoku_cell_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuCell, g_object_unref)
VALA_EXTERN GType sudoku_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuView, g_object_unref)
VALA_EXTERN GType number_picker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NumberPicker, g_object_unref)
VALA_EXTERN SudokuCell* sudoku_cell_new (gint row,
                             gint col,
                             SudokuGame* game,
                             SudokuView* view);
VALA_EXTERN SudokuCell* sudoku_cell_construct (GType object_type,
                                   gint row,
                                   gint col,
                                   SudokuGame* game,
                                   SudokuView* view);
VALA_EXTERN gint sudoku_cell_get_value (SudokuCell* self);
static void sudoku_cell_set_fixed_css (SudokuCell* self,
                                gboolean enabled);
static void sudoku_cell_focus_changed_cb (SudokuCell* self);
static void _sudoku_cell_focus_changed_cb_g_object_notify (GObject* _sender,
                                                    GParamSpec* pspec,
                                                    gpointer self);
static void sudoku_cell_long_press_cb (SudokuCell* self,
                                GtkGestureLongPress* gesture,
                                gdouble x,
                                gdouble y);
static void _sudoku_cell_long_press_cb_gtk_gesture_long_press_pressed (GtkGestureLongPress* _sender,
                                                                gdouble x,
                                                                gdouble y,
                                                                gpointer self);
static void sudoku_cell_button_released_cb (SudokuCell* self,
                                     GtkGestureClick* gesture,
                                     gint n_press,
                                     gdouble x,
                                     gdouble y);
static void _sudoku_cell_button_released_cb_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                 gint n_press,
                                                                 gdouble x,
                                                                 gdouble y,
                                                                 gpointer self);
VALA_EXTERN gboolean sudoku_cell_get_is_fixed (SudokuCell* self);
static gboolean sudoku_cell_key_pressed_cb (SudokuCell* self,
                                     guint keyval,
                                     guint keycode,
                                     GdkModifierType state);
static gboolean _sudoku_cell_key_pressed_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                           guint keyval,
                                                                           guint keycode,
                                                                           GdkModifierType state,
                                                                           gpointer self);
static void sudoku_cell_key_released_cb (SudokuCell* self,
                                  guint keyval,
                                  guint keycode,
                                  GdkModifierType state);
static void _sudoku_cell_key_released_cb_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                         guint keyval,
                                                                         guint keycode,
                                                                         GdkModifierType state,
                                                                         gpointer self);
VALA_EXTERN NumberPicker* number_picker_new (SudokuGame* game,
                                 gboolean for_earmarks);
VALA_EXTERN NumberPicker* number_picker_construct (GType object_type,
                                       SudokuGame* game,
                                       gboolean for_earmarks);
static void sudoku_cell_value_picked_cb (SudokuCell* self,
                                  gint val);
static void _sudoku_cell_value_picked_cb_number_picker_value_picked (NumberPicker* _sender,
                                                              gint val,
                                                              gpointer self);
static void sudoku_cell_earmark_picked_cb (SudokuCell* self,
                                    gint num,
                                    gboolean state);
static void _sudoku_cell_earmark_picked_cb_number_picker_earmark_state_changed (NumberPicker* _sender,
                                                                         gint num,
                                                                         gboolean active,
                                                                         gpointer self);
VALA_EXTERN void sudoku_cell_set_earmark_highlight (SudokuCell* self,
                                        gint val,
                                        gboolean enabled);
VALA_EXTERN void sudoku_cell_update_value (SudokuCell* self);
static void sudoku_cell_get_visible_earmarks (SudokuCell* self);
VALA_EXTERN void sudoku_cell_update_earmark (SudokuCell* self,
                                 gint num);
static void sudoku_cell_get_visible_earmark (SudokuCell* self,
                                      gint num);
static gint sudoku_cell_get_key_number (SudokuCell* self,
                                 guint keyval);
VALA_EXTERN gboolean number_picker_get_is_earmark_picker (NumberPicker* self);
VALA_EXTERN void number_picker_set_earmark_button (NumberPicker* self,
                                       gint num,
                                       gboolean state);
VALA_EXTERN void sudoku_cell_set_value (SudokuCell* self,
                            gint value);
static void sudoku_cell_show_value_picker (SudokuCell* self);
static void sudoku_cell_show_earmark_picker (SudokuCell* self);
VALA_EXTERN void sudoku_view_set_selected (SudokuView* self,
                               gint cell_row,
                               gint cell_col);
VALA_EXTERN void number_picker_set_clear_button_visibility (NumberPicker* self,
                                                gboolean visible);
VALA_EXTERN void number_picker_set_clear_button_enabled (NumberPicker* self,
                                             gboolean enabled);
VALA_EXTERN void sudoku_cell_initialize_earmarks (SudokuCell* self,
                                      gboolean show_possibilities,
                                      gboolean force);
VALA_EXTERN void sudoku_cell_dismiss_popover (SudokuCell* self);
VALA_EXTERN void number_picker_set_earmark_buttons (NumberPicker* self,
                                        gint row,
                                        gint col);
VALA_EXTERN void sudoku_cell_check_value_warnings (SudokuCell* self,
                                       gboolean show_extra_warnings);
VALA_EXTERN void sudoku_cell_check_earmarks_warnings (SudokuCell* self);
VALA_EXTERN void sudoku_cell_check_earmark_warnings (SudokuCell* self,
                                         gint num);
VALA_EXTERN void sudoku_cell_clear_warnings (SudokuCell* self);
static void sudoku_cell_real_size_allocate (GtkWidget* base,
                                     gint width,
                                     gint height,
                                     gint baseline);
static void sudoku_cell_set_font_size (SudokuCell* self,
                                GtkLabel* label,
                                gint font_size);
static void sudoku_cell_real_dispose (GObject* base);
VALA_EXTERN gboolean sudoku_cell_get_selected (SudokuCell* self);
VALA_EXTERN void sudoku_cell_set_selected (SudokuCell* self,
                               gboolean value);
VALA_EXTERN gboolean sudoku_cell_get_highlighted_background (SudokuCell* self);
VALA_EXTERN void sudoku_cell_set_highlighted_background (SudokuCell* self,
                                             gboolean value);
VALA_EXTERN gboolean sudoku_cell_get_highlighted_value (SudokuCell* self);
VALA_EXTERN void sudoku_cell_set_highlighted_value (SudokuCell* self,
                                        gboolean value);
VALA_EXTERN gboolean sudoku_cell_get_paused (SudokuCell* self);
VALA_EXTERN void sudoku_cell_set_paused (SudokuCell* self,
                             gboolean value);
static void sudoku_cell_finalize (GObject * obj);
static GType sudoku_cell_get_type_once (void);
static void _vala_sudoku_cell_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_sudoku_cell_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
sudoku_cell_get_instance_private (SudokuCell* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuCell_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_sudoku_cell_focus_changed_cb_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self)
{
	sudoku_cell_focus_changed_cb ((SudokuCell*) self);
}

static void
_sudoku_cell_long_press_cb_gtk_gesture_long_press_pressed (GtkGestureLongPress* _sender,
                                                           gdouble x,
                                                           gdouble y,
                                                           gpointer self)
{
	sudoku_cell_long_press_cb ((SudokuCell*) self, _sender, x, y);
}

static void
_sudoku_cell_button_released_cb_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                            gint n_press,
                                                            gdouble x,
                                                            gdouble y,
                                                            gpointer self)
{
	sudoku_cell_button_released_cb ((SudokuCell*) self, _sender, n_press, x, y);
}

static gboolean
_sudoku_cell_key_pressed_cb_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                  guint keyval,
                                                                  guint keycode,
                                                                  GdkModifierType state,
                                                                  gpointer self)
{
	gboolean result;
	result = sudoku_cell_key_pressed_cb ((SudokuCell*) self, keyval, keycode, state);
	return result;
}

static void
_sudoku_cell_key_released_cb_gtk_event_controller_key_key_released (GtkEventControllerKey* _sender,
                                                                    guint keyval,
                                                                    guint keycode,
                                                                    GdkModifierType state,
                                                                    gpointer self)
{
	sudoku_cell_key_released_cb ((SudokuCell*) self, keyval, keycode, state);
}

static void
_sudoku_cell_value_picked_cb_number_picker_value_picked (NumberPicker* _sender,
                                                         gint val,
                                                         gpointer self)
{
	sudoku_cell_value_picked_cb ((SudokuCell*) self, val);
}

static void
_sudoku_cell_earmark_picked_cb_number_picker_earmark_state_changed (NumberPicker* _sender,
                                                                    gint num,
                                                                    gboolean active,
                                                                    gpointer self)
{
	sudoku_cell_earmark_picked_cb ((SudokuCell*) self, num, active);
}

SudokuCell*
sudoku_cell_construct (GType object_type,
                       gint row,
                       gint col,
                       SudokuGame* game,
                       SudokuView* view)
{
	SudokuCell * self = NULL;
	SudokuGame* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GtkGestureClick* _tmp9_;
	GtkGestureClick* _tmp10_;
	GtkEventController* _tmp11_;
	GtkGestureLongPress* _tmp12_;
	GtkEventController* _tmp13_;
	GtkGestureLongPress* _tmp14_;
	GtkGestureClick* _tmp15_;
	GtkLabel* _tmp16_;
	gint num = 0;
	gboolean _tmp38_;
	gboolean _tmp39_;
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (view != NULL, NULL);
	self = (SudokuCell*) g_object_new (object_type, NULL);
	gtk_widget_class_set_accessible_role (G_TYPE_INSTANCE_GET_CLASS (self, gtk_widget_get_type (), GtkWidgetClass), GTK_ACCESSIBLE_ROLE_BUTTON);
	self->priv->row = row;
	self->priv->col = col;
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp0_;
	self->priv->view = view;
	_tmp1_ = sudoku_cell_get_value (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != 0) {
		GtkLabel* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GtkLabel* _tmp8_;
		_tmp3_ = self->priv->value_label;
		_tmp4_ = sudoku_cell_get_value (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup_printf ("%i", _tmp5_);
		_tmp7_ = _tmp6_;
		gtk_label_set_label (_tmp3_, _tmp7_);
		_g_free0 (_tmp7_);
		_tmp8_ = self->priv->value_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp8_, TRUE);
	}
	gtk_widget_set_focusable ((GtkWidget*) self, TRUE);
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	sudoku_cell_set_fixed_css (self, TRUE);
	g_signal_connect_object ((GObject*) self, "notify::has-focus", (GCallback) _sudoku_cell_focus_changed_cb_g_object_notify, self, 0);
	_tmp9_ = self->priv->button_controller;
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp9_, (guint) 0);
	_tmp10_ = self->priv->button_controller;
	_tmp11_ = _g_object_ref0 ((GtkEventController*) _tmp10_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp11_);
	_tmp12_ = self->priv->long_press_controller;
	_tmp13_ = _g_object_ref0 ((GtkEventController*) _tmp12_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp13_);
	_tmp14_ = self->priv->long_press_controller;
	g_signal_connect_object (_tmp14_, "pressed", (GCallback) _sudoku_cell_long_press_cb_gtk_gesture_long_press_pressed, self, 0);
	_tmp15_ = self->priv->button_controller;
	g_signal_connect_object (_tmp15_, "released", (GCallback) _sudoku_cell_button_released_cb_gtk_gesture_click_released, self, 0);
	_tmp16_ = self->priv->value_label;
	gtk_widget_set_parent ((GtkWidget*) _tmp16_, (GtkWidget*) self);
	num = 0;
	{
		gint row_tmp = 0;
		row_tmp = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				SudokuBoard* _tmp19_;
				SudokuBoard* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				if (!_tmp17_) {
					gint _tmp18_;
					_tmp18_ = row_tmp;
					row_tmp = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = sudoku_game_get_board (game);
				_tmp20_ = _tmp19_;
				_tmp21_ = sudoku_board_get_block_rows (_tmp20_);
				_tmp22_ = _tmp21_;
				if (!(row_tmp < _tmp22_)) {
					break;
				}
				{
					gint col_tmp = 0;
					col_tmp = 0;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							SudokuBoard* _tmp25_;
							SudokuBoard* _tmp26_;
							gint _tmp27_;
							gint _tmp28_;
							gint _tmp29_;
							GtkLabel** _tmp30_;
							gint _tmp30__length1;
							gchar* _tmp31_;
							gchar* _tmp32_;
							GtkLabel* _tmp33_ = NULL;
							GtkLabel** _tmp34_;
							gint _tmp34__length1;
							GtkLabel* _tmp35_;
							GtkLabel** _tmp36_;
							gint _tmp36__length1;
							GtkLabel* _tmp37_;
							if (!_tmp23_) {
								gint _tmp24_;
								_tmp24_ = col_tmp;
								col_tmp = _tmp24_ + 1;
							}
							_tmp23_ = FALSE;
							_tmp25_ = sudoku_game_get_board (game);
							_tmp26_ = _tmp25_;
							_tmp27_ = sudoku_board_get_block_cols (_tmp26_);
							_tmp28_ = _tmp27_;
							if (!(col_tmp < _tmp28_)) {
								break;
							}
							_tmp29_ = num;
							num = _tmp29_ + 1;
							_tmp30_ = self->priv->earmark_labels;
							_tmp30__length1 = self->priv->earmark_labels_length1;
							_tmp31_ = g_strdup_printf ("%i", num);
							_tmp32_ = _tmp31_;
							_tmp33_ = (GtkLabel*) gtk_label_new (_tmp32_);
							gtk_widget_set_visible ((GtkWidget*) _tmp33_, FALSE);
							g_object_ref_sink (_tmp33_);
							_g_object_unref0 (_tmp30_[num - 1]);
							_tmp30_[num - 1] = _tmp33_;
							_g_free0 (_tmp32_);
							_tmp34_ = self->priv->earmark_labels;
							_tmp34__length1 = self->priv->earmark_labels_length1;
							_tmp35_ = _tmp34_[num - 1];
							gtk_widget_set_parent ((GtkWidget*) _tmp35_, (GtkWidget*) self);
							_tmp36_ = self->priv->earmark_labels;
							_tmp36__length1 = self->priv->earmark_labels_length1;
							_tmp37_ = _tmp36_[num - 1];
							gtk_widget_add_css_class ((GtkWidget*) _tmp37_, "earmark");
						}
					}
				}
			}
		}
	}
	_tmp38_ = sudoku_cell_get_is_fixed (self);
	_tmp39_ = _tmp38_;
	if (!_tmp39_) {
		GtkEventControllerKey* _tmp40_;
		GtkEventControllerKey* _tmp41_;
		GtkEventController* _tmp42_;
		GtkEventControllerKey* _tmp43_;
		GtkEventControllerKey* _tmp44_;
		GtkPopover* _tmp45_;
		GtkPopover* _tmp46_;
		GtkPopover* _tmp47_;
		GtkEventControllerKey* popover_controller = NULL;
		GtkEventControllerKey* _tmp48_;
		GtkEventControllerKey* _tmp49_;
		GtkEventControllerKey* _tmp50_;
		GtkWidget* _tmp51_ = NULL;
		GtkPopover* _tmp52_;
		NumberPicker* _tmp55_;
		NumberPicker* _tmp56_;
		NumberPicker* _tmp57_;
		NumberPicker* _tmp58_;
		_tmp40_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
		_g_object_unref0 (self->priv->key_controller);
		self->priv->key_controller = _tmp40_;
		_tmp41_ = self->priv->key_controller;
		_tmp42_ = _g_object_ref0 ((GtkEventController*) _tmp41_);
		gtk_widget_add_controller ((GtkWidget*) self, _tmp42_);
		_tmp43_ = self->priv->key_controller;
		g_signal_connect_object (_tmp43_, "key-pressed", (GCallback) _sudoku_cell_key_pressed_cb_gtk_event_controller_key_key_pressed, self, 0);
		_tmp44_ = self->priv->key_controller;
		g_signal_connect_object (_tmp44_, "key-released", (GCallback) _sudoku_cell_key_released_cb_gtk_event_controller_key_key_released, self, 0);
		_tmp45_ = (GtkPopover*) gtk_popover_new ();
		g_object_ref_sink (_tmp45_);
		_g_object_unref0 (self->priv->popover);
		self->priv->popover = _tmp45_;
		_tmp46_ = self->priv->popover;
		gtk_popover_set_autohide (_tmp46_, FALSE);
		_tmp47_ = self->priv->popover;
		gtk_widget_set_parent ((GtkWidget*) _tmp47_, (GtkWidget*) self);
		_tmp48_ = (GtkEventControllerKey*) gtk_event_controller_key_new ();
		popover_controller = _tmp48_;
		_tmp49_ = popover_controller;
		g_signal_connect_object (_tmp49_, "key-pressed", (GCallback) _sudoku_cell_key_pressed_cb_gtk_event_controller_key_key_pressed, self, 0);
		_tmp50_ = popover_controller;
		g_signal_connect_object (_tmp50_, "key-released", (GCallback) _sudoku_cell_key_released_cb_gtk_event_controller_key_key_released, self, 0);
		_tmp52_ = self->priv->popover;
		_tmp51_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp52_) : NULL;
		if (_tmp51_ != NULL) {
			GtkEventControllerKey* _tmp53_;
			GtkEventController* _tmp54_;
			_tmp53_ = popover_controller;
			_tmp54_ = _g_object_ref0 ((GtkEventController*) _tmp53_);
			gtk_widget_add_controller (_tmp51_, _tmp54_);
		}
		_tmp55_ = number_picker_new (game, FALSE);
		g_object_ref_sink (_tmp55_);
		_g_object_unref0 (self->priv->value_picker);
		self->priv->value_picker = _tmp55_;
		_tmp56_ = self->priv->value_picker;
		g_signal_connect_object (_tmp56_, "value-picked", (GCallback) _sudoku_cell_value_picked_cb_number_picker_value_picked, self, 0);
		_tmp57_ = number_picker_new (game, TRUE);
		g_object_ref_sink (_tmp57_);
		_g_object_unref0 (self->priv->earmark_picker);
		self->priv->earmark_picker = _tmp57_;
		_tmp58_ = self->priv->earmark_picker;
		g_signal_connect_object (_tmp58_, "earmark-state-changed", (GCallback) _sudoku_cell_earmark_picked_cb_number_picker_earmark_state_changed, self, 0);
		_g_object_unref0 (popover_controller);
	}
	return self;
}

SudokuCell*
sudoku_cell_new (gint row,
                 gint col,
                 SudokuGame* game,
                 SudokuView* view)
{
	return sudoku_cell_construct (TYPE_SUDOKU_CELL, row, col, game, view);
}

static void
sudoku_cell_set_fixed_css (SudokuCell* self,
                           gboolean enabled)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_cell_get_is_fixed (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		if (enabled) {
			gtk_widget_add_css_class ((GtkWidget*) self, "fixed");
		} else {
			gtk_widget_remove_css_class ((GtkWidget*) self, "fixed");
		}
	}
}

void
sudoku_cell_set_earmark_highlight (SudokuCell* self,
                                   gint val,
                                   gboolean enabled)
{
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	SudokuBoard* _tmp2_;
	GtkLabel* earmark = NULL;
	GtkLabel** _tmp3_;
	gint _tmp3__length1;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_board (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!sudoku_board_is_earmark_enabled (_tmp2_, self->priv->row, self->priv->col, val)) {
		return;
	}
	_tmp3_ = self->priv->earmark_labels;
	_tmp3__length1 = self->priv->earmark_labels_length1;
	_tmp4_ = _tmp3_[val - 1];
	_tmp5_ = _g_object_ref0 (_tmp4_);
	earmark = _tmp5_;
	if (enabled) {
		GtkLabel* _tmp7_;
		_tmp7_ = earmark;
		_tmp6_ = !gtk_widget_has_css_class ((GtkWidget*) _tmp7_, "error");
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GtkLabel* _tmp8_;
		_tmp8_ = earmark;
		gtk_widget_add_css_class ((GtkWidget*) _tmp8_, "highlight-label");
	} else {
		GtkLabel* _tmp9_;
		_tmp9_ = earmark;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp9_, "highlight-label");
	}
	_g_object_unref0 (earmark);
}

void
sudoku_cell_update_value (SudokuCell* self)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_cell_get_value (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != 0) {
		GtkLabel* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GtkLabel* _tmp7_;
		_tmp2_ = self->priv->value_label;
		_tmp3_ = sudoku_cell_get_value (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strdup_printf ("%i", _tmp4_);
		_tmp6_ = _tmp5_;
		gtk_label_set_label (_tmp2_, _tmp6_);
		_g_free0 (_tmp6_);
		_tmp7_ = self->priv->value_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp7_, TRUE);
	} else {
		GtkLabel* _tmp8_;
		_tmp8_ = self->priv->value_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp8_, FALSE);
	}
	sudoku_cell_get_visible_earmarks (self);
}

void
sudoku_cell_update_earmark (SudokuCell* self,
                            gint num)
{
	g_return_if_fail (self != NULL);
	sudoku_cell_get_visible_earmark (self, num);
}

static gboolean
sudoku_cell_key_pressed_cb (SudokuCell* self,
                            guint keyval,
                            guint keycode,
                            GdkModifierType state)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (keyval == GDK_KEY_Control_L) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = keyval == GDK_KEY_Control_R;
	}
	if (_tmp0_) {
		self->priv->control_key_pressed = TRUE;
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}

static void
sudoku_cell_key_released_cb (SudokuCell* self,
                             guint keyval,
                             guint keycode,
                             GdkModifierType state)
{
	SudokuGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gint key = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	if (keyval == GDK_KEY_Control_L) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = keyval == GDK_KEY_Control_R;
	}
	if (_tmp3_) {
		self->priv->control_key_pressed = FALSE;
	}
	key = sudoku_cell_get_key_number (self, keyval);
	if (key >= 1) {
		_tmp4_ = key <= 9;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		NumberPicker* number_picker = NULL;
		GtkPopover* _tmp5_;
		GtkWidget* _tmp6_;
		NumberPicker* _tmp7_;
		gboolean ctrl_pressed = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		GtkPopover* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		gboolean want_earmark = FALSE;
		gboolean _tmp21_ = FALSE;
		_tmp5_ = self->priv->popover;
		_tmp6_ = gtk_popover_get_child (_tmp5_);
		_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_NUMBER_PICKER, NumberPicker));
		number_picker = _tmp7_;
		ctrl_pressed = (state & GDK_CONTROL_MASK) > 0;
		_tmp11_ = self->priv->popover;
		_tmp12_ = gtk_widget_get_visible ((GtkWidget*) _tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_) {
			NumberPicker* _tmp14_;
			_tmp14_ = number_picker;
			_tmp10_ = _tmp14_ != NULL;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			NumberPicker* _tmp15_;
			gboolean _tmp16_;
			gboolean _tmp17_;
			_tmp15_ = number_picker;
			_tmp16_ = number_picker_get_is_earmark_picker (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp9_ = _tmp17_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			gboolean _tmp18_ = FALSE;
			if (ctrl_pressed) {
				gint _tmp19_;
				gint _tmp20_;
				_tmp19_ = sudoku_cell_get_value (self);
				_tmp20_ = _tmp19_;
				_tmp18_ = _tmp20_ == 0;
			} else {
				_tmp18_ = FALSE;
			}
			_tmp8_ = _tmp18_;
		}
		want_earmark = _tmp8_;
		if (want_earmark) {
			SudokuGame* _tmp22_;
			GameMode _tmp23_;
			GameMode _tmp24_;
			_tmp22_ = self->priv->game;
			_tmp23_ = sudoku_game_get_mode (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp21_ = _tmp24_ == GAME_MODE_PLAY;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			gboolean new_state = FALSE;
			SudokuGame* _tmp25_;
			SudokuBoard* _tmp26_;
			SudokuBoard* _tmp27_;
			gboolean _tmp28_ = FALSE;
			NumberPicker* _tmp29_;
			_tmp25_ = self->priv->game;
			_tmp26_ = sudoku_game_get_board (_tmp25_);
			_tmp27_ = _tmp26_;
			new_state = !sudoku_board_is_earmark_enabled (_tmp27_, self->priv->row, self->priv->col, key);
			_tmp29_ = number_picker;
			if (_tmp29_ != NULL) {
				NumberPicker* _tmp30_;
				gboolean _tmp31_;
				gboolean _tmp32_;
				_tmp30_ = number_picker;
				_tmp31_ = number_picker_get_is_earmark_picker (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp28_ = _tmp32_;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				NumberPicker* _tmp33_;
				_tmp33_ = number_picker;
				number_picker_set_earmark_button (_tmp33_, key, new_state);
			} else {
				if (new_state) {
					SudokuGame* _tmp34_;
					_tmp34_ = self->priv->game;
					sudoku_game_enable_earmark (_tmp34_, self->priv->row, self->priv->col, key);
				} else {
					SudokuGame* _tmp35_;
					_tmp35_ = self->priv->game;
					sudoku_game_disable_earmark (_tmp35_, self->priv->row, self->priv->col, key);
				}
			}
		} else {
			if (!ctrl_pressed) {
				SudokuGame* _tmp36_;
				SudokuBoard* _tmp37_;
				SudokuBoard* _tmp38_;
				sudoku_cell_set_value (self, key);
				_tmp36_ = self->priv->game;
				_tmp37_ = sudoku_game_get_board (_tmp36_);
				_tmp38_ = _tmp37_;
				sudoku_board_disable_all_earmarks (_tmp38_, self->priv->row, self->priv->col);
			}
		}
		_g_object_unref0 (number_picker);
		return;
	}
	if (key == 0) {
		_tmp40_ = TRUE;
	} else {
		_tmp40_ = keyval == GDK_KEY_BackSpace;
	}
	if (_tmp40_) {
		_tmp39_ = TRUE;
	} else {
		_tmp39_ = keyval == GDK_KEY_Delete;
	}
	if (_tmp39_) {
		SudokuGame* _tmp41_;
		SudokuBoard* _tmp42_;
		SudokuBoard* _tmp43_;
		_tmp41_ = self->priv->game;
		_tmp42_ = sudoku_game_get_board (_tmp41_);
		_tmp43_ = _tmp42_;
		if (sudoku_board_has_earmarks (_tmp43_, self->priv->row, self->priv->col)) {
			SudokuGame* _tmp44_;
			_tmp44_ = self->priv->game;
			sudoku_game_disable_all_earmarks (_tmp44_, self->priv->row, self->priv->col);
		}
		sudoku_cell_set_value (self, 0);
		return;
	}
	if (keyval == GDK_KEY_space) {
		_tmp46_ = TRUE;
	} else {
		_tmp46_ = keyval == GDK_KEY_Return;
	}
	if (_tmp46_) {
		_tmp45_ = TRUE;
	} else {
		_tmp45_ = keyval == GDK_KEY_KP_Enter;
	}
	if (_tmp45_) {
		sudoku_cell_show_value_picker (self);
		return;
	}
	if (keyval == GDK_KEY_Escape) {
		GtkPopover* _tmp47_;
		gboolean _tmp48_;
		gboolean _tmp49_;
		_tmp47_ = self->priv->popover;
		_tmp48_ = gtk_widget_get_visible ((GtkWidget*) _tmp47_);
		_tmp49_ = _tmp48_;
		if (_tmp49_) {
			GtkPopover* _tmp50_;
			_tmp50_ = self->priv->popover;
			gtk_popover_popdown (_tmp50_);
		}
		return;
	}
}

static void
sudoku_cell_button_released_cb (SudokuCell* self,
                                GtkGestureClick* gesture,
                                gint n_press,
                                gdouble x,
                                gdouble y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	if (gtk_gesture_single_get_current_button ((GtkGestureSingle*) gesture) != ((guint) GDK_BUTTON_PRIMARY)) {
		_tmp0_ = gtk_gesture_single_get_current_button ((GtkGestureSingle*) gesture) != ((guint) GDK_BUTTON_SECONDARY);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	gtk_gesture_set_state ((GtkGesture*) gesture, GTK_EVENT_SEQUENCE_CLAIMED);
	g_object_get ((GtkWidget*) self, "has-focus", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gtk_widget_grab_focus ((GtkWidget*) self);
	}
	_tmp4_ = sudoku_cell_get_is_fixed (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		_tmp3_ = TRUE;
	} else {
		SudokuGame* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = self->priv->game;
		_tmp7_ = sudoku_game_get_paused (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp3_ = _tmp8_;
	}
	if (_tmp3_) {
		return;
	}
	if (gtk_gesture_single_get_current_button ((GtkGestureSingle*) gesture) == ((guint) GDK_BUTTON_PRIMARY)) {
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		SudokuGame* _tmp11_;
		GameMode _tmp12_;
		GameMode _tmp13_;
		_tmp11_ = self->priv->game;
		_tmp12_ = sudoku_game_get_mode (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == GAME_MODE_PLAY) {
			GdkEventSequence* _tmp14_;
			GdkEvent* _tmp15_;
			_tmp14_ = gtk_gesture_get_last_updated_sequence ((GtkGesture*) gesture);
			_tmp15_ = gtk_gesture_get_last_event ((GtkGesture*) gesture, _tmp14_);
			_tmp10_ = (gdk_event_get_modifier_state (_tmp15_) & GDK_CONTROL_MASK) > 0;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			gint _tmp16_;
			gint _tmp17_;
			_tmp16_ = sudoku_cell_get_value (self);
			_tmp17_ = _tmp16_;
			_tmp9_ = _tmp17_ == 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			sudoku_cell_show_earmark_picker (self);
		} else {
			sudoku_cell_show_value_picker (self);
		}
	} else {
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		if (gtk_gesture_single_get_current_button ((GtkGestureSingle*) gesture) == ((guint) GDK_BUTTON_SECONDARY)) {
			SudokuGame* _tmp20_;
			GameMode _tmp21_;
			GameMode _tmp22_;
			_tmp20_ = self->priv->game;
			_tmp21_ = sudoku_game_get_mode (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp19_ = _tmp22_ == GAME_MODE_PLAY;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			gint _tmp23_;
			gint _tmp24_;
			_tmp23_ = sudoku_cell_get_value (self);
			_tmp24_ = _tmp23_;
			_tmp18_ = _tmp24_ == 0;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			sudoku_cell_show_earmark_picker (self);
		}
	}
}

static void
sudoku_cell_long_press_cb (SudokuCell* self,
                           GtkGestureLongPress* gesture,
                           gdouble x,
                           gdouble y)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	SudokuGame* _tmp8_;
	GameMode _tmp9_;
	GameMode _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gesture != NULL);
	gtk_gesture_set_state ((GtkGesture*) gesture, GTK_EVENT_SEQUENCE_CLAIMED);
	g_object_get ((GtkWidget*) self, "has-focus", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		gtk_widget_grab_focus ((GtkWidget*) self);
	}
	_tmp3_ = sudoku_cell_get_is_fixed (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp2_ = TRUE;
	} else {
		SudokuGame* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->game;
		_tmp6_ = sudoku_game_get_paused (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp2_ = _tmp7_;
	}
	if (_tmp2_) {
		return;
	}
	_tmp8_ = self->priv->game;
	_tmp9_ = sudoku_game_get_mode (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == GAME_MODE_CREATE) {
		sudoku_cell_show_value_picker (self);
	} else {
		gint _tmp11_;
		gint _tmp12_;
		_tmp11_ = sudoku_cell_get_value (self);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == 0) {
			sudoku_cell_show_earmark_picker (self);
		}
	}
}

static void
sudoku_cell_focus_changed_cb (SudokuCell* self)
{
	SudokuGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	g_object_get ((GtkWidget*) self, "has-focus", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		SudokuView* _tmp5_;
		_tmp5_ = self->priv->view;
		sudoku_view_set_selected (_tmp5_, self->priv->row, self->priv->col);
	}
}

static void
sudoku_cell_value_picked_cb (SudokuCell* self,
                             gint val)
{
	g_return_if_fail (self != NULL);
	if (val > 0) {
		GtkPopover* _tmp0_;
		_tmp0_ = self->priv->popover;
		gtk_popover_popdown (_tmp0_);
	} else {
		SudokuGame* _tmp1_;
		SudokuBoard* _tmp2_;
		SudokuBoard* _tmp3_;
		NumberPicker* _tmp4_;
		_tmp1_ = self->priv->game;
		_tmp2_ = sudoku_game_get_board (_tmp1_);
		_tmp3_ = _tmp2_;
		sudoku_board_disable_all_earmarks (_tmp3_, self->priv->row, self->priv->col);
		_tmp4_ = self->priv->value_picker;
		number_picker_set_clear_button_visibility (_tmp4_, FALSE);
	}
	sudoku_cell_set_value (self, val);
}

static void
sudoku_cell_earmark_picked_cb (SudokuCell* self,
                               gint num,
                               gboolean state)
{
	NumberPicker* _tmp9_;
	SudokuGame* _tmp10_;
	SudokuBoard* _tmp11_;
	SudokuBoard* _tmp12_;
	g_return_if_fail (self != NULL);
	if (state) {
		SudokuGame* _tmp0_;
		SudokuBoard* _tmp1_;
		SudokuBoard* _tmp2_;
		_tmp0_ = self->priv->game;
		_tmp1_ = sudoku_game_get_board (_tmp0_);
		_tmp2_ = _tmp1_;
		if (!sudoku_board_is_earmark_enabled (_tmp2_, self->priv->row, self->priv->col, num)) {
			SudokuGame* _tmp3_;
			_tmp3_ = self->priv->game;
			sudoku_game_enable_earmark (_tmp3_, self->priv->row, self->priv->col, num);
		}
	} else {
		if (num == 0) {
			SudokuGame* _tmp4_;
			_tmp4_ = self->priv->game;
			sudoku_game_disable_all_earmarks (_tmp4_, self->priv->row, self->priv->col);
		} else {
			SudokuGame* _tmp5_;
			SudokuBoard* _tmp6_;
			SudokuBoard* _tmp7_;
			_tmp5_ = self->priv->game;
			_tmp6_ = sudoku_game_get_board (_tmp5_);
			_tmp7_ = _tmp6_;
			if (sudoku_board_is_earmark_enabled (_tmp7_, self->priv->row, self->priv->col, num)) {
				SudokuGame* _tmp8_;
				_tmp8_ = self->priv->game;
				sudoku_game_disable_earmark (_tmp8_, self->priv->row, self->priv->col, num);
			}
		}
	}
	_tmp9_ = self->priv->earmark_picker;
	_tmp10_ = self->priv->game;
	_tmp11_ = sudoku_game_get_board (_tmp10_);
	_tmp12_ = _tmp11_;
	number_picker_set_clear_button_enabled (_tmp9_, sudoku_board_has_earmarks (_tmp12_, self->priv->row, self->priv->col));
}

static gint
sudoku_cell_get_key_number (SudokuCell* self,
                            guint keyval)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	switch (keyval) {
		case GDK_KEY_0:
		case GDK_KEY_KP_0:
		{
			result = 0;
			return result;
		}
		case GDK_KEY_1:
		case GDK_KEY_KP_1:
		{
			result = 1;
			return result;
		}
		case GDK_KEY_2:
		case GDK_KEY_KP_2:
		{
			result = 2;
			return result;
		}
		case GDK_KEY_3:
		case GDK_KEY_KP_3:
		{
			result = 3;
			return result;
		}
		case GDK_KEY_4:
		case GDK_KEY_KP_4:
		{
			result = 4;
			return result;
		}
		case GDK_KEY_5:
		case GDK_KEY_KP_5:
		{
			result = 5;
			return result;
		}
		case GDK_KEY_6:
		case GDK_KEY_KP_6:
		{
			result = 6;
			return result;
		}
		case GDK_KEY_7:
		case GDK_KEY_KP_7:
		{
			result = 7;
			return result;
		}
		case GDK_KEY_8:
		case GDK_KEY_KP_8:
		{
			result = 8;
			return result;
		}
		case GDK_KEY_9:
		case GDK_KEY_KP_9:
		{
			result = 9;
			return result;
		}
		default:
		{
			result = -1;
			return result;
		}
	}
}

void
sudoku_cell_initialize_earmarks (SudokuCell* self,
                                 gboolean show_possibilities,
                                 gboolean force)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = sudoku_cell_get_value (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != 0) {
		_tmp0_ = TRUE;
	} else {
		SudokuGame* _tmp3_;
		GameMode _tmp4_;
		GameMode _tmp5_;
		_tmp3_ = self->priv->game;
		_tmp4_ = sudoku_game_get_mode (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ == GAME_MODE_CREATE;
	}
	if (_tmp0_) {
		return;
	}
	if (show_possibilities) {
		gboolean _tmp7_ = FALSE;
		SudokuGame* _tmp8_;
		SudokuBoard* _tmp9_;
		SudokuBoard* _tmp10_;
		gdouble _tmp11_;
		gdouble _tmp12_;
		_tmp8_ = self->priv->game;
		_tmp9_ = sudoku_game_get_board (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = sudoku_board_get_previous_played_time (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ == 0.0) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = force;
		}
		_tmp6_ = _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gboolean* marks = NULL;
		SudokuGame* _tmp13_;
		SudokuBoard* _tmp14_;
		SudokuBoard* _tmp15_;
		gint _tmp16_ = 0;
		gboolean* _tmp17_;
		gint marks_length1;
		gint _marks_size_;
		_tmp13_ = self->priv->game;
		_tmp14_ = sudoku_game_get_board (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp17_ = sudoku_board_get_possibilities_as_bool_array (_tmp15_, self->priv->row, self->priv->col, &_tmp16_);
		marks = _tmp17_;
		marks_length1 = _tmp16_;
		_marks_size_ = marks_length1;
		{
			gint num = 0;
			num = 1;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					gboolean _tmp20_ = FALSE;
					gboolean* _tmp21_;
					gint _tmp21__length1;
					gboolean _tmp22_;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = num;
						num = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					if (!(num <= 9)) {
						break;
					}
					_tmp21_ = marks;
					_tmp21__length1 = marks_length1;
					_tmp22_ = _tmp21_[num - 1];
					if (_tmp22_) {
						SudokuGame* _tmp23_;
						SudokuBoard* _tmp24_;
						SudokuBoard* _tmp25_;
						_tmp23_ = self->priv->game;
						_tmp24_ = sudoku_game_get_board (_tmp23_);
						_tmp25_ = _tmp24_;
						_tmp20_ = !sudoku_board_is_earmark_enabled (_tmp25_, self->priv->row, self->priv->col, num);
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						SudokuGame* _tmp26_;
						SudokuBoard* _tmp27_;
						SudokuBoard* _tmp28_;
						_tmp26_ = self->priv->game;
						_tmp27_ = sudoku_game_get_board (_tmp26_);
						_tmp28_ = _tmp27_;
						sudoku_board_enable_earmark (_tmp28_, self->priv->row, self->priv->col, num);
					}
				}
			}
		}
		marks = (g_free (marks), NULL);
	}
	sudoku_cell_get_visible_earmarks (self);
}

static void
sudoku_cell_get_visible_earmarks (SudokuCell* self)
{
	g_return_if_fail (self != NULL);
	{
		gint num = 0;
		num = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = num;
					num = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(num <= 9)) {
					break;
				}
				sudoku_cell_get_visible_earmark (self, num);
			}
		}
	}
}

static void
sudoku_cell_get_visible_earmark (SudokuCell* self,
                                 gint num)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_cell_get_value (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != 0) {
		GtkLabel** _tmp2_;
		gint _tmp2__length1;
		GtkLabel* _tmp3_;
		_tmp2_ = self->priv->earmark_labels;
		_tmp2__length1 = self->priv->earmark_labels_length1;
		_tmp3_ = _tmp2_[num - 1];
		gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
	} else {
		GtkLabel** _tmp4_;
		gint _tmp4__length1;
		GtkLabel* _tmp5_;
		SudokuGame* _tmp6_;
		SudokuBoard* _tmp7_;
		SudokuBoard* _tmp8_;
		_tmp4_ = self->priv->earmark_labels;
		_tmp4__length1 = self->priv->earmark_labels_length1;
		_tmp5_ = _tmp4_[num - 1];
		_tmp6_ = self->priv->game;
		_tmp7_ = sudoku_game_get_board (_tmp6_);
		_tmp8_ = _tmp7_;
		gtk_widget_set_visible ((GtkWidget*) _tmp5_, sudoku_board_is_earmark_enabled (_tmp8_, self->priv->row, self->priv->col, num));
	}
}

static void
sudoku_cell_show_earmark_picker (SudokuCell* self)
{
	gint _tmp0_;
	gint _tmp1_;
	GtkPopover* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	NumberPicker* _tmp10_;
	NumberPicker* _tmp11_;
	SudokuGame* _tmp12_;
	SudokuBoard* _tmp13_;
	SudokuBoard* _tmp14_;
	GtkPopover* _tmp16_;
	NumberPicker* _tmp17_;
	GtkPopover* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sudoku_cell_get_value (self);
	_tmp1_ = _tmp0_;
	_vala_return_if_fail (_tmp1_ == 0, "this.value == 0");
	_tmp2_ = self->priv->popover;
	_tmp3_ = gtk_widget_get_visible ((GtkWidget*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		gboolean is_earmark_picker = FALSE;
		GtkPopover* _tmp5_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		_tmp5_ = self->priv->popover;
		_tmp6_ = gtk_popover_get_child (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = number_picker_get_is_earmark_picker (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_NUMBER_PICKER, NumberPicker));
		_tmp9_ = _tmp8_;
		is_earmark_picker = _tmp9_;
		sudoku_cell_dismiss_popover (self);
		if (is_earmark_picker) {
			return;
		}
	}
	g_signal_emit (self, sudoku_cell_signals[SUDOKU_CELL_WILL_OPEN_POPOVER_SIGNAL], 0);
	_tmp10_ = self->priv->earmark_picker;
	number_picker_set_clear_button_visibility (_tmp10_, TRUE);
	_tmp11_ = self->priv->earmark_picker;
	number_picker_set_earmark_buttons (_tmp11_, self->priv->row, self->priv->col);
	_tmp12_ = self->priv->game;
	_tmp13_ = sudoku_game_get_board (_tmp12_);
	_tmp14_ = _tmp13_;
	if (!sudoku_board_has_earmarks (_tmp14_, self->priv->row, self->priv->col)) {
		NumberPicker* _tmp15_;
		_tmp15_ = self->priv->earmark_picker;
		number_picker_set_clear_button_enabled (_tmp15_, FALSE);
	}
	_tmp16_ = self->priv->popover;
	_tmp17_ = self->priv->earmark_picker;
	gtk_popover_set_child (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = self->priv->popover;
	gtk_popover_popup (_tmp18_);
}

static void
sudoku_cell_show_value_picker (SudokuCell* self)
{
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_;
	gint _tmp10_;
	NumberPicker* _tmp14_;
	GtkPopover* _tmp15_;
	NumberPicker* _tmp16_;
	GtkPopover* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean is_earmark_picker = FALSE;
		GtkPopover* _tmp3_;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp3_ = self->priv->popover;
		_tmp4_ = gtk_popover_get_child (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = number_picker_get_is_earmark_picker (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_NUMBER_PICKER, NumberPicker));
		_tmp7_ = _tmp6_;
		is_earmark_picker = _tmp7_;
		sudoku_cell_dismiss_popover (self);
		if (!is_earmark_picker) {
			return;
		}
	}
	g_signal_emit (self, sudoku_cell_signals[SUDOKU_CELL_WILL_OPEN_POPOVER_SIGNAL], 0);
	_tmp9_ = sudoku_cell_get_value (self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 0) {
		_tmp8_ = TRUE;
	} else {
		SudokuGame* _tmp11_;
		SudokuBoard* _tmp12_;
		SudokuBoard* _tmp13_;
		_tmp11_ = self->priv->game;
		_tmp12_ = sudoku_game_get_board (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp8_ = sudoku_board_has_earmarks (_tmp13_, self->priv->row, self->priv->col);
	}
	_tmp14_ = self->priv->value_picker;
	number_picker_set_clear_button_visibility (_tmp14_, _tmp8_);
	_tmp15_ = self->priv->popover;
	_tmp16_ = self->priv->value_picker;
	gtk_popover_set_child (_tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = self->priv->popover;
	gtk_popover_popup (_tmp17_);
}

void
sudoku_cell_check_value_warnings (SudokuCell* self,
                                  gboolean show_extra_warnings)
{
	gboolean _error_ = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	_error_ = FALSE;
	_tmp0_ = sudoku_cell_get_value (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != 0) {
		SudokuGame* _tmp2_;
		SudokuBoard* _tmp3_;
		SudokuBoard* _tmp4_;
		GeeSet* _tmp5_;
		GeeSet* _tmp6_;
		Coord _tmp7_ = {0};
		GtkLabel* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp2_ = self->priv->game;
		_tmp3_ = sudoku_game_get_board (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = sudoku_board_get_broken_coords (_tmp4_);
		_tmp6_ = _tmp5_;
		coord_init (&_tmp7_, self->priv->row, self->priv->col);
		if (gee_collection_contains ((GeeCollection*) _tmp6_, &_tmp7_)) {
			_error_ = TRUE;
		} else {
			gboolean _tmp8_ = FALSE;
			if (show_extra_warnings) {
				SudokuGame* _tmp9_;
				GameMode _tmp10_;
				GameMode _tmp11_;
				_tmp9_ = self->priv->game;
				_tmp10_ = sudoku_game_get_mode (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp8_ = _tmp11_ == GAME_MODE_PLAY;
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				gint solution = 0;
				SudokuGame* _tmp12_;
				SudokuBoard* _tmp13_;
				SudokuBoard* _tmp14_;
				_tmp12_ = self->priv->game;
				_tmp13_ = sudoku_game_get_board (_tmp12_);
				_tmp14_ = _tmp13_;
				solution = sudoku_board_get_solution (_tmp14_, self->priv->row, self->priv->col);
				if (solution != 0) {
					gint _tmp15_;
					gint _tmp16_;
					_tmp15_ = sudoku_cell_get_value (self);
					_tmp16_ = _tmp15_;
					_error_ = _tmp16_ != solution;
				}
			}
		}
		_tmp17_ = self->priv->value_label;
		_tmp18_ = sudoku_cell_get_value (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strdup_printf ("%i", _tmp19_);
		_tmp21_ = _tmp20_;
		gtk_label_set_label (_tmp17_, _tmp21_);
		_g_free0 (_tmp21_);
	} else {
		SudokuGame* _tmp22_;
		SudokuBoard* _tmp23_;
		SudokuBoard* _tmp24_;
		_tmp22_ = self->priv->game;
		_tmp23_ = sudoku_game_get_board (_tmp22_);
		_tmp24_ = _tmp23_;
		if (sudoku_board_count_possibilities (_tmp24_, self->priv->row, self->priv->col) == 0) {
			GtkLabel* _tmp25_;
			_tmp25_ = self->priv->value_label;
			gtk_label_set_label (_tmp25_, "X");
		}
	}
	if (_error_) {
		gtk_widget_add_css_class ((GtkWidget*) self, "error");
	} else {
		gtk_widget_remove_css_class ((GtkWidget*) self, "error");
	}
}

void
sudoku_cell_check_earmarks_warnings (SudokuCell* self)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gboolean* marks = NULL;
	SudokuGame* _tmp6_;
	SudokuBoard* _tmp7_;
	SudokuBoard* _tmp8_;
	gint _tmp9_ = 0;
	gboolean* _tmp10_;
	gint marks_length1;
	gint _marks_size_;
	g_return_if_fail (self != NULL);
	_tmp1_ = sudoku_cell_get_value (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != 0) {
		_tmp0_ = TRUE;
	} else {
		SudokuGame* _tmp3_;
		GameMode _tmp4_;
		GameMode _tmp5_;
		_tmp3_ = self->priv->game;
		_tmp4_ = sudoku_game_get_mode (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ == GAME_MODE_CREATE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp6_ = self->priv->game;
	_tmp7_ = sudoku_game_get_board (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp10_ = sudoku_board_get_earmarks (_tmp8_, self->priv->row, self->priv->col, &_tmp9_);
	marks = _tmp10_;
	marks_length1 = _tmp9_;
	_marks_size_ = marks_length1;
	{
		gint num = 0;
		num = 1;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean* _tmp13_;
				gint _tmp13__length1;
				gboolean* _tmp14_;
				gint _tmp14__length1;
				gboolean _tmp15_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = num;
					num = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp13_ = marks;
				_tmp13__length1 = marks_length1;
				if (!(num <= _tmp13__length1)) {
					break;
				}
				_tmp14_ = marks;
				_tmp14__length1 = marks_length1;
				_tmp15_ = _tmp14_[num - 1];
				if (_tmp15_) {
					sudoku_cell_check_earmark_warnings (self, num);
				}
			}
		}
	}
	marks = (g_free (marks), NULL);
}

void
sudoku_cell_check_earmark_warnings (SudokuCell* self,
                                    gint num)
{
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	SudokuBoard* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_board (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!sudoku_board_is_possible (_tmp2_, self->priv->row, self->priv->col, num)) {
		GtkLabel** _tmp3_;
		gint _tmp3__length1;
		GtkLabel* _tmp4_;
		_tmp3_ = self->priv->earmark_labels;
		_tmp3__length1 = self->priv->earmark_labels_length1;
		_tmp4_ = _tmp3_[num - 1];
		gtk_widget_add_css_class ((GtkWidget*) _tmp4_, "error");
	} else {
		GtkLabel** _tmp5_;
		gint _tmp5__length1;
		GtkLabel* _tmp6_;
		_tmp5_ = self->priv->earmark_labels;
		_tmp5__length1 = self->priv->earmark_labels_length1;
		_tmp6_ = _tmp5_[num - 1];
		gtk_widget_remove_css_class ((GtkWidget*) _tmp6_, "error");
	}
}

void
sudoku_cell_clear_warnings (SudokuCell* self)
{
	gboolean* marks = NULL;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	SudokuBoard* _tmp2_;
	gint _tmp3_ = 0;
	gboolean* _tmp4_;
	gint marks_length1;
	gint _marks_size_;
	GtkLabel* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_board (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = sudoku_board_get_earmarks (_tmp2_, self->priv->row, self->priv->col, &_tmp3_);
	marks = _tmp4_;
	marks_length1 = _tmp3_;
	_marks_size_ = marks_length1;
	_tmp5_ = self->priv->value_label;
	_tmp6_ = sudoku_cell_get_value (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = _tmp8_;
	gtk_label_set_label (_tmp5_, _tmp9_);
	_g_free0 (_tmp9_);
	gtk_widget_remove_css_class ((GtkWidget*) self, "error");
	{
		gint num = 0;
		num = 1;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gboolean* _tmp12_;
				gint _tmp12__length1;
				GtkLabel** _tmp13_;
				gint _tmp13__length1;
				GtkLabel* _tmp14_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = num;
					num = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = marks;
				_tmp12__length1 = marks_length1;
				if (!(num <= _tmp12__length1)) {
					break;
				}
				_tmp13_ = self->priv->earmark_labels;
				_tmp13__length1 = self->priv->earmark_labels_length1;
				_tmp14_ = _tmp13_[num - 1];
				gtk_widget_remove_css_class ((GtkWidget*) _tmp14_, "error");
			}
		}
	}
	marks = (g_free (marks), NULL);
}

static gpointer
_gsk_transform_ref0 (gpointer self)
{
	return self ? gsk_transform_ref (self) : NULL;
}

static void
sudoku_cell_real_size_allocate (GtkWidget* base,
                                gint width,
                                gint height,
                                gint baseline)
{
	SudokuCell * self;
	GtkPopover* _tmp0_ = NULL;
	GtkPopover* _tmp1_;
	gint value_width = 0;
	gint value_height = 0;
	GtkLabel* _tmp2_;
	GskTransform* center = NULL;
	GskTransform* _tmp3_;
	graphene_point_t _tmp4_ = {0};
	graphene_point_t _tmp5_;
	GskTransform* _tmp6_;
	GtkLabel* _tmp7_;
	GskTransform* _tmp8_;
	GskTransform* _tmp9_;
	gint earmark_width = 0;
	gint earmark_height = 0;
	SudokuGame* _tmp10_;
	SudokuBoard* _tmp11_;
	SudokuBoard* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	SudokuGame* _tmp15_;
	SudokuBoard* _tmp16_;
	SudokuBoard* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint num = 0;
	self = (SudokuCell*) base;
	_tmp1_ = self->priv->popover;
	_tmp0_ = _tmp1_;
	if (_tmp0_ != NULL) {
		gtk_popover_present (_tmp0_);
	}
	value_height = MIN (width, height);
	value_width = value_height;
	_tmp2_ = self->priv->value_label;
	sudoku_cell_set_font_size (self, _tmp2_, height / SUDOKU_CELL_size_ratio);
	_tmp3_ = gsk_transform_new ();
	memset (&_tmp4_, 0, sizeof (graphene_point_t));
	_tmp5_ = *graphene_point_init (&_tmp4_, (gfloat) ((width - value_width) / 2), (gfloat) ((height - value_height) / 2));
	_tmp6_ = gsk_transform_translate (_tmp3_, &_tmp5_);
	center = _tmp6_;
	_tmp7_ = self->priv->value_label;
	_tmp8_ = center;
	_tmp9_ = _gsk_transform_ref0 (_tmp8_);
	gtk_widget_allocate ((GtkWidget*) _tmp7_, value_width, value_height, baseline, _tmp9_);
	_tmp10_ = self->priv->game;
	_tmp11_ = sudoku_game_get_board (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = sudoku_board_get_block_cols (_tmp12_);
	_tmp14_ = _tmp13_;
	earmark_width = width / _tmp14_;
	_tmp15_ = self->priv->game;
	_tmp16_ = sudoku_game_get_board (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = sudoku_board_get_block_rows (_tmp17_);
	_tmp19_ = _tmp18_;
	earmark_height = height / _tmp19_;
	num = 0;
	{
		gint row_tmp = 0;
		row_tmp = 0;
		{
			gboolean _tmp20_ = FALSE;
			_tmp20_ = TRUE;
			while (TRUE) {
				SudokuGame* _tmp22_;
				SudokuBoard* _tmp23_;
				SudokuBoard* _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				if (!_tmp20_) {
					gint _tmp21_;
					_tmp21_ = row_tmp;
					row_tmp = _tmp21_ + 1;
				}
				_tmp20_ = FALSE;
				_tmp22_ = self->priv->game;
				_tmp23_ = sudoku_game_get_board (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = sudoku_board_get_block_rows (_tmp24_);
				_tmp26_ = _tmp25_;
				if (!(row_tmp < _tmp26_)) {
					break;
				}
				{
					gint col_tmp = 0;
					col_tmp = 0;
					{
						gboolean _tmp27_ = FALSE;
						_tmp27_ = TRUE;
						while (TRUE) {
							SudokuGame* _tmp29_;
							SudokuBoard* _tmp30_;
							SudokuBoard* _tmp31_;
							gint _tmp32_;
							gint _tmp33_;
							gint _tmp34_;
							GtkLabel** _tmp35_;
							gint _tmp35__length1;
							GtkLabel* _tmp36_;
							GskTransform* earmark_position = NULL;
							GskTransform* _tmp37_;
							graphene_point_t _tmp38_ = {0};
							SudokuGame* _tmp39_;
							SudokuBoard* _tmp40_;
							SudokuBoard* _tmp41_;
							gint _tmp42_;
							gint _tmp43_;
							graphene_point_t _tmp44_;
							GskTransform* _tmp45_;
							GtkLabel** _tmp46_;
							gint _tmp46__length1;
							GtkLabel* _tmp47_;
							GskTransform* _tmp48_;
							GskTransform* _tmp49_;
							if (!_tmp27_) {
								gint _tmp28_;
								_tmp28_ = col_tmp;
								col_tmp = _tmp28_ + 1;
							}
							_tmp27_ = FALSE;
							_tmp29_ = self->priv->game;
							_tmp30_ = sudoku_game_get_board (_tmp29_);
							_tmp31_ = _tmp30_;
							_tmp32_ = sudoku_board_get_block_cols (_tmp31_);
							_tmp33_ = _tmp32_;
							if (!(col_tmp < _tmp33_)) {
								break;
							}
							_tmp34_ = num;
							num = _tmp34_ + 1;
							_tmp35_ = self->priv->earmark_labels;
							_tmp35__length1 = self->priv->earmark_labels_length1;
							_tmp36_ = _tmp35_[num - 1];
							sudoku_cell_set_font_size (self, _tmp36_, (height / SUDOKU_CELL_size_ratio) / 2);
							_tmp37_ = gsk_transform_new ();
							memset (&_tmp38_, 0, sizeof (graphene_point_t));
							_tmp39_ = self->priv->game;
							_tmp40_ = sudoku_game_get_board (_tmp39_);
							_tmp41_ = _tmp40_;
							_tmp42_ = sudoku_board_get_block_rows (_tmp41_);
							_tmp43_ = _tmp42_;
							_tmp44_ = *graphene_point_init (&_tmp38_, (gfloat) (col_tmp * earmark_width), (gfloat) (((_tmp43_ - row_tmp) - 1) * earmark_height));
							_tmp45_ = gsk_transform_translate (_tmp37_, &_tmp44_);
							earmark_position = _tmp45_;
							_tmp46_ = self->priv->earmark_labels;
							_tmp46__length1 = self->priv->earmark_labels_length1;
							_tmp47_ = _tmp46_[num - 1];
							_tmp48_ = earmark_position;
							_tmp49_ = _gsk_transform_ref0 (_tmp48_);
							gtk_widget_allocate ((GtkWidget*) _tmp47_, earmark_width, earmark_height, baseline, _tmp49_);
							_gsk_transform_unref0 (earmark_position);
						}
					}
				}
			}
		}
	}
	_gsk_transform_unref0 (center);
}

static gpointer
_pango_attr_list_ref0 (gpointer self)
{
	return self ? pango_attr_list_ref (self) : NULL;
}

static void
sudoku_cell_set_font_size (SudokuCell* self,
                           GtkLabel* label,
                           gint font_size)
{
	PangoAttrList* attr_list = NULL;
	PangoAttrList* _tmp0_;
	PangoAttrList* _tmp1_;
	PangoAttrList* _tmp2_;
	PangoAttrList* _tmp4_;
	PangoAttribute* _tmp5_;
	PangoAttrList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = gtk_label_get_attributes (label);
	_tmp1_ = _pango_attr_list_ref0 (_tmp0_);
	attr_list = _tmp1_;
	_tmp2_ = attr_list;
	if (_tmp2_ == NULL) {
		PangoAttrList* _tmp3_;
		_tmp3_ = pango_attr_list_new ();
		_pango_attr_list_unref0 (attr_list);
		attr_list = _tmp3_;
	}
	_tmp4_ = attr_list;
	_tmp5_ = pango_attr_size_new_absolute (font_size * PANGO_SCALE);
	pango_attr_list_change (_tmp4_, _tmp5_);
	_tmp6_ = attr_list;
	gtk_label_set_attributes (label, _tmp6_);
	_pango_attr_list_unref0 (attr_list);
}

void
sudoku_cell_dismiss_popover (SudokuCell* self)
{
	GtkPopover* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->popover;
	if (_tmp0_ != NULL) {
		GtkPopover* _tmp1_;
		GtkPopover* _tmp2_;
		_tmp1_ = self->priv->popover;
		gtk_popover_popdown (_tmp1_);
		_tmp2_ = self->priv->popover;
		gtk_popover_set_child (_tmp2_, NULL);
	}
}

static void
sudoku_cell_real_dispose (GObject* base)
{
	SudokuCell * self;
	GtkLabel* _tmp0_;
	GtkLabel** _tmp1_;
	gint _tmp1__length1;
	GtkPopover* _tmp4_ = NULL;
	GtkPopover* _tmp5_;
	self = (SudokuCell*) base;
	_tmp0_ = self->priv->value_label;
	gtk_widget_unparent ((GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->earmark_labels;
	_tmp1__length1 = self->priv->earmark_labels_length1;
	{
		GtkLabel** earmark_collection = NULL;
		gint earmark_collection_length1 = 0;
		gint _earmark_collection_size_ = 0;
		gint earmark_it = 0;
		earmark_collection = _tmp1_;
		earmark_collection_length1 = _tmp1__length1;
		for (earmark_it = 0; earmark_it < earmark_collection_length1; earmark_it = earmark_it + 1) {
			GtkLabel* _tmp2_;
			GtkLabel* earmark = NULL;
			_tmp2_ = _g_object_ref0 (earmark_collection[earmark_it]);
			earmark = _tmp2_;
			{
				GtkLabel* _tmp3_;
				_tmp3_ = earmark;
				gtk_widget_unparent ((GtkWidget*) _tmp3_);
				_g_object_unref0 (earmark);
			}
		}
	}
	_tmp5_ = self->priv->popover;
	_tmp4_ = _tmp5_;
	if (_tmp4_ != NULL) {
		gtk_widget_unparent ((GtkWidget*) _tmp4_);
	}
	G_OBJECT_CLASS (sudoku_cell_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

gint
sudoku_cell_get_value (SudokuCell* self)
{
	gint result;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	SudokuBoard* _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_board (_tmp0_);
	_tmp2_ = _tmp1_;
	result = sudoku_board_get (_tmp2_, self->priv->row, self->priv->col);
	return result;
}

void
sudoku_cell_set_value (SudokuCell* self,
                       gint value)
{
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp1_;
	SudokuBoard* _tmp2_;
	SudokuBoard* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	_tmp2_ = sudoku_game_get_board (_tmp1_);
	_tmp3_ = _tmp2_;
	if (value == sudoku_board_get (_tmp3_, self->priv->row, self->priv->col)) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = sudoku_cell_get_is_fixed (self);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_;
	}
	if (_tmp0_) {
		return;
	}
	if (value != 0) {
		GtkLabel* _tmp6_;
		_tmp6_ = self->priv->value_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
	} else {
		GtkLabel* _tmp7_;
		_tmp7_ = self->priv->value_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp7_, FALSE);
	}
	if (value == 0) {
		SudokuGame* _tmp8_;
		SudokuBoard* _tmp9_;
		SudokuBoard* _tmp10_;
		_tmp8_ = self->priv->game;
		_tmp9_ = sudoku_game_get_board (_tmp8_);
		_tmp10_ = _tmp9_;
		if (sudoku_board_get (_tmp10_, self->priv->row, self->priv->col) != 0) {
			SudokuGame* _tmp11_;
			_tmp11_ = self->priv->game;
			sudoku_game_remove (_tmp11_, self->priv->row, self->priv->col);
		}
	} else {
		GtkLabel* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		SudokuGame* _tmp15_;
		_tmp12_ = self->priv->value_label;
		_tmp13_ = g_strdup_printf ("%i", value);
		_tmp14_ = _tmp13_;
		gtk_label_set_label (_tmp12_, _tmp14_);
		_g_free0 (_tmp14_);
		_tmp15_ = self->priv->game;
		sudoku_game_insert (_tmp15_, self->priv->row, self->priv->col, value);
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_properties[SUDOKU_CELL_VALUE_PROPERTY]);
}

gboolean
sudoku_cell_get_is_fixed (SudokuCell* self)
{
	gboolean result;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	SudokuBoard* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_board (_tmp0_);
	_tmp2_ = _tmp1_;
	result = sudoku_board_get_is_fixed (_tmp2_, self->priv->row, self->priv->col);
	return result;
}

gboolean
sudoku_cell_get_selected (SudokuCell* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_selected;
	return result;
}

void
sudoku_cell_set_selected (SudokuCell* self,
                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_selected = value;
	sudoku_cell_set_fixed_css (self, !value);
	if (value) {
		gtk_widget_add_css_class ((GtkWidget*) self, "selected");
	} else {
		gtk_widget_remove_css_class ((GtkWidget*) self, "selected");
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_properties[SUDOKU_CELL_SELECTED_PROPERTY]);
}

gboolean
sudoku_cell_get_highlighted_background (SudokuCell* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_highlighted_background;
	return result;
}

void
sudoku_cell_set_highlighted_background (SudokuCell* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_highlighted_background = value;
	sudoku_cell_set_fixed_css (self, !value);
	if (value) {
		gtk_widget_add_css_class ((GtkWidget*) self, "highlight-bg");
	} else {
		gtk_widget_remove_css_class ((GtkWidget*) self, "highlight-bg");
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_properties[SUDOKU_CELL_HIGHLIGHTED_BACKGROUND_PROPERTY]);
}

gboolean
sudoku_cell_get_highlighted_value (SudokuCell* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_highlighted_value;
	return result;
}

void
sudoku_cell_set_highlighted_value (SudokuCell* self,
                                   gboolean value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	self->priv->_highlighted_value = value;
	if (value) {
		_tmp0_ = !gtk_widget_has_css_class ((GtkWidget*) self, "error");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gtk_widget_add_css_class ((GtkWidget*) self, "highlight-label");
	} else {
		gtk_widget_remove_css_class ((GtkWidget*) self, "highlight-label");
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_properties[SUDOKU_CELL_HIGHLIGHTED_VALUE_PROPERTY]);
}

gboolean
sudoku_cell_get_paused (SudokuCell* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_paused;
	return result;
}

void
sudoku_cell_set_paused (SudokuCell* self,
                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_paused = value;
	if (value) {
		gtk_widget_add_css_class ((GtkWidget*) self, "paused");
	} else {
		gtk_widget_remove_css_class ((GtkWidget*) self, "paused");
	}
	g_object_notify_by_pspec ((GObject *) self, sudoku_cell_properties[SUDOKU_CELL_PAUSED_PROPERTY]);
}

static void
sudoku_cell_class_init (SudokuCellClass * klass,
                        gpointer klass_data)
{
	sudoku_cell_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuCell_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) sudoku_cell_real_size_allocate;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) sudoku_cell_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_cell_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_cell_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_cell_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VALUE_PROPERTY, sudoku_cell_properties[SUDOKU_CELL_VALUE_PROPERTY] = g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_IS_FIXED_PROPERTY, sudoku_cell_properties[SUDOKU_CELL_IS_FIXED_PROPERTY] = g_param_spec_boolean ("is-fixed", "is-fixed", "is-fixed", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_SELECTED_PROPERTY, sudoku_cell_properties[SUDOKU_CELL_SELECTED_PROPERTY] = g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_HIGHLIGHTED_BACKGROUND_PROPERTY, sudoku_cell_properties[SUDOKU_CELL_HIGHLIGHTED_BACKGROUND_PROPERTY] = g_param_spec_boolean ("highlighted-background", "highlighted-background", "highlighted-background", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_HIGHLIGHTED_VALUE_PROPERTY, sudoku_cell_properties[SUDOKU_CELL_HIGHLIGHTED_VALUE_PROPERTY] = g_param_spec_boolean ("highlighted-value", "highlighted-value", "highlighted-value", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_PAUSED_PROPERTY, sudoku_cell_properties[SUDOKU_CELL_PAUSED_PROPERTY] = g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	sudoku_cell_signals[SUDOKU_CELL_WILL_OPEN_POPOVER_SIGNAL] = g_signal_new ("will-open-popover", TYPE_SUDOKU_CELL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "sudokucell");
}

static void
sudoku_cell_instance_init (SudokuCell * self,
                           gpointer klass)
{
	GtkGestureClick* _tmp0_;
	GtkGestureLongPress* _tmp1_;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel** _tmp3_;
	self->priv = sudoku_cell_get_instance_private (self);
	_tmp0_ = (GtkGestureClick*) gtk_gesture_click_new ();
	self->priv->button_controller = _tmp0_;
	_tmp1_ = (GtkGestureLongPress*) gtk_gesture_long_press_new ();
	self->priv->long_press_controller = _tmp1_;
	_tmp2_ = (GtkLabel*) gtk_label_new ("");
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, FALSE);
	g_object_ref_sink (_tmp2_);
	self->priv->value_label = _tmp2_;
	_tmp3_ = g_new0 (GtkLabel*, 9 + 1);
	self->priv->earmark_labels = _tmp3_;
	self->priv->earmark_labels_length1 = 9;
	self->priv->_earmark_labels_size_ = self->priv->earmark_labels_length1;
	self->priv->_selected = FALSE;
	self->priv->_highlighted_background = FALSE;
	self->priv->_highlighted_value = FALSE;
	self->priv->_paused = FALSE;
}

static void
sudoku_cell_finalize (GObject * obj)
{
	SudokuCell * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_CELL, SudokuCell);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->button_controller);
	_g_object_unref0 (self->priv->long_press_controller);
	_g_object_unref0 (self->priv->popover);
	_g_object_unref0 (self->priv->key_controller);
	_g_object_unref0 (self->priv->earmark_picker);
	_g_object_unref0 (self->priv->value_picker);
	_g_object_unref0 (self->priv->value_label);
	self->priv->earmark_labels = (_vala_array_free (self->priv->earmark_labels, self->priv->earmark_labels_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (sudoku_cell_parent_class)->finalize (obj);
}

static GType
sudoku_cell_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuCellClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_cell_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuCell), 0, (GInstanceInitFunc) sudoku_cell_instance_init, NULL };
	GType sudoku_cell_type_id;
	sudoku_cell_type_id = g_type_register_static (gtk_widget_get_type (), "SudokuCell", &g_define_type_info, 0);
	SudokuCell_private_offset = g_type_add_instance_private (sudoku_cell_type_id, sizeof (SudokuCellPrivate));
	return sudoku_cell_type_id;
}

GType
sudoku_cell_get_type (void)
{
	static volatile gsize sudoku_cell_type_id__once = 0;
	if (g_once_init_enter (&sudoku_cell_type_id__once)) {
		GType sudoku_cell_type_id;
		sudoku_cell_type_id = sudoku_cell_get_type_once ();
		g_once_init_leave (&sudoku_cell_type_id__once, sudoku_cell_type_id);
	}
	return sudoku_cell_type_id__once;
}

static void
_vala_sudoku_cell_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	SudokuCell * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL, SudokuCell);
	switch (property_id) {
		case SUDOKU_CELL_VALUE_PROPERTY:
		g_value_set_int (value, sudoku_cell_get_value (self));
		break;
		case SUDOKU_CELL_IS_FIXED_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_get_is_fixed (self));
		break;
		case SUDOKU_CELL_SELECTED_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_get_selected (self));
		break;
		case SUDOKU_CELL_HIGHLIGHTED_BACKGROUND_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_get_highlighted_background (self));
		break;
		case SUDOKU_CELL_HIGHLIGHTED_VALUE_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_get_highlighted_value (self));
		break;
		case SUDOKU_CELL_PAUSED_PROPERTY:
		g_value_set_boolean (value, sudoku_cell_get_paused (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sudoku_cell_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	SudokuCell * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL, SudokuCell);
	switch (property_id) {
		case SUDOKU_CELL_VALUE_PROPERTY:
		sudoku_cell_set_value (self, g_value_get_int (value));
		break;
		case SUDOKU_CELL_SELECTED_PROPERTY:
		sudoku_cell_set_selected (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_HIGHLIGHTED_BACKGROUND_PROPERTY:
		sudoku_cell_set_highlighted_background (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_HIGHLIGHTED_VALUE_PROPERTY:
		sudoku_cell_set_highlighted_value (self, g_value_get_boolean (value));
		break;
		case SUDOKU_CELL_PAUSED_PROPERTY:
		sudoku_cell_set_paused (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

