/* print-dialog.c generated by valac 0.56.17, the Vala compiler
 * generated from print-dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <adwaita.h>
#include <glib-object.h>
#include "libsudoku.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gdk/gdk.h>

#define PRINT_DIALOG_DIFFICULTY_KEY_NAME "print-multiple-sudoku-difficulty"
#define PRINT_DIALOG_MAX_PUZZLES_PER_PAGE 15
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;
typedef struct _PrintDialogPrivate PrintDialogPrivate;
enum  {
	PRINT_DIALOG_0_PROPERTY,
	PRINT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* print_dialog_properties[PRINT_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PrintDialog {
	AdwWindow parent_instance;
	PrintDialogPrivate * priv;
};

struct _PrintDialogClass {
	AdwWindowClass parent_class;
};

struct _PrintDialogPrivate {
	SudokuSaver* saver;
	GSettings* settings;
	GtkButton* print_button;
	AdwPreferencesGroup* options_group;
	AdwSpinRow* n_puzzles;
	AdwSpinRow* n_puzzles_per_page;
	AdwComboRow* difficulty;
	GCancellable* cancellable;
};

struct _Block5Data {
	int _ref_count_;
	PrintDialog* self;
	GtkAdjustment* total;
	GtkAdjustment* per_page;
};

struct _Block6Data {
	int _ref_count_;
	PrintDialog* self;
	gint npuzzles_per_page;
};

static gint PrintDialog_private_offset;
static gpointer print_dialog_parent_class = NULL;

VALA_EXTERN GType print_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PrintDialog, g_object_unref)
VALA_EXTERN PrintDialog* print_dialog_new (SudokuSaver* saver,
                               GtkWindow* window);
VALA_EXTERN PrintDialog* print_dialog_construct (GType object_type,
                                     SudokuSaver* saver,
                                     GtkWindow* window);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda22_ (Block5Data* _data5_);
static void ___lambda22__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                gpointer self);
static void __lambda23_ (Block5Data* _data5_);
static void ___lambda23__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                                gpointer self);
static void __lambda24_ (PrintDialog* self);
VALA_EXTERN void print_dialog_print (PrintDialog* self);
static void ___lambda24__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda25_ (Block6Data* _data6_,
                  GObject* obj,
                  GAsyncResult* res);
VALA_EXTERN GType sudoku_printer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuPrinter, g_object_unref)
VALA_EXTERN SudokuPrinter* sudoku_printer_new (GeeList* boards,
                                   gint sudokus_per_page,
                                   GtkWindow* window);
VALA_EXTERN SudokuPrinter* sudoku_printer_construct (GType object_type,
                                         GeeList* boards,
                                         gint sudokus_per_page,
                                         GtkWindow* window);
VALA_EXTERN GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
static void ___lambda25__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static gboolean _print_dialog___lambda26_ (GtkWidget* _self_);
static gboolean __print_dialog___lambda26__gtk_shortcut_func (GtkWidget* widget,
                                                       GVariant* args,
                                                       gpointer self);
static void print_dialog_finalize (GObject * obj);
static GType print_dialog_get_type_once (void);

static inline gpointer
print_dialog_get_instance_private (PrintDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PrintDialog_private_offset);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		PrintDialog* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->per_page);
		_g_object_unref0 (_data5_->total);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda22_ (Block5Data* _data5_)
{
	PrintDialog* self;
	gint total_value = 0;
	GSettings* _tmp0_;
	gint max_per_page = 0;
	gint per_page_value = 0;
	self = _data5_->self;
	total_value = (gint) gtk_adjustment_get_value (_data5_->total);
	_tmp0_ = self->priv->settings;
	g_settings_set_int (_tmp0_, "print-multiple-sudokus-to-print", total_value);
	max_per_page = MIN (PRINT_DIALOG_MAX_PUZZLES_PER_PAGE, total_value);
	per_page_value = (gint) gtk_adjustment_get_value (_data5_->per_page);
	per_page_value = MIN (per_page_value, max_per_page);
	gtk_adjustment_set_upper (_data5_->per_page, (gdouble) max_per_page);
	gtk_adjustment_set_value (_data5_->per_page, (gdouble) per_page_value);
}

static void
___lambda22__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                           gpointer self)
{
	__lambda22_ (self);
}

static void
__lambda23_ (Block5Data* _data5_)
{
	PrintDialog* self;
	gint per_page_value = 0;
	GSettings* _tmp0_;
	self = _data5_->self;
	per_page_value = (gint) gtk_adjustment_get_value (_data5_->per_page);
	_tmp0_ = self->priv->settings;
	g_settings_set_int (_tmp0_, "print-multiple-sudokus-to-print-per-page", per_page_value);
}

static void
___lambda23__gtk_adjustment_value_changed (GtkAdjustment* _sender,
                                           gpointer self)
{
	__lambda23_ (self);
}

static void
__lambda24_ (PrintDialog* self)
{
	print_dialog_print (self);
}

static void
___lambda24__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda24_ ((PrintDialog*) self);
}

PrintDialog*
print_dialog_construct (GType object_type,
                        SudokuSaver* saver,
                        GtkWindow* window)
{
	PrintDialog * self = NULL;
	Block5Data* _data5_;
	SudokuSaver* _tmp0_;
	GSettings* _tmp1_;
	DifficultyCategory saved_difficulty = 0;
	GSettings* _tmp2_;
	AdwComboRow* _tmp3_;
	gint initial_total_value = 0;
	GSettings* _tmp4_;
	gint initial_per_page_value = 0;
	GSettings* _tmp5_;
	AdwSpinRow* _tmp6_;
	GtkAdjustment* _tmp7_;
	GtkAdjustment* _tmp8_;
	AdwSpinRow* _tmp9_;
	GtkAdjustment* _tmp10_;
	GtkAdjustment* _tmp11_;
	gint initial_max_per_page = 0;
	GtkButton* _tmp12_;
	g_return_val_if_fail (saver != NULL, NULL);
	g_return_val_if_fail (window != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	self = (PrintDialog*) g_object_new (object_type, NULL);
	_data5_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (saver);
	_g_object_unref0 (self->priv->saver);
	self->priv->saver = _tmp0_;
	_tmp1_ = g_settings_new ("org.gnome.Sudoku");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp1_;
	gtk_window_set_transient_for ((GtkWindow*) self, window);
	_tmp2_ = self->priv->settings;
	saved_difficulty = (DifficultyCategory) g_settings_get_enum (_tmp2_, PRINT_DIALOG_DIFFICULTY_KEY_NAME);
	_tmp3_ = self->priv->difficulty;
	adw_combo_row_set_selected (_tmp3_, (guint) (((gint) saved_difficulty) - 1));
	_tmp4_ = self->priv->settings;
	initial_total_value = g_settings_get_int (_tmp4_, "print-multiple-sudokus-to-print");
	_tmp5_ = self->priv->settings;
	initial_per_page_value = g_settings_get_int (_tmp5_, "print-multiple-sudokus-to-print-per-page");
	_tmp6_ = self->priv->n_puzzles;
	_tmp7_ = adw_spin_row_get_adjustment (_tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_data5_->total = _tmp8_;
	_tmp9_ = self->priv->n_puzzles_per_page;
	_tmp10_ = adw_spin_row_get_adjustment (_tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_data5_->per_page = _tmp11_;
	gtk_adjustment_set_value (_data5_->total, (gdouble) initial_total_value);
	initial_max_per_page = MIN (PRINT_DIALOG_MAX_PUZZLES_PER_PAGE, initial_total_value);
	gtk_adjustment_set_value (_data5_->per_page, (gdouble) MIN (initial_max_per_page, initial_per_page_value));
	gtk_adjustment_set_upper (_data5_->per_page, (gdouble) initial_max_per_page);
	g_signal_connect_data (_data5_->total, "value-changed", (GCallback) ___lambda22__gtk_adjustment_value_changed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	g_signal_connect_data (_data5_->per_page, "value-changed", (GCallback) ___lambda23__gtk_adjustment_value_changed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	_tmp12_ = self->priv->print_button;
	g_signal_connect_object (_tmp12_, "clicked", (GCallback) ___lambda24__gtk_button_clicked, self, 0);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return self;
}

PrintDialog*
print_dialog_new (SudokuSaver* saver,
                  GtkWindow* window)
{
	return print_dialog_construct (TYPE_PRINT_DIALOG, saver, window);
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		PrintDialog* self;
		self = _data6_->self;
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda25_ (Block6Data* _data6_,
             GObject* obj,
             GAsyncResult* res)
{
	PrintDialog* self;
	GError* _inner_error0_ = NULL;
	self = _data6_->self;
	g_return_if_fail (res != NULL);
	{
		GeeList* boards = NULL;
		GeeList* _tmp0_;
		SudokuPrinter* printer = NULL;
		SudokuPrinter* _tmp1_;
		SudokuPrinter* _tmp2_;
		_tmp0_ = sudoku_generator_generate_boards_finish (res, &_inner_error0_);
		boards = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_THREAD_ERROR) {
				goto __catch0_g_thread_error;
			}
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp1_ = sudoku_printer_new (boards, _data6_->npuzzles_per_page, (GtkWindow*) self);
		printer = _tmp1_;
		_tmp2_ = printer;
		if (sudoku_printer_print_sudoku (_tmp2_) == GTK_PRINT_OPERATION_RESULT_APPLY) {
			{
				GeeList* _board_list = NULL;
				gint _board_size = 0;
				GeeList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				gint _board_index = 0;
				_board_list = boards;
				_tmp3_ = _board_list;
				_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				_board_size = _tmp5_;
				_board_index = -1;
				while (TRUE) {
					gint _tmp6_;
					gint _tmp7_;
					SudokuBoard* board = NULL;
					GeeList* _tmp8_;
					gpointer _tmp9_;
					SudokuSaver* _tmp10_;
					SudokuBoard* _tmp11_;
					SudokuGame* _tmp12_;
					SudokuGame* _tmp13_;
					_board_index = _board_index + 1;
					_tmp6_ = _board_index;
					_tmp7_ = _board_size;
					if (!(_tmp6_ < _tmp7_)) {
						break;
					}
					_tmp8_ = _board_list;
					_tmp9_ = gee_list_get (_tmp8_, _board_index);
					board = (SudokuBoard*) _tmp9_;
					_tmp10_ = self->priv->saver;
					_tmp11_ = board;
					_tmp12_ = sudoku_game_new (_tmp11_);
					_tmp13_ = _tmp12_;
					sudoku_saver_add_game_to_finished (_tmp10_, _tmp13_, FALSE);
					_g_object_unref0 (_tmp13_);
					_g_object_unref0 (board);
				}
			}
		}
		_g_object_unref0 (printer);
		_g_object_unref0 (boards);
	}
	goto __finally0;
	__catch0_g_thread_error:
	{
		GError* e = NULL;
		const gchar* _tmp14_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp14_ = e->message;
		g_error ("print-dialog.vala:117: Thread error: %s\n", _tmp14_);
		_g_error_free0 (e);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp15_ = e;
		if (!g_error_matches (_tmp15_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			GError* _tmp16_;
			const gchar* _tmp17_;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			g_warning ("print-dialog.vala:122: Error: %s\n", _tmp17_);
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	gtk_window_destroy ((GtkWindow*) self);
}

static void
___lambda25__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda25_ (self, source_object, res);
	block6_data_unref (self);
}

void
print_dialog_print (PrintDialog* self)
{
	Block6Data* _data6_;
	gint npuzzles = 0;
	AdwSpinRow* _tmp0_;
	GtkAdjustment* _tmp1_;
	AdwSpinRow* _tmp2_;
	GtkAdjustment* _tmp3_;
	DifficultyCategory level = 0;
	AdwComboRow* _tmp4_;
	GSettings* _tmp5_;
	GtkButton* _tmp6_;
	AdwPreferencesGroup* _tmp7_;
	GCancellable* _tmp8_;
	GCancellable* _tmp9_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_tmp0_ = self->priv->n_puzzles;
	_tmp1_ = adw_spin_row_get_adjustment (_tmp0_);
	npuzzles = (gint) gtk_adjustment_get_value (_tmp1_);
	_tmp2_ = self->priv->n_puzzles_per_page;
	_tmp3_ = adw_spin_row_get_adjustment (_tmp2_);
	_data6_->npuzzles_per_page = (gint) gtk_adjustment_get_value (_tmp3_);
	_tmp4_ = self->priv->difficulty;
	level = ((DifficultyCategory) adw_combo_row_get_selected (_tmp4_)) + 1;
	_tmp5_ = self->priv->settings;
	g_settings_set_enum (_tmp5_, PRINT_DIALOG_DIFFICULTY_KEY_NAME, (gint) level);
	_tmp6_ = self->priv->print_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, FALSE);
	_tmp7_ = self->priv->options_group;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, FALSE);
	_tmp8_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp8_;
	_tmp9_ = self->priv->cancellable;
	sudoku_generator_generate_boards_async (npuzzles, level, _tmp9_, ___lambda25__gasync_ready_callback, block6_data_ref (_data6_));
	block6_data_unref (_data6_);
	_data6_ = NULL;
}

static gboolean
_print_dialog___lambda26_ (GtkWidget* _self_)
{
	gboolean result;
	g_return_val_if_fail (_self_ != NULL, FALSE);
	gtk_window_destroy ((GtkWindow*) G_TYPE_CHECK_INSTANCE_CAST (_self_, TYPE_PRINT_DIALOG, PrintDialog));
	result = GDK_EVENT_STOP;
	return result;
}

static gboolean
__print_dialog___lambda26__gtk_shortcut_func (GtkWidget* widget,
                                              GVariant* args,
                                              gpointer self)
{
	gboolean result;
	result = _print_dialog___lambda26_ (widget);
	return result;
}

static void
print_dialog_class_init (PrintDialogClass * klass,
                         gpointer klass_data)
{
	print_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PrintDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = print_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Sudoku/ui/print-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "print_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, print_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "options_group", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, options_group));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "n_puzzles", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, n_puzzles));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "n_puzzles_per_page", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, n_puzzles_per_page));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "difficulty", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, difficulty));
	gtk_widget_class_add_binding (GTK_WIDGET_CLASS (klass), GDK_KEY_Escape, 0, __print_dialog___lambda26__gtk_shortcut_func, NULL, NULL, NULL);
}

static void
print_dialog_instance_init (PrintDialog * self,
                            gpointer klass)
{
	self->priv = print_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
print_dialog_finalize (GObject * obj)
{
	PrintDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_DIALOG, PrintDialog);
	_g_object_unref0 (self->priv->saver);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->cancellable);
	G_OBJECT_CLASS (print_dialog_parent_class)->finalize (obj);
}

static GType
print_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrintDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintDialog), 0, (GInstanceInitFunc) print_dialog_instance_init, NULL };
	GType print_dialog_type_id;
	print_dialog_type_id = g_type_register_static (adw_window_get_type (), "PrintDialog", &g_define_type_info, 0);
	PrintDialog_private_offset = g_type_add_instance_private (print_dialog_type_id, sizeof (PrintDialogPrivate));
	return print_dialog_type_id;
}

GType
print_dialog_get_type (void)
{
	static volatile gsize print_dialog_type_id__once = 0;
	if (g_once_init_enter (&print_dialog_type_id__once)) {
		GType print_dialog_type_id;
		print_dialog_type_id = print_dialog_get_type_once ();
		g_once_init_leave (&print_dialog_type_id__once, print_dialog_type_id);
	}
	return print_dialog_type_id__once;
}

