/* gnome-sudoku.c generated by valac 0.56.17, the Vala compiler
 * generated from gnome-sudoku.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include "libsudoku.h"
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gdk/gdk.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
typedef struct _SudokuPrivate SudokuPrivate;

#define TYPE_SUDOKU_WINDOW (sudoku_window_get_type ())
#define SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_WINDOW, SudokuWindow))
#define SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_WINDOW, SudokuWindowClass))
#define IS_SUDOKU_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_WINDOW))
#define IS_SUDOKU_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_WINDOW))
#define SUDOKU_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_WINDOW, SudokuWindowClass))

typedef struct _SudokuWindow SudokuWindow;
typedef struct _SudokuWindowClass SudokuWindowClass;
enum  {
	SUDOKU_0_PROPERTY,
	SUDOKU_NUM_PROPERTIES
};
static GParamSpec* sudoku_properties[SUDOKU_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SUDOKU_MAIN_MENU_ITEM (sudoku_main_menu_item_get_type ())
#define SUDOKU_MAIN_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_MAIN_MENU_ITEM, SudokuMainMenuItem))
#define SUDOKU_MAIN_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_MAIN_MENU_ITEM, SudokuMainMenuItemClass))
#define IS_SUDOKU_MAIN_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_MAIN_MENU_ITEM))
#define IS_SUDOKU_MAIN_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_MAIN_MENU_ITEM))
#define SUDOKU_MAIN_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_MAIN_MENU_ITEM, SudokuMainMenuItemClass))

typedef struct _SudokuMainMenuItem SudokuMainMenuItem;
typedef struct _SudokuMainMenuItemClass SudokuMainMenuItemClass;

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block4Data Block4Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;

#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;

struct _Sudoku {
	AdwApplication parent_instance;
	SudokuPrivate * priv;
};

struct _SudokuClass {
	AdwApplicationClass parent_class;
};

struct _SudokuPrivate {
	GSettings* settings;
	SudokuWindow* window;
	SudokuGame* game;
	SudokuSaver* saver;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GSimpleAction* clear_action;
	GSimpleAction* print_action;
	GSimpleAction* print_multiple_action;
	GSimpleAction* pause_action;
	GSimpleAction* play_custom_game_action;
	GSimpleAction* new_game_action;
	GSimpleAction* show_timer_action;
	GameMode current_game_mode;
	DifficultyCategory play_difficulty;
};

struct _Block1Data {
	int _ref_count_;
	Sudoku* self;
	AdwMessageDialog* dialog;
};

struct _Block2Data {
	int _ref_count_;
	Sudoku* self;
	AdwMessageDialog* dialog;
};

struct _Block3Data {
	int _ref_count_;
	Sudoku* self;
	AdwMessageDialog* dialog;
};

struct _Block4Data {
	int _ref_count_;
	Sudoku* self;
	AdwMessageDialog* dialog;
};

static gint Sudoku_private_offset;
static gpointer sudoku_parent_class = NULL;

VALA_EXTERN GType sudoku_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Sudoku, g_object_unref)
VALA_EXTERN GType sudoku_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuWindow, g_object_unref)
static void sudoku_new_game_cb (Sudoku* self);
static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void sudoku_start_game_cb (Sudoku* self,
                           GSimpleAction* action,
                           GVariant* difficulty);
static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void sudoku_create_game_cb (Sudoku* self);
static void _sudoku_create_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self);
static void sudoku_reset_cb (Sudoku* self);
static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
static void sudoku_back_cb (Sudoku* self);
static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self);
static void sudoku_undo_cb (Sudoku* self);
static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self);
static void sudoku_redo_cb (Sudoku* self);
static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self);
static void sudoku_print_cb (Sudoku* self);
static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
static void sudoku_play_custom_game_cb (Sudoku* self);
static void _sudoku_play_custom_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void sudoku_toggle_pause_cb (Sudoku* self);
static void _sudoku_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void sudoku_print_multiple_cb (Sudoku* self);
static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void sudoku_help_cb (Sudoku* self);
static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self);
static void sudoku_about_cb (Sudoku* self);
static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
static void sudoku_fullscreen_cb (Sudoku* self);
static void _sudoku_fullscreen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void sudoku_show_timer_cb (Sudoku* self);
static void _sudoku_show_timer_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
VALA_EXTERN Sudoku* sudoku_new (void);
VALA_EXTERN Sudoku* sudoku_construct (GType object_type);
VALA_EXTERN GType sudoku_main_menu_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuMainMenuItem, g_object_unref)
static gint sudoku_real_handle_local_options (GApplication* base,
                                       GVariantDict* options);
static void sudoku_real_startup (GApplication* base);
static void __lambda27_ (Sudoku* self);
VALA_EXTERN GType sudoku_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuView, g_object_unref)
static SudokuView* sudoku_get_view (Sudoku* self);
VALA_EXTERN void sudoku_view_set_show_warnings (SudokuView* self,
                                    gboolean value);
static void ___lambda27__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda28_ (Sudoku* self);
VALA_EXTERN void sudoku_view_set_show_extra_warnings (SudokuView* self,
                                          gboolean value);
static void ___lambda28__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda29_ (Sudoku* self);
VALA_EXTERN void sudoku_view_set_show_possibilities (SudokuView* self,
                                         gboolean value);
static void ___lambda29__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda30_ (Sudoku* self);
VALA_EXTERN void sudoku_view_set_highlighter (SudokuView* self,
                                  gboolean value);
static void ___lambda30__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static GVariant* _variant_new1 (gboolean value);
VALA_EXTERN SudokuWindow* sudoku_window_new (GSettings* settings);
VALA_EXTERN SudokuWindow* sudoku_window_construct (GType object_type,
                                       GSettings* settings);
static void sudoku_start_game (Sudoku* self,
                        SudokuBoard* board);
static void sudoku_show_new_game_screen (Sudoku* self);
static void sudoku_real_activate (GApplication* base);
static void sudoku_real_shutdown (GApplication* base);
static void sudoku_paused_changed_cb (Sudoku* self);
VALA_EXTERN void sudoku_window_display_pause_button (SudokuWindow* self);
VALA_EXTERN gboolean sudoku_window_get_show_timer (SudokuWindow* self);
VALA_EXTERN void sudoku_window_set_show_timer (SudokuWindow* self,
                                   gboolean value);
static GVariant* _variant_new2 (gboolean value);
static void sudoku_start_custom_game (Sudoku* self,
                               SudokuBoard* board);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ____lambda20_ (Block1Data* _data1_);
static void _____lambda20__adw_message_dialog_response (AdwMessageDialog* _sender,
                                                 const gchar* response,
                                                 gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ____lambda21_ (Block2Data* _data2_);
static void _____lambda21__adw_message_dialog_response (AdwMessageDialog* _sender,
                                                 const gchar* response,
                                                 gpointer self);
VALA_EXTERN gboolean sudoku_window_is_board_visible (SudokuWindow* self);
static void sudoku_cell_modified_cb (Sudoku* self);
static void sudoku_board_completed_cb (Sudoku* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN void sudoku_window_board_completed (SudokuWindow* self);
static void __lambda17_ (Block3Data* _data3_,
                  const gchar* response_id);
static void ___lambda17__adw_message_dialog_response (AdwMessageDialog* _sender,
                                               const gchar* response,
                                               gpointer self);
static void _sudoku_paused_changed_cb_sudoku_game_paused_changed (SudokuGame* _sender,
                                                           gpointer self);
static void _sudoku_cell_modified_cb_sudoku_board_cell_changed (SudokuBoard* _sender,
                                                         gint row,
                                                         gint col,
                                                         gint old_val,
                                                         gint new_val,
                                                         gpointer self);
static void _sudoku_cell_modified_cb_sudoku_board_earmark_changed (SudokuBoard* _sender,
                                                            gint row,
                                                            gint col,
                                                            gint num,
                                                            gboolean enabled,
                                                            gpointer self);
VALA_EXTERN void sudoku_window_start_game (SudokuWindow* self,
                               SudokuGame* game);
static void _sudoku_board_completed_cb_sudoku_board_completed (SudokuBoard* _sender,
                                                        gpointer self);
VALA_EXTERN void sudoku_window_show_new_game_screen (SudokuWindow* self);
VALA_EXTERN void sudoku_window_activate_difficulty_checkbutton (SudokuWindow* self,
                                                    DifficultyCategory difficulty);
static void __lambda18_ (Sudoku* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda18__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN void sudoku_window_will_start_game (SudokuWindow* self);
static void __lambda16_ (Sudoku* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda16__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda19_ (Block4Data* _data4_,
                  const gchar* response_id);
VALA_EXTERN void sudoku_view_clear (SudokuView* self);
static void ___lambda19__adw_message_dialog_response (AdwMessageDialog* _sender,
                                               const gchar* response,
                                               gpointer self);
VALA_EXTERN void sudoku_window_show_game_view (SudokuWindow* self);
VALA_EXTERN GType sudoku_printer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuPrinter, g_object_unref)
VALA_EXTERN SudokuPrinter* sudoku_printer_new (GeeList* boards,
                                   gint sudokus_per_page,
                                   GtkWindow* window);
VALA_EXTERN SudokuPrinter* sudoku_printer_construct (GType object_type,
                                         GeeList* boards,
                                         gint sudokus_per_page,
                                         GtkWindow* window);
VALA_EXTERN GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
VALA_EXTERN GType print_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PrintDialog, g_object_unref)
VALA_EXTERN PrintDialog* print_dialog_new (SudokuSaver* saver,
                               GtkWindow* window);
VALA_EXTERN PrintDialog* print_dialog_construct (GType object_type,
                                     SudokuSaver* saver,
                                     GtkWindow* window);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static gint sudoku_main (gchar** args,
                  gint args_length1);
VALA_EXTERN SudokuView* sudoku_window_get_view (SudokuWindow* self);
static void sudoku_finalize (GObject * obj);
static GType sudoku_get_type_once (void);
static void _vala_sudoku_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry SUDOKU_action_entries[16] = {{"new-game", _sudoku_new_game_cb_gsimple_action_activate_callback}, {"start-game", _sudoku_start_game_cb_gsimple_action_activate_callback, "i"}, {"create-game", _sudoku_create_game_cb_gsimple_action_activate_callback}, {"reset", _sudoku_reset_cb_gsimple_action_activate_callback}, {"back", _sudoku_back_cb_gsimple_action_activate_callback}, {"undo", _sudoku_undo_cb_gsimple_action_activate_callback}, {"redo", _sudoku_redo_cb_gsimple_action_activate_callback}, {"print", _sudoku_print_cb_gsimple_action_activate_callback}, {"play-custom-game", _sudoku_play_custom_game_cb_gsimple_action_activate_callback}, {"pause", _sudoku_toggle_pause_cb_gsimple_action_activate_callback}, {"print-multiple", _sudoku_print_multiple_cb_gsimple_action_activate_callback}, {"help", _sudoku_help_cb_gsimple_action_activate_callback}, {"about", _sudoku_about_cb_gsimple_action_activate_callback}, {"fullscreen", _sudoku_fullscreen_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}, {"show-timer", _sudoku_show_timer_cb_gsimple_action_activate_callback, NULL, "true"}};
static const GOptionEntry SUDOKU_option_entries[3] = {{"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {"show-possible-values", 's', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Show the possible values for each cell"), NULL}, {NULL}};
static const gchar* SUDOKU_authors[7] = {"Robert Ancell <robert.ancell@gmail.com>", "Christopher Baines <cbaines8@gmail.com>", "Thomas M. Hinkle <Thomas_Hinkle@alumni.brown.edu>", "Parin Porecha <parinporecha@gmail.com>", "John Stowers <john.stowers@gmail.com>", "Jamie Murphy <jmurphy@gnome.org>", NULL};

static inline gpointer
sudoku_get_instance_private (Sudoku* self)
{
	return G_STRUCT_MEMBER_P (self, Sudoku_private_offset);
}

static void
_sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	sudoku_new_game_cb ((Sudoku*) self);
}

static void
_sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	sudoku_start_game_cb ((Sudoku*) self, action, parameter);
}

static void
_sudoku_create_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self)
{
	sudoku_create_game_cb ((Sudoku*) self);
}

static void
_sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
	sudoku_reset_cb ((Sudoku*) self);
}

static void
_sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                  GVariant* parameter,
                                                  gpointer self)
{
	sudoku_back_cb ((Sudoku*) self);
}

static void
_sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                  GVariant* parameter,
                                                  gpointer self)
{
	sudoku_undo_cb ((Sudoku*) self);
}

static void
_sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                  GVariant* parameter,
                                                  gpointer self)
{
	sudoku_redo_cb ((Sudoku*) self);
}

static void
_sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
	sudoku_print_cb ((Sudoku*) self);
}

static void
_sudoku_play_custom_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	sudoku_play_custom_game_cb ((Sudoku*) self);
}

static void
_sudoku_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	sudoku_toggle_pause_cb ((Sudoku*) self);
}

static void
_sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	sudoku_print_multiple_cb ((Sudoku*) self);
}

static void
_sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                  GVariant* parameter,
                                                  gpointer self)
{
	sudoku_help_cb ((Sudoku*) self);
}

static void
_sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
	sudoku_about_cb ((Sudoku*) self);
}

static void
_sudoku_fullscreen_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	sudoku_fullscreen_cb ((Sudoku*) self);
}

static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	g_application_quit ((GApplication*) self);
}

static void
_sudoku_show_timer_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	sudoku_show_timer_cb ((Sudoku*) self);
}

Sudoku*
sudoku_construct (GType object_type)
{
	Sudoku * self = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	self = (Sudoku*) g_object_new (object_type, "application-id", "org.gnome.Sudoku", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, SUDOKU_option_entries);
	g_type_ensure (TYPE_SUDOKU_MAIN_MENU_ITEM);
	return self;
}

Sudoku*
sudoku_new (void)
{
	return sudoku_construct (TYPE_SUDOKU);
}

static gint
sudoku_real_handle_local_options (GApplication* base,
                                  GVariantDict* options)
{
	Sudoku * self;
	gint result;
	self = (Sudoku*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "gnome-sudoku %s\n", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	result = -1;
	return result;
}

static void
__lambda27_ (Sudoku* self)
{
	gboolean _tmp0_ = FALSE;
	SudokuView* _tmp1_;
	SudokuView* _tmp2_;
	_tmp1_ = sudoku_get_view (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		_tmp0_ = self->priv->current_game_mode == GAME_MODE_PLAY;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SudokuView* _tmp3_;
		SudokuView* _tmp4_;
		GSettings* _tmp5_;
		_tmp3_ = sudoku_get_view (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->settings;
		sudoku_view_set_show_warnings (_tmp4_, g_settings_get_boolean (_tmp5_, "show-warnings"));
	}
}

static void
___lambda27__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda27_ ((Sudoku*) self);
}

static void
__lambda28_ (Sudoku* self)
{
	gboolean _tmp0_ = FALSE;
	SudokuView* _tmp1_;
	SudokuView* _tmp2_;
	_tmp1_ = sudoku_get_view (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		_tmp0_ = self->priv->current_game_mode == GAME_MODE_PLAY;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SudokuView* _tmp3_;
		SudokuView* _tmp4_;
		GSettings* _tmp5_;
		_tmp3_ = sudoku_get_view (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->settings;
		sudoku_view_set_show_extra_warnings (_tmp4_, g_settings_get_boolean (_tmp5_, "show-extra-warnings"));
	}
}

static void
___lambda28__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda28_ ((Sudoku*) self);
}

static void
__lambda29_ (Sudoku* self)
{
	gboolean _tmp0_ = FALSE;
	SudokuView* _tmp1_;
	SudokuView* _tmp2_;
	_tmp1_ = sudoku_get_view (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		_tmp0_ = self->priv->current_game_mode == GAME_MODE_PLAY;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SudokuView* _tmp3_;
		SudokuView* _tmp4_;
		GSettings* _tmp5_;
		_tmp3_ = sudoku_get_view (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->settings;
		sudoku_view_set_show_possibilities (_tmp4_, g_settings_get_boolean (_tmp5_, "show-possibilities"));
	}
}

static void
___lambda29__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda29_ ((Sudoku*) self);
}

static void
__lambda30_ (Sudoku* self)
{
	SudokuView* _tmp0_;
	SudokuView* _tmp1_;
	_tmp0_ = sudoku_get_view (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		SudokuView* _tmp2_;
		SudokuView* _tmp3_;
		GSettings* _tmp4_;
		_tmp2_ = sudoku_get_view (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->settings;
		sudoku_view_set_highlighter (_tmp3_, g_settings_get_boolean (_tmp4_, "highlighter"));
	}
}

static void
___lambda30__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda30_ ((Sudoku*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GVariant*
_variant_new1 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
sudoku_real_startup (GApplication* base)
{
	Sudoku * self;
	GSettings* _tmp0_;
	GAction* action = NULL;
	GSettings* _tmp1_;
	GAction* _tmp2_;
	GAction* _tmp3_;
	GAction* _tmp4_;
	GSettings* _tmp5_;
	GAction* _tmp6_;
	GAction* _tmp7_;
	GAction* _tmp8_;
	GSettings* _tmp9_;
	GAction* _tmp10_;
	GAction* _tmp11_;
	GAction* _tmp12_;
	GSettings* _tmp13_;
	GAction* _tmp14_;
	GAction* _tmp15_;
	GAction* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar** _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	gchar* _tmp40_;
	gchar** _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar** _tmp45_;
	gchar** _tmp46_;
	gint _tmp46__length1;
	gchar* _tmp47_;
	gchar** _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	gchar* _tmp50_;
	gchar** _tmp51_;
	gchar** _tmp52_;
	gint _tmp52__length1;
	GAction* _tmp53_;
	GSimpleAction* _tmp54_;
	GAction* _tmp55_;
	GSimpleAction* _tmp56_;
	GAction* _tmp57_;
	GSimpleAction* _tmp58_;
	GAction* _tmp59_;
	GSimpleAction* _tmp60_;
	GAction* _tmp61_;
	GSimpleAction* _tmp62_;
	GAction* _tmp63_;
	GSimpleAction* _tmp64_;
	GAction* _tmp65_;
	GSimpleAction* _tmp66_;
	GAction* _tmp67_;
	GSimpleAction* _tmp68_;
	GAction* _tmp69_;
	GSimpleAction* _tmp70_;
	GSimpleAction* _tmp71_;
	GSettings* _tmp72_;
	GVariant* _tmp73_;
	GSettings* _tmp74_;
	GSettings* _tmp75_;
	SudokuWindow* _tmp76_;
	SudokuWindow* _tmp77_;
	SudokuSaver* _tmp78_;
	SudokuGame* savegame = NULL;
	SudokuSaver* _tmp79_;
	SudokuGame* _tmp80_;
	SudokuGame* _tmp81_;
	self = (Sudoku*) base;
	G_APPLICATION_CLASS (sudoku_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	g_action_map_add_action_entries ((GActionMap*) self, SUDOKU_action_entries, (gint) G_N_ELEMENTS (SUDOKU_action_entries), self);
	_tmp0_ = g_settings_new ("org.gnome.Sudoku");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_create_action (_tmp1_, "show-warnings");
	action = _tmp2_;
	_tmp3_ = action;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::state", (GCallback) ___lambda27__g_object_notify, self, 0);
	_tmp4_ = action;
	g_action_map_add_action ((GActionMap*) self, _tmp4_);
	_tmp5_ = self->priv->settings;
	_tmp6_ = g_settings_create_action (_tmp5_, "show-extra-warnings");
	_g_object_unref0 (action);
	action = _tmp6_;
	_tmp7_ = action;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::state", (GCallback) ___lambda28__g_object_notify, self, 0);
	_tmp8_ = action;
	g_action_map_add_action ((GActionMap*) self, _tmp8_);
	_tmp9_ = self->priv->settings;
	_tmp10_ = g_settings_create_action (_tmp9_, "show-possibilities");
	_g_object_unref0 (action);
	action = _tmp10_;
	_tmp11_ = action;
	g_signal_connect_object ((GObject*) _tmp11_, "notify::state", (GCallback) ___lambda29__g_object_notify, self, 0);
	_tmp12_ = action;
	g_action_map_add_action ((GActionMap*) self, _tmp12_);
	_tmp13_ = self->priv->settings;
	_tmp14_ = g_settings_create_action (_tmp13_, "highlighter");
	_g_object_unref0 (action);
	action = _tmp14_;
	_tmp15_ = action;
	g_signal_connect_object ((GObject*) _tmp15_, "notify::state", (GCallback) ___lambda30__g_object_notify, self, 0);
	_tmp16_ = action;
	g_action_map_add_action ((GActionMap*) self, _tmp16_);
	_tmp17_ = g_strdup ("<Primary>n");
	_tmp18_ = g_new0 (gchar*, 1 + 1);
	_tmp18_[0] = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp19_);
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	_tmp20_ = g_strdup ("<Primary>p");
	_tmp21_ = g_new0 (gchar*, 1 + 1);
	_tmp21_[0] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.print", _tmp22_);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_tmp23_ = g_strdup ("p");
	_tmp24_ = g_new0 (gchar*, 1 + 1);
	_tmp24_[0] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.pause", _tmp25_);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	_tmp26_ = g_strdup ("<Primary>q");
	_tmp27_ = g_new0 (gchar*, 1 + 1);
	_tmp27_[0] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp28_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp29_ = g_strdup ("<Primary>r");
	_tmp30_ = g_new0 (gchar*, 1 + 1);
	_tmp30_[0] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.reset", _tmp31_);
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	_tmp32_ = g_strdup ("<Primary>z");
	_tmp33_ = g_strdup ("u");
	_tmp34_ = g_new0 (gchar*, 2 + 1);
	_tmp34_[0] = _tmp32_;
	_tmp34_[1] = _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp35__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp35_);
	_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
	_tmp36_ = g_strdup ("<Primary><Shift>z");
	_tmp37_ = g_strdup ("r");
	_tmp38_ = g_new0 (gchar*, 2 + 1);
	_tmp38_[0] = _tmp36_;
	_tmp38_[1] = _tmp37_;
	_tmp39_ = _tmp38_;
	_tmp39__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp39_);
	_tmp39_ = (_vala_array_free (_tmp39_, _tmp39__length1, (GDestroyNotify) g_free), NULL);
	_tmp40_ = g_strdup ("F1");
	_tmp41_ = g_new0 (gchar*, 1 + 1);
	_tmp41_[0] = _tmp40_;
	_tmp42_ = _tmp41_;
	_tmp42__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp42_);
	_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
	_tmp43_ = g_strdup ("F11");
	_tmp44_ = g_strdup ("f");
	_tmp45_ = g_new0 (gchar*, 2 + 1);
	_tmp45_[0] = _tmp43_;
	_tmp45_[1] = _tmp44_;
	_tmp46_ = _tmp45_;
	_tmp46__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.fullscreen", _tmp46_);
	_tmp46_ = (_vala_array_free (_tmp46_, _tmp46__length1, (GDestroyNotify) g_free), NULL);
	_tmp47_ = g_strdup ("<Primary>h");
	_tmp48_ = g_new0 (gchar*, 1 + 1);
	_tmp48_[0] = _tmp47_;
	_tmp49_ = _tmp48_;
	_tmp49__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.highlighter", _tmp49_);
	_tmp49_ = (_vala_array_free (_tmp49_, _tmp49__length1, (GDestroyNotify) g_free), NULL);
	_tmp50_ = g_strdup ("<Primary>w");
	_tmp51_ = g_new0 (gchar*, 1 + 1);
	_tmp51_[0] = _tmp50_;
	_tmp52_ = _tmp51_;
	_tmp52__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.show-warnings", _tmp52_);
	_tmp52_ = (_vala_array_free (_tmp52_, _tmp52__length1, (GDestroyNotify) g_free), NULL);
	_tmp53_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp54_;
	_tmp55_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
	_tmp56_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->redo_action);
	self->priv->redo_action = _tmp56_;
	_tmp57_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
	_tmp58_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->new_game_action);
	self->priv->new_game_action = _tmp58_;
	_tmp59_ = g_action_map_lookup_action ((GActionMap*) self, "reset");
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->clear_action);
	self->priv->clear_action = _tmp60_;
	_tmp61_ = g_action_map_lookup_action ((GActionMap*) self, "print");
	_tmp62_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->print_action);
	self->priv->print_action = _tmp62_;
	_tmp63_ = g_action_map_lookup_action ((GActionMap*) self, "print-multiple");
	_tmp64_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->print_multiple_action);
	self->priv->print_multiple_action = _tmp64_;
	_tmp65_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->pause_action);
	self->priv->pause_action = _tmp66_;
	_tmp67_ = g_action_map_lookup_action ((GActionMap*) self, "play-custom-game");
	_tmp68_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->play_custom_game_action);
	self->priv->play_custom_game_action = _tmp68_;
	_tmp69_ = g_action_map_lookup_action ((GActionMap*) self, "show-timer");
	_tmp70_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->show_timer_action);
	self->priv->show_timer_action = _tmp70_;
	_tmp71_ = self->priv->show_timer_action;
	_tmp72_ = self->priv->settings;
	_tmp73_ = _variant_new1 (g_settings_get_boolean (_tmp72_, "show-timer"));
	g_simple_action_set_state (_tmp71_, _tmp73_);
	_g_variant_unref0 (_tmp73_);
	_tmp74_ = self->priv->settings;
	self->priv->play_difficulty = (DifficultyCategory) g_settings_get_enum (_tmp74_, "play-difficulty");
	gtk_window_set_default_icon_name ("org.gnome.Sudoku");
	_tmp75_ = self->priv->settings;
	_tmp76_ = sudoku_window_new (_tmp75_);
	g_object_ref_sink (_tmp76_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp76_;
	_tmp77_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp77_);
	_tmp78_ = sudoku_saver_new ();
	_g_object_unref0 (self->priv->saver);
	self->priv->saver = _tmp78_;
	_tmp79_ = self->priv->saver;
	_tmp80_ = sudoku_saver_get_savedgame (_tmp79_);
	savegame = _tmp80_;
	_tmp81_ = savegame;
	if (_tmp81_ != NULL) {
		SudokuGame* _tmp82_;
		SudokuBoard* _tmp83_;
		SudokuBoard* _tmp84_;
		DifficultyCategory _tmp85_;
		DifficultyCategory _tmp86_;
		SudokuGame* _tmp93_;
		SudokuBoard* _tmp94_;
		SudokuBoard* _tmp95_;
		_tmp82_ = savegame;
		_tmp83_ = sudoku_game_get_board (_tmp82_);
		_tmp84_ = _tmp83_;
		_tmp85_ = sudoku_board_get_difficulty_category (_tmp84_);
		_tmp86_ = _tmp85_;
		if (_tmp86_ == DIFFICULTY_CATEGORY_CUSTOM) {
			GameMode _tmp87_ = 0;
			SudokuGame* _tmp88_;
			SudokuBoard* _tmp89_;
			SudokuBoard* _tmp90_;
			gint _tmp91_;
			gint _tmp92_;
			_tmp88_ = savegame;
			_tmp89_ = sudoku_game_get_board (_tmp88_);
			_tmp90_ = _tmp89_;
			_tmp91_ = sudoku_board_get_fixed (_tmp90_);
			_tmp92_ = _tmp91_;
			if (_tmp92_ == 0) {
				_tmp87_ = GAME_MODE_CREATE;
			} else {
				_tmp87_ = GAME_MODE_PLAY;
			}
			self->priv->current_game_mode = _tmp87_;
		}
		_tmp93_ = savegame;
		_tmp94_ = sudoku_game_get_board (_tmp93_);
		_tmp95_ = _tmp94_;
		sudoku_start_game (self, _tmp95_);
	} else {
		sudoku_show_new_game_screen (self);
	}
	_g_object_unref0 (savegame);
	_g_object_unref0 (action);
}

static void
sudoku_real_activate (GApplication* base)
{
	Sudoku * self;
	SudokuWindow* _tmp0_;
	self = (Sudoku*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
}

static void
sudoku_real_shutdown (GApplication* base)
{
	Sudoku * self;
	SudokuWindow* _tmp0_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	SudokuGame* _tmp4_;
	GError* _inner_error0_ = NULL;
	self = (Sudoku*) base;
	_tmp0_ = self->priv->window;
	if (_tmp0_ != NULL) {
		SudokuWindow* _tmp1_;
		_tmp1_ = self->priv->window;
		gtk_window_close ((GtkWindow*) _tmp1_);
		_g_object_unref0 (self->priv->window);
		self->priv->window = NULL;
	}
	_tmp2_ = self->priv->settings;
	g_settings_set_enum (_tmp2_, "play-difficulty", (gint) self->priv->play_difficulty);
	_tmp3_ = self->priv->settings;
	g_settings_apply (_tmp3_);
	_tmp4_ = self->priv->game;
	if (_tmp4_ != NULL) {
		SudokuGame* _tmp5_;
		gboolean _tmp6_ = FALSE;
		SudokuGame* _tmp7_;
		gboolean _tmp15_ = FALSE;
		SudokuGame* _tmp16_;
		_tmp5_ = self->priv->game;
		sudoku_game_stop_clock (_tmp5_);
		_tmp7_ = self->priv->game;
		if (!sudoku_game_is_empty (_tmp7_)) {
			SudokuGame* _tmp8_;
			SudokuBoard* _tmp9_;
			SudokuBoard* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp8_ = self->priv->game;
			_tmp9_ = sudoku_game_get_board (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = sudoku_board_get_complete (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp6_ = !_tmp12_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			SudokuSaver* _tmp13_;
			SudokuGame* _tmp14_;
			_tmp13_ = self->priv->saver;
			_tmp14_ = self->priv->game;
			sudoku_saver_save_game (_tmp13_, _tmp14_);
		}
		_tmp16_ = self->priv->game;
		if (sudoku_game_is_empty (_tmp16_)) {
			SudokuSaver* _tmp17_;
			SudokuGame* _tmp18_;
			SudokuGame* _tmp19_;
			_tmp17_ = self->priv->saver;
			_tmp18_ = sudoku_saver_get_savedgame (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp15_ = _tmp19_ != NULL;
			_g_object_unref0 (_tmp19_);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			GFile* file = NULL;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			GFile* _tmp22_;
			_tmp20_ = sudoku_saver_get_savegame_file ();
			_tmp21_ = _tmp20_;
			_tmp22_ = g_file_new_for_path (_tmp21_);
			file = _tmp22_;
			{
				GFile* _tmp23_;
				_tmp23_ = file;
				g_file_delete (_tmp23_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp24_;
				const gchar* _tmp25_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp24_ = e;
				_tmp25_ = _tmp24_->message;
				g_warning ("gnome-sudoku.vala:228: Failed to delete saved game: %s", _tmp25_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (file);
		}
	}
	G_APPLICATION_CLASS (sudoku_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
}

static void
sudoku_paused_changed_cb (Sudoku* self)
{
	SudokuGame* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	SudokuWindow* _tmp15_;
	SudokuView* _tmp16_;
	SudokuView* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GSimpleAction* _tmp3_;
		GSimpleAction* _tmp4_;
		GSimpleAction* _tmp5_;
		GSimpleAction* _tmp6_;
		_tmp3_ = self->priv->clear_action;
		g_simple_action_set_enabled (_tmp3_, FALSE);
		_tmp4_ = self->priv->undo_action;
		g_simple_action_set_enabled (_tmp4_, FALSE);
		_tmp5_ = self->priv->redo_action;
		g_simple_action_set_enabled (_tmp5_, FALSE);
		_tmp6_ = self->priv->new_game_action;
		g_simple_action_set_enabled (_tmp6_, FALSE);
	} else {
		SudokuGame* _tmp7_;
		_tmp7_ = self->priv->game;
		if (sudoku_game_get_total_time_played (_tmp7_) > ((gdouble) 0)) {
			GSimpleAction* _tmp8_;
			SudokuGame* _tmp9_;
			GSimpleAction* _tmp10_;
			SudokuGame* _tmp11_;
			GSimpleAction* _tmp12_;
			SudokuGame* _tmp13_;
			GSimpleAction* _tmp14_;
			_tmp8_ = self->priv->clear_action;
			_tmp9_ = self->priv->game;
			g_simple_action_set_enabled (_tmp8_, !sudoku_game_is_empty (_tmp9_));
			_tmp10_ = self->priv->undo_action;
			_tmp11_ = self->priv->game;
			g_simple_action_set_enabled (_tmp10_, !sudoku_game_is_undostack_null (_tmp11_));
			_tmp12_ = self->priv->redo_action;
			_tmp13_ = self->priv->game;
			g_simple_action_set_enabled (_tmp12_, !sudoku_game_is_redostack_null (_tmp13_));
			_tmp14_ = self->priv->new_game_action;
			g_simple_action_set_enabled (_tmp14_, TRUE);
		}
	}
	_tmp15_ = self->priv->window;
	sudoku_window_display_pause_button (_tmp15_);
	_tmp16_ = sudoku_get_view (self);
	_tmp17_ = _tmp16_;
	gtk_widget_queue_draw ((GtkWidget*) _tmp17_);
}

static GVariant*
_variant_new2 (gboolean value)
{
	return g_variant_ref_sink (g_variant_new_boolean (value));
}

static void
sudoku_show_timer_cb (Sudoku* self)
{
	SudokuWindow* _tmp0_;
	SudokuWindow* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GSimpleAction* _tmp4_;
	SudokuWindow* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GVariant* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = self->priv->window;
	_tmp2_ = sudoku_window_get_show_timer (_tmp1_);
	_tmp3_ = _tmp2_;
	sudoku_window_set_show_timer (_tmp0_, !_tmp3_);
	_tmp4_ = self->priv->show_timer_action;
	_tmp5_ = self->priv->window;
	_tmp6_ = sudoku_window_get_show_timer (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _variant_new2 (_tmp7_);
	g_simple_action_set_state (_tmp4_, _tmp8_);
	_g_variant_unref0 (_tmp8_);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Sudoku* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
____lambda20_ (Block1Data* _data1_)
{
	Sudoku* self;
	AdwMessageDialog* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->dialog;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
}

static void
_____lambda20__adw_message_dialog_response (AdwMessageDialog* _sender,
                                            const gchar* response,
                                            gpointer self)
{
	____lambda20_ (self);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		Sudoku* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
____lambda21_ (Block2Data* _data2_)
{
	Sudoku* self;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	SudokuBoard* _tmp2_;
	AdwMessageDialog* _tmp3_;
	self = _data2_->self;
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_board (_tmp0_);
	_tmp2_ = _tmp1_;
	sudoku_start_custom_game (self, _tmp2_);
	_tmp3_ = _data2_->dialog;
	gtk_window_destroy ((GtkWindow*) _tmp3_);
}

static void
_____lambda21__adw_message_dialog_response (AdwMessageDialog* _sender,
                                            const gchar* response,
                                            gpointer self)
{
	____lambda21_ (self);
}

static void
sudoku_play_custom_game_cb (Sudoku* self)
{
	gint solutions = 0;
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	SudokuBoard* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_board (_tmp0_);
	_tmp2_ = _tmp1_;
	solutions = sudoku_board_count_solutions_limited (_tmp2_);
	if (solutions == 1) {
		SudokuGame* _tmp3_;
		SudokuBoard* _tmp4_;
		SudokuBoard* _tmp5_;
		_tmp3_ = self->priv->game;
		_tmp4_ = sudoku_game_get_board (_tmp3_);
		_tmp5_ = _tmp4_;
		sudoku_start_custom_game (self, _tmp5_);
	} else {
		if (solutions == 0) {
			Block1Data* _data1_;
			SudokuWindow* _tmp6_;
			AdwMessageDialog* _tmp7_;
			AdwMessageDialog* _tmp8_;
			AdwMessageDialog* _tmp9_;
			AdwMessageDialog* _tmp10_;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_tmp6_ = self->priv->window;
			_tmp7_ = (AdwMessageDialog*) adw_message_dialog_new ((GtkWindow*) _tmp6_, _ ("The puzzle you have entered is not a valid Sudoku."), _ ("Please enter a valid puzzle."));
			g_object_ref_sink (_tmp7_);
			_data1_->dialog = _tmp7_;
			_tmp8_ = _data1_->dialog;
			adw_message_dialog_add_response (_tmp8_, "close", _ ("Close"));
			_tmp9_ = _data1_->dialog;
			g_signal_connect_data (_tmp9_, "response", (GCallback) _____lambda20__adw_message_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
			_tmp10_ = _data1_->dialog;
			gtk_widget_show ((GtkWidget*) _tmp10_);
			block1_data_unref (_data1_);
			_data1_ = NULL;
		} else {
			Block2Data* _data2_;
			SudokuWindow* _tmp11_;
			AdwMessageDialog* _tmp12_;
			AdwMessageDialog* _tmp13_;
			AdwMessageDialog* _tmp14_;
			AdwMessageDialog* _tmp15_;
			AdwMessageDialog* _tmp16_;
			AdwMessageDialog* _tmp17_;
			_data2_ = g_slice_new0 (Block2Data);
			_data2_->_ref_count_ = 1;
			_data2_->self = g_object_ref (self);
			_tmp11_ = self->priv->window;
			_tmp12_ = (AdwMessageDialog*) adw_message_dialog_new ((GtkWindow*) _tmp11_, _ ("The puzzle you have entered has multiple solutions."), _ ("Valid Sudoku puzzles have exactly one solution."));
			g_object_ref_sink (_tmp12_);
			_data2_->dialog = _tmp12_;
			_tmp13_ = _data2_->dialog;
			adw_message_dialog_add_response (_tmp13_, "close", _ ("_Back"));
			_tmp14_ = _data2_->dialog;
			adw_message_dialog_add_response (_tmp14_, "continue", _ ("Play _Anyway"));
			_tmp15_ = _data2_->dialog;
			adw_message_dialog_set_response_appearance (_tmp15_, "continue", ADW_RESPONSE_DESTRUCTIVE);
			_tmp16_ = _data2_->dialog;
			g_signal_connect_data (_tmp16_, "response::continue", (GCallback) _____lambda21__adw_message_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
			_tmp17_ = _data2_->dialog;
			gtk_widget_show ((GtkWidget*) _tmp17_);
			block2_data_unref (_data2_);
			_data2_ = NULL;
		}
	}
}

static void
sudoku_toggle_pause_cb (Sudoku* self)
{
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	if (_tmp1_ != NULL) {
		SudokuWindow* _tmp2_;
		_tmp2_ = self->priv->window;
		_tmp0_ = sudoku_window_is_board_visible (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		SudokuGame* _tmp3_;
		SudokuGame* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		SudokuGame* _tmp7_;
		gboolean _tmp8_;
		gboolean _tmp9_;
		GSimpleAction* _tmp12_;
		SudokuGame* _tmp13_;
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp3_ = self->priv->game;
		_tmp4_ = self->priv->game;
		_tmp5_ = sudoku_game_get_paused (_tmp4_);
		_tmp6_ = _tmp5_;
		sudoku_game_set_paused (_tmp3_, !_tmp6_);
		_tmp7_ = self->priv->game;
		_tmp8_ = sudoku_game_get_paused (_tmp7_);
		_tmp9_ = _tmp8_;
		if (!_tmp9_) {
			SudokuGame* _tmp10_;
			_tmp10_ = self->priv->game;
			sudoku_game_resume_clock (_tmp10_);
		} else {
			SudokuGame* _tmp11_;
			_tmp11_ = self->priv->game;
			sudoku_game_stop_clock (_tmp11_);
		}
		_tmp12_ = self->priv->show_timer_action;
		_tmp13_ = self->priv->game;
		_tmp14_ = sudoku_game_get_paused (_tmp13_);
		_tmp15_ = _tmp14_;
		g_simple_action_set_enabled (_tmp12_, !_tmp15_);
	}
}

static void
sudoku_cell_modified_cb (Sudoku* self)
{
	GSimpleAction* _tmp0_;
	SudokuGame* _tmp1_;
	GSimpleAction* _tmp2_;
	SudokuGame* _tmp3_;
	GSimpleAction* _tmp4_;
	SudokuGame* _tmp5_;
	gboolean _tmp6_ = FALSE;
	SudokuGame* _tmp7_;
	GSimpleAction* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_action;
	_tmp1_ = self->priv->game;
	g_simple_action_set_enabled (_tmp0_, !sudoku_game_is_undostack_null (_tmp1_));
	_tmp2_ = self->priv->redo_action;
	_tmp3_ = self->priv->game;
	g_simple_action_set_enabled (_tmp2_, !sudoku_game_is_redostack_null (_tmp3_));
	_tmp4_ = self->priv->clear_action;
	_tmp5_ = self->priv->game;
	g_simple_action_set_enabled (_tmp4_, !sudoku_game_is_empty (_tmp5_));
	_tmp7_ = self->priv->game;
	if (!sudoku_game_is_empty (_tmp7_)) {
		SudokuGame* _tmp8_;
		SudokuBoard* _tmp9_;
		SudokuBoard* _tmp10_;
		_tmp8_ = self->priv->game;
		_tmp9_ = sudoku_game_get_board (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp6_ = !sudoku_board_is_fully_filled (_tmp10_);
	} else {
		_tmp6_ = FALSE;
	}
	_tmp11_ = self->priv->play_custom_game_action;
	g_simple_action_set_enabled (_tmp11_, _tmp6_);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		Sudoku* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda17_ (Block3Data* _data3_,
             const gchar* response_id)
{
	Sudoku* self;
	self = _data3_->self;
	g_return_if_fail (response_id != NULL);
	if (g_strcmp0 (response_id, "play-again") == 0) {
		sudoku_show_new_game_screen (self);
	} else {
		if (g_strcmp0 (response_id, "close") == 0) {
			g_application_quit ((GApplication*) self);
		}
	}
	gtk_window_destroy ((GtkWindow*) _data3_->dialog);
}

static void
___lambda17__adw_message_dialog_response (AdwMessageDialog* _sender,
                                          const gchar* response,
                                          gpointer self)
{
	__lambda17_ (self, response);
}

static void
sudoku_board_completed_cb (Sudoku* self)
{
	Block3Data* _data3_;
	SudokuWindow* _tmp0_;
	SudokuGame* _tmp1_;
	SudokuView* _tmp2_;
	SudokuView* _tmp3_;
	SudokuSaver* _tmp4_;
	SudokuGame* _tmp5_;
	gchar* win_str = NULL;
	SudokuWindow* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	SudokuWindow* _tmp12_;
	const gchar* _tmp13_;
	AdwMessageDialog* _tmp14_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->window;
	sudoku_window_board_completed (_tmp0_);
	_tmp1_ = self->priv->game;
	sudoku_game_stop_clock (_tmp1_);
	_tmp2_ = sudoku_get_view (self);
	_tmp3_ = _tmp2_;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp3_, FALSE);
	_tmp4_ = self->priv->saver;
	_tmp5_ = self->priv->game;
	sudoku_saver_add_game_to_finished (_tmp4_, _tmp5_, TRUE);
	_tmp6_ = self->priv->window;
	_tmp7_ = sudoku_window_get_show_timer (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		gint minutes = 0;
		SudokuGame* _tmp9_;
		gchar* _tmp10_;
		_tmp9_ = self->priv->game;
		minutes = MAX (1, ((gint) sudoku_game_get_total_time_played (_tmp9_)) / 60);
		_tmp10_ = g_strdup_printf (ngettext ("Well done, you completed the puzzle in %d minute!", "Well done, you completed the puzzle in %d minutes!", (gulong) minutes), minutes);
		_g_free0 (win_str);
		win_str = _tmp10_;
	} else {
		gchar* _tmp11_;
		_tmp11_ = g_strdup (gettext ("Well done, you completed the puzzle!"));
		_g_free0 (win_str);
		win_str = _tmp11_;
	}
	_tmp12_ = self->priv->window;
	_tmp13_ = win_str;
	_tmp14_ = (AdwMessageDialog*) adw_message_dialog_new ((GtkWindow*) _tmp12_, _tmp13_, NULL);
	g_object_ref_sink (_tmp14_);
	_data3_->dialog = _tmp14_;
	adw_message_dialog_add_response (_data3_->dialog, "close", _ ("Quit"));
	adw_message_dialog_add_response (_data3_->dialog, "play-again", _ ("Play _Again"));
	adw_message_dialog_set_response_appearance (_data3_->dialog, "play-again", ADW_RESPONSE_SUGGESTED);
	g_signal_connect_data (_data3_->dialog, "response", (GCallback) ___lambda17__adw_message_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data3_->dialog);
	_g_free0 (win_str);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
sudoku_start_custom_game (Sudoku* self,
                          SudokuBoard* board)
{
	SudokuGame* _tmp0_;
	SudokuBoard* _tmp1_;
	SudokuBoard* _tmp2_;
	SudokuGame* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (board != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = sudoku_game_get_board (_tmp0_);
	_tmp2_ = _tmp1_;
	sudoku_board_set_all_is_fixed (_tmp2_);
	self->priv->current_game_mode = GAME_MODE_PLAY;
	_tmp3_ = self->priv->game;
	sudoku_game_stop_clock (_tmp3_);
	sudoku_start_game (self, board);
}

static void
_sudoku_paused_changed_cb_sudoku_game_paused_changed (SudokuGame* _sender,
                                                      gpointer self)
{
	sudoku_paused_changed_cb ((Sudoku*) self);
}

static void
_sudoku_cell_modified_cb_sudoku_board_cell_changed (SudokuBoard* _sender,
                                                    gint row,
                                                    gint col,
                                                    gint old_val,
                                                    gint new_val,
                                                    gpointer self)
{
	sudoku_cell_modified_cb ((Sudoku*) self);
}

static void
_sudoku_cell_modified_cb_sudoku_board_earmark_changed (SudokuBoard* _sender,
                                                       gint row,
                                                       gint col,
                                                       gint num,
                                                       gboolean enabled,
                                                       gpointer self)
{
	sudoku_cell_modified_cb ((Sudoku*) self);
}

static void
_sudoku_board_completed_cb_sudoku_board_completed (SudokuBoard* _sender,
                                                   gpointer self)
{
	sudoku_board_completed_cb ((Sudoku*) self);
}

static void
sudoku_start_game (Sudoku* self,
                   SudokuBoard* board)
{
	SudokuGame* _tmp0_;
	SudokuGame* _tmp1_;
	SudokuGame* _tmp2_;
	SudokuGame* _tmp3_;
	SudokuBoard* _tmp4_;
	SudokuBoard* _tmp5_;
	SudokuGame* _tmp6_;
	SudokuBoard* _tmp7_;
	SudokuBoard* _tmp8_;
	SudokuWindow* _tmp9_;
	SudokuGame* _tmp10_;
	GSimpleAction* _tmp11_;
	GSimpleAction* _tmp12_;
	GSimpleAction* _tmp13_;
	GSimpleAction* _tmp14_;
	GSimpleAction* _tmp15_;
	SudokuGame* _tmp16_;
	GSimpleAction* _tmp17_;
	SudokuGame* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (board != NULL);
	if (self->priv->current_game_mode == GAME_MODE_PLAY) {
		sudoku_board_solve (board);
	}
	_tmp0_ = sudoku_game_new (board);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp0_;
	_tmp1_ = self->priv->game;
	sudoku_game_set_mode (_tmp1_, self->priv->current_game_mode);
	_tmp2_ = self->priv->game;
	g_signal_connect_object (_tmp2_, "paused-changed", (GCallback) _sudoku_paused_changed_cb_sudoku_game_paused_changed, self, 0);
	_tmp3_ = self->priv->game;
	_tmp4_ = sudoku_game_get_board (_tmp3_);
	_tmp5_ = _tmp4_;
	g_signal_connect_object (_tmp5_, "cell-changed", (GCallback) _sudoku_cell_modified_cb_sudoku_board_cell_changed, self, 0);
	_tmp6_ = self->priv->game;
	_tmp7_ = sudoku_game_get_board (_tmp6_);
	_tmp8_ = _tmp7_;
	g_signal_connect_object (_tmp8_, "earmark-changed", (GCallback) _sudoku_cell_modified_cb_sudoku_board_earmark_changed, self, 0);
	_tmp9_ = self->priv->window;
	_tmp10_ = self->priv->game;
	sudoku_window_start_game (_tmp9_, _tmp10_);
	_tmp11_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp11_, TRUE);
	_tmp12_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp12_, FALSE);
	_tmp13_ = self->priv->redo_action;
	g_simple_action_set_enabled (_tmp13_, FALSE);
	_tmp14_ = self->priv->new_game_action;
	g_simple_action_set_enabled (_tmp14_, TRUE);
	_tmp15_ = self->priv->clear_action;
	_tmp16_ = self->priv->game;
	g_simple_action_set_enabled (_tmp15_, !sudoku_game_is_empty (_tmp16_));
	_tmp17_ = self->priv->play_custom_game_action;
	_tmp18_ = self->priv->game;
	g_simple_action_set_enabled (_tmp17_, !sudoku_game_is_empty (_tmp18_));
	if (self->priv->current_game_mode != GAME_MODE_CREATE) {
		SudokuGame* _tmp19_;
		SudokuBoard* _tmp20_;
		SudokuBoard* _tmp21_;
		_tmp19_ = self->priv->game;
		_tmp20_ = sudoku_game_get_board (_tmp19_);
		_tmp21_ = _tmp20_;
		g_signal_connect_object (_tmp21_, "completed", (GCallback) _sudoku_board_completed_cb_sudoku_board_completed, self, 0);
	}
}

static void
sudoku_show_new_game_screen (Sudoku* self)
{
	GSimpleAction* _tmp0_;
	SudokuGame* _tmp1_;
	SudokuWindow* _tmp3_;
	SudokuWindow* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->game;
	if (_tmp1_ != NULL) {
		SudokuGame* _tmp2_;
		_tmp2_ = self->priv->game;
		sudoku_game_stop_clock (_tmp2_);
	}
	_tmp3_ = self->priv->window;
	sudoku_window_show_new_game_screen (_tmp3_);
	_tmp4_ = self->priv->window;
	sudoku_window_activate_difficulty_checkbutton (_tmp4_, self->priv->play_difficulty);
}

static void
sudoku_new_game_cb (Sudoku* self)
{
	g_return_if_fail (self != NULL);
	sudoku_show_new_game_screen (self);
}

static void
__lambda18_ (Sudoku* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GeeList* gen_boards = NULL;
		GeeList* _tmp0_;
		gpointer _tmp1_;
		SudokuBoard* _tmp2_;
		_tmp0_ = sudoku_generator_generate_boards_finish (res, &_inner_error0_);
		gen_boards = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = gee_list_get (gen_boards, 0);
		_tmp2_ = (SudokuBoard*) _tmp1_;
		sudoku_start_game (self, _tmp2_);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (gen_boards);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e->message;
		g_error ("gnome-sudoku.vala:416: Error: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda18__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda18_ ((Sudoku*) self, source_object, res);
	g_object_unref (self);
}

static void
sudoku_create_game_cb (Sudoku* self)
{
	g_return_if_fail (self != NULL);
	self->priv->current_game_mode = GAME_MODE_CREATE;
	sudoku_generator_generate_boards_async (1, DIFFICULTY_CATEGORY_CUSTOM, NULL, ___lambda18__gasync_ready_callback, g_object_ref (self));
}

static void
__lambda16_ (Sudoku* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GeeList* gen_boards = NULL;
		GeeList* _tmp0_;
		gpointer _tmp1_;
		SudokuBoard* _tmp2_;
		_tmp0_ = sudoku_generator_generate_boards_finish (res, &_inner_error0_);
		gen_boards = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = gee_list_get (gen_boards, 0);
		_tmp2_ = (SudokuBoard*) _tmp1_;
		sudoku_start_game (self, _tmp2_);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (gen_boards);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e->message;
		g_error ("gnome-sudoku.vala:440: Error: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda16__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda16_ ((Sudoku*) self, source_object, res);
	g_object_unref (self);
}

static void
sudoku_start_game_cb (Sudoku* self,
                      GSimpleAction* action,
                      GVariant* difficulty)
{
	SudokuWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = self->priv->window;
	sudoku_window_will_start_game (_tmp0_);
	self->priv->current_game_mode = GAME_MODE_PLAY;
	self->priv->play_difficulty = (DifficultyCategory) g_variant_get_int32 (difficulty);
	sudoku_generator_generate_boards_async (1, self->priv->play_difficulty, NULL, ___lambda16__gasync_ready_callback, g_object_ref (self));
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		Sudoku* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda19_ (Block4Data* _data4_,
             const gchar* response_id)
{
	Sudoku* self;
	SudokuGame* _tmp0_;
	SudokuView* _tmp1_;
	SudokuView* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* _tmp4_;
	self = _data4_->self;
	g_return_if_fail (response_id != NULL);
	_tmp0_ = self->priv->game;
	sudoku_game_reset (_tmp0_);
	_tmp1_ = sudoku_get_view (self);
	_tmp2_ = _tmp1_;
	sudoku_view_clear (_tmp2_);
	_tmp3_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp3_, FALSE);
	_tmp4_ = self->priv->redo_action;
	g_simple_action_set_enabled (_tmp4_, FALSE);
	gtk_window_destroy ((GtkWindow*) _data4_->dialog);
}

static void
___lambda19__adw_message_dialog_response (AdwMessageDialog* _sender,
                                          const gchar* response,
                                          gpointer self)
{
	__lambda19_ (self, response);
}

static void
sudoku_reset_cb (Sudoku* self)
{
	Block4Data* _data4_;
	SudokuWindow* _tmp0_;
	AdwMessageDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_tmp0_ = self->priv->window;
	_tmp1_ = (AdwMessageDialog*) adw_message_dialog_new ((GtkWindow*) _tmp0_, _ ("Reset the board to its original state?"), NULL);
	g_object_ref_sink (_tmp1_);
	_data4_->dialog = _tmp1_;
	adw_message_dialog_add_response (_data4_->dialog, "close", _ ("No"));
	adw_message_dialog_add_response (_data4_->dialog, "yes", _ ("Yes"));
	adw_message_dialog_set_response_appearance (_data4_->dialog, "yes", ADW_RESPONSE_DESTRUCTIVE);
	g_signal_connect_data (_data4_->dialog, "response::yes", (GCallback) ___lambda19__adw_message_dialog_response, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	gtk_window_present ((GtkWindow*) _data4_->dialog);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
sudoku_back_cb (Sudoku* self)
{
	SudokuWindow* _tmp0_;
	SudokuGame* _tmp1_;
	GameMode _tmp2_;
	GameMode _tmp3_;
	GSimpleAction* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	sudoku_window_show_game_view (_tmp0_);
	_tmp1_ = self->priv->game;
	_tmp2_ = sudoku_game_get_mode (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != GAME_MODE_CREATE) {
		SudokuGame* _tmp4_;
		_tmp4_ = self->priv->game;
		sudoku_game_resume_clock (_tmp4_);
	}
	_tmp5_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp5_, TRUE);
}

static void
sudoku_undo_cb (Sudoku* self)
{
	SudokuWindow* _tmp0_;
	SudokuGame* _tmp1_;
	GSimpleAction* _tmp2_;
	SudokuGame* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (!sudoku_window_is_board_visible (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->game;
	sudoku_game_undo (_tmp1_);
	_tmp2_ = self->priv->undo_action;
	_tmp3_ = self->priv->game;
	g_simple_action_set_enabled (_tmp2_, !sudoku_game_is_undostack_null (_tmp3_));
}

static void
sudoku_redo_cb (Sudoku* self)
{
	SudokuWindow* _tmp0_;
	SudokuGame* _tmp1_;
	GSimpleAction* _tmp2_;
	SudokuGame* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (!sudoku_window_is_board_visible (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->game;
	sudoku_game_redo (_tmp1_);
	_tmp2_ = self->priv->redo_action;
	_tmp3_ = self->priv->game;
	g_simple_action_set_enabled (_tmp2_, !sudoku_game_is_redostack_null (_tmp3_));
}

static void
sudoku_print_cb (Sudoku* self)
{
	SudokuWindow* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	SudokuGame* _tmp5_;
	SudokuBoard* _tmp6_;
	SudokuBoard* _tmp7_;
	SudokuBoard* _tmp8_;
	SudokuBoard* _tmp9_;
	SudokuPrinter* printer = NULL;
	GeeArrayList* _tmp10_;
	SudokuWindow* _tmp11_;
	SudokuPrinter* _tmp12_;
	SudokuPrinter* _tmp13_;
	GSimpleAction* _tmp14_;
	GSimpleAction* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (!sudoku_window_is_board_visible (_tmp0_)) {
		return;
	}
	_tmp1_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp1_, FALSE);
	_tmp2_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp2_, FALSE);
	_tmp3_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	list = _tmp3_;
	_tmp4_ = list;
	_tmp5_ = self->priv->game;
	_tmp6_ = sudoku_game_get_board (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = sudoku_board_clone (_tmp7_);
	_tmp9_ = _tmp8_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = list;
	_tmp11_ = self->priv->window;
	_tmp12_ = sudoku_printer_new ((GeeList*) _tmp10_, 1, (GtkWindow*) _tmp11_);
	printer = _tmp12_;
	_tmp13_ = printer;
	sudoku_printer_print_sudoku (_tmp13_);
	_tmp14_ = self->priv->print_action;
	g_simple_action_set_enabled (_tmp14_, TRUE);
	_tmp15_ = self->priv->print_multiple_action;
	g_simple_action_set_enabled (_tmp15_, TRUE);
	_g_object_unref0 (printer);
	_g_object_unref0 (list);
}

static void
sudoku_print_multiple_cb (Sudoku* self)
{
	PrintDialog* print_dialog = NULL;
	SudokuSaver* _tmp0_;
	SudokuWindow* _tmp1_;
	PrintDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->saver;
	_tmp1_ = self->priv->window;
	_tmp2_ = print_dialog_new (_tmp0_, (GtkWindow*) _tmp1_);
	g_object_ref_sink (_tmp2_);
	print_dialog = _tmp2_;
	gtk_widget_show ((GtkWidget*) print_dialog);
	_g_object_unref0 (print_dialog);
}

static void
sudoku_help_cb (Sudoku* self)
{
	SudokuWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_show_uri ((GtkWindow*) _tmp0_, "help:gnome-sudoku", (guint32) GDK_CURRENT_TIME);
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
sudoku_about_cb (Sudoku* self)
{
	gchar* localized_comments_format = NULL;
	gchar* _tmp0_;
	AdwAboutWindow* about = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* _tmp9_;
	gchar* _tmp10_;
	AdwAboutWindow* _tmp11_ = NULL;
	AdwAboutWindow* _tmp12_;
	SudokuWindow* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("The popular Japanese logic puzzle\n\nPuzzles generated by QQwing %s"));
	localized_comments_format = _tmp0_;
	_tmp1_ = g_strdup (_ ("Sudoku"));
	_tmp2_ = g_strdup ("org.gnome.Sudoku");
	_tmp3_ = g_strdup (VERSION);
	_tmp4_ = sudoku_generator_qqwing_version ();
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf (localized_comments_format, _tmp5_);
	_tmp7_ = g_strdup ("Copyright © 2005–2008 Thomas M. Hinkle\n" \
"Copyright © 2010–2011 Robert Ancell\n" \
"Copyright © 2014 Parin Porecha\n" \
"Copyright © 2023 Jamie Murphy");
	_tmp8_ = _vala_array_dup1 (SUDOKU_authors, G_N_ELEMENTS (SUDOKU_authors));
	_tmp8__length1 = G_N_ELEMENTS (SUDOKU_authors);
	_tmp9_ = g_strdup (_ ("translator-credits"));
	_tmp10_ = g_strdup ("https://wiki.gnome.org/Apps/Sudoku/");
	_tmp11_ = (AdwAboutWindow*) adw_about_window_new ();
	adw_about_window_set_application_name (_tmp11_, _tmp1_);
	_g_free0 (_tmp1_);
	adw_about_window_set_application_icon (_tmp11_, _tmp2_);
	_g_free0 (_tmp2_);
	adw_about_window_set_version (_tmp11_, _tmp3_);
	_g_free0 (_tmp3_);
	adw_about_window_set_comments (_tmp11_, _tmp6_);
	_g_free0 (_tmp6_);
	adw_about_window_set_copyright (_tmp11_, _tmp7_);
	_g_free0 (_tmp7_);
	adw_about_window_set_license_type (_tmp11_, GTK_LICENSE_GPL_3_0);
	adw_about_window_set_developers (_tmp11_, _tmp8_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	adw_about_window_set_translator_credits (_tmp11_, _tmp9_);
	_g_free0 (_tmp9_);
	adw_about_window_set_website (_tmp11_, _tmp10_);
	_g_free0 (_tmp10_);
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp5_);
	about = _tmp12_;
	_tmp13_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) about, (GtkWindow*) _tmp13_);
	gtk_window_present ((GtkWindow*) about);
	_g_object_unref0 (about);
	_g_free0 (localized_comments_format);
}

static void
sudoku_fullscreen_cb (Sudoku* self)
{
	SudokuWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	if (gtk_window_is_fullscreen ((GtkWindow*) _tmp0_)) {
		SudokuWindow* _tmp1_;
		_tmp1_ = self->priv->window;
		gtk_window_unfullscreen ((GtkWindow*) _tmp1_);
	} else {
		SudokuWindow* _tmp2_;
		_tmp2_ = self->priv->window;
		gtk_window_fullscreen ((GtkWindow*) _tmp2_);
	}
}

static gint
sudoku_main (gchar** args,
             gint args_length1)
{
	Sudoku* _tmp0_;
	Sudoku* _tmp1_;
	gint _tmp2_;
	gint result;
	_tmp0_ = sudoku_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return sudoku_main (argv, argc);
}

static SudokuView*
sudoku_get_view (Sudoku* self)
{
	SudokuView* result;
	SudokuWindow* _tmp0_;
	SudokuView* _tmp1_;
	SudokuView* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = sudoku_window_get_view (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
sudoku_class_init (SudokuClass * klass,
                   gpointer klass_data)
{
	sudoku_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Sudoku_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) sudoku_real_handle_local_options;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) sudoku_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) sudoku_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) sudoku_real_shutdown;
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_get_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_finalize;
}

static void
sudoku_instance_init (Sudoku * self,
                      gpointer klass)
{
	self->priv = sudoku_get_instance_private (self);
	self->priv->game = NULL;
	self->priv->current_game_mode = GAME_MODE_PLAY;
}

static void
sudoku_finalize (GObject * obj)
{
	Sudoku * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU, Sudoku);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->saver);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->redo_action);
	_g_object_unref0 (self->priv->clear_action);
	_g_object_unref0 (self->priv->print_action);
	_g_object_unref0 (self->priv->print_multiple_action);
	_g_object_unref0 (self->priv->pause_action);
	_g_object_unref0 (self->priv->play_custom_game_action);
	_g_object_unref0 (self->priv->new_game_action);
	_g_object_unref0 (self->priv->show_timer_action);
	G_OBJECT_CLASS (sudoku_parent_class)->finalize (obj);
}

static GType
sudoku_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sudoku), 0, (GInstanceInitFunc) sudoku_instance_init, NULL };
	GType sudoku_type_id;
	sudoku_type_id = g_type_register_static (adw_application_get_type (), "Sudoku", &g_define_type_info, 0);
	Sudoku_private_offset = g_type_add_instance_private (sudoku_type_id, sizeof (SudokuPrivate));
	return sudoku_type_id;
}

GType
sudoku_get_type (void)
{
	static volatile gsize sudoku_type_id__once = 0;
	if (g_once_init_enter (&sudoku_type_id__once)) {
		GType sudoku_type_id;
		sudoku_type_id = sudoku_get_type_once ();
		g_once_init_leave (&sudoku_type_id__once, sudoku_type_id);
	}
	return sudoku_type_id__once;
}

static void
_vala_sudoku_get_property (GObject * object,
                           guint property_id,
                           GValue * value,
                           GParamSpec * pspec)
{
	Sudoku * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU, Sudoku);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

