/* aspect-frame.c generated by valac 0.56.17, the Vala compiler
 * generated from aspect-frame.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2023 Jamie Murphy <jmurphy@gnome.org>
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <gsk/gsk.h>
#include <graphene-gobject.h>
#include <string.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SUDOKU_FRAME (sudoku_frame_get_type ())
#define SUDOKU_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_FRAME, SudokuFrame))
#define SUDOKU_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_FRAME, SudokuFrameClass))
#define IS_SUDOKU_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_FRAME))
#define IS_SUDOKU_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_FRAME))
#define SUDOKU_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_FRAME, SudokuFrameClass))

typedef struct _SudokuFrame SudokuFrame;
typedef struct _SudokuFrameClass SudokuFrameClass;
typedef struct _SudokuFramePrivate SudokuFramePrivate;
enum  {
	SUDOKU_FRAME_0_PROPERTY,
	SUDOKU_FRAME_CHILD_PROPERTY,
	SUDOKU_FRAME_NUM_PROPERTIES
};
static GParamSpec* sudoku_frame_properties[SUDOKU_FRAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gsk_transform_unref0(var) ((var == NULL) ? NULL : (var = (gsk_transform_unref (var), NULL)))

struct _SudokuFrame {
	GtkWidget parent_instance;
	SudokuFramePrivate * priv;
};

struct _SudokuFrameClass {
	GtkWidgetClass parent_class;
};

struct _SudokuFramePrivate {
	GtkWidget* _child;
};

static gint SudokuFrame_private_offset;
static gpointer sudoku_frame_parent_class = NULL;

VALA_EXTERN GType sudoku_frame_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SudokuFrame, g_object_unref)
static void sudoku_frame_real_measure (GtkWidget* base,
                                GtkOrientation orientation,
                                gint for_size,
                                gint* minimum,
                                gint* natural,
                                gint* minimum_baseline,
                                gint* natural_baseline);
VALA_EXTERN GtkWidget* sudoku_frame_get_child (SudokuFrame* self);
static void sudoku_frame_real_size_allocate (GtkWidget* base,
                                      gint width,
                                      gint height,
                                      gint baseline);
VALA_EXTERN SudokuFrame* sudoku_frame_new (GtkWidget* child);
VALA_EXTERN SudokuFrame* sudoku_frame_construct (GType object_type,
                                     GtkWidget* child);
VALA_EXTERN void sudoku_frame_set_child (SudokuFrame* self,
                             GtkWidget* value);
static void sudoku_frame_real_dispose (GObject* base);
static void sudoku_frame_finalize (GObject * obj);
static GType sudoku_frame_get_type_once (void);
static void _vala_sudoku_frame_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_sudoku_frame_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);

static inline gpointer
sudoku_frame_get_instance_private (SudokuFrame* self)
{
	return G_STRUCT_MEMBER_P (self, SudokuFrame_private_offset);
}

static void
sudoku_frame_real_measure (GtkWidget* base,
                           GtkOrientation orientation,
                           gint for_size,
                           gint* minimum,
                           gint* natural,
                           gint* minimum_baseline,
                           gint* natural_baseline)
{
	SudokuFrame * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint _vala_minimum_baseline = 0;
	gint _vala_natural_baseline = 0;
	gboolean _tmp0_ = FALSE;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	self = (SudokuFrame*) base;
	_tmp1_ = sudoku_frame_get_child (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = sudoku_frame_get_child (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = gtk_widget_get_visible (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint child_height_min = 0;
		gint child_height_nat = 0;
		gint child_width_min = 0;
		gint child_width_nat = 0;
		GtkWidget* _tmp7_;
		GtkWidget* _tmp8_;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		GtkWidget* _tmp11_;
		GtkWidget* _tmp12_;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp7_ = sudoku_frame_get_child (self);
		_tmp8_ = _tmp7_;
		gtk_widget_measure (_tmp8_, GTK_ORIENTATION_HORIZONTAL, -1, &_tmp9_, &_tmp10_, NULL, NULL);
		child_width_min = _tmp9_;
		child_width_nat = _tmp10_;
		_tmp11_ = sudoku_frame_get_child (self);
		_tmp12_ = _tmp11_;
		gtk_widget_measure (_tmp12_, GTK_ORIENTATION_VERTICAL, -1, &_tmp13_, &_tmp14_, NULL, NULL);
		child_height_min = _tmp13_;
		child_height_nat = _tmp14_;
		_vala_minimum = MAX (child_height_min, child_width_min);
		_vala_natural = MAX (child_height_nat, child_width_nat);
	} else {
		_vala_natural = 0;
		_vala_minimum = _vala_natural;
	}
	_vala_natural_baseline = -1;
	_vala_minimum_baseline = _vala_natural_baseline;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
	if (minimum_baseline) {
		*minimum_baseline = _vala_minimum_baseline;
	}
	if (natural_baseline) {
		*natural_baseline = _vala_natural_baseline;
	}
}

static gpointer
_gsk_transform_ref0 (gpointer self)
{
	return self ? gsk_transform_ref (self) : NULL;
}

static void
sudoku_frame_real_size_allocate (GtkWidget* base,
                                 gint width,
                                 gint height,
                                 gint baseline)
{
	SudokuFrame * self;
	gint child_width = 0;
	gint child_height = 0;
	GskTransform* center = NULL;
	GskTransform* _tmp0_;
	graphene_point_t _tmp1_ = {0};
	graphene_point_t _tmp2_;
	GskTransform* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GskTransform* _tmp6_;
	self = (SudokuFrame*) base;
	child_height = MIN (width, height);
	child_width = child_height;
	_tmp0_ = gsk_transform_new ();
	memset (&_tmp1_, 0, sizeof (graphene_point_t));
	_tmp2_ = *graphene_point_init (&_tmp1_, (gfloat) ((width - child_width) / 2), (gfloat) ((height - child_height) / 2));
	_tmp3_ = gsk_transform_translate (_tmp0_, &_tmp2_);
	center = _tmp3_;
	_tmp4_ = sudoku_frame_get_child (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _gsk_transform_ref0 (center);
	gtk_widget_allocate (_tmp5_, child_width, child_height, baseline, _tmp6_);
	_gsk_transform_unref0 (center);
}

SudokuFrame*
sudoku_frame_construct (GType object_type,
                        GtkWidget* child)
{
	SudokuFrame * self = NULL;
	self = (SudokuFrame*) g_object_new (object_type, NULL);
	sudoku_frame_set_child (self, child);
	gtk_widget_class_set_css_name (G_TYPE_INSTANCE_GET_CLASS (self, gtk_widget_get_type (), GtkWidgetClass), "aspectframe");
	gtk_widget_class_set_accessible_role (G_TYPE_INSTANCE_GET_CLASS (self, gtk_widget_get_type (), GtkWidgetClass), GTK_ACCESSIBLE_ROLE_GROUP);
	return self;
}

SudokuFrame*
sudoku_frame_new (GtkWidget* child)
{
	return sudoku_frame_construct (TYPE_SUDOKU_FRAME, child);
}

static void
sudoku_frame_real_dispose (GObject* base)
{
	SudokuFrame * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	self = (SudokuFrame*) base;
	_tmp0_ = sudoku_frame_get_child (self);
	_tmp1_ = _tmp0_;
	gtk_widget_unparent (_tmp1_);
	G_OBJECT_CLASS (sudoku_frame_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}

GtkWidget*
sudoku_frame_get_child (SudokuFrame* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_child;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
sudoku_frame_set_child (SudokuFrame* self,
                        GtkWidget* value)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_child);
	self->priv->_child = _tmp0_;
	_tmp1_ = self->priv->_child;
	gtk_widget_set_parent (_tmp1_, (GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, sudoku_frame_properties[SUDOKU_FRAME_CHILD_PROPERTY]);
}

static void
sudoku_frame_class_init (SudokuFrameClass * klass,
                         gpointer klass_data)
{
	sudoku_frame_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SudokuFrame_private_offset);
	((GtkWidgetClass *) klass)->measure = (void (*) (GtkWidget*, GtkOrientation, gint, gint*, gint*, gint*, gint*)) sudoku_frame_real_measure;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) sudoku_frame_real_size_allocate;
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) sudoku_frame_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_frame_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_frame_set_property;
	G_OBJECT_CLASS (klass)->finalize = sudoku_frame_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_FRAME_CHILD_PROPERTY, sudoku_frame_properties[SUDOKU_FRAME_CHILD_PROPERTY] = g_param_spec_object ("child", "child", "child", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
sudoku_frame_instance_init (SudokuFrame * self,
                            gpointer klass)
{
	self->priv = sudoku_frame_get_instance_private (self);
}

static void
sudoku_frame_finalize (GObject * obj)
{
	SudokuFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_FRAME, SudokuFrame);
	_g_object_unref0 (self->priv->_child);
	G_OBJECT_CLASS (sudoku_frame_parent_class)->finalize (obj);
}

static GType
sudoku_frame_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SudokuFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuFrame), 0, (GInstanceInitFunc) sudoku_frame_instance_init, NULL };
	GType sudoku_frame_type_id;
	sudoku_frame_type_id = g_type_register_static (gtk_widget_get_type (), "SudokuFrame", &g_define_type_info, 0);
	SudokuFrame_private_offset = g_type_add_instance_private (sudoku_frame_type_id, sizeof (SudokuFramePrivate));
	return sudoku_frame_type_id;
}

GType
sudoku_frame_get_type (void)
{
	static volatile gsize sudoku_frame_type_id__once = 0;
	if (g_once_init_enter (&sudoku_frame_type_id__once)) {
		GType sudoku_frame_type_id;
		sudoku_frame_type_id = sudoku_frame_get_type_once ();
		g_once_init_leave (&sudoku_frame_type_id__once, sudoku_frame_type_id);
	}
	return sudoku_frame_type_id__once;
}

static void
_vala_sudoku_frame_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	SudokuFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_FRAME, SudokuFrame);
	switch (property_id) {
		case SUDOKU_FRAME_CHILD_PROPERTY:
		g_value_set_object (value, sudoku_frame_get_child (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sudoku_frame_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	SudokuFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_FRAME, SudokuFrame);
	switch (property_id) {
		case SUDOKU_FRAME_CHILD_PROPERTY:
		sudoku_frame_set_child (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

