/* warp.c generated by valac 0.56.16, the Vala compiler
 * generated from warp.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 *
 * Rewrite of the original by Sean MacIsaac, Ian Peters, Guillaume Béland
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 * Copyright (C) 2020 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't 
 * match them self.
 *
 * grep -ne '[^][)(_!$ "](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 *
 */

#include <glib-object.h>
#include <gee.h>
#include <glib.h>

#define WARP_MANAGER_MAX_WARPS ((guint8) 200)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_WARP_MANAGER (warp_manager_get_type ())
#define WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_MANAGER, WarpManager))
#define WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_MANAGER, WarpManagerClass))
#define IS_WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_MANAGER))
#define IS_WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_MANAGER))
#define WARP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_MANAGER, WarpManagerClass))

typedef struct _WarpManager WarpManager;
typedef struct _WarpManagerClass WarpManagerClass;
typedef struct _WarpManagerPrivate WarpManagerPrivate;

#define WARP_MANAGER_TYPE_WARP (warp_manager_warp_get_type ())
#define WARP_MANAGER_WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WARP_MANAGER_TYPE_WARP, WarpManagerWarp))
#define WARP_MANAGER_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WARP_MANAGER_TYPE_WARP, WarpManagerWarpClass))
#define WARP_MANAGER_IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WARP_MANAGER_TYPE_WARP))
#define WARP_MANAGER_IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WARP_MANAGER_TYPE_WARP))
#define WARP_MANAGER_WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WARP_MANAGER_TYPE_WARP, WarpManagerWarpClass))

typedef struct _WarpManagerWarp WarpManagerWarp;
typedef struct _WarpManagerWarpClass WarpManagerWarpClass;
enum  {
	WARP_MANAGER_0_PROPERTY,
	WARP_MANAGER_NUM_PROPERTIES
};
static GParamSpec* warp_manager_properties[WARP_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _WarpManagerWarpPrivate WarpManagerWarpPrivate;
enum  {
	WARP_MANAGER_WARP_0_PROPERTY,
	WARP_MANAGER_WARP_ID_PROPERTY,
	WARP_MANAGER_WARP_SOURCE_X_PROPERTY,
	WARP_MANAGER_WARP_SOURCE_Y_PROPERTY,
	WARP_MANAGER_WARP_TARGET_X_PROPERTY,
	WARP_MANAGER_WARP_TARGET_Y_PROPERTY,
	WARP_MANAGER_WARP_BIDI_PROPERTY,
	WARP_MANAGER_WARP_NUM_PROPERTIES
};
static GParamSpec* warp_manager_warp_properties[WARP_MANAGER_WARP_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _WarpManager {
	GObject parent_instance;
	WarpManagerPrivate * priv;
};

struct _WarpManagerClass {
	GObjectClass parent_class;
};

struct _WarpManagerPrivate {
	GeeLinkedList* warps;
};

struct _WarpManagerWarp {
	GObject parent_instance;
	WarpManagerWarpPrivate * priv;
};

struct _WarpManagerWarpClass {
	GObjectClass parent_class;
};

struct _WarpManagerWarpPrivate {
	gboolean init_finished;
	gint _id;
	guint8 _source_x;
	guint8 _source_y;
	guint8 _target_x;
	guint8 _target_y;
	gboolean _bidi;
};

static gint WarpManager_private_offset;
static gpointer warp_manager_parent_class = NULL;
static gint WarpManagerWarp_private_offset;
static gpointer warp_manager_warp_parent_class = NULL;

VALA_EXTERN GType warp_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WarpManager, g_object_unref)
static GType warp_manager_warp_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WarpManagerWarp, g_object_unref)
VALA_EXTERN void warp_manager_add_warp_source (WarpManager* self,
                                   gint id,
                                   guint8 x,
                                   guint8 y);
static gint warp_manager_warp_get_id (WarpManagerWarp* self);
static void warp_manager_warp_set_source (WarpManagerWarp* self,
                                   guint8 x,
                                   guint8 y);
static gboolean warp_manager_warp_get_bidi (WarpManagerWarp* self);
static WarpManagerWarp* warp_manager_warp_new_from_source (gint id,
                                                    guint8 source_x,
                                                    guint8 source_y);
static WarpManagerWarp* warp_manager_warp_construct_from_source (GType object_type,
                                                          gint id,
                                                          guint8 source_x,
                                                          guint8 source_y);
static guint8 warp_manager_warp_get_source_x (WarpManagerWarp* self);
static guint8 warp_manager_warp_get_source_y (WarpManagerWarp* self);
VALA_EXTERN void warp_manager_add_warp_target (WarpManager* self,
                                   gint id,
                                   guint8 x,
                                   guint8 y);
static void warp_manager_warp_set_target (WarpManagerWarp* self,
                                   guint8 x,
                                   guint8 y);
static WarpManagerWarp* warp_manager_warp_new_from_target (gint id,
                                                    guint8 target_x,
                                                    guint8 target_y);
static WarpManagerWarp* warp_manager_warp_construct_from_target (GType object_type,
                                                          gint id,
                                                          guint8 target_x,
                                                          guint8 target_y);
VALA_EXTERN gboolean warp_manager_get_warp_target (WarpManager* self,
                                       guint8 x,
                                       guint8 y,
                                       gboolean horizontal,
                                       guint8* target_x,
                                       guint8* target_y);
static gboolean warp_manager_warp_get_target (WarpManagerWarp* self,
                                       guint8 x,
                                       guint8 y,
                                       gboolean horizontal,
                                       guint8* target_x,
                                       guint8* target_y);
VALA_EXTERN void warp_manager_clear_warps (WarpManager* self);
VALA_EXTERN WarpManager* warp_manager_new (void);
VALA_EXTERN WarpManager* warp_manager_construct (GType object_type);
static void warp_manager_warp_set_target_x (WarpManagerWarp* self,
                                     guint8 value);
static void warp_manager_warp_set_target_y (WarpManagerWarp* self,
                                     guint8 value);
static void warp_manager_warp_set_source_x (WarpManagerWarp* self,
                                     guint8 value);
static void warp_manager_warp_set_source_y (WarpManagerWarp* self,
                                     guint8 value);
static void warp_manager_warp_set_bidi (WarpManagerWarp* self,
                                 gboolean value);
static guint8 warp_manager_warp_get_target_x (WarpManagerWarp* self);
static guint8 warp_manager_warp_get_target_y (WarpManagerWarp* self);
static WarpManagerWarp* warp_manager_warp_new (void);
static WarpManagerWarp* warp_manager_warp_construct (GType object_type);
static void warp_manager_warp_set_id (WarpManagerWarp* self,
                               gint value);
static void warp_manager_warp_finalize (GObject * obj);
static GType warp_manager_warp_get_type_once (void);
static void _vala_warp_manager_warp_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_warp_manager_warp_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void warp_manager_finalize (GObject * obj);
static GType warp_manager_get_type_once (void);

static inline gpointer
warp_manager_get_instance_private (WarpManager* self)
{
	return G_STRUCT_MEMBER_P (self, WarpManager_private_offset);
}

void
warp_manager_add_warp_source (WarpManager* self,
                              gint id,
                              guint8 x,
                              guint8 y)
{
	GeeLinkedList* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GeeLinkedList* _tmp28_;
	WarpManagerWarp* _tmp29_;
	WarpManagerWarp* _tmp30_;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _warp_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _warp_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _warp_index = 0;
		_tmp0_ = self->priv->warps;
		_warp_list = _tmp0_;
		_tmp1_ = _warp_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_warp_size = _tmp3_;
		_warp_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			WarpManagerWarp* warp = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			WarpManagerWarp* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			WarpManagerWarp* _tmp11_;
			WarpManagerWarp* _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_;
			_warp_index = _warp_index + 1;
			_tmp4_ = _warp_index;
			_tmp5_ = _warp_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _warp_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _warp_index);
			warp = (WarpManagerWarp*) _tmp7_;
			_tmp8_ = warp;
			_tmp9_ = warp_manager_warp_get_id (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != id) {
				_g_object_unref0 (warp);
				continue;
			}
			_tmp11_ = warp;
			warp_manager_warp_set_source (_tmp11_, x, y);
			_tmp12_ = warp;
			_tmp13_ = warp_manager_warp_get_bidi (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_) {
				WarpManagerWarp* bidi_warp = NULL;
				WarpManagerWarp* _tmp15_;
				WarpManagerWarp* _tmp16_;
				WarpManagerWarp* _tmp17_;
				guint8 _tmp18_;
				guint8 _tmp19_;
				WarpManagerWarp* _tmp20_;
				guint8 _tmp21_;
				guint8 _tmp22_;
				GeeLinkedList* _tmp23_;
				WarpManagerWarp* _tmp24_;
				_tmp15_ = warp_manager_warp_new_from_source (id, x, y);
				bidi_warp = _tmp15_;
				_tmp16_ = bidi_warp;
				_tmp17_ = warp;
				_tmp18_ = warp_manager_warp_get_source_x (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = warp;
				_tmp21_ = warp_manager_warp_get_source_y (_tmp20_);
				_tmp22_ = _tmp21_;
				warp_manager_warp_set_source (_tmp16_, _tmp19_, _tmp22_);
				_tmp23_ = self->priv->warps;
				_tmp24_ = bidi_warp;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
				_g_object_unref0 (bidi_warp);
			}
			_g_object_unref0 (warp);
			return;
		}
	}
	_tmp25_ = self->priv->warps;
	_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ >= ((gint) WARP_MANAGER_MAX_WARPS)) {
		return;
	}
	_tmp28_ = self->priv->warps;
	_tmp29_ = warp_manager_warp_new_from_source (id, x, y);
	_tmp30_ = _tmp29_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp30_);
	_g_object_unref0 (_tmp30_);
}

void
warp_manager_add_warp_target (WarpManager* self,
                              gint id,
                              guint8 x,
                              guint8 y)
{
	GeeLinkedList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GeeLinkedList* _tmp15_;
	WarpManagerWarp* _tmp16_;
	WarpManagerWarp* _tmp17_;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _warp_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _warp_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _warp_index = 0;
		_tmp0_ = self->priv->warps;
		_warp_list = _tmp0_;
		_tmp1_ = _warp_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_warp_size = _tmp3_;
		_warp_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			WarpManagerWarp* warp = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			WarpManagerWarp* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			WarpManagerWarp* _tmp11_;
			_warp_index = _warp_index + 1;
			_tmp4_ = _warp_index;
			_tmp5_ = _warp_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _warp_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _warp_index);
			warp = (WarpManagerWarp*) _tmp7_;
			_tmp8_ = warp;
			_tmp9_ = warp_manager_warp_get_id (_tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != id) {
				_g_object_unref0 (warp);
				continue;
			}
			_tmp11_ = warp;
			warp_manager_warp_set_target (_tmp11_, x, y);
			_g_object_unref0 (warp);
			return;
		}
	}
	_tmp12_ = self->priv->warps;
	_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ >= ((gint) WARP_MANAGER_MAX_WARPS)) {
		return;
	}
	_tmp15_ = self->priv->warps;
	_tmp16_ = warp_manager_warp_new_from_target (id, x, y);
	_tmp17_ = _tmp16_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp17_);
	_g_object_unref0 (_tmp17_);
}

gboolean
warp_manager_get_warp_target (WarpManager* self,
                              guint8 x,
                              guint8 y,
                              gboolean horizontal,
                              guint8* target_x,
                              guint8* target_y)
{
	guint8 _vala_target_x = 0U;
	guint8 _vala_target_y = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_target_x = (guint8) 0;
	_vala_target_y = (guint8) 0;
	{
		GeeLinkedList* _warp_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _warp_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _warp_index = 0;
		_tmp0_ = self->priv->warps;
		_warp_list = _tmp0_;
		_tmp1_ = _warp_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_warp_size = _tmp3_;
		_warp_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			WarpManagerWarp* warp = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			WarpManagerWarp* _tmp8_;
			gboolean _tmp9_;
			_warp_index = _warp_index + 1;
			_tmp4_ = _warp_index;
			_tmp5_ = _warp_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _warp_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _warp_index);
			warp = (WarpManagerWarp*) _tmp7_;
			_tmp8_ = warp;
			_tmp9_ = warp_manager_warp_get_target (_tmp8_, x, y, horizontal, &_vala_target_x, &_vala_target_y);
			if (_tmp9_) {
				result = TRUE;
				_g_object_unref0 (warp);
				if (target_x) {
					*target_x = _vala_target_x;
				}
				if (target_y) {
					*target_y = _vala_target_y;
				}
				return result;
			}
			_g_object_unref0 (warp);
		}
	}
	result = FALSE;
	if (target_x) {
		*target_x = _vala_target_x;
	}
	if (target_y) {
		*target_y = _vala_target_y;
	}
	return result;
}

void
warp_manager_clear_warps (WarpManager* self)
{
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->warps;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
}

WarpManager*
warp_manager_construct (GType object_type)
{
	WarpManager * self = NULL;
	self = (WarpManager*) g_object_new (object_type, NULL);
	return self;
}

WarpManager*
warp_manager_new (void)
{
	return warp_manager_construct (TYPE_WARP_MANAGER);
}

static inline gpointer
warp_manager_warp_get_instance_private (WarpManagerWarp* self)
{
	return G_STRUCT_MEMBER_P (self, WarpManagerWarp_private_offset);
}

static WarpManagerWarp*
warp_manager_warp_construct_from_source (GType object_type,
                                         gint id,
                                         guint8 source_x,
                                         guint8 source_y)
{
	WarpManagerWarp * self = NULL;
	self = (WarpManagerWarp*) g_object_new (object_type, "id", id, "source-x", source_x, "source-y", source_y, "bidi", TRUE, NULL);
	return self;
}

static WarpManagerWarp*
warp_manager_warp_new_from_source (gint id,
                                   guint8 source_x,
                                   guint8 source_y)
{
	return warp_manager_warp_construct_from_source (WARP_MANAGER_TYPE_WARP, id, source_x, source_y);
}

static WarpManagerWarp*
warp_manager_warp_construct_from_target (GType object_type,
                                         gint id,
                                         guint8 target_x,
                                         guint8 target_y)
{
	WarpManagerWarp * self = NULL;
	self = (WarpManagerWarp*) g_object_new (object_type, "id", id, "target-x", target_x, "target-y", target_y, "bidi", FALSE, NULL);
	return self;
}

static WarpManagerWarp*
warp_manager_warp_new_from_target (gint id,
                                   guint8 target_x,
                                   guint8 target_y)
{
	return warp_manager_warp_construct_from_target (WARP_MANAGER_TYPE_WARP, id, target_x, target_y);
}

static void
warp_manager_warp_set_source (WarpManagerWarp* self,
                              guint8 x,
                              guint8 y)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->init_finished == FALSE, "init_finished == false");
	_tmp0_ = self->priv->_bidi;
	if (_tmp0_) {
		warp_manager_warp_set_target_x (self, x);
		warp_manager_warp_set_target_y (self, y);
	} else {
		warp_manager_warp_set_source_x (self, x);
		warp_manager_warp_set_source_y (self, y);
	}
	self->priv->init_finished = TRUE;
}

static void
warp_manager_warp_set_target (WarpManagerWarp* self,
                              guint8 x,
                              guint8 y)
{
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_vala_return_if_fail (self->priv->init_finished == FALSE, "init_finished == false");
	_tmp0_ = self->priv->_bidi;
	_vala_return_if_fail (_tmp0_ == TRUE, "bidi == true");
	warp_manager_warp_set_target_x (self, x);
	warp_manager_warp_set_target_y (self, y);
	warp_manager_warp_set_bidi (self, FALSE);
	self->priv->init_finished = TRUE;
}

static gboolean
warp_manager_warp_get_target (WarpManagerWarp* self,
                              guint8 x,
                              guint8 y,
                              gboolean horizontal,
                              guint8* target_x,
                              guint8* target_y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	guint8 _tmp2_;
	gboolean _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_return_val_if_fail (self->priv->init_finished == TRUE, "init_finished == true", FALSE);
	_tmp2_ = self->priv->_source_x;
	if (x != _tmp2_) {
		guint8 _tmp3_;
		_tmp3_ = self->priv->_source_x;
		_tmp1_ = ((gint) x) != (_tmp3_ + 1);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		guint8 _tmp5_;
		_tmp5_ = self->priv->_source_y;
		if (y != _tmp5_) {
			guint8 _tmp6_;
			_tmp6_ = self->priv->_source_y;
			_tmp4_ = ((gint) y) != (_tmp6_ + 1);
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp7_ = self->priv->_bidi;
	if (!_tmp7_) {
		guint8 _tmp8_;
		guint8 _tmp9_;
		_tmp8_ = self->priv->_target_x;
		*target_x = _tmp8_;
		_tmp9_ = self->priv->_target_y;
		*target_y = _tmp9_;
	} else {
		if (horizontal) {
			guint8 _tmp10_;
			guint8 _tmp14_;
			_tmp10_ = self->priv->_source_x;
			if (x == _tmp10_) {
				guint8 _tmp11_;
				_tmp11_ = self->priv->_target_x;
				*target_x = (guint8) (_tmp11_ + 2);
			} else {
				guint8 _tmp12_;
				_tmp12_ = self->priv->_target_x;
				if (((gint) _tmp12_) == 0) {
					g_assert_not_reached ();
				} else {
					guint8 _tmp13_;
					_tmp13_ = self->priv->_target_x;
					*target_x = (guint8) (_tmp13_ - 1);
				}
			}
			_tmp14_ = self->priv->_source_y;
			if (y == _tmp14_) {
				guint8 _tmp15_;
				_tmp15_ = self->priv->_target_y;
				*target_y = _tmp15_;
			} else {
				guint8 _tmp16_;
				_tmp16_ = self->priv->_target_y;
				*target_y = (guint8) (_tmp16_ + 1);
			}
		} else {
			guint8 _tmp17_;
			guint8 _tmp20_;
			_tmp17_ = self->priv->_source_x;
			if (x == _tmp17_) {
				guint8 _tmp18_;
				_tmp18_ = self->priv->_target_x;
				*target_x = _tmp18_;
			} else {
				guint8 _tmp19_;
				_tmp19_ = self->priv->_target_x;
				*target_x = (guint8) (_tmp19_ + 1);
			}
			_tmp20_ = self->priv->_source_y;
			if (y == _tmp20_) {
				guint8 _tmp21_;
				_tmp21_ = self->priv->_target_y;
				*target_y = (guint8) (_tmp21_ + 2);
			} else {
				guint8 _tmp22_;
				_tmp22_ = self->priv->_target_y;
				if (((gint) _tmp22_) == 0) {
					g_assert_not_reached ();
				} else {
					guint8 _tmp23_;
					_tmp23_ = self->priv->_target_y;
					*target_y = (guint8) (_tmp23_ - 1);
				}
			}
		}
	}
	result = TRUE;
	return result;
}

static WarpManagerWarp*
warp_manager_warp_construct (GType object_type)
{
	WarpManagerWarp * self = NULL;
	self = (WarpManagerWarp*) g_object_new (object_type, NULL);
	return self;
}

static WarpManagerWarp*
warp_manager_warp_new (void)
{
	return warp_manager_warp_construct (WARP_MANAGER_TYPE_WARP);
}

static gint
warp_manager_warp_get_id (WarpManagerWarp* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_id;
	return result;
}

static void
warp_manager_warp_set_id (WarpManagerWarp* self,
                          gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = warp_manager_warp_get_id (self);
	if (old_value != value) {
		self->priv->_id = value;
		g_object_notify_by_pspec ((GObject *) self, warp_manager_warp_properties[WARP_MANAGER_WARP_ID_PROPERTY]);
	}
}

static guint8
warp_manager_warp_get_source_x (WarpManagerWarp* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_source_x;
	return result;
}

static void
warp_manager_warp_set_source_x (WarpManagerWarp* self,
                                guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = warp_manager_warp_get_source_x (self);
	if (old_value != value) {
		self->priv->_source_x = value;
		g_object_notify_by_pspec ((GObject *) self, warp_manager_warp_properties[WARP_MANAGER_WARP_SOURCE_X_PROPERTY]);
	}
}

static guint8
warp_manager_warp_get_source_y (WarpManagerWarp* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_source_y;
	return result;
}

static void
warp_manager_warp_set_source_y (WarpManagerWarp* self,
                                guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = warp_manager_warp_get_source_y (self);
	if (old_value != value) {
		self->priv->_source_y = value;
		g_object_notify_by_pspec ((GObject *) self, warp_manager_warp_properties[WARP_MANAGER_WARP_SOURCE_Y_PROPERTY]);
	}
}

static guint8
warp_manager_warp_get_target_x (WarpManagerWarp* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_target_x;
	return result;
}

static void
warp_manager_warp_set_target_x (WarpManagerWarp* self,
                                guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = warp_manager_warp_get_target_x (self);
	if (old_value != value) {
		self->priv->_target_x = value;
		g_object_notify_by_pspec ((GObject *) self, warp_manager_warp_properties[WARP_MANAGER_WARP_TARGET_X_PROPERTY]);
	}
}

static guint8
warp_manager_warp_get_target_y (WarpManagerWarp* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_target_y;
	return result;
}

static void
warp_manager_warp_set_target_y (WarpManagerWarp* self,
                                guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = warp_manager_warp_get_target_y (self);
	if (old_value != value) {
		self->priv->_target_y = value;
		g_object_notify_by_pspec ((GObject *) self, warp_manager_warp_properties[WARP_MANAGER_WARP_TARGET_Y_PROPERTY]);
	}
}

static gboolean
warp_manager_warp_get_bidi (WarpManagerWarp* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_bidi;
	return result;
}

static void
warp_manager_warp_set_bidi (WarpManagerWarp* self,
                            gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = warp_manager_warp_get_bidi (self);
	if (old_value != value) {
		self->priv->_bidi = value;
		g_object_notify_by_pspec ((GObject *) self, warp_manager_warp_properties[WARP_MANAGER_WARP_BIDI_PROPERTY]);
	}
}

static void
warp_manager_warp_class_init (WarpManagerWarpClass * klass,
                              gpointer klass_data)
{
	warp_manager_warp_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WarpManagerWarp_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_warp_manager_warp_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_warp_manager_warp_set_property;
	G_OBJECT_CLASS (klass)->finalize = warp_manager_warp_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WARP_MANAGER_WARP_ID_PROPERTY, warp_manager_warp_properties[WARP_MANAGER_WARP_ID_PROPERTY] = g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WARP_MANAGER_WARP_SOURCE_X_PROPERTY, warp_manager_warp_properties[WARP_MANAGER_WARP_SOURCE_X_PROPERTY] = g_param_spec_uchar ("source-x", "source-x", "source-x", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WARP_MANAGER_WARP_SOURCE_Y_PROPERTY, warp_manager_warp_properties[WARP_MANAGER_WARP_SOURCE_Y_PROPERTY] = g_param_spec_uchar ("source-y", "source-y", "source-y", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WARP_MANAGER_WARP_TARGET_X_PROPERTY, warp_manager_warp_properties[WARP_MANAGER_WARP_TARGET_X_PROPERTY] = g_param_spec_uchar ("target-x", "target-x", "target-x", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WARP_MANAGER_WARP_TARGET_Y_PROPERTY, warp_manager_warp_properties[WARP_MANAGER_WARP_TARGET_Y_PROPERTY] = g_param_spec_uchar ("target-y", "target-y", "target-y", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), WARP_MANAGER_WARP_BIDI_PROPERTY, warp_manager_warp_properties[WARP_MANAGER_WARP_BIDI_PROPERTY] = g_param_spec_boolean ("bidi", "bidi", "bidi", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
warp_manager_warp_instance_init (WarpManagerWarp * self,
                                 gpointer klass)
{
	self->priv = warp_manager_warp_get_instance_private (self);
	self->priv->init_finished = FALSE;
}

static void
warp_manager_warp_finalize (GObject * obj)
{
	WarpManagerWarp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WARP_MANAGER_TYPE_WARP, WarpManagerWarp);
	G_OBJECT_CLASS (warp_manager_warp_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
warp_manager_warp_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WarpManagerWarpClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) warp_manager_warp_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WarpManagerWarp), 0, (GInstanceInitFunc) warp_manager_warp_instance_init, NULL };
	GType warp_manager_warp_type_id;
	warp_manager_warp_type_id = g_type_register_static (G_TYPE_OBJECT, "WarpManagerWarp", &g_define_type_info, 0);
	WarpManagerWarp_private_offset = g_type_add_instance_private (warp_manager_warp_type_id, sizeof (WarpManagerWarpPrivate));
	return warp_manager_warp_type_id;
}

static GType
warp_manager_warp_get_type (void)
{
	static gsize warp_manager_warp_type_id__once = 0;
	if (g_once_init_enter (&warp_manager_warp_type_id__once)) {
		GType warp_manager_warp_type_id;
		warp_manager_warp_type_id = warp_manager_warp_get_type_once ();
		g_once_init_leave (&warp_manager_warp_type_id__once, warp_manager_warp_type_id);
	}
	return warp_manager_warp_type_id__once;
}

static void
_vala_warp_manager_warp_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	WarpManagerWarp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WARP_MANAGER_TYPE_WARP, WarpManagerWarp);
	switch (property_id) {
		case WARP_MANAGER_WARP_ID_PROPERTY:
		g_value_set_int (value, warp_manager_warp_get_id (self));
		break;
		case WARP_MANAGER_WARP_SOURCE_X_PROPERTY:
		g_value_set_uchar (value, warp_manager_warp_get_source_x (self));
		break;
		case WARP_MANAGER_WARP_SOURCE_Y_PROPERTY:
		g_value_set_uchar (value, warp_manager_warp_get_source_y (self));
		break;
		case WARP_MANAGER_WARP_TARGET_X_PROPERTY:
		g_value_set_uchar (value, warp_manager_warp_get_target_x (self));
		break;
		case WARP_MANAGER_WARP_TARGET_Y_PROPERTY:
		g_value_set_uchar (value, warp_manager_warp_get_target_y (self));
		break;
		case WARP_MANAGER_WARP_BIDI_PROPERTY:
		g_value_set_boolean (value, warp_manager_warp_get_bidi (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_warp_manager_warp_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	WarpManagerWarp * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, WARP_MANAGER_TYPE_WARP, WarpManagerWarp);
	switch (property_id) {
		case WARP_MANAGER_WARP_ID_PROPERTY:
		warp_manager_warp_set_id (self, g_value_get_int (value));
		break;
		case WARP_MANAGER_WARP_SOURCE_X_PROPERTY:
		warp_manager_warp_set_source_x (self, g_value_get_uchar (value));
		break;
		case WARP_MANAGER_WARP_SOURCE_Y_PROPERTY:
		warp_manager_warp_set_source_y (self, g_value_get_uchar (value));
		break;
		case WARP_MANAGER_WARP_TARGET_X_PROPERTY:
		warp_manager_warp_set_target_x (self, g_value_get_uchar (value));
		break;
		case WARP_MANAGER_WARP_TARGET_Y_PROPERTY:
		warp_manager_warp_set_target_y (self, g_value_get_uchar (value));
		break;
		case WARP_MANAGER_WARP_BIDI_PROPERTY:
		warp_manager_warp_set_bidi (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
warp_manager_class_init (WarpManagerClass * klass,
                         gpointer klass_data)
{
	warp_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WarpManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = warp_manager_finalize;
}

static void
warp_manager_instance_init (WarpManager * self,
                            gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = warp_manager_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (WARP_MANAGER_TYPE_WARP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->warps = _tmp0_;
}

static void
warp_manager_finalize (GObject * obj)
{
	WarpManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WARP_MANAGER, WarpManager);
	_g_object_unref0 (self->priv->warps);
	G_OBJECT_CLASS (warp_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
warp_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WarpManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) warp_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WarpManager), 0, (GInstanceInitFunc) warp_manager_instance_init, NULL };
	GType warp_manager_type_id;
	warp_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "WarpManager", &g_define_type_info, 0);
	WarpManager_private_offset = g_type_add_instance_private (warp_manager_type_id, sizeof (WarpManagerPrivate));
	return warp_manager_type_id;
}

GType
warp_manager_get_type (void)
{
	static gsize warp_manager_type_id__once = 0;
	if (g_once_init_enter (&warp_manager_type_id__once)) {
		GType warp_manager_type_id;
		warp_manager_type_id = warp_manager_get_type_once ();
		g_once_init_leave (&warp_manager_type_id__once, warp_manager_type_id);
	}
	return warp_manager_type_id__once;
}

