/* scoreboard.c generated by valac 0.56.16, the Vala compiler
 * generated from scoreboard.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#define WORM_MAX_LIVES ((guint8) 12)
#define WORM_STARTING_LIVES ((guint8) 6)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SCOREBOARD (scoreboard_get_type ())
#define SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCOREBOARD, Scoreboard))
#define SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCOREBOARD, ScoreboardClass))
#define IS_SCOREBOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCOREBOARD))
#define IS_SCOREBOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCOREBOARD))
#define SCOREBOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCOREBOARD, ScoreboardClass))

typedef struct _Scoreboard Scoreboard;
typedef struct _ScoreboardClass ScoreboardClass;
typedef struct _ScoreboardPrivate ScoreboardPrivate;

#define TYPE_PLAYER_SCORE_BOX (player_score_box_get_type ())
#define PLAYER_SCORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYER_SCORE_BOX, PlayerScoreBox))
#define PLAYER_SCORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxClass))
#define IS_PLAYER_SCORE_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYER_SCORE_BOX))
#define IS_PLAYER_SCORE_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYER_SCORE_BOX))
#define PLAYER_SCORE_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYER_SCORE_BOX, PlayerScoreBoxClass))

typedef struct _PlayerScoreBox PlayerScoreBox;
typedef struct _PlayerScoreBoxClass PlayerScoreBoxClass;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;
enum  {
	SCOREBOARD_0_PROPERTY,
	SCOREBOARD_NUM_PROPERTIES
};
static GParamSpec* scoreboard_properties[SCOREBOARD_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _PlayerScoreBoxPrivate PlayerScoreBoxPrivate;
enum  {
	PLAYER_SCORE_BOX_0_PROPERTY,
	PLAYER_SCORE_BOX_NUM_PROPERTIES
};
static GParamSpec* player_score_box_properties[PLAYER_SCORE_BOX_NUM_PROPERTIES];

struct _Scoreboard {
	GtkBox parent_instance;
	ScoreboardPrivate * priv;
};

struct _ScoreboardClass {
	GtkBoxClass parent_class;
};

struct _ScoreboardPrivate {
	GeeHashMap* boxes;
};

struct _PlayerScoreBox {
	GtkBox parent_instance;
	PlayerScoreBoxPrivate * priv;
};

struct _PlayerScoreBoxClass {
	GtkBoxClass parent_class;
};

struct _PlayerScoreBoxPrivate {
	GtkLabel* name_label;
	GtkLabel* score_label;
	GtkGrid* lives_grid;
	GeeLinkedList* life_images;
};

static gint Scoreboard_private_offset;
static gpointer scoreboard_parent_class = NULL;
static gint PlayerScoreBox_private_offset;
static gpointer player_score_box_parent_class = NULL;

VALA_EXTERN GType scoreboard_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Scoreboard, g_object_unref)
VALA_EXTERN GType player_score_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PlayerScoreBox, g_object_unref)
VALA_EXTERN GType worm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Worm, g_object_unref)
VALA_EXTERN void scoreboard_register (Scoreboard* self,
                          Worm* worm,
                          const gchar* color_name,
                          GtkImage* life);
VALA_EXTERN void get_worm_pango_color (gint color,
                           gboolean bright,
                           PangoColor* c);
VALA_EXTERN gint worm_get_id (Worm* self);
VALA_EXTERN gint worm_get_score (Worm* self);
VALA_EXTERN guint8 worm_get_lives (Worm* self);
VALA_EXTERN PlayerScoreBox* player_score_box_new (const gchar* name,
                                      PangoColor* color,
                                      gint score,
                                      guint8 lives_left,
                                      GtkImage* _life);
VALA_EXTERN PlayerScoreBox* player_score_box_construct (GType object_type,
                                            const gchar* name,
                                            PangoColor* color,
                                            gint score,
                                            guint8 lives_left,
                                            GtkImage* _life);
VALA_EXTERN void scoreboard_update (Scoreboard* self);
VALA_EXTERN void player_score_box_update (PlayerScoreBox* self,
                              gint score,
                              guint8 lives_left);
VALA_EXTERN void scoreboard_clear (Scoreboard* self);
VALA_EXTERN Scoreboard* scoreboard_new (void);
VALA_EXTERN Scoreboard* scoreboard_construct (GType object_type);
static void scoreboard_finalize (GObject * obj);
static GType scoreboard_get_type_once (void);
VALA_EXTERN void player_score_box_update_score (PlayerScoreBox* self,
                                    gint score);
VALA_EXTERN void player_score_box_update_lives (PlayerScoreBox* self,
                                    guint8 lives_left);
static void player_score_box_finalize (GObject * obj);
static GType player_score_box_get_type_once (void);

static inline gpointer
scoreboard_get_instance_private (Scoreboard* self)
{
	return G_STRUCT_MEMBER_P (self, Scoreboard_private_offset);
}

void
scoreboard_register (Scoreboard* self,
                     Worm* worm,
                     const gchar* color_name,
                     GtkImage* life)
{
	PangoColor color = {0};
	PlayerScoreBox* box = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	PangoColor _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	guint8 _tmp7_;
	guint8 _tmp8_;
	PlayerScoreBox* _tmp9_;
	PlayerScoreBox* _tmp10_;
	GeeHashMap* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	g_return_if_fail (color_name != NULL);
	g_return_if_fail (life != NULL);
	memset (&color, 0, sizeof (PangoColor));
	if (g_strcmp0 (color_name, "red") == 0) {
		get_worm_pango_color (0, TRUE, &color);
	} else {
		if (g_strcmp0 (color_name, "green") == 0) {
			get_worm_pango_color (1, TRUE, &color);
		} else {
			if (g_strcmp0 (color_name, "blue") == 0) {
				get_worm_pango_color (2, TRUE, &color);
			} else {
				if (g_strcmp0 (color_name, "yellow") == 0) {
					get_worm_pango_color (3, TRUE, &color);
				} else {
					if (g_strcmp0 (color_name, "cyan") == 0) {
						get_worm_pango_color (4, TRUE, &color);
					} else {
						if (g_strcmp0 (color_name, "purple") == 0) {
							get_worm_pango_color (5, TRUE, &color);
						} else {
							get_worm_pango_color (-1, TRUE, &color);
						}
					}
				}
			}
		}
	}
	_tmp0_ = worm_get_id (worm);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("Worm %d"), _tmp1_ + 1);
	_tmp3_ = _tmp2_;
	_tmp4_ = color;
	_tmp5_ = worm_get_score (worm);
	_tmp6_ = _tmp5_;
	_tmp7_ = worm_get_lives (worm);
	_tmp8_ = _tmp7_;
	_tmp9_ = player_score_box_new (_tmp3_, &_tmp4_, _tmp6_, _tmp8_, life);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp3_);
	box = _tmp10_;
	_tmp11_ = self->priv->boxes;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, box, worm);
	gtk_box_append ((GtkBox*) self, (GtkWidget*) box);
	_g_object_unref0 (box);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
scoreboard_update (Scoreboard* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->boxes;
		_tmp1_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_entry_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			PlayerScoreBox* box = NULL;
			GeeMapEntry* _tmp9_;
			gconstpointer _tmp10_;
			gconstpointer _tmp11_;
			PlayerScoreBox* _tmp12_;
			Worm* worm = NULL;
			GeeMapEntry* _tmp13_;
			gconstpointer _tmp14_;
			gconstpointer _tmp15_;
			Worm* _tmp16_;
			PlayerScoreBox* _tmp17_;
			Worm* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			Worm* _tmp21_;
			guint8 _tmp22_;
			guint8 _tmp23_;
			_tmp6_ = _entry_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _entry_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			entry = (GeeMapEntry*) _tmp8_;
			_tmp9_ = entry;
			_tmp10_ = gee_map_entry_get_key (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = _g_object_ref0 ((PlayerScoreBox*) _tmp11_);
			box = _tmp12_;
			_tmp13_ = entry;
			_tmp14_ = gee_map_entry_get_value (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = _g_object_ref0 ((Worm*) _tmp15_);
			worm = _tmp16_;
			_tmp17_ = box;
			_tmp18_ = worm;
			_tmp19_ = worm_get_score (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = worm;
			_tmp22_ = worm_get_lives (_tmp21_);
			_tmp23_ = _tmp22_;
			player_score_box_update (_tmp17_, _tmp20_, _tmp23_);
			_g_object_unref0 (worm);
			_g_object_unref0 (box);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
}

void
scoreboard_clear (Scoreboard* self)
{
	GeeHashMap* _tmp12_;
	g_return_if_fail (self != NULL);
	{
		GeeIterator* _entry_it = NULL;
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->boxes;
		_tmp1_ = gee_abstract_map_get_entries ((GeeAbstractMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_entry_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			GeeMapEntry* entry = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GeeMapEntry* _tmp9_;
			gconstpointer _tmp10_;
			gconstpointer _tmp11_;
			_tmp6_ = _entry_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _entry_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			entry = (GeeMapEntry*) _tmp8_;
			_tmp9_ = entry;
			_tmp10_ = gee_map_entry_get_key (_tmp9_);
			_tmp11_ = _tmp10_;
			gtk_box_remove ((GtkBox*) self, (GtkWidget*) ((PlayerScoreBox*) _tmp11_));
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	_tmp12_ = self->priv->boxes;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp12_);
}

Scoreboard*
scoreboard_construct (GType object_type)
{
	Scoreboard * self = NULL;
	self = (Scoreboard*) g_object_new (object_type, NULL);
	return self;
}

Scoreboard*
scoreboard_new (void)
{
	return scoreboard_construct (TYPE_SCOREBOARD);
}

static void
scoreboard_class_init (ScoreboardClass * klass,
                       gpointer klass_data)
{
	scoreboard_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Scoreboard_private_offset);
	G_OBJECT_CLASS (klass)->finalize = scoreboard_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/scoreboard.ui");
}

static void
scoreboard_instance_init (Scoreboard * self,
                          gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = scoreboard_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (TYPE_PLAYER_SCORE_BOX, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->boxes = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
scoreboard_finalize (GObject * obj)
{
	Scoreboard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCOREBOARD, Scoreboard);
	_g_object_unref0 (self->priv->boxes);
	G_OBJECT_CLASS (scoreboard_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scoreboard_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScoreboardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scoreboard_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Scoreboard), 0, (GInstanceInitFunc) scoreboard_instance_init, NULL };
	GType scoreboard_type_id;
	scoreboard_type_id = g_type_register_static (gtk_box_get_type (), "Scoreboard", &g_define_type_info, 0);
	Scoreboard_private_offset = g_type_add_instance_private (scoreboard_type_id, sizeof (ScoreboardPrivate));
	return scoreboard_type_id;
}

GType
scoreboard_get_type (void)
{
	static gsize scoreboard_type_id__once = 0;
	if (g_once_init_enter (&scoreboard_type_id__once)) {
		GType scoreboard_type_id;
		scoreboard_type_id = scoreboard_get_type_once ();
		g_once_init_leave (&scoreboard_type_id__once, scoreboard_type_id);
	}
	return scoreboard_type_id__once;
}

static inline gpointer
player_score_box_get_instance_private (PlayerScoreBox* self)
{
	return G_STRUCT_MEMBER_P (self, PlayerScoreBox_private_offset);
}

PlayerScoreBox*
player_score_box_construct (GType object_type,
                            const gchar* name,
                            PangoColor* color,
                            gint score,
                            guint8 lives_left,
                            GtkImage* _life)
{
	PlayerScoreBox * self = NULL;
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkLabel* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (color != NULL, NULL);
	g_return_val_if_fail (_life != NULL, NULL);
	self = (PlayerScoreBox*) g_object_new (object_type, NULL);
	_tmp0_ = self->priv->name_label;
	_tmp1_ = pango_color_to_string (color);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("<span color=\"", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\">", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, name, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, "</span>", NULL);
	_tmp10_ = _tmp9_;
	gtk_label_set_markup (_tmp0_, _tmp10_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp11_ = self->priv->score_label;
	_tmp12_ = g_strdup_printf ("%i", score);
	_tmp13_ = _tmp12_;
	gtk_label_set_label (_tmp11_, _tmp13_);
	_g_free0 (_tmp13_);
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				GtkImage* life = NULL;
				GdkPaintable* _tmp16_;
				GtkImage* _tmp17_;
				GeeLinkedList* _tmp19_;
				GtkImage* _tmp20_;
				GtkGrid* _tmp21_;
				GtkImage* _tmp22_;
				if (!_tmp14_) {
					guint8 _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				if (!(i < WORM_MAX_LIVES)) {
					break;
				}
				_tmp16_ = gtk_image_get_paintable (_life);
				_tmp17_ = (GtkImage*) gtk_image_new_from_paintable (_tmp16_);
				g_object_ref_sink (_tmp17_);
				life = _tmp17_;
				if (i >= WORM_STARTING_LIVES) {
					GtkImage* _tmp18_;
					_tmp18_ = life;
					gtk_widget_set_opacity ((GtkWidget*) _tmp18_, (gdouble) 0);
				}
				_tmp19_ = self->priv->life_images;
				_tmp20_ = life;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
				_tmp21_ = self->priv->lives_grid;
				_tmp22_ = life;
				gtk_grid_attach (_tmp21_, (GtkWidget*) _tmp22_, i % 6, i / 6, 1, 1);
				_g_object_unref0 (life);
			}
		}
	}
	return self;
}

PlayerScoreBox*
player_score_box_new (const gchar* name,
                      PangoColor* color,
                      gint score,
                      guint8 lives_left,
                      GtkImage* _life)
{
	return player_score_box_construct (TYPE_PLAYER_SCORE_BOX, name, color, score, lives_left, _life);
}

void
player_score_box_update (PlayerScoreBox* self,
                         gint score,
                         guint8 lives_left)
{
	g_return_if_fail (self != NULL);
	player_score_box_update_score (self, score);
	player_score_box_update_lives (self, lives_left);
}

inline void
player_score_box_update_score (PlayerScoreBox* self,
                               gint score)
{
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->score_label;
	_tmp1_ = g_strdup_printf ("%i", score);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
}

void
player_score_box_update_lives (PlayerScoreBox* self,
                               guint8 lives_left)
{
	g_return_if_fail (self != NULL);
	{
		guint8 i = 0U;
		GeeLinkedList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = self->priv->life_images;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		i = (guint8) _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GeeLinkedList* _tmp5_;
				gpointer _tmp6_;
				GtkImage* _tmp7_;
				if (!_tmp3_) {
					guint8 _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ - 1;
				}
				_tmp3_ = FALSE;
				if (!(i > lives_left)) {
					break;
				}
				_tmp5_ = self->priv->life_images;
				_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, i - 1);
				_tmp7_ = (GtkImage*) _tmp6_;
				gtk_widget_set_opacity ((GtkWidget*) _tmp7_, (gdouble) 0);
				_g_object_unref0 (_tmp7_);
			}
		}
	}
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				GeeLinkedList* _tmp10_;
				gpointer _tmp11_;
				GtkImage* _tmp12_;
				if (!_tmp8_) {
					guint8 _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp8_ = FALSE;
				if (!(i < lives_left)) {
					break;
				}
				_tmp10_ = self->priv->life_images;
				_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, (gint) i);
				_tmp12_ = (GtkImage*) _tmp11_;
				gtk_widget_set_opacity ((GtkWidget*) _tmp12_, (gdouble) 1);
				_g_object_unref0 (_tmp12_);
			}
		}
	}
}

static void
player_score_box_class_init (PlayerScoreBoxClass * klass,
                             gpointer klass_data)
{
	player_score_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PlayerScoreBox_private_offset);
	G_OBJECT_CLASS (klass)->finalize = player_score_box_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/player-score-box.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "score_label", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, score_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "lives_grid", FALSE, PlayerScoreBox_private_offset + G_STRUCT_OFFSET (PlayerScoreBoxPrivate, lives_grid));
}

static void
player_score_box_instance_init (PlayerScoreBox * self,
                                gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = player_score_box_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (gtk_image_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->life_images = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
player_score_box_finalize (GObject * obj)
{
	PlayerScoreBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLAYER_SCORE_BOX, PlayerScoreBox);
	_g_object_unref0 (self->priv->life_images);
	G_OBJECT_CLASS (player_score_box_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
player_score_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlayerScoreBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) player_score_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PlayerScoreBox), 0, (GInstanceInitFunc) player_score_box_instance_init, NULL };
	GType player_score_box_type_id;
	player_score_box_type_id = g_type_register_static (gtk_box_get_type (), "PlayerScoreBox", &g_define_type_info, 0);
	PlayerScoreBox_private_offset = g_type_add_instance_private (player_score_box_type_id, sizeof (PlayerScoreBoxPrivate));
	return player_score_box_type_id;
}

GType
player_score_box_get_type (void)
{
	static gsize player_score_box_type_id__once = 0;
	if (g_once_init_enter (&player_score_box_type_id__once)) {
		GType player_score_box_type_id;
		player_score_box_type_id = player_score_box_get_type_once ();
		g_once_init_leave (&player_score_box_type_id__once, player_score_box_type_id);
	}
	return player_score_box_type_id__once;
}

