/* nibbles-view.c generated by valac 0.56.16, the Vala compiler
 * generated from nibbles-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 * Copyright (C) 2023 Ben Corby <bcorby@new-ms.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't 
 * match them self.
 *
 * grep -ne '[^][)(_!$ "](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 *
 */
/* designed for Gtk 4, link with libgtk-4-dev or gtk4-devel */

#include <glib.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <pango/pangocairo.h>
#include <gobject/gvaluecollector.h>

#define NIBBLES_VIEW_WIDTH ((guint8) 92)
#define NIBBLES_VIEW_HEIGHT ((guint8) 66)
#define NIBBLES_VIEW_NUM_COLORS 6
#define NIBBLES_GAME_WARPCHAR 'W'
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef void (*YesNoResultFunction) (guint yes_no, gpointer user_data);
typedef gboolean (*NewGameDialogueActiveFunction) (YesNoResultFunction* function, gpointer* function_target, GDestroyNotify* function_target_destroy_notify, gpointer user_data);

#define TYPE_NIBBLES_VIEW (nibbles_view_get_type ())
#define NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_VIEW, NibblesView))
#define NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_VIEW, NibblesViewClass))
#define IS_NIBBLES_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_VIEW))
#define IS_NIBBLES_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_VIEW))
#define NIBBLES_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_VIEW, NibblesViewClass))

typedef struct _NibblesView NibblesView;
typedef struct _NibblesViewClass NibblesViewClass;
typedef struct _NibblesViewPrivate NibblesViewPrivate;

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
typedef gint (*NibblesViewCountdownActiveFunction) (gpointer user_data);
enum  {
	NIBBLES_VIEW_0_PROPERTY,
	NIBBLES_VIEW_NUM_PROPERTIES
};
static GParamSpec* nibbles_view_properties[NIBBLES_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block6Data Block6Data;

#define NIBBLES_VIEW_TYPE_VIEW3_D (nibbles_view_view3_d_get_type ())
#define NIBBLES_VIEW_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NIBBLES_VIEW_TYPE_VIEW3_D, NibblesViewView3D))
#define NIBBLES_VIEW_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NIBBLES_VIEW_TYPE_VIEW3_D, NibblesViewView3DClass))
#define NIBBLES_VIEW_IS_VIEW3_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NIBBLES_VIEW_TYPE_VIEW3_D))
#define NIBBLES_VIEW_IS_VIEW3_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NIBBLES_VIEW_TYPE_VIEW3_D))
#define NIBBLES_VIEW_VIEW3_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NIBBLES_VIEW_TYPE_VIEW3_D, NibblesViewView3DClass))

typedef struct _NibblesViewView3D NibblesViewView3D;
typedef struct _NibblesViewView3DClass NibblesViewView3DClass;

#define NIBBLES_VIEW_TYPE_POINT3_D (nibbles_view_point3_d_get_type ())
typedef struct _NibblesViewPoint3D NibblesViewPoint3D;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;
typedef struct _WormPrivate WormPrivate;

#define TYPE_WORM_POSITIONS (worm_positions_get_type ())
#define WORM_POSITIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_POSITIONS, WormPositions))
#define WORM_POSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_POSITIONS, WormPositionsClass))
#define IS_WORM_POSITIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_POSITIONS))
#define IS_WORM_POSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_POSITIONS))
#define WORM_POSITIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_POSITIONS, WormPositionsClass))

typedef struct _WormPositions WormPositions;
typedef struct _WormPositionsClass WormPositionsClass;

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
#define WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_PROPERTIES, WormProperties))
#define WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_PROPERTIES, WormPropertiesClass))
#define IS_WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_PROPERTIES))
#define IS_WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_PROPERTIES))
#define WORM_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_PROPERTIES, WormPropertiesClass))

typedef struct _WormProperties WormProperties;
typedef struct _WormPropertiesClass WormPropertiesClass;

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;
typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_EAST = WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_SOUTH = WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_WEST = WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP,
	WORM_DIRECTION_NORTH = WORM_DIRECTION_UP
} WormDirection;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())
typedef struct _NibblesGamePrivate NibblesGamePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _nibbles_view_view3_d_unref0(var) ((var == NULL) ? NULL : (var = (nibbles_view_view3_d_unref (var), NULL)))
typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;

#define TYPE_BONUS_TYPE (bonus_type_get_type ())
typedef struct _Block7Data Block7Data;
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _NibblesViewView3DPrivate NibblesViewView3DPrivate;
typedef struct _NibblesViewParamSpecView3D NibblesViewParamSpecView3D;

struct _NibblesView {
	GtkDrawingArea parent_instance;
	NibblesViewPrivate * priv;
};

struct _NibblesViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _NibblesViewPrivate {
	NibblesGame* game;
	NibblesViewCountdownActiveFunction countdown_active;
	gpointer countdown_active_target;
	GDestroyNotify countdown_active_target_destroy_notify;
	NewGameDialogueActiveFunction new_game_dialogue_active;
	gpointer new_game_dialogue_active_target;
	GDestroyNotify new_game_dialogue_active_target_destroy_notify;
	YesNoResultFunction result_function;
	gpointer result_function_target;
	GDestroyNotify result_function_target_destroy_notify;
	gdouble b0_x;
	gdouble b0_y;
	gdouble b0_width;
	gdouble b0_height;
	gdouble b1_x;
	gdouble b1_y;
	gdouble b1_width;
	gdouble b1_height;
	gboolean mouse_pressed;
	guint mouse_button;
	guint64 animate;
};

struct _Block6Data {
	int _ref_count_;
	NibblesView* self;
	NibblesGame* game;
	NibblesViewCountdownActiveFunction countdown_active;
	gpointer countdown_active_target;
	NewGameDialogueActiveFunction new_game_dialogue_active;
	gpointer new_game_dialogue_active_target;
};

struct _NibblesViewPoint3D {
	gdouble x;
	gdouble y;
	gdouble z;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gint rounds_to_stay_still;
	gboolean is_stopped;
	WormPositions* list;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Position {
	guint8 x;
	guint8 y;
};

struct _NibblesGame {
	GObject parent_instance;
	NibblesGamePrivate * priv;
	gint* board;
	gint board_length1;
	gint board_length2;
	gboolean added_keypress_handler;
};

struct _NibblesGameClass {
	GObjectClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	NibblesView* self;
	YesNoResultFunction result_function;
	gpointer result_function_target;
};

struct _NibblesViewView3D {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NibblesViewView3DPrivate * priv;
};

struct _NibblesViewView3DClass {
	GTypeClass parent_class;
	void (*finalize) (NibblesViewView3D *self);
};

struct _NibblesViewView3DPrivate {
	gdouble view_plain_y;
	gboolean has_view_plain_been_set;
	gdouble view_plain_z_height;
	gboolean has_view_plain_z_height_been_set;
	NibblesViewPoint3D view_point;
	gdouble x_scale;
	gdouble y_scale;
};

struct _NibblesViewParamSpecView3D {
	GParamSpec parent_instance;
};

static gint NibblesView_private_offset;
static gpointer nibbles_view_parent_class = NULL;
static gchar** nibbles_view_color_lookup;
static gint nibbles_view_color_lookup_length1;
static gint nibbles_view_color_lookup_length2;
static gchar** nibbles_view_color_lookup = NULL;
static gint nibbles_view_color_lookup_length1 = 0;
static gint nibbles_view_color_lookup_length2 = 0;
static gint NibblesViewView3D_private_offset;
static gpointer nibbles_view_view3_d_parent_class = NULL;

VALA_EXTERN void get_worm_rgb (gint color,
                   gboolean bright,
                   gdouble* r,
                   gdouble* g,
                   gdouble* b);
VALA_EXTERN void get_worm_pango_color (gint color,
                           gboolean bright,
                           PangoColor* c);
VALA_EXTERN GType nibbles_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesView, g_object_unref)
VALA_EXTERN GType nibbles_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesGame, g_object_unref)
VALA_EXTERN NibblesView* nibbles_view_new (NibblesGame* game,
                               NibblesViewCountdownActiveFunction countdown_active,
                               gpointer countdown_active_target,
                               NewGameDialogueActiveFunction new_game_dialogue_active,
                               gpointer new_game_dialogue_active_target);
VALA_EXTERN NibblesView* nibbles_view_construct (GType object_type,
                                     NibblesGame* game,
                                     NibblesViewCountdownActiveFunction countdown_active,
                                     gpointer countdown_active_target,
                                     NewGameDialogueActiveFunction new_game_dialogue_active,
                                     gpointer new_game_dialogue_active_target);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda16_ (NibblesView* self);
static void ___lambda16__gtk_widget_realize (GtkWidget* _sender,
                                      gpointer self);
static void __lambda17_ (NibblesView* self,
                  gint width,
                  gint height);
static void ___lambda17__gtk_drawing_area_resize (GtkDrawingArea* _sender,
                                           gint width,
                                           gint height,
                                           gpointer self);
static void __lambda18_ (Block6Data* _data6_,
                  GtkDrawingArea* area,
                  cairo_t* c,
                  gint width,
                  gint height);
VALA_EXTERN gboolean nibbles_game_get_three_dimensional_view (NibblesGame* self);
static gpointer nibbles_view_view3_d_ref (gpointer instance);
static void nibbles_view_view3_d_unref (gpointer instance);
static GParamSpec* nibbles_view_param_spec_view3_d (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags) G_GNUC_UNUSED ;
static void nibbles_view_value_set_view3_d (GValue* value,
                                     gpointer v_object) G_GNUC_UNUSED ;
static void nibbles_view_value_take_view3_d (GValue* value,
                                      gpointer v_object) G_GNUC_UNUSED ;
static gpointer nibbles_view_value_get_view3_d (const GValue* value) G_GNUC_UNUSED ;
static GType nibbles_view_view3_d_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesViewView3D, nibbles_view_view3_d_unref)
static NibblesViewView3D* nibbles_view_view3_d_new (void);
static NibblesViewView3D* nibbles_view_view3_d_construct (GType object_type);
static void nibbles_view_view3_d_set_view_plain (NibblesViewView3D* self,
                                          gdouble y);
static GType nibbles_view_point3_d_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static NibblesViewPoint3D* nibbles_view_point3_d_dup (const NibblesViewPoint3D* self);
static void nibbles_view_point3_d_free (NibblesViewPoint3D* self);
static void nibbles_view_view3_d_set_view_point (NibblesViewView3D* self,
                                          NibblesViewPoint3D* point,
                                          gdouble max_object_height);
static void nibbles_view_view3_d_set_scale_x (NibblesViewView3D* self,
                                       gdouble scale);
static void nibbles_view_view3_d_set_scale_y (NibblesViewView3D* self,
                                       gdouble scale);
static void nibbles_view_view3_d_to_view_plain (NibblesViewView3D* self,
                                         NibblesViewPoint3D* point,
                                         gdouble* x_at_plain,
                                         gdouble* z_at_plain);
VALA_EXTERN GType worm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Worm, g_object_unref)
VALA_EXTERN GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
VALA_EXTERN GType worm_positions_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormPositions, g_object_unref)
VALA_EXTERN gboolean worm_get_is_materialized (Worm* self);
static void _vala_array_add2 (Worm** * array,
                       gint* length,
                       gint* size,
                       Worm* value);
VALA_EXTERN GType bonus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Bonus, g_object_unref)
VALA_EXTERN GeeList* nibbles_game_get_bonuses (NibblesGame* self);
VALA_EXTERN guint8 bonus_get_x (Bonus* self);
VALA_EXTERN guint8 bonus_get_y (Bonus* self);
VALA_EXTERN GType worm_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormProperties, g_object_unref)
VALA_EXTERN GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
VALA_EXTERN gint worm_properties_get_color (WormProperties* self);
VALA_EXTERN gboolean worm_was_bonus_eaten_at_this_position (Worm* self,
                                                guint16 position);
static void nibbles_view_draw_sphere (NibblesView* self,
                               cairo_t* c,
                               NibblesViewView3D* v,
                               gint x,
                               gint y,
                               gdouble r,
                               gdouble g,
                               gdouble b,
                               gdouble size);
VALA_EXTERN GType position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Position* position_dup (const Position* self);
VALA_EXTERN void position_free (Position* self);
VALA_EXTERN void worm_get_head (Worm* self,
                    Position * result);
VALA_EXTERN GType worm_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN WormDirection worm_get_direction (Worm* self);
static void nibbles_view_draw_eyes_front (NibblesView* self,
                                   cairo_t* c,
                                   NibblesViewView3D* v,
                                   gint x,
                                   gint y,
                                   gboolean blink);
VALA_EXTERN gint worm_get_id (Worm* self);
static void nibbles_view_draw_eyes_right (NibblesView* self,
                                   cairo_t* c,
                                   NibblesViewView3D* v,
                                   gint x,
                                   gint y,
                                   gboolean blink);
static void nibbles_view_draw_eyes_left (NibblesView* self,
                                  cairo_t* c,
                                  NibblesViewView3D* v,
                                  gint x,
                                  gint y,
                                  gboolean blink);
static gdouble nibbles_view_view3_d_view_point_x (NibblesViewView3D* self);
static void nibbles_view_draw_oval (NibblesView* self,
                             cairo_t* C,
                             NibblesViewView3D* v,
                             NibblesViewPoint3D* a,
                             NibblesViewPoint3D* b,
                             NibblesViewPoint3D* c,
                             NibblesViewPoint3D* d);
static void nibbles_view_draw_3D_bonus (NibblesView* self,
                                 cairo_t* c,
                                 NibblesViewView3D* v,
                                 gint x,
                                 gint y,
                                 Bonus* bonus);
static gchar* nibbles_view_seconds_string (NibblesView* self,
                                    gint s);
static gdouble nibbles_view_view3_d_2D_diff (NibblesViewView3D* self,
                                      NibblesViewPoint3D* a,
                                      NibblesViewPoint3D* b);
static gint nibbles_view_calculate_font_size (NibblesView* self,
                                       cairo_t* C,
                                       const gchar* text,
                                       gint target_width,
                                       gdouble* width,
                                       gdouble* height);
static void nibbles_view_draw_text_font_size (NibblesView* self,
                                       cairo_t* C,
                                       gint x,
                                       gint y,
                                       const gchar* text,
                                       gint font_size);
VALA_EXTERN gint worm_get_length (Worm* self);
static void nibbles_view_draw_text_target_width (NibblesView* self,
                                          cairo_t* C,
                                          gint x,
                                          gint y,
                                          const gchar* text,
                                          gint target_width,
                                          gint color);
static gchar* nibbles_view_worm_name (NibblesView* self,
                               gint id);
static void nibbles_view_new_game_dialogue_draw (NibblesView* self,
                                          cairo_t* c,
                                          gdouble width,
                                          gdouble height,
                                          YesNoResultFunction result_function,
                                          gpointer result_function_target);
static void nibbles_view_draw_wall_segment (NibblesView* self,
                                     gint i,
                                     cairo_t* C,
                                     gint x,
                                     gint y,
                                     gint x_size,
                                     gint y_size);
VALA_EXTERN GType bonus_type_get_type (void) G_GNUC_CONST ;
static void nibbles_view_draw_bonus (NibblesView* self,
                              cairo_t* C,
                              gint x,
                              gint y,
                              gint x_size,
                              gint y_size,
                              BonusType type);
static void nibbles_view_draw_worm_segment (NibblesView* self,
                                     cairo_t* C,
                                     gint x,
                                     gint y,
                                     gint x_size,
                                     gint y_size,
                                     gint color,
                                     gboolean is_materialized,
                                     gboolean eaten_bonus);
static void _vala_array_add3 (gint* * array,
                       gint* length,
                       gint* size,
                       gint value);
VALA_EXTERN BonusType bonus_get_bonus_type (Bonus* self);
static void ___lambda18__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                              cairo_t* cr,
                                              gint width,
                                              gint height,
                                              gpointer self);
VALA_EXTERN void nibbles_view_connect_game_signals (NibblesView* self,
                                        NibblesGame* game);
VALA_EXTERN void nibbles_view_redraw (NibblesView* self,
                          gboolean AnimateStep);
static void _nibbles_view_redraw_nibbles_game_redraw (NibblesGame* _sender,
                                               gboolean animate,
                                               gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void nibbles_view_draw_dialogue (NibblesView* self,
                                 cairo_t* C,
                                 gdouble width,
                                 gdouble height,
                                 const gchar* text,
                                 gdouble* b0_x,
                                 gdouble* b0_y,
                                 gdouble* b0_width,
                                 gdouble* b0_height,
                                 gdouble* b1_x,
                                 gdouble* b1_y,
                                 gdouble* b1_width,
                                 gdouble* b1_height,
                                 gboolean draw_buttons);
static void __lambda19_ (NibblesView* self,
                  gdouble x,
                  gdouble y);
static void nibbles_view_yesno_position (NibblesView* self,
                                  gdouble x,
                                  gdouble y);
static void ___lambda19__gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                      gdouble x,
                                                      gdouble y,
                                                      gpointer self);
static void __lambda20_ (NibblesView* self,
                  gdouble x,
                  gdouble y);
static void ___lambda20__gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                     gdouble x,
                                                     gdouble y,
                                                     gpointer self);
static gboolean __lambda21_ (Block7Data* _data7_,
                      GdkEvent* event);
static gboolean ___lambda21__gtk_event_controller_legacy_event (GtkEventControllerLegacy* _sender,
                                                         GdkEvent* event,
                                                         gpointer self);
static void nibbles_view_mid_point (NibblesView* self,
                             NibblesViewPoint3D* a,
                             NibblesViewPoint3D* b,
                             NibblesViewPoint3D* result);
static void nibbles_view_draw_apple (NibblesView* self,
                              cairo_t* c,
                              NibblesViewView3D* v,
                              gdouble x,
                              gdouble y);
static void nibbles_view_draw_cherry (NibblesView* self,
                               cairo_t* c,
                               NibblesViewView3D* v,
                               gdouble x,
                               gdouble y);
static void nibbles_view_draw_banana (NibblesView* self,
                               cairo_t* c,
                               NibblesViewView3D* v,
                               gdouble x,
                               gdouble y);
static void nibbles_view_draw_heart (NibblesView* self,
                              cairo_t* c,
                              NibblesViewView3D* v,
                              gdouble x,
                              gdouble y);
static void nibbles_view_draw_diamond (NibblesView* self,
                                cairo_t* c,
                                NibblesViewView3D* v,
                                gdouble x,
                                gdouble y);
static void nibbles_view_set_color (NibblesView* self,
                             cairo_t* C,
                             gint color,
                             gboolean bright);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void nibbles_view_get_text_offsets (NibblesView* self,
                                    cairo_t* C,
                                    const gchar* text,
                                    gint font_size,
                                    gint* x_offset,
                                    gint* y_offset);
static void _vala_array_add4 (gdouble* * array,
                       gint* length,
                       gint* size,
                       gdouble value);
static void _vala_array_add5 (gdouble* * array,
                       gint* length,
                       gint* size,
                       gdouble value);
static void nibbles_view_draw_dialogue_text (NibblesView* self,
                                      cairo_t* C,
                                      gdouble x,
                                      gdouble y,
                                      const gchar* text,
                                      gint font_size);
static gint nibbles_view_calculate_font_size_from_max (NibblesView* self,
                                                cairo_t* C,
                                                const gchar* text,
                                                gint max_width,
                                                gint max_height,
                                                gdouble* width,
                                                gdouble* height);
VALA_EXTERN gchar* nibbles_view_colorval_name_untranslated (gint colorval);
VALA_EXTERN GtkImage* nibbles_view_load_image_file (const gchar* pixmap,
                                        gint xsize,
                                        gint ysize);
static void nibbles_view_view3_d_finalize (NibblesViewView3D * obj);
static GType nibbles_view_view3_d_get_type_once (void);
static void nibbles_view_finalize (GObject * obj);
static GType nibbles_view_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

void
get_worm_rgb (gint color,
              gboolean bright,
              gdouble* r,
              gdouble* g,
              gdouble* b)
{
	gdouble _vala_r = 0.0;
	gdouble _vala_g = 0.0;
	gdouble _vala_b = 0.0;
	switch (color) {
		case 0:
		{
			gdouble _tmp0_ = 0.0;
			if (bright) {
				_tmp0_ = (gdouble) 1;
			} else {
				_tmp0_ = 0.75;
			}
			_vala_r = _tmp0_;
			_vala_g = (gdouble) 0;
			_vala_b = (gdouble) 0;
			break;
		}
		case 1:
		{
			gdouble _tmp1_ = 0.0;
			_vala_r = (gdouble) 0;
			if (bright) {
				_tmp1_ = 0.75;
			} else {
				_tmp1_ = 0.5;
			}
			_vala_g = _tmp1_;
			_vala_b = (gdouble) 0;
			break;
		}
		case 2:
		{
			gdouble _tmp2_ = 0.0;
			gdouble _tmp3_ = 0.0;
			_vala_r = (gdouble) 0;
			if (bright) {
				_tmp2_ = 0.5;
			} else {
				_tmp2_ = 0.25;
			}
			_vala_g = _tmp2_;
			if (bright) {
				_tmp3_ = (gdouble) 1;
			} else {
				_tmp3_ = 0.75;
			}
			_vala_b = _tmp3_;
			break;
		}
		case 3:
		{
			gdouble _tmp4_ = 0.0;
			gdouble _tmp5_ = 0.0;
			if (bright) {
				_tmp4_ = 0.9;
			} else {
				_tmp4_ = 0.75;
			}
			_vala_r = _tmp4_;
			if (bright) {
				_tmp5_ = 0.9;
			} else {
				_tmp5_ = 0.75;
			}
			_vala_g = _tmp5_;
			_vala_b = (gdouble) 0;
			break;
		}
		case 4:
		{
			gdouble _tmp6_ = 0.0;
			gdouble _tmp7_ = 0.0;
			_vala_r = (gdouble) 0;
			if (bright) {
				_tmp6_ = (gdouble) 1;
			} else {
				_tmp6_ = 0.75;
			}
			_vala_g = _tmp6_;
			if (bright) {
				_tmp7_ = (gdouble) 1;
			} else {
				_tmp7_ = 0.75;
			}
			_vala_b = _tmp7_;
			break;
		}
		case 5:
		{
			gdouble _tmp8_ = 0.0;
			gdouble _tmp9_ = 0.0;
			if (bright) {
				_tmp8_ = 0.75;
			} else {
				_tmp8_ = 0.5;
			}
			_vala_r = _tmp8_;
			_vala_g = (gdouble) 0;
			if (bright) {
				_tmp9_ = 0.75;
			} else {
				_tmp9_ = 0.5;
			}
			_vala_b = _tmp9_;
			break;
		}
		default:
		{
			gdouble _tmp10_ = 0.0;
			gdouble _tmp11_ = 0.0;
			gdouble _tmp12_ = 0.0;
			if (bright) {
				_tmp10_ = (gdouble) 1;
			} else {
				_tmp10_ = 0.75;
			}
			_vala_r = _tmp10_;
			if (bright) {
				_tmp11_ = (gdouble) 1;
			} else {
				_tmp11_ = 0.75;
			}
			_vala_g = _tmp11_;
			if (bright) {
				_tmp12_ = (gdouble) 1;
			} else {
				_tmp12_ = 0.75;
			}
			_vala_b = _tmp12_;
			break;
		}
	}
	if (r) {
		*r = _vala_r;
	}
	if (g) {
		*g = _vala_g;
	}
	if (b) {
		*b = _vala_b;
	}
}

void
get_worm_pango_color (gint color,
                      gboolean bright,
                      PangoColor* c)
{
	gdouble r = 0.0;
	gdouble g = 0.0;
	gdouble b = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	g_return_if_fail (c != NULL);
	get_worm_rgb (color, bright, &_tmp0_, &_tmp1_, &_tmp2_);
	r = _tmp0_;
	g = _tmp1_;
	b = _tmp2_;
	(*c).red = (guint16) (r * 0xffff);
	(*c).green = (guint16) (g * 0xffff);
	(*c).blue = (guint16) (b * 0xffff);
}

static inline gpointer
nibbles_view_get_instance_private (NibblesView* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		NibblesView* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->game);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}

static void
__lambda16_ (NibblesView* self)
{
}

static void
___lambda16__gtk_widget_realize (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda16_ ((NibblesView*) self);
}

static void
__lambda17_ (NibblesView* self,
             gint width,
             gint height)
{
}

static void
___lambda17__gtk_drawing_area_resize (GtkDrawingArea* _sender,
                                      gint width,
                                      gint height,
                                      gpointer self)
{
	__lambda17_ ((NibblesView*) self, width, height);
}

static void
_vala_array_add2 (Worm** * array,
                  gint* length,
                  gint* size,
                  Worm* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Worm*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gint* * array,
                  gint* length,
                  gint* size,
                  gint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
__lambda18_ (Block6Data* _data6_,
             GtkDrawingArea* area,
             cairo_t* c,
             gint width,
             gint height)
{
	NibblesView* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data6_->self;
	g_return_if_fail (area != NULL);
	g_return_if_fail (c != NULL);
	_tmp0_ = nibbles_game_get_three_dimensional_view (_data6_->game);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gdouble x2d = 0.0;
		gdouble y2d = 0.0;
		gdouble r = 0.0;
		gdouble g = 0.0;
		gdouble b = 0.0;
		NibblesViewView3D* v = NULL;
		NibblesViewView3D* _tmp2_;
		NibblesViewView3D* _tmp3_;
		NibblesViewView3D* _tmp4_;
		NibblesViewPoint3D _tmp5_ = {0};
		NibblesViewView3D* _tmp6_;
		NibblesViewView3D* _tmp7_;
		NibblesViewView3D* _tmp8_;
		NibblesViewPoint3D _tmp9_ = {0};
		gdouble _tmp10_ = 0.0;
		gdouble _tmp11_ = 0.0;
		NibblesViewView3D* _tmp12_;
		NibblesViewPoint3D _tmp13_ = {0};
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
		NibblesViewView3D* _tmp16_;
		NibblesViewPoint3D _tmp17_ = {0};
		gdouble _tmp18_ = 0.0;
		gdouble _tmp19_ = 0.0;
		NibblesViewView3D* _tmp20_;
		NibblesViewPoint3D _tmp21_ = {0};
		gdouble _tmp22_ = 0.0;
		gdouble _tmp23_ = 0.0;
		Worm** dematerialized_worms = NULL;
		Worm** _tmp24_;
		gint dematerialized_worms_length1;
		gint _dematerialized_worms_size_;
		Worm** worm_at = NULL;
		Worm** _tmp25_;
		gint worm_at_length1;
		gint worm_at_length2;
		Worm** _tmp53_;
		gint _tmp53__length1;
		Bonus** bonus_at = NULL;
		Bonus** _tmp69_;
		gint bonus_at_length1;
		gint bonus_at_length2;
		YesNoResultFunction _tmp377_ = NULL;
		gpointer _tmp378_ = NULL;
		GDestroyNotify _tmp379_ = NULL;
		gboolean _tmp380_;
		_tmp2_ = nibbles_view_view3_d_new ();
		v = _tmp2_;
		_tmp3_ = v;
		nibbles_view_view3_d_set_view_plain (_tmp3_, (gdouble) NIBBLES_VIEW_HEIGHT);
		_tmp4_ = v;
		_tmp5_.x = ((gdouble) NIBBLES_VIEW_WIDTH) / 2.0;
		_tmp5_.y = 2.0 * ((gdouble) NIBBLES_VIEW_HEIGHT);
		_tmp5_.z = 2.0 * ((gdouble) NIBBLES_VIEW_HEIGHT);
		nibbles_view_view3_d_set_view_point (_tmp4_, &_tmp5_, (gdouble) 1);
		_tmp6_ = v;
		nibbles_view_view3_d_set_scale_x (_tmp6_, (gdouble) (width / NIBBLES_VIEW_WIDTH));
		_tmp7_ = v;
		nibbles_view_view3_d_set_scale_y (_tmp7_, (gdouble) (height / NIBBLES_VIEW_HEIGHT));
		_tmp8_ = v;
		_tmp9_.x = (gdouble) 0;
		_tmp9_.y = (gdouble) 0;
		_tmp9_.z = (gdouble) 0;
		nibbles_view_view3_d_to_view_plain (_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
		x2d = _tmp10_;
		y2d = _tmp11_;
		cairo_move_to (c, x2d, y2d);
		_tmp12_ = v;
		_tmp13_.x = (gdouble) NIBBLES_VIEW_WIDTH;
		_tmp13_.y = (gdouble) 0;
		_tmp13_.z = (gdouble) 0;
		nibbles_view_view3_d_to_view_plain (_tmp12_, &_tmp13_, &_tmp14_, &_tmp15_);
		x2d = _tmp14_;
		y2d = _tmp15_;
		cairo_line_to (c, x2d, y2d);
		_tmp16_ = v;
		_tmp17_.x = (gdouble) NIBBLES_VIEW_WIDTH;
		_tmp17_.y = (gdouble) NIBBLES_VIEW_HEIGHT;
		_tmp17_.z = (gdouble) 0;
		nibbles_view_view3_d_to_view_plain (_tmp16_, &_tmp17_, &_tmp18_, &_tmp19_);
		x2d = _tmp18_;
		y2d = _tmp19_;
		cairo_line_to (c, x2d, y2d);
		_tmp20_ = v;
		_tmp21_.x = (gdouble) 0;
		_tmp21_.y = (gdouble) NIBBLES_VIEW_HEIGHT;
		_tmp21_.z = (gdouble) 0;
		nibbles_view_view3_d_to_view_plain (_tmp20_, &_tmp21_, &_tmp22_, &_tmp23_);
		x2d = _tmp22_;
		y2d = _tmp23_;
		cairo_line_to (c, x2d, y2d);
		cairo_set_source_rgb (c, (gdouble) 0, (gdouble) 0, (gdouble) 0);
		cairo_fill (c);
		_tmp24_ = g_new0 (Worm*, 0 + 1);
		dematerialized_worms = _tmp24_;
		dematerialized_worms_length1 = 0;
		_dematerialized_worms_size_ = dematerialized_worms_length1;
		_tmp25_ = g_new0 (Worm*, (NIBBLES_VIEW_WIDTH * NIBBLES_VIEW_HEIGHT) + 1);
		worm_at = _tmp25_;
		worm_at_length1 = NIBBLES_VIEW_WIDTH;
		worm_at_length2 = NIBBLES_VIEW_HEIGHT;
		{
			GeeLinkedList* _worm_list = NULL;
			GeeLinkedList* _tmp26_;
			GeeLinkedList* _tmp27_;
			gint _worm_size = 0;
			GeeLinkedList* _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gint _worm_index = 0;
			_tmp26_ = nibbles_game_get_worms (_data6_->game);
			_tmp27_ = _tmp26_;
			_worm_list = _tmp27_;
			_tmp28_ = _worm_list;
			_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
			_tmp30_ = _tmp29_;
			_worm_size = _tmp30_;
			_worm_index = -1;
			while (TRUE) {
				gint _tmp31_;
				gint _tmp32_;
				Worm* worm = NULL;
				GeeLinkedList* _tmp33_;
				gpointer _tmp34_;
				Worm* _tmp35_;
				_worm_index = _worm_index + 1;
				_tmp31_ = _worm_index;
				_tmp32_ = _worm_size;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = _worm_list;
				_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _worm_index);
				worm = (Worm*) _tmp34_;
				_tmp35_ = worm;
				if (!_tmp35_->is_stopped) {
					Worm* _tmp36_;
					gboolean _tmp37_;
					gboolean _tmp38_;
					_tmp36_ = worm;
					_tmp37_ = worm_get_is_materialized (_tmp36_);
					_tmp38_ = _tmp37_;
					if (_tmp38_) {
						{
							WormPositions* _p_list = NULL;
							Worm* _tmp39_;
							WormPositions* _tmp40_;
							gint _p_size = 0;
							WormPositions* _tmp41_;
							gint _tmp42_;
							gint _tmp43_;
							gint _p_index = 0;
							_tmp39_ = worm;
							_tmp40_ = _tmp39_->list;
							_p_list = _tmp40_;
							_tmp41_ = _p_list;
							_tmp42_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp41_);
							_tmp43_ = _tmp42_;
							_p_size = _tmp43_;
							_p_index = -1;
							while (TRUE) {
								gint _tmp44_;
								gint _tmp45_;
								guint16 p = 0U;
								WormPositions* _tmp46_;
								gpointer _tmp47_;
								Worm** _tmp48_;
								gint _tmp48__length1;
								gint _tmp48__length2;
								Worm* _tmp49_;
								Worm* _tmp50_;
								_p_index = _p_index + 1;
								_tmp44_ = _p_index;
								_tmp45_ = _p_size;
								if (!(_tmp44_ < _tmp45_)) {
									break;
								}
								_tmp46_ = _p_list;
								_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp46_, _p_index);
								p = (guint16) ((guintptr) _tmp47_);
								_tmp48_ = worm_at;
								_tmp48__length1 = worm_at_length1;
								_tmp48__length2 = worm_at_length2;
								_tmp49_ = worm;
								_tmp50_ = _g_object_ref0 (_tmp49_);
								_g_object_unref0 (_tmp48_[((p >> 8) * _tmp48__length2) + ((guint8) p)]);
								_tmp48_[((p >> 8) * _tmp48__length2) + ((guint8) p)] = _tmp50_;
							}
						}
					} else {
						Worm* _tmp51_;
						Worm* _tmp52_;
						_tmp51_ = worm;
						_tmp52_ = _g_object_ref0 (_tmp51_);
						_vala_array_add2 (&dematerialized_worms, &dematerialized_worms_length1, &_dematerialized_worms_size_, _tmp52_);
					}
				}
				_g_object_unref0 (worm);
			}
		}
		_tmp53_ = dematerialized_worms;
		_tmp53__length1 = dematerialized_worms_length1;
		{
			Worm** worm_collection = NULL;
			gint worm_collection_length1 = 0;
			gint _worm_collection_size_ = 0;
			gint worm_it = 0;
			worm_collection = _tmp53_;
			worm_collection_length1 = _tmp53__length1;
			for (worm_it = 0; worm_it < worm_collection_length1; worm_it = worm_it + 1) {
				Worm* _tmp54_;
				Worm* worm = NULL;
				_tmp54_ = _g_object_ref0 (worm_collection[worm_it]);
				worm = _tmp54_;
				{
					{
						WormPositions* _p_list = NULL;
						Worm* _tmp55_;
						WormPositions* _tmp56_;
						gint _p_size = 0;
						WormPositions* _tmp57_;
						gint _tmp58_;
						gint _tmp59_;
						gint _p_index = 0;
						_tmp55_ = worm;
						_tmp56_ = _tmp55_->list;
						_p_list = _tmp56_;
						_tmp57_ = _p_list;
						_tmp58_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp57_);
						_tmp59_ = _tmp58_;
						_p_size = _tmp59_;
						_p_index = -1;
						while (TRUE) {
							gint _tmp60_;
							gint _tmp61_;
							guint16 p = 0U;
							WormPositions* _tmp62_;
							gpointer _tmp63_;
							Worm** _tmp64_;
							gint _tmp64__length1;
							gint _tmp64__length2;
							Worm* _tmp65_;
							_p_index = _p_index + 1;
							_tmp60_ = _p_index;
							_tmp61_ = _p_size;
							if (!(_tmp60_ < _tmp61_)) {
								break;
							}
							_tmp62_ = _p_list;
							_tmp63_ = gee_abstract_list_get ((GeeAbstractList*) _tmp62_, _p_index);
							p = (guint16) ((guintptr) _tmp63_);
							_tmp64_ = worm_at;
							_tmp64__length1 = worm_at_length1;
							_tmp64__length2 = worm_at_length2;
							_tmp65_ = _tmp64_[((p >> 8) * _tmp64__length2) + ((guint8) p)];
							if (_tmp65_ == NULL) {
								Worm** _tmp66_;
								gint _tmp66__length1;
								gint _tmp66__length2;
								Worm* _tmp67_;
								Worm* _tmp68_;
								_tmp66_ = worm_at;
								_tmp66__length1 = worm_at_length1;
								_tmp66__length2 = worm_at_length2;
								_tmp67_ = worm;
								_tmp68_ = _g_object_ref0 (_tmp67_);
								_g_object_unref0 (_tmp66_[((p >> 8) * _tmp66__length2) + ((guint8) p)]);
								_tmp66_[((p >> 8) * _tmp66__length2) + ((guint8) p)] = _tmp68_;
							}
						}
					}
					_g_object_unref0 (worm);
				}
			}
		}
		_tmp69_ = g_new0 (Bonus*, (NIBBLES_VIEW_WIDTH * NIBBLES_VIEW_HEIGHT) + 1);
		bonus_at = _tmp69_;
		bonus_at_length1 = NIBBLES_VIEW_WIDTH;
		bonus_at_length2 = NIBBLES_VIEW_HEIGHT;
		{
			GeeList* _bonus_list = NULL;
			GeeList* _tmp70_;
			gint _bonus_size = 0;
			GeeList* _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			gint _bonus_index = 0;
			_tmp70_ = nibbles_game_get_bonuses (_data6_->game);
			_bonus_list = _tmp70_;
			_tmp71_ = _bonus_list;
			_tmp72_ = gee_collection_get_size ((GeeCollection*) _tmp71_);
			_tmp73_ = _tmp72_;
			_bonus_size = _tmp73_;
			_bonus_index = -1;
			while (TRUE) {
				gint _tmp74_;
				gint _tmp75_;
				Bonus* bonus = NULL;
				GeeList* _tmp76_;
				gpointer _tmp77_;
				Bonus** _tmp78_;
				gint _tmp78__length1;
				gint _tmp78__length2;
				Bonus* _tmp79_;
				guint8 _tmp80_;
				guint8 _tmp81_;
				Bonus* _tmp82_;
				guint8 _tmp83_;
				guint8 _tmp84_;
				Bonus* _tmp85_;
				Bonus* _tmp86_;
				_bonus_index = _bonus_index + 1;
				_tmp74_ = _bonus_index;
				_tmp75_ = _bonus_size;
				if (!(_tmp74_ < _tmp75_)) {
					break;
				}
				_tmp76_ = _bonus_list;
				_tmp77_ = gee_list_get (_tmp76_, _bonus_index);
				bonus = (Bonus*) _tmp77_;
				_tmp78_ = bonus_at;
				_tmp78__length1 = bonus_at_length1;
				_tmp78__length2 = bonus_at_length2;
				_tmp79_ = bonus;
				_tmp80_ = bonus_get_x (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = bonus;
				_tmp83_ = bonus_get_y (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp85_ = bonus;
				_tmp86_ = _g_object_ref0 (_tmp85_);
				_g_object_unref0 (_tmp78_[(_tmp81_ * _tmp78__length2) + _tmp84_]);
				_tmp78_[(_tmp81_ * _tmp78__length2) + _tmp84_] = _tmp86_;
				_g_object_unref0 (bonus);
			}
			_g_object_unref0 (_bonus_list);
		}
		{
			gint y = 0;
			y = 0;
			{
				gboolean _tmp87_ = FALSE;
				_tmp87_ = TRUE;
				while (TRUE) {
					if (!_tmp87_) {
						gint _tmp88_;
						_tmp88_ = y;
						y = _tmp88_ + 1;
					}
					_tmp87_ = FALSE;
					if (!(y < ((gint) NIBBLES_VIEW_HEIGHT))) {
						break;
					}
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp89_ = FALSE;
							_tmp89_ = TRUE;
							while (TRUE) {
								Worm** _tmp91_;
								gint _tmp91__length1;
								gint _tmp91__length2;
								Worm* _tmp92_;
								gboolean _tmp136_ = FALSE;
								gint* _tmp137_;
								gint _tmp137__length1;
								gint _tmp137__length2;
								gint _tmp138_;
								gboolean _tmp219_ = FALSE;
								gboolean _tmp220_ = FALSE;
								gboolean _tmp221_ = FALSE;
								gint* _tmp222_;
								gint _tmp222__length1;
								gint _tmp222__length2;
								gint _tmp223_;
								Bonus** _tmp253_;
								gint _tmp253__length1;
								gint _tmp253__length2;
								Bonus* _tmp254_;
								if (!_tmp89_) {
									gint _tmp90_ = 0;
									if (x < (NIBBLES_VIEW_WIDTH / 2)) {
										_tmp90_ = (NIBBLES_VIEW_WIDTH - 1) - x;
									} else {
										_tmp90_ = NIBBLES_VIEW_WIDTH - x;
									}
									x = _tmp90_;
								}
								_tmp89_ = FALSE;
								_tmp91_ = worm_at;
								_tmp91__length1 = worm_at_length1;
								_tmp91__length2 = worm_at_length2;
								_tmp92_ = _tmp91_[(x * _tmp91__length2) + y];
								if (_tmp92_ != NULL) {
									GeeHashMap* _tmp93_;
									GeeHashMap* _tmp94_;
									Worm** _tmp95_;
									gint _tmp95__length1;
									gint _tmp95__length2;
									Worm* _tmp96_;
									gpointer _tmp97_;
									WormProperties* _tmp98_;
									gint _tmp99_;
									gint _tmp100_;
									gdouble _tmp101_ = 0.0;
									gdouble _tmp102_ = 0.0;
									gdouble _tmp103_ = 0.0;
									Worm** _tmp104_;
									gint _tmp104__length1;
									gint _tmp104__length2;
									Worm* _tmp105_;
									gdouble _tmp106_ = 0.0;
									Worm** _tmp107_;
									gint _tmp107__length1;
									gint _tmp107__length2;
									Worm* _tmp108_;
									NibblesViewView3D* _tmp109_;
									Position head = {0};
									Worm** _tmp110_;
									gint _tmp110__length1;
									gint _tmp110__length2;
									Worm* _tmp111_;
									Position _tmp112_ = {0};
									Position _tmp113_;
									gboolean _tmp114_ = FALSE;
									Position _tmp115_;
									_tmp93_ = nibbles_game_get_worm_props (_data6_->game);
									_tmp94_ = _tmp93_;
									_tmp95_ = worm_at;
									_tmp95__length1 = worm_at_length1;
									_tmp95__length2 = worm_at_length2;
									_tmp96_ = _tmp95_[(x * _tmp95__length2) + y];
									_tmp97_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp94_, _tmp96_);
									_tmp98_ = (WormProperties*) _tmp97_;
									_tmp99_ = worm_properties_get_color (_tmp98_);
									_tmp100_ = _tmp99_;
									get_worm_rgb (_tmp100_, TRUE, &_tmp101_, &_tmp102_, &_tmp103_);
									r = _tmp101_;
									g = _tmp102_;
									b = _tmp103_;
									_g_object_unref0 (_tmp98_);
									_tmp104_ = worm_at;
									_tmp104__length1 = worm_at_length1;
									_tmp104__length2 = worm_at_length2;
									_tmp105_ = _tmp104_[(x * _tmp104__length2) + y];
									worm_was_bonus_eaten_at_this_position (_tmp105_, (guint16) ((x << 8) | y));
									_tmp107_ = worm_at;
									_tmp107__length1 = worm_at_length1;
									_tmp107__length2 = worm_at_length2;
									_tmp108_ = _tmp107_[(x * _tmp107__length2) + y];
									if (worm_was_bonus_eaten_at_this_position (_tmp108_, (guint16) ((x << 8) | y))) {
										_tmp106_ = 1.25;
									} else {
										_tmp106_ = (gdouble) 1;
									}
									_tmp109_ = v;
									nibbles_view_draw_sphere (self, c, _tmp109_, x, y, r, g, b, _tmp106_);
									_tmp110_ = worm_at;
									_tmp110__length1 = worm_at_length1;
									_tmp110__length2 = worm_at_length2;
									_tmp111_ = _tmp110_[(x * _tmp110__length2) + y];
									worm_get_head (_tmp111_, &_tmp112_);
									_tmp113_ = _tmp112_;
									head = _tmp113_;
									_tmp115_ = head;
									if (((gint) _tmp115_.x) == x) {
										Position _tmp116_;
										_tmp116_ = head;
										_tmp114_ = ((gint) _tmp116_.y) == y;
									} else {
										_tmp114_ = FALSE;
									}
									if (_tmp114_) {
										Worm** _tmp117_;
										gint _tmp117__length1;
										gint _tmp117__length2;
										Worm* _tmp118_;
										WormDirection _tmp119_;
										WormDirection _tmp120_;
										_tmp117_ = worm_at;
										_tmp117__length1 = worm_at_length1;
										_tmp117__length2 = worm_at_length2;
										_tmp118_ = _tmp117_[(x * _tmp117__length2) + y];
										_tmp119_ = worm_get_direction (_tmp118_);
										_tmp120_ = _tmp119_;
										switch (_tmp120_) {
											case WORM_DIRECTION_SOUTH:
											{
												NibblesViewView3D* _tmp121_;
												Worm** _tmp122_;
												gint _tmp122__length1;
												gint _tmp122__length2;
												Worm* _tmp123_;
												gint _tmp124_;
												gint _tmp125_;
												_tmp121_ = v;
												_tmp122_ = worm_at;
												_tmp122__length1 = worm_at_length1;
												_tmp122__length2 = worm_at_length2;
												_tmp123_ = _tmp122_[(x * _tmp122__length2) + y];
												_tmp124_ = worm_get_id (_tmp123_);
												_tmp125_ = _tmp124_;
												nibbles_view_draw_eyes_front (self, c, _tmp121_, x, y, ((self->priv->animate % 30) / 5) == ((guint64) _tmp125_));
												break;
											}
											case WORM_DIRECTION_EAST:
											{
												NibblesViewView3D* _tmp126_;
												Worm** _tmp127_;
												gint _tmp127__length1;
												gint _tmp127__length2;
												Worm* _tmp128_;
												gint _tmp129_;
												gint _tmp130_;
												_tmp126_ = v;
												_tmp127_ = worm_at;
												_tmp127__length1 = worm_at_length1;
												_tmp127__length2 = worm_at_length2;
												_tmp128_ = _tmp127_[(x * _tmp127__length2) + y];
												_tmp129_ = worm_get_id (_tmp128_);
												_tmp130_ = _tmp129_;
												nibbles_view_draw_eyes_right (self, c, _tmp126_, x, y, ((self->priv->animate % 30) / 5) == ((guint64) _tmp130_));
												break;
											}
											case WORM_DIRECTION_WEST:
											{
												NibblesViewView3D* _tmp131_;
												Worm** _tmp132_;
												gint _tmp132__length1;
												gint _tmp132__length2;
												Worm* _tmp133_;
												gint _tmp134_;
												gint _tmp135_;
												_tmp131_ = v;
												_tmp132_ = worm_at;
												_tmp132__length1 = worm_at_length1;
												_tmp132__length2 = worm_at_length2;
												_tmp133_ = _tmp132_[(x * _tmp132__length2) + y];
												_tmp134_ = worm_get_id (_tmp133_);
												_tmp135_ = _tmp134_;
												nibbles_view_draw_eyes_left (self, c, _tmp131_, x, y, ((self->priv->animate % 30) / 5) == ((guint64) _tmp135_));
												break;
											}
											default:
											{
												break;
											}
										}
									}
								}
								_tmp137_ = _data6_->game->board;
								_tmp137__length1 = _data6_->game->board_length1;
								_tmp137__length2 = _data6_->game->board_length2;
								_tmp138_ = _tmp137_[(x * _tmp137__length2) + y];
								if (_tmp138_ >= ((gint) 'b')) {
									gint* _tmp139_;
									gint _tmp139__length1;
									gint _tmp139__length2;
									gint _tmp140_;
									_tmp139_ = _data6_->game->board;
									_tmp139__length1 = _data6_->game->board_length1;
									_tmp139__length2 = _data6_->game->board_length2;
									_tmp140_ = _tmp139_[(x * _tmp139__length2) + y];
									_tmp136_ = _tmp140_ <= ((gint) 'l');
								} else {
									_tmp136_ = FALSE;
								}
								if (_tmp136_) {
									NibblesViewView3D* _tmp141_;
									NibblesViewPoint3D _tmp142_ = {0};
									gdouble _tmp143_ = 0.0;
									gdouble _tmp144_ = 0.0;
									NibblesViewView3D* _tmp145_;
									NibblesViewPoint3D _tmp146_ = {0};
									gdouble _tmp147_ = 0.0;
									gdouble _tmp148_ = 0.0;
									NibblesViewView3D* _tmp149_;
									NibblesViewPoint3D _tmp150_ = {0};
									gdouble _tmp151_ = 0.0;
									gdouble _tmp152_ = 0.0;
									NibblesViewView3D* _tmp153_;
									NibblesViewPoint3D _tmp154_ = {0};
									gdouble _tmp155_ = 0.0;
									gdouble _tmp156_ = 0.0;
									gboolean _tmp157_ = FALSE;
									NibblesViewView3D* _tmp158_;
									NibblesViewView3D* _tmp203_;
									NibblesViewPoint3D _tmp204_ = {0};
									gdouble _tmp205_ = 0.0;
									gdouble _tmp206_ = 0.0;
									NibblesViewView3D* _tmp207_;
									NibblesViewPoint3D _tmp208_ = {0};
									gdouble _tmp209_ = 0.0;
									gdouble _tmp210_ = 0.0;
									NibblesViewView3D* _tmp211_;
									NibblesViewPoint3D _tmp212_ = {0};
									gdouble _tmp213_ = 0.0;
									gdouble _tmp214_ = 0.0;
									NibblesViewView3D* _tmp215_;
									NibblesViewPoint3D _tmp216_ = {0};
									gdouble _tmp217_ = 0.0;
									gdouble _tmp218_ = 0.0;
									_tmp141_ = v;
									_tmp142_.x = (gdouble) x;
									_tmp142_.y = (gdouble) y;
									_tmp142_.z = (gdouble) 1;
									nibbles_view_view3_d_to_view_plain (_tmp141_, &_tmp142_, &_tmp143_, &_tmp144_);
									x2d = _tmp143_;
									y2d = _tmp144_;
									cairo_move_to (c, x2d, y2d);
									_tmp145_ = v;
									_tmp146_.x = (gdouble) (x + 1);
									_tmp146_.y = (gdouble) y;
									_tmp146_.z = (gdouble) 1;
									nibbles_view_view3_d_to_view_plain (_tmp145_, &_tmp146_, &_tmp147_, &_tmp148_);
									x2d = _tmp147_;
									y2d = _tmp148_;
									cairo_line_to (c, x2d, y2d);
									_tmp149_ = v;
									_tmp150_.x = (gdouble) (x + 1);
									_tmp150_.y = (gdouble) (y + 1);
									_tmp150_.z = (gdouble) 1;
									nibbles_view_view3_d_to_view_plain (_tmp149_, &_tmp150_, &_tmp151_, &_tmp152_);
									x2d = _tmp151_;
									y2d = _tmp152_;
									cairo_line_to (c, x2d, y2d);
									_tmp153_ = v;
									_tmp154_.x = (gdouble) x;
									_tmp154_.y = (gdouble) (y + 1);
									_tmp154_.z = (gdouble) 1;
									nibbles_view_view3_d_to_view_plain (_tmp153_, &_tmp154_, &_tmp155_, &_tmp156_);
									x2d = _tmp155_;
									y2d = _tmp156_;
									cairo_line_to (c, x2d, y2d);
									cairo_set_source_rgb (c, 0.95, 0.95, 0.95);
									cairo_fill (c);
									_tmp158_ = v;
									if (((gdouble) x) < nibbles_view_view3_d_view_point_x (_tmp158_)) {
										gboolean _tmp159_ = FALSE;
										gint* _tmp160_;
										gint _tmp160__length1;
										gint _tmp160__length2;
										gint _tmp161_;
										_tmp160_ = _data6_->game->board;
										_tmp160__length1 = _data6_->game->board_length1;
										_tmp160__length2 = _data6_->game->board_length2;
										_tmp161_ = _tmp160_[((x + 1) * _tmp160__length2) + y];
										if (_tmp161_ >= ((gint) 'b')) {
											gint* _tmp162_;
											gint _tmp162__length1;
											gint _tmp162__length2;
											gint _tmp163_;
											_tmp162_ = _data6_->game->board;
											_tmp162__length1 = _data6_->game->board_length1;
											_tmp162__length2 = _data6_->game->board_length2;
											_tmp163_ = _tmp162_[((x + 1) * _tmp162__length2) + y];
											_tmp159_ = _tmp163_ <= ((gint) 'l');
										} else {
											_tmp159_ = FALSE;
										}
										_tmp157_ = !_tmp159_;
									} else {
										_tmp157_ = FALSE;
									}
									if (_tmp157_) {
										NibblesViewView3D* _tmp164_;
										NibblesViewPoint3D _tmp165_ = {0};
										gdouble _tmp166_ = 0.0;
										gdouble _tmp167_ = 0.0;
										NibblesViewView3D* _tmp168_;
										NibblesViewPoint3D _tmp169_ = {0};
										gdouble _tmp170_ = 0.0;
										gdouble _tmp171_ = 0.0;
										NibblesViewView3D* _tmp172_;
										NibblesViewPoint3D _tmp173_ = {0};
										gdouble _tmp174_ = 0.0;
										gdouble _tmp175_ = 0.0;
										NibblesViewView3D* _tmp176_;
										NibblesViewPoint3D _tmp177_ = {0};
										gdouble _tmp178_ = 0.0;
										gdouble _tmp179_ = 0.0;
										_tmp164_ = v;
										_tmp165_.x = (gdouble) (x + 1);
										_tmp165_.y = (gdouble) y;
										_tmp165_.z = (gdouble) 0;
										nibbles_view_view3_d_to_view_plain (_tmp164_, &_tmp165_, &_tmp166_, &_tmp167_);
										x2d = _tmp166_;
										y2d = _tmp167_;
										cairo_move_to (c, x2d, y2d);
										_tmp168_ = v;
										_tmp169_.x = (gdouble) (x + 1);
										_tmp169_.y = (gdouble) (y + 1);
										_tmp169_.z = (gdouble) 0;
										nibbles_view_view3_d_to_view_plain (_tmp168_, &_tmp169_, &_tmp170_, &_tmp171_);
										x2d = _tmp170_;
										y2d = _tmp171_;
										cairo_line_to (c, x2d, y2d);
										_tmp172_ = v;
										_tmp173_.x = (gdouble) (x + 1);
										_tmp173_.y = (gdouble) (y + 1);
										_tmp173_.z = (gdouble) 1;
										nibbles_view_view3_d_to_view_plain (_tmp172_, &_tmp173_, &_tmp174_, &_tmp175_);
										x2d = _tmp174_;
										y2d = _tmp175_;
										cairo_line_to (c, x2d, y2d);
										_tmp176_ = v;
										_tmp177_.x = (gdouble) (x + 1);
										_tmp177_.y = (gdouble) y;
										_tmp177_.z = (gdouble) 1;
										nibbles_view_view3_d_to_view_plain (_tmp176_, &_tmp177_, &_tmp178_, &_tmp179_);
										x2d = _tmp178_;
										y2d = _tmp179_;
										cairo_line_to (c, x2d, y2d);
										cairo_set_source_rgb (c, 0.5, 0.5, 0.5);
										cairo_fill (c);
									} else {
										gboolean _tmp180_ = FALSE;
										NibblesViewView3D* _tmp181_;
										_tmp181_ = v;
										if (((gdouble) x) > nibbles_view_view3_d_view_point_x (_tmp181_)) {
											gboolean _tmp182_ = FALSE;
											gint* _tmp183_;
											gint _tmp183__length1;
											gint _tmp183__length2;
											gint _tmp184_;
											_tmp183_ = _data6_->game->board;
											_tmp183__length1 = _data6_->game->board_length1;
											_tmp183__length2 = _data6_->game->board_length2;
											_tmp184_ = _tmp183_[((x - 1) * _tmp183__length2) + y];
											if (_tmp184_ >= ((gint) 'b')) {
												gint* _tmp185_;
												gint _tmp185__length1;
												gint _tmp185__length2;
												gint _tmp186_;
												_tmp185_ = _data6_->game->board;
												_tmp185__length1 = _data6_->game->board_length1;
												_tmp185__length2 = _data6_->game->board_length2;
												_tmp186_ = _tmp185_[((x - 1) * _tmp185__length2) + y];
												_tmp182_ = _tmp186_ <= ((gint) 'l');
											} else {
												_tmp182_ = FALSE;
											}
											_tmp180_ = !_tmp182_;
										} else {
											_tmp180_ = FALSE;
										}
										if (_tmp180_) {
											NibblesViewView3D* _tmp187_;
											NibblesViewPoint3D _tmp188_ = {0};
											gdouble _tmp189_ = 0.0;
											gdouble _tmp190_ = 0.0;
											NibblesViewView3D* _tmp191_;
											NibblesViewPoint3D _tmp192_ = {0};
											gdouble _tmp193_ = 0.0;
											gdouble _tmp194_ = 0.0;
											NibblesViewView3D* _tmp195_;
											NibblesViewPoint3D _tmp196_ = {0};
											gdouble _tmp197_ = 0.0;
											gdouble _tmp198_ = 0.0;
											NibblesViewView3D* _tmp199_;
											NibblesViewPoint3D _tmp200_ = {0};
											gdouble _tmp201_ = 0.0;
											gdouble _tmp202_ = 0.0;
											_tmp187_ = v;
											_tmp188_.x = (gdouble) x;
											_tmp188_.y = (gdouble) y;
											_tmp188_.z = (gdouble) 0;
											nibbles_view_view3_d_to_view_plain (_tmp187_, &_tmp188_, &_tmp189_, &_tmp190_);
											x2d = _tmp189_;
											y2d = _tmp190_;
											cairo_move_to (c, x2d, y2d);
											_tmp191_ = v;
											_tmp192_.x = (gdouble) x;
											_tmp192_.y = (gdouble) (y + 1);
											_tmp192_.z = (gdouble) 0;
											nibbles_view_view3_d_to_view_plain (_tmp191_, &_tmp192_, &_tmp193_, &_tmp194_);
											x2d = _tmp193_;
											y2d = _tmp194_;
											cairo_line_to (c, x2d, y2d);
											_tmp195_ = v;
											_tmp196_.x = (gdouble) x;
											_tmp196_.y = (gdouble) (y + 1);
											_tmp196_.z = (gdouble) 1;
											nibbles_view_view3_d_to_view_plain (_tmp195_, &_tmp196_, &_tmp197_, &_tmp198_);
											x2d = _tmp197_;
											y2d = _tmp198_;
											cairo_line_to (c, x2d, y2d);
											_tmp199_ = v;
											_tmp200_.x = (gdouble) x;
											_tmp200_.y = (gdouble) y;
											_tmp200_.z = (gdouble) 1;
											nibbles_view_view3_d_to_view_plain (_tmp199_, &_tmp200_, &_tmp201_, &_tmp202_);
											x2d = _tmp201_;
											y2d = _tmp202_;
											cairo_line_to (c, x2d, y2d);
											cairo_set_source_rgb (c, 0.5, 0.5, 0.5);
											cairo_fill (c);
										} else {
										}
									}
									_tmp203_ = v;
									_tmp204_.x = (gdouble) x;
									_tmp204_.y = (gdouble) (y + 1);
									_tmp204_.z = (gdouble) 0;
									nibbles_view_view3_d_to_view_plain (_tmp203_, &_tmp204_, &_tmp205_, &_tmp206_);
									x2d = _tmp205_;
									y2d = _tmp206_;
									cairo_move_to (c, x2d, y2d);
									_tmp207_ = v;
									_tmp208_.x = (gdouble) (x + 1);
									_tmp208_.y = (gdouble) (y + 1);
									_tmp208_.z = (gdouble) 0;
									nibbles_view_view3_d_to_view_plain (_tmp207_, &_tmp208_, &_tmp209_, &_tmp210_);
									x2d = _tmp209_;
									y2d = _tmp210_;
									cairo_line_to (c, x2d, y2d);
									_tmp211_ = v;
									_tmp212_.x = (gdouble) (x + 1);
									_tmp212_.y = (gdouble) (y + 1);
									_tmp212_.z = (gdouble) 1;
									nibbles_view_view3_d_to_view_plain (_tmp211_, &_tmp212_, &_tmp213_, &_tmp214_);
									x2d = _tmp213_;
									y2d = _tmp214_;
									cairo_line_to (c, x2d, y2d);
									_tmp215_ = v;
									_tmp216_.x = (gdouble) x;
									_tmp216_.y = (gdouble) (y + 1);
									_tmp216_.z = (gdouble) 1;
									nibbles_view_view3_d_to_view_plain (_tmp215_, &_tmp216_, &_tmp217_, &_tmp218_);
									x2d = _tmp217_;
									y2d = _tmp218_;
									cairo_line_to (c, x2d, y2d);
									cairo_set_source_rgb (c, 0.75, 0.75, 0.75);
									cairo_fill (c);
								}
								_tmp222_ = _data6_->game->board;
								_tmp222__length1 = _data6_->game->board_length1;
								_tmp222__length2 = _data6_->game->board_length2;
								_tmp223_ = _tmp222_[((x + 0) * _tmp222__length2) + (y + 0)];
								if (_tmp223_ == ((gint) NIBBLES_GAME_WARPCHAR)) {
									gint* _tmp224_;
									gint _tmp224__length1;
									gint _tmp224__length2;
									gint _tmp225_;
									_tmp224_ = _data6_->game->board;
									_tmp224__length1 = _data6_->game->board_length1;
									_tmp224__length2 = _data6_->game->board_length2;
									_tmp225_ = _tmp224_[((x + 1) * _tmp224__length2) + (y + 0)];
									_tmp221_ = _tmp225_ == ((gint) NIBBLES_GAME_WARPCHAR);
								} else {
									_tmp221_ = FALSE;
								}
								if (_tmp221_) {
									gint* _tmp226_;
									gint _tmp226__length1;
									gint _tmp226__length2;
									gint _tmp227_;
									_tmp226_ = _data6_->game->board;
									_tmp226__length1 = _data6_->game->board_length1;
									_tmp226__length2 = _data6_->game->board_length2;
									_tmp227_ = _tmp226_[((x + 0) * _tmp226__length2) + (y + 1)];
									_tmp220_ = _tmp227_ == ((gint) NIBBLES_GAME_WARPCHAR);
								} else {
									_tmp220_ = FALSE;
								}
								if (_tmp220_) {
									gint* _tmp228_;
									gint _tmp228__length1;
									gint _tmp228__length2;
									gint _tmp229_;
									_tmp228_ = _data6_->game->board;
									_tmp228__length1 = _data6_->game->board_length1;
									_tmp228__length2 = _data6_->game->board_length2;
									_tmp229_ = _tmp228_[((x + 1) * _tmp228__length2) + (y + 1)];
									_tmp219_ = _tmp229_ == ((gint) NIBBLES_GAME_WARPCHAR);
								} else {
									_tmp219_ = FALSE;
								}
								if (_tmp219_) {
									{
										gint z = 0;
										z = 0;
										{
											gboolean _tmp230_ = FALSE;
											_tmp230_ = TRUE;
											while (TRUE) {
												guint64 a40 = 0ULL;
												guint64 a20 = 0ULL;
												guint64 a20o = 0ULL;
												gdouble a10 = 0.0;
												gdouble _tmp232_ = 0.0;
												gdouble _tmp234_ = 0.0;
												gboolean _tmp235_ = FALSE;
												gdouble _tmp237_ = 0.0;
												gboolean _tmp238_ = FALSE;
												gdouble _tmp240_ = 0.0;
												gboolean _tmp241_ = FALSE;
												gdouble angle[4] = {0};
												gdouble _tmp243_[4] = {0};
												NibblesViewView3D* _tmp244_;
												gdouble _tmp245_;
												NibblesViewPoint3D _tmp246_ = {0};
												gdouble _tmp247_;
												NibblesViewPoint3D _tmp248_ = {0};
												gdouble _tmp249_;
												NibblesViewPoint3D _tmp250_ = {0};
												gdouble _tmp251_;
												NibblesViewPoint3D _tmp252_ = {0};
												if (!_tmp230_) {
													gint _tmp231_;
													_tmp231_ = z;
													z = _tmp231_ + 1;
												}
												_tmp230_ = FALSE;
												if (!(z < 6)) {
													break;
												}
												a40 = self->priv->animate % 40;
												a20 = self->priv->animate % 20;
												a20o = (self->priv->animate + 10) % 20;
												a10 = (gdouble) (self->priv->animate % 10);
												if (a40 < ((guint64) 20)) {
													gdouble _tmp233_ = 0.0;
													if (a20 < ((guint64) 10)) {
														_tmp233_ = a10;
													} else {
														_tmp233_ = 10.0 - a10;
													}
													_tmp232_ = _tmp233_ / 5.0;
												} else {
													_tmp232_ = (gdouble) 0;
												}
												if (a40 >= ((guint64) 10)) {
													_tmp235_ = a40 < ((guint64) 30);
												} else {
													_tmp235_ = FALSE;
												}
												if (_tmp235_) {
													gdouble _tmp236_ = 0.0;
													if (a20o < ((guint64) 10)) {
														_tmp236_ = a10;
													} else {
														_tmp236_ = 10.0 - a10;
													}
													_tmp234_ = _tmp236_ / 5.0;
												} else {
													_tmp234_ = (gdouble) 0;
												}
												if (a40 >= ((guint64) 20)) {
													_tmp238_ = a40 < ((guint64) 40);
												} else {
													_tmp238_ = FALSE;
												}
												if (_tmp238_) {
													gdouble _tmp239_ = 0.0;
													if (a20 < ((guint64) 10)) {
														_tmp239_ = a10;
													} else {
														_tmp239_ = 10.0 - a10;
													}
													_tmp237_ = _tmp239_ / 5.0;
												} else {
													_tmp237_ = (gdouble) 0;
												}
												if (a40 >= ((guint64) 30)) {
													_tmp241_ = TRUE;
												} else {
													_tmp241_ = a40 < ((guint64) 10);
												}
												if (_tmp241_) {
													gdouble _tmp242_ = 0.0;
													if (a20o < ((guint64) 10)) {
														_tmp242_ = a10;
													} else {
														_tmp242_ = 10.0 - a10;
													}
													_tmp240_ = _tmp242_ / 5.0;
												} else {
													_tmp240_ = (gdouble) 0;
												}
												_tmp243_[0] = _tmp232_;
												_tmp243_[1] = _tmp234_;
												_tmp243_[2] = _tmp237_;
												_tmp243_[3] = _tmp240_;
												memcpy (angle, _tmp243_, 4 * sizeof (gdouble));
												_tmp244_ = v;
												_tmp245_ = angle[0];
												_tmp246_.x = ((gdouble) x) + (0.1 * z);
												_tmp246_.y = ((gdouble) y) + (0.1 * z);
												_tmp246_.z = _tmp245_;
												_tmp247_ = angle[1];
												_tmp248_.x = (((gdouble) x) + 2) - (0.1 * z);
												_tmp248_.y = ((gdouble) y) + (0.1 * z);
												_tmp248_.z = _tmp247_;
												_tmp249_ = angle[2];
												_tmp250_.x = (((gdouble) x) + 2) - (0.1 * z);
												_tmp250_.y = (((gdouble) y) + 2) - (0.1 * z);
												_tmp250_.z = _tmp249_;
												_tmp251_ = angle[3];
												_tmp252_.x = ((gdouble) x) + (0.1 * z);
												_tmp252_.y = (((gdouble) y) + 2) - (0.1 * z);
												_tmp252_.z = _tmp251_;
												nibbles_view_draw_oval (self, c, _tmp244_, &_tmp246_, &_tmp248_, &_tmp250_, &_tmp252_);
												cairo_set_source_rgb (c, 0.0, 0.0, 0.6 - (0.1 * ((gdouble) z)));
												cairo_fill (c);
											}
										}
									}
								}
								_tmp253_ = bonus_at;
								_tmp253__length1 = bonus_at_length1;
								_tmp253__length2 = bonus_at_length2;
								_tmp254_ = _tmp253_[(x * _tmp253__length2) + y];
								if (_tmp254_ != NULL) {
									NibblesViewView3D* _tmp255_;
									Bonus** _tmp256_;
									gint _tmp256__length1;
									gint _tmp256__length2;
									Bonus* _tmp257_;
									_tmp255_ = v;
									_tmp256_ = bonus_at;
									_tmp256__length1 = bonus_at_length1;
									_tmp256__length2 = bonus_at_length2;
									_tmp257_ = _tmp256_[(x * _tmp256__length2) + y];
									nibbles_view_draw_3D_bonus (self, c, _tmp255_, x, y, _tmp257_);
								}
								if (x == (NIBBLES_VIEW_WIDTH / 2)) {
									break;
								}
							}
						}
					}
				}
			}
		}
		if (_data6_->countdown_active (_data6_->countdown_active_target) > 0) {
			gchar* text = NULL;
			gchar* _tmp258_;
			gint text_width = 0;
			NibblesViewView3D* _tmp259_;
			NibblesViewPoint3D _tmp260_ = {0};
			NibblesViewPoint3D _tmp261_ = {0};
			gdouble w = 0.0;
			gdouble h = 0.0;
			gint font_size = 0;
			const gchar* _tmp262_;
			gdouble _tmp263_ = 0.0;
			gdouble _tmp264_ = 0.0;
			gint _tmp265_;
			gdouble center_x = 0.0;
			gdouble center_y = 0.0;
			NibblesViewView3D* _tmp266_;
			NibblesViewPoint3D _tmp267_ = {0};
			gdouble _tmp268_ = 0.0;
			gdouble _tmp269_ = 0.0;
			const gchar* _tmp270_;
			_tmp258_ = nibbles_view_seconds_string (self, _data6_->countdown_active (_data6_->countdown_active_target));
			text = _tmp258_;
			_tmp259_ = v;
			_tmp260_.x = (gdouble) ((NIBBLES_VIEW_WIDTH / 2) - 5);
			_tmp260_.y = (gdouble) (NIBBLES_VIEW_HEIGHT / 2);
			_tmp260_.z = (gdouble) 0;
			_tmp261_.x = (gdouble) ((NIBBLES_VIEW_WIDTH / 2) + 5);
			_tmp261_.y = (gdouble) (NIBBLES_VIEW_HEIGHT / 2);
			_tmp261_.z = (gdouble) 0;
			text_width = (gint) nibbles_view_view3_d_2D_diff (_tmp259_, &_tmp260_, &_tmp261_);
			_tmp262_ = text;
			_tmp265_ = nibbles_view_calculate_font_size (self, c, _tmp262_, text_width, &_tmp263_, &_tmp264_);
			w = _tmp263_;
			h = _tmp264_;
			font_size = _tmp265_;
			_tmp266_ = v;
			_tmp267_.x = (gdouble) (NIBBLES_VIEW_WIDTH / 2);
			_tmp267_.y = (gdouble) (NIBBLES_VIEW_HEIGHT / 2);
			_tmp267_.z = (gdouble) 0;
			nibbles_view_view3_d_to_view_plain (_tmp266_, &_tmp267_, &_tmp268_, &_tmp269_);
			center_x = _tmp268_;
			center_y = _tmp269_;
			_tmp270_ = text;
			nibbles_view_draw_text_font_size (self, c, (gint) (center_x - (w / 2)), (gint) (center_y - (h / 2)), _tmp270_, font_size);
			{
				GeeLinkedList* _worm_list = NULL;
				GeeLinkedList* _tmp271_;
				GeeLinkedList* _tmp272_;
				gint _worm_size = 0;
				GeeLinkedList* _tmp273_;
				gint _tmp274_;
				gint _tmp275_;
				gint _worm_index = 0;
				_tmp271_ = nibbles_game_get_worms (_data6_->game);
				_tmp272_ = _tmp271_;
				_worm_list = _tmp272_;
				_tmp273_ = _worm_list;
				_tmp274_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp273_);
				_tmp275_ = _tmp274_;
				_worm_size = _tmp275_;
				_worm_index = -1;
				while (TRUE) {
					gint _tmp276_;
					gint _tmp277_;
					Worm* worm = NULL;
					GeeLinkedList* _tmp278_;
					gpointer _tmp279_;
					Worm* _tmp280_;
					WormPositions* _tmp281_;
					gboolean _tmp282_;
					gboolean _tmp283_;
					_worm_index = _worm_index + 1;
					_tmp276_ = _worm_index;
					_tmp277_ = _worm_size;
					if (!(_tmp276_ < _tmp277_)) {
						break;
					}
					_tmp278_ = _worm_list;
					_tmp279_ = gee_abstract_list_get ((GeeAbstractList*) _tmp278_, _worm_index);
					worm = (Worm*) _tmp279_;
					_tmp280_ = worm;
					_tmp281_ = _tmp280_->list;
					_tmp282_ = gee_collection_get_is_empty ((GeeCollection*) _tmp281_);
					_tmp283_ = _tmp282_;
					if (!_tmp283_) {
						gint color = 0;
						GeeHashMap* _tmp284_;
						GeeHashMap* _tmp285_;
						Worm* _tmp286_;
						gpointer _tmp287_;
						WormProperties* _tmp288_;
						gint _tmp289_;
						gint _tmp290_;
						gint _tmp291_;
						gboolean _tmp292_ = FALSE;
						Worm* _tmp293_;
						WormDirection _tmp294_;
						WormDirection _tmp295_;
						_tmp284_ = nibbles_game_get_worm_props (_data6_->game);
						_tmp285_ = _tmp284_;
						_tmp286_ = worm;
						_tmp287_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp285_, _tmp286_);
						_tmp288_ = (WormProperties*) _tmp287_;
						_tmp289_ = worm_properties_get_color (_tmp288_);
						_tmp290_ = _tmp289_;
						_tmp291_ = _tmp290_;
						_g_object_unref0 (_tmp288_);
						color = _tmp291_;
						_tmp293_ = worm;
						_tmp294_ = worm_get_direction (_tmp293_);
						_tmp295_ = _tmp294_;
						if (_tmp295_ == WORM_DIRECTION_UP) {
							_tmp292_ = TRUE;
						} else {
							Worm* _tmp296_;
							WormDirection _tmp297_;
							WormDirection _tmp298_;
							_tmp296_ = worm;
							_tmp297_ = worm_get_direction (_tmp296_);
							_tmp298_ = _tmp297_;
							_tmp292_ = _tmp298_ == WORM_DIRECTION_DOWN;
						}
						if (_tmp292_) {
							gint middle = 0;
							Worm* _tmp299_;
							gint _tmp300_;
							gint _tmp301_;
							NibblesViewView3D* _tmp302_;
							Worm* _tmp303_;
							WormPositions* _tmp304_;
							gpointer _tmp305_;
							Worm* _tmp306_;
							WormPositions* _tmp307_;
							gpointer _tmp308_;
							NibblesViewPoint3D _tmp309_ = {0};
							gdouble _tmp310_ = 0.0;
							gdouble _tmp311_ = 0.0;
							Worm* _tmp312_;
							gint _tmp313_;
							gint _tmp314_;
							gchar* _tmp315_;
							gchar* _tmp316_;
							NibblesViewView3D* _tmp317_;
							Worm* _tmp318_;
							WormPositions* _tmp319_;
							gpointer _tmp320_;
							Worm* _tmp321_;
							WormPositions* _tmp322_;
							gpointer _tmp323_;
							NibblesViewPoint3D _tmp324_ = {0};
							Worm* _tmp325_;
							WormPositions* _tmp326_;
							Worm* _tmp327_;
							gint _tmp328_;
							gint _tmp329_;
							gpointer _tmp330_;
							Worm* _tmp331_;
							WormPositions* _tmp332_;
							Worm* _tmp333_;
							gint _tmp334_;
							gint _tmp335_;
							gpointer _tmp336_;
							NibblesViewPoint3D _tmp337_ = {0};
							_tmp299_ = worm;
							_tmp300_ = worm_get_length (_tmp299_);
							_tmp301_ = _tmp300_;
							middle = _tmp301_ / 2;
							_tmp302_ = v;
							_tmp303_ = worm;
							_tmp304_ = _tmp303_->list;
							_tmp305_ = gee_abstract_list_get ((GeeAbstractList*) _tmp304_, middle);
							_tmp306_ = worm;
							_tmp307_ = _tmp306_->list;
							_tmp308_ = gee_abstract_list_get ((GeeAbstractList*) _tmp307_, middle);
							_tmp309_.x = (((guint16) ((guintptr) _tmp305_)) >> 8) + 1.5;
							_tmp309_.y = (gdouble) ((guint8) ((guint16) ((guintptr) _tmp308_)));
							_tmp309_.z = (gdouble) 0;
							nibbles_view_view3_d_to_view_plain (_tmp302_, &_tmp309_, &_tmp310_, &_tmp311_);
							x2d = _tmp310_;
							y2d = _tmp311_;
							_tmp312_ = worm;
							_tmp313_ = worm_get_id (_tmp312_);
							_tmp314_ = _tmp313_;
							_tmp315_ = nibbles_view_worm_name (self, _tmp314_ + 1);
							_tmp316_ = _tmp315_;
							_tmp317_ = v;
							_tmp318_ = worm;
							_tmp319_ = _tmp318_->list;
							_tmp320_ = gee_abstract_list_get ((GeeAbstractList*) _tmp319_, 0);
							_tmp321_ = worm;
							_tmp322_ = _tmp321_->list;
							_tmp323_ = gee_abstract_list_get ((GeeAbstractList*) _tmp322_, 0);
							_tmp324_.x = (gdouble) (((guint16) ((guintptr) _tmp320_)) >> 8);
							_tmp324_.y = (gdouble) ((guint8) ((guint16) ((guintptr) _tmp323_)));
							_tmp324_.z = (gdouble) 0;
							_tmp325_ = worm;
							_tmp326_ = _tmp325_->list;
							_tmp327_ = worm;
							_tmp328_ = worm_get_length (_tmp327_);
							_tmp329_ = _tmp328_;
							_tmp330_ = gee_abstract_list_get ((GeeAbstractList*) _tmp326_, _tmp329_ - 1);
							_tmp331_ = worm;
							_tmp332_ = _tmp331_->list;
							_tmp333_ = worm;
							_tmp334_ = worm_get_length (_tmp333_);
							_tmp335_ = _tmp334_;
							_tmp336_ = gee_abstract_list_get ((GeeAbstractList*) _tmp332_, _tmp335_ - 1);
							_tmp337_.x = (gdouble) (((guint16) ((guintptr) _tmp330_)) >> 8);
							_tmp337_.y = (gdouble) (((guint8) ((guint16) ((guintptr) _tmp336_))) + 1);
							_tmp337_.z = (gdouble) 0;
							nibbles_view_draw_text_target_width (self, c, (gint) x2d, (gint) y2d, _tmp316_, (gint) nibbles_view_view3_d_2D_diff (_tmp317_, &_tmp324_, &_tmp337_), color);
							_g_free0 (_tmp316_);
						} else {
							gboolean _tmp338_ = FALSE;
							Worm* _tmp339_;
							WormDirection _tmp340_;
							WormDirection _tmp341_;
							_tmp339_ = worm;
							_tmp340_ = worm_get_direction (_tmp339_);
							_tmp341_ = _tmp340_;
							if (_tmp341_ == WORM_DIRECTION_LEFT) {
								_tmp338_ = TRUE;
							} else {
								Worm* _tmp342_;
								WormDirection _tmp343_;
								WormDirection _tmp344_;
								_tmp342_ = worm;
								_tmp343_ = worm_get_direction (_tmp342_);
								_tmp344_ = _tmp343_;
								_tmp338_ = _tmp344_ == WORM_DIRECTION_RIGHT;
							}
							if (_tmp338_) {
								gdouble x_2d[2] = {0};
								gdouble y_2d[2] = {0};
								gint x = 0;
								Worm* _tmp345_;
								WormPositions* _tmp346_;
								gpointer _tmp347_;
								gint x_max = 0;
								Worm* _tmp348_;
								WormPositions* _tmp349_;
								Worm* _tmp350_;
								gint _tmp351_;
								gint _tmp352_;
								gpointer _tmp353_;
								NibblesViewView3D* _tmp354_;
								Worm* _tmp355_;
								WormPositions* _tmp356_;
								gpointer _tmp357_;
								NibblesViewPoint3D _tmp358_ = {0};
								gdouble _tmp359_ = 0.0;
								gdouble _tmp360_ = 0.0;
								NibblesViewView3D* _tmp361_;
								Worm* _tmp362_;
								WormPositions* _tmp363_;
								gpointer _tmp364_;
								NibblesViewPoint3D _tmp365_ = {0};
								gdouble _tmp366_ = 0.0;
								gdouble _tmp367_ = 0.0;
								gdouble _tmp368_;
								gdouble _tmp369_;
								Worm* _tmp370_;
								gint _tmp371_;
								gint _tmp372_;
								gchar* _tmp373_;
								gchar* _tmp374_;
								gdouble _tmp375_;
								gdouble _tmp376_;
								_tmp345_ = worm;
								_tmp346_ = _tmp345_->list;
								_tmp347_ = gee_abstract_list_get ((GeeAbstractList*) _tmp346_, 0);
								x = ((guint16) ((guintptr) _tmp347_)) >> 8;
								_tmp348_ = worm;
								_tmp349_ = _tmp348_->list;
								_tmp350_ = worm;
								_tmp351_ = worm_get_length (_tmp350_);
								_tmp352_ = _tmp351_;
								_tmp353_ = gee_abstract_list_get ((GeeAbstractList*) _tmp349_, _tmp352_ - 1);
								x_max = ((guint16) ((guintptr) _tmp353_)) >> 8;
								if (x > x_max) {
									gint swap = 0;
									swap = x;
									x = x_max;
									x_max = swap;
								}
								_tmp354_ = v;
								_tmp355_ = worm;
								_tmp356_ = _tmp355_->list;
								_tmp357_ = gee_abstract_list_get ((GeeAbstractList*) _tmp356_, 0);
								_tmp358_.x = (gdouble) x;
								_tmp358_.y = (gdouble) ((guint8) ((guint16) ((guintptr) _tmp357_)));
								_tmp358_.z = (gdouble) 3;
								nibbles_view_view3_d_to_view_plain (_tmp354_, &_tmp358_, &_tmp359_, &_tmp360_);
								x_2d[0] = _tmp359_;
								y_2d[0] = _tmp360_;
								_tmp361_ = v;
								_tmp362_ = worm;
								_tmp363_ = _tmp362_->list;
								_tmp364_ = gee_abstract_list_get ((GeeAbstractList*) _tmp363_, 0);
								_tmp365_.x = (gdouble) (x_max + 1);
								_tmp365_.y = (gdouble) ((guint8) ((guint16) ((guintptr) _tmp364_)));
								_tmp365_.z = (gdouble) 3;
								nibbles_view_view3_d_to_view_plain (_tmp361_, &_tmp365_, &_tmp366_, &_tmp367_);
								x_2d[1] = _tmp366_;
								y_2d[1] = _tmp367_;
								_tmp368_ = x_2d[0];
								_tmp369_ = y_2d[0];
								_tmp370_ = worm;
								_tmp371_ = worm_get_id (_tmp370_);
								_tmp372_ = _tmp371_;
								_tmp373_ = nibbles_view_worm_name (self, _tmp372_ + 1);
								_tmp374_ = _tmp373_;
								_tmp375_ = x_2d[1];
								_tmp376_ = x_2d[0];
								nibbles_view_draw_text_target_width (self, c, (gint) _tmp368_, (gint) _tmp369_, _tmp374_, (gint) (_tmp375_ - _tmp376_), color);
								_g_free0 (_tmp374_);
							}
						}
					}
					_g_object_unref0 (worm);
				}
			}
			_g_free0 (text);
		}
		_tmp380_ = _data6_->new_game_dialogue_active (&_tmp377_, &_tmp378_, &_tmp379_, _data6_->new_game_dialogue_active_target);
		(self->priv->result_function_target_destroy_notify == NULL) ? NULL : (self->priv->result_function_target_destroy_notify (self->priv->result_function_target), NULL);
		self->priv->result_function = NULL;
		self->priv->result_function_target = NULL;
		self->priv->result_function_target_destroy_notify = NULL;
		self->priv->result_function = _tmp377_;
		self->priv->result_function_target = _tmp378_;
		self->priv->result_function_target_destroy_notify = _tmp379_;
		if (_tmp380_) {
			YesNoResultFunction _tmp381_;
			gpointer _tmp381__target;
			_tmp381_ = self->priv->result_function;
			_tmp381__target = self->priv->result_function_target;
			nibbles_view_new_game_dialogue_draw (self, c, (gdouble) width, (gdouble) height, _tmp381_, _tmp381__target);
		}
		bonus_at = (_vala_array_free (bonus_at, bonus_at_length1 * bonus_at_length2, (GDestroyNotify) g_object_unref), NULL);
		worm_at = (_vala_array_free (worm_at, worm_at_length1 * worm_at_length2, (GDestroyNotify) g_object_unref), NULL);
		dematerialized_worms = (_vala_array_free (dematerialized_worms, dematerialized_worms_length1, (GDestroyNotify) g_object_unref), NULL);
		_nibbles_view_view3_d_unref0 (v);
	} else {
		static const gdouble max_delta_deviation = 1.15;
		gint x_delta = 0;
		gint y_delta = 0;
		gint x_offset = 0;
		gint y_offset = 0;
		GeeArrayList* materialized_worm_positions = NULL;
		GeeArrayList* _tmp404_;
		gint* dematerialized_worms = NULL;
		gint* _tmp405_;
		gint dematerialized_worms_length1;
		gint _dematerialized_worms_size_;
		YesNoResultFunction _tmp575_ = NULL;
		gpointer _tmp576_ = NULL;
		GDestroyNotify _tmp577_ = NULL;
		gboolean _tmp578_;
		x_delta = width / NIBBLES_VIEW_WIDTH;
		y_delta = height / NIBBLES_VIEW_HEIGHT;
		if (((gdouble) x_delta) > (max_delta_deviation * y_delta)) {
			x_delta = (gint) (y_delta * max_delta_deviation);
		} else {
			if (((gdouble) y_delta) > (max_delta_deviation * x_delta)) {
				y_delta = (gint) (x_delta * max_delta_deviation);
			}
		}
		x_offset = (width - (x_delta * NIBBLES_VIEW_WIDTH)) / 2;
		y_offset = (height - (y_delta * NIBBLES_VIEW_HEIGHT)) / 2;
		cairo_rectangle (c, (gdouble) x_offset, (gdouble) y_offset, (gdouble) (x_delta * NIBBLES_VIEW_WIDTH), (gdouble) (y_delta * NIBBLES_VIEW_HEIGHT));
		cairo_set_source_rgb (c, (gdouble) 0, (gdouble) 0, (gdouble) 0);
		cairo_fill (c);
		{
			gint x = 0;
			x = 0;
			{
				gboolean _tmp382_ = FALSE;
				_tmp382_ = TRUE;
				while (TRUE) {
					if (!_tmp382_) {
						gint _tmp383_;
						_tmp383_ = x;
						x = _tmp383_ + 1;
					}
					_tmp382_ = FALSE;
					if (!(x < ((gint) NIBBLES_VIEW_WIDTH))) {
						break;
					}
					{
						gint y = 0;
						y = 0;
						{
							gboolean _tmp384_ = FALSE;
							_tmp384_ = TRUE;
							while (TRUE) {
								gboolean _tmp386_ = FALSE;
								gint* _tmp387_;
								gint _tmp387__length1;
								gint _tmp387__length2;
								gint _tmp388_;
								gboolean _tmp393_ = FALSE;
								gboolean _tmp394_ = FALSE;
								gboolean _tmp395_ = FALSE;
								gint* _tmp396_;
								gint _tmp396__length1;
								gint _tmp396__length2;
								gint _tmp397_;
								if (!_tmp384_) {
									gint _tmp385_;
									_tmp385_ = y;
									y = _tmp385_ + 1;
								}
								_tmp384_ = FALSE;
								if (!(y < ((gint) NIBBLES_VIEW_HEIGHT))) {
									break;
								}
								_tmp387_ = _data6_->game->board;
								_tmp387__length1 = _data6_->game->board_length1;
								_tmp387__length2 = _data6_->game->board_length2;
								_tmp388_ = _tmp387_[(x * _tmp387__length2) + y];
								if (_tmp388_ >= ((gint) 'b')) {
									gint* _tmp389_;
									gint _tmp389__length1;
									gint _tmp389__length2;
									gint _tmp390_;
									_tmp389_ = _data6_->game->board;
									_tmp389__length1 = _data6_->game->board_length1;
									_tmp389__length2 = _data6_->game->board_length2;
									_tmp390_ = _tmp389_[(x * _tmp389__length2) + y];
									_tmp386_ = _tmp390_ <= ((gint) 'l');
								} else {
									_tmp386_ = FALSE;
								}
								if (_tmp386_) {
									gint* _tmp391_;
									gint _tmp391__length1;
									gint _tmp391__length2;
									gint _tmp392_;
									_tmp391_ = _data6_->game->board;
									_tmp391__length1 = _data6_->game->board_length1;
									_tmp391__length2 = _data6_->game->board_length2;
									_tmp392_ = _tmp391_[(x * _tmp391__length2) + y];
									nibbles_view_draw_wall_segment (self, _tmp392_, c, (x_delta * x) + x_offset, (y_delta * y) + y_offset, x_delta, y_delta);
								}
								_tmp396_ = _data6_->game->board;
								_tmp396__length1 = _data6_->game->board_length1;
								_tmp396__length2 = _data6_->game->board_length2;
								_tmp397_ = _tmp396_[((x + 0) * _tmp396__length2) + (y + 0)];
								if (_tmp397_ == ((gint) NIBBLES_GAME_WARPCHAR)) {
									gint* _tmp398_;
									gint _tmp398__length1;
									gint _tmp398__length2;
									gint _tmp399_;
									_tmp398_ = _data6_->game->board;
									_tmp398__length1 = _data6_->game->board_length1;
									_tmp398__length2 = _data6_->game->board_length2;
									_tmp399_ = _tmp398_[((x + 1) * _tmp398__length2) + (y + 0)];
									_tmp395_ = _tmp399_ == ((gint) NIBBLES_GAME_WARPCHAR);
								} else {
									_tmp395_ = FALSE;
								}
								if (_tmp395_) {
									gint* _tmp400_;
									gint _tmp400__length1;
									gint _tmp400__length2;
									gint _tmp401_;
									_tmp400_ = _data6_->game->board;
									_tmp400__length1 = _data6_->game->board_length1;
									_tmp400__length2 = _data6_->game->board_length2;
									_tmp401_ = _tmp400_[((x + 0) * _tmp400__length2) + (y + 1)];
									_tmp394_ = _tmp401_ == ((gint) NIBBLES_GAME_WARPCHAR);
								} else {
									_tmp394_ = FALSE;
								}
								if (_tmp394_) {
									gint* _tmp402_;
									gint _tmp402__length1;
									gint _tmp402__length2;
									gint _tmp403_;
									_tmp402_ = _data6_->game->board;
									_tmp402__length1 = _data6_->game->board_length1;
									_tmp402__length2 = _data6_->game->board_length2;
									_tmp403_ = _tmp402_[((x + 1) * _tmp402__length2) + (y + 1)];
									_tmp393_ = _tmp403_ == ((gint) NIBBLES_GAME_WARPCHAR);
								} else {
									_tmp393_ = FALSE;
								}
								if (_tmp393_) {
									nibbles_view_draw_bonus (self, c, (x_delta * x) + x_offset, (y_delta * y) + y_offset, x_delta + x_delta, y_delta + y_delta, BONUS_TYPE_WARP);
								}
							}
						}
					}
				}
			}
		}
		_tmp404_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
		materialized_worm_positions = _tmp404_;
		_tmp405_ = g_new0 (gint, 0);
		dematerialized_worms = _tmp405_;
		dematerialized_worms_length1 = 0;
		_dematerialized_worms_size_ = dematerialized_worms_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp406_ = FALSE;
				_tmp406_ = TRUE;
				while (TRUE) {
					GeeLinkedList* _tmp408_;
					GeeLinkedList* _tmp409_;
					gint _tmp410_;
					gint _tmp411_;
					GeeLinkedList* _tmp412_;
					GeeLinkedList* _tmp413_;
					gpointer _tmp414_;
					Worm* _tmp415_;
					gboolean _tmp416_;
					gboolean _tmp417_;
					gboolean _tmp418_;
					if (!_tmp406_) {
						gint _tmp407_;
						_tmp407_ = i;
						i = _tmp407_ + 1;
					}
					_tmp406_ = FALSE;
					_tmp408_ = nibbles_game_get_worms (_data6_->game);
					_tmp409_ = _tmp408_;
					_tmp410_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp409_);
					_tmp411_ = _tmp410_;
					if (!(i < _tmp411_)) {
						break;
					}
					_tmp412_ = nibbles_game_get_worms (_data6_->game);
					_tmp413_ = _tmp412_;
					_tmp414_ = gee_abstract_list_get ((GeeAbstractList*) _tmp413_, i);
					_tmp415_ = (Worm*) _tmp414_;
					_tmp416_ = worm_get_is_materialized (_tmp415_);
					_tmp417_ = _tmp416_;
					_tmp418_ = _tmp417_;
					_g_object_unref0 (_tmp415_);
					if (_tmp418_) {
						{
							WormPositions* _position_list = NULL;
							GeeLinkedList* _tmp419_;
							GeeLinkedList* _tmp420_;
							gpointer _tmp421_;
							Worm* _tmp422_;
							WormPositions* _tmp423_;
							WormPositions* _tmp424_;
							gint _position_size = 0;
							WormPositions* _tmp425_;
							gint _tmp426_;
							gint _tmp427_;
							gint _position_index = 0;
							_tmp419_ = nibbles_game_get_worms (_data6_->game);
							_tmp420_ = _tmp419_;
							_tmp421_ = gee_abstract_list_get ((GeeAbstractList*) _tmp420_, i);
							_tmp422_ = (Worm*) _tmp421_;
							_tmp423_ = _tmp422_->list;
							_tmp424_ = _tmp423_;
							_g_object_unref0 (_tmp422_);
							_position_list = _tmp424_;
							_tmp425_ = _position_list;
							_tmp426_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp425_);
							_tmp427_ = _tmp426_;
							_position_size = _tmp427_;
							_position_index = -1;
							while (TRUE) {
								gint _tmp428_;
								gint _tmp429_;
								guint16 position = 0U;
								WormPositions* _tmp430_;
								gpointer _tmp431_;
								guint8 x = 0U;
								guint8 y = 0U;
								GeeHashMap* _tmp432_;
								GeeHashMap* _tmp433_;
								GeeLinkedList* _tmp434_;
								GeeLinkedList* _tmp435_;
								gpointer _tmp436_;
								Worm* _tmp437_;
								gpointer _tmp438_;
								WormProperties* _tmp439_;
								gint _tmp440_;
								gint _tmp441_;
								GeeLinkedList* _tmp442_;
								GeeLinkedList* _tmp443_;
								gpointer _tmp444_;
								Worm* _tmp445_;
								GeeArrayList* _tmp446_;
								_position_index = _position_index + 1;
								_tmp428_ = _position_index;
								_tmp429_ = _position_size;
								if (!(_tmp428_ < _tmp429_)) {
									break;
								}
								_tmp430_ = _position_list;
								_tmp431_ = gee_abstract_list_get ((GeeAbstractList*) _tmp430_, _position_index);
								position = (guint16) ((guintptr) _tmp431_);
								x = (guint8) (position >> 8);
								y = (guint8) position;
								_tmp432_ = nibbles_game_get_worm_props (_data6_->game);
								_tmp433_ = _tmp432_;
								_tmp434_ = nibbles_game_get_worms (_data6_->game);
								_tmp435_ = _tmp434_;
								_tmp436_ = gee_abstract_list_get ((GeeAbstractList*) _tmp435_, i);
								_tmp437_ = (Worm*) _tmp436_;
								_tmp438_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp433_, _tmp437_);
								_tmp439_ = (WormProperties*) _tmp438_;
								_tmp440_ = worm_properties_get_color (_tmp439_);
								_tmp441_ = _tmp440_;
								_tmp442_ = nibbles_game_get_worms (_data6_->game);
								_tmp443_ = _tmp442_;
								_tmp444_ = gee_abstract_list_get ((GeeAbstractList*) _tmp443_, i);
								_tmp445_ = (Worm*) _tmp444_;
								nibbles_view_draw_worm_segment (self, c, (x_delta * x) + x_offset, (y_delta * y) + y_offset, x_delta, y_delta, _tmp441_, TRUE, worm_was_bonus_eaten_at_this_position (_tmp445_, position));
								_g_object_unref0 (_tmp445_);
								_g_object_unref0 (_tmp439_);
								_g_object_unref0 (_tmp437_);
								_tmp446_ = materialized_worm_positions;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp446_, (gpointer) ((guintptr) position));
							}
						}
					} else {
						_vala_array_add3 (&dematerialized_worms, &dematerialized_worms_length1, &_dematerialized_worms_size_, i);
					}
				}
			}
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp447_ = FALSE;
				_tmp447_ = TRUE;
				while (TRUE) {
					gint* _tmp449_;
					gint _tmp449__length1;
					if (!_tmp447_) {
						gint _tmp448_;
						_tmp448_ = i;
						i = _tmp448_ + 1;
					}
					_tmp447_ = FALSE;
					_tmp449_ = dematerialized_worms;
					_tmp449__length1 = dematerialized_worms_length1;
					if (!(i < _tmp449__length1)) {
						break;
					}
					{
						WormPositions* _position_list = NULL;
						GeeLinkedList* _tmp450_;
						GeeLinkedList* _tmp451_;
						gpointer _tmp452_;
						Worm* _tmp453_;
						WormPositions* _tmp454_;
						WormPositions* _tmp455_;
						gint _position_size = 0;
						WormPositions* _tmp456_;
						gint _tmp457_;
						gint _tmp458_;
						gint _position_index = 0;
						_tmp450_ = nibbles_game_get_worms (_data6_->game);
						_tmp451_ = _tmp450_;
						_tmp452_ = gee_abstract_list_get ((GeeAbstractList*) _tmp451_, i);
						_tmp453_ = (Worm*) _tmp452_;
						_tmp454_ = _tmp453_->list;
						_tmp455_ = _tmp454_;
						_g_object_unref0 (_tmp453_);
						_position_list = _tmp455_;
						_tmp456_ = _position_list;
						_tmp457_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp456_);
						_tmp458_ = _tmp457_;
						_position_size = _tmp458_;
						_position_index = -1;
						while (TRUE) {
							gint _tmp459_;
							gint _tmp460_;
							guint16 position = 0U;
							WormPositions* _tmp461_;
							gpointer _tmp462_;
							GeeArrayList* _tmp463_;
							_position_index = _position_index + 1;
							_tmp459_ = _position_index;
							_tmp460_ = _position_size;
							if (!(_tmp459_ < _tmp460_)) {
								break;
							}
							_tmp461_ = _position_list;
							_tmp462_ = gee_abstract_list_get ((GeeAbstractList*) _tmp461_, _position_index);
							position = (guint16) ((guintptr) _tmp462_);
							_tmp463_ = materialized_worm_positions;
							if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp463_, (gpointer) ((guintptr) position))) {
								guint8 x = 0U;
								guint8 y = 0U;
								GeeHashMap* _tmp464_;
								GeeHashMap* _tmp465_;
								GeeLinkedList* _tmp466_;
								GeeLinkedList* _tmp467_;
								gpointer _tmp468_;
								Worm* _tmp469_;
								gpointer _tmp470_;
								WormProperties* _tmp471_;
								gint _tmp472_;
								gint _tmp473_;
								x = (guint8) (position >> 8);
								y = (guint8) position;
								_tmp464_ = nibbles_game_get_worm_props (_data6_->game);
								_tmp465_ = _tmp464_;
								_tmp466_ = nibbles_game_get_worms (_data6_->game);
								_tmp467_ = _tmp466_;
								_tmp468_ = gee_abstract_list_get ((GeeAbstractList*) _tmp467_, i);
								_tmp469_ = (Worm*) _tmp468_;
								_tmp470_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp465_, _tmp469_);
								_tmp471_ = (WormProperties*) _tmp470_;
								_tmp472_ = worm_properties_get_color (_tmp471_);
								_tmp473_ = _tmp472_;
								nibbles_view_draw_worm_segment (self, c, (x_delta * x) + x_offset, (y_delta * y) + y_offset, x_delta, y_delta, _tmp473_, FALSE, FALSE);
								_g_object_unref0 (_tmp471_);
								_g_object_unref0 (_tmp469_);
							}
						}
					}
				}
			}
		}
		{
			GeeList* _bonus_list = NULL;
			GeeList* _tmp474_;
			gint _bonus_size = 0;
			GeeList* _tmp475_;
			gint _tmp476_;
			gint _tmp477_;
			gint _bonus_index = 0;
			_tmp474_ = nibbles_game_get_bonuses (_data6_->game);
			_bonus_list = _tmp474_;
			_tmp475_ = _bonus_list;
			_tmp476_ = gee_collection_get_size ((GeeCollection*) _tmp475_);
			_tmp477_ = _tmp476_;
			_bonus_size = _tmp477_;
			_bonus_index = -1;
			while (TRUE) {
				gint _tmp478_;
				gint _tmp479_;
				Bonus* bonus = NULL;
				GeeList* _tmp480_;
				gpointer _tmp481_;
				Bonus* _tmp482_;
				guint8 _tmp483_;
				guint8 _tmp484_;
				Bonus* _tmp485_;
				guint8 _tmp486_;
				guint8 _tmp487_;
				Bonus* _tmp488_;
				BonusType _tmp489_;
				BonusType _tmp490_;
				_bonus_index = _bonus_index + 1;
				_tmp478_ = _bonus_index;
				_tmp479_ = _bonus_size;
				if (!(_tmp478_ < _tmp479_)) {
					break;
				}
				_tmp480_ = _bonus_list;
				_tmp481_ = gee_list_get (_tmp480_, _bonus_index);
				bonus = (Bonus*) _tmp481_;
				_tmp482_ = bonus;
				_tmp483_ = bonus_get_x (_tmp482_);
				_tmp484_ = _tmp483_;
				_tmp485_ = bonus;
				_tmp486_ = bonus_get_y (_tmp485_);
				_tmp487_ = _tmp486_;
				_tmp488_ = bonus;
				_tmp489_ = bonus_get_bonus_type (_tmp488_);
				_tmp490_ = _tmp489_;
				nibbles_view_draw_bonus (self, c, (x_delta * _tmp484_) + x_offset, (y_delta * _tmp487_) + y_offset, x_delta + x_delta, y_delta + y_delta, _tmp490_);
				_g_object_unref0 (bonus);
			}
			_g_object_unref0 (_bonus_list);
		}
		if (_data6_->countdown_active (_data6_->countdown_active_target) > 0) {
			gchar* text = NULL;
			gchar* _tmp491_;
			gint text_width = 0;
			gdouble w = 0.0;
			gdouble h = 0.0;
			gint font_size = 0;
			const gchar* _tmp492_;
			gdouble _tmp493_ = 0.0;
			gdouble _tmp494_ = 0.0;
			gint _tmp495_;
			const gchar* _tmp496_;
			_tmp491_ = nibbles_view_seconds_string (self, _data6_->countdown_active (_data6_->countdown_active_target));
			text = _tmp491_;
			text_width = x_delta * 10;
			_tmp492_ = text;
			_tmp495_ = nibbles_view_calculate_font_size (self, c, _tmp492_, text_width, &_tmp493_, &_tmp494_);
			w = _tmp493_;
			h = _tmp494_;
			font_size = _tmp495_;
			_tmp496_ = text;
			nibbles_view_draw_text_font_size (self, c, (gint) ((x_offset + (x_delta * (NIBBLES_VIEW_WIDTH / 2))) - (w / 2)), (gint) ((y_offset + (y_delta * (NIBBLES_VIEW_HEIGHT / 2))) - (h / 2)), _tmp496_, font_size);
			{
				GeeLinkedList* _worm_list = NULL;
				GeeLinkedList* _tmp497_;
				GeeLinkedList* _tmp498_;
				gint _worm_size = 0;
				GeeLinkedList* _tmp499_;
				gint _tmp500_;
				gint _tmp501_;
				gint _worm_index = 0;
				_tmp497_ = nibbles_game_get_worms (_data6_->game);
				_tmp498_ = _tmp497_;
				_worm_list = _tmp498_;
				_tmp499_ = _worm_list;
				_tmp500_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp499_);
				_tmp501_ = _tmp500_;
				_worm_size = _tmp501_;
				_worm_index = -1;
				while (TRUE) {
					gint _tmp502_;
					gint _tmp503_;
					Worm* worm = NULL;
					GeeLinkedList* _tmp504_;
					gpointer _tmp505_;
					Worm* _tmp506_;
					WormPositions* _tmp507_;
					gboolean _tmp508_;
					gboolean _tmp509_;
					_worm_index = _worm_index + 1;
					_tmp502_ = _worm_index;
					_tmp503_ = _worm_size;
					if (!(_tmp502_ < _tmp503_)) {
						break;
					}
					_tmp504_ = _worm_list;
					_tmp505_ = gee_abstract_list_get ((GeeAbstractList*) _tmp504_, _worm_index);
					worm = (Worm*) _tmp505_;
					_tmp506_ = worm;
					_tmp507_ = _tmp506_->list;
					_tmp508_ = gee_collection_get_is_empty ((GeeCollection*) _tmp507_);
					_tmp509_ = _tmp508_;
					if (!_tmp509_) {
						gint color = 0;
						GeeHashMap* _tmp510_;
						GeeHashMap* _tmp511_;
						Worm* _tmp512_;
						gpointer _tmp513_;
						WormProperties* _tmp514_;
						gint _tmp515_;
						gint _tmp516_;
						gint _tmp517_;
						gboolean _tmp518_ = FALSE;
						Worm* _tmp519_;
						WormDirection _tmp520_;
						WormDirection _tmp521_;
						_tmp510_ = nibbles_game_get_worm_props (_data6_->game);
						_tmp511_ = _tmp510_;
						_tmp512_ = worm;
						_tmp513_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp511_, _tmp512_);
						_tmp514_ = (WormProperties*) _tmp513_;
						_tmp515_ = worm_properties_get_color (_tmp514_);
						_tmp516_ = _tmp515_;
						_tmp517_ = _tmp516_;
						_g_object_unref0 (_tmp514_);
						color = _tmp517_;
						_tmp519_ = worm;
						_tmp520_ = worm_get_direction (_tmp519_);
						_tmp521_ = _tmp520_;
						if (_tmp521_ == WORM_DIRECTION_UP) {
							_tmp518_ = TRUE;
						} else {
							Worm* _tmp522_;
							WormDirection _tmp523_;
							WormDirection _tmp524_;
							_tmp522_ = worm;
							_tmp523_ = worm_get_direction (_tmp522_);
							_tmp524_ = _tmp523_;
							_tmp518_ = _tmp524_ == WORM_DIRECTION_DOWN;
						}
						if (_tmp518_) {
							gint middle = 0;
							Worm* _tmp525_;
							gint _tmp526_;
							gint _tmp527_;
							Worm* _tmp528_;
							WormPositions* _tmp529_;
							gpointer _tmp530_;
							Worm* _tmp531_;
							WormPositions* _tmp532_;
							gpointer _tmp533_;
							Worm* _tmp534_;
							gint _tmp535_;
							gint _tmp536_;
							gchar* _tmp537_;
							gchar* _tmp538_;
							Worm* _tmp539_;
							gint _tmp540_;
							gint _tmp541_;
							_tmp525_ = worm;
							_tmp526_ = worm_get_length (_tmp525_);
							_tmp527_ = _tmp526_;
							middle = _tmp527_ / 2;
							_tmp528_ = worm;
							_tmp529_ = _tmp528_->list;
							_tmp530_ = gee_abstract_list_get ((GeeAbstractList*) _tmp529_, middle);
							_tmp531_ = worm;
							_tmp532_ = _tmp531_->list;
							_tmp533_ = gee_abstract_list_get ((GeeAbstractList*) _tmp532_, middle);
							_tmp534_ = worm;
							_tmp535_ = worm_get_id (_tmp534_);
							_tmp536_ = _tmp535_;
							_tmp537_ = nibbles_view_worm_name (self, _tmp536_ + 1);
							_tmp538_ = _tmp537_;
							_tmp539_ = worm;
							_tmp540_ = worm_get_length (_tmp539_);
							_tmp541_ = _tmp540_;
							nibbles_view_draw_text_target_width (self, c, (x_offset + (x_delta * ((((guint16) ((guintptr) _tmp530_)) >> 8) + 1))) + (x_delta / 2), y_offset + (y_delta * ((guint8) ((guint16) ((guintptr) _tmp533_)))), _tmp538_, x_delta * _tmp541_, color);
							_g_free0 (_tmp538_);
						} else {
							gboolean _tmp542_ = FALSE;
							Worm* _tmp543_;
							WormDirection _tmp544_;
							WormDirection _tmp545_;
							_tmp543_ = worm;
							_tmp544_ = worm_get_direction (_tmp543_);
							_tmp545_ = _tmp544_;
							if (_tmp545_ == WORM_DIRECTION_LEFT) {
								_tmp542_ = TRUE;
							} else {
								Worm* _tmp546_;
								WormDirection _tmp547_;
								WormDirection _tmp548_;
								_tmp546_ = worm;
								_tmp547_ = worm_get_direction (_tmp546_);
								_tmp548_ = _tmp547_;
								_tmp542_ = _tmp548_ == WORM_DIRECTION_RIGHT;
							}
							if (_tmp542_) {
								gint x = 0;
								Worm* _tmp549_;
								WormPositions* _tmp550_;
								gpointer _tmp551_;
								Worm* _tmp552_;
								WormPositions* _tmp553_;
								Worm* _tmp554_;
								gint _tmp555_;
								gint _tmp556_;
								gpointer _tmp557_;
								Worm* _tmp564_;
								WormPositions* _tmp565_;
								gpointer _tmp566_;
								Worm* _tmp567_;
								gint _tmp568_;
								gint _tmp569_;
								gchar* _tmp570_;
								gchar* _tmp571_;
								Worm* _tmp572_;
								gint _tmp573_;
								gint _tmp574_;
								_tmp549_ = worm;
								_tmp550_ = _tmp549_->list;
								_tmp551_ = gee_abstract_list_get ((GeeAbstractList*) _tmp550_, 0);
								x = ((guint16) ((guintptr) _tmp551_)) >> 8;
								_tmp552_ = worm;
								_tmp553_ = _tmp552_->list;
								_tmp554_ = worm;
								_tmp555_ = worm_get_length (_tmp554_);
								_tmp556_ = _tmp555_;
								_tmp557_ = gee_abstract_list_get ((GeeAbstractList*) _tmp553_, _tmp556_ - 1);
								if (x > (((guint16) ((guintptr) _tmp557_)) >> 8)) {
									Worm* _tmp558_;
									WormPositions* _tmp559_;
									Worm* _tmp560_;
									gint _tmp561_;
									gint _tmp562_;
									gpointer _tmp563_;
									_tmp558_ = worm;
									_tmp559_ = _tmp558_->list;
									_tmp560_ = worm;
									_tmp561_ = worm_get_length (_tmp560_);
									_tmp562_ = _tmp561_;
									_tmp563_ = gee_abstract_list_get ((GeeAbstractList*) _tmp559_, _tmp562_ - 1);
									x = ((guint16) ((guintptr) _tmp563_)) >> 8;
								}
								_tmp564_ = worm;
								_tmp565_ = _tmp564_->list;
								_tmp566_ = gee_abstract_list_get ((GeeAbstractList*) _tmp565_, 0);
								_tmp567_ = worm;
								_tmp568_ = worm_get_id (_tmp567_);
								_tmp569_ = _tmp568_;
								_tmp570_ = nibbles_view_worm_name (self, _tmp569_ + 1);
								_tmp571_ = _tmp570_;
								_tmp572_ = worm;
								_tmp573_ = worm_get_length (_tmp572_);
								_tmp574_ = _tmp573_;
								nibbles_view_draw_text_target_width (self, c, x_offset + (x_delta * x), (y_offset + (y_delta * ((guint8) ((guint16) ((guintptr) _tmp566_))))) - y_delta, _tmp571_, x_delta * _tmp574_, color);
								_g_free0 (_tmp571_);
							}
						}
					}
					_g_object_unref0 (worm);
				}
			}
			_g_free0 (text);
		}
		_tmp578_ = _data6_->new_game_dialogue_active (&_tmp575_, &_tmp576_, &_tmp577_, _data6_->new_game_dialogue_active_target);
		(self->priv->result_function_target_destroy_notify == NULL) ? NULL : (self->priv->result_function_target_destroy_notify (self->priv->result_function_target), NULL);
		self->priv->result_function = NULL;
		self->priv->result_function_target = NULL;
		self->priv->result_function_target_destroy_notify = NULL;
		self->priv->result_function = _tmp575_;
		self->priv->result_function_target = _tmp576_;
		self->priv->result_function_target_destroy_notify = _tmp577_;
		if (_tmp578_) {
			YesNoResultFunction _tmp579_;
			gpointer _tmp579__target;
			_tmp579_ = self->priv->result_function;
			_tmp579__target = self->priv->result_function_target;
			nibbles_view_new_game_dialogue_draw (self, c, (gdouble) width, (gdouble) height, _tmp579_, _tmp579__target);
		}
		dematerialized_worms = (g_free (dematerialized_worms), NULL);
		_g_object_unref0 (materialized_worm_positions);
	}
}

static void
___lambda18__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                         cairo_t* cr,
                                         gint width,
                                         gint height,
                                         gpointer self)
{
	__lambda18_ (self, drawing_area, cr, width, height);
}

NibblesView*
nibbles_view_construct (GType object_type,
                        NibblesGame* game,
                        NibblesViewCountdownActiveFunction countdown_active,
                        gpointer countdown_active_target,
                        NewGameDialogueActiveFunction new_game_dialogue_active,
                        gpointer new_game_dialogue_active_target)
{
	NibblesView * self = NULL;
	Block6Data* _data6_;
	NibblesGame* _tmp0_;
	NibblesGame* _tmp1_;
	g_return_val_if_fail (game != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (_data6_->game);
	_data6_->game = _tmp0_;
	_data6_->countdown_active = countdown_active;
	_data6_->countdown_active_target = countdown_active_target;
	_data6_->new_game_dialogue_active = new_game_dialogue_active;
	_data6_->new_game_dialogue_active_target = new_game_dialogue_active_target;
	self = (NibblesView*) g_object_new (object_type, NULL);
	_data6_->self = g_object_ref (self);
	_tmp1_ = _g_object_ref0 (_data6_->game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp1_;
	(self->priv->countdown_active_target_destroy_notify == NULL) ? NULL : (self->priv->countdown_active_target_destroy_notify (self->priv->countdown_active_target), NULL);
	self->priv->countdown_active = NULL;
	self->priv->countdown_active_target = NULL;
	self->priv->countdown_active_target_destroy_notify = NULL;
	self->priv->countdown_active = (NibblesViewCountdownActiveFunction) _data6_->countdown_active;
	self->priv->countdown_active_target = _data6_->countdown_active_target;
	self->priv->countdown_active_target_destroy_notify = NULL;
	(self->priv->new_game_dialogue_active_target_destroy_notify == NULL) ? NULL : (self->priv->new_game_dialogue_active_target_destroy_notify (self->priv->new_game_dialogue_active_target), NULL);
	self->priv->new_game_dialogue_active = NULL;
	self->priv->new_game_dialogue_active_target = NULL;
	self->priv->new_game_dialogue_active_target_destroy_notify = NULL;
	self->priv->new_game_dialogue_active = (NewGameDialogueActiveFunction) _data6_->new_game_dialogue_active;
	self->priv->new_game_dialogue_active_target = _data6_->new_game_dialogue_active_target;
	self->priv->new_game_dialogue_active_target_destroy_notify = NULL;
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) ___lambda16__gtk_widget_realize, self, 0);
	g_signal_connect_object ((GtkDrawingArea*) self, "resize", (GCallback) ___lambda17__gtk_drawing_area_resize, self, 0);
	gtk_widget_set_focusable ((GtkWidget*) self, TRUE);
	gtk_drawing_area_set_draw_func ((GtkDrawingArea*) self, ___lambda18__gtk_drawing_area_draw_func, block6_data_ref (_data6_), block6_data_unref);
	nibbles_view_connect_game_signals (self, _data6_->game);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return self;
}

NibblesView*
nibbles_view_new (NibblesGame* game,
                  NibblesViewCountdownActiveFunction countdown_active,
                  gpointer countdown_active_target,
                  NewGameDialogueActiveFunction new_game_dialogue_active,
                  gpointer new_game_dialogue_active_target)
{
	return nibbles_view_construct (TYPE_NIBBLES_VIEW, game, countdown_active, countdown_active_target, new_game_dialogue_active, new_game_dialogue_active_target);
}

static gchar*
nibbles_view_seconds_string (NibblesView* self,
                             gint s)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (s) {
		case 1:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("1"));
			result = _tmp0_;
			return result;
		}
		case 2:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("2"));
			result = _tmp1_;
			return result;
		}
		case 3:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("3"));
			result = _tmp2_;
			return result;
		}
		default:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("");
			result = _tmp3_;
			return result;
		}
	}
}

static gchar*
nibbles_view_worm_name (NibblesView* self,
                        gint id)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (id) {
		case 1:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Worm 1"));
			result = _tmp0_;
			return result;
		}
		case 2:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Worm 2"));
			result = _tmp1_;
			return result;
		}
		case 3:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Worm 3"));
			result = _tmp2_;
			return result;
		}
		case 4:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Worm 4"));
			result = _tmp3_;
			return result;
		}
		case 5:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("Worm 5"));
			result = _tmp4_;
			return result;
		}
		case 6:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Worm 6"));
			result = _tmp5_;
			return result;
		}
		default:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup ("");
			result = _tmp6_;
			return result;
		}
	}
}

void
nibbles_view_redraw (NibblesView* self,
                     gboolean AnimateStep)
{
	g_return_if_fail (self != NULL);
	if (AnimateStep) {
		guint64 _tmp0_;
		self->priv->animate = self->priv->animate + 1;
		_tmp0_ = self->priv->animate;
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
_nibbles_view_redraw_nibbles_game_redraw (NibblesGame* _sender,
                                          gboolean animate,
                                          gpointer self)
{
	nibbles_view_redraw ((NibblesView*) self, animate);
}

void
nibbles_view_connect_game_signals (NibblesView* self,
                                   NibblesGame* game)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	g_signal_connect_object (game, "redraw", (GCallback) _nibbles_view_redraw_nibbles_game_redraw, self, 0);
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		NibblesView* self;
		self = _data7_->self;
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda19_ (NibblesView* self,
             gdouble x,
             gdouble y)
{
	nibbles_view_yesno_position (self, x, y);
}

static void
___lambda19__gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                 gdouble x,
                                                 gdouble y,
                                                 gpointer self)
{
	__lambda19_ ((NibblesView*) self, x, y);
}

static void
__lambda20_ (NibblesView* self,
             gdouble x,
             gdouble y)
{
	nibbles_view_yesno_position (self, x, y);
}

static void
___lambda20__gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                gdouble x,
                                                gdouble y,
                                                gpointer self)
{
	__lambda20_ ((NibblesView*) self, x, y);
}

static gboolean
__lambda21_ (Block7Data* _data7_,
             GdkEvent* event)
{
	NibblesView* self;
	gboolean result;
	self = _data7_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (gdk_event_get_event_type (event)) {
		case GDK_BUTTON_PRESS:
		{
			self->priv->mouse_pressed = TRUE;
			nibbles_view_redraw (self, FALSE);
			result = TRUE;
			return result;
		}
		case GDK_BUTTON_RELEASE:
		{
			self->priv->mouse_pressed = FALSE;
			if (self->priv->mouse_button > ((guint) 1)) {
				nibbles_view_redraw (self, FALSE);
			} else {
				_data7_->result_function (self->priv->mouse_button, _data7_->result_function_target);
			}
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gboolean
___lambda21__gtk_event_controller_legacy_event (GtkEventControllerLegacy* _sender,
                                                GdkEvent* event,
                                                gpointer self)
{
	gboolean result;
	result = __lambda21_ (self, event);
	return result;
}

static void
nibbles_view_new_game_dialogue_draw (NibblesView* self,
                                     cairo_t* c,
                                     gdouble width,
                                     gdouble height,
                                     YesNoResultFunction result_function,
                                     gpointer result_function_target)
{
	Block7Data* _data7_;
	gchar* text = NULL;
	gchar* _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	GtkEventControllerMotion* mouse_position = NULL;
	GtkEventControllerMotion* _tmp9_;
	GtkEventControllerLegacy* mouse_click = NULL;
	GtkEventControllerLegacy* _tmp10_;
	GtkEventController* _tmp11_;
	GtkEventController* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->result_function = result_function;
	_data7_->result_function_target = result_function_target;
	_tmp0_ = g_strdup (_ ("Are you sure you want to start a new game?\n" \
"If you start a new game, the current one will be lost."));
	text = _tmp0_;
	nibbles_view_draw_dialogue (self, c, width, height, text, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, TRUE);
	self->priv->b0_x = _tmp1_;
	self->priv->b0_y = _tmp2_;
	self->priv->b0_width = _tmp3_;
	self->priv->b0_height = _tmp4_;
	self->priv->b1_x = _tmp5_;
	self->priv->b1_y = _tmp6_;
	self->priv->b1_width = _tmp7_;
	self->priv->b1_height = _tmp8_;
	_tmp9_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ();
	mouse_position = _tmp9_;
	g_signal_connect_object (mouse_position, "motion", (GCallback) ___lambda19__gtk_event_controller_motion_motion, self, 0);
	g_signal_connect_object (mouse_position, "enter", (GCallback) ___lambda20__gtk_event_controller_motion_enter, self, 0);
	_tmp10_ = (GtkEventControllerLegacy*) gtk_event_controller_legacy_new ();
	mouse_click = _tmp10_;
	g_signal_connect_data (mouse_click, "event", (GCallback) ___lambda21__gtk_event_controller_legacy_event, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp11_ = _g_object_ref0 ((GtkEventController*) mouse_click);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp11_);
	_tmp12_ = _g_object_ref0 ((GtkEventController*) mouse_position);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp12_);
	_g_object_unref0 (mouse_click);
	_g_object_unref0 (mouse_position);
	_g_free0 (text);
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
nibbles_view_yesno_position (NibblesView* self,
                             gdouble x,
                             gdouble y)
{
	guint new_button = 0U;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	if (x >= self->priv->b0_x) {
		_tmp2_ = x <= (self->priv->b0_x + self->priv->b0_width);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = y >= self->priv->b0_y;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = y <= (self->priv->b0_y + self->priv->b0_height);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		new_button = (guint) 0;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		if (x >= self->priv->b1_x) {
			_tmp5_ = x <= (self->priv->b1_x + self->priv->b1_width);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			_tmp4_ = y >= self->priv->b1_y;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			_tmp3_ = y <= (self->priv->b1_y + self->priv->b1_height);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			new_button = (guint) 1;
		} else {
			new_button = G_MAXUINT;
		}
	}
	if (new_button != self->priv->mouse_button) {
		self->priv->mouse_button = new_button;
		nibbles_view_redraw (self, FALSE);
	}
}

static void
nibbles_view_draw_oval (NibblesView* self,
                        cairo_t* C,
                        NibblesViewView3D* v,
                        NibblesViewPoint3D* a,
                        NibblesViewPoint3D* b,
                        NibblesViewPoint3D* c,
                        NibblesViewPoint3D* d)
{
	gdouble x[3] = {0};
	gdouble y[3] = {0};
	NibblesViewPoint3D p[8] = {0};
	NibblesViewPoint3D _tmp0_;
	NibblesViewPoint3D _tmp1_;
	NibblesViewPoint3D _tmp2_;
	NibblesViewPoint3D _tmp3_ = {0};
	NibblesViewPoint3D _tmp4_;
	NibblesViewPoint3D _tmp5_;
	NibblesViewPoint3D _tmp6_;
	NibblesViewPoint3D _tmp7_ = {0};
	NibblesViewPoint3D _tmp8_;
	NibblesViewPoint3D _tmp9_;
	NibblesViewPoint3D _tmp10_;
	NibblesViewPoint3D _tmp11_ = {0};
	NibblesViewPoint3D _tmp12_;
	NibblesViewPoint3D _tmp13_;
	NibblesViewPoint3D _tmp14_;
	NibblesViewPoint3D _tmp15_ = {0};
	NibblesViewPoint3D _tmp16_[8] = {0};
	guint lowest_y_midpoint_index = 0U;
	guint second_lowest_y_midpoint_index = 0U;
	gint _tmp26_ = 0;
	gint direction = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	g_return_if_fail (v != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (d != NULL);
	_tmp0_ = *a;
	_tmp1_ = *a;
	_tmp2_ = *b;
	nibbles_view_mid_point (self, &_tmp1_, &_tmp2_, &_tmp3_);
	_tmp4_ = *b;
	_tmp5_ = *b;
	_tmp6_ = *c;
	nibbles_view_mid_point (self, &_tmp5_, &_tmp6_, &_tmp7_);
	_tmp8_ = *c;
	_tmp9_ = *c;
	_tmp10_ = *d;
	nibbles_view_mid_point (self, &_tmp9_, &_tmp10_, &_tmp11_);
	_tmp12_ = *d;
	_tmp13_ = *d;
	_tmp14_ = *a;
	nibbles_view_mid_point (self, &_tmp13_, &_tmp14_, &_tmp15_);
	_tmp16_[0] = _tmp0_;
	_tmp16_[1] = _tmp3_;
	_tmp16_[2] = _tmp4_;
	_tmp16_[3] = _tmp7_;
	_tmp16_[4] = _tmp8_;
	_tmp16_[5] = _tmp11_;
	_tmp16_[6] = _tmp12_;
	_tmp16_[7] = _tmp15_;
	memcpy (p, _tmp16_, 8 * sizeof (NibblesViewPoint3D));
	lowest_y_midpoint_index = G_MAXUINT;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_ = FALSE;
				if (!_tmp17_) {
					i += 2;
				}
				_tmp17_ = FALSE;
				if (!(i < 8)) {
					break;
				}
				if (lowest_y_midpoint_index == G_MAXUINT) {
					_tmp18_ = TRUE;
				} else {
					NibblesViewPoint3D _tmp19_;
					NibblesViewPoint3D _tmp20_;
					_tmp19_ = p[lowest_y_midpoint_index];
					_tmp20_ = p[i];
					_tmp18_ = _tmp19_.y > _tmp20_.y;
				}
				if (_tmp18_) {
					lowest_y_midpoint_index = (guint) i;
				}
			}
		}
	}
	second_lowest_y_midpoint_index = G_MAXUINT;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				gboolean _tmp22_ = FALSE;
				if (!_tmp21_) {
					i += 2;
				}
				_tmp21_ = FALSE;
				if (!(i < 8)) {
					break;
				}
				if (((guint) i) != lowest_y_midpoint_index) {
					gboolean _tmp23_ = FALSE;
					if (second_lowest_y_midpoint_index == G_MAXUINT) {
						_tmp23_ = TRUE;
					} else {
						NibblesViewPoint3D _tmp24_;
						NibblesViewPoint3D _tmp25_;
						_tmp24_ = p[second_lowest_y_midpoint_index];
						_tmp25_ = p[i];
						_tmp23_ = _tmp24_.y > _tmp25_.y;
					}
					_tmp22_ = _tmp23_;
				} else {
					_tmp22_ = FALSE;
				}
				if (_tmp22_) {
					second_lowest_y_midpoint_index = (guint) i;
				}
			}
		}
	}
	if (second_lowest_y_midpoint_index > lowest_y_midpoint_index) {
		_tmp26_ = -1;
	} else {
		_tmp26_ = 1;
	}
	direction = _tmp26_;
	{
		guint i = 0U;
		i = second_lowest_y_midpoint_index;
		{
			gboolean _tmp27_ = FALSE;
			_tmp27_ = TRUE;
			while (TRUE) {
				gint between_point = 0;
				gint next_index = 0;
				NibblesViewPoint3D _tmp28_;
				gdouble _tmp29_ = 0.0;
				gdouble _tmp30_ = 0.0;
				NibblesViewPoint3D _tmp31_;
				gdouble _tmp32_ = 0.0;
				gdouble _tmp33_ = 0.0;
				NibblesViewPoint3D _tmp34_;
				gdouble _tmp35_ = 0.0;
				gdouble _tmp36_ = 0.0;
				gdouble _tmp39_;
				gdouble _tmp40_;
				gdouble _tmp41_;
				gdouble _tmp42_;
				gdouble _tmp43_;
				gdouble _tmp44_;
				if (!_tmp27_) {
				}
				_tmp27_ = FALSE;
				between_point = ((gint) i) + direction;
				next_index = between_point + direction;
				if (between_point < 0) {
					between_point += 8;
				} else {
					if (between_point > 7) {
						between_point -= 8;
					}
				}
				if (next_index < 0) {
					next_index += 8;
				} else {
					if (next_index > 7) {
						next_index -= 8;
					}
				}
				_tmp28_ = p[i];
				nibbles_view_view3_d_to_view_plain (v, &_tmp28_, &_tmp29_, &_tmp30_);
				x[0] = _tmp29_;
				y[0] = _tmp30_;
				_tmp31_ = p[between_point];
				nibbles_view_view3_d_to_view_plain (v, &_tmp31_, &_tmp32_, &_tmp33_);
				x[1] = _tmp32_;
				y[1] = _tmp33_;
				_tmp34_ = p[next_index];
				nibbles_view_view3_d_to_view_plain (v, &_tmp34_, &_tmp35_, &_tmp36_);
				x[2] = _tmp35_;
				y[2] = _tmp36_;
				if (i == second_lowest_y_midpoint_index) {
					gdouble _tmp37_;
					gdouble _tmp38_;
					_tmp37_ = x[0];
					_tmp38_ = y[0];
					cairo_move_to (C, _tmp37_, _tmp38_);
				}
				_tmp39_ = x[0];
				_tmp40_ = y[0];
				_tmp41_ = x[1];
				_tmp42_ = y[1];
				_tmp43_ = x[2];
				_tmp44_ = y[2];
				cairo_curve_to (C, _tmp39_, _tmp40_, _tmp41_, _tmp42_, _tmp43_, _tmp44_);
				i = (guint) next_index;
				if (i == second_lowest_y_midpoint_index) {
					break;
				}
			}
		}
	}
}

static void
nibbles_view_mid_point (NibblesView* self,
                        NibblesViewPoint3D* a,
                        NibblesViewPoint3D* b,
                        NibblesViewPoint3D* result)
{
	gdouble _tmp0_ = 0.0;
	NibblesViewPoint3D _tmp1_;
	NibblesViewPoint3D _tmp2_;
	gdouble _tmp9_ = 0.0;
	NibblesViewPoint3D _tmp10_;
	NibblesViewPoint3D _tmp11_;
	gdouble _tmp18_ = 0.0;
	NibblesViewPoint3D _tmp19_;
	NibblesViewPoint3D _tmp20_;
	NibblesViewPoint3D _tmp27_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (a != NULL);
	g_return_if_fail (b != NULL);
	_tmp1_ = *a;
	_tmp2_ = *b;
	if (_tmp1_.x > _tmp2_.x) {
		NibblesViewPoint3D _tmp3_;
		NibblesViewPoint3D _tmp4_;
		NibblesViewPoint3D _tmp5_;
		_tmp3_ = *a;
		_tmp4_ = *b;
		_tmp5_ = *b;
		_tmp0_ = ((_tmp3_.x - _tmp4_.x) / 2) + _tmp5_.x;
	} else {
		NibblesViewPoint3D _tmp6_;
		NibblesViewPoint3D _tmp7_;
		NibblesViewPoint3D _tmp8_;
		_tmp6_ = *b;
		_tmp7_ = *a;
		_tmp8_ = *a;
		_tmp0_ = ((_tmp6_.x - _tmp7_.x) / 2) + _tmp8_.x;
	}
	_tmp10_ = *a;
	_tmp11_ = *b;
	if (_tmp10_.y > _tmp11_.y) {
		NibblesViewPoint3D _tmp12_;
		NibblesViewPoint3D _tmp13_;
		NibblesViewPoint3D _tmp14_;
		_tmp12_ = *a;
		_tmp13_ = *b;
		_tmp14_ = *b;
		_tmp9_ = ((_tmp12_.y - _tmp13_.y) / 2) + _tmp14_.y;
	} else {
		NibblesViewPoint3D _tmp15_;
		NibblesViewPoint3D _tmp16_;
		NibblesViewPoint3D _tmp17_;
		_tmp15_ = *b;
		_tmp16_ = *a;
		_tmp17_ = *a;
		_tmp9_ = ((_tmp15_.y - _tmp16_.y) / 2) + _tmp17_.y;
	}
	_tmp19_ = *a;
	_tmp20_ = *b;
	if (_tmp19_.z > _tmp20_.z) {
		NibblesViewPoint3D _tmp21_;
		NibblesViewPoint3D _tmp22_;
		NibblesViewPoint3D _tmp23_;
		_tmp21_ = *a;
		_tmp22_ = *b;
		_tmp23_ = *b;
		_tmp18_ = ((_tmp21_.z - _tmp22_.z) / 2) + _tmp23_.z;
	} else {
		NibblesViewPoint3D _tmp24_;
		NibblesViewPoint3D _tmp25_;
		NibblesViewPoint3D _tmp26_;
		_tmp24_ = *b;
		_tmp25_ = *a;
		_tmp26_ = *a;
		_tmp18_ = ((_tmp24_.z - _tmp25_.z) / 2) + _tmp26_.z;
	}
	_tmp27_.x = _tmp0_;
	_tmp27_.y = _tmp9_;
	_tmp27_.z = _tmp18_;
	*result = _tmp27_;
	return;
}

static void
nibbles_view_draw_sphere (NibblesView* self,
                          cairo_t* c,
                          NibblesViewView3D* v,
                          gint x,
                          gint y,
                          gdouble r,
                          gdouble g,
                          gdouble b,
                          gdouble size)
{
	gdouble increase = 0.0;
	NibblesViewPoint3D _tmp0_ = {0};
	NibblesViewPoint3D _tmp1_ = {0};
	NibblesViewPoint3D _tmp2_ = {0};
	NibblesViewPoint3D _tmp3_ = {0};
	gdouble X = 0.0;
	gdouble Y = 0.0;
	gdouble radius = 0.0;
	gdouble d = 0.0;
	gdouble top_x = 0.0;
	gdouble top_y = 0.0;
	NibblesViewPoint3D _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	NibblesViewPoint3D _tmp7_ = {0};
	NibblesViewPoint3D _tmp8_ = {0};
	NibblesViewPoint3D _tmp9_ = {0};
	NibblesViewPoint3D _tmp10_ = {0};
	NibblesViewPoint3D _tmp11_ = {0};
	NibblesViewPoint3D _tmp12_ = {0};
	NibblesViewPoint3D _tmp13_ = {0};
	NibblesViewPoint3D _tmp14_ = {0};
	NibblesViewPoint3D _tmp15_ = {0};
	gdouble _tmp16_ = 0.0;
	gdouble _tmp17_ = 0.0;
	cairo_pattern_t* pat2 = NULL;
	cairo_pattern_t* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (v != NULL);
	increase = (size - 1) / 2;
	_tmp0_.x = (x + 0) - increase;
	_tmp0_.y = (y + 1.0) + increase;
	_tmp0_.z = 0 - increase;
	_tmp1_.x = (x + 0) - increase;
	_tmp1_.y = (y + 0.0) - increase;
	_tmp1_.z = 1 + increase;
	_tmp2_.x = (x + 1) + increase;
	_tmp2_.y = (y + 0.0) - increase;
	_tmp2_.z = 1 + increase;
	_tmp3_.x = (x + 1) + increase;
	_tmp3_.y = (y + 1.0) + increase;
	_tmp3_.z = 0 - increase;
	nibbles_view_draw_oval (self, c, v, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	_tmp4_.x = x + 0.5;
	_tmp4_.y = y + 0.5;
	_tmp4_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp4_, &_tmp5_, &_tmp6_);
	X = _tmp5_;
	Y = _tmp6_;
	_tmp7_.x = x + 0.5;
	_tmp7_.y = y + 0.5;
	_tmp7_.z = 0.5;
	_tmp8_.x = x + 0.5;
	_tmp8_.y = (y + 0.0) - increase;
	_tmp8_.z = 1 + increase;
	radius = nibbles_view_view3_d_2D_diff (v, &_tmp7_, &_tmp8_);
	_tmp9_.x = x + 0.5;
	_tmp9_.y = y + 0.5;
	_tmp9_.z = 0.5;
	_tmp10_.x = (x + 0.0) - increase;
	_tmp10_.y = y + 0.5;
	_tmp10_.z = 0.5;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp9_, &_tmp10_);
	if (d > radius) {
		radius = d;
	}
	_tmp11_.x = x + 0.5;
	_tmp11_.y = y + 0.5;
	_tmp11_.z = 0.5;
	_tmp12_.x = (x + 1.0) + increase;
	_tmp12_.y = y + 0.5;
	_tmp12_.z = 0.5;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp11_, &_tmp12_);
	if (d > radius) {
		radius = d;
	}
	_tmp13_.x = x + 0.5;
	_tmp13_.y = y + 0.5;
	_tmp13_.z = 0.5;
	_tmp14_.x = x + 0.5;
	_tmp14_.y = (y + 1.0) + increase;
	_tmp14_.z = 0.0 - increase;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp13_, &_tmp14_);
	if (d > radius) {
		radius = d;
	}
	_tmp15_.x = x + 0.5;
	_tmp15_.y = y + 0.5;
	_tmp15_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp15_, &_tmp16_, &_tmp17_);
	top_x = _tmp16_;
	top_y = _tmp17_;
	_tmp18_ = cairo_pattern_create_radial (X, Y, radius, top_x, top_y, radius / 20.0);
	pat2 = _tmp18_;
	cairo_pattern_add_color_stop_rgb (pat2, (gdouble) 0, r / 10, g / 10, b / 10);
	cairo_pattern_add_color_stop_rgb (pat2, (gdouble) 1, r, g, b);
	cairo_pattern_add_color_stop_rgb (pat2, (gdouble) 2, ((1 - r) / 2) + r, ((1 - g) / 2) + g, ((1 - b) / 2) + b);
	cairo_set_source (c, pat2);
	cairo_fill (c);
	_cairo_pattern_destroy0 (pat2);
}

static void
nibbles_view_draw_eyes_front (NibblesView* self,
                              cairo_t* c,
                              NibblesViewView3D* v,
                              gint x,
                              gint y,
                              gboolean blink)
{
	gdouble e = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble b = 0.0;
	NibblesViewPoint3D centre = {0};
	NibblesViewPoint3D _tmp1_ = {0};
	NibblesViewPoint3D _tmp2_;
	NibblesViewPoint3D _tmp3_;
	NibblesViewPoint3D _tmp4_;
	NibblesViewPoint3D _tmp5_ = {0};
	NibblesViewPoint3D _tmp6_;
	NibblesViewPoint3D _tmp7_;
	NibblesViewPoint3D _tmp8_;
	NibblesViewPoint3D _tmp9_ = {0};
	NibblesViewPoint3D _tmp10_;
	NibblesViewPoint3D _tmp11_;
	NibblesViewPoint3D _tmp12_;
	NibblesViewPoint3D _tmp13_ = {0};
	NibblesViewPoint3D _tmp14_;
	NibblesViewPoint3D _tmp15_;
	NibblesViewPoint3D _tmp16_;
	NibblesViewPoint3D _tmp17_ = {0};
	NibblesViewPoint3D _tmp18_ = {0};
	NibblesViewPoint3D _tmp19_;
	NibblesViewPoint3D _tmp20_;
	NibblesViewPoint3D _tmp21_;
	NibblesViewPoint3D _tmp22_ = {0};
	NibblesViewPoint3D _tmp23_;
	NibblesViewPoint3D _tmp24_;
	NibblesViewPoint3D _tmp25_;
	NibblesViewPoint3D _tmp26_ = {0};
	NibblesViewPoint3D _tmp27_;
	NibblesViewPoint3D _tmp28_;
	NibblesViewPoint3D _tmp29_;
	NibblesViewPoint3D _tmp30_ = {0};
	NibblesViewPoint3D _tmp31_;
	NibblesViewPoint3D _tmp32_;
	NibblesViewPoint3D _tmp33_;
	NibblesViewPoint3D _tmp34_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (v != NULL);
	e = sqrt (0.125);
	if (blink) {
		_tmp0_ = 0.025;
	} else {
		_tmp0_ = 0.1;
	}
	b = _tmp0_;
	_tmp1_.x = (x + 0.5) - (e / 2);
	_tmp1_.y = (y + 0.5) + e;
	_tmp1_.z = 0.5 + (e / 2);
	centre = _tmp1_;
	_tmp2_ = centre;
	_tmp3_ = centre;
	_tmp4_ = centre;
	_tmp5_.x = _tmp2_.x - 0.1;
	_tmp5_.y = _tmp3_.y + b;
	_tmp5_.z = _tmp4_.z - b;
	_tmp6_ = centre;
	_tmp7_ = centre;
	_tmp8_ = centre;
	_tmp9_.x = _tmp6_.x - 0.1;
	_tmp9_.y = _tmp7_.y - b;
	_tmp9_.z = _tmp8_.z + b;
	_tmp10_ = centre;
	_tmp11_ = centre;
	_tmp12_ = centre;
	_tmp13_.x = _tmp10_.x + 0.1;
	_tmp13_.y = _tmp11_.y - b;
	_tmp13_.z = _tmp12_.z + b;
	_tmp14_ = centre;
	_tmp15_ = centre;
	_tmp16_ = centre;
	_tmp17_.x = _tmp14_.x + 0.1;
	_tmp17_.y = _tmp15_.y + b;
	_tmp17_.z = _tmp16_.z - b;
	nibbles_view_draw_oval (self, c, v, &_tmp5_, &_tmp9_, &_tmp13_, &_tmp17_);
	cairo_set_source_rgb (c, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_fill (c);
	_tmp18_.x = (x + 0.5) + (e / 2);
	_tmp18_.y = (y + 0.5) + e;
	_tmp18_.z = 0.5 + (e / 2);
	centre = _tmp18_;
	_tmp19_ = centre;
	_tmp20_ = centre;
	_tmp21_ = centre;
	_tmp22_.x = _tmp19_.x - 0.1;
	_tmp22_.y = _tmp20_.y + b;
	_tmp22_.z = _tmp21_.z - b;
	_tmp23_ = centre;
	_tmp24_ = centre;
	_tmp25_ = centre;
	_tmp26_.x = _tmp23_.x - 0.1;
	_tmp26_.y = _tmp24_.y - b;
	_tmp26_.z = _tmp25_.z + b;
	_tmp27_ = centre;
	_tmp28_ = centre;
	_tmp29_ = centre;
	_tmp30_.x = _tmp27_.x + 0.1;
	_tmp30_.y = _tmp28_.y - b;
	_tmp30_.z = _tmp29_.z + b;
	_tmp31_ = centre;
	_tmp32_ = centre;
	_tmp33_ = centre;
	_tmp34_.x = _tmp31_.x + 0.1;
	_tmp34_.y = _tmp32_.y + b;
	_tmp34_.z = _tmp33_.z - b;
	nibbles_view_draw_oval (self, c, v, &_tmp22_, &_tmp26_, &_tmp30_, &_tmp34_);
	cairo_set_source_rgb (c, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_fill (c);
}

static void
nibbles_view_draw_eyes_left (NibblesView* self,
                             cairo_t* c,
                             NibblesViewView3D* v,
                             gint x,
                             gint y,
                             gboolean blink)
{
	gdouble e = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble b = 0.0;
	NibblesViewPoint3D centre = {0};
	NibblesViewPoint3D _tmp1_ = {0};
	NibblesViewPoint3D _tmp2_;
	NibblesViewPoint3D _tmp3_;
	NibblesViewPoint3D _tmp4_;
	NibblesViewPoint3D _tmp5_ = {0};
	NibblesViewPoint3D _tmp6_;
	NibblesViewPoint3D _tmp7_;
	NibblesViewPoint3D _tmp8_;
	NibblesViewPoint3D _tmp9_ = {0};
	NibblesViewPoint3D _tmp10_;
	NibblesViewPoint3D _tmp11_;
	NibblesViewPoint3D _tmp12_;
	NibblesViewPoint3D _tmp13_ = {0};
	NibblesViewPoint3D _tmp14_;
	NibblesViewPoint3D _tmp15_;
	NibblesViewPoint3D _tmp16_;
	NibblesViewPoint3D _tmp17_ = {0};
	NibblesViewPoint3D _tmp18_ = {0};
	NibblesViewPoint3D _tmp19_;
	NibblesViewPoint3D _tmp20_;
	NibblesViewPoint3D _tmp21_;
	NibblesViewPoint3D _tmp22_ = {0};
	NibblesViewPoint3D _tmp23_;
	NibblesViewPoint3D _tmp24_;
	NibblesViewPoint3D _tmp25_;
	NibblesViewPoint3D _tmp26_ = {0};
	NibblesViewPoint3D _tmp27_;
	NibblesViewPoint3D _tmp28_;
	NibblesViewPoint3D _tmp29_;
	NibblesViewPoint3D _tmp30_ = {0};
	NibblesViewPoint3D _tmp31_;
	NibblesViewPoint3D _tmp32_;
	NibblesViewPoint3D _tmp33_;
	NibblesViewPoint3D _tmp34_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (v != NULL);
	e = sqrt (0.125);
	if (blink) {
		_tmp0_ = 0.025;
	} else {
		_tmp0_ = 0.1;
	}
	b = _tmp0_;
	_tmp1_.x = (x + 0.5) - e;
	_tmp1_.y = (y + 0.5) - (e / 2);
	_tmp1_.z = 0.5 + (e / 2);
	centre = _tmp1_;
	_tmp2_ = centre;
	_tmp3_ = centre;
	_tmp4_ = centre;
	_tmp5_.x = _tmp2_.x - b;
	_tmp5_.y = _tmp3_.y - 0.1;
	_tmp5_.z = _tmp4_.z - b;
	_tmp6_ = centre;
	_tmp7_ = centre;
	_tmp8_ = centre;
	_tmp9_.x = _tmp6_.x + b;
	_tmp9_.y = _tmp7_.y - 0.1;
	_tmp9_.z = _tmp8_.z + b;
	_tmp10_ = centre;
	_tmp11_ = centre;
	_tmp12_ = centre;
	_tmp13_.x = _tmp10_.x + b;
	_tmp13_.y = _tmp11_.y + 0.1;
	_tmp13_.z = _tmp12_.z + b;
	_tmp14_ = centre;
	_tmp15_ = centre;
	_tmp16_ = centre;
	_tmp17_.x = _tmp14_.x - b;
	_tmp17_.y = _tmp15_.y + 0.1;
	_tmp17_.z = _tmp16_.z - b;
	nibbles_view_draw_oval (self, c, v, &_tmp5_, &_tmp9_, &_tmp13_, &_tmp17_);
	cairo_set_source_rgb (c, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_fill (c);
	_tmp18_.x = (x + 0.5) - e;
	_tmp18_.y = (y + 0.5) + (e / 2);
	_tmp18_.z = 0.5 + (e / 2);
	centre = _tmp18_;
	_tmp19_ = centre;
	_tmp20_ = centre;
	_tmp21_ = centre;
	_tmp22_.x = _tmp19_.x - b;
	_tmp22_.y = _tmp20_.y - 0.1;
	_tmp22_.z = _tmp21_.z - b;
	_tmp23_ = centre;
	_tmp24_ = centre;
	_tmp25_ = centre;
	_tmp26_.x = _tmp23_.x + b;
	_tmp26_.y = _tmp24_.y - 0.1;
	_tmp26_.z = _tmp25_.z + b;
	_tmp27_ = centre;
	_tmp28_ = centre;
	_tmp29_ = centre;
	_tmp30_.x = _tmp27_.x + b;
	_tmp30_.y = _tmp28_.y + 0.1;
	_tmp30_.z = _tmp29_.z + b;
	_tmp31_ = centre;
	_tmp32_ = centre;
	_tmp33_ = centre;
	_tmp34_.x = _tmp31_.x - b;
	_tmp34_.y = _tmp32_.y + 0.1;
	_tmp34_.z = _tmp33_.z - b;
	nibbles_view_draw_oval (self, c, v, &_tmp22_, &_tmp26_, &_tmp30_, &_tmp34_);
	cairo_set_source_rgb (c, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_fill (c);
}

static void
nibbles_view_draw_eyes_right (NibblesView* self,
                              cairo_t* c,
                              NibblesViewView3D* v,
                              gint x,
                              gint y,
                              gboolean blink)
{
	gdouble e = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble b = 0.0;
	NibblesViewPoint3D centre = {0};
	NibblesViewPoint3D _tmp1_ = {0};
	NibblesViewPoint3D _tmp2_;
	NibblesViewPoint3D _tmp3_;
	NibblesViewPoint3D _tmp4_;
	NibblesViewPoint3D _tmp5_ = {0};
	NibblesViewPoint3D _tmp6_;
	NibblesViewPoint3D _tmp7_;
	NibblesViewPoint3D _tmp8_;
	NibblesViewPoint3D _tmp9_ = {0};
	NibblesViewPoint3D _tmp10_;
	NibblesViewPoint3D _tmp11_;
	NibblesViewPoint3D _tmp12_;
	NibblesViewPoint3D _tmp13_ = {0};
	NibblesViewPoint3D _tmp14_;
	NibblesViewPoint3D _tmp15_;
	NibblesViewPoint3D _tmp16_;
	NibblesViewPoint3D _tmp17_ = {0};
	NibblesViewPoint3D _tmp18_ = {0};
	NibblesViewPoint3D _tmp19_;
	NibblesViewPoint3D _tmp20_;
	NibblesViewPoint3D _tmp21_;
	NibblesViewPoint3D _tmp22_ = {0};
	NibblesViewPoint3D _tmp23_;
	NibblesViewPoint3D _tmp24_;
	NibblesViewPoint3D _tmp25_;
	NibblesViewPoint3D _tmp26_ = {0};
	NibblesViewPoint3D _tmp27_;
	NibblesViewPoint3D _tmp28_;
	NibblesViewPoint3D _tmp29_;
	NibblesViewPoint3D _tmp30_ = {0};
	NibblesViewPoint3D _tmp31_;
	NibblesViewPoint3D _tmp32_;
	NibblesViewPoint3D _tmp33_;
	NibblesViewPoint3D _tmp34_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (v != NULL);
	e = sqrt (0.125);
	if (blink) {
		_tmp0_ = 0.025;
	} else {
		_tmp0_ = 0.1;
	}
	b = _tmp0_;
	_tmp1_.x = (x + 0.5) + e;
	_tmp1_.y = (y + 0.5) - (e / 2);
	_tmp1_.z = 0.5 + (e / 2);
	centre = _tmp1_;
	_tmp2_ = centre;
	_tmp3_ = centre;
	_tmp4_ = centre;
	_tmp5_.x = _tmp2_.x + b;
	_tmp5_.y = _tmp3_.y - 0.1;
	_tmp5_.z = _tmp4_.z - b;
	_tmp6_ = centre;
	_tmp7_ = centre;
	_tmp8_ = centre;
	_tmp9_.x = _tmp6_.x - b;
	_tmp9_.y = _tmp7_.y - 0.1;
	_tmp9_.z = _tmp8_.z + b;
	_tmp10_ = centre;
	_tmp11_ = centre;
	_tmp12_ = centre;
	_tmp13_.x = _tmp10_.x - b;
	_tmp13_.y = _tmp11_.y + 0.1;
	_tmp13_.z = _tmp12_.z + b;
	_tmp14_ = centre;
	_tmp15_ = centre;
	_tmp16_ = centre;
	_tmp17_.x = _tmp14_.x + b;
	_tmp17_.y = _tmp15_.y + 0.1;
	_tmp17_.z = _tmp16_.z - b;
	nibbles_view_draw_oval (self, c, v, &_tmp5_, &_tmp9_, &_tmp13_, &_tmp17_);
	cairo_set_source_rgb (c, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_fill (c);
	_tmp18_.x = (x + 0.5) + e;
	_tmp18_.y = (y + 0.5) + (e / 2);
	_tmp18_.z = 0.5 + (e / 2);
	centre = _tmp18_;
	_tmp19_ = centre;
	_tmp20_ = centre;
	_tmp21_ = centre;
	_tmp22_.x = _tmp19_.x + b;
	_tmp22_.y = _tmp20_.y - 0.1;
	_tmp22_.z = _tmp21_.z - b;
	_tmp23_ = centre;
	_tmp24_ = centre;
	_tmp25_ = centre;
	_tmp26_.x = _tmp23_.x - b;
	_tmp26_.y = _tmp24_.y - 0.1;
	_tmp26_.z = _tmp25_.z + b;
	_tmp27_ = centre;
	_tmp28_ = centre;
	_tmp29_ = centre;
	_tmp30_.x = _tmp27_.x - b;
	_tmp30_.y = _tmp28_.y + 0.1;
	_tmp30_.z = _tmp29_.z + b;
	_tmp31_ = centre;
	_tmp32_ = centre;
	_tmp33_ = centre;
	_tmp34_.x = _tmp31_.x + b;
	_tmp34_.y = _tmp32_.y + 0.1;
	_tmp34_.z = _tmp33_.z - b;
	nibbles_view_draw_oval (self, c, v, &_tmp22_, &_tmp26_, &_tmp30_, &_tmp34_);
	cairo_set_source_rgb (c, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	cairo_fill (c);
}

static void
nibbles_view_draw_3D_bonus (NibblesView* self,
                            cairo_t* c,
                            NibblesViewView3D* v,
                            gint x,
                            gint y,
                            Bonus* bonus)
{
	BonusType _tmp0_;
	BonusType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (v != NULL);
	g_return_if_fail (bonus != NULL);
	_tmp0_ = bonus_get_bonus_type (bonus);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case BONUS_TYPE_REGULAR:
		{
			nibbles_view_draw_apple (self, c, v, (gdouble) x, (gdouble) y);
			break;
		}
		case BONUS_TYPE_HALF:
		{
			nibbles_view_draw_cherry (self, c, v, (gdouble) x, (gdouble) y);
			break;
		}
		case BONUS_TYPE_DOUBLE:
		{
			nibbles_view_draw_banana (self, c, v, (gdouble) x, (gdouble) y);
			break;
		}
		case BONUS_TYPE_LIFE:
		{
			nibbles_view_draw_heart (self, c, v, (gdouble) x, (gdouble) y);
			break;
		}
		case BONUS_TYPE_REVERSE:
		{
			nibbles_view_draw_diamond (self, c, v, (gdouble) x, (gdouble) y);
			break;
		}
		case BONUS_TYPE_WARP:
		{
			break;
		}
		case 6:
		{
			break;
		}
		case 7:
		{
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
nibbles_view_draw_banana (NibblesView* self,
                          cairo_t* c,
                          NibblesViewView3D* v,
                          gdouble x,
                          gdouble y)
{
	gdouble cx[3] = {0};
	gdouble cy[3] = {0};
	NibblesViewPoint3D _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	NibblesViewPoint3D _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	NibblesViewPoint3D _tmp6_ = {0};
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	NibblesViewPoint3D _tmp17_ = {0};
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	NibblesViewPoint3D _tmp20_ = {0};
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	NibblesViewPoint3D _tmp23_ = {0};
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_;
	gdouble _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	NibblesViewPoint3D _tmp32_ = {0};
	gdouble _tmp33_ = 0.0;
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_;
	gdouble _tmp36_;
	NibblesViewPoint3D _tmp37_ = {0};
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	gdouble _tmp40_;
	gdouble _tmp41_;
	NibblesViewPoint3D _tmp42_ = {0};
	gdouble _tmp43_ = 0.0;
	gdouble _tmp44_ = 0.0;
	NibblesViewPoint3D _tmp45_ = {0};
	gdouble _tmp46_ = 0.0;
	gdouble _tmp47_ = 0.0;
	NibblesViewPoint3D _tmp48_ = {0};
	gdouble _tmp49_ = 0.0;
	gdouble _tmp50_ = 0.0;
	gdouble _tmp51_;
	gdouble _tmp52_;
	gdouble _tmp53_;
	gdouble _tmp54_;
	gdouble _tmp55_;
	gdouble _tmp56_;
	NibblesViewPoint3D _tmp57_ = {0};
	gdouble _tmp58_ = 0.0;
	gdouble _tmp59_ = 0.0;
	NibblesViewPoint3D _tmp60_ = {0};
	gdouble _tmp61_ = 0.0;
	gdouble _tmp62_ = 0.0;
	NibblesViewPoint3D _tmp63_ = {0};
	gdouble _tmp64_ = 0.0;
	gdouble _tmp65_ = 0.0;
	gdouble _tmp66_;
	gdouble _tmp67_;
	gdouble _tmp68_;
	gdouble _tmp69_;
	gdouble _tmp70_;
	gdouble _tmp71_;
	NibblesViewPoint3D _tmp72_ = {0};
	gdouble _tmp73_ = 0.0;
	gdouble _tmp74_ = 0.0;
	gdouble _tmp75_;
	gdouble _tmp76_;
	NibblesViewPoint3D _tmp77_ = {0};
	gdouble _tmp78_ = 0.0;
	gdouble _tmp79_ = 0.0;
	gdouble _tmp80_;
	gdouble _tmp81_;
	NibblesViewPoint3D _tmp82_ = {0};
	gdouble _tmp83_ = 0.0;
	gdouble _tmp84_ = 0.0;
	NibblesViewPoint3D _tmp85_ = {0};
	gdouble _tmp86_ = 0.0;
	gdouble _tmp87_ = 0.0;
	NibblesViewPoint3D _tmp88_ = {0};
	gdouble _tmp89_ = 0.0;
	gdouble _tmp90_ = 0.0;
	gdouble _tmp91_;
	gdouble _tmp92_;
	gdouble _tmp93_;
	gdouble _tmp94_;
	gdouble _tmp95_;
	gdouble _tmp96_;
	NibblesViewPoint3D _tmp97_ = {0};
	gdouble _tmp98_ = 0.0;
	gdouble _tmp99_ = 0.0;
	NibblesViewPoint3D _tmp100_ = {0};
	gdouble _tmp101_ = 0.0;
	gdouble _tmp102_ = 0.0;
	NibblesViewPoint3D _tmp103_ = {0};
	gdouble _tmp104_ = 0.0;
	gdouble _tmp105_ = 0.0;
	gdouble _tmp106_;
	gdouble _tmp107_;
	gdouble _tmp108_;
	gdouble _tmp109_;
	gdouble _tmp110_;
	gdouble _tmp111_;
	NibblesViewPoint3D _tmp112_ = {0};
	gdouble _tmp113_ = 0.0;
	gdouble _tmp114_ = 0.0;
	gdouble _tmp115_;
	gdouble _tmp116_;
	NibblesViewPoint3D _tmp117_ = {0};
	gdouble _tmp118_ = 0.0;
	gdouble _tmp119_ = 0.0;
	gdouble _tmp120_;
	gdouble _tmp121_;
	NibblesViewPoint3D _tmp122_ = {0};
	gdouble _tmp123_ = 0.0;
	gdouble _tmp124_ = 0.0;
	gdouble _tmp125_;
	gdouble _tmp126_;
	NibblesViewPoint3D _tmp127_ = {0};
	gdouble _tmp128_ = 0.0;
	gdouble _tmp129_ = 0.0;
	gdouble _tmp130_;
	gdouble _tmp131_;
	NibblesViewPoint3D _tmp132_ = {0};
	gdouble _tmp133_ = 0.0;
	gdouble _tmp134_ = 0.0;
	NibblesViewPoint3D _tmp135_ = {0};
	gdouble _tmp136_ = 0.0;
	gdouble _tmp137_ = 0.0;
	NibblesViewPoint3D _tmp138_ = {0};
	gdouble _tmp139_ = 0.0;
	gdouble _tmp140_ = 0.0;
	gdouble _tmp141_;
	gdouble _tmp142_;
	gdouble _tmp143_;
	gdouble _tmp144_;
	gdouble _tmp145_;
	gdouble _tmp146_;
	NibblesViewPoint3D _tmp147_ = {0};
	gdouble _tmp148_ = 0.0;
	gdouble _tmp149_ = 0.0;
	NibblesViewPoint3D _tmp150_ = {0};
	gdouble _tmp151_ = 0.0;
	gdouble _tmp152_ = 0.0;
	NibblesViewPoint3D _tmp153_ = {0};
	gdouble _tmp154_ = 0.0;
	gdouble _tmp155_ = 0.0;
	gdouble _tmp156_;
	gdouble _tmp157_;
	gdouble _tmp158_;
	gdouble _tmp159_;
	gdouble _tmp160_;
	gdouble _tmp161_;
	NibblesViewPoint3D _tmp162_ = {0};
	gdouble _tmp163_ = 0.0;
	gdouble _tmp164_ = 0.0;
	gdouble _tmp165_;
	gdouble _tmp166_;
	NibblesViewPoint3D _tmp167_ = {0};
	gdouble _tmp168_ = 0.0;
	gdouble _tmp169_ = 0.0;
	gdouble _tmp170_;
	gdouble _tmp171_;
	NibblesViewPoint3D _tmp172_ = {0};
	gdouble _tmp173_ = 0.0;
	gdouble _tmp174_ = 0.0;
	gdouble _tmp175_;
	gdouble _tmp176_;
	NibblesViewPoint3D _tmp177_ = {0};
	gdouble _tmp178_ = 0.0;
	gdouble _tmp179_ = 0.0;
	gdouble _tmp180_;
	gdouble _tmp181_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_.x = x + 0;
	_tmp0_.y = (y + 1) + 0.25;
	_tmp0_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp0_, &_tmp1_, &_tmp2_);
	cx[0] = _tmp1_;
	cy[0] = _tmp2_;
	_tmp3_.x = x + 0;
	_tmp3_.y = (y + 1) + 0.25;
	_tmp3_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp3_, &_tmp4_, &_tmp5_);
	cx[1] = _tmp4_;
	cy[1] = _tmp5_;
	_tmp6_.x = x + 1;
	_tmp6_.y = (y + 1) + 0.25;
	_tmp6_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp6_, &_tmp7_, &_tmp8_);
	cx[2] = _tmp7_;
	cy[2] = _tmp8_;
	_tmp9_ = cx[0];
	_tmp10_ = cy[0];
	cairo_move_to (c, _tmp9_, _tmp10_);
	_tmp11_ = cx[0];
	_tmp12_ = cy[0];
	_tmp13_ = cx[1];
	_tmp14_ = cy[1];
	_tmp15_ = cx[2];
	_tmp16_ = cy[2];
	cairo_curve_to (c, _tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_, _tmp16_);
	_tmp17_.x = x + 1;
	_tmp17_.y = (y + 1) + 0.25;
	_tmp17_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp17_, &_tmp18_, &_tmp19_);
	cx[0] = _tmp18_;
	cy[0] = _tmp19_;
	_tmp20_.x = x + 2;
	_tmp20_.y = (y + 1) + 0.25;
	_tmp20_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp20_, &_tmp21_, &_tmp22_);
	cx[1] = _tmp21_;
	cy[1] = _tmp22_;
	_tmp23_.x = x + 2;
	_tmp23_.y = (y + 1) + 0.25;
	_tmp23_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp23_, &_tmp24_, &_tmp25_);
	cx[2] = _tmp24_;
	cy[2] = _tmp25_;
	_tmp26_ = cx[0];
	_tmp27_ = cy[0];
	_tmp28_ = cx[1];
	_tmp29_ = cy[1];
	_tmp30_ = cx[2];
	_tmp31_ = cy[2];
	cairo_curve_to (c, _tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp31_);
	_tmp32_.x = (x + 2) - 0.1;
	_tmp32_.y = (y + 1) + 0.25;
	_tmp32_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp32_, &_tmp33_, &_tmp34_);
	cx[0] = _tmp33_;
	cy[0] = _tmp34_;
	_tmp35_ = cx[0];
	_tmp36_ = cy[0];
	cairo_line_to (c, _tmp35_, _tmp36_);
	_tmp37_.x = (x + 2) - 0.2;
	_tmp37_.y = (y + 1) + 0.25;
	_tmp37_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp37_, &_tmp38_, &_tmp39_);
	cx[0] = _tmp38_;
	cy[0] = _tmp39_;
	_tmp40_ = cx[0];
	_tmp41_ = cy[0];
	cairo_line_to (c, _tmp40_, _tmp41_);
	_tmp42_.x = (x + 2) - 0.2;
	_tmp42_.y = (y + 1) + 0.25;
	_tmp42_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp42_, &_tmp43_, &_tmp44_);
	cx[0] = _tmp43_;
	cy[0] = _tmp44_;
	_tmp45_.x = (x + 2) - 0.2;
	_tmp45_.y = (y + 1) + 0.25;
	_tmp45_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp45_, &_tmp46_, &_tmp47_);
	cx[1] = _tmp46_;
	cy[1] = _tmp47_;
	_tmp48_.x = x + 1;
	_tmp48_.y = (y + 1) + 0.25;
	_tmp48_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp48_, &_tmp49_, &_tmp50_);
	cx[2] = _tmp49_;
	cy[2] = _tmp50_;
	_tmp51_ = cx[0];
	_tmp52_ = cy[0];
	_tmp53_ = cx[1];
	_tmp54_ = cy[1];
	_tmp55_ = cx[2];
	_tmp56_ = cy[2];
	cairo_curve_to (c, _tmp51_, _tmp52_, _tmp53_, _tmp54_, _tmp55_, _tmp56_);
	_tmp57_.x = x + 1;
	_tmp57_.y = (y + 1) + 0.25;
	_tmp57_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp57_, &_tmp58_, &_tmp59_);
	cx[0] = _tmp58_;
	cy[0] = _tmp59_;
	_tmp60_.x = x + 0.2;
	_tmp60_.y = (y + 1) + 0.25;
	_tmp60_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp60_, &_tmp61_, &_tmp62_);
	cx[1] = _tmp61_;
	cy[1] = _tmp62_;
	_tmp63_.x = x + 0.1;
	_tmp63_.y = (y + 1) + 0.25;
	_tmp63_.z = 1 + 0.1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp63_, &_tmp64_, &_tmp65_);
	cx[2] = _tmp64_;
	cy[2] = _tmp65_;
	_tmp66_ = cx[0];
	_tmp67_ = cy[0];
	_tmp68_ = cx[1];
	_tmp69_ = cy[1];
	_tmp70_ = cx[2];
	_tmp71_ = cy[2];
	cairo_curve_to (c, _tmp66_, _tmp67_, _tmp68_, _tmp69_, _tmp70_, _tmp71_);
	cairo_set_source_rgb (c, 0.6, 0.6, (gdouble) 0);
	cairo_fill (c);
	_tmp72_.x = x + 0.1;
	_tmp72_.y = (y + 1) + 0.25;
	_tmp72_.z = 1 + 0.1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp72_, &_tmp73_, &_tmp74_);
	cx[0] = _tmp73_;
	cy[0] = _tmp74_;
	_tmp75_ = cx[0];
	_tmp76_ = cy[0];
	cairo_move_to (c, _tmp75_, _tmp76_);
	_tmp77_.x = x + 0.1;
	_tmp77_.y = (y + 1) + 0.15;
	_tmp77_.z = 1 + 0.1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp77_, &_tmp78_, &_tmp79_);
	cx[0] = _tmp78_;
	cy[0] = _tmp79_;
	_tmp80_ = cx[0];
	_tmp81_ = cy[0];
	cairo_line_to (c, _tmp80_, _tmp81_);
	_tmp82_.x = x + 0.1;
	_tmp82_.y = (y + 1) + 0.15;
	_tmp82_.z = 1 + 0.1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp82_, &_tmp83_, &_tmp84_);
	cx[0] = _tmp83_;
	cy[0] = _tmp84_;
	_tmp85_.x = x + 0.2;
	_tmp85_.y = (y + 1) + 0.15;
	_tmp85_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp85_, &_tmp86_, &_tmp87_);
	cx[1] = _tmp86_;
	cy[1] = _tmp87_;
	_tmp88_.x = x + 1;
	_tmp88_.y = (y + 1) + 0.15;
	_tmp88_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp88_, &_tmp89_, &_tmp90_);
	cx[2] = _tmp89_;
	cy[2] = _tmp90_;
	_tmp91_ = cx[0];
	_tmp92_ = cy[0];
	_tmp93_ = cx[1];
	_tmp94_ = cy[1];
	_tmp95_ = cx[2];
	_tmp96_ = cy[2];
	cairo_curve_to (c, _tmp91_, _tmp92_, _tmp93_, _tmp94_, _tmp95_, _tmp96_);
	_tmp97_.x = x + 1;
	_tmp97_.y = (y + 1) + 0.15;
	_tmp97_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp97_, &_tmp98_, &_tmp99_);
	cx[0] = _tmp98_;
	cy[0] = _tmp99_;
	_tmp100_.x = (x + 2) - 0.2;
	_tmp100_.y = (y + 1) + 0.15;
	_tmp100_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp100_, &_tmp101_, &_tmp102_);
	cx[1] = _tmp101_;
	cy[1] = _tmp102_;
	_tmp103_.x = (x + 2) - 0.2;
	_tmp103_.y = (y + 1) + 0.15;
	_tmp103_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp103_, &_tmp104_, &_tmp105_);
	cx[2] = _tmp104_;
	cy[2] = _tmp105_;
	_tmp106_ = cx[0];
	_tmp107_ = cy[0];
	_tmp108_ = cx[1];
	_tmp109_ = cy[1];
	_tmp110_ = cx[2];
	_tmp111_ = cy[2];
	cairo_curve_to (c, _tmp106_, _tmp107_, _tmp108_, _tmp109_, _tmp110_, _tmp111_);
	_tmp112_.x = (x + 2) - 0.2;
	_tmp112_.y = (y + 1) + 0.15;
	_tmp112_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp112_, &_tmp113_, &_tmp114_);
	cx[0] = _tmp113_;
	cy[0] = _tmp114_;
	_tmp115_ = cx[0];
	_tmp116_ = cy[0];
	cairo_line_to (c, _tmp115_, _tmp116_);
	_tmp117_.x = (x + 2) - 0.1;
	_tmp117_.y = (y + 1) + 0.15;
	_tmp117_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp117_, &_tmp118_, &_tmp119_);
	cx[0] = _tmp118_;
	cy[0] = _tmp119_;
	_tmp120_ = cx[0];
	_tmp121_ = cy[0];
	cairo_line_to (c, _tmp120_, _tmp121_);
	_tmp122_.x = (x + 2) - 0.1;
	_tmp122_.y = (y + 1) + 0.25;
	_tmp122_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp122_, &_tmp123_, &_tmp124_);
	cx[0] = _tmp123_;
	cy[0] = _tmp124_;
	_tmp125_ = cx[0];
	_tmp126_ = cy[0];
	cairo_line_to (c, _tmp125_, _tmp126_);
	_tmp127_.x = (x + 2) - 0.2;
	_tmp127_.y = (y + 1) + 0.25;
	_tmp127_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp127_, &_tmp128_, &_tmp129_);
	cx[0] = _tmp128_;
	cy[0] = _tmp129_;
	_tmp130_ = cx[0];
	_tmp131_ = cy[0];
	cairo_line_to (c, _tmp130_, _tmp131_);
	_tmp132_.x = (x + 2) - 0.2;
	_tmp132_.y = (y + 1) + 0.25;
	_tmp132_.z = 1 + 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp132_, &_tmp133_, &_tmp134_);
	cx[0] = _tmp133_;
	cy[0] = _tmp134_;
	_tmp135_.x = (x + 2) - 0.2;
	_tmp135_.y = (y + 1) + 0.25;
	_tmp135_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp135_, &_tmp136_, &_tmp137_);
	cx[1] = _tmp136_;
	cy[1] = _tmp137_;
	_tmp138_.x = x + 1;
	_tmp138_.y = (y + 1) + 0.25;
	_tmp138_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp138_, &_tmp139_, &_tmp140_);
	cx[2] = _tmp139_;
	cy[2] = _tmp140_;
	_tmp141_ = cx[0];
	_tmp142_ = cy[0];
	_tmp143_ = cx[1];
	_tmp144_ = cy[1];
	_tmp145_ = cx[2];
	_tmp146_ = cy[2];
	cairo_curve_to (c, _tmp141_, _tmp142_, _tmp143_, _tmp144_, _tmp145_, _tmp146_);
	_tmp147_.x = x + 1;
	_tmp147_.y = (y + 1) + 0.25;
	_tmp147_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp147_, &_tmp148_, &_tmp149_);
	cx[0] = _tmp148_;
	cy[0] = _tmp149_;
	_tmp150_.x = x + 0.2;
	_tmp150_.y = (y + 1) + 0.25;
	_tmp150_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp150_, &_tmp151_, &_tmp152_);
	cx[1] = _tmp151_;
	cy[1] = _tmp152_;
	_tmp153_.x = x + 0.1;
	_tmp153_.y = (y + 1) + 0.25;
	_tmp153_.z = 1 + 0.1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp153_, &_tmp154_, &_tmp155_);
	cx[2] = _tmp154_;
	cy[2] = _tmp155_;
	_tmp156_ = cx[0];
	_tmp157_ = cy[0];
	_tmp158_ = cx[1];
	_tmp159_ = cy[1];
	_tmp160_ = cx[2];
	_tmp161_ = cy[2];
	cairo_curve_to (c, _tmp156_, _tmp157_, _tmp158_, _tmp159_, _tmp160_, _tmp161_);
	cairo_set_source_rgb (c, 0.8, 0.8, (gdouble) 0);
	cairo_fill (c);
	_tmp162_.x = x + 0;
	_tmp162_.y = (y + 1) + 0.25;
	_tmp162_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp162_, &_tmp163_, &_tmp164_);
	cx[0] = _tmp163_;
	cy[0] = _tmp164_;
	_tmp165_ = cx[0];
	_tmp166_ = cy[0];
	cairo_move_to (c, _tmp165_, _tmp166_);
	_tmp167_.x = x + 0.1;
	_tmp167_.y = (y + 1) + 0.25;
	_tmp167_.z = 1 + 0.1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp167_, &_tmp168_, &_tmp169_);
	cx[0] = _tmp168_;
	cy[0] = _tmp169_;
	_tmp170_ = cx[0];
	_tmp171_ = cy[0];
	cairo_line_to (c, _tmp170_, _tmp171_);
	_tmp172_.x = x + 0.1;
	_tmp172_.y = (y + 1) + 0.15;
	_tmp172_.z = 1 + 0.1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp172_, &_tmp173_, &_tmp174_);
	cx[0] = _tmp173_;
	cy[0] = _tmp174_;
	_tmp175_ = cx[0];
	_tmp176_ = cy[0];
	cairo_line_to (c, _tmp175_, _tmp176_);
	_tmp177_.x = x + 0;
	_tmp177_.y = (y + 1) + 0.15;
	_tmp177_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp177_, &_tmp178_, &_tmp179_);
	cx[0] = _tmp178_;
	cy[0] = _tmp179_;
	_tmp180_ = cx[0];
	_tmp181_ = cy[0];
	cairo_line_to (c, _tmp180_, _tmp181_);
	cairo_set_source_rgb (c, 0.3, 0.3, 0.4);
	cairo_fill (c);
}

static void
nibbles_view_draw_diamond (NibblesView* self,
                           cairo_t* c,
                           NibblesViewView3D* v,
                           gdouble x,
                           gdouble y)
{
	static const gdouble cos60 = 0.5;
	static const gdouble sin60 = 0.866025403784;
	NibblesViewPoint3D top[6] = {0};
	NibblesViewPoint3D _tmp0_ = {0};
	NibblesViewPoint3D _tmp1_ = {0};
	NibblesViewPoint3D _tmp2_ = {0};
	NibblesViewPoint3D _tmp3_ = {0};
	NibblesViewPoint3D _tmp4_ = {0};
	NibblesViewPoint3D _tmp5_ = {0};
	NibblesViewPoint3D _tmp6_[6] = {0};
	NibblesViewPoint3D middle[6] = {0};
	NibblesViewPoint3D _tmp7_ = {0};
	NibblesViewPoint3D _tmp8_ = {0};
	NibblesViewPoint3D _tmp9_ = {0};
	NibblesViewPoint3D _tmp10_ = {0};
	NibblesViewPoint3D _tmp11_ = {0};
	NibblesViewPoint3D _tmp12_ = {0};
	NibblesViewPoint3D _tmp13_[6] = {0};
	gdouble X = 0.0;
	gdouble Y = 0.0;
	NibblesViewPoint3D _tmp14_;
	gdouble _tmp15_ = 0.0;
	gdouble _tmp16_ = 0.0;
	NibblesViewPoint3D _tmp17_;
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	NibblesViewPoint3D _tmp20_;
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	NibblesViewPoint3D _tmp23_;
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	NibblesViewPoint3D _tmp26_;
	gdouble _tmp27_ = 0.0;
	gdouble _tmp28_ = 0.0;
	NibblesViewPoint3D _tmp29_;
	gdouble _tmp30_ = 0.0;
	gdouble _tmp31_ = 0.0;
	NibblesViewPoint3D _tmp32_;
	gdouble _tmp33_ = 0.0;
	gdouble _tmp34_ = 0.0;
	NibblesViewPoint3D _tmp35_;
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	NibblesViewPoint3D _tmp38_;
	gdouble _tmp39_ = 0.0;
	gdouble _tmp40_ = 0.0;
	NibblesViewPoint3D _tmp41_;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_ = 0.0;
	NibblesViewPoint3D _tmp44_;
	gdouble _tmp45_ = 0.0;
	gdouble _tmp46_ = 0.0;
	NibblesViewPoint3D _tmp47_;
	gdouble _tmp48_ = 0.0;
	gdouble _tmp49_ = 0.0;
	NibblesViewPoint3D _tmp50_;
	gdouble _tmp51_ = 0.0;
	gdouble _tmp52_ = 0.0;
	NibblesViewPoint3D _tmp53_;
	gdouble _tmp54_ = 0.0;
	gdouble _tmp55_ = 0.0;
	NibblesViewPoint3D _tmp56_;
	gdouble _tmp57_ = 0.0;
	gdouble _tmp58_ = 0.0;
	NibblesViewPoint3D _tmp59_;
	gdouble _tmp60_ = 0.0;
	gdouble _tmp61_ = 0.0;
	NibblesViewPoint3D _tmp62_;
	gdouble _tmp63_ = 0.0;
	gdouble _tmp64_ = 0.0;
	NibblesViewPoint3D _tmp65_;
	gdouble _tmp66_ = 0.0;
	gdouble _tmp67_ = 0.0;
	NibblesViewPoint3D _tmp68_;
	gdouble _tmp69_ = 0.0;
	gdouble _tmp70_ = 0.0;
	NibblesViewPoint3D _tmp71_;
	gdouble _tmp72_ = 0.0;
	gdouble _tmp73_ = 0.0;
	NibblesViewPoint3D _tmp74_;
	gdouble _tmp75_ = 0.0;
	gdouble _tmp76_ = 0.0;
	NibblesViewPoint3D _tmp77_;
	gdouble _tmp78_ = 0.0;
	gdouble _tmp79_ = 0.0;
	NibblesViewPoint3D _tmp80_;
	gdouble _tmp81_ = 0.0;
	gdouble _tmp82_ = 0.0;
	NibblesViewPoint3D _tmp83_;
	gdouble _tmp84_ = 0.0;
	gdouble _tmp85_ = 0.0;
	NibblesViewPoint3D _tmp86_;
	gdouble _tmp87_ = 0.0;
	gdouble _tmp88_ = 0.0;
	NibblesViewPoint3D _tmp89_;
	gdouble _tmp90_ = 0.0;
	gdouble _tmp91_ = 0.0;
	NibblesViewPoint3D _tmp92_;
	gdouble _tmp93_ = 0.0;
	gdouble _tmp94_ = 0.0;
	NibblesViewPoint3D _tmp95_;
	gdouble _tmp96_ = 0.0;
	gdouble _tmp97_ = 0.0;
	NibblesViewPoint3D _tmp98_;
	gdouble _tmp99_ = 0.0;
	gdouble _tmp100_ = 0.0;
	NibblesViewPoint3D _tmp101_;
	gdouble _tmp102_ = 0.0;
	gdouble _tmp103_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (v != NULL);
	memset (&_tmp0_, 0, sizeof (NibblesViewPoint3D));
	_tmp0_.x = x + 0;
	_tmp0_.y = y + 1;
	_tmp0_.z = 1.5;
	memset (&_tmp1_, 0, sizeof (NibblesViewPoint3D));
	_tmp1_.x = x + cos60;
	_tmp1_.y = (y + 1.0) - sin60;
	_tmp1_.z = 1.5;
	memset (&_tmp2_, 0, sizeof (NibblesViewPoint3D));
	_tmp2_.x = (x + cos60) + 1;
	_tmp2_.y = (y + 1.0) - sin60;
	_tmp2_.z = 1.5;
	memset (&_tmp3_, 0, sizeof (NibblesViewPoint3D));
	_tmp3_.x = x + 2;
	_tmp3_.y = y + 1;
	_tmp3_.z = 1.5;
	memset (&_tmp4_, 0, sizeof (NibblesViewPoint3D));
	_tmp4_.x = (x + cos60) + 1;
	_tmp4_.y = (y + 1.0) + sin60;
	_tmp4_.z = 1.5;
	memset (&_tmp5_, 0, sizeof (NibblesViewPoint3D));
	_tmp5_.x = x + cos60;
	_tmp5_.y = (y + 1.0) + sin60;
	_tmp5_.z = 1.5;
	_tmp6_[0] = _tmp0_;
	_tmp6_[1] = _tmp1_;
	_tmp6_[2] = _tmp2_;
	_tmp6_[3] = _tmp3_;
	_tmp6_[4] = _tmp4_;
	_tmp6_[5] = _tmp5_;
	memcpy (top, _tmp6_, 6 * sizeof (NibblesViewPoint3D));
	memset (&_tmp7_, 0, sizeof (NibblesViewPoint3D));
	_tmp7_.x = x + 0.5;
	_tmp7_.y = y + 1;
	_tmp7_.z = (gdouble) 2;
	memset (&_tmp8_, 0, sizeof (NibblesViewPoint3D));
	_tmp8_.x = x + (1.0 - (0.5 * cos60));
	_tmp8_.y = (y + 1.0) - (0.5 * sin60);
	_tmp8_.z = (gdouble) 2;
	memset (&_tmp9_, 0, sizeof (NibblesViewPoint3D));
	_tmp9_.x = (x + (0.5 * cos60)) + 1;
	_tmp9_.y = (y + 1.0) - (0.5 * sin60);
	_tmp9_.z = (gdouble) 2;
	memset (&_tmp10_, 0, sizeof (NibblesViewPoint3D));
	_tmp10_.x = x + 1.5;
	_tmp10_.y = y + 1;
	_tmp10_.z = (gdouble) 2;
	memset (&_tmp11_, 0, sizeof (NibblesViewPoint3D));
	_tmp11_.x = (x + (0.5 * cos60)) + 1;
	_tmp11_.y = (y + 1.0) + (0.5 * sin60);
	_tmp11_.z = (gdouble) 2;
	memset (&_tmp12_, 0, sizeof (NibblesViewPoint3D));
	_tmp12_.x = x + (1.0 - (0.5 * cos60));
	_tmp12_.y = (y + 1.0) + (0.5 * sin60);
	_tmp12_.z = (gdouble) 2;
	_tmp13_[0] = _tmp7_;
	_tmp13_[1] = _tmp8_;
	_tmp13_[2] = _tmp9_;
	_tmp13_[3] = _tmp10_;
	_tmp13_[4] = _tmp11_;
	_tmp13_[5] = _tmp12_;
	memcpy (middle, _tmp13_, 6 * sizeof (NibblesViewPoint3D));
	_tmp14_ = top[0];
	nibbles_view_view3_d_to_view_plain (v, &_tmp14_, &_tmp15_, &_tmp16_);
	X = _tmp15_;
	Y = _tmp16_;
	cairo_move_to (c, X, Y);
	_tmp17_ = top[1];
	nibbles_view_view3_d_to_view_plain (v, &_tmp17_, &_tmp18_, &_tmp19_);
	X = _tmp18_;
	Y = _tmp19_;
	cairo_line_to (c, X, Y);
	_tmp20_ = top[2];
	nibbles_view_view3_d_to_view_plain (v, &_tmp20_, &_tmp21_, &_tmp22_);
	X = _tmp21_;
	Y = _tmp22_;
	cairo_line_to (c, X, Y);
	_tmp23_ = top[3];
	nibbles_view_view3_d_to_view_plain (v, &_tmp23_, &_tmp24_, &_tmp25_);
	X = _tmp24_;
	Y = _tmp25_;
	cairo_line_to (c, X, Y);
	_tmp26_ = top[4];
	nibbles_view_view3_d_to_view_plain (v, &_tmp26_, &_tmp27_, &_tmp28_);
	X = _tmp27_;
	Y = _tmp28_;
	cairo_line_to (c, X, Y);
	_tmp29_ = top[5];
	nibbles_view_view3_d_to_view_plain (v, &_tmp29_, &_tmp30_, &_tmp31_);
	X = _tmp30_;
	Y = _tmp31_;
	cairo_line_to (c, X, Y);
	cairo_set_source_rgb (c, 0.8, 0.9, (gdouble) 1);
	cairo_fill (c);
	_tmp32_ = middle[1];
	nibbles_view_view3_d_to_view_plain (v, &_tmp32_, &_tmp33_, &_tmp34_);
	X = _tmp33_;
	Y = _tmp34_;
	cairo_move_to (c, X, Y);
	_tmp35_ = middle[2];
	nibbles_view_view3_d_to_view_plain (v, &_tmp35_, &_tmp36_, &_tmp37_);
	X = _tmp36_;
	Y = _tmp37_;
	cairo_line_to (c, X, Y);
	_tmp38_ = top[2];
	nibbles_view_view3_d_to_view_plain (v, &_tmp38_, &_tmp39_, &_tmp40_);
	X = _tmp39_;
	Y = _tmp40_;
	cairo_line_to (c, X, Y);
	_tmp41_ = top[1];
	nibbles_view_view3_d_to_view_plain (v, &_tmp41_, &_tmp42_, &_tmp43_);
	X = _tmp42_;
	Y = _tmp43_;
	cairo_line_to (c, X, Y);
	cairo_set_source_rgb (c, 0.618, 0.708, 0.802);
	cairo_fill (c);
	_tmp44_ = middle[1];
	nibbles_view_view3_d_to_view_plain (v, &_tmp44_, &_tmp45_, &_tmp46_);
	X = _tmp45_;
	Y = _tmp46_;
	cairo_move_to (c, X, Y);
	_tmp47_ = middle[0];
	nibbles_view_view3_d_to_view_plain (v, &_tmp47_, &_tmp48_, &_tmp49_);
	X = _tmp48_;
	Y = _tmp49_;
	cairo_line_to (c, X, Y);
	_tmp50_ = top[0];
	nibbles_view_view3_d_to_view_plain (v, &_tmp50_, &_tmp51_, &_tmp52_);
	X = _tmp51_;
	Y = _tmp52_;
	cairo_line_to (c, X, Y);
	_tmp53_ = top[1];
	nibbles_view_view3_d_to_view_plain (v, &_tmp53_, &_tmp54_, &_tmp55_);
	X = _tmp54_;
	Y = _tmp55_;
	cairo_line_to (c, X, Y);
	cairo_set_source_rgb (c, 0.347, 0.524, 0.712);
	cairo_fill (c);
	_tmp56_ = middle[2];
	nibbles_view_view3_d_to_view_plain (v, &_tmp56_, &_tmp57_, &_tmp58_);
	X = _tmp57_;
	Y = _tmp58_;
	cairo_move_to (c, X, Y);
	_tmp59_ = middle[3];
	nibbles_view_view3_d_to_view_plain (v, &_tmp59_, &_tmp60_, &_tmp61_);
	X = _tmp60_;
	Y = _tmp61_;
	cairo_line_to (c, X, Y);
	_tmp62_ = top[3];
	nibbles_view_view3_d_to_view_plain (v, &_tmp62_, &_tmp63_, &_tmp64_);
	X = _tmp63_;
	Y = _tmp64_;
	cairo_line_to (c, X, Y);
	_tmp65_ = top[2];
	nibbles_view_view3_d_to_view_plain (v, &_tmp65_, &_tmp66_, &_tmp67_);
	X = _tmp66_;
	Y = _tmp67_;
	cairo_line_to (c, X, Y);
	cairo_set_source_rgb (c, 0.347, 0.524, 0.712);
	cairo_fill (c);
	_tmp68_ = middle[3];
	nibbles_view_view3_d_to_view_plain (v, &_tmp68_, &_tmp69_, &_tmp70_);
	X = _tmp69_;
	Y = _tmp70_;
	cairo_move_to (c, X, Y);
	_tmp71_ = middle[4];
	nibbles_view_view3_d_to_view_plain (v, &_tmp71_, &_tmp72_, &_tmp73_);
	X = _tmp72_;
	Y = _tmp73_;
	cairo_line_to (c, X, Y);
	_tmp74_ = top[4];
	nibbles_view_view3_d_to_view_plain (v, &_tmp74_, &_tmp75_, &_tmp76_);
	X = _tmp75_;
	Y = _tmp76_;
	cairo_line_to (c, X, Y);
	_tmp77_ = top[3];
	nibbles_view_view3_d_to_view_plain (v, &_tmp77_, &_tmp78_, &_tmp79_);
	X = _tmp78_;
	Y = _tmp79_;
	cairo_line_to (c, X, Y);
	cairo_set_source_rgb (c, 0.447, 0.624, 0.812);
	cairo_fill (c);
	_tmp80_ = middle[5];
	nibbles_view_view3_d_to_view_plain (v, &_tmp80_, &_tmp81_, &_tmp82_);
	X = _tmp81_;
	Y = _tmp82_;
	cairo_move_to (c, X, Y);
	_tmp83_ = middle[0];
	nibbles_view_view3_d_to_view_plain (v, &_tmp83_, &_tmp84_, &_tmp85_);
	X = _tmp84_;
	Y = _tmp85_;
	cairo_line_to (c, X, Y);
	_tmp86_ = top[0];
	nibbles_view_view3_d_to_view_plain (v, &_tmp86_, &_tmp87_, &_tmp88_);
	X = _tmp87_;
	Y = _tmp88_;
	cairo_line_to (c, X, Y);
	_tmp89_ = top[5];
	nibbles_view_view3_d_to_view_plain (v, &_tmp89_, &_tmp90_, &_tmp91_);
	X = _tmp90_;
	Y = _tmp91_;
	cairo_line_to (c, X, Y);
	cairo_set_source_rgb (c, 0.447, 0.624, 0.812);
	cairo_fill (c);
	_tmp92_ = middle[4];
	nibbles_view_view3_d_to_view_plain (v, &_tmp92_, &_tmp93_, &_tmp94_);
	X = _tmp93_;
	Y = _tmp94_;
	cairo_move_to (c, X, Y);
	_tmp95_ = middle[5];
	nibbles_view_view3_d_to_view_plain (v, &_tmp95_, &_tmp96_, &_tmp97_);
	X = _tmp96_;
	Y = _tmp97_;
	cairo_line_to (c, X, Y);
	_tmp98_ = top[5];
	nibbles_view_view3_d_to_view_plain (v, &_tmp98_, &_tmp99_, &_tmp100_);
	X = _tmp99_;
	Y = _tmp100_;
	cairo_line_to (c, X, Y);
	_tmp101_ = top[4];
	nibbles_view_view3_d_to_view_plain (v, &_tmp101_, &_tmp102_, &_tmp103_);
	X = _tmp102_;
	Y = _tmp103_;
	cairo_line_to (c, X, Y);
	cairo_set_source_rgb (c, 0.718, 0.808, 0.902);
	cairo_fill (c);
}

static void
nibbles_view_draw_heart (NibblesView* self,
                         cairo_t* c,
                         NibblesViewView3D* v,
                         gdouble x,
                         gdouble y)
{
	gdouble H = 0.0;
	gdouble h = 0.0;
	gdouble cx[3] = {0};
	gdouble cy[3] = {0};
	NibblesViewPoint3D _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	NibblesViewPoint3D _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	NibblesViewPoint3D _tmp6_ = {0};
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	NibblesViewPoint3D _tmp17_ = {0};
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	NibblesViewPoint3D _tmp20_ = {0};
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	NibblesViewPoint3D _tmp23_ = {0};
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_;
	gdouble _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	NibblesViewPoint3D _tmp32_ = {0};
	gdouble _tmp33_ = 0.0;
	gdouble _tmp34_ = 0.0;
	NibblesViewPoint3D _tmp35_ = {0};
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	NibblesViewPoint3D _tmp38_ = {0};
	gdouble _tmp39_ = 0.0;
	gdouble _tmp40_ = 0.0;
	gdouble _tmp41_;
	gdouble _tmp42_;
	gdouble _tmp43_;
	gdouble _tmp44_;
	gdouble _tmp45_;
	gdouble _tmp46_;
	NibblesViewPoint3D _tmp47_ = {0};
	gdouble _tmp48_ = 0.0;
	gdouble _tmp49_ = 0.0;
	NibblesViewPoint3D _tmp50_ = {0};
	gdouble _tmp51_ = 0.0;
	gdouble _tmp52_ = 0.0;
	NibblesViewPoint3D _tmp53_ = {0};
	gdouble _tmp54_ = 0.0;
	gdouble _tmp55_ = 0.0;
	gdouble _tmp56_;
	gdouble _tmp57_;
	gdouble _tmp58_;
	gdouble _tmp59_;
	gdouble _tmp60_;
	gdouble _tmp61_;
	NibblesViewPoint3D _tmp62_ = {0};
	gdouble _tmp63_ = 0.0;
	gdouble _tmp64_ = 0.0;
	NibblesViewPoint3D _tmp65_ = {0};
	gdouble _tmp66_ = 0.0;
	gdouble _tmp67_ = 0.0;
	NibblesViewPoint3D _tmp68_ = {0};
	gdouble _tmp69_ = 0.0;
	gdouble _tmp70_ = 0.0;
	gdouble _tmp71_;
	gdouble _tmp72_;
	gdouble _tmp73_;
	gdouble _tmp74_;
	gdouble _tmp75_;
	gdouble _tmp76_;
	NibblesViewPoint3D _tmp77_ = {0};
	gdouble _tmp78_ = 0.0;
	gdouble _tmp79_ = 0.0;
	NibblesViewPoint3D _tmp80_ = {0};
	gdouble _tmp81_ = 0.0;
	gdouble _tmp82_ = 0.0;
	NibblesViewPoint3D _tmp83_ = {0};
	gdouble _tmp84_ = 0.0;
	gdouble _tmp85_ = 0.0;
	gdouble _tmp86_;
	gdouble _tmp87_;
	gdouble _tmp88_;
	gdouble _tmp89_;
	gdouble _tmp90_;
	gdouble _tmp91_;
	NibblesViewPoint3D _tmp92_ = {0};
	gdouble _tmp93_ = 0.0;
	gdouble _tmp94_ = 0.0;
	gdouble _tmp95_;
	gdouble _tmp96_;
	NibblesViewPoint3D _tmp97_ = {0};
	gdouble _tmp98_ = 0.0;
	gdouble _tmp99_ = 0.0;
	gdouble _tmp100_;
	gdouble _tmp101_;
	NibblesViewPoint3D _tmp102_ = {0};
	gdouble _tmp103_ = 0.0;
	gdouble _tmp104_ = 0.0;
	NibblesViewPoint3D _tmp105_ = {0};
	gdouble _tmp106_ = 0.0;
	gdouble _tmp107_ = 0.0;
	gdouble radius = 0.0;
	NibblesViewPoint3D _tmp108_ = {0};
	NibblesViewPoint3D _tmp109_ = {0};
	cairo_pattern_t* pat2 = NULL;
	gdouble _tmp110_;
	gdouble _tmp111_;
	gdouble _tmp112_;
	gdouble _tmp113_;
	cairo_pattern_t* _tmp114_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (v != NULL);
	H = sqrt (0.125);
	h = 0.5 - H;
	_tmp0_.x = x + h;
	_tmp0_.y = y + 1;
	_tmp0_.z = 1 + h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp0_, &_tmp1_, &_tmp2_);
	cx[0] = _tmp1_;
	cy[0] = _tmp2_;
	_tmp3_.x = x - 0.207106781187;
	_tmp3_.y = y + 1;
	_tmp3_.z = 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp3_, &_tmp4_, &_tmp5_);
	cx[1] = _tmp4_;
	cy[1] = _tmp5_;
	_tmp6_.x = x + h;
	_tmp6_.y = y + 1;
	_tmp6_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp6_, &_tmp7_, &_tmp8_);
	cx[2] = _tmp7_;
	cy[2] = _tmp8_;
	_tmp9_ = cx[0];
	_tmp10_ = cy[0];
	cairo_move_to (c, _tmp9_, _tmp10_);
	_tmp11_ = cx[0];
	_tmp12_ = cy[0];
	_tmp13_ = cx[1];
	_tmp14_ = cy[1];
	_tmp15_ = cx[2];
	_tmp16_ = cy[2];
	cairo_curve_to (c, _tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_, _tmp16_);
	_tmp17_.x = x + h;
	_tmp17_.y = y + 1;
	_tmp17_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp17_, &_tmp18_, &_tmp19_);
	cx[0] = _tmp18_;
	cy[0] = _tmp19_;
	_tmp20_.x = x + 0.5;
	_tmp20_.y = y + 1;
	_tmp20_.z = 2.0 + 0.207106781187;
	nibbles_view_view3_d_to_view_plain (v, &_tmp20_, &_tmp21_, &_tmp22_);
	cx[1] = _tmp21_;
	cy[1] = _tmp22_;
	_tmp23_.x = (x + 1) - h;
	_tmp23_.y = y + 1;
	_tmp23_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp23_, &_tmp24_, &_tmp25_);
	cx[2] = _tmp24_;
	cy[2] = _tmp25_;
	_tmp26_ = cx[0];
	_tmp27_ = cy[0];
	_tmp28_ = cx[1];
	_tmp29_ = cy[1];
	_tmp30_ = cx[2];
	_tmp31_ = cy[2];
	cairo_curve_to (c, _tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp31_);
	_tmp32_.x = (x + 1) - h;
	_tmp32_.y = y + 1;
	_tmp32_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp32_, &_tmp33_, &_tmp34_);
	cx[0] = _tmp33_;
	cy[0] = _tmp34_;
	_tmp35_.x = x + 1;
	_tmp35_.y = y + 1;
	_tmp35_.z = (((2.0 - h) - 1.5) / 2) + 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp35_, &_tmp36_, &_tmp37_);
	cx[1] = _tmp36_;
	cy[1] = _tmp37_;
	_tmp38_.x = x + 1;
	_tmp38_.y = y + 1;
	_tmp38_.z = 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp38_, &_tmp39_, &_tmp40_);
	cx[2] = _tmp39_;
	cy[2] = _tmp40_;
	_tmp41_ = cx[0];
	_tmp42_ = cy[0];
	_tmp43_ = cx[1];
	_tmp44_ = cy[1];
	_tmp45_ = cx[2];
	_tmp46_ = cy[2];
	cairo_curve_to (c, _tmp41_, _tmp42_, _tmp43_, _tmp44_, _tmp45_, _tmp46_);
	_tmp47_.x = x + 1;
	_tmp47_.y = y + 1;
	_tmp47_.z = 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp47_, &_tmp48_, &_tmp49_);
	cx[0] = _tmp48_;
	cy[0] = _tmp49_;
	_tmp50_.x = x + 1;
	_tmp50_.y = y + 1;
	_tmp50_.z = (((2.0 - h) - 1.5) / 2) + 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp50_, &_tmp51_, &_tmp52_);
	cx[1] = _tmp51_;
	cy[1] = _tmp52_;
	_tmp53_.x = (x + 1) + h;
	_tmp53_.y = y + 1;
	_tmp53_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp53_, &_tmp54_, &_tmp55_);
	cx[2] = _tmp54_;
	cy[2] = _tmp55_;
	_tmp56_ = cx[0];
	_tmp57_ = cy[0];
	_tmp58_ = cx[1];
	_tmp59_ = cy[1];
	_tmp60_ = cx[2];
	_tmp61_ = cy[2];
	cairo_curve_to (c, _tmp56_, _tmp57_, _tmp58_, _tmp59_, _tmp60_, _tmp61_);
	_tmp62_.x = (x + 1) + h;
	_tmp62_.y = y + 1;
	_tmp62_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp62_, &_tmp63_, &_tmp64_);
	cx[0] = _tmp63_;
	cy[0] = _tmp64_;
	_tmp65_.x = x + 1.5;
	_tmp65_.y = y + 1;
	_tmp65_.z = 2.0 + 0.207106781187;
	nibbles_view_view3_d_to_view_plain (v, &_tmp65_, &_tmp66_, &_tmp67_);
	cx[1] = _tmp66_;
	cy[1] = _tmp67_;
	_tmp68_.x = (x + 2) - h;
	_tmp68_.y = y + 1;
	_tmp68_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp68_, &_tmp69_, &_tmp70_);
	cx[2] = _tmp69_;
	cy[2] = _tmp70_;
	_tmp71_ = cx[0];
	_tmp72_ = cy[0];
	_tmp73_ = cx[1];
	_tmp74_ = cy[1];
	_tmp75_ = cx[2];
	_tmp76_ = cy[2];
	cairo_curve_to (c, _tmp71_, _tmp72_, _tmp73_, _tmp74_, _tmp75_, _tmp76_);
	_tmp77_.x = (x + 2) - h;
	_tmp77_.y = y + 1;
	_tmp77_.z = 2.0 - h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp77_, &_tmp78_, &_tmp79_);
	cx[0] = _tmp78_;
	cy[0] = _tmp79_;
	_tmp80_.x = (x + 2) + 0.207106781187;
	_tmp80_.y = y + 1;
	_tmp80_.z = 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp80_, &_tmp81_, &_tmp82_);
	cx[1] = _tmp81_;
	cy[1] = _tmp82_;
	_tmp83_.x = (x + 2) - h;
	_tmp83_.y = y + 1;
	_tmp83_.z = 1 + h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp83_, &_tmp84_, &_tmp85_);
	cx[2] = _tmp84_;
	cy[2] = _tmp85_;
	_tmp86_ = cx[0];
	_tmp87_ = cy[0];
	_tmp88_ = cx[1];
	_tmp89_ = cy[1];
	_tmp90_ = cx[2];
	_tmp91_ = cy[2];
	cairo_curve_to (c, _tmp86_, _tmp87_, _tmp88_, _tmp89_, _tmp90_, _tmp91_);
	_tmp92_.x = x + 1;
	_tmp92_.y = y + 1;
	_tmp92_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp92_, &_tmp93_, &_tmp94_);
	cx[0] = _tmp93_;
	cy[0] = _tmp94_;
	_tmp95_ = cx[0];
	_tmp96_ = cy[0];
	cairo_line_to (c, _tmp95_, _tmp96_);
	_tmp97_.x = x + h;
	_tmp97_.y = y + 1;
	_tmp97_.z = 1 + h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp97_, &_tmp98_, &_tmp99_);
	cx[0] = _tmp98_;
	cy[0] = _tmp99_;
	_tmp100_ = cx[0];
	_tmp101_ = cy[0];
	cairo_line_to (c, _tmp100_, _tmp101_);
	_tmp102_.x = x + 1;
	_tmp102_.y = y + 1;
	_tmp102_.z = 1 + h;
	nibbles_view_view3_d_to_view_plain (v, &_tmp102_, &_tmp103_, &_tmp104_);
	cx[0] = _tmp103_;
	cy[0] = _tmp104_;
	_tmp105_.x = x + 0.875;
	_tmp105_.y = y + 1;
	_tmp105_.z = 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp105_, &_tmp106_, &_tmp107_);
	cx[1] = _tmp106_;
	cy[1] = _tmp107_;
	_tmp108_.x = x + 1;
	_tmp108_.y = y + 1;
	_tmp108_.z = 1 + h;
	_tmp109_.x = x + 1;
	_tmp109_.y = y + 1;
	_tmp109_.z = 0.0;
	radius = nibbles_view_view3_d_2D_diff (v, &_tmp108_, &_tmp109_);
	_tmp110_ = cx[0];
	_tmp111_ = cy[0];
	_tmp112_ = cx[1];
	_tmp113_ = cy[1];
	_tmp114_ = cairo_pattern_create_radial (_tmp110_, _tmp111_, radius, _tmp112_, _tmp113_, radius / 40.0);
	pat2 = _tmp114_;
	cairo_pattern_add_color_stop_rgb (pat2, (gdouble) 0, (gdouble) (1 / 10), (gdouble) 0, (gdouble) 0);
	cairo_pattern_add_color_stop_rgb (pat2, (gdouble) 1, (gdouble) 1, (gdouble) 0, (gdouble) 0);
	cairo_pattern_add_color_stop_rgb (pat2, (gdouble) 2, (gdouble) 1, 0.5, 0.5);
	cairo_set_source (c, pat2);
	cairo_fill (c);
	_cairo_pattern_destroy0 (pat2);
}

static void
nibbles_view_draw_cherry (NibblesView* self,
                          cairo_t* c,
                          NibblesViewView3D* v,
                          gdouble x,
                          gdouble y)
{
	NibblesViewPoint3D _tmp0_ = {0};
	NibblesViewPoint3D _tmp1_ = {0};
	NibblesViewPoint3D _tmp2_ = {0};
	NibblesViewPoint3D _tmp3_ = {0};
	gdouble X = 0.0;
	gdouble Y = 0.0;
	gdouble radius = 0.0;
	gdouble d = 0.0;
	gdouble top_x = 0.0;
	gdouble top_y = 0.0;
	NibblesViewPoint3D _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	NibblesViewPoint3D _tmp7_ = {0};
	NibblesViewPoint3D _tmp8_ = {0};
	NibblesViewPoint3D _tmp9_ = {0};
	NibblesViewPoint3D _tmp10_ = {0};
	NibblesViewPoint3D _tmp11_ = {0};
	NibblesViewPoint3D _tmp12_ = {0};
	NibblesViewPoint3D _tmp13_ = {0};
	NibblesViewPoint3D _tmp14_ = {0};
	NibblesViewPoint3D _tmp15_ = {0};
	gdouble _tmp16_ = 0.0;
	gdouble _tmp17_ = 0.0;
	cairo_pattern_t* pat2 = NULL;
	cairo_pattern_t* _tmp18_;
	cairo_pattern_t* _tmp19_;
	cairo_pattern_t* _tmp20_;
	cairo_pattern_t* _tmp21_;
	cairo_pattern_t* _tmp22_;
	gdouble cx[3] = {0};
	gdouble cy[3] = {0};
	NibblesViewPoint3D _tmp23_ = {0};
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	NibblesViewPoint3D _tmp26_ = {0};
	gdouble _tmp27_ = 0.0;
	gdouble _tmp28_ = 0.0;
	NibblesViewPoint3D _tmp29_ = {0};
	gdouble _tmp30_ = 0.0;
	gdouble _tmp31_ = 0.0;
	gdouble _tmp32_;
	gdouble _tmp33_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	gdouble _tmp36_;
	gdouble _tmp37_;
	gdouble _tmp38_;
	gdouble _tmp39_;
	NibblesViewPoint3D _tmp40_ = {0};
	gdouble _tmp41_ = 0.0;
	gdouble _tmp42_ = 0.0;
	NibblesViewPoint3D _tmp43_ = {0};
	gdouble _tmp44_ = 0.0;
	gdouble _tmp45_ = 0.0;
	NibblesViewPoint3D _tmp46_ = {0};
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_ = 0.0;
	gdouble _tmp49_;
	gdouble _tmp50_;
	gdouble _tmp51_;
	gdouble _tmp52_;
	gdouble _tmp53_;
	gdouble _tmp54_;
	NibblesViewPoint3D _tmp55_ = {0};
	NibblesViewPoint3D _tmp56_ = {0};
	NibblesViewPoint3D _tmp57_ = {0};
	NibblesViewPoint3D _tmp58_ = {0};
	NibblesViewPoint3D _tmp59_ = {0};
	gdouble _tmp60_ = 0.0;
	gdouble _tmp61_ = 0.0;
	NibblesViewPoint3D _tmp62_ = {0};
	NibblesViewPoint3D _tmp63_ = {0};
	NibblesViewPoint3D _tmp64_ = {0};
	NibblesViewPoint3D _tmp65_ = {0};
	NibblesViewPoint3D _tmp66_ = {0};
	NibblesViewPoint3D _tmp67_ = {0};
	NibblesViewPoint3D _tmp68_ = {0};
	NibblesViewPoint3D _tmp69_ = {0};
	NibblesViewPoint3D _tmp70_ = {0};
	gdouble _tmp71_ = 0.0;
	gdouble _tmp72_ = 0.0;
	cairo_pattern_t* _tmp73_;
	cairo_pattern_t* _tmp74_;
	cairo_pattern_t* _tmp75_;
	cairo_pattern_t* _tmp76_;
	cairo_pattern_t* _tmp77_;
	NibblesViewPoint3D _tmp78_ = {0};
	gdouble _tmp79_ = 0.0;
	gdouble _tmp80_ = 0.0;
	NibblesViewPoint3D _tmp81_ = {0};
	gdouble _tmp82_ = 0.0;
	gdouble _tmp83_ = 0.0;
	NibblesViewPoint3D _tmp84_ = {0};
	gdouble _tmp85_ = 0.0;
	gdouble _tmp86_ = 0.0;
	gdouble _tmp87_;
	gdouble _tmp88_;
	gdouble _tmp89_;
	gdouble _tmp90_;
	gdouble _tmp91_;
	gdouble _tmp92_;
	gdouble _tmp93_;
	gdouble _tmp94_;
	NibblesViewPoint3D _tmp95_ = {0};
	gdouble _tmp96_ = 0.0;
	gdouble _tmp97_ = 0.0;
	NibblesViewPoint3D _tmp98_ = {0};
	gdouble _tmp99_ = 0.0;
	gdouble _tmp100_ = 0.0;
	NibblesViewPoint3D _tmp101_ = {0};
	gdouble _tmp102_ = 0.0;
	gdouble _tmp103_ = 0.0;
	gdouble _tmp104_;
	gdouble _tmp105_;
	gdouble _tmp106_;
	gdouble _tmp107_;
	gdouble _tmp108_;
	gdouble _tmp109_;
	NibblesViewPoint3D _tmp110_ = {0};
	gdouble _tmp111_ = 0.0;
	gdouble _tmp112_ = 0.0;
	NibblesViewPoint3D _tmp113_ = {0};
	gdouble _tmp114_ = 0.0;
	gdouble _tmp115_ = 0.0;
	NibblesViewPoint3D _tmp116_ = {0};
	gdouble _tmp117_ = 0.0;
	gdouble _tmp118_ = 0.0;
	gdouble _tmp119_;
	gdouble _tmp120_;
	gdouble _tmp121_;
	gdouble _tmp122_;
	gdouble _tmp123_;
	gdouble _tmp124_;
	gdouble _tmp125_;
	gdouble _tmp126_;
	NibblesViewPoint3D _tmp127_ = {0};
	gdouble _tmp128_ = 0.0;
	gdouble _tmp129_ = 0.0;
	NibblesViewPoint3D _tmp130_ = {0};
	gdouble _tmp131_ = 0.0;
	gdouble _tmp132_ = 0.0;
	NibblesViewPoint3D _tmp133_ = {0};
	gdouble _tmp134_ = 0.0;
	gdouble _tmp135_ = 0.0;
	gdouble _tmp136_;
	gdouble _tmp137_;
	gdouble _tmp138_;
	gdouble _tmp139_;
	gdouble _tmp140_;
	gdouble _tmp141_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_.x = x;
	_tmp0_.y = 1.5 + y;
	_tmp0_.z = (gdouble) 0;
	_tmp1_.x = x;
	_tmp1_.y = 0.5 + y;
	_tmp1_.z = (gdouble) 1;
	_tmp2_.x = 1.0 + x;
	_tmp2_.y = 0.5 + y;
	_tmp2_.z = (gdouble) 1;
	_tmp3_.x = 1.0 + x;
	_tmp3_.y = 1.5 + y;
	_tmp3_.z = (gdouble) 0;
	nibbles_view_draw_oval (self, c, v, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	_tmp4_.x = x + 0.5;
	_tmp4_.y = y + 1.0;
	_tmp4_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp4_, &_tmp5_, &_tmp6_);
	X = _tmp5_;
	Y = _tmp6_;
	_tmp7_.x = x + 0.5;
	_tmp7_.y = y + 1.0;
	_tmp7_.z = 0.5;
	_tmp8_.x = x + 0.5;
	_tmp8_.y = y + 0.5;
	_tmp8_.z = 1.0;
	radius = nibbles_view_view3_d_2D_diff (v, &_tmp7_, &_tmp8_);
	_tmp9_.x = x + 0.5;
	_tmp9_.y = y + 1.0;
	_tmp9_.z = 0.5;
	_tmp10_.x = x + 0.0;
	_tmp10_.y = y + 1.0;
	_tmp10_.z = 0.5;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp9_, &_tmp10_);
	if (d > radius) {
		radius = d;
	}
	_tmp11_.x = x + 0.5;
	_tmp11_.y = y + 1.0;
	_tmp11_.z = 0.5;
	_tmp12_.x = x + 1.0;
	_tmp12_.y = y + 1.0;
	_tmp12_.z = 0.5;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp11_, &_tmp12_);
	if (d > radius) {
		radius = d;
	}
	_tmp13_.x = x + 0.5;
	_tmp13_.y = y + 1.0;
	_tmp13_.z = 0.5;
	_tmp14_.x = x + 0.5;
	_tmp14_.y = y + 1.5;
	_tmp14_.z = 0.0;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp13_, &_tmp14_);
	if (d > radius) {
		radius = d;
	}
	_tmp15_.x = x + 0.5;
	_tmp15_.y = y + 1.0;
	_tmp15_.z = 1.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp15_, &_tmp16_, &_tmp17_);
	top_x = _tmp16_;
	top_y = _tmp17_;
	_tmp18_ = cairo_pattern_create_radial (X, Y, radius, top_x, top_y, radius / 20.0);
	pat2 = _tmp18_;
	_tmp19_ = pat2;
	cairo_pattern_add_color_stop_rgb (_tmp19_, (gdouble) 0, (gdouble) (1 / 10), (gdouble) 0, (gdouble) 0);
	_tmp20_ = pat2;
	cairo_pattern_add_color_stop_rgb (_tmp20_, (gdouble) 1, (gdouble) 1, (gdouble) 0, (gdouble) 0);
	_tmp21_ = pat2;
	cairo_pattern_add_color_stop_rgb (_tmp21_, (gdouble) 2, (gdouble) 1, 0.5, 0.5);
	_tmp22_ = pat2;
	cairo_set_source (c, _tmp22_);
	cairo_fill (c);
	_tmp23_.x = x + 0.45;
	_tmp23_.y = y + 1.0;
	_tmp23_.z = 1.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp23_, &_tmp24_, &_tmp25_);
	cx[0] = _tmp24_;
	cy[0] = _tmp25_;
	_tmp26_.x = x + 0.45;
	_tmp26_.y = y + 1.0;
	_tmp26_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp26_, &_tmp27_, &_tmp28_);
	cx[1] = _tmp27_;
	cy[1] = _tmp28_;
	_tmp29_.x = x + 1.15;
	_tmp29_.y = y + 1.0;
	_tmp29_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp29_, &_tmp30_, &_tmp31_);
	cx[2] = _tmp30_;
	cy[2] = _tmp31_;
	_tmp32_ = cx[0];
	_tmp33_ = cy[0];
	cairo_move_to (c, _tmp32_, _tmp33_);
	_tmp34_ = cx[0];
	_tmp35_ = cy[0];
	_tmp36_ = cx[1];
	_tmp37_ = cy[1];
	_tmp38_ = cx[2];
	_tmp39_ = cy[2];
	cairo_curve_to (c, _tmp34_, _tmp35_, _tmp36_, _tmp37_, _tmp38_, _tmp39_);
	_tmp40_.x = x + 1.25;
	_tmp40_.y = y + 1.0;
	_tmp40_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp40_, &_tmp41_, &_tmp42_);
	cx[0] = _tmp41_;
	cy[0] = _tmp42_;
	_tmp43_.x = x + 0.55;
	_tmp43_.y = y + 1.0;
	_tmp43_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp43_, &_tmp44_, &_tmp45_);
	cx[1] = _tmp44_;
	cy[1] = _tmp45_;
	_tmp46_.x = x + 0.55;
	_tmp46_.y = y + 1.0;
	_tmp46_.z = 1.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp46_, &_tmp47_, &_tmp48_);
	cx[2] = _tmp47_;
	cy[2] = _tmp48_;
	_tmp49_ = cx[0];
	_tmp50_ = cy[0];
	_tmp51_ = cx[1];
	_tmp52_ = cy[1];
	_tmp53_ = cx[2];
	_tmp54_ = cy[2];
	cairo_curve_to (c, _tmp49_, _tmp50_, _tmp51_, _tmp52_, _tmp53_, _tmp54_);
	cairo_set_source_rgb (c, 0.5, 0.5, (gdouble) 0);
	cairo_fill (c);
	_tmp55_.x = 1.0 + x;
	_tmp55_.y = 1.5 + y;
	_tmp55_.z = (gdouble) 0;
	_tmp56_.x = 1.0 + x;
	_tmp56_.y = 0.5 + y;
	_tmp56_.z = (gdouble) 1;
	_tmp57_.x = 2.0 + x;
	_tmp57_.y = 0.5 + y;
	_tmp57_.z = (gdouble) 1;
	_tmp58_.x = 2.0 + x;
	_tmp58_.y = 1.5 + y;
	_tmp58_.z = (gdouble) 0;
	nibbles_view_draw_oval (self, c, v, &_tmp55_, &_tmp56_, &_tmp57_, &_tmp58_);
	_tmp59_.x = x + 1.5;
	_tmp59_.y = y + 1.0;
	_tmp59_.z = 0.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp59_, &_tmp60_, &_tmp61_);
	X = _tmp60_;
	Y = _tmp61_;
	_tmp62_.x = x + 1.5;
	_tmp62_.y = y + 1.0;
	_tmp62_.z = 0.5;
	_tmp63_.x = x + 1.5;
	_tmp63_.y = y + 0.5;
	_tmp63_.z = 1.0;
	radius = nibbles_view_view3_d_2D_diff (v, &_tmp62_, &_tmp63_);
	_tmp64_.x = x + 1.5;
	_tmp64_.y = y + 1.0;
	_tmp64_.z = 0.5;
	_tmp65_.x = x + 1.0;
	_tmp65_.y = y + 1.0;
	_tmp65_.z = 0.5;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp64_, &_tmp65_);
	if (d > radius) {
		radius = d;
	}
	_tmp66_.x = x + 1.5;
	_tmp66_.y = y + 1.0;
	_tmp66_.z = 0.5;
	_tmp67_.x = x + 2.0;
	_tmp67_.y = y + 1.0;
	_tmp67_.z = 0.5;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp66_, &_tmp67_);
	if (d > radius) {
		radius = d;
	}
	_tmp68_.x = x + 1.5;
	_tmp68_.y = y + 1.0;
	_tmp68_.z = 0.5;
	_tmp69_.x = x + 1.5;
	_tmp69_.y = y + 1.5;
	_tmp69_.z = 0.0;
	d = nibbles_view_view3_d_2D_diff (v, &_tmp68_, &_tmp69_);
	if (d > radius) {
		radius = d;
	}
	_tmp70_.x = x + 1.5;
	_tmp70_.y = y + 1.0;
	_tmp70_.z = 1.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp70_, &_tmp71_, &_tmp72_);
	top_x = _tmp71_;
	top_y = _tmp72_;
	_tmp73_ = cairo_pattern_create_radial (X, Y, radius, top_x, top_y, radius / 20.0);
	_cairo_pattern_destroy0 (pat2);
	pat2 = _tmp73_;
	_tmp74_ = pat2;
	cairo_pattern_add_color_stop_rgb (_tmp74_, (gdouble) 0, (gdouble) (1 / 10), (gdouble) 0, (gdouble) 0);
	_tmp75_ = pat2;
	cairo_pattern_add_color_stop_rgb (_tmp75_, (gdouble) 1, (gdouble) 1, (gdouble) 0, (gdouble) 0);
	_tmp76_ = pat2;
	cairo_pattern_add_color_stop_rgb (_tmp76_, (gdouble) 2, (gdouble) 1, 0.5, 0.5);
	_tmp77_ = pat2;
	cairo_set_source (c, _tmp77_);
	cairo_fill (c);
	_tmp78_.x = x + 1.45;
	_tmp78_.y = y + 1.0;
	_tmp78_.z = 1.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp78_, &_tmp79_, &_tmp80_);
	cx[0] = _tmp79_;
	cy[0] = _tmp80_;
	_tmp81_.x = x + 1.45;
	_tmp81_.y = y + 1.0;
	_tmp81_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp81_, &_tmp82_, &_tmp83_);
	cx[1] = _tmp82_;
	cy[1] = _tmp83_;
	_tmp84_.x = x + 1.15;
	_tmp84_.y = y + 1.0;
	_tmp84_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp84_, &_tmp85_, &_tmp86_);
	cx[2] = _tmp85_;
	cy[2] = _tmp86_;
	_tmp87_ = cx[0];
	_tmp88_ = cy[0];
	cairo_move_to (c, _tmp87_, _tmp88_);
	_tmp89_ = cx[0];
	_tmp90_ = cy[0];
	_tmp91_ = cx[1];
	_tmp92_ = cy[1];
	_tmp93_ = cx[2];
	_tmp94_ = cy[2];
	cairo_curve_to (c, _tmp89_, _tmp90_, _tmp91_, _tmp92_, _tmp93_, _tmp94_);
	_tmp95_.x = x + 1.25;
	_tmp95_.y = y + 1.0;
	_tmp95_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp95_, &_tmp96_, &_tmp97_);
	cx[0] = _tmp96_;
	cy[0] = _tmp97_;
	_tmp98_.x = x + 1.55;
	_tmp98_.y = y + 1.0;
	_tmp98_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp98_, &_tmp99_, &_tmp100_);
	cx[1] = _tmp99_;
	cy[1] = _tmp100_;
	_tmp101_.x = x + 1.55;
	_tmp101_.y = y + 1.0;
	_tmp101_.z = 1.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp101_, &_tmp102_, &_tmp103_);
	cx[2] = _tmp102_;
	cy[2] = _tmp103_;
	_tmp104_ = cx[0];
	_tmp105_ = cy[0];
	_tmp106_ = cx[1];
	_tmp107_ = cy[1];
	_tmp108_ = cx[2];
	_tmp109_ = cy[2];
	cairo_curve_to (c, _tmp104_, _tmp105_, _tmp106_, _tmp107_, _tmp108_, _tmp109_);
	cairo_set_source_rgb (c, 0.5, 0.5, (gdouble) 0);
	cairo_fill (c);
	_tmp110_.x = x + 1.20;
	_tmp110_.y = y + 1.0;
	_tmp110_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp110_, &_tmp111_, &_tmp112_);
	cx[0] = _tmp111_;
	cy[0] = _tmp112_;
	_tmp113_.x = (x + 1.20) - 0.5;
	_tmp113_.y = y + 1.0;
	_tmp113_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp113_, &_tmp114_, &_tmp115_);
	cx[1] = _tmp114_;
	cy[1] = _tmp115_;
	_tmp116_.x = (x + 1.20) - 0.5;
	_tmp116_.y = (y + 1.0) - 0.5;
	_tmp116_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp116_, &_tmp117_, &_tmp118_);
	cx[2] = _tmp117_;
	cy[2] = _tmp118_;
	_tmp119_ = cx[0];
	_tmp120_ = cy[0];
	cairo_move_to (c, _tmp119_, _tmp120_);
	_tmp121_ = cx[0];
	_tmp122_ = cy[0];
	_tmp123_ = cx[1];
	_tmp124_ = cy[1];
	_tmp125_ = cx[2];
	_tmp126_ = cy[2];
	cairo_curve_to (c, _tmp121_, _tmp122_, _tmp123_, _tmp124_, _tmp125_, _tmp126_);
	_tmp127_.x = (x + 1.20) - 0.5;
	_tmp127_.y = (y + 1.0) - 0.5;
	_tmp127_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp127_, &_tmp128_, &_tmp129_);
	cx[0] = _tmp128_;
	cy[0] = _tmp129_;
	_tmp130_.x = x + 1.20;
	_tmp130_.y = (y + 1.0) - 0.5;
	_tmp130_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp130_, &_tmp131_, &_tmp132_);
	cx[1] = _tmp131_;
	cy[1] = _tmp132_;
	_tmp133_.x = x + 1.20;
	_tmp133_.y = y + 1.0;
	_tmp133_.z = 2.0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp133_, &_tmp134_, &_tmp135_);
	cx[2] = _tmp134_;
	cy[2] = _tmp135_;
	_tmp136_ = cx[0];
	_tmp137_ = cy[0];
	_tmp138_ = cx[1];
	_tmp139_ = cy[1];
	_tmp140_ = cx[2];
	_tmp141_ = cy[2];
	cairo_curve_to (c, _tmp136_, _tmp137_, _tmp138_, _tmp139_, _tmp140_, _tmp141_);
	cairo_set_source_rgb (c, (gdouble) 0, 0.75, (gdouble) 0);
	cairo_fill (c);
	_cairo_pattern_destroy0 (pat2);
}

static void
nibbles_view_draw_apple (NibblesView* self,
                         cairo_t* c,
                         NibblesViewView3D* v,
                         gdouble x,
                         gdouble y)
{
	gdouble cx[3] = {0};
	gdouble cy[3] = {0};
	gdouble top_x = 0.0;
	gdouble top_y = 0.0;
	NibblesViewPoint3D _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	NibblesViewPoint3D _tmp3_ = {0};
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	NibblesViewPoint3D _tmp6_ = {0};
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	gdouble _tmp15_;
	gdouble _tmp16_;
	NibblesViewPoint3D _tmp17_ = {0};
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	NibblesViewPoint3D _tmp20_ = {0};
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	NibblesViewPoint3D _tmp23_ = {0};
	gdouble _tmp24_ = 0.0;
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_;
	gdouble _tmp27_;
	gdouble _tmp28_;
	gdouble _tmp29_;
	gdouble _tmp30_;
	gdouble _tmp31_;
	NibblesViewPoint3D _tmp32_ = {0};
	gdouble _tmp33_ = 0.0;
	gdouble _tmp34_ = 0.0;
	NibblesViewPoint3D _tmp35_ = {0};
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	NibblesViewPoint3D _tmp38_ = {0};
	gdouble _tmp39_ = 0.0;
	gdouble _tmp40_ = 0.0;
	gdouble _tmp41_;
	gdouble _tmp42_;
	gdouble _tmp43_;
	gdouble _tmp44_;
	gdouble _tmp45_;
	gdouble _tmp46_;
	NibblesViewPoint3D _tmp47_ = {0};
	gdouble _tmp48_ = 0.0;
	gdouble _tmp49_ = 0.0;
	NibblesViewPoint3D _tmp50_ = {0};
	gdouble _tmp51_ = 0.0;
	gdouble _tmp52_ = 0.0;
	NibblesViewPoint3D _tmp53_ = {0};
	gdouble _tmp54_ = 0.0;
	gdouble _tmp55_ = 0.0;
	gdouble _tmp56_;
	gdouble _tmp57_;
	gdouble _tmp58_;
	gdouble _tmp59_;
	gdouble _tmp60_;
	gdouble _tmp61_;
	NibblesViewPoint3D _tmp62_ = {0};
	gdouble _tmp63_ = 0.0;
	gdouble _tmp64_ = 0.0;
	gdouble radius = 0.0;
	NibblesViewPoint3D _tmp65_ = {0};
	NibblesViewPoint3D _tmp66_ = {0};
	cairo_pattern_t* pat2 = NULL;
	cairo_pattern_t* _tmp67_;
	cairo_pattern_t* _tmp68_;
	cairo_pattern_t* _tmp69_;
	cairo_pattern_t* _tmp70_;
	cairo_pattern_t* _tmp71_;
	NibblesViewPoint3D _tmp135_ = {0};
	gdouble _tmp136_ = 0.0;
	gdouble _tmp137_ = 0.0;
	NibblesViewPoint3D _tmp138_ = {0};
	gdouble _tmp139_ = 0.0;
	gdouble _tmp140_ = 0.0;
	NibblesViewPoint3D _tmp141_ = {0};
	gdouble _tmp142_ = 0.0;
	gdouble _tmp143_ = 0.0;
	gdouble _tmp144_;
	gdouble _tmp145_;
	gdouble _tmp146_;
	gdouble _tmp147_;
	gdouble _tmp148_;
	gdouble _tmp149_;
	gdouble _tmp150_;
	gdouble _tmp151_;
	NibblesViewPoint3D _tmp152_ = {0};
	gdouble _tmp153_ = 0.0;
	gdouble _tmp154_ = 0.0;
	NibblesViewPoint3D _tmp155_ = {0};
	gdouble _tmp156_ = 0.0;
	gdouble _tmp157_ = 0.0;
	NibblesViewPoint3D _tmp158_ = {0};
	gdouble _tmp159_ = 0.0;
	gdouble _tmp160_ = 0.0;
	gdouble _tmp161_;
	gdouble _tmp162_;
	gdouble _tmp163_;
	gdouble _tmp164_;
	gdouble _tmp165_;
	gdouble _tmp166_;
	NibblesViewPoint3D _tmp167_ = {0};
	gdouble _tmp168_ = 0.0;
	gdouble _tmp169_ = 0.0;
	NibblesViewPoint3D _tmp170_ = {0};
	gdouble _tmp171_ = 0.0;
	gdouble _tmp172_ = 0.0;
	NibblesViewPoint3D _tmp173_ = {0};
	gdouble _tmp174_ = 0.0;
	gdouble _tmp175_ = 0.0;
	gdouble _tmp176_;
	gdouble _tmp177_;
	gdouble _tmp178_;
	gdouble _tmp179_;
	gdouble _tmp180_;
	gdouble _tmp181_;
	gdouble _tmp182_;
	gdouble _tmp183_;
	NibblesViewPoint3D _tmp184_ = {0};
	gdouble _tmp185_ = 0.0;
	gdouble _tmp186_ = 0.0;
	NibblesViewPoint3D _tmp187_ = {0};
	gdouble _tmp188_ = 0.0;
	gdouble _tmp189_ = 0.0;
	NibblesViewPoint3D _tmp190_ = {0};
	gdouble _tmp191_ = 0.0;
	gdouble _tmp192_ = 0.0;
	gdouble _tmp193_;
	gdouble _tmp194_;
	gdouble _tmp195_;
	gdouble _tmp196_;
	gdouble _tmp197_;
	gdouble _tmp198_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (c != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_.x = x + 0;
	_tmp0_.y = y + 1;
	_tmp0_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp0_, &_tmp1_, &_tmp2_);
	cx[0] = _tmp1_;
	cy[0] = _tmp2_;
	_tmp3_.x = x + 0;
	_tmp3_.y = y + 1;
	_tmp3_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp3_, &_tmp4_, &_tmp5_);
	cx[1] = _tmp4_;
	cy[1] = _tmp5_;
	_tmp6_.x = x + 1;
	_tmp6_.y = y + 1;
	_tmp6_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp6_, &_tmp7_, &_tmp8_);
	cx[2] = _tmp7_;
	cy[2] = _tmp8_;
	_tmp9_ = cx[0];
	_tmp10_ = cy[0];
	cairo_move_to (c, _tmp9_, _tmp10_);
	_tmp11_ = cx[0];
	_tmp12_ = cy[0];
	_tmp13_ = cx[1];
	_tmp14_ = cy[1];
	_tmp15_ = cx[2];
	_tmp16_ = cy[2];
	cairo_curve_to (c, _tmp11_, _tmp12_, _tmp13_, _tmp14_, _tmp15_, _tmp16_);
	_tmp17_.x = x + 1;
	_tmp17_.y = y + 1;
	_tmp17_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp17_, &_tmp18_, &_tmp19_);
	cx[0] = _tmp18_;
	cy[0] = _tmp19_;
	_tmp20_.x = x + 2;
	_tmp20_.y = y + 1;
	_tmp20_.z = (gdouble) 0;
	nibbles_view_view3_d_to_view_plain (v, &_tmp20_, &_tmp21_, &_tmp22_);
	cx[1] = _tmp21_;
	cy[1] = _tmp22_;
	_tmp23_.x = x + 2;
	_tmp23_.y = y + 1;
	_tmp23_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp23_, &_tmp24_, &_tmp25_);
	cx[2] = _tmp24_;
	cy[2] = _tmp25_;
	_tmp26_ = cx[0];
	_tmp27_ = cy[0];
	_tmp28_ = cx[1];
	_tmp29_ = cy[1];
	_tmp30_ = cx[2];
	_tmp31_ = cy[2];
	cairo_curve_to (c, _tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp31_);
	_tmp32_.x = x + 2;
	_tmp32_.y = y + 1;
	_tmp32_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp32_, &_tmp33_, &_tmp34_);
	cx[0] = _tmp33_;
	cy[0] = _tmp34_;
	_tmp35_.x = x + 2;
	_tmp35_.y = y + 1.0;
	_tmp35_.z = (gdouble) 2;
	nibbles_view_view3_d_to_view_plain (v, &_tmp35_, &_tmp36_, &_tmp37_);
	cx[1] = _tmp36_;
	cy[1] = _tmp37_;
	_tmp38_.x = x + 1.0;
	_tmp38_.y = y + 1;
	_tmp38_.z = (gdouble) 2;
	nibbles_view_view3_d_to_view_plain (v, &_tmp38_, &_tmp39_, &_tmp40_);
	cx[2] = _tmp39_;
	cy[2] = _tmp40_;
	_tmp41_ = cx[0];
	_tmp42_ = cy[0];
	_tmp43_ = cx[1];
	_tmp44_ = cy[1];
	_tmp45_ = cx[2];
	_tmp46_ = cy[2];
	cairo_curve_to (c, _tmp41_, _tmp42_, _tmp43_, _tmp44_, _tmp45_, _tmp46_);
	_tmp47_.x = x + 1.0;
	_tmp47_.y = y + 1;
	_tmp47_.z = (gdouble) 2;
	nibbles_view_view3_d_to_view_plain (v, &_tmp47_, &_tmp48_, &_tmp49_);
	cx[0] = _tmp48_;
	cy[0] = _tmp49_;
	_tmp50_.x = x + 0;
	_tmp50_.y = y + 1;
	_tmp50_.z = (gdouble) 2;
	nibbles_view_view3_d_to_view_plain (v, &_tmp50_, &_tmp51_, &_tmp52_);
	cx[1] = _tmp51_;
	cy[1] = _tmp52_;
	_tmp53_.x = x + 0;
	_tmp53_.y = y + 1;
	_tmp53_.z = (gdouble) 1;
	nibbles_view_view3_d_to_view_plain (v, &_tmp53_, &_tmp54_, &_tmp55_);
	cx[2] = _tmp54_;
	cy[2] = _tmp55_;
	_tmp56_ = cx[0];
	_tmp57_ = cy[0];
	_tmp58_ = cx[1];
	_tmp59_ = cy[1];
	_tmp60_ = cx[2];
	_tmp61_ = cy[2];
	cairo_curve_to (c, _tmp56_, _tmp57_, _tmp58_, _tmp59_, _tmp60_, _tmp61_);
	_tmp62_.x = x + 1;
	_tmp62_.y = y + 1.0;
	_tmp62_.z = 1.5;
	nibbles_view_view3_d_to_view_plain (v, &_tmp62_, &_tmp63_, &_tmp64_);
	top_x = _tmp63_;
	top_y = _tmp64_;
	_tmp65_.x = x + 1;
	_tmp65_.y = y + 1.0;
	_tmp65_.z = 1.5;
	_tmp66_.x = x + 1;
	_tmp66_.y = y + 1.0;
	_tmp66_.z = (gdouble) 0;
	radius = nibbles_view_view3_d_2D_diff (v, &_tmp65_, &_tmp66_);
	_tmp67_ = cairo_pattern_create_radial (top_x, top_y, radius, top_x, top_y, radius / 20.0);
	pat2 = _tmp67_;
	_tmp68_ = pat2;
	cairo_pattern_add_color_stop_rgb (_tmp68_, (gdouble) 0, (gdouble) 0, (gdouble) (1 / 10), (gdouble) 0);
	_tmp69_ = pat2;
	cairo_pattern_add_color_stop_rgb (_tmp69_, (gdouble) 1, (gdouble) 0, (gdouble) 1, (gdouble) 0);
	_tmp70_ = pat2;
	cairo_pattern_add_color_stop_rgb (_tmp70_, (gdouble) 2, 0.5, (gdouble) 1, 0.5);
	_tmp71_ = pat2;
	cairo_set_source (c, _tmp71_);
	cairo_fill (c);
	{
		gdouble _3D_radius_ = 0.0;
		_3D_radius_ = 0.2;
		{
			gboolean _tmp72_ = FALSE;
			_tmp72_ = TRUE;
			while (TRUE) {
				NibblesViewPoint3D _tmp73_ = {0};
				gdouble _tmp74_ = 0.0;
				gdouble _tmp75_ = 0.0;
				NibblesViewPoint3D _tmp76_ = {0};
				gdouble _tmp77_ = 0.0;
				gdouble _tmp78_ = 0.0;
				NibblesViewPoint3D _tmp79_ = {0};
				gdouble _tmp80_ = 0.0;
				gdouble _tmp81_ = 0.0;
				gdouble _tmp82_;
				gdouble _tmp83_;
				gdouble _tmp84_;
				gdouble _tmp85_;
				gdouble _tmp86_;
				gdouble _tmp87_;
				gdouble _tmp88_;
				gdouble _tmp89_;
				NibblesViewPoint3D _tmp90_ = {0};
				gdouble _tmp91_ = 0.0;
				gdouble _tmp92_ = 0.0;
				NibblesViewPoint3D _tmp93_ = {0};
				gdouble _tmp94_ = 0.0;
				gdouble _tmp95_ = 0.0;
				NibblesViewPoint3D _tmp96_ = {0};
				gdouble _tmp97_ = 0.0;
				gdouble _tmp98_ = 0.0;
				gdouble _tmp99_;
				gdouble _tmp100_;
				gdouble _tmp101_;
				gdouble _tmp102_;
				gdouble _tmp103_;
				gdouble _tmp104_;
				NibblesViewPoint3D _tmp105_ = {0};
				gdouble _tmp106_ = 0.0;
				gdouble _tmp107_ = 0.0;
				NibblesViewPoint3D _tmp108_ = {0};
				gdouble _tmp109_ = 0.0;
				gdouble _tmp110_ = 0.0;
				NibblesViewPoint3D _tmp111_ = {0};
				gdouble _tmp112_ = 0.0;
				gdouble _tmp113_ = 0.0;
				gdouble _tmp114_;
				gdouble _tmp115_;
				gdouble _tmp116_;
				gdouble _tmp117_;
				gdouble _tmp118_;
				gdouble _tmp119_;
				NibblesViewPoint3D _tmp120_ = {0};
				gdouble _tmp121_ = 0.0;
				gdouble _tmp122_ = 0.0;
				NibblesViewPoint3D _tmp123_ = {0};
				gdouble _tmp124_ = 0.0;
				gdouble _tmp125_ = 0.0;
				NibblesViewPoint3D _tmp126_ = {0};
				gdouble _tmp127_ = 0.0;
				gdouble _tmp128_ = 0.0;
				gdouble _tmp129_;
				gdouble _tmp130_;
				gdouble _tmp131_;
				gdouble _tmp132_;
				gdouble _tmp133_;
				gdouble _tmp134_;
				if (!_tmp72_) {
					_3D_radius_ -= 0.01;
				}
				_tmp72_ = FALSE;
				if (!(_3D_radius_ > 0.01)) {
					break;
				}
				_tmp73_.x = x + (1 - _3D_radius_);
				_tmp73_.y = y + 1.0;
				_tmp73_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp73_, &_tmp74_, &_tmp75_);
				cx[0] = _tmp74_;
				cy[0] = _tmp75_;
				_tmp76_.x = x + (1 - _3D_radius_);
				_tmp76_.y = y + (1 - _3D_radius_);
				_tmp76_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp76_, &_tmp77_, &_tmp78_);
				cx[1] = _tmp77_;
				cy[1] = _tmp78_;
				_tmp79_.x = x + 1.00;
				_tmp79_.y = y + (1 - _3D_radius_);
				_tmp79_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp79_, &_tmp80_, &_tmp81_);
				cx[2] = _tmp80_;
				cy[2] = _tmp81_;
				_tmp82_ = cx[0];
				_tmp83_ = cy[0];
				cairo_move_to (c, _tmp82_, _tmp83_);
				_tmp84_ = cx[0];
				_tmp85_ = cy[0];
				_tmp86_ = cx[1];
				_tmp87_ = cy[1];
				_tmp88_ = cx[2];
				_tmp89_ = cy[2];
				cairo_curve_to (c, _tmp84_, _tmp85_, _tmp86_, _tmp87_, _tmp88_, _tmp89_);
				_tmp90_.x = x + 1.00;
				_tmp90_.y = y + (1 - _3D_radius_);
				_tmp90_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp90_, &_tmp91_, &_tmp92_);
				cx[0] = _tmp91_;
				cy[0] = _tmp92_;
				_tmp93_.x = x + (1 + _3D_radius_);
				_tmp93_.y = y + (1 - _3D_radius_);
				_tmp93_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp93_, &_tmp94_, &_tmp95_);
				cx[1] = _tmp94_;
				cy[1] = _tmp95_;
				_tmp96_.x = x + (1 + _3D_radius_);
				_tmp96_.y = y + 1.0;
				_tmp96_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp96_, &_tmp97_, &_tmp98_);
				cx[2] = _tmp97_;
				cy[2] = _tmp98_;
				_tmp99_ = cx[0];
				_tmp100_ = cy[0];
				_tmp101_ = cx[1];
				_tmp102_ = cy[1];
				_tmp103_ = cx[2];
				_tmp104_ = cy[2];
				cairo_curve_to (c, _tmp99_, _tmp100_, _tmp101_, _tmp102_, _tmp103_, _tmp104_);
				_tmp105_.x = x + (1 + _3D_radius_);
				_tmp105_.y = y + 1.0;
				_tmp105_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp105_, &_tmp106_, &_tmp107_);
				cx[0] = _tmp106_;
				cy[0] = _tmp107_;
				_tmp108_.x = x + (1 + _3D_radius_);
				_tmp108_.y = y + (1 + _3D_radius_);
				_tmp108_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp108_, &_tmp109_, &_tmp110_);
				cx[1] = _tmp109_;
				cy[1] = _tmp110_;
				_tmp111_.x = x + 1;
				_tmp111_.y = y + (1 + _3D_radius_);
				_tmp111_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp111_, &_tmp112_, &_tmp113_);
				cx[2] = _tmp112_;
				cy[2] = _tmp113_;
				_tmp114_ = cx[0];
				_tmp115_ = cy[0];
				_tmp116_ = cx[1];
				_tmp117_ = cy[1];
				_tmp118_ = cx[2];
				_tmp119_ = cy[2];
				cairo_curve_to (c, _tmp114_, _tmp115_, _tmp116_, _tmp117_, _tmp118_, _tmp119_);
				_tmp120_.x = x + 1;
				_tmp120_.y = y + (1 + _3D_radius_);
				_tmp120_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp120_, &_tmp121_, &_tmp122_);
				cx[0] = _tmp121_;
				cy[0] = _tmp122_;
				_tmp123_.x = x + (1 - _3D_radius_);
				_tmp123_.y = y + (1 + _3D_radius_);
				_tmp123_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp123_, &_tmp124_, &_tmp125_);
				cx[1] = _tmp124_;
				cy[1] = _tmp125_;
				_tmp126_.x = x + (1 - _3D_radius_);
				_tmp126_.y = y + 1.0;
				_tmp126_.z = 1.75;
				nibbles_view_view3_d_to_view_plain (v, &_tmp126_, &_tmp127_, &_tmp128_);
				cx[2] = _tmp127_;
				cy[2] = _tmp128_;
				_tmp129_ = cx[0];
				_tmp130_ = cy[0];
				_tmp131_ = cx[1];
				_tmp132_ = cy[1];
				_tmp133_ = cx[2];
				_tmp134_ = cy[2];
				cairo_curve_to (c, _tmp129_, _tmp130_, _tmp131_, _tmp132_, _tmp133_, _tmp134_);
				cairo_set_source_rgb (c, 0.4, 0.8 - ((0.2 - _3D_radius_) * 3), 0.4 - ((0.2 - _3D_radius_) * 2));
				cairo_fill (c);
			}
		}
	}
	_tmp135_.x = x + 1.0;
	_tmp135_.y = y + 1.0;
	_tmp135_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp135_, &_tmp136_, &_tmp137_);
	cx[0] = _tmp136_;
	cy[0] = _tmp137_;
	_tmp138_.x = (x + 1.0) - 0.5;
	_tmp138_.y = y + 1.0;
	_tmp138_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp138_, &_tmp139_, &_tmp140_);
	cx[1] = _tmp139_;
	cy[1] = _tmp140_;
	_tmp141_.x = (x + 1.0) - 0.5;
	_tmp141_.y = (y + 1.0) - 0.5;
	_tmp141_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp141_, &_tmp142_, &_tmp143_);
	cx[2] = _tmp142_;
	cy[2] = _tmp143_;
	_tmp144_ = cx[0];
	_tmp145_ = cy[0];
	cairo_move_to (c, _tmp144_, _tmp145_);
	_tmp146_ = cx[0];
	_tmp147_ = cy[0];
	_tmp148_ = cx[1];
	_tmp149_ = cy[1];
	_tmp150_ = cx[2];
	_tmp151_ = cy[2];
	cairo_curve_to (c, _tmp146_, _tmp147_, _tmp148_, _tmp149_, _tmp150_, _tmp151_);
	_tmp152_.x = (x + 1.0) - 0.5;
	_tmp152_.y = (y + 1.0) - 0.5;
	_tmp152_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp152_, &_tmp153_, &_tmp154_);
	cx[0] = _tmp153_;
	cy[0] = _tmp154_;
	_tmp155_.x = x + 1.0;
	_tmp155_.y = (y + 1.0) - 0.5;
	_tmp155_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp155_, &_tmp156_, &_tmp157_);
	cx[1] = _tmp156_;
	cy[1] = _tmp157_;
	_tmp158_.x = x + 1.0;
	_tmp158_.y = y + 1.0;
	_tmp158_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp158_, &_tmp159_, &_tmp160_);
	cx[2] = _tmp159_;
	cy[2] = _tmp160_;
	_tmp161_ = cx[0];
	_tmp162_ = cy[0];
	_tmp163_ = cx[1];
	_tmp164_ = cy[1];
	_tmp165_ = cx[2];
	_tmp166_ = cy[2];
	cairo_curve_to (c, _tmp161_, _tmp162_, _tmp163_, _tmp164_, _tmp165_, _tmp166_);
	cairo_set_source_rgb (c, 0.25, 0.5, (gdouble) 0);
	cairo_fill (c);
	_tmp167_.x = x + 1.0;
	_tmp167_.y = y + 1.0;
	_tmp167_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp167_, &_tmp168_, &_tmp169_);
	cx[0] = _tmp168_;
	cy[0] = _tmp169_;
	_tmp170_.x = (x + 1.0) + 0.5;
	_tmp170_.y = y + 1.0;
	_tmp170_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp170_, &_tmp171_, &_tmp172_);
	cx[1] = _tmp171_;
	cy[1] = _tmp172_;
	_tmp173_.x = (x + 1.0) + 0.5;
	_tmp173_.y = (y + 1.0) - 0.5;
	_tmp173_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp173_, &_tmp174_, &_tmp175_);
	cx[2] = _tmp174_;
	cy[2] = _tmp175_;
	_tmp176_ = cx[0];
	_tmp177_ = cy[0];
	cairo_move_to (c, _tmp176_, _tmp177_);
	_tmp178_ = cx[0];
	_tmp179_ = cy[0];
	_tmp180_ = cx[1];
	_tmp181_ = cy[1];
	_tmp182_ = cx[2];
	_tmp183_ = cy[2];
	cairo_curve_to (c, _tmp178_, _tmp179_, _tmp180_, _tmp181_, _tmp182_, _tmp183_);
	_tmp184_.x = (x + 1.0) + 0.5;
	_tmp184_.y = (y + 1.0) - 0.5;
	_tmp184_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp184_, &_tmp185_, &_tmp186_);
	cx[0] = _tmp185_;
	cy[0] = _tmp186_;
	_tmp187_.x = x + 1.0;
	_tmp187_.y = (y + 1.0) - 0.5;
	_tmp187_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp187_, &_tmp188_, &_tmp189_);
	cx[1] = _tmp188_;
	cy[1] = _tmp189_;
	_tmp190_.x = x + 1.0;
	_tmp190_.y = y + 1.0;
	_tmp190_.z = 1.75;
	nibbles_view_view3_d_to_view_plain (v, &_tmp190_, &_tmp191_, &_tmp192_);
	cx[2] = _tmp191_;
	cy[2] = _tmp192_;
	_tmp193_ = cx[0];
	_tmp194_ = cy[0];
	_tmp195_ = cx[1];
	_tmp196_ = cy[1];
	_tmp197_ = cx[2];
	_tmp198_ = cy[2];
	cairo_curve_to (c, _tmp193_, _tmp194_, _tmp195_, _tmp196_, _tmp197_, _tmp198_);
	cairo_set_source_rgb (c, (gdouble) 0, 0.5, 0.25);
	cairo_fill (c);
	_cairo_pattern_destroy0 (pat2);
}

static void
nibbles_view_draw_wall_segment (NibblesView* self,
                                gint i,
                                cairo_t* C,
                                gint x,
                                gint y,
                                gint x_size,
                                gint y_size)
{
	gint x_s13 = 0;
	gint x_remainder = 0;
	gint y_s13 = 0;
	gint y_remainder = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp33_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	x_s13 = x_size / 3;
	x_remainder = x_size - (x_s13 * 3);
	y_s13 = y_size / 3;
	y_remainder = y_size - (y_s13 * 3);
	if (i >= ((gint) 'b')) {
		_tmp0_ = i <= ((gint) 'l');
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		if (x_remainder == 2) {
			_tmp1_ = (x_s13 + x) + x_remainder;
		} else {
			_tmp1_ = x_s13 + x;
		}
		if (y_remainder == 2) {
			_tmp2_ = (y_s13 + y) + y_remainder;
		} else {
			_tmp2_ = y_s13 + y;
		}
		if (x_remainder == 2) {
			_tmp3_ = x_s13;
		} else {
			_tmp3_ = x_s13 + x_remainder;
		}
		if (y_remainder == 2) {
			_tmp4_ = y_s13;
		} else {
			_tmp4_ = y_s13 + y_remainder;
		}
		cairo_rectangle (C, (gdouble) _tmp1_, (gdouble) _tmp2_, (gdouble) _tmp3_, (gdouble) _tmp4_);
		cairo_set_source_rgb (C, 0.5, 0.5, 0.5);
		cairo_fill (C);
	}
	if (i == ((gint) 'b')) {
		_tmp10_ = TRUE;
	} else {
		_tmp10_ = i == ((gint) 'd');
	}
	if (_tmp10_) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = i == ((gint) 'e');
	}
	if (_tmp9_) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = i == ((gint) 'h');
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = i == ((gint) 'i');
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = i == ((gint) 'j');
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = i == ((gint) 'l');
	}
	if (_tmp5_) {
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		if (x_remainder == 2) {
			_tmp11_ = (x_s13 + x) + x_remainder;
		} else {
			_tmp11_ = x_s13 + x;
		}
		if (x_remainder == 2) {
			_tmp12_ = x_s13;
		} else {
			_tmp12_ = x_s13 + x_remainder;
		}
		if (y_remainder == 2) {
			_tmp13_ = y_s13 + y_remainder;
		} else {
			_tmp13_ = y_s13;
		}
		cairo_rectangle (C, (gdouble) _tmp11_, (gdouble) y, (gdouble) _tmp12_, (gdouble) _tmp13_);
		cairo_set_source_rgb (C, 0.5, 0.5, 0.5);
		cairo_fill (C);
	}
	if (i == ((gint) 'c')) {
		_tmp19_ = TRUE;
	} else {
		_tmp19_ = i == ((gint) 'd');
	}
	if (_tmp19_) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = i == ((gint) 'f');
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = i == ((gint) 'h');
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = i == ((gint) 'i');
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = i == ((gint) 'k');
	}
	if (_tmp15_) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = i == ((gint) 'l');
	}
	if (_tmp14_) {
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		if (y_remainder == 2) {
			_tmp20_ = (y_s13 + y_remainder) + y;
		} else {
			_tmp20_ = y_s13 + y;
		}
		if (x_remainder == 2) {
			_tmp21_ = x_s13 + x_remainder;
		} else {
			_tmp21_ = x_s13;
		}
		if (y_remainder == 2) {
			_tmp22_ = y_s13;
		} else {
			_tmp22_ = y_s13 + y_remainder;
		}
		cairo_rectangle (C, (gdouble) (((x_s13 + x_s13) + x_remainder) + x), (gdouble) _tmp20_, (gdouble) _tmp21_, (gdouble) _tmp22_);
		cairo_set_source_rgb (C, 0.5, 0.5, 0.5);
		cairo_fill (C);
	}
	if (i == ((gint) 'b')) {
		_tmp28_ = TRUE;
	} else {
		_tmp28_ = i == ((gint) 'f');
	}
	if (_tmp28_) {
		_tmp27_ = TRUE;
	} else {
		_tmp27_ = i == ((gint) 'g');
	}
	if (_tmp27_) {
		_tmp26_ = TRUE;
	} else {
		_tmp26_ = i == ((gint) 'i');
	}
	if (_tmp26_) {
		_tmp25_ = TRUE;
	} else {
		_tmp25_ = i == ((gint) 'j');
	}
	if (_tmp25_) {
		_tmp24_ = TRUE;
	} else {
		_tmp24_ = i == ((gint) 'k');
	}
	if (_tmp24_) {
		_tmp23_ = TRUE;
	} else {
		_tmp23_ = i == ((gint) 'l');
	}
	if (_tmp23_) {
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gint _tmp31_ = 0;
		if (x_remainder == 2) {
			_tmp29_ = (x_s13 + x) + x_remainder;
		} else {
			_tmp29_ = x_s13 + x;
		}
		if (x_remainder == 2) {
			_tmp30_ = x_s13;
		} else {
			_tmp30_ = x_s13 + x_remainder;
		}
		if (y_remainder == 2) {
			_tmp31_ = y_s13 + y_remainder;
		} else {
			_tmp31_ = y_s13;
		}
		cairo_rectangle (C, (gdouble) _tmp29_, (gdouble) (((y_s13 + y_s13) + y_remainder) + y), (gdouble) _tmp30_, (gdouble) _tmp31_);
		cairo_set_source_rgb (C, 0.5, 0.5, 0.5);
		cairo_fill (C);
	}
	if (i == ((gint) 'c')) {
		_tmp37_ = TRUE;
	} else {
		_tmp37_ = i == ((gint) 'e');
	}
	if (_tmp37_) {
		_tmp36_ = TRUE;
	} else {
		_tmp36_ = i == ((gint) 'g');
	}
	if (_tmp36_) {
		_tmp35_ = TRUE;
	} else {
		_tmp35_ = i == ((gint) 'h');
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		_tmp34_ = i == ((gint) 'j');
	}
	if (_tmp34_) {
		_tmp33_ = TRUE;
	} else {
		_tmp33_ = i == ((gint) 'k');
	}
	if (_tmp33_) {
		_tmp32_ = TRUE;
	} else {
		_tmp32_ = i == ((gint) 'l');
	}
	if (_tmp32_) {
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		if (y_remainder == 2) {
			_tmp38_ = (y_s13 + y) + y_remainder;
		} else {
			_tmp38_ = y_s13 + y;
		}
		if (x_remainder == 2) {
			_tmp39_ = x_s13 + x_remainder;
		} else {
			_tmp39_ = x_s13;
		}
		if (y_remainder == 2) {
			_tmp40_ = y_s13;
		} else {
			_tmp40_ = y_s13 + y_remainder;
		}
		cairo_rectangle (C, (gdouble) x, (gdouble) _tmp38_, (gdouble) _tmp39_, (gdouble) _tmp40_);
		cairo_set_source_rgb (C, 0.5, 0.5, 0.5);
		cairo_fill (C);
	}
}

static void
nibbles_view_draw_worm_segment (NibblesView* self,
                                cairo_t* C,
                                gint x,
                                gint y,
                                gint x_size,
                                gint y_size,
                                gint color,
                                gboolean is_materialized,
                                gboolean eaten_bonus)
{
	static const gdouble PI2 = 1.570796326794896619231321691639751442;
	gdouble x_s13 = 0.0;
	gdouble x_s23 = 0.0;
	gdouble y_s13 = 0.0;
	gdouble y_s23 = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	if (eaten_bonus) {
		gint a = 0;
		a = x_size + (x_size / 5);
		if (a < (x_size + 1)) {
			x_size = x_size + 1;
		} else {
			x = x - ((a - x_size) / 2);
			x_size = a;
		}
		a = y_size + (y_size / 5);
		if (a < (y_size + 1)) {
			y_size = y_size + 1;
		} else {
			y = y - ((a - y_size) / 2);
			y_size = a;
		}
	} else {
		gint _tmp0_;
		gint _tmp1_;
		x = x + 1;
		_tmp0_ = x;
		y = y + 1;
		_tmp1_ = y;
		x_size = x_size - 1;
		y_size = y_size - 1;
	}
	x_s13 = x_size / 3.0;
	x_s23 = x_s13 + x_s13;
	y_s13 = y_size / 3.0;
	y_s23 = y_s13 + y_s13;
	if (x_s13 < y_s13) {
		_tmp2_ = x_s13;
	} else {
		_tmp2_ = y_s13;
	}
	cairo_arc (C, x + x_s23, y + y_s13, _tmp2_, -PI2, (gdouble) 0);
	if (x_s13 < y_s13) {
		_tmp3_ = x_s13;
	} else {
		_tmp3_ = y_s13;
	}
	cairo_arc (C, x + x_s23, y + y_s23, _tmp3_, (gdouble) 0, PI2);
	if (x_s13 < y_s13) {
		_tmp4_ = x_s13;
	} else {
		_tmp4_ = y_s13;
	}
	cairo_arc (C, x + x_s13, y + y_s23, _tmp4_, PI2, PI2 * 2);
	if (x_s13 < y_s13) {
		_tmp5_ = x_s13;
	} else {
		_tmp5_ = y_s13;
	}
	cairo_arc (C, x + x_s13, y + y_s13, _tmp5_, PI2 * 2, -PI2);
	nibbles_view_set_color (self, C, color, is_materialized);
	cairo_fill (C);
}

static void
nibbles_view_draw_bonus (NibblesView* self,
                         cairo_t* C,
                         gint x,
                         gint y,
                         gint x_size,
                         gint y_size,
                         BonusType type)
{
	gdouble x_m = 0.0;
	gdouble y_m = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	x_m = (gdouble) x_size;
	y_m = (gdouble) y_size;
	switch (type) {
		case BONUS_TYPE_REGULAR:
		{
			x_m /= (gdouble) 18;
			y_m /= (gdouble) 18;
			cairo_move_to (C, x + (x_m * 15), y + (y_m * 8));
			cairo_curve_to (C, x + (x_m * 15.023438), y + (y_m * 10.035156), x + (x_m * 13.953125), y + (y_m * 17.1875), x + (x_m * 8), y + (y_m * 14.429688));
			cairo_curve_to (C, x + (x_m * 1.90625), y + (y_m * 17.109375), x + (x_m * 1.03125), y + (y_m * 9.921875), x + (x_m * 1), y + (y_m * 8));
			cairo_curve_to (C, x + (x_m * 1.007813), y + (y_m * 5.109375), x + (x_m * 3.300781), y + (y_m * 1.355469), x + (x_m * 8), y + (y_m * 4.3125));
			cairo_curve_to (C, x + (x_m * 12.933594), y + (y_m * 1.394531), x + (x_m * 15.0625), y + (y_m * 5), x + (x_m * 15), y + (y_m * 8));
			cairo_close_path (C);
			cairo_set_source_rgba (C, (gdouble) 0, (gdouble) 1, (gdouble) 0, (gdouble) 1);
			cairo_fill (C);
			cairo_move_to (C, x + (x_m * 9.65625), y + (y_m * 1.34375));
			cairo_curve_to (C, x + (x_m * 8), y + (y_m * 2), x + (x_m * 8), y + (y_m * 3.667969), x + (x_m * 8), y + (y_m * 5));
			cairo_close_path (C);
			cairo_set_source_rgba (C, (gdouble) 0, (gdouble) 1, (gdouble) 0, (gdouble) 1);
			cairo_fill (C);
			break;
		}
		case BONUS_TYPE_HALF:
		{
			x_m /= (gdouble) 16;
			y_m /= (gdouble) 16;
			cairo_move_to (C, x + (x_m * 10.253906), y + (y_m * 1.3125));
			cairo_curve_to (C, x + (x_m * 9.472656), y + (y_m * 4.730469), x + (x_m * 9.445313), y + (y_m * 8.015625), x + (x_m * 11.625), y + (y_m * 10.683594));
			cairo_set_source_rgba (C, 0.305882, 0.603922, 0.0235294, (gdouble) 1);
			cairo_fill (C);
			cairo_move_to (C, x + (x_m * 10.296875), y + (y_m * 1.152344));
			cairo_curve_to (C, x + (x_m * 9.046875), y + (y_m * 7.132813), x + (x_m * 6.023438), y + (y_m * 7.765625), x + (x_m * 3.84375), y + (y_m * 10.429688));
			cairo_set_source_rgba (C, 0.305882, 0.603922, 0.0235294, (gdouble) 1);
			cairo_fill (C);
			cairo_move_to (C, x + (x_m * 7), y + (y_m * 10));
			cairo_curve_to (C, x + (x_m * 7), y + (y_m * 11.65625), x + (x_m * 5.65625), y + (y_m * 13), x + (x_m * 4), y + (y_m * 13));
			cairo_curve_to (C, x + (x_m * 2.34375), y + (y_m * 13), x + (x_m * 1), y + (y_m * 11.65625), x + (x_m * 1), y + (y_m * 10));
			cairo_curve_to (C, x + (x_m * 1), y + (y_m * 8.34375), x + (x_m * 2.34375), y + (y_m * 7), x + (x_m * 4), y + (y_m * 7));
			cairo_curve_to (C, x + (x_m * 5.65625), y + (y_m * 7), x + (x_m * 7), y + (y_m * 8.34375), x + (x_m * 7), y + (y_m * 10));
			cairo_set_source_rgba (C, 0.8, (gdouble) 0, (gdouble) 0, (gdouble) 1);
			cairo_fill (C);
			cairo_move_to (C, x + (x_m * 15), y + (y_m * 12));
			cairo_curve_to (C, x + (x_m * 15), y + (y_m * 13.65625), x + (x_m * 13.65625), y + (y_m * 15), x + (x_m * 12), y + (y_m * 15));
			cairo_curve_to (C, x + (x_m * 10.34375), y + (y_m * 15), x + (x_m * 9), y + (y_m * 13.65625), x + (x_m * 9), y + (y_m * 12));
			cairo_curve_to (C, x + (x_m * 9), y + (y_m * 10.34375), x + (x_m * 10.34375), y + (y_m * 9), x + (x_m * 12), y + (y_m * 9));
			cairo_curve_to (C, x + (x_m * 13.65625), y + (y_m * 9), x + (x_m * 15), y + (y_m * 10.34375), x + (x_m * 15), y + (y_m * 12));
			cairo_set_source_rgba (C, 0.8, (gdouble) 0, (gdouble) 0, (gdouble) 1);
			cairo_fill (C);
			break;
		}
		case BONUS_TYPE_DOUBLE:
		{
			x_m /= (gdouble) 18;
			y_m /= (gdouble) 18;
			cairo_move_to (C, x + (x_m * 0.695313), y + (y_m * 8.425781));
			cairo_curve_to (C, x + (x_m * 8.914063), y + (y_m * 11.246094), x + (x_m * 13.257813), y + (y_m * 5.894531), x + (x_m * 13.847656), y + (y_m * 4.394531));
			cairo_curve_to (C, x + (x_m * 14.285156), y + (y_m * 3.351563), x + (x_m * 14.308594), y + (y_m * 3.082031), x + (x_m * 14.402344), y + (y_m * 2.535156));
			cairo_curve_to (C, x + (x_m * 14.941406), y + (y_m * 2.433594), x + (x_m * 15.613281), y + (y_m * 2.71875), x + (x_m * 16), y + (y_m * 3.0625));
			cairo_curve_to (C, x + (x_m * 15.566406), y + (y_m * 3.535156), x + (x_m * 15.261719), y + (y_m * 4.246094), x + (x_m * 15.167969), y + (y_m * 4.984375));
			cairo_curve_to (C, x + (x_m * 15.675781), y + (y_m * 11.316406), x + (x_m * 7.71875), y + (y_m * 17.683594), x + (x_m * 0), y + (y_m * 9.972656));
			cairo_curve_to (C, x + (x_m * 0.03125), y + (y_m * 9.433594), x + (x_m * 0.210938), y + (y_m * 8.84375), x + (x_m * 0.695313), y + (y_m * 8.425781));
			cairo_set_source_rgba (C, 0.988235, 0.913725, 0.309804, (gdouble) 1);
			cairo_fill (C);
			break;
		}
		case BONUS_TYPE_LIFE:
		{
			x_m /= (gdouble) 16;
			y_m /= (gdouble) 16;
			cairo_move_to (C, x + (x_m * 4.753906), y + (y_m * 1.828125));
			cairo_curve_to (C, x + (x_m * 2.652344), y + (y_m * 1.851563), x + (x_m * 1.019531), y + (y_m * 3.648438), x + (x_m * 1), y + (y_m * 5.8125));
			cairo_curve_to (C, x + (x_m * 0.972656), y + (y_m * 8.890625), x + (x_m * 2.808594), y + (y_m * 9.882813), x + (x_m * 8.015625), y + (y_m * 14.171875));
			cairo_curve_to (C, x + (x_m * 12.992188), y + (y_m * 9.558594), x + (x_m * 14.976563), y + (y_m * 8.316406), x + (x_m * 15), y + (y_m * 5.722656));
			cairo_curve_to (C, x + (x_m * 15.027344), y + (y_m * 2.886719), x + (x_m * 10.90625), y + (y_m * 0.128906), x + (x_m * 7.910156), y + (y_m * 3.121094));
			cairo_curve_to (C, x + (x_m * 6.835938), y + (y_m * 2.199219), x + (x_m * 5.742188), y + (y_m * 1.816406), x + (x_m * 4.753906), y + (y_m * 1.828125));
			cairo_set_source_rgba (C, (gdouble) 1, (gdouble) 0, (gdouble) 0, (gdouble) 1);
			cairo_fill (C);
			break;
		}
		case BONUS_TYPE_REVERSE:
		{
			x_m /= (gdouble) 16;
			y_m /= (gdouble) 16;
			cairo_move_to (C, x + (x_m * 4), y + (y_m * 2));
			cairo_line_to (C, x + (x_m * 12), y + (y_m * 2));
			cairo_line_to (C, x + (x_m * 15), y + (y_m * 6));
			cairo_line_to (C, x + (x_m * 8), y + (y_m * 15));
			cairo_line_to (C, x + (x_m * 1), y + (y_m * 6));
			cairo_set_source_rgba (C, 0.717647, 0.807843, 0.901961, (gdouble) 1);
			cairo_fill (C);
			cairo_move_to (C, x + (x_m * 11), y + (y_m * 6));
			cairo_line_to (C, x + (x_m * 8), y + (y_m * 15));
			cairo_line_to (C, x + (x_m * 5), y + (y_m * 6));
			cairo_set_source_rgba (C, 0.447059, 0.623529, 0.811765, (gdouble) 1);
			cairo_fill (C);
			cairo_move_to (C, x + (x_m * 4), y + (y_m * 2));
			cairo_line_to (C, x + (x_m * 8), y + (y_m * 2));
			cairo_line_to (C, x + (x_m * 5), y + (y_m * 6));
			cairo_line_to (C, x + (x_m * 1), y + (y_m * 6));
			cairo_set_source_rgba (C, 0.447059, 0.623529, 0.811765, (gdouble) 1);
			cairo_fill (C);
			cairo_move_to (C, x + (x_m * 12), y + (y_m * 2));
			cairo_line_to (C, x + (x_m * 8), y + (y_m * 2));
			cairo_line_to (C, x + (x_m * 11), y + (y_m * 6));
			cairo_line_to (C, x + (x_m * 15), y + (y_m * 6));
			cairo_set_source_rgba (C, 0.447059, 0.623529, 0.811765, (gdouble) 1);
			cairo_fill (C);
			break;
		}
		case BONUS_TYPE_WARP:
		{
			gdouble _tmp0_ = 0.0;
			gdouble _tmp2_ = 0.0;
			gdouble _tmp4_ = 0.0;
			x_m /= (gdouble) 16;
			y_m /= (gdouble) 16;
			cairo_move_to (C, x + (x_m * 8.664063), y + (y_m * 0.621094));
			cairo_curve_to (C, x + (x_m * 6.179688), y + (y_m * 0.761719), x + (x_m * 4.265625), y + (y_m * 2.679688), x + (x_m * 4.40625), y + (y_m * 5.164063));
			cairo_line_to (C, x + (x_m * 7.433594), y + (y_m * 5.164063));
			cairo_curve_to (C, x + (x_m * 7.386719), y + (y_m * 4.3125), x + (x_m * 8.003906), y + (y_m * 3.699219), x + (x_m * 8.855469), y + (y_m * 3.652344));
			cairo_curve_to (C, x + (x_m * 9.707031), y + (y_m * 3.601563), x + (x_m * 10.417969), y + (y_m * 4.21875), x + (x_m * 10.464844), y + (y_m * 5.070313));
			cairo_line_to (C, x + (x_m * 10.464844), y + (y_m * 5.117188));
			cairo_curve_to (C, x + (x_m * 10.46875), y + (y_m * 5.316406), x + (x_m * 10.417969), y + (y_m * 5.609375), x + (x_m * 10.273438), y + (y_m * 5.78125));
			cairo_curve_to (C, x + (x_m * 9.929688), y + (y_m * 6.191406), x + (x_m * 9.542969), y + (y_m * 6.53125), x + (x_m * 9.234375), y + (y_m * 6.773438));
			cairo_curve_to (C, x + (x_m * 8.890625), y + (y_m * 7.035156), x + (x_m * 8.515625), y + (y_m * 7.351563), x + (x_m * 8.144531), y + (y_m * 7.816406));
			cairo_curve_to (C, x + (x_m * 7.773438), y + (y_m * 8.28125), x + (x_m * 7.433594), y + (y_m * 8.949219), x + (x_m * 7.433594), y + (y_m * 9.710938));
			cairo_curve_to (C, x + (x_m * 7.425781), y + (y_m * 10.507813), x + (x_m * 8.148438), y + (y_m * 11.222656), x + (x_m * 8.949219), y + (y_m * 11.222656));
			cairo_curve_to (C, x + (x_m * 9.75), y + (y_m * 11.222656), x + (x_m * 10.476563), y + (y_m * 10.507813), x + (x_m * 10.464844), y + (y_m * 9.710938));
			cairo_curve_to (C, x + (x_m * 10.464844), y + (y_m * 9.710938), x + (x_m * 10.4375), y + (y_m * 9.753906), x + (x_m * 10.511719), y + (y_m * 9.664063));
			cairo_curve_to (C, x + (x_m * 10.585938), y + (y_m * 9.566406), x + (x_m * 10.789063), y + (y_m * 9.40625), x + (x_m * 11.078125), y + (y_m * 9.1875));
			cairo_curve_to (C, x + (x_m * 12.921875), y + (y_m * 7.792969), x + (x_m * 13.492188), y + (y_m * 7.003906), x + (x_m * 13.492188), y + (y_m * 4.882813));
			cairo_curve_to (C, x + (x_m * 13.355469), y + (y_m * 2.394531), x + (x_m * 11.152344), y + (y_m * 0.484375), x + (x_m * 8.664063), y + (y_m * 0.621094));
			if ((self->priv->animate % 30) < ((guint64) 10)) {
				_tmp0_ = (self->priv->animate % 30) / 10.0;
			} else {
				gdouble _tmp1_ = 0.0;
				if ((self->priv->animate % 30) >= ((guint64) 20)) {
					_tmp1_ = (gdouble) 0;
				} else {
					_tmp1_ = (20 - (self->priv->animate % 30)) / 10.0;
				}
				_tmp0_ = _tmp1_;
			}
			if (((self->priv->animate + 10) % 30) < ((guint64) 10)) {
				_tmp2_ = ((self->priv->animate + 10) % 30) / 10.0;
			} else {
				gdouble _tmp3_ = 0.0;
				if (((self->priv->animate + 10) % 30) >= ((guint64) 20)) {
					_tmp3_ = (gdouble) 0;
				} else {
					_tmp3_ = (20 - ((self->priv->animate + 10) % 30)) / 10.0;
				}
				_tmp2_ = _tmp3_;
			}
			if (((self->priv->animate + 20) % 30) < ((guint64) 10)) {
				_tmp4_ = ((self->priv->animate + 20) % 30) / 10.0;
			} else {
				gdouble _tmp5_ = 0.0;
				if (((self->priv->animate + 20) % 30) >= ((guint64) 20)) {
					_tmp5_ = (gdouble) 0;
				} else {
					_tmp5_ = (20 - ((self->priv->animate + 20) % 30)) / 10.0;
				}
				_tmp4_ = _tmp5_;
			}
			cairo_set_source_rgba (C, _tmp0_, _tmp2_, _tmp4_, (gdouble) 1);
			cairo_fill (C);
			cairo_move_to (C, x + (x_m * 8.949219), y + (y_m * 12.738281));
			cairo_curve_to (C, x + (x_m * 8.113281), y + (y_m * 12.738281), x + (x_m * 7.433594), y + (y_m * 13.417969), x + (x_m * 7.433594), y + (y_m * 14.253906));
			cairo_curve_to (C, x + (x_m * 7.433594), y + (y_m * 15.089844), x + (x_m * 8.113281), y + (y_m * 15.769531), x + (x_m * 8.949219), y + (y_m * 15.769531));
			cairo_curve_to (C, x + (x_m * 9.785156), y + (y_m * 15.769531), x + (x_m * 10.464844), y + (y_m * 15.089844), x + (x_m * 10.464844), y + (y_m * 14.253906));
			cairo_curve_to (C, x + (x_m * 10.464844), y + (y_m * 13.417969), x + (x_m * 9.785156), y + (y_m * 12.738281), x + (x_m * 8.949219), y + (y_m * 12.738281));
			cairo_fill (C);
			break;
		}
		case 6:
		{
			x_m /= (gdouble) 16;
			y_m /= (gdouble) 16;
			cairo_move_to (C, x + (x_m * 8.902344), y + (y_m * 0.160156));
			cairo_curve_to (C, x + (x_m * 6.953125), y + (y_m * 1.15625), x + (x_m * 7.480469), y + (y_m * 3.089844), x + (x_m * 7.453125), y + (y_m * 5.019531));
			cairo_line_to (C, x + (x_m * 8.257813), y + (y_m * 4.8125));
			cairo_curve_to (C, x + (x_m * 8.144531), y + (y_m * 3.507813), x + (x_m * 9.359375), y + (y_m * 1.511719), x + (x_m * 10.742188), y + (y_m * 1.675781));
			cairo_set_source_rgba (C, 0.305882, 0.603922, 0.0235294, (gdouble) 1);
			cairo_fill (C);
			cairo_move_to (C, x + (x_m * 14), y + (y_m * 9));
			cairo_curve_to (C, x + (x_m * 14), y + (y_m * 5.6875), x + (x_m * 11.3125), y + (y_m * 3), x + (x_m * 8), y + (y_m * 3));
			cairo_curve_to (C, x + (x_m * 4.6875), y + (y_m * 3), x + (x_m * 2), y + (y_m * 5.6875), x + (x_m * 2), y + (y_m * 9));
			cairo_curve_to (C, x + (x_m * 2), y + (y_m * 12.3125), x + (x_m * 4.6875), y + (y_m * 15), x + (x_m * 8), y + (y_m * 15));
			cairo_curve_to (C, x + (x_m * 11.3125), y + (y_m * 15), x + (x_m * 14), y + (y_m * 12.3125), x + (x_m * 14), y + (y_m * 9));
			cairo_set_source_rgba (C, 0.960784, 0.47451, (gdouble) 0, (gdouble) 1);
			cairo_fill (C);
			break;
		}
		case 7:
		{
			x_m /= (gdouble) 16;
			y_m /= (gdouble) 16;
			cairo_move_to (C, x + (x_m * 4.585938), y + (y_m * 0.96875));
			cairo_curve_to (C, x + (x_m * 3.914063), y + (y_m * 3.050781), x + (x_m * 5.65625), y + (y_m * 4.042969), x + (x_m * 7), y + (y_m * 5.429688));
			cairo_line_to (C, x + (x_m * 7.421875), y + (y_m * 4.710938));
			cairo_curve_to (C, x + (x_m * 6.417969), y + (y_m * 3.871094), x + (x_m * 5.867188), y + (y_m * 1.597656), x + (x_m * 6.960938), y + (y_m * 0.738281));
			cairo_set_source_rgba (C, 0.305882, 0.603922, 0.0235294, (gdouble) 1);
			cairo_fill (C);
			cairo_move_to (C, x + (x_m * 12.933594), y + (y_m * 5.347656));
			cairo_curve_to (C, x + (x_m * 13.652344), y + (y_m * 7.882813), x + (x_m * 12.867188), y + (y_m * 8.753906), x + (x_m * 12.871094), y + (y_m * 10.476563));
			cairo_curve_to (C, x + (x_m * 12.875), y + (y_m * 12.890625), x + (x_m * 13.015625), y + (y_m * 14.386719), x + (x_m * 11.148438), y + (y_m * 15.089844));
			cairo_curve_to (C, x + (x_m * 9.941406), y + (y_m * 15.492188), x + (x_m * 8.785156), y + (y_m * 15.382813), x + (x_m * 6.539063), y + (y_m * 12.617188));
			cairo_curve_to (C, x + (x_m * 5.886719), y + (y_m * 11.765625), x + (x_m * 4.117188), y + (y_m * 11.683594), x + (x_m * 3.226563), y + (y_m * 10.214844));
			cairo_curve_to (C, x + (x_m * 2.117188), y + (y_m * 8.375), x + (x_m * 2.902344), y + (y_m * 5.152344), x + (x_m * 6.707031), y + (y_m * 4.464844));
			cairo_curve_to (C, x + (x_m * 8.609375), y + (y_m * 2.308594), x + (x_m * 11.933594), y + (y_m * 3.136719), x + (x_m * 12.933594), y + (y_m * 5.347656));
			cairo_set_source_rgba (C, 0.937255, 0.160784, 0.160784, (gdouble) 1);
			cairo_fill (C);
			break;
		}
		default:
		{
			break;
		}
	}
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static void
nibbles_view_draw_text_target_width (NibblesView* self,
                                     cairo_t* C,
                                     gint x,
                                     gint y,
                                     const gchar* text,
                                     gint target_width,
                                     gint color)
{
	gint target_font_size = 0;
	guint target_width_diff = 0U;
	PangoRectangle a = {0};
	PangoRectangle _tmp0_ = {0};
	PangoRectangle _tmp20_;
	PangoRectangle _tmp21_;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp22_;
	PangoFontDescription* font = NULL;
	PangoLayout* _tmp23_;
	PangoFontDescription* _tmp24_;
	PangoFontDescription* _tmp29_;
	PangoLayout* _tmp30_;
	PangoFontDescription* _tmp31_;
	PangoLayout* _tmp32_;
	PangoLayout* _tmp33_;
	PangoLayout* _tmp34_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	g_return_if_fail (text != NULL);
	target_font_size = 1;
	target_width_diff = G_MAXUINT;
	_tmp0_.x = 0;
	_tmp0_.y = 0;
	_tmp0_.width = 0;
	_tmp0_.height = 0;
	a = _tmp0_;
	{
		gint font_size = 0;
		font_size = 1;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				PangoLayout* layout = NULL;
				PangoLayout* _tmp3_;
				PangoFontDescription* font = NULL;
				PangoLayout* _tmp4_;
				PangoFontDescription* _tmp5_;
				PangoFontDescription* _tmp10_;
				PangoLayout* _tmp11_;
				PangoFontDescription* _tmp12_;
				PangoLayout* _tmp13_;
				PangoLayout* _tmp14_;
				PangoRectangle b = {0};
				PangoLayout* _tmp15_;
				PangoRectangle _tmp16_ = {0};
				PangoRectangle _tmp17_ = {0};
				guint width_diff = 0U;
				PangoRectangle _tmp18_;
				gboolean _tmp19_ = FALSE;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = font_size;
					font_size = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(font_size < 200)) {
					break;
				}
				_tmp3_ = pango_cairo_create_layout (C);
				layout = _tmp3_;
				_tmp4_ = layout;
				_tmp5_ = pango_layout_get_font_description (_tmp4_);
				if (NULL == _tmp5_) {
					PangoFontDescription* _tmp6_;
					_tmp6_ = pango_font_description_from_string ("Sans Bold 1pt");
					__vala_PangoFontDescription_free0 (font);
					font = _tmp6_;
				} else {
					PangoLayout* _tmp7_;
					PangoFontDescription* _tmp8_;
					PangoFontDescription* _tmp9_;
					_tmp7_ = layout;
					_tmp8_ = pango_layout_get_font_description (_tmp7_);
					_tmp9_ = pango_font_description_copy (_tmp8_);
					__vala_PangoFontDescription_free0 (font);
					font = _tmp9_;
				}
				_tmp10_ = font;
				pango_font_description_set_size (_tmp10_, PANGO_SCALE * font_size);
				_tmp11_ = layout;
				_tmp12_ = font;
				pango_layout_set_font_description (_tmp11_, _tmp12_);
				_tmp13_ = layout;
				pango_layout_set_text (_tmp13_, text, -1);
				_tmp14_ = layout;
				pango_cairo_update_layout (C, _tmp14_);
				_tmp15_ = layout;
				pango_layout_get_extents (_tmp15_, &_tmp16_, &_tmp17_);
				a = _tmp16_;
				b = _tmp17_;
				_tmp18_ = a;
				width_diff = (guint) abs (target_width - (((gint) _tmp18_.width) / PANGO_SCALE));
				if (width_diff > target_width_diff) {
					_tmp19_ = (width_diff - target_width_diff) > ((guint) 2);
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					__vala_PangoFontDescription_free0 (font);
					_g_object_unref0 (layout);
					break;
				} else {
					if (width_diff < target_width_diff) {
						target_width_diff = width_diff;
						target_font_size = font_size;
					}
				}
				__vala_PangoFontDescription_free0 (font);
				_g_object_unref0 (layout);
			}
		}
	}
	_tmp20_ = a;
	_tmp21_ = a;
	cairo_move_to (C, (gdouble) (x - (_tmp20_.x / PANGO_SCALE)), (gdouble) (y - (_tmp21_.y / PANGO_SCALE)));
	_tmp22_ = pango_cairo_create_layout (C);
	layout = _tmp22_;
	_tmp23_ = layout;
	_tmp24_ = pango_layout_get_font_description (_tmp23_);
	if (NULL == _tmp24_) {
		PangoFontDescription* _tmp25_;
		_tmp25_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (font);
		font = _tmp25_;
	} else {
		PangoLayout* _tmp26_;
		PangoFontDescription* _tmp27_;
		PangoFontDescription* _tmp28_;
		_tmp26_ = layout;
		_tmp27_ = pango_layout_get_font_description (_tmp26_);
		_tmp28_ = pango_font_description_copy (_tmp27_);
		__vala_PangoFontDescription_free0 (font);
		font = _tmp28_;
	}
	_tmp29_ = font;
	pango_font_description_set_size (_tmp29_, PANGO_SCALE * target_font_size);
	_tmp30_ = layout;
	_tmp31_ = font;
	pango_layout_set_font_description (_tmp30_, _tmp31_);
	_tmp32_ = layout;
	pango_layout_set_text (_tmp32_, text, -1);
	_tmp33_ = layout;
	pango_cairo_update_layout (C, _tmp33_);
	_tmp34_ = layout;
	pango_cairo_show_layout (C, _tmp34_);
	__vala_PangoFontDescription_free0 (font);
	_g_object_unref0 (layout);
}

static void
nibbles_view_draw_text_font_size (NibblesView* self,
                                  cairo_t* C,
                                  gint x,
                                  gint y,
                                  const gchar* text,
                                  gint font_size)
{
	gint x_offset = 0;
	gint y_offset = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp2_;
	PangoFontDescription* font = NULL;
	PangoLayout* _tmp3_;
	PangoFontDescription* _tmp4_;
	PangoFontDescription* _tmp9_;
	PangoLayout* _tmp10_;
	PangoFontDescription* _tmp11_;
	PangoLayout* _tmp12_;
	PangoLayout* _tmp13_;
	PangoLayout* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	g_return_if_fail (text != NULL);
	nibbles_view_get_text_offsets (self, C, text, font_size, &_tmp0_, &_tmp1_);
	x_offset = _tmp0_;
	y_offset = _tmp1_;
	cairo_move_to (C, (gdouble) (x - x_offset), (gdouble) (y - y_offset));
	cairo_set_source_rgb (C, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp2_ = pango_cairo_create_layout (C);
	layout = _tmp2_;
	_tmp3_ = layout;
	_tmp4_ = pango_layout_get_font_description (_tmp3_);
	if (NULL == _tmp4_) {
		PangoFontDescription* _tmp5_;
		_tmp5_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (font);
		font = _tmp5_;
	} else {
		PangoLayout* _tmp6_;
		PangoFontDescription* _tmp7_;
		PangoFontDescription* _tmp8_;
		_tmp6_ = layout;
		_tmp7_ = pango_layout_get_font_description (_tmp6_);
		_tmp8_ = pango_font_description_copy (_tmp7_);
		__vala_PangoFontDescription_free0 (font);
		font = _tmp8_;
	}
	_tmp9_ = font;
	pango_font_description_set_size (_tmp9_, PANGO_SCALE * font_size);
	_tmp10_ = layout;
	_tmp11_ = font;
	pango_layout_set_font_description (_tmp10_, _tmp11_);
	_tmp12_ = layout;
	pango_layout_set_text (_tmp12_, text, -1);
	_tmp13_ = layout;
	pango_cairo_update_layout (C, _tmp13_);
	_tmp14_ = layout;
	pango_cairo_show_layout (C, _tmp14_);
	__vala_PangoFontDescription_free0 (font);
	_g_object_unref0 (layout);
}

static void
nibbles_view_get_text_offsets (NibblesView* self,
                               cairo_t* C,
                               const gchar* text,
                               gint font_size,
                               gint* x_offset,
                               gint* y_offset)
{
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	PangoFontDescription* font = NULL;
	PangoLayout* _tmp1_;
	PangoFontDescription* _tmp2_;
	PangoFontDescription* _tmp7_;
	PangoLayout* _tmp8_;
	PangoFontDescription* _tmp9_;
	PangoLayout* _tmp10_;
	PangoLayout* _tmp11_;
	PangoRectangle a = {0};
	PangoRectangle b = {0};
	PangoLayout* _tmp12_;
	PangoRectangle _tmp13_ = {0};
	PangoRectangle _tmp14_ = {0};
	PangoRectangle _tmp15_;
	PangoRectangle _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = pango_cairo_create_layout (C);
	layout = _tmp0_;
	_tmp1_ = layout;
	_tmp2_ = pango_layout_get_font_description (_tmp1_);
	if (NULL == _tmp2_) {
		PangoFontDescription* _tmp3_;
		_tmp3_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (font);
		font = _tmp3_;
	} else {
		PangoLayout* _tmp4_;
		PangoFontDescription* _tmp5_;
		PangoFontDescription* _tmp6_;
		_tmp4_ = layout;
		_tmp5_ = pango_layout_get_font_description (_tmp4_);
		_tmp6_ = pango_font_description_copy (_tmp5_);
		__vala_PangoFontDescription_free0 (font);
		font = _tmp6_;
	}
	_tmp7_ = font;
	pango_font_description_set_size (_tmp7_, PANGO_SCALE * font_size);
	_tmp8_ = layout;
	_tmp9_ = font;
	pango_layout_set_font_description (_tmp8_, _tmp9_);
	_tmp10_ = layout;
	pango_layout_set_text (_tmp10_, text, -1);
	_tmp11_ = layout;
	pango_cairo_update_layout (C, _tmp11_);
	_tmp12_ = layout;
	pango_layout_get_extents (_tmp12_, &_tmp13_, &_tmp14_);
	a = _tmp13_;
	b = _tmp14_;
	_tmp15_ = a;
	_vala_x_offset = _tmp15_.x / PANGO_SCALE;
	_tmp16_ = a;
	_vala_y_offset = _tmp16_.y / PANGO_SCALE;
	__vala_PangoFontDescription_free0 (font);
	_g_object_unref0 (layout);
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
}

static void
nibbles_view_set_color (NibblesView* self,
                        cairo_t* C,
                        gint color,
                        gboolean bright)
{
	gdouble r = 0.0;
	gdouble g = 0.0;
	gdouble b = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	get_worm_rgb (color, bright, &_tmp0_, &_tmp1_, &_tmp2_);
	r = _tmp0_;
	g = _tmp1_;
	b = _tmp2_;
	cairo_set_source_rgba (C, r, g, b, (gdouble) 1);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static void
_vala_array_add4 (gdouble* * array,
                  gint* length,
                  gint* size,
                  gdouble value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gdouble, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add5 (gdouble* * array,
                  gint* length,
                  gint* size,
                  gdouble value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gdouble, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
nibbles_view_draw_dialogue (NibblesView* self,
                            cairo_t* C,
                            gdouble width,
                            gdouble height,
                            const gchar* text,
                            gdouble* b0_x,
                            gdouble* b0_y,
                            gdouble* b0_width,
                            gdouble* b0_height,
                            gdouble* b1_x,
                            gdouble* b1_y,
                            gdouble* b1_width,
                            gdouble* b1_height,
                            gboolean draw_buttons)
{
	gdouble _vala_b0_x = 0.0;
	gdouble _vala_b0_y = 0.0;
	gdouble _vala_b0_width = 0.0;
	gdouble _vala_b0_height = 0.0;
	gdouble _vala_b1_x = 0.0;
	gdouble _vala_b1_y = 0.0;
	gdouble _vala_b1_width = 0.0;
	gdouble _vala_b1_height = 0.0;
	static const gdouble PI2 = 1.570796326794896619231321691639751442;
	static const gdouble border_width = (gdouble) 3;
	gint lines = 0;
	gint font_size = 0;
	gdouble* line_width = NULL;
	gdouble* _tmp27_;
	gint line_width_length1;
	gint _line_width_size_;
	gdouble* line_height = NULL;
	gdouble* _tmp28_;
	gint line_height_length1;
	gint _line_height_size_;
	gdouble text_width = 0.0;
	gdouble text_height = 0.0;
	gdouble button_height = 0.0;
	gdouble minimum_dimension = 0.0;
	gdouble background_width = 0.0;
	gdouble background_height = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble _tmp63_ = 0.0;
	gdouble arc_radius = 0.0;
	gint line = 0;
	gdouble y_line = 0.0;
	gdouble _tmp92_ = 0.0;
	gdouble button_width = 0.0;
	gdouble _tmp93_ = 0.0;
	gdouble b0_radius = 0.0;
	gdouble b1_radius = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	g_return_if_fail (text != NULL);
	lines = 0;
	font_size = G_MAXINT;
	{
		gchar* s = NULL;
		gchar* _tmp0_;
		_tmp0_ = g_strdup (text);
		s = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				guint new_line = 0U;
				gint _tmp12_;
				const gchar* _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				if (!_tmp1_) {
				}
				_tmp1_ = FALSE;
				_tmp2_ = s;
				_tmp3_ = strlen (_tmp2_);
				_tmp4_ = _tmp3_;
				if (!(_tmp4_ > 0)) {
					break;
				}
				{
					gboolean _tmp5_ = FALSE;
					new_line = (guint) 0;
					_tmp5_ = TRUE;
					while (TRUE) {
						gboolean _tmp7_ = FALSE;
						const gchar* _tmp8_;
						gint _tmp9_;
						gint _tmp10_;
						if (!_tmp5_) {
							guint _tmp6_;
							new_line = new_line + 1;
							_tmp6_ = new_line;
						}
						_tmp5_ = FALSE;
						_tmp8_ = s;
						_tmp9_ = strlen (_tmp8_);
						_tmp10_ = _tmp9_;
						if (new_line < ((guint) _tmp10_)) {
							const gchar* _tmp11_;
							_tmp11_ = s;
							_tmp7_ = string_get (_tmp11_, (glong) new_line) != '\n';
						} else {
							_tmp7_ = FALSE;
						}
						if (!_tmp7_) {
							break;
						}
					}
				}
				lines = lines + 1;
				_tmp12_ = lines;
				if (new_line > ((guint) 0)) {
					gchar* _text = NULL;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gdouble _text_width = 0.0;
					gdouble _text_height = 0.0;
					gint size = 0;
					const gchar* _tmp15_;
					gdouble _tmp16_ = 0.0;
					gdouble _tmp17_ = 0.0;
					gint _tmp18_;
					_tmp13_ = s;
					_tmp14_ = string_slice (_tmp13_, (glong) 0, (glong) new_line);
					_text = _tmp14_;
					_tmp15_ = _text;
					_tmp18_ = nibbles_view_calculate_font_size (self, C, _tmp15_, (gint) (width * 0.8), &_tmp16_, &_tmp17_);
					_text_width = _tmp16_;
					_text_height = _tmp17_;
					size = _tmp18_;
					if (size < font_size) {
						font_size = size;
					}
					_g_free0 (_text);
				}
				_tmp19_ = s;
				_tmp20_ = strlen (_tmp19_);
				_tmp21_ = _tmp20_;
				if (((guint) _tmp21_) > (new_line + 1)) {
					const gchar* _tmp22_;
					const gchar* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					gchar* _tmp26_;
					_tmp22_ = s;
					_tmp23_ = s;
					_tmp24_ = strlen (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = string_slice (_tmp22_, (glong) (new_line + 1), (glong) _tmp25_);
					_g_free0 (s);
					s = _tmp26_;
				} else {
					break;
				}
			}
		}
		_g_free0 (s);
	}
	_tmp27_ = g_new0 (gdouble, 0);
	line_width = _tmp27_;
	line_width_length1 = 0;
	_line_width_size_ = line_width_length1;
	_tmp28_ = g_new0 (gdouble, 0);
	line_height = _tmp28_;
	line_height_length1 = 0;
	_line_height_size_ = line_height_length1;
	text_width = (gdouble) 0;
	text_height = (gdouble) 0;
	{
		gchar* s = NULL;
		gchar* _tmp29_;
		_tmp29_ = g_strdup (text);
		s = _tmp29_;
		{
			gboolean _tmp30_ = FALSE;
			_tmp30_ = TRUE;
			while (TRUE) {
				const gchar* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				guint new_line = 0U;
				const gchar* _tmp55_;
				gint _tmp56_;
				gint _tmp57_;
				if (!_tmp30_) {
				}
				_tmp30_ = FALSE;
				_tmp31_ = s;
				_tmp32_ = strlen (_tmp31_);
				_tmp33_ = _tmp32_;
				if (!(_tmp33_ > 0)) {
					break;
				}
				{
					gboolean _tmp34_ = FALSE;
					new_line = (guint) 0;
					_tmp34_ = TRUE;
					while (TRUE) {
						gboolean _tmp36_ = FALSE;
						const gchar* _tmp37_;
						gint _tmp38_;
						gint _tmp39_;
						if (!_tmp34_) {
							guint _tmp35_;
							new_line = new_line + 1;
							_tmp35_ = new_line;
						}
						_tmp34_ = FALSE;
						_tmp37_ = s;
						_tmp38_ = strlen (_tmp37_);
						_tmp39_ = _tmp38_;
						if (new_line < ((guint) _tmp39_)) {
							const gchar* _tmp40_;
							_tmp40_ = s;
							_tmp36_ = string_get (_tmp40_, (glong) new_line) != '\n';
						} else {
							_tmp36_ = FALSE;
						}
						if (!_tmp36_) {
							break;
						}
					}
				}
				if (new_line > ((guint) 0)) {
					gchar* _text = NULL;
					const gchar* _tmp41_;
					gchar* _tmp42_;
					cairo_t* c = NULL;
					cairo_surface_t* _tmp43_;
					cairo_t* _tmp44_;
					cairo_t* _tmp45_;
					cairo_t* _tmp46_;
					cairo_text_extents_t extents = {0};
					cairo_t* _tmp47_;
					const gchar* _tmp48_;
					cairo_text_extents_t _tmp49_ = {0};
					cairo_text_extents_t _tmp50_;
					cairo_text_extents_t _tmp51_;
					cairo_text_extents_t _tmp52_;
					cairo_text_extents_t _tmp54_;
					_tmp41_ = s;
					_tmp42_ = string_slice (_tmp41_, (glong) 0, (glong) new_line);
					_text = _tmp42_;
					_tmp43_ = cairo_get_target (C);
					_tmp44_ = cairo_create (_tmp43_);
					c = _tmp44_;
					_tmp45_ = c;
					cairo_move_to (_tmp45_, (gdouble) 0, (gdouble) 0);
					_tmp46_ = c;
					cairo_set_font_size (_tmp46_, (gdouble) font_size);
					_tmp47_ = c;
					_tmp48_ = _text;
					cairo_text_extents (_tmp47_, _tmp48_, &_tmp49_);
					extents = _tmp49_;
					_tmp50_ = extents;
					_vala_array_add4 (&line_width, &line_width_length1, &_line_width_size_, _tmp50_.width);
					_tmp51_ = extents;
					_vala_array_add5 (&line_height, &line_height_length1, &_line_height_size_, _tmp51_.height + 5);
					_tmp52_ = extents;
					if (_tmp52_.width > text_width) {
						cairo_text_extents_t _tmp53_;
						_tmp53_ = extents;
						text_width = _tmp53_.width;
					}
					_tmp54_ = extents;
					text_height += _tmp54_.height + 5;
					_cairo_destroy0 (c);
					_g_free0 (_text);
				}
				_tmp55_ = s;
				_tmp56_ = strlen (_tmp55_);
				_tmp57_ = _tmp56_;
				if (((guint) _tmp57_) > (new_line + 1)) {
					const gchar* _tmp58_;
					const gchar* _tmp59_;
					gint _tmp60_;
					gint _tmp61_;
					gchar* _tmp62_;
					_tmp58_ = s;
					_tmp59_ = s;
					_tmp60_ = strlen (_tmp59_);
					_tmp61_ = _tmp60_;
					_tmp62_ = string_slice (_tmp58_, (glong) (new_line + 1), (glong) _tmp61_);
					_g_free0 (s);
					s = _tmp62_;
				} else {
					break;
				}
			}
		}
		_g_free0 (s);
	}
	button_height = (text_height / lines) * 1.5;
	minimum_dimension = (gdouble) 10;
	background_width = text_width + (minimum_dimension * 2);
	background_height = (text_height + (minimum_dimension * 5)) + button_height;
	x = (width - background_width) / 2;
	y = (gdouble) 0;
	if (background_width < background_height) {
		_tmp63_ = background_width / 3;
	} else {
		_tmp63_ = background_height / 3;
	}
	arc_radius = _tmp63_;
	cairo_move_to (C, x + background_width, y);
	cairo_arc (C, (x + background_width) - arc_radius, y + arc_radius, arc_radius, -PI2, (gdouble) 0);
	cairo_arc (C, (x + background_width) - arc_radius, (y + background_height) - arc_radius, arc_radius, (gdouble) 0, PI2);
	cairo_arc (C, x + arc_radius, (y + background_height) - arc_radius, arc_radius, PI2, PI2 * 2);
	cairo_arc (C, x + arc_radius, y + arc_radius, arc_radius, PI2 * 2, -PI2);
	cairo_set_source_rgba (C, 0.5, 0.5, 0.5, (gdouble) 1);
	cairo_fill (C);
	cairo_arc (C, (x + background_width) - arc_radius, y + arc_radius, arc_radius - border_width, -PI2, (gdouble) 0);
	cairo_arc (C, (x + background_width) - arc_radius, (y + background_height) - arc_radius, arc_radius - border_width, (gdouble) 0, PI2);
	cairo_arc (C, x + arc_radius, (y + background_height) - arc_radius, arc_radius - border_width, PI2, PI2 * 2);
	cairo_arc (C, x + arc_radius, y + arc_radius, arc_radius - border_width, PI2 * 2, -PI2);
	cairo_set_source_rgba (C, 0.125, 0.125, 0.125, (gdouble) 1);
	cairo_fill (C);
	line = 0;
	y_line = (gdouble) 0;
	{
		gchar* s = NULL;
		gchar* _tmp64_;
		_tmp64_ = g_strdup (text);
		s = _tmp64_;
		{
			gboolean _tmp65_ = FALSE;
			_tmp65_ = TRUE;
			while (TRUE) {
				const gchar* _tmp67_;
				gint _tmp68_;
				gint _tmp69_;
				guint new_line = 0U;
				const gchar* _tmp84_;
				gint _tmp85_;
				gint _tmp86_;
				if (!_tmp65_) {
					gint _tmp66_;
					line = line + 1;
					_tmp66_ = line;
				}
				_tmp65_ = FALSE;
				_tmp67_ = s;
				_tmp68_ = strlen (_tmp67_);
				_tmp69_ = _tmp68_;
				if (!(_tmp69_ > 0)) {
					break;
				}
				{
					gboolean _tmp70_ = FALSE;
					new_line = (guint) 0;
					_tmp70_ = TRUE;
					while (TRUE) {
						gboolean _tmp72_ = FALSE;
						const gchar* _tmp73_;
						gint _tmp74_;
						gint _tmp75_;
						if (!_tmp70_) {
							guint _tmp71_;
							new_line = new_line + 1;
							_tmp71_ = new_line;
						}
						_tmp70_ = FALSE;
						_tmp73_ = s;
						_tmp74_ = strlen (_tmp73_);
						_tmp75_ = _tmp74_;
						if (new_line < ((guint) _tmp75_)) {
							const gchar* _tmp76_;
							_tmp76_ = s;
							_tmp72_ = string_get (_tmp76_, (glong) new_line) != '\n';
						} else {
							_tmp72_ = FALSE;
						}
						if (!_tmp72_) {
							break;
						}
					}
				}
				if (new_line > ((guint) 0)) {
					gdouble* _tmp77_;
					gint _tmp77__length1;
					gdouble _tmp78_;
					gchar* _text = NULL;
					const gchar* _tmp79_;
					gchar* _tmp80_;
					gdouble* _tmp81_;
					gint _tmp81__length1;
					gdouble _tmp82_;
					const gchar* _tmp83_;
					_tmp77_ = line_height;
					_tmp77__length1 = line_height_length1;
					_tmp78_ = _tmp77_[line];
					y_line += _tmp78_;
					_tmp79_ = s;
					_tmp80_ = string_slice (_tmp79_, (glong) 0, (glong) new_line);
					_text = _tmp80_;
					_tmp81_ = line_width;
					_tmp81__length1 = line_width_length1;
					_tmp82_ = _tmp81_[line];
					_tmp83_ = _text;
					nibbles_view_draw_dialogue_text (self, C, x + ((background_width - _tmp82_) / 2), (y + minimum_dimension) + y_line, _tmp83_, font_size);
					_g_free0 (_text);
				}
				_tmp84_ = s;
				_tmp85_ = strlen (_tmp84_);
				_tmp86_ = _tmp85_;
				if (((guint) _tmp86_) > (new_line + 1)) {
					const gchar* _tmp87_;
					const gchar* _tmp88_;
					gint _tmp89_;
					gint _tmp90_;
					gchar* _tmp91_;
					_tmp87_ = s;
					_tmp88_ = s;
					_tmp89_ = strlen (_tmp88_);
					_tmp90_ = _tmp89_;
					_tmp91_ = string_slice (_tmp87_, (glong) (new_line + 1), (glong) _tmp90_);
					_g_free0 (s);
					s = _tmp91_;
				} else {
					break;
				}
			}
		}
		_g_free0 (s);
	}
	if ((background_width / 5) > ((gdouble) 100)) {
		_tmp92_ = background_width / 5;
	} else {
		_tmp92_ = (gdouble) 100;
	}
	button_width = _tmp92_;
	_vala_b0_x = x + ((background_width - (button_width * 2)) / 3);
	_vala_b0_y = ((y + background_height) - minimum_dimension) - button_height;
	if (button_width < button_height) {
		_tmp93_ = button_width / 3;
	} else {
		_tmp93_ = button_height / 3;
	}
	b0_radius = _tmp93_;
	if (draw_buttons) {
		gboolean _tmp94_ = FALSE;
		gchar* No = NULL;
		gchar* _tmp95_;
		const gchar* _tmp96_;
		gdouble _tmp97_ = 0.0;
		gdouble _tmp98_ = 0.0;
		gint _tmp99_;
		const gchar* _tmp100_;
		cairo_move_to (C, _vala_b0_x + button_width, _vala_b0_y);
		cairo_arc (C, (_vala_b0_x + button_width) - b0_radius, _vala_b0_y + b0_radius, b0_radius, -PI2, (gdouble) 0);
		cairo_arc (C, (_vala_b0_x + button_width) - b0_radius, (_vala_b0_y + button_height) - b0_radius, b0_radius, (gdouble) 0, PI2);
		cairo_arc (C, _vala_b0_x + b0_radius, (_vala_b0_y + button_height) - b0_radius, b0_radius, PI2, PI2 * 2);
		cairo_arc (C, _vala_b0_x + b0_radius, _vala_b0_y + b0_radius, b0_radius, PI2 * 2, -PI2);
		cairo_set_source_rgba (C, 0.5, 0.5, 0.5, (gdouble) 1);
		cairo_fill (C);
		cairo_arc (C, (_vala_b0_x + button_width) - b0_radius, _vala_b0_y + b0_radius, b0_radius - border_width, -PI2, (gdouble) 0);
		cairo_arc (C, (_vala_b0_x + button_width) - b0_radius, (_vala_b0_y + button_height) - b0_radius, b0_radius - border_width, (gdouble) 0, PI2);
		cairo_arc (C, _vala_b0_x + b0_radius, (_vala_b0_y + button_height) - b0_radius, b0_radius - border_width, PI2, PI2 * 2);
		cairo_arc (C, _vala_b0_x + b0_radius, _vala_b0_y + b0_radius, b0_radius - border_width, PI2 * 2, -PI2);
		if (self->priv->mouse_pressed) {
			_tmp94_ = self->priv->mouse_button == ((guint) 0);
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			cairo_set_source_rgba (C, 0.063, 0.243, 0.459, (gdouble) 1);
		} else {
			cairo_set_source_rgba (C, 0.082, 0.322, 0.612, (gdouble) 1);
		}
		cairo_fill (C);
		_tmp95_ = g_strdup (_ ("No"));
		No = _tmp95_;
		_tmp96_ = No;
		_tmp99_ = nibbles_view_calculate_font_size_from_max (self, C, _tmp96_, (gint) (button_width - (border_width * 2)), (gint) (button_height / 3), &_tmp97_, &_tmp98_);
		_vala_b0_width = _tmp97_;
		_vala_b0_height = _tmp98_;
		font_size = _tmp99_;
		_tmp100_ = No;
		nibbles_view_draw_dialogue_text (self, C, _vala_b0_x + ((button_width - _vala_b0_width) / 2), (_vala_b0_y + _vala_b0_height) + (button_height / 3), _tmp100_, font_size);
		_g_free0 (No);
	}
	_vala_b1_x = (x + (((background_width - (button_width * 2)) / 3) * 2)) + button_width;
	_vala_b1_y = _vala_b0_y;
	b1_radius = b0_radius;
	if (draw_buttons) {
		gboolean _tmp101_ = FALSE;
		gchar* Yes = NULL;
		gchar* _tmp102_;
		const gchar* _tmp103_;
		gdouble _tmp104_ = 0.0;
		gdouble _tmp105_ = 0.0;
		gint _tmp106_;
		const gchar* _tmp107_;
		cairo_move_to (C, _vala_b1_x + button_width, _vala_b1_y);
		cairo_arc (C, (_vala_b1_x + button_width) - b1_radius, _vala_b1_y + b1_radius, b1_radius, -PI2, (gdouble) 0);
		cairo_arc (C, (_vala_b1_x + button_width) - b1_radius, (_vala_b1_y + button_height) - b1_radius, b1_radius, (gdouble) 0, PI2);
		cairo_arc (C, _vala_b1_x + b1_radius, (_vala_b1_y + button_height) - b1_radius, b1_radius, PI2, PI2 * 2);
		cairo_arc (C, _vala_b1_x + b1_radius, _vala_b1_y + b1_radius, b1_radius, PI2 * 2, -PI2);
		cairo_set_source_rgba (C, 0.5, 0.5, 0.5, (gdouble) 1);
		cairo_fill (C);
		cairo_arc (C, (_vala_b1_x + button_width) - b1_radius, _vala_b1_y + b1_radius, b1_radius - border_width, -PI2, (gdouble) 0);
		cairo_arc (C, (_vala_b1_x + button_width) - b1_radius, (_vala_b1_y + button_height) - b1_radius, b1_radius - border_width, (gdouble) 0, PI2);
		cairo_arc (C, _vala_b1_x + b1_radius, (_vala_b1_y + button_height) - b1_radius, b1_radius - border_width, PI2, PI2 * 2);
		cairo_arc (C, _vala_b1_x + b1_radius, _vala_b1_y + b1_radius, b1_radius - border_width, PI2 * 2, -PI2);
		if (self->priv->mouse_pressed) {
			_tmp101_ = self->priv->mouse_button == ((guint) 1);
		} else {
			_tmp101_ = FALSE;
		}
		if (_tmp101_) {
			cairo_set_source_rgba (C, 0.063, 0.243, 0.459, (gdouble) 1);
		} else {
			cairo_set_source_rgba (C, 0.082, 0.322, 0.612, (gdouble) 1);
		}
		cairo_fill (C);
		_tmp102_ = g_strdup (_ ("Yes"));
		Yes = _tmp102_;
		_tmp103_ = Yes;
		_tmp106_ = nibbles_view_calculate_font_size_from_max (self, C, _tmp103_, (gint) (button_width - (border_width * 2)), (gint) (button_height / 3), &_tmp104_, &_tmp105_);
		_vala_b1_width = _tmp104_;
		_vala_b1_height = _tmp105_;
		font_size = _tmp106_;
		_tmp107_ = Yes;
		nibbles_view_draw_dialogue_text (self, C, _vala_b1_x + ((button_width - _vala_b1_width) / 2), (_vala_b1_y + _vala_b1_height) + (button_height / 3), _tmp107_, font_size);
		_g_free0 (Yes);
	}
	_vala_b0_width = button_width;
	_vala_b1_width = button_width;
	_vala_b0_height = button_height;
	_vala_b1_height = button_height;
	line_height = (g_free (line_height), NULL);
	line_width = (g_free (line_width), NULL);
	if (b0_x) {
		*b0_x = _vala_b0_x;
	}
	if (b0_y) {
		*b0_y = _vala_b0_y;
	}
	if (b0_width) {
		*b0_width = _vala_b0_width;
	}
	if (b0_height) {
		*b0_height = _vala_b0_height;
	}
	if (b1_x) {
		*b1_x = _vala_b1_x;
	}
	if (b1_y) {
		*b1_y = _vala_b1_y;
	}
	if (b1_width) {
		*b1_width = _vala_b1_width;
	}
	if (b1_height) {
		*b1_height = _vala_b1_height;
	}
}

static gint
nibbles_view_calculate_font_size (NibblesView* self,
                                  cairo_t* C,
                                  const gchar* text,
                                  gint target_width,
                                  gdouble* width,
                                  gdouble* height)
{
	gdouble _vala_width = 0.0;
	gdouble _vala_height = 0.0;
	gint target_font_size = 0;
	guint target_width_diff = 0U;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (C != NULL, 0);
	g_return_val_if_fail (text != NULL, 0);
	target_font_size = 1;
	target_width_diff = G_MAXUINT;
	_vala_width = (gdouble) 0;
	_vala_height = (gdouble) 0;
	{
		gint font_size = 0;
		font_size = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				PangoLayout* layout = NULL;
				PangoLayout* _tmp1_;
				PangoFontDescription* font = NULL;
				PangoLayout* _tmp2_;
				PangoFontDescription* _tmp3_;
				PangoFontDescription* _tmp8_;
				PangoLayout* _tmp9_;
				PangoFontDescription* _tmp10_;
				PangoLayout* _tmp11_;
				PangoLayout* _tmp12_;
				PangoRectangle a = {0};
				PangoRectangle b = {0};
				PangoLayout* _tmp13_;
				PangoRectangle _tmp14_ = {0};
				PangoRectangle _tmp15_ = {0};
				PangoRectangle _tmp16_;
				PangoRectangle _tmp17_;
				guint width_diff = 0U;
				PangoRectangle _tmp18_;
				gboolean _tmp19_ = FALSE;
				if (!_tmp0_) {
				}
				_tmp0_ = FALSE;
				if (!(font_size < 200)) {
					break;
				}
				_tmp1_ = pango_cairo_create_layout (C);
				layout = _tmp1_;
				_tmp2_ = layout;
				_tmp3_ = pango_layout_get_font_description (_tmp2_);
				if (NULL == _tmp3_) {
					PangoFontDescription* _tmp4_;
					_tmp4_ = pango_font_description_from_string ("Sans Bold 1pt");
					__vala_PangoFontDescription_free0 (font);
					font = _tmp4_;
				} else {
					PangoLayout* _tmp5_;
					PangoFontDescription* _tmp6_;
					PangoFontDescription* _tmp7_;
					_tmp5_ = layout;
					_tmp6_ = pango_layout_get_font_description (_tmp5_);
					_tmp7_ = pango_font_description_copy (_tmp6_);
					__vala_PangoFontDescription_free0 (font);
					font = _tmp7_;
				}
				_tmp8_ = font;
				pango_font_description_set_size (_tmp8_, PANGO_SCALE * font_size);
				_tmp9_ = layout;
				_tmp10_ = font;
				pango_layout_set_font_description (_tmp9_, _tmp10_);
				_tmp11_ = layout;
				pango_layout_set_text (_tmp11_, text, -1);
				_tmp12_ = layout;
				pango_cairo_update_layout (C, _tmp12_);
				_tmp13_ = layout;
				pango_layout_get_extents (_tmp13_, &_tmp14_, &_tmp15_);
				a = _tmp14_;
				b = _tmp15_;
				_tmp16_ = a;
				_vala_width = (gdouble) (_tmp16_.width / PANGO_SCALE);
				_tmp17_ = a;
				_vala_height = (gdouble) (_tmp17_.height / PANGO_SCALE);
				_tmp18_ = a;
				width_diff = (guint) abs (target_width - (((gint) _tmp18_.width) / PANGO_SCALE));
				if (width_diff > target_width_diff) {
					_tmp19_ = (width_diff - target_width_diff) > ((guint) 2);
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					__vala_PangoFontDescription_free0 (font);
					_g_object_unref0 (layout);
					break;
				} else {
					if (width_diff < target_width_diff) {
						target_width_diff = width_diff;
						target_font_size = font_size;
					}
				}
				if (font_size < 20) {
					gint _tmp20_;
					_tmp20_ = font_size;
					font_size = _tmp20_ + 1;
				} else {
					if (font_size < 50) {
						font_size += 5;
					} else {
						font_size += 10;
					}
				}
				__vala_PangoFontDescription_free0 (font);
				_g_object_unref0 (layout);
			}
		}
	}
	result = target_font_size;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	return result;
}

static gint
nibbles_view_calculate_font_size_from_max (NibblesView* self,
                                           cairo_t* C,
                                           const gchar* text,
                                           gint max_width,
                                           gint max_height,
                                           gdouble* width,
                                           gdouble* height)
{
	gdouble _vala_width = 0.0;
	gdouble _vala_height = 0.0;
	gint target_font_size = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (C != NULL, 0);
	g_return_val_if_fail (text != NULL, 0);
	target_font_size = 1;
	_vala_width = (gdouble) 0;
	_vala_height = (gdouble) 0;
	{
		gint font_size = 0;
		font_size = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				PangoLayout* layout = NULL;
				PangoLayout* _tmp1_;
				PangoFontDescription* font = NULL;
				PangoLayout* _tmp2_;
				PangoFontDescription* _tmp3_;
				PangoFontDescription* _tmp8_;
				PangoLayout* _tmp9_;
				PangoFontDescription* _tmp10_;
				PangoLayout* _tmp11_;
				PangoLayout* _tmp12_;
				PangoRectangle a = {0};
				PangoRectangle b = {0};
				PangoLayout* _tmp13_;
				PangoRectangle _tmp14_ = {0};
				PangoRectangle _tmp15_ = {0};
				gboolean _tmp16_ = FALSE;
				PangoRectangle _tmp17_;
				if (!_tmp0_) {
				}
				_tmp0_ = FALSE;
				if (!(font_size < 200)) {
					break;
				}
				_tmp1_ = pango_cairo_create_layout (C);
				layout = _tmp1_;
				_tmp2_ = layout;
				_tmp3_ = pango_layout_get_font_description (_tmp2_);
				if (NULL == _tmp3_) {
					PangoFontDescription* _tmp4_;
					_tmp4_ = pango_font_description_from_string ("Sans Bold 1pt");
					__vala_PangoFontDescription_free0 (font);
					font = _tmp4_;
				} else {
					PangoLayout* _tmp5_;
					PangoFontDescription* _tmp6_;
					PangoFontDescription* _tmp7_;
					_tmp5_ = layout;
					_tmp6_ = pango_layout_get_font_description (_tmp5_);
					_tmp7_ = pango_font_description_copy (_tmp6_);
					__vala_PangoFontDescription_free0 (font);
					font = _tmp7_;
				}
				_tmp8_ = font;
				pango_font_description_set_size (_tmp8_, PANGO_SCALE * font_size);
				_tmp9_ = layout;
				_tmp10_ = font;
				pango_layout_set_font_description (_tmp9_, _tmp10_);
				_tmp11_ = layout;
				pango_layout_set_text (_tmp11_, text, -1);
				_tmp12_ = layout;
				pango_cairo_update_layout (C, _tmp12_);
				_tmp13_ = layout;
				pango_layout_get_extents (_tmp13_, &_tmp14_, &_tmp15_);
				a = _tmp14_;
				b = _tmp15_;
				_tmp17_ = a;
				if ((_tmp17_.width / PANGO_SCALE) < max_width) {
					PangoRectangle _tmp18_;
					_tmp18_ = a;
					_tmp16_ = (_tmp18_.height / PANGO_SCALE) < max_height;
				} else {
					_tmp16_ = FALSE;
				}
				if (_tmp16_) {
					PangoRectangle _tmp19_;
					PangoRectangle _tmp20_;
					_tmp19_ = a;
					_vala_width = (gdouble) (_tmp19_.width / PANGO_SCALE);
					_tmp20_ = a;
					_vala_height = (gdouble) (_tmp20_.height / PANGO_SCALE);
					target_font_size = font_size;
				} else {
					__vala_PangoFontDescription_free0 (font);
					_g_object_unref0 (layout);
					break;
				}
				if (font_size < 20) {
					gint _tmp21_;
					_tmp21_ = font_size;
					font_size = _tmp21_ + 1;
				} else {
					if (font_size < 50) {
						font_size += 5;
					} else {
						font_size += 10;
					}
				}
				__vala_PangoFontDescription_free0 (font);
				_g_object_unref0 (layout);
			}
		}
	}
	result = target_font_size;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	return result;
}

static void
nibbles_view_draw_dialogue_text (NibblesView* self,
                                 cairo_t* C,
                                 gdouble x,
                                 gdouble y,
                                 const gchar* text,
                                 gint font_size)
{
	gint x_offset = 0;
	gint y_offset = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp2_;
	PangoFontDescription* font = NULL;
	PangoLayout* _tmp3_;
	PangoFontDescription* _tmp4_;
	PangoFontDescription* _tmp9_;
	PangoLayout* _tmp10_;
	PangoFontDescription* _tmp11_;
	PangoLayout* _tmp12_;
	PangoLayout* _tmp13_;
	PangoLayout* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	g_return_if_fail (text != NULL);
	nibbles_view_get_text_offsets (self, C, text, font_size, &_tmp0_, &_tmp1_);
	x_offset = _tmp0_;
	y_offset = _tmp1_;
	cairo_move_to (C, x - x_offset, y - y_offset);
	cairo_set_source_rgb (C, 0.75, 0.75, 0.75);
	_tmp2_ = pango_cairo_create_layout (C);
	layout = _tmp2_;
	_tmp3_ = layout;
	_tmp4_ = pango_layout_get_font_description (_tmp3_);
	if (NULL == _tmp4_) {
		PangoFontDescription* _tmp5_;
		_tmp5_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (font);
		font = _tmp5_;
	} else {
		PangoLayout* _tmp6_;
		PangoFontDescription* _tmp7_;
		PangoFontDescription* _tmp8_;
		_tmp6_ = layout;
		_tmp7_ = pango_layout_get_font_description (_tmp6_);
		_tmp8_ = pango_font_description_copy (_tmp7_);
		__vala_PangoFontDescription_free0 (font);
		font = _tmp8_;
	}
	_tmp9_ = font;
	pango_font_description_set_size (_tmp9_, PANGO_SCALE * font_size);
	_tmp10_ = layout;
	_tmp11_ = font;
	pango_layout_set_font_description (_tmp10_, _tmp11_);
	_tmp12_ = layout;
	pango_layout_set_text (_tmp12_, text, -1);
	_tmp13_ = layout;
	pango_cairo_update_layout (C, _tmp13_);
	_tmp14_ = layout;
	pango_cairo_show_layout (C, _tmp14_);
	__vala_PangoFontDescription_free0 (font);
	_g_object_unref0 (layout);
}

gchar*
nibbles_view_colorval_name_untranslated (gint colorval)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = nibbles_view_color_lookup;
	_tmp0__length1 = nibbles_view_color_lookup_length1;
	_tmp0__length2 = nibbles_view_color_lookup_length2;
	_tmp1_ = _tmp0_[(colorval * _tmp0__length2) + 0];
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

GtkImage*
nibbles_view_load_image_file (const gchar* pixmap,
                              gint xsize,
                              gint ysize)
{
	gchar* filename = NULL;
	gchar* _tmp0_;
	GtkImage* image = NULL;
	GtkImage* _tmp1_;
	GtkImage* result;
	g_return_val_if_fail (pixmap != NULL, NULL);
	_tmp0_ = g_build_filename (PKGDATADIR, "pixmaps", pixmap, NULL, NULL);
	filename = _tmp0_;
	if (filename == NULL) {
		g_error ("nibbles-view.vala:1972: Nibbles couldn't find image file: %s", filename);
	}
	_tmp1_ = (GtkImage*) gtk_image_new_from_file (filename);
	g_object_ref_sink (_tmp1_);
	image = _tmp1_;
	result = image;
	_g_free0 (filename);
	return result;
}

static inline gpointer
nibbles_view_view3_d_get_instance_private (NibblesViewView3D* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesViewView3D_private_offset);
}

static void
nibbles_view_view3_d_set_view_plain (NibblesViewView3D* self,
                                     gdouble y)
{
	g_return_if_fail (self != NULL);
	self->priv->view_plain_y = y;
	self->priv->has_view_plain_been_set = TRUE;
}

static void
nibbles_view_view3_d_set_view_point (NibblesViewView3D* self,
                                     NibblesViewPoint3D* point,
                                     gdouble max_object_height)
{
	NibblesViewPoint3D _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (point != NULL);
	_tmp0_ = *point;
	self->priv->view_point = _tmp0_;
	if (self->priv->has_view_plain_been_set) {
		_tmp1_ = !self->priv->has_view_plain_z_height_been_set;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		NibblesViewPoint3D _tmp2_;
		NibblesViewPoint3D _tmp3_;
		_tmp2_ = *point;
		_tmp3_ = *point;
		self->priv->view_plain_z_height = (((_tmp2_.z - max_object_height) * self->priv->view_plain_y) / _tmp3_.y) + max_object_height;
	}
}

static void
nibbles_view_view3_d_set_scale_x (NibblesViewView3D* self,
                                  gdouble scale)
{
	g_return_if_fail (self != NULL);
	self->priv->x_scale = scale;
}

static void
nibbles_view_view3_d_set_scale_y (NibblesViewView3D* self,
                                  gdouble scale)
{
	g_return_if_fail (self != NULL);
	self->priv->y_scale = scale;
}

static void
nibbles_view_view3_d_to_view_plain (NibblesViewView3D* self,
                                    NibblesViewPoint3D* point,
                                    gdouble* x_at_plain,
                                    gdouble* z_at_plain)
{
	gdouble _vala_x_at_plain = 0.0;
	gdouble _vala_z_at_plain = 0.0;
	gdouble base_length = 0.0;
	NibblesViewPoint3D _tmp0_;
	NibblesViewPoint3D _tmp1_;
	NibblesViewPoint3D _tmp2_;
	NibblesViewPoint3D _tmp3_;
	NibblesViewPoint3D _tmp4_;
	NibblesViewPoint3D _tmp5_;
	NibblesViewPoint3D _tmp6_;
	NibblesViewPoint3D _tmp7_;
	gdouble z_length = 0.0;
	NibblesViewPoint3D _tmp8_;
	NibblesViewPoint3D _tmp9_;
	gdouble base_length_to_view_plain = 0.0;
	NibblesViewPoint3D _tmp10_;
	NibblesViewPoint3D _tmp11_;
	NibblesViewPoint3D _tmp12_;
	NibblesViewPoint3D _tmp13_;
	gdouble x_length = 0.0;
	NibblesViewPoint3D _tmp14_;
	NibblesViewPoint3D _tmp15_;
	NibblesViewPoint3D _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (point != NULL);
	_tmp0_ = self->priv->view_point;
	_tmp1_ = *point;
	_tmp2_ = self->priv->view_point;
	_tmp3_ = *point;
	_tmp4_ = self->priv->view_point;
	_tmp5_ = *point;
	_tmp6_ = self->priv->view_point;
	_tmp7_ = *point;
	base_length = sqrt (((_tmp0_.x - _tmp1_.x) * (_tmp2_.x - _tmp3_.x)) + ((_tmp4_.y - _tmp5_.y) * (_tmp6_.y - _tmp7_.y)));
	_tmp8_ = self->priv->view_point;
	_tmp9_ = *point;
	z_length = _tmp8_.z - _tmp9_.z;
	_tmp10_ = *point;
	_tmp11_ = self->priv->view_point;
	_tmp12_ = *point;
	base_length_to_view_plain = ((self->priv->view_plain_y - _tmp10_.y) / (_tmp11_.y - _tmp12_.y)) * base_length;
	_tmp13_ = *point;
	_vala_z_at_plain = (self->priv->view_plain_z_height - (_tmp13_.z + ((base_length_to_view_plain / base_length) * z_length))) * self->priv->y_scale;
	_tmp14_ = self->priv->view_point;
	_tmp15_ = *point;
	x_length = _tmp14_.x - _tmp15_.x;
	_tmp16_ = *point;
	_vala_x_at_plain = (_tmp16_.x + ((base_length_to_view_plain / base_length) * x_length)) * self->priv->x_scale;
	if (x_at_plain) {
		*x_at_plain = _vala_x_at_plain;
	}
	if (z_at_plain) {
		*z_at_plain = _vala_z_at_plain;
	}
}

static gdouble
nibbles_view_view3_d_view_point_x (NibblesViewView3D* self)
{
	NibblesViewPoint3D _tmp0_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->view_point;
	result = _tmp0_.x;
	return result;
}

static gdouble
nibbles_view_view3_d_2D_diff (NibblesViewView3D* self,
                              NibblesViewPoint3D* a,
                              NibblesViewPoint3D* b)
{
	gdouble ax = 0.0;
	gdouble ay = 0.0;
	gdouble bx = 0.0;
	gdouble by = 0.0;
	NibblesViewPoint3D _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	NibblesViewPoint3D _tmp3_;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (a != NULL, 0.0);
	g_return_val_if_fail (b != NULL, 0.0);
	_tmp0_ = *a;
	nibbles_view_view3_d_to_view_plain (self, &_tmp0_, &_tmp1_, &_tmp2_);
	ax = _tmp1_;
	ay = _tmp2_;
	_tmp3_ = *b;
	nibbles_view_view3_d_to_view_plain (self, &_tmp3_, &_tmp4_, &_tmp5_);
	bx = _tmp4_;
	by = _tmp5_;
	result = sqrt (((ax - bx) * (ax - bx)) + ((ay - by) * (ay - by)));
	return result;
}

static NibblesViewView3D*
nibbles_view_view3_d_construct (GType object_type)
{
	NibblesViewView3D* self = NULL;
	self = (NibblesViewView3D*) g_type_create_instance (object_type);
	return self;
}

static NibblesViewView3D*
nibbles_view_view3_d_new (void)
{
	return nibbles_view_view3_d_construct (NIBBLES_VIEW_TYPE_VIEW3_D);
}

static void
nibbles_view_value_view3_d_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
nibbles_view_value_view3_d_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		nibbles_view_view3_d_unref (value->data[0].v_pointer);
	}
}

static void
nibbles_view_value_view3_d_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = nibbles_view_view3_d_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
nibbles_view_value_view3_d_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
nibbles_view_value_view3_d_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		NibblesViewView3D * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = nibbles_view_view3_d_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
nibbles_view_value_view3_d_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	NibblesViewView3D ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = nibbles_view_view3_d_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
nibbles_view_param_spec_view3_d (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	NibblesViewParamSpecView3D* spec;
	g_return_val_if_fail (g_type_is_a (object_type, NIBBLES_VIEW_TYPE_VIEW3_D), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
nibbles_view_value_get_view3_d (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_VIEW_TYPE_VIEW3_D), NULL);
	return value->data[0].v_pointer;
}

static void
nibbles_view_value_set_view3_d (GValue* value,
                                gpointer v_object)
{
	NibblesViewView3D * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_VIEW_TYPE_VIEW3_D));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NIBBLES_VIEW_TYPE_VIEW3_D));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		nibbles_view_view3_d_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		nibbles_view_view3_d_unref (old);
	}
}

static void
nibbles_view_value_take_view3_d (GValue* value,
                                 gpointer v_object)
{
	NibblesViewView3D * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NIBBLES_VIEW_TYPE_VIEW3_D));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NIBBLES_VIEW_TYPE_VIEW3_D));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		nibbles_view_view3_d_unref (old);
	}
}

static void
nibbles_view_view3_d_class_init (NibblesViewView3DClass * klass,
                                 gpointer klass_data)
{
	nibbles_view_view3_d_parent_class = g_type_class_peek_parent (klass);
	((NibblesViewView3DClass *) klass)->finalize = nibbles_view_view3_d_finalize;
	g_type_class_adjust_private_offset (klass, &NibblesViewView3D_private_offset);
}

static void
nibbles_view_view3_d_instance_init (NibblesViewView3D * self,
                                    gpointer klass)
{
	self->priv = nibbles_view_view3_d_get_instance_private (self);
	self->priv->has_view_plain_been_set = FALSE;
	self->priv->has_view_plain_z_height_been_set = FALSE;
	self->priv->x_scale = (gdouble) 1;
	self->priv->y_scale = (gdouble) 1;
	self->ref_count = 1;
}

static void
nibbles_view_view3_d_finalize (NibblesViewView3D * obj)
{
	NibblesViewView3D * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NIBBLES_VIEW_TYPE_VIEW3_D, NibblesViewView3D);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
nibbles_view_view3_d_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { nibbles_view_value_view3_d_init, nibbles_view_value_view3_d_free_value, nibbles_view_value_view3_d_copy_value, nibbles_view_value_view3_d_peek_pointer, "p", nibbles_view_value_view3_d_collect_value, "p", nibbles_view_value_view3_d_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NibblesViewView3DClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_view_view3_d_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesViewView3D), 0, (GInstanceInitFunc) nibbles_view_view3_d_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType nibbles_view_view3_d_type_id;
	nibbles_view_view3_d_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NibblesViewView3D", &g_define_type_info, &g_define_type_fundamental_info, 0);
	NibblesViewView3D_private_offset = g_type_add_instance_private (nibbles_view_view3_d_type_id, sizeof (NibblesViewView3DPrivate));
	return nibbles_view_view3_d_type_id;
}

static GType
nibbles_view_view3_d_get_type (void)
{
	static gsize nibbles_view_view3_d_type_id__once = 0;
	if (g_once_init_enter (&nibbles_view_view3_d_type_id__once)) {
		GType nibbles_view_view3_d_type_id;
		nibbles_view_view3_d_type_id = nibbles_view_view3_d_get_type_once ();
		g_once_init_leave (&nibbles_view_view3_d_type_id__once, nibbles_view_view3_d_type_id);
	}
	return nibbles_view_view3_d_type_id__once;
}

static gpointer
nibbles_view_view3_d_ref (gpointer instance)
{
	NibblesViewView3D * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
nibbles_view_view3_d_unref (gpointer instance)
{
	NibblesViewView3D * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NIBBLES_VIEW_VIEW3_D_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static NibblesViewPoint3D*
nibbles_view_point3_d_dup (const NibblesViewPoint3D* self)
{
	NibblesViewPoint3D* dup;
	dup = g_new0 (NibblesViewPoint3D, 1);
	memcpy (dup, self, sizeof (NibblesViewPoint3D));
	return dup;
}

static void
nibbles_view_point3_d_free (NibblesViewPoint3D* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
nibbles_view_point3_d_get_type_once (void)
{
	GType nibbles_view_point3_d_type_id;
	nibbles_view_point3_d_type_id = g_boxed_type_register_static ("NibblesViewPoint3D", (GBoxedCopyFunc) nibbles_view_point3_d_dup, (GBoxedFreeFunc) nibbles_view_point3_d_free);
	return nibbles_view_point3_d_type_id;
}

static GType
nibbles_view_point3_d_get_type (void)
{
	static gsize nibbles_view_point3_d_type_id__once = 0;
	if (g_once_init_enter (&nibbles_view_point3_d_type_id__once)) {
		GType nibbles_view_point3_d_type_id;
		nibbles_view_point3_d_type_id = nibbles_view_point3_d_get_type_once ();
		g_once_init_leave (&nibbles_view_point3_d_type_id__once, nibbles_view_point3_d_type_id);
	}
	return nibbles_view_point3_d_type_id__once;
}

static void
nibbles_view_class_init (NibblesViewClass * klass,
                         gpointer klass_data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	nibbles_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NibblesView_private_offset);
	G_OBJECT_CLASS (klass)->finalize = nibbles_view_finalize;
	_tmp0_ = g_strdup ("red");
	_tmp1_ = g_strdup (N_ ("red"));
	_tmp2_ = g_strdup ("green");
	_tmp3_ = g_strdup (N_ ("green"));
	_tmp4_ = g_strdup ("blue");
	_tmp5_ = g_strdup (N_ ("blue"));
	_tmp6_ = g_strdup ("yellow");
	_tmp7_ = g_strdup (N_ ("yellow"));
	_tmp8_ = g_strdup ("cyan");
	_tmp9_ = g_strdup (N_ ("cyan"));
	_tmp10_ = g_strdup ("purple");
	_tmp11_ = g_strdup (N_ ("purple"));
	_tmp12_ = g_new0 (gchar*, (6 * 2) + 1);
	_tmp12_[0] = _tmp0_;
	_tmp12_[1] = _tmp1_;
	_tmp12_[2] = _tmp2_;
	_tmp12_[3] = _tmp3_;
	_tmp12_[4] = _tmp4_;
	_tmp12_[5] = _tmp5_;
	_tmp12_[6] = _tmp6_;
	_tmp12_[7] = _tmp7_;
	_tmp12_[8] = _tmp8_;
	_tmp12_[9] = _tmp9_;
	_tmp12_[10] = _tmp10_;
	_tmp12_[11] = _tmp11_;
	nibbles_view_color_lookup = _tmp12_;
	nibbles_view_color_lookup_length1 = 6;
	nibbles_view_color_lookup_length2 = 2;
}

static void
nibbles_view_instance_init (NibblesView * self,
                            gpointer klass)
{
	self->priv = nibbles_view_get_instance_private (self);
	self->priv->animate = (guint64) 0;
}

static void
nibbles_view_finalize (GObject * obj)
{
	NibblesView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_VIEW, NibblesView);
	_g_object_unref0 (self->priv->game);
	(self->priv->countdown_active_target_destroy_notify == NULL) ? NULL : (self->priv->countdown_active_target_destroy_notify (self->priv->countdown_active_target), NULL);
	self->priv->countdown_active = NULL;
	self->priv->countdown_active_target = NULL;
	self->priv->countdown_active_target_destroy_notify = NULL;
	(self->priv->new_game_dialogue_active_target_destroy_notify == NULL) ? NULL : (self->priv->new_game_dialogue_active_target_destroy_notify (self->priv->new_game_dialogue_active_target), NULL);
	self->priv->new_game_dialogue_active = NULL;
	self->priv->new_game_dialogue_active_target = NULL;
	self->priv->new_game_dialogue_active_target_destroy_notify = NULL;
	(self->priv->result_function_target_destroy_notify == NULL) ? NULL : (self->priv->result_function_target_destroy_notify (self->priv->result_function_target), NULL);
	self->priv->result_function = NULL;
	self->priv->result_function_target = NULL;
	self->priv->result_function_target_destroy_notify = NULL;
	G_OBJECT_CLASS (nibbles_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
nibbles_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NibblesViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesView), 0, (GInstanceInitFunc) nibbles_view_instance_init, NULL };
	GType nibbles_view_type_id;
	nibbles_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "NibblesView", &g_define_type_info, 0);
	NibblesView_private_offset = g_type_add_instance_private (nibbles_view_type_id, sizeof (NibblesViewPrivate));
	return nibbles_view_type_id;
}

GType
nibbles_view_get_type (void)
{
	static gsize nibbles_view_type_id__once = 0;
	if (g_once_init_enter (&nibbles_view_type_id__once)) {
		GType nibbles_view_type_id;
		nibbles_view_type_id = nibbles_view_get_type_once ();
		g_once_init_leave (&nibbles_view_type_id__once, nibbles_view_type_id);
	}
	return nibbles_view_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

