/* nibbles-game.c generated by valac 0.56.16, the Vala compiler
 * generated from nibbles-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't 
 * match them self.
 *
 * grep -ne '[^][)(_!$ "](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gio/gio.h>

#define NIBBLES_GAME_MAX_WORMS 6
#define NIBBLES_GAME_MAX_SPEED 4
#define NIBBLES_GAME_EMPTYCHAR 'a'
#define NIBBLES_GAME_WORMCHAR 'w'
#define NIBBLES_GAME_WARPCHAR 'W'
#define NIBBLES_GAME_MAX_LEVEL 26
#define WORM_GROW_FACTOR 4
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef gboolean (*KeypressHandlerFunction) (guint a, guint b, gboolean* remove_handler, gpointer user_data);
typedef enum  {
	GAME_STATUS_GAMEOVER,
	GAME_STATUS_VICTORY,
	GAME_STATUS_NEWROUND
} GameStatus;

#define TYPE_GAME_STATUS (game_status_get_type ())

#define TYPE_NIBBLES_GAME (nibbles_game_get_type ())
#define NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_GAME, NibblesGame))
#define NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_GAME, NibblesGameClass))
#define IS_NIBBLES_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_GAME))
#define IS_NIBBLES_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_GAME))
#define NIBBLES_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_GAME, NibblesGameClass))

typedef struct _NibblesGame NibblesGame;
typedef struct _NibblesGameClass NibblesGameClass;
typedef struct _NibblesGamePrivate NibblesGamePrivate;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
#define WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_PROPERTIES, WormProperties))
#define WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_PROPERTIES, WormPropertiesClass))
#define IS_WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_PROPERTIES))
#define IS_WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_PROPERTIES))
#define WORM_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_PROPERTIES, WormPropertiesClass))

typedef struct _WormProperties WormProperties;
typedef struct _WormPropertiesClass WormPropertiesClass;

#define TYPE_BONI (boni_get_type ())
#define BONI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONI, Boni))
#define BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONI, BoniClass))
#define IS_BONI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONI))
#define IS_BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONI))
#define BONI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONI, BoniClass))

typedef struct _Boni Boni;
typedef struct _BoniClass BoniClass;

#define TYPE_WARP_MANAGER (warp_manager_get_type ())
#define WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP_MANAGER, WarpManager))
#define WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP_MANAGER, WarpManagerClass))
#define IS_WARP_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP_MANAGER))
#define IS_WARP_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP_MANAGER))
#define WARP_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP_MANAGER, WarpManagerClass))

typedef struct _WarpManager WarpManager;
typedef struct _WarpManagerClass WarpManagerClass;
enum  {
	NIBBLES_GAME_0_PROPERTY,
	NIBBLES_GAME_SKIP_SCORE_PROPERTY,
	NIBBLES_GAME_CURRENT_LEVEL_PROPERTY,
	NIBBLES_GAME_THREE_DIMENSIONAL_VIEW_PROPERTY,
	NIBBLES_GAME_SPEED_PROPERTY,
	NIBBLES_GAME_GAMEDELAY_PROPERTY,
	NIBBLES_GAME_WIDTH_PROPERTY,
	NIBBLES_GAME_HEIGHT_PROPERTY,
	NIBBLES_GAME_NUMHUMANS_PROPERTY,
	NIBBLES_GAME_NUMAI_PROPERTY,
	NIBBLES_GAME_NUMWORMS_PROPERTY,
	NIBBLES_GAME_WORMS_PROPERTY,
	NIBBLES_GAME_WORM_PROPS_PROPERTY,
	NIBBLES_GAME_IS_RUNNING_PROPERTY,
	NIBBLES_GAME_PAUSED_PROPERTY,
	NIBBLES_GAME_FAKES_PROPERTY,
	NIBBLES_GAME_NUM_PROPERTIES
};
static GParamSpec* nibbles_game_properties[NIBBLES_GAME_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_EAST = WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_SOUTH = WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_WEST = WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP,
	WORM_DIRECTION_NORTH = WORM_DIRECTION_UP
} WormDirection;

#define TYPE_WORM_DIRECTION (worm_direction_get_type ())
typedef GeeList* (*WormGetOtherWormsType) (Worm* _self_, gpointer user_data);

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;
typedef GeeList* (*WormGetBonusesType) (gpointer user_data);
typedef struct _WormPrivate WormPrivate;

#define TYPE_WORM_POSITIONS (worm_positions_get_type ())
#define WORM_POSITIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_POSITIONS, WormPositions))
#define WORM_POSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_POSITIONS, WormPositionsClass))
#define IS_WORM_POSITIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_POSITIONS))
#define IS_WORM_POSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_POSITIONS))
#define WORM_POSITIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_POSITIONS, WormPositionsClass))

typedef struct _WormPositions WormPositions;
typedef struct _WormPositionsClass WormPositionsClass;

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;
typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;

#define TYPE_BONUS_TYPE (bonus_type_get_type ())
typedef GVariant* (*NibblesGameSetMappingFunction) (GValue* value, const GVariantType* type, void* data, gpointer user_data);
enum  {
	NIBBLES_GAME_BONUS_APPLIED_SIGNAL,
	NIBBLES_GAME_LOG_SCORE_SIGNAL,
	NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL,
	NIBBLES_GAME_LEVEL_COMPLETED_SIGNAL,
	NIBBLES_GAME_WARP_ADDED_SIGNAL,
	NIBBLES_GAME_BONUS_ADDED_SIGNAL,
	NIBBLES_GAME_BONUS_REMOVED_SIGNAL,
	NIBBLES_GAME_GET_PKGDATADIR_SIGNAL,
	NIBBLES_GAME_ADD_KEYPRESS_HANDLER_SIGNAL,
	NIBBLES_GAME_REDRAW_SIGNAL,
	NIBBLES_GAME_PLAY_SOUND_SIGNAL,
	NIBBLES_GAME_NUM_SIGNALS
};
static guint nibbles_game_signals[NIBBLES_GAME_NUM_SIGNALS] = {0};

struct _NibblesGame {
	GObject parent_instance;
	NibblesGamePrivate * priv;
	gint* board;
	gint board_length1;
	gint board_length2;
	gboolean added_keypress_handler;
};

struct _NibblesGameClass {
	GObjectClass parent_class;
};

struct _NibblesGamePrivate {
	gboolean _skip_score;
	gint _current_level;
	gboolean _three_dimensional_view;
	gint _speed;
	gint _gamedelay;
	guint8 _width;
	guint8 _height;
	gint _numhumans;
	gint _numai;
	gint _numworms;
	GeeLinkedList* _worms;
	GeeHashMap* _worm_props;
	Boni* boni;
	WarpManager* warp_manager;
	gboolean _is_running;
	gboolean _is_paused;
	guint main_id;
	gboolean _fakes;
	guint8 bonus_cycle;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gint rounds_to_stay_still;
	gboolean is_stopped;
	WormPositions* list;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _Position {
	guint8 x;
	guint8 y;
};

static gint NibblesGame_private_offset;
static gpointer nibbles_game_parent_class = NULL;

VALA_EXTERN GType game_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType nibbles_game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesGame, g_object_unref)
VALA_EXTERN GType worm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Worm, g_object_unref)
VALA_EXTERN GType worm_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormProperties, g_object_unref)
VALA_EXTERN GType boni_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Boni, g_object_unref)
VALA_EXTERN GType warp_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WarpManager, g_object_unref)
VALA_EXTERN Boni* boni_new (void);
VALA_EXTERN Boni* boni_construct (GType object_type);
VALA_EXTERN WarpManager* warp_manager_new (void);
VALA_EXTERN WarpManager* warp_manager_construct (GType object_type);
VALA_EXTERN NibblesGame* nibbles_game_new (gint start_level,
                               gint speed,
                               gint gamedelay,
                               gboolean fakes,
                               gboolean three_dimensional_view,
                               guint8 width,
                               guint8 height,
                               gboolean no_random);
VALA_EXTERN NibblesGame* nibbles_game_construct (GType object_type,
                                     gint start_level,
                                     gint speed,
                                     gint gamedelay,
                                     gboolean fakes,
                                     gboolean three_dimensional_view,
                                     guint8 width,
                                     guint8 height,
                                     gboolean no_random);
VALA_EXTERN void nibbles_game_new_level (NibblesGame* self,
                             gint level_id);
VALA_EXTERN gboolean nibbles_game_keypress (NibblesGame* self,
                                guint keyval,
                                guint keycode,
                                gboolean* remove_handler);
static gboolean _nibbles_game_keypress_keypress_handler_function (guint a,
                                                           guint b,
                                                           gboolean* remove_handler,
                                                           gpointer self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
VALA_EXTERN gboolean nibbles_game_load_board (NibblesGame* self,
                                  gchar** future_board,
                                  gint future_board_length1,
                                  guint8 regular_bonus);
VALA_EXTERN gint nibbles_game_get_numworms (NibblesGame* self);
VALA_EXTERN guint8 nibbles_game_get_height (NibblesGame* self);
VALA_EXTERN void boni_reset (Boni* self,
                 guint8 regular_bonus);
VALA_EXTERN void warp_manager_clear_warps (WarpManager* self);
VALA_EXTERN guint8 nibbles_game_get_width (NibblesGame* self);
VALA_EXTERN GeeLinkedList* nibbles_game_get_worms (NibblesGame* self);
VALA_EXTERN GType worm_direction_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void worm_set_start (Worm* self,
                     guint8 x,
                     guint8 y,
                     WormDirection direction);
VALA_EXTERN void warp_manager_add_warp_source (WarpManager* self,
                                   gint id,
                                   guint8 x,
                                   guint8 y);
VALA_EXTERN void warp_manager_add_warp_target (WarpManager* self,
                                   gint id,
                                   guint8 x,
                                   guint8 y);
VALA_EXTERN void nibbles_game_start (NibblesGame* self,
                         gboolean add_initial_bonus);
static void nibbles_game_add_bonus (NibblesGame* self,
                             gboolean regular);
static void nibbles_game_set_is_running (NibblesGame* self,
                                  gboolean value);
VALA_EXTERN gint nibbles_game_get_gamedelay (NibblesGame* self);
VALA_EXTERN gint nibbles_game_get_speed (NibblesGame* self);
static gboolean __lambda11_ (NibblesGame* self);
static gboolean nibbles_game_main_loop_cb (NibblesGame* self);
static gboolean ___lambda11__gsource_func (gpointer self);
VALA_EXTERN void nibbles_game_stop (NibblesGame* self);
VALA_EXTERN void nibbles_game_reset (NibblesGame* self,
                         gint start_level);
VALA_EXTERN void nibbles_game_set_skip_score (NibblesGame* self,
                                  gboolean value);
VALA_EXTERN void nibbles_game_set_current_level (NibblesGame* self,
                                     gint value);
static void nibbles_game_set_is_paused (NibblesGame* self,
                                 gboolean value);
static void nibbles_game_end (NibblesGame* self);
VALA_EXTERN GameStatus* nibbles_game_get_game_status (NibblesGame* self);
static gboolean _game_status_equal (const GameStatus * s1,
                             const GameStatus * s2);
VALA_EXTERN gint worm_get_score (Worm* self);
VALA_EXTERN gint nibbles_game_get_current_level (NibblesGame* self);
VALA_EXTERN Worm* nibbles_game_get_winner (NibblesGame* self);
static void nibbles_game_move_worms (NibblesGame* self);
VALA_EXTERN void nibbles_game_create_worms (NibblesGame* self,
                                GeeArrayList* worm_settings);
VALA_EXTERN gint nibbles_game_get_numai (NibblesGame* self);
VALA_EXTERN gint nibbles_game_get_numhumans (NibblesGame* self);
static void nibbles_game_set_numworms (NibblesGame* self,
                                gint value);
static GeeList* nibbles_game_get_other_worms (NibblesGame* self,
                                       Worm* _self_);
static GeeList* _nibbles_game_get_other_worms_worm_get_other_worms_type (Worm* _self_,
                                                                  gpointer self);
VALA_EXTERN GType bonus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Bonus, g_object_unref)
VALA_EXTERN GeeList* nibbles_game_get_bonuses (NibblesGame* self);
static GeeList* _nibbles_game_get_bonuses_worm_get_bonuses_type (gpointer self);
VALA_EXTERN Worm* worm_new (gint id,
                guint8 width,
                guint8 height,
                WormGetOtherWormsType cb0,
                gpointer cb0_target,
                WormGetBonusesType cb1,
                gpointer cb1_target);
VALA_EXTERN Worm* worm_construct (GType object_type,
                      gint id,
                      guint8 width,
                      guint8 height,
                      WormGetOtherWormsType cb0,
                      gpointer cb0_target,
                      WormGetBonusesType cb1,
                      gpointer cb1_target);
static void nibbles_game_bonus_found_cb (NibblesGame* self,
                                  Worm* worm);
static void _nibbles_game_bonus_found_cb_worm_bonus_found (Worm* _sender,
                                                    gpointer self);
VALA_EXTERN GType worm_positions_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormPositions, g_object_unref)
VALA_EXTERN void nibbles_game_load_worm_properties (NibblesGame* self,
                                        GeeArrayList* worm_settings);
VALA_EXTERN void nibbles_game_add_worms (NibblesGame* self);
VALA_EXTERN void worm_spawn (Worm* self);
VALA_EXTERN gboolean boni_too_many_missed (Boni* self);
VALA_EXTERN void worm_set_score (Worm* self,
                     gint value);
VALA_EXTERN void boni_on_worms_move (Boni* self,
                         guint8* missed_bonuses_to_replace);
VALA_EXTERN void worm_ai_move (Worm* self,
                   gint* board,
                   gint board_length1,
                   gint board_length2,
                   GeeLinkedList* worms);
VALA_EXTERN GType position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Position* position_dup (const Position* self);
VALA_EXTERN void position_free (Position* self);
VALA_EXTERN void worm_position_move (Worm* self,
                         Position* result);
VALA_EXTERN WormDirection worm_get_direction (Worm* self);
VALA_EXTERN gboolean warp_manager_get_warp_target (WarpManager* self,
                                       guint8 x,
                                       guint8 y,
                                       gboolean horizontal,
                                       guint8* target_x,
                                       guint8* target_y);
VALA_EXTERN gboolean worm_can_move_to (Worm* self,
                           gint* board,
                           gint board_length1,
                           gint board_length2,
                           GeeLinkedList* worms,
                           Position* position);
VALA_EXTERN void worm_move_part_1 (Worm* self);
VALA_EXTERN void worm_get_head (Worm* self,
                    Position * result);
VALA_EXTERN void worm_move_part_2 (Worm* self,
                       Position* head_position);
VALA_EXTERN guint8 worm_get_lives (Worm* self);
VALA_EXTERN void worm_reset (Worm* self);
static void nibbles_game_reverse_worms (NibblesGame* self,
                                 Worm* worm);
VALA_EXTERN void worm_reverse (Worm* self);
static gboolean nibbles_game_is_space_empty (NibblesGame* self,
                                      guint8 x,
                                      guint8 y,
                                      gboolean* worms_at,
                                      gint worms_at_length1,
                                      gint worms_at_length2);
VALA_EXTERN Bonus* boni_get_bonus (Boni* self,
                       guint8 x,
                       guint8 y);
VALA_EXTERN gboolean nibbles_game_get_fakes (NibblesGame* self);
VALA_EXTERN GType bonus_type_get_type (void) G_GNUC_CONST ;
static inline void _nibbles_game_add_bonus (NibblesGame* self,
                              guint8 x,
                              guint8 y,
                              BonusType bonus_type,
                              gboolean fake,
                              guint16 countdown);
VALA_EXTERN Bonus* bonus_new (guint8 x,
                  guint8 y,
                  BonusType bonus_type,
                  gboolean fake,
                  guint16 countdown);
VALA_EXTERN Bonus* bonus_construct (GType object_type,
                        guint8 x,
                        guint8 y,
                        BonusType bonus_type,
                        gboolean fake,
                        guint16 countdown);
VALA_EXTERN gboolean boni_add_bonus (Boni* self,
                         Bonus* bonus);
VALA_EXTERN BonusType bonus_get_bonus_type (Bonus* self);
static void nibbles_game_apply_bonus (NibblesGame* self,
                               Bonus* bonus,
                               Worm* worm);
VALA_EXTERN gboolean bonus_get_fake (Bonus* self);
VALA_EXTERN guint8 boni_new_regular_bonus_eaten (Boni* self);
VALA_EXTERN gint worm_get_change (Worm* self);
VALA_EXTERN void worm_set_change (Worm* self,
                      gint value);
VALA_EXTERN gint worm_get_length (Worm* self);
VALA_EXTERN void worm_reduce_tail (Worm* self,
                       gint erase_size);
VALA_EXTERN void worm_add_life (Worm* self);
VALA_EXTERN void worm_add_bonus_eaten_position (Worm* self,
                                    guint8 x,
                                    guint8 y);
VALA_EXTERN void boni_remove_bonus (Boni* self,
                        Bonus* bonus);
VALA_EXTERN gboolean boni_last_regular_bonus (Boni* self);
static GameStatus* _game_status_dup (GameStatus* self);
VALA_EXTERN GeeHashMap* nibbles_game_get_worm_props (NibblesGame* self);
VALA_EXTERN WormProperties* worm_properties_new (void);
VALA_EXTERN WormProperties* worm_properties_construct (GType object_type);
static GVariant* ____lambda12_ (NibblesGame* self,
                         GValue* value,
                         const GVariantType* type,
                         void* data);
static inline gchar* nibbles_game_get_color_string (gint color);
static GVariant* _____lambda12__nibbles_game_set_mapping_function (GValue* value,
                                                            const GVariantType* type,
                                                            void* data,
                                                            gpointer self);
VALA_EXTERN gint worm_get_id (Worm* self);
static gboolean ____lambda13_ (GValue* prop_value,
                        GVariant* variant);
static inline gint nibbles_game_get_color_num (const gchar* color);
static gboolean _____lambda13__gsettings_bind_get_mapping (GValue* value,
                                                    GVariant* variant,
                                                    void* user_data);
VALA_EXTERN gboolean nibbles_game_handle_keypress (NibblesGame* self,
                                       guint keyval,
                                       guint keycode);
VALA_EXTERN gboolean nibbles_game_get_is_running (NibblesGame* self);
VALA_EXTERN gboolean worm_handle_keypress (Worm* self,
                               guint keycode,
                               GeeHashMap* worm_props,
                               gint* board,
                               gint board_length1,
                               gint board_length2,
                               GeeLinkedList* worms);
VALA_EXTERN GeeList* boni_get_bonuses (Boni* self);
VALA_EXTERN gboolean nibbles_game_get_skip_score (NibblesGame* self);
VALA_EXTERN gboolean nibbles_game_get_three_dimensional_view (NibblesGame* self);
VALA_EXTERN void nibbles_game_set_three_dimensional_view (NibblesGame* self,
                                              gboolean value);
VALA_EXTERN void nibbles_game_set_speed (NibblesGame* self,
                             gint value);
static void nibbles_game_set_gamedelay (NibblesGame* self,
                                 gint value);
static void nibbles_game_set_width (NibblesGame* self,
                             guint8 value);
static void nibbles_game_set_height (NibblesGame* self,
                              guint8 value);
VALA_EXTERN void nibbles_game_set_numhumans (NibblesGame* self,
                                 gint value);
VALA_EXTERN void nibbles_game_set_numai (NibblesGame* self,
                             gint value);
static gboolean nibbles_game_get_is_paused (NibblesGame* self);
VALA_EXTERN gboolean nibbles_game_get_paused (NibblesGame* self);
VALA_EXTERN void nibbles_game_set_paused (NibblesGame* self,
                              gboolean value);
VALA_EXTERN void nibbles_game_set_fakes (NibblesGame* self,
                             gboolean value);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UCHAR_UCHAR (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void g_cclosure_user_marshal_STRING__VOID (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure,
                                                       GValue * return_value,
                                                       guint n_param_values,
                                                       const GValue * param_values,
                                                       gpointer invocation_hint,
                                                       gpointer marshal_data);
static GObject * nibbles_game_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void _nibbles_game___lambda14_ (NibblesGame* self,
                                Bonus* bonus);
static void __nibbles_game___lambda14__boni_bonus_removed (Boni* _sender,
                                                    Bonus* bonus,
                                                    gpointer self);
static void nibbles_game_finalize (GObject * obj);
static GType nibbles_game_get_type_once (void);
static void _vala_nibbles_game_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_nibbles_game_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

 G_GNUC_NO_INLINE static GType
game_status_get_type_once (void)
{
	static const GEnumValue values[] = {{GAME_STATUS_GAMEOVER, "GAME_STATUS_GAMEOVER", "gameover"}, {GAME_STATUS_VICTORY, "GAME_STATUS_VICTORY", "victory"}, {GAME_STATUS_NEWROUND, "GAME_STATUS_NEWROUND", "newround"}, {0, NULL, NULL}};
	GType game_status_type_id;
	game_status_type_id = g_enum_register_static ("GameStatus", values);
	return game_status_type_id;
}

GType
game_status_get_type (void)
{
	static gsize game_status_type_id__once = 0;
	if (g_once_init_enter (&game_status_type_id__once)) {
		GType game_status_type_id;
		game_status_type_id = game_status_get_type_once ();
		g_once_init_leave (&game_status_type_id__once, game_status_type_id);
	}
	return game_status_type_id__once;
}

static inline gpointer
nibbles_game_get_instance_private (NibblesGame* self)
{
	return G_STRUCT_MEMBER_P (self, NibblesGame_private_offset);
}

NibblesGame*
nibbles_game_construct (GType object_type,
                        gint start_level,
                        gint speed,
                        gint gamedelay,
                        gboolean fakes,
                        gboolean three_dimensional_view,
                        guint8 width,
                        guint8 height,
                        gboolean no_random)
{
	NibblesGame * self = NULL;
	guint32 _tmp0_ = 0U;
	self = (NibblesGame*) g_object_new (object_type, "skip-score", start_level != 1, "current-level", start_level, "speed", speed, "gamedelay", gamedelay, "fakes", fakes, "three-dimensional-view", three_dimensional_view, "width", width, "height", height, NULL);
	if (no_random) {
		_tmp0_ = (guint32) 42;
	} else {
		time_t _tmp1_;
		_tmp1_ = time (NULL);
		_tmp0_ = (guint32) _tmp1_;
	}
	g_random_set_seed (_tmp0_);
	return self;
}

NibblesGame*
nibbles_game_new (gint start_level,
                  gint speed,
                  gint gamedelay,
                  gboolean fakes,
                  gboolean three_dimensional_view,
                  guint8 width,
                  guint8 height,
                  gboolean no_random)
{
	return nibbles_game_construct (TYPE_NIBBLES_GAME, start_level, speed, gamedelay, fakes, three_dimensional_view, width, height, no_random);
}

static gboolean
_nibbles_game_keypress_keypress_handler_function (guint a,
                                                  guint b,
                                                  gboolean* remove_handler,
                                                  gpointer self)
{
	gboolean result;
	result = nibbles_game_keypress ((NibblesGame*) self, a, b, remove_handler);
	return result;
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		_tmp6_ = g_strdup (_tmp5_);
		result = _tmp6_;
		_g_string_free0 (ret);
		return result;
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
nibbles_game_new_level (NibblesGame* self,
                        gint level_id)
{
	gchar* level_name = NULL;
	gchar* _tmp1_;
	gchar* filename = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	FILE* file = NULL;
	FILE* _tmp6_;
	gchar* line = NULL;
	gchar** board = NULL;
	gchar** _tmp7_;
	gint board_length1;
	gint _board_size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	if (!self->added_keypress_handler) {
		gboolean _tmp0_ = FALSE;
		g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_ADD_KEYPRESS_HANDLER_SIGNAL], 0, _nibbles_game_keypress_keypress_handler_function, self, &_tmp0_);
		self->added_keypress_handler = _tmp0_;
	}
	_tmp1_ = g_strdup_printf ("level%03d.gnl", level_id);
	level_name = _tmp1_;
	g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_GET_PKGDATADIR_SIGNAL], 0, &_tmp2_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_filename (_tmp3_, "levels", level_name, NULL, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	filename = _tmp5_;
	_tmp6_ = g_fopen (filename, "r");
	_fclose0 (file);
	file = _tmp6_;
	if (file == NULL) {
		g_error ("nibbles-game.vala:149: Nibbles couldn't find pixmap file: %s", filename);
	}
	_tmp7_ = g_new0 (gchar*, 0 + 1);
	board = _tmp7_;
	board_length1 = 0;
	_board_size_ = board_length1;
	while (TRUE) {
		gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp8_ = g_file_stream_read_line (file);
		_g_free0 (line);
		line = _tmp8_;
		_tmp9_ = line;
		if (!(_tmp9_ != NULL)) {
			break;
		}
		_tmp10_ = line;
		_tmp11_ = g_strdup ((const gchar*) _tmp10_);
		_vala_array_add1 (&board, &board_length1, &_board_size_, _tmp11_);
	}
	_tmp12_ = board;
	_tmp12__length1 = board_length1;
	_tmp13_ = self->priv->_numworms;
	if (!nibbles_game_load_board (self, _tmp12_, (gint) _tmp12__length1, (guint8) (8 + _tmp13_))) {
		g_error ("nibbles-game.vala:156: Level file appears to be damaged: %s", filename);
	}
	board = (_vala_array_free (board, board_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (line);
	_fclose0 (file);
	_g_free0 (filename);
	_g_free0 (level_name);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

gboolean
nibbles_game_load_board (NibblesGame* self,
                         gchar** future_board,
                         gint future_board_length1,
                         guint8 regular_bonus)
{
	guint8 _tmp0_;
	Boni* _tmp1_;
	WarpManager* _tmp2_;
	gchar* tmpboard = NULL;
	gint count = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_height;
	if (future_board_length1 != ((gint) _tmp0_)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->boni;
	boni_reset (_tmp1_, regular_bonus);
	_tmp2_ = self->priv->warp_manager;
	warp_manager_clear_warps (_tmp2_);
	count = 0;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				guint8 _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				const gchar* _tmp8_;
				guint8 _tmp9_;
				if (!_tmp3_) {
					guint8 _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_height;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = future_board[i];
				_tmp7_ = g_strdup (_tmp6_);
				_g_free0 (tmpboard);
				tmpboard = _tmp7_;
				_tmp8_ = tmpboard;
				_tmp9_ = self->priv->_width;
				if (g_utf8_strlen (_tmp8_, (gssize) -1) != ((gint) _tmp9_)) {
					result = FALSE;
					_g_free0 (tmpboard);
					return result;
				}
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp10_ = FALSE;
						_tmp10_ = TRUE;
						while (TRUE) {
							guint8 _tmp12_;
							gunichar char_value = 0U;
							const gchar* _tmp13_;
							const gchar* _tmp14_;
							if (!_tmp10_) {
								guint8 _tmp11_;
								_tmp11_ = j;
								j = _tmp11_ + 1;
							}
							_tmp10_ = FALSE;
							_tmp12_ = self->priv->_width;
							if (!(j < _tmp12_)) {
								break;
							}
							_tmp13_ = tmpboard;
							_tmp14_ = tmpboard;
							char_value = string_get_char (_tmp13_, (glong) string_index_of_nth_char (_tmp14_, (glong) j));
							switch (char_value) {
								case '.':
								case '+':
								{
									gint* _tmp15_;
									gint _tmp15__length1;
									gint _tmp15__length2;
									_tmp15_ = self->board;
									_tmp15__length1 = self->board_length1;
									_tmp15__length2 = self->board_length2;
									_tmp15_[(j * _tmp15__length2) + i] = (gint) 'a';
									break;
								}
								case 9475U:
								{
									gint* _tmp16_;
									gint _tmp16__length1;
									gint _tmp16__length2;
									_tmp16_ = self->board;
									_tmp16__length1 = self->board_length1;
									_tmp16__length2 = self->board_length2;
									_tmp16_[(j * _tmp16__length2) + i] = (gint) 'b';
									break;
								}
								case 9473U:
								{
									gint* _tmp17_;
									gint _tmp17__length1;
									gint _tmp17__length2;
									_tmp17_ = self->board;
									_tmp17__length1 = self->board_length1;
									_tmp17__length2 = self->board_length2;
									_tmp17_[(j * _tmp17__length2) + i] = (gint) 'c';
									break;
								}
								case 9495U:
								{
									gint* _tmp18_;
									gint _tmp18__length1;
									gint _tmp18__length2;
									_tmp18_ = self->board;
									_tmp18__length1 = self->board_length1;
									_tmp18__length2 = self->board_length2;
									_tmp18_[(j * _tmp18__length2) + i] = (gint) 'd';
									break;
								}
								case 9499U:
								{
									gint* _tmp19_;
									gint _tmp19__length1;
									gint _tmp19__length2;
									_tmp19_ = self->board;
									_tmp19__length1 = self->board_length1;
									_tmp19__length2 = self->board_length2;
									_tmp19_[(j * _tmp19__length2) + i] = (gint) 'e';
									break;
								}
								case 9487U:
								{
									gint* _tmp20_;
									gint _tmp20__length1;
									gint _tmp20__length2;
									_tmp20_ = self->board;
									_tmp20__length1 = self->board_length1;
									_tmp20__length2 = self->board_length2;
									_tmp20_[(j * _tmp20__length2) + i] = (gint) 'f';
									break;
								}
								case 9491U:
								{
									gint* _tmp21_;
									gint _tmp21__length1;
									gint _tmp21__length2;
									_tmp21_ = self->board;
									_tmp21__length1 = self->board_length1;
									_tmp21__length2 = self->board_length2;
									_tmp21_[(j * _tmp21__length2) + i] = (gint) 'g';
									break;
								}
								case 9531U:
								{
									gint* _tmp22_;
									gint _tmp22__length1;
									gint _tmp22__length2;
									_tmp22_ = self->board;
									_tmp22__length1 = self->board_length1;
									_tmp22__length2 = self->board_length2;
									_tmp22_[(j * _tmp22__length2) + i] = (gint) 'h';
									break;
								}
								case 9507U:
								{
									gint* _tmp23_;
									gint _tmp23__length1;
									gint _tmp23__length2;
									_tmp23_ = self->board;
									_tmp23__length1 = self->board_length1;
									_tmp23__length2 = self->board_length2;
									_tmp23_[(j * _tmp23__length2) + i] = (gint) 'i';
									break;
								}
								case 9515U:
								{
									gint* _tmp24_;
									gint _tmp24__length1;
									gint _tmp24__length2;
									_tmp24_ = self->board;
									_tmp24__length1 = self->board_length1;
									_tmp24__length2 = self->board_length2;
									_tmp24_[(j * _tmp24__length2) + i] = (gint) 'j';
									break;
								}
								case 9523U:
								{
									gint* _tmp25_;
									gint _tmp25__length1;
									gint _tmp25__length2;
									_tmp25_ = self->board;
									_tmp25__length1 = self->board_length1;
									_tmp25__length2 = self->board_length2;
									_tmp25_[(j * _tmp25__length2) + i] = (gint) 'k';
									break;
								}
								case 9547U:
								{
									gint* _tmp26_;
									gint _tmp26__length1;
									gint _tmp26__length2;
									_tmp26_ = self->board;
									_tmp26__length1 = self->board_length1;
									_tmp26__length2 = self->board_length2;
									_tmp26_[(j * _tmp26__length2) + i] = (gint) 'l';
									break;
								}
								case 9650U:
								case 'm':
								{
									gint* _tmp27_;
									gint _tmp27__length1;
									gint _tmp27__length2;
									gint _tmp28_;
									_tmp27_ = self->board;
									_tmp27__length1 = self->board_length1;
									_tmp27__length2 = self->board_length2;
									_tmp27_[(j * _tmp27__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp28_ = self->priv->_numworms;
									if (count < _tmp28_) {
										GeeLinkedList* _tmp29_;
										gpointer _tmp30_;
										Worm* _tmp31_;
										gint _tmp32_;
										_tmp29_ = self->priv->_worms;
										_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, count);
										_tmp31_ = (Worm*) _tmp30_;
										worm_set_start (_tmp31_, j, i, WORM_DIRECTION_UP);
										_g_object_unref0 (_tmp31_);
										_tmp32_ = count;
										count = _tmp32_ + 1;
									}
									break;
								}
								case 9664U:
								case 'n':
								{
									gint* _tmp33_;
									gint _tmp33__length1;
									gint _tmp33__length2;
									gint _tmp34_;
									_tmp33_ = self->board;
									_tmp33__length1 = self->board_length1;
									_tmp33__length2 = self->board_length2;
									_tmp33_[(j * _tmp33__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp34_ = self->priv->_numworms;
									if (count < _tmp34_) {
										GeeLinkedList* _tmp35_;
										gpointer _tmp36_;
										Worm* _tmp37_;
										gint _tmp38_;
										_tmp35_ = self->priv->_worms;
										_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, count);
										_tmp37_ = (Worm*) _tmp36_;
										worm_set_start (_tmp37_, j, i, WORM_DIRECTION_LEFT);
										_g_object_unref0 (_tmp37_);
										_tmp38_ = count;
										count = _tmp38_ + 1;
									}
									break;
								}
								case 9660U:
								case 'o':
								{
									gint* _tmp39_;
									gint _tmp39__length1;
									gint _tmp39__length2;
									gint _tmp40_;
									_tmp39_ = self->board;
									_tmp39__length1 = self->board_length1;
									_tmp39__length2 = self->board_length2;
									_tmp39_[(j * _tmp39__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp40_ = self->priv->_numworms;
									if (count < _tmp40_) {
										GeeLinkedList* _tmp41_;
										gpointer _tmp42_;
										Worm* _tmp43_;
										gint _tmp44_;
										_tmp41_ = self->priv->_worms;
										_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp41_, count);
										_tmp43_ = (Worm*) _tmp42_;
										worm_set_start (_tmp43_, j, i, WORM_DIRECTION_DOWN);
										_g_object_unref0 (_tmp43_);
										_tmp44_ = count;
										count = _tmp44_ + 1;
									}
									break;
								}
								case 9654U:
								case 'p':
								{
									gint* _tmp45_;
									gint _tmp45__length1;
									gint _tmp45__length2;
									gint _tmp46_;
									_tmp45_ = self->board;
									_tmp45__length1 = self->board_length1;
									_tmp45__length2 = self->board_length2;
									_tmp45_[(j * _tmp45__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
									_tmp46_ = self->priv->_numworms;
									if (count < _tmp46_) {
										GeeLinkedList* _tmp47_;
										gpointer _tmp48_;
										Worm* _tmp49_;
										gint _tmp50_;
										_tmp47_ = self->priv->_worms;
										_tmp48_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, count);
										_tmp49_ = (Worm*) _tmp48_;
										worm_set_start (_tmp49_, j, i, WORM_DIRECTION_RIGHT);
										_g_object_unref0 (_tmp49_);
										_tmp50_ = count;
										count = _tmp50_ + 1;
									}
									break;
								}
								case 'Q':
								case 'R':
								case 'S':
								case 'T':
								case 'U':
								case 'V':
								case 'W':
								case 'X':
								case 'Y':
								case 'Z':
								{
									gboolean _tmp51_ = FALSE;
									gint* _tmp52_;
									gint _tmp52__length1;
									gint _tmp52__length2;
									WarpManager* _tmp53_;
									gint* _tmp54_;
									gint _tmp54__length1;
									gint _tmp54__length2;
									gint _tmp55_;
									gint* _tmp56_;
									gint _tmp56__length1;
									gint _tmp56__length2;
									gint* _tmp57_;
									gint _tmp57__length1;
									gint _tmp57__length2;
									gint* _tmp58_;
									gint _tmp58__length1;
									gint _tmp58__length2;
									gint* _tmp59_;
									gint _tmp59__length1;
									gint _tmp59__length2;
									if (((gint) j) == 0) {
										_tmp51_ = TRUE;
									} else {
										_tmp51_ = ((gint) i) == 0;
									}
									if (_tmp51_) {
										result = FALSE;
										_g_free0 (tmpboard);
										return result;
									}
									_tmp52_ = self->board;
									_tmp52__length1 = self->board_length1;
									_tmp52__length2 = self->board_length2;
									_tmp52_[(j * _tmp52__length2) + i] = (gint) char_value;
									_tmp53_ = self->priv->warp_manager;
									_tmp54_ = self->board;
									_tmp54__length1 = self->board_length1;
									_tmp54__length2 = self->board_length2;
									_tmp55_ = _tmp54_[(j * _tmp54__length2) + i];
									warp_manager_add_warp_source (_tmp53_, _tmp55_, (guint8) (j - 1), (guint8) (i - 1));
									_tmp56_ = self->board;
									_tmp56__length1 = self->board_length1;
									_tmp56__length2 = self->board_length2;
									_tmp56_[((j - 1) * _tmp56__length2) + (i - 1)] = (gint) NIBBLES_GAME_WARPCHAR;
									_tmp57_ = self->board;
									_tmp57__length1 = self->board_length1;
									_tmp57__length2 = self->board_length2;
									_tmp57_[(j * _tmp57__length2) + (i - 1)] = (gint) NIBBLES_GAME_WARPCHAR;
									_tmp58_ = self->board;
									_tmp58__length1 = self->board_length1;
									_tmp58__length2 = self->board_length2;
									_tmp58_[((j - 1) * _tmp58__length2) + i] = (gint) NIBBLES_GAME_WARPCHAR;
									_tmp59_ = self->board;
									_tmp59__length1 = self->board_length1;
									_tmp59__length2 = self->board_length2;
									_tmp59_[(j * _tmp59__length2) + i] = (gint) NIBBLES_GAME_WARPCHAR;
									g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_WARP_ADDED_SIGNAL], 0, (guint8) (j - 1), (guint8) (i - 1));
									break;
								}
								case 'r':
								case 's':
								case 't':
								case 'u':
								case 'v':
								case 'w':
								case 'x':
								case 'y':
								case 'z':
								{
									WarpManager* _tmp60_;
									gint* _tmp61_;
									gint _tmp61__length1;
									gint _tmp61__length2;
									_tmp60_ = self->priv->warp_manager;
									warp_manager_add_warp_target (_tmp60_, (((gint) char_value) - ((gint) 'a')) + ((gint) 'A'), j, i);
									_tmp61_ = self->board;
									_tmp61__length1 = self->board_length1;
									_tmp61__length2 = self->board_length2;
									_tmp61_[(j * _tmp61__length2) + i] = (gint) NIBBLES_GAME_EMPTYCHAR;
									break;
								}
								case 'a':
								case 'b':
								case 'c':
								case 'd':
								case 'e':
								case 'f':
								case 'g':
								case 'h':
								case 'i':
								case 'j':
								case 'k':
								case 'l':
								{
									gint* _tmp62_;
									gint _tmp62__length1;
									gint _tmp62__length2;
									_tmp62_ = self->board;
									_tmp62__length1 = self->board_length1;
									_tmp62__length2 = self->board_length2;
									_tmp62_[(j * _tmp62__length2) + i] = (gint) char_value;
									break;
								}
								default:
								{
									result = FALSE;
									_g_free0 (tmpboard);
									return result;
								}
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	_g_free0 (tmpboard);
	return result;
}

static gboolean
__lambda11_ (NibblesGame* self)
{
	gboolean result;
	self->priv->bonus_cycle = (guint8) ((self->priv->bonus_cycle + 1) % 3);
	if (((gint) self->priv->bonus_cycle) == 0) {
		nibbles_game_add_bonus (self, FALSE);
	}
	result = nibbles_game_main_loop_cb (self);
	return result;
}

static gboolean
___lambda11__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda11_ ((NibblesGame*) self);
	return result;
}

void
nibbles_game_start (NibblesGame* self,
                    gboolean add_initial_bonus)
{
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	if (add_initial_bonus) {
		nibbles_game_add_bonus (self, TRUE);
	}
	nibbles_game_set_is_running (self, TRUE);
	_tmp0_ = self->priv->_gamedelay;
	_tmp1_ = self->priv->_speed;
	self->priv->main_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (_tmp0_ * _tmp1_), ___lambda11__gsource_func, g_object_ref (self), g_object_unref);
	g_source_set_name_by_id (self->priv->main_id, "[Nibbles] main_loop_cb");
}

void
nibbles_game_stop (NibblesGame* self)
{
	g_return_if_fail (self != NULL);
	nibbles_game_set_is_running (self, FALSE);
	if (self->priv->main_id == ((guint) 0)) {
		return;
	}
	g_source_remove (self->priv->main_id);
	self->priv->main_id = (guint) 0;
}

inline void
nibbles_game_reset (NibblesGame* self,
                    gint start_level)
{
	g_return_if_fail (self != NULL);
	nibbles_game_set_skip_score (self, start_level != 1);
	nibbles_game_set_current_level (self, start_level);
	nibbles_game_set_is_paused (self, FALSE);
}

static void
nibbles_game_end (NibblesGame* self)
{
	g_return_if_fail (self != NULL);
	nibbles_game_stop (self);
	g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL], 0);
}

static gboolean
_game_status_equal (const GameStatus * s1,
                    const GameStatus * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static gboolean
nibbles_game_main_loop_cb (NibblesGame* self)
{
	GameStatus* status = NULL;
	GameStatus* _tmp0_;
	GameStatus* _tmp1_;
	GameStatus _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = nibbles_game_get_game_status (self);
	status = _tmp0_;
	_tmp1_ = status;
	_tmp2_ = GAME_STATUS_GAMEOVER;
	if (_game_status_equal (_tmp1_, &_tmp2_) == TRUE) {
		GeeLinkedList* _tmp3_;
		gpointer _tmp4_;
		Worm* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		nibbles_game_end (self);
		_tmp3_ = self->priv->_worms;
		_tmp4_ = gee_linked_list_first (_tmp3_);
		_tmp5_ = (Worm*) _tmp4_;
		_tmp6_ = worm_get_score (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = self->priv->_current_level;
		g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL], 0, _tmp7_, _tmp8_);
		_g_object_unref0 (_tmp5_);
		result = G_SOURCE_REMOVE;
		_g_free0 (status);
		return result;
	} else {
		GameStatus* _tmp9_;
		GameStatus _tmp10_;
		_tmp9_ = status;
		_tmp10_ = GAME_STATUS_VICTORY;
		if (_game_status_equal (_tmp9_, &_tmp10_) == TRUE) {
			Worm* winner = NULL;
			Worm* _tmp11_;
			Worm* _tmp12_;
			Worm* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			nibbles_game_end (self);
			_tmp11_ = nibbles_game_get_winner (self);
			winner = _tmp11_;
			_tmp12_ = winner;
			if (_tmp12_ == NULL) {
				result = G_SOURCE_REMOVE;
				_g_object_unref0 (winner);
				_g_free0 (status);
				return result;
			}
			_tmp13_ = winner;
			_tmp14_ = worm_get_score (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = self->priv->_current_level;
			g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL], 0, _tmp15_, _tmp16_);
			result = G_SOURCE_REMOVE;
			_g_object_unref0 (winner);
			_g_free0 (status);
			return result;
		} else {
			GameStatus* _tmp17_;
			GameStatus _tmp18_;
			_tmp17_ = status;
			_tmp18_ = GAME_STATUS_NEWROUND;
			if (_game_status_equal (_tmp17_, &_tmp18_) == TRUE) {
				gint _tmp19_;
				gint _tmp20_;
				nibbles_game_stop (self);
				g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL], 0);
				g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LEVEL_COMPLETED_SIGNAL], 0);
				_tmp19_ = self->priv->_current_level;
				nibbles_game_set_current_level (self, _tmp19_ + 1);
				_tmp20_ = self->priv->_current_level;
				if (_tmp20_ == (NIBBLES_GAME_MAX_LEVEL + 1)) {
					GeeLinkedList* _tmp21_;
					gpointer _tmp22_;
					Worm* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					gint _tmp26_;
					_tmp21_ = self->priv->_worms;
					_tmp22_ = gee_linked_list_first (_tmp21_);
					_tmp23_ = (Worm*) _tmp22_;
					_tmp24_ = worm_get_score (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = self->priv->_current_level;
					g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL], 0, _tmp25_, _tmp26_);
					_g_object_unref0 (_tmp23_);
				}
				result = G_SOURCE_REMOVE;
				_g_free0 (status);
				return result;
			}
		}
	}
	nibbles_game_move_worms (self);
	result = G_SOURCE_CONTINUE;
	_g_free0 (status);
	return result;
}

static GeeList*
_nibbles_game_get_other_worms_worm_get_other_worms_type (Worm* _self_,
                                                         gpointer self)
{
	GeeList* result;
	result = nibbles_game_get_other_worms ((NibblesGame*) self, _self_);
	return result;
}

static GeeList*
_nibbles_game_get_bonuses_worm_get_bonuses_type (gpointer self)
{
	GeeList* result;
	result = nibbles_game_get_bonuses ((NibblesGame*) self);
	return result;
}

static void
_nibbles_game_bonus_found_cb_worm_bonus_found (Worm* _sender,
                                               gpointer self)
{
	nibbles_game_bonus_found_cb ((NibblesGame*) self, _sender);
}

void
nibbles_game_create_worms (NibblesGame* self,
                           GeeArrayList* worm_settings)
{
	GeeLinkedList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_worms;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = self->priv->_numai;
	_tmp2_ = self->priv->_numhumans;
	nibbles_game_set_numworms (self, _tmp1_ + _tmp2_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				Worm* worm = NULL;
				guint8 _tmp6_;
				guint8 _tmp7_;
				Worm* _tmp8_;
				Worm* _tmp9_;
				Worm* _tmp10_;
				gint _tmp11_;
				GeeLinkedList* _tmp12_;
				Worm* _tmp13_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_numworms;
				if (!(i < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->_width;
				_tmp7_ = self->priv->_height;
				_tmp8_ = worm_new (i, _tmp6_, _tmp7_, _nibbles_game_get_other_worms_worm_get_other_worms_type, self, _nibbles_game_get_bonuses_worm_get_bonuses_type, self);
				worm = _tmp8_;
				_tmp9_ = worm;
				g_signal_connect_object (_tmp9_, "bonus-found", (GCallback) _nibbles_game_bonus_found_cb_worm_bonus_found, self, 0);
				_tmp10_ = worm;
				_tmp11_ = self->priv->_numhumans;
				_tmp10_->is_human = i < _tmp11_;
				_tmp12_ = self->priv->_worms;
				_tmp13_ = worm;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
				_g_object_unref0 (worm);
			}
		}
	}
	if (worm_settings != NULL) {
		nibbles_game_load_worm_properties (self, worm_settings);
	}
}

void
nibbles_game_add_worms (NibblesGame* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_worm_list = _tmp0_;
		_tmp1_ = _worm_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_worm_size = _tmp3_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			Worm* _tmp8_;
			_worm_index = _worm_index + 1;
			_tmp4_ = _worm_index;
			_tmp5_ = _worm_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _worm_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _worm_index);
			worm = (Worm*) _tmp7_;
			_tmp8_ = worm;
			worm_spawn (_tmp8_);
			_g_object_unref0 (worm);
		}
	}
}

static void
nibbles_game_move_worms (NibblesGame* self)
{
	Boni* _tmp13_;
	guint8 missed_bonuses_to_replace = 0U;
	Boni* _tmp28_;
	guint8 _tmp29_ = 0U;
	GeeLinkedList* dead_worms = NULL;
	GeeLinkedList* _tmp32_;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_worm_list = _tmp0_;
		_tmp1_ = _worm_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_worm_size = _tmp3_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			Worm* _tmp8_;
			Worm* _tmp10_;
			_worm_index = _worm_index + 1;
			_tmp4_ = _worm_index;
			_tmp5_ = _worm_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _worm_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _worm_index);
			worm = (Worm*) _tmp7_;
			_tmp8_ = worm;
			if (_tmp8_->rounds_to_stay_still == 1) {
				Worm* _tmp9_;
				_tmp9_ = worm;
				_tmp9_->is_stopped = FALSE;
			}
			_tmp10_ = worm;
			if (_tmp10_->rounds_to_stay_still > 0) {
				Worm* _tmp11_;
				gint _tmp12_;
				_tmp11_ = worm;
				_tmp11_->rounds_to_stay_still = _tmp11_->rounds_to_stay_still - 1;
				_tmp12_ = _tmp11_->rounds_to_stay_still;
			}
			_g_object_unref0 (worm);
		}
	}
	_tmp13_ = self->priv->boni;
	if (boni_too_many_missed (_tmp13_)) {
		{
			GeeLinkedList* _worm_list = NULL;
			GeeLinkedList* _tmp14_;
			gint _worm_size = 0;
			GeeLinkedList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _worm_index = 0;
			_tmp14_ = self->priv->_worms;
			_worm_list = _tmp14_;
			_tmp15_ = _worm_list;
			_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
			_tmp17_ = _tmp16_;
			_worm_size = _tmp17_;
			_worm_index = -1;
			while (TRUE) {
				gint _tmp18_;
				gint _tmp19_;
				Worm* worm = NULL;
				GeeLinkedList* _tmp20_;
				gpointer _tmp21_;
				Worm* _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				_worm_index = _worm_index + 1;
				_tmp18_ = _worm_index;
				_tmp19_ = _worm_size;
				if (!(_tmp18_ < _tmp19_)) {
					break;
				}
				_tmp20_ = _worm_list;
				_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _worm_index);
				worm = (Worm*) _tmp21_;
				_tmp22_ = worm;
				_tmp23_ = worm_get_score (_tmp22_);
				_tmp24_ = _tmp23_;
				if (_tmp24_ > 0) {
					Worm* _tmp25_;
					gint _tmp26_;
					gint _tmp27_;
					_tmp25_ = worm;
					_tmp26_ = worm_get_score (_tmp25_);
					_tmp27_ = _tmp26_;
					worm_set_score (_tmp25_, _tmp27_ - 1);
				}
				_g_object_unref0 (worm);
			}
		}
	}
	_tmp28_ = self->priv->boni;
	boni_on_worms_move (_tmp28_, &_tmp29_);
	missed_bonuses_to_replace = _tmp29_;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp30_ = FALSE;
			_tmp30_ = TRUE;
			while (TRUE) {
				if (!_tmp30_) {
					guint8 _tmp31_;
					_tmp31_ = i;
					i = _tmp31_ + 1;
				}
				_tmp30_ = FALSE;
				if (!(i < missed_bonuses_to_replace)) {
					break;
				}
				nibbles_game_add_bonus (self, TRUE);
			}
		}
	}
	_tmp32_ = gee_linked_list_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	dead_worms = _tmp32_;
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp33_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		gint _worm_index = 0;
		_tmp33_ = self->priv->_worms;
		_worm_list = _tmp33_;
		_tmp34_ = _worm_list;
		_tmp35_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp34_);
		_tmp36_ = _tmp35_;
		_worm_size = _tmp36_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp37_;
			gint _tmp38_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp39_;
			gpointer _tmp40_;
			gboolean _tmp41_ = FALSE;
			Worm* _tmp42_;
			Worm* _tmp47_;
			_worm_index = _worm_index + 1;
			_tmp37_ = _worm_index;
			_tmp38_ = _worm_size;
			if (!(_tmp37_ < _tmp38_)) {
				break;
			}
			_tmp39_ = _worm_list;
			_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, _worm_index);
			worm = (Worm*) _tmp40_;
			_tmp42_ = worm;
			if (_tmp42_->is_stopped) {
				_tmp41_ = TRUE;
			} else {
				Worm* _tmp43_;
				WormPositions* _tmp44_;
				gboolean _tmp45_;
				gboolean _tmp46_;
				_tmp43_ = worm;
				_tmp44_ = _tmp43_->list;
				_tmp45_ = gee_collection_get_is_empty ((GeeCollection*) _tmp44_);
				_tmp46_ = _tmp45_;
				_tmp41_ = _tmp46_;
			}
			if (_tmp41_) {
				_g_object_unref0 (worm);
				continue;
			}
			_tmp47_ = worm;
			if (!_tmp47_->is_human) {
				Worm* _tmp48_;
				gint* _tmp49_;
				gint _tmp49__length1;
				gint _tmp49__length2;
				GeeLinkedList* _tmp50_;
				_tmp48_ = worm;
				_tmp49_ = self->board;
				_tmp49__length1 = self->board_length1;
				_tmp49__length2 = self->board_length2;
				_tmp50_ = self->priv->_worms;
				worm_ai_move (_tmp48_, _tmp49_, (gint) _tmp49__length1, (gint) _tmp49__length2, _tmp50_);
			}
			_g_object_unref0 (worm);
		}
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp51_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _worm_index = 0;
		_tmp51_ = self->priv->_worms;
		_worm_list = _tmp51_;
		_tmp52_ = _worm_list;
		_tmp53_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp52_);
		_tmp54_ = _tmp53_;
		_worm_size = _tmp54_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp55_;
			gint _tmp56_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp57_;
			gpointer _tmp58_;
			gboolean _tmp59_ = FALSE;
			Worm* _tmp60_;
			Position position = {0};
			Worm* _tmp65_;
			Position _tmp66_ = {0};
			guint8 target_x = 0U;
			guint8 target_y = 0U;
			gboolean _tmp67_ = FALSE;
			Worm* _tmp68_;
			WormDirection _tmp69_;
			WormDirection _tmp70_;
			WarpManager* _tmp74_;
			Position _tmp75_;
			Position _tmp76_;
			guint8 _tmp77_ = 0U;
			guint8 _tmp78_ = 0U;
			gboolean _tmp79_;
			Worm* _tmp81_;
			gint* _tmp82_;
			gint _tmp82__length1;
			gint _tmp82__length2;
			GeeLinkedList* _tmp83_;
			Position _tmp84_;
			_worm_index = _worm_index + 1;
			_tmp55_ = _worm_index;
			_tmp56_ = _worm_size;
			if (!(_tmp55_ < _tmp56_)) {
				break;
			}
			_tmp57_ = _worm_list;
			_tmp58_ = gee_abstract_list_get ((GeeAbstractList*) _tmp57_, _worm_index);
			worm = (Worm*) _tmp58_;
			_tmp60_ = worm;
			if (_tmp60_->is_stopped) {
				_tmp59_ = TRUE;
			} else {
				Worm* _tmp61_;
				WormPositions* _tmp62_;
				gboolean _tmp63_;
				gboolean _tmp64_;
				_tmp61_ = worm;
				_tmp62_ = _tmp61_->list;
				_tmp63_ = gee_collection_get_is_empty ((GeeCollection*) _tmp62_);
				_tmp64_ = _tmp63_;
				_tmp59_ = _tmp64_;
			}
			if (_tmp59_) {
				_g_object_unref0 (worm);
				continue;
			}
			_tmp65_ = worm;
			worm_position_move (_tmp65_, &_tmp66_);
			position = _tmp66_;
			_tmp68_ = worm;
			_tmp69_ = worm_get_direction (_tmp68_);
			_tmp70_ = _tmp69_;
			if (_tmp70_ == WORM_DIRECTION_LEFT) {
				_tmp67_ = TRUE;
			} else {
				Worm* _tmp71_;
				WormDirection _tmp72_;
				WormDirection _tmp73_;
				_tmp71_ = worm;
				_tmp72_ = worm_get_direction (_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp67_ = _tmp73_ == WORM_DIRECTION_RIGHT;
			}
			_tmp74_ = self->priv->warp_manager;
			_tmp75_ = position;
			_tmp76_ = position;
			_tmp79_ = warp_manager_get_warp_target (_tmp74_, _tmp75_.x, _tmp76_.y, _tmp67_, &_tmp77_, &_tmp78_);
			target_x = _tmp77_;
			target_y = _tmp78_;
			if (_tmp79_) {
				Position _tmp80_ = {0};
				memset (&_tmp80_, 0, sizeof (Position));
				_tmp80_.x = target_x;
				_tmp80_.y = target_y;
				position = _tmp80_;
			}
			_tmp81_ = worm;
			_tmp82_ = self->board;
			_tmp82__length1 = self->board_length1;
			_tmp82__length2 = self->board_length2;
			_tmp83_ = self->priv->_worms;
			_tmp84_ = position;
			if (!worm_can_move_to (_tmp81_, _tmp82_, (gint) _tmp82__length1, (gint) _tmp82__length2, _tmp83_, &_tmp84_)) {
				GeeLinkedList* _tmp85_;
				Worm* _tmp86_;
				_tmp85_ = dead_worms;
				_tmp86_ = worm;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp85_, _tmp86_);
				g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "crash");
			}
			_g_object_unref0 (worm);
		}
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp87_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
		gint _worm_index = 0;
		_tmp87_ = self->priv->_worms;
		_worm_list = _tmp87_;
		_tmp88_ = _worm_list;
		_tmp89_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp88_);
		_tmp90_ = _tmp89_;
		_worm_size = _tmp90_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp91_;
			gint _tmp92_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp93_;
			gpointer _tmp94_;
			gboolean _tmp95_ = FALSE;
			gboolean _tmp96_ = FALSE;
			Worm* _tmp97_;
			Worm* _tmp104_;
			gint* _tmp105_;
			gint _tmp105__length1;
			gint _tmp105__length2;
			Worm* _tmp106_;
			Position _tmp107_ = {0};
			Position _tmp108_;
			Worm* _tmp109_;
			Position _tmp110_ = {0};
			Position _tmp111_;
			gint _tmp112_;
			_worm_index = _worm_index + 1;
			_tmp91_ = _worm_index;
			_tmp92_ = _worm_size;
			if (!(_tmp91_ < _tmp92_)) {
				break;
			}
			_tmp93_ = _worm_list;
			_tmp94_ = gee_abstract_list_get ((GeeAbstractList*) _tmp93_, _worm_index);
			worm = (Worm*) _tmp94_;
			_tmp97_ = worm;
			if (_tmp97_->is_stopped) {
				_tmp96_ = TRUE;
			} else {
				Worm* _tmp98_;
				WormPositions* _tmp99_;
				gboolean _tmp100_;
				gboolean _tmp101_;
				_tmp98_ = worm;
				_tmp99_ = _tmp98_->list;
				_tmp100_ = gee_collection_get_is_empty ((GeeCollection*) _tmp99_);
				_tmp101_ = _tmp100_;
				_tmp96_ = _tmp101_;
			}
			if (_tmp96_) {
				_tmp95_ = TRUE;
			} else {
				GeeLinkedList* _tmp102_;
				Worm* _tmp103_;
				_tmp102_ = dead_worms;
				_tmp103_ = worm;
				_tmp95_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp102_, _tmp103_);
			}
			if (_tmp95_) {
				_g_object_unref0 (worm);
				continue;
			}
			_tmp104_ = worm;
			worm_move_part_1 (_tmp104_);
			_tmp105_ = self->board;
			_tmp105__length1 = self->board_length1;
			_tmp105__length2 = self->board_length2;
			_tmp106_ = worm;
			worm_get_head (_tmp106_, &_tmp107_);
			_tmp108_ = _tmp107_;
			_tmp109_ = worm;
			worm_get_head (_tmp109_, &_tmp110_);
			_tmp111_ = _tmp110_;
			_tmp112_ = _tmp105_[(_tmp108_.x * _tmp105__length2) + _tmp111_.y];
			if (_tmp112_ == ((gint) NIBBLES_GAME_WARPCHAR)) {
				guint8 target_x = 0U;
				guint8 target_y = 0U;
				gboolean _tmp113_ = FALSE;
				Worm* _tmp114_;
				WormDirection _tmp115_;
				WormDirection _tmp116_;
				WarpManager* _tmp120_;
				Worm* _tmp121_;
				Position _tmp122_ = {0};
				Position _tmp123_;
				Worm* _tmp124_;
				Position _tmp125_ = {0};
				Position _tmp126_;
				guint8 _tmp127_ = 0U;
				guint8 _tmp128_ = 0U;
				gboolean _tmp129_;
				Worm* _tmp130_;
				Position _tmp131_ = {0};
				_tmp114_ = worm;
				_tmp115_ = worm_get_direction (_tmp114_);
				_tmp116_ = _tmp115_;
				if (_tmp116_ == WORM_DIRECTION_LEFT) {
					_tmp113_ = TRUE;
				} else {
					Worm* _tmp117_;
					WormDirection _tmp118_;
					WormDirection _tmp119_;
					_tmp117_ = worm;
					_tmp118_ = worm_get_direction (_tmp117_);
					_tmp119_ = _tmp118_;
					_tmp113_ = _tmp119_ == WORM_DIRECTION_RIGHT;
				}
				_tmp120_ = self->priv->warp_manager;
				_tmp121_ = worm;
				worm_get_head (_tmp121_, &_tmp122_);
				_tmp123_ = _tmp122_;
				_tmp124_ = worm;
				worm_get_head (_tmp124_, &_tmp125_);
				_tmp126_ = _tmp125_;
				_tmp129_ = warp_manager_get_warp_target (_tmp120_, _tmp123_.x, _tmp126_.y, _tmp113_, &_tmp127_, &_tmp128_);
				target_x = _tmp127_;
				target_y = _tmp128_;
				if (!_tmp129_) {
					g_assert_not_reached ();
				}
				_tmp130_ = worm;
				memset (&_tmp131_, 0, sizeof (Position));
				_tmp131_.x = target_x;
				_tmp131_.y = target_y;
				worm_move_part_2 (_tmp130_, &_tmp131_);
			} else {
				Worm* _tmp132_;
				_tmp132_ = worm;
				worm_move_part_2 (_tmp132_, NULL);
			}
			{
				GeeLinkedList* _other_worm_list = NULL;
				GeeLinkedList* _tmp133_;
				gint _other_worm_size = 0;
				GeeLinkedList* _tmp134_;
				gint _tmp135_;
				gint _tmp136_;
				gint _other_worm_index = 0;
				_tmp133_ = self->priv->_worms;
				_other_worm_list = _tmp133_;
				_tmp134_ = _other_worm_list;
				_tmp135_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp134_);
				_tmp136_ = _tmp135_;
				_other_worm_size = _tmp136_;
				_other_worm_index = -1;
				while (TRUE) {
					gint _tmp137_;
					gint _tmp138_;
					Worm* other_worm = NULL;
					GeeLinkedList* _tmp139_;
					gpointer _tmp140_;
					gboolean _tmp141_ = FALSE;
					gboolean _tmp142_ = FALSE;
					gboolean _tmp143_ = FALSE;
					gboolean _tmp144_ = FALSE;
					Worm* _tmp145_;
					Worm* _tmp146_;
					_other_worm_index = _other_worm_index + 1;
					_tmp137_ = _other_worm_index;
					_tmp138_ = _other_worm_size;
					if (!(_tmp137_ < _tmp138_)) {
						break;
					}
					_tmp139_ = _other_worm_list;
					_tmp140_ = gee_abstract_list_get ((GeeAbstractList*) _tmp139_, _other_worm_index);
					other_worm = (Worm*) _tmp140_;
					_tmp145_ = worm;
					_tmp146_ = other_worm;
					if (_tmp145_ != _tmp146_) {
						Worm* _tmp147_;
						_tmp147_ = other_worm;
						_tmp144_ = !_tmp147_->is_stopped;
					} else {
						_tmp144_ = FALSE;
					}
					if (_tmp144_) {
						Worm* _tmp148_;
						WormPositions* _tmp149_;
						gboolean _tmp150_;
						gboolean _tmp151_;
						_tmp148_ = other_worm;
						_tmp149_ = _tmp148_->list;
						_tmp150_ = gee_collection_get_is_empty ((GeeCollection*) _tmp149_);
						_tmp151_ = _tmp150_;
						_tmp143_ = !_tmp151_;
					} else {
						_tmp143_ = FALSE;
					}
					if (_tmp143_) {
						Worm* _tmp152_;
						Position _tmp153_ = {0};
						Position _tmp154_;
						Worm* _tmp155_;
						Position _tmp156_ = {0};
						Position _tmp157_;
						_tmp152_ = worm;
						worm_get_head (_tmp152_, &_tmp153_);
						_tmp154_ = _tmp153_;
						_tmp155_ = other_worm;
						worm_get_head (_tmp155_, &_tmp156_);
						_tmp157_ = _tmp156_;
						_tmp142_ = _tmp154_.x == _tmp157_.x;
					} else {
						_tmp142_ = FALSE;
					}
					if (_tmp142_) {
						Worm* _tmp158_;
						Position _tmp159_ = {0};
						Position _tmp160_;
						Worm* _tmp161_;
						Position _tmp162_ = {0};
						Position _tmp163_;
						_tmp158_ = worm;
						worm_get_head (_tmp158_, &_tmp159_);
						_tmp160_ = _tmp159_;
						_tmp161_ = other_worm;
						worm_get_head (_tmp161_, &_tmp162_);
						_tmp163_ = _tmp162_;
						_tmp141_ = _tmp160_.y == _tmp163_.y;
					} else {
						_tmp141_ = FALSE;
					}
					if (_tmp141_) {
						GeeLinkedList* _tmp164_;
						Worm* _tmp165_;
						GeeLinkedList* _tmp168_;
						Worm* _tmp169_;
						_tmp164_ = dead_worms;
						_tmp165_ = worm;
						if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp164_, _tmp165_)) {
							GeeLinkedList* _tmp166_;
							Worm* _tmp167_;
							_tmp166_ = dead_worms;
							_tmp167_ = worm;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp166_, _tmp167_);
						}
						_tmp168_ = dead_worms;
						_tmp169_ = other_worm;
						if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp168_, _tmp169_)) {
							GeeLinkedList* _tmp170_;
							Worm* _tmp171_;
							_tmp170_ = dead_worms;
							_tmp171_ = other_worm;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp170_, _tmp171_);
						}
					}
					_g_object_unref0 (other_worm);
				}
			}
			_g_object_unref0 (worm);
		}
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp172_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp173_;
		gint _tmp174_;
		gint _tmp175_;
		gint _worm_index = 0;
		_tmp172_ = dead_worms;
		_worm_list = _tmp172_;
		_tmp173_ = _worm_list;
		_tmp174_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp173_);
		_tmp175_ = _tmp174_;
		_worm_size = _tmp175_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp176_;
			gint _tmp177_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp178_;
			gpointer _tmp179_;
			gint _tmp180_;
			Worm* _tmp185_;
			guint8 _tmp186_;
			guint8 _tmp187_;
			_worm_index = _worm_index + 1;
			_tmp176_ = _worm_index;
			_tmp177_ = _worm_size;
			if (!(_tmp176_ < _tmp177_)) {
				break;
			}
			_tmp178_ = _worm_list;
			_tmp179_ = gee_abstract_list_get ((GeeAbstractList*) _tmp178_, _worm_index);
			worm = (Worm*) _tmp179_;
			_tmp180_ = self->priv->_numworms;
			if (_tmp180_ > 1) {
				Worm* _tmp181_;
				Worm* _tmp182_;
				gint _tmp183_;
				gint _tmp184_;
				_tmp181_ = worm;
				_tmp182_ = worm;
				_tmp183_ = worm_get_score (_tmp182_);
				_tmp184_ = _tmp183_;
				worm_set_score (_tmp181_, (_tmp184_ * 7) / 10);
			}
			_tmp185_ = worm;
			_tmp186_ = worm_get_lives (_tmp185_);
			_tmp187_ = _tmp186_;
			if (((gint) _tmp187_) > 0) {
				Worm* _tmp188_;
				_tmp188_ = worm;
				worm_reset (_tmp188_);
			}
			_g_object_unref0 (worm);
		}
	}
	g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_REDRAW_SIGNAL], 0, TRUE);
	_g_object_unref0 (dead_worms);
}

static void
nibbles_game_reverse_worms (NibblesGame* self,
                            Worm* worm)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	{
		GeeLinkedList* _other_worm_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _other_worm_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _other_worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_other_worm_list = _tmp0_;
		_tmp1_ = _other_worm_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_other_worm_size = _tmp3_;
		_other_worm_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Worm* other_worm = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			Worm* _tmp8_;
			_other_worm_index = _other_worm_index + 1;
			_tmp4_ = _other_worm_index;
			_tmp5_ = _other_worm_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _other_worm_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _other_worm_index);
			other_worm = (Worm*) _tmp7_;
			_tmp8_ = other_worm;
			if (worm != _tmp8_) {
				Worm* _tmp9_;
				_tmp9_ = other_worm;
				worm_reverse (_tmp9_);
			}
			_g_object_unref0 (other_worm);
		}
	}
}

static gboolean
nibbles_game_is_space_empty (NibblesGame* self,
                             guint8 x,
                             guint8 y,
                             gboolean* worms_at,
                             gint worms_at_length1,
                             gint worms_at_length2)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gint* _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	gint _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp11_ = self->board;
	_tmp11__length1 = self->board_length1;
	_tmp11__length2 = self->board_length2;
	_tmp12_ = _tmp11_[(x * _tmp11__length2) + y];
	if (((gint) NIBBLES_GAME_EMPTYCHAR) == _tmp12_) {
		gint* _tmp13_;
		gint _tmp13__length1;
		gint _tmp13__length2;
		gint _tmp14_;
		_tmp13_ = self->board;
		_tmp13__length1 = self->board_length1;
		_tmp13__length2 = self->board_length2;
		_tmp14_ = _tmp13_[((x + 1) * _tmp13__length2) + (y + 1)];
		_tmp10_ = ((gint) NIBBLES_GAME_EMPTYCHAR) == _tmp14_;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		gint* _tmp15_;
		gint _tmp15__length1;
		gint _tmp15__length2;
		gint _tmp16_;
		_tmp15_ = self->board;
		_tmp15__length1 = self->board_length1;
		_tmp15__length2 = self->board_length2;
		_tmp16_ = _tmp15_[((x + 1) * _tmp15__length2) + y];
		_tmp9_ = ((gint) NIBBLES_GAME_EMPTYCHAR) == _tmp16_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gint* _tmp17_;
		gint _tmp17__length1;
		gint _tmp17__length2;
		gint _tmp18_;
		_tmp17_ = self->board;
		_tmp17__length1 = self->board_length1;
		_tmp17__length2 = self->board_length2;
		_tmp18_ = _tmp17_[(x * _tmp17__length2) + (y + 1)];
		_tmp8_ = ((gint) NIBBLES_GAME_EMPTYCHAR) == _tmp18_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		Boni* _tmp19_;
		Bonus* _tmp20_;
		Bonus* _tmp21_;
		_tmp19_ = self->priv->boni;
		_tmp20_ = boni_get_bonus (_tmp19_, x, y);
		_tmp21_ = _tmp20_;
		_tmp7_ = _tmp21_ == NULL;
		_g_object_unref0 (_tmp21_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		Boni* _tmp22_;
		Bonus* _tmp23_;
		Bonus* _tmp24_;
		_tmp22_ = self->priv->boni;
		_tmp23_ = boni_get_bonus (_tmp22_, (guint8) (x + 1), (guint8) (y + 1));
		_tmp24_ = _tmp23_;
		_tmp6_ = _tmp24_ == NULL;
		_g_object_unref0 (_tmp24_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		Boni* _tmp25_;
		Bonus* _tmp26_;
		Bonus* _tmp27_;
		_tmp25_ = self->priv->boni;
		_tmp26_ = boni_get_bonus (_tmp25_, (guint8) (x + 1), y);
		_tmp27_ = _tmp26_;
		_tmp5_ = _tmp27_ == NULL;
		_g_object_unref0 (_tmp27_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		Boni* _tmp28_;
		Bonus* _tmp29_;
		Bonus* _tmp30_;
		_tmp28_ = self->priv->boni;
		_tmp29_ = boni_get_bonus (_tmp28_, x, (guint8) (y + 1));
		_tmp30_ = _tmp29_;
		_tmp4_ = _tmp30_ == NULL;
		_g_object_unref0 (_tmp30_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp31_;
		_tmp31_ = worms_at[(x * worms_at_length2) + y];
		_tmp3_ = !_tmp31_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp32_;
		_tmp32_ = worms_at[((x + 1) * worms_at_length2) + (y + 1)];
		_tmp2_ = !_tmp32_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp33_;
		_tmp33_ = worms_at[((x + 1) * worms_at_length2) + y];
		_tmp1_ = !_tmp33_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp34_;
		_tmp34_ = worms_at[(x * worms_at_length2) + (y + 1)];
		_tmp0_ = !_tmp34_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
nibbles_game_add_bonus (NibblesGame* self,
                        gboolean regular)
{
	gboolean good = FALSE;
	guint8 x = 0U;
	guint8 y = 0U;
	gboolean* worms_at = NULL;
	guint8 _tmp0_;
	guint8 _tmp1_;
	gboolean* _tmp2_;
	gint worms_at_length1;
	gint worms_at_length2;
	g_return_if_fail (self != NULL);
	good = FALSE;
	x = (guint8) 0;
	y = (guint8) 0;
	_tmp0_ = self->priv->_width;
	_tmp1_ = self->priv->_height;
	_tmp2_ = g_new0 (gboolean, _tmp0_ * _tmp1_);
	worms_at = _tmp2_;
	worms_at_length1 = _tmp0_;
	worms_at_length2 = _tmp1_;
	if (!regular) {
		if (g_random_int_range ((gint32) 0, (gint32) 50) != ((gint32) 0)) {
			worms_at = (g_free (worms_at), NULL);
			return;
		}
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp3_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _worm_index = 0;
		_tmp3_ = self->priv->_worms;
		_worm_list = _tmp3_;
		_tmp4_ = _worm_list;
		_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_worm_size = _tmp6_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp9_;
			gpointer _tmp10_;
			Worm* _tmp11_;
			_worm_index = _worm_index + 1;
			_tmp7_ = _worm_index;
			_tmp8_ = _worm_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _worm_list;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _worm_index);
			worm = (Worm*) _tmp10_;
			_tmp11_ = worm;
			if (!_tmp11_->is_stopped) {
				{
					WormPositions* _p_list = NULL;
					Worm* _tmp12_;
					WormPositions* _tmp13_;
					gint _p_size = 0;
					WormPositions* _tmp14_;
					gint _tmp15_;
					gint _tmp16_;
					gint _p_index = 0;
					_tmp12_ = worm;
					_tmp13_ = _tmp12_->list;
					_p_list = _tmp13_;
					_tmp14_ = _p_list;
					_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
					_tmp16_ = _tmp15_;
					_p_size = _tmp16_;
					_p_index = -1;
					while (TRUE) {
						gint _tmp17_;
						gint _tmp18_;
						guint16 p = 0U;
						WormPositions* _tmp19_;
						gpointer _tmp20_;
						gboolean* _tmp21_;
						gint _tmp21__length1;
						gint _tmp21__length2;
						_p_index = _p_index + 1;
						_tmp17_ = _p_index;
						_tmp18_ = _p_size;
						if (!(_tmp17_ < _tmp18_)) {
							break;
						}
						_tmp19_ = _p_list;
						_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _p_index);
						p = (guint16) ((guintptr) _tmp20_);
						_tmp21_ = worms_at;
						_tmp21__length1 = worms_at_length1;
						_tmp21__length2 = worms_at_length2;
						_tmp21_[((p >> 8) * _tmp21__length2) + ((guint8) p)] = TRUE;
					}
				}
			}
			_g_object_unref0 (worm);
		}
	}
	{
		gboolean _tmp22_ = FALSE;
		_tmp22_ = TRUE;
		while (TRUE) {
			guint8 _tmp24_;
			guint8 _tmp25_;
			if (!_tmp22_) {
				gboolean* _tmp23_;
				gint _tmp23__length1;
				gint _tmp23__length2;
				_tmp23_ = worms_at;
				_tmp23__length1 = worms_at_length1;
				_tmp23__length2 = worms_at_length2;
				if (!(!nibbles_game_is_space_empty (self, x, y, _tmp23_, (gint) _tmp23__length1, (gint) _tmp23__length2))) {
					break;
				}
			}
			_tmp22_ = FALSE;
			_tmp24_ = self->priv->_width;
			x = (guint8) g_random_int_range ((gint32) 0, (gint32) (_tmp24_ - 1));
			_tmp25_ = self->priv->_height;
			y = (guint8) g_random_int_range ((gint32) 0, (gint32) (_tmp25_ - 1));
		}
	}
	if (regular) {
		gboolean _tmp26_ = FALSE;
		if (g_random_int_range ((gint32) 0, (gint32) 7) == ((gint32) 0)) {
			gboolean _tmp27_;
			_tmp27_ = self->priv->_fakes;
			_tmp26_ = _tmp27_;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			_nibbles_game_add_bonus (self, x, y, BONUS_TYPE_REGULAR, TRUE, (guint16) 300);
		}
		{
			gboolean _tmp28_ = FALSE;
			_tmp28_ = TRUE;
			while (TRUE) {
				guint8 _tmp30_;
				guint8 _tmp31_;
				if (!_tmp28_) {
					gboolean* _tmp29_;
					gint _tmp29__length1;
					gint _tmp29__length2;
					_tmp29_ = worms_at;
					_tmp29__length1 = worms_at_length1;
					_tmp29__length2 = worms_at_length2;
					if (!(!nibbles_game_is_space_empty (self, x, y, _tmp29_, (gint) _tmp29__length1, (gint) _tmp29__length2))) {
						break;
					}
				}
				_tmp28_ = FALSE;
				_tmp30_ = self->priv->_width;
				x = (guint8) g_random_int_range ((gint32) 0, (gint32) (_tmp30_ - 1));
				_tmp31_ = self->priv->_height;
				y = (guint8) g_random_int_range ((gint32) 0, (gint32) (_tmp31_ - 1));
			}
		}
		_nibbles_game_add_bonus (self, x, y, BONUS_TYPE_REGULAR, FALSE, (guint16) 300);
	} else {
		Boni* _tmp32_;
		_tmp32_ = self->priv->boni;
		if (!boni_too_many_missed (_tmp32_)) {
			gboolean _tmp33_ = FALSE;
			if (g_random_int_range ((gint32) 0, (gint32) 7) != ((gint32) 0)) {
				good = FALSE;
			} else {
				good = TRUE;
			}
			if (good) {
				gboolean _tmp34_;
				_tmp34_ = self->priv->_fakes;
				_tmp33_ = !_tmp34_;
			} else {
				_tmp33_ = FALSE;
			}
			if (_tmp33_) {
				worms_at = (g_free (worms_at), NULL);
				return;
			}
			switch (g_random_int_range ((gint32) 0, (gint32) 21)) {
				case 0:
				case 1:
				case 2:
				case 3:
				case 4:
				case 5:
				case 6:
				case 7:
				case 8:
				case 9:
				{
					_nibbles_game_add_bonus (self, x, y, BONUS_TYPE_HALF, good, (guint16) 200);
					break;
				}
				case 10:
				case 11:
				case 12:
				case 13:
				case 14:
				{
					_nibbles_game_add_bonus (self, x, y, BONUS_TYPE_DOUBLE, good, (guint16) 150);
					break;
				}
				case 15:
				{
					_nibbles_game_add_bonus (self, x, y, BONUS_TYPE_LIFE, good, (guint16) 100);
					break;
				}
				case 16:
				case 17:
				case 18:
				case 19:
				case 20:
				{
					gint _tmp35_;
					_tmp35_ = self->priv->_numworms;
					if (_tmp35_ > 1) {
						_nibbles_game_add_bonus (self, x, y, BONUS_TYPE_REVERSE, good, (guint16) 150);
					}
					break;
				}
				default:
				break;
			}
		}
	}
	worms_at = (g_free (worms_at), NULL);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static inline void
_nibbles_game_add_bonus (NibblesGame* self,
                         guint8 x,
                         guint8 y,
                         BonusType bonus_type,
                         gboolean fake,
                         guint16 countdown)
{
	Bonus* bonus = NULL;
	Bonus* _tmp0_;
	Boni* _tmp1_;
	Bonus* _tmp2_;
	Bonus* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = bonus_new (x, y, bonus_type, fake, countdown);
	bonus = _tmp0_;
	_tmp1_ = self->priv->boni;
	_tmp2_ = bonus;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	if (boni_add_bonus (_tmp1_, _tmp3_)) {
		Bonus* _tmp4_;
		BonusType _tmp5_;
		BonusType _tmp6_;
		_tmp4_ = bonus;
		_tmp5_ = bonus_get_bonus_type (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != BONUS_TYPE_REGULAR) {
			g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "appear");
		}
	}
	_g_object_unref0 (bonus);
}

static void
nibbles_game_apply_bonus (NibblesGame* self,
                          Bonus* bonus,
                          Worm* worm)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	BonusType _tmp2_;
	BonusType _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bonus != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = bonus_get_fake (bonus);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		worm_reverse (worm);
		return;
	}
	_tmp2_ = bonus_get_bonus_type (bonus);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case BONUS_TYPE_REGULAR:
		{
			guint8 nth_bonus = 0U;
			Boni* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			_tmp4_ = self->priv->boni;
			nth_bonus = boni_new_regular_bonus_eaten (_tmp4_);
			_tmp5_ = worm_get_change (worm);
			_tmp6_ = _tmp5_;
			worm_set_change (worm, _tmp6_ + (((gint) nth_bonus) * WORM_GROW_FACTOR));
			_tmp7_ = worm_get_score (worm);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->priv->_current_level;
			worm_set_score (worm, _tmp8_ + (((gint) nth_bonus) * _tmp9_));
			g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "gobble");
			break;
		}
		case BONUS_TYPE_DOUBLE:
		{
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			_tmp10_ = worm_get_score (worm);
			_tmp11_ = _tmp10_;
			_tmp12_ = worm_get_length (worm);
			_tmp13_ = _tmp12_;
			_tmp14_ = worm_get_change (worm);
			_tmp15_ = _tmp14_;
			_tmp16_ = self->priv->_current_level;
			worm_set_score (worm, _tmp11_ + ((_tmp13_ + _tmp15_) * _tmp16_));
			_tmp17_ = worm_get_change (worm);
			_tmp18_ = _tmp17_;
			_tmp19_ = worm_get_length (worm);
			_tmp20_ = _tmp19_;
			_tmp21_ = worm_get_change (worm);
			_tmp22_ = _tmp21_;
			worm_set_change (worm, _tmp18_ + (_tmp20_ + _tmp22_));
			g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "bonus");
			break;
		}
		case BONUS_TYPE_HALF:
		{
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			_tmp23_ = worm_get_length (worm);
			_tmp24_ = _tmp23_;
			_tmp25_ = worm_get_change (worm);
			_tmp26_ = _tmp25_;
			if ((_tmp24_ + _tmp26_) > 2) {
				gint _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				_tmp27_ = worm_get_score (worm);
				_tmp28_ = _tmp27_;
				_tmp29_ = worm_get_length (worm);
				_tmp30_ = _tmp29_;
				_tmp31_ = worm_get_change (worm);
				_tmp32_ = _tmp31_;
				_tmp33_ = self->priv->_current_level;
				worm_set_score (worm, _tmp28_ + ((_tmp30_ + (_tmp32_ / 2)) * _tmp33_));
				_tmp34_ = worm_get_length (worm);
				_tmp35_ = _tmp34_;
				worm_reduce_tail (worm, _tmp35_ / 2);
				_tmp36_ = worm_get_change (worm);
				_tmp37_ = _tmp36_;
				_tmp38_ = worm_get_length (worm);
				_tmp39_ = _tmp38_;
				_tmp40_ = worm_get_change (worm);
				_tmp41_ = _tmp40_;
				worm_set_change (worm, _tmp37_ - ((_tmp39_ + _tmp41_) / 2));
			}
			g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "bonus");
			break;
		}
		case BONUS_TYPE_LIFE:
		{
			worm_add_life (worm);
			g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "life");
			break;
		}
		case BONUS_TYPE_REVERSE:
		{
			nibbles_game_reverse_worms (self, worm);
			g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL], 0, "reverse");
			break;
		}
		case BONUS_TYPE_WARP:
		{
			break;
		}
		default:
		break;
	}
}

static void
nibbles_game_bonus_found_cb (NibblesGame* self,
                             Worm* worm)
{
	Bonus* bonus = NULL;
	Boni* _tmp0_;
	Position _tmp1_ = {0};
	Position _tmp2_;
	Position _tmp3_ = {0};
	Position _tmp4_;
	Bonus* _tmp5_;
	Bonus* _tmp6_;
	Position _tmp7_ = {0};
	Position _tmp8_;
	Position _tmp9_ = {0};
	Position _tmp10_;
	Bonus* _tmp11_;
	Bonus* _tmp12_;
	gboolean _tmp13_ = FALSE;
	Bonus* _tmp14_;
	BonusType _tmp15_;
	BonusType _tmp16_;
	gboolean real_bonus = FALSE;
	Boni* _tmp20_;
	Bonus* _tmp21_;
	gboolean _tmp22_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm != NULL);
	_tmp0_ = self->priv->boni;
	worm_get_head (worm, &_tmp1_);
	_tmp2_ = _tmp1_;
	worm_get_head (worm, &_tmp3_);
	_tmp4_ = _tmp3_;
	_tmp5_ = boni_get_bonus (_tmp0_, _tmp2_.x, _tmp4_.y);
	bonus = _tmp5_;
	_tmp6_ = bonus;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (bonus);
		return;
	}
	worm_get_head (worm, &_tmp7_);
	_tmp8_ = _tmp7_;
	worm_get_head (worm, &_tmp9_);
	_tmp10_ = _tmp9_;
	worm_add_bonus_eaten_position (worm, _tmp8_.x, _tmp10_.y);
	_tmp11_ = bonus;
	nibbles_game_apply_bonus (self, _tmp11_, worm);
	_tmp12_ = bonus;
	g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_BONUS_APPLIED_SIGNAL], 0, _tmp12_, worm);
	_tmp14_ = bonus;
	_tmp15_ = bonus_get_bonus_type (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == BONUS_TYPE_REGULAR) {
		Bonus* _tmp17_;
		gboolean _tmp18_;
		gboolean _tmp19_;
		_tmp17_ = bonus;
		_tmp18_ = bonus_get_fake (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = !_tmp19_;
	} else {
		_tmp13_ = FALSE;
	}
	real_bonus = _tmp13_;
	_tmp20_ = self->priv->boni;
	_tmp21_ = bonus;
	boni_remove_bonus (_tmp20_, _tmp21_);
	if (real_bonus) {
		Boni* _tmp23_;
		_tmp23_ = self->priv->boni;
		_tmp22_ = !boni_last_regular_bonus (_tmp23_);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		nibbles_game_add_bonus (self, TRUE);
	}
	_g_object_unref0 (bonus);
}

static GameStatus*
_game_status_dup (GameStatus* self)
{
	GameStatus* dup;
	dup = g_new0 (GameStatus, 1);
	memcpy (dup, self, sizeof (GameStatus));
	return dup;
}

static gpointer
__game_status_dup0 (gpointer self)
{
	return self ? _game_status_dup (self) : NULL;
}

GameStatus*
nibbles_game_get_game_status (NibblesGame* self)
{
	gint worms_left = 0;
	gboolean _tmp25_ = FALSE;
	Boni* _tmp31_;
	GameStatus* result;
	g_return_val_if_fail (self != NULL, NULL);
	worms_left = 0;
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_worm_list = _tmp0_;
		_tmp1_ = _worm_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_worm_size = _tmp3_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			Worm* _tmp8_;
			guint8 _tmp9_;
			guint8 _tmp10_;
			_worm_index = _worm_index + 1;
			_tmp4_ = _worm_index;
			_tmp5_ = _worm_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _worm_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _worm_index);
			worm = (Worm*) _tmp7_;
			_tmp8_ = worm;
			_tmp9_ = worm_get_lives (_tmp8_);
			_tmp10_ = _tmp9_;
			if (((gint) _tmp10_) > 0) {
				worms_left += 1;
			} else {
				gboolean _tmp11_ = FALSE;
				Worm* _tmp12_;
				_tmp12_ = worm;
				if (_tmp12_->is_human) {
					Worm* _tmp13_;
					guint8 _tmp14_;
					guint8 _tmp15_;
					_tmp13_ = worm;
					_tmp14_ = worm_get_lives (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp11_ = ((gint) _tmp15_) == 0;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					GameStatus _tmp16_;
					GameStatus* _tmp17_;
					_tmp16_ = GAME_STATUS_GAMEOVER;
					_tmp17_ = __game_status_dup0 (&_tmp16_);
					result = _tmp17_;
					_g_object_unref0 (worm);
					return result;
				} else {
					gboolean _tmp18_ = FALSE;
					gint _tmp19_;
					_tmp19_ = self->priv->_numhumans;
					if (_tmp19_ == 0) {
						Worm* _tmp20_;
						guint8 _tmp21_;
						guint8 _tmp22_;
						_tmp20_ = worm;
						_tmp21_ = worm_get_lives (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp18_ = ((gint) _tmp22_) == 0;
					} else {
						_tmp18_ = FALSE;
					}
					if (_tmp18_) {
						GameStatus _tmp23_;
						GameStatus* _tmp24_;
						_tmp23_ = GAME_STATUS_GAMEOVER;
						_tmp24_ = __game_status_dup0 (&_tmp23_);
						result = _tmp24_;
						_g_object_unref0 (worm);
						return result;
					}
				}
			}
			_g_object_unref0 (worm);
		}
	}
	if (worms_left == 1) {
		gint _tmp26_;
		_tmp26_ = self->priv->_numworms;
		_tmp25_ = _tmp26_ > 1;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		GameStatus _tmp27_;
		GameStatus* _tmp28_;
		_tmp27_ = GAME_STATUS_VICTORY;
		_tmp28_ = __game_status_dup0 (&_tmp27_);
		result = _tmp28_;
		return result;
	} else {
		if (worms_left == 0) {
			GameStatus _tmp29_;
			GameStatus* _tmp30_;
			_tmp29_ = GAME_STATUS_GAMEOVER;
			_tmp30_ = __game_status_dup0 (&_tmp29_);
			result = _tmp30_;
			return result;
		}
	}
	_tmp31_ = self->priv->boni;
	if (boni_last_regular_bonus (_tmp31_)) {
		GameStatus _tmp32_;
		GameStatus* _tmp33_;
		_tmp32_ = GAME_STATUS_NEWROUND;
		_tmp33_ = __game_status_dup0 (&_tmp32_);
		result = _tmp33_;
		return result;
	}
	result = NULL;
	return result;
}

Worm*
nibbles_game_get_winner (NibblesGame* self)
{
	Worm* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _worm_index = 0;
		_tmp0_ = self->priv->_worms;
		_worm_list = _tmp0_;
		_tmp1_ = _worm_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_worm_size = _tmp3_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			Worm* _tmp8_;
			guint8 _tmp9_;
			guint8 _tmp10_;
			_worm_index = _worm_index + 1;
			_tmp4_ = _worm_index;
			_tmp5_ = _worm_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _worm_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _worm_index);
			worm = (Worm*) _tmp7_;
			_tmp8_ = worm;
			_tmp9_ = worm_get_lives (_tmp8_);
			_tmp10_ = _tmp9_;
			if (((gint) _tmp10_) > 0) {
				result = worm;
				return result;
			}
			_g_object_unref0 (worm);
		}
	}
	result = NULL;
	return result;
}

static GVariant*
____lambda12_ (NibblesGame* self,
               GValue* value,
               const GVariantType* type,
               void* data)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* result;
	g_return_val_if_fail (value != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = nibbles_game_get_color_string (g_value_get_int (value));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_new_string (_tmp1_);
	g_variant_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GVariant*
_____lambda12__nibbles_game_set_mapping_function (GValue* value,
                                                  const GVariantType* type,
                                                  void* data,
                                                  gpointer self)
{
	GVariant* result;
	result = ____lambda12_ ((NibblesGame*) self, value, type, data);
	return result;
}

static gboolean
____lambda13_ (GValue* prop_value,
               GVariant* variant)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (prop_value != NULL, FALSE);
	g_return_val_if_fail (variant != NULL, FALSE);
	_tmp0_ = g_variant_get_string (variant, NULL);
	g_value_set_int (prop_value, nibbles_game_get_color_num (_tmp0_));
	result = TRUE;
	return result;
}

static gboolean
_____lambda13__gsettings_bind_get_mapping (GValue* value,
                                           GVariant* variant,
                                           void* user_data)
{
	gboolean result;
	result = ____lambda13_ (value, variant);
	return result;
}

void
nibbles_game_load_worm_properties (NibblesGame* self,
                                   GeeArrayList* worm_settings)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worm_settings != NULL);
	_tmp0_ = self->priv->_worm_props;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _worm_index = 0;
		_tmp1_ = self->priv->_worms;
		_worm_list = _tmp1_;
		_tmp2_ = _worm_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_worm_size = _tmp4_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			WormProperties* properties = NULL;
			WormProperties* _tmp9_;
			NibblesGameSetMappingFunction set_mapping = NULL;
			gpointer set_mapping_target;
			GDestroyNotify set_mapping_target_destroy_notify;
			Worm* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			GSettings* _tmp14_;
			WormProperties* _tmp15_;
			NibblesGameSetMappingFunction _tmp16_;
			gpointer _tmp16__target;
			Worm* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			GSettings* _tmp21_;
			WormProperties* _tmp22_;
			Worm* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gpointer _tmp26_;
			GSettings* _tmp27_;
			WormProperties* _tmp28_;
			Worm* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			GSettings* _tmp33_;
			WormProperties* _tmp34_;
			Worm* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gpointer _tmp38_;
			GSettings* _tmp39_;
			WormProperties* _tmp40_;
			Worm* _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gpointer _tmp44_;
			GSettings* _tmp45_;
			WormProperties* _tmp46_;
			Worm* _tmp47_;
			gint _tmp48_;
			gint _tmp49_;
			gpointer _tmp50_;
			GSettings* _tmp51_;
			WormProperties* _tmp52_;
			Worm* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			gpointer _tmp56_;
			GSettings* _tmp57_;
			WormProperties* _tmp58_;
			Worm* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gpointer _tmp62_;
			GSettings* _tmp63_;
			WormProperties* _tmp64_;
			GeeHashMap* _tmp65_;
			Worm* _tmp66_;
			WormProperties* _tmp67_;
			_worm_index = _worm_index + 1;
			_tmp5_ = _worm_index;
			_tmp6_ = _worm_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _worm_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _worm_index);
			worm = (Worm*) _tmp8_;
			_tmp9_ = worm_properties_new ();
			properties = _tmp9_;
			set_mapping = _____lambda12__nibbles_game_set_mapping_function;
			set_mapping_target = g_object_ref (self);
			set_mapping_target_destroy_notify = g_object_unref;
			_tmp10_ = worm;
			_tmp11_ = worm_get_id (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp12_);
			_tmp14_ = (GSettings*) _tmp13_;
			_tmp15_ = properties;
			_tmp16_ = set_mapping;
			_tmp16__target = set_mapping_target;
			g_settings_bind_with_mapping (_tmp14_, "color", (GObject*) _tmp15_, "color", G_SETTINGS_BIND_DEFAULT, _____lambda13__gsettings_bind_get_mapping, (GSettingsBindSetMapping) _tmp16_, NULL, NULL);
			_g_object_unref0 (_tmp14_);
			_tmp17_ = worm;
			_tmp18_ = worm_get_id (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp19_);
			_tmp21_ = (GSettings*) _tmp20_;
			_tmp22_ = properties;
			g_settings_bind (_tmp21_, "key-up", (GObject*) _tmp22_, "up", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp21_);
			_tmp23_ = worm;
			_tmp24_ = worm_get_id (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp25_);
			_tmp27_ = (GSettings*) _tmp26_;
			_tmp28_ = properties;
			g_settings_bind (_tmp27_, "key-down", (GObject*) _tmp28_, "down", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp27_);
			_tmp29_ = worm;
			_tmp30_ = worm_get_id (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp31_);
			_tmp33_ = (GSettings*) _tmp32_;
			_tmp34_ = properties;
			g_settings_bind (_tmp33_, "key-left", (GObject*) _tmp34_, "left", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp33_);
			_tmp35_ = worm;
			_tmp36_ = worm_get_id (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp37_);
			_tmp39_ = (GSettings*) _tmp38_;
			_tmp40_ = properties;
			g_settings_bind (_tmp39_, "key-right", (GObject*) _tmp40_, "right", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp39_);
			_tmp41_ = worm;
			_tmp42_ = worm_get_id (_tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp43_);
			_tmp45_ = (GSettings*) _tmp44_;
			_tmp46_ = properties;
			g_settings_bind (_tmp45_, "key-up-raw", (GObject*) _tmp46_, "raw-up", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp45_);
			_tmp47_ = worm;
			_tmp48_ = worm_get_id (_tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp49_);
			_tmp51_ = (GSettings*) _tmp50_;
			_tmp52_ = properties;
			g_settings_bind (_tmp51_, "key-down-raw", (GObject*) _tmp52_, "raw-down", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp51_);
			_tmp53_ = worm;
			_tmp54_ = worm_get_id (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp55_);
			_tmp57_ = (GSettings*) _tmp56_;
			_tmp58_ = properties;
			g_settings_bind (_tmp57_, "key-left-raw", (GObject*) _tmp58_, "raw-left", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp57_);
			_tmp59_ = worm;
			_tmp60_ = worm_get_id (_tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = gee_abstract_list_get ((GeeAbstractList*) worm_settings, _tmp61_);
			_tmp63_ = (GSettings*) _tmp62_;
			_tmp64_ = properties;
			g_settings_bind (_tmp63_, "key-right-raw", (GObject*) _tmp64_, "raw-right", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (_tmp63_);
			_tmp65_ = self->priv->_worm_props;
			_tmp66_ = worm;
			_tmp67_ = properties;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp65_, _tmp66_, _tmp67_);
			(set_mapping_target_destroy_notify == NULL) ? NULL : (set_mapping_target_destroy_notify (set_mapping_target), NULL);
			set_mapping = NULL;
			set_mapping_target = NULL;
			set_mapping_target_destroy_notify = NULL;
			_g_object_unref0 (properties);
			_g_object_unref0 (worm);
		}
	}
}

static inline gchar*
nibbles_game_get_color_string (gint color)
{
	gchar* result;
	switch (color) {
		case 0:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("red");
			result = _tmp0_;
			return result;
		}
		case 1:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("green");
			result = _tmp1_;
			return result;
		}
		case 2:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("blue");
			result = _tmp2_;
			return result;
		}
		case 3:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("yellow");
			result = _tmp3_;
			return result;
		}
		case 4:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("cyan");
			result = _tmp4_;
			return result;
		}
		case 5:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup ("purple");
			result = _tmp5_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static inline gint
nibbles_game_get_color_num (const gchar* color)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	static GQuark _tmp1_label4 = 0;
	static GQuark _tmp1_label5 = 0;
	gint result;
	g_return_val_if_fail (color != NULL, 0);
	_tmp0_ = color;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("red")))) {
		switch (0) {
			default:
			{
				result = 0;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("green")))) {
		switch (0) {
			default:
			{
				result = 1;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("blue")))) {
		switch (0) {
			default:
			{
				result = 2;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("yellow")))) {
		switch (0) {
			default:
			{
				result = 3;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("cyan")))) {
		switch (0) {
			default:
			{
				result = 4;
				return result;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("purple")))) {
		switch (0) {
			default:
			{
				result = 5;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
}

gboolean
nibbles_game_keypress (NibblesGame* self,
                       guint keyval,
                       guint keycode,
                       gboolean* remove_handler)
{
	gboolean _vala_remove_handler = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_remove_handler = FALSE;
	result = nibbles_game_handle_keypress (self, keyval, keycode);
	if (remove_handler) {
		*remove_handler = _vala_remove_handler;
	}
	return result;
}

gboolean
nibbles_game_handle_keypress (NibblesGame* self,
                              guint keyval,
                              guint keycode)
{
	gboolean _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_running;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _worm_index = 0;
		_tmp1_ = self->priv->_worms;
		_worm_list = _tmp1_;
		_tmp2_ = _worm_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_worm_size = _tmp4_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			Worm* _tmp9_;
			_worm_index = _worm_index + 1;
			_tmp5_ = _worm_index;
			_tmp6_ = _worm_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _worm_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _worm_index);
			worm = (Worm*) _tmp8_;
			_tmp9_ = worm;
			if (_tmp9_->is_human) {
				Worm* _tmp10_;
				GeeHashMap* _tmp11_;
				gint* _tmp12_;
				gint _tmp12__length1;
				gint _tmp12__length2;
				GeeLinkedList* _tmp13_;
				_tmp10_ = worm;
				_tmp11_ = self->priv->_worm_props;
				_tmp12_ = self->board;
				_tmp12__length1 = self->board_length1;
				_tmp12__length2 = self->board_length2;
				_tmp13_ = self->priv->_worms;
				if (worm_handle_keypress (_tmp10_, keycode, _tmp11_, _tmp12_, (gint) _tmp12__length1, (gint) _tmp12__length2, _tmp13_)) {
					result = TRUE;
					_g_object_unref0 (worm);
					return result;
				}
			}
			_g_object_unref0 (worm);
		}
	}
	result = FALSE;
	return result;
}

static GeeList*
nibbles_game_get_other_worms (NibblesGame* self,
                              Worm* _self_)
{
	GeeArrayList* _result_ = NULL;
	GeeArrayList* _tmp0_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (_self_ != NULL, NULL);
	_tmp0_ = gee_array_list_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_result_ = _tmp0_;
	{
		GeeLinkedList* _worm_list = NULL;
		GeeLinkedList* _tmp1_;
		gint _worm_size = 0;
		GeeLinkedList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _worm_index = 0;
		_tmp1_ = self->priv->_worms;
		_worm_list = _tmp1_;
		_tmp2_ = _worm_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_worm_size = _tmp4_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp7_;
			gpointer _tmp8_;
			Worm* _tmp9_;
			_worm_index = _worm_index + 1;
			_tmp5_ = _worm_index;
			_tmp6_ = _worm_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _worm_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _worm_index);
			worm = (Worm*) _tmp8_;
			_tmp9_ = worm;
			if (_tmp9_ != _self_) {
				GeeArrayList* _tmp10_;
				Worm* _tmp11_;
				_tmp10_ = _result_;
				_tmp11_ = worm;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			}
			_g_object_unref0 (worm);
		}
	}
	result = (GeeList*) _result_;
	return result;
}

GeeList*
nibbles_game_get_bonuses (NibblesGame* self)
{
	Boni* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->boni;
	_tmp1_ = boni_get_bonuses (_tmp0_);
	result = _tmp1_;
	return result;
}

gboolean
nibbles_game_get_skip_score (NibblesGame* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_skip_score;
	return result;
}

void
nibbles_game_set_skip_score (NibblesGame* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_skip_score (self);
	if (old_value != value) {
		self->priv->_skip_score = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_SKIP_SCORE_PROPERTY]);
	}
}

gint
nibbles_game_get_current_level (NibblesGame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_current_level;
	return result;
}

void
nibbles_game_set_current_level (NibblesGame* self,
                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_current_level (self);
	if (old_value != value) {
		self->priv->_current_level = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_CURRENT_LEVEL_PROPERTY]);
	}
}

gboolean
nibbles_game_get_three_dimensional_view (NibblesGame* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_three_dimensional_view;
	return result;
}

void
nibbles_game_set_three_dimensional_view (NibblesGame* self,
                                         gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_three_dimensional_view (self);
	if (old_value != value) {
		self->priv->_three_dimensional_view = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_THREE_DIMENSIONAL_VIEW_PROPERTY]);
	}
}

gint
nibbles_game_get_speed (NibblesGame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_speed;
	return result;
}

void
nibbles_game_set_speed (NibblesGame* self,
                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_speed (self);
	if (old_value != value) {
		self->priv->_speed = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_SPEED_PROPERTY]);
	}
}

gint
nibbles_game_get_gamedelay (NibblesGame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_gamedelay;
	return result;
}

static void
nibbles_game_set_gamedelay (NibblesGame* self,
                            gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_gamedelay (self);
	if (old_value != value) {
		self->priv->_gamedelay = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_GAMEDELAY_PROPERTY]);
	}
}

guint8
nibbles_game_get_width (NibblesGame* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_width;
	return result;
}

static void
nibbles_game_set_width (NibblesGame* self,
                        guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_width (self);
	if (old_value != value) {
		self->priv->_width = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_WIDTH_PROPERTY]);
	}
}

guint8
nibbles_game_get_height (NibblesGame* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_height;
	return result;
}

static void
nibbles_game_set_height (NibblesGame* self,
                         guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_height (self);
	if (old_value != value) {
		self->priv->_height = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_HEIGHT_PROPERTY]);
	}
}

gint
nibbles_game_get_numhumans (NibblesGame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_numhumans;
	return result;
}

void
nibbles_game_set_numhumans (NibblesGame* self,
                            gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_numhumans (self);
	if (old_value != value) {
		self->priv->_numhumans = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_NUMHUMANS_PROPERTY]);
	}
}

gint
nibbles_game_get_numai (NibblesGame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_numai;
	return result;
}

void
nibbles_game_set_numai (NibblesGame* self,
                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_numai (self);
	if (old_value != value) {
		self->priv->_numai = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_NUMAI_PROPERTY]);
	}
}

gint
nibbles_game_get_numworms (NibblesGame* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_numworms;
	return result;
}

static void
nibbles_game_set_numworms (NibblesGame* self,
                           gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_numworms (self);
	if (old_value != value) {
		self->priv->_numworms = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_NUMWORMS_PROPERTY]);
	}
}

GeeLinkedList*
nibbles_game_get_worms (NibblesGame* self)
{
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_worms;
	result = _tmp0_;
	return result;
}

GeeHashMap*
nibbles_game_get_worm_props (NibblesGame* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_worm_props;
	result = _tmp0_;
	return result;
}

gboolean
nibbles_game_get_is_running (NibblesGame* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_running;
	return result;
}

static void
nibbles_game_set_is_running (NibblesGame* self,
                             gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_is_running (self);
	if (old_value != value) {
		self->priv->_is_running = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_IS_RUNNING_PROPERTY]);
	}
}

static gboolean
nibbles_game_get_is_paused (NibblesGame* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_paused;
	return result;
}

static void
nibbles_game_set_is_paused (NibblesGame* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_paused = value;
}

gboolean
nibbles_game_get_paused (NibblesGame* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_paused;
	result = _tmp0_;
	return result;
}

void
nibbles_game_set_paused (NibblesGame* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	nibbles_game_set_is_paused (self, value);
	if (value) {
		nibbles_game_stop (self);
	} else {
		nibbles_game_start (self, FALSE);
	}
	g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_PAUSED_PROPERTY]);
}

gboolean
nibbles_game_get_fakes (NibblesGame* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_fakes;
	return result;
}

void
nibbles_game_set_fakes (NibblesGame* self,
                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = nibbles_game_get_fakes (self);
	if (old_value != value) {
		self->priv->_fakes = value;
		g_object_notify_by_pspec ((GObject *) self, nibbles_game_properties[NIBBLES_GAME_FAKES_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__UCHAR_UCHAR (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UCHAR_UCHAR) (gpointer data1, guint8 arg_1, guint8 arg_2, gpointer data2);
	register GMarshalFunc_VOID__UCHAR_UCHAR callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UCHAR_UCHAR) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uchar (param_values + 1), g_value_get_uchar (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_STRING__VOID (GClosure * closure,
                                      GValue * return_value,
                                      guint n_param_values,
                                      const GValue * param_values,
                                      gpointer invocation_hint,
                                      gpointer marshal_data)
{
	typedef const char* (*GMarshalFunc_STRING__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_STRING__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	const char* v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_STRING__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_take_string (return_value, v_return);
}

static void
g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__POINTER_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__POINTER_POINTER) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}

static void
_nibbles_game___lambda14_ (NibblesGame* self,
                           Bonus* bonus)
{
	g_return_if_fail (bonus != NULL);
	g_signal_emit (self, nibbles_game_signals[NIBBLES_GAME_BONUS_REMOVED_SIGNAL], 0, bonus);
}

static void
__nibbles_game___lambda14__boni_bonus_removed (Boni* _sender,
                                               Bonus* bonus,
                                               gpointer self)
{
	_nibbles_game___lambda14_ ((NibblesGame*) self, bonus);
}

static GObject *
nibbles_game_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NibblesGame * self;
	guint8 _tmp0_;
	guint8 _tmp1_;
	gint* _tmp2_;
	Boni* _tmp3_;
	parent_class = G_OBJECT_CLASS (nibbles_game_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_GAME, NibblesGame);
	_tmp0_ = self->priv->_width;
	_tmp1_ = self->priv->_height;
	_tmp2_ = g_new0 (gint, _tmp0_ * _tmp1_);
	self->board = (g_free (self->board), NULL);
	self->board = _tmp2_;
	self->board_length1 = _tmp0_;
	self->board_length2 = _tmp1_;
	_tmp3_ = self->priv->boni;
	g_signal_connect_object (_tmp3_, "bonus-removed", (GCallback) __nibbles_game___lambda14__boni_bonus_removed, self, 0);
	return obj;
}

static void
nibbles_game_class_init (NibblesGameClass * klass,
                         gpointer klass_data)
{
	nibbles_game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NibblesGame_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_nibbles_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_nibbles_game_set_property;
	G_OBJECT_CLASS (klass)->constructor = nibbles_game_constructor;
	G_OBJECT_CLASS (klass)->finalize = nibbles_game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_SKIP_SCORE_PROPERTY, nibbles_game_properties[NIBBLES_GAME_SKIP_SCORE_PROPERTY] = g_param_spec_boolean ("skip-score", "skip-score", "skip-score", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_CURRENT_LEVEL_PROPERTY, nibbles_game_properties[NIBBLES_GAME_CURRENT_LEVEL_PROPERTY] = g_param_spec_int ("current-level", "current-level", "current-level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_THREE_DIMENSIONAL_VIEW_PROPERTY, nibbles_game_properties[NIBBLES_GAME_THREE_DIMENSIONAL_VIEW_PROPERTY] = g_param_spec_boolean ("three-dimensional-view", "three-dimensional-view", "three-dimensional-view", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_SPEED_PROPERTY, nibbles_game_properties[NIBBLES_GAME_SPEED_PROPERTY] = g_param_spec_int ("speed", "speed", "speed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_GAMEDELAY_PROPERTY, nibbles_game_properties[NIBBLES_GAME_GAMEDELAY_PROPERTY] = g_param_spec_int ("gamedelay", "gamedelay", "gamedelay", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WIDTH_PROPERTY, nibbles_game_properties[NIBBLES_GAME_WIDTH_PROPERTY] = g_param_spec_uchar ("width", "width", "width", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_HEIGHT_PROPERTY, nibbles_game_properties[NIBBLES_GAME_HEIGHT_PROPERTY] = g_param_spec_uchar ("height", "height", "height", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMHUMANS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_NUMHUMANS_PROPERTY] = g_param_spec_int ("numhumans", "numhumans", "numhumans", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMAI_PROPERTY, nibbles_game_properties[NIBBLES_GAME_NUMAI_PROPERTY] = g_param_spec_int ("numai", "numai", "numai", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_NUMWORMS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_NUMWORMS_PROPERTY] = g_param_spec_int ("numworms", "numworms", "numworms", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WORMS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_WORMS_PROPERTY] = g_param_spec_object ("worms", "worms", "worms", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_WORM_PROPS_PROPERTY, nibbles_game_properties[NIBBLES_GAME_WORM_PROPS_PROPERTY] = g_param_spec_object ("worm-props", "worm-props", "worm-props", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_IS_RUNNING_PROPERTY, nibbles_game_properties[NIBBLES_GAME_IS_RUNNING_PROPERTY] = g_param_spec_boolean ("is-running", "is-running", "is-running", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_PAUSED_PROPERTY, nibbles_game_properties[NIBBLES_GAME_PAUSED_PROPERTY] = g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NIBBLES_GAME_FAKES_PROPERTY, nibbles_game_properties[NIBBLES_GAME_FAKES_PROPERTY] = g_param_spec_boolean ("fakes", "fakes", "fakes", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	nibbles_game_signals[NIBBLES_GAME_BONUS_APPLIED_SIGNAL] = g_signal_new ("bonus-applied", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, TYPE_BONUS, TYPE_WORM);
	nibbles_game_signals[NIBBLES_GAME_LOG_SCORE_SIGNAL] = g_signal_new ("log-score", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	nibbles_game_signals[NIBBLES_GAME_ANIMATE_END_GAME_SIGNAL] = g_signal_new ("animate-end-game", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	nibbles_game_signals[NIBBLES_GAME_LEVEL_COMPLETED_SIGNAL] = g_signal_new ("level-completed", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	nibbles_game_signals[NIBBLES_GAME_WARP_ADDED_SIGNAL] = g_signal_new ("warp-added", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UCHAR_UCHAR, G_TYPE_NONE, 2, G_TYPE_UCHAR, G_TYPE_UCHAR);
	nibbles_game_signals[NIBBLES_GAME_BONUS_ADDED_SIGNAL] = g_signal_new ("bonus-added", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_BONUS);
	nibbles_game_signals[NIBBLES_GAME_BONUS_REMOVED_SIGNAL] = g_signal_new ("bonus-removed", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_BONUS);
	nibbles_game_signals[NIBBLES_GAME_GET_PKGDATADIR_SIGNAL] = g_signal_new ("get-pkgdatadir", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_STRING__VOID, G_TYPE_STRING, 0);
	nibbles_game_signals[NIBBLES_GAME_ADD_KEYPRESS_HANDLER_SIGNAL] = g_signal_new ("add-keypress-handler", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER, G_TYPE_BOOLEAN, 2, G_TYPE_POINTER, G_TYPE_POINTER);
	nibbles_game_signals[NIBBLES_GAME_REDRAW_SIGNAL] = g_signal_new ("redraw", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
	nibbles_game_signals[NIBBLES_GAME_PLAY_SOUND_SIGNAL] = g_signal_new ("play-sound", TYPE_NIBBLES_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
nibbles_game_instance_init (NibblesGame * self,
                            gpointer klass)
{
	GeeLinkedList* _tmp0_;
	GeeHashMap* _tmp1_;
	Boni* _tmp2_;
	WarpManager* _tmp3_;
	self->priv = nibbles_game_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_worms = _tmp0_;
	_tmp1_ = gee_hash_map_new (TYPE_WORM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_WORM_PROPERTIES, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->_worm_props = _tmp1_;
	_tmp2_ = boni_new ();
	self->priv->boni = _tmp2_;
	_tmp3_ = warp_manager_new ();
	self->priv->warp_manager = _tmp3_;
	self->priv->_is_running = FALSE;
	self->priv->_is_paused = FALSE;
	self->priv->main_id = (guint) 0;
	self->added_keypress_handler = FALSE;
	self->priv->bonus_cycle = (guint8) 0;
}

static void
nibbles_game_finalize (GObject * obj)
{
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES_GAME, NibblesGame);
	self->board = (g_free (self->board), NULL);
	_g_object_unref0 (self->priv->_worms);
	_g_object_unref0 (self->priv->_worm_props);
	_g_object_unref0 (self->priv->boni);
	_g_object_unref0 (self->priv->warp_manager);
	G_OBJECT_CLASS (nibbles_game_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
nibbles_game_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NibblesGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NibblesGame), 0, (GInstanceInitFunc) nibbles_game_instance_init, NULL };
	GType nibbles_game_type_id;
	nibbles_game_type_id = g_type_register_static (G_TYPE_OBJECT, "NibblesGame", &g_define_type_info, 0);
	NibblesGame_private_offset = g_type_add_instance_private (nibbles_game_type_id, sizeof (NibblesGamePrivate));
	return nibbles_game_type_id;
}

GType
nibbles_game_get_type (void)
{
	static gsize nibbles_game_type_id__once = 0;
	if (g_once_init_enter (&nibbles_game_type_id__once)) {
		GType nibbles_game_type_id;
		nibbles_game_type_id = nibbles_game_get_type_once ();
		g_once_init_leave (&nibbles_game_type_id__once, nibbles_game_type_id);
	}
	return nibbles_game_type_id__once;
}

static void
_vala_nibbles_game_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_GAME, NibblesGame);
	switch (property_id) {
		case NIBBLES_GAME_SKIP_SCORE_PROPERTY:
		g_value_set_boolean (value, nibbles_game_get_skip_score (self));
		break;
		case NIBBLES_GAME_CURRENT_LEVEL_PROPERTY:
		g_value_set_int (value, nibbles_game_get_current_level (self));
		break;
		case NIBBLES_GAME_THREE_DIMENSIONAL_VIEW_PROPERTY:
		g_value_set_boolean (value, nibbles_game_get_three_dimensional_view (self));
		break;
		case NIBBLES_GAME_SPEED_PROPERTY:
		g_value_set_int (value, nibbles_game_get_speed (self));
		break;
		case NIBBLES_GAME_GAMEDELAY_PROPERTY:
		g_value_set_int (value, nibbles_game_get_gamedelay (self));
		break;
		case NIBBLES_GAME_WIDTH_PROPERTY:
		g_value_set_uchar (value, nibbles_game_get_width (self));
		break;
		case NIBBLES_GAME_HEIGHT_PROPERTY:
		g_value_set_uchar (value, nibbles_game_get_height (self));
		break;
		case NIBBLES_GAME_NUMHUMANS_PROPERTY:
		g_value_set_int (value, nibbles_game_get_numhumans (self));
		break;
		case NIBBLES_GAME_NUMAI_PROPERTY:
		g_value_set_int (value, nibbles_game_get_numai (self));
		break;
		case NIBBLES_GAME_NUMWORMS_PROPERTY:
		g_value_set_int (value, nibbles_game_get_numworms (self));
		break;
		case NIBBLES_GAME_WORMS_PROPERTY:
		g_value_set_object (value, nibbles_game_get_worms (self));
		break;
		case NIBBLES_GAME_WORM_PROPS_PROPERTY:
		g_value_set_object (value, nibbles_game_get_worm_props (self));
		break;
		case NIBBLES_GAME_IS_RUNNING_PROPERTY:
		g_value_set_boolean (value, nibbles_game_get_is_running (self));
		break;
		case NIBBLES_GAME_PAUSED_PROPERTY:
		g_value_set_boolean (value, nibbles_game_get_paused (self));
		break;
		case NIBBLES_GAME_FAKES_PROPERTY:
		g_value_set_boolean (value, nibbles_game_get_fakes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_nibbles_game_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	NibblesGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NIBBLES_GAME, NibblesGame);
	switch (property_id) {
		case NIBBLES_GAME_SKIP_SCORE_PROPERTY:
		nibbles_game_set_skip_score (self, g_value_get_boolean (value));
		break;
		case NIBBLES_GAME_CURRENT_LEVEL_PROPERTY:
		nibbles_game_set_current_level (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_THREE_DIMENSIONAL_VIEW_PROPERTY:
		nibbles_game_set_three_dimensional_view (self, g_value_get_boolean (value));
		break;
		case NIBBLES_GAME_SPEED_PROPERTY:
		nibbles_game_set_speed (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_GAMEDELAY_PROPERTY:
		nibbles_game_set_gamedelay (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_WIDTH_PROPERTY:
		nibbles_game_set_width (self, g_value_get_uchar (value));
		break;
		case NIBBLES_GAME_HEIGHT_PROPERTY:
		nibbles_game_set_height (self, g_value_get_uchar (value));
		break;
		case NIBBLES_GAME_NUMHUMANS_PROPERTY:
		nibbles_game_set_numhumans (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_NUMAI_PROPERTY:
		nibbles_game_set_numai (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_NUMWORMS_PROPERTY:
		nibbles_game_set_numworms (self, g_value_get_int (value));
		break;
		case NIBBLES_GAME_IS_RUNNING_PROPERTY:
		nibbles_game_set_is_running (self, g_value_get_boolean (value));
		break;
		case NIBBLES_GAME_PAUSED_PROPERTY:
		nibbles_game_set_paused (self, g_value_get_boolean (value));
		break;
		case NIBBLES_GAME_FAKES_PROPERTY:
		nibbles_game_set_fakes (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

