/* gnome-nibbles.c generated by valac 0.56.16, the Vala compiler
 * generated from gnome-nibbles.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't 
 * match them self.
 *
 * grep -ne '[^][)(_!$ "](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 *
 */
/* designed for Gtk 4, link with libgtk-4-dev or gtk4-devel */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <stdio.h>
#include <gdk/gdk.h>

#define NIBBLES_PROGRAM_NAME _ ("Nibbles")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NIBBLES (nibbles_get_type ())
#define NIBBLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES, Nibbles))
#define NIBBLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES, NibblesClass))
#define IS_NIBBLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES))
#define IS_NIBBLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES))
#define NIBBLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES, NibblesClass))

typedef struct _Nibbles Nibbles;
typedef struct _NibblesClass NibblesClass;
typedef struct _NibblesPrivate NibblesPrivate;

#define TYPE_NIBBLES_WINDOW (nibbles_window_get_type ())
#define NIBBLES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NIBBLES_WINDOW, NibblesWindow))
#define NIBBLES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NIBBLES_WINDOW, NibblesWindowClass))
#define IS_NIBBLES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NIBBLES_WINDOW))
#define IS_NIBBLES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NIBBLES_WINDOW))
#define NIBBLES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NIBBLES_WINDOW, NibblesWindowClass))

typedef struct _NibblesWindow NibblesWindow;
typedef struct _NibblesWindowClass NibblesWindowClass;
enum  {
	NIBBLES_0_PROPERTY,
	NIBBLES_NUM_PROPERTIES
};
static GParamSpec* nibbles_properties[NIBBLES_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef enum  {
	SETUP_SCREEN_USUAL,
	SETUP_SCREEN_SPEED,
	SETUP_SCREEN_CONTROLS,
	SETUP_SCREEN_GAME
} SetupScreen;

#define TYPE_SETUP_SCREEN (setup_screen_get_type ())

struct _Nibbles {
	GtkApplication parent_instance;
	NibblesPrivate * priv;
};

struct _NibblesClass {
	GtkApplicationClass parent_class;
};

struct _NibblesPrivate {
	NibblesWindow* window;
};

struct _Block5Data {
	int _ref_count_;
	Nibbles* application;
};

static gint Nibbles_private_offset;
static gpointer nibbles_parent_class = NULL;
static gint nibbles_level;
static gint nibbles_nibbles;
static gint nibbles_players;
static gint nibbles_speed;
static gboolean nibbles_disable_fakes;
static gboolean nibbles_disable_fakes = FALSE;
static gboolean nibbles_enable_fakes;
static gboolean nibbles_enable_fakes = FALSE;
static gboolean nibbles_start;
static gboolean nibbles_start = FALSE;
static gint nibbles_level = G_MININT;
static gint nibbles_nibbles = G_MININT;
static gint nibbles_players = G_MININT;
static gint nibbles_speed = G_MININT;
static gboolean* nibbles_three_dimensional_view;
static gboolean* nibbles_three_dimensional_view = NULL;
static gboolean* nibbles_sound;
static gboolean* nibbles_sound = NULL;

VALA_EXTERN GType nibbles_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Nibbles, g_object_unref)
VALA_EXTERN GType nibbles_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NibblesWindow, g_object_unref)
static inline void nibbles_help_cb (Nibbles* self);
static void _nibbles_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self);
static inline void nibbles_about_cb (Nibbles* self);
static void _nibbles_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static gint nibbles_main (gchar** args,
                   gint args_length1);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static Nibbles* nibbles_new (void);
static Nibbles* nibbles_construct (GType object_type);
static void __lambda52_ (Block5Data* _data5_);
static void nibbles_setup (Nibbles* self);
static void ___lambda52__g_application_activate (GApplication* _sender,
                                          gpointer self);
static gint nibbles_real_handle_local_options (GApplication* base,
                                        GVariantDict* options);
static gboolean* _bool_dup (gboolean* self);
VALA_EXTERN GType setup_screen_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NibblesWindow* nibbles_window_new (gint cli_start_level,
                                   SetupScreen start_screen);
VALA_EXTERN NibblesWindow* nibbles_window_construct (GType object_type,
                                         gint cli_start_level,
                                         SetupScreen start_screen);
static void nibbles_real_activate (GApplication* base);
static void nibbles_real_shutdown (GApplication* base);
VALA_EXTERN void nibbles_window_on_shutdown (NibblesWindow* self);
VALA_EXTERN gboolean nibbles_window_get_game_paused (NibblesWindow* self);
static void nibbles_finalize (GObject * obj);
static GType nibbles_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry NIBBLES_action_entries[3] = {{"help", _nibbles_help_cb_gsimple_action_activate_callback}, {"about", _nibbles_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GOptionEntry NIBBLES_option_entries[13] = {{"disable-fakes", 'd', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Disable fake bonuses"), NULL}, {"enable-fakes", 'e', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Enable fake bonuses"), NULL}, {"level", 'l', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_INT, &nibbles_level, N_ ("Start at given level (1-26)"), N_ ("NUMBER")}, {"mute", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Turn off the sound"), NULL}, {"nibbles", 'n', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_INT, &nibbles_nibbles, N_ ("Set number of nibbles (4-6)"), N_ ("NUMBER")}, {"players", 'p', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_INT, &nibbles_players, N_ ("Set number of players (1-4)"), N_ ("NUMBER")}, {"speed", 's', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_INT, &nibbles_speed, N_ ("Set worms speed (4-1, 4 for slow)"), N_ ("NUMBER")}, {"3D", '3', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Set three dimensional view"), NULL}, {"2D", '2', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Set two dimensional view"), NULL}, {"start", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Start playing"), NULL}, {"unmute", (gchar) 0, (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Turn on the sound"), NULL}, {"version", 'v', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, NULL, N_ ("Show release version"), NULL}, {0}};

static inline gpointer
nibbles_get_instance_private (Nibbles* self)
{
	return G_STRUCT_MEMBER_P (self, Nibbles_private_offset);
}

static void
_nibbles_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                   GVariant* parameter,
                                                   gpointer self)
{
	nibbles_help_cb ((Nibbles*) self);
}

static void
_nibbles_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	nibbles_about_cb ((Nibbles*) self);
}

static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	g_application_quit ((GApplication*) self);
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->application);
		g_slice_free (Block5Data, _data5_);
	}
}

static void
__lambda52_ (Block5Data* _data5_)
{
	nibbles_setup (_data5_->application);
}

static void
___lambda52__g_application_activate (GApplication* _sender,
                                     gpointer self)
{
	__lambda52_ (self);
}

static gint
nibbles_main (gchar** args,
              gint args_length1)
{
	Block5Data* _data5_;
	Nibbles* _tmp0_;
	gint result;
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	gtk_init ();
	_tmp0_ = nibbles_new ();
	_data5_->application = _tmp0_;
	g_signal_connect_data ((GApplication*) _data5_->application, "activate", (GCallback) ___lambda52__g_application_activate, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
	result = g_application_run ((GApplication*) _data5_->application, (gint) args_length1, args);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return nibbles_main (argv, argc);
}

static Nibbles*
nibbles_construct (GType object_type)
{
	Nibbles * self = NULL;
	self = (Nibbles*) g_object_new (object_type, "application-id", "org.gnome.Nibbles", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, NIBBLES_option_entries);
	return self;
}

static Nibbles*
nibbles_new (void)
{
	return nibbles_construct (TYPE_NIBBLES);
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static gint
nibbles_real_handle_local_options (GApplication* base,
                                   GVariantDict* options)
{
	Nibbles * self;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gint result;
	self = (Nibbles*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "gnome-nibbles %s\n", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	if (nibbles_level != G_MININT) {
		gboolean _tmp2_ = FALSE;
		if (nibbles_level < 1) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = nibbles_level > 26;
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		FILE* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = stderr;
		_tmp4_ = g_strconcat (_ ("Start level should only be between 1 and 26."), "\n", NULL);
		_tmp5_ = _tmp4_;
		fprintf (_tmp3_, "%s", _tmp5_);
		_g_free0 (_tmp5_);
		result = EXIT_FAILURE;
		return result;
	}
	if (nibbles_nibbles != G_MININT) {
		gboolean _tmp7_ = FALSE;
		if (nibbles_nibbles < 4) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = nibbles_nibbles > 6;
		}
		_tmp6_ = _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		FILE* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = stderr;
		_tmp9_ = g_strconcat (_ ("There could only be between 4 and 6 nibbles."), "\n", NULL);
		_tmp10_ = _tmp9_;
		fprintf (_tmp8_, "%s", _tmp10_);
		_g_free0 (_tmp10_);
		result = EXIT_FAILURE;
		return result;
	}
	if (nibbles_players != G_MININT) {
		gboolean _tmp12_ = FALSE;
		if (nibbles_players < 1) {
			_tmp12_ = TRUE;
		} else {
			_tmp12_ = nibbles_players > 4;
		}
		_tmp11_ = _tmp12_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		FILE* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = stderr;
		_tmp14_ = g_strconcat (_ ("There could only be between 1 and 4 players."), "\n", NULL);
		_tmp15_ = _tmp14_;
		fprintf (_tmp13_, "%s", _tmp15_);
		_g_free0 (_tmp15_);
		result = EXIT_FAILURE;
		return result;
	}
	if (nibbles_speed != G_MININT) {
		gboolean _tmp17_ = FALSE;
		if (nibbles_speed < 1) {
			_tmp17_ = TRUE;
		} else {
			_tmp17_ = nibbles_speed > 4;
		}
		_tmp16_ = _tmp17_;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		FILE* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = stderr;
		_tmp19_ = g_strconcat (_ ("Speed should be between 4 (slow) and 1 (fast)."), "\n", NULL);
		_tmp20_ = _tmp19_;
		fprintf (_tmp18_, "%s", _tmp20_);
		_g_free0 (_tmp20_);
		result = EXIT_FAILURE;
		return result;
	}
	nibbles_disable_fakes = g_variant_dict_contains (options, "disable-fakes");
	nibbles_enable_fakes = g_variant_dict_contains (options, "enable-fakes");
	if (nibbles_disable_fakes) {
		_tmp21_ = nibbles_enable_fakes;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		FILE* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp22_ = stderr;
		_tmp23_ = g_strconcat (_ ("Options --disable-fakes (-d) and --enable-fakes (-e) are mutually excl" \
"usive."), "\n", NULL);
		_tmp24_ = _tmp23_;
		fprintf (_tmp22_, "%s", _tmp24_);
		_g_free0 (_tmp24_);
		result = EXIT_FAILURE;
		return result;
	}
	if (g_variant_dict_contains (options, "mute")) {
		gboolean _tmp25_;
		gboolean* _tmp26_;
		_tmp25_ = FALSE;
		_tmp26_ = __bool_dup0 (&_tmp25_);
		_g_free0 (nibbles_sound);
		nibbles_sound = _tmp26_;
	} else {
		if (g_variant_dict_contains (options, "unmute")) {
			gboolean _tmp27_;
			gboolean* _tmp28_;
			_tmp27_ = TRUE;
			_tmp28_ = __bool_dup0 (&_tmp27_);
			_g_free0 (nibbles_sound);
			nibbles_sound = _tmp28_;
		}
	}
	if (g_variant_dict_contains (options, "3D")) {
		_tmp29_ = g_variant_dict_contains (options, "2D");
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		FILE* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp30_ = stderr;
		_tmp31_ = g_strconcat (_ ("Options --3D (-3) and --2D (-2) are mutually exclusive."), "\n", NULL);
		_tmp32_ = _tmp31_;
		fprintf (_tmp30_, "%s", _tmp32_);
		_g_free0 (_tmp32_);
		result = EXIT_FAILURE;
		return result;
	} else {
		if (g_variant_dict_contains (options, "3D")) {
			gboolean _tmp33_;
			gboolean* _tmp34_;
			_tmp33_ = TRUE;
			_tmp34_ = __bool_dup0 (&_tmp33_);
			_g_free0 (nibbles_three_dimensional_view);
			nibbles_three_dimensional_view = _tmp34_;
		} else {
			if (g_variant_dict_contains (options, "2D")) {
				gboolean _tmp35_;
				gboolean* _tmp36_;
				_tmp35_ = FALSE;
				_tmp36_ = __bool_dup0 (&_tmp35_);
				_g_free0 (nibbles_three_dimensional_view);
				nibbles_three_dimensional_view = _tmp36_;
			}
		}
	}
	if (g_variant_dict_contains (options, "start")) {
		nibbles_start = TRUE;
	}
	result = -1;
	return result;
}

static void
nibbles_setup (Nibbles* self)
{
	GtkSettings* _tmp0_;
	static const gchar* newgame[2] = {"<Primary>n", NULL};
	static const gchar* pause[3] = {"<Primary>p", "Pause", NULL};
	static const gchar* appquit[2] = {"<Primary>q", NULL};
	static const gchar* back[2] = {"Escape", NULL};
	static const gchar* hamburger[3] = {"F10", "Menu", NULL};
	gboolean nibbles_changed = FALSE;
	gboolean players_changed = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	SetupScreen setup = 0;
	gint _tmp31_ = 0;
	NibblesWindow* _tmp32_;
	NibblesWindow* _tmp33_;
	g_return_if_fail (self != NULL);
	g_set_prgname ("org.gnome.Nibbles");
	g_set_application_name (NIBBLES_PROGRAM_NAME);
	gtk_window_set_default_icon_name ("org.gnome.Nibbles");
	_tmp0_ = gtk_settings_get_default ();
	g_object_set ((GObject*) _tmp0_, "gtk-application-prefer-dark-theme", TRUE, NULL);
	g_action_map_add_action_entries ((GActionMap*) self, NIBBLES_action_entries, (gint) G_N_ELEMENTS (NIBBLES_action_entries), self);
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.new-game", newgame);
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.pause", pause);
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", appquit);
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.back", back);
	gtk_application_set_accels_for_action ((GtkApplication*) self, "win.hamburger", hamburger);
	nibbles_changed = nibbles_nibbles != G_MININT;
	players_changed = nibbles_players != G_MININT;
	if (nibbles_changed) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = players_changed;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = nibbles_speed != G_MININT;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = nibbles_disable_fakes;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = nibbles_enable_fakes;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean* _tmp7_;
		_tmp7_ = nibbles_three_dimensional_view;
		_tmp2_ = _tmp7_ != NULL;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean* _tmp8_;
		_tmp8_ = nibbles_sound;
		_tmp1_ = _tmp8_ != NULL;
	}
	if (_tmp1_) {
		GSettings* settings = NULL;
		GSettings* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean* _tmp22_;
		gboolean* _tmp25_;
		_tmp9_ = g_settings_new ("org.gnome.Nibbles");
		settings = _tmp9_;
		if (nibbles_changed) {
			_tmp10_ = players_changed;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			GSettings* _tmp11_;
			GSettings* _tmp12_;
			_tmp11_ = settings;
			g_settings_set_int (_tmp11_, "players", nibbles_players);
			_tmp12_ = settings;
			g_settings_set_int (_tmp12_, "ai", nibbles_nibbles - nibbles_players);
		} else {
			if (players_changed) {
				gint old_ai = 0;
				GSettings* _tmp13_;
				gint old_players = 0;
				GSettings* _tmp14_;
				GSettings* _tmp15_;
				gint new_ai = 0;
				_tmp13_ = settings;
				old_ai = g_settings_get_int (_tmp13_, "ai");
				_tmp14_ = settings;
				old_players = g_settings_get_int (_tmp14_, "players");
				_tmp15_ = settings;
				g_settings_set_int (_tmp15_, "players", nibbles_players);
				new_ai = CLAMP (CLAMP (old_ai + old_players, 4, 6) - nibbles_players, 0, 5);
				if (old_ai != new_ai) {
					GSettings* _tmp16_;
					_tmp16_ = settings;
					g_settings_set_int (_tmp16_, "ai", new_ai);
				}
			} else {
				if (nibbles_changed) {
					GSettings* _tmp17_;
					GSettings* _tmp18_;
					_tmp17_ = settings;
					_tmp18_ = settings;
					g_settings_set_int (_tmp17_, "ai", nibbles_nibbles - g_settings_get_int (_tmp18_, "players"));
				}
			}
		}
		if (nibbles_speed != G_MININT) {
			GSettings* _tmp19_;
			_tmp19_ = settings;
			g_settings_set_int (_tmp19_, "speed", nibbles_speed);
		}
		if (nibbles_disable_fakes) {
			GSettings* _tmp20_;
			_tmp20_ = settings;
			g_settings_set_boolean (_tmp20_, "fakes", FALSE);
		} else {
			if (nibbles_enable_fakes) {
				GSettings* _tmp21_;
				_tmp21_ = settings;
				g_settings_set_boolean (_tmp21_, "fakes", TRUE);
			}
		}
		_tmp22_ = nibbles_three_dimensional_view;
		if (_tmp22_ != NULL) {
			GSettings* _tmp23_;
			gboolean* _tmp24_;
			_tmp23_ = settings;
			_tmp24_ = nibbles_three_dimensional_view;
			g_settings_set_boolean (_tmp23_, "three-dimensional-view", (gboolean) (*_tmp24_));
		}
		_tmp25_ = nibbles_sound;
		if (_tmp25_ != NULL) {
			GSettings* _tmp26_;
			gboolean* _tmp27_;
			_tmp26_ = settings;
			_tmp27_ = nibbles_sound;
			g_settings_set_boolean (_tmp26_, "sound", (gboolean) (*_tmp27_));
		}
		_g_object_unref0 (settings);
	}
	if (nibbles_start) {
		setup = SETUP_SCREEN_GAME;
	} else {
		gboolean _tmp28_ = FALSE;
		if (nibbles_changed) {
			_tmp28_ = players_changed;
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			gboolean _tmp29_ = FALSE;
			if (nibbles_speed != G_MININT) {
				gboolean _tmp30_ = FALSE;
				if (nibbles_disable_fakes) {
					_tmp30_ = TRUE;
				} else {
					_tmp30_ = nibbles_enable_fakes;
				}
				_tmp29_ = _tmp30_;
			} else {
				_tmp29_ = FALSE;
			}
			if (_tmp29_) {
				setup = SETUP_SCREEN_CONTROLS;
			} else {
				setup = SETUP_SCREEN_SPEED;
			}
		} else {
			setup = SETUP_SCREEN_USUAL;
		}
	}
	if (nibbles_level == G_MININT) {
		_tmp31_ = 0;
	} else {
		_tmp31_ = nibbles_level;
	}
	_tmp32_ = nibbles_window_new (_tmp31_, setup);
	g_object_ref_sink (_tmp32_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp32_;
	_tmp33_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp33_);
}

static void
nibbles_real_activate (GApplication* base)
{
	Nibbles * self;
	NibblesWindow* _tmp0_;
	self = (Nibbles*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
	G_APPLICATION_CLASS (nibbles_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}

static void
nibbles_real_shutdown (GApplication* base)
{
	Nibbles * self;
	NibblesWindow* _tmp0_;
	self = (Nibbles*) base;
	_tmp0_ = self->priv->window;
	nibbles_window_on_shutdown (_tmp0_);
	G_APPLICATION_CLASS (nibbles_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
}

static inline void
nibbles_help_cb (Nibbles* self)
{
	gboolean _tmp0_ = FALSE;
	NibblesWindow* _tmp1_;
	NibblesWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->window;
	if (_tmp1_ != NULL) {
		NibblesWindow* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->window;
		_tmp3_ = nibbles_window_get_game_paused (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		NibblesWindow* _tmp5_;
		_tmp5_ = self->priv->window;
		g_action_group_activate_action ((GActionGroup*) _tmp5_, "pause", NULL);
	}
	_tmp6_ = self->priv->window;
	gtk_show_uri ((GtkWindow*) _tmp6_, "help:gnome-nibbles", (guint32) GDK_CURRENT_TIME);
}

static inline void
nibbles_about_cb (Nibbles* self)
{
	gboolean _tmp0_ = FALSE;
	NibblesWindow* _tmp1_;
	gchar** authors = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gint authors_length1;
	gint _authors_size_;
	gchar** documenters = NULL;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gint documenters_length1;
	gint _documenters_size_;
	gchar** artists = NULL;
	gchar* _tmp15_;
	gchar** _tmp16_;
	gint artists_length1;
	gint _artists_size_;
	NibblesWindow* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->window;
	if (_tmp1_ != NULL) {
		NibblesWindow* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->window;
		_tmp3_ = nibbles_window_get_game_paused (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = !_tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		NibblesWindow* _tmp5_;
		_tmp5_ = self->priv->window;
		g_action_group_activate_action ((GActionGroup*) _tmp5_, "pause", NULL);
	}
	_tmp6_ = g_strdup (_ ("Sean MacIsaac"));
	_tmp7_ = g_strdup (_ ("Ian Peters"));
	_tmp8_ = g_strdup (_ ("Andreas Røsdal"));
	_tmp9_ = g_strdup (_ ("Guillaume Beland"));
	_tmp10_ = g_strdup (_ ("Iulian-Gabriel Radu"));
	_tmp11_ = g_strdup (_ ("Ben Corby"));
	_tmp12_ = g_new0 (gchar*, 6 + 1);
	_tmp12_[0] = _tmp6_;
	_tmp12_[1] = _tmp7_;
	_tmp12_[2] = _tmp8_;
	_tmp12_[3] = _tmp9_;
	_tmp12_[4] = _tmp10_;
	_tmp12_[5] = _tmp11_;
	authors = _tmp12_;
	authors_length1 = 6;
	_authors_size_ = authors_length1;
	_tmp13_ = g_strdup (_ ("Kevin Breit"));
	_tmp14_ = g_new0 (gchar*, 1 + 1);
	_tmp14_[0] = _tmp13_;
	documenters = _tmp14_;
	documenters_length1 = 1;
	_documenters_size_ = documenters_length1;
	_tmp15_ = g_strdup (_ ("Allan Day"));
	_tmp16_ = g_new0 (gchar*, 1 + 1);
	_tmp16_[0] = _tmp15_;
	artists = _tmp16_;
	artists_length1 = 1;
	_artists_size_ = artists_length1;
	_tmp17_ = self->priv->window;
	_tmp18_ = g_strconcat (_ ("Copyright © 1999-2008 – Sean MacIsaac, Ian Peters, Andreas Røsdal"), "\n", NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp19_, _ ("Copyright © 2009 – Guillaume Beland"), NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp21_, "\n", NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strdup_printf (_ ("Copyright © %u-%u – Iulian-Gabriel Radu"), (guint) 2015, (guint) 2020);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_strconcat (_tmp23_, _tmp25_, NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = g_strconcat (_tmp27_, "\n", NULL);
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strdup_printf (_ ("Copyright © %u-%u – Ben Corby"), (guint) 2022, (guint) 2023);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat (_tmp29_, _tmp31_, NULL);
	_tmp33_ = _tmp32_;
	gtk_show_about_dialog ((GtkWindow*) _tmp17_, "program-name", NIBBLES_PROGRAM_NAME, "version", VERSION, "comments", _ ("A worm game for GNOME"), "logo-icon-name", "org.gnome.Nibbles", "copyright", _tmp33_, "license-type", GTK_LICENSE_GPL_3_0, "authors", authors, "documenters", documenters, "artists", artists, "translator-credits", _ ("translator-credits"), "website", "https://wiki.gnome.org/Apps/Nibbles/", NULL);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

static void
nibbles_class_init (NibblesClass * klass,
                    gpointer klass_data)
{
	nibbles_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Nibbles_private_offset);
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) nibbles_real_handle_local_options;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) nibbles_real_activate;
	((GApplicationClass *) klass)->shutdown = (void (*) (GApplication*)) nibbles_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = nibbles_finalize;
}

static void
nibbles_instance_init (Nibbles * self,
                       gpointer klass)
{
	self->priv = nibbles_get_instance_private (self);
}

static void
nibbles_finalize (GObject * obj)
{
	Nibbles * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NIBBLES, Nibbles);
	_g_object_unref0 (self->priv->window);
	G_OBJECT_CLASS (nibbles_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
nibbles_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NibblesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) nibbles_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Nibbles), 0, (GInstanceInitFunc) nibbles_instance_init, NULL };
	GType nibbles_type_id;
	nibbles_type_id = g_type_register_static (gtk_application_get_type (), "Nibbles", &g_define_type_info, 0);
	Nibbles_private_offset = g_type_add_instance_private (nibbles_type_id, sizeof (NibblesPrivate));
	return nibbles_type_id;
}

GType
nibbles_get_type (void)
{
	static gsize nibbles_type_id__once = 0;
	if (g_once_init_enter (&nibbles_type_id__once)) {
		GType nibbles_type_id;
		nibbles_type_id = nibbles_get_type_once ();
		g_once_init_leave (&nibbles_type_id__once, nibbles_type_id);
	}
	return nibbles_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

