/* controls.c generated by valac 0.56.16, the Vala compiler
 * generated from controls.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 * Copyright (C) 2020 Arnaud Bonatti <arnaud.bonatti@gmail.com>
 * Copyright (C) 2023 Ben Corby <bcorby@new-ms.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't 
 * match them self.
 *
 * grep -ne '[^][)(_!$ "](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <pango/pangocairo.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_CONTROLS (controls_get_type ())
#define CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTROLS, Controls))
#define CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTROLS, ControlsClass))
#define IS_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTROLS))
#define IS_CONTROLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTROLS))
#define CONTROLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTROLS, ControlsClass))

typedef struct _Controls Controls;
typedef struct _ControlsClass ControlsClass;
typedef struct _ControlsPrivate ControlsPrivate;

#define TYPE_CONTROLS_GRID (controls_grid_get_type ())
#define CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTROLS_GRID, ControlsGrid))
#define CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTROLS_GRID, ControlsGridClass))
#define IS_CONTROLS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTROLS_GRID))
#define IS_CONTROLS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTROLS_GRID))
#define CONTROLS_GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTROLS_GRID, ControlsGridClass))

typedef struct _ControlsGrid ControlsGrid;
typedef struct _ControlsGridClass ControlsGridClass;
enum  {
	CONTROLS_0_PROPERTY,
	CONTROLS_NUM_PROPERTIES
};
static GParamSpec* controls_properties[CONTROLS_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
#define WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_PROPERTIES, WormProperties))
#define WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_PROPERTIES, WormPropertiesClass))
#define IS_WORM_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_PROPERTIES))
#define IS_WORM_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_PROPERTIES))
#define WORM_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_PROPERTIES, WormPropertiesClass))

typedef struct _WormProperties WormProperties;
typedef struct _WormPropertiesClass WormPropertiesClass;
typedef struct _Block1Data Block1Data;
typedef struct _WormPrivate WormPrivate;

#define TYPE_WORM_POSITIONS (worm_positions_get_type ())
#define WORM_POSITIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM_POSITIONS, WormPositions))
#define WORM_POSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM_POSITIONS, WormPositionsClass))
#define IS_WORM_POSITIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM_POSITIONS))
#define IS_WORM_POSITIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM_POSITIONS))
#define WORM_POSITIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM_POSITIONS, WormPositionsClass))

typedef struct _WormPositions WormPositions;
typedef struct _WormPositionsClass WormPositionsClass;
typedef struct _ControlsGridPrivate ControlsGridPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef gboolean (*KeypressHandlerFunction) (guint a, guint b, gboolean* remove_handler, gpointer user_data);
enum  {
	CONTROLS_ADD_KEYPRESS_HANDLER_SIGNAL,
	CONTROLS_NUM_SIGNALS
};
static guint controls_signals[CONTROLS_NUM_SIGNALS] = {0};

#define TYPE_COLOUR_WHEEL (colour_wheel_get_type ())
#define COLOUR_WHEEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLOUR_WHEEL, ColourWheel))
#define COLOUR_WHEEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLOUR_WHEEL, ColourWheelClass))
#define IS_COLOUR_WHEEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLOUR_WHEEL))
#define IS_COLOUR_WHEEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLOUR_WHEEL))
#define COLOUR_WHEEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLOUR_WHEEL, ColourWheelClass))

typedef struct _ColourWheel ColourWheel;
typedef struct _ColourWheelClass ColourWheelClass;

#define TYPE_OVERLAY_MESSAGE (overlay_message_get_type ())
#define OVERLAY_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OVERLAY_MESSAGE, OverlayMessage))
#define OVERLAY_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OVERLAY_MESSAGE, OverlayMessageClass))
#define IS_OVERLAY_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OVERLAY_MESSAGE))
#define IS_OVERLAY_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OVERLAY_MESSAGE))
#define OVERLAY_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OVERLAY_MESSAGE, OverlayMessageClass))

typedef struct _OverlayMessage OverlayMessage;
typedef struct _OverlayMessageClass OverlayMessageClass;
enum  {
	CONTROLS_GRID_0_PROPERTY,
	CONTROLS_GRID_NUM_PROPERTIES
};
static GParamSpec* controls_grid_properties[CONTROLS_GRID_NUM_PROPERTIES];
typedef struct _Block2Data Block2Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef void (*ColourWheelResultFunction) (guint c, gpointer user_data);

#define CONTROLS_GRID_TYPE_XY (controls_grid_xy_get_type ())
typedef struct _ControlsGridxy ControlsGridxy;
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
typedef struct _OverlayMessagePrivate OverlayMessagePrivate;
enum  {
	OVERLAY_MESSAGE_0_PROPERTY,
	OVERLAY_MESSAGE_NUM_PROPERTIES
};
static GParamSpec* overlay_message_properties[OVERLAY_MESSAGE_NUM_PROPERTIES];
typedef struct _Block3Data Block3Data;
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
typedef struct _ColourWheelPrivate ColourWheelPrivate;
enum  {
	COLOUR_WHEEL_0_PROPERTY,
	COLOUR_WHEEL_NUM_PROPERTIES
};
static GParamSpec* colour_wheel_properties[COLOUR_WHEEL_NUM_PROPERTIES];
typedef struct _Block4Data Block4Data;

struct _Controls {
	GtkBox parent_instance;
	ControlsPrivate * priv;
	GeeList* worm_settings;
};

struct _ControlsClass {
	GtkBoxClass parent_class;
};

struct _ControlsPrivate {
	GtkBox* grids_box;
	GeeLinkedList* grids;
};

struct _Block1Data {
	int _ref_count_;
	Controls* self;
	GeeLinkedList* worms;
	GeeHashMap* worms_props;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gint rounds_to_stay_still;
	gboolean is_stopped;
	WormPositions* list;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _ControlsGrid {
	GtkFrame parent_instance;
	ControlsGridPrivate * priv;
	Controls* controls;
	WormProperties* worm_props;
	gulong external_handler;
};

struct _ControlsGridClass {
	GtkFrameClass parent_class;
};

struct _ControlsGridPrivate {
	GtkOverlay* overlay;
	GtkButton* name_label;
	GtkDrawingArea* arrow_up;
	GtkDrawingArea* arrow_down;
	GtkDrawingArea* arrow_left;
	GtkDrawingArea* arrow_right;
	GtkButton* move_up_button;
	GtkButton* move_down_button;
	GtkButton* move_left_button;
	GtkButton* move_right_button;
	gulong up_handler;
	gulong down_handler;
	gulong left_handler;
	gulong right_handler;
	gulong color_handler;
	ColourWheel* colour_wheel;
	OverlayMessage* key_press_message;
	gboolean duplicate[4];
};

struct _Block2Data {
	int _ref_count_;
	ControlsGrid* self;
	gchar* player_id;
	Controls* controls;
	WormProperties* worm_props;
	GeeHashMap* worms_props;
};

struct _ControlsGridxy {
	gdouble x;
	gdouble y;
};

struct _OverlayMessage {
	GtkDrawingArea parent_instance;
	OverlayMessagePrivate * priv;
};

struct _OverlayMessageClass {
	GtkDrawingAreaClass parent_class;
};

struct _Block3Data {
	int _ref_count_;
	OverlayMessage* self;
	gchar* text;
};

struct _ColourWheel {
	GtkDrawingArea parent_instance;
	ColourWheelPrivate * priv;
	ColourWheelResultFunction result;
	gpointer result_target;
	GDestroyNotify result_target_destroy_notify;
};

struct _ColourWheelClass {
	GtkDrawingAreaClass parent_class;
};

struct _ColourWheelPrivate {
	gdouble centre_x;
	gdouble centre_y;
	gdouble radius;
	guint mouse_segment;
	gboolean mouse_pressed;
};

struct _Block4Data {
	int _ref_count_;
	ColourWheel* self;
	ColourWheelResultFunction _result_;
	gpointer _result__target;
};

static gint Controls_private_offset;
static gpointer controls_parent_class = NULL;
static gint ControlsGrid_private_offset;
static gpointer controls_grid_parent_class = NULL;
static gpointer overlay_message_parent_class = NULL;
static gint ColourWheel_private_offset;
static gpointer colour_wheel_parent_class = NULL;

VALA_EXTERN GType controls_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Controls, g_object_unref)
VALA_EXTERN GType controls_grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ControlsGrid, g_object_unref)
VALA_EXTERN GType worm_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Worm, g_object_unref)
VALA_EXTERN GType worm_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormProperties, g_object_unref)
VALA_EXTERN void controls_prepare (Controls* self,
                       GeeLinkedList* worms,
                       GeeHashMap* worms_props,
                       GeeList* worm_settings);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN GType worm_positions_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WormPositions, g_object_unref)
VALA_EXTERN gint worm_get_id (Worm* self);
VALA_EXTERN ControlsGrid* controls_grid_new (Controls* controls,
                                 gint worm_id,
                                 WormProperties* worm_props,
                                 GeeHashMap* worms_props);
VALA_EXTERN ControlsGrid* controls_grid_construct (GType object_type,
                                       Controls* controls,
                                       gint worm_id,
                                       WormProperties* worm_props,
                                       GeeHashMap* worms_props);
static void controls_check_for_duplicates (Controls* self,
                                    guint key,
                                    GHashTable** encountered_keys,
                                    GHashTable** duplicate_keys);
VALA_EXTERN guint worm_properties_get_up (WormProperties* self);
VALA_EXTERN guint worm_properties_get_down (WormProperties* self);
VALA_EXTERN guint worm_properties_get_left (WormProperties* self);
VALA_EXTERN guint worm_properties_get_right (WormProperties* self);
static void ____lambda40_ (Block1Data* _data1_);
VALA_EXTERN void controls_grid_mark_duplicated_keys (ControlsGrid* self,
                                         GHashTable* duplicate_keys);
static void _____lambda40__g_object_notify (GObject* _sender,
                                     GParamSpec* pspec,
                                     gpointer self);
VALA_EXTERN void controls_clean (Controls* self);
VALA_EXTERN void controls_grid_disconnect_stuff (ControlsGrid* self);
VALA_EXTERN Controls* controls_new (void);
VALA_EXTERN Controls* controls_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__POINTER_POINTER (GClosure * closure,
                                                    GValue * return_value,
                                                    guint n_param_values,
                                                    const GValue * param_values,
                                                    gpointer invocation_hint,
                                                    gpointer marshal_data);
static void controls_finalize (GObject * obj);
static GType controls_get_type_once (void);
VALA_EXTERN GType colour_wheel_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ColourWheel, g_object_unref)
VALA_EXTERN GType overlay_message_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OverlayMessage, g_object_unref)
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda15_ (Block2Data* _data2_);
VALA_EXTERN gchar* nibbles_view_colorval_name_untranslated (gint colorval);
VALA_EXTERN gint worm_properties_get_color (WormProperties* self);
static void ___lambda15__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda22_ (ControlsGrid* self,
                  GtkDrawingArea* area,
                  cairo_t* C,
                  gint width,
                  gint height);
static void controls_grid_draw_arrow (ControlsGrid* self,
                               guint d,
                               cairo_t* C,
                               gdouble width,
                               gdouble height);
static void ___lambda22__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                              cairo_t* cr,
                                              gint width,
                                              gint height,
                                              gpointer self);
static void __lambda23_ (ControlsGrid* self,
                  GtkDrawingArea* area,
                  cairo_t* C,
                  gint width,
                  gint height);
static void ___lambda23__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                              cairo_t* cr,
                                              gint width,
                                              gint height,
                                              gpointer self);
static void __lambda24_ (ControlsGrid* self,
                  GtkDrawingArea* area,
                  cairo_t* C,
                  gint width,
                  gint height);
static void ___lambda24__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                              cairo_t* cr,
                                              gint width,
                                              gint height,
                                              gpointer self);
static void __lambda25_ (ControlsGrid* self,
                  GtkDrawingArea* area,
                  cairo_t* C,
                  gint width,
                  gint height);
static void ___lambda25__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                              cairo_t* cr,
                                              gint width,
                                              gint height,
                                              gpointer self);
static void __lambda26_ (Block2Data* _data2_);
static void controls_grid_configure_label (guint key_value,
                                    GtkLabel* label);
static void ___lambda26__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda27_ (Block2Data* _data2_);
static void ___lambda27__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda28_ (Block2Data* _data2_);
static void ___lambda28__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda29_ (Block2Data* _data2_);
static void ___lambda29__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda30_ (Block2Data* _data2_);
static void ___lambda31_ (Block2Data* _data2_,
                   guint c);
VALA_EXTERN void worm_properties_set_color (WormProperties* self,
                                gint value);
static void ____lambda31__colour_wheel_result_function (guint c,
                                                 gpointer self);
VALA_EXTERN ColourWheel* colour_wheel_new (ColourWheelResultFunction _result_,
                               gpointer _result__target);
VALA_EXTERN ColourWheel* colour_wheel_construct (GType object_type,
                                     ColourWheelResultFunction _result_,
                                     gpointer _result__target);
static void ___lambda30__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda32_ (Block2Data* _data2_);
VALA_EXTERN OverlayMessage* overlay_message_new (const gchar* text);
VALA_EXTERN OverlayMessage* overlay_message_construct (GType object_type,
                                           const gchar* text);
static gboolean ___lambda33_ (ControlsGrid* self,
                       guint keyval,
                       guint keycode,
                       gboolean* remove_handler);
VALA_EXTERN void worm_properties_set_up (WormProperties* self,
                             guint value);
VALA_EXTERN gint worm_properties_get_raw_up (WormProperties* self);
VALA_EXTERN void worm_properties_set_raw_up (WormProperties* self,
                                 gint value);
static gboolean ____lambda33__keypress_handler_function (guint a,
                                                  guint b,
                                                  gboolean* remove_handler,
                                                  gpointer self);
static void ___lambda32__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda34_ (Block2Data* _data2_);
static gboolean ___lambda35_ (ControlsGrid* self,
                       guint keyval,
                       guint keycode,
                       gboolean* remove_handler);
VALA_EXTERN void worm_properties_set_down (WormProperties* self,
                               guint value);
VALA_EXTERN gint worm_properties_get_raw_down (WormProperties* self);
VALA_EXTERN void worm_properties_set_raw_down (WormProperties* self,
                                   gint value);
static gboolean ____lambda35__keypress_handler_function (guint a,
                                                  guint b,
                                                  gboolean* remove_handler,
                                                  gpointer self);
static void ___lambda34__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda36_ (Block2Data* _data2_);
static gboolean ___lambda37_ (ControlsGrid* self,
                       guint keyval,
                       guint keycode,
                       gboolean* remove_handler);
VALA_EXTERN void worm_properties_set_left (WormProperties* self,
                               guint value);
VALA_EXTERN gint worm_properties_get_raw_left (WormProperties* self);
VALA_EXTERN void worm_properties_set_raw_left (WormProperties* self,
                                   gint value);
static gboolean ____lambda37__keypress_handler_function (guint a,
                                                  guint b,
                                                  gboolean* remove_handler,
                                                  gpointer self);
static void ___lambda36__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda38_ (Block2Data* _data2_);
static gboolean ___lambda39_ (ControlsGrid* self,
                       guint keyval,
                       guint keycode,
                       gboolean* remove_handler);
VALA_EXTERN void worm_properties_set_right (WormProperties* self,
                                guint value);
VALA_EXTERN gint worm_properties_get_raw_right (WormProperties* self);
VALA_EXTERN void worm_properties_set_raw_right (WormProperties* self,
                                    gint value);
static gboolean ____lambda39__keypress_handler_function (guint a,
                                                  guint b,
                                                  gboolean* remove_handler,
                                                  gpointer self);
static void ___lambda38__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static GType controls_grid_xy_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ControlsGridxy* controls_grid_xy_dup (const ControlsGridxy* self);
static void controls_grid_xy_free (ControlsGridxy* self);
static void controls_grid_set_duplicate_class (ControlsGrid* self,
                                        gboolean duplicate,
                                        GtkLabel* label);
static void controls_grid_finalize (GObject * obj);
static GType controls_grid_get_type_once (void);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda8_ (Block3Data* _data3_,
                 GtkDrawingArea* area,
                 cairo_t* C,
                 gint width,
                 gint height);
static gint overlay_message_calculate_font_size (OverlayMessage* self,
                                          cairo_t* C,
                                          const gchar* text,
                                          gint target_width,
                                          gdouble* width,
                                          gdouble* height);
static void overlay_message_draw_text_font_size (OverlayMessage* self,
                                          cairo_t* C,
                                          gint x,
                                          gint y,
                                          const gchar* text,
                                          gint font_size);
static void ___lambda8__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                             cairo_t* cr,
                                             gint width,
                                             gint height,
                                             gpointer self);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void overlay_message_get_text_offsets (OverlayMessage* self,
                                       cairo_t* C,
                                       const gchar* text,
                                       gint font_size,
                                       gint* x_offset,
                                       gint* y_offset);
static GType overlay_message_get_type_once (void);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void __lambda4_ (ColourWheel* self,
                 GtkDrawingArea* area,
                 cairo_t* C,
                 gint width,
                 gint height);
static void colour_wheel_draw_label (ColourWheel* self,
                              cairo_t* C,
                              gdouble width,
                              gdouble height,
                              const gchar* text);
static void ___lambda4__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                             cairo_t* cr,
                                             gint width,
                                             gint height,
                                             gpointer self);
static void __lambda5_ (ColourWheel* self,
                 gdouble x,
                 gdouble y);
static void colour_wheel_new_position (ColourWheel* self,
                                gdouble x,
                                gdouble y);
static void ___lambda5__gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                     gdouble x,
                                                     gdouble y,
                                                     gpointer self);
static void __lambda6_ (ColourWheel* self,
                 gdouble x,
                 gdouble y);
static void ___lambda6__gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                                    gdouble x,
                                                    gdouble y,
                                                    gpointer self);
static gboolean __lambda7_ (Block4Data* _data4_,
                     GdkEvent* event);
static void colour_wheel_redraw (ColourWheel* self);
static gboolean ___lambda7__gtk_event_controller_legacy_event (GtkEventControllerLegacy* _sender,
                                                        GdkEvent* event,
                                                        gpointer self);
static guint colour_wheel_segment (ColourWheel* self,
                            gdouble x,
                            gdouble y);
static gint colour_wheel_calculate_font_size (ColourWheel* self,
                                       cairo_t* C,
                                       const gchar* text,
                                       gint target_width,
                                       gdouble* width,
                                       gdouble* height);
static void colour_wheel_draw_text_font_size (ColourWheel* self,
                                       cairo_t* C,
                                       gint x,
                                       gint y,
                                       const gchar* text,
                                       gint font_size);
static void colour_wheel_get_text_offsets (ColourWheel* self,
                                    cairo_t* C,
                                    const gchar* text,
                                    gint font_size,
                                    gint* x_offset,
                                    gint* y_offset);
static void colour_wheel_finalize (GObject * obj);
static GType colour_wheel_get_type_once (void);

static inline gpointer
controls_get_instance_private (Controls* self)
{
	return G_STRUCT_MEMBER_P (self, Controls_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Controls* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->worms);
		_g_object_unref0 (_data1_->worms_props);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
____lambda40_ (Block1Data* _data1_)
{
	Controls* self;
	GHashTable* _duplicate_keys = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _encountered_keys = NULL;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	self = _data1_->self;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, NULL);
	_duplicate_keys = _tmp2_;
	_tmp3_ = g_direct_hash;
	_tmp4_ = g_direct_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, NULL, NULL);
	_encountered_keys = _tmp5_;
	{
		GeeLinkedList* _worm_list = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _worm_index = 0;
		_worm_list = _data1_->worms;
		_tmp6_ = _worm_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_worm_size = _tmp8_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp11_;
			gpointer _tmp12_;
			Worm* _tmp13_;
			_worm_index = _worm_index + 1;
			_tmp9_ = _worm_index;
			_tmp10_ = _worm_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _worm_list;
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _worm_index);
			worm = (Worm*) _tmp12_;
			_tmp13_ = worm;
			if (_tmp13_->is_human) {
				WormProperties* worm_prop = NULL;
				Worm* _tmp14_;
				gpointer _tmp15_;
				WormProperties* _tmp16_;
				guint _tmp17_;
				guint _tmp18_;
				WormProperties* _tmp19_;
				guint _tmp20_;
				guint _tmp21_;
				WormProperties* _tmp22_;
				guint _tmp23_;
				guint _tmp24_;
				WormProperties* _tmp25_;
				guint _tmp26_;
				guint _tmp27_;
				_tmp14_ = worm;
				_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _data1_->worms_props, _tmp14_);
				worm_prop = (WormProperties*) _tmp15_;
				_tmp16_ = worm_prop;
				_tmp17_ = worm_properties_get_up (_tmp16_);
				_tmp18_ = _tmp17_;
				controls_check_for_duplicates (self, _tmp18_, &_encountered_keys, &_duplicate_keys);
				_tmp19_ = worm_prop;
				_tmp20_ = worm_properties_get_down (_tmp19_);
				_tmp21_ = _tmp20_;
				controls_check_for_duplicates (self, _tmp21_, &_encountered_keys, &_duplicate_keys);
				_tmp22_ = worm_prop;
				_tmp23_ = worm_properties_get_left (_tmp22_);
				_tmp24_ = _tmp23_;
				controls_check_for_duplicates (self, _tmp24_, &_encountered_keys, &_duplicate_keys);
				_tmp25_ = worm_prop;
				_tmp26_ = worm_properties_get_right (_tmp25_);
				_tmp27_ = _tmp26_;
				controls_check_for_duplicates (self, _tmp27_, &_encountered_keys, &_duplicate_keys);
				_g_object_unref0 (worm_prop);
			}
			_g_object_unref0 (worm);
		}
	}
	{
		GeeLinkedList* __grid_list = NULL;
		GeeLinkedList* _tmp28_;
		gint __grid_size = 0;
		GeeLinkedList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint __grid_index = 0;
		_tmp28_ = self->priv->grids;
		__grid_list = _tmp28_;
		_tmp29_ = __grid_list;
		_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		__grid_size = _tmp31_;
		__grid_index = -1;
		while (TRUE) {
			gint _tmp32_;
			gint _tmp33_;
			ControlsGrid* _grid = NULL;
			GeeLinkedList* _tmp34_;
			gpointer _tmp35_;
			ControlsGrid* _tmp36_;
			GHashTable* _tmp37_;
			__grid_index = __grid_index + 1;
			_tmp32_ = __grid_index;
			_tmp33_ = __grid_size;
			if (!(_tmp32_ < _tmp33_)) {
				break;
			}
			_tmp34_ = __grid_list;
			_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, __grid_index);
			_grid = (ControlsGrid*) _tmp35_;
			_tmp36_ = _grid;
			_tmp37_ = _duplicate_keys;
			controls_grid_mark_duplicated_keys (_tmp36_, _tmp37_);
			_g_object_unref0 (_grid);
		}
	}
	_g_hash_table_unref0 (_encountered_keys);
	_g_hash_table_unref0 (_duplicate_keys);
}

static void
_____lambda40__g_object_notify (GObject* _sender,
                                GParamSpec* pspec,
                                gpointer self)
{
	____lambda40_ (self);
}

void
controls_prepare (Controls* self,
                  GeeLinkedList* worms,
                  GeeHashMap* worms_props,
                  GeeList* worm_settings)
{
	Block1Data* _data1_;
	GeeLinkedList* _tmp0_;
	GeeHashMap* _tmp1_;
	GHashTable* duplicate_keys = NULL;
	GHashFunc _tmp11_;
	GEqualFunc _tmp12_;
	GHashTable* _tmp13_;
	GHashTable* encountered_keys = NULL;
	GHashFunc _tmp14_;
	GEqualFunc _tmp15_;
	GHashTable* _tmp16_;
	GeeList* _tmp62_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (worms != NULL);
	g_return_if_fail (worms_props != NULL);
	g_return_if_fail (worm_settings != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (worms);
	_g_object_unref0 (_data1_->worms);
	_data1_->worms = _tmp0_;
	_tmp1_ = _g_object_ref0 (worms_props);
	_g_object_unref0 (_data1_->worms_props);
	_data1_->worms_props = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			GtkBox* _tmp3_;
			GtkWidget* _tmp4_;
			GtkWidget* child = NULL;
			GtkBox* _tmp5_;
			GtkWidget* _tmp6_;
			GtkWidget* _tmp7_;
			GtkBox* _tmp8_;
			GtkWidget* _tmp9_;
			GtkWidget* _tmp10_;
			if (!_tmp2_) {
			}
			_tmp2_ = FALSE;
			_tmp3_ = self->priv->grids_box;
			_tmp4_ = gtk_widget_get_last_child ((GtkWidget*) _tmp3_);
			if (!(_tmp4_ != NULL)) {
				break;
			}
			_tmp5_ = self->priv->grids_box;
			_tmp6_ = gtk_widget_get_last_child ((GtkWidget*) _tmp5_);
			_tmp7_ = _g_object_ref0 (_tmp6_);
			child = _tmp7_;
			_tmp8_ = self->priv->grids_box;
			_tmp9_ = child;
			gtk_box_remove (_tmp8_, _tmp9_);
			_tmp10_ = child;
			g_signal_emit_by_name (_tmp10_, "destroy");
			_g_object_unref0 (child);
		}
	}
	_tmp11_ = g_direct_hash;
	_tmp12_ = g_direct_equal;
	_tmp13_ = g_hash_table_new_full (_tmp11_, _tmp12_, NULL, NULL);
	duplicate_keys = _tmp13_;
	_tmp14_ = g_direct_hash;
	_tmp15_ = g_direct_equal;
	_tmp16_ = g_hash_table_new_full (_tmp14_, _tmp15_, NULL, NULL);
	encountered_keys = _tmp16_;
	{
		GeeLinkedList* _worm_list = NULL;
		gint _worm_size = 0;
		GeeLinkedList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _worm_index = 0;
		_worm_list = _data1_->worms;
		_tmp17_ = _worm_list;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_worm_size = _tmp19_;
		_worm_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			Worm* worm = NULL;
			GeeLinkedList* _tmp22_;
			gpointer _tmp23_;
			Worm* _tmp24_;
			_worm_index = _worm_index + 1;
			_tmp20_ = _worm_index;
			_tmp21_ = _worm_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _worm_list;
			_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _worm_index);
			worm = (Worm*) _tmp23_;
			_tmp24_ = worm;
			if (_tmp24_->is_human) {
				WormProperties* worm_prop = NULL;
				Worm* _tmp25_;
				gpointer _tmp26_;
				ControlsGrid* grid = NULL;
				Worm* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				WormProperties* _tmp30_;
				ControlsGrid* _tmp31_;
				GtkBox* _tmp32_;
				ControlsGrid* _tmp33_;
				GeeLinkedList* _tmp34_;
				ControlsGrid* _tmp35_;
				WormProperties* _tmp36_;
				guint _tmp37_;
				guint _tmp38_;
				WormProperties* _tmp39_;
				guint _tmp40_;
				guint _tmp41_;
				WormProperties* _tmp42_;
				guint _tmp43_;
				guint _tmp44_;
				WormProperties* _tmp45_;
				guint _tmp46_;
				guint _tmp47_;
				_tmp25_ = worm;
				_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _data1_->worms_props, _tmp25_);
				worm_prop = (WormProperties*) _tmp26_;
				_tmp27_ = worm;
				_tmp28_ = worm_get_id (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = worm_prop;
				_tmp31_ = controls_grid_new (self, _tmp29_, _tmp30_, _data1_->worms_props);
				g_object_ref_sink (_tmp31_);
				grid = _tmp31_;
				_tmp32_ = self->priv->grids_box;
				_tmp33_ = grid;
				gtk_box_append (_tmp32_, (GtkWidget*) _tmp33_);
				_tmp34_ = self->priv->grids;
				_tmp35_ = grid;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, _tmp35_);
				_tmp36_ = worm_prop;
				_tmp37_ = worm_properties_get_up (_tmp36_);
				_tmp38_ = _tmp37_;
				controls_check_for_duplicates (self, _tmp38_, &encountered_keys, &duplicate_keys);
				_tmp39_ = worm_prop;
				_tmp40_ = worm_properties_get_down (_tmp39_);
				_tmp41_ = _tmp40_;
				controls_check_for_duplicates (self, _tmp41_, &encountered_keys, &duplicate_keys);
				_tmp42_ = worm_prop;
				_tmp43_ = worm_properties_get_left (_tmp42_);
				_tmp44_ = _tmp43_;
				controls_check_for_duplicates (self, _tmp44_, &encountered_keys, &duplicate_keys);
				_tmp45_ = worm_prop;
				_tmp46_ = worm_properties_get_right (_tmp45_);
				_tmp47_ = _tmp46_;
				controls_check_for_duplicates (self, _tmp47_, &encountered_keys, &duplicate_keys);
				_g_object_unref0 (grid);
				_g_object_unref0 (worm_prop);
			}
			_g_object_unref0 (worm);
		}
	}
	{
		GeeLinkedList* _grid_list = NULL;
		GeeLinkedList* _tmp48_;
		gint _grid_size = 0;
		GeeLinkedList* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gint _grid_index = 0;
		_tmp48_ = self->priv->grids;
		_grid_list = _tmp48_;
		_tmp49_ = _grid_list;
		_tmp50_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp49_);
		_tmp51_ = _tmp50_;
		_grid_size = _tmp51_;
		_grid_index = -1;
		while (TRUE) {
			gint _tmp52_;
			gint _tmp53_;
			ControlsGrid* grid = NULL;
			GeeLinkedList* _tmp54_;
			gpointer _tmp55_;
			ControlsGrid* _tmp56_;
			ControlsGrid* _tmp57_;
			WormProperties* _tmp58_;
			gulong _tmp59_;
			ControlsGrid* _tmp60_;
			GHashTable* _tmp61_;
			_grid_index = _grid_index + 1;
			_tmp52_ = _grid_index;
			_tmp53_ = _grid_size;
			if (!(_tmp52_ < _tmp53_)) {
				break;
			}
			_tmp54_ = _grid_list;
			_tmp55_ = gee_abstract_list_get ((GeeAbstractList*) _tmp54_, _grid_index);
			grid = (ControlsGrid*) _tmp55_;
			_tmp56_ = grid;
			_tmp57_ = grid;
			_tmp58_ = _tmp57_->worm_props;
			_tmp59_ = g_signal_connect_data ((GObject*) _tmp58_, "notify", (GCallback) _____lambda40__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
			_tmp56_->external_handler = _tmp59_;
			_tmp60_ = grid;
			_tmp61_ = duplicate_keys;
			controls_grid_mark_duplicated_keys (_tmp60_, _tmp61_);
			_g_object_unref0 (grid);
		}
	}
	_tmp62_ = _g_object_ref0 (worm_settings);
	_g_object_unref0 (self->worm_settings);
	self->worm_settings = _tmp62_;
	_g_hash_table_unref0 (encountered_keys);
	_g_hash_table_unref0 (duplicate_keys);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
controls_check_for_duplicates (Controls* self,
                               guint key,
                               GHashTable** encountered_keys,
                               GHashTable** duplicate_keys)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (*encountered_keys != NULL);
	g_return_if_fail (*duplicate_keys != NULL);
	if (g_hash_table_contains (*encountered_keys, (gpointer) ((guintptr) key))) {
		g_hash_table_add (*duplicate_keys, (gpointer) ((guintptr) key));
	} else {
		g_hash_table_add (*encountered_keys, (gpointer) ((guintptr) key));
	}
}

void
controls_clean (Controls* self)
{
	GeeLinkedList* _tmp12_;
	g_return_if_fail (self != NULL);
	{
		GeeLinkedList* _grid_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _grid_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _grid_index = 0;
		_tmp0_ = self->priv->grids;
		_grid_list = _tmp0_;
		_tmp1_ = _grid_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_grid_size = _tmp3_;
		_grid_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ControlsGrid* grid = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			ControlsGrid* _tmp8_;
			WormProperties* _tmp9_;
			ControlsGrid* _tmp10_;
			ControlsGrid* _tmp11_;
			_grid_index = _grid_index + 1;
			_tmp4_ = _grid_index;
			_tmp5_ = _grid_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _grid_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _grid_index);
			grid = (ControlsGrid*) _tmp7_;
			_tmp8_ = grid;
			_tmp9_ = _tmp8_->worm_props;
			_tmp10_ = grid;
			g_signal_handler_disconnect ((GObject*) _tmp9_, _tmp10_->external_handler);
			_tmp11_ = grid;
			controls_grid_disconnect_stuff (_tmp11_);
			_g_object_unref0 (grid);
		}
	}
	_tmp12_ = self->priv->grids;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp12_);
}

Controls*
controls_construct (GType object_type)
{
	Controls * self = NULL;
	self = (Controls*) g_object_new (object_type, NULL);
	return self;
}

Controls*
controls_new (void)
{
	return controls_construct (TYPE_CONTROLS);
}

static void
g_cclosure_user_marshal_VOID__POINTER_POINTER (GClosure * closure,
                                               GValue * return_value,
                                               guint n_param_values,
                                               const GValue * param_values,
                                               gpointer invocation_hint,
                                               gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__POINTER_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}

static void
controls_class_init (ControlsClass * klass,
                     gpointer klass_data)
{
	controls_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Controls_private_offset);
	G_OBJECT_CLASS (klass)->finalize = controls_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/controls.ui");
	controls_signals[CONTROLS_ADD_KEYPRESS_HANDLER_SIGNAL] = g_signal_new ("add-keypress-handler", TYPE_CONTROLS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_POINTER, G_TYPE_NONE, 2, G_TYPE_POINTER, G_TYPE_POINTER);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grids_box", FALSE, Controls_private_offset + G_STRUCT_OFFSET (ControlsPrivate, grids_box));
}

static void
controls_instance_init (Controls * self,
                        gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = controls_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (TYPE_CONTROLS_GRID, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->grids = _tmp0_;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
controls_finalize (GObject * obj)
{
	Controls * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTROLS, Controls);
	_g_object_unref0 (self->priv->grids);
	_g_object_unref0 (self->worm_settings);
	G_OBJECT_CLASS (controls_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
controls_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ControlsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) controls_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Controls), 0, (GInstanceInitFunc) controls_instance_init, NULL };
	GType controls_type_id;
	controls_type_id = g_type_register_static (gtk_box_get_type (), "Controls", &g_define_type_info, 0);
	Controls_private_offset = g_type_add_instance_private (controls_type_id, sizeof (ControlsPrivate));
	return controls_type_id;
}

GType
controls_get_type (void)
{
	static gsize controls_type_id__once = 0;
	if (g_once_init_enter (&controls_type_id__once)) {
		GType controls_type_id;
		controls_type_id = controls_get_type_once ();
		g_once_init_leave (&controls_type_id__once, controls_type_id);
	}
	return controls_type_id__once;
}

static inline gpointer
controls_grid_get_instance_private (ControlsGrid* self)
{
	return G_STRUCT_MEMBER_P (self, ControlsGrid_private_offset);
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		ControlsGrid* self;
		self = _data2_->self;
		_g_free0 (_data2_->player_id);
		_g_object_unref0 (_data2_->controls);
		_g_object_unref0 (_data2_->worm_props);
		_g_object_unref0 (_data2_->worms_props);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
__lambda15_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	PangoColor color = {0};
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkButton* _tmp4_;
	GtkWidget* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	self = _data2_->self;
	memset (&color, 0, sizeof (PangoColor));
	_tmp0_ = worm_properties_get_color (_data2_->worm_props);
	_tmp1_ = _tmp0_;
	_tmp2_ = nibbles_view_colorval_name_untranslated (_tmp1_);
	_tmp3_ = _tmp2_;
	pango_color_parse (&color, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->priv->name_label;
	_tmp5_ = gtk_button_get_child (_tmp4_);
	_tmp6_ = pango_color_to_string (&color);
	_tmp7_ = _tmp6_;
	_tmp8_ = string_to_string (_tmp7_);
	_tmp9_ = string_to_string (_data2_->player_id);
	_tmp10_ = g_strconcat ("<b><span font-family=\"Sans\" color=\"", _tmp8_, "\">", _tmp9_, "</span></b>", NULL);
	_tmp11_ = _tmp10_;
	gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_label_get_type (), GtkLabel), _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp7_);
}

static void
___lambda15__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda15_ (self);
}

static void
__lambda22_ (ControlsGrid* self,
             GtkDrawingArea* area,
             cairo_t* C,
             gint width,
             gint height)
{
	g_return_if_fail (area != NULL);
	g_return_if_fail (C != NULL);
	controls_grid_draw_arrow (self, (guint) 0, C, (gdouble) width, (gdouble) height);
}

static void
___lambda22__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                         cairo_t* cr,
                                         gint width,
                                         gint height,
                                         gpointer self)
{
	__lambda22_ ((ControlsGrid*) self, drawing_area, cr, width, height);
}

static void
__lambda23_ (ControlsGrid* self,
             GtkDrawingArea* area,
             cairo_t* C,
             gint width,
             gint height)
{
	g_return_if_fail (area != NULL);
	g_return_if_fail (C != NULL);
	controls_grid_draw_arrow (self, (guint) 1, C, (gdouble) width, (gdouble) height);
}

static void
___lambda23__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                         cairo_t* cr,
                                         gint width,
                                         gint height,
                                         gpointer self)
{
	__lambda23_ ((ControlsGrid*) self, drawing_area, cr, width, height);
}

static void
__lambda24_ (ControlsGrid* self,
             GtkDrawingArea* area,
             cairo_t* C,
             gint width,
             gint height)
{
	g_return_if_fail (area != NULL);
	g_return_if_fail (C != NULL);
	controls_grid_draw_arrow (self, (guint) 2, C, (gdouble) width, (gdouble) height);
}

static void
___lambda24__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                         cairo_t* cr,
                                         gint width,
                                         gint height,
                                         gpointer self)
{
	__lambda24_ ((ControlsGrid*) self, drawing_area, cr, width, height);
}

static void
__lambda25_ (ControlsGrid* self,
             GtkDrawingArea* area,
             cairo_t* C,
             gint width,
             gint height)
{
	g_return_if_fail (area != NULL);
	g_return_if_fail (C != NULL);
	controls_grid_draw_arrow (self, (guint) 3, C, (gdouble) width, (gdouble) height);
}

static void
___lambda25__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                         cairo_t* cr,
                                         gint width,
                                         gint height,
                                         gpointer self)
{
	__lambda25_ ((ControlsGrid*) self, drawing_area, cr, width, height);
}

static void
__lambda26_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	guint _tmp0_;
	guint _tmp1_;
	GtkButton* _tmp2_;
	GtkWidget* _tmp3_;
	self = _data2_->self;
	_tmp0_ = worm_properties_get_up (_data2_->worm_props);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->move_up_button;
	_tmp3_ = gtk_button_get_child (_tmp2_);
	controls_grid_configure_label (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel));
}

static void
___lambda26__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda26_ (self);
}

static void
__lambda27_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	guint _tmp0_;
	guint _tmp1_;
	GtkButton* _tmp2_;
	GtkWidget* _tmp3_;
	self = _data2_->self;
	_tmp0_ = worm_properties_get_down (_data2_->worm_props);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->move_down_button;
	_tmp3_ = gtk_button_get_child (_tmp2_);
	controls_grid_configure_label (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel));
}

static void
___lambda27__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda27_ (self);
}

static void
__lambda28_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	guint _tmp0_;
	guint _tmp1_;
	GtkButton* _tmp2_;
	GtkWidget* _tmp3_;
	self = _data2_->self;
	_tmp0_ = worm_properties_get_left (_data2_->worm_props);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->move_left_button;
	_tmp3_ = gtk_button_get_child (_tmp2_);
	controls_grid_configure_label (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel));
}

static void
___lambda28__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda28_ (self);
}

static void
__lambda29_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	guint _tmp0_;
	guint _tmp1_;
	GtkButton* _tmp2_;
	GtkWidget* _tmp3_;
	self = _data2_->self;
	_tmp0_ = worm_properties_get_right (_data2_->worm_props);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->move_right_button;
	_tmp3_ = gtk_button_get_child (_tmp2_);
	controls_grid_configure_label (_tmp1_, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel));
}

static void
___lambda29__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda29_ (self);
}

static void
___lambda31_ (Block2Data* _data2_,
              guint c)
{
	ControlsGrid* self;
	GtkOverlay* _tmp0_;
	ColourWheel* _tmp1_;
	WormProperties* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	self = _data2_->self;
	_tmp0_ = self->priv->overlay;
	_tmp1_ = self->priv->colour_wheel;
	gtk_overlay_remove_overlay (_tmp0_, (GtkWidget*) _tmp1_);
	_g_object_unref0 (self->priv->colour_wheel);
	self->priv->colour_wheel = NULL;
	g_signal_emit (_data2_->controls, controls_signals[CONTROLS_ADD_KEYPRESS_HANDLER_SIGNAL], 0, NULL, NULL);
	_tmp2_ = self->worm_props;
	_tmp3_ = worm_properties_get_color (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != ((gint) c)) {
		WormProperties* _tmp21_;
		{
			GeeMapIterator* i = NULL;
			GeeMapIterator* _tmp5_;
			_tmp5_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _data2_->worms_props);
			i = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					GeeMapIterator* _tmp7_;
					GeeMapIterator* _tmp8_;
					gpointer _tmp9_;
					WormProperties* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					gboolean _tmp13_;
					if (!_tmp6_) {
					}
					_tmp6_ = FALSE;
					_tmp7_ = i;
					if (!gee_map_iterator_next (_tmp7_)) {
						break;
					}
					_tmp8_ = i;
					_tmp9_ = gee_map_iterator_get_value (_tmp8_);
					_tmp10_ = (WormProperties*) _tmp9_;
					_tmp11_ = worm_properties_get_color (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = _tmp12_ == ((gint) c);
					_g_object_unref0 (_tmp10_);
					if (_tmp13_) {
						GeeMapIterator* _tmp14_;
						gpointer _tmp15_;
						WormProperties* _tmp16_;
						WormProperties* _tmp17_;
						gint _tmp18_;
						gint _tmp19_;
						WormProperties* _tmp20_;
						_tmp14_ = i;
						_tmp15_ = gee_map_iterator_get_value (_tmp14_);
						_tmp16_ = (WormProperties*) _tmp15_;
						_tmp17_ = self->worm_props;
						_tmp18_ = worm_properties_get_color (_tmp17_);
						_tmp19_ = _tmp18_;
						worm_properties_set_color (_tmp16_, _tmp19_);
						_g_object_unref0 (_tmp16_);
						_tmp20_ = self->worm_props;
						worm_properties_set_color (_tmp20_, (gint) c);
						_g_object_unref0 (i);
						return;
					}
				}
			}
			_g_object_unref0 (i);
		}
		_tmp21_ = self->worm_props;
		worm_properties_set_color (_tmp21_, (gint) c);
	}
}

static void
____lambda31__colour_wheel_result_function (guint c,
                                            gpointer self)
{
	___lambda31_ (self, c);
}

static void
__lambda30_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	gboolean _tmp0_ = FALSE;
	ColourWheel* _tmp1_;
	self = _data2_->self;
	_tmp1_ = self->priv->colour_wheel;
	if (NULL == _tmp1_) {
		OverlayMessage* _tmp2_;
		_tmp2_ = self->priv->key_press_message;
		_tmp0_ = NULL == _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ColourWheel* _tmp3_;
		GtkOverlay* _tmp4_;
		ColourWheel* _tmp5_;
		_tmp3_ = colour_wheel_new (____lambda31__colour_wheel_result_function, _data2_);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->colour_wheel);
		self->priv->colour_wheel = _tmp3_;
		_tmp4_ = self->priv->overlay;
		_tmp5_ = self->priv->colour_wheel;
		gtk_overlay_add_overlay (_tmp4_, (GtkWidget*) _tmp5_);
	}
}

static void
___lambda30__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda30_ (self);
}

static gboolean
___lambda33_ (ControlsGrid* self,
              guint keyval,
              guint keycode,
              gboolean* remove_handler)
{
	gboolean _vala_remove_handler = FALSE;
	WormProperties* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	WormProperties* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkOverlay* _tmp8_;
	OverlayMessage* _tmp9_;
	gboolean result;
	_vala_remove_handler = TRUE;
	_tmp0_ = self->worm_props;
	_tmp1_ = worm_properties_get_up (_tmp0_);
	_tmp2_ = _tmp1_;
	if (keyval != _tmp2_) {
		WormProperties* _tmp3_;
		_tmp3_ = self->worm_props;
		worm_properties_set_up (_tmp3_, keyval);
	}
	_tmp4_ = self->worm_props;
	_tmp5_ = worm_properties_get_raw_up (_tmp4_);
	_tmp6_ = _tmp5_;
	if (keycode != ((guint) _tmp6_)) {
		WormProperties* _tmp7_;
		_tmp7_ = self->worm_props;
		worm_properties_set_raw_up (_tmp7_, (gint) keycode);
	}
	_tmp8_ = self->priv->overlay;
	_tmp9_ = self->priv->key_press_message;
	gtk_overlay_remove_overlay (_tmp8_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (self->priv->key_press_message);
	self->priv->key_press_message = NULL;
	result = TRUE;
	if (remove_handler) {
		*remove_handler = _vala_remove_handler;
	}
	return result;
}

static gboolean
____lambda33__keypress_handler_function (guint a,
                                         guint b,
                                         gboolean* remove_handler,
                                         gpointer self)
{
	gboolean result;
	result = ___lambda33_ ((ControlsGrid*) self, a, b, remove_handler);
	return result;
}

static void
__lambda32_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	gboolean _tmp0_ = FALSE;
	ColourWheel* _tmp1_;
	self = _data2_->self;
	_tmp1_ = self->priv->colour_wheel;
	if (NULL == _tmp1_) {
		OverlayMessage* _tmp2_;
		_tmp2_ = self->priv->key_press_message;
		_tmp0_ = NULL == _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		OverlayMessage* _tmp3_;
		GtkOverlay* _tmp4_;
		OverlayMessage* _tmp5_;
		_tmp3_ = overlay_message_new (_ ("Press a key for up."));
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->key_press_message);
		self->priv->key_press_message = _tmp3_;
		_tmp4_ = self->priv->overlay;
		_tmp5_ = self->priv->key_press_message;
		gtk_overlay_add_overlay (_tmp4_, (GtkWidget*) _tmp5_);
		g_signal_emit (_data2_->controls, controls_signals[CONTROLS_ADD_KEYPRESS_HANDLER_SIGNAL], 0, ____lambda33__keypress_handler_function, self);
	}
}

static void
___lambda32__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda32_ (self);
}

static gboolean
___lambda35_ (ControlsGrid* self,
              guint keyval,
              guint keycode,
              gboolean* remove_handler)
{
	gboolean _vala_remove_handler = FALSE;
	WormProperties* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	WormProperties* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkOverlay* _tmp8_;
	OverlayMessage* _tmp9_;
	gboolean result;
	_vala_remove_handler = TRUE;
	_tmp0_ = self->worm_props;
	_tmp1_ = worm_properties_get_down (_tmp0_);
	_tmp2_ = _tmp1_;
	if (keyval != _tmp2_) {
		WormProperties* _tmp3_;
		_tmp3_ = self->worm_props;
		worm_properties_set_down (_tmp3_, keyval);
	}
	_tmp4_ = self->worm_props;
	_tmp5_ = worm_properties_get_raw_down (_tmp4_);
	_tmp6_ = _tmp5_;
	if (keycode != ((guint) _tmp6_)) {
		WormProperties* _tmp7_;
		_tmp7_ = self->worm_props;
		worm_properties_set_raw_down (_tmp7_, (gint) keycode);
	}
	_tmp8_ = self->priv->overlay;
	_tmp9_ = self->priv->key_press_message;
	gtk_overlay_remove_overlay (_tmp8_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (self->priv->key_press_message);
	self->priv->key_press_message = NULL;
	result = TRUE;
	if (remove_handler) {
		*remove_handler = _vala_remove_handler;
	}
	return result;
}

static gboolean
____lambda35__keypress_handler_function (guint a,
                                         guint b,
                                         gboolean* remove_handler,
                                         gpointer self)
{
	gboolean result;
	result = ___lambda35_ ((ControlsGrid*) self, a, b, remove_handler);
	return result;
}

static void
__lambda34_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	gboolean _tmp0_ = FALSE;
	ColourWheel* _tmp1_;
	self = _data2_->self;
	_tmp1_ = self->priv->colour_wheel;
	if (NULL == _tmp1_) {
		OverlayMessage* _tmp2_;
		_tmp2_ = self->priv->key_press_message;
		_tmp0_ = NULL == _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		OverlayMessage* _tmp3_;
		GtkOverlay* _tmp4_;
		OverlayMessage* _tmp5_;
		_tmp3_ = overlay_message_new (_ ("Press a key for down."));
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->key_press_message);
		self->priv->key_press_message = _tmp3_;
		_tmp4_ = self->priv->overlay;
		_tmp5_ = self->priv->key_press_message;
		gtk_overlay_add_overlay (_tmp4_, (GtkWidget*) _tmp5_);
		g_signal_emit (_data2_->controls, controls_signals[CONTROLS_ADD_KEYPRESS_HANDLER_SIGNAL], 0, ____lambda35__keypress_handler_function, self);
	}
}

static void
___lambda34__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda34_ (self);
}

static gboolean
___lambda37_ (ControlsGrid* self,
              guint keyval,
              guint keycode,
              gboolean* remove_handler)
{
	gboolean _vala_remove_handler = FALSE;
	WormProperties* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	WormProperties* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkOverlay* _tmp8_;
	OverlayMessage* _tmp9_;
	gboolean result;
	_vala_remove_handler = TRUE;
	_tmp0_ = self->worm_props;
	_tmp1_ = worm_properties_get_left (_tmp0_);
	_tmp2_ = _tmp1_;
	if (keyval != _tmp2_) {
		WormProperties* _tmp3_;
		_tmp3_ = self->worm_props;
		worm_properties_set_left (_tmp3_, keyval);
	}
	_tmp4_ = self->worm_props;
	_tmp5_ = worm_properties_get_raw_left (_tmp4_);
	_tmp6_ = _tmp5_;
	if (keycode != ((guint) _tmp6_)) {
		WormProperties* _tmp7_;
		_tmp7_ = self->worm_props;
		worm_properties_set_raw_left (_tmp7_, (gint) keycode);
	}
	_tmp8_ = self->priv->overlay;
	_tmp9_ = self->priv->key_press_message;
	gtk_overlay_remove_overlay (_tmp8_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (self->priv->key_press_message);
	self->priv->key_press_message = NULL;
	result = TRUE;
	if (remove_handler) {
		*remove_handler = _vala_remove_handler;
	}
	return result;
}

static gboolean
____lambda37__keypress_handler_function (guint a,
                                         guint b,
                                         gboolean* remove_handler,
                                         gpointer self)
{
	gboolean result;
	result = ___lambda37_ ((ControlsGrid*) self, a, b, remove_handler);
	return result;
}

static void
__lambda36_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	gboolean _tmp0_ = FALSE;
	ColourWheel* _tmp1_;
	self = _data2_->self;
	_tmp1_ = self->priv->colour_wheel;
	if (NULL == _tmp1_) {
		OverlayMessage* _tmp2_;
		_tmp2_ = self->priv->key_press_message;
		_tmp0_ = NULL == _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		OverlayMessage* _tmp3_;
		GtkOverlay* _tmp4_;
		OverlayMessage* _tmp5_;
		_tmp3_ = overlay_message_new (_ ("Press a key for left."));
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->key_press_message);
		self->priv->key_press_message = _tmp3_;
		_tmp4_ = self->priv->overlay;
		_tmp5_ = self->priv->key_press_message;
		gtk_overlay_add_overlay (_tmp4_, (GtkWidget*) _tmp5_);
		g_signal_emit (_data2_->controls, controls_signals[CONTROLS_ADD_KEYPRESS_HANDLER_SIGNAL], 0, ____lambda37__keypress_handler_function, self);
	}
}

static void
___lambda36__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda36_ (self);
}

static gboolean
___lambda39_ (ControlsGrid* self,
              guint keyval,
              guint keycode,
              gboolean* remove_handler)
{
	gboolean _vala_remove_handler = FALSE;
	WormProperties* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	WormProperties* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GtkOverlay* _tmp8_;
	OverlayMessage* _tmp9_;
	gboolean result;
	_vala_remove_handler = TRUE;
	_tmp0_ = self->worm_props;
	_tmp1_ = worm_properties_get_right (_tmp0_);
	_tmp2_ = _tmp1_;
	if (keyval != _tmp2_) {
		WormProperties* _tmp3_;
		_tmp3_ = self->worm_props;
		worm_properties_set_right (_tmp3_, keyval);
	}
	_tmp4_ = self->worm_props;
	_tmp5_ = worm_properties_get_raw_right (_tmp4_);
	_tmp6_ = _tmp5_;
	if (keycode != ((guint) _tmp6_)) {
		WormProperties* _tmp7_;
		_tmp7_ = self->worm_props;
		worm_properties_set_raw_right (_tmp7_, (gint) keycode);
	}
	_tmp8_ = self->priv->overlay;
	_tmp9_ = self->priv->key_press_message;
	gtk_overlay_remove_overlay (_tmp8_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (self->priv->key_press_message);
	self->priv->key_press_message = NULL;
	result = TRUE;
	if (remove_handler) {
		*remove_handler = _vala_remove_handler;
	}
	return result;
}

static gboolean
____lambda39__keypress_handler_function (guint a,
                                         guint b,
                                         gboolean* remove_handler,
                                         gpointer self)
{
	gboolean result;
	result = ___lambda39_ ((ControlsGrid*) self, a, b, remove_handler);
	return result;
}

static void
__lambda38_ (Block2Data* _data2_)
{
	ControlsGrid* self;
	gboolean _tmp0_ = FALSE;
	ColourWheel* _tmp1_;
	self = _data2_->self;
	_tmp1_ = self->priv->colour_wheel;
	if (NULL == _tmp1_) {
		OverlayMessage* _tmp2_;
		_tmp2_ = self->priv->key_press_message;
		_tmp0_ = NULL == _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		OverlayMessage* _tmp3_;
		GtkOverlay* _tmp4_;
		OverlayMessage* _tmp5_;
		_tmp3_ = overlay_message_new (_ ("Press a key for right."));
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->key_press_message);
		self->priv->key_press_message = _tmp3_;
		_tmp4_ = self->priv->overlay;
		_tmp5_ = self->priv->key_press_message;
		gtk_overlay_add_overlay (_tmp4_, (GtkWidget*) _tmp5_);
		g_signal_emit (_data2_->controls, controls_signals[CONTROLS_ADD_KEYPRESS_HANDLER_SIGNAL], 0, ____lambda39__keypress_handler_function, self);
	}
}

static void
___lambda38__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda38_ (self);
}

ControlsGrid*
controls_grid_construct (GType object_type,
                         Controls* controls,
                         gint worm_id,
                         WormProperties* worm_props,
                         GeeHashMap* worms_props)
{
	ControlsGrid * self = NULL;
	Block2Data* _data2_;
	Controls* _tmp0_;
	WormProperties* _tmp1_;
	GeeHashMap* _tmp2_;
	Controls* _tmp3_;
	WormProperties* _tmp4_;
	gchar* _tmp5_;
	gulong _tmp6_;
	PangoColor color = {0};
	gint _tmp7_;
	gint _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkButton* _tmp11_;
	GtkWidget* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GtkDrawingArea* _tmp19_;
	GtkDrawingArea* _tmp20_;
	GtkDrawingArea* _tmp21_;
	GtkDrawingArea* _tmp22_;
	gulong _tmp23_;
	gulong _tmp24_;
	gulong _tmp25_;
	gulong _tmp26_;
	guint _tmp27_;
	guint _tmp28_;
	GtkButton* _tmp29_;
	GtkWidget* _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	GtkButton* _tmp33_;
	GtkWidget* _tmp34_;
	guint _tmp35_;
	guint _tmp36_;
	GtkButton* _tmp37_;
	GtkWidget* _tmp38_;
	guint _tmp39_;
	guint _tmp40_;
	GtkButton* _tmp41_;
	GtkWidget* _tmp42_;
	GtkButton* _tmp43_;
	GtkButton* _tmp44_;
	GtkButton* _tmp45_;
	GtkButton* _tmp46_;
	GtkButton* _tmp47_;
	g_return_val_if_fail (controls != NULL, NULL);
	g_return_val_if_fail (worm_props != NULL, NULL);
	g_return_val_if_fail (worms_props != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (controls);
	_g_object_unref0 (_data2_->controls);
	_data2_->controls = _tmp0_;
	_tmp1_ = _g_object_ref0 (worm_props);
	_g_object_unref0 (_data2_->worm_props);
	_data2_->worm_props = _tmp1_;
	_tmp2_ = _g_object_ref0 (worms_props);
	_g_object_unref0 (_data2_->worms_props);
	_data2_->worms_props = _tmp2_;
	self = (ControlsGrid*) g_object_new (object_type, NULL);
	_data2_->self = g_object_ref (self);
	_tmp3_ = _g_object_ref0 (_data2_->controls);
	_g_object_unref0 (self->controls);
	self->controls = _tmp3_;
	_tmp4_ = _g_object_ref0 (_data2_->worm_props);
	_g_object_unref0 (self->worm_props);
	self->worm_props = _tmp4_;
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 10);
	_tmp5_ = g_strdup_printf (_ ("Player %d"), worm_id + 1);
	_data2_->player_id = _tmp5_;
	_tmp6_ = g_signal_connect_data ((GObject*) _data2_->worm_props, "notify::color", (GCallback) ___lambda15__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	self->priv->color_handler = _tmp6_;
	memset (&color, 0, sizeof (PangoColor));
	_tmp7_ = worm_properties_get_color (_data2_->worm_props);
	_tmp8_ = _tmp7_;
	_tmp9_ = nibbles_view_colorval_name_untranslated (_tmp8_);
	_tmp10_ = _tmp9_;
	pango_color_parse (&color, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = self->priv->name_label;
	_tmp12_ = gtk_button_get_child (_tmp11_);
	_tmp13_ = pango_color_to_string (&color);
	_tmp14_ = _tmp13_;
	_tmp15_ = string_to_string (_tmp14_);
	_tmp16_ = string_to_string (_data2_->player_id);
	_tmp17_ = g_strconcat ("<b><span font-family=\"Sans\" color=\"", _tmp15_, "\">", _tmp16_, "</span></b>", NULL);
	_tmp18_ = _tmp17_;
	gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_label_get_type (), GtkLabel), _tmp18_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp14_);
	_tmp19_ = self->priv->arrow_up;
	gtk_drawing_area_set_draw_func (_tmp19_, ___lambda22__gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	_tmp20_ = self->priv->arrow_down;
	gtk_drawing_area_set_draw_func (_tmp20_, ___lambda23__gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	_tmp21_ = self->priv->arrow_left;
	gtk_drawing_area_set_draw_func (_tmp21_, ___lambda24__gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	_tmp22_ = self->priv->arrow_right;
	gtk_drawing_area_set_draw_func (_tmp22_, ___lambda25__gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	_tmp23_ = g_signal_connect_data ((GObject*) _data2_->worm_props, "notify::up", (GCallback) ___lambda26__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	self->priv->up_handler = _tmp23_;
	_tmp24_ = g_signal_connect_data ((GObject*) _data2_->worm_props, "notify::down", (GCallback) ___lambda27__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	self->priv->down_handler = _tmp24_;
	_tmp25_ = g_signal_connect_data ((GObject*) _data2_->worm_props, "notify::left", (GCallback) ___lambda28__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	self->priv->left_handler = _tmp25_;
	_tmp26_ = g_signal_connect_data ((GObject*) _data2_->worm_props, "notify::right", (GCallback) ___lambda29__g_object_notify, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	self->priv->right_handler = _tmp26_;
	_tmp27_ = worm_properties_get_up (_data2_->worm_props);
	_tmp28_ = _tmp27_;
	_tmp29_ = self->priv->move_up_button;
	_tmp30_ = gtk_button_get_child (_tmp29_);
	controls_grid_configure_label (_tmp28_, G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_label_get_type (), GtkLabel));
	_tmp31_ = worm_properties_get_down (_data2_->worm_props);
	_tmp32_ = _tmp31_;
	_tmp33_ = self->priv->move_down_button;
	_tmp34_ = gtk_button_get_child (_tmp33_);
	controls_grid_configure_label (_tmp32_, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_label_get_type (), GtkLabel));
	_tmp35_ = worm_properties_get_left (_data2_->worm_props);
	_tmp36_ = _tmp35_;
	_tmp37_ = self->priv->move_left_button;
	_tmp38_ = gtk_button_get_child (_tmp37_);
	controls_grid_configure_label (_tmp36_, G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, gtk_label_get_type (), GtkLabel));
	_tmp39_ = worm_properties_get_right (_data2_->worm_props);
	_tmp40_ = _tmp39_;
	_tmp41_ = self->priv->move_right_button;
	_tmp42_ = gtk_button_get_child (_tmp41_);
	controls_grid_configure_label (_tmp40_, G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_label_get_type (), GtkLabel));
	_tmp43_ = self->priv->name_label;
	g_signal_connect_data (_tmp43_, "clicked", (GCallback) ___lambda30__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp44_ = self->priv->move_up_button;
	g_signal_connect_data (_tmp44_, "clicked", (GCallback) ___lambda32__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp45_ = self->priv->move_down_button;
	g_signal_connect_data (_tmp45_, "clicked", (GCallback) ___lambda34__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp46_ = self->priv->move_left_button;
	g_signal_connect_data (_tmp46_, "clicked", (GCallback) ___lambda36__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	_tmp47_ = self->priv->move_right_button;
	g_signal_connect_data (_tmp47_, "clicked", (GCallback) ___lambda38__gtk_button_clicked, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return self;
}

ControlsGrid*
controls_grid_new (Controls* controls,
                   gint worm_id,
                   WormProperties* worm_props,
                   GeeHashMap* worms_props)
{
	return controls_grid_construct (TYPE_CONTROLS_GRID, controls, worm_id, worm_props, worms_props);
}

static void
controls_grid_draw_arrow (ControlsGrid* self,
                          guint d,
                          cairo_t* C,
                          gdouble width,
                          gdouble height)
{
	ControlsGridxy a[7] = {0};
	gboolean _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	if (d == ((guint) 0)) {
		ControlsGridxy _tmp0_ = {0};
		ControlsGridxy _tmp1_ = {0};
		ControlsGridxy _tmp2_ = {0};
		ControlsGridxy _tmp3_ = {0};
		ControlsGridxy _tmp4_ = {0};
		ControlsGridxy _tmp5_ = {0};
		ControlsGridxy _tmp6_ = {0};
		ControlsGridxy _tmp7_[7] = {0};
		memset (&_tmp0_, 0, sizeof (ControlsGridxy));
		_tmp0_.x = (gdouble) 0;
		_tmp0_.y = height / 2;
		memset (&_tmp1_, 0, sizeof (ControlsGridxy));
		_tmp1_.x = width / 2;
		_tmp1_.y = (gdouble) 0;
		memset (&_tmp2_, 0, sizeof (ControlsGridxy));
		_tmp2_.x = width;
		_tmp2_.y = height / 2;
		memset (&_tmp3_, 0, sizeof (ControlsGridxy));
		_tmp3_.x = (width * 2) / 3;
		_tmp3_.y = height / 2;
		memset (&_tmp4_, 0, sizeof (ControlsGridxy));
		_tmp4_.x = (width * 2) / 3;
		_tmp4_.y = height;
		memset (&_tmp5_, 0, sizeof (ControlsGridxy));
		_tmp5_.x = width / 3;
		_tmp5_.y = height;
		memset (&_tmp6_, 0, sizeof (ControlsGridxy));
		_tmp6_.x = width / 3;
		_tmp6_.y = height / 2;
		_tmp7_[0] = _tmp0_;
		_tmp7_[1] = _tmp1_;
		_tmp7_[2] = _tmp2_;
		_tmp7_[3] = _tmp3_;
		_tmp7_[4] = _tmp4_;
		_tmp7_[5] = _tmp5_;
		_tmp7_[6] = _tmp6_;
		memcpy (a, _tmp7_, 7 * sizeof (ControlsGridxy));
	} else {
		if (d == ((guint) 1)) {
			ControlsGridxy _tmp8_ = {0};
			ControlsGridxy _tmp9_ = {0};
			ControlsGridxy _tmp10_ = {0};
			ControlsGridxy _tmp11_ = {0};
			ControlsGridxy _tmp12_ = {0};
			ControlsGridxy _tmp13_ = {0};
			ControlsGridxy _tmp14_ = {0};
			ControlsGridxy _tmp15_[7] = {0};
			memset (&_tmp8_, 0, sizeof (ControlsGridxy));
			_tmp8_.x = (gdouble) 0;
			_tmp8_.y = height / 2;
			memset (&_tmp9_, 0, sizeof (ControlsGridxy));
			_tmp9_.x = width / 2;
			_tmp9_.y = height;
			memset (&_tmp10_, 0, sizeof (ControlsGridxy));
			_tmp10_.x = width;
			_tmp10_.y = height / 2;
			memset (&_tmp11_, 0, sizeof (ControlsGridxy));
			_tmp11_.x = (width * 2) / 3;
			_tmp11_.y = height / 2;
			memset (&_tmp12_, 0, sizeof (ControlsGridxy));
			_tmp12_.x = (width * 2) / 3;
			_tmp12_.y = (gdouble) 0;
			memset (&_tmp13_, 0, sizeof (ControlsGridxy));
			_tmp13_.x = width / 3;
			_tmp13_.y = (gdouble) 0;
			memset (&_tmp14_, 0, sizeof (ControlsGridxy));
			_tmp14_.x = width / 3;
			_tmp14_.y = height / 2;
			_tmp15_[0] = _tmp8_;
			_tmp15_[1] = _tmp9_;
			_tmp15_[2] = _tmp10_;
			_tmp15_[3] = _tmp11_;
			_tmp15_[4] = _tmp12_;
			_tmp15_[5] = _tmp13_;
			_tmp15_[6] = _tmp14_;
			memcpy (a, _tmp15_, 7 * sizeof (ControlsGridxy));
		} else {
			if (d == ((guint) 2)) {
				ControlsGridxy _tmp16_ = {0};
				ControlsGridxy _tmp17_ = {0};
				ControlsGridxy _tmp18_ = {0};
				ControlsGridxy _tmp19_ = {0};
				ControlsGridxy _tmp20_ = {0};
				ControlsGridxy _tmp21_ = {0};
				ControlsGridxy _tmp22_ = {0};
				ControlsGridxy _tmp23_[7] = {0};
				memset (&_tmp16_, 0, sizeof (ControlsGridxy));
				_tmp16_.x = width / 2;
				_tmp16_.y = (gdouble) 0;
				memset (&_tmp17_, 0, sizeof (ControlsGridxy));
				_tmp17_.x = (gdouble) 0;
				_tmp17_.y = height / 2;
				memset (&_tmp18_, 0, sizeof (ControlsGridxy));
				_tmp18_.x = width / 2;
				_tmp18_.y = height;
				memset (&_tmp19_, 0, sizeof (ControlsGridxy));
				_tmp19_.x = width / 2;
				_tmp19_.y = (height * 2) / 3;
				memset (&_tmp20_, 0, sizeof (ControlsGridxy));
				_tmp20_.x = width;
				_tmp20_.y = (height * 2) / 3;
				memset (&_tmp21_, 0, sizeof (ControlsGridxy));
				_tmp21_.x = width;
				_tmp21_.y = height / 3;
				memset (&_tmp22_, 0, sizeof (ControlsGridxy));
				_tmp22_.x = width / 2;
				_tmp22_.y = height / 3;
				_tmp23_[0] = _tmp16_;
				_tmp23_[1] = _tmp17_;
				_tmp23_[2] = _tmp18_;
				_tmp23_[3] = _tmp19_;
				_tmp23_[4] = _tmp20_;
				_tmp23_[5] = _tmp21_;
				_tmp23_[6] = _tmp22_;
				memcpy (a, _tmp23_, 7 * sizeof (ControlsGridxy));
			} else {
				ControlsGridxy _tmp24_ = {0};
				ControlsGridxy _tmp25_ = {0};
				ControlsGridxy _tmp26_ = {0};
				ControlsGridxy _tmp27_ = {0};
				ControlsGridxy _tmp28_ = {0};
				ControlsGridxy _tmp29_ = {0};
				ControlsGridxy _tmp30_ = {0};
				ControlsGridxy _tmp31_[7] = {0};
				memset (&_tmp24_, 0, sizeof (ControlsGridxy));
				_tmp24_.x = width / 2;
				_tmp24_.y = (gdouble) 0;
				memset (&_tmp25_, 0, sizeof (ControlsGridxy));
				_tmp25_.x = width;
				_tmp25_.y = height / 2;
				memset (&_tmp26_, 0, sizeof (ControlsGridxy));
				_tmp26_.x = width / 2;
				_tmp26_.y = height;
				memset (&_tmp27_, 0, sizeof (ControlsGridxy));
				_tmp27_.x = width / 2;
				_tmp27_.y = (height * 2) / 3;
				memset (&_tmp28_, 0, sizeof (ControlsGridxy));
				_tmp28_.x = (gdouble) 0;
				_tmp28_.y = (height * 2) / 3;
				memset (&_tmp29_, 0, sizeof (ControlsGridxy));
				_tmp29_.x = (gdouble) 0;
				_tmp29_.y = height / 3;
				memset (&_tmp30_, 0, sizeof (ControlsGridxy));
				_tmp30_.x = width / 2;
				_tmp30_.y = height / 3;
				_tmp31_[0] = _tmp24_;
				_tmp31_[1] = _tmp25_;
				_tmp31_[2] = _tmp26_;
				_tmp31_[3] = _tmp27_;
				_tmp31_[4] = _tmp28_;
				_tmp31_[5] = _tmp29_;
				_tmp31_[6] = _tmp30_;
				memcpy (a, _tmp31_, 7 * sizeof (ControlsGridxy));
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				if (!(i < 7)) {
					break;
				}
				if (i == 0) {
					ControlsGridxy _tmp34_;
					ControlsGridxy _tmp35_;
					_tmp34_ = a[0];
					_tmp35_ = a[0];
					cairo_move_to (C, _tmp34_.x, _tmp35_.y);
				} else {
					ControlsGridxy _tmp36_;
					ControlsGridxy _tmp37_;
					_tmp36_ = a[i];
					_tmp37_ = a[i];
					cairo_line_to (C, _tmp36_.x, _tmp37_.y);
				}
			}
		}
	}
	_tmp38_ = self->priv->duplicate[d];
	if (_tmp38_) {
		cairo_set_source_rgba (C, 0.75, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	} else {
		cairo_set_source_rgba (C, 0.2890625, 0.5625, 0.84765625, (gdouble) 1);
	}
	cairo_fill (C);
}

void
controls_grid_mark_duplicated_keys (ControlsGrid* self,
                                    GHashTable* duplicate_keys)
{
	gboolean d = FALSE;
	WormProperties* _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	gboolean _tmp3_;
	WormProperties* _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	gboolean _tmp8_;
	WormProperties* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	gboolean _tmp13_;
	WormProperties* _tmp15_;
	guint _tmp16_;
	guint _tmp17_;
	gboolean _tmp18_;
	WormProperties* _tmp20_;
	guint _tmp21_;
	guint _tmp22_;
	GtkButton* _tmp23_;
	GtkWidget* _tmp24_;
	WormProperties* _tmp25_;
	guint _tmp26_;
	guint _tmp27_;
	GtkButton* _tmp28_;
	GtkWidget* _tmp29_;
	WormProperties* _tmp30_;
	guint _tmp31_;
	guint _tmp32_;
	GtkButton* _tmp33_;
	GtkWidget* _tmp34_;
	WormProperties* _tmp35_;
	guint _tmp36_;
	guint _tmp37_;
	GtkButton* _tmp38_;
	GtkWidget* _tmp39_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (duplicate_keys != NULL);
	_tmp0_ = self->worm_props;
	_tmp1_ = worm_properties_get_up (_tmp0_);
	_tmp2_ = _tmp1_;
	d = g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp2_));
	_tmp3_ = self->priv->duplicate[0];
	if (d != _tmp3_) {
		GtkDrawingArea* _tmp4_;
		self->priv->duplicate[0] = d;
		_tmp4_ = self->priv->arrow_up;
		gtk_widget_queue_draw ((GtkWidget*) _tmp4_);
	}
	_tmp5_ = self->worm_props;
	_tmp6_ = worm_properties_get_down (_tmp5_);
	_tmp7_ = _tmp6_;
	d = g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp7_));
	_tmp8_ = self->priv->duplicate[1];
	if (d != _tmp8_) {
		GtkDrawingArea* _tmp9_;
		self->priv->duplicate[1] = d;
		_tmp9_ = self->priv->arrow_down;
		gtk_widget_queue_draw ((GtkWidget*) _tmp9_);
	}
	_tmp10_ = self->worm_props;
	_tmp11_ = worm_properties_get_left (_tmp10_);
	_tmp12_ = _tmp11_;
	d = g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp12_));
	_tmp13_ = self->priv->duplicate[2];
	if (d != _tmp13_) {
		GtkDrawingArea* _tmp14_;
		self->priv->duplicate[2] = d;
		_tmp14_ = self->priv->arrow_left;
		gtk_widget_queue_draw ((GtkWidget*) _tmp14_);
	}
	_tmp15_ = self->worm_props;
	_tmp16_ = worm_properties_get_right (_tmp15_);
	_tmp17_ = _tmp16_;
	d = g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp17_));
	_tmp18_ = self->priv->duplicate[3];
	if (d != _tmp18_) {
		GtkDrawingArea* _tmp19_;
		self->priv->duplicate[3] = d;
		_tmp19_ = self->priv->arrow_right;
		gtk_widget_queue_draw ((GtkWidget*) _tmp19_);
	}
	_tmp20_ = self->worm_props;
	_tmp21_ = worm_properties_get_up (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = self->priv->move_up_button;
	_tmp24_ = gtk_button_get_child (_tmp23_);
	controls_grid_set_duplicate_class (self, g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp22_)), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_label_get_type (), GtkLabel));
	_tmp25_ = self->worm_props;
	_tmp26_ = worm_properties_get_down (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = self->priv->move_down_button;
	_tmp29_ = gtk_button_get_child (_tmp28_);
	controls_grid_set_duplicate_class (self, g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp27_)), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_label_get_type (), GtkLabel));
	_tmp30_ = self->worm_props;
	_tmp31_ = worm_properties_get_left (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = self->priv->move_left_button;
	_tmp34_ = gtk_button_get_child (_tmp33_);
	controls_grid_set_duplicate_class (self, g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp32_)), G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_label_get_type (), GtkLabel));
	_tmp35_ = self->worm_props;
	_tmp36_ = worm_properties_get_right (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = self->priv->move_right_button;
	_tmp39_ = gtk_button_get_child (_tmp38_);
	controls_grid_set_duplicate_class (self, g_hash_table_contains (duplicate_keys, (gpointer) ((guintptr) _tmp37_)), G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_label_get_type (), GtkLabel));
}

static void
controls_grid_set_duplicate_class (ControlsGrid* self,
                                   gboolean duplicate,
                                   GtkLabel* label)
{
	PangoAttrList* _tmp0_;
	PangoAttrList* _tmp1_;
	PangoAttrList* _tmp2_;
	PangoAttrList* _tmp3_;
	PangoAttribute* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (label != NULL);
	_tmp0_ = pango_attr_list_new ();
	_tmp1_ = _tmp0_;
	gtk_label_set_attributes (label, _tmp1_);
	_pango_attr_list_unref0 (_tmp1_);
	_tmp2_ = gtk_label_get_attributes (label);
	_tmp3_ = _tmp2_;
	_tmp4_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
	pango_attr_list_insert (_tmp3_, _tmp4_);
	if (duplicate) {
		PangoAttrList* _tmp5_;
		PangoAttrList* _tmp6_;
		PangoAttribute* _tmp7_;
		_tmp5_ = gtk_label_get_attributes (label);
		_tmp6_ = _tmp5_;
		_tmp7_ = pango_attr_foreground_new ((guint16) 0xffff, (guint16) 0, (guint16) 0);
		pango_attr_list_insert (_tmp6_, _tmp7_);
	} else {
		PangoAttrList* _tmp8_;
		PangoAttrList* _tmp9_;
		PangoAttribute* _tmp10_;
		_tmp8_ = gtk_label_get_attributes (label);
		_tmp9_ = _tmp8_;
		_tmp10_ = pango_attr_foreground_new ((guint16) 0xffff, (guint16) 0xffff, (guint16) 0xffff);
		pango_attr_list_insert (_tmp9_, _tmp10_);
	}
}

void
controls_grid_disconnect_stuff (ControlsGrid* self)
{
	WormProperties* _tmp0_;
	WormProperties* _tmp1_;
	WormProperties* _tmp2_;
	WormProperties* _tmp3_;
	WormProperties* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->worm_props;
	g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->up_handler);
	_tmp1_ = self->worm_props;
	g_signal_handler_disconnect ((GObject*) _tmp1_, self->priv->down_handler);
	_tmp2_ = self->worm_props;
	g_signal_handler_disconnect ((GObject*) _tmp2_, self->priv->left_handler);
	_tmp3_ = self->worm_props;
	g_signal_handler_disconnect ((GObject*) _tmp3_, self->priv->right_handler);
	_tmp4_ = self->worm_props;
	g_signal_handler_disconnect ((GObject*) _tmp4_, self->priv->color_handler);
}

static void
controls_grid_configure_label (guint key_value,
                               GtkLabel* label)
{
	gchar* key_name = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (label != NULL);
	_tmp0_ = gdk_keyval_name (key_value);
	_tmp1_ = g_strdup (_tmp0_);
	key_name = _tmp1_;
	_tmp2_ = key_name;
	if (g_strcmp0 (_tmp2_, "Up") == 0) {
		PangoAttrList* _tmp3_;
		PangoAttrList* _tmp4_;
		PangoAttrList* _tmp7_;
		PangoAttrList* _tmp8_;
		PangoAttribute* _tmp9_;
		PangoAttrList* _tmp10_;
		PangoAttrList* _tmp11_;
		PangoAttribute* _tmp12_;
		_tmp3_ = gtk_label_get_attributes (label);
		_tmp4_ = _tmp3_;
		if (_tmp4_ == NULL) {
			PangoAttrList* _tmp5_;
			PangoAttrList* _tmp6_;
			_tmp5_ = pango_attr_list_new ();
			_tmp6_ = _tmp5_;
			gtk_label_set_attributes (label, _tmp6_);
			_pango_attr_list_unref0 (_tmp6_);
		}
		_tmp7_ = gtk_label_get_attributes (label);
		_tmp8_ = _tmp7_;
		_tmp9_ = pango_attr_scale_new (PANGO_SCALE_X_LARGE);
		pango_attr_list_insert (_tmp8_, _tmp9_);
		_tmp10_ = gtk_label_get_attributes (label);
		_tmp11_ = _tmp10_;
		_tmp12_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
		pango_attr_list_insert (_tmp11_, _tmp12_);
		gtk_label_set_text (label, "↑");
	} else {
		const gchar* _tmp13_;
		_tmp13_ = key_name;
		if (g_strcmp0 (_tmp13_, "Down") == 0) {
			PangoAttrList* _tmp14_;
			PangoAttrList* _tmp15_;
			PangoAttrList* _tmp18_;
			PangoAttrList* _tmp19_;
			PangoAttribute* _tmp20_;
			PangoAttrList* _tmp21_;
			PangoAttrList* _tmp22_;
			PangoAttribute* _tmp23_;
			_tmp14_ = gtk_label_get_attributes (label);
			_tmp15_ = _tmp14_;
			if (_tmp15_ == NULL) {
				PangoAttrList* _tmp16_;
				PangoAttrList* _tmp17_;
				_tmp16_ = pango_attr_list_new ();
				_tmp17_ = _tmp16_;
				gtk_label_set_attributes (label, _tmp17_);
				_pango_attr_list_unref0 (_tmp17_);
			}
			_tmp18_ = gtk_label_get_attributes (label);
			_tmp19_ = _tmp18_;
			_tmp20_ = pango_attr_scale_new (PANGO_SCALE_X_LARGE);
			pango_attr_list_insert (_tmp19_, _tmp20_);
			_tmp21_ = gtk_label_get_attributes (label);
			_tmp22_ = _tmp21_;
			_tmp23_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
			pango_attr_list_insert (_tmp22_, _tmp23_);
			gtk_label_set_text (label, "↓");
		} else {
			const gchar* _tmp24_;
			_tmp24_ = key_name;
			if (g_strcmp0 (_tmp24_, "Left") == 0) {
				PangoAttrList* _tmp25_;
				PangoAttrList* _tmp26_;
				PangoAttrList* _tmp29_;
				PangoAttrList* _tmp30_;
				PangoAttribute* _tmp31_;
				PangoAttrList* _tmp32_;
				PangoAttrList* _tmp33_;
				PangoAttribute* _tmp34_;
				_tmp25_ = gtk_label_get_attributes (label);
				_tmp26_ = _tmp25_;
				if (_tmp26_ == NULL) {
					PangoAttrList* _tmp27_;
					PangoAttrList* _tmp28_;
					_tmp27_ = pango_attr_list_new ();
					_tmp28_ = _tmp27_;
					gtk_label_set_attributes (label, _tmp28_);
					_pango_attr_list_unref0 (_tmp28_);
				}
				_tmp29_ = gtk_label_get_attributes (label);
				_tmp30_ = _tmp29_;
				_tmp31_ = pango_attr_scale_new (PANGO_SCALE_X_LARGE);
				pango_attr_list_insert (_tmp30_, _tmp31_);
				_tmp32_ = gtk_label_get_attributes (label);
				_tmp33_ = _tmp32_;
				_tmp34_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
				pango_attr_list_insert (_tmp33_, _tmp34_);
				gtk_label_set_text (label, "←");
			} else {
				const gchar* _tmp35_;
				_tmp35_ = key_name;
				if (g_strcmp0 (_tmp35_, "Right") == 0) {
					PangoAttrList* _tmp36_;
					PangoAttrList* _tmp37_;
					PangoAttrList* _tmp40_;
					PangoAttrList* _tmp41_;
					PangoAttribute* _tmp42_;
					PangoAttrList* _tmp43_;
					PangoAttrList* _tmp44_;
					PangoAttribute* _tmp45_;
					_tmp36_ = gtk_label_get_attributes (label);
					_tmp37_ = _tmp36_;
					if (_tmp37_ == NULL) {
						PangoAttrList* _tmp38_;
						PangoAttrList* _tmp39_;
						_tmp38_ = pango_attr_list_new ();
						_tmp39_ = _tmp38_;
						gtk_label_set_attributes (label, _tmp39_);
						_pango_attr_list_unref0 (_tmp39_);
					}
					_tmp40_ = gtk_label_get_attributes (label);
					_tmp41_ = _tmp40_;
					_tmp42_ = pango_attr_scale_new (PANGO_SCALE_X_LARGE);
					pango_attr_list_insert (_tmp41_, _tmp42_);
					_tmp43_ = gtk_label_get_attributes (label);
					_tmp44_ = _tmp43_;
					_tmp45_ = pango_attr_weight_new (PANGO_WEIGHT_BOLD);
					pango_attr_list_insert (_tmp44_, _tmp45_);
					gtk_label_set_text (label, "→");
				} else {
					gboolean _tmp46_ = FALSE;
					const gchar* _tmp47_;
					_tmp47_ = key_name;
					if (_tmp47_ == NULL) {
						_tmp46_ = TRUE;
					} else {
						const gchar* _tmp48_;
						_tmp48_ = key_name;
						_tmp46_ = g_strcmp0 (_tmp48_, "") == 0;
					}
					if (_tmp46_) {
						gtk_label_set_attributes (label, NULL);
						gtk_label_set_text (label, "");
					} else {
						gchar* _tmp49_;
						gchar* _tmp50_;
						const gchar* _tmp51_;
						gtk_label_set_attributes (label, NULL);
						_tmp49_ = gtk_accelerator_get_label (key_value, 0);
						_tmp50_ = _tmp49_;
						_tmp51_ = string_to_string (_tmp50_);
						gtk_label_set_text (label, _tmp51_);
						_g_free0 (_tmp50_);
					}
				}
			}
		}
	}
	_g_free0 (key_name);
}

static ControlsGridxy*
controls_grid_xy_dup (const ControlsGridxy* self)
{
	ControlsGridxy* dup;
	dup = g_new0 (ControlsGridxy, 1);
	memcpy (dup, self, sizeof (ControlsGridxy));
	return dup;
}

static void
controls_grid_xy_free (ControlsGridxy* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
controls_grid_xy_get_type_once (void)
{
	GType controls_grid_xy_type_id;
	controls_grid_xy_type_id = g_boxed_type_register_static ("ControlsGridxy", (GBoxedCopyFunc) controls_grid_xy_dup, (GBoxedFreeFunc) controls_grid_xy_free);
	return controls_grid_xy_type_id;
}

static GType
controls_grid_xy_get_type (void)
{
	static gsize controls_grid_xy_type_id__once = 0;
	if (g_once_init_enter (&controls_grid_xy_type_id__once)) {
		GType controls_grid_xy_type_id;
		controls_grid_xy_type_id = controls_grid_xy_get_type_once ();
		g_once_init_leave (&controls_grid_xy_type_id__once, controls_grid_xy_type_id);
	}
	return controls_grid_xy_type_id__once;
}

static void
controls_grid_class_init (ControlsGridClass * klass,
                          gpointer klass_data)
{
	controls_grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ControlsGrid_private_offset);
	G_OBJECT_CLASS (klass)->finalize = controls_grid_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/controls-grid.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_label", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_up", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_up));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_down", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_down));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_left", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_left));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "arrow_right", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, arrow_right));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_up_button", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_up_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_down_button", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_down_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_left_button", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_left_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "move_right_button", FALSE, ControlsGrid_private_offset + G_STRUCT_OFFSET (ControlsGridPrivate, move_right_button));
}

static void
controls_grid_instance_init (ControlsGrid * self,
                             gpointer klass)
{
	self->priv = controls_grid_get_instance_private (self);
	self->priv->colour_wheel = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
controls_grid_finalize (GObject * obj)
{
	ControlsGrid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTROLS_GRID, ControlsGrid);
	_g_object_unref0 (self->controls);
	_g_object_unref0 (self->worm_props);
	_g_object_unref0 (self->priv->colour_wheel);
	_g_object_unref0 (self->priv->key_press_message);
	G_OBJECT_CLASS (controls_grid_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
controls_grid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ControlsGridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) controls_grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ControlsGrid), 0, (GInstanceInitFunc) controls_grid_instance_init, NULL };
	GType controls_grid_type_id;
	controls_grid_type_id = g_type_register_static (gtk_frame_get_type (), "ControlsGrid", &g_define_type_info, 0);
	ControlsGrid_private_offset = g_type_add_instance_private (controls_grid_type_id, sizeof (ControlsGridPrivate));
	return controls_grid_type_id;
}

GType
controls_grid_get_type (void)
{
	static gsize controls_grid_type_id__once = 0;
	if (g_once_init_enter (&controls_grid_type_id__once)) {
		GType controls_grid_type_id;
		controls_grid_type_id = controls_grid_get_type_once ();
		g_once_init_leave (&controls_grid_type_id__once, controls_grid_type_id);
	}
	return controls_grid_type_id__once;
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		OverlayMessage* self;
		self = _data3_->self;
		_g_free0 (_data3_->text);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda8_ (Block3Data* _data3_,
            GtkDrawingArea* area,
            cairo_t* C,
            gint width,
            gint height)
{
	OverlayMessage* self;
	static const gdouble PI2 = 1.570796326794896619231321691639751442;
	static const gdouble border_width = (gdouble) 3;
	gdouble text_width = 0.0;
	gdouble text_height = 0.0;
	gint font_size = 0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gint _tmp2_;
	gdouble _tmp3_ = 0.0;
	gdouble minimum_dimension = 0.0;
	gdouble background_width = 0.0;
	gdouble background_height = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble arc_radius = 0.0;
	self = _data3_->self;
	g_return_if_fail (area != NULL);
	g_return_if_fail (C != NULL);
	_tmp2_ = overlay_message_calculate_font_size (self, C, _data3_->text, (width / 3) * 2, &_tmp0_, &_tmp1_);
	text_width = _tmp0_;
	text_height = _tmp1_;
	font_size = _tmp2_;
	if (text_width < text_height) {
		_tmp3_ = text_width;
	} else {
		_tmp3_ = text_height;
	}
	minimum_dimension = _tmp3_;
	background_width = text_width + (minimum_dimension * 2);
	background_height = text_height + (minimum_dimension * 2);
	x = (width - background_width) / 2;
	y = (height - background_height) / 2;
	if (background_width < background_height) {
		_tmp4_ = background_width / 3;
	} else {
		_tmp4_ = background_height / 3;
	}
	arc_radius = _tmp4_;
	cairo_arc (C, (x + background_width) - arc_radius, y + arc_radius, arc_radius, -PI2, (gdouble) 0);
	cairo_arc (C, (x + background_width) - arc_radius, (y + background_height) - arc_radius, arc_radius, (gdouble) 0, PI2);
	cairo_arc (C, x + arc_radius, (y + background_height) - arc_radius, arc_radius, PI2, PI2 * 2);
	cairo_arc (C, x + arc_radius, y + arc_radius, arc_radius, PI2 * 2, -PI2);
	cairo_set_source_rgba (C, 0.5, 0.5, 0.5, (gdouble) 1);
	cairo_fill (C);
	cairo_arc (C, (x + background_width) - arc_radius, y + arc_radius, arc_radius - border_width, -PI2, (gdouble) 0);
	cairo_arc (C, (x + background_width) - arc_radius, (y + background_height) - arc_radius, arc_radius - border_width, (gdouble) 0, PI2);
	cairo_arc (C, x + arc_radius, (y + background_height) - arc_radius, arc_radius - border_width, PI2, PI2 * 2);
	cairo_arc (C, x + arc_radius, y + arc_radius, arc_radius - border_width, PI2 * 2, -PI2);
	cairo_set_source_rgba (C, 0.125, 0.125, 0.125, (gdouble) 1);
	cairo_fill (C);
	overlay_message_draw_text_font_size (self, C, (gint) (x + ((background_width - text_width) / 2)), (gint) ((y + (background_height / 2)) - (text_height / 2)), _data3_->text, font_size);
}

static void
___lambda8__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                        cairo_t* cr,
                                        gint width,
                                        gint height,
                                        gpointer self)
{
	__lambda8_ (self, drawing_area, cr, width, height);
}

OverlayMessage*
overlay_message_construct (GType object_type,
                           const gchar* text)
{
	OverlayMessage * self = NULL;
	Block3Data* _data3_;
	gchar* _tmp0_;
	g_return_val_if_fail (text != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = g_strdup (text);
	_g_free0 (_data3_->text);
	_data3_->text = _tmp0_;
	self = (OverlayMessage*) g_object_new (object_type, NULL);
	_data3_->self = g_object_ref (self);
	gtk_drawing_area_set_draw_func ((GtkDrawingArea*) self, ___lambda8__gtk_drawing_area_draw_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return self;
}

OverlayMessage*
overlay_message_new (const gchar* text)
{
	return overlay_message_construct (TYPE_OVERLAY_MESSAGE, text);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static gint
overlay_message_calculate_font_size (OverlayMessage* self,
                                     cairo_t* C,
                                     const gchar* text,
                                     gint target_width,
                                     gdouble* width,
                                     gdouble* height)
{
	gdouble _vala_width = 0.0;
	gdouble _vala_height = 0.0;
	gint target_font_size = 0;
	guint target_width_diff = 0U;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (C != NULL, 0);
	g_return_val_if_fail (text != NULL, 0);
	target_font_size = 1;
	target_width_diff = G_MAXUINT;
	_vala_width = (gdouble) 0;
	_vala_height = (gdouble) 0;
	{
		gint font_size = 0;
		font_size = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				PangoLayout* layout = NULL;
				PangoLayout* _tmp1_;
				PangoFontDescription* font = NULL;
				PangoLayout* _tmp2_;
				PangoFontDescription* _tmp3_;
				PangoFontDescription* _tmp8_;
				PangoLayout* _tmp9_;
				PangoFontDescription* _tmp10_;
				PangoLayout* _tmp11_;
				PangoLayout* _tmp12_;
				PangoRectangle a = {0};
				PangoRectangle b = {0};
				PangoLayout* _tmp13_;
				PangoRectangle _tmp14_ = {0};
				PangoRectangle _tmp15_ = {0};
				PangoRectangle _tmp16_;
				PangoRectangle _tmp17_;
				guint width_diff = 0U;
				PangoRectangle _tmp18_;
				gboolean _tmp19_ = FALSE;
				if (!_tmp0_) {
				}
				_tmp0_ = FALSE;
				if (!(font_size < 200)) {
					break;
				}
				_tmp1_ = pango_cairo_create_layout (C);
				layout = _tmp1_;
				_tmp2_ = layout;
				_tmp3_ = pango_layout_get_font_description (_tmp2_);
				if (NULL == _tmp3_) {
					PangoFontDescription* _tmp4_;
					_tmp4_ = pango_font_description_from_string ("Sans Bold 1pt");
					__vala_PangoFontDescription_free0 (font);
					font = _tmp4_;
				} else {
					PangoLayout* _tmp5_;
					PangoFontDescription* _tmp6_;
					PangoFontDescription* _tmp7_;
					_tmp5_ = layout;
					_tmp6_ = pango_layout_get_font_description (_tmp5_);
					_tmp7_ = pango_font_description_copy (_tmp6_);
					__vala_PangoFontDescription_free0 (font);
					font = _tmp7_;
				}
				_tmp8_ = font;
				pango_font_description_set_size (_tmp8_, PANGO_SCALE * font_size);
				_tmp9_ = layout;
				_tmp10_ = font;
				pango_layout_set_font_description (_tmp9_, _tmp10_);
				_tmp11_ = layout;
				pango_layout_set_text (_tmp11_, text, -1);
				_tmp12_ = layout;
				pango_cairo_update_layout (C, _tmp12_);
				_tmp13_ = layout;
				pango_layout_get_extents (_tmp13_, &_tmp14_, &_tmp15_);
				a = _tmp14_;
				b = _tmp15_;
				_tmp16_ = a;
				_vala_width = (gdouble) (_tmp16_.width / PANGO_SCALE);
				_tmp17_ = a;
				_vala_height = (gdouble) (_tmp17_.height / PANGO_SCALE);
				_tmp18_ = a;
				width_diff = (guint) abs (target_width - (((gint) _tmp18_.width) / PANGO_SCALE));
				if (width_diff > target_width_diff) {
					_tmp19_ = (width_diff - target_width_diff) > ((guint) 2);
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					__vala_PangoFontDescription_free0 (font);
					_g_object_unref0 (layout);
					break;
				} else {
					if (width_diff < target_width_diff) {
						target_width_diff = width_diff;
						target_font_size = font_size;
					}
				}
				if (font_size < 20) {
					gint _tmp20_;
					_tmp20_ = font_size;
					font_size = _tmp20_ + 1;
				} else {
					if (font_size < 50) {
						font_size += 5;
					} else {
						font_size += 10;
					}
				}
				__vala_PangoFontDescription_free0 (font);
				_g_object_unref0 (layout);
			}
		}
	}
	result = target_font_size;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	return result;
}

static void
overlay_message_draw_text_font_size (OverlayMessage* self,
                                     cairo_t* C,
                                     gint x,
                                     gint y,
                                     const gchar* text,
                                     gint font_size)
{
	gint x_offset = 0;
	gint y_offset = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp2_;
	PangoFontDescription* font = NULL;
	PangoLayout* _tmp3_;
	PangoFontDescription* _tmp4_;
	PangoFontDescription* _tmp9_;
	PangoLayout* _tmp10_;
	PangoFontDescription* _tmp11_;
	PangoLayout* _tmp12_;
	PangoLayout* _tmp13_;
	PangoLayout* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	g_return_if_fail (text != NULL);
	overlay_message_get_text_offsets (self, C, text, font_size, &_tmp0_, &_tmp1_);
	x_offset = _tmp0_;
	y_offset = _tmp1_;
	cairo_move_to (C, (gdouble) (x - x_offset), (gdouble) (y - y_offset));
	cairo_set_source_rgb (C, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp2_ = pango_cairo_create_layout (C);
	layout = _tmp2_;
	_tmp3_ = layout;
	_tmp4_ = pango_layout_get_font_description (_tmp3_);
	if (NULL == _tmp4_) {
		PangoFontDescription* _tmp5_;
		_tmp5_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (font);
		font = _tmp5_;
	} else {
		PangoLayout* _tmp6_;
		PangoFontDescription* _tmp7_;
		PangoFontDescription* _tmp8_;
		_tmp6_ = layout;
		_tmp7_ = pango_layout_get_font_description (_tmp6_);
		_tmp8_ = pango_font_description_copy (_tmp7_);
		__vala_PangoFontDescription_free0 (font);
		font = _tmp8_;
	}
	_tmp9_ = font;
	pango_font_description_set_size (_tmp9_, PANGO_SCALE * font_size);
	_tmp10_ = layout;
	_tmp11_ = font;
	pango_layout_set_font_description (_tmp10_, _tmp11_);
	_tmp12_ = layout;
	pango_layout_set_text (_tmp12_, text, -1);
	_tmp13_ = layout;
	pango_cairo_update_layout (C, _tmp13_);
	_tmp14_ = layout;
	pango_cairo_show_layout (C, _tmp14_);
	__vala_PangoFontDescription_free0 (font);
	_g_object_unref0 (layout);
}

static void
overlay_message_get_text_offsets (OverlayMessage* self,
                                  cairo_t* C,
                                  const gchar* text,
                                  gint font_size,
                                  gint* x_offset,
                                  gint* y_offset)
{
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	PangoFontDescription* font = NULL;
	PangoLayout* _tmp1_;
	PangoFontDescription* _tmp2_;
	PangoFontDescription* _tmp7_;
	PangoLayout* _tmp8_;
	PangoFontDescription* _tmp9_;
	PangoLayout* _tmp10_;
	PangoLayout* _tmp11_;
	PangoRectangle a = {0};
	PangoRectangle b = {0};
	PangoLayout* _tmp12_;
	PangoRectangle _tmp13_ = {0};
	PangoRectangle _tmp14_ = {0};
	PangoRectangle _tmp15_;
	PangoRectangle _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = pango_cairo_create_layout (C);
	layout = _tmp0_;
	_tmp1_ = layout;
	_tmp2_ = pango_layout_get_font_description (_tmp1_);
	if (NULL == _tmp2_) {
		PangoFontDescription* _tmp3_;
		_tmp3_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (font);
		font = _tmp3_;
	} else {
		PangoLayout* _tmp4_;
		PangoFontDescription* _tmp5_;
		PangoFontDescription* _tmp6_;
		_tmp4_ = layout;
		_tmp5_ = pango_layout_get_font_description (_tmp4_);
		_tmp6_ = pango_font_description_copy (_tmp5_);
		__vala_PangoFontDescription_free0 (font);
		font = _tmp6_;
	}
	_tmp7_ = font;
	pango_font_description_set_size (_tmp7_, PANGO_SCALE * font_size);
	_tmp8_ = layout;
	_tmp9_ = font;
	pango_layout_set_font_description (_tmp8_, _tmp9_);
	_tmp10_ = layout;
	pango_layout_set_text (_tmp10_, text, -1);
	_tmp11_ = layout;
	pango_cairo_update_layout (C, _tmp11_);
	_tmp12_ = layout;
	pango_layout_get_extents (_tmp12_, &_tmp13_, &_tmp14_);
	a = _tmp13_;
	b = _tmp14_;
	_tmp15_ = a;
	_vala_x_offset = _tmp15_.x / PANGO_SCALE;
	_tmp16_ = a;
	_vala_y_offset = _tmp16_.y / PANGO_SCALE;
	__vala_PangoFontDescription_free0 (font);
	_g_object_unref0 (layout);
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
}

static void
overlay_message_class_init (OverlayMessageClass * klass,
                            gpointer klass_data)
{
	overlay_message_parent_class = g_type_class_peek_parent (klass);
}

static void
overlay_message_instance_init (OverlayMessage * self,
                               gpointer klass)
{
}

 G_GNUC_NO_INLINE static GType
overlay_message_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (OverlayMessageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) overlay_message_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OverlayMessage), 0, (GInstanceInitFunc) overlay_message_instance_init, NULL };
	GType overlay_message_type_id;
	overlay_message_type_id = g_type_register_static (gtk_drawing_area_get_type (), "OverlayMessage", &g_define_type_info, 0);
	return overlay_message_type_id;
}

GType
overlay_message_get_type (void)
{
	static gsize overlay_message_type_id__once = 0;
	if (g_once_init_enter (&overlay_message_type_id__once)) {
		GType overlay_message_type_id;
		overlay_message_type_id = overlay_message_get_type_once ();
		g_once_init_leave (&overlay_message_type_id__once, overlay_message_type_id);
	}
	return overlay_message_type_id__once;
}

static inline gpointer
colour_wheel_get_instance_private (ColourWheel* self)
{
	return G_STRUCT_MEMBER_P (self, ColourWheel_private_offset);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		ColourWheel* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
__lambda4_ (ColourWheel* self,
            GtkDrawingArea* area,
            cairo_t* C,
            gint width,
            gint height)
{
	static const gdouble PI2 = 1.570796326794896619231321691639751442;
	static const gdouble PI3 = 1.047197551196597746154214461093167628;
	static const gdouble border_width = (gdouble) 10;
	static const gdouble sixty_degrees = 2642885282.0 / 1525870529.0;
	gint _tmp0_ = 0;
	gdouble _tmp1_ = 0.0;
	gboolean _tmp2_ = FALSE;
	gdouble _tmp3_ = 0.0;
	gboolean _tmp4_ = FALSE;
	gdouble _tmp5_ = 0.0;
	gboolean _tmp6_ = FALSE;
	gdouble _tmp7_ = 0.0;
	gboolean _tmp8_ = FALSE;
	gdouble _tmp9_ = 0.0;
	gboolean _tmp10_ = FALSE;
	gdouble _tmp11_ = 0.0;
	gboolean _tmp12_ = FALSE;
	gdouble _tmp13_ = 0.0;
	gboolean _tmp14_ = FALSE;
	gdouble _tmp15_ = 0.0;
	gboolean _tmp16_ = FALSE;
	gdouble _tmp17_ = 0.0;
	gboolean _tmp18_ = FALSE;
	gdouble _tmp19_ = 0.0;
	gboolean _tmp20_ = FALSE;
	gdouble _tmp21_ = 0.0;
	gboolean _tmp22_ = FALSE;
	gdouble _tmp23_ = 0.0;
	gboolean _tmp24_ = FALSE;
	gdouble _tmp25_ = 0.0;
	gboolean _tmp26_ = FALSE;
	gdouble _tmp27_ = 0.0;
	gboolean _tmp28_ = FALSE;
	gdouble _tmp29_ = 0.0;
	gboolean _tmp30_ = FALSE;
	gdouble _tmp31_ = 0.0;
	gboolean _tmp32_ = FALSE;
	gdouble _tmp33_ = 0.0;
	gboolean _tmp34_ = FALSE;
	gdouble _tmp35_ = 0.0;
	gboolean _tmp36_ = FALSE;
	gdouble _tmp37_ = 0.0;
	gboolean _tmp38_ = FALSE;
	gdouble _tmp39_ = 0.0;
	gboolean _tmp40_ = FALSE;
	g_return_if_fail (area != NULL);
	g_return_if_fail (C != NULL);
	if (width < height) {
		_tmp0_ = width / 2;
	} else {
		_tmp0_ = height / 2;
	}
	self->priv->radius = (gdouble) _tmp0_;
	if (self->priv->radius > border_width) {
		self->priv->radius = self->priv->radius - border_width;
	}
	self->priv->centre_x = (gdouble) (width / 2);
	self->priv->centre_y = (gdouble) (height / 2);
	if (self->priv->mouse_pressed) {
		_tmp2_ = self->priv->mouse_segment == ((guint) 0);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = (border_width / sixty_degrees) / 2.0;
	} else {
		_tmp1_ = (gdouble) 0;
	}
	if (self->priv->mouse_pressed) {
		_tmp4_ = self->priv->mouse_segment == ((guint) 0);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = (border_width * sixty_degrees) / 2.0;
	} else {
		_tmp3_ = (gdouble) 0;
	}
	cairo_move_to (C, self->priv->centre_x + _tmp1_, self->priv->centre_y - _tmp3_);
	if (self->priv->mouse_pressed) {
		_tmp6_ = self->priv->mouse_segment == ((guint) 0);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_tmp5_ = (border_width / sixty_degrees) / 2.0;
	} else {
		_tmp5_ = (gdouble) 0;
	}
	if (self->priv->mouse_pressed) {
		_tmp8_ = self->priv->mouse_segment == ((guint) 0);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = (border_width * sixty_degrees) / 2.0;
	} else {
		_tmp7_ = (gdouble) 0;
	}
	cairo_arc (C, self->priv->centre_x + _tmp5_, self->priv->centre_y - _tmp7_, self->priv->radius, -PI2, (-PI2) + PI3);
	cairo_set_source_rgba (C, (gdouble) 1, (gdouble) 0, (gdouble) 0, (gdouble) 1);
	cairo_fill (C);
	if (self->priv->mouse_pressed) {
		_tmp10_ = self->priv->mouse_segment == ((guint) 1);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_tmp9_ = border_width;
	} else {
		_tmp9_ = (gdouble) 0;
	}
	cairo_move_to (C, self->priv->centre_x + _tmp9_, self->priv->centre_y);
	if (self->priv->mouse_pressed) {
		_tmp12_ = self->priv->mouse_segment == ((guint) 1);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		_tmp11_ = border_width;
	} else {
		_tmp11_ = (gdouble) 0;
	}
	cairo_arc (C, self->priv->centre_x + _tmp11_, self->priv->centre_y, self->priv->radius, (-PI2) + PI3, ((-PI2) + PI3) + PI3);
	cairo_set_source_rgba (C, (gdouble) 0, 0.75, (gdouble) 0, (gdouble) 1);
	cairo_fill (C);
	if (self->priv->mouse_pressed) {
		_tmp14_ = self->priv->mouse_segment == ((guint) 2);
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		_tmp13_ = (border_width / sixty_degrees) / 2.0;
	} else {
		_tmp13_ = (gdouble) 0;
	}
	if (self->priv->mouse_pressed) {
		_tmp16_ = self->priv->mouse_segment == ((guint) 2);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		_tmp15_ = (border_width * sixty_degrees) / 2.0;
	} else {
		_tmp15_ = (gdouble) 0;
	}
	cairo_move_to (C, self->priv->centre_x + _tmp13_, self->priv->centre_y + _tmp15_);
	if (self->priv->mouse_pressed) {
		_tmp18_ = self->priv->mouse_segment == ((guint) 2);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		_tmp17_ = (border_width / sixty_degrees) / 2.0;
	} else {
		_tmp17_ = (gdouble) 0;
	}
	if (self->priv->mouse_pressed) {
		_tmp20_ = self->priv->mouse_segment == ((guint) 2);
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		_tmp19_ = (border_width * sixty_degrees) / 2.0;
	} else {
		_tmp19_ = (gdouble) 0;
	}
	cairo_arc (C, self->priv->centre_x + _tmp17_, self->priv->centre_y + _tmp19_, self->priv->radius, PI2 - PI3, PI2);
	cairo_set_source_rgba (C, (gdouble) 0, 0.5, (gdouble) 1, (gdouble) 1);
	cairo_fill (C);
	if (self->priv->mouse_pressed) {
		_tmp22_ = self->priv->mouse_segment == ((guint) 3);
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		_tmp21_ = (border_width / sixty_degrees) / 2.0;
	} else {
		_tmp21_ = (gdouble) 0;
	}
	if (self->priv->mouse_pressed) {
		_tmp24_ = self->priv->mouse_segment == ((guint) 3);
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		_tmp23_ = (border_width * sixty_degrees) / 2.0;
	} else {
		_tmp23_ = (gdouble) 0;
	}
	cairo_move_to (C, self->priv->centre_x - _tmp21_, self->priv->centre_y + _tmp23_);
	if (self->priv->mouse_pressed) {
		_tmp26_ = self->priv->mouse_segment == ((guint) 3);
	} else {
		_tmp26_ = FALSE;
	}
	if (_tmp26_) {
		_tmp25_ = (border_width / sixty_degrees) / 2.0;
	} else {
		_tmp25_ = (gdouble) 0;
	}
	if (self->priv->mouse_pressed) {
		_tmp28_ = self->priv->mouse_segment == ((guint) 3);
	} else {
		_tmp28_ = FALSE;
	}
	if (_tmp28_) {
		_tmp27_ = (border_width * sixty_degrees) / 2.0;
	} else {
		_tmp27_ = (gdouble) 0;
	}
	cairo_arc (C, self->priv->centre_x - _tmp25_, self->priv->centre_y + _tmp27_, self->priv->radius, PI2, PI2 + PI3);
	cairo_set_source_rgba (C, (gdouble) 1, (gdouble) 1, (gdouble) 0, (gdouble) 1);
	cairo_fill (C);
	if (self->priv->mouse_pressed) {
		_tmp30_ = self->priv->mouse_segment == ((guint) 4);
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		_tmp29_ = border_width;
	} else {
		_tmp29_ = (gdouble) 0;
	}
	cairo_move_to (C, self->priv->centre_x - _tmp29_, self->priv->centre_y);
	if (self->priv->mouse_pressed) {
		_tmp32_ = self->priv->mouse_segment == ((guint) 4);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		_tmp31_ = border_width;
	} else {
		_tmp31_ = (gdouble) 0;
	}
	cairo_arc (C, self->priv->centre_x - _tmp31_, self->priv->centre_y, self->priv->radius, PI2 + PI3, (PI2 + PI3) + PI3);
	cairo_set_source_rgba (C, (gdouble) 0, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	cairo_fill (C);
	if (self->priv->mouse_pressed) {
		_tmp34_ = self->priv->mouse_segment == ((guint) 5);
	} else {
		_tmp34_ = FALSE;
	}
	if (_tmp34_) {
		_tmp33_ = (border_width / sixty_degrees) / 2.0;
	} else {
		_tmp33_ = (gdouble) 0;
	}
	if (self->priv->mouse_pressed) {
		_tmp36_ = self->priv->mouse_segment == ((guint) 5);
	} else {
		_tmp36_ = FALSE;
	}
	if (_tmp36_) {
		_tmp35_ = (border_width * sixty_degrees) / 2.0;
	} else {
		_tmp35_ = (gdouble) 0;
	}
	cairo_move_to (C, self->priv->centre_x - _tmp33_, self->priv->centre_y - _tmp35_);
	if (self->priv->mouse_pressed) {
		_tmp38_ = self->priv->mouse_segment == ((guint) 5);
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		_tmp37_ = (border_width / sixty_degrees) / 2.0;
	} else {
		_tmp37_ = (gdouble) 0;
	}
	if (self->priv->mouse_pressed) {
		_tmp40_ = self->priv->mouse_segment == ((guint) 5);
	} else {
		_tmp40_ = FALSE;
	}
	if (_tmp40_) {
		_tmp39_ = (border_width * sixty_degrees) / 2.0;
	} else {
		_tmp39_ = (gdouble) 0;
	}
	cairo_arc (C, self->priv->centre_x - _tmp37_, self->priv->centre_y - _tmp39_, self->priv->radius, (PI2 + PI3) + PI3, -PI2);
	cairo_set_source_rgba (C, 0.75, (gdouble) 0, 0.75, (gdouble) 1);
	cairo_fill (C);
	colour_wheel_draw_label (self, C, (gdouble) width, (gdouble) height, _ ("Select your color"));
}

static void
___lambda4__gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                        cairo_t* cr,
                                        gint width,
                                        gint height,
                                        gpointer self)
{
	__lambda4_ ((ColourWheel*) self, drawing_area, cr, width, height);
}

static void
__lambda5_ (ColourWheel* self,
            gdouble x,
            gdouble y)
{
	colour_wheel_new_position (self, x, y);
}

static void
___lambda5__gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                gdouble x,
                                                gdouble y,
                                                gpointer self)
{
	__lambda5_ ((ColourWheel*) self, x, y);
}

static void
__lambda6_ (ColourWheel* self,
            gdouble x,
            gdouble y)
{
	colour_wheel_new_position (self, x, y);
}

static void
___lambda6__gtk_event_controller_motion_enter (GtkEventControllerMotion* _sender,
                                               gdouble x,
                                               gdouble y,
                                               gpointer self)
{
	__lambda6_ ((ColourWheel*) self, x, y);
}

static gboolean
__lambda7_ (Block4Data* _data4_,
            GdkEvent* event)
{
	ColourWheel* self;
	gboolean result;
	self = _data4_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	switch (gdk_event_get_event_type (event)) {
		case GDK_BUTTON_PRESS:
		{
			self->priv->mouse_pressed = TRUE;
			colour_wheel_redraw (self);
			result = TRUE;
			return result;
		}
		case GDK_BUTTON_RELEASE:
		{
			self->priv->mouse_pressed = FALSE;
			if (self->priv->mouse_segment > ((guint) 5)) {
				colour_wheel_redraw (self);
			} else {
				_data4_->_result_ (self->priv->mouse_segment, _data4_->_result__target);
			}
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gboolean
___lambda7__gtk_event_controller_legacy_event (GtkEventControllerLegacy* _sender,
                                               GdkEvent* event,
                                               gpointer self)
{
	gboolean result;
	result = __lambda7_ (self, event);
	return result;
}

ColourWheel*
colour_wheel_construct (GType object_type,
                        ColourWheelResultFunction _result_,
                        gpointer _result__target)
{
	ColourWheel * self = NULL;
	Block4Data* _data4_;
	GtkEventControllerMotion* mouse_position = NULL;
	GtkEventControllerMotion* _tmp0_;
	GtkEventControllerLegacy* mouse_click = NULL;
	GtkEventControllerLegacy* _tmp1_;
	GtkEventController* _tmp2_;
	GtkEventController* _tmp3_;
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->_result_ = _result_;
	_data4_->_result__target = _result__target;
	self = (ColourWheel*) g_object_new (object_type, NULL);
	_data4_->self = g_object_ref (self);
	(self->result_target_destroy_notify == NULL) ? NULL : (self->result_target_destroy_notify (self->result_target), NULL);
	self->result = NULL;
	self->result_target = NULL;
	self->result_target_destroy_notify = NULL;
	self->result = (ColourWheelResultFunction) _data4_->_result_;
	self->result_target = _data4_->_result__target;
	self->result_target_destroy_notify = NULL;
	gtk_widget_set_focusable ((GtkWidget*) self, TRUE);
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
	gtk_widget_set_focus_on_click ((GtkWidget*) self, TRUE);
	gtk_widget_grab_focus ((GtkWidget*) self);
	gtk_drawing_area_set_draw_func ((GtkDrawingArea*) self, ___lambda4__gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	_tmp0_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ();
	mouse_position = _tmp0_;
	g_signal_connect_object (mouse_position, "motion", (GCallback) ___lambda5__gtk_event_controller_motion_motion, self, 0);
	g_signal_connect_object (mouse_position, "enter", (GCallback) ___lambda6__gtk_event_controller_motion_enter, self, 0);
	_tmp1_ = (GtkEventControllerLegacy*) gtk_event_controller_legacy_new ();
	mouse_click = _tmp1_;
	g_signal_connect_data (mouse_click, "event", (GCallback) ___lambda7__gtk_event_controller_legacy_event, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
	_tmp2_ = _g_object_ref0 ((GtkEventController*) mouse_click);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp2_);
	_tmp3_ = _g_object_ref0 ((GtkEventController*) mouse_position);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp3_);
	_g_object_unref0 (mouse_click);
	_g_object_unref0 (mouse_position);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	return self;
}

ColourWheel*
colour_wheel_new (ColourWheelResultFunction _result_,
                  gpointer _result__target)
{
	return colour_wheel_construct (TYPE_COLOUR_WHEEL, _result_, _result__target);
}

static void
colour_wheel_new_position (ColourWheel* self,
                           gdouble x,
                           gdouble y)
{
	guint new_segment = 0U;
	g_return_if_fail (self != NULL);
	new_segment = colour_wheel_segment (self, x, y);
	if (new_segment != self->priv->mouse_segment) {
		self->priv->mouse_segment = new_segment;
		colour_wheel_redraw (self);
	}
}

static guint
colour_wheel_segment (ColourWheel* self,
                      gdouble x,
                      gdouble y)
{
	static const gdouble sixty_degrees = 2642885282.0 / 1525870529.0;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	x = x - self->priv->centre_x;
	y = y - self->priv->centre_y;
	y = -y;
	if (((x * x) + (y * y)) > (self->priv->radius * self->priv->radius)) {
		result = G_MAXUINT;
		return result;
	} else {
		if (x >= ((gdouble) 0)) {
			gboolean _tmp0_ = FALSE;
			if (y > ((gdouble) 0)) {
				_tmp0_ = (x / y) < sixty_degrees;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				result = (guint) 0;
				return result;
			} else {
				gboolean _tmp1_ = FALSE;
				if (y < ((gdouble) 0)) {
					_tmp1_ = (x / y) > (-sixty_degrees);
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					result = (guint) 2;
					return result;
				} else {
					result = (guint) 1;
					return result;
				}
			}
		} else {
			gboolean _tmp2_ = FALSE;
			if (y > ((gdouble) 0)) {
				_tmp2_ = ((-x) / y) < sixty_degrees;
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				result = (guint) 5;
				return result;
			} else {
				gboolean _tmp3_ = FALSE;
				if (y < ((gdouble) 0)) {
					_tmp3_ = ((-x) / y) > (-sixty_degrees);
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					result = (guint) 3;
					return result;
				} else {
					result = (guint) 4;
					return result;
				}
			}
		}
	}
}

static void
colour_wheel_redraw (ColourWheel* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static gint
colour_wheel_calculate_font_size (ColourWheel* self,
                                  cairo_t* C,
                                  const gchar* text,
                                  gint target_width,
                                  gdouble* width,
                                  gdouble* height)
{
	gdouble _vala_width = 0.0;
	gdouble _vala_height = 0.0;
	gint target_font_size = 0;
	guint target_width_diff = 0U;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (C != NULL, 0);
	g_return_val_if_fail (text != NULL, 0);
	target_font_size = 1;
	target_width_diff = G_MAXUINT;
	_vala_width = (gdouble) 0;
	_vala_height = (gdouble) 0;
	{
		gint font_size = 0;
		font_size = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				PangoLayout* layout = NULL;
				PangoLayout* _tmp1_;
				PangoFontDescription* font = NULL;
				PangoLayout* _tmp2_;
				PangoFontDescription* _tmp3_;
				PangoFontDescription* _tmp8_;
				PangoLayout* _tmp9_;
				PangoFontDescription* _tmp10_;
				PangoLayout* _tmp11_;
				PangoLayout* _tmp12_;
				PangoRectangle a = {0};
				PangoRectangle b = {0};
				PangoLayout* _tmp13_;
				PangoRectangle _tmp14_ = {0};
				PangoRectangle _tmp15_ = {0};
				PangoRectangle _tmp16_;
				PangoRectangle _tmp17_;
				guint width_diff = 0U;
				PangoRectangle _tmp18_;
				gboolean _tmp19_ = FALSE;
				if (!_tmp0_) {
				}
				_tmp0_ = FALSE;
				if (!(font_size < 200)) {
					break;
				}
				_tmp1_ = pango_cairo_create_layout (C);
				layout = _tmp1_;
				_tmp2_ = layout;
				_tmp3_ = pango_layout_get_font_description (_tmp2_);
				if (NULL == _tmp3_) {
					PangoFontDescription* _tmp4_;
					_tmp4_ = pango_font_description_from_string ("Sans Bold 1pt");
					__vala_PangoFontDescription_free0 (font);
					font = _tmp4_;
				} else {
					PangoLayout* _tmp5_;
					PangoFontDescription* _tmp6_;
					PangoFontDescription* _tmp7_;
					_tmp5_ = layout;
					_tmp6_ = pango_layout_get_font_description (_tmp5_);
					_tmp7_ = pango_font_description_copy (_tmp6_);
					__vala_PangoFontDescription_free0 (font);
					font = _tmp7_;
				}
				_tmp8_ = font;
				pango_font_description_set_size (_tmp8_, PANGO_SCALE * font_size);
				_tmp9_ = layout;
				_tmp10_ = font;
				pango_layout_set_font_description (_tmp9_, _tmp10_);
				_tmp11_ = layout;
				pango_layout_set_text (_tmp11_, text, -1);
				_tmp12_ = layout;
				pango_cairo_update_layout (C, _tmp12_);
				_tmp13_ = layout;
				pango_layout_get_extents (_tmp13_, &_tmp14_, &_tmp15_);
				a = _tmp14_;
				b = _tmp15_;
				_tmp16_ = a;
				_vala_width = (gdouble) (_tmp16_.width / PANGO_SCALE);
				_tmp17_ = a;
				_vala_height = (gdouble) (_tmp17_.height / PANGO_SCALE);
				_tmp18_ = a;
				width_diff = (guint) abs (target_width - (((gint) _tmp18_.width) / PANGO_SCALE));
				if (width_diff > target_width_diff) {
					_tmp19_ = (width_diff - target_width_diff) > ((guint) 2);
				} else {
					_tmp19_ = FALSE;
				}
				if (_tmp19_) {
					__vala_PangoFontDescription_free0 (font);
					_g_object_unref0 (layout);
					break;
				} else {
					if (width_diff < target_width_diff) {
						target_width_diff = width_diff;
						target_font_size = font_size;
					}
				}
				if (font_size < 20) {
					gint _tmp20_;
					_tmp20_ = font_size;
					font_size = _tmp20_ + 1;
				} else {
					if (font_size < 50) {
						font_size += 5;
					} else {
						font_size += 10;
					}
				}
				__vala_PangoFontDescription_free0 (font);
				_g_object_unref0 (layout);
			}
		}
	}
	result = target_font_size;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	return result;
}

static void
colour_wheel_draw_text_font_size (ColourWheel* self,
                                  cairo_t* C,
                                  gint x,
                                  gint y,
                                  const gchar* text,
                                  gint font_size)
{
	gint x_offset = 0;
	gint y_offset = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp2_;
	PangoFontDescription* font = NULL;
	PangoLayout* _tmp3_;
	PangoFontDescription* _tmp4_;
	PangoFontDescription* _tmp9_;
	PangoLayout* _tmp10_;
	PangoFontDescription* _tmp11_;
	PangoLayout* _tmp12_;
	PangoLayout* _tmp13_;
	PangoLayout* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	g_return_if_fail (text != NULL);
	colour_wheel_get_text_offsets (self, C, text, font_size, &_tmp0_, &_tmp1_);
	x_offset = _tmp0_;
	y_offset = _tmp1_;
	cairo_move_to (C, (gdouble) (x - x_offset), (gdouble) (y - y_offset));
	cairo_set_source_rgb (C, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	_tmp2_ = pango_cairo_create_layout (C);
	layout = _tmp2_;
	_tmp3_ = layout;
	_tmp4_ = pango_layout_get_font_description (_tmp3_);
	if (NULL == _tmp4_) {
		PangoFontDescription* _tmp5_;
		_tmp5_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (font);
		font = _tmp5_;
	} else {
		PangoLayout* _tmp6_;
		PangoFontDescription* _tmp7_;
		PangoFontDescription* _tmp8_;
		_tmp6_ = layout;
		_tmp7_ = pango_layout_get_font_description (_tmp6_);
		_tmp8_ = pango_font_description_copy (_tmp7_);
		__vala_PangoFontDescription_free0 (font);
		font = _tmp8_;
	}
	_tmp9_ = font;
	pango_font_description_set_size (_tmp9_, PANGO_SCALE * font_size);
	_tmp10_ = layout;
	_tmp11_ = font;
	pango_layout_set_font_description (_tmp10_, _tmp11_);
	_tmp12_ = layout;
	pango_layout_set_text (_tmp12_, text, -1);
	_tmp13_ = layout;
	pango_cairo_update_layout (C, _tmp13_);
	_tmp14_ = layout;
	pango_cairo_show_layout (C, _tmp14_);
	__vala_PangoFontDescription_free0 (font);
	_g_object_unref0 (layout);
}

static void
colour_wheel_get_text_offsets (ColourWheel* self,
                               cairo_t* C,
                               const gchar* text,
                               gint font_size,
                               gint* x_offset,
                               gint* y_offset)
{
	gint _vala_x_offset = 0;
	gint _vala_y_offset = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	PangoFontDescription* font = NULL;
	PangoLayout* _tmp1_;
	PangoFontDescription* _tmp2_;
	PangoFontDescription* _tmp7_;
	PangoLayout* _tmp8_;
	PangoFontDescription* _tmp9_;
	PangoLayout* _tmp10_;
	PangoLayout* _tmp11_;
	PangoRectangle a = {0};
	PangoRectangle b = {0};
	PangoLayout* _tmp12_;
	PangoRectangle _tmp13_ = {0};
	PangoRectangle _tmp14_ = {0};
	PangoRectangle _tmp15_;
	PangoRectangle _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = pango_cairo_create_layout (C);
	layout = _tmp0_;
	_tmp1_ = layout;
	_tmp2_ = pango_layout_get_font_description (_tmp1_);
	if (NULL == _tmp2_) {
		PangoFontDescription* _tmp3_;
		_tmp3_ = pango_font_description_from_string ("Sans Bold 1pt");
		__vala_PangoFontDescription_free0 (font);
		font = _tmp3_;
	} else {
		PangoLayout* _tmp4_;
		PangoFontDescription* _tmp5_;
		PangoFontDescription* _tmp6_;
		_tmp4_ = layout;
		_tmp5_ = pango_layout_get_font_description (_tmp4_);
		_tmp6_ = pango_font_description_copy (_tmp5_);
		__vala_PangoFontDescription_free0 (font);
		font = _tmp6_;
	}
	_tmp7_ = font;
	pango_font_description_set_size (_tmp7_, PANGO_SCALE * font_size);
	_tmp8_ = layout;
	_tmp9_ = font;
	pango_layout_set_font_description (_tmp8_, _tmp9_);
	_tmp10_ = layout;
	pango_layout_set_text (_tmp10_, text, -1);
	_tmp11_ = layout;
	pango_cairo_update_layout (C, _tmp11_);
	_tmp12_ = layout;
	pango_layout_get_extents (_tmp12_, &_tmp13_, &_tmp14_);
	a = _tmp13_;
	b = _tmp14_;
	_tmp15_ = a;
	_vala_x_offset = _tmp15_.x / PANGO_SCALE;
	_tmp16_ = a;
	_vala_y_offset = _tmp16_.y / PANGO_SCALE;
	__vala_PangoFontDescription_free0 (font);
	_g_object_unref0 (layout);
	if (x_offset) {
		*x_offset = _vala_x_offset;
	}
	if (y_offset) {
		*y_offset = _vala_y_offset;
	}
}

static void
colour_wheel_draw_label (ColourWheel* self,
                         cairo_t* C,
                         gdouble width,
                         gdouble height,
                         const gchar* text)
{
	static const gdouble PI2 = 1.570796326794896619231321691639751442;
	static const gdouble border_width = (gdouble) 3;
	gdouble text_width = 0.0;
	gdouble text_height = 0.0;
	gint font_size = 0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gint _tmp2_;
	gdouble _tmp3_ = 0.0;
	gdouble minimum_dimension = 0.0;
	gdouble background_width = 0.0;
	gdouble background_height = 0.0;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble arc_radius = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (C != NULL);
	g_return_if_fail (text != NULL);
	_tmp2_ = colour_wheel_calculate_font_size (self, C, text, (gint) (width / 2), &_tmp0_, &_tmp1_);
	text_width = _tmp0_;
	text_height = _tmp1_;
	font_size = _tmp2_;
	if (text_width < text_height) {
		_tmp3_ = text_width;
	} else {
		_tmp3_ = text_height;
	}
	minimum_dimension = _tmp3_;
	background_width = text_width + (minimum_dimension * 2);
	background_height = text_height + (minimum_dimension * 2);
	x = (width - background_width) / 2;
	y = (gdouble) 0;
	if (background_width < background_height) {
		_tmp4_ = background_width / 3;
	} else {
		_tmp4_ = background_height / 3;
	}
	arc_radius = _tmp4_;
	cairo_arc (C, (x + background_width) - arc_radius, y + arc_radius, arc_radius, -PI2, (gdouble) 0);
	cairo_arc (C, (x + background_width) - arc_radius, (y + background_height) - arc_radius, arc_radius, (gdouble) 0, PI2);
	cairo_arc (C, x + arc_radius, (y + background_height) - arc_radius, arc_radius, PI2, PI2 * 2);
	cairo_arc (C, x + arc_radius, y + arc_radius, arc_radius, PI2 * 2, -PI2);
	cairo_set_source_rgba (C, 0.5, 0.5, 0.5, (gdouble) 1);
	cairo_fill (C);
	cairo_arc (C, (x + background_width) - arc_radius, y + arc_radius, arc_radius - border_width, -PI2, (gdouble) 0);
	cairo_arc (C, (x + background_width) - arc_radius, (y + background_height) - arc_radius, arc_radius - border_width, (gdouble) 0, PI2);
	cairo_arc (C, x + arc_radius, (y + background_height) - arc_radius, arc_radius - border_width, PI2, PI2 * 2);
	cairo_arc (C, x + arc_radius, y + arc_radius, arc_radius - border_width, PI2 * 2, -PI2);
	cairo_set_source_rgba (C, 0.125, 0.125, 0.125, (gdouble) 1);
	cairo_fill (C);
	colour_wheel_draw_text_font_size (self, C, (gint) (x + ((background_width - text_width) / 2)), (gint) ((y + (background_height / 2)) - (text_height / 2)), text, font_size);
}

static void
colour_wheel_class_init (ColourWheelClass * klass,
                         gpointer klass_data)
{
	colour_wheel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ColourWheel_private_offset);
	G_OBJECT_CLASS (klass)->finalize = colour_wheel_finalize;
}

static void
colour_wheel_instance_init (ColourWheel * self,
                            gpointer klass)
{
	self->priv = colour_wheel_get_instance_private (self);
	self->priv->mouse_segment = G_MAXUINT;
	self->priv->mouse_pressed = FALSE;
}

static void
colour_wheel_finalize (GObject * obj)
{
	ColourWheel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COLOUR_WHEEL, ColourWheel);
	(self->result_target_destroy_notify == NULL) ? NULL : (self->result_target_destroy_notify (self->result_target), NULL);
	self->result = NULL;
	self->result_target = NULL;
	self->result_target_destroy_notify = NULL;
	G_OBJECT_CLASS (colour_wheel_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
colour_wheel_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ColourWheelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) colour_wheel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ColourWheel), 0, (GInstanceInitFunc) colour_wheel_instance_init, NULL };
	GType colour_wheel_type_id;
	colour_wheel_type_id = g_type_register_static (gtk_drawing_area_get_type (), "ColourWheel", &g_define_type_info, 0);
	ColourWheel_private_offset = g_type_add_instance_private (colour_wheel_type_id, sizeof (ColourWheelPrivate));
	return colour_wheel_type_id;
}

GType
colour_wheel_get_type (void)
{
	static gsize colour_wheel_type_id__once = 0;
	if (g_once_init_enter (&colour_wheel_type_id__once)) {
		GType colour_wheel_type_id;
		colour_wheel_type_id = colour_wheel_get_type_once ();
		g_once_init_leave (&colour_wheel_type_id__once, colour_wheel_type_id);
	}
	return colour_wheel_type_id__once;
}

