/* boni.c generated by valac 0.56.16, the Vala compiler
 * generated from boni.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 * Coding style.
 *
 * To help you comply with the coding style in this project use the
 * following greps. Any lines returned should be adjusted so they
 * don't match. The convoluted regular expressions are so they don't 
 * match them self.
 *
 * grep -ne '[^][)(_!$ "](' *.vala
 * grep -ne '[(] ' *.vala
 * grep -ne '[ ])' *.vala
 *
 */

#include <glib-object.h>
#include <glib.h>
#include <gee.h>

#define BONI_MAX_BONUSES ((guint8) 100)
#define BONI_MAX_MISSED ((guint8) 2)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;

#define TYPE_BONUS_TYPE (bonus_type_get_type ())

#define TYPE_BONUS (bonus_get_type ())
#define BONUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONUS, Bonus))
#define BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONUS, BonusClass))
#define IS_BONUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONUS))
#define IS_BONUS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONUS))
#define BONUS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONUS, BonusClass))

typedef struct _Bonus Bonus;
typedef struct _BonusClass BonusClass;
typedef struct _BonusPrivate BonusPrivate;
enum  {
	BONUS_0_PROPERTY,
	BONUS_X_PROPERTY,
	BONUS_Y_PROPERTY,
	BONUS_BONUS_TYPE_PROPERTY,
	BONUS_FAKE_PROPERTY,
	BONUS_COUNTDOWN_PROPERTY,
	BONUS_NUM_PROPERTIES
};
static GParamSpec* bonus_properties[BONUS_NUM_PROPERTIES];

#define TYPE_BONI (boni_get_type ())
#define BONI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BONI, Boni))
#define BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BONI, BoniClass))
#define IS_BONI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BONI))
#define IS_BONI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BONI))
#define BONI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BONI, BoniClass))

typedef struct _Boni Boni;
typedef struct _BoniClass BoniClass;
typedef struct _BoniPrivate BoniPrivate;
enum  {
	BONI_0_PROPERTY,
	BONI_NUM_PROPERTIES
};
static GParamSpec* boni_properties[BONI_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	BONI_BONUS_REMOVED_SIGNAL,
	BONI_NUM_SIGNALS
};
static guint boni_signals[BONI_NUM_SIGNALS] = {0};

struct _Bonus {
	GObject parent_instance;
	BonusPrivate * priv;
};

struct _BonusClass {
	GObjectClass parent_class;
};

struct _BonusPrivate {
	guint8 _x;
	guint8 _y;
	BonusType _bonus_type;
	gboolean _fake;
	guint16 _countdown;
};

struct _Boni {
	GObject parent_instance;
	BoniPrivate * priv;
};

struct _BoniClass {
	GObjectClass parent_class;
};

struct _BoniPrivate {
	GeeLinkedList* bonuses;
	guint8 regular_bonus_left;
	guint8 regular_bonus_maxi;
	guint8 total_bonus_number;
	guint8 missed;
};

static gint Bonus_private_offset;
static gpointer bonus_parent_class = NULL;
static gint Boni_private_offset;
static gpointer boni_parent_class = NULL;

VALA_EXTERN GType bonus_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType bonus_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Bonus, g_object_unref)
VALA_EXTERN Bonus* bonus_new (guint8 x,
                  guint8 y,
                  BonusType bonus_type,
                  gboolean fake,
                  guint16 countdown);
VALA_EXTERN Bonus* bonus_construct (GType object_type,
                        guint8 x,
                        guint8 y,
                        BonusType bonus_type,
                        gboolean fake,
                        guint16 countdown);
VALA_EXTERN guint8 bonus_get_x (Bonus* self);
static void bonus_set_x (Bonus* self,
                  guint8 value);
VALA_EXTERN guint8 bonus_get_y (Bonus* self);
static void bonus_set_y (Bonus* self,
                  guint8 value);
VALA_EXTERN BonusType bonus_get_bonus_type (Bonus* self);
static void bonus_set_bonus_type (Bonus* self,
                           BonusType value);
VALA_EXTERN gboolean bonus_get_fake (Bonus* self);
static void bonus_set_fake (Bonus* self,
                     gboolean value);
VALA_EXTERN guint16 bonus_get_countdown (Bonus* self);
VALA_EXTERN void bonus_set_countdown (Bonus* self,
                          guint16 value);
static void bonus_finalize (GObject * obj);
static GType bonus_get_type_once (void);
static void _vala_bonus_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec);
static void _vala_bonus_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec);
VALA_EXTERN GType boni_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Boni, g_object_unref)
VALA_EXTERN gboolean boni_add_bonus (Boni* self,
                         Bonus* bonus);
VALA_EXTERN void boni_remove_bonus (Boni* self,
                        Bonus* bonus);
VALA_EXTERN void boni_reset (Boni* self,
                 guint8 regular_bonus);
static inline void boni_reset_missed (Boni* self);
VALA_EXTERN Bonus* boni_get_bonus (Boni* self,
                       guint8 x,
                       guint8 y);
VALA_EXTERN GeeList* boni_get_bonuses (Boni* self);
VALA_EXTERN void boni_on_worms_move (Boni* self,
                         guint8* missed_bonuses_to_replace);
static inline void boni_increase_missed (Boni* self);
VALA_EXTERN guint8 boni_new_regular_bonus_eaten (Boni* self);
VALA_EXTERN gboolean boni_last_regular_bonus (Boni* self);
VALA_EXTERN gboolean boni_too_many_missed (Boni* self);
VALA_EXTERN Boni* boni_new (void);
VALA_EXTERN Boni* boni_construct (GType object_type);
static void boni_finalize (GObject * obj);
static GType boni_get_type_once (void);

 G_GNUC_NO_INLINE static GType
bonus_type_get_type_once (void)
{
	static const GEnumValue values[] = {{BONUS_TYPE_REGULAR, "BONUS_TYPE_REGULAR", "regular"}, {BONUS_TYPE_HALF, "BONUS_TYPE_HALF", "half"}, {BONUS_TYPE_DOUBLE, "BONUS_TYPE_DOUBLE", "double"}, {BONUS_TYPE_LIFE, "BONUS_TYPE_LIFE", "life"}, {BONUS_TYPE_REVERSE, "BONUS_TYPE_REVERSE", "reverse"}, {BONUS_TYPE_WARP, "BONUS_TYPE_WARP", "warp"}, {0, NULL, NULL}};
	GType bonus_type_type_id;
	bonus_type_type_id = g_enum_register_static ("BonusType", values);
	return bonus_type_type_id;
}

GType
bonus_type_get_type (void)
{
	static gsize bonus_type_type_id__once = 0;
	if (g_once_init_enter (&bonus_type_type_id__once)) {
		GType bonus_type_type_id;
		bonus_type_type_id = bonus_type_get_type_once ();
		g_once_init_leave (&bonus_type_type_id__once, bonus_type_type_id);
	}
	return bonus_type_type_id__once;
}

static inline gpointer
bonus_get_instance_private (Bonus* self)
{
	return G_STRUCT_MEMBER_P (self, Bonus_private_offset);
}

Bonus*
bonus_construct (GType object_type,
                 guint8 x,
                 guint8 y,
                 BonusType bonus_type,
                 gboolean fake,
                 guint16 countdown)
{
	Bonus * self = NULL;
	self = (Bonus*) g_object_new (object_type, "x", x, "y", y, "bonus-type", bonus_type, "fake", fake, "countdown", countdown, NULL);
	return self;
}

Bonus*
bonus_new (guint8 x,
           guint8 y,
           BonusType bonus_type,
           gboolean fake,
           guint16 countdown)
{
	return bonus_construct (TYPE_BONUS, x, y, bonus_type, fake, countdown);
}

guint8
bonus_get_x (Bonus* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_x;
	return result;
}

static void
bonus_set_x (Bonus* self,
             guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = bonus_get_x (self);
	if (old_value != value) {
		self->priv->_x = value;
		g_object_notify_by_pspec ((GObject *) self, bonus_properties[BONUS_X_PROPERTY]);
	}
}

guint8
bonus_get_y (Bonus* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_y;
	return result;
}

static void
bonus_set_y (Bonus* self,
             guint8 value)
{
	guint8 old_value;
	g_return_if_fail (self != NULL);
	old_value = bonus_get_y (self);
	if (old_value != value) {
		self->priv->_y = value;
		g_object_notify_by_pspec ((GObject *) self, bonus_properties[BONUS_Y_PROPERTY]);
	}
}

BonusType
bonus_get_bonus_type (Bonus* self)
{
	BonusType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_bonus_type;
	return result;
}

static void
bonus_set_bonus_type (Bonus* self,
                      BonusType value)
{
	BonusType old_value;
	g_return_if_fail (self != NULL);
	old_value = bonus_get_bonus_type (self);
	if (old_value != value) {
		self->priv->_bonus_type = value;
		g_object_notify_by_pspec ((GObject *) self, bonus_properties[BONUS_BONUS_TYPE_PROPERTY]);
	}
}

gboolean
bonus_get_fake (Bonus* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_fake;
	return result;
}

static void
bonus_set_fake (Bonus* self,
                gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = bonus_get_fake (self);
	if (old_value != value) {
		self->priv->_fake = value;
		g_object_notify_by_pspec ((GObject *) self, bonus_properties[BONUS_FAKE_PROPERTY]);
	}
}

guint16
bonus_get_countdown (Bonus* self)
{
	guint16 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_countdown;
	return result;
}

void
bonus_set_countdown (Bonus* self,
                     guint16 value)
{
	guint16 old_value;
	g_return_if_fail (self != NULL);
	old_value = bonus_get_countdown (self);
	if (old_value != value) {
		self->priv->_countdown = value;
		g_object_notify_by_pspec ((GObject *) self, bonus_properties[BONUS_COUNTDOWN_PROPERTY]);
	}
}

static void
bonus_class_init (BonusClass * klass,
                  gpointer klass_data)
{
	bonus_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Bonus_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_bonus_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_bonus_set_property;
	G_OBJECT_CLASS (klass)->finalize = bonus_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BONUS_X_PROPERTY, bonus_properties[BONUS_X_PROPERTY] = g_param_spec_uchar ("x", "x", "x", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BONUS_Y_PROPERTY, bonus_properties[BONUS_Y_PROPERTY] = g_param_spec_uchar ("y", "y", "y", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BONUS_BONUS_TYPE_PROPERTY, bonus_properties[BONUS_BONUS_TYPE_PROPERTY] = g_param_spec_enum ("bonus-type", "bonus-type", "bonus-type", TYPE_BONUS_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BONUS_FAKE_PROPERTY, bonus_properties[BONUS_FAKE_PROPERTY] = g_param_spec_boolean ("fake", "fake", "fake", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BONUS_COUNTDOWN_PROPERTY, bonus_properties[BONUS_COUNTDOWN_PROPERTY] = g_param_spec_uint ("countdown", "countdown", "countdown", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
bonus_instance_init (Bonus * self,
                     gpointer klass)
{
	self->priv = bonus_get_instance_private (self);
}

static void
bonus_finalize (GObject * obj)
{
	Bonus * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BONUS, Bonus);
	G_OBJECT_CLASS (bonus_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
bonus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BonusClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bonus_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Bonus), 0, (GInstanceInitFunc) bonus_instance_init, NULL };
	GType bonus_type_id;
	bonus_type_id = g_type_register_static (G_TYPE_OBJECT, "Bonus", &g_define_type_info, 0);
	Bonus_private_offset = g_type_add_instance_private (bonus_type_id, sizeof (BonusPrivate));
	return bonus_type_id;
}

GType
bonus_get_type (void)
{
	static gsize bonus_type_id__once = 0;
	if (g_once_init_enter (&bonus_type_id__once)) {
		GType bonus_type_id;
		bonus_type_id = bonus_get_type_once ();
		g_once_init_leave (&bonus_type_id__once, bonus_type_id);
	}
	return bonus_type_id__once;
}

static void
_vala_bonus_get_property (GObject * object,
                          guint property_id,
                          GValue * value,
                          GParamSpec * pspec)
{
	Bonus * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BONUS, Bonus);
	switch (property_id) {
		case BONUS_X_PROPERTY:
		g_value_set_uchar (value, bonus_get_x (self));
		break;
		case BONUS_Y_PROPERTY:
		g_value_set_uchar (value, bonus_get_y (self));
		break;
		case BONUS_BONUS_TYPE_PROPERTY:
		g_value_set_enum (value, bonus_get_bonus_type (self));
		break;
		case BONUS_FAKE_PROPERTY:
		g_value_set_boolean (value, bonus_get_fake (self));
		break;
		case BONUS_COUNTDOWN_PROPERTY:
		g_value_set_uint (value, bonus_get_countdown (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_bonus_set_property (GObject * object,
                          guint property_id,
                          const GValue * value,
                          GParamSpec * pspec)
{
	Bonus * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_BONUS, Bonus);
	switch (property_id) {
		case BONUS_X_PROPERTY:
		bonus_set_x (self, g_value_get_uchar (value));
		break;
		case BONUS_Y_PROPERTY:
		bonus_set_y (self, g_value_get_uchar (value));
		break;
		case BONUS_BONUS_TYPE_PROPERTY:
		bonus_set_bonus_type (self, g_value_get_enum (value));
		break;
		case BONUS_FAKE_PROPERTY:
		bonus_set_fake (self, g_value_get_boolean (value));
		break;
		case BONUS_COUNTDOWN_PROPERTY:
		bonus_set_countdown (self, g_value_get_uint (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
boni_get_instance_private (Boni* self)
{
	return G_STRUCT_MEMBER_P (self, Boni_private_offset);
}

gboolean
boni_add_bonus (Boni* self,
                Bonus* bonus)
{
	GeeLinkedList* _tmp0_;
	guint8 _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (bonus != NULL, FALSE);
	if (self->priv->total_bonus_number >= BONI_MAX_BONUSES) {
		result = FALSE;
		_g_object_unref0 (bonus);
		return result;
	}
	_tmp0_ = self->priv->bonuses;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, bonus);
	_tmp1_ = self->priv->total_bonus_number;
	self->priv->total_bonus_number = _tmp1_ + 1;
	result = TRUE;
	_g_object_unref0 (bonus);
	return result;
}

void
boni_remove_bonus (Boni* self,
                   Bonus* bonus)
{
	GeeLinkedList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (bonus != NULL);
	g_signal_emit (self, boni_signals[BONI_BONUS_REMOVED_SIGNAL], 0, bonus);
	_tmp0_ = self->priv->bonuses;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, bonus);
}

void
boni_reset (Boni* self,
            guint8 regular_bonus)
{
	GeeLinkedList* _tmp0_;
	guint8 _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bonuses;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	boni_reset_missed (self);
	if (regular_bonus < BONI_MAX_BONUSES) {
		_tmp1_ = regular_bonus;
	} else {
		_tmp1_ = BONI_MAX_BONUSES;
	}
	self->priv->regular_bonus_maxi = _tmp1_;
	self->priv->regular_bonus_left = self->priv->regular_bonus_maxi;
	self->priv->total_bonus_number = (guint8) 0;
}

Bonus*
boni_get_bonus (Boni* self,
                guint8 x,
                guint8 y)
{
	Bonus* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeLinkedList* _bonus_list = NULL;
		GeeLinkedList* _tmp0_;
		gint _bonus_size = 0;
		GeeLinkedList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _bonus_index = 0;
		_tmp0_ = self->priv->bonuses;
		_bonus_list = _tmp0_;
		_tmp1_ = _bonus_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_bonus_size = _tmp3_;
		_bonus_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Bonus* bonus = NULL;
			GeeLinkedList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			Bonus* _tmp12_;
			guint8 _tmp13_;
			guint8 _tmp14_;
			_bonus_index = _bonus_index + 1;
			_tmp4_ = _bonus_index;
			_tmp5_ = _bonus_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _bonus_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _bonus_index);
			bonus = (Bonus*) _tmp7_;
			_tmp12_ = bonus;
			_tmp13_ = bonus_get_x (_tmp12_);
			_tmp14_ = _tmp13_;
			if (((gint) x) == (_tmp14_ + 0)) {
				Bonus* _tmp15_;
				guint8 _tmp16_;
				guint8 _tmp17_;
				_tmp15_ = bonus;
				_tmp16_ = bonus_get_y (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = ((gint) y) == (_tmp17_ + 0);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				_tmp10_ = TRUE;
			} else {
				gboolean _tmp18_ = FALSE;
				Bonus* _tmp19_;
				guint8 _tmp20_;
				guint8 _tmp21_;
				_tmp19_ = bonus;
				_tmp20_ = bonus_get_x (_tmp19_);
				_tmp21_ = _tmp20_;
				if (((gint) x) == (_tmp21_ + 1)) {
					Bonus* _tmp22_;
					guint8 _tmp23_;
					guint8 _tmp24_;
					_tmp22_ = bonus;
					_tmp23_ = bonus_get_y (_tmp22_);
					_tmp24_ = _tmp23_;
					_tmp18_ = ((gint) y) == (_tmp24_ + 0);
				} else {
					_tmp18_ = FALSE;
				}
				_tmp10_ = _tmp18_;
			}
			if (_tmp10_) {
				_tmp9_ = TRUE;
			} else {
				gboolean _tmp25_ = FALSE;
				Bonus* _tmp26_;
				guint8 _tmp27_;
				guint8 _tmp28_;
				_tmp26_ = bonus;
				_tmp27_ = bonus_get_x (_tmp26_);
				_tmp28_ = _tmp27_;
				if (((gint) x) == (_tmp28_ + 0)) {
					Bonus* _tmp29_;
					guint8 _tmp30_;
					guint8 _tmp31_;
					_tmp29_ = bonus;
					_tmp30_ = bonus_get_y (_tmp29_);
					_tmp31_ = _tmp30_;
					_tmp25_ = ((gint) y) == (_tmp31_ + 1);
				} else {
					_tmp25_ = FALSE;
				}
				_tmp9_ = _tmp25_;
			}
			if (_tmp9_) {
				_tmp8_ = TRUE;
			} else {
				gboolean _tmp32_ = FALSE;
				Bonus* _tmp33_;
				guint8 _tmp34_;
				guint8 _tmp35_;
				_tmp33_ = bonus;
				_tmp34_ = bonus_get_x (_tmp33_);
				_tmp35_ = _tmp34_;
				if (((gint) x) == (_tmp35_ + 1)) {
					Bonus* _tmp36_;
					guint8 _tmp37_;
					guint8 _tmp38_;
					_tmp36_ = bonus;
					_tmp37_ = bonus_get_y (_tmp36_);
					_tmp38_ = _tmp37_;
					_tmp32_ = ((gint) y) == (_tmp38_ + 1);
				} else {
					_tmp32_ = FALSE;
				}
				_tmp8_ = _tmp32_;
			}
			if (_tmp8_) {
				result = bonus;
				return result;
			}
			_g_object_unref0 (bonus);
		}
	}
	result = NULL;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeList*
boni_get_bonuses (Boni* self)
{
	GeeLinkedList* _tmp0_;
	GeeList* _tmp1_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->bonuses;
	_tmp1_ = _g_object_ref0 ((GeeList*) _tmp0_);
	result = _tmp1_;
	return result;
}

void
boni_on_worms_move (Boni* self,
                    guint8* missed_bonuses_to_replace)
{
	guint8 _vala_missed_bonuses_to_replace = 0U;
	g_return_if_fail (self != NULL);
	_vala_missed_bonuses_to_replace = (guint8) 0;
	{
		gint i = 0;
		GeeLinkedList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = self->priv->bonuses;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		i = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				Bonus* bonus = NULL;
				GeeLinkedList* _tmp5_;
				gpointer _tmp6_;
				Bonus* _tmp7_;
				guint16 _tmp8_;
				guint16 _tmp9_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ - 1;
				}
				_tmp3_ = FALSE;
				if (!(i > 0)) {
					break;
				}
				_tmp5_ = self->priv->bonuses;
				_tmp6_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, i - 1);
				bonus = (Bonus*) _tmp6_;
				_tmp7_ = bonus;
				_tmp8_ = bonus_get_countdown (_tmp7_);
				_tmp9_ = _tmp8_;
				if (((gint) _tmp9_) > 0) {
					Bonus* _tmp10_;
					guint16 _tmp11_;
					guint16 _tmp12_;
					_tmp10_ = bonus;
					_tmp11_ = bonus_get_countdown (_tmp10_);
					_tmp12_ = _tmp11_;
					bonus_set_countdown (_tmp10_, _tmp12_ - 1);
				} else {
					Bonus* _tmp13_;
					gboolean _tmp14_ = FALSE;
					Bonus* _tmp15_;
					BonusType _tmp16_;
					BonusType _tmp17_;
					_tmp13_ = bonus;
					boni_remove_bonus (self, _tmp13_);
					_tmp15_ = bonus;
					_tmp16_ = bonus_get_bonus_type (_tmp15_);
					_tmp17_ = _tmp16_;
					if (_tmp17_ == BONUS_TYPE_REGULAR) {
						Bonus* _tmp18_;
						gboolean _tmp19_;
						gboolean _tmp20_;
						_tmp18_ = bonus;
						_tmp19_ = bonus_get_fake (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp14_ = !_tmp20_;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						guint8 _tmp21_;
						boni_increase_missed (self);
						_tmp21_ = _vala_missed_bonuses_to_replace;
						_vala_missed_bonuses_to_replace = _tmp21_ + 1;
					}
				}
				_g_object_unref0 (bonus);
			}
		}
	}
	if (missed_bonuses_to_replace) {
		*missed_bonuses_to_replace = _vala_missed_bonuses_to_replace;
	}
}

inline guint8
boni_new_regular_bonus_eaten (Boni* self)
{
	guint8 _tmp0_;
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	boni_reset_missed (self);
	if (((gint) self->priv->regular_bonus_left) == 0) {
		g_assert_not_reached ();
	}
	_tmp0_ = self->priv->regular_bonus_left;
	self->priv->regular_bonus_left = _tmp0_ - 1;
	result = self->priv->regular_bonus_maxi - self->priv->regular_bonus_left;
	return result;
}

inline gboolean
boni_last_regular_bonus (Boni* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = ((gint) self->priv->regular_bonus_left) == 0;
	return result;
}

inline gboolean
boni_too_many_missed (Boni* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->missed > BONI_MAX_MISSED;
	return result;
}

static inline void
boni_increase_missed (Boni* self)
{
	guint8 _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->missed;
	self->priv->missed = _tmp0_ + 1;
}

static inline void
boni_reset_missed (Boni* self)
{
	g_return_if_fail (self != NULL);
	self->priv->missed = (guint8) 0;
}

Boni*
boni_construct (GType object_type)
{
	Boni * self = NULL;
	self = (Boni*) g_object_new (object_type, NULL);
	return self;
}

Boni*
boni_new (void)
{
	return boni_construct (TYPE_BONI);
}

static void
boni_class_init (BoniClass * klass,
                 gpointer klass_data)
{
	boni_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Boni_private_offset);
	G_OBJECT_CLASS (klass)->finalize = boni_finalize;
	boni_signals[BONI_BONUS_REMOVED_SIGNAL] = g_signal_new ("bonus-removed", TYPE_BONI, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_BONUS);
}

static void
boni_instance_init (Boni * self,
                    gpointer klass)
{
	GeeLinkedList* _tmp0_;
	self->priv = boni_get_instance_private (self);
	_tmp0_ = gee_linked_list_new (TYPE_BONUS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->bonuses = _tmp0_;
	self->priv->regular_bonus_left = (guint8) 0;
	self->priv->regular_bonus_maxi = (guint8) 0;
	self->priv->total_bonus_number = (guint8) 0;
	self->priv->missed = (guint8) 0;
}

static void
boni_finalize (GObject * obj)
{
	Boni * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BONI, Boni);
	_g_object_unref0 (self->priv->bonuses);
	G_OBJECT_CLASS (boni_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
boni_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoniClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boni_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Boni), 0, (GInstanceInitFunc) boni_instance_init, NULL };
	GType boni_type_id;
	boni_type_id = g_type_register_static (G_TYPE_OBJECT, "Boni", &g_define_type_info, 0);
	Boni_private_offset = g_type_add_instance_private (boni_type_id, sizeof (BoniPrivate));
	return boni_type_id;
}

GType
boni_get_type (void)
{
	static gsize boni_type_id__once = 0;
	if (g_once_init_enter (&boni_type_id__once)) {
		GType boni_type_id;
		boni_type_id = boni_get_type_once ();
		g_once_init_leave (&boni_type_id__once, boni_type_id);
	}
	return boni_type_id__once;
}

