/* score-dialog.c generated by valac 0.56.16, the Vala compiler
 * generated from score-dialog.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
typedef struct _ScoreDialogPrivate ScoreDialogPrivate;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;
enum  {
	SCORE_DIALOG_0_PROPERTY,
	SCORE_DIALOG_NUM_PROPERTIES
};
static GParamSpec* score_dialog_properties[SCORE_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _HistoryPrivate HistoryPrivate;
typedef struct _HistoryEntryPrivate HistoryEntryPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
typedef struct _MapPrivate MapPrivate;

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;

struct _ScoreDialog {
	GtkDialog parent_instance;
	ScoreDialogPrivate * priv;
};

struct _ScoreDialogClass {
	GtkDialogClass parent_class;
};

struct _ScoreDialogPrivate {
	GtkComboBox* layouts;
	GtkTreeView* scores;
	History* history;
	HistoryEntry* selected_entry;
	GtkListStore* size_model;
	GtkListStore* score_model;
	GList* maps;
};

struct _History {
	GObject parent_instance;
	HistoryPrivate * priv;
	gchar* filename;
	GList* entries;
};

struct _HistoryClass {
	GObjectClass parent_class;
};

struct _HistoryEntry {
	GObject parent_instance;
	HistoryEntryPrivate * priv;
	GDateTime* date;
	gchar* name;
	guint duration;
};

struct _HistoryEntryClass {
	GObjectClass parent_class;
};

struct _Map {
	GObject parent_instance;
	MapPrivate * priv;
	gchar* name;
	gchar* score_name;
	GList* slots;
};

struct _MapClass {
	GObjectClass parent_class;
};

static gint ScoreDialog_private_offset;
static gpointer score_dialog_parent_class = NULL;

VALA_EXTERN GType score_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScoreDialog, g_object_unref)
VALA_EXTERN GType history_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (History, g_object_unref)
VALA_EXTERN GType history_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryEntry, g_object_unref)
VALA_EXTERN GType map_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Map, g_object_unref)
VALA_EXTERN ScoreDialog* score_dialog_new (History* history,
                               HistoryEntry* selected_entry,
                               gboolean show_quit,
                               GList* maps);
VALA_EXTERN ScoreDialog* score_dialog_construct (GType object_type,
                                     History* history,
                                     HistoryEntry* selected_entry,
                                     gboolean show_quit,
                                     GList* maps);
static void score_dialog_entry_added_cb (ScoreDialog* self,
                                  HistoryEntry* entry);
static void _score_dialog_entry_added_cb_history_entry_added (History* _sender,
                                                       HistoryEntry* entry,
                                                       gpointer self);
static void score_dialog_size_changed_cb (ScoreDialog* self,
                                   GtkComboBox* combo);
static void _score_dialog_size_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                          gpointer self);
VALA_EXTERN void score_dialog_set_map (ScoreDialog* self,
                           const gchar* name);
static gint score_dialog_compare_entries (HistoryEntry* a,
                                   HistoryEntry* b);
static gint _score_dialog_compare_entries_gcompare_func (gconstpointer a,
                                                  gconstpointer b);
static void _vala_GtkTreePath_free (GtkTreePath* self);
VALA_EXTERN GType slot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Slot, g_object_unref)
static void score_dialog_finalize (GObject * obj);
static GType score_dialog_get_type_once (void);

static inline gpointer
score_dialog_get_instance_private (ScoreDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ScoreDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_score_dialog_entry_added_cb_history_entry_added (History* _sender,
                                                  HistoryEntry* entry,
                                                  gpointer self)
{
	score_dialog_entry_added_cb ((ScoreDialog*) self, entry);
}

static void
_score_dialog_size_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender,
                                                     gpointer self)
{
	score_dialog_size_changed_cb ((ScoreDialog*) self, _sender);
}

ScoreDialog*
score_dialog_construct (GType object_type,
                        History* history,
                        HistoryEntry* selected_entry,
                        gboolean show_quit,
                        GList* maps)
{
	ScoreDialog * self = NULL;
	History* _tmp0_;
	HistoryEntry* _tmp1_;
	GtkListStore* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkListStore* _tmp5_;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp6_;
	GtkComboBox* _tmp7_;
	GtkCellRendererText* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkCellRendererText* _tmp10_;
	GtkListStore* _tmp11_;
	GtkCellRendererText* _tmp12_;
	GtkTreeView* _tmp13_;
	GtkCellRendererText* _tmp14_;
	GtkCellRendererText* _tmp15_;
	GtkCellRendererText* _tmp16_;
	GtkTreeView* _tmp17_;
	GtkCellRendererText* _tmp18_;
	GtkTreeView* _tmp19_;
	GtkListStore* _tmp20_;
	GList* _tmp21_;
	g_return_val_if_fail (history != NULL, NULL);
	self = (ScoreDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
	self->priv->maps = maps;
	_tmp0_ = _g_object_ref0 (history);
	_g_object_unref0 (self->priv->history);
	self->priv->history = _tmp0_;
	g_signal_connect_object (history, "entry-added", (GCallback) _score_dialog_entry_added_cb_history_entry_added, self, 0);
	_tmp1_ = _g_object_ref0 (selected_entry);
	_g_object_unref0 (self->priv->selected_entry);
	self->priv->selected_entry = _tmp1_;
	_tmp2_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->size_model);
	self->priv->size_model = _tmp2_;
	_tmp3_ = self->priv->layouts;
	g_signal_connect_object (_tmp3_, "changed", (GCallback) _score_dialog_size_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp4_ = self->priv->layouts;
	_tmp5_ = self->priv->size_model;
	gtk_combo_box_set_model (_tmp4_, (GtkTreeModel*) _tmp5_);
	_tmp6_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp6_);
	renderer = _tmp6_;
	_tmp7_ = self->priv->layouts;
	_tmp8_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp7_, (GtkCellRenderer*) _tmp8_, TRUE);
	_tmp9_ = self->priv->layouts;
	_tmp10_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) _tmp10_, "text", 0);
	if (show_quit) {
		gtk_dialog_add_button ((GtkDialog*) self, _ ("_Quit"), (gint) GTK_RESPONSE_CLOSE);
		gtk_dialog_add_button ((GtkDialog*) self, _ ("New Game"), (gint) GTK_RESPONSE_OK);
	} else {
		gtk_dialog_add_button ((GtkDialog*) self, _ ("OK"), (gint) GTK_RESPONSE_DELETE_EVENT);
	}
	gtk_widget_set_size_request ((GtkWidget*) self, 200, 300);
	_tmp11_ = gtk_list_store_new (3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT, -1);
	_g_object_unref0 (self->priv->score_model);
	self->priv->score_model = _tmp11_;
	_tmp12_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (renderer);
	renderer = _tmp12_;
	_tmp13_ = self->priv->scores;
	_tmp14_ = renderer;
	gtk_tree_view_insert_column_with_attributes (_tmp13_, -1, _ ("Date"), (GtkCellRenderer*) _tmp14_, "text", 0, "weight", 2, NULL);
	_tmp15_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (renderer);
	renderer = _tmp15_;
	_tmp16_ = renderer;
	g_object_set ((GtkCellRenderer*) _tmp16_, "xalign", 1.0f, NULL);
	_tmp17_ = self->priv->scores;
	_tmp18_ = renderer;
	gtk_tree_view_insert_column_with_attributes (_tmp17_, -1, _ ("Time"), (GtkCellRenderer*) _tmp18_, "text", 1, "weight", 2, NULL);
	_tmp19_ = self->priv->scores;
	_tmp20_ = self->priv->score_model;
	gtk_tree_view_set_model (_tmp19_, (GtkTreeModel*) _tmp20_);
	_tmp21_ = history->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp21_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			HistoryEntry* _tmp22_;
			HistoryEntry* entry = NULL;
			_tmp22_ = _g_object_ref0 ((HistoryEntry*) entry_it->data);
			entry = _tmp22_;
			{
				HistoryEntry* _tmp23_;
				_tmp23_ = entry;
				score_dialog_entry_added_cb (self, _tmp23_);
				_g_object_unref0 (entry);
			}
		}
	}
	_g_object_unref0 (renderer);
	return self;
}

ScoreDialog*
score_dialog_new (History* history,
                  HistoryEntry* selected_entry,
                  gboolean show_quit,
                  GList* maps)
{
	return score_dialog_construct (TYPE_SCORE_DIALOG, history, selected_entry, show_quit, maps);
}

static gint
_score_dialog_compare_entries_gcompare_func (gconstpointer a,
                                             gconstpointer b)
{
	gint result;
	result = score_dialog_compare_entries ((HistoryEntry*) a, (HistoryEntry*) b);
	return result;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

void
score_dialog_set_map (ScoreDialog* self,
                      const gchar* name)
{
	GtkListStore* _tmp0_;
	GList* entries = NULL;
	History* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->score_model;
	gtk_list_store_clear (_tmp0_);
	_tmp1_ = self->priv->history;
	_tmp2_ = _tmp1_->entries;
	_tmp3_ = g_list_copy (_tmp2_);
	entries = _tmp3_;
	entries = g_list_sort (entries, _score_dialog_compare_entries_gcompare_func);
	_tmp4_ = entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp4_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			HistoryEntry* entry = NULL;
			entry = (HistoryEntry*) entry_it->data;
			{
				HistoryEntry* _tmp5_;
				const gchar* _tmp6_;
				gchar* date_label = NULL;
				HistoryEntry* _tmp7_;
				GDateTime* _tmp8_;
				gchar* _tmp9_;
				gchar* time_label = NULL;
				HistoryEntry* _tmp10_;
				gchar* _tmp11_;
				HistoryEntry* _tmp12_;
				gint weight = 0;
				HistoryEntry* _tmp16_;
				HistoryEntry* _tmp17_;
				GtkTreeIter iter = {0};
				GtkListStore* _tmp18_;
				GtkTreeIter _tmp19_ = {0};
				GtkListStore* _tmp20_;
				GtkTreeIter _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				HistoryEntry* _tmp24_;
				HistoryEntry* _tmp25_;
				_tmp5_ = entry;
				_tmp6_ = _tmp5_->name;
				if (g_strcmp0 (_tmp6_, name) != 0) {
					continue;
				}
				_tmp7_ = entry;
				_tmp8_ = _tmp7_->date;
				_tmp9_ = g_date_time_format (_tmp8_, "%x");
				date_label = _tmp9_;
				_tmp10_ = entry;
				_tmp11_ = g_strdup_printf ("%us", _tmp10_->duration);
				time_label = _tmp11_;
				_tmp12_ = entry;
				if (_tmp12_->duration >= ((guint) 60)) {
					HistoryEntry* _tmp13_;
					HistoryEntry* _tmp14_;
					gchar* _tmp15_;
					_tmp13_ = entry;
					_tmp14_ = entry;
					_tmp15_ = g_strdup_printf ("%um %us", _tmp13_->duration / 60, _tmp14_->duration % 60);
					_g_free0 (time_label);
					time_label = _tmp15_;
				}
				weight = (gint) PANGO_WEIGHT_NORMAL;
				_tmp16_ = entry;
				_tmp17_ = self->priv->selected_entry;
				if (_tmp16_ == _tmp17_) {
					weight = (gint) PANGO_WEIGHT_BOLD;
				}
				_tmp18_ = self->priv->score_model;
				gtk_list_store_append (_tmp18_, &_tmp19_);
				iter = _tmp19_;
				_tmp20_ = self->priv->score_model;
				_tmp21_ = iter;
				_tmp22_ = date_label;
				_tmp23_ = time_label;
				gtk_list_store_set (_tmp20_, &_tmp21_, 0, _tmp22_, 1, _tmp23_, 2, weight, -1);
				_tmp24_ = entry;
				_tmp25_ = self->priv->selected_entry;
				if (_tmp24_ == _tmp25_) {
					GtkTreeIter piter = {0};
					GtkTreeIter _tmp26_;
					GtkListStore* _tmp27_;
					gboolean _tmp28_;
					GtkTreeView* _tmp34_;
					GtkListStore* _tmp35_;
					GtkTreeIter _tmp36_;
					GtkTreePath* _tmp37_;
					GtkTreePath* _tmp38_;
					_tmp26_ = iter;
					piter = _tmp26_;
					_tmp27_ = self->priv->score_model;
					_tmp28_ = gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp27_, &piter);
					if (_tmp28_) {
						GtkTreeIter ppiter = {0};
						GtkTreeIter _tmp29_;
						GtkListStore* _tmp30_;
						gboolean _tmp31_;
						_tmp29_ = piter;
						ppiter = _tmp29_;
						_tmp30_ = self->priv->score_model;
						_tmp31_ = gtk_tree_model_iter_previous ((GtkTreeModel*) _tmp30_, &ppiter);
						if (_tmp31_) {
							GtkTreeIter _tmp32_;
							_tmp32_ = ppiter;
							piter = _tmp32_;
						}
					} else {
						GtkTreeIter _tmp33_;
						_tmp33_ = iter;
						piter = _tmp33_;
					}
					_tmp34_ = self->priv->scores;
					_tmp35_ = self->priv->score_model;
					_tmp36_ = piter;
					_tmp37_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp35_, &_tmp36_);
					_tmp38_ = _tmp37_;
					gtk_tree_view_scroll_to_cell (_tmp34_, _tmp38_, NULL, FALSE, (gfloat) 0, (gfloat) 0);
					__vala_GtkTreePath_free0 (_tmp38_);
				}
				_g_free0 (time_label);
				_g_free0 (date_label);
			}
		}
	}
	(entries == NULL) ? NULL : (entries = (g_list_free (entries), NULL));
}

static gint
score_dialog_compare_entries (HistoryEntry* a,
                              HistoryEntry* b)
{
	gint d = 0;
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = a->name;
	_tmp2_ = b->name;
	d = _tmp0_ (_tmp1_, _tmp2_);
	if (d != 0) {
		result = d;
		return result;
	}
	if (a->duration != b->duration) {
		result = ((gint) a->duration) - ((gint) b->duration);
		return result;
	}
	_tmp3_ = a->date;
	_tmp4_ = b->date;
	result = g_date_time_compare (_tmp3_, _tmp4_);
	return result;
}

static void
score_dialog_size_changed_cb (ScoreDialog* self,
                              GtkComboBox* combo)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	gchar* name = NULL;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (combo, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (combo);
	_tmp3_ = _tmp2_;
	_tmp4_ = iter;
	gtk_tree_model_get (_tmp3_, &_tmp4_, 1, &_tmp5_, -1);
	_g_free0 (name);
	name = _tmp5_;
	_tmp6_ = name;
	score_dialog_set_map (self, _tmp6_);
	_g_free0 (name);
}

static void
score_dialog_entry_added_cb (ScoreDialog* self,
                             HistoryEntry* entry)
{
	GtkTreeIter iter = {0};
	gboolean have_size_entry = FALSE;
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	have_size_entry = FALSE;
	_tmp0_ = self->priv->size_model;
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (_tmp2_) {
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar* name = NULL;
				GtkListStore* _tmp6_;
				GtkTreeIter _tmp7_;
				gchar* _tmp8_ = NULL;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				if (!_tmp3_) {
					GtkListStore* _tmp4_;
					gboolean _tmp5_;
					_tmp4_ = self->priv->size_model;
					_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter);
					if (!_tmp5_) {
						break;
					}
				}
				_tmp3_ = FALSE;
				_tmp6_ = self->priv->size_model;
				_tmp7_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, 1, &_tmp8_, -1);
				_g_free0 (name);
				name = _tmp8_;
				_tmp9_ = name;
				_tmp10_ = entry->name;
				if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
					have_size_entry = TRUE;
					_g_free0 (name);
					break;
				}
				_g_free0 (name);
			}
		}
	}
	if (!have_size_entry) {
		GList* map = NULL;
		GList* _tmp11_;
		GList* _tmp12_;
		gchar* display_name = NULL;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		GtkListStore* _tmp27_;
		GtkTreeIter _tmp28_ = {0};
		GtkListStore* _tmp29_;
		GtkTreeIter _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		GtkComboBox* _tmp33_;
		gboolean _tmp36_ = FALSE;
		HistoryEntry* _tmp37_;
		_tmp11_ = self->priv->maps;
		_tmp12_ = g_list_first (_tmp11_);
		map = _tmp12_;
		_tmp13_ = entry->name;
		_tmp14_ = g_strdup (_tmp13_);
		display_name = _tmp14_;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				GList* _tmp19_;
				gconstpointer _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				if (!_tmp15_) {
					GList* _tmp16_;
					GList* _tmp17_;
					GList* _tmp18_;
					_tmp16_ = map;
					_tmp17_ = _tmp16_->next;
					map = _tmp17_;
					_tmp18_ = map;
					if (!(_tmp18_ != NULL)) {
						break;
					}
				}
				_tmp15_ = FALSE;
				_tmp19_ = map;
				_tmp20_ = _tmp19_->data;
				_tmp21_ = ((Map*) _tmp20_)->score_name;
				_tmp22_ = display_name;
				if (g_strcmp0 (_tmp21_, _tmp22_) == 0) {
					GList* _tmp23_;
					gconstpointer _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp23_ = map;
					_tmp24_ = _tmp23_->data;
					_tmp25_ = ((Map*) _tmp24_)->name;
					_tmp26_ = g_strdup (g_dpgettext2 (NULL, "mahjongg map name", _tmp25_));
					_g_free0 (display_name);
					display_name = _tmp26_;
					break;
				}
			}
		}
		_tmp27_ = self->priv->size_model;
		gtk_list_store_append (_tmp27_, &_tmp28_);
		iter = _tmp28_;
		_tmp29_ = self->priv->size_model;
		_tmp30_ = iter;
		_tmp31_ = display_name;
		_tmp32_ = entry->name;
		gtk_list_store_set (_tmp29_, &_tmp30_, 0, _tmp31_, 1, _tmp32_, -1);
		_tmp33_ = self->priv->layouts;
		if (gtk_combo_box_get_active (_tmp33_) == -1) {
			GtkComboBox* _tmp34_;
			GtkTreeIter _tmp35_;
			_tmp34_ = self->priv->layouts;
			_tmp35_ = iter;
			gtk_combo_box_set_active_iter (_tmp34_, &_tmp35_);
		}
		_tmp37_ = self->priv->selected_entry;
		if (_tmp37_ != NULL) {
			const gchar* _tmp38_;
			HistoryEntry* _tmp39_;
			const gchar* _tmp40_;
			_tmp38_ = entry->name;
			_tmp39_ = self->priv->selected_entry;
			_tmp40_ = _tmp39_->name;
			_tmp36_ = g_strcmp0 (_tmp38_, _tmp40_) == 0;
		} else {
			_tmp36_ = FALSE;
		}
		if (_tmp36_) {
			GtkComboBox* _tmp41_;
			GtkTreeIter _tmp42_;
			_tmp41_ = self->priv->layouts;
			_tmp42_ = iter;
			gtk_combo_box_set_active_iter (_tmp41_, &_tmp42_);
		}
		_g_free0 (display_name);
	}
}

static void
score_dialog_class_init (ScoreDialogClass * klass,
                         gpointer klass_data)
{
	score_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScoreDialog_private_offset);
	G_OBJECT_CLASS (klass)->finalize = score_dialog_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Mahjongg/ui/score-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "layouts", FALSE, ScoreDialog_private_offset + G_STRUCT_OFFSET (ScoreDialogPrivate, layouts));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scores", FALSE, ScoreDialog_private_offset + G_STRUCT_OFFSET (ScoreDialogPrivate, scores));
}

static void
score_dialog_instance_init (ScoreDialog * self,
                            gpointer klass)
{
	self->priv = score_dialog_get_instance_private (self);
	self->priv->selected_entry = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
score_dialog_finalize (GObject * obj)
{
	ScoreDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SCORE_DIALOG, ScoreDialog);
	_g_object_unref0 (self->priv->history);
	_g_object_unref0 (self->priv->selected_entry);
	_g_object_unref0 (self->priv->size_model);
	_g_object_unref0 (self->priv->score_model);
	G_OBJECT_CLASS (score_dialog_parent_class)->finalize (obj);
}

static GType
score_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScoreDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) score_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScoreDialog), 0, (GInstanceInitFunc) score_dialog_instance_init, NULL };
	GType score_dialog_type_id;
	score_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "ScoreDialog", &g_define_type_info, 0);
	ScoreDialog_private_offset = g_type_add_instance_private (score_dialog_type_id, sizeof (ScoreDialogPrivate));
	return score_dialog_type_id;
}

GType
score_dialog_get_type (void)
{
	static volatile gsize score_dialog_type_id__once = 0;
	if (g_once_init_enter (&score_dialog_type_id__once)) {
		GType score_dialog_type_id;
		score_dialog_type_id = score_dialog_get_type_once ();
		g_once_init_leave (&score_dialog_type_id__once, score_dialog_type_id);
	}
	return score_dialog_type_id__once;
}

