/* map.c generated by valac 0.56.16, the Vala compiler
 * generated from map.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;
typedef struct _SlotPrivate SlotPrivate;
enum  {
	SLOT_0_PROPERTY,
	SLOT_NUM_PROPERTIES
};
static GParamSpec* slot_properties[SLOT_NUM_PROPERTIES];

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;
typedef struct _MapPrivate MapPrivate;
enum  {
	MAP_0_PROPERTY,
	MAP_WIDTH_PROPERTY,
	MAP_HEIGHT_PROPERTY,
	MAP_NUM_PROPERTIES
};
static GParamSpec* map_properties[MAP_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAP_LOADER (map_loader_get_type ())
#define MAP_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP_LOADER, MapLoader))
#define MAP_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP_LOADER, MapLoaderClass))
#define IS_MAP_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP_LOADER))
#define IS_MAP_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP_LOADER))
#define MAP_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP_LOADER, MapLoaderClass))

typedef struct _MapLoader MapLoader;
typedef struct _MapLoaderClass MapLoaderClass;
typedef struct _MapLoaderPrivate MapLoaderPrivate;
enum  {
	MAP_LOADER_0_PROPERTY,
	MAP_LOADER_NUM_PROPERTIES
};
static GParamSpec* map_loader_properties[MAP_LOADER_NUM_PROPERTIES];
typedef void (*GMarkupParserStartElementFunc) (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer user_data, GError** error);
typedef void (*GMarkupParserEndElementFunc) (GMarkupParseContext* context, const gchar* element_name, gpointer user_data, GError** error);
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))

struct _Slot {
	GObject parent_instance;
	SlotPrivate * priv;
	gint x;
	gint y;
	gint layer;
};

struct _SlotClass {
	GObjectClass parent_class;
};

struct _Map {
	GObject parent_instance;
	MapPrivate * priv;
	gchar* name;
	gchar* score_name;
	GList* slots;
};

struct _MapClass {
	GObjectClass parent_class;
};

struct _MapLoader {
	GObject parent_instance;
	MapLoaderPrivate * priv;
	GList* maps;
};

struct _MapLoaderClass {
	GObjectClass parent_class;
};

struct _MapLoaderPrivate {
	Map* map;
	gint layer_z;
};

static gpointer slot_parent_class = NULL;
static gpointer map_parent_class = NULL;
static gint MapLoader_private_offset;
static gpointer map_loader_parent_class = NULL;

VALA_EXTERN GType slot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Slot, g_object_unref)
VALA_EXTERN Slot* slot_new (gint x,
                gint y,
                gint layer);
VALA_EXTERN Slot* slot_construct (GType object_type,
                      gint x,
                      gint y,
                      gint layer);
static void slot_finalize (GObject * obj);
static GType slot_get_type_once (void);
VALA_EXTERN gint compare_slots (Slot* a,
                    Slot* b);
VALA_EXTERN GType map_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Map, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN Map* map_new_test (void);
VALA_EXTERN Map* map_construct_test (GType object_type);
VALA_EXTERN Map* map_new_builtin (void);
VALA_EXTERN Map* map_construct_builtin (GType object_type);
VALA_EXTERN Map* map_new (void);
VALA_EXTERN Map* map_construct (GType object_type);
VALA_EXTERN guint map_get_width (Map* self);
VALA_EXTERN guint map_get_height (Map* self);
static void map_finalize (GObject * obj);
static GType map_get_type_once (void);
static void _vala_map_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec);
VALA_EXTERN GType map_loader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MapLoader, g_object_unref)
VALA_EXTERN void map_loader_load (MapLoader* self,
                      const gchar* filename,
                      GError** error);
static void map_loader_start_element_cb (MapLoader* self,
                                  GMarkupParseContext* context,
                                  const gchar* element_name,
                                  gchar** attribute_names,
                                  gint attribute_names_length1,
                                  gchar** attribute_values,
                                  gint attribute_values_length1,
                                  GError** error);
static void _map_loader_start_element_cb_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                     const gchar* element_name,
                                                                     gchar** attribute_names,
                                                                     gchar** attribute_values,
                                                                     gpointer self,
                                                                     GError** error);
static void map_loader_end_element_cb (MapLoader* self,
                                GMarkupParseContext* context,
                                const gchar* element_name,
                                GError** error);
static void _map_loader_end_element_cb_gmarkup_parser_end_element_func (GMarkupParseContext* context,
                                                                 const gchar* element_name,
                                                                 gpointer self,
                                                                 GError** error);
static gchar* map_loader_get_attribute (MapLoader* self,
                                 gchar** attribute_names,
                                 gint attribute_names_length1,
                                 gchar** attribute_values,
                                 gint attribute_values_length1,
                                 const gchar* name,
                                 const gchar* _default_);
static gdouble map_loader_get_attribute_d (MapLoader* self,
                                    gchar** attribute_names,
                                    gint attribute_names_length1,
                                    gchar** attribute_values,
                                    gint attribute_values_length1,
                                    const gchar* name,
                                    gdouble _default_);
VALA_EXTERN MapLoader* map_loader_new (void);
VALA_EXTERN MapLoader* map_loader_construct (GType object_type);
static void map_loader_finalize (GObject * obj);
static GType map_loader_get_type_once (void);
static gssize _vala_array_length (gpointer array);

Slot*
slot_construct (GType object_type,
                gint x,
                gint y,
                gint layer)
{
	Slot * self = NULL;
	self = (Slot*) g_object_new (object_type, NULL);
	self->x = x;
	self->y = y;
	self->layer = layer;
	return self;
}

Slot*
slot_new (gint x,
          gint y,
          gint layer)
{
	return slot_construct (TYPE_SLOT, x, y, layer);
}

static void
slot_class_init (SlotClass * klass,
                 gpointer klass_data)
{
	slot_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = slot_finalize;
}

static void
slot_instance_init (Slot * self,
                    gpointer klass)
{
}

static void
slot_finalize (GObject * obj)
{
	Slot * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SLOT, Slot);
	G_OBJECT_CLASS (slot_parent_class)->finalize (obj);
}

static GType
slot_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlotClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slot_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Slot), 0, (GInstanceInitFunc) slot_instance_init, NULL };
	GType slot_type_id;
	slot_type_id = g_type_register_static (G_TYPE_OBJECT, "Slot", &g_define_type_info, 0);
	return slot_type_id;
}

GType
slot_get_type (void)
{
	static volatile gsize slot_type_id__once = 0;
	if (g_once_init_enter (&slot_type_id__once)) {
		GType slot_type_id;
		slot_type_id = slot_get_type_once ();
		g_once_init_leave (&slot_type_id__once, slot_type_id);
	}
	return slot_type_id__once;
}

gint
compare_slots (Slot* a,
               Slot* b)
{
	gint dl = 0;
	gint dx = 0;
	gint dy = 0;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	dl = a->layer - b->layer;
	if (dl != 0) {
		result = dl;
		return result;
	}
	dx = a->x - b->x;
	dy = a->y - b->y;
	if (dx > dy) {
		result = -1;
		return result;
	}
	if (dx < dy) {
		result = 1;
		return result;
	}
	result = 0;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

Map*
map_construct_test (GType object_type)
{
	Map * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	Slot* _tmp2_;
	Slot* _tmp3_;
	Slot* _tmp4_;
	Slot* _tmp5_;
	Slot* _tmp6_;
	Slot* _tmp7_;
	Slot* _tmp8_;
	Slot* _tmp9_;
	self = (Map*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup ("Test");
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = g_strdup ("test");
	_g_free0 (self->score_name);
	self->score_name = _tmp1_;
	_tmp2_ = slot_new (0, 0, 0);
	self->slots = g_list_append (self->slots, _tmp2_);
	_tmp3_ = slot_new (2, 0, 0);
	self->slots = g_list_append (self->slots, _tmp3_);
	_tmp4_ = slot_new (2, 0, 1);
	self->slots = g_list_append (self->slots, _tmp4_);
	_tmp5_ = slot_new (4, 0, 0);
	self->slots = g_list_append (self->slots, _tmp5_);
	_tmp6_ = slot_new (0, 2, 0);
	self->slots = g_list_append (self->slots, _tmp6_);
	_tmp7_ = slot_new (2, 2, 0);
	self->slots = g_list_append (self->slots, _tmp7_);
	_tmp8_ = slot_new (2, 2, 1);
	self->slots = g_list_append (self->slots, _tmp8_);
	_tmp9_ = slot_new (4, 2, 0);
	self->slots = g_list_append (self->slots, _tmp9_);
	return self;
}

Map*
map_new_test (void)
{
	return map_construct_test (TYPE_MAP);
}

Map*
map_construct_builtin (GType object_type)
{
	Map * self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	Slot* _tmp2_;
	Slot* _tmp3_;
	Slot* _tmp4_;
	Slot* _tmp5_;
	Slot* _tmp6_;
	Slot* _tmp7_;
	Slot* _tmp8_;
	Slot* _tmp9_;
	Slot* _tmp10_;
	Slot* _tmp11_;
	Slot* _tmp12_;
	Slot* _tmp13_;
	Slot* _tmp14_;
	Slot* _tmp15_;
	Slot* _tmp16_;
	Slot* _tmp17_;
	Slot* _tmp18_;
	Slot* _tmp19_;
	Slot* _tmp20_;
	Slot* _tmp21_;
	Slot* _tmp22_;
	Slot* _tmp23_;
	Slot* _tmp24_;
	Slot* _tmp25_;
	Slot* _tmp26_;
	Slot* _tmp27_;
	Slot* _tmp28_;
	Slot* _tmp29_;
	Slot* _tmp30_;
	Slot* _tmp31_;
	Slot* _tmp32_;
	Slot* _tmp33_;
	Slot* _tmp34_;
	Slot* _tmp35_;
	Slot* _tmp36_;
	Slot* _tmp37_;
	Slot* _tmp38_;
	Slot* _tmp39_;
	Slot* _tmp40_;
	Slot* _tmp41_;
	Slot* _tmp42_;
	Slot* _tmp43_;
	Slot* _tmp44_;
	Slot* _tmp45_;
	Slot* _tmp46_;
	Slot* _tmp47_;
	Slot* _tmp48_;
	Slot* _tmp49_;
	Slot* _tmp50_;
	Slot* _tmp51_;
	Slot* _tmp52_;
	Slot* _tmp53_;
	Slot* _tmp54_;
	Slot* _tmp55_;
	Slot* _tmp56_;
	Slot* _tmp57_;
	Slot* _tmp58_;
	Slot* _tmp59_;
	Slot* _tmp60_;
	Slot* _tmp61_;
	Slot* _tmp62_;
	Slot* _tmp63_;
	Slot* _tmp64_;
	Slot* _tmp65_;
	Slot* _tmp66_;
	Slot* _tmp67_;
	Slot* _tmp68_;
	Slot* _tmp69_;
	Slot* _tmp70_;
	Slot* _tmp71_;
	Slot* _tmp72_;
	Slot* _tmp73_;
	Slot* _tmp74_;
	Slot* _tmp75_;
	Slot* _tmp76_;
	Slot* _tmp77_;
	Slot* _tmp78_;
	Slot* _tmp79_;
	Slot* _tmp80_;
	Slot* _tmp81_;
	Slot* _tmp82_;
	Slot* _tmp83_;
	Slot* _tmp84_;
	Slot* _tmp85_;
	Slot* _tmp86_;
	Slot* _tmp87_;
	Slot* _tmp88_;
	Slot* _tmp89_;
	Slot* _tmp90_;
	Slot* _tmp91_;
	Slot* _tmp92_;
	Slot* _tmp93_;
	Slot* _tmp94_;
	Slot* _tmp95_;
	Slot* _tmp96_;
	Slot* _tmp97_;
	Slot* _tmp98_;
	Slot* _tmp99_;
	Slot* _tmp100_;
	Slot* _tmp101_;
	Slot* _tmp102_;
	Slot* _tmp103_;
	Slot* _tmp104_;
	Slot* _tmp105_;
	Slot* _tmp106_;
	Slot* _tmp107_;
	Slot* _tmp108_;
	Slot* _tmp109_;
	Slot* _tmp110_;
	Slot* _tmp111_;
	Slot* _tmp112_;
	Slot* _tmp113_;
	Slot* _tmp114_;
	Slot* _tmp115_;
	Slot* _tmp116_;
	Slot* _tmp117_;
	Slot* _tmp118_;
	Slot* _tmp119_;
	Slot* _tmp120_;
	Slot* _tmp121_;
	Slot* _tmp122_;
	Slot* _tmp123_;
	Slot* _tmp124_;
	Slot* _tmp125_;
	Slot* _tmp126_;
	Slot* _tmp127_;
	Slot* _tmp128_;
	Slot* _tmp129_;
	Slot* _tmp130_;
	Slot* _tmp131_;
	Slot* _tmp132_;
	Slot* _tmp133_;
	Slot* _tmp134_;
	Slot* _tmp135_;
	Slot* _tmp136_;
	Slot* _tmp137_;
	Slot* _tmp138_;
	Slot* _tmp139_;
	Slot* _tmp140_;
	Slot* _tmp141_;
	Slot* _tmp142_;
	Slot* _tmp143_;
	Slot* _tmp144_;
	Slot* _tmp145_;
	self = (Map*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup ("Easy");
	_g_free0 (self->name);
	self->name = _tmp0_;
	_tmp1_ = g_strdup ("easy");
	_g_free0 (self->score_name);
	self->score_name = _tmp1_;
	_tmp2_ = slot_new (13, 7, 4);
	self->slots = g_list_append (self->slots, _tmp2_);
	_tmp3_ = slot_new (12, 8, 3);
	self->slots = g_list_append (self->slots, _tmp3_);
	_tmp4_ = slot_new (14, 8, 3);
	self->slots = g_list_append (self->slots, _tmp4_);
	_tmp5_ = slot_new (12, 6, 3);
	self->slots = g_list_append (self->slots, _tmp5_);
	_tmp6_ = slot_new (14, 6, 3);
	self->slots = g_list_append (self->slots, _tmp6_);
	_tmp7_ = slot_new (10, 10, 2);
	self->slots = g_list_append (self->slots, _tmp7_);
	_tmp8_ = slot_new (12, 10, 2);
	self->slots = g_list_append (self->slots, _tmp8_);
	_tmp9_ = slot_new (14, 10, 2);
	self->slots = g_list_append (self->slots, _tmp9_);
	_tmp10_ = slot_new (16, 10, 2);
	self->slots = g_list_append (self->slots, _tmp10_);
	_tmp11_ = slot_new (10, 8, 2);
	self->slots = g_list_append (self->slots, _tmp11_);
	_tmp12_ = slot_new (12, 8, 2);
	self->slots = g_list_append (self->slots, _tmp12_);
	_tmp13_ = slot_new (14, 8, 2);
	self->slots = g_list_append (self->slots, _tmp13_);
	_tmp14_ = slot_new (16, 8, 2);
	self->slots = g_list_append (self->slots, _tmp14_);
	_tmp15_ = slot_new (10, 6, 2);
	self->slots = g_list_append (self->slots, _tmp15_);
	_tmp16_ = slot_new (12, 6, 2);
	self->slots = g_list_append (self->slots, _tmp16_);
	_tmp17_ = slot_new (14, 6, 2);
	self->slots = g_list_append (self->slots, _tmp17_);
	_tmp18_ = slot_new (16, 6, 2);
	self->slots = g_list_append (self->slots, _tmp18_);
	_tmp19_ = slot_new (10, 4, 2);
	self->slots = g_list_append (self->slots, _tmp19_);
	_tmp20_ = slot_new (12, 4, 2);
	self->slots = g_list_append (self->slots, _tmp20_);
	_tmp21_ = slot_new (14, 4, 2);
	self->slots = g_list_append (self->slots, _tmp21_);
	_tmp22_ = slot_new (16, 4, 2);
	self->slots = g_list_append (self->slots, _tmp22_);
	_tmp23_ = slot_new (8, 12, 1);
	self->slots = g_list_append (self->slots, _tmp23_);
	_tmp24_ = slot_new (10, 12, 1);
	self->slots = g_list_append (self->slots, _tmp24_);
	_tmp25_ = slot_new (12, 12, 1);
	self->slots = g_list_append (self->slots, _tmp25_);
	_tmp26_ = slot_new (14, 12, 1);
	self->slots = g_list_append (self->slots, _tmp26_);
	_tmp27_ = slot_new (16, 12, 1);
	self->slots = g_list_append (self->slots, _tmp27_);
	_tmp28_ = slot_new (18, 12, 1);
	self->slots = g_list_append (self->slots, _tmp28_);
	_tmp29_ = slot_new (8, 10, 1);
	self->slots = g_list_append (self->slots, _tmp29_);
	_tmp30_ = slot_new (10, 10, 1);
	self->slots = g_list_append (self->slots, _tmp30_);
	_tmp31_ = slot_new (12, 10, 1);
	self->slots = g_list_append (self->slots, _tmp31_);
	_tmp32_ = slot_new (14, 10, 1);
	self->slots = g_list_append (self->slots, _tmp32_);
	_tmp33_ = slot_new (16, 10, 1);
	self->slots = g_list_append (self->slots, _tmp33_);
	_tmp34_ = slot_new (18, 10, 1);
	self->slots = g_list_append (self->slots, _tmp34_);
	_tmp35_ = slot_new (8, 8, 1);
	self->slots = g_list_append (self->slots, _tmp35_);
	_tmp36_ = slot_new (10, 8, 1);
	self->slots = g_list_append (self->slots, _tmp36_);
	_tmp37_ = slot_new (12, 8, 1);
	self->slots = g_list_append (self->slots, _tmp37_);
	_tmp38_ = slot_new (14, 8, 1);
	self->slots = g_list_append (self->slots, _tmp38_);
	_tmp39_ = slot_new (16, 8, 1);
	self->slots = g_list_append (self->slots, _tmp39_);
	_tmp40_ = slot_new (18, 8, 1);
	self->slots = g_list_append (self->slots, _tmp40_);
	_tmp41_ = slot_new (8, 6, 1);
	self->slots = g_list_append (self->slots, _tmp41_);
	_tmp42_ = slot_new (10, 6, 1);
	self->slots = g_list_append (self->slots, _tmp42_);
	_tmp43_ = slot_new (12, 6, 1);
	self->slots = g_list_append (self->slots, _tmp43_);
	_tmp44_ = slot_new (14, 6, 1);
	self->slots = g_list_append (self->slots, _tmp44_);
	_tmp45_ = slot_new (16, 6, 1);
	self->slots = g_list_append (self->slots, _tmp45_);
	_tmp46_ = slot_new (18, 6, 1);
	self->slots = g_list_append (self->slots, _tmp46_);
	_tmp47_ = slot_new (8, 4, 1);
	self->slots = g_list_append (self->slots, _tmp47_);
	_tmp48_ = slot_new (10, 4, 1);
	self->slots = g_list_append (self->slots, _tmp48_);
	_tmp49_ = slot_new (12, 4, 1);
	self->slots = g_list_append (self->slots, _tmp49_);
	_tmp50_ = slot_new (14, 4, 1);
	self->slots = g_list_append (self->slots, _tmp50_);
	_tmp51_ = slot_new (16, 4, 1);
	self->slots = g_list_append (self->slots, _tmp51_);
	_tmp52_ = slot_new (18, 4, 1);
	self->slots = g_list_append (self->slots, _tmp52_);
	_tmp53_ = slot_new (8, 2, 1);
	self->slots = g_list_append (self->slots, _tmp53_);
	_tmp54_ = slot_new (10, 2, 1);
	self->slots = g_list_append (self->slots, _tmp54_);
	_tmp55_ = slot_new (12, 2, 1);
	self->slots = g_list_append (self->slots, _tmp55_);
	_tmp56_ = slot_new (14, 2, 1);
	self->slots = g_list_append (self->slots, _tmp56_);
	_tmp57_ = slot_new (16, 2, 1);
	self->slots = g_list_append (self->slots, _tmp57_);
	_tmp58_ = slot_new (18, 2, 1);
	self->slots = g_list_append (self->slots, _tmp58_);
	_tmp59_ = slot_new (2, 14, 0);
	self->slots = g_list_append (self->slots, _tmp59_);
	_tmp60_ = slot_new (4, 14, 0);
	self->slots = g_list_append (self->slots, _tmp60_);
	_tmp61_ = slot_new (6, 14, 0);
	self->slots = g_list_append (self->slots, _tmp61_);
	_tmp62_ = slot_new (8, 14, 0);
	self->slots = g_list_append (self->slots, _tmp62_);
	_tmp63_ = slot_new (10, 14, 0);
	self->slots = g_list_append (self->slots, _tmp63_);
	_tmp64_ = slot_new (12, 14, 0);
	self->slots = g_list_append (self->slots, _tmp64_);
	_tmp65_ = slot_new (14, 14, 0);
	self->slots = g_list_append (self->slots, _tmp65_);
	_tmp66_ = slot_new (16, 14, 0);
	self->slots = g_list_append (self->slots, _tmp66_);
	_tmp67_ = slot_new (18, 14, 0);
	self->slots = g_list_append (self->slots, _tmp67_);
	_tmp68_ = slot_new (20, 14, 0);
	self->slots = g_list_append (self->slots, _tmp68_);
	_tmp69_ = slot_new (22, 14, 0);
	self->slots = g_list_append (self->slots, _tmp69_);
	_tmp70_ = slot_new (24, 14, 0);
	self->slots = g_list_append (self->slots, _tmp70_);
	_tmp71_ = slot_new (6, 12, 0);
	self->slots = g_list_append (self->slots, _tmp71_);
	_tmp72_ = slot_new (8, 12, 0);
	self->slots = g_list_append (self->slots, _tmp72_);
	_tmp73_ = slot_new (10, 12, 0);
	self->slots = g_list_append (self->slots, _tmp73_);
	_tmp74_ = slot_new (12, 12, 0);
	self->slots = g_list_append (self->slots, _tmp74_);
	_tmp75_ = slot_new (14, 12, 0);
	self->slots = g_list_append (self->slots, _tmp75_);
	_tmp76_ = slot_new (16, 12, 0);
	self->slots = g_list_append (self->slots, _tmp76_);
	_tmp77_ = slot_new (18, 12, 0);
	self->slots = g_list_append (self->slots, _tmp77_);
	_tmp78_ = slot_new (20, 12, 0);
	self->slots = g_list_append (self->slots, _tmp78_);
	_tmp79_ = slot_new (4, 10, 0);
	self->slots = g_list_append (self->slots, _tmp79_);
	_tmp80_ = slot_new (6, 10, 0);
	self->slots = g_list_append (self->slots, _tmp80_);
	_tmp81_ = slot_new (8, 10, 0);
	self->slots = g_list_append (self->slots, _tmp81_);
	_tmp82_ = slot_new (10, 10, 0);
	self->slots = g_list_append (self->slots, _tmp82_);
	_tmp83_ = slot_new (12, 10, 0);
	self->slots = g_list_append (self->slots, _tmp83_);
	_tmp84_ = slot_new (14, 10, 0);
	self->slots = g_list_append (self->slots, _tmp84_);
	_tmp85_ = slot_new (16, 10, 0);
	self->slots = g_list_append (self->slots, _tmp85_);
	_tmp86_ = slot_new (18, 10, 0);
	self->slots = g_list_append (self->slots, _tmp86_);
	_tmp87_ = slot_new (20, 10, 0);
	self->slots = g_list_append (self->slots, _tmp87_);
	_tmp88_ = slot_new (22, 10, 0);
	self->slots = g_list_append (self->slots, _tmp88_);
	_tmp89_ = slot_new (0, 7, 0);
	self->slots = g_list_append (self->slots, _tmp89_);
	_tmp90_ = slot_new (2, 8, 0);
	self->slots = g_list_append (self->slots, _tmp90_);
	_tmp91_ = slot_new (4, 8, 0);
	self->slots = g_list_append (self->slots, _tmp91_);
	_tmp92_ = slot_new (6, 8, 0);
	self->slots = g_list_append (self->slots, _tmp92_);
	_tmp93_ = slot_new (8, 8, 0);
	self->slots = g_list_append (self->slots, _tmp93_);
	_tmp94_ = slot_new (10, 8, 0);
	self->slots = g_list_append (self->slots, _tmp94_);
	_tmp95_ = slot_new (12, 8, 0);
	self->slots = g_list_append (self->slots, _tmp95_);
	_tmp96_ = slot_new (14, 8, 0);
	self->slots = g_list_append (self->slots, _tmp96_);
	_tmp97_ = slot_new (16, 8, 0);
	self->slots = g_list_append (self->slots, _tmp97_);
	_tmp98_ = slot_new (18, 8, 0);
	self->slots = g_list_append (self->slots, _tmp98_);
	_tmp99_ = slot_new (20, 8, 0);
	self->slots = g_list_append (self->slots, _tmp99_);
	_tmp100_ = slot_new (22, 8, 0);
	self->slots = g_list_append (self->slots, _tmp100_);
	_tmp101_ = slot_new (24, 8, 0);
	self->slots = g_list_append (self->slots, _tmp101_);
	_tmp102_ = slot_new (2, 6, 0);
	self->slots = g_list_append (self->slots, _tmp102_);
	_tmp103_ = slot_new (4, 6, 0);
	self->slots = g_list_append (self->slots, _tmp103_);
	_tmp104_ = slot_new (6, 6, 0);
	self->slots = g_list_append (self->slots, _tmp104_);
	_tmp105_ = slot_new (8, 6, 0);
	self->slots = g_list_append (self->slots, _tmp105_);
	_tmp106_ = slot_new (10, 6, 0);
	self->slots = g_list_append (self->slots, _tmp106_);
	_tmp107_ = slot_new (12, 6, 0);
	self->slots = g_list_append (self->slots, _tmp107_);
	_tmp108_ = slot_new (14, 6, 0);
	self->slots = g_list_append (self->slots, _tmp108_);
	_tmp109_ = slot_new (16, 6, 0);
	self->slots = g_list_append (self->slots, _tmp109_);
	_tmp110_ = slot_new (18, 6, 0);
	self->slots = g_list_append (self->slots, _tmp110_);
	_tmp111_ = slot_new (20, 6, 0);
	self->slots = g_list_append (self->slots, _tmp111_);
	_tmp112_ = slot_new (22, 6, 0);
	self->slots = g_list_append (self->slots, _tmp112_);
	_tmp113_ = slot_new (24, 6, 0);
	self->slots = g_list_append (self->slots, _tmp113_);
	_tmp114_ = slot_new (4, 4, 0);
	self->slots = g_list_append (self->slots, _tmp114_);
	_tmp115_ = slot_new (6, 4, 0);
	self->slots = g_list_append (self->slots, _tmp115_);
	_tmp116_ = slot_new (8, 4, 0);
	self->slots = g_list_append (self->slots, _tmp116_);
	_tmp117_ = slot_new (10, 4, 0);
	self->slots = g_list_append (self->slots, _tmp117_);
	_tmp118_ = slot_new (12, 4, 0);
	self->slots = g_list_append (self->slots, _tmp118_);
	_tmp119_ = slot_new (14, 4, 0);
	self->slots = g_list_append (self->slots, _tmp119_);
	_tmp120_ = slot_new (16, 4, 0);
	self->slots = g_list_append (self->slots, _tmp120_);
	_tmp121_ = slot_new (18, 4, 0);
	self->slots = g_list_append (self->slots, _tmp121_);
	_tmp122_ = slot_new (20, 4, 0);
	self->slots = g_list_append (self->slots, _tmp122_);
	_tmp123_ = slot_new (22, 4, 0);
	self->slots = g_list_append (self->slots, _tmp123_);
	_tmp124_ = slot_new (6, 2, 0);
	self->slots = g_list_append (self->slots, _tmp124_);
	_tmp125_ = slot_new (8, 2, 0);
	self->slots = g_list_append (self->slots, _tmp125_);
	_tmp126_ = slot_new (10, 2, 0);
	self->slots = g_list_append (self->slots, _tmp126_);
	_tmp127_ = slot_new (12, 2, 0);
	self->slots = g_list_append (self->slots, _tmp127_);
	_tmp128_ = slot_new (14, 2, 0);
	self->slots = g_list_append (self->slots, _tmp128_);
	_tmp129_ = slot_new (16, 2, 0);
	self->slots = g_list_append (self->slots, _tmp129_);
	_tmp130_ = slot_new (18, 2, 0);
	self->slots = g_list_append (self->slots, _tmp130_);
	_tmp131_ = slot_new (20, 2, 0);
	self->slots = g_list_append (self->slots, _tmp131_);
	_tmp132_ = slot_new (2, 0, 0);
	self->slots = g_list_append (self->slots, _tmp132_);
	_tmp133_ = slot_new (4, 0, 0);
	self->slots = g_list_append (self->slots, _tmp133_);
	_tmp134_ = slot_new (6, 0, 0);
	self->slots = g_list_append (self->slots, _tmp134_);
	_tmp135_ = slot_new (8, 0, 0);
	self->slots = g_list_append (self->slots, _tmp135_);
	_tmp136_ = slot_new (10, 0, 0);
	self->slots = g_list_append (self->slots, _tmp136_);
	_tmp137_ = slot_new (12, 0, 0);
	self->slots = g_list_append (self->slots, _tmp137_);
	_tmp138_ = slot_new (14, 0, 0);
	self->slots = g_list_append (self->slots, _tmp138_);
	_tmp139_ = slot_new (16, 0, 0);
	self->slots = g_list_append (self->slots, _tmp139_);
	_tmp140_ = slot_new (18, 0, 0);
	self->slots = g_list_append (self->slots, _tmp140_);
	_tmp141_ = slot_new (20, 0, 0);
	self->slots = g_list_append (self->slots, _tmp141_);
	_tmp142_ = slot_new (22, 0, 0);
	self->slots = g_list_append (self->slots, _tmp142_);
	_tmp143_ = slot_new (24, 0, 0);
	self->slots = g_list_append (self->slots, _tmp143_);
	_tmp144_ = slot_new (26, 7, 0);
	self->slots = g_list_append (self->slots, _tmp144_);
	_tmp145_ = slot_new (28, 7, 0);
	self->slots = g_list_append (self->slots, _tmp145_);
	return self;
}

Map*
map_new_builtin (void)
{
	return map_construct_builtin (TYPE_MAP);
}

Map*
map_construct (GType object_type)
{
	Map * self = NULL;
	self = (Map*) g_object_new (object_type, NULL);
	return self;
}

Map*
map_new (void)
{
	return map_construct (TYPE_MAP);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

guint
map_get_width (Map* self)
{
	guint result;
	gint w = 0;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	w = 0;
	_tmp0_ = self->slots;
	{
		GList* slot_collection = NULL;
		GList* slot_it = NULL;
		slot_collection = _tmp0_;
		for (slot_it = slot_collection; slot_it != NULL; slot_it = slot_it->next) {
			Slot* _tmp1_;
			Slot* slot = NULL;
			_tmp1_ = _g_object_ref0 ((Slot*) slot_it->data);
			slot = _tmp1_;
			{
				Slot* _tmp2_;
				_tmp2_ = slot;
				if (_tmp2_->x > w) {
					Slot* _tmp3_;
					_tmp3_ = slot;
					w = _tmp3_->x;
				}
				_g_object_unref0 (slot);
			}
		}
	}
	result = (guint) (w + 2);
	return result;
}

guint
map_get_height (Map* self)
{
	guint result;
	gint h = 0;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	h = 0;
	_tmp0_ = self->slots;
	{
		GList* slot_collection = NULL;
		GList* slot_it = NULL;
		slot_collection = _tmp0_;
		for (slot_it = slot_collection; slot_it != NULL; slot_it = slot_it->next) {
			Slot* _tmp1_;
			Slot* slot = NULL;
			_tmp1_ = _g_object_ref0 ((Slot*) slot_it->data);
			slot = _tmp1_;
			{
				Slot* _tmp2_;
				_tmp2_ = slot;
				if (_tmp2_->y > h) {
					Slot* _tmp3_;
					_tmp3_ = slot;
					h = _tmp3_->y;
				}
				_g_object_unref0 (slot);
			}
		}
	}
	result = (guint) (h + 2);
	return result;
}

static void
map_class_init (MapClass * klass,
                gpointer klass_data)
{
	map_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_map_get_property;
	G_OBJECT_CLASS (klass)->finalize = map_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_WIDTH_PROPERTY, map_properties[MAP_WIDTH_PROPERTY] = g_param_spec_uint ("width", "width", "width", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAP_HEIGHT_PROPERTY, map_properties[MAP_HEIGHT_PROPERTY] = g_param_spec_uint ("height", "height", "height", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
map_instance_init (Map * self,
                   gpointer klass)
{
	self->name = NULL;
	self->score_name = NULL;
	self->slots = NULL;
}

static void
map_finalize (GObject * obj)
{
	Map * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAP, Map);
	_g_free0 (self->name);
	_g_free0 (self->score_name);
	(self->slots == NULL) ? NULL : (self->slots = (_g_list_free__g_object_unref0_ (self->slots), NULL));
	G_OBJECT_CLASS (map_parent_class)->finalize (obj);
}

static GType
map_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Map), 0, (GInstanceInitFunc) map_instance_init, NULL };
	GType map_type_id;
	map_type_id = g_type_register_static (G_TYPE_OBJECT, "Map", &g_define_type_info, 0);
	return map_type_id;
}

GType
map_get_type (void)
{
	static volatile gsize map_type_id__once = 0;
	if (g_once_init_enter (&map_type_id__once)) {
		GType map_type_id;
		map_type_id = map_get_type_once ();
		g_once_init_leave (&map_type_id__once, map_type_id);
	}
	return map_type_id__once;
}

static void
_vala_map_get_property (GObject * object,
                        guint property_id,
                        GValue * value,
                        GParamSpec * pspec)
{
	Map * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAP, Map);
	switch (property_id) {
		case MAP_WIDTH_PROPERTY:
		g_value_set_uint (value, map_get_width (self));
		break;
		case MAP_HEIGHT_PROPERTY:
		g_value_set_uint (value, map_get_height (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
map_loader_get_instance_private (MapLoader* self)
{
	return G_STRUCT_MEMBER_P (self, MapLoader_private_offset);
}

static void
_map_loader_start_element_cb_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                const gchar* element_name,
                                                                gchar** attribute_names,
                                                                gchar** attribute_values,
                                                                gpointer self,
                                                                GError** error)
{
	map_loader_start_element_cb ((MapLoader*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}

static void
_map_loader_end_element_cb_gmarkup_parser_end_element_func (GMarkupParseContext* context,
                                                            const gchar* element_name,
                                                            gpointer self,
                                                            GError** error)
{
	map_loader_end_element_cb ((MapLoader*) self, context, element_name, error);
}

void
map_loader_load (MapLoader* self,
                 const gchar* filename,
                 GError** error)
{
	gchar* data = NULL;
	gsize length = 0UL;
	gchar* _tmp0_ = NULL;
	gsize _tmp1_ = 0UL;
	GMarkupParser parser = {0};
	GMarkupParseContext* parse_context = NULL;
	GMarkupParser _tmp2_;
	GMarkupParseContext* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	g_file_get_contents (filename, &_tmp0_, &_tmp1_, &_inner_error0_);
	_g_free0 (data);
	data = _tmp0_;
	length = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (data);
		return;
	}
	memset (&parser, 0, sizeof (GMarkupParser));
	parser.start_element = _map_loader_start_element_cb_gmarkup_parser_start_element_func;
	parser.end_element = _map_loader_end_element_cb_gmarkup_parser_end_element_func;
	parser.text = NULL;
	parser.passthrough = NULL;
	parser.error = NULL;
	_tmp2_ = parser;
	_tmp3_ = g_markup_parse_context_new (&_tmp2_, 0, self, NULL);
	parse_context = _tmp3_;
	{
		GMarkupParseContext* _tmp4_;
		_tmp4_ = parse_context;
		g_markup_parse_context_parse (_tmp4_, data, (gssize) length, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_MARKUP_ERROR) {
				goto __catch0_g_markup_error;
			}
			_g_markup_parse_context_unref0 (parse_context);
			_g_free0 (data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_markup_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_markup_parse_context_unref0 (parse_context);
		_g_free0 (data);
		return;
	}
	_g_markup_parse_context_unref0 (parse_context);
	_g_free0 (data);
}

static gchar*
map_loader_get_attribute (MapLoader* self,
                          gchar** attribute_names,
                          gint attribute_names_length1,
                          gchar** attribute_values,
                          gint attribute_values_length1,
                          const gchar* name,
                          const gchar* _default_)
{
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = attribute_names[i];
				if (!(_tmp2_ != NULL)) {
					break;
				}
				_tmp3_ = attribute_names[i];
				_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strcmp0 (_tmp5_, name) == 0;
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					const gchar* _tmp7_;
					gchar* _tmp8_;
					_tmp7_ = attribute_values[i];
					_tmp8_ = g_strdup (_tmp7_);
					result = _tmp8_;
					return result;
				}
			}
		}
	}
	_tmp9_ = g_strdup (_default_);
	result = _tmp9_;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

static gdouble
map_loader_get_attribute_d (MapLoader* self,
                            gchar** attribute_names,
                            gint attribute_names_length1,
                            gchar** attribute_values,
                            gint attribute_values_length1,
                            const gchar* name,
                            gdouble _default_)
{
	gchar* a = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (name != NULL, 0.0);
	_tmp0_ = map_loader_get_attribute (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, name, NULL);
	a = _tmp0_;
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		result = _default_;
		_g_free0 (a);
		return result;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = a;
		result = double_parse (_tmp2_);
		_g_free0 (a);
		return result;
	}
}

static void
map_loader_start_element_cb (MapLoader* self,
                             GMarkupParseContext* context,
                             const gchar* element_name,
                             gchar** attribute_names,
                             gint attribute_names_length1,
                             gchar** attribute_values,
                             gint attribute_values_length1,
                             GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (element_name != NULL);
	_tmp0_ = g_utf8_strdown (element_name, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("mahjongg")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("map")))) {
		switch (0) {
			default:
			{
				Map* _tmp4_;
				Map* _tmp5_;
				gchar* _tmp6_;
				Map* _tmp7_;
				gchar* _tmp8_;
				_tmp4_ = map_new ();
				_g_object_unref0 (self->priv->map);
				self->priv->map = _tmp4_;
				_tmp5_ = self->priv->map;
				_tmp6_ = map_loader_get_attribute (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "name", "");
				_g_free0 (_tmp5_->name);
				_tmp5_->name = _tmp6_;
				_tmp7_ = self->priv->map;
				_tmp8_ = map_loader_get_attribute (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "scorename", "");
				_g_free0 (_tmp7_->score_name);
				_tmp7_->score_name = _tmp8_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("layer")))) {
		switch (0) {
			default:
			{
				self->priv->layer_z = (gint) map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "z", 0.0);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("row")))) {
		switch (0) {
			default:
			{
				gint x1 = 0;
				gint x2 = 0;
				gint y = 0;
				gint z = 0;
				x1 = (gint) (map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "left", 0.0) * 2);
				x2 = (gint) (map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "right", 0.0) * 2);
				y = (gint) (map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "y", 0.0) * 2);
				z = (gint) map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "z", (gdouble) self->priv->layer_z);
				{
					gboolean _tmp9_ = FALSE;
					_tmp9_ = TRUE;
					while (TRUE) {
						Map* _tmp10_;
						Slot* _tmp11_;
						if (!_tmp9_) {
							x1 += 2;
						}
						_tmp9_ = FALSE;
						if (!(x1 <= x2)) {
							break;
						}
						_tmp10_ = self->priv->map;
						_tmp11_ = slot_new (x1, y, z);
						_tmp10_->slots = g_list_append (_tmp10_->slots, _tmp11_);
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("column")))) {
		switch (0) {
			default:
			{
				gint x = 0;
				gint y1 = 0;
				gint y2 = 0;
				gint z = 0;
				x = (gint) (map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "x", 0.0) * 2);
				y1 = (gint) (map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "top", 0.0) * 2);
				y2 = (gint) (map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "bottom", 0.0) * 2);
				z = (gint) map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "z", (gdouble) self->priv->layer_z);
				{
					gboolean _tmp12_ = FALSE;
					_tmp12_ = TRUE;
					while (TRUE) {
						Map* _tmp13_;
						Slot* _tmp14_;
						if (!_tmp12_) {
							y1 += 2;
						}
						_tmp12_ = FALSE;
						if (!(y1 <= y2)) {
							break;
						}
						_tmp13_ = self->priv->map;
						_tmp14_ = slot_new (x, y1, z);
						_tmp13_->slots = g_list_append (_tmp13_->slots, _tmp14_);
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("block")))) {
		switch (0) {
			default:
			{
				gint x1 = 0;
				gint x2 = 0;
				gint y1 = 0;
				gint y2 = 0;
				gint z = 0;
				x1 = (gint) (map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "left", 0.0) * 2);
				x2 = (gint) (map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "right", 0.0) * 2);
				y1 = (gint) (map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "top", 0.0) * 2);
				y2 = (gint) (map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "bottom", 0.0) * 2);
				z = (gint) map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "z", (gdouble) self->priv->layer_z);
				{
					gboolean _tmp15_ = FALSE;
					_tmp15_ = TRUE;
					while (TRUE) {
						if (!_tmp15_) {
							x1 += 2;
						}
						_tmp15_ = FALSE;
						if (!(x1 <= x2)) {
							break;
						}
						{
							gint y = 0;
							y = y1;
							{
								gboolean _tmp16_ = FALSE;
								_tmp16_ = TRUE;
								while (TRUE) {
									Map* _tmp17_;
									Slot* _tmp18_;
									if (!_tmp16_) {
										y += 2;
									}
									_tmp16_ = FALSE;
									if (!(y <= y2)) {
										break;
									}
									_tmp17_ = self->priv->map;
									_tmp18_ = slot_new (x1, y, z);
									_tmp17_->slots = g_list_append (_tmp17_->slots, _tmp18_);
								}
							}
						}
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("tile")))) {
		switch (0) {
			default:
			{
				gint x = 0;
				gint y = 0;
				gint z = 0;
				Map* _tmp19_;
				Slot* _tmp20_;
				x = (gint) (map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "x", 0.0) * 2);
				y = (gint) (map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "y", 0.0) * 2);
				z = (gint) map_loader_get_attribute_d (self, attribute_names, (gint) attribute_names_length1, attribute_values, (gint) attribute_values_length1, "z", (gdouble) self->priv->layer_z);
				_tmp19_ = self->priv->map;
				_tmp20_ = slot_new (x, y, z);
				_tmp19_->slots = g_list_append (_tmp19_->slots, _tmp20_);
				break;
			}
		}
	}
}

static void
map_loader_end_element_cb (MapLoader* self,
                           GMarkupParseContext* context,
                           const gchar* element_name,
                           GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (element_name != NULL);
	_tmp0_ = g_utf8_strdown (element_name, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	g_free (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("map")))) {
		switch (0) {
			default:
			{
				guint n_slots = 0U;
				Map* _tmp4_;
				GList* _tmp5_;
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				Map* _tmp9_;
				const gchar* _tmp10_;
				_tmp4_ = self->priv->map;
				_tmp5_ = _tmp4_->slots;
				n_slots = g_list_length (_tmp5_);
				_tmp9_ = self->priv->map;
				_tmp10_ = _tmp9_->name;
				if (_tmp10_ != NULL) {
					Map* _tmp11_;
					const gchar* _tmp12_;
					_tmp11_ = self->priv->map;
					_tmp12_ = _tmp11_->score_name;
					_tmp8_ = _tmp12_ != NULL;
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					_tmp7_ = n_slots <= ((guint) 144);
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = (n_slots % 2) == ((guint) 0);
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					Map* _tmp13_;
					Map* _tmp14_;
					_tmp13_ = self->priv->map;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					self->maps = g_list_append (self->maps, _tmp14_);
				} else {
					g_warning ("map.vala:359: Invalid map");
				}
				_g_object_unref0 (self->priv->map);
				self->priv->map = NULL;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("layer")))) {
		switch (0) {
			default:
			{
				self->priv->layer_z = 0;
				break;
			}
		}
	}
}

MapLoader*
map_loader_construct (GType object_type)
{
	MapLoader * self = NULL;
	self = (MapLoader*) g_object_new (object_type, NULL);
	return self;
}

MapLoader*
map_loader_new (void)
{
	return map_loader_construct (TYPE_MAP_LOADER);
}

static void
map_loader_class_init (MapLoaderClass * klass,
                       gpointer klass_data)
{
	map_loader_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MapLoader_private_offset);
	G_OBJECT_CLASS (klass)->finalize = map_loader_finalize;
}

static void
map_loader_instance_init (MapLoader * self,
                          gpointer klass)
{
	self->priv = map_loader_get_instance_private (self);
	self->maps = NULL;
	self->priv->layer_z = 0;
}

static void
map_loader_finalize (GObject * obj)
{
	MapLoader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAP_LOADER, MapLoader);
	(self->maps == NULL) ? NULL : (self->maps = (_g_list_free__g_object_unref0_ (self->maps), NULL));
	_g_object_unref0 (self->priv->map);
	G_OBJECT_CLASS (map_loader_parent_class)->finalize (obj);
}

static GType
map_loader_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MapLoaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) map_loader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MapLoader), 0, (GInstanceInitFunc) map_loader_instance_init, NULL };
	GType map_loader_type_id;
	map_loader_type_id = g_type_register_static (G_TYPE_OBJECT, "MapLoader", &g_define_type_info, 0);
	MapLoader_private_offset = g_type_add_instance_private (map_loader_type_id, sizeof (MapLoaderPrivate));
	return map_loader_type_id;
}

GType
map_loader_get_type (void)
{
	static volatile gsize map_loader_type_id__once = 0;
	if (g_once_init_enter (&map_loader_type_id__once)) {
		GType map_loader_type_id;
		map_loader_type_id = map_loader_get_type_once ();
		g_once_init_leave (&map_loader_type_id__once, map_loader_type_id);
	}
	return map_loader_type_id__once;
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

