/* history.c generated by valac 0.56.16, the Vala compiler
 * generated from history.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;
typedef struct _HistoryPrivate HistoryPrivate;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
enum  {
	HISTORY_0_PROPERTY,
	HISTORY_NUM_PROPERTIES
};
static GParamSpec* history_properties[HISTORY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _HistoryEntryPrivate HistoryEntryPrivate;
#define _g_time_zone_unref0(var) ((var == NULL) ? NULL : (var = (g_time_zone_unref (var), NULL)))
enum  {
	HISTORY_ENTRY_ADDED_SIGNAL,
	HISTORY_NUM_SIGNALS
};
static guint history_signals[HISTORY_NUM_SIGNALS] = {0};
enum  {
	HISTORY_ENTRY_0_PROPERTY,
	HISTORY_ENTRY_NUM_PROPERTIES
};
static GParamSpec* history_entry_properties[HISTORY_ENTRY_NUM_PROPERTIES];

struct _History {
	GObject parent_instance;
	HistoryPrivate * priv;
	gchar* filename;
	GList* entries;
};

struct _HistoryClass {
	GObjectClass parent_class;
};

struct _HistoryEntry {
	GObject parent_instance;
	HistoryEntryPrivate * priv;
	GDateTime* date;
	gchar* name;
	guint duration;
};

struct _HistoryEntryClass {
	GObjectClass parent_class;
};

static gpointer history_parent_class = NULL;
static gpointer history_entry_parent_class = NULL;

VALA_EXTERN GType history_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (History, g_object_unref)
VALA_EXTERN GType history_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryEntry, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN History* history_new (const gchar* filename);
VALA_EXTERN History* history_construct (GType object_type,
                            const gchar* filename);
VALA_EXTERN void history_add (History* self,
                  HistoryEntry* entry);
VALA_EXTERN void history_load (History* self);
static GDateTime* history_parse_date (History* self,
                               const gchar* date);
VALA_EXTERN HistoryEntry* history_entry_new (GDateTime* date,
                                 const gchar* name,
                                 guint duration);
VALA_EXTERN HistoryEntry* history_entry_construct (GType object_type,
                                       GDateTime* date,
                                       const gchar* name,
                                       guint duration);
VALA_EXTERN void history_save (History* self);
static void history_finalize (GObject * obj);
static GType history_get_type_once (void);
static void history_entry_finalize (GObject * obj);
static GType history_entry_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

History*
history_construct (GType object_type,
                   const gchar* filename)
{
	History * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (filename != NULL, NULL);
	self = (History*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (filename);
	_g_free0 (self->filename);
	self->filename = _tmp0_;
	(self->entries == NULL) ? NULL : (self->entries = (_g_list_free__g_object_unref0_ (self->entries), NULL));
	self->entries = NULL;
	return self;
}

History*
history_new (const gchar* filename)
{
	return history_construct (TYPE_HISTORY, filename);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
history_add (History* self,
             HistoryEntry* entry)
{
	HistoryEntry* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry != NULL);
	_tmp0_ = _g_object_ref0 (entry);
	self->entries = g_list_append (self->entries, _tmp0_);
	g_signal_emit (self, history_signals[HISTORY_ENTRY_ADDED_SIGNAL], 0, entry);
}

void
history_load (History* self)
{
	gchar* contents = NULL;
	gchar* _tmp0_;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	(self->entries == NULL) ? NULL : (self->entries = (_g_list_free__g_object_unref0_ (self->entries), NULL));
	self->entries = NULL;
	_tmp0_ = g_strdup ("");
	contents = _tmp0_;
	{
		const gchar* _tmp1_;
		gchar* _tmp2_ = NULL;
		_tmp1_ = self->filename;
		g_file_get_contents (_tmp1_, &_tmp2_, NULL, &_inner_error0_);
		_g_free0 (contents);
		contents = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		if (!g_error_matches (_tmp3_, G_FILE_ERROR, G_FILE_ERROR_NOENT)) {
			GError* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = e;
			_tmp5_ = _tmp4_->message;
			g_warning ("history.vala:42: Failed to load history: %s", _tmp5_);
		}
		_g_error_free0 (e);
		_g_free0 (contents);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp6_ = contents;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp8_;
		line_collection_length1 = _vala_array_length (_tmp7_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp9_;
			gchar* line = NULL;
			_tmp9_ = g_strdup (line_collection[line_it]);
			line = _tmp9_;
			{
				gchar** tokens = NULL;
				const gchar* _tmp10_;
				gchar** _tmp11_;
				gchar** _tmp12_;
				gint tokens_length1;
				gint _tokens_size_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				GDateTime* date = NULL;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				GDateTime* _tmp16_;
				GDateTime* _tmp17_;
				gchar* name = NULL;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gint duration = 0;
				gchar** _tmp21_;
				gint _tmp21__length1;
				const gchar* _tmp22_;
				GDateTime* _tmp23_;
				const gchar* _tmp24_;
				HistoryEntry* _tmp25_;
				HistoryEntry* _tmp26_;
				_tmp10_ = line;
				_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, " ", 0);
				tokens = _tmp12_;
				tokens_length1 = _vala_array_length (_tmp11_);
				_tokens_size_ = tokens_length1;
				_tmp13_ = tokens;
				_tmp13__length1 = tokens_length1;
				if (_tmp13__length1 != 3) {
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp14_ = tokens;
				_tmp14__length1 = tokens_length1;
				_tmp15_ = _tmp14_[0];
				_tmp16_ = history_parse_date (self, _tmp15_);
				date = _tmp16_;
				_tmp17_ = date;
				if (_tmp17_ == NULL) {
					_g_date_time_unref0 (date);
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp18_ = tokens;
				_tmp18__length1 = tokens_length1;
				_tmp19_ = _tmp18_[1];
				_tmp20_ = g_strdup (_tmp19_);
				name = _tmp20_;
				_tmp21_ = tokens;
				_tmp21__length1 = tokens_length1;
				_tmp22_ = _tmp21_[2];
				duration = atoi (_tmp22_);
				_tmp23_ = date;
				_tmp24_ = name;
				_tmp25_ = history_entry_new (_tmp23_, _tmp24_, (guint) duration);
				_tmp26_ = _tmp25_;
				history_add (self, _tmp26_);
				_g_object_unref0 (_tmp26_);
				_g_free0 (name);
				_g_date_time_unref0 (date);
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (contents);
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

void
history_save (History* self)
{
	gchar* contents = NULL;
	gchar* _tmp0_;
	GList* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	contents = _tmp0_;
	_tmp1_ = self->entries;
	{
		GList* entry_collection = NULL;
		GList* entry_it = NULL;
		entry_collection = _tmp1_;
		for (entry_it = entry_collection; entry_it != NULL; entry_it = entry_it->next) {
			HistoryEntry* _tmp2_;
			HistoryEntry* entry = NULL;
			_tmp2_ = _g_object_ref0 ((HistoryEntry*) entry_it->data);
			entry = _tmp2_;
			{
				gchar* line = NULL;
				HistoryEntry* _tmp3_;
				GDateTime* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				HistoryEntry* _tmp7_;
				const gchar* _tmp8_;
				HistoryEntry* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp3_ = entry;
				_tmp4_ = _tmp3_->date;
				_tmp5_ = g_date_time_to_string (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = entry;
				_tmp8_ = _tmp7_->name;
				_tmp9_ = entry;
				_tmp10_ = g_strdup_printf ("%s %s %u\n", _tmp6_, _tmp8_, _tmp9_->duration);
				_tmp11_ = _tmp10_;
				_g_free0 (_tmp6_);
				line = _tmp11_;
				_tmp12_ = contents;
				_tmp13_ = line;
				_tmp14_ = g_strconcat (_tmp12_, _tmp13_, NULL);
				_g_free0 (contents);
				contents = _tmp14_;
				_g_free0 (line);
				_g_object_unref0 (entry);
			}
		}
	}
	{
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp15_ = self->filename;
		_tmp16_ = g_path_get_dirname (_tmp15_);
		_tmp17_ = _tmp16_;
		g_mkdir_with_parents (_tmp17_, 0775);
		_g_free0 (_tmp17_);
		_tmp18_ = self->filename;
		_tmp19_ = contents;
		g_file_set_contents (_tmp18_, _tmp19_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("history.vala:79: Failed to save history: %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (contents);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static GTimeZone*
vala_g_time_zone_new_identifier (const gchar* identifier,
                                 GError** error)
{
	GTimeZone* self;
	GError* _inner_error0_ = NULL;
	self = (GTimeZone*) g_time_zone_new_identifier (identifier);
	if (((GTimeZone*) self) == NULL) {
		GError* _tmp0_;
		_tmp0_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_ILLEGAL_SEQUENCE, "Invalid identifier argument");
		_inner_error0_ = _tmp0_;
		g_propagate_error (error, _inner_error0_);
		_g_time_zone_unref0 (self);
		return NULL;
	}
	return self;
}

static GDateTime*
history_parse_date (History* self,
                    const gchar* date)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp5_;
	gint _tmp6_;
	gint year = 0;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gint _tmp9_;
	gint month = 0;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gint _tmp12_;
	gint day = 0;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint _tmp15_;
	gint hour = 0;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gint _tmp18_;
	gint minute = 0;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gint _tmp21_;
	gint seconds = 0;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gint _tmp24_;
	gchar* timezone = NULL;
	gchar* _tmp25_;
	GError* _inner_error0_ = NULL;
	GDateTime* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (date != NULL, NULL);
	_tmp5_ = strlen (date);
	_tmp6_ = _tmp5_;
	if (_tmp6_ < 19) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = string_get (date, (glong) 4) != '-';
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = string_get (date, (glong) 7) != '-';
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = string_get (date, (glong) 10) != 'T';
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = string_get (date, (glong) 13) != ':';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = string_get (date, (glong) 16) != ':';
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp7_ = string_substring (date, (glong) 0, (glong) 4);
	_tmp8_ = _tmp7_;
	_tmp9_ = atoi (_tmp8_);
	_g_free0 (_tmp8_);
	year = _tmp9_;
	_tmp10_ = string_substring (date, (glong) 5, (glong) 2);
	_tmp11_ = _tmp10_;
	_tmp12_ = atoi (_tmp11_);
	_g_free0 (_tmp11_);
	month = _tmp12_;
	_tmp13_ = string_substring (date, (glong) 8, (glong) 2);
	_tmp14_ = _tmp13_;
	_tmp15_ = atoi (_tmp14_);
	_g_free0 (_tmp14_);
	day = _tmp15_;
	_tmp16_ = string_substring (date, (glong) 11, (glong) 2);
	_tmp17_ = _tmp16_;
	_tmp18_ = atoi (_tmp17_);
	_g_free0 (_tmp17_);
	hour = _tmp18_;
	_tmp19_ = string_substring (date, (glong) 14, (glong) 2);
	_tmp20_ = _tmp19_;
	_tmp21_ = atoi (_tmp20_);
	_g_free0 (_tmp20_);
	minute = _tmp21_;
	_tmp22_ = string_substring (date, (glong) 17, (glong) 2);
	_tmp23_ = _tmp22_;
	_tmp24_ = atoi (_tmp23_);
	_g_free0 (_tmp23_);
	seconds = _tmp24_;
	_tmp25_ = string_substring (date, (glong) 19, (glong) -1);
	timezone = _tmp25_;
	{
		GTimeZone* tz = NULL;
		const gchar* _tmp26_;
		GTimeZone* _tmp27_;
		GTimeZone* _tmp28_;
		GDateTime* _tmp29_;
		_tmp26_ = timezone;
		_tmp27_ = vala_g_time_zone_new_identifier (_tmp26_, &_inner_error0_);
		tz = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp28_ = tz;
		_tmp29_ = g_date_time_new (_tmp28_, year, month, day, hour, minute, (gdouble) seconds);
		result = _tmp29_;
		_g_time_zone_unref0 (tz);
		_g_free0 (timezone);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = NULL;
		_g_free0 (timezone);
		return result;
	}
	__finally0:
	_g_free0 (timezone);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
history_class_init (HistoryClass * klass,
                    gpointer klass_data)
{
	history_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = history_finalize;
	history_signals[HISTORY_ENTRY_ADDED_SIGNAL] = g_signal_new ("entry-added", TYPE_HISTORY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_HISTORY_ENTRY);
}

static void
history_instance_init (History * self,
                       gpointer klass)
{
}

static void
history_finalize (GObject * obj)
{
	History * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY, History);
	_g_free0 (self->filename);
	(self->entries == NULL) ? NULL : (self->entries = (_g_list_free__g_object_unref0_ (self->entries), NULL));
	G_OBJECT_CLASS (history_parent_class)->finalize (obj);
}

static GType
history_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (HistoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (History), 0, (GInstanceInitFunc) history_instance_init, NULL };
	GType history_type_id;
	history_type_id = g_type_register_static (G_TYPE_OBJECT, "History", &g_define_type_info, 0);
	return history_type_id;
}

GType
history_get_type (void)
{
	static volatile gsize history_type_id__once = 0;
	if (g_once_init_enter (&history_type_id__once)) {
		GType history_type_id;
		history_type_id = history_get_type_once ();
		g_once_init_leave (&history_type_id__once, history_type_id);
	}
	return history_type_id__once;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

HistoryEntry*
history_entry_construct (GType object_type,
                         GDateTime* date,
                         const gchar* name,
                         guint duration)
{
	HistoryEntry * self = NULL;
	GDateTime* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (date != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (HistoryEntry*) g_object_new (object_type, NULL);
	_tmp0_ = _g_date_time_ref0 (date);
	_g_date_time_unref0 (self->date);
	self->date = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp1_;
	self->duration = duration;
	return self;
}

HistoryEntry*
history_entry_new (GDateTime* date,
                   const gchar* name,
                   guint duration)
{
	return history_entry_construct (TYPE_HISTORY_ENTRY, date, name, duration);
}

static void
history_entry_class_init (HistoryEntryClass * klass,
                          gpointer klass_data)
{
	history_entry_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = history_entry_finalize;
}

static void
history_entry_instance_init (HistoryEntry * self,
                             gpointer klass)
{
}

static void
history_entry_finalize (GObject * obj)
{
	HistoryEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY_ENTRY, HistoryEntry);
	_g_date_time_unref0 (self->date);
	_g_free0 (self->name);
	G_OBJECT_CLASS (history_entry_parent_class)->finalize (obj);
}

static GType
history_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (HistoryEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryEntry), 0, (GInstanceInitFunc) history_entry_instance_init, NULL };
	GType history_entry_type_id;
	history_entry_type_id = g_type_register_static (G_TYPE_OBJECT, "HistoryEntry", &g_define_type_info, 0);
	return history_entry_type_id;
}

GType
history_entry_get_type (void)
{
	static volatile gsize history_entry_type_id__once = 0;
	if (g_once_init_enter (&history_entry_type_id__once)) {
		GType history_entry_type_id;
		history_entry_type_id = history_entry_get_type_once ();
		g_once_init_leave (&history_entry_type_id__once, history_entry_type_id);
	}
	return history_entry_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

