/* gnome-mahjongg.c generated by valac 0.56.16, the Vala compiler
 * generated from gnome-mahjongg.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <locale.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MAHJONGG (mahjongg_get_type ())
#define MAHJONGG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAHJONGG, Mahjongg))
#define MAHJONGG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAHJONGG, MahjonggClass))
#define IS_MAHJONGG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAHJONGG))
#define IS_MAHJONGG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAHJONGG))
#define MAHJONGG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAHJONGG, MahjonggClass))

typedef struct _Mahjongg Mahjongg;
typedef struct _MahjonggClass MahjonggClass;
typedef struct _MahjonggPrivate MahjonggPrivate;

#define TYPE_HISTORY (history_get_type ())
#define HISTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY, History))
#define HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY, HistoryClass))
#define IS_HISTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY))
#define IS_HISTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY))
#define HISTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY, HistoryClass))

typedef struct _History History;
typedef struct _HistoryClass HistoryClass;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;

#define TYPE_MAHJONGG_WINDOW (mahjongg_window_get_type ())
#define MAHJONGG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAHJONGG_WINDOW, MahjonggWindow))
#define MAHJONGG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAHJONGG_WINDOW, MahjonggWindowClass))
#define IS_MAHJONGG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAHJONGG_WINDOW))
#define IS_MAHJONGG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAHJONGG_WINDOW))
#define MAHJONGG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAHJONGG_WINDOW, MahjonggWindowClass))

typedef struct _MahjonggWindow MahjonggWindow;
typedef struct _MahjonggWindowClass MahjonggWindowClass;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
enum  {
	MAHJONGG_0_PROPERTY,
	MAHJONGG_NUM_PROPERTIES
};
static GParamSpec* mahjongg_properties[MAHJONGG_NUM_PROPERTIES];
typedef enum  {
	MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO,
	MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE,
	MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART,
	MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME
} MahjonggNoMovesDialogResponse;

#define MAHJONGG_TYPE_NO_MOVES_DIALOG_RESPONSE (mahjongg_no_moves_dialog_response_get_type ())
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _Block1Data Block1Data;

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _MapPrivate MapPrivate;

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block2Data Block2Data;

#define TYPE_SCORE_DIALOG (score_dialog_get_type ())
#define SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCORE_DIALOG, ScoreDialog))
#define SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCORE_DIALOG, ScoreDialogClass))
#define IS_SCORE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCORE_DIALOG))
#define IS_SCORE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCORE_DIALOG))
#define SCORE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCORE_DIALOG, ScoreDialogClass))

typedef struct _ScoreDialog ScoreDialog;
typedef struct _ScoreDialogClass ScoreDialogClass;
typedef struct _Block3Data Block3Data;

#define TYPE_PREFERENCES_WINDOW (preferences_window_get_type ())
#define PREFERENCES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_WINDOW, PreferencesWindow))
#define PREFERENCES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_WINDOW, PreferencesWindowClass))
#define IS_PREFERENCES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_WINDOW))
#define IS_PREFERENCES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_WINDOW))
#define PREFERENCES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_WINDOW, PreferencesWindowClass))

typedef struct _PreferencesWindow PreferencesWindow;
typedef struct _PreferencesWindowClass PreferencesWindowClass;
typedef struct _GameViewPrivate GameViewPrivate;
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))

#define TYPE_MATCH (match_get_type ())
#define MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATCH, Match))
#define MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATCH, MatchClass))
#define IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATCH))
#define IS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATCH))
#define MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATCH, MatchClass))

typedef struct _Match Match;
typedef struct _MatchClass MatchClass;
typedef struct _MatchPrivate MatchPrivate;

#define TYPE_MAP_LOADER (map_loader_get_type ())
#define MAP_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP_LOADER, MapLoader))
#define MAP_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP_LOADER, MapLoaderClass))
#define IS_MAP_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP_LOADER))
#define IS_MAP_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP_LOADER))
#define MAP_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP_LOADER, MapLoaderClass))

typedef struct _MapLoader MapLoader;
typedef struct _MapLoaderClass MapLoaderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _MapLoaderPrivate MapLoaderPrivate;

struct _Mahjongg {
	AdwApplication parent_instance;
	MahjonggPrivate * priv;
};

struct _MahjonggClass {
	AdwApplicationClass parent_class;
};

struct _MahjonggPrivate {
	GSettings* settings;
	History* history;
	GList* maps;
	MahjonggWindow* window;
	GameView* game_view;
	GtkGestureClick* view_click_controller;
};

struct _Block1Data {
	int _ref_count_;
	Mahjongg* self;
	GtkMessageDialog* dialog;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Map* map;
	GList* tiles;
	Tile* hint_tiles[2];
	gint move_number;
	guint hint_blink_counter;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _Map {
	GObject parent_instance;
	MapPrivate * priv;
	gchar* name;
	gchar* score_name;
	GList* slots;
};

struct _MapClass {
	GObjectClass parent_class;
};

struct _Block2Data {
	int _ref_count_;
	Mahjongg* self;
	GtkMessageDialog* dialog;
};

struct _Block3Data {
	int _ref_count_;
	Mahjongg* self;
	ScoreDialog* dialog;
};

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
	GdkRGBA background_color;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _Match {
	GObject parent_instance;
	MatchPrivate * priv;
	Tile* tile0;
	Tile* tile1;
};

struct _MatchClass {
	GObjectClass parent_class;
};

struct _MapLoader {
	GObject parent_instance;
	MapLoaderPrivate * priv;
	GList* maps;
};

struct _MapLoaderClass {
	GObjectClass parent_class;
};

static gint Mahjongg_private_offset;
static gpointer mahjongg_parent_class = NULL;

VALA_EXTERN GType mahjongg_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Mahjongg, g_object_unref)
VALA_EXTERN GType history_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (History, g_object_unref)
VALA_EXTERN GType map_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Map, g_object_unref)
VALA_EXTERN GType mahjongg_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MahjonggWindow, g_object_unref)
VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
static GType mahjongg_no_moves_dialog_response_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void mahjongg_new_game_cb (Mahjongg* self);
static void _mahjongg_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self);
static void mahjongg_undo_cb (Mahjongg* self);
static void _mahjongg_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void mahjongg_redo_cb (Mahjongg* self);
static void _mahjongg_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void mahjongg_hint_cb (Mahjongg* self);
static void _mahjongg_hint_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void mahjongg_pause_cb (Mahjongg* self);
static void _mahjongg_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void mahjongg_restart_game_cb (Mahjongg* self);
static void _mahjongg_restart_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self);
static void mahjongg_scores_cb (Mahjongg* self);
static void _mahjongg_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void mahjongg_preferences_cb (Mahjongg* self);
static void _mahjongg_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void mahjongg_help_cb (Mahjongg* self);
static void _mahjongg_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void mahjongg_about_cb (Mahjongg* self);
static void _mahjongg_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self);
static void mahjongg_quit_cb (Mahjongg* self);
static void _mahjongg_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                         GVariant* parameter,
                                                         gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN Mahjongg* mahjongg_new (void);
VALA_EXTERN Mahjongg* mahjongg_construct (GType object_type);
static void mahjongg_real_startup (GApplication* base);
static void mahjongg_load_maps (Mahjongg* self);
VALA_EXTERN History* history_new (const gchar* filename);
VALA_EXTERN History* history_construct (GType object_type,
                            const gchar* filename);
VALA_EXTERN void history_load (History* self);
VALA_EXTERN GameView* game_view_new (void);
VALA_EXTERN GameView* game_view_construct (GType object_type);
static inline void mahjongg_on_click (Mahjongg* self,
                        GtkGestureClick* _view_click_controller,
                        gint n_press,
                        gdouble event_x,
                        gdouble event_y);
static void _mahjongg_on_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                   gint n_press,
                                                   gdouble x,
                                                   gdouble y,
                                                   gpointer self);
VALA_EXTERN MahjonggWindow* mahjongg_window_new (GtkApplication* application,
                                     GameView* game_view);
VALA_EXTERN MahjonggWindow* mahjongg_window_construct (GType object_type,
                                           GtkApplication* application,
                                           GameView* game_view);
static gint mahjongg_real_handle_local_options (GApplication* base,
                                         GVariantDict* options);
static void mahjongg_real_activate (GApplication* base);
static void mahjongg_conf_value_changed_cb (Mahjongg* self,
                                     GSettings* settings,
                                     const gchar* key);
static void _mahjongg_conf_value_changed_cb_g_settings_changed (GSettings* _sender,
                                                         const gchar* key,
                                                         gpointer self);
static void mahjongg_new_game (Mahjongg* self);
static void mahjongg_tick_cb (Mahjongg* self);
static void mahjongg_update_ui (Mahjongg* self);
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN Game* game_view_get_game (GameView* self);
VALA_EXTERN gboolean game_get_started (Game* self);
VALA_EXTERN gboolean game_get_paused (Game* self);
VALA_EXTERN guint game_get_moves_left (Game* self);
VALA_EXTERN gboolean game_get_can_undo (Game* self);
VALA_EXTERN gboolean game_get_can_redo (Game* self);
VALA_EXTERN void game_view_set_theme (GameView* self,
                          const gchar* value);
VALA_EXTERN void game_view_set_background (GameView* self,
                               const gchar* colour);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ______lambda10_ (Block1Data* _data1_,
                      gint resp_id);
static void _______lambda10__gtk_dialog_response (GtkDialog* _sender,
                                           gint response_id,
                                           gpointer self);
static void mahjongg_moved_cb (Mahjongg* self);
VALA_EXTERN gboolean game_get_complete (Game* self);
VALA_EXTERN gdouble game_get_elapsed (Game* self);
VALA_EXTERN GType history_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryEntry, g_object_unref)
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tile, g_object_unref)
VALA_EXTERN GType slot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Slot, g_object_unref)
VALA_EXTERN HistoryEntry* history_entry_new (GDateTime* date,
                                 const gchar* name,
                                 guint duration);
VALA_EXTERN HistoryEntry* history_entry_construct (GType object_type,
                                       GDateTime* date,
                                       const gchar* name,
                                       guint duration);
VALA_EXTERN void history_add (History* self,
                  HistoryEntry* entry);
VALA_EXTERN void history_save (History* self);
static void mahjongg_show_scores (Mahjongg* self,
                           HistoryEntry* selected_entry,
                           gboolean show_quit);
VALA_EXTERN gboolean game_get_can_move (Game* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN gint game_number_of_movable_tiles (Game* self);
static void ____lambda6_ (Block2Data* _data2_,
                   gint resp_id);
static void mahjongg_shuffle_cb (Mahjongg* self);
static void mahjongg_restart_game (Mahjongg* self);
static void _____lambda6__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
VALA_EXTERN GType score_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ScoreDialog, g_object_unref)
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN ScoreDialog* score_dialog_new (History* history,
                               HistoryEntry* selected_entry,
                               gboolean show_quit,
                               GList* maps);
VALA_EXTERN ScoreDialog* score_dialog_construct (GType object_type,
                                     History* history,
                                     HistoryEntry* selected_entry,
                                     gboolean show_quit,
                                     GList* maps);
static void __lambda5_ (Block3Data* _data3_,
                 gint resp_id);
static void ___lambda5__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self);
VALA_EXTERN GType preferences_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PreferencesWindow, g_object_unref)
VALA_EXTERN PreferencesWindow* preferences_window_new (GSettings* settings);
VALA_EXTERN PreferencesWindow* preferences_window_construct (GType object_type,
                                                 GSettings* settings);
VALA_EXTERN void preferences_window_populate_themes (PreferencesWindow* self,
                                         GList* themes);
static GList* mahjongg_load_themes (Mahjongg* self);
static void _g_free0_ (gpointer var);
static inline void _g_list_free__g_free0_ (GList* self);
VALA_EXTERN void preferences_window_populate_layouts (PreferencesWindow* self,
                                          GList* layouts);
VALA_EXTERN void preferences_window_populate_background (PreferencesWindow* self,
                                             GdkRGBA* background_color);
VALA_EXTERN GType match_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Match, g_object_unref)
VALA_EXTERN GList* game_find_matches (Game* self,
                          Tile* tile);
VALA_EXTERN Tile* game_get_selected_tile (Game* self);
VALA_EXTERN void game_set_hint (Game* self,
                    Tile* tile0,
                    Tile* tile1);
VALA_EXTERN void game_shuffle_remaining (Game* self,
                             gboolean redraw);
VALA_EXTERN void game_set_paused (Game* self,
                      gboolean value);
VALA_EXTERN void game_set_selected_tile (Game* self,
                             Tile* value);
VALA_EXTERN void mahjongg_window_pause (MahjonggWindow* self);
VALA_EXTERN void mahjongg_window_unpause (MahjonggWindow* self);
VALA_EXTERN void game_redo (Game* self);
VALA_EXTERN void game_undo (Game* self);
VALA_EXTERN void game_reset (Game* self);
VALA_EXTERN Game* game_new (Map* map);
VALA_EXTERN Game* game_construct (GType object_type,
                      Map* map);
VALA_EXTERN void game_view_set_game (GameView* self,
                         Game* value);
static void _mahjongg_moved_cb_game_moved (Game* _sender,
                                    gpointer self);
static void _mahjongg_tick_cb_game_tick (Game* _sender,
                                  gpointer self);
VALA_EXTERN void mahjongg_window_set_map_title (MahjonggWindow* self,
                                    GameView* game_view);
VALA_EXTERN void mahjongg_window_set_subtitle (MahjonggWindow* self,
                                   GameView* game_view,
                                   const gchar* clock);
VALA_EXTERN Map* map_new_builtin (void);
VALA_EXTERN Map* map_construct_builtin (GType object_type);
VALA_EXTERN GType map_loader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MapLoader, g_object_unref)
VALA_EXTERN MapLoader* map_loader_new (void);
VALA_EXTERN MapLoader* map_loader_construct (GType object_type);
VALA_EXTERN void map_loader_load (MapLoader* self,
                      const gchar* filename,
                      GError** error);
static gint mahjongg_main (gchar** args,
                    gint args_length1);
static void mahjongg_finalize (GObject * obj);
static GType mahjongg_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GOptionEntry MAHJONGG_option_entries[2] = {{"version", 'v', (gint) 0, G_OPTION_ARG_NONE, NULL, N_ ("Print release version and exit"), NULL}, {NULL}};
static const GActionEntry MAHJONGG_action_entries[11] = {{"new-game", _mahjongg_new_game_cb_gsimple_action_activate_callback}, {"undo", _mahjongg_undo_cb_gsimple_action_activate_callback}, {"redo", _mahjongg_redo_cb_gsimple_action_activate_callback}, {"hint", _mahjongg_hint_cb_gsimple_action_activate_callback}, {"pause", _mahjongg_pause_cb_gsimple_action_activate_callback}, {"restart-game", _mahjongg_restart_game_cb_gsimple_action_activate_callback}, {"scores", _mahjongg_scores_cb_gsimple_action_activate_callback}, {"preferences", _mahjongg_preferences_cb_gsimple_action_activate_callback}, {"help", _mahjongg_help_cb_gsimple_action_activate_callback}, {"about", _mahjongg_about_cb_gsimple_action_activate_callback}, {"quit", _mahjongg_quit_cb_gsimple_action_activate_callback}};

static inline gpointer
mahjongg_get_instance_private (Mahjongg* self)
{
	return G_STRUCT_MEMBER_P (self, Mahjongg_private_offset);
}

static GType
mahjongg_no_moves_dialog_response_get_type_once (void)
{
	static const GEnumValue values[] = {{MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO, "MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO", "undo"}, {MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE, "MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE", "shuffle"}, {MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART, "MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART", "restart"}, {MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME, "MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME", "new-game"}, {0, NULL, NULL}};
	GType mahjongg_no_moves_dialog_response_type_id;
	mahjongg_no_moves_dialog_response_type_id = g_enum_register_static ("MahjonggNoMovesDialogResponse", values);
	return mahjongg_no_moves_dialog_response_type_id;
}

static GType
mahjongg_no_moves_dialog_response_get_type (void)
{
	static volatile gsize mahjongg_no_moves_dialog_response_type_id__once = 0;
	if (g_once_init_enter (&mahjongg_no_moves_dialog_response_type_id__once)) {
		GType mahjongg_no_moves_dialog_response_type_id;
		mahjongg_no_moves_dialog_response_type_id = mahjongg_no_moves_dialog_response_get_type_once ();
		g_once_init_leave (&mahjongg_no_moves_dialog_response_type_id__once, mahjongg_no_moves_dialog_response_type_id);
	}
	return mahjongg_no_moves_dialog_response_type_id__once;
}

static void
_mahjongg_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                        GVariant* parameter,
                                                        gpointer self)
{
	mahjongg_new_game_cb ((Mahjongg*) self);
}

static void
_mahjongg_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	mahjongg_undo_cb ((Mahjongg*) self);
}

static void
_mahjongg_redo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	mahjongg_redo_cb ((Mahjongg*) self);
}

static void
_mahjongg_hint_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	mahjongg_hint_cb ((Mahjongg*) self);
}

static void
_mahjongg_pause_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
	mahjongg_pause_cb ((Mahjongg*) self);
}

static void
_mahjongg_restart_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self)
{
	mahjongg_restart_game_cb ((Mahjongg*) self);
}

static void
_mahjongg_scores_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	mahjongg_scores_cb ((Mahjongg*) self);
}

static void
_mahjongg_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	mahjongg_preferences_cb ((Mahjongg*) self);
}

static void
_mahjongg_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	mahjongg_help_cb ((Mahjongg*) self);
}

static void
_mahjongg_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                     GVariant* parameter,
                                                     gpointer self)
{
	mahjongg_about_cb ((Mahjongg*) self);
}

static void
_mahjongg_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                    GVariant* parameter,
                                                    gpointer self)
{
	mahjongg_quit_cb ((Mahjongg*) self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

Mahjongg*
mahjongg_construct (GType object_type)
{
	Mahjongg * self = NULL;
	self = (Mahjongg*) g_object_new (object_type, "application-id", "org.gnome.Mahjongg", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	g_application_add_main_option_entries ((GApplication*) self, MAHJONGG_option_entries);
	return self;
}

Mahjongg*
mahjongg_new (void)
{
	return mahjongg_construct (TYPE_MAHJONGG);
}

static void
_mahjongg_on_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                              gint n_press,
                                              gdouble x,
                                              gdouble y,
                                              gpointer self)
{
	mahjongg_on_click ((Mahjongg*) self, _sender, n_press, x, y);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
mahjongg_real_startup (GApplication* base)
{
	Mahjongg * self;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	gchar** _tmp8_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	gchar* _tmp16_;
	gchar** _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	GSettings* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	History* _tmp27_;
	History* _tmp28_;
	GameView* _tmp29_;
	GtkGestureClick* _tmp30_;
	GtkGestureClick* _tmp31_;
	GameView* _tmp32_;
	GtkGestureClick* _tmp33_;
	GtkEventController* _tmp34_;
	GameView* _tmp35_;
	MahjonggWindow* _tmp36_;
	GSettings* _tmp37_;
	MahjonggWindow* _tmp38_;
	GSettings* _tmp39_;
	MahjonggWindow* _tmp40_;
	GSettings* _tmp41_;
	MahjonggWindow* _tmp42_;
	self = (Mahjongg*) base;
	G_APPLICATION_CLASS (mahjongg_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, adw_application_get_type (), AdwApplication));
	g_action_map_add_action_entries ((GActionMap*) self, MAHJONGG_action_entries, (gint) G_N_ELEMENTS (MAHJONGG_action_entries), self);
	_tmp0_ = g_strdup ("<Primary>n");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp2_);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	_tmp3_ = g_strdup ("<Primary>p");
	_tmp4_ = g_strdup ("Pause");
	_tmp5_ = g_new0 (gchar*, 2 + 1);
	_tmp5_[0] = _tmp3_;
	_tmp5_[1] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.pause", _tmp6_);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = g_strdup ("<Primary>h");
	_tmp8_ = g_new0 (gchar*, 1 + 1);
	_tmp8_[0] = _tmp7_;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.hint", _tmp9_);
	_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = g_strdup ("<Primary>z");
	_tmp11_ = g_new0 (gchar*, 1 + 1);
	_tmp11_[0] = _tmp10_;
	_tmp12_ = _tmp11_;
	_tmp12__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp12_);
	_tmp12_ = (_vala_array_free (_tmp12_, _tmp12__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = g_strdup ("<Shift><Primary>z");
	_tmp14_ = g_new0 (gchar*, 1 + 1);
	_tmp14_[0] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp15_);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	_tmp16_ = g_strdup ("F1");
	_tmp17_ = g_new0 (gchar*, 1 + 1);
	_tmp17_[0] = _tmp16_;
	_tmp18_ = _tmp17_;
	_tmp18__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp18_);
	_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_free), NULL);
	_tmp19_ = g_strdup ("<Primary>q");
	_tmp20_ = g_strdup ("<Primary>w");
	_tmp21_ = g_new0 (gchar*, 2 + 1);
	_tmp21_[0] = _tmp19_;
	_tmp21_[1] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 2;
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp22_);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_tmp23_ = g_settings_new ("org.gnome.Mahjongg");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp23_;
	mahjongg_load_maps (self);
	_tmp24_ = g_get_user_data_dir ();
	_tmp25_ = g_build_filename (_tmp24_, "gnome-mahjongg", "history", NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = history_new (_tmp26_);
	_g_object_unref0 (self->priv->history);
	self->priv->history = _tmp27_;
	_g_free0 (_tmp26_);
	_tmp28_ = self->priv->history;
	history_load (_tmp28_);
	_tmp29_ = game_view_new ();
	g_object_ref_sink (_tmp29_);
	_g_object_unref0 (self->priv->game_view);
	self->priv->game_view = _tmp29_;
	_tmp30_ = (GtkGestureClick*) gtk_gesture_click_new ();
	_g_object_unref0 (self->priv->view_click_controller);
	self->priv->view_click_controller = _tmp30_;
	_tmp31_ = self->priv->view_click_controller;
	g_signal_connect_object (_tmp31_, "pressed", (GCallback) _mahjongg_on_click_gtk_gesture_click_pressed, self, 0);
	_tmp32_ = self->priv->game_view;
	_tmp33_ = self->priv->view_click_controller;
	_tmp34_ = _g_object_ref0 ((GtkEventController*) _tmp33_);
	gtk_widget_add_controller ((GtkWidget*) _tmp32_, _tmp34_);
	_tmp35_ = self->priv->game_view;
	_tmp36_ = mahjongg_window_new ((GtkApplication*) self, _tmp35_);
	g_object_ref_sink (_tmp36_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp36_;
	_tmp37_ = self->priv->settings;
	_tmp38_ = self->priv->window;
	g_settings_bind (_tmp37_, "window-width", (GObject*) _tmp38_, "default-width", G_SETTINGS_BIND_DEFAULT);
	_tmp39_ = self->priv->settings;
	_tmp40_ = self->priv->window;
	g_settings_bind (_tmp39_, "window-height", (GObject*) _tmp40_, "default-height", G_SETTINGS_BIND_DEFAULT);
	_tmp41_ = self->priv->settings;
	_tmp42_ = self->priv->window;
	g_settings_bind (_tmp41_, "window-is-maximized", (GObject*) _tmp42_, "maximized", G_SETTINGS_BIND_DEFAULT);
}

static gint
mahjongg_real_handle_local_options (GApplication* base,
                                    GVariantDict* options)
{
	Mahjongg * self;
	gint result;
	self = (Mahjongg*) base;
	g_return_val_if_fail (options != NULL, 0);
	if (g_variant_dict_contains (options, "version")) {
		FILE* _tmp0_;
		_tmp0_ = stderr;
		fprintf (_tmp0_, "%1$s %2$s\n", "gnome-mahjongg", VERSION);
		result = EXIT_SUCCESS;
		return result;
	}
	result = -1;
	return result;
}

static void
_mahjongg_conf_value_changed_cb_g_settings_changed (GSettings* _sender,
                                                    const gchar* key,
                                                    gpointer self)
{
	mahjongg_conf_value_changed_cb ((Mahjongg*) self, _sender, key);
}

static void
mahjongg_real_activate (GApplication* base)
{
	Mahjongg * self;
	MahjonggWindow* _tmp0_;
	GSettings* _tmp1_;
	GameView* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	self = (Mahjongg*) base;
	_tmp0_ = self->priv->window;
	gtk_window_present ((GtkWindow*) _tmp0_);
	_tmp1_ = self->priv->settings;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _mahjongg_conf_value_changed_cb_g_settings_changed, self, 0);
	mahjongg_new_game (self);
	_tmp2_ = self->priv->game_view;
	gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->settings;
	mahjongg_conf_value_changed_cb (self, _tmp3_, "tileset");
	_tmp4_ = self->priv->settings;
	mahjongg_conf_value_changed_cb (self, _tmp4_, "bgcolour");
	mahjongg_tick_cb (self);
}

static void
mahjongg_update_ui (Mahjongg* self)
{
	GSimpleAction* pause_action = NULL;
	GAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* hint_action = NULL;
	GAction* _tmp2_;
	GSimpleAction* _tmp3_;
	GSimpleAction* undo_action = NULL;
	GAction* _tmp4_;
	GSimpleAction* _tmp5_;
	GSimpleAction* redo_action = NULL;
	GAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GameView* _tmp9_;
	Game* _tmp10_;
	Game* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GameView* _tmp14_;
	Game* _tmp15_;
	Game* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	pause_action = _tmp1_;
	_tmp2_ = g_action_map_lookup_action ((GActionMap*) self, "hint");
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp2_) : NULL);
	hint_action = _tmp3_;
	_tmp4_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp4_) : NULL);
	undo_action = _tmp5_;
	_tmp6_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp6_) : NULL);
	redo_action = _tmp7_;
	_tmp8_ = pause_action;
	_tmp9_ = self->priv->game_view;
	_tmp10_ = game_view_get_game (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = game_get_started (_tmp11_);
	_tmp13_ = _tmp12_;
	g_simple_action_set_enabled (_tmp8_, _tmp13_);
	_tmp14_ = self->priv->game_view;
	_tmp15_ = game_view_get_game (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = game_get_paused (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		GSimpleAction* _tmp19_;
		GSimpleAction* _tmp20_;
		GSimpleAction* _tmp21_;
		_tmp19_ = hint_action;
		g_simple_action_set_enabled (_tmp19_, FALSE);
		_tmp20_ = undo_action;
		g_simple_action_set_enabled (_tmp20_, FALSE);
		_tmp21_ = redo_action;
		g_simple_action_set_enabled (_tmp21_, FALSE);
	} else {
		GSimpleAction* _tmp22_;
		GameView* _tmp23_;
		Game* _tmp24_;
		Game* _tmp25_;
		guint _tmp26_;
		guint _tmp27_;
		GSimpleAction* _tmp28_;
		GameView* _tmp29_;
		Game* _tmp30_;
		Game* _tmp31_;
		gboolean _tmp32_;
		gboolean _tmp33_;
		GSimpleAction* _tmp34_;
		GameView* _tmp35_;
		Game* _tmp36_;
		Game* _tmp37_;
		gboolean _tmp38_;
		gboolean _tmp39_;
		_tmp22_ = hint_action;
		_tmp23_ = self->priv->game_view;
		_tmp24_ = game_view_get_game (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = game_get_moves_left (_tmp25_);
		_tmp27_ = _tmp26_;
		g_simple_action_set_enabled (_tmp22_, _tmp27_ > ((guint) 0));
		_tmp28_ = undo_action;
		_tmp29_ = self->priv->game_view;
		_tmp30_ = game_view_get_game (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = game_get_can_undo (_tmp31_);
		_tmp33_ = _tmp32_;
		g_simple_action_set_enabled (_tmp28_, _tmp33_);
		_tmp34_ = redo_action;
		_tmp35_ = self->priv->game_view;
		_tmp36_ = game_view_get_game (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = game_get_can_redo (_tmp37_);
		_tmp39_ = _tmp38_;
		g_simple_action_set_enabled (_tmp34_, _tmp39_);
	}
	mahjongg_tick_cb (self);
	_g_object_unref0 (redo_action);
	_g_object_unref0 (undo_action);
	_g_object_unref0 (hint_action);
	_g_object_unref0 (pause_action);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Mahjongg* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
______lambda10_ (Block1Data* _data1_,
                 gint resp_id)
{
	Mahjongg* self;
	GtkMessageDialog* _tmp0_;
	self = _data1_->self;
	if (resp_id == ((gint) GTK_RESPONSE_ACCEPT)) {
		mahjongg_new_game (self);
	}
	_tmp0_ = _data1_->dialog;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
}

static void
_______lambda10__gtk_dialog_response (GtkDialog* _sender,
                                      gint response_id,
                                      gpointer self)
{
	______lambda10_ (self, response_id);
}

static void
mahjongg_conf_value_changed_cb (Mahjongg* self,
                                GSettings* settings,
                                const gchar* key)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (settings != NULL);
	g_return_if_fail (key != NULL);
	if (g_strcmp0 (key, "tileset") == 0) {
		gchar* theme = NULL;
		gchar* _tmp0_;
		GameView* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = g_settings_get_string (settings, "tileset");
		theme = _tmp0_;
		_tmp1_ = self->priv->game_view;
		_tmp2_ = theme;
		_tmp3_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		game_view_set_theme (_tmp1_, _tmp4_);
		_g_free0 (_tmp4_);
		_g_free0 (theme);
	} else {
		if (g_strcmp0 (key, "bgcolour") == 0) {
			GameView* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = self->priv->game_view;
			_tmp6_ = g_settings_get_string (settings, "bgcolour");
			_tmp7_ = _tmp6_;
			game_view_set_background (_tmp5_, _tmp7_);
			_g_free0 (_tmp7_);
		} else {
			if (g_strcmp0 (key, "mapset") == 0) {
				GameView* _tmp8_;
				Game* _tmp9_;
				Game* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				_tmp8_ = self->priv->game_view;
				_tmp9_ = game_view_get_game (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = game_get_started (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_) {
					Block1Data* _data1_;
					MahjonggWindow* _tmp13_;
					GtkMessageDialog* _tmp14_;
					GtkMessageDialog* _tmp15_;
					GtkMessageDialog* _tmp16_;
					GtkMessageDialog* _tmp17_;
					GtkMessageDialog* _tmp18_;
					GtkMessageDialog* _tmp19_;
					_data1_ = g_slice_new0 (Block1Data);
					_data1_->_ref_count_ = 1;
					_data1_->self = g_object_ref (self);
					_tmp13_ = self->priv->window;
					_tmp14_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp13_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Do you want to start a new game with this map?"));
					g_object_ref_sink (_tmp14_);
					_data1_->dialog = _tmp14_;
					_tmp15_ = _data1_->dialog;
					gtk_message_dialog_format_secondary_text (_tmp15_, "%s", _ ("If you continue playing the next game will use the new map."));
					_tmp16_ = _data1_->dialog;
					gtk_dialog_add_buttons ((GtkDialog*) _tmp16_, _ ("_Continue playing"), GTK_RESPONSE_REJECT, _ ("Use _new map"), GTK_RESPONSE_ACCEPT, NULL, NULL);
					_tmp17_ = _data1_->dialog;
					gtk_dialog_set_default_response ((GtkDialog*) _tmp17_, (gint) GTK_RESPONSE_ACCEPT);
					_tmp18_ = _data1_->dialog;
					g_signal_connect_data ((GtkDialog*) _tmp18_, "response", (GCallback) _______lambda10__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
					_tmp19_ = _data1_->dialog;
					gtk_widget_show ((GtkWidget*) _tmp19_);
					block1_data_unref (_data1_);
					_data1_ = NULL;
				} else {
					mahjongg_new_game (self);
				}
			}
		}
	}
}

static inline void
mahjongg_on_click (Mahjongg* self,
                   GtkGestureClick* _view_click_controller,
                   gint n_press,
                   gdouble event_x,
                   gdouble event_y)
{
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_view_click_controller != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_paused (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		mahjongg_pause_cb (self);
	}
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		Mahjongg* self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}

static void
____lambda6_ (Block2Data* _data2_,
              gint resp_id)
{
	Mahjongg* self;
	GtkMessageDialog* _tmp0_;
	self = _data2_->self;
	switch (resp_id) {
		case MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO:
		{
			mahjongg_undo_cb (self);
			break;
		}
		case MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE:
		{
			mahjongg_shuffle_cb (self);
			break;
		}
		case MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART:
		{
			mahjongg_restart_game (self);
			break;
		}
		case MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME:
		{
			mahjongg_new_game (self);
			break;
		}
		case GTK_RESPONSE_DELETE_EVENT:
		{
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp0_ = _data2_->dialog;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
}

static void
_____lambda6__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	____lambda6_ (self, response_id);
}

static void
mahjongg_moved_cb (Mahjongg* self)
{
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	mahjongg_update_ui (self);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_complete (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GDateTime* date = NULL;
		GDateTime* _tmp5_;
		guint duration = 0U;
		GameView* _tmp6_;
		Game* _tmp7_;
		Game* _tmp8_;
		gdouble _tmp9_;
		gdouble _tmp10_;
		HistoryEntry* entry = NULL;
		GDateTime* _tmp11_;
		GameView* _tmp12_;
		Game* _tmp13_;
		Game* _tmp14_;
		Map* _tmp15_;
		const gchar* _tmp16_;
		HistoryEntry* _tmp17_;
		History* _tmp18_;
		HistoryEntry* _tmp19_;
		History* _tmp20_;
		HistoryEntry* _tmp21_;
		_tmp5_ = g_date_time_new_now_local ();
		date = _tmp5_;
		_tmp6_ = self->priv->game_view;
		_tmp7_ = game_view_get_game (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = game_get_elapsed (_tmp8_);
		_tmp10_ = _tmp9_;
		duration = (guint) (_tmp10_ + 0.5);
		_tmp11_ = date;
		_tmp12_ = self->priv->game_view;
		_tmp13_ = game_view_get_game (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_->map;
		_tmp16_ = _tmp15_->score_name;
		_tmp17_ = history_entry_new (_tmp11_, _tmp16_, duration);
		entry = _tmp17_;
		_tmp18_ = self->priv->history;
		_tmp19_ = entry;
		history_add (_tmp18_, _tmp19_);
		_tmp20_ = self->priv->history;
		history_save (_tmp20_);
		_tmp21_ = entry;
		mahjongg_show_scores (self, _tmp21_, TRUE);
		_g_object_unref0 (entry);
		_g_date_time_unref0 (date);
	} else {
		GameView* _tmp22_;
		Game* _tmp23_;
		Game* _tmp24_;
		gboolean _tmp25_;
		gboolean _tmp26_;
		_tmp22_ = self->priv->game_view;
		_tmp23_ = game_view_get_game (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = game_get_can_move (_tmp24_);
		_tmp26_ = _tmp25_;
		if (!_tmp26_) {
			Block2Data* _data2_;
			gboolean allow_shuffle = FALSE;
			GameView* _tmp27_;
			Game* _tmp28_;
			Game* _tmp29_;
			MahjonggWindow* _tmp30_;
			GtkMessageDialog* _tmp31_;
			const gchar* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			GtkMessageDialog* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			const gchar* _tmp37_ = NULL;
			GtkMessageDialog* _tmp38_;
			GtkMessageDialog* _tmp39_;
			GtkMessageDialog* _tmp40_;
			_data2_ = g_slice_new0 (Block2Data);
			_data2_->_ref_count_ = 1;
			_data2_->self = g_object_ref (self);
			_tmp27_ = self->priv->game_view;
			_tmp28_ = game_view_get_game (_tmp27_);
			_tmp29_ = _tmp28_;
			allow_shuffle = game_number_of_movable_tiles (_tmp29_) > 1;
			_tmp30_ = self->priv->window;
			_tmp31_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp30_, GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, "%s", _ ("There are no more moves."));
			g_object_ref_sink (_tmp31_);
			_data2_->dialog = _tmp31_;
			if (allow_shuffle) {
				_tmp32_ = " ";
			} else {
				_tmp32_ = "";
			}
			if (allow_shuffle) {
				_tmp33_ = _ ("You can also try to reshuffle the game, but this does not guarantee a " \
"solution.");
			} else {
				_tmp33_ = "";
			}
			_tmp34_ = _data2_->dialog;
			_tmp35_ = g_strdup_printf ("%s%s%s", _ ("Each puzzle has at least one solution.  You can undo your moves and tr" \
"y and find the solution, restart this game, or start a new one."), _tmp32_, _tmp33_);
			_tmp36_ = _tmp35_;
			gtk_message_dialog_format_secondary_text (_tmp34_, "%s", _tmp36_);
			_g_free0 (_tmp36_);
			if (allow_shuffle) {
				_tmp37_ = _ ("_Shuffle");
			} else {
				_tmp37_ = NULL;
			}
			_tmp38_ = _data2_->dialog;
			gtk_dialog_add_buttons ((GtkDialog*) _tmp38_, _ ("_Undo"), MAHJONGG_NO_MOVES_DIALOG_RESPONSE_UNDO, _ ("_Restart"), MAHJONGG_NO_MOVES_DIALOG_RESPONSE_RESTART, _ ("_New game"), MAHJONGG_NO_MOVES_DIALOG_RESPONSE_NEW_GAME, _tmp37_, MAHJONGG_NO_MOVES_DIALOG_RESPONSE_SHUFFLE, NULL);
			_tmp39_ = _data2_->dialog;
			g_signal_connect_data ((GtkDialog*) _tmp39_, "response", (GCallback) _____lambda6__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
			_tmp40_ = _data2_->dialog;
			gtk_widget_show ((GtkWidget*) _tmp40_);
			block2_data_unref (_data2_);
			_data2_ = NULL;
		}
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		Mahjongg* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda5_ (Block3Data* _data3_,
            gint resp_id)
{
	Mahjongg* self;
	self = _data3_->self;
	if (resp_id == ((gint) GTK_RESPONSE_CLOSE)) {
		MahjonggWindow* _tmp0_;
		_tmp0_ = self->priv->window;
		gtk_window_destroy ((GtkWindow*) _tmp0_);
	} else {
		if (resp_id == ((gint) GTK_RESPONSE_OK)) {
			mahjongg_new_game (self);
		}
	}
	gtk_window_destroy ((GtkWindow*) _data3_->dialog);
}

static void
___lambda5__gtk_dialog_response (GtkDialog* _sender,
                                 gint response_id,
                                 gpointer self)
{
	__lambda5_ (self, response_id);
}

static void
mahjongg_show_scores (Mahjongg* self,
                      HistoryEntry* selected_entry,
                      gboolean show_quit)
{
	Block3Data* _data3_;
	History* _tmp0_;
	GList* _tmp1_;
	ScoreDialog* _tmp2_;
	MahjonggWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = self->priv->history;
	_tmp1_ = self->priv->maps;
	_tmp2_ = score_dialog_new (_tmp0_, selected_entry, show_quit, _tmp1_);
	g_object_ref_sink (_tmp2_);
	_data3_->dialog = _tmp2_;
	gtk_window_set_modal ((GtkWindow*) _data3_->dialog, TRUE);
	_tmp3_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) _data3_->dialog, (GtkWindow*) _tmp3_);
	g_signal_connect_data ((GtkDialog*) _data3_->dialog, "response", (GCallback) ___lambda5__gtk_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	gtk_widget_show ((GtkWidget*) _data3_->dialog);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_list_free__g_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_free0_);
}

static void
mahjongg_preferences_cb (Mahjongg* self)
{
	PreferencesWindow* preferences = NULL;
	GSettings* _tmp0_;
	PreferencesWindow* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	GList* _tmp4_;
	GameView* _tmp5_;
	GdkRGBA _tmp6_;
	MahjonggWindow* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = preferences_window_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	preferences = _tmp1_;
	_tmp2_ = mahjongg_load_themes (self);
	_tmp3_ = _tmp2_;
	preferences_window_populate_themes (preferences, _tmp3_);
	(_tmp3_ == NULL) ? NULL : (_tmp3_ = (_g_list_free__g_free0_ (_tmp3_), NULL));
	_tmp4_ = self->priv->maps;
	preferences_window_populate_layouts (preferences, _tmp4_);
	_tmp5_ = self->priv->game_view;
	_tmp6_ = _tmp5_->background_color;
	preferences_window_populate_background (preferences, &_tmp6_);
	_tmp7_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) preferences, (GtkWindow*) _tmp7_);
	gtk_widget_show ((GtkWidget*) preferences);
	_g_object_unref0 (preferences);
}

static GList*
mahjongg_load_themes (Mahjongg* self)
{
	GList* themes = NULL;
	GDir* dir = NULL;
	GError* _inner_error0_ = NULL;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	themes = NULL;
	{
		GDir* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GDir* _tmp3_;
		GDir* _tmp4_;
		GDir* _tmp5_;
		_tmp1_ = g_build_filename (DATA_DIRECTORY, "themes", NULL);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_dir_open (_tmp2_, (guint) 0, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_dir_close0 (dir);
			(themes == NULL) ? NULL : (themes = (_g_list_free__g_free0_ (themes), NULL));
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		_g_dir_close0 (dir);
		dir = _tmp5_;
		_g_dir_close0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
		result = themes;
		_g_dir_close0 (dir);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_dir_close0 (dir);
		(themes == NULL) ? NULL : (themes = (_g_list_free__g_free0_ (themes), NULL));
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	while (TRUE) {
		gchar* s = NULL;
		GDir* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		const gchar* _tmp15_;
		_tmp6_ = dir;
		_tmp7_ = g_dir_read_name (_tmp6_);
		_tmp8_ = g_strdup (_tmp7_);
		s = _tmp8_;
		_tmp9_ = s;
		if (_tmp9_ == NULL) {
			_g_free0 (s);
			break;
		}
		_tmp15_ = s;
		if (g_str_has_suffix (_tmp15_, ".xpm")) {
			_tmp14_ = TRUE;
		} else {
			const gchar* _tmp16_;
			_tmp16_ = s;
			_tmp14_ = g_str_has_suffix (_tmp16_, ".svg");
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			const gchar* _tmp17_;
			_tmp17_ = s;
			_tmp13_ = g_str_has_suffix (_tmp17_, ".gif");
		}
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			const gchar* _tmp18_;
			_tmp18_ = s;
			_tmp12_ = g_str_has_suffix (_tmp18_, ".png");
		}
		if (_tmp12_) {
			_tmp11_ = TRUE;
		} else {
			const gchar* _tmp19_;
			_tmp19_ = s;
			_tmp11_ = g_str_has_suffix (_tmp19_, ".jpg");
		}
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			const gchar* _tmp20_;
			_tmp20_ = s;
			_tmp10_ = g_str_has_suffix (_tmp20_, ".xbm");
		}
		if (_tmp10_) {
			const gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp21_ = s;
			_tmp22_ = g_strdup (_tmp21_);
			themes = g_list_append (themes, _tmp22_);
		}
		_g_free0 (s);
	}
	result = themes;
	_g_dir_close0 (dir);
	return result;
}

static void
mahjongg_hint_cb (Mahjongg* self)
{
	GList* matches = NULL;
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	GameView* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	Tile* _tmp6_;
	Tile* _tmp7_;
	GList* _tmp8_;
	GList* _tmp9_;
	gint32 n = 0;
	GList* _tmp19_;
	Match* match = NULL;
	GList* _tmp20_;
	gconstpointer _tmp21_;
	Match* _tmp22_;
	GameView* _tmp23_;
	Game* _tmp24_;
	Game* _tmp25_;
	Match* _tmp26_;
	Tile* _tmp27_;
	Match* _tmp28_;
	Tile* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->game_view;
	_tmp4_ = game_view_get_game (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_selected_tile (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = game_find_matches (_tmp2_, _tmp7_);
	matches = _tmp8_;
	_tmp9_ = matches;
	if (g_list_length (_tmp9_) == ((guint) 0)) {
		GameView* _tmp10_;
		Game* _tmp11_;
		Game* _tmp12_;
		Tile* _tmp13_;
		Tile* _tmp14_;
		GameView* _tmp15_;
		Game* _tmp16_;
		Game* _tmp17_;
		GList* _tmp18_;
		_tmp10_ = self->priv->game_view;
		_tmp11_ = game_view_get_game (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = game_get_selected_tile (_tmp12_);
		_tmp14_ = _tmp13_;
		if (_tmp14_ == NULL) {
			(matches == NULL) ? NULL : (matches = (_g_list_free__g_object_unref0_ (matches), NULL));
			return;
		}
		_tmp15_ = self->priv->game_view;
		_tmp16_ = game_view_get_game (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = game_find_matches (_tmp17_, NULL);
		(matches == NULL) ? NULL : (matches = (_g_list_free__g_object_unref0_ (matches), NULL));
		matches = _tmp18_;
	}
	_tmp19_ = matches;
	n = g_random_int_range ((gint32) 0, (gint32) ((gint) g_list_length (_tmp19_)));
	_tmp20_ = matches;
	_tmp21_ = g_list_nth_data (_tmp20_, (guint) n);
	_tmp22_ = _g_object_ref0 ((Match*) _tmp21_);
	match = _tmp22_;
	_tmp23_ = self->priv->game_view;
	_tmp24_ = game_view_get_game (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = match;
	_tmp27_ = _tmp26_->tile0;
	_tmp28_ = match;
	_tmp29_ = _tmp28_->tile1;
	game_set_hint (_tmp25_, _tmp27_, _tmp29_);
	mahjongg_update_ui (self);
	_g_object_unref0 (match);
	(matches == NULL) ? NULL : (matches = (_g_list_free__g_object_unref0_ (matches), NULL));
}

static void
mahjongg_shuffle_cb (Mahjongg* self)
{
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	game_shuffle_remaining (_tmp2_, TRUE);
}

static void
mahjongg_about_cb (Mahjongg* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint authors_length1;
	gint _authors_size_;
	gchar** artists = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar** _tmp20_;
	gint artists_length1;
	gint _artists_size_;
	gchar** documenters = NULL;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gint documenters_length1;
	gint _documenters_size_;
	MahjonggWindow* _tmp24_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("Main game:"));
	_tmp1_ = g_strdup ("Francisco Bustamante");
	_tmp2_ = g_strdup ("Max Watson");
	_tmp3_ = g_strdup ("Heinz Hempe");
	_tmp4_ = g_strdup ("Michael Meeks");
	_tmp5_ = g_strdup ("Philippe Chavin");
	_tmp6_ = g_strdup ("Callum McKenzie");
	_tmp7_ = g_strdup ("Robert Ancell");
	_tmp8_ = g_strdup ("Günther Wagner");
	_tmp9_ = g_strdup ("");
	_tmp10_ = g_strdup (_ ("Maps:"));
	_tmp11_ = g_strdup ("Rexford Newbould");
	_tmp12_ = g_strdup ("Krzysztof Foltman");
	_tmp13_ = g_new0 (gchar*, 14 + 1);
	_tmp13_[0] = _tmp0_;
	_tmp13_[1] = _tmp1_;
	_tmp13_[2] = _tmp2_;
	_tmp13_[3] = _tmp3_;
	_tmp13_[4] = _tmp4_;
	_tmp13_[5] = _tmp5_;
	_tmp13_[6] = _tmp6_;
	_tmp13_[7] = _tmp7_;
	_tmp13_[8] = _tmp8_;
	_tmp13_[9] = _tmp9_;
	_tmp13_[10] = _tmp10_;
	_tmp13_[11] = _tmp11_;
	_tmp13_[12] = _tmp12_;
	_tmp13_[13] = NULL;
	authors = _tmp13_;
	authors_length1 = 14;
	_authors_size_ = authors_length1;
	_tmp14_ = g_strdup (_ ("Tiles:"));
	_tmp15_ = g_strdup ("Jonathan Buzzard");
	_tmp16_ = g_strdup ("Jim Evans");
	_tmp17_ = g_strdup ("Richard Hoelscher");
	_tmp18_ = g_strdup ("Gonzalo Odiard");
	_tmp19_ = g_strdup ("Max Watson");
	_tmp20_ = g_new0 (gchar*, 7 + 1);
	_tmp20_[0] = _tmp14_;
	_tmp20_[1] = _tmp15_;
	_tmp20_[2] = _tmp16_;
	_tmp20_[3] = _tmp17_;
	_tmp20_[4] = _tmp18_;
	_tmp20_[5] = _tmp19_;
	_tmp20_[6] = NULL;
	artists = _tmp20_;
	artists_length1 = 7;
	_artists_size_ = artists_length1;
	_tmp21_ = g_strdup ("Tiffany Antopolski");
	_tmp22_ = g_strdup ("Chris Beiser");
	_tmp23_ = g_new0 (gchar*, 3 + 1);
	_tmp23_[0] = _tmp21_;
	_tmp23_[1] = _tmp22_;
	_tmp23_[2] = NULL;
	documenters = _tmp23_;
	documenters_length1 = 3;
	_documenters_size_ = documenters_length1;
	_tmp24_ = self->priv->window;
	gtk_show_about_dialog ((GtkWindow*) _tmp24_, "program-name", _ ("Mahjongg"), "version", VERSION, "comments", _ ("A matching game played with Mahjongg tiles"), "copyright", "Copyright © 1998–2008 Free Software Foundation, Inc.", "license-type", GTK_LICENSE_GPL_2_0, "authors", authors, "artists", artists, "documenters", documenters, "translator-credits", _ ("translator-credits"), "logo-icon-name", "org.gnome.Mahjongg", "website", "https://gitlab.gnome.org/GNOME/gnome-mahjongg", NULL, NULL);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

static void
mahjongg_pause_cb (Mahjongg* self)
{
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	GameView* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GameView* _tmp8_;
	Game* _tmp9_;
	Game* _tmp10_;
	GameView* _tmp11_;
	Game* _tmp12_;
	Game* _tmp13_;
	GameView* _tmp14_;
	Game* _tmp15_;
	Game* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->game_view;
	_tmp4_ = game_view_get_game (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_paused (_tmp5_);
	_tmp7_ = _tmp6_;
	game_set_paused (_tmp2_, !_tmp7_);
	_tmp8_ = self->priv->game_view;
	_tmp9_ = game_view_get_game (_tmp8_);
	_tmp10_ = _tmp9_;
	game_set_hint (_tmp10_, NULL, NULL);
	_tmp11_ = self->priv->game_view;
	_tmp12_ = game_view_get_game (_tmp11_);
	_tmp13_ = _tmp12_;
	game_set_selected_tile (_tmp13_, NULL);
	_tmp14_ = self->priv->game_view;
	_tmp15_ = game_view_get_game (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = game_get_paused (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		MahjonggWindow* _tmp19_;
		_tmp19_ = self->priv->window;
		mahjongg_window_pause (_tmp19_);
	} else {
		MahjonggWindow* _tmp20_;
		_tmp20_ = self->priv->window;
		mahjongg_window_unpause (_tmp20_);
	}
	mahjongg_update_ui (self);
}

static void
mahjongg_scores_cb (Mahjongg* self)
{
	g_return_if_fail (self != NULL);
	mahjongg_show_scores (self, NULL, FALSE);
}

static void
mahjongg_new_game_cb (Mahjongg* self)
{
	g_return_if_fail (self != NULL);
	mahjongg_new_game (self);
}

static void
mahjongg_restart_game_cb (Mahjongg* self)
{
	g_return_if_fail (self != NULL);
	mahjongg_restart_game (self);
}

static void
mahjongg_quit_cb (Mahjongg* self)
{
	MahjonggWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
}

static void
mahjongg_redo_cb (Mahjongg* self)
{
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GameView* _tmp5_;
	Game* _tmp6_;
	Game* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = game_get_paused (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->game_view;
	_tmp6_ = game_view_get_game (_tmp5_);
	_tmp7_ = _tmp6_;
	game_redo (_tmp7_);
	mahjongg_update_ui (self);
}

static void
mahjongg_undo_cb (Mahjongg* self)
{
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	game_undo (_tmp2_);
	mahjongg_update_ui (self);
}

static void
mahjongg_restart_game (Mahjongg* self)
{
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	GameView* _tmp3_;
	Game* _tmp4_;
	Game* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	game_reset (_tmp2_);
	_tmp3_ = self->priv->game_view;
	_tmp4_ = game_view_get_game (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = game_get_paused (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		mahjongg_pause_cb (self);
	}
	mahjongg_update_ui (self);
}

static void
_mahjongg_moved_cb_game_moved (Game* _sender,
                               gpointer self)
{
	mahjongg_moved_cb ((Mahjongg*) self);
}

static void
_mahjongg_tick_cb_game_tick (Game* _sender,
                             gpointer self)
{
	mahjongg_tick_cb ((Mahjongg*) self);
}

static void
mahjongg_new_game (Mahjongg* self)
{
	Map* map = NULL;
	GList* _tmp0_;
	Map* _tmp10_;
	GameView* _tmp14_;
	Map* _tmp15_;
	Game* _tmp16_;
	Game* _tmp17_;
	GameView* _tmp18_;
	Game* _tmp19_;
	Game* _tmp20_;
	GameView* _tmp21_;
	Game* _tmp22_;
	Game* _tmp23_;
	MahjonggWindow* _tmp24_;
	GameView* _tmp25_;
	MahjonggWindow* _tmp26_;
	g_return_if_fail (self != NULL);
	map = NULL;
	_tmp0_ = self->priv->maps;
	{
		GList* m_collection = NULL;
		GList* m_it = NULL;
		m_collection = _tmp0_;
		for (m_it = m_collection; m_it != NULL; m_it = m_it->next) {
			Map* _tmp1_;
			Map* m = NULL;
			_tmp1_ = _g_object_ref0 ((Map*) m_it->data);
			m = _tmp1_;
			{
				Map* _tmp2_;
				const gchar* _tmp3_;
				GSettings* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gboolean _tmp7_;
				_tmp2_ = m;
				_tmp3_ = _tmp2_->name;
				_tmp4_ = self->priv->settings;
				_tmp5_ = g_settings_get_string (_tmp4_, "mapset");
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strcmp0 (_tmp3_, _tmp6_) == 0;
				_g_free0 (_tmp6_);
				if (_tmp7_) {
					Map* _tmp8_;
					Map* _tmp9_;
					_tmp8_ = m;
					_tmp9_ = _g_object_ref0 (_tmp8_);
					_g_object_unref0 (map);
					map = _tmp9_;
					_g_object_unref0 (m);
					break;
				}
				_g_object_unref0 (m);
			}
		}
	}
	_tmp10_ = map;
	if (_tmp10_ == NULL) {
		GList* _tmp11_;
		gconstpointer _tmp12_;
		Map* _tmp13_;
		_tmp11_ = self->priv->maps;
		_tmp12_ = g_list_nth_data (_tmp11_, (guint) 0);
		_tmp13_ = _g_object_ref0 ((Map*) _tmp12_);
		_g_object_unref0 (map);
		map = _tmp13_;
	}
	_tmp14_ = self->priv->game_view;
	_tmp15_ = map;
	_tmp16_ = game_new (_tmp15_);
	_tmp17_ = _tmp16_;
	game_view_set_game (_tmp14_, _tmp17_);
	_g_object_unref0 (_tmp17_);
	_tmp18_ = self->priv->game_view;
	_tmp19_ = game_view_get_game (_tmp18_);
	_tmp20_ = _tmp19_;
	g_signal_connect_object (_tmp20_, "moved", (GCallback) _mahjongg_moved_cb_game_moved, self, 0);
	_tmp21_ = self->priv->game_view;
	_tmp22_ = game_view_get_game (_tmp21_);
	_tmp23_ = _tmp22_;
	g_signal_connect_object (_tmp23_, "tick", (GCallback) _mahjongg_tick_cb_game_tick, self, 0);
	_tmp24_ = self->priv->window;
	_tmp25_ = self->priv->game_view;
	mahjongg_window_set_map_title (_tmp24_, _tmp25_);
	mahjongg_update_ui (self);
	_tmp26_ = self->priv->window;
	mahjongg_window_unpause (_tmp26_);
	_g_object_unref0 (map);
}

static void
mahjongg_tick_cb (Mahjongg* self)
{
	gchar* clock = NULL;
	gint elapsed = 0;
	GameView* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	gint hours = 0;
	gint minutes = 0;
	gint seconds = 0;
	MahjonggWindow* _tmp10_;
	GameView* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	elapsed = 0;
	_tmp0_ = self->priv->game_view;
	_tmp1_ = game_view_get_game (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GameView* _tmp3_;
		Game* _tmp4_;
		Game* _tmp5_;
		gdouble _tmp6_;
		gdouble _tmp7_;
		_tmp3_ = self->priv->game_view;
		_tmp4_ = game_view_get_game (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = game_get_elapsed (_tmp5_);
		_tmp7_ = _tmp6_;
		elapsed = (gint) (_tmp7_ + 0.5);
	}
	hours = elapsed / 3600;
	minutes = (elapsed - (hours * 3600)) / 60;
	seconds = (elapsed - (hours * 3600)) - (minutes * 60);
	if (hours > 0) {
		gchar* _tmp8_;
		_tmp8_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", hours, minutes, seconds);
		_g_free0 (clock);
		clock = _tmp8_;
	} else {
		gchar* _tmp9_;
		_tmp9_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", minutes, seconds);
		_g_free0 (clock);
		clock = _tmp9_;
	}
	_tmp10_ = self->priv->window;
	_tmp11_ = self->priv->game_view;
	_tmp12_ = clock;
	mahjongg_window_set_subtitle (_tmp10_, _tmp11_, _tmp12_);
	_g_free0 (clock);
}

static void
mahjongg_help_cb (Mahjongg* self)
{
	MahjonggWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_show_uri ((GtkWindow*) _tmp0_, "help:gnome-mahjongg", (guint32) GDK_CURRENT_TIME);
}

static void
mahjongg_load_maps (Mahjongg* self)
{
	Map* _tmp0_;
	GDir* dir = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	(self->priv->maps == NULL) ? NULL : (self->priv->maps = (_g_list_free__g_object_unref0_ (self->priv->maps), NULL));
	self->priv->maps = NULL;
	_tmp0_ = map_new_builtin ();
	self->priv->maps = g_list_append (self->priv->maps, _tmp0_);
	{
		GDir* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GDir* _tmp4_;
		GDir* _tmp5_;
		GDir* _tmp6_;
		_tmp2_ = g_build_filename (DATA_DIRECTORY, "maps", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_dir_open (_tmp3_, (guint) 0, &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		_tmp1_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_dir_close0 (dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp6_ = _tmp1_;
		_tmp1_ = NULL;
		_g_dir_close0 (dir);
		dir = _tmp6_;
		_g_dir_close0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
		_g_dir_close0 (dir);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_dir_close0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	while (TRUE) {
		gchar* filename = NULL;
		GDir* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		MapLoader* loader = NULL;
		MapLoader* _tmp12_;
		gchar* path = NULL;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		MapLoader* _tmp20_;
		GList* _tmp21_;
		_tmp7_ = dir;
		_tmp8_ = g_dir_read_name (_tmp7_);
		_tmp9_ = g_strdup (_tmp8_);
		filename = _tmp9_;
		_tmp10_ = filename;
		if (_tmp10_ == NULL) {
			_g_free0 (filename);
			break;
		}
		_tmp11_ = filename;
		if (!g_str_has_suffix (_tmp11_, ".map")) {
			_g_free0 (filename);
			continue;
		}
		_tmp12_ = map_loader_new ();
		loader = _tmp12_;
		_tmp13_ = filename;
		_tmp14_ = g_build_filename (DATA_DIRECTORY, "maps", _tmp13_, NULL);
		path = _tmp14_;
		{
			MapLoader* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = loader;
			_tmp16_ = path;
			map_loader_load (_tmp15_, _tmp16_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp17_;
			GError* _tmp18_;
			const gchar* _tmp19_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp17_ = path;
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			g_warning ("gnome-mahjongg.vala:524: Could not load map %s: %s\n", _tmp17_, _tmp19_);
			_g_error_free0 (e);
			_g_free0 (path);
			_g_object_unref0 (loader);
			_g_free0 (filename);
			continue;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (path);
			_g_object_unref0 (loader);
			_g_free0 (filename);
			_g_dir_close0 (dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp20_ = loader;
		_tmp21_ = _tmp20_->maps;
		{
			GList* map_collection = NULL;
			GList* map_it = NULL;
			map_collection = _tmp21_;
			for (map_it = map_collection; map_it != NULL; map_it = map_it->next) {
				Map* _tmp22_;
				Map* map = NULL;
				_tmp22_ = _g_object_ref0 ((Map*) map_it->data);
				map = _tmp22_;
				{
					Map* _tmp23_;
					Map* _tmp24_;
					_tmp23_ = map;
					_tmp24_ = _g_object_ref0 (_tmp23_);
					self->priv->maps = g_list_append (self->priv->maps, _tmp24_);
					_g_object_unref0 (map);
				}
			}
		}
		_g_free0 (path);
		_g_object_unref0 (loader);
		_g_free0 (filename);
	}
	_g_dir_close0 (dir);
}

static gint
mahjongg_main (gchar** args,
               gint args_length1)
{
	Mahjongg* app = NULL;
	Mahjongg* _tmp0_;
	gint _result_ = 0;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	g_set_application_name (_ ("Mahjongg"));
	gtk_window_set_default_icon_name ("org.gnome.Mahjongg");
	g_type_ensure (TYPE_GAME_VIEW);
	_tmp0_ = mahjongg_new ();
	app = _tmp0_;
	_result_ = g_application_run ((GApplication*) app, (gint) args_length1, args);
	g_settings_sync ();
	result = _result_;
	_g_object_unref0 (app);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return mahjongg_main (argv, argc);
}

static void
mahjongg_class_init (MahjonggClass * klass,
                     gpointer klass_data)
{
	mahjongg_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Mahjongg_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) mahjongg_real_startup;
	((GApplicationClass *) klass)->handle_local_options = (gint (*) (GApplication*, GVariantDict*)) mahjongg_real_handle_local_options;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) mahjongg_real_activate;
	G_OBJECT_CLASS (klass)->finalize = mahjongg_finalize;
}

static void
mahjongg_instance_init (Mahjongg * self,
                        gpointer klass)
{
	self->priv = mahjongg_get_instance_private (self);
	self->priv->maps = NULL;
}

static void
mahjongg_finalize (GObject * obj)
{
	Mahjongg * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAHJONGG, Mahjongg);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->history);
	(self->priv->maps == NULL) ? NULL : (self->priv->maps = (_g_list_free__g_object_unref0_ (self->priv->maps), NULL));
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->game_view);
	_g_object_unref0 (self->priv->view_click_controller);
	G_OBJECT_CLASS (mahjongg_parent_class)->finalize (obj);
}

static GType
mahjongg_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MahjonggClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mahjongg_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Mahjongg), 0, (GInstanceInitFunc) mahjongg_instance_init, NULL };
	GType mahjongg_type_id;
	mahjongg_type_id = g_type_register_static (adw_application_get_type (), "Mahjongg", &g_define_type_info, 0);
	Mahjongg_private_offset = g_type_add_instance_private (mahjongg_type_id, sizeof (MahjonggPrivate));
	return mahjongg_type_id;
}

GType
mahjongg_get_type (void)
{
	static volatile gsize mahjongg_type_id__once = 0;
	if (g_once_init_enter (&mahjongg_type_id__once)) {
		GType mahjongg_type_id;
		mahjongg_type_id = mahjongg_get_type_once ();
		g_once_init_leave (&mahjongg_type_id__once, mahjongg_type_id);
	}
	return mahjongg_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

