/* game.c generated by valac 0.56.16, the Vala compiler
 * generated from game.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _TilePrivate TilePrivate;

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;
enum  {
	TILE_0_PROPERTY,
	TILE_SET_PROPERTY,
	TILE_NUM_PROPERTIES
};
static GParamSpec* tile_properties[TILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MATCH (match_get_type ())
#define MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATCH, Match))
#define MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATCH, MatchClass))
#define IS_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATCH))
#define IS_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATCH))
#define MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATCH, MatchClass))

typedef struct _Match Match;
typedef struct _MatchClass MatchClass;
typedef struct _MatchPrivate MatchPrivate;
enum  {
	MATCH_0_PROPERTY,
	MATCH_NUM_PROPERTIES
};
static GParamSpec* match_properties[MATCH_NUM_PROPERTIES];

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;
enum  {
	GAME_0_PROPERTY,
	GAME_STARTED_PROPERTY,
	GAME_ELAPSED_PROPERTY,
	GAME_PAUSED_PROPERTY,
	GAME_SELECTED_TILE_PROPERTY,
	GAME_VISIBLE_TILES_PROPERTY,
	GAME_MOVES_LEFT_PROPERTY,
	GAME_COMPLETE_PROPERTY,
	GAME_CAN_MOVE_PROPERTY,
	GAME_CAN_UNDO_PROPERTY,
	GAME_CAN_REDO_PROPERTY,
	GAME_NUM_PROPERTIES
};
static GParamSpec* game_properties[GAME_NUM_PROPERTIES];
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _MapPrivate MapPrivate;
typedef struct _SlotPrivate SlotPrivate;
enum  {
	GAME_REDRAW_TILE_SIGNAL,
	GAME_MOVED_SIGNAL,
	GAME_PAUSED_CHANGED_SIGNAL,
	GAME_TICK_SIGNAL,
	GAME_NUM_SIGNALS
};
static guint game_signals[GAME_NUM_SIGNALS] = {0};

struct _Tile {
	GObject parent_instance;
	TilePrivate * priv;
	gint number;
	Slot* slot;
	gboolean visible;
	gint move_number;
};

struct _TileClass {
	GObjectClass parent_class;
};

struct _Match {
	GObject parent_instance;
	MatchPrivate * priv;
	Tile* tile0;
	Tile* tile1;
};

struct _MatchClass {
	GObjectClass parent_class;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Map* map;
	GList* tiles;
	Tile* hint_tiles[2];
	gint move_number;
	guint hint_blink_counter;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GamePrivate {
	guint hint_timout;
	gdouble clock_elapsed;
	GTimer* clock;
	guint clock_timeout;
	gboolean _paused;
	Tile* _selected_tile;
};

struct _Map {
	GObject parent_instance;
	MapPrivate * priv;
	gchar* name;
	gchar* score_name;
	GList* slots;
};

struct _MapClass {
	GObjectClass parent_class;
};

struct _Slot {
	GObject parent_instance;
	SlotPrivate * priv;
	gint x;
	gint y;
	gint layer;
};

struct _SlotClass {
	GObjectClass parent_class;
};

static gpointer tile_parent_class = NULL;
static gpointer match_parent_class = NULL;
static gint Game_private_offset;
static gpointer game_parent_class = NULL;

VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tile, g_object_unref)
VALA_EXTERN GType slot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Slot, g_object_unref)
VALA_EXTERN Tile* tile_new (Slot* slot);
VALA_EXTERN Tile* tile_construct (GType object_type,
                      Slot* slot);
VALA_EXTERN gboolean tile_matches (Tile* self,
                       Tile* tile);
VALA_EXTERN gint tile_get_set (Tile* self);
static void tile_finalize (GObject * obj);
static GType tile_get_type_once (void);
static void _vala_tile_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
VALA_EXTERN gint compare_tiles (Tile* a,
                    Tile* b);
VALA_EXTERN gint compare_slots (Slot* a,
                    Slot* b);
VALA_EXTERN gboolean switch_tiles (Tile* a,
                       Tile* b);
VALA_EXTERN GType match_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Match, g_object_unref)
VALA_EXTERN Match* match_new (Tile* tile0,
                  Tile* tile1);
VALA_EXTERN Match* match_construct (GType object_type,
                        Tile* tile0,
                        Tile* tile1);
static void match_finalize (GObject * obj);
static GType match_get_type_once (void);
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
VALA_EXTERN GType map_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Map, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN Game* game_new (Map* map);
VALA_EXTERN Game* game_construct (GType object_type,
                      Map* map);
static gint _compare_tiles_gcompare_func (gconstpointer a,
                                   gconstpointer b);
static gboolean game_shuffle (Game* self,
                       gint* numbers,
                       gint numbers_length1,
                       gint depth);
VALA_EXTERN void game_reset (Game* self);
VALA_EXTERN void game_shuffle_remaining (Game* self,
                             gboolean redraw);
VALA_EXTERN gboolean game_get_can_move (Game* self);
VALA_EXTERN gint game_get_visible_tiles (Game* self);
VALA_EXTERN GList* game_find_matches (Game* self,
                          Tile* tile);
VALA_EXTERN void game_redraw_all_tiles (Game* self);
static void game_start_clock (Game* self);
static void game_reset_clock (Game* self);
VALA_EXTERN void game_set_selected_tile (Game* self,
                             Tile* value);
VALA_EXTERN void game_set_hint (Game* self,
                    Tile* tile0,
                    Tile* tile1);
static gboolean game_hint_timeout_cb (Game* self);
static gboolean _game_hint_timeout_cb_gsource_func (gpointer self);
VALA_EXTERN gboolean game_tile_can_move (Game* self,
                             Tile* tile);
VALA_EXTERN gint game_number_of_movable_tiles (Game* self);
VALA_EXTERN gboolean game_remove_pair (Game* self,
                           Tile* tile0,
                           Tile* tile1);
VALA_EXTERN gboolean game_get_complete (Game* self);
static void game_stop_clock (Game* self);
static gboolean game_timeout_cb (Game* self);
static void game_continue_clock (Game* self);
static gboolean _game_timeout_cb_gsource_func (gpointer self);
VALA_EXTERN void game_undo (Game* self);
VALA_EXTERN gboolean game_get_can_undo (Game* self);
VALA_EXTERN void game_redo (Game* self);
VALA_EXTERN gboolean game_get_can_redo (Game* self);
VALA_EXTERN gboolean game_get_started (Game* self);
VALA_EXTERN gdouble game_get_elapsed (Game* self);
VALA_EXTERN gboolean game_get_paused (Game* self);
VALA_EXTERN void game_set_paused (Game* self,
                      gboolean value);
VALA_EXTERN Tile* game_get_selected_tile (Game* self);
VALA_EXTERN guint game_get_moves_left (Game* self);
static void game_finalize (GObject * obj);
static GType game_get_type_once (void);
static void _vala_game_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_game_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Tile*
tile_construct (GType object_type,
                Slot* slot)
{
	Tile * self = NULL;
	Slot* _tmp0_;
	g_return_val_if_fail (slot != NULL, NULL);
	self = (Tile*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (slot);
	_g_object_unref0 (self->slot);
	self->slot = _tmp0_;
	return self;
}

Tile*
tile_new (Slot* slot)
{
	return tile_construct (TYPE_TILE, slot);
}

gboolean
tile_matches (Tile* self,
              Tile* tile)
{
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tile != NULL, FALSE);
	_tmp0_ = tile_get_set (tile);
	_tmp1_ = _tmp0_;
	_tmp2_ = tile_get_set (self);
	_tmp3_ = _tmp2_;
	result = _tmp1_ == _tmp3_;
	return result;
}

gint
tile_get_set (Tile* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->number / 4;
	return result;
}

static void
tile_class_init (TileClass * klass,
                 gpointer klass_data)
{
	tile_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_tile_get_property;
	G_OBJECT_CLASS (klass)->finalize = tile_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TILE_SET_PROPERTY, tile_properties[TILE_SET_PROPERTY] = g_param_spec_int ("set", "set", "set", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
tile_instance_init (Tile * self,
                    gpointer klass)
{
	self->visible = TRUE;
}

static void
tile_finalize (GObject * obj)
{
	Tile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TILE, Tile);
	_g_object_unref0 (self->slot);
	G_OBJECT_CLASS (tile_parent_class)->finalize (obj);
}

static GType
tile_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Tile), 0, (GInstanceInitFunc) tile_instance_init, NULL };
	GType tile_type_id;
	tile_type_id = g_type_register_static (G_TYPE_OBJECT, "Tile", &g_define_type_info, 0);
	return tile_type_id;
}

GType
tile_get_type (void)
{
	static volatile gsize tile_type_id__once = 0;
	if (g_once_init_enter (&tile_type_id__once)) {
		GType tile_type_id;
		tile_type_id = tile_get_type_once ();
		g_once_init_leave (&tile_type_id__once, tile_type_id);
	}
	return tile_type_id__once;
}

static void
_vala_tile_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Tile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TILE, Tile);
	switch (property_id) {
		case TILE_SET_PROPERTY:
		g_value_set_int (value, tile_get_set (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

gint
compare_tiles (Tile* a,
               Tile* b)
{
	Slot* _tmp0_;
	Slot* _tmp1_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a->slot;
	_tmp1_ = b->slot;
	result = compare_slots (_tmp0_, _tmp1_);
	return result;
}

gboolean
switch_tiles (Tile* a,
              Tile* b)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	if (a->visible) {
		_tmp0_ = b->visible;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		Slot* h = NULL;
		Slot* _tmp1_;
		Slot* _tmp2_;
		Slot* _tmp3_;
		Slot* _tmp4_;
		Slot* _tmp5_;
		Slot* _tmp6_;
		_tmp1_ = a->slot;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		h = _tmp2_;
		_tmp3_ = b->slot;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (a->slot);
		a->slot = _tmp4_;
		_tmp5_ = h;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (b->slot);
		b->slot = _tmp6_;
		result = TRUE;
		_g_object_unref0 (h);
		return result;
	}
	result = FALSE;
	return result;
}

Match*
match_construct (GType object_type,
                 Tile* tile0,
                 Tile* tile1)
{
	Match * self = NULL;
	Tile* _tmp0_;
	Tile* _tmp1_;
	g_return_val_if_fail (tile0 != NULL, NULL);
	g_return_val_if_fail (tile1 != NULL, NULL);
	self = (Match*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (tile0);
	_g_object_unref0 (self->tile0);
	self->tile0 = _tmp0_;
	_tmp1_ = _g_object_ref0 (tile1);
	_g_object_unref0 (self->tile1);
	self->tile1 = _tmp1_;
	return self;
}

Match*
match_new (Tile* tile0,
           Tile* tile1)
{
	return match_construct (TYPE_MATCH, tile0, tile1);
}

static void
match_class_init (MatchClass * klass,
                  gpointer klass_data)
{
	match_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = match_finalize;
}

static void
match_instance_init (Match * self,
                     gpointer klass)
{
}

static void
match_finalize (GObject * obj)
{
	Match * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATCH, Match);
	_g_object_unref0 (self->tile0);
	_g_object_unref0 (self->tile1);
	G_OBJECT_CLASS (match_parent_class)->finalize (obj);
}

static GType
match_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Match), 0, (GInstanceInitFunc) match_instance_init, NULL };
	GType match_type_id;
	match_type_id = g_type_register_static (G_TYPE_OBJECT, "Match", &g_define_type_info, 0);
	return match_type_id;
}

GType
match_get_type (void)
{
	static volatile gsize match_type_id__once = 0;
	if (g_once_init_enter (&match_type_id__once)) {
		GType match_type_id;
		match_type_id = match_get_type_once ();
		g_once_init_leave (&match_type_id__once, match_type_id);
	}
	return match_type_id__once;
}

static inline gpointer
game_get_instance_private (Game* self)
{
	return G_STRUCT_MEMBER_P (self, Game_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gint
_compare_tiles_gcompare_func (gconstpointer a,
                              gconstpointer b)
{
	gint result;
	result = compare_tiles ((Tile*) a, (Tile*) b);
	return result;
}

Game*
game_construct (GType object_type,
                Map* map)
{
	Game * self = NULL;
	Map* _tmp0_;
	GList* _tmp1_;
	gint n_pairs = 0;
	GList* _tmp8_;
	gint* numbers = NULL;
	gint* _tmp9_;
	gint numbers_length1;
	gint _numbers_size_;
	gint* _tmp21_;
	gint _tmp21__length1;
	g_return_val_if_fail (map != NULL, NULL);
	self = (Game*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (map);
	_g_object_unref0 (self->map);
	self->map = _tmp0_;
	self->move_number = 1;
	_tmp1_ = map->slots;
	{
		GList* slot_collection = NULL;
		GList* slot_it = NULL;
		slot_collection = _tmp1_;
		for (slot_it = slot_collection; slot_it != NULL; slot_it = slot_it->next) {
			Slot* _tmp2_;
			Slot* slot = NULL;
			_tmp2_ = _g_object_ref0 ((Slot*) slot_it->data);
			slot = _tmp2_;
			{
				Tile* tile = NULL;
				Slot* _tmp3_;
				Tile* _tmp4_;
				Tile* _tmp5_;
				Tile* _tmp6_;
				Tile* _tmp7_;
				_tmp3_ = slot;
				_tmp4_ = tile_new (_tmp3_);
				tile = _tmp4_;
				_tmp5_ = tile;
				_tmp5_->number = 0;
				_tmp6_ = tile;
				_tmp7_ = _g_object_ref0 (_tmp6_);
				self->tiles = g_list_insert_sorted (self->tiles, _tmp7_, _compare_tiles_gcompare_func);
				_g_object_unref0 (tile);
				_g_object_unref0 (slot);
			}
		}
	}
	_tmp8_ = self->tiles;
	n_pairs = ((gint) g_list_length (_tmp8_)) / 2;
	_tmp9_ = g_new0 (gint, n_pairs);
	numbers = _tmp9_;
	numbers_length1 = n_pairs;
	_numbers_size_ = numbers_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gint* _tmp12_;
				gint _tmp12__length1;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				if (!(i < n_pairs)) {
					break;
				}
				_tmp12_ = numbers;
				_tmp12__length1 = numbers_length1;
				_tmp12_[i] = i * 2;
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				gint32 n = 0;
				gint t = 0;
				gint* _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				gint* _tmp17_;
				gint _tmp17__length1;
				gint* _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				gint* _tmp20_;
				gint _tmp20__length1;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				if (!(i < n_pairs)) {
					break;
				}
				n = g_random_int_range ((gint32) i, (gint32) n_pairs);
				_tmp15_ = numbers;
				_tmp15__length1 = numbers_length1;
				_tmp16_ = _tmp15_[i];
				t = _tmp16_;
				_tmp17_ = numbers;
				_tmp17__length1 = numbers_length1;
				_tmp18_ = numbers;
				_tmp18__length1 = numbers_length1;
				_tmp19_ = _tmp18_[n];
				_tmp17_[i] = _tmp19_;
				_tmp20_ = numbers;
				_tmp20__length1 = numbers_length1;
				_tmp20_[n] = t;
			}
		}
	}
	_tmp21_ = numbers;
	_tmp21__length1 = numbers_length1;
	game_shuffle (self, _tmp21_, (gint) _tmp21__length1, 0);
	game_reset (self);
	numbers = (g_free (numbers), NULL);
	return self;
}

Game*
game_new (Map* map)
{
	return game_construct (TYPE_GAME, map);
}

void
game_shuffle_remaining (Game* self,
                        gboolean redraw)
{
	guint n = 0U;
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tiles;
	n = g_list_length (_tmp0_);
	{
		gboolean _tmp1_ = FALSE;
		_tmp1_ = TRUE;
		while (TRUE) {
			GList* _tmp13_;
			GList* _tmp16_;
			GList* _tmp17_;
			if (!_tmp1_) {
				gboolean _tmp2_ = FALSE;
				gboolean _tmp3_;
				gboolean _tmp4_;
				_tmp3_ = game_get_can_move (self);
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					gint _tmp6_;
					_tmp5_ = game_get_visible_tiles (self);
					_tmp6_ = _tmp5_;
					_tmp2_ = _tmp6_ > 1;
				} else {
					_tmp2_ = FALSE;
				}
				if (!_tmp2_) {
					break;
				}
			}
			_tmp1_ = FALSE;
			{
				guint i = 0U;
				i = n - 1;
				{
					gboolean _tmp7_ = FALSE;
					_tmp7_ = TRUE;
					while (TRUE) {
						gint j = 0;
						GList* _tmp9_;
						gconstpointer _tmp10_;
						GList* _tmp11_;
						gconstpointer _tmp12_;
						if (!_tmp7_) {
							guint _tmp8_;
							_tmp8_ = i;
							i = _tmp8_ - 1;
						}
						_tmp7_ = FALSE;
						if (!(i > ((guint) 0))) {
							break;
						}
						j = (gint) g_random_int_range ((gint32) 0, (gint32) (((gint) i) + 1));
						_tmp9_ = self->tiles;
						_tmp10_ = g_list_nth_data (_tmp9_, (guint) j);
						_tmp11_ = self->tiles;
						_tmp12_ = g_list_nth_data (_tmp11_, i);
						switch_tiles ((Tile*) _tmp10_, (Tile*) _tmp12_);
					}
				}
			}
			self->tiles = g_list_sort (self->tiles, _compare_tiles_gcompare_func);
			self->move_number = 1;
			_tmp13_ = self->tiles;
			{
				GList* tile_collection = NULL;
				GList* tile_it = NULL;
				tile_collection = _tmp13_;
				for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
					Tile* _tmp14_;
					Tile* tile = NULL;
					_tmp14_ = _g_object_ref0 ((Tile*) tile_it->data);
					tile = _tmp14_;
					{
						Tile* _tmp15_;
						_tmp15_ = tile;
						_tmp15_->move_number = 0;
						_g_object_unref0 (tile);
					}
				}
			}
			_tmp16_ = game_find_matches (self, NULL);
			_tmp17_ = _tmp16_;
			(_tmp17_ == NULL) ? NULL : (_tmp17_ = (_g_list_free__g_object_unref0_ (_tmp17_), NULL));
		}
	}
	g_signal_emit (self, game_signals[GAME_MOVED_SIGNAL], 0);
	if (redraw) {
		game_redraw_all_tiles (self);
	}
	game_start_clock (self);
	self->priv->clock_elapsed = self->priv->clock_elapsed + 60.0;
	g_signal_emit (self, game_signals[GAME_TICK_SIGNAL], 0);
}

void
game_redraw_all_tiles (Game* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp0_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp1_;
			Tile* tile = NULL;
			_tmp1_ = _g_object_ref0 ((Tile*) tile_it->data);
			tile = _tmp1_;
			{
				Tile* _tmp2_;
				_tmp2_ = tile;
				if (_tmp2_->visible) {
					Tile* _tmp3_;
					_tmp3_ = tile;
					g_signal_emit (self, game_signals[GAME_REDRAW_TILE_SIGNAL], 0, _tmp3_);
				}
				_g_object_unref0 (tile);
			}
		}
	}
}

static gboolean
game_shuffle (Game* self,
              gint* numbers,
              gint numbers_length1,
              gint depth)
{
	GList* _tmp0_;
	GList* matches = NULL;
	GList* _tmp1_;
	guint n_matches = 0U;
	GList* _tmp2_;
	gint32 n = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->tiles;
	if (((guint) depth) == (g_list_length (_tmp0_) / 2)) {
		result = TRUE;
		return result;
	}
	_tmp1_ = game_find_matches (self, NULL);
	matches = _tmp1_;
	_tmp2_ = matches;
	n_matches = g_list_length (_tmp2_);
	if (n_matches == ((guint) 0)) {
		result = FALSE;
		(matches == NULL) ? NULL : (matches = (_g_list_free__g_object_unref0_ (matches), NULL));
		return result;
	}
	n = g_random_int_range ((gint32) 0, (gint32) ((gint) n_matches));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				Match* match = NULL;
				GList* _tmp5_;
				gconstpointer _tmp6_;
				Match* _tmp7_;
				Match* _tmp8_;
				Tile* _tmp9_;
				gint _tmp10_;
				Match* _tmp11_;
				Tile* _tmp12_;
				Match* _tmp13_;
				Tile* _tmp14_;
				gint _tmp15_;
				Match* _tmp16_;
				Tile* _tmp17_;
				Match* _tmp18_;
				Tile* _tmp19_;
				Match* _tmp20_;
				Tile* _tmp21_;
				Match* _tmp22_;
				Tile* _tmp23_;
				Match* _tmp24_;
				Tile* _tmp25_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(((guint) i) < n_matches)) {
					break;
				}
				_tmp5_ = matches;
				_tmp6_ = g_list_nth_data (_tmp5_, (n + i) % n_matches);
				_tmp7_ = _g_object_ref0 ((Match*) _tmp6_);
				match = _tmp7_;
				_tmp8_ = match;
				_tmp9_ = _tmp8_->tile0;
				_tmp10_ = numbers[depth];
				_tmp9_->number = _tmp10_;
				_tmp11_ = match;
				_tmp12_ = _tmp11_->tile0;
				_tmp12_->visible = FALSE;
				_tmp13_ = match;
				_tmp14_ = _tmp13_->tile1;
				_tmp15_ = numbers[depth];
				_tmp14_->number = _tmp15_ + 1;
				_tmp16_ = match;
				_tmp17_ = _tmp16_->tile1;
				_tmp17_->visible = FALSE;
				if (game_shuffle (self, numbers, (gint) numbers_length1, depth + 1)) {
					result = TRUE;
					_g_object_unref0 (match);
					(matches == NULL) ? NULL : (matches = (_g_list_free__g_object_unref0_ (matches), NULL));
					return result;
				}
				_tmp18_ = match;
				_tmp19_ = _tmp18_->tile0;
				_tmp19_->number = 0;
				_tmp20_ = match;
				_tmp21_ = _tmp20_->tile0;
				_tmp21_->visible = TRUE;
				_tmp22_ = match;
				_tmp23_ = _tmp22_->tile1;
				_tmp23_->number = 0;
				_tmp24_ = match;
				_tmp25_ = _tmp24_->tile1;
				_tmp25_->visible = TRUE;
				_g_object_unref0 (match);
			}
		}
	}
	result = FALSE;
	(matches == NULL) ? NULL : (matches = (_g_list_free__g_object_unref0_ (matches), NULL));
	return result;
}

void
game_reset (Game* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	game_reset_clock (self);
	self->move_number = 1;
	game_set_selected_tile (self, NULL);
	game_set_hint (self, NULL, NULL);
	_tmp0_ = self->tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp0_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp1_;
			Tile* tile = NULL;
			_tmp1_ = _g_object_ref0 ((Tile*) tile_it->data);
			tile = _tmp1_;
			{
				Tile* _tmp2_;
				Tile* _tmp3_;
				_tmp2_ = tile;
				_tmp2_->visible = TRUE;
				_tmp3_ = tile;
				_tmp3_->move_number = 0;
				_g_object_unref0 (tile);
			}
		}
	}
	game_redraw_all_tiles (self);
}

static gboolean
_game_hint_timeout_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = game_hint_timeout_cb ((Game*) self);
	return result;
}

void
game_set_hint (Game* self,
               Tile* tile0,
               Tile* tile1)
{
	Tile* _tmp0_;
	Tile* _tmp2_;
	gboolean _tmp4_ = FALSE;
	Tile* _tmp5_;
	Tile* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->hint_tiles[0];
	if (_tmp0_ != NULL) {
		Tile* _tmp1_;
		_tmp1_ = self->hint_tiles[0];
		g_signal_emit (self, game_signals[GAME_REDRAW_TILE_SIGNAL], 0, _tmp1_);
	}
	_tmp2_ = self->hint_tiles[1];
	if (_tmp2_ != NULL) {
		Tile* _tmp3_;
		_tmp3_ = self->hint_tiles[1];
		g_signal_emit (self, game_signals[GAME_REDRAW_TILE_SIGNAL], 0, _tmp3_);
	}
	if (tile0 == NULL) {
		_tmp4_ = tile1 == NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		self->hint_blink_counter = (guint) 0;
		game_hint_timeout_cb (self);
		return;
	}
	_tmp5_ = _g_object_ref0 (tile0);
	_g_object_unref0 (self->hint_tiles[0]);
	self->hint_tiles[0] = _tmp5_;
	_tmp6_ = _g_object_ref0 (tile1);
	_g_object_unref0 (self->hint_tiles[1]);
	self->hint_tiles[1] = _tmp6_;
	self->hint_blink_counter = (guint) 6;
	if (self->priv->hint_timout != ((guint) 0)) {
		g_source_remove (self->priv->hint_timout);
	}
	self->priv->hint_timout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _game_hint_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
	game_hint_timeout_cb (self);
	game_start_clock (self);
	self->priv->clock_elapsed = self->priv->clock_elapsed + 30.0;
	g_signal_emit (self, game_signals[GAME_TICK_SIGNAL], 0);
}

static gboolean
game_hint_timeout_cb (Game* self)
{
	guint _tmp0_;
	Tile* _tmp1_;
	Tile* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->hint_blink_counter == ((guint) 0)) {
		if (self->priv->hint_timout != ((guint) 0)) {
			g_source_remove (self->priv->hint_timout);
		}
		self->priv->hint_timout = (guint) 0;
		result = FALSE;
		return result;
	}
	_tmp0_ = self->hint_blink_counter;
	self->hint_blink_counter = _tmp0_ - 1;
	_tmp1_ = self->hint_tiles[0];
	if (_tmp1_ != NULL) {
		Tile* _tmp2_;
		_tmp2_ = self->hint_tiles[0];
		g_signal_emit (self, game_signals[GAME_REDRAW_TILE_SIGNAL], 0, _tmp2_);
	}
	_tmp3_ = self->hint_tiles[1];
	if (_tmp3_ != NULL) {
		Tile* _tmp4_;
		_tmp4_ = self->hint_tiles[1];
		g_signal_emit (self, game_signals[GAME_REDRAW_TILE_SIGNAL], 0, _tmp4_);
	}
	result = TRUE;
	return result;
}

gboolean
game_tile_can_move (Game* self,
                    Tile* tile)
{
	gboolean blocked_left = FALSE;
	gboolean blocked_right = FALSE;
	Slot* slot = NULL;
	Slot* _tmp0_;
	Slot* _tmp1_;
	GList* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tile != NULL, FALSE);
	if (!tile->visible) {
		result = FALSE;
		return result;
	}
	blocked_left = FALSE;
	blocked_right = FALSE;
	_tmp0_ = tile->slot;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	slot = _tmp1_;
	_tmp2_ = self->tiles;
	{
		GList* t_collection = NULL;
		GList* t_it = NULL;
		t_collection = _tmp2_;
		for (t_it = t_collection; t_it != NULL; t_it = t_it->next) {
			Tile* _tmp3_;
			Tile* t = NULL;
			_tmp3_ = _g_object_ref0 ((Tile*) t_it->data);
			t = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				Tile* _tmp5_;
				Slot* s = NULL;
				Tile* _tmp7_;
				Slot* _tmp8_;
				Slot* _tmp9_;
				gboolean _tmp10_ = FALSE;
				gboolean _tmp11_ = FALSE;
				Slot* _tmp12_;
				Slot* _tmp13_;
				gboolean _tmp24_ = FALSE;
				Slot* _tmp25_;
				Slot* _tmp26_;
				_tmp5_ = t;
				if (_tmp5_ == tile) {
					_tmp4_ = TRUE;
				} else {
					Tile* _tmp6_;
					_tmp6_ = t;
					_tmp4_ = !_tmp6_->visible;
				}
				if (_tmp4_) {
					_g_object_unref0 (t);
					continue;
				}
				_tmp7_ = t;
				_tmp8_ = _tmp7_->slot;
				_tmp9_ = _g_object_ref0 (_tmp8_);
				s = _tmp9_;
				_tmp12_ = s;
				_tmp13_ = slot;
				if (_tmp12_->layer == (_tmp13_->layer + 1)) {
					gboolean _tmp14_ = FALSE;
					Slot* _tmp15_;
					Slot* _tmp16_;
					_tmp15_ = s;
					_tmp16_ = slot;
					if (_tmp15_->x >= (_tmp16_->x - 1)) {
						Slot* _tmp17_;
						Slot* _tmp18_;
						_tmp17_ = s;
						_tmp18_ = slot;
						_tmp14_ = _tmp17_->x <= (_tmp18_->x + 1);
					} else {
						_tmp14_ = FALSE;
					}
					_tmp11_ = _tmp14_;
				} else {
					_tmp11_ = FALSE;
				}
				if (_tmp11_) {
					gboolean _tmp19_ = FALSE;
					Slot* _tmp20_;
					Slot* _tmp21_;
					_tmp20_ = s;
					_tmp21_ = slot;
					if (_tmp20_->y >= (_tmp21_->y - 1)) {
						Slot* _tmp22_;
						Slot* _tmp23_;
						_tmp22_ = s;
						_tmp23_ = slot;
						_tmp19_ = _tmp22_->y <= (_tmp23_->y + 1);
					} else {
						_tmp19_ = FALSE;
					}
					_tmp10_ = _tmp19_;
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					result = FALSE;
					_g_object_unref0 (s);
					_g_object_unref0 (t);
					_g_object_unref0 (slot);
					return result;
				}
				_tmp25_ = s;
				_tmp26_ = slot;
				if (_tmp25_->layer == _tmp26_->layer) {
					gboolean _tmp27_ = FALSE;
					Slot* _tmp28_;
					Slot* _tmp29_;
					_tmp28_ = s;
					_tmp29_ = slot;
					if (_tmp28_->y >= (_tmp29_->y - 1)) {
						Slot* _tmp30_;
						Slot* _tmp31_;
						_tmp30_ = s;
						_tmp31_ = slot;
						_tmp27_ = _tmp30_->y <= (_tmp31_->y + 1);
					} else {
						_tmp27_ = FALSE;
					}
					_tmp24_ = _tmp27_;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					Slot* _tmp32_;
					Slot* _tmp33_;
					Slot* _tmp34_;
					Slot* _tmp35_;
					gboolean _tmp36_ = FALSE;
					_tmp32_ = s;
					_tmp33_ = slot;
					if (_tmp32_->x == (_tmp33_->x - 2)) {
						blocked_left = TRUE;
					}
					_tmp34_ = s;
					_tmp35_ = slot;
					if (_tmp34_->x == (_tmp35_->x + 2)) {
						blocked_right = TRUE;
					}
					if (blocked_left) {
						_tmp36_ = blocked_right;
					} else {
						_tmp36_ = FALSE;
					}
					if (_tmp36_) {
						result = FALSE;
						_g_object_unref0 (s);
						_g_object_unref0 (t);
						_g_object_unref0 (slot);
						return result;
					}
				}
				_g_object_unref0 (s);
				_g_object_unref0 (t);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (slot);
	return result;
}

gint
game_number_of_movable_tiles (Game* self)
{
	gint count = 0;
	GList* _tmp0_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	count = 0;
	_tmp0_ = self->tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp0_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp1_;
			Tile* tile = NULL;
			_tmp1_ = _g_object_ref0 ((Tile*) tile_it->data);
			tile = _tmp1_;
			{
				Tile* _tmp2_;
				_tmp2_ = tile;
				if (game_tile_can_move (self, _tmp2_)) {
					gint _tmp3_;
					_tmp3_ = count;
					count = _tmp3_ + 1;
				}
				_g_object_unref0 (tile);
			}
		}
	}
	result = count;
	return result;
}

GList*
game_find_matches (Game* self,
                   Tile* tile)
{
	GList* matches = NULL;
	gboolean _tmp0_ = FALSE;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	matches = NULL;
	if (tile != NULL) {
		_tmp0_ = !game_tile_can_move (self, tile);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = matches;
		return result;
	}
	if (tile == NULL) {
		GList* _tmp1_;
		_tmp1_ = self->tiles;
		{
			GList* t_collection = NULL;
			GList* t_it = NULL;
			t_collection = _tmp1_;
			for (t_it = t_collection; t_it != NULL; t_it = t_it->next) {
				Tile* _tmp2_;
				Tile* t = NULL;
				_tmp2_ = _g_object_ref0 ((Tile*) t_it->data);
				t = _tmp2_;
				{
					Tile* _tmp3_;
					GList* _tmp4_;
					_tmp3_ = t;
					_tmp4_ = game_find_matches (self, _tmp3_);
					{
						GList* match_collection = NULL;
						GList* match_it = NULL;
						match_collection = _tmp4_;
						for (match_it = match_collection; match_it != NULL; match_it = match_it->next) {
							Match* _tmp5_;
							Match* match = NULL;
							_tmp5_ = _g_object_ref0 ((Match*) match_it->data);
							match = _tmp5_;
							{
								gboolean already_matched = FALSE;
								GList* _tmp6_;
								already_matched = FALSE;
								_tmp6_ = matches;
								{
									GList* existing_match_collection = NULL;
									GList* existing_match_it = NULL;
									existing_match_collection = _tmp6_;
									for (existing_match_it = existing_match_collection; existing_match_it != NULL; existing_match_it = existing_match_it->next) {
										Match* _tmp7_;
										Match* existing_match = NULL;
										_tmp7_ = _g_object_ref0 ((Match*) existing_match_it->data);
										existing_match = _tmp7_;
										{
											gboolean _tmp8_ = FALSE;
											Match* _tmp9_;
											Tile* _tmp10_;
											Match* _tmp11_;
											Tile* _tmp12_;
											_tmp9_ = existing_match;
											_tmp10_ = _tmp9_->tile0;
											_tmp11_ = match;
											_tmp12_ = _tmp11_->tile1;
											if (_tmp10_ == _tmp12_) {
												Match* _tmp13_;
												Tile* _tmp14_;
												Match* _tmp15_;
												Tile* _tmp16_;
												_tmp13_ = existing_match;
												_tmp14_ = _tmp13_->tile1;
												_tmp15_ = match;
												_tmp16_ = _tmp15_->tile0;
												_tmp8_ = _tmp14_ == _tmp16_;
											} else {
												_tmp8_ = FALSE;
											}
											if (_tmp8_) {
												already_matched = TRUE;
												_g_object_unref0 (existing_match);
												break;
											}
											_g_object_unref0 (existing_match);
										}
									}
								}
								if (!already_matched) {
									Match* _tmp17_;
									Match* _tmp18_;
									_tmp17_ = match;
									_tmp18_ = _g_object_ref0 (_tmp17_);
									matches = g_list_append (matches, _tmp18_);
								}
								_g_object_unref0 (match);
							}
						}
						(match_collection == NULL) ? NULL : (match_collection = (_g_list_free__g_object_unref0_ (match_collection), NULL));
					}
					_g_object_unref0 (t);
				}
			}
		}
	} else {
		GList* _tmp19_;
		_tmp19_ = self->tiles;
		{
			GList* t_collection = NULL;
			GList* t_it = NULL;
			t_collection = _tmp19_;
			for (t_it = t_collection; t_it != NULL; t_it = t_it->next) {
				Tile* _tmp20_;
				Tile* t = NULL;
				_tmp20_ = _g_object_ref0 ((Tile*) t_it->data);
				t = _tmp20_;
				{
					gboolean _tmp21_ = FALSE;
					Tile* _tmp22_;
					Tile* _tmp24_;
					_tmp22_ = t;
					if (_tmp22_ == tile) {
						_tmp21_ = TRUE;
					} else {
						Tile* _tmp23_;
						_tmp23_ = t;
						_tmp21_ = !game_tile_can_move (self, _tmp23_);
					}
					if (_tmp21_) {
						_g_object_unref0 (t);
						continue;
					}
					_tmp24_ = t;
					if (tile_matches (_tmp24_, tile)) {
						Tile* _tmp25_;
						Match* _tmp26_;
						_tmp25_ = t;
						_tmp26_ = match_new (_tmp25_, tile);
						matches = g_list_append (matches, _tmp26_);
					}
					_g_object_unref0 (t);
				}
			}
		}
	}
	result = matches;
	return result;
}

gboolean
game_remove_pair (Game* self,
                  Tile* tile0,
                  Tile* tile1)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GList* _tmp5_;
	gint _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tile0 != NULL, FALSE);
	g_return_val_if_fail (tile1 != NULL, FALSE);
	if (!tile0->visible) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !tile1->visible;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = tile_get_set (tile0);
	_tmp2_ = _tmp1_;
	_tmp3_ = tile_get_set (tile1);
	_tmp4_ = _tmp3_;
	if (_tmp2_ != _tmp4_) {
		result = FALSE;
		return result;
	}
	game_set_selected_tile (self, NULL);
	game_set_hint (self, NULL, NULL);
	_tmp5_ = self->tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp5_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp6_;
			Tile* tile = NULL;
			_tmp6_ = _g_object_ref0 ((Tile*) tile_it->data);
			tile = _tmp6_;
			{
				Tile* _tmp7_;
				_tmp7_ = tile;
				if (_tmp7_->move_number >= self->move_number) {
					Tile* _tmp8_;
					_tmp8_ = tile;
					_tmp8_->move_number = 0;
				}
				_g_object_unref0 (tile);
			}
		}
	}
	tile0->visible = FALSE;
	tile0->move_number = self->move_number;
	tile1->visible = FALSE;
	tile1->move_number = self->move_number;
	_tmp9_ = self->move_number;
	self->move_number = _tmp9_ + 1;
	g_signal_emit (self, game_signals[GAME_REDRAW_TILE_SIGNAL], 0, tile0);
	g_signal_emit (self, game_signals[GAME_REDRAW_TILE_SIGNAL], 0, tile1);
	_tmp10_ = game_get_complete (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_) {
		game_stop_clock (self);
	} else {
		game_start_clock (self);
	}
	g_signal_emit (self, game_signals[GAME_MOVED_SIGNAL], 0);
	result = TRUE;
	return result;
}

static void
game_start_clock (Game* self)
{
	GTimer* _tmp0_;
	GTimer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->clock);
	self->priv->clock = _tmp1_;
	game_timeout_cb (self);
}

static void
game_stop_clock (Game* self)
{
	GTimer* _tmp0_;
	GTimer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		return;
	}
	if (self->priv->clock_timeout != ((guint) 0)) {
		g_source_remove (self->priv->clock_timeout);
	}
	self->priv->clock_timeout = (guint) 0;
	_tmp1_ = self->priv->clock;
	g_timer_stop (_tmp1_);
	g_signal_emit (self, game_signals[GAME_TICK_SIGNAL], 0);
}

static void
game_continue_clock (Game* self)
{
	GTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		GTimer* _tmp1_;
		_tmp1_ = g_timer_new ();
		_g_timer_destroy0 (self->priv->clock);
		self->priv->clock = _tmp1_;
	} else {
		GTimer* _tmp2_;
		_tmp2_ = self->priv->clock;
		g_timer_continue (_tmp2_);
	}
	game_timeout_cb (self);
}

static void
game_reset_clock (Game* self)
{
	g_return_if_fail (self != NULL);
	game_stop_clock (self);
	_g_timer_destroy0 (self->priv->clock);
	self->priv->clock = NULL;
	self->priv->clock_elapsed = 0.0;
	g_signal_emit (self, game_signals[GAME_TICK_SIGNAL], 0);
}

static gboolean
_game_timeout_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = game_timeout_cb ((Game*) self);
	return result;
}

static gboolean
game_timeout_cb (Game* self)
{
	GTimer* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ != NULL) {
		gdouble elapsed = 0.0;
		GTimer* _tmp1_;
		gint next = 0;
		gdouble wait = 0.0;
		_tmp1_ = self->priv->clock;
		elapsed = g_timer_elapsed (_tmp1_, NULL);
		next = (gint) (elapsed + 1.0);
		wait = next - elapsed;
		self->priv->clock_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((gint) (wait * 1000)), _game_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
		g_signal_emit (self, game_signals[GAME_TICK_SIGNAL], 0);
	}
	result = FALSE;
	return result;
}

void
game_undo (Game* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_;
	GList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_get_can_undo (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	game_set_selected_tile (self, NULL);
	game_set_hint (self, NULL, NULL);
	_tmp2_ = self->move_number;
	self->move_number = _tmp2_ - 1;
	_tmp3_ = self->tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp3_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp4_;
			Tile* tile = NULL;
			_tmp4_ = _g_object_ref0 ((Tile*) tile_it->data);
			tile = _tmp4_;
			{
				Tile* _tmp5_;
				_tmp5_ = tile;
				if (_tmp5_->move_number == self->move_number) {
					Tile* _tmp6_;
					Tile* _tmp7_;
					_tmp6_ = tile;
					_tmp6_->visible = TRUE;
					_tmp7_ = tile;
					g_signal_emit (self, game_signals[GAME_REDRAW_TILE_SIGNAL], 0, _tmp7_);
				}
				_g_object_unref0 (tile);
			}
		}
	}
}

void
game_redo (Game* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GList* _tmp2_;
	gint _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_get_can_redo (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	game_set_selected_tile (self, NULL);
	game_set_hint (self, NULL, NULL);
	_tmp2_ = self->tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp2_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp3_;
			Tile* tile = NULL;
			_tmp3_ = _g_object_ref0 ((Tile*) tile_it->data);
			tile = _tmp3_;
			{
				Tile* _tmp4_;
				_tmp4_ = tile;
				if (_tmp4_->move_number == self->move_number) {
					Tile* _tmp5_;
					Tile* _tmp6_;
					_tmp5_ = tile;
					_tmp5_->visible = FALSE;
					_tmp6_ = tile;
					g_signal_emit (self, game_signals[GAME_REDRAW_TILE_SIGNAL], 0, _tmp6_);
				}
				_g_object_unref0 (tile);
			}
		}
	}
	_tmp7_ = self->move_number;
	self->move_number = _tmp7_ + 1;
}

gboolean
game_get_started (Game* self)
{
	gboolean result;
	GTimer* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->clock;
	result = _tmp0_ != NULL;
	return result;
}

gdouble
game_get_elapsed (Game* self)
{
	gdouble result;
	GTimer* _tmp0_;
	GTimer* _tmp1_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->clock;
	if (_tmp0_ == NULL) {
		result = 0.0;
		return result;
	}
	_tmp1_ = self->priv->clock;
	result = self->priv->clock_elapsed + g_timer_elapsed (_tmp1_, NULL);
	return result;
}

gboolean
game_get_paused (Game* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_paused;
	return result;
}

void
game_set_paused (Game* self,
                 gboolean value)
{
	GTimer* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_paused = value;
	_tmp0_ = self->priv->clock;
	if (_tmp0_ != NULL) {
		if (value) {
			game_stop_clock (self);
		} else {
			game_continue_clock (self);
		}
	}
	g_signal_emit (self, game_signals[GAME_PAUSED_CHANGED_SIGNAL], 0);
	g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_PAUSED_PROPERTY]);
}

Tile*
game_get_selected_tile (Game* self)
{
	Tile* result;
	Tile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_selected_tile;
	result = _tmp0_;
	return result;
}

void
game_set_selected_tile (Game* self,
                        Tile* value)
{
	Tile* _tmp0_;
	Tile* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_selected_tile;
	if (_tmp0_ != NULL) {
		Tile* _tmp1_;
		_tmp1_ = self->priv->_selected_tile;
		g_signal_emit (self, game_signals[GAME_REDRAW_TILE_SIGNAL], 0, _tmp1_);
	}
	_tmp2_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_selected_tile);
	self->priv->_selected_tile = _tmp2_;
	if (value != NULL) {
		g_signal_emit (self, game_signals[GAME_REDRAW_TILE_SIGNAL], 0, value);
	}
	g_object_notify_by_pspec ((GObject *) self, game_properties[GAME_SELECTED_TILE_PROPERTY]);
}

gint
game_get_visible_tiles (Game* self)
{
	gint result;
	gint n = 0;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	_tmp0_ = self->tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp0_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp1_;
			Tile* tile = NULL;
			_tmp1_ = _g_object_ref0 ((Tile*) tile_it->data);
			tile = _tmp1_;
			{
				Tile* _tmp2_;
				_tmp2_ = tile;
				if (_tmp2_->visible) {
					gint _tmp3_;
					_tmp3_ = n;
					n = _tmp3_ + 1;
				}
				_g_object_unref0 (tile);
			}
		}
	}
	result = n;
	return result;
}

guint
game_get_moves_left (Game* self)
{
	guint result;
	GList* _tmp0_;
	GList* _tmp1_;
	guint _tmp2_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = game_find_matches (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_list_length (_tmp1_);
	(_tmp1_ == NULL) ? NULL : (_tmp1_ = (_g_list_free__g_object_unref0_ (_tmp1_), NULL));
	result = _tmp2_;
	return result;
}

gboolean
game_get_complete (Game* self)
{
	gboolean result;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_get_visible_tiles (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ == 0;
	return result;
}

gboolean
game_get_can_move (Game* self)
{
	gboolean result;
	guint _tmp0_;
	guint _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_get_moves_left (self);
	_tmp1_ = _tmp0_;
	result = _tmp1_ != ((guint) 0);
	return result;
}

gboolean
game_get_can_undo (Game* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->move_number > 1;
	return result;
}

gboolean
game_get_can_redo (Game* self)
{
	gboolean result;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp0_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp1_;
			Tile* tile = NULL;
			_tmp1_ = _g_object_ref0 ((Tile*) tile_it->data);
			tile = _tmp1_;
			{
				Tile* _tmp2_;
				_tmp2_ = tile;
				if (_tmp2_->move_number >= self->move_number) {
					result = TRUE;
					_g_object_unref0 (tile);
					return result;
				}
				_g_object_unref0 (tile);
			}
		}
	}
	result = FALSE;
	return result;
}

static void
game_class_init (GameClass * klass,
                 gpointer klass_data)
{
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Game_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_STARTED_PROPERTY, game_properties[GAME_STARTED_PROPERTY] = g_param_spec_boolean ("started", "started", "started", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_ELAPSED_PROPERTY, game_properties[GAME_ELAPSED_PROPERTY] = g_param_spec_double ("elapsed", "elapsed", "elapsed", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_PAUSED_PROPERTY, game_properties[GAME_PAUSED_PROPERTY] = g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SELECTED_TILE_PROPERTY, game_properties[GAME_SELECTED_TILE_PROPERTY] = g_param_spec_object ("selected-tile", "selected-tile", "selected-tile", TYPE_TILE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VISIBLE_TILES_PROPERTY, game_properties[GAME_VISIBLE_TILES_PROPERTY] = g_param_spec_int ("visible-tiles", "visible-tiles", "visible-tiles", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_MOVES_LEFT_PROPERTY, game_properties[GAME_MOVES_LEFT_PROPERTY] = g_param_spec_uint ("moves-left", "moves-left", "moves-left", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_COMPLETE_PROPERTY, game_properties[GAME_COMPLETE_PROPERTY] = g_param_spec_boolean ("complete", "complete", "complete", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CAN_MOVE_PROPERTY, game_properties[GAME_CAN_MOVE_PROPERTY] = g_param_spec_boolean ("can-move", "can-move", "can-move", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CAN_UNDO_PROPERTY, game_properties[GAME_CAN_UNDO_PROPERTY] = g_param_spec_boolean ("can-undo", "can-undo", "can-undo", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_CAN_REDO_PROPERTY, game_properties[GAME_CAN_REDO_PROPERTY] = g_param_spec_boolean ("can-redo", "can-redo", "can-redo", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	game_signals[GAME_REDRAW_TILE_SIGNAL] = g_signal_new ("redraw-tile", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_TILE);
	game_signals[GAME_MOVED_SIGNAL] = g_signal_new ("moved", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_PAUSED_CHANGED_SIGNAL] = g_signal_new ("paused-changed", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_signals[GAME_TICK_SIGNAL] = g_signal_new ("tick", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
game_instance_init (Game * self,
                    gpointer klass)
{
	self->priv = game_get_instance_private (self);
	self->tiles = NULL;
	self->priv->hint_timout = (guint) 0;
	self->hint_blink_counter = (guint) 0;
	self->priv->_paused = FALSE;
	self->priv->_selected_tile = NULL;
}

static void
game_finalize (GObject * obj)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	_g_object_unref0 (self->map);
	(self->tiles == NULL) ? NULL : (self->tiles = (_g_list_free__g_object_unref0_ (self->tiles), NULL));
	_vala_array_destroy (self->hint_tiles, 2, (GDestroyNotify) g_object_unref);
	_g_timer_destroy0 (self->priv->clock);
	_g_object_unref0 (self->priv->_selected_tile);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}

static GType
game_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
	GType game_type_id;
	game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
	Game_private_offset = g_type_add_instance_private (game_type_id, sizeof (GamePrivate));
	return game_type_id;
}

GType
game_get_type (void)
{
	static volatile gsize game_type_id__once = 0;
	if (g_once_init_enter (&game_type_id__once)) {
		GType game_type_id;
		game_type_id = game_get_type_once ();
		g_once_init_leave (&game_type_id__once, game_type_id);
	}
	return game_type_id__once;
}

static void
_vala_game_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_STARTED_PROPERTY:
		g_value_set_boolean (value, game_get_started (self));
		break;
		case GAME_ELAPSED_PROPERTY:
		g_value_set_double (value, game_get_elapsed (self));
		break;
		case GAME_PAUSED_PROPERTY:
		g_value_set_boolean (value, game_get_paused (self));
		break;
		case GAME_SELECTED_TILE_PROPERTY:
		g_value_set_object (value, game_get_selected_tile (self));
		break;
		case GAME_VISIBLE_TILES_PROPERTY:
		g_value_set_int (value, game_get_visible_tiles (self));
		break;
		case GAME_MOVES_LEFT_PROPERTY:
		g_value_set_uint (value, game_get_moves_left (self));
		break;
		case GAME_COMPLETE_PROPERTY:
		g_value_set_boolean (value, game_get_complete (self));
		break;
		case GAME_CAN_MOVE_PROPERTY:
		g_value_set_boolean (value, game_get_can_move (self));
		break;
		case GAME_CAN_UNDO_PROPERTY:
		g_value_set_boolean (value, game_get_can_undo (self));
		break;
		case GAME_CAN_REDO_PROPERTY:
		g_value_set_boolean (value, game_get_can_redo (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_PAUSED_PROPERTY:
		game_set_paused (self, g_value_get_boolean (value));
		break;
		case GAME_SELECTED_TILE_PROPERTY:
		game_set_selected_tile (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

