/* game-view.c generated by valac 0.56.16, the Vala compiler
 * generated from game-view.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
enum  {
	GAME_VIEW_0_PROPERTY,
	GAME_VIEW_GAME_PROPERTY,
	GAME_VIEW_THEME_PROPERTY,
	GAME_VIEW_NUM_PROPERTIES
};
static GParamSpec* game_view_properties[GAME_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef struct _GamePrivate GamePrivate;

#define TYPE_MAP (map_get_type ())
#define MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAP, Map))
#define MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAP, MapClass))
#define IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAP))
#define IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAP))
#define MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAP, MapClass))

typedef struct _Map Map;
typedef struct _MapClass MapClass;

#define TYPE_TILE (tile_get_type ())
#define TILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TILE, Tile))
#define TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TILE, TileClass))
#define IS_TILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TILE))
#define IS_TILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TILE))
#define TILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TILE, TileClass))

typedef struct _Tile Tile;
typedef struct _TileClass TileClass;
typedef struct _TilePrivate TilePrivate;

#define TYPE_SLOT (slot_get_type ())
#define SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SLOT, Slot))
#define SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SLOT, SlotClass))
#define IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SLOT))
#define IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SLOT))
#define SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SLOT, SlotClass))

typedef struct _Slot Slot;
typedef struct _SlotClass SlotClass;
typedef struct _SlotPrivate SlotPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
	GdkRGBA background_color;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameViewPrivate {
	gint tile_pattern_width;
	gint tile_pattern_height;
	gint x_offset;
	gint y_offset;
	gint tile_width;
	gint tile_height;
	gint tile_layer_offset_x;
	gint tile_layer_offset_y;
	gint theme_width;
	gint theme_height;
	gdouble theme_aspect;
	RsvgHandle* theme_handle;
	cairo_pattern_t* tile_pattern;
	guint theme_resize_timer;
	guint theme_timer_id;
	GtkGestureClick* click_controller;
	Game* _game;
	gchar* _theme;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Map* map;
	GList* tiles;
	Tile* hint_tiles[2];
	gint move_number;
	guint hint_blink_counter;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _Tile {
	GObject parent_instance;
	TilePrivate * priv;
	gint number;
	Slot* slot;
	gboolean visible;
	gint move_number;
};

struct _TileClass {
	GObjectClass parent_class;
};

struct _Slot {
	GObject parent_instance;
	SlotPrivate * priv;
	gint x;
	gint y;
	gint layer;
};

struct _SlotClass {
	GObjectClass parent_class;
};

static gint GameView_private_offset;
static gpointer game_view_parent_class = NULL;

VALA_EXTERN GType game_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameView, g_object_unref)
VALA_EXTERN GType game_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Game, g_object_unref)
static void game_view_real_size_allocate (GtkWidget* base,
                                   gint width,
                                   gint height,
                                   gint baseline);
static void game_view_update_dimensions (GameView* self);
static gboolean ___lambda4_ (GameView* self);
static void game_view_resize_theme (GameView* self);
static gboolean ____lambda4__gsource_func (gpointer self);
VALA_EXTERN void game_view_set_background (GameView* self,
                               const gchar* colour);
static void game_view_draw_game (GameView* self,
                          cairo_t* cr,
                          gboolean render_indexes);
VALA_EXTERN const gchar* game_view_get_theme (GameView* self);
VALA_EXTERN Game* game_view_get_game (GameView* self);
VALA_EXTERN GType map_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Map, g_object_unref)
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tile, g_object_unref)
VALA_EXTERN GType slot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Slot, g_object_unref)
static void game_view_get_tile_position (GameView* self,
                                  Tile* tile,
                                  gint* x,
                                  gint* y);
VALA_EXTERN gboolean game_get_paused (Game* self);
static gint game_view_get_image_offset (GameView* self,
                                 gint number);
VALA_EXTERN Tile* game_get_selected_tile (Game* self);
VALA_EXTERN guint map_get_width (Map* self);
VALA_EXTERN guint map_get_height (Map* self);
static void game_view_redraw_tile_cb (GameView* self,
                               Tile* tile);
static void game_view_paused_changed_cb (GameView* self);
VALA_EXTERN void game_view_draw_func (GameView* self,
                          GtkDrawingArea* area,
                          cairo_t* cr,
                          gint width,
                          gint height);
static inline void game_view_init_mouse (GameView* self);
static inline void game_view_on_click (GameView* self,
                         GtkGestureClick* _click_controller,
                         gint n_press,
                         gdouble event_x,
                         gdouble event_y);
static void _game_view_on_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                    gint n_press,
                                                    gdouble x,
                                                    gdouble y,
                                                    gpointer self);
static Tile* game_view_find_tile (GameView* self,
                           gdouble x,
                           gdouble y);
VALA_EXTERN gboolean game_tile_can_move (Game* self,
                             Tile* tile);
VALA_EXTERN void game_set_selected_tile (Game* self,
                             Tile* value);
VALA_EXTERN gboolean tile_matches (Tile* self,
                       Tile* tile);
VALA_EXTERN gboolean game_remove_pair (Game* self,
                           Tile* tile0,
                           Tile* tile1);
VALA_EXTERN GameView* game_view_new (void);
VALA_EXTERN GameView* game_view_construct (GType object_type);
VALA_EXTERN void game_view_set_game (GameView* self,
                         Game* value);
static void _game_view_redraw_tile_cb_game_redraw_tile (Game* _sender,
                                                 Tile* tile,
                                                 gpointer self);
static void _game_view_paused_changed_cb_game_paused_changed (Game* _sender,
                                                       gpointer self);
VALA_EXTERN void game_view_set_theme (GameView* self,
                          const gchar* value);
static GObject * game_view_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties);
static void _game_view_draw_func_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                      cairo_t* cr,
                                                      gint width,
                                                      gint height,
                                                      gpointer self);
static void game_view_finalize (GObject * obj);
static GType game_view_get_type_once (void);
static void _vala_game_view_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec);

static inline gpointer
game_view_get_instance_private (GameView* self)
{
	return G_STRUCT_MEMBER_P (self, GameView_private_offset);
}

static gboolean
___lambda4_ (GameView* self)
{
	guint _tmp0_;
	gboolean result;
	if (self->priv->theme_resize_timer == ((guint) 0)) {
		game_view_resize_theme (self);
		self->priv->theme_timer_id = (guint) 0;
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->theme_resize_timer;
	self->priv->theme_resize_timer = _tmp0_ - 1;
	result = TRUE;
	return result;
}

static gboolean
____lambda4__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda4_ ((GameView*) self);
	return result;
}

static void
game_view_real_size_allocate (GtkWidget* base,
                              gint width,
                              gint height,
                              gint baseline)
{
	GameView * self;
	RsvgHandle* _tmp0_;
	self = (GameView*) base;
	game_view_update_dimensions (self);
	if (self->priv->theme_timer_id != ((guint) 0)) {
		g_source_remove (self->priv->theme_timer_id);
		self->priv->theme_timer_id = (guint) 0;
	}
	_tmp0_ = self->priv->theme_handle;
	if (_tmp0_ != NULL) {
		self->priv->theme_resize_timer = (guint) 2;
		self->priv->theme_timer_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ____lambda4__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
game_view_resize_theme (GameView* self)
{
	RsvgHandle* _tmp0_;
	gint rendered_theme_width = 0;
	cairo_surface_t* theme_surface = NULL;
	GtkNative* _tmp4_;
	GdkSurface* _tmp5_;
	cairo_surface_t* _tmp6_;
	cairo_t* ctx = NULL;
	cairo_surface_t* _tmp7_;
	cairo_t* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->theme_handle;
	if (_tmp0_ == NULL) {
		return;
	}
	rendered_theme_width = (self->priv->tile_width + self->priv->tile_layer_offset_x) * 43;
	if (self->priv->theme_width >= rendered_theme_width) {
		gdouble width = 0.0;
		gdouble height = 0.0;
		RsvgHandle* _tmp1_;
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		_tmp1_ = self->priv->theme_handle;
		rsvg_handle_get_intrinsic_size_in_pixels (_tmp1_, &_tmp2_, &_tmp3_);
		width = _tmp2_;
		height = _tmp3_;
		self->priv->theme_width = (gint) width;
		self->priv->theme_height = (gint) height;
	}
	while (TRUE) {
		if (!(self->priv->theme_width < rendered_theme_width)) {
			break;
		}
		self->priv->theme_width = self->priv->theme_width + self->priv->theme_width;
		self->priv->theme_height = self->priv->theme_height + self->priv->theme_height;
	}
	_tmp4_ = gtk_widget_get_native ((GtkWidget*) self);
	_tmp5_ = gtk_native_get_surface (_tmp4_);
	_tmp6_ = gdk_surface_create_similar_surface (_tmp5_, CAIRO_CONTENT_COLOR_ALPHA, self->priv->theme_width, self->priv->theme_height);
	theme_surface = _tmp6_;
	_tmp7_ = theme_surface;
	_tmp8_ = cairo_create (_tmp7_);
	ctx = _tmp8_;
	{
		RsvgHandle* _tmp9_;
		cairo_t* _tmp10_;
		RsvgRectangle _tmp11_ = {0};
		cairo_surface_t* _tmp12_;
		cairo_pattern_t* _tmp13_;
		_tmp9_ = self->priv->theme_handle;
		_tmp10_ = ctx;
		_tmp11_.x = (gdouble) 0;
		_tmp11_.y = (gdouble) 0;
		_tmp11_.width = (gdouble) self->priv->theme_width;
		_tmp11_.height = (gdouble) self->priv->theme_height;
		rsvg_handle_render_document (_tmp9_, _tmp10_, &_tmp11_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp12_ = theme_surface;
		_tmp13_ = cairo_pattern_create_for_surface (_tmp12_);
		_cairo_pattern_destroy0 (self->priv->tile_pattern);
		self->priv->tile_pattern = _tmp13_;
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("game-view.vala:159: Could not upscale theme");
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_cairo_destroy0 (ctx);
		_cairo_surface_destroy0 (theme_surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_cairo_destroy0 (ctx);
	_cairo_surface_destroy0 (theme_surface);
}

void
game_view_set_background (GameView* self,
                          const gchar* colour)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	memset (&self->background_color, 0, sizeof (GdkRGBA));
	if (colour == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !gdk_rgba_parse (&self->background_color, colour);
	}
	if (_tmp0_) {
		self->background_color.blue = (gfloat) 0;
		self->background_color.green = self->background_color.blue;
		self->background_color.red = self->background_color.green;
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
game_view_draw_game (GameView* self,
                     cairo_t* cr,
                     gboolean render_indexes)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	Game* _tmp2_;
	Game* _tmp3_;
	GList* _tmp4_;
	Game* _tmp44_;
	Game* _tmp45_;
	gboolean _tmp46_;
	gboolean _tmp47_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = game_view_get_theme (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	self->priv->tile_pattern_width = self->priv->tile_width + self->priv->tile_layer_offset_x;
	self->priv->tile_pattern_height = self->priv->tile_height + self->priv->tile_layer_offset_y;
	_tmp2_ = game_view_get_game (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp4_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp5_;
			Tile* tile = NULL;
			_tmp5_ = _g_object_ref0 ((Tile*) tile_it->data);
			tile = _tmp5_;
			{
				Tile* _tmp6_;
				gint x = 0;
				gint y = 0;
				Tile* _tmp7_;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				_tmp6_ = tile;
				if (!_tmp6_->visible) {
					_g_object_unref0 (tile);
					continue;
				}
				_tmp7_ = tile;
				game_view_get_tile_position (self, _tmp7_, &_tmp8_, &_tmp9_);
				x = _tmp8_;
				y = _tmp9_;
				if (render_indexes) {
					Tile* _tmp10_;
					Tile* _tmp11_;
					Tile* _tmp12_;
					_tmp10_ = tile;
					_tmp11_ = tile;
					_tmp12_ = tile;
					cairo_set_source_rgb (cr, _tmp10_->number / 255.0, _tmp11_->number / 255.0, _tmp12_->number / 255.0);
				} else {
					gdouble width_scale = 0.0;
					gdouble height_scale = 0.0;
					gint _tmp13_ = 0;
					Game* _tmp14_;
					Game* _tmp15_;
					gboolean _tmp16_;
					gboolean _tmp17_;
					gint tile_number = 0;
					gdouble texture_x = 0.0;
					gdouble texture_y = 0.0;
					Game* _tmp19_;
					Game* _tmp20_;
					gboolean _tmp21_;
					gboolean _tmp22_;
					cairo_matrix_t matrix = {0};
					cairo_pattern_t* _tmp41_;
					cairo_matrix_t _tmp42_;
					cairo_pattern_t* _tmp43_;
					width_scale = ((gdouble) self->priv->theme_width) / (((gdouble) self->priv->tile_pattern_width) * 43.0);
					height_scale = ((gdouble) self->priv->theme_height) / (((gdouble) self->priv->tile_pattern_height) * 2);
					_tmp14_ = game_view_get_game (self);
					_tmp15_ = _tmp14_;
					_tmp16_ = game_get_paused (_tmp15_);
					_tmp17_ = _tmp16_;
					if (_tmp17_) {
						_tmp13_ = -1;
					} else {
						Tile* _tmp18_;
						_tmp18_ = tile;
						_tmp13_ = _tmp18_->number;
					}
					tile_number = _tmp13_;
					texture_x = ((gdouble) game_view_get_image_offset (self, tile_number)) * self->priv->tile_pattern_width;
					texture_y = (gdouble) 0;
					_tmp19_ = game_view_get_game (self);
					_tmp20_ = _tmp19_;
					_tmp21_ = game_get_paused (_tmp20_);
					_tmp22_ = _tmp21_;
					if (!_tmp22_) {
						gboolean _tmp23_ = FALSE;
						Tile* _tmp24_;
						Game* _tmp25_;
						Game* _tmp26_;
						Tile* _tmp27_;
						Tile* _tmp28_;
						_tmp24_ = tile;
						_tmp25_ = game_view_get_game (self);
						_tmp26_ = _tmp25_;
						_tmp27_ = game_get_selected_tile (_tmp26_);
						_tmp28_ = _tmp27_;
						if (_tmp24_ == _tmp28_) {
							_tmp23_ = TRUE;
						} else {
							gboolean _tmp29_ = FALSE;
							Game* _tmp30_;
							Game* _tmp31_;
							_tmp30_ = game_view_get_game (self);
							_tmp31_ = _tmp30_;
							if ((_tmp31_->hint_blink_counter % 2) == ((guint) 1)) {
								gboolean _tmp32_ = FALSE;
								Tile* _tmp33_;
								Game* _tmp34_;
								Game* _tmp35_;
								Tile* _tmp36_;
								_tmp33_ = tile;
								_tmp34_ = game_view_get_game (self);
								_tmp35_ = _tmp34_;
								_tmp36_ = _tmp35_->hint_tiles[0];
								if (_tmp33_ == _tmp36_) {
									_tmp32_ = TRUE;
								} else {
									Tile* _tmp37_;
									Game* _tmp38_;
									Game* _tmp39_;
									Tile* _tmp40_;
									_tmp37_ = tile;
									_tmp38_ = game_view_get_game (self);
									_tmp39_ = _tmp38_;
									_tmp40_ = _tmp39_->hint_tiles[1];
									_tmp32_ = _tmp37_ == _tmp40_;
								}
								_tmp29_ = _tmp32_;
							} else {
								_tmp29_ = FALSE;
							}
							_tmp23_ = _tmp29_;
						}
						if (_tmp23_) {
							texture_y = (gdouble) self->priv->tile_pattern_height;
						}
					}
					cairo_matrix_init_identity (&matrix);
					cairo_matrix_scale (&matrix, width_scale, height_scale);
					cairo_matrix_translate (&matrix, texture_x - x, texture_y - y);
					_tmp41_ = self->priv->tile_pattern;
					_tmp42_ = matrix;
					cairo_pattern_set_matrix (_tmp41_, &_tmp42_);
					_tmp43_ = self->priv->tile_pattern;
					cairo_set_source (cr, _tmp43_);
				}
				cairo_rectangle (cr, (gdouble) x, (gdouble) y, (gdouble) self->priv->tile_pattern_width, (gdouble) self->priv->tile_pattern_height);
				cairo_fill (cr);
				_g_object_unref0 (tile);
			}
		}
	}
	_tmp44_ = game_view_get_game (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = game_get_paused (_tmp45_);
	_tmp47_ = _tmp46_;
	if (_tmp47_) {
		gchar* text = NULL;
		gchar* _tmp48_;
		cairo_text_extents_t extents = {0};
		const gchar* _tmp49_;
		cairo_text_extents_t _tmp50_ = {0};
		cairo_text_extents_t _tmp51_;
		cairo_text_extents_t _tmp52_;
		const gchar* _tmp53_;
		cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
		cairo_paint (cr);
		cairo_select_font_face (cr, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		cairo_set_font_size (cr, gtk_widget_get_allocated_width ((GtkWidget*) self) * 0.125);
		_tmp48_ = g_strdup (_ ("Paused"));
		text = _tmp48_;
		_tmp49_ = text;
		cairo_text_extents (cr, _tmp49_, &_tmp50_);
		extents = _tmp50_;
		_tmp51_ = extents;
		_tmp52_ = extents;
		cairo_move_to (cr, (gtk_widget_get_allocated_width ((GtkWidget*) self) - _tmp51_.width) / 2.0, (gtk_widget_get_allocated_height ((GtkWidget*) self) + _tmp52_.height) / 2.0);
		cairo_set_source_rgb (cr, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp53_ = text;
		cairo_show_text (cr, _tmp53_);
		_g_free0 (text);
	}
}

static void
game_view_update_dimensions (GameView* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint width = 0;
	gint height = 0;
	gdouble map_width = 0.0;
	Game* _tmp2_;
	Game* _tmp3_;
	Map* _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	gdouble map_height = 0.0;
	Game* _tmp7_;
	Game* _tmp8_;
	Map* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	gdouble unit_width = 0.0;
	gdouble unit_height = 0.0;
	Game* _tmp12_;
	Game* _tmp13_;
	Map* _tmp14_;
	guint _tmp15_;
	guint _tmp16_;
	Game* _tmp17_;
	Game* _tmp18_;
	Map* _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_view_get_theme (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp2_ = game_view_get_game (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->map;
	_tmp5_ = map_get_width (_tmp4_);
	_tmp6_ = _tmp5_;
	map_width = _tmp6_ + 2.0;
	_tmp7_ = game_view_get_game (self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_->map;
	_tmp10_ = map_get_height (_tmp9_);
	_tmp11_ = _tmp10_;
	map_height = (_tmp11_ + 2.0) * self->priv->theme_aspect;
	unit_width = MIN (width / map_width, height / map_height);
	unit_height = unit_width * self->priv->theme_aspect;
	self->priv->tile_width = (gint) (unit_width * 2);
	self->priv->tile_height = (gint) (unit_height * 2);
	self->priv->tile_layer_offset_x = self->priv->tile_width / 7;
	self->priv->tile_layer_offset_y = self->priv->tile_height / 10;
	_tmp12_ = game_view_get_game (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_->map;
	_tmp15_ = map_get_width (_tmp14_);
	_tmp16_ = _tmp15_;
	self->priv->x_offset = ((gint) (width - (_tmp16_ * unit_width))) / 2;
	_tmp17_ = game_view_get_game (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_->map;
	_tmp20_ = map_get_height (_tmp19_);
	_tmp21_ = _tmp20_;
	self->priv->y_offset = ((gint) (height - (_tmp21_ * unit_height))) / 2;
}

static void
game_view_get_tile_position (GameView* self,
                             Tile* tile,
                             gint* x,
                             gint* y)
{
	gint _vala_x = 0;
	gint _vala_y = 0;
	Slot* _tmp0_;
	Slot* _tmp1_;
	Slot* _tmp2_;
	Slot* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tile != NULL);
	_tmp0_ = tile->slot;
	_tmp1_ = tile->slot;
	_vala_x = (self->priv->x_offset + ((_tmp0_->x * self->priv->tile_width) / 2)) + (_tmp1_->layer * self->priv->tile_layer_offset_x);
	_tmp2_ = tile->slot;
	_tmp3_ = tile->slot;
	_vala_y = (self->priv->y_offset + ((_tmp2_->y * self->priv->tile_height) / 2)) - (_tmp3_->layer * self->priv->tile_layer_offset_y);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

static gint
game_view_get_image_offset (GameView* self,
                            gint number)
{
	gint set = 0;
	gboolean _tmp0_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	set = number / 4;
	if (number < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = set >= 36;
	}
	if (_tmp0_) {
		result = 42;
		return result;
	}
	if (set == 33) {
		result = 33 + (number % 4);
		return result;
	}
	if (set == 35) {
		result = 38 + (number % 4);
		return result;
	}
	if (set == 34) {
		result = 37;
		return result;
	}
	result = set;
	return result;
}

static void
game_view_redraw_tile_cb (GameView* self,
                          Tile* tile)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tile != NULL);
	game_view_update_dimensions (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
game_view_paused_changed_cb (GameView* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

void
game_view_draw_func (GameView* self,
                     GtkDrawingArea* area,
                     cairo_t* cr,
                     gint width,
                     gint height)
{
	Game* _tmp0_;
	Game* _tmp1_;
	GdkRGBA _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (area != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = game_view_get_game (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->background_color;
	gdk_cairo_set_source_rgba (cr, &_tmp2_);
	cairo_paint (cr);
	game_view_draw_game (self, cr, FALSE);
}

static void
_game_view_on_click_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                               gint n_press,
                                               gdouble x,
                                               gdouble y,
                                               gpointer self)
{
	game_view_on_click ((GameView*) self, _sender, n_press, x, y);
}

static inline void
game_view_init_mouse (GameView* self)
{
	GtkGestureClick* _tmp0_;
	GtkGestureClick* _tmp1_;
	GtkEventController* _tmp2_;
	GtkGestureClick* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkGestureClick*) gtk_gesture_click_new ();
	_g_object_unref0 (self->priv->click_controller);
	self->priv->click_controller = _tmp0_;
	_tmp1_ = self->priv->click_controller;
	_tmp2_ = _g_object_ref0 ((GtkEventController*) _tmp1_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp2_);
	_tmp3_ = self->priv->click_controller;
	g_signal_connect_object (_tmp3_, "pressed", (GCallback) _game_view_on_click_gtk_gesture_click_pressed, self, 0);
}

static inline void
game_view_on_click (GameView* self,
                    GtkGestureClick* _click_controller,
                    gint n_press,
                    gdouble event_x,
                    gdouble event_y)
{
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_;
	Game* _tmp2_;
	Tile* tile = NULL;
	Tile* _tmp7_;
	gboolean _tmp8_ = FALSE;
	Tile* _tmp9_;
	Game* _tmp13_;
	Game* _tmp14_;
	Tile* _tmp15_;
	Tile* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_click_controller != NULL);
	_tmp1_ = game_view_get_game (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		Game* _tmp3_;
		Game* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = game_view_get_game (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = game_get_paused (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp7_ = game_view_find_tile (self, event_x, event_y);
	tile = _tmp7_;
	_tmp9_ = tile;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		Game* _tmp10_;
		Game* _tmp11_;
		Tile* _tmp12_;
		_tmp10_ = game_view_get_game (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = tile;
		_tmp8_ = !game_tile_can_move (_tmp11_, _tmp12_);
	}
	if (_tmp8_) {
		_g_object_unref0 (tile);
		return;
	}
	_tmp13_ = game_view_get_game (self);
	_tmp14_ = _tmp13_;
	_tmp15_ = game_get_selected_tile (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_ == NULL) {
		Game* _tmp17_;
		Game* _tmp18_;
		Tile* _tmp19_;
		_tmp17_ = game_view_get_game (self);
		_tmp18_ = _tmp17_;
		_tmp19_ = tile;
		game_set_selected_tile (_tmp18_, _tmp19_);
	} else {
		Tile* _tmp20_;
		Game* _tmp21_;
		Game* _tmp22_;
		Tile* _tmp23_;
		Tile* _tmp24_;
		_tmp20_ = tile;
		_tmp21_ = game_view_get_game (self);
		_tmp22_ = _tmp21_;
		_tmp23_ = game_get_selected_tile (_tmp22_);
		_tmp24_ = _tmp23_;
		if (_tmp20_ == _tmp24_) {
			Game* _tmp25_;
			Game* _tmp26_;
			_tmp25_ = game_view_get_game (self);
			_tmp26_ = _tmp25_;
			game_set_selected_tile (_tmp26_, NULL);
		} else {
			Game* _tmp27_;
			Game* _tmp28_;
			Tile* _tmp29_;
			Tile* _tmp30_;
			Tile* _tmp31_;
			_tmp27_ = game_view_get_game (self);
			_tmp28_ = _tmp27_;
			_tmp29_ = game_get_selected_tile (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = tile;
			if (tile_matches (_tmp30_, _tmp31_)) {
				Game* _tmp32_;
				Game* _tmp33_;
				Game* _tmp34_;
				Game* _tmp35_;
				Tile* _tmp36_;
				Tile* _tmp37_;
				Tile* _tmp38_;
				_tmp32_ = game_view_get_game (self);
				_tmp33_ = _tmp32_;
				_tmp34_ = game_view_get_game (self);
				_tmp35_ = _tmp34_;
				_tmp36_ = game_get_selected_tile (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = tile;
				game_remove_pair (_tmp33_, _tmp37_, _tmp38_);
			} else {
				Game* _tmp39_;
				Game* _tmp40_;
				Tile* _tmp41_;
				_tmp39_ = game_view_get_game (self);
				_tmp40_ = _tmp39_;
				_tmp41_ = tile;
				game_set_selected_tile (_tmp40_, _tmp41_);
			}
		}
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_object_unref0 (tile);
}

static Tile*
game_view_find_tile (GameView* self,
                     gdouble x,
                     gdouble y)
{
	cairo_surface_t* surface = NULL;
	cairo_surface_t* _tmp0_;
	cairo_t* cr = NULL;
	cairo_surface_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	guchar* data = NULL;
	cairo_surface_t* _tmp7_;
	guchar* _tmp8_;
	gint data_length1;
	gint _data_size_;
	guchar number = '\0';
	guchar* _tmp9_;
	gint _tmp9__length1;
	guchar _tmp10_;
	Game* _tmp11_;
	Game* _tmp12_;
	GList* _tmp13_;
	Tile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = cairo_image_surface_create (CAIRO_FORMAT_RGB24, 1, 1);
	surface = _tmp0_;
	_tmp1_ = surface;
	_tmp2_ = cairo_create (_tmp1_);
	cr = _tmp2_;
	_tmp3_ = cr;
	cairo_set_source_rgba (_tmp3_, (gdouble) 255, (gdouble) 255, (gdouble) 255, (gdouble) 255);
	_tmp4_ = cr;
	cairo_paint (_tmp4_);
	_tmp5_ = cr;
	cairo_translate (_tmp5_, -x, -y);
	_tmp6_ = cr;
	game_view_draw_game (self, _tmp6_, TRUE);
	_tmp7_ = surface;
	_tmp8_ = cairo_image_surface_get_data (_tmp7_);
	data = _tmp8_;
	data_length1 = -1;
	_data_size_ = data_length1;
	_tmp9_ = data;
	_tmp9__length1 = data_length1;
	_tmp10_ = _tmp9_[0];
	number = _tmp10_;
	_tmp11_ = game_view_get_game (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_->tiles;
	{
		GList* tile_collection = NULL;
		GList* tile_it = NULL;
		tile_collection = _tmp13_;
		for (tile_it = tile_collection; tile_it != NULL; tile_it = tile_it->next) {
			Tile* _tmp14_;
			Tile* tile = NULL;
			_tmp14_ = _g_object_ref0 ((Tile*) tile_it->data);
			tile = _tmp14_;
			{
				Tile* _tmp15_;
				_tmp15_ = tile;
				if (_tmp15_->number == ((gint) number)) {
					result = tile;
					_cairo_destroy0 (cr);
					_cairo_surface_destroy0 (surface);
					return result;
				}
				_g_object_unref0 (tile);
			}
		}
	}
	result = NULL;
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (surface);
	return result;
}

GameView*
game_view_construct (GType object_type)
{
	GameView * self = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	return self;
}

GameView*
game_view_new (void)
{
	return game_view_construct (TYPE_GAME_VIEW);
}

Game*
game_view_get_game (GameView* self)
{
	Game* result;
	Game* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game;
	result = _tmp0_;
	return result;
}

static void
_game_view_redraw_tile_cb_game_redraw_tile (Game* _sender,
                                            Tile* tile,
                                            gpointer self)
{
	game_view_redraw_tile_cb ((GameView*) self, tile);
}

static void
_game_view_paused_changed_cb_game_paused_changed (Game* _sender,
                                                  gpointer self)
{
	game_view_paused_changed_cb ((GameView*) self);
}

void
game_view_set_game (GameView* self,
                    Game* value)
{
	Game* _tmp0_;
	Game* _tmp1_;
	Game* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game);
	self->priv->_game = _tmp0_;
	_tmp1_ = self->priv->_game;
	g_signal_connect_object (_tmp1_, "redraw-tile", (GCallback) _game_view_redraw_tile_cb_game_redraw_tile, self, 0);
	_tmp2_ = self->priv->_game;
	g_signal_connect_object (_tmp2_, "paused-changed", (GCallback) _game_view_paused_changed_cb_game_paused_changed, self, 0);
	game_view_update_dimensions (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_GAME_PROPERTY]);
}

const gchar*
game_view_get_theme (GameView* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_theme;
	result = _tmp0_;
	return result;
}

void
game_view_set_theme (GameView* self,
                     const gchar* value)
{
	gchar* _tmp0_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp16_;
	RsvgHandle* _tmp27_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_theme);
	self->priv->_theme = _tmp0_;
	pixbuf = NULL;
	_g_object_unref0 (self->priv->theme_handle);
	self->priv->theme_handle = NULL;
	_cairo_pattern_destroy0 (self->priv->tile_pattern);
	self->priv->tile_pattern = NULL;
	{
		RsvgHandle* _tmp1_ = NULL;
		RsvgHandle* _tmp2_;
		RsvgHandle* _tmp3_;
		gdouble width = 0.0;
		gdouble height = 0.0;
		RsvgHandle* _tmp4_;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		_tmp2_ = rsvg_handle_new_from_file (value, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->theme_handle);
		self->priv->theme_handle = _tmp3_;
		_tmp4_ = self->priv->theme_handle;
		rsvg_handle_get_intrinsic_size_in_pixels (_tmp4_, &_tmp5_, &_tmp6_);
		width = _tmp5_;
		height = _tmp6_;
		self->priv->theme_width = (gint) width;
		self->priv->theme_height = (gint) height;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		{
			GdkPixbuf* _tmp7_ = NULL;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			GdkPixbuf* _tmp10_;
			GdkPixbuf* _tmp11_;
			GdkPixbuf* _tmp12_;
			GdkPixbuf* _tmp13_;
			_tmp8_ = game_view_get_theme (self);
			_tmp9_ = _tmp8_;
			_tmp10_ = gdk_pixbuf_new_from_file (_tmp9_, &_inner_error0_);
			_tmp7_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp11_ = _tmp7_;
			_tmp7_ = NULL;
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp11_;
			_tmp12_ = pixbuf;
			self->priv->theme_width = gdk_pixbuf_get_width (_tmp12_);
			_tmp13_ = pixbuf;
			self->priv->theme_height = gdk_pixbuf_get_height (_tmp13_);
			_g_object_unref0 (_tmp7_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			g_warning ("game-view.vala:76: Could not load theme %s: %s", value, _tmp15_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	self->priv->theme_aspect = (((gdouble) self->priv->theme_height) / 2) / (((gdouble) self->priv->theme_width) / 43);
	game_view_update_dimensions (self);
	_tmp16_ = pixbuf;
	if (_tmp16_ != NULL) {
		cairo_surface_t* theme_surface = NULL;
		GtkNative* _tmp17_;
		GdkSurface* _tmp18_;
		cairo_surface_t* _tmp19_;
		cairo_t* ctx = NULL;
		cairo_surface_t* _tmp20_;
		cairo_t* _tmp21_;
		cairo_t* _tmp22_;
		GdkPixbuf* _tmp23_;
		cairo_t* _tmp24_;
		cairo_surface_t* _tmp25_;
		cairo_pattern_t* _tmp26_;
		_tmp17_ = gtk_widget_get_native ((GtkWidget*) self);
		_tmp18_ = gtk_native_get_surface (_tmp17_);
		_tmp19_ = gdk_surface_create_similar_surface (_tmp18_, CAIRO_CONTENT_COLOR_ALPHA, self->priv->theme_width, self->priv->theme_height);
		theme_surface = _tmp19_;
		_tmp20_ = theme_surface;
		_tmp21_ = cairo_create (_tmp20_);
		ctx = _tmp21_;
		_tmp22_ = ctx;
		_tmp23_ = pixbuf;
		gdk_cairo_set_source_pixbuf (_tmp22_, _tmp23_, (gdouble) 0, (gdouble) 0);
		_tmp24_ = ctx;
		cairo_paint (_tmp24_);
		_tmp25_ = theme_surface;
		_tmp26_ = cairo_pattern_create_for_surface (_tmp25_);
		_cairo_pattern_destroy0 (self->priv->tile_pattern);
		self->priv->tile_pattern = _tmp26_;
		_cairo_destroy0 (ctx);
		_cairo_surface_destroy0 (theme_surface);
	}
	_tmp27_ = self->priv->theme_handle;
	if (_tmp27_ != NULL) {
		game_view_resize_theme (self);
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	_g_object_unref0 (pixbuf);
	g_object_notify_by_pspec ((GObject *) self, game_view_properties[GAME_VIEW_THEME_PROPERTY]);
}

static void
_game_view_draw_func_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                 cairo_t* cr,
                                                 gint width,
                                                 gint height,
                                                 gpointer self)
{
	game_view_draw_func ((GameView*) self, drawing_area, cr, width, height);
}

static GObject *
game_view_constructor (GType type,
                       guint n_construct_properties,
                       GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GameView * self;
	parent_class = G_OBJECT_CLASS (game_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	self->priv->theme_timer_id = (guint) 0;
	game_view_init_mouse (self);
	gtk_drawing_area_set_draw_func ((GtkDrawingArea*) self, _game_view_draw_func_gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	return obj;
}

static void
game_view_class_init (GameViewClass * klass,
                      gpointer klass_data)
{
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameView_private_offset);
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, gint, gint, gint)) game_view_real_size_allocate;
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = game_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME_PROPERTY, game_view_properties[GAME_VIEW_GAME_PROPERTY] = g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME_PROPERTY, game_view_properties[GAME_VIEW_THEME_PROPERTY] = g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
game_view_instance_init (GameView * self,
                         gpointer klass)
{
	self->priv = game_view_get_instance_private (self);
	self->priv->tile_pattern_width = 0;
	self->priv->tile_pattern_height = 0;
	self->priv->theme_handle = NULL;
	self->priv->tile_pattern = NULL;
	self->priv->_theme = NULL;
}

static void
game_view_finalize (GObject * obj)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
	_g_object_unref0 (self->priv->theme_handle);
	_cairo_pattern_destroy0 (self->priv->tile_pattern);
	_g_object_unref0 (self->priv->click_controller);
	_g_object_unref0 (self->priv->_game);
	_g_free0 (self->priv->_theme);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}

static GType
game_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
	GType game_view_type_id;
	game_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GameView", &g_define_type_info, 0);
	GameView_private_offset = g_type_add_instance_private (game_view_type_id, sizeof (GameViewPrivate));
	return game_view_type_id;
}

GType
game_view_get_type (void)
{
	static volatile gsize game_view_type_id__once = 0;
	if (g_once_init_enter (&game_view_type_id__once)) {
		GType game_view_type_id;
		game_view_type_id = game_view_get_type_once ();
		g_once_init_leave (&game_view_type_id__once, game_view_type_id);
	}
	return game_view_type_id__once;
}

static void
_vala_game_view_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_GAME_PROPERTY:
		g_value_set_object (value, game_view_get_game (self));
		break;
		case GAME_VIEW_THEME_PROPERTY:
		g_value_set_string (value, game_view_get_theme (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_view_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec)
{
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
	switch (property_id) {
		case GAME_VIEW_GAME_PROPERTY:
		game_view_set_game (self, g_value_get_object (value));
		break;
		case GAME_VIEW_THEME_PROPERTY:
		game_view_set_theme (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

