/* structure.c generated by valac 0.56.17, the Vala compiler
 * generated from structure.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2011-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <tepl/tepl.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <latexila.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	STRUCT_TYPE_BEGIN_COMMON_TYPES,
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_END_COMMON_TYPES,
	STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_FIGURE,
	STRUCT_TYPE_END_FIGURE,
	STRUCT_TYPE_BEGIN_TABLE,
	STRUCT_TYPE_END_TABLE,
	STRUCT_TYPE_BEGIN_VERBATIM,
	STRUCT_TYPE_END_VERBATIM,
	STRUCT_TYPE_END_DOCUMENT,
	STRUCT_TYPE_CAPTION,
	STRUCT_TYPE_END_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_END_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_NB_TYPES
} StructType;

#define TYPE_STRUCT_TYPE (struct_type_get_type ())
typedef enum  {
	STRUCT_ACTION_CUT,
	STRUCT_ACTION_COPY,
	STRUCT_ACTION_DELETE,
	STRUCT_ACTION_SELECT,
	STRUCT_ACTION_COMMENT,
	STRUCT_ACTION_SHIFT_LEFT,
	STRUCT_ACTION_SHIFT_RIGHT,
	STRUCT_ACTION_OPEN_FILE,
	STRUCT_ACTION_NB_ACTIONS
} StructAction;

#define TYPE_STRUCT_ACTION (struct_action_get_type ())

#define TYPE_STRUCTURE (structure_get_type ())
#define STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE, Structure))
#define STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE, StructureClass))
#define IS_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE))
#define IS_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE))
#define STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE, StructureClass))

typedef struct _Structure Structure;
typedef struct _StructureClass StructureClass;
typedef struct _StructurePrivate StructurePrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;
enum  {
	STRUCTURE_0_PROPERTY,
	STRUCTURE_NUM_PROPERTIES
};
static GParamSpec* structure_properties[STRUCTURE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block28Data Block28Data;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
typedef enum  {
	STRUCT_LIST_COLUMN_PIXBUF,
	STRUCT_LIST_COLUMN_TEXT,
	STRUCT_LIST_COLUMN_TOOLTIP,
	STRUCT_LIST_COLUMN_N_COLUMNS
} StructListColumn;

#define TYPE_STRUCT_LIST_COLUMN (struct_list_column_get_type ())
typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_STRUCT_ERROR (struct_error_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
enum  {
	STRUCTURE_NO_ITEMS_SELECTED_SIGNAL,
	STRUCTURE_ITEM_SELECTED_SIGNAL,
	STRUCTURE_SHOW_POPUP_MENU_SIGNAL,
	STRUCTURE_NUM_SIGNALS
};
static guint structure_signals[STRUCTURE_NUM_SIGNALS] = {0};

struct _Structure {
	GtkGrid parent_instance;
	StructurePrivate * priv;
};

struct _StructureClass {
	GtkGridClass parent_class;
};

struct _StructurePrivate {
	MainWindow* _main_window;
	GtkToggleToolButton** _simple_list_buttons;
	gint _simple_list_buttons_length1;
	gint __simple_list_buttons_size_;
	GtkPaned* _vpaned;
	GtkTreeView* _tree_view;
	DocumentStructure* _document_structure;
	StructureModel* _model;
	GtkTreeView* _list_view;
	GtkScrolledWindow* _list_view_sw;
	GtkListStore* _list_store;
	StructType _current_list_type;
	gboolean _list_is_hidden;
	gboolean _first_select;
};

struct _Block28Data {
	int _ref_count_;
	Structure* self;
	GtkToggleToolButton* button;
	StructType type;
};

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()

static gint Structure_private_offset;
static gpointer structure_parent_class = NULL;
static gchar** structure__icons;
static gint structure__icons_length1;
static gchar** structure__icons = NULL;
static gint structure__icons_length1 = 0;
static gint _structure__icons_size_ = 0;
static gchar** structure__names;
static gint structure__names_length1;
static gchar** structure__names = NULL;
static gint structure__names_length1 = 0;
static gint _structure__names_size_ = 0;
static gchar** structure__action_names;
static gint structure__action_names_length1;
static gchar** structure__action_names = NULL;
static gint structure__action_names_length1 = 0;
static gint _structure__action_names_size_ = 0;

VALA_EXTERN GType struct_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType struct_action_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType structure_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Structure, g_object_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN GType document_structure_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentStructure, g_object_unref)
VALA_EXTERN GType structure_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (StructureModel, g_object_unref)
VALA_EXTERN Structure* structure_new (MainWindow* main_window);
VALA_EXTERN Structure* structure_construct (GType object_type,
                                MainWindow* main_window);
static void structure_init_toolbar (Structure* self);
static void structure_init_vpaned (Structure* self);
static void structure_init_list_view (Structure* self);
static void structure_init_tree_view (Structure* self);
VALA_EXTERN void structure_connect_parsing (Structure* self);
static void _structure_connect_parsing_gtk_widget_show (GtkWidget* _sender,
                                                 gpointer self);
VALA_EXTERN void structure_disconnect_parsing (Structure* self);
static void _structure_disconnect_parsing_gtk_widget_hide (GtkWidget* _sender,
                                                    gpointer self);
VALA_EXTERN void structure_refresh (Structure* self);
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
static void structure_show_document (Structure* self,
                              Document* doc,
                              gboolean force_parse);
VALA_EXTERN Document* main_window_get_active_document (MainWindow* self);
static GtkToolButton* structure_get_refresh_button (Structure* self);
static GtkToolButton* structure_get_collapse_all_button (Structure* self);
static void structure_init_simple_list_buttons (Structure* self);
static void __lambda27_ (Structure* self);
static void ___lambda27__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static void __lambda29_ (Structure* self);
static void ___lambda29__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static GtkToggleToolButton* structure_create_simple_list_button (Structure* self,
                                                          StructType type,
                                                          const gchar* tooltip);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
VALA_EXTERN gchar* structure_get_icon_from_type (StructType type);
static void _vala_array_add7 (GtkToggleToolButton** * array,
                       gint* length,
                       gint* size,
                       GtkToggleToolButton* value);
static void __lambda30_ (Block28Data* _data28_);
static void structure_populate_simple_list (Structure* self);
static void ___lambda30__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
VALA_EXTERN void structure_model_populate_list (StructureModel* self,
                                    GtkListStore* store,
                                    StructType type);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void structure_select_simple_list_item (Structure* self,
                                        GtkTreeIter* tree_iter);
VALA_EXTERN void structure_save_state (Structure* self);
static GtkTreeView* structure_get_new_tree_view (Structure* self,
                                          gint pixbuf_col,
                                          gint text_col,
                                          gint tooltip_col);
VALA_EXTERN GType struct_list_column_get_type (void) G_GNUC_CONST ;
static gboolean __lambda31_ (Structure* self,
                      GtkTreeSelection* select,
                      GtkTreeModel* model,
                      GtkTreePath* path,
                      gboolean path_currently_selected);
static gboolean structure_select_list_row (Structure* self,
                                    GtkTreePath* list_path);
static gboolean ___lambda31__gtk_tree_selection_func (GtkTreeSelection* selection,
                                               GtkTreeModel* model,
                                               GtkTreePath* path,
                                               gboolean path_currently_selected,
                                               gpointer self);
static void __lambda32_ (Structure* self,
                  GtkTreePath* path);
static void ___lambda32__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                               GtkTreePath* path,
                                               GtkTreeViewColumn* column,
                                               gpointer self);
VALA_EXTERN GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
VALA_EXTERN GType struct_column_get_type (void) G_GNUC_CONST ;
static gboolean __lambda33_ (Structure* self,
                      GtkTreeSelection* select,
                      GtkTreeModel* model,
                      GtkTreePath* path,
                      gboolean path_currently_selected);
static gboolean structure_select_tree_row (Structure* self,
                                    GtkTreePath* tree_path);
static gboolean ___lambda33__gtk_tree_selection_func (GtkTreeSelection* selection,
                                               GtkTreeModel* model,
                                               GtkTreePath* path,
                                               gboolean path_currently_selected,
                                               gpointer self);
static void __lambda34_ (Structure* self,
                  GtkTreePath* path);
static void ___lambda34__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                               GtkTreePath* path,
                                               GtkTreeViewColumn* column,
                                               gpointer self);
static gboolean __lambda35_ (Structure* self,
                      GdkEventButton* event);
static gboolean ___lambda35__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static gboolean __lambda36_ (Structure* self);
static gboolean ___lambda36__gtk_widget_popup_menu (GtkWidget* _sender,
                                             gpointer self);
VALA_EXTERN GtkTreePath* structure_model_get_tree_path_from_list_num (StructureModel* self,
                                                          StructType list_type,
                                                          gint num);
VALA_EXTERN GType document_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
VALA_EXTERN DocumentView* main_window_get_active_view (MainWindow* self);
static GeeArrayList* structure_get_simple_list_types (Structure* self,
                                               StructType type);
VALA_EXTERN gint structure_model_get_list_num_from_tree_iter (StructureModel* self,
                                                  GtkTreeIter* tree_iter);
VALA_EXTERN gboolean structure_is_section (StructType type);
static void structure_show_active_document (Structure* self);
static void structure_set_model (Structure* self,
                          StructureModel* model);
static void structure_on_parsing_done (Structure* self);
static void _structure_on_parsing_done_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self);
VALA_EXTERN DocumentStructure* document_get_structure (Document* self);
VALA_EXTERN void document_structure_parse (DocumentStructure* self);
VALA_EXTERN gboolean document_structure_get_parsing_done (DocumentStructure* self);
VALA_EXTERN StructureModel* document_structure_get_model (DocumentStructure* self);
VALA_EXTERN void structure_model_set_emit_signals (StructureModel* self,
                                       gboolean value);
VALA_EXTERN guint structure_model_get_nb_items (StructureModel* self);
static void _structure_show_active_document_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
VALA_EXTERN gboolean structure_is_common_type (StructType type);
VALA_EXTERN void structure_do_action (Structure* self,
                          StructAction action_type);
VALA_EXTERN gint utils_get_selected_row (GtkTreeView* view,
                             GtkTreeIter* iter);
static void structure_open_referenced_file (Structure* self,
                                     GtkTreeIter* iter);
VALA_EXTERN GQuark struct_error_quark (void);
VALA_EXTERN GType struct_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void document_structure_do_action (DocumentStructure* self,
                                   StructAction action_type,
                                   GtkTreeIter* tree_iter,
                                   gboolean* refresh_simple_list,
                                   GError** error);
static gchar* structure_get_action_name (StructAction action_type);
VALA_EXTERN GFile* document_get_location (Document* self);
static void structure_open_included_file (Structure* self,
                                   GFile* referenced_file);
static void structure_open_image (Structure* self,
                           GFile* referenced_file);
VALA_EXTERN GType document_tab_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
VALA_EXTERN DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
VALA_EXTERN gchar* structure_get_type_name (StructType type);
static void structure_finalize (GObject * obj);
static GType structure_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

 G_GNUC_NO_INLINE static GType
struct_type_get_type_once (void)
{
	static const GEnumValue values[] = {{STRUCT_TYPE_BEGIN_COMMON_TYPES, "STRUCT_TYPE_BEGIN_COMMON_TYPES", "begin-common-types"}, {STRUCT_TYPE_PART, "STRUCT_TYPE_PART", "part"}, {STRUCT_TYPE_CHAPTER, "STRUCT_TYPE_CHAPTER", "chapter"}, {STRUCT_TYPE_SECTION, "STRUCT_TYPE_SECTION", "section"}, {STRUCT_TYPE_SUBSECTION, "STRUCT_TYPE_SUBSECTION", "subsection"}, {STRUCT_TYPE_SUBSUBSECTION, "STRUCT_TYPE_SUBSUBSECTION", "subsubsection"}, {STRUCT_TYPE_PARAGRAPH, "STRUCT_TYPE_PARAGRAPH", "paragraph"}, {STRUCT_TYPE_SUBPARAGRAPH, "STRUCT_TYPE_SUBPARAGRAPH", "subparagraph"}, {STRUCT_TYPE_LABEL, "STRUCT_TYPE_LABEL", "label"}, {STRUCT_TYPE_INCLUDE, "STRUCT_TYPE_INCLUDE", "include"}, {STRUCT_TYPE_IMAGE, "STRUCT_TYPE_IMAGE", "image"}, {STRUCT_TYPE_TODO, "STRUCT_TYPE_TODO", "todo"}, {STRUCT_TYPE_FIXME, "STRUCT_TYPE_FIXME", "fixme"}, {STRUCT_TYPE_END_COMMON_TYPES, "STRUCT_TYPE_END_COMMON_TYPES", "end-common-types"}, {STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES, "STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES", "begin-low-level-types"}, {STRUCT_TYPE_BEGIN_FIGURE, "STRUCT_TYPE_BEGIN_FIGURE", "begin-figure"}, {STRUCT_TYPE_END_FIGURE, "STRUCT_TYPE_END_FIGURE", "end-figure"}, {STRUCT_TYPE_BEGIN_TABLE, "STRUCT_TYPE_BEGIN_TABLE", "begin-table"}, {STRUCT_TYPE_END_TABLE, "STRUCT_TYPE_END_TABLE", "end-table"}, {STRUCT_TYPE_BEGIN_VERBATIM, "STRUCT_TYPE_BEGIN_VERBATIM", "begin-verbatim"}, {STRUCT_TYPE_END_VERBATIM, "STRUCT_TYPE_END_VERBATIM", "end-verbatim"}, {STRUCT_TYPE_END_DOCUMENT, "STRUCT_TYPE_END_DOCUMENT", "end-document"}, {STRUCT_TYPE_CAPTION, "STRUCT_TYPE_CAPTION", "caption"}, {STRUCT_TYPE_END_LOW_LEVEL_TYPES, "STRUCT_TYPE_END_LOW_LEVEL_TYPES", "end-low-level-types"}, {STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES, "STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES", "begin-high-level-types"}, {STRUCT_TYPE_TABLE, "STRUCT_TYPE_TABLE", "table"}, {STRUCT_TYPE_FIGURE, "STRUCT_TYPE_FIGURE", "figure"}, {STRUCT_TYPE_END_HIGH_LEVEL_TYPES, "STRUCT_TYPE_END_HIGH_LEVEL_TYPES", "end-high-level-types"}, {STRUCT_TYPE_NB_TYPES, "STRUCT_TYPE_NB_TYPES", "nb-types"}, {0, NULL, NULL}};
	GType struct_type_type_id;
	struct_type_type_id = g_enum_register_static ("StructType", values);
	return struct_type_type_id;
}

GType
struct_type_get_type (void)
{
	static gsize struct_type_type_id__once = 0;
	if (g_once_init_enter (&struct_type_type_id__once)) {
		GType struct_type_type_id;
		struct_type_type_id = struct_type_get_type_once ();
		g_once_init_leave (&struct_type_type_id__once, struct_type_type_id);
	}
	return struct_type_type_id__once;
}

 G_GNUC_NO_INLINE static GType
struct_action_get_type_once (void)
{
	static const GEnumValue values[] = {{STRUCT_ACTION_CUT, "STRUCT_ACTION_CUT", "cut"}, {STRUCT_ACTION_COPY, "STRUCT_ACTION_COPY", "copy"}, {STRUCT_ACTION_DELETE, "STRUCT_ACTION_DELETE", "delete"}, {STRUCT_ACTION_SELECT, "STRUCT_ACTION_SELECT", "select"}, {STRUCT_ACTION_COMMENT, "STRUCT_ACTION_COMMENT", "comment"}, {STRUCT_ACTION_SHIFT_LEFT, "STRUCT_ACTION_SHIFT_LEFT", "shift-left"}, {STRUCT_ACTION_SHIFT_RIGHT, "STRUCT_ACTION_SHIFT_RIGHT", "shift-right"}, {STRUCT_ACTION_OPEN_FILE, "STRUCT_ACTION_OPEN_FILE", "open-file"}, {STRUCT_ACTION_NB_ACTIONS, "STRUCT_ACTION_NB_ACTIONS", "nb-actions"}, {0, NULL, NULL}};
	GType struct_action_type_id;
	struct_action_type_id = g_enum_register_static ("StructAction", values);
	return struct_action_type_id;
}

GType
struct_action_get_type (void)
{
	static gsize struct_action_type_id__once = 0;
	if (g_once_init_enter (&struct_action_type_id__once)) {
		GType struct_action_type_id;
		struct_action_type_id = struct_action_get_type_once ();
		g_once_init_leave (&struct_action_type_id__once, struct_action_type_id);
	}
	return struct_action_type_id__once;
}

static inline gpointer
structure_get_instance_private (Structure* self)
{
	return G_STRUCT_MEMBER_P (self, Structure_private_offset);
}

static void
_structure_connect_parsing_gtk_widget_show (GtkWidget* _sender,
                                            gpointer self)
{
	structure_connect_parsing ((Structure*) self);
}

static void
_structure_disconnect_parsing_gtk_widget_hide (GtkWidget* _sender,
                                               gpointer self)
{
	structure_disconnect_parsing ((Structure*) self);
}

Structure*
structure_construct (GType object_type,
                     MainWindow* main_window)
{
	Structure * self = NULL;
	GtkScrolledWindow* _tmp0_;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (Structure*) g_object_new (object_type, NULL);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	self->priv->_main_window = main_window;
	structure_init_toolbar (self);
	structure_init_vpaned (self);
	structure_init_list_view (self);
	structure_init_tree_view (self);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp0_ = self->priv->_list_view_sw;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) _structure_connect_parsing_gtk_widget_show, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "hide", (GCallback) _structure_disconnect_parsing_gtk_widget_hide, self, 0);
	return self;
}

Structure*
structure_new (MainWindow* main_window)
{
	return structure_construct (TYPE_STRUCTURE, main_window);
}

void
structure_refresh (Structure* self)
{
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_document (_tmp0_);
	_tmp2_ = _tmp1_;
	structure_show_document (self, _tmp2_, TRUE);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
structure_init_toolbar (Structure* self)
{
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp0_;
	GtkToolbar* _tmp1_;
	GtkToolbar* _tmp2_;
	GtkToolbar* _tmp3_;
	GtkToolbar* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolButton* _tmp6_;
	GtkToolbar* _tmp7_;
	GtkToolButton* _tmp8_;
	GtkToolButton* _tmp9_;
	GtkToolbar* _tmp10_;
	GtkSeparatorToolItem* _tmp11_;
	GtkSeparatorToolItem* _tmp12_;
	GtkToggleToolButton** _tmp13_;
	gint _tmp13__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkToolbar*) gtk_toolbar_new ();
	g_object_ref_sink (_tmp0_);
	toolbar = _tmp0_;
	_tmp1_ = toolbar;
	gtk_toolbar_set_icon_size (_tmp1_, GTK_ICON_SIZE_MENU);
	_tmp2_ = toolbar;
	gtk_toolbar_set_style (_tmp2_, GTK_TOOLBAR_ICONS);
	_tmp3_ = toolbar;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	_tmp4_ = toolbar;
	_tmp5_ = structure_get_refresh_button (self);
	_tmp6_ = _tmp5_;
	gtk_toolbar_insert (_tmp4_, (GtkToolItem*) _tmp6_, -1);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = toolbar;
	_tmp8_ = structure_get_collapse_all_button (self);
	_tmp9_ = _tmp8_;
	gtk_toolbar_insert (_tmp7_, (GtkToolItem*) _tmp9_, -1);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = toolbar;
	_tmp11_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	gtk_toolbar_insert (_tmp10_, (GtkToolItem*) _tmp12_, -1);
	_g_object_unref0 (_tmp12_);
	structure_init_simple_list_buttons (self);
	_tmp13_ = self->priv->_simple_list_buttons;
	_tmp13__length1 = self->priv->_simple_list_buttons_length1;
	{
		GtkToggleToolButton** simple_list_button_collection = NULL;
		gint simple_list_button_collection_length1 = 0;
		gint _simple_list_button_collection_size_ = 0;
		gint simple_list_button_it = 0;
		simple_list_button_collection = _tmp13_;
		simple_list_button_collection_length1 = _tmp13__length1;
		for (simple_list_button_it = 0; simple_list_button_it < simple_list_button_collection_length1; simple_list_button_it = simple_list_button_it + 1) {
			GtkToggleToolButton* _tmp14_;
			GtkToggleToolButton* simple_list_button = NULL;
			_tmp14_ = _g_object_ref0 (simple_list_button_collection[simple_list_button_it]);
			simple_list_button = _tmp14_;
			{
				GtkToolbar* _tmp15_;
				GtkToggleToolButton* _tmp16_;
				_tmp15_ = toolbar;
				_tmp16_ = simple_list_button;
				gtk_toolbar_insert (_tmp15_, (GtkToolItem*) _tmp16_, -1);
				_g_object_unref0 (simple_list_button);
			}
		}
	}
	_g_object_unref0 (toolbar);
}

static void
__lambda27_ (Structure* self)
{
	structure_refresh (self);
}

static void
___lambda27__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
	__lambda27_ ((Structure*) self);
}

static GtkToolButton*
structure_get_refresh_button (Structure* self)
{
	GtkToolButton* refresh_button = NULL;
	GtkToolButton* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkToolButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	refresh_button = _tmp0_;
	gtk_tool_button_set_icon_name (refresh_button, "view-refresh");
	gtk_widget_set_tooltip_text ((GtkWidget*) refresh_button, _ ("Refresh"));
	_tmp1_ = gtk_widget_get_tooltip_text ((GtkWidget*) refresh_button);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	gtk_tool_button_set_label (refresh_button, _tmp3_);
	_g_free0 (_tmp3_);
	g_signal_connect_object (refresh_button, "clicked", (GCallback) ___lambda27__gtk_tool_button_clicked, self, 0);
	result = refresh_button;
	return result;
}

static void
__lambda29_ (Structure* self)
{
	GtkTreeView* _tmp0_;
	_tmp0_ = self->priv->_tree_view;
	gtk_tree_view_collapse_all (_tmp0_);
}

static void
___lambda29__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
	__lambda29_ ((Structure*) self);
}

static GtkToolButton*
structure_get_collapse_all_button (Structure* self)
{
	GtkToolButton* collapse_button = NULL;
	GtkToolButton* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkToolButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
	g_object_ref_sink (_tmp0_);
	collapse_button = _tmp0_;
	gtk_tool_button_set_icon_name (collapse_button, "zoom-out");
	gtk_widget_set_tooltip_text ((GtkWidget*) collapse_button, _ ("Collapse All"));
	_tmp1_ = gtk_widget_get_tooltip_text ((GtkWidget*) collapse_button);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	gtk_tool_button_set_label (collapse_button, _tmp3_);
	_g_free0 (_tmp3_);
	g_signal_connect_object (collapse_button, "clicked", (GCallback) ___lambda29__gtk_tool_button_clicked, self, 0);
	result = collapse_button;
	return result;
}

static void
structure_init_simple_list_buttons (Structure* self)
{
	GtkToggleToolButton* _tmp0_;
	GtkToggleToolButton* _tmp1_;
	GtkToggleToolButton* _tmp2_;
	GtkToggleToolButton* _tmp3_;
	GtkToggleToolButton* _tmp4_;
	GtkToggleToolButton* _tmp5_;
	GtkToggleToolButton* _tmp6_;
	GtkToggleToolButton* _tmp7_;
	GtkToggleToolButton* _tmp8_;
	GtkToggleToolButton* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = structure_create_simple_list_button (self, STRUCT_TYPE_LABEL, _ ("Show labels"));
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
	_tmp2_ = structure_create_simple_list_button (self, STRUCT_TYPE_INCLUDE, _ ("Show included files"));
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_tmp4_ = structure_create_simple_list_button (self, STRUCT_TYPE_TABLE, _ ("Show tables"));
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp5_);
	_tmp6_ = structure_create_simple_list_button (self, STRUCT_TYPE_FIGURE, _ ("Show figures and images"));
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp7_);
	_tmp8_ = structure_create_simple_list_button (self, STRUCT_TYPE_TODO, _ ("Show TODOs and FIXMEs"));
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp9_);
}

static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		Structure* self;
		self = _data28_->self;
		_g_object_unref0 (_data28_->button);
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}

static void
_vala_array_add7 (GtkToggleToolButton** * array,
                  gint* length,
                  gint* size,
                  GtkToggleToolButton* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkToggleToolButton*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda30_ (Block28Data* _data28_)
{
	Structure* self;
	GtkScrolledWindow* _tmp2_;
	GtkToggleToolButton** _tmp3_;
	gint _tmp3__length1;
	self = _data28_->self;
	if (!gtk_toggle_tool_button_get_active (_data28_->button)) {
		gboolean _tmp0_ = FALSE;
		if (!self->priv->_list_is_hidden) {
			_tmp0_ = _data28_->type == self->priv->_current_list_type;
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			GtkScrolledWindow* _tmp1_;
			self->priv->_list_is_hidden = TRUE;
			_tmp1_ = self->priv->_list_view_sw;
			gtk_widget_hide ((GtkWidget*) _tmp1_);
		}
		return;
	}
	self->priv->_current_list_type = _data28_->type;
	self->priv->_list_is_hidden = FALSE;
	_tmp2_ = self->priv->_list_view_sw;
	gtk_widget_show_all ((GtkWidget*) _tmp2_);
	structure_populate_simple_list (self);
	_tmp3_ = self->priv->_simple_list_buttons;
	_tmp3__length1 = self->priv->_simple_list_buttons_length1;
	{
		GtkToggleToolButton** simple_list_button_collection = NULL;
		gint simple_list_button_collection_length1 = 0;
		gint _simple_list_button_collection_size_ = 0;
		gint simple_list_button_it = 0;
		simple_list_button_collection = _tmp3_;
		simple_list_button_collection_length1 = _tmp3__length1;
		for (simple_list_button_it = 0; simple_list_button_it < simple_list_button_collection_length1; simple_list_button_it = simple_list_button_it + 1) {
			GtkToggleToolButton* _tmp4_;
			GtkToggleToolButton* simple_list_button = NULL;
			_tmp4_ = _g_object_ref0 (simple_list_button_collection[simple_list_button_it]);
			simple_list_button = _tmp4_;
			{
				GtkToggleToolButton* _tmp5_;
				GtkToggleToolButton* _tmp6_;
				_tmp5_ = simple_list_button;
				if (_tmp5_ == _data28_->button) {
					_g_object_unref0 (simple_list_button);
					continue;
				}
				_tmp6_ = simple_list_button;
				gtk_toggle_tool_button_set_active (_tmp6_, FALSE);
				_g_object_unref0 (simple_list_button);
			}
		}
	}
}

static void
___lambda30__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
	__lambda30_ (self);
}

static GtkToggleToolButton*
structure_create_simple_list_button (Structure* self,
                                     StructType type,
                                     const gchar* tooltip)
{
	Block28Data* _data28_;
	GtkToggleToolButton* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkToggleToolButton* _tmp3_;
	GtkToggleToolButton* _tmp4_;
	GtkToggleToolButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tooltip != NULL, NULL);
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	_data28_->type = type;
	_tmp0_ = (GtkToggleToolButton*) gtk_toggle_tool_button_new ();
	g_object_ref_sink (_tmp0_);
	_data28_->button = _tmp0_;
	_tmp1_ = structure_get_icon_from_type (_data28_->type);
	_tmp2_ = _tmp1_;
	gtk_tool_button_set_icon_name ((GtkToolButton*) _data28_->button, _tmp2_);
	_g_free0 (_tmp2_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _data28_->button, tooltip);
	gtk_tool_button_set_label ((GtkToolButton*) _data28_->button, tooltip);
	_tmp3_ = _g_object_ref0 (_data28_->button);
	_vala_array_add7 (&self->priv->_simple_list_buttons, &self->priv->_simple_list_buttons_length1, &self->priv->__simple_list_buttons_size_, _tmp3_);
	g_signal_connect_data ((GtkToolButton*) _data28_->button, "clicked", (GCallback) ___lambda30__gtk_tool_button_clicked, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
	_tmp4_ = _g_object_ref0 (_data28_->button);
	result = _tmp4_;
	block28_data_unref (_data28_);
	_data28_ = NULL;
	return result;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static void
structure_populate_simple_list (Structure* self)
{
	GtkListStore* _tmp0_;
	gboolean _tmp1_ = FALSE;
	StructureModel* _tmp2_;
	StructureModel* _tmp3_;
	GtkListStore* _tmp4_;
	GtkTreeSelection* tree_select = NULL;
	GtkTreeView* _tmp5_;
	GtkTreeSelection* _tmp6_;
	GtkTreeSelection* _tmp7_;
	GList* selected_rows = NULL;
	GtkTreeSelection* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	GtkTreePath* tree_path = NULL;
	GList* _tmp11_;
	gconstpointer _tmp12_;
	GtkTreePath* _tmp13_;
	GtkTreeIter tree_iter = {0};
	StructureModel* _tmp14_;
	GtkTreePath* _tmp15_;
	GtkTreeIter _tmp16_ = {0};
	gboolean _tmp17_;
	GtkTreeIter _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_list_store;
	gtk_list_store_clear (_tmp0_);
	_tmp2_ = self->priv->_model;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->_list_is_hidden;
	}
	if (_tmp1_) {
		return;
	}
	_tmp3_ = self->priv->_model;
	_tmp4_ = self->priv->_list_store;
	structure_model_populate_list (_tmp3_, _tmp4_, self->priv->_current_list_type);
	_tmp5_ = self->priv->_tree_view;
	_tmp6_ = gtk_tree_view_get_selection (_tmp5_);
	_tmp7_ = _g_object_ref0 (_tmp6_);
	tree_select = _tmp7_;
	_tmp8_ = tree_select;
	_tmp9_ = gtk_tree_selection_get_selected_rows (_tmp8_, NULL);
	selected_rows = _tmp9_;
	_tmp10_ = selected_rows;
	if (g_list_length (_tmp10_) != ((guint) 1)) {
		(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
		_g_object_unref0 (tree_select);
		return;
	}
	_tmp11_ = selected_rows;
	_tmp12_ = g_list_nth_data (_tmp11_, (guint) 0);
	_tmp13_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp12_);
	tree_path = _tmp13_;
	_tmp14_ = self->priv->_model;
	_tmp15_ = tree_path;
	_tmp17_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp14_, &_tmp16_, _tmp15_);
	tree_iter = _tmp16_;
	if (!_tmp17_) {
		g_return_if_reached ();
	}
	_tmp18_ = tree_iter;
	structure_select_simple_list_item (self, &_tmp18_);
	__vala_GtkTreePath_free0 (tree_path);
	(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
	_g_object_unref0 (tree_select);
}

static void
structure_init_vpaned (Structure* self)
{
	GtkPaned* _tmp0_;
	GtkPaned* _tmp1_;
	GtkPaned* _tmp2_;
	GSettings* settings = NULL;
	GSettings* _tmp3_;
	GtkPaned* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_VERTICAL);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_vpaned);
	self->priv->_vpaned = _tmp0_;
	_tmp1_ = self->priv->_vpaned;
	g_object_set ((GtkWidget*) _tmp1_, "expand", TRUE, NULL);
	_tmp2_ = self->priv->_vpaned;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = g_settings_new ("org.gnome.gnome-latex.state.window");
	settings = _tmp3_;
	_tmp4_ = self->priv->_vpaned;
	gtk_paned_set_position (_tmp4_, g_settings_get_int (settings, "structure-paned-position"));
	_g_object_unref0 (settings);
}

void
structure_save_state (Structure* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GtkPaned* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.state.window");
	settings = _tmp0_;
	_tmp1_ = self->priv->_vpaned;
	g_settings_set_int (settings, "structure-paned-position", gtk_paned_get_position (_tmp1_));
	_g_object_unref0 (settings);
}

static gboolean
__lambda31_ (Structure* self,
             GtkTreeSelection* select,
             GtkTreeModel* model,
             GtkTreePath* path,
             gboolean path_currently_selected)
{
	gboolean result;
	g_return_val_if_fail (select != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	if (path_currently_selected) {
		result = TRUE;
		return result;
	}
	result = structure_select_list_row (self, path);
	return result;
}

static gboolean
___lambda31__gtk_tree_selection_func (GtkTreeSelection* selection,
                                      GtkTreeModel* model,
                                      GtkTreePath* path,
                                      gboolean path_currently_selected,
                                      gpointer self)
{
	gboolean result;
	result = __lambda31_ ((Structure*) self, selection, model, path, path_currently_selected);
	return result;
}

static void
__lambda32_ (Structure* self,
             GtkTreePath* path)
{
	g_return_if_fail (path != NULL);
	structure_select_list_row (self, path);
}

static void
___lambda32__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                          GtkTreePath* path,
                                          GtkTreeViewColumn* column,
                                          gpointer self)
{
	__lambda32_ ((Structure*) self, path);
}

static void
structure_init_list_view (Structure* self)
{
	GtkTreeView* _tmp0_;
	GtkListStore* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeSelection* list_select = NULL;
	GtkTreeView* _tmp4_;
	GtkTreeSelection* _tmp5_;
	GtkTreeSelection* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkTreeView* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkScrolledWindow* _tmp10_;
	GtkPaned* _tmp11_;
	GtkScrolledWindow* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = structure_get_new_tree_view (self, (gint) STRUCT_LIST_COLUMN_PIXBUF, (gint) STRUCT_LIST_COLUMN_TEXT, (gint) STRUCT_LIST_COLUMN_TOOLTIP);
	_g_object_unref0 (self->priv->_list_view);
	self->priv->_list_view = _tmp0_;
	_tmp1_ = gtk_list_store_new ((gint) STRUCT_LIST_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, -1);
	_g_object_unref0 (self->priv->_list_store);
	self->priv->_list_store = _tmp1_;
	_tmp2_ = self->priv->_list_view;
	_tmp3_ = self->priv->_list_store;
	gtk_tree_view_set_model (_tmp2_, (GtkTreeModel*) _tmp3_);
	_tmp4_ = self->priv->_list_view;
	_tmp5_ = gtk_tree_view_get_selection (_tmp4_);
	_tmp6_ = _g_object_ref0 (_tmp5_);
	list_select = _tmp6_;
	gtk_tree_selection_set_select_function (list_select, ___lambda31__gtk_tree_selection_func, g_object_ref (self), g_object_unref);
	_tmp7_ = self->priv->_list_view;
	g_signal_connect_object (_tmp7_, "row-activated", (GCallback) ___lambda32__gtk_tree_view_row_activated, self, 0);
	_tmp8_ = self->priv->_list_view;
	_tmp9_ = utils_add_scrollbar ((GtkWidget*) _tmp8_);
	_g_object_unref0 (self->priv->_list_view_sw);
	self->priv->_list_view_sw = _tmp9_;
	_tmp10_ = self->priv->_list_view_sw;
	gtk_scrolled_window_set_shadow_type (_tmp10_, GTK_SHADOW_IN);
	_tmp11_ = self->priv->_vpaned;
	_tmp12_ = self->priv->_list_view_sw;
	gtk_paned_pack1 (_tmp11_, (GtkWidget*) _tmp12_, FALSE, FALSE);
	_g_object_unref0 (list_select);
}

static gboolean
__lambda33_ (Structure* self,
             GtkTreeSelection* select,
             GtkTreeModel* model,
             GtkTreePath* path,
             gboolean path_currently_selected)
{
	gboolean result;
	g_return_val_if_fail (select != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	if (path_currently_selected) {
		g_signal_emit (self, structure_signals[STRUCTURE_NO_ITEMS_SELECTED_SIGNAL], 0);
		result = TRUE;
		return result;
	}
	result = structure_select_tree_row (self, path);
	return result;
}

static gboolean
___lambda33__gtk_tree_selection_func (GtkTreeSelection* selection,
                                      GtkTreeModel* model,
                                      GtkTreePath* path,
                                      gboolean path_currently_selected,
                                      gpointer self)
{
	gboolean result;
	result = __lambda33_ ((Structure*) self, selection, model, path, path_currently_selected);
	return result;
}

static void
__lambda34_ (Structure* self,
             GtkTreePath* path)
{
	g_return_if_fail (path != NULL);
	structure_select_tree_row (self, path);
}

static void
___lambda34__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                          GtkTreePath* path,
                                          GtkTreeViewColumn* column,
                                          gpointer self)
{
	__lambda34_ ((Structure*) self, path);
}

static gboolean
__lambda35_ (Structure* self,
             GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 3)) {
		_tmp0_ = event->type == GDK_BUTTON_PRESS;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit (self, structure_signals[STRUCTURE_SHOW_POPUP_MENU_SIGNAL], 0, event);
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda35__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda35_ ((Structure*) self, event);
	return result;
}

static gboolean
__lambda36_ (Structure* self)
{
	gboolean result;
	g_signal_emit (self, structure_signals[STRUCTURE_SHOW_POPUP_MENU_SIGNAL], 0, NULL);
	result = TRUE;
	return result;
}

static gboolean
___lambda36__gtk_widget_popup_menu (GtkWidget* _sender,
                                    gpointer self)
{
	gboolean result;
	result = __lambda36_ ((Structure*) self);
	return result;
}

static void
structure_init_tree_view (Structure* self)
{
	GtkTreeView* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* tree_select = NULL;
	GtkTreeView* _tmp2_;
	GtkTreeSelection* _tmp3_;
	GtkTreeSelection* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkScrolledWindow* sw = NULL;
	GtkTreeView* _tmp8_;
	GtkScrolledWindow* _tmp9_;
	GtkPaned* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = structure_get_new_tree_view (self, (gint) STRUCT_COLUMN_PIXBUF, (gint) STRUCT_COLUMN_TEXT, (gint) STRUCT_COLUMN_TOOLTIP);
	_g_object_unref0 (self->priv->_tree_view);
	self->priv->_tree_view = _tmp0_;
	_tmp1_ = self->priv->_tree_view;
	gtk_tree_view_set_enable_tree_lines (_tmp1_, TRUE);
	_tmp2_ = self->priv->_tree_view;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	tree_select = _tmp4_;
	gtk_tree_selection_set_select_function (tree_select, ___lambda33__gtk_tree_selection_func, g_object_ref (self), g_object_unref);
	_tmp5_ = self->priv->_tree_view;
	g_signal_connect_object (_tmp5_, "row-activated", (GCallback) ___lambda34__gtk_tree_view_row_activated, self, 0);
	_tmp6_ = self->priv->_tree_view;
	g_signal_connect_object ((GtkWidget*) _tmp6_, "button-press-event", (GCallback) ___lambda35__gtk_widget_button_press_event, self, 0);
	_tmp7_ = self->priv->_tree_view;
	g_signal_connect_object ((GtkWidget*) _tmp7_, "popup-menu", (GCallback) ___lambda36__gtk_widget_popup_menu, self, 0);
	_tmp8_ = self->priv->_tree_view;
	_tmp9_ = utils_add_scrollbar ((GtkWidget*) _tmp8_);
	sw = _tmp9_;
	gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_IN);
	_tmp10_ = self->priv->_vpaned;
	gtk_paned_add2 (_tmp10_, (GtkWidget*) sw);
	_g_object_unref0 (sw);
	_g_object_unref0 (tree_select);
}

static GtkTreeView*
structure_get_new_tree_view (Structure* self,
                             gint pixbuf_col,
                             gint text_col,
                             gint tooltip_col)
{
	GtkTreeView* tree_view = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeViewColumn* column = NULL;
	GtkTreeViewColumn* _tmp1_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp2_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp3_;
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp4_;
	GtkTreeSelection* _tmp5_;
	GtkTreeView* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkTreeView*) gtk_tree_view_new ();
	g_object_ref_sink (_tmp0_);
	tree_view = _tmp0_;
	gtk_tree_view_set_headers_visible (tree_view, FALSE);
	_tmp1_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp1_);
	column = _tmp1_;
	gtk_tree_view_append_column (tree_view, column);
	_tmp2_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp2_);
	pixbuf_renderer = _tmp2_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) pixbuf_renderer, "icon-name", pixbuf_col, NULL, NULL);
	_tmp3_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp3_);
	text_renderer = _tmp3_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text_renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) text_renderer, "text", text_col, NULL, NULL);
	gtk_tree_view_set_tooltip_column (tree_view, tooltip_col);
	_tmp4_ = gtk_tree_view_get_selection (tree_view);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	select = _tmp5_;
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	result = tree_view;
	_g_object_unref0 (select);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	_g_object_unref0 (column);
	return result;
}

static gboolean
structure_select_list_row (Structure* self,
                           GtkTreePath* list_path)
{
	StructureModel* _tmp0_;
	GtkTreeSelection* tree_select = NULL;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* _tmp3_;
	GtkTreeSelection* _tmp4_;
	gint row_num = 0;
	gint _tmp5_ = 0;
	gint* _tmp6_;
	gint _tmp7_;
	GtkTreePath* tree_path = NULL;
	StructureModel* _tmp8_;
	GtkTreePath* _tmp9_;
	GtkTreePath* _tmp10_;
	GtkTreeView* _tmp11_;
	GtkTreePath* _tmp12_;
	GtkTreeSelection* _tmp13_;
	GtkTreePath* _tmp14_;
	GtkTreeView* _tmp15_;
	GtkTreePath* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (list_path != NULL, FALSE);
	if (!self->priv->_first_select) {
		self->priv->_first_select = TRUE;
		result = TRUE;
		return result;
	}
	_tmp0_ = self->priv->_model;
	g_return_val_if_fail (_tmp0_ != NULL, FALSE);
	_tmp1_ = self->priv->_tree_view;
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	tree_select = _tmp3_;
	_tmp4_ = tree_select;
	gtk_tree_selection_unselect_all (_tmp4_);
	_tmp6_ = gtk_tree_path_get_indices_with_depth (list_path, &_tmp5_);
	_tmp7_ = _tmp6_[0];
	row_num = _tmp7_;
	_tmp8_ = self->priv->_model;
	_tmp9_ = structure_model_get_tree_path_from_list_num (_tmp8_, self->priv->_current_list_type, row_num);
	tree_path = _tmp9_;
	_tmp10_ = tree_path;
	g_return_val_if_fail (_tmp10_ != NULL, FALSE);
	_tmp11_ = self->priv->_tree_view;
	_tmp12_ = tree_path;
	gtk_tree_view_expand_to_path (_tmp11_, _tmp12_);
	self->priv->_first_select = FALSE;
	_tmp13_ = tree_select;
	_tmp14_ = tree_path;
	gtk_tree_selection_select_path (_tmp13_, _tmp14_);
	_tmp15_ = self->priv->_tree_view;
	_tmp16_ = tree_path;
	gtk_tree_view_scroll_to_cell (_tmp15_, _tmp16_, NULL, TRUE, (gfloat) 0.5, (gfloat) 0);
	result = TRUE;
	__vala_GtkTreePath_free0 (tree_path);
	_g_object_unref0 (tree_select);
	return result;
}

static gboolean
structure_select_tree_row (Structure* self,
                           GtkTreePath* tree_path)
{
	gboolean first_select = FALSE;
	GtkTreeIter tree_iter = {0};
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	GtkTextMark* mark = NULL;
	StructType type = 0;
	StructureModel* _tmp3_;
	GtkTreeIter _tmp4_;
	GtkTextMark* _tmp5_ = NULL;
	StructType _tmp6_ = 0;
	GtkTextBuffer* doc = NULL;
	GtkTextMark* _tmp7_;
	GtkTextBuffer* _tmp8_;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	MainWindow* _tmp11_;
	Document* _tmp12_;
	Document* _tmp13_;
	GtkTextIter text_iter = {0};
	GtkTextBuffer* _tmp14_;
	GtkTextMark* _tmp15_;
	GtkTextIter _tmp16_ = {0};
	GtkTextBuffer* _tmp17_;
	GtkTextIter _tmp18_;
	MainWindow* _tmp19_;
	DocumentView* _tmp20_;
	DocumentView* _tmp21_;
	GtkTextBuffer* _tmp22_;
	GtkTextMark* _tmp23_;
	GtkTreeIter _tmp24_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tree_path != NULL, FALSE);
	first_select = self->priv->_first_select;
	self->priv->_first_select = TRUE;
	_tmp0_ = self->priv->_model;
	_tmp2_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp0_, &_tmp1_, tree_path);
	tree_iter = _tmp1_;
	if (!_tmp2_) {
		g_return_val_if_reached (FALSE);
	}
	_tmp3_ = self->priv->_model;
	_tmp4_ = tree_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, STRUCT_COLUMN_START_MARK, &_tmp5_, STRUCT_COLUMN_TYPE, &_tmp6_, -1);
	_g_object_unref0 (mark);
	mark = _tmp5_;
	type = _tmp6_;
	_tmp7_ = mark;
	_tmp8_ = gtk_text_mark_get_buffer (_tmp7_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	doc = _tmp9_;
	_tmp10_ = doc;
	_tmp11_ = self->priv->_main_window;
	_tmp12_ = main_window_get_active_document (_tmp11_);
	_tmp13_ = _tmp12_;
	g_return_val_if_fail (_tmp10_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_text_buffer_get_type (), GtkTextBuffer), FALSE);
	_tmp14_ = doc;
	_tmp15_ = mark;
	gtk_text_buffer_get_iter_at_mark (_tmp14_, &_tmp16_, _tmp15_);
	text_iter = _tmp16_;
	_tmp17_ = doc;
	_tmp18_ = text_iter;
	gtk_text_buffer_place_cursor (_tmp17_, &_tmp18_);
	_tmp19_ = self->priv->_main_window;
	_tmp20_ = main_window_get_active_view (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = doc;
	_tmp23_ = gtk_text_buffer_get_insert (_tmp22_);
	gtk_text_view_scroll_to_mark ((GtkTextView*) _tmp21_, _tmp23_, (gdouble) 0, TRUE, (gdouble) 1, (gdouble) 0);
	g_signal_emit (self, structure_signals[STRUCTURE_ITEM_SELECTED_SIGNAL], 0, type);
	if (!first_select) {
		result = TRUE;
		_g_object_unref0 (doc);
		_g_object_unref0 (mark);
		return result;
	}
	_tmp24_ = tree_iter;
	structure_select_simple_list_item (self, &_tmp24_);
	result = TRUE;
	_g_object_unref0 (doc);
	_g_object_unref0 (mark);
	return result;
}

static void
structure_select_simple_list_item (Structure* self,
                                   GtkTreeIter* tree_iter)
{
	GtkTreeSelection* list_select = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* _tmp3_;
	StructType type = 0;
	StructureModel* _tmp4_;
	GtkTreeIter _tmp5_;
	StructType _tmp6_ = 0;
	GeeArrayList* current_list_types = NULL;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	gint row_num = 0;
	StructureModel* _tmp9_;
	GtkTreeIter _tmp10_;
	GtkTreePath* list_path = NULL;
	GtkTreePath* _tmp11_;
	GtkTreeSelection* _tmp12_;
	GtkTreePath* _tmp13_;
	GtkTreeView* _tmp14_;
	GtkTreePath* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree_iter != NULL);
	if (self->priv->_list_is_hidden) {
		return;
	}
	_tmp0_ = self->priv->_list_view;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	list_select = _tmp2_;
	_tmp3_ = list_select;
	gtk_tree_selection_unselect_all (_tmp3_);
	_tmp4_ = self->priv->_model;
	_tmp5_ = *tree_iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp4_, &_tmp5_, STRUCT_COLUMN_TYPE, &_tmp6_, -1, -1);
	type = _tmp6_;
	_tmp7_ = structure_get_simple_list_types (self, self->priv->_current_list_type);
	current_list_types = _tmp7_;
	_tmp8_ = current_list_types;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp8_, (gpointer) ((gintptr) type))) {
		_g_object_unref0 (current_list_types);
		_g_object_unref0 (list_select);
		return;
	}
	_tmp9_ = self->priv->_model;
	_tmp10_ = *tree_iter;
	row_num = structure_model_get_list_num_from_tree_iter (_tmp9_, &_tmp10_);
	if (row_num == -1) {
		_g_object_unref0 (current_list_types);
		_g_object_unref0 (list_select);
		return;
	}
	_tmp11_ = gtk_tree_path_new_from_indices (row_num, -1, -1);
	list_path = _tmp11_;
	self->priv->_first_select = FALSE;
	_tmp12_ = list_select;
	_tmp13_ = list_path;
	gtk_tree_selection_select_path (_tmp12_, _tmp13_);
	_tmp14_ = self->priv->_list_view;
	_tmp15_ = list_path;
	gtk_tree_view_scroll_to_cell (_tmp14_, _tmp15_, NULL, FALSE, (gfloat) 0, (gfloat) 0);
	__vala_GtkTreePath_free0 (list_path);
	_g_object_unref0 (current_list_types);
	_g_object_unref0 (list_select);
}

static GeeArrayList*
structure_get_simple_list_types (Structure* self,
                                 StructType type)
{
	GeeArrayList* types = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (!structure_is_section (type), NULL);
	_tmp0_ = gee_array_list_new (TYPE_STRUCT_TYPE, NULL, NULL, NULL, NULL, NULL);
	types = _tmp0_;
	switch (type) {
		case STRUCT_TYPE_FIGURE:
		case STRUCT_TYPE_IMAGE:
		{
			GeeArrayList* _tmp1_;
			GeeArrayList* _tmp2_;
			_tmp1_ = types;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, (gpointer) ((gintptr) STRUCT_TYPE_FIGURE));
			_tmp2_ = types;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp2_, (gpointer) ((gintptr) STRUCT_TYPE_IMAGE));
			break;
		}
		case STRUCT_TYPE_TODO:
		case STRUCT_TYPE_FIXME:
		{
			GeeArrayList* _tmp3_;
			GeeArrayList* _tmp4_;
			_tmp3_ = types;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, (gpointer) ((gintptr) STRUCT_TYPE_TODO));
			_tmp4_ = types;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, (gpointer) ((gintptr) STRUCT_TYPE_FIXME));
			break;
		}
		default:
		{
			GeeArrayList* _tmp5_;
			_tmp5_ = types;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, (gpointer) ((gintptr) type));
			break;
		}
	}
	result = types;
	return result;
}

static void
structure_show_active_document (Structure* self)
{
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_document (_tmp0_);
	_tmp2_ = _tmp1_;
	structure_show_document (self, _tmp2_, FALSE);
}

static void
_structure_on_parsing_done_g_object_notify (GObject* _sender,
                                            GParamSpec* pspec,
                                            gpointer self)
{
	structure_on_parsing_done ((Structure*) self);
}

static void
structure_show_document (Structure* self,
                         Document* doc,
                         gboolean force_parse)
{
	GtkTreeView* _tmp0_;
	DocumentStructure* _tmp1_;
	DocumentStructure* _tmp5_;
	DocumentStructure* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	structure_set_model (self, NULL);
	_tmp0_ = self->priv->_tree_view;
	gtk_tree_view_columns_autosize (_tmp0_);
	_tmp1_ = self->priv->_document_structure;
	if (_tmp1_ != NULL) {
		DocumentStructure* _tmp2_;
		guint _tmp3_;
		GQuark _tmp4_;
		_tmp2_ = self->priv->_document_structure;
		g_signal_parse_name ("notify::parsing-done", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _structure_on_parsing_done_g_object_notify, self);
	}
	if (doc == NULL) {
		_g_object_unref0 (self->priv->_document_structure);
		self->priv->_document_structure = NULL;
		return;
	}
	_tmp5_ = document_get_structure (doc);
	_g_object_unref0 (self->priv->_document_structure);
	self->priv->_document_structure = _tmp5_;
	if (force_parse) {
		DocumentStructure* _tmp6_;
		_tmp6_ = self->priv->_document_structure;
		document_structure_parse (_tmp6_);
	}
	_tmp7_ = self->priv->_document_structure;
	_tmp8_ = document_structure_get_parsing_done (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		structure_on_parsing_done (self);
	} else {
		DocumentStructure* _tmp10_;
		_tmp10_ = self->priv->_document_structure;
		g_signal_connect_object ((GObject*) _tmp10_, "notify::parsing-done", (GCallback) _structure_on_parsing_done_g_object_notify, self, 0);
	}
}

static void
structure_on_parsing_done (Structure* self)
{
	DocumentStructure* _tmp0_;
	DocumentStructure* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_document_structure;
	g_return_if_fail (_tmp0_ != NULL);
	_tmp1_ = self->priv->_document_structure;
	_tmp2_ = document_structure_get_parsing_done (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		DocumentStructure* _tmp4_;
		StructureModel* _tmp5_;
		StructureModel* _tmp6_;
		_tmp4_ = self->priv->_document_structure;
		_tmp5_ = document_structure_get_model (_tmp4_);
		_tmp6_ = _tmp5_;
		structure_set_model (self, _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
}

static void
structure_set_model (Structure* self,
                     StructureModel* model)
{
	StructureModel* _tmp0_;
	GtkTreeView* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	if (model != NULL) {
		structure_model_set_emit_signals (model, TRUE);
	}
	_tmp0_ = _g_object_ref0 (model);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp0_;
	_tmp1_ = self->priv->_tree_view;
	gtk_tree_view_set_model (_tmp1_, (GtkTreeModel*) model);
	if (model != NULL) {
		_tmp2_ = structure_model_get_nb_items (model) <= ((guint) 2000);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GtkTreeView* _tmp3_;
		_tmp3_ = self->priv->_tree_view;
		gtk_tree_view_expand_all (_tmp3_);
	}
	structure_populate_simple_list (self);
}

static void
_structure_show_active_document_g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	structure_show_active_document ((Structure*) self);
}

void
structure_connect_parsing (Structure* self)
{
	MainWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::active-document", (GCallback) _structure_show_active_document_g_object_notify, self, 0);
	structure_show_active_document (self);
}

void
structure_disconnect_parsing (Structure* self)
{
	MainWindow* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_main_window;
	g_signal_parse_name ("notify::active-document", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _structure_show_active_document_g_object_notify, self);
}

gboolean
structure_is_section (StructType type)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (STRUCT_TYPE_PART <= type) {
		_tmp0_ = type <= STRUCT_TYPE_SUBPARAGRAPH;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
structure_is_common_type (StructType type)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (STRUCT_TYPE_BEGIN_COMMON_TYPES < type) {
		_tmp0_ = type < STRUCT_TYPE_END_COMMON_TYPES;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/*************************************************************************/
void
structure_do_action (Structure* self,
                     StructAction action_type)
{
	GtkTreeIter selected_iter = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	gboolean refresh_simple_list = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_tree_view;
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
	selected_iter = _tmp1_;
	selected_row = _tmp2_;
	g_return_if_fail (selected_row != -1);
	if (action_type == STRUCT_ACTION_OPEN_FILE) {
		GtkTreeIter _tmp3_;
		_tmp3_ = selected_iter;
		structure_open_referenced_file (self, &_tmp3_);
		return;
	}
	refresh_simple_list = FALSE;
	{
		DocumentStructure* _tmp4_;
		GtkTreeIter _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = self->priv->_document_structure;
		_tmp5_ = selected_iter;
		document_structure_do_action (_tmp4_, action_type, &_tmp5_, &_tmp6_, &_inner_error0_);
		refresh_simple_list = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == STRUCT_ERROR) {
				goto __catch0_struct_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_struct_error:
	{
		GError* e = NULL;
		GtkMessageDialog* dialog = NULL;
		MainWindow* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GtkMessageDialog* _tmp10_;
		GtkMessageDialog* _tmp11_;
		GError* _tmp12_;
		GtkMessageDialog* _tmp17_;
		GtkMessageDialog* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = self->priv->_main_window;
		_tmp8_ = structure_get_action_name (action_type);
		_tmp9_ = _tmp8_;
		_tmp10_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp7_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("Structure action error: %s"), _tmp9_);
		g_object_ref_sink (_tmp10_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp9_);
		dialog = _tmp11_;
		_tmp12_ = e;
		if (g_error_matches (_tmp12_, STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED)) {
			GtkMessageDialog* _tmp13_;
			_tmp13_ = dialog;
			g_object_set (_tmp13_, "secondary-text", _ ("The structure data seems outdated. Please refresh the structure."), NULL);
		} else {
			GtkMessageDialog* _tmp14_;
			GError* _tmp15_;
			const gchar* _tmp16_;
			_tmp14_ = dialog;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			g_object_set (_tmp14_, "secondary-text", _tmp16_, NULL);
		}
		_tmp17_ = dialog;
		gtk_dialog_run ((GtkDialog*) _tmp17_);
		_tmp18_ = dialog;
		gtk_widget_destroy ((GtkWidget*) _tmp18_);
		_g_object_unref0 (dialog);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (refresh_simple_list) {
		structure_populate_simple_list (self);
	}
}

static void
structure_open_referenced_file (Structure* self,
                                GtkTreeIter* iter)
{
	MainWindow* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	StructType type = 0;
	gchar* filename = NULL;
	StructureModel* _tmp3_;
	GtkTreeIter _tmp4_;
	StructType _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	GFile* doc_location = NULL;
	MainWindow* _tmp7_;
	Document* _tmp8_;
	Document* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	GFile* parent = NULL;
	GFile* _tmp14_;
	GFile* _tmp15_;
	GFile* _tmp16_;
	GFile* referenced_file = NULL;
	GFile* _tmp17_;
	const gchar* _tmp18_;
	GFile* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_document (_tmp0_);
	_tmp2_ = _tmp1_;
	g_return_if_fail (_tmp2_ != NULL);
	_tmp3_ = self->priv->_model;
	_tmp4_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, STRUCT_COLUMN_TYPE, &_tmp5_, STRUCT_COLUMN_TEXT, &_tmp6_, -1);
	type = _tmp5_;
	_g_free0 (filename);
	filename = _tmp6_;
	_tmp7_ = self->priv->_main_window;
	_tmp8_ = main_window_get_active_document (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = document_get_location (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	doc_location = _tmp12_;
	_tmp13_ = doc_location;
	if (_tmp13_ == NULL) {
		_g_object_unref0 (doc_location);
		_g_free0 (filename);
		return;
	}
	_tmp14_ = doc_location;
	_tmp15_ = g_file_get_parent (_tmp14_);
	parent = _tmp15_;
	_tmp16_ = parent;
	g_return_if_fail (_tmp16_ != NULL);
	_tmp17_ = parent;
	_tmp18_ = filename;
	_tmp19_ = g_file_get_child (_tmp17_, _tmp18_);
	referenced_file = _tmp19_;
	switch (type) {
		case STRUCT_TYPE_INCLUDE:
		{
			GFile* _tmp20_;
			_tmp20_ = referenced_file;
			structure_open_included_file (self, _tmp20_);
			break;
		}
		case STRUCT_TYPE_IMAGE:
		{
			GFile* _tmp21_;
			_tmp21_ = referenced_file;
			structure_open_image (self, _tmp21_);
			break;
		}
		default:
		{
			g_return_if_reached ();
		}
	}
	_g_object_unref0 (referenced_file);
	_g_object_unref0 (parent);
	_g_object_unref0 (doc_location);
	_g_free0 (filename);
}

static void
structure_open_included_file (Structure* self,
                              GFile* referenced_file)
{
	GFile* file_to_open = NULL;
	MainWindow* _tmp10_;
	GFile* _tmp11_;
	DocumentTab* _tmp12_;
	DocumentTab* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (referenced_file != NULL);
	if (g_file_query_exists (referenced_file, NULL)) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (referenced_file);
		_g_object_unref0 (file_to_open);
		file_to_open = _tmp0_;
	} else {
		gchar* uri = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		_tmp1_ = g_file_get_uri (referenced_file);
		uri = _tmp1_;
		_tmp2_ = uri;
		_tmp3_ = g_strconcat (_tmp2_, ".tex", NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_new_for_uri (_tmp4_);
		_g_object_unref0 (file_to_open);
		file_to_open = _tmp5_;
		_g_free0 (_tmp4_);
		_tmp6_ = file_to_open;
		if (!g_file_query_exists (_tmp6_, NULL)) {
			GFile* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp7_ = file_to_open;
			_tmp8_ = g_file_get_parse_name (_tmp7_);
			_tmp9_ = _tmp8_;
			g_warning ("structure.vala:703: Structure: the file '%s' doesn't exist.", _tmp9_);
			_g_free0 (_tmp9_);
			_g_free0 (uri);
			_g_object_unref0 (file_to_open);
			return;
		}
		_g_free0 (uri);
	}
	_tmp10_ = self->priv->_main_window;
	_tmp11_ = file_to_open;
	_tmp12_ = main_window_open_document (_tmp10_, _tmp11_, TRUE);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp13_);
	_g_object_unref0 (file_to_open);
}

static void
structure_open_image (Structure* self,
                      GFile* referenced_file)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (referenced_file != NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = g_file_get_uri (referenced_file);
		_tmp1_ = _tmp0_;
		latexila_utils_show_uri ((GtkWidget*) self, _tmp1_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
		_g_free0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("structure.vala:720: Structure: can not open image: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
structure_get_action_name (StructAction action_type)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* result;
	_tmp0_ = structure__action_names;
	_tmp0__length1 = structure__action_names_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		gchar* _tmp17_;
		_tmp1_ = g_new0 (gchar*, STRUCT_ACTION_NB_ACTIONS + 1);
		structure__action_names = (_vala_array_free (structure__action_names, structure__action_names_length1, (GDestroyNotify) g_free), NULL);
		structure__action_names = _tmp1_;
		structure__action_names_length1 = STRUCT_ACTION_NB_ACTIONS;
		_structure__action_names_size_ = structure__action_names_length1;
		_tmp2_ = structure__action_names;
		_tmp2__length1 = structure__action_names_length1;
		_tmp3_ = g_strdup (_ ("cut"));
		_g_free0 (_tmp2_[STRUCT_ACTION_CUT]);
		_tmp2_[STRUCT_ACTION_CUT] = _tmp3_;
		_tmp4_ = structure__action_names;
		_tmp4__length1 = structure__action_names_length1;
		_tmp5_ = g_strdup (_ ("copy"));
		_g_free0 (_tmp4_[STRUCT_ACTION_COPY]);
		_tmp4_[STRUCT_ACTION_COPY] = _tmp5_;
		_tmp6_ = structure__action_names;
		_tmp6__length1 = structure__action_names_length1;
		_tmp7_ = g_strdup (_ ("delete"));
		_g_free0 (_tmp6_[STRUCT_ACTION_DELETE]);
		_tmp6_[STRUCT_ACTION_DELETE] = _tmp7_;
		_tmp8_ = structure__action_names;
		_tmp8__length1 = structure__action_names_length1;
		_tmp9_ = g_strdup (_ ("select"));
		_g_free0 (_tmp8_[STRUCT_ACTION_SELECT]);
		_tmp8_[STRUCT_ACTION_SELECT] = _tmp9_;
		_tmp10_ = structure__action_names;
		_tmp10__length1 = structure__action_names_length1;
		_tmp11_ = g_strdup (_ ("comment"));
		_g_free0 (_tmp10_[STRUCT_ACTION_COMMENT]);
		_tmp10_[STRUCT_ACTION_COMMENT] = _tmp11_;
		_tmp12_ = structure__action_names;
		_tmp12__length1 = structure__action_names_length1;
		_tmp13_ = g_strdup (_ ("shift left"));
		_g_free0 (_tmp12_[STRUCT_ACTION_SHIFT_LEFT]);
		_tmp12_[STRUCT_ACTION_SHIFT_LEFT] = _tmp13_;
		_tmp14_ = structure__action_names;
		_tmp14__length1 = structure__action_names_length1;
		_tmp15_ = g_strdup (_ ("shift right"));
		_g_free0 (_tmp14_[STRUCT_ACTION_SHIFT_RIGHT]);
		_tmp14_[STRUCT_ACTION_SHIFT_RIGHT] = _tmp15_;
		_tmp16_ = structure__action_names;
		_tmp16__length1 = structure__action_names_length1;
		_tmp17_ = g_strdup (_ ("open file"));
		_g_free0 (_tmp16_[STRUCT_ACTION_OPEN_FILE]);
		_tmp16_[STRUCT_ACTION_OPEN_FILE] = _tmp17_;
	}
	_tmp18_ = structure__action_names;
	_tmp18__length1 = structure__action_names_length1;
	_tmp19_ = _tmp18_[action_type];
	_tmp20_ = g_strdup (_tmp19_);
	result = _tmp20_;
	return result;
}

gchar*
structure_get_icon_from_type (StructType type)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp30_;
	gint _tmp30__length1;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* result;
	_tmp0_ = structure__icons;
	_tmp0__length1 = structure__icons_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		gchar* _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar* _tmp21_;
		gchar** _tmp22_;
		gint _tmp22__length1;
		gchar* _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		gchar* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar* _tmp27_;
		gchar** _tmp28_;
		gint _tmp28__length1;
		gchar* _tmp29_;
		_tmp1_ = g_new0 (gchar*, STRUCT_TYPE_NB_TYPES + 1);
		structure__icons = (_vala_array_free (structure__icons, structure__icons_length1, (GDestroyNotify) g_free), NULL);
		structure__icons = _tmp1_;
		structure__icons_length1 = STRUCT_TYPE_NB_TYPES;
		_structure__icons_size_ = structure__icons_length1;
		_tmp2_ = structure__icons;
		_tmp2__length1 = structure__icons_length1;
		_tmp3_ = g_strdup ("tree_part");
		_g_free0 (_tmp2_[STRUCT_TYPE_PART]);
		_tmp2_[STRUCT_TYPE_PART] = _tmp3_;
		_tmp4_ = structure__icons;
		_tmp4__length1 = structure__icons_length1;
		_tmp5_ = g_strdup ("tree_chapter");
		_g_free0 (_tmp4_[STRUCT_TYPE_CHAPTER]);
		_tmp4_[STRUCT_TYPE_CHAPTER] = _tmp5_;
		_tmp6_ = structure__icons;
		_tmp6__length1 = structure__icons_length1;
		_tmp7_ = g_strdup ("tree_section");
		_g_free0 (_tmp6_[STRUCT_TYPE_SECTION]);
		_tmp6_[STRUCT_TYPE_SECTION] = _tmp7_;
		_tmp8_ = structure__icons;
		_tmp8__length1 = structure__icons_length1;
		_tmp9_ = g_strdup ("tree_subsection");
		_g_free0 (_tmp8_[STRUCT_TYPE_SUBSECTION]);
		_tmp8_[STRUCT_TYPE_SUBSECTION] = _tmp9_;
		_tmp10_ = structure__icons;
		_tmp10__length1 = structure__icons_length1;
		_tmp11_ = g_strdup ("tree_subsubsection");
		_g_free0 (_tmp10_[STRUCT_TYPE_SUBSUBSECTION]);
		_tmp10_[STRUCT_TYPE_SUBSUBSECTION] = _tmp11_;
		_tmp12_ = structure__icons;
		_tmp12__length1 = structure__icons_length1;
		_tmp13_ = g_strdup ("tree_paragraph");
		_g_free0 (_tmp12_[STRUCT_TYPE_PARAGRAPH]);
		_tmp12_[STRUCT_TYPE_PARAGRAPH] = _tmp13_;
		_tmp14_ = structure__icons;
		_tmp14__length1 = structure__icons_length1;
		_tmp15_ = g_strdup ("tree_paragraph");
		_g_free0 (_tmp14_[STRUCT_TYPE_SUBPARAGRAPH]);
		_tmp14_[STRUCT_TYPE_SUBPARAGRAPH] = _tmp15_;
		_tmp16_ = structure__icons;
		_tmp16__length1 = structure__icons_length1;
		_tmp17_ = g_strdup ("tree_label");
		_g_free0 (_tmp16_[STRUCT_TYPE_LABEL]);
		_tmp16_[STRUCT_TYPE_LABEL] = _tmp17_;
		_tmp18_ = structure__icons;
		_tmp18__length1 = structure__icons_length1;
		_tmp19_ = g_strdup ("tree_todo");
		_g_free0 (_tmp18_[STRUCT_TYPE_TODO]);
		_tmp18_[STRUCT_TYPE_TODO] = _tmp19_;
		_tmp20_ = structure__icons;
		_tmp20__length1 = structure__icons_length1;
		_tmp21_ = g_strdup ("tree_todo");
		_g_free0 (_tmp20_[STRUCT_TYPE_FIXME]);
		_tmp20_[STRUCT_TYPE_FIXME] = _tmp21_;
		_tmp22_ = structure__icons;
		_tmp22__length1 = structure__icons_length1;
		_tmp23_ = g_strdup ("table");
		_g_free0 (_tmp22_[STRUCT_TYPE_TABLE]);
		_tmp22_[STRUCT_TYPE_TABLE] = _tmp23_;
		_tmp24_ = structure__icons;
		_tmp24__length1 = structure__icons_length1;
		_tmp25_ = g_strdup ("image-x-generic");
		_g_free0 (_tmp24_[STRUCT_TYPE_FIGURE]);
		_tmp24_[STRUCT_TYPE_FIGURE] = _tmp25_;
		_tmp26_ = structure__icons;
		_tmp26__length1 = structure__icons_length1;
		_tmp27_ = g_strdup ("image-x-generic");
		_g_free0 (_tmp26_[STRUCT_TYPE_IMAGE]);
		_tmp26_[STRUCT_TYPE_IMAGE] = _tmp27_;
		_tmp28_ = structure__icons;
		_tmp28__length1 = structure__icons_length1;
		_tmp29_ = g_strdup ("text-x-generic");
		_g_free0 (_tmp28_[STRUCT_TYPE_INCLUDE]);
		_tmp28_[STRUCT_TYPE_INCLUDE] = _tmp29_;
	}
	_tmp30_ = structure__icons;
	_tmp30__length1 = structure__icons_length1;
	_tmp31_ = _tmp30_[type];
	_tmp32_ = g_strdup (_tmp31_);
	result = _tmp32_;
	return result;
}

gchar*
structure_get_type_name (StructType type)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp30_;
	gint _tmp30__length1;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* result;
	_tmp0_ = structure__names;
	_tmp0__length1 = structure__names_length1;
	if (_tmp0_ == NULL) {
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		gchar* _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		gchar* _tmp19_;
		gchar** _tmp20_;
		gint _tmp20__length1;
		gchar* _tmp21_;
		gchar** _tmp22_;
		gint _tmp22__length1;
		gchar* _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		gchar* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar* _tmp27_;
		gchar** _tmp28_;
		gint _tmp28__length1;
		gchar* _tmp29_;
		_tmp1_ = g_new0 (gchar*, STRUCT_TYPE_NB_TYPES + 1);
		structure__names = (_vala_array_free (structure__names, structure__names_length1, (GDestroyNotify) g_free), NULL);
		structure__names = _tmp1_;
		structure__names_length1 = STRUCT_TYPE_NB_TYPES;
		_structure__names_size_ = structure__names_length1;
		_tmp2_ = structure__names;
		_tmp2__length1 = structure__names_length1;
		_tmp3_ = g_strdup (_ ("Part"));
		_g_free0 (_tmp2_[STRUCT_TYPE_PART]);
		_tmp2_[STRUCT_TYPE_PART] = _tmp3_;
		_tmp4_ = structure__names;
		_tmp4__length1 = structure__names_length1;
		_tmp5_ = g_strdup (_ ("Chapter"));
		_g_free0 (_tmp4_[STRUCT_TYPE_CHAPTER]);
		_tmp4_[STRUCT_TYPE_CHAPTER] = _tmp5_;
		_tmp6_ = structure__names;
		_tmp6__length1 = structure__names_length1;
		_tmp7_ = g_strdup (_ ("Section"));
		_g_free0 (_tmp6_[STRUCT_TYPE_SECTION]);
		_tmp6_[STRUCT_TYPE_SECTION] = _tmp7_;
		_tmp8_ = structure__names;
		_tmp8__length1 = structure__names_length1;
		_tmp9_ = g_strdup (_ ("Sub-section"));
		_g_free0 (_tmp8_[STRUCT_TYPE_SUBSECTION]);
		_tmp8_[STRUCT_TYPE_SUBSECTION] = _tmp9_;
		_tmp10_ = structure__names;
		_tmp10__length1 = structure__names_length1;
		_tmp11_ = g_strdup (_ ("Sub-sub-section"));
		_g_free0 (_tmp10_[STRUCT_TYPE_SUBSUBSECTION]);
		_tmp10_[STRUCT_TYPE_SUBSUBSECTION] = _tmp11_;
		_tmp12_ = structure__names;
		_tmp12__length1 = structure__names_length1;
		_tmp13_ = g_strdup (_ ("Paragraph"));
		_g_free0 (_tmp12_[STRUCT_TYPE_PARAGRAPH]);
		_tmp12_[STRUCT_TYPE_PARAGRAPH] = _tmp13_;
		_tmp14_ = structure__names;
		_tmp14__length1 = structure__names_length1;
		_tmp15_ = g_strdup (_ ("Sub-paragraph"));
		_g_free0 (_tmp14_[STRUCT_TYPE_SUBPARAGRAPH]);
		_tmp14_[STRUCT_TYPE_SUBPARAGRAPH] = _tmp15_;
		_tmp16_ = structure__names;
		_tmp16__length1 = structure__names_length1;
		_tmp17_ = g_strdup (_ ("Label"));
		_g_free0 (_tmp16_[STRUCT_TYPE_LABEL]);
		_tmp16_[STRUCT_TYPE_LABEL] = _tmp17_;
		_tmp18_ = structure__names;
		_tmp18__length1 = structure__names_length1;
		_tmp19_ = g_strdup ("TODO");
		_g_free0 (_tmp18_[STRUCT_TYPE_TODO]);
		_tmp18_[STRUCT_TYPE_TODO] = _tmp19_;
		_tmp20_ = structure__names;
		_tmp20__length1 = structure__names_length1;
		_tmp21_ = g_strdup ("FIXME");
		_g_free0 (_tmp20_[STRUCT_TYPE_FIXME]);
		_tmp20_[STRUCT_TYPE_FIXME] = _tmp21_;
		_tmp22_ = structure__names;
		_tmp22__length1 = structure__names_length1;
		_tmp23_ = g_strdup (_ ("Table"));
		_g_free0 (_tmp22_[STRUCT_TYPE_TABLE]);
		_tmp22_[STRUCT_TYPE_TABLE] = _tmp23_;
		_tmp24_ = structure__names;
		_tmp24__length1 = structure__names_length1;
		_tmp25_ = g_strdup (_ ("Figure"));
		_g_free0 (_tmp24_[STRUCT_TYPE_FIGURE]);
		_tmp24_[STRUCT_TYPE_FIGURE] = _tmp25_;
		_tmp26_ = structure__names;
		_tmp26__length1 = structure__names_length1;
		_tmp27_ = g_strdup (_ ("Image"));
		_g_free0 (_tmp26_[STRUCT_TYPE_IMAGE]);
		_tmp26_[STRUCT_TYPE_IMAGE] = _tmp27_;
		_tmp28_ = structure__names;
		_tmp28__length1 = structure__names_length1;
		_tmp29_ = g_strdup (_ ("File included"));
		_g_free0 (_tmp28_[STRUCT_TYPE_INCLUDE]);
		_tmp28_[STRUCT_TYPE_INCLUDE] = _tmp29_;
	}
	_tmp30_ = structure__names;
	_tmp30__length1 = structure__names_length1;
	_tmp31_ = _tmp30_[type];
	_tmp32_ = g_strdup (_tmp31_);
	result = _tmp32_;
	return result;
}

static void
structure_class_init (StructureClass * klass,
                      gpointer klass_data)
{
	structure_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Structure_private_offset);
	G_OBJECT_CLASS (klass)->finalize = structure_finalize;
	structure_signals[STRUCTURE_NO_ITEMS_SELECTED_SIGNAL] = g_signal_new ("no-items-selected", TYPE_STRUCTURE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	structure_signals[STRUCTURE_ITEM_SELECTED_SIGNAL] = g_signal_new ("item-selected", TYPE_STRUCTURE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__ENUM, G_TYPE_NONE, 1, TYPE_STRUCT_TYPE);
	structure_signals[STRUCTURE_SHOW_POPUP_MENU_SIGNAL] = g_signal_new ("show-popup-menu", TYPE_STRUCTURE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOXED, G_TYPE_NONE, 1, gdk_event_get_type ());
}

static void
structure_instance_init (Structure * self,
                         gpointer klass)
{
	GtkToggleToolButton** _tmp0_;
	self->priv = structure_get_instance_private (self);
	_tmp0_ = g_new0 (GtkToggleToolButton*, 0 + 1);
	self->priv->_simple_list_buttons = _tmp0_;
	self->priv->_simple_list_buttons_length1 = 0;
	self->priv->__simple_list_buttons_size_ = self->priv->_simple_list_buttons_length1;
	self->priv->_document_structure = NULL;
	self->priv->_model = NULL;
	self->priv->_list_is_hidden = TRUE;
	self->priv->_first_select = TRUE;
}

static void
structure_finalize (GObject * obj)
{
	Structure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_STRUCTURE, Structure);
	self->priv->_simple_list_buttons = (_vala_array_free (self->priv->_simple_list_buttons, self->priv->_simple_list_buttons_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->_vpaned);
	_g_object_unref0 (self->priv->_tree_view);
	_g_object_unref0 (self->priv->_document_structure);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->_list_view);
	_g_object_unref0 (self->priv->_list_view_sw);
	_g_object_unref0 (self->priv->_list_store);
	G_OBJECT_CLASS (structure_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
structure_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (StructureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) structure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Structure), 0, (GInstanceInitFunc) structure_instance_init, NULL };
	GType structure_type_id;
	structure_type_id = g_type_register_static (gtk_grid_get_type (), "Structure", &g_define_type_info, 0);
	Structure_private_offset = g_type_add_instance_private (structure_type_id, sizeof (StructurePrivate));
	return structure_type_id;
}

GType
structure_get_type (void)
{
	static gsize structure_type_id__once = 0;
	if (g_once_init_enter (&structure_type_id__once)) {
		GType structure_type_id;
		structure_type_id = structure_get_type_once ();
		g_once_init_leave (&structure_type_id__once, structure_type_id);
	}
	return structure_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

