/* preferences_dialog.c generated by valac 0.56.17, the Vala compiler
 * generated from preferences_dialog.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2022 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tepl/tepl.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

VALA_EXTERN void preferences_dialog_fill (TeplPrefsDialog* prefs_dialog);
VALA_EXTERN void preferences_dialog_reset_all (void);
static void _preferences_dialog_reset_all_gtk_button_clicked (GtkButton* _sender,
                                                       gpointer self);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static void
_preferences_dialog_reset_all_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self)
{
	preferences_dialog_reset_all ();
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
preferences_dialog_fill (TeplPrefsDialog* prefs_dialog)
{
	GtkButton* reset_button = NULL;
	GtkButton* _tmp0_;
	GtkHeaderBar* headerbar = NULL;
	GtkHeaderBar* _tmp1_;
	GtkHeaderBar* _tmp2_;
	GtkBox* content_area = NULL;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkNotebook* _tmp5_;
	g_return_if_fail (prefs_dialog != NULL);
	_tmp0_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Reset All"));
	g_object_ref_sink (_tmp0_);
	reset_button = _tmp0_;
	gtk_widget_set_tooltip_text ((GtkWidget*) reset_button, _ ("Reset all preferences"));
	gtk_widget_show_all ((GtkWidget*) reset_button);
	g_signal_connect (reset_button, "clicked", (GCallback) _preferences_dialog_reset_all_gtk_button_clicked, NULL);
	_tmp1_ = gtk_dialog_get_header_bar ((GtkDialog*) prefs_dialog);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_header_bar_get_type ()) ? ((GtkHeaderBar*) _tmp1_) : NULL);
	headerbar = _tmp2_;
	gtk_header_bar_pack_start (headerbar, (GtkWidget*) reset_button);
	_tmp3_ = gtk_dialog_get_content_area ((GtkDialog*) prefs_dialog);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_box_get_type ()) ? ((GtkBox*) _tmp3_) : NULL);
	content_area = _tmp4_;
	_tmp5_ = latexila_prefs_create_notebook ();
	gtk_box_pack_start (content_area, (GtkWidget*) _tmp5_, TRUE, TRUE, (guint) 0);
	_g_object_unref0 (content_area);
	_g_object_unref0 (headerbar);
	_g_object_unref0 (reset_button);
}

void
preferences_dialog_reset_all (void)
{
	TeplPrefsDialog* prefs_dialog = NULL;
	TeplPrefsDialog* _tmp0_;
	TeplPrefsDialog* _tmp1_;
	GtkDialog* dialog = NULL;
	TeplPrefsDialog* _tmp2_;
	GtkMessageDialog* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	gint resp = 0;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	gchar** settings_str = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint settings_str_length1;
	gint _settings_str_size_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	_tmp0_ = tepl_prefs_dialog_get_singleton ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	prefs_dialog = _tmp1_;
	_tmp2_ = prefs_dialog;
	_tmp3_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp2_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Do you really want to reset all preferences?"));
	g_object_ref_sink (_tmp3_);
	dialog = (GtkDialog*) _tmp3_;
	_tmp4_ = dialog;
	gtk_dialog_add_button (_tmp4_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp5_ = dialog;
	gtk_dialog_add_button (_tmp5_, _ ("_Reset All"), (gint) GTK_RESPONSE_YES);
	_tmp6_ = dialog;
	resp = gtk_dialog_run (_tmp6_);
	_tmp7_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp7_);
	if (resp != ((gint) GTK_RESPONSE_YES)) {
		_g_object_unref0 (dialog);
		_g_object_unref0 (prefs_dialog);
		return;
	}
	_tmp8_ = g_strdup ("org.gnome.gnome-latex.preferences.editor");
	_tmp9_ = g_strdup ("org.gnome.gnome-latex.preferences.latex");
	_tmp10_ = g_new0 (gchar*, 2 + 1);
	_tmp10_[0] = _tmp8_;
	_tmp10_[1] = _tmp9_;
	settings_str = _tmp10_;
	settings_str_length1 = 2;
	_settings_str_size_ = settings_str_length1;
	_tmp11_ = settings_str;
	_tmp11__length1 = settings_str_length1;
	{
		gchar** setting_str_collection = NULL;
		gint setting_str_collection_length1 = 0;
		gint _setting_str_collection_size_ = 0;
		gint setting_str_it = 0;
		setting_str_collection = _tmp11_;
		setting_str_collection_length1 = _tmp11__length1;
		for (setting_str_it = 0; setting_str_it < setting_str_collection_length1; setting_str_it = setting_str_it + 1) {
			gchar* _tmp12_;
			gchar* setting_str = NULL;
			_tmp12_ = g_strdup (setting_str_collection[setting_str_it]);
			setting_str = _tmp12_;
			{
				GSettings* settings = NULL;
				const gchar* _tmp13_;
				GSettings* _tmp14_;
				gchar** keys = NULL;
				GSettings* _tmp15_;
				gchar** _tmp16_;
				gchar** _tmp17_;
				gint keys_length1;
				gint _keys_size_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				_tmp13_ = setting_str;
				_tmp14_ = g_settings_new (_tmp13_);
				settings = _tmp14_;
				_tmp15_ = settings;
				_tmp17_ = _tmp16_ = g_settings_list_keys (_tmp15_);
				keys = _tmp17_;
				keys_length1 = _vala_array_length (_tmp16_);
				_keys_size_ = keys_length1;
				_tmp18_ = keys;
				_tmp18__length1 = keys_length1;
				{
					gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
					key_collection = _tmp18_;
					key_collection_length1 = _tmp18__length1;
					for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
						gchar* _tmp19_;
						gchar* key = NULL;
						_tmp19_ = g_strdup (key_collection[key_it]);
						key = _tmp19_;
						{
							GSettings* _tmp20_;
							const gchar* _tmp21_;
							_tmp20_ = settings;
							_tmp21_ = key;
							g_settings_reset (_tmp20_, _tmp21_);
							_g_free0 (key);
						}
					}
				}
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (settings);
				_g_free0 (setting_str);
			}
		}
	}
	settings_str = (_vala_array_free (settings_str, settings_str_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (dialog);
	_g_object_unref0 (prefs_dialog);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

