/* most_used_symbols.c generated by valac 0.56.17, the Vala compiler
 * generated from most_used_symbols.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#define MOST_USED_SYMBOLS_SYMBOL_COLUMN_NUM ((gint) SYMBOL_COLUMN_N_COLUMNS)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;
typedef struct _MostUsedSymbolsPrivate MostUsedSymbolsPrivate;
enum  {
	MOST_USED_SYMBOLS_0_PROPERTY,
	MOST_USED_SYMBOLS_NUM_PROPERTIES
};
static GParamSpec* most_used_symbols_properties[MOST_USED_SYMBOLS_NUM_PROPERTIES];
typedef enum  {
	SYMBOL_COLUMN_PIXBUF,
	SYMBOL_COLUMN_COMMAND,
	SYMBOL_COLUMN_TOOLTIP,
	SYMBOL_COLUMN_ID,
	SYMBOL_COLUMN_N_COLUMNS
} SymbolColumn;

#define TYPE_SYMBOL_COLUMN (symbol_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SYMBOLS (symbols_get_type ())
#define SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS, Symbols))
#define SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS, SymbolsClass))
#define IS_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS))
#define IS_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS))
#define SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS, SymbolsClass))

typedef struct _Symbols Symbols;
typedef struct _SymbolsClass SymbolsClass;
typedef void (*GMarkupParserStartElementFunc) (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer user_data, GError** error);
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _MostUsedSymbols {
	GObject parent_instance;
	MostUsedSymbolsPrivate * priv;
};

struct _MostUsedSymbolsClass {
	GObjectClass parent_class;
};

struct _MostUsedSymbolsPrivate {
	gboolean _modified;
	GtkListStore* _store;
};

static gint MostUsedSymbols_private_offset;
static gpointer most_used_symbols_parent_class = NULL;
static MostUsedSymbols* most_used_symbols__instance;
static MostUsedSymbols* most_used_symbols__instance = NULL;

VALA_EXTERN GType most_used_symbols_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MostUsedSymbols, g_object_unref)
VALA_EXTERN GType symbol_column_get_type (void) G_GNUC_CONST ;
static MostUsedSymbols* most_used_symbols_new (void);
static MostUsedSymbols* most_used_symbols_construct (GType object_type);
static void most_used_symbols_init_models (MostUsedSymbols* self);
static void most_used_symbols_load_data (MostUsedSymbols* self);
VALA_EXTERN MostUsedSymbols* most_used_symbols_get_default (void);
VALA_EXTERN GtkTreeModel* most_used_symbols_get_model (MostUsedSymbols* self);
VALA_EXTERN void most_used_symbols_clear (MostUsedSymbols* self);
VALA_EXTERN void most_used_symbols_increment_symbol (MostUsedSymbols* self,
                                         const gchar* id);
static gboolean most_used_symbols_get_iter_at_symbol_id (MostUsedSymbols* self,
                                                  const gchar* id,
                                                  GtkTreeIter* iter);
static void most_used_symbols_add_symbol (MostUsedSymbols* self,
                                   const gchar* id,
                                   gint nb_times_used);
VALA_EXTERN GdkPixbuf* symbols_get_pixbuf (const gchar* symbol_id);
VALA_EXTERN GType symbols_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Symbols, g_object_unref)
VALA_EXTERN Symbols* symbols_get_default (void);
VALA_EXTERN gboolean symbols_get_symbol_info (Symbols* self,
                                  const gchar* id,
                                  gchar** command,
                                  gchar** tooltip);
static GFile* most_used_symbols_get_xml_file (MostUsedSymbols* self);
VALA_EXTERN gchar* utils_load_file (GFile* file);
static void most_used_symbols_parser_start (MostUsedSymbols* self,
                                     GMarkupParseContext* context,
                                     const gchar* name,
                                     gchar** attr_names,
                                     gint attr_names_length1,
                                     gchar** attr_values,
                                     gint attr_values_length1,
                                     GError** error);
static void _most_used_symbols_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                        const gchar* element_name,
                                                                        gchar** attribute_names,
                                                                        gchar** attribute_values,
                                                                        gpointer self,
                                                                        GError** error);
VALA_EXTERN void most_used_symbols_save (MostUsedSymbols* self);
VALA_EXTERN void utils_delete_file (GFile* file);
VALA_EXTERN gboolean utils_save_file (GFile* file,
                          const gchar* contents,
                          gboolean make_backup);
static void most_used_symbols_finalize (GObject * obj);
static GType most_used_symbols_get_type_once (void);
static gssize _vala_array_length (gpointer array);

static inline gpointer
most_used_symbols_get_instance_private (MostUsedSymbols* self)
{
	return G_STRUCT_MEMBER_P (self, MostUsedSymbols_private_offset);
}

static MostUsedSymbols*
most_used_symbols_construct (GType object_type)
{
	MostUsedSymbols * self = NULL;
	self = (MostUsedSymbols*) g_object_new (object_type, NULL);
	most_used_symbols_init_models (self);
	most_used_symbols_load_data (self);
	return self;
}

static MostUsedSymbols*
most_used_symbols_new (void)
{
	return most_used_symbols_construct (TYPE_MOST_USED_SYMBOLS);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

MostUsedSymbols*
most_used_symbols_get_default (void)
{
	MostUsedSymbols* _tmp0_;
	MostUsedSymbols* _tmp2_;
	MostUsedSymbols* _tmp3_;
	MostUsedSymbols* result;
	_tmp0_ = most_used_symbols__instance;
	if (_tmp0_ == NULL) {
		MostUsedSymbols* _tmp1_;
		_tmp1_ = most_used_symbols_new ();
		_g_object_unref0 (most_used_symbols__instance);
		most_used_symbols__instance = _tmp1_;
	}
	_tmp2_ = most_used_symbols__instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
most_used_symbols_init_models (MostUsedSymbols* self)
{
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_list_store_new ((gint) (SYMBOL_COLUMN_N_COLUMNS + 1), gdk_pixbuf_get_type (), G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT, -1);
	_g_object_unref0 (self->priv->_store);
	self->priv->_store = _tmp0_;
	_tmp1_ = self->priv->_store;
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp1_, MOST_USED_SYMBOLS_SYMBOL_COLUMN_NUM, GTK_SORT_DESCENDING);
}

GtkTreeModel*
most_used_symbols_get_model (MostUsedSymbols* self)
{
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_store;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp0_) : NULL);
	result = _tmp1_;
	return result;
}

void
most_used_symbols_clear (MostUsedSymbols* self)
{
	GtkListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_store;
	gtk_list_store_clear (_tmp0_);
}

void
most_used_symbols_increment_symbol (MostUsedSymbols* self,
                                    const gchar* id)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp1_ = most_used_symbols_get_iter_at_symbol_id (self, id, &_tmp0_);
	iter = _tmp0_;
	if (!_tmp1_) {
		most_used_symbols_add_symbol (self, id, 1);
	} else {
		gint num = 0;
		GtkTreeModel* model = NULL;
		GtkListStore* _tmp2_;
		GtkTreeModel* _tmp3_;
		GtkTreeModel* _tmp4_;
		GtkTreeIter _tmp5_;
		gint _tmp6_ = 0;
		GtkListStore* _tmp7_;
		GtkTreeIter _tmp8_;
		_tmp2_ = self->priv->_store;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp2_) : NULL);
		model = _tmp3_;
		_tmp4_ = model;
		_tmp5_ = iter;
		gtk_tree_model_get (_tmp4_, &_tmp5_, MOST_USED_SYMBOLS_SYMBOL_COLUMN_NUM, &_tmp6_, -1);
		num = _tmp6_;
		_tmp7_ = self->priv->_store;
		_tmp8_ = iter;
		gtk_list_store_set (_tmp7_, &_tmp8_, MOST_USED_SYMBOLS_SYMBOL_COLUMN_NUM, num + 1, -1);
		_g_object_unref0 (model);
	}
	self->priv->_modified = TRUE;
}

static gboolean
most_used_symbols_get_iter_at_symbol_id (MostUsedSymbols* self,
                                         const gchar* id,
                                         GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (id != NULL, FALSE);
	_tmp0_ = self->priv->_store;
	_tmp2_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp0_, &_tmp1_);
	_vala_iter = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			gchar* cur_id = NULL;
			GtkTreeModel* model = NULL;
			GtkListStore* _tmp6_;
			GtkTreeModel* _tmp7_;
			GtkTreeModel* _tmp8_;
			GtkTreeIter _tmp9_;
			gchar* _tmp10_ = NULL;
			const gchar* _tmp11_;
			if (!_tmp3_) {
				GtkListStore* _tmp4_;
				gboolean _tmp5_;
				_tmp4_ = self->priv->_store;
				_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &_vala_iter);
				if (!_tmp5_) {
					break;
				}
			}
			_tmp3_ = FALSE;
			_tmp6_ = self->priv->_store;
			_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp6_) : NULL);
			model = _tmp7_;
			_tmp8_ = model;
			_tmp9_ = _vala_iter;
			gtk_tree_model_get (_tmp8_, &_tmp9_, SYMBOL_COLUMN_ID, &_tmp10_, -1);
			_g_free0 (cur_id);
			cur_id = _tmp10_;
			_tmp11_ = cur_id;
			if (g_strcmp0 (_tmp11_, id) == 0) {
				result = TRUE;
				_g_object_unref0 (model);
				_g_free0 (cur_id);
				if (iter) {
					*iter = _vala_iter;
				}
				return result;
			}
			_g_object_unref0 (model);
			_g_free0 (cur_id);
		}
	}
	result = FALSE;
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}

static void
most_used_symbols_add_symbol (MostUsedSymbols* self,
                              const gchar* id,
                              gint nb_times_used)
{
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	gchar* command = NULL;
	gchar* tooltip = NULL;
	Symbols* _tmp2_;
	Symbols* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_;
	gboolean _tmp7_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp8_;
	GtkTreeIter _tmp9_ = {0};
	GtkListStore* _tmp10_;
	GtkTreeIter _tmp11_;
	GdkPixbuf* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = symbols_get_pixbuf (id);
	pixbuf = _tmp0_;
	_tmp1_ = pixbuf;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (pixbuf);
		return;
	}
	_tmp2_ = symbols_get_default ();
	_tmp3_ = _tmp2_;
	_tmp6_ = symbols_get_symbol_info (_tmp3_, id, &_tmp4_, &_tmp5_);
	_g_free0 (command);
	command = _tmp4_;
	_g_free0 (tooltip);
	tooltip = _tmp5_;
	_tmp7_ = !_tmp6_;
	_g_object_unref0 (_tmp3_);
	if (_tmp7_) {
		_g_free0 (tooltip);
		_g_free0 (command);
		_g_object_unref0 (pixbuf);
		return;
	}
	_tmp8_ = self->priv->_store;
	gtk_list_store_append (_tmp8_, &_tmp9_);
	iter = _tmp9_;
	_tmp10_ = self->priv->_store;
	_tmp11_ = iter;
	_tmp12_ = pixbuf;
	_tmp13_ = command;
	_tmp14_ = tooltip;
	gtk_list_store_set (_tmp10_, &_tmp11_, SYMBOL_COLUMN_PIXBUF, _tmp12_, SYMBOL_COLUMN_COMMAND, _tmp13_, SYMBOL_COLUMN_TOOLTIP, _tmp14_, SYMBOL_COLUMN_ID, id, MOST_USED_SYMBOLS_SYMBOL_COLUMN_NUM, nb_times_used, -1);
	_g_free0 (tooltip);
	_g_free0 (command);
	_g_object_unref0 (pixbuf);
}

static GFile*
most_used_symbols_get_xml_file (MostUsedSymbols* self)
{
	gchar* path = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, "gnome-latex", "most_used_symbols.xml", NULL);
	path = _tmp1_;
	_tmp2_ = g_file_new_for_path (path);
	result = _tmp2_;
	_g_free0 (path);
	return result;
}

static void
_most_used_symbols_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                   const gchar* element_name,
                                                                   gchar** attribute_names,
                                                                   gchar** attribute_values,
                                                                   gpointer self,
                                                                   GError** error)
{
	most_used_symbols_parser_start ((MostUsedSymbols*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}

static void
most_used_symbols_load_data (MostUsedSymbols* self)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* contents = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = most_used_symbols_get_xml_file (self);
	file = _tmp0_;
	_tmp1_ = file;
	if (!g_file_query_exists (_tmp1_, NULL)) {
		_g_object_unref0 (file);
		return;
	}
	_tmp2_ = file;
	_tmp3_ = utils_load_file (_tmp2_);
	contents = _tmp3_;
	_tmp4_ = contents;
	if (_tmp4_ == NULL) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		return;
	}
	{
		GMarkupParser parser = {0};
		GMarkupParser _tmp5_ = {0};
		GMarkupParseContext* context = NULL;
		GMarkupParser _tmp6_;
		GMarkupParseContext* _tmp7_;
		GMarkupParseContext* _tmp8_;
		const gchar* _tmp9_;
		_tmp5_.start_element = _most_used_symbols_parser_start_gmarkup_parser_start_element_func;
		_tmp5_.end_element = NULL;
		_tmp5_.text = NULL;
		_tmp5_.passthrough = NULL;
		_tmp5_.error = NULL;
		parser = _tmp5_;
		_tmp6_ = parser;
		_tmp7_ = g_markup_parse_context_new (&_tmp6_, 0, self, NULL);
		context = _tmp7_;
		_tmp8_ = context;
		_tmp9_ = contents;
		g_markup_parse_context_parse (_tmp8_, _tmp9_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_markup_parse_context_unref0 (context);
			goto __catch0_g_error;
		}
		_g_markup_parse_context_unref0 (context);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_warning ("most_used_symbols.vala:156: Impossible to load the most used symbols: " \
"%s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (contents);
	_g_object_unref0 (file);
}

static void
most_used_symbols_parser_start (MostUsedSymbols* self,
                                GMarkupParseContext* context,
                                const gchar* name,
                                gchar** attr_names,
                                gint attr_names_length1,
                                gchar** attr_values,
                                gint attr_values_length1,
                                GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("symbols")))) {
		switch (0) {
			default:
			{
				return;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("symbol")))) {
		switch (0) {
			default:
			{
				gchar* id = NULL;
				gint num = 0;
				const gchar* _tmp19_;
				id = NULL;
				num = 0;
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							const gchar* _tmp5_;
							const gchar* _tmp6_;
							GQuark _tmp8_ = 0U;
							static GQuark _tmp7_label0 = 0;
							static GQuark _tmp7_label1 = 0;
							static GQuark _tmp7_label2 = 0;
							static GQuark _tmp7_label3 = 0;
							if (!_tmp3_) {
								gint _tmp4_;
								_tmp4_ = i;
								i = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(i < attr_names_length1)) {
								break;
							}
							_tmp5_ = attr_names[i];
							_tmp6_ = _tmp5_;
							_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
							if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string ("id")))) {
								switch (0) {
									default:
									{
										const gchar* _tmp9_;
										gchar* _tmp10_;
										_tmp9_ = attr_values[i];
										_tmp10_ = g_strdup (_tmp9_);
										_g_free0 (id);
										id = _tmp10_;
										break;
									}
								}
							} else if (_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string ("num")))) {
								switch (0) {
									default:
									{
										const gchar* _tmp11_;
										_tmp11_ = attr_values[i];
										num = atoi (_tmp11_);
										break;
									}
								}
							} else if ((_tmp8_ == ((0 != _tmp7_label2) ? _tmp7_label2 : (_tmp7_label2 = g_quark_from_static_string ("command")))) || (_tmp8_ == ((0 != _tmp7_label3) ? _tmp7_label3 : (_tmp7_label3 = g_quark_from_static_string ("package"))))) {
								switch (0) {
									default:
									{
										break;
									}
								}
							} else {
								switch (0) {
									default:
									{
										const gchar* _tmp12_;
										gchar* _tmp13_;
										gchar* _tmp14_;
										gchar* _tmp15_;
										gchar* _tmp16_;
										GError* _tmp17_;
										GError* _tmp18_;
										_tmp12_ = attr_names[i];
										_tmp13_ = g_strconcat ("unknown attribute \"", _tmp12_, NULL);
										_tmp14_ = _tmp13_;
										_tmp15_ = g_strconcat (_tmp14_, "\"", NULL);
										_tmp16_ = _tmp15_;
										_tmp17_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp16_);
										_tmp18_ = _tmp17_;
										_g_free0 (_tmp16_);
										_g_free0 (_tmp14_);
										_inner_error0_ = _tmp18_;
										if (_inner_error0_->domain == G_MARKUP_ERROR) {
											g_propagate_error (error, _inner_error0_);
											_g_free0 (id);
											return;
										} else {
											_g_free0 (id);
											g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
											g_clear_error (&_inner_error0_);
											return;
										}
									}
								}
							}
						}
					}
				}
				_tmp19_ = id;
				most_used_symbols_add_symbol (self, _tmp19_, num);
				_g_free0 (id);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				GError* _tmp24_;
				GError* _tmp25_;
				_tmp20_ = g_strconcat ("unknown element \"", name, NULL);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strconcat (_tmp21_, "\"", NULL);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp23_);
				_tmp25_ = _tmp24_;
				_g_free0 (_tmp23_);
				_g_free0 (_tmp21_);
				_inner_error0_ = _tmp25_;
				if (_inner_error0_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
}

void
most_used_symbols_save (MostUsedSymbols* self)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GtkTreeIter iter = {0};
	gboolean is_empty = FALSE;
	GtkListStore* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	gchar* content = NULL;
	gchar* _tmp5_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	GFile* _tmp22_;
	const gchar* _tmp23_;
	g_return_if_fail (self != NULL);
	if (!self->priv->_modified) {
		return;
	}
	self->priv->_modified = FALSE;
	_tmp0_ = most_used_symbols_get_xml_file (self);
	file = _tmp0_;
	_tmp1_ = self->priv->_store;
	_tmp3_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp1_, &_tmp2_);
	iter = _tmp2_;
	is_empty = !_tmp3_;
	if (is_empty) {
		GFile* _tmp4_;
		_tmp4_ = file;
		utils_delete_file (_tmp4_);
		_g_object_unref0 (file);
		return;
	}
	_tmp5_ = g_strdup ("<symbols>\n");
	content = _tmp5_;
	{
		gboolean _tmp6_ = FALSE;
		_tmp6_ = TRUE;
		while (TRUE) {
			gchar* id = NULL;
			gint num = 0;
			GtkTreeModel* model = NULL;
			GtkListStore* _tmp9_;
			GtkTreeModel* _tmp10_;
			GtkTreeModel* _tmp11_;
			GtkTreeIter _tmp12_;
			gchar* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			if (!_tmp6_) {
				GtkListStore* _tmp7_;
				gboolean _tmp8_;
				_tmp7_ = self->priv->_store;
				_tmp8_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp7_, &iter);
				if (!_tmp8_) {
					break;
				}
			}
			_tmp6_ = FALSE;
			_tmp9_ = self->priv->_store;
			_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp9_) : NULL);
			model = _tmp10_;
			_tmp11_ = model;
			_tmp12_ = iter;
			gtk_tree_model_get (_tmp11_, &_tmp12_, SYMBOL_COLUMN_ID, &_tmp13_, MOST_USED_SYMBOLS_SYMBOL_COLUMN_NUM, &_tmp14_, -1);
			_g_free0 (id);
			id = _tmp13_;
			num = _tmp14_;
			_tmp15_ = content;
			_tmp16_ = id;
			_tmp17_ = g_strdup_printf ("  <symbol id=\"%s\" num=\"%d\" />\n", _tmp16_, num);
			_tmp18_ = _tmp17_;
			_tmp19_ = g_strconcat (_tmp15_, _tmp18_, NULL);
			_g_free0 (content);
			content = _tmp19_;
			_g_free0 (_tmp18_);
			_g_object_unref0 (model);
			_g_free0 (id);
		}
	}
	_tmp20_ = content;
	_tmp21_ = g_strconcat (_tmp20_, "</symbols>\n", NULL);
	_g_free0 (content);
	content = _tmp21_;
	_tmp22_ = file;
	_tmp23_ = content;
	utils_save_file (_tmp22_, _tmp23_, FALSE);
	_g_free0 (content);
	_g_object_unref0 (file);
}

static void
most_used_symbols_class_init (MostUsedSymbolsClass * klass,
                              gpointer klass_data)
{
	most_used_symbols_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MostUsedSymbols_private_offset);
	G_OBJECT_CLASS (klass)->finalize = most_used_symbols_finalize;
}

static void
most_used_symbols_instance_init (MostUsedSymbols * self,
                                 gpointer klass)
{
	self->priv = most_used_symbols_get_instance_private (self);
	self->priv->_modified = FALSE;
}

static void
most_used_symbols_finalize (GObject * obj)
{
	MostUsedSymbols * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MOST_USED_SYMBOLS, MostUsedSymbols);
	_g_object_unref0 (self->priv->_store);
	G_OBJECT_CLASS (most_used_symbols_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
most_used_symbols_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MostUsedSymbolsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) most_used_symbols_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MostUsedSymbols), 0, (GInstanceInitFunc) most_used_symbols_instance_init, NULL };
	GType most_used_symbols_type_id;
	most_used_symbols_type_id = g_type_register_static (G_TYPE_OBJECT, "MostUsedSymbols", &g_define_type_info, 0);
	MostUsedSymbols_private_offset = g_type_add_instance_private (most_used_symbols_type_id, sizeof (MostUsedSymbolsPrivate));
	return most_used_symbols_type_id;
}

GType
most_used_symbols_get_type (void)
{
	static gsize most_used_symbols_type_id__once = 0;
	if (g_once_init_enter (&most_used_symbols_type_id__once)) {
		GType most_used_symbols_type_id;
		most_used_symbols_type_id = most_used_symbols_get_type_once ();
		g_once_init_leave (&most_used_symbols_type_id__once, most_used_symbols_type_id);
	}
	return most_used_symbols_type_id__once;
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

