/* dialogs.c generated by valac 0.56.17, the Vala compiler
 * generated from dialogs.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <tepl/tepl.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	DIALOGS_UNSAVED_DOC_COLUMN_SAVE,
	DIALOGS_UNSAVED_DOC_COLUMN_NAME,
	DIALOGS_UNSAVED_DOC_COLUMN_DOC,
	DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS
} DialogsUnsavedDocColumn;

#define DIALOGS_TYPE_UNSAVED_DOC_COLUMN (dialogs_unsaved_doc_column_get_type ())

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _Block12Data Block12Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
typedef struct _DocumentPrivate DocumentPrivate;

struct _Block12Data {
	int _ref_count_;
	GtkListStore* store;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

VALA_EXTERN GType dialogs_unsaved_doc_column_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN void dialogs_close_several_unsaved_documents (MainWindow* window,
                                              GeeList* unsaved_docs);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void __lambda41_ (Block12Data* _data12_,
                  const gchar* path_str);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void ___lambda41__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender,
                                                    const gchar* path,
                                                    gpointer self);
VALA_EXTERN GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
VALA_EXTERN void main_window_remove_all_tabs (MainWindow* self);
VALA_EXTERN GeeList* main_window_get_documents (MainWindow* self);
VALA_EXTERN GType document_tab_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
VALA_EXTERN gboolean main_window_close_tab (MainWindow* self,
                                DocumentTab* tab,
                                gboolean force_close);
VALA_EXTERN gboolean main_window_save_document (MainWindow* self,
                                    Document* doc,
                                    gboolean force_save_as);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);

 G_GNUC_NO_INLINE static GType
dialogs_unsaved_doc_column_get_type_once (void)
{
	static const GEnumValue values[] = {{DIALOGS_UNSAVED_DOC_COLUMN_SAVE, "DIALOGS_UNSAVED_DOC_COLUMN_SAVE", "save"}, {DIALOGS_UNSAVED_DOC_COLUMN_NAME, "DIALOGS_UNSAVED_DOC_COLUMN_NAME", "name"}, {DIALOGS_UNSAVED_DOC_COLUMN_DOC, "DIALOGS_UNSAVED_DOC_COLUMN_DOC", "doc"}, {DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS, "DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType dialogs_unsaved_doc_column_type_id;
	dialogs_unsaved_doc_column_type_id = g_enum_register_static ("DialogsUnsavedDocColumn", values);
	return dialogs_unsaved_doc_column_type_id;
}

GType
dialogs_unsaved_doc_column_get_type (void)
{
	static gsize dialogs_unsaved_doc_column_type_id__once = 0;
	if (g_once_init_enter (&dialogs_unsaved_doc_column_type_id__once)) {
		GType dialogs_unsaved_doc_column_type_id;
		dialogs_unsaved_doc_column_type_id = dialogs_unsaved_doc_column_get_type_once ();
		g_once_init_leave (&dialogs_unsaved_doc_column_type_id__once, dialogs_unsaved_doc_column_type_id);
	}
	return dialogs_unsaved_doc_column_type_id__once;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		_g_object_unref0 (_data12_->store);
		g_slice_free (Block12Data, _data12_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
__lambda41_ (Block12Data* _data12_,
             const gchar* path_str)
{
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreeIter iter = {0};
	gboolean active = FALSE;
	GtkListStore* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_;
	gboolean _tmp5_ = FALSE;
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_;
	g_return_if_fail (path_str != NULL);
	_tmp0_ = gtk_tree_path_new_from_string (path_str);
	path = _tmp0_;
	_tmp1_ = _data12_->store;
	gtk_tree_model_get_iter ((GtkTreeModel*) _tmp1_, &_tmp2_, path);
	iter = _tmp2_;
	_tmp3_ = _data12_->store;
	_tmp4_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, &_tmp5_, -1, -1);
	active = _tmp5_;
	_tmp6_ = _data12_->store;
	_tmp7_ = iter;
	gtk_list_store_set (_tmp6_, &_tmp7_, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, !active, -1, -1);
	__vala_GtkTreePath_free0 (path);
}

static void
___lambda41__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender,
                                               const gchar* path,
                                               gpointer self)
{
	__lambda41_ (self, path);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
dialogs_close_several_unsaved_documents (MainWindow* window,
                                         GeeList* unsaved_docs)
{
	Block12Data* _data12_;
	gint _tmp0_;
	gint _tmp1_;
	GtkDialog* dialog = NULL;
	GtkDialog* _tmp2_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp3_;
	GtkGrid* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp7_;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkBox* _tmp10_;
	GtkGrid* _tmp11_;
	GtkImage* image = NULL;
	GtkImage* _tmp12_;
	GtkImage* _tmp13_;
	GtkGrid* _tmp14_;
	GtkImage* _tmp15_;
	GtkLabel* primary_label = NULL;
	GtkLabel* _tmp16_;
	GtkLabel* _tmp17_;
	GtkLabel* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GtkLabel* _tmp21_;
	GtkLabel* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	GtkGrid* _tmp31_;
	GtkLabel* _tmp32_;
	GtkLabel* select_label = NULL;
	GtkLabel* _tmp33_;
	GtkLabel* _tmp34_;
	GtkLabel* _tmp35_;
	GtkGrid* _tmp36_;
	GtkLabel* _tmp37_;
	GtkTreeView* treeview = NULL;
	GtkTreeView* _tmp38_;
	GtkTreeView* _tmp39_;
	GtkTreeView* _tmp40_;
	GtkTreeView* _tmp41_;
	GtkListStore* _tmp42_;
	GtkTreeView* _tmp59_;
	GtkListStore* _tmp60_;
	GtkCellRendererToggle* renderer1 = NULL;
	GtkCellRendererToggle* _tmp61_;
	GtkCellRendererToggle* _tmp62_;
	GtkTreeViewColumn* column = NULL;
	GtkCellRendererToggle* _tmp63_;
	GtkTreeViewColumn* _tmp64_;
	GtkTreeView* _tmp65_;
	GtkTreeViewColumn* _tmp66_;
	GtkCellRendererText* renderer2 = NULL;
	GtkCellRendererText* _tmp67_;
	GtkCellRendererText* _tmp68_;
	GtkTreeViewColumn* _tmp69_;
	GtkTreeView* _tmp70_;
	GtkTreeViewColumn* _tmp71_;
	GtkScrolledWindow* sw = NULL;
	GtkTreeView* _tmp72_;
	GtkScrolledWindow* _tmp73_;
	GtkScrolledWindow* _tmp74_;
	GtkScrolledWindow* _tmp75_;
	GtkGrid* _tmp76_;
	GtkScrolledWindow* _tmp77_;
	GtkLabel* secondary_label = NULL;
	GtkLabel* _tmp78_;
	GtkLabel* _tmp79_;
	GtkLabel* _tmp80_;
	GtkLabel* _tmp81_;
	GtkGrid* _tmp82_;
	GtkLabel* _tmp83_;
	GtkGrid* _tmp84_;
	gint resp = 0;
	GtkDialog* _tmp85_;
	GtkDialog* _tmp115_;
	g_return_if_fail (window != NULL);
	g_return_if_fail (unsaved_docs != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_tmp0_ = gee_collection_get_size ((GeeCollection*) unsaved_docs);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ >= 2);
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (NULL, (GtkWindow*) window, GTK_DIALOG_DESTROY_WITH_PARENT, _ ("Close _without Saving"), GTK_RESPONSE_CLOSE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Save"), GTK_RESPONSE_ACCEPT, NULL, NULL);
	g_object_ref_sink (_tmp2_);
	dialog = _tmp2_;
	_tmp3_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp3_);
	grid = _tmp3_;
	_tmp4_ = grid;
	gtk_grid_set_column_spacing (_tmp4_, (guint) 12);
	_tmp5_ = grid;
	gtk_grid_set_row_spacing (_tmp5_, (guint) 8);
	_tmp6_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp6_, (guint) 5);
	_tmp7_ = dialog;
	_tmp8_ = gtk_dialog_get_content_area (_tmp7_);
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_box_get_type ()) ? ((GtkBox*) _tmp8_) : NULL);
	content_area = _tmp9_;
	_tmp10_ = content_area;
	_tmp11_ = grid;
	gtk_box_pack_start (_tmp10_, (GtkWidget*) _tmp11_, TRUE, TRUE, (guint) 0);
	_tmp12_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-warning", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
	g_object_ref_sink (_tmp12_);
	image = _tmp12_;
	_tmp13_ = image;
	gtk_widget_set_valign ((GtkWidget*) _tmp13_, GTK_ALIGN_START);
	_tmp14_ = grid;
	_tmp15_ = image;
	gtk_grid_attach (_tmp14_, (GtkWidget*) _tmp15_, 0, 0, 1, 4);
	_tmp16_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp16_);
	primary_label = _tmp16_;
	_tmp17_ = primary_label;
	gtk_label_set_line_wrap (_tmp17_, TRUE);
	_tmp18_ = primary_label;
	gtk_label_set_use_markup (_tmp18_, TRUE);
	_tmp19_ = primary_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp19_, GTK_ALIGN_START);
	_tmp20_ = primary_label;
	gtk_label_set_selectable (_tmp20_, TRUE);
	_tmp21_ = primary_label;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp21_, 4);
	_tmp22_ = primary_label;
	_tmp23_ = gee_collection_get_size ((GeeCollection*) unsaved_docs);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strdup_printf (_ ("There are %d documents with unsaved changes. Save changes before closi" \
"ng?"), _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strconcat ("<span weight=\"bold\" size=\"larger\">", _tmp26_, NULL);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat (_tmp28_, "</span>", NULL);
	_tmp30_ = _tmp29_;
	gtk_label_set_markup (_tmp22_, _tmp30_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp26_);
	_tmp31_ = grid;
	_tmp32_ = primary_label;
	gtk_grid_attach (_tmp31_, (GtkWidget*) _tmp32_, 1, 0, 1, 1);
	_tmp33_ = (GtkLabel*) gtk_label_new (_ ("Select the documents you want to save:"));
	g_object_ref_sink (_tmp33_);
	select_label = _tmp33_;
	_tmp34_ = select_label;
	gtk_label_set_line_wrap (_tmp34_, TRUE);
	_tmp35_ = select_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp35_, GTK_ALIGN_START);
	_tmp36_ = grid;
	_tmp37_ = select_label;
	gtk_grid_attach (_tmp36_, (GtkWidget*) _tmp37_, 1, 1, 1, 1);
	_tmp38_ = (GtkTreeView*) gtk_tree_view_new ();
	g_object_ref_sink (_tmp38_);
	treeview = _tmp38_;
	_tmp39_ = treeview;
	gtk_widget_set_size_request ((GtkWidget*) _tmp39_, 260, 120);
	_tmp40_ = treeview;
	gtk_tree_view_set_headers_visible (_tmp40_, FALSE);
	_tmp41_ = treeview;
	gtk_tree_view_set_enable_search (_tmp41_, FALSE);
	_tmp42_ = gtk_list_store_new ((gint) DIALOGS_UNSAVED_DOC_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, TYPE_DOCUMENT, -1);
	_data12_->store = _tmp42_;
	{
		GeeList* _doc_list = NULL;
		gint _doc_size = 0;
		GeeList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _doc_index = 0;
		_doc_list = unsaved_docs;
		_tmp43_ = _doc_list;
		_tmp44_ = gee_collection_get_size ((GeeCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_doc_size = _tmp45_;
		_doc_index = -1;
		while (TRUE) {
			gint _tmp46_;
			gint _tmp47_;
			Document* doc = NULL;
			GeeList* _tmp48_;
			gpointer _tmp49_;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp50_;
			GtkTreeIter _tmp51_ = {0};
			GtkListStore* _tmp52_;
			GtkTreeIter _tmp53_;
			Document* _tmp54_;
			TeplFile* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			Document* _tmp58_;
			_doc_index = _doc_index + 1;
			_tmp46_ = _doc_index;
			_tmp47_ = _doc_size;
			if (!(_tmp46_ < _tmp47_)) {
				break;
			}
			_tmp48_ = _doc_list;
			_tmp49_ = gee_list_get (_tmp48_, _doc_index);
			doc = (Document*) _tmp49_;
			_tmp50_ = _data12_->store;
			gtk_list_store_append (_tmp50_, &_tmp51_);
			iter = _tmp51_;
			_tmp52_ = _data12_->store;
			_tmp53_ = iter;
			_tmp54_ = doc;
			_tmp55_ = tepl_buffer_get_file ((TeplBuffer*) _tmp54_);
			_tmp56_ = tepl_file_get_short_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = doc;
			gtk_list_store_set (_tmp52_, &_tmp53_, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, TRUE, DIALOGS_UNSAVED_DOC_COLUMN_NAME, _tmp57_, DIALOGS_UNSAVED_DOC_COLUMN_DOC, _tmp58_, -1, -1);
			_g_free0 (_tmp57_);
			_g_object_unref0 (doc);
		}
	}
	_tmp59_ = treeview;
	_tmp60_ = _data12_->store;
	gtk_tree_view_set_model (_tmp59_, (GtkTreeModel*) _tmp60_);
	_tmp61_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
	g_object_ref_sink (_tmp61_);
	renderer1 = _tmp61_;
	_tmp62_ = renderer1;
	g_signal_connect_data (_tmp62_, "toggled", (GCallback) ___lambda41__gtk_cell_renderer_toggle_toggled, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	_tmp63_ = renderer1;
	_tmp64_ = gtk_tree_view_column_new_with_attributes ("Save?", (GtkCellRenderer*) _tmp63_, "active", DIALOGS_UNSAVED_DOC_COLUMN_SAVE, NULL, NULL);
	g_object_ref_sink (_tmp64_);
	column = _tmp64_;
	_tmp65_ = treeview;
	_tmp66_ = column;
	gtk_tree_view_append_column (_tmp65_, _tmp66_);
	_tmp67_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp67_);
	renderer2 = _tmp67_;
	_tmp68_ = renderer2;
	_tmp69_ = gtk_tree_view_column_new_with_attributes ("Name", (GtkCellRenderer*) _tmp68_, "text", DIALOGS_UNSAVED_DOC_COLUMN_NAME, NULL, NULL);
	g_object_ref_sink (_tmp69_);
	_g_object_unref0 (column);
	column = _tmp69_;
	_tmp70_ = treeview;
	_tmp71_ = column;
	gtk_tree_view_append_column (_tmp70_, _tmp71_);
	_tmp72_ = treeview;
	_tmp73_ = utils_add_scrollbar ((GtkWidget*) _tmp72_);
	sw = _tmp73_;
	_tmp74_ = sw;
	gtk_scrolled_window_set_shadow_type (_tmp74_, GTK_SHADOW_IN);
	_tmp75_ = sw;
	g_object_set ((GtkWidget*) _tmp75_, "expand", TRUE, NULL);
	_tmp76_ = grid;
	_tmp77_ = sw;
	gtk_grid_attach (_tmp76_, (GtkWidget*) _tmp77_, 1, 2, 1, 1);
	_tmp78_ = (GtkLabel*) gtk_label_new (_ ("If you don’t save, all your changes will be permanently lost."));
	g_object_ref_sink (_tmp78_);
	secondary_label = _tmp78_;
	_tmp79_ = secondary_label;
	gtk_label_set_line_wrap (_tmp79_, TRUE);
	_tmp80_ = secondary_label;
	gtk_widget_set_halign ((GtkWidget*) _tmp80_, GTK_ALIGN_START);
	_tmp81_ = secondary_label;
	gtk_label_set_selectable (_tmp81_, TRUE);
	_tmp82_ = grid;
	_tmp83_ = secondary_label;
	gtk_grid_attach (_tmp82_, (GtkWidget*) _tmp83_, 1, 3, 1, 1);
	_tmp84_ = grid;
	gtk_widget_show_all ((GtkWidget*) _tmp84_);
	_tmp85_ = dialog;
	resp = gtk_dialog_run (_tmp85_);
	if (resp == ((gint) GTK_RESPONSE_CLOSE)) {
		main_window_remove_all_tabs (window);
	} else {
		if (resp == ((gint) GTK_RESPONSE_ACCEPT)) {
			GList* selected_docs = NULL;
			GtkTreeIter iter = {0};
			gboolean valid = FALSE;
			GtkListStore* _tmp97_;
			GtkTreeIter _tmp98_ = {0};
			gboolean _tmp99_;
			GList* _tmp110_;
			{
				GeeList* _doc_list = NULL;
				GeeList* _tmp86_;
				gint _doc_size = 0;
				GeeList* _tmp87_;
				gint _tmp88_;
				gint _tmp89_;
				gint _doc_index = 0;
				_tmp86_ = main_window_get_documents (window);
				_doc_list = _tmp86_;
				_tmp87_ = _doc_list;
				_tmp88_ = gee_collection_get_size ((GeeCollection*) _tmp87_);
				_tmp89_ = _tmp88_;
				_doc_size = _tmp89_;
				_doc_index = -1;
				while (TRUE) {
					gint _tmp90_;
					gint _tmp91_;
					Document* doc = NULL;
					GeeList* _tmp92_;
					gpointer _tmp93_;
					Document* _tmp94_;
					_doc_index = _doc_index + 1;
					_tmp90_ = _doc_index;
					_tmp91_ = _doc_size;
					if (!(_tmp90_ < _tmp91_)) {
						break;
					}
					_tmp92_ = _doc_list;
					_tmp93_ = gee_list_get (_tmp92_, _doc_index);
					doc = (Document*) _tmp93_;
					_tmp94_ = doc;
					if (!gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp94_)) {
						Document* _tmp95_;
						DocumentTab* _tmp96_;
						_tmp95_ = doc;
						_tmp96_ = _tmp95_->tab;
						main_window_close_tab (window, _tmp96_, FALSE);
					}
					_g_object_unref0 (doc);
				}
				_g_object_unref0 (_doc_list);
			}
			selected_docs = NULL;
			_tmp97_ = _data12_->store;
			_tmp99_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp97_, &_tmp98_);
			iter = _tmp98_;
			valid = _tmp99_;
			while (TRUE) {
				gboolean selected = FALSE;
				Document* doc = NULL;
				GtkListStore* _tmp100_;
				GtkTreeIter _tmp101_;
				gboolean _tmp102_ = FALSE;
				Document* _tmp103_ = NULL;
				GtkListStore* _tmp108_;
				gboolean _tmp109_;
				if (!valid) {
					break;
				}
				_tmp100_ = _data12_->store;
				_tmp101_ = iter;
				gtk_tree_model_get ((GtkTreeModel*) _tmp100_, &_tmp101_, DIALOGS_UNSAVED_DOC_COLUMN_SAVE, &_tmp102_, DIALOGS_UNSAVED_DOC_COLUMN_DOC, &_tmp103_, -1, -1);
				selected = _tmp102_;
				_g_object_unref0 (doc);
				doc = _tmp103_;
				if (selected) {
					Document* _tmp104_;
					Document* _tmp105_;
					_tmp104_ = doc;
					_tmp105_ = _g_object_ref0 (_tmp104_);
					selected_docs = g_list_prepend (selected_docs, _tmp105_);
				} else {
					Document* _tmp106_;
					DocumentTab* _tmp107_;
					_tmp106_ = doc;
					_tmp107_ = _tmp106_->tab;
					main_window_close_tab (window, _tmp107_, TRUE);
				}
				_tmp108_ = _data12_->store;
				_tmp109_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp108_, &iter);
				valid = _tmp109_;
				_g_object_unref0 (doc);
			}
			selected_docs = g_list_reverse (selected_docs);
			_tmp110_ = selected_docs;
			{
				GList* doc_collection = NULL;
				GList* doc_it = NULL;
				doc_collection = _tmp110_;
				for (doc_it = doc_collection; doc_it != NULL; doc_it = doc_it->next) {
					Document* _tmp111_;
					Document* doc = NULL;
					_tmp111_ = _g_object_ref0 ((Document*) doc_it->data);
					doc = _tmp111_;
					{
						Document* _tmp112_;
						_tmp112_ = doc;
						if (main_window_save_document (window, _tmp112_, FALSE)) {
							Document* _tmp113_;
							DocumentTab* _tmp114_;
							_tmp113_ = doc;
							_tmp114_ = _tmp113_->tab;
							main_window_close_tab (window, _tmp114_, TRUE);
						}
						_g_object_unref0 (doc);
					}
				}
			}
			(selected_docs == NULL) ? NULL : (selected_docs = (_g_list_free__g_object_unref0_ (selected_docs), NULL));
		}
	}
	_tmp115_ = dialog;
	gtk_widget_destroy ((GtkWidget*) _tmp115_);
	_g_object_unref0 (secondary_label);
	_g_object_unref0 (sw);
	_g_object_unref0 (renderer2);
	_g_object_unref0 (column);
	_g_object_unref0 (renderer1);
	_g_object_unref0 (treeview);
	_g_object_unref0 (select_label);
	_g_object_unref0 (primary_label);
	_g_object_unref0 (image);
	_g_object_unref0 (content_area);
	_g_object_unref0 (grid);
	_g_object_unref0 (dialog);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

