/* uri.c generated by valac 0.56.8, the Vala compiler
 * generated from uri.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _games_uri_unref0(var) ((var == NULL) ? NULL : (var = (games_uri_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))

#define GAMES_TYPE_URI_ERROR (games_uri_error_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _GamesParamSpecUri GamesParamSpecUri;

struct _GamesUriPrivate {
	gchar* uri;
};

typedef enum  {
	GAMES_URI_ERROR_INVALID_SCHEME
} GamesUriError;
#define GAMES_URI_ERROR games_uri_error_quark ()

struct _GamesParamSpecUri {
	GParamSpec parent_instance;
};

static gint GamesUri_private_offset;
static gpointer games_uri_parent_class = NULL;
static GRegex* games_uri_scheme_regex;
static GRegex* games_uri_scheme_regex = NULL;

VALA_EXTERN GQuark games_uri_error_quark (void);
GType games_uri_error_get_type (void) G_GNUC_CONST ;
static void games_uri_finalize (GamesUri * obj);
static GType games_uri_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static GRegex* _tmp_regex_0 = NULL;

static inline gpointer
games_uri_get_instance_private (GamesUri* self)
{
	return G_STRUCT_MEMBER_P (self, GamesUri_private_offset);
}

GamesUri*
games_uri_construct (GType object_type,
                     const gchar* uri)
{
	GamesUri* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (GamesUri*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (uri);
	_g_free0 (self->priv->uri);
	self->priv->uri = _tmp0_;
	return self;
}

GamesUri*
games_uri_new (const gchar* uri)
{
	return games_uri_construct (GAMES_TYPE_URI, uri);
}

GamesUri*
games_uri_construct_from_uri_and_scheme (GType object_type,
                                         GamesUri* uri,
                                         const gchar* scheme,
                                         GError** error)
{
	GamesUri* self = NULL;
	gchar* _tmp0_ = NULL;
	GRegex* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (scheme != NULL, NULL);
	self = (GamesUri*) g_type_create_instance (object_type);
	_tmp1_ = games_uri_scheme_regex;
	_tmp2_ = uri->priv->uri;
	_tmp3_ = g_strconcat (scheme, ":", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_regex_replace (_tmp1_, _tmp2_, (gssize) -1, 0, _tmp4_, 0, &_inner_error0_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_tmp0_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_games_uri_unref0 (self);
		return NULL;
	}
	_tmp7_ = _tmp0_;
	_tmp0_ = NULL;
	_g_free0 (self->priv->uri);
	self->priv->uri = _tmp7_;
	_g_free0 (_tmp0_);
	return self;
}

GamesUri*
games_uri_new_from_uri_and_scheme (GamesUri* uri,
                                   const gchar* scheme,
                                   GError** error)
{
	return games_uri_construct_from_uri_and_scheme (GAMES_TYPE_URI, uri, scheme, error);
}

GamesUri*
games_uri_construct_from_file (GType object_type,
                               GFile* file)
{
	GamesUri* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesUri*) g_type_create_instance (object_type);
	_tmp0_ = g_file_get_uri (file);
	_g_free0 (self->priv->uri);
	self->priv->uri = _tmp0_;
	return self;
}

GamesUri*
games_uri_new_from_file (GFile* file)
{
	return games_uri_construct_from_file (GAMES_TYPE_URI, file);
}

guint
games_uri_hash (GamesUri* uri)
{
	GHashFunc _tmp0_;
	const gchar* _tmp1_;
	guint result;
	g_return_val_if_fail (uri != NULL, 0U);
	_tmp0_ = g_str_hash;
	_tmp1_ = uri->priv->uri;
	result = _tmp0_ (_tmp1_);
	return result;
}

gboolean
games_uri_equal (GamesUri* a,
                 GamesUri* b)
{
	GEqualFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = g_str_equal;
	_tmp1_ = a->priv->uri;
	_tmp2_ = b->priv->uri;
	result = _tmp0_ (_tmp1_, _tmp2_);
	return result;
}

gchar*
games_uri_to_string (GamesUri* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->uri;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

GFile*
games_uri_to_file (GamesUri* self)
{
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
games_uri_get_scheme (GamesUri* self,
                      GError** error)
{
	GMatchInfo* info = NULL;
	GRegex* _tmp0_;
	const gchar* _tmp1_;
	GMatchInfo* _tmp2_ = NULL;
	gboolean _tmp3_;
	GMatchInfo* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = games_uri_scheme_regex;
	_tmp1_ = self->priv->uri;
	_tmp3_ = g_regex_match (_tmp0_, _tmp1_, 0, &_tmp2_);
	_g_match_info_unref0 (info);
	info = _tmp2_;
	if (!_tmp3_) {
		const gchar* _tmp4_;
		GError* _tmp5_;
		_tmp4_ = self->priv->uri;
		_tmp5_ = g_error_new (GAMES_URI_ERROR, GAMES_URI_ERROR_INVALID_SCHEME, "The URI doesn't have a valid scheme: %s.", _tmp4_);
		_inner_error0_ = _tmp5_;
		g_propagate_error (error, _inner_error0_);
		_g_match_info_unref0 (info);
		return NULL;
	}
	_tmp6_ = info;
	_tmp7_ = g_match_info_fetch (_tmp6_, 1);
	result = _tmp7_;
	_g_match_info_unref0 (info);
	return result;
}

static inline GRegex*
_thread_safe_regex_init (GRegex** re,
                         const gchar * pattern,
                         GRegexCompileFlags compile_flags)
{
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, compile_flags, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}

static gpointer
_g_regex_ref0 (gpointer self)
{
	return self ? g_regex_ref (self) : NULL;
}

static void
games_value_uri_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
games_value_uri_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		games_uri_unref (value->data[0].v_pointer);
	}
}

static void
games_value_uri_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = games_uri_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
games_value_uri_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
games_value_uri_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GamesUri * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = games_uri_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
games_value_uri_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	GamesUri ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = games_uri_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
games_param_spec_uri (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	GamesParamSpecUri* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GAMES_TYPE_URI), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
games_value_get_uri (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAMES_TYPE_URI), NULL);
	return value->data[0].v_pointer;
}

void
games_value_set_uri (GValue* value,
                     gpointer v_object)
{
	GamesUri * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAMES_TYPE_URI));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAMES_TYPE_URI));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		games_uri_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		games_uri_unref (old);
	}
}

void
games_value_take_uri (GValue* value,
                      gpointer v_object)
{
	GamesUri * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAMES_TYPE_URI));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAMES_TYPE_URI));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		games_uri_unref (old);
	}
}

static void
games_uri_class_init (GamesUriClass * klass,
                      gpointer klass_data)
{
	GRegex* _tmp0_;
	games_uri_parent_class = g_type_class_peek_parent (klass);
	((GamesUriClass *) klass)->finalize = games_uri_finalize;
	g_type_class_adjust_private_offset (klass, &GamesUri_private_offset);
	_tmp0_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "^([a-z][a-z0-9\\+\\.\\-]*):", 0 | G_REGEX_CASELESS));
	_g_regex_unref0 (games_uri_scheme_regex);
	games_uri_scheme_regex = _tmp0_;
}

static void
games_uri_instance_init (GamesUri * self,
                         gpointer klass)
{
	self->priv = games_uri_get_instance_private (self);
	self->ref_count = 1;
}

static void
games_uri_finalize (GamesUri * obj)
{
	GamesUri * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_URI, GamesUri);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->uri);
}

static GType
games_uri_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { games_value_uri_init, games_value_uri_free_value, games_value_uri_copy_value, games_value_uri_peek_pointer, "p", games_value_uri_collect_value, "p", games_value_uri_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GamesUriClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_uri_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesUri), 0, (GInstanceInitFunc) games_uri_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType games_uri_type_id;
	games_uri_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GamesUri", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GamesUri_private_offset = g_type_add_instance_private (games_uri_type_id, sizeof (GamesUriPrivate));
	return games_uri_type_id;
}

GType
games_uri_get_type (void)
{
	static volatile gsize games_uri_type_id__once = 0;
	if (g_once_init_enter (&games_uri_type_id__once)) {
		GType games_uri_type_id;
		games_uri_type_id = games_uri_get_type_once ();
		g_once_init_leave (&games_uri_type_id__once, games_uri_type_id);
	}
	return games_uri_type_id__once;
}

gpointer
games_uri_ref (gpointer instance)
{
	GamesUri * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
games_uri_unref (gpointer instance)
{
	GamesUri * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GAMES_URI_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

