/* unicode.c generated by valac 0.56.8, the Vala compiler
 * generated from unicode.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

VALA_EXTERN GamesUnicodeEncoding games_unicode_parse_encoding (GFileInputStream* stream,
                                                   gint* bom_length,
                                                   GError** error);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

gchar*
games_unicode_encoding_to_string (GamesUnicodeEncoding self)
{
	gchar* result;
	switch (self) {
		case GAMES_UNICODE_ENCODING_UTF_32BE:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("utf-32be");
			result = _tmp0_;
			return result;
		}
		case GAMES_UNICODE_ENCODING_UTF_32LE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("utf-32le");
			result = _tmp1_;
			return result;
		}
		case GAMES_UNICODE_ENCODING_UTF_16BE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("utf-16be");
			result = _tmp2_;
			return result;
		}
		case GAMES_UNICODE_ENCODING_UTF_16LE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("utf-16le");
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("utf-8");
			result = _tmp4_;
			return result;
		}
	}
}

static GType
games_unicode_encoding_get_type_once (void)
{
	static const GEnumValue values[] = {{GAMES_UNICODE_ENCODING_UTF_32BE, "GAMES_UNICODE_ENCODING_UTF_32BE", "utf-32be"}, {GAMES_UNICODE_ENCODING_UTF_32LE, "GAMES_UNICODE_ENCODING_UTF_32LE", "utf-32le"}, {GAMES_UNICODE_ENCODING_UTF_16BE, "GAMES_UNICODE_ENCODING_UTF_16BE", "utf-16be"}, {GAMES_UNICODE_ENCODING_UTF_16LE, "GAMES_UNICODE_ENCODING_UTF_16LE", "utf-16le"}, {GAMES_UNICODE_ENCODING_UTF_8, "GAMES_UNICODE_ENCODING_UTF_8", "utf-8"}, {0, NULL, NULL}};
	GType games_unicode_encoding_type_id;
	games_unicode_encoding_type_id = g_enum_register_static ("GamesUnicodeEncoding", values);
	return games_unicode_encoding_type_id;
}

GType
games_unicode_encoding_get_type (void)
{
	static volatile gsize games_unicode_encoding_type_id__once = 0;
	if (g_once_init_enter (&games_unicode_encoding_type_id__once)) {
		GType games_unicode_encoding_type_id;
		games_unicode_encoding_type_id = games_unicode_encoding_get_type_once ();
		g_once_init_leave (&games_unicode_encoding_type_id__once, games_unicode_encoding_type_id);
	}
	return games_unicode_encoding_type_id__once;
}

GamesUnicodeEncoding
games_unicode_parse_encoding (GFileInputStream* stream,
                              gint* bom_length,
                              GError** error)
{
	gint _vala_bom_length = 0;
	guint8* c = NULL;
	guint8* _tmp0_;
	gint c_length1;
	gint _c_size_;
	gssize size = 0L;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint32 bom = 0U;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8 _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8 _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8 _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8 _tmp9_;
	GError* _inner_error0_ = NULL;
	GamesUnicodeEncoding result;
	g_return_val_if_fail (stream != NULL, 0);
	G_TYPE_INSTANCE_GET_CLASS (stream, g_file_input_stream_get_type (), GFileInputStreamClass)->seek (stream, (gint64) 0, G_SEEK_SET, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return 0;
	}
	_tmp0_ = g_new0 (guint8, 4);
	_tmp0_[0] = (guint8) 0;
	_tmp0_[1] = (guint8) 0;
	_tmp0_[2] = (guint8) 0;
	_tmp0_[3] = (guint8) 0;
	c = _tmp0_;
	c_length1 = 4;
	_c_size_ = c_length1;
	_tmp1_ = c;
	_tmp1__length1 = c_length1;
	size = g_input_stream_read ((GInputStream*) stream, _tmp1_, (gsize) _tmp1__length1, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		c = (g_free (c), NULL);
		return 0;
	}
	if (size < ((gssize) 4)) {
		_vala_bom_length = 0;
		result = GAMES_UNICODE_ENCODING_UTF_8;
		c = (g_free (c), NULL);
		if (bom_length) {
			*bom_length = _vala_bom_length;
		}
		return result;
	}
	_tmp2_ = c;
	_tmp2__length1 = c_length1;
	_tmp3_ = _tmp2_[0];
	_tmp4_ = c;
	_tmp4__length1 = c_length1;
	_tmp5_ = _tmp4_[1];
	_tmp6_ = c;
	_tmp6__length1 = c_length1;
	_tmp7_ = _tmp6_[2];
	_tmp8_ = c;
	_tmp8__length1 = c_length1;
	_tmp9_ = _tmp8_[3];
	bom = (guint32) (((_tmp3_ | (_tmp5_ << 8)) | (_tmp7_ << 16)) | (_tmp9_ << 24));
	if (((gint64) bom) == 0xfffe0000LL) {
		_vala_bom_length = 4;
		result = GAMES_UNICODE_ENCODING_UTF_32BE;
		c = (g_free (c), NULL);
		if (bom_length) {
			*bom_length = _vala_bom_length;
		}
		return result;
	} else {
		if (bom == ((guint32) 0x0000feff)) {
			_vala_bom_length = 4;
			result = GAMES_UNICODE_ENCODING_UTF_32LE;
			c = (g_free (c), NULL);
			if (bom_length) {
				*bom_length = _vala_bom_length;
			}
			return result;
		} else {
			if ((bom & 0xffff) == ((guint32) 0xfffe)) {
				_vala_bom_length = 2;
				result = GAMES_UNICODE_ENCODING_UTF_16BE;
				c = (g_free (c), NULL);
				if (bom_length) {
					*bom_length = _vala_bom_length;
				}
				return result;
			} else {
				if ((bom & 0xffff) == ((guint32) 0xfeff)) {
					_vala_bom_length = 2;
					result = GAMES_UNICODE_ENCODING_UTF_16LE;
					c = (g_free (c), NULL);
					if (bom_length) {
						*bom_length = _vala_bom_length;
					}
					return result;
				} else {
					if ((bom & 0xffffff) == ((guint32) 0xbfbbef)) {
						_vala_bom_length = 3;
						result = GAMES_UNICODE_ENCODING_UTF_8;
						c = (g_free (c), NULL);
						if (bom_length) {
							*bom_length = _vala_bom_length;
						}
						return result;
					}
				}
			}
		}
	}
	_vala_bom_length = 0;
	result = GAMES_UNICODE_ENCODING_UTF_8;
	c = (g_free (c), NULL);
	if (bom_length) {
		*bom_length = _vala_bom_length;
	}
	return result;
}

GInputStream*
games_unicode_read (GFile* file,
                    GamesUnicodeEncoding encoding,
                    GError** error)
{
	GFileInputStream* stream = NULL;
	GFileInputStream* _tmp0_;
	gint bom_length = 0;
	GamesUnicodeEncoding src_encoding = 0;
	GFileInputStream* _tmp1_;
	gint _tmp2_ = 0;
	GamesUnicodeEncoding _tmp3_;
	GFileInputStream* _tmp4_;
	GCharsetConverter* converter = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GCharsetConverter* _tmp9_;
	GCharsetConverter* _tmp10_;
	GFileInputStream* _tmp11_;
	GCharsetConverter* _tmp12_;
	GConverterInputStream* _tmp13_;
	GError* _inner_error0_ = NULL;
	GInputStream* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_read (file, NULL, &_inner_error0_);
	stream = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	bom_length = 0;
	_tmp1_ = stream;
	_tmp3_ = games_unicode_parse_encoding (_tmp1_, &_tmp2_, &_inner_error0_);
	bom_length = _tmp2_;
	src_encoding = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		return NULL;
	}
	_tmp4_ = stream;
	G_TYPE_INSTANCE_GET_CLASS (_tmp4_, g_file_input_stream_get_type (), GFileInputStreamClass)->seek (_tmp4_, (gint64) bom_length, G_SEEK_SET, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		return NULL;
	}
	if (encoding == GAMES_UNICODE_ENCODING_UTF_8) {
		result = (GInputStream*) stream;
		return result;
	}
	_tmp5_ = games_unicode_encoding_to_string (encoding);
	_tmp6_ = _tmp5_;
	_tmp7_ = games_unicode_encoding_to_string (src_encoding);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_charset_converter_new (_tmp6_, _tmp8_, &_inner_error0_);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	converter = _tmp10_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		return NULL;
	}
	_tmp11_ = stream;
	_tmp12_ = converter;
	_tmp13_ = (GConverterInputStream*) g_converter_input_stream_new ((GInputStream*) _tmp11_, (GConverter*) _tmp12_);
	result = (GInputStream*) _tmp13_;
	_g_object_unref0 (converter);
	_g_object_unref0 (stream);
	return result;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

