/* local-cover.c generated by valac 0.56.8, the Vala compiler
 * generated from local-cover.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>

enum  {
	GAMES_LOCAL_COVER_0_PROPERTY,
	GAMES_LOCAL_COVER_NUM_PROPERTIES
};
static GParamSpec* games_local_cover_properties[GAMES_LOCAL_COVER_NUM_PROPERTIES];
#define _games_uri_unref0(var) ((var == NULL) ? NULL : (var = (games_uri_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block31Data Block31Data;
typedef struct _Block32Data Block32Data;

struct _GamesLocalCoverPrivate {
	GamesUri* uri;
	gboolean resolved;
	GFile* file;
};

struct _Block31Data {
	int _ref_count_;
	GamesLocalCover* self;
	GFile* parent;
	gchar* basename;
	gchar* prefix;
	gchar* cover_path;
};

struct _Block32Data {
	int _ref_count_;
	GamesLocalCover* self;
	GFile* parent;
	gchar* cover_path;
};

static gint GamesLocalCover_private_offset;
static gpointer games_local_cover_parent_class = NULL;
static GamesCoverIface * games_local_cover_games_cover_parent_iface = NULL;

static GFile* games_local_cover_real_get_cover (GamesCover* base);
static gchar* games_local_cover_get_cover_path (GamesLocalCover* self,
                                         GError** error);
static gchar* games_local_cover_get_sibling_cover_path (GamesLocalCover* self,
                                                 GError** error);
static gchar* games_local_cover_get_directory_cover_path (GamesLocalCover* self,
                                                   GError** error);
static gchar* games_local_cover_get_basename_prefix (GamesLocalCover* self,
                                              const gchar* basename);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static gboolean __lambda71_ (Block31Data* _data31_,
                      GFileInfo* sibling,
                      GError** error);
static gboolean ___lambda71__games_directory_file_info_test (GFileInfo* file_info,
                                                      gpointer self,
                                                      GError** error);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static gboolean __lambda72_ (Block32Data* _data32_,
                      GFileInfo* sibbling,
                      GError** error);
static gboolean ___lambda72__games_directory_file_info_test (GFileInfo* file_info,
                                                      gpointer self,
                                                      GError** error);
static void games_local_cover_finalize (GObject * obj);
static GType games_local_cover_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_local_cover_get_instance_private (GamesLocalCover* self)
{
	return G_STRUCT_MEMBER_P (self, GamesLocalCover_private_offset);
}

static gpointer
_games_uri_ref0 (gpointer self)
{
	return self ? games_uri_ref (self) : NULL;
}

GamesLocalCover*
games_local_cover_construct (GType object_type,
                             GamesUri* uri)
{
	GamesLocalCover * self = NULL;
	GamesUri* _tmp0_;
	g_return_val_if_fail (uri != NULL, NULL);
	self = (GamesLocalCover*) g_object_new (object_type, NULL);
	_tmp0_ = _games_uri_ref0 (uri);
	_games_uri_unref0 (self->priv->uri);
	self->priv->uri = _tmp0_;
	return self;
}

GamesLocalCover*
games_local_cover_new (GamesUri* uri)
{
	return games_local_cover_construct (GAMES_TYPE_LOCAL_COVER, uri);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GFile*
games_local_cover_real_get_cover (GamesCover* base)
{
	GamesLocalCover * self;
	gchar* cover_path = NULL;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	self = (GamesLocalCover*) base;
	if (self->priv->resolved) {
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = self->priv->file;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		result = _tmp1_;
		return result;
	}
	self->priv->resolved = TRUE;
	{
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = games_local_cover_get_cover_path (self, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_free0 (cover_path);
		cover_path = _tmp4_;
		_g_free0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("local-cover.vala:23: %s", _tmp6_);
		result = NULL;
		_g_error_free0 (e);
		_g_free0 (cover_path);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (cover_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp7_ = cover_path;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_free0 (cover_path);
		return result;
	}
	_tmp8_ = cover_path;
	_tmp9_ = g_file_new_for_path (_tmp8_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp9_;
	_tmp10_ = self->priv->file;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	result = _tmp11_;
	_g_free0 (cover_path);
	return result;
}

static gchar*
games_local_cover_get_cover_path (GamesLocalCover* self,
                                  GError** error)
{
	gchar* cover_path = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = games_local_cover_get_sibling_cover_path (self, &_inner_error0_);
	cover_path = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = cover_path;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		_tmp3_ = cover_path;
		_tmp1_ = g_file_test (_tmp3_, G_FILE_TEST_EXISTS);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = cover_path;
		return result;
	}
	_tmp5_ = games_local_cover_get_directory_cover_path (self, &_inner_error0_);
	_tmp4_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (cover_path);
		return NULL;
	}
	_tmp6_ = _tmp4_;
	_tmp4_ = NULL;
	_g_free0 (cover_path);
	cover_path = _tmp6_;
	_tmp8_ = cover_path;
	if (_tmp8_ != NULL) {
		const gchar* _tmp9_;
		_tmp9_ = cover_path;
		_tmp7_ = g_file_test (_tmp9_, G_FILE_TEST_EXISTS);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		result = cover_path;
		_g_free0 (_tmp4_);
		return result;
	}
	result = NULL;
	_g_free0 (_tmp4_);
	_g_free0 (cover_path);
	return result;
}

static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
games_local_cover_get_basename_prefix (GamesLocalCover* self,
                                       const gchar* basename)
{
	gint pos = 0;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (basename != NULL, NULL);
	pos = string_last_index_of_char (basename, (gunichar) '.', 0);
	if (pos < 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (basename);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = string_substring (basename, (glong) 0, (glong) pos);
	result = _tmp1_;
	return result;
}

static Block31Data*
block31_data_ref (Block31Data* _data31_)
{
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}

static void
block31_data_unref (void * _userdata_)
{
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		GamesLocalCover* self;
		self = _data31_->self;
		_g_free0 (_data31_->cover_path);
		_g_free0 (_data31_->prefix);
		_g_free0 (_data31_->basename);
		_g_object_unref0 (_data31_->parent);
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}

static gboolean
__lambda71_ (Block31Data* _data31_,
             GFileInfo* sibling,
             GError** error)
{
	GamesLocalCover* self;
	gchar* sibling_basename = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* sibling_prefix = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* type = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	GFile* sibling_file = NULL;
	GFile* _tmp11_;
	const gchar* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	gboolean result;
	self = _data31_->self;
	g_return_val_if_fail (sibling != NULL, FALSE);
	_tmp0_ = g_file_info_get_name (sibling);
	_tmp1_ = g_strdup (_tmp0_);
	sibling_basename = _tmp1_;
	_tmp2_ = sibling_basename;
	_tmp3_ = _data31_->basename;
	if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
		result = FALSE;
		_g_free0 (sibling_basename);
		return result;
	}
	_tmp4_ = sibling_basename;
	_tmp5_ = games_local_cover_get_basename_prefix (self, _tmp4_);
	sibling_prefix = _tmp5_;
	_tmp6_ = _data31_->prefix;
	_tmp7_ = sibling_prefix;
	if (g_strcmp0 (_tmp6_, _tmp7_) != 0) {
		result = FALSE;
		_g_free0 (sibling_prefix);
		_g_free0 (sibling_basename);
		return result;
	}
	_tmp8_ = g_file_info_get_attribute_string (sibling, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE);
	_tmp9_ = g_strdup (_tmp8_);
	type = _tmp9_;
	_tmp10_ = type;
	if (!g_str_has_prefix (_tmp10_, "image")) {
		result = FALSE;
		_g_free0 (type);
		_g_free0 (sibling_prefix);
		_g_free0 (sibling_basename);
		return result;
	}
	_tmp11_ = _data31_->parent;
	_tmp12_ = sibling_basename;
	_tmp13_ = g_file_get_child (_tmp11_, _tmp12_);
	sibling_file = _tmp13_;
	_tmp14_ = sibling_file;
	_tmp15_ = g_file_get_path (_tmp14_);
	_g_free0 (_data31_->cover_path);
	_data31_->cover_path = _tmp15_;
	result = TRUE;
	_g_object_unref0 (sibling_file);
	_g_free0 (type);
	_g_free0 (sibling_prefix);
	_g_free0 (sibling_basename);
	return result;
}

static gboolean
___lambda71__games_directory_file_info_test (GFileInfo* file_info,
                                             gpointer self,
                                             GError** error)
{
	gboolean result;
	result = __lambda71_ (self, file_info, error);
	return result;
}

static gchar*
games_local_cover_get_sibling_cover_path (GamesLocalCover* self,
                                          GError** error)
{
	Block31Data* _data31_;
	GFile* file = NULL;
	GamesUri* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GamesDirectory* directory = NULL;
	GFile* _tmp9_;
	GamesDirectory* _tmp10_;
	gchar* attributes = NULL;
	gchar* _tmp11_;
	GamesDirectory* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data31_ = g_slice_new0 (Block31Data);
	_data31_->_ref_count_ = 1;
	_data31_->self = g_object_ref (self);
	_tmp0_ = self->priv->uri;
	_tmp1_ = games_uri_to_file (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_get_parent (_tmp2_);
	_data31_->parent = _tmp3_;
	_tmp4_ = _data31_->parent;
	if (_tmp4_ == NULL) {
		result = NULL;
		_g_object_unref0 (file);
		block31_data_unref (_data31_);
		_data31_ = NULL;
		return result;
	}
	_tmp5_ = file;
	_tmp6_ = g_file_get_basename (_tmp5_);
	_data31_->basename = _tmp6_;
	_tmp7_ = _data31_->basename;
	_tmp8_ = games_local_cover_get_basename_prefix (self, _tmp7_);
	_data31_->prefix = _tmp8_;
	_data31_->cover_path = NULL;
	_tmp9_ = _data31_->parent;
	_tmp10_ = games_directory_new (_tmp9_);
	directory = _tmp10_;
	_tmp11_ = g_strjoin (",", G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE, NULL);
	attributes = _tmp11_;
	_tmp12_ = directory;
	_tmp13_ = attributes;
	games_directory_foreach (_tmp12_, _tmp13_, ___lambda71__games_directory_file_info_test, _data31_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (attributes);
		_g_object_unref0 (directory);
		_g_object_unref0 (file);
		block31_data_unref (_data31_);
		_data31_ = NULL;
		return NULL;
	}
	_tmp14_ = _data31_->cover_path;
	_tmp15_ = g_strdup (_tmp14_);
	result = _tmp15_;
	_g_free0 (attributes);
	_g_object_unref0 (directory);
	_g_object_unref0 (file);
	block31_data_unref (_data31_);
	_data31_ = NULL;
	return result;
}

static Block32Data*
block32_data_ref (Block32Data* _data32_)
{
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}

static void
block32_data_unref (void * _userdata_)
{
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		GamesLocalCover* self;
		self = _data32_->self;
		_g_free0 (_data32_->cover_path);
		_g_object_unref0 (_data32_->parent);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}

static gboolean
__lambda72_ (Block32Data* _data32_,
             GFileInfo* sibbling,
             GError** error)
{
	GamesLocalCover* self;
	gchar* sibbling_basename = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gchar* type = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GFile* sibbling_file = NULL;
	GFile* _tmp8_;
	const gchar* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	gchar* _tmp12_;
	gboolean result;
	self = _data32_->self;
	g_return_val_if_fail (sibbling != NULL, FALSE);
	_tmp0_ = g_file_info_get_name (sibbling);
	_tmp1_ = g_strdup (_tmp0_);
	sibbling_basename = _tmp1_;
	_tmp3_ = sibbling_basename;
	if (!g_str_has_prefix (_tmp3_, "cover.")) {
		const gchar* _tmp4_;
		_tmp4_ = sibbling_basename;
		_tmp2_ = !g_str_has_prefix (_tmp4_, "folder.");
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = FALSE;
		_g_free0 (sibbling_basename);
		return result;
	}
	_tmp5_ = g_file_info_get_attribute_string (sibbling, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE);
	_tmp6_ = g_strdup (_tmp5_);
	type = _tmp6_;
	_tmp7_ = type;
	if (!g_str_has_prefix (_tmp7_, "image")) {
		result = FALSE;
		_g_free0 (type);
		_g_free0 (sibbling_basename);
		return result;
	}
	_tmp8_ = _data32_->parent;
	_tmp9_ = sibbling_basename;
	_tmp10_ = g_file_get_child (_tmp8_, _tmp9_);
	sibbling_file = _tmp10_;
	_tmp11_ = sibbling_file;
	_tmp12_ = g_file_get_path (_tmp11_);
	_g_free0 (_data32_->cover_path);
	_data32_->cover_path = _tmp12_;
	result = TRUE;
	_g_object_unref0 (sibbling_file);
	_g_free0 (type);
	_g_free0 (sibbling_basename);
	return result;
}

static gboolean
___lambda72__games_directory_file_info_test (GFileInfo* file_info,
                                             gpointer self,
                                             GError** error)
{
	gboolean result;
	result = __lambda72_ (self, file_info, error);
	return result;
}

static gchar*
games_local_cover_get_directory_cover_path (GamesLocalCover* self,
                                            GError** error)
{
	Block32Data* _data32_;
	GFile* file = NULL;
	GamesUri* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GamesDirectory* directory = NULL;
	GFile* _tmp5_;
	GamesDirectory* _tmp6_;
	gchar* attributes = NULL;
	gchar* _tmp7_;
	GamesDirectory* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data32_ = g_slice_new0 (Block32Data);
	_data32_->_ref_count_ = 1;
	_data32_->self = g_object_ref (self);
	_tmp0_ = self->priv->uri;
	_tmp1_ = games_uri_to_file (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_get_parent (_tmp2_);
	_data32_->parent = _tmp3_;
	_tmp4_ = _data32_->parent;
	if (_tmp4_ == NULL) {
		result = NULL;
		_g_object_unref0 (file);
		block32_data_unref (_data32_);
		_data32_ = NULL;
		return result;
	}
	_data32_->cover_path = NULL;
	_tmp5_ = _data32_->parent;
	_tmp6_ = games_directory_new (_tmp5_);
	directory = _tmp6_;
	_tmp7_ = g_strjoin (",", G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE, NULL);
	attributes = _tmp7_;
	_tmp8_ = directory;
	_tmp9_ = attributes;
	games_directory_foreach (_tmp8_, _tmp9_, ___lambda72__games_directory_file_info_test, _data32_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (attributes);
		_g_object_unref0 (directory);
		_g_object_unref0 (file);
		block32_data_unref (_data32_);
		_data32_ = NULL;
		return NULL;
	}
	_tmp10_ = _data32_->cover_path;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	_g_free0 (attributes);
	_g_object_unref0 (directory);
	_g_object_unref0 (file);
	block32_data_unref (_data32_);
	_data32_ = NULL;
	return result;
}

static void
games_local_cover_class_init (GamesLocalCoverClass * klass,
                              gpointer klass_data)
{
	games_local_cover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesLocalCover_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_local_cover_finalize;
}

static void
games_local_cover_games_cover_interface_init (GamesCoverIface * iface,
                                              gpointer iface_data)
{
	games_local_cover_games_cover_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_cover = (GFile* (*) (GamesCover*)) games_local_cover_real_get_cover;
}

static void
games_local_cover_instance_init (GamesLocalCover * self,
                                 gpointer klass)
{
	self->priv = games_local_cover_get_instance_private (self);
}

static void
games_local_cover_finalize (GObject * obj)
{
	GamesLocalCover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_LOCAL_COVER, GamesLocalCover);
	_games_uri_unref0 (self->priv->uri);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (games_local_cover_parent_class)->finalize (obj);
}

static GType
games_local_cover_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesLocalCoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_local_cover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesLocalCover), 0, (GInstanceInitFunc) games_local_cover_instance_init, NULL };
	static const GInterfaceInfo games_cover_info = { (GInterfaceInitFunc) games_local_cover_games_cover_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType games_local_cover_type_id;
	games_local_cover_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesLocalCover", &g_define_type_info, 0);
	g_type_add_interface_static (games_local_cover_type_id, GAMES_TYPE_COVER, &games_cover_info);
	GamesLocalCover_private_offset = g_type_add_instance_private (games_local_cover_type_id, sizeof (GamesLocalCoverPrivate));
	return games_local_cover_type_id;
}

GType
games_local_cover_get_type (void)
{
	static volatile gsize games_local_cover_type_id__once = 0;
	if (g_once_init_enter (&games_local_cover_type_id__once)) {
		GType games_local_cover_type_id;
		games_local_cover_type_id = games_local_cover_get_type_once ();
		g_once_init_leave (&games_local_cover_type_id__once, games_local_cover_type_id);
	}
	return games_local_cover_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

