/* file-operations.c generated by valac 0.56.8, the Vala compiler
 * generated from file-operations.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <archive.h>
#include <glib/gi18n-lib.h>
#include <archive_entry.h>
#include <time.h>
#include <sys/stat.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#define _archive_write_free0(var) ((var == NULL) ? NULL : (var = (archive_write_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _archive_entry_free0(var) ((var == NULL) ? NULL : (var = (archive_entry_free (var), NULL)))
#define _archive_read_free0(var) ((var == NULL) ? NULL : (var = (archive_read_free (var), NULL)))
typedef struct _GamesParamSpecFileOperations GamesParamSpecFileOperations;

struct _GamesParamSpecFileOperations {
	GParamSpec parent_instance;
};

static gpointer games_file_operations_parent_class = NULL;

static void games_file_operations_backup_data (GFile* parent,
                                        GFile* dir,
                                        struct archive* archive,
                                        gchar** exclusions,
                                        gint exclusions_length1,
                                        GError** error);
static void games_file_operations_compress_files (GFile* parent_working_dir,
                                           GFile* export_dir,
                                           struct archive* export_archive,
                                           GError** error);
static guint8* _vala_array_dup32 (guint8* self,
                           gssize length);
static void games_file_operations_copy_recursively (GFile* src,
                                             GFile* dest,
                                             gboolean merge_flag,
                                             GError** error);
static void games_file_operations_finalize (GamesFileOperations * obj);
static GType games_file_operations_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

GQuark
games_compression_error_quark (void)
{
	return g_quark_from_static_string ("games-compression-error-quark");
}

static GType
games_compression_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GAMES_COMPRESSION_ERROR_CLOSING_FAILED, "GAMES_COMPRESSION_ERROR_CLOSING_FAILED", "closing-failed"}, {GAMES_COMPRESSION_ERROR_COULDNT_ENUMERATE_CHILDREN, "GAMES_COMPRESSION_ERROR_COULDNT_ENUMERATE_CHILDREN", "couldnt-enumerate-children"}, {GAMES_COMPRESSION_ERROR_COULDNT_READ_FILE, "GAMES_COMPRESSION_ERROR_COULDNT_READ_FILE", "couldnt-read-file"}, {GAMES_COMPRESSION_ERROR_COULDNT_WRITE_HEADER, "GAMES_COMPRESSION_ERROR_COULDNT_WRITE_HEADER", "couldnt-write-header"}, {GAMES_COMPRESSION_ERROR_COULDNT_WRITE_FILE, "GAMES_COMPRESSION_ERROR_COULDNT_WRITE_FILE", "couldnt-write-file"}, {GAMES_COMPRESSION_ERROR_INITIALIZATION_FAILED, "GAMES_COMPRESSION_ERROR_INITIALIZATION_FAILED", "initialization-failed"}, {0, NULL, NULL}};
	GType games_compression_error_type_id;
	games_compression_error_type_id = g_enum_register_static ("GamesCompressionError", values);
	return games_compression_error_type_id;
}

GType
games_compression_error_get_type (void)
{
	static volatile gsize games_compression_error_type_id__once = 0;
	if (g_once_init_enter (&games_compression_error_type_id__once)) {
		GType games_compression_error_type_id;
		games_compression_error_type_id = games_compression_error_get_type_once ();
		g_once_init_leave (&games_compression_error_type_id__once, games_compression_error_type_id);
	}
	return games_compression_error_type_id__once;
}

GQuark
games_extraction_error_quark (void)
{
	return g_quark_from_static_string ("games-extraction-error-quark");
}

static GType
games_extraction_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GAMES_EXTRACTION_ERROR_CLEANUP_FAILED, "GAMES_EXTRACTION_ERROR_CLEANUP_FAILED", "cleanup-failed"}, {GAMES_EXTRACTION_ERROR_COULDNT_READ_HEADER, "GAMES_EXTRACTION_ERROR_COULDNT_READ_HEADER", "couldnt-read-header"}, {GAMES_EXTRACTION_ERROR_DIDNT_REACH_EOF, "GAMES_EXTRACTION_ERROR_DIDNT_REACH_EOF", "didnt-reach-eof"}, {0, NULL, NULL}};
	GType games_extraction_error_type_id;
	games_extraction_error_type_id = g_enum_register_static ("GamesExtractionError", values);
	return games_extraction_error_type_id;
}

GType
games_extraction_error_get_type (void)
{
	static volatile gsize games_extraction_error_type_id__once = 0;
	if (g_once_init_enter (&games_extraction_error_type_id__once)) {
		GType games_extraction_error_type_id;
		games_extraction_error_type_id = games_extraction_error_get_type_once ();
		g_once_init_leave (&games_extraction_error_type_id__once, games_extraction_error_type_id);
	}
	return games_extraction_error_type_id__once;
}

void
games_file_operations_compress_dir (const gchar* archive_path,
                                    GFile* exported_data,
                                    gchar** exclude_files,
                                    gint exclude_files_length1,
                                    GError** error)
{
	struct archive* archive = NULL;
	struct archive* _tmp0_;
	struct archive* _tmp1_;
	struct archive* _tmp2_;
	struct archive* _tmp3_;
	struct archive* _tmp4_;
	struct archive* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (archive_path != NULL);
	g_return_if_fail (exported_data != NULL);
	_tmp0_ = archive_write_new ();
	archive = _tmp0_;
	_tmp1_ = archive;
	archive_write_add_filter_gzip (_tmp1_);
	_tmp2_ = archive;
	archive_write_set_format_pax_restricted (_tmp2_);
	_tmp3_ = archive;
	archive_write_open_filename (_tmp3_, archive_path);
	_tmp4_ = archive;
	games_file_operations_backup_data (exported_data, exported_data, _tmp4_, exclude_files, (gint) exclude_files_length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_COMPRESSION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_archive_write_free0 (archive);
			return;
		} else {
			_archive_write_free0 (archive);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp5_ = archive;
	if (archive_write_close (_tmp5_) != ARCHIVE_OK) {
		gchar* error_message = NULL;
		struct archive* _tmp6_;
		const gchar* _tmp7_;
		struct archive* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		GError* _tmp11_;
		_tmp6_ = archive;
		_tmp7_ = archive_error_string (_tmp6_);
		_tmp8_ = archive;
		_tmp9_ = g_strdup_printf (_ ("Error: %s (%d)"), _tmp7_, archive_errno (_tmp8_));
		error_message = _tmp9_;
		_tmp10_ = error_message;
		_tmp11_ = g_error_new_literal (GAMES_COMPRESSION_ERROR, GAMES_COMPRESSION_ERROR_CLOSING_FAILED, _tmp10_);
		_inner_error0_ = _tmp11_;
		if (_inner_error0_->domain == GAMES_COMPRESSION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (error_message);
			_archive_write_free0 (archive);
			return;
		} else {
			_g_free0 (error_message);
			_archive_write_free0 (archive);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (error_message);
	}
	_archive_write_free0 (archive);
}

static void
games_file_operations_backup_data (GFile* parent,
                                   GFile* dir,
                                   struct archive* archive,
                                   gchar** exclusions,
                                   gint exclusions_length1,
                                   GError** error)
{
	GFileType dtype = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (parent != NULL);
	g_return_if_fail (dir != NULL);
	g_return_if_fail (archive != NULL);
	dtype = g_file_query_file_type (dir, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
	{
		gchar** filename_collection = NULL;
		gint filename_collection_length1 = 0;
		gint _filename_collection_size_ = 0;
		gint filename_it = 0;
		filename_collection = exclusions;
		filename_collection_length1 = exclusions_length1;
		for (filename_it = 0; filename_it < filename_collection_length1; filename_it = filename_it + 1) {
			gchar* _tmp0_;
			gchar* filename = NULL;
			_tmp0_ = g_strdup (filename_collection[filename_it]);
			filename = _tmp0_;
			{
				gchar* _tmp1_;
				gchar* _tmp2_;
				const gchar* _tmp3_;
				gboolean _tmp4_;
				_tmp1_ = g_file_get_parse_name (dir);
				_tmp2_ = _tmp1_;
				_tmp3_ = filename;
				_tmp4_ = g_strcmp0 (_tmp2_, _tmp3_) == 0;
				_g_free0 (_tmp2_);
				if (_tmp4_) {
					_g_free0 (filename);
					return;
				}
				_g_free0 (filename);
			}
		}
	}
	if (dir != parent) {
		games_file_operations_compress_files (parent, dir, archive, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GAMES_COMPRESSION_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	if (dtype == G_FILE_TYPE_DIRECTORY) {
		{
			GFileEnumerator* dir_children = NULL;
			GFileEnumerator* _tmp5_;
			GFileInfo* dir_info = NULL;
			_tmp5_ = g_file_enumerate_children (dir, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
			dir_children = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			while (TRUE) {
				GFileInfo* _tmp6_ = NULL;
				GFileEnumerator* _tmp7_;
				GFileInfo* _tmp8_;
				GFileInfo* _tmp9_;
				GFileInfo* _tmp10_;
				GFile* file = NULL;
				GFileInfo* _tmp11_;
				const gchar* _tmp12_;
				GFile* _tmp13_;
				GFile* _tmp14_;
				_tmp7_ = dir_children;
				_tmp8_ = g_file_enumerator_next_file (_tmp7_, NULL, &_inner_error0_);
				_tmp6_ = _tmp8_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (dir_info);
					_g_object_unref0 (dir_children);
					goto __catch0_g_error;
				}
				_tmp9_ = _tmp6_;
				_tmp6_ = NULL;
				_g_object_unref0 (dir_info);
				dir_info = _tmp9_;
				_tmp10_ = dir_info;
				if (!(_tmp10_ != NULL)) {
					_g_object_unref0 (_tmp6_);
					break;
				}
				_tmp11_ = dir_info;
				_tmp12_ = g_file_info_get_name (_tmp11_);
				_tmp13_ = g_file_get_child (dir, _tmp12_);
				file = _tmp13_;
				_tmp14_ = file;
				games_file_operations_backup_data (parent, _tmp14_, archive, exclusions, (gint) exclusions_length1, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (file);
					_g_object_unref0 (_tmp6_);
					_g_object_unref0 (dir_info);
					_g_object_unref0 (dir_children);
					goto __catch0_g_error;
				}
				_g_object_unref0 (file);
				_g_object_unref0 (_tmp6_);
			}
			_g_object_unref0 (dir_info);
			_g_object_unref0 (dir_children);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp15_;
			const gchar* _tmp16_;
			GError* _tmp17_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp15_ = e;
			_tmp16_ = _tmp15_->message;
			_tmp17_ = g_error_new_literal (GAMES_COMPRESSION_ERROR, GAMES_COMPRESSION_ERROR_COULDNT_ENUMERATE_CHILDREN, _tmp16_);
			_inner_error0_ = _tmp17_;
			_g_error_free0 (e);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == GAMES_COMPRESSION_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
}

static void
games_file_operations_compress_files (GFile* parent_working_dir,
                                      GFile* export_dir,
                                      struct archive* export_archive,
                                      GError** error)
{
	GFileInfo* export_info = NULL;
	GFileType file_type = 0;
	struct archive_entry* entry = NULL;
	struct archive_entry* _tmp7_;
	GDateTime* datetime = NULL;
	GFileInfo* _tmp8_;
	GDateTime* _tmp9_;
	struct archive_entry* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	struct archive_entry* _tmp13_;
	GFileInfo* _tmp14_;
	struct archive_entry* _tmp15_;
	GDateTime* _tmp16_;
	struct archive_entry* _tmp17_;
	GFileInfo* _tmp18_;
	struct archive_entry* _tmp21_;
	struct archive_entry* _tmp29_;
	GDataInputStream* data_input_stream = NULL;
	gsize bytes_read = 0UL;
	guint8* buffer = NULL;
	guint8* _tmp36_;
	gint buffer_length1;
	gint _buffer_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (parent_working_dir != NULL);
	g_return_if_fail (export_dir != NULL);
	g_return_if_fail (export_archive != NULL);
	{
		gchar* attributes = NULL;
		gchar* _tmp0_;
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		_tmp0_ = g_strdup_printf ("%s,%s,%s", G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_ATTRIBUTE_TIME_MODIFIED, G_FILE_ATTRIBUTE_UNIX_MODE);
		attributes = _tmp0_;
		_tmp2_ = g_file_query_info (export_dir, attributes, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (attributes);
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (export_info);
		export_info = _tmp3_;
		_g_object_unref0 (_tmp1_);
		_g_free0 (attributes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = g_error_new_literal (GAMES_COMPRESSION_ERROR, GAMES_COMPRESSION_ERROR_INITIALIZATION_FAILED, _tmp5_);
		_inner_error0_ = _tmp6_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_COMPRESSION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (export_info);
			return;
		} else {
			_g_object_unref0 (export_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	file_type = g_file_query_file_type (export_dir, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
	_tmp7_ = archive_entry_new2 (NULL);
	entry = _tmp7_;
	_tmp8_ = export_info;
	_tmp9_ = g_file_info_get_modification_date_time (_tmp8_);
	datetime = _tmp9_;
	_tmp10_ = entry;
	_tmp11_ = g_file_get_relative_path (parent_working_dir, export_dir);
	_tmp12_ = _tmp11_;
	archive_entry_set_pathname (_tmp10_, _tmp12_);
	_g_free0 (_tmp12_);
	_tmp13_ = entry;
	_tmp14_ = export_info;
	archive_entry_set_size (_tmp13_, (la_int64_t) g_file_info_get_size (_tmp14_));
	_tmp15_ = entry;
	_tmp16_ = datetime;
	archive_entry_set_mtime (_tmp15_, (time_t) g_date_time_to_unix (_tmp16_), (glong) 0);
	_tmp17_ = entry;
	_tmp18_ = export_info;
	archive_entry_set_perm (_tmp17_, (__LA_MODE_T) g_file_info_get_attribute_uint32 (_tmp18_, G_FILE_ATTRIBUTE_UNIX_MODE));
	if (file_type == G_FILE_TYPE_DIRECTORY) {
		struct archive_entry* _tmp19_;
		_tmp19_ = entry;
		archive_entry_set_filetype (_tmp19_, (__LA_MODE_T) S_IFDIR);
	} else {
		struct archive_entry* _tmp20_;
		_tmp20_ = entry;
		archive_entry_set_filetype (_tmp20_, (__LA_MODE_T) S_IFREG);
	}
	_tmp21_ = entry;
	if (archive_write_header (export_archive, _tmp21_) != ARCHIVE_OK) {
		gchar* error_msg = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		GError* _tmp28_;
		_tmp22_ = g_file_get_path (export_dir);
		_tmp23_ = _tmp22_;
		_tmp24_ = archive_error_string (export_archive);
		_tmp25_ = g_strdup_printf (_ ("Error writing “%s”: %s (%d)"), _tmp23_, _tmp24_, archive_errno (export_archive));
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp23_);
		error_msg = _tmp26_;
		_tmp27_ = error_msg;
		_tmp28_ = g_error_new_literal (GAMES_COMPRESSION_ERROR, GAMES_COMPRESSION_ERROR_COULDNT_WRITE_HEADER, _tmp27_);
		_inner_error0_ = _tmp28_;
		if (_inner_error0_->domain == GAMES_COMPRESSION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (error_msg);
			_g_date_time_unref0 (datetime);
			_archive_entry_free0 (entry);
			_g_object_unref0 (export_info);
			return;
		} else {
			_g_free0 (error_msg);
			_g_date_time_unref0 (datetime);
			_archive_entry_free0 (entry);
			_g_object_unref0 (export_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_g_free0 (error_msg);
	}
	_tmp29_ = entry;
	if (archive_entry_size (_tmp29_) <= ((la_int64_t) 0)) {
		_g_date_time_unref0 (datetime);
		_archive_entry_free0 (entry);
		_g_object_unref0 (export_info);
		return;
	}
	{
		GFileInputStream* input_stream = NULL;
		GFileInputStream* _tmp30_;
		GFileInputStream* _tmp31_;
		GDataInputStream* _tmp32_;
		_tmp30_ = g_file_read (export_dir, NULL, &_inner_error0_);
		input_stream = _tmp30_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp31_ = input_stream;
		_tmp32_ = g_data_input_stream_new ((GInputStream*) _tmp31_);
		_g_object_unref0 (data_input_stream);
		data_input_stream = _tmp32_;
		_g_object_unref0 (input_stream);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp33_;
		const gchar* _tmp34_;
		GError* _tmp35_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp33_ = e;
		_tmp34_ = _tmp33_->message;
		_tmp35_ = g_error_new_literal (GAMES_COMPRESSION_ERROR, GAMES_COMPRESSION_ERROR_COULDNT_READ_FILE, _tmp34_);
		_inner_error0_ = _tmp35_;
		_g_error_free0 (e);
		goto __finally1;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_COMPRESSION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (data_input_stream);
			_g_date_time_unref0 (datetime);
			_archive_entry_free0 (entry);
			_g_object_unref0 (export_info);
			return;
		} else {
			_g_object_unref0 (data_input_stream);
			_g_date_time_unref0 (datetime);
			_archive_entry_free0 (entry);
			_g_object_unref0 (export_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp36_ = g_new0 (guint8, 64);
	buffer = _tmp36_;
	buffer_length1 = 64;
	_buffer_size_ = buffer_length1;
	{
		while (TRUE) {
			gboolean _tmp37_ = FALSE;
			GDataInputStream* _tmp38_;
			guint8* _tmp39_;
			gint _tmp39__length1;
			gsize _tmp40_ = 0UL;
			gboolean _tmp41_;
			guint8* _tmp42_;
			gint _tmp42__length1;
			_tmp38_ = data_input_stream;
			_tmp39_ = buffer;
			_tmp39__length1 = buffer_length1;
			_tmp41_ = g_input_stream_read_all ((GInputStream*) _tmp38_, _tmp39_, (gsize) _tmp39__length1, &_tmp40_, NULL, &_inner_error0_);
			bytes_read = _tmp40_;
			_tmp37_ = _tmp41_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			if (!_tmp37_) {
				break;
			}
			if (bytes_read <= ((gsize) 0)) {
				break;
			}
			_tmp42_ = buffer;
			_tmp42__length1 = buffer_length1;
			archive_write_data (export_archive, _tmp42_, (size_t) _tmp42__length1);
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp43_;
		const gchar* _tmp44_;
		GError* _tmp45_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp43_ = e;
		_tmp44_ = _tmp43_->message;
		_tmp45_ = g_error_new_literal (GAMES_COMPRESSION_ERROR, GAMES_COMPRESSION_ERROR_COULDNT_WRITE_FILE, _tmp44_);
		_inner_error0_ = _tmp45_;
		_g_error_free0 (e);
		goto __finally2;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_COMPRESSION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (data_input_stream);
			_g_date_time_unref0 (datetime);
			_archive_entry_free0 (entry);
			_g_object_unref0 (export_info);
			return;
		} else {
			buffer = (g_free (buffer), NULL);
			_g_object_unref0 (data_input_stream);
			_g_date_time_unref0 (datetime);
			_archive_entry_free0 (entry);
			_g_object_unref0 (export_info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	buffer = (g_free (buffer), NULL);
	_g_object_unref0 (data_input_stream);
	_g_date_time_unref0 (datetime);
	_archive_entry_free0 (entry);
	_g_object_unref0 (export_info);
}

void
games_file_operations_delete_files (GFile* file,
                                    gchar** excluded,
                                    gint excluded_length1,
                                    GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file != NULL);
	games_file_operations_delete_files_recurse (file, excluded, (gint) excluded_length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

gboolean
games_file_operations_delete_files_recurse (GFile* file,
                                            gchar** excluded,
                                            gint excluded_length1,
                                            GError** error)
{
	gboolean has_excluded_children = FALSE;
	GFileType dtype = 0;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	{
		gchar** filename_collection = NULL;
		gint filename_collection_length1 = 0;
		gint _filename_collection_size_ = 0;
		gint filename_it = 0;
		filename_collection = excluded;
		filename_collection_length1 = excluded_length1;
		for (filename_it = 0; filename_it < filename_collection_length1; filename_it = filename_it + 1) {
			gchar* _tmp0_;
			gchar* filename = NULL;
			_tmp0_ = g_strdup (filename_collection[filename_it]);
			filename = _tmp0_;
			{
				gchar* _tmp1_;
				gchar* _tmp2_;
				const gchar* _tmp3_;
				gboolean _tmp4_;
				_tmp1_ = g_file_get_parse_name (file);
				_tmp2_ = _tmp1_;
				_tmp3_ = filename;
				_tmp4_ = g_strcmp0 (_tmp2_, _tmp3_) == 0;
				_g_free0 (_tmp2_);
				if (_tmp4_) {
					result = TRUE;
					_g_free0 (filename);
					return result;
				}
				_g_free0 (filename);
			}
		}
	}
	has_excluded_children = FALSE;
	dtype = g_file_query_file_type (file, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL);
	if (dtype == G_FILE_TYPE_DIRECTORY) {
		GFileEnumerator* file_children = NULL;
		GFileEnumerator* _tmp5_;
		GFileInfo* file_info = NULL;
		_tmp5_ = g_file_enumerate_children (file, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
		file_children = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp6_;
		}
		while (TRUE) {
			GFileInfo* _tmp7_ = NULL;
			GFileEnumerator* _tmp8_;
			GFileInfo* _tmp9_;
			GFileInfo* _tmp11_;
			GFileInfo* _tmp12_;
			GFile* child = NULL;
			GFileInfo* _tmp13_;
			const gchar* _tmp14_;
			GFile* _tmp15_;
			gboolean _tmp16_ = FALSE;
			GFile* _tmp17_;
			_tmp8_ = file_children;
			_tmp9_ = g_file_enumerator_next_file (_tmp8_, NULL, &_inner_error0_);
			_tmp7_ = _tmp9_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp10_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file_children);
				return _tmp10_;
			}
			_tmp11_ = _tmp7_;
			_tmp7_ = NULL;
			_g_object_unref0 (file_info);
			file_info = _tmp11_;
			_tmp12_ = file_info;
			if (!(_tmp12_ != NULL)) {
				_g_object_unref0 (_tmp7_);
				break;
			}
			_tmp13_ = file_info;
			_tmp14_ = g_file_info_get_name (_tmp13_);
			_tmp15_ = g_file_get_child (file, _tmp14_);
			child = _tmp15_;
			_tmp17_ = child;
			_tmp16_ = games_file_operations_delete_files_recurse (_tmp17_, excluded, (gint) excluded_length1, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp18_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (child);
				_g_object_unref0 (_tmp7_);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file_children);
				return _tmp18_;
			}
			has_excluded_children |= _tmp16_;
			_g_object_unref0 (child);
			_g_object_unref0 (_tmp7_);
		}
		_g_object_unref0 (file_info);
		_g_object_unref0 (file_children);
	}
	if (!has_excluded_children) {
		g_file_delete (file, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp19_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp19_;
		}
	}
	result = FALSE;
	return result;
}

static guint8*
_vala_array_dup32 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

void
games_file_operations_extract_archive (const gchar* archive_path,
                                       const gchar* extract_dir,
                                       gchar** exclude,
                                       gint exclude_length1,
                                       GError** error)
{
	struct archive* restore_archive = NULL;
	struct archive* _tmp4_;
	struct archive* _tmp5_;
	struct archive* _tmp6_;
	int flags = 0;
	struct archive* extractor_archive = NULL;
	struct archive* _tmp7_;
	struct archive* _tmp8_;
	struct archive* _tmp9_;
	struct archive* _tmp10_;
	struct archive_entry* entry = NULL;
	int last_result = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (archive_path != NULL);
	g_return_if_fail (extract_dir != NULL);
	{
		GFile* file_dir = NULL;
		GFile* _tmp0_;
		_tmp0_ = g_file_new_for_path (extract_dir);
		file_dir = _tmp0_;
		games_file_operations_delete_files (file_dir, exclude, (gint) exclude_length1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file_dir);
			goto __catch0_g_error;
		}
		_g_object_unref0 (file_dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		_tmp3_ = g_error_new_literal (GAMES_EXTRACTION_ERROR, GAMES_EXTRACTION_ERROR_CLEANUP_FAILED, _tmp2_);
		_inner_error0_ = _tmp3_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_EXTRACTION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp4_ = archive_read_new ();
	restore_archive = _tmp4_;
	_tmp5_ = restore_archive;
	archive_read_support_format_all (_tmp5_);
	_tmp6_ = restore_archive;
	archive_read_support_filter_all (_tmp6_);
	flags = ARCHIVE_EXTRACT_TIME | ARCHIVE_EXTRACT_PERM;
	_tmp7_ = archive_write_disk_new ();
	extractor_archive = _tmp7_;
	_tmp8_ = extractor_archive;
	archive_write_disk_set_options (_tmp8_, flags);
	_tmp9_ = extractor_archive;
	archive_write_disk_set_standard_lookup (_tmp9_);
	_tmp10_ = restore_archive;
	archive_read_open_filename (_tmp10_, archive_path, (gsize) 10240);
	while (TRUE) {
		struct archive* _tmp11_;
		struct archive_entry* _tmp12_ = NULL;
		int _tmp13_;
		gchar* dir_pathname = NULL;
		struct archive_entry* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		struct archive_entry* _tmp17_;
		const gchar* _tmp18_;
		struct archive* _tmp19_;
		struct archive_entry* _tmp20_;
		guint8* buffer = NULL;
		guint8* _tmp24_;
		gint buffer_length1;
		gint _buffer_size_;
		gsize buffer_length = 0UL;
		_tmp11_ = restore_archive;
		_tmp13_ = archive_read_next_header (_tmp11_, &_tmp12_);
		entry = _tmp12_;
		last_result = _tmp13_;
		if (!(last_result == ARCHIVE_OK)) {
			break;
		}
		_tmp14_ = entry;
		_tmp15_ = archive_entry_pathname (_tmp14_);
		_tmp16_ = g_strdup_printf ("%s/%s", extract_dir, _tmp15_);
		dir_pathname = _tmp16_;
		_tmp17_ = entry;
		_tmp18_ = dir_pathname;
		archive_entry_set_pathname (_tmp17_, _tmp18_);
		_tmp19_ = extractor_archive;
		_tmp20_ = entry;
		if (archive_write_header (_tmp19_, _tmp20_) != ARCHIVE_OK) {
			struct archive* _tmp21_;
			const gchar* _tmp22_;
			GError* _tmp23_;
			_tmp21_ = extractor_archive;
			_tmp22_ = archive_error_string (_tmp21_);
			_tmp23_ = g_error_new (GAMES_EXTRACTION_ERROR, GAMES_EXTRACTION_ERROR_COULDNT_READ_HEADER, "%s\n", _tmp22_);
			_inner_error0_ = _tmp23_;
			if (_inner_error0_->domain == GAMES_EXTRACTION_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (dir_pathname);
				_archive_write_free0 (extractor_archive);
				_archive_read_free0 (restore_archive);
				return;
			} else {
				_g_free0 (dir_pathname);
				_archive_write_free0 (extractor_archive);
				_archive_read_free0 (restore_archive);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp24_ = g_new0 (guint8, 64);
		buffer = _tmp24_;
		buffer_length1 = 64;
		_buffer_size_ = buffer_length1;
		while (TRUE) {
			struct archive* _tmp25_;
			guint8* _tmp26_ = NULL;
			size_t _tmp27_ = 0;
			la_int64_t _tmp28_ = {0};
			int _tmp29_;
			guint8* _tmp30_;
			gint _tmp30__length1;
			struct archive* _tmp31_;
			guint8* _tmp32_;
			gint _tmp32__length1;
			_tmp25_ = restore_archive;
			_tmp29_ = archive_read_data_block (_tmp25_, &_tmp26_, &_tmp27_, &_tmp28_);
			buffer = (g_free (buffer), NULL);
			_tmp30_ = (_tmp26_ != NULL) ? _vala_array_dup32 (_tmp26_, _tmp27_) : _tmp26_;
			_tmp30__length1 = _tmp27_;
			buffer = _tmp30_;
			buffer_length1 = _tmp30__length1;
			_buffer_size_ = buffer_length1;
			buffer_length = (gsize) _tmp28_;
			if (!(_tmp29_ == ARCHIVE_OK)) {
				break;
			}
			_tmp31_ = extractor_archive;
			_tmp32_ = buffer;
			_tmp32__length1 = buffer_length1;
			if (archive_write_data_block (_tmp31_, _tmp32_, (size_t) _tmp32__length1, (la_int64_t) buffer_length) != ((gssize) ARCHIVE_OK)) {
				break;
			}
		}
		buffer = (g_free (buffer), NULL);
		_g_free0 (dir_pathname);
	}
	if (last_result != ARCHIVE_EOF) {
		struct archive* _tmp33_;
		const gchar* _tmp34_;
		struct archive* _tmp35_;
		GError* _tmp36_;
		_tmp33_ = restore_archive;
		_tmp34_ = archive_error_string (_tmp33_);
		_tmp35_ = restore_archive;
		_tmp36_ = g_error_new (GAMES_EXTRACTION_ERROR, GAMES_EXTRACTION_ERROR_DIDNT_REACH_EOF, "%s (%d)", _tmp34_, archive_errno (_tmp35_));
		_inner_error0_ = _tmp36_;
		if (_inner_error0_->domain == GAMES_EXTRACTION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_archive_write_free0 (extractor_archive);
			_archive_read_free0 (restore_archive);
			return;
		} else {
			_archive_write_free0 (extractor_archive);
			_archive_read_free0 (restore_archive);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_archive_write_free0 (extractor_archive);
	_archive_read_free0 (restore_archive);
}

void
games_file_operations_copy_dir (GFile* src,
                                GFile* dest,
                                GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (src != NULL);
	g_return_if_fail (dest != NULL);
	games_file_operations_copy_recursively (src, dest, FALSE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
games_file_operations_copy_contents (GFile* src,
                                     GFile* dest,
                                     GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (src != NULL);
	g_return_if_fail (dest != NULL);
	games_file_operations_copy_recursively (src, dest, TRUE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
games_file_operations_copy_recursively (GFile* src,
                                        GFile* dest,
                                        gboolean merge_flag,
                                        GError** error)
{
	GFileType src_type = 0;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (src != NULL);
	g_return_if_fail (dest != NULL);
	src_type = g_file_query_file_type (src, G_FILE_QUERY_INFO_NONE, NULL);
	if (src_type == G_FILE_TYPE_DIRECTORY) {
		gboolean _tmp0_ = FALSE;
		gchar* src_path = NULL;
		gchar* _tmp1_;
		gchar* dest_path = NULL;
		gchar* _tmp2_;
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp3_;
		if (!g_file_query_exists (dest, NULL)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = !merge_flag;
		}
		if (_tmp0_) {
			g_file_make_directory_with_parents (dest, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
			g_file_copy_attributes (src, dest, G_FILE_COPY_NONE, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
		}
		_tmp1_ = g_file_get_path (src);
		src_path = _tmp1_;
		_tmp2_ = g_file_get_path (dest);
		dest_path = _tmp2_;
		_tmp3_ = g_file_enumerate_children (src, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		enumerator = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (dest_path);
			_g_free0 (src_path);
			return;
		}
		{
			GFileInfo* info = NULL;
			GFileEnumerator* _tmp4_;
			GFileInfo* _tmp5_;
			_tmp4_ = enumerator;
			_tmp5_ = g_file_enumerator_next_file (_tmp4_, NULL, &_inner_error0_);
			info = _tmp5_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (enumerator);
				_g_free0 (dest_path);
				_g_free0 (src_path);
				return;
			}
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					GFileInfo* _tmp11_;
					gchar* info_name = NULL;
					GFileInfo* _tmp12_;
					const gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* src_object_path = NULL;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					GFile* src_object = NULL;
					const gchar* _tmp18_;
					GFile* _tmp19_;
					gchar* dest_object_path = NULL;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					GFile* dest_object = NULL;
					const gchar* _tmp23_;
					GFile* _tmp24_;
					GFile* _tmp25_;
					GFile* _tmp26_;
					if (!_tmp6_) {
						GFileInfo* _tmp7_ = NULL;
						GFileEnumerator* _tmp8_;
						GFileInfo* _tmp9_;
						GFileInfo* _tmp10_;
						_tmp8_ = enumerator;
						_tmp9_ = g_file_enumerator_next_file (_tmp8_, NULL, &_inner_error0_);
						_tmp7_ = _tmp9_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (info);
							_g_object_unref0 (enumerator);
							_g_free0 (dest_path);
							_g_free0 (src_path);
							return;
						}
						_tmp10_ = _tmp7_;
						_tmp7_ = NULL;
						_g_object_unref0 (info);
						info = _tmp10_;
						_g_object_unref0 (_tmp7_);
					}
					_tmp6_ = FALSE;
					_tmp11_ = info;
					if (!(_tmp11_ != NULL)) {
						break;
					}
					_tmp12_ = info;
					_tmp13_ = g_file_info_get_name (_tmp12_);
					_tmp14_ = g_strdup (_tmp13_);
					info_name = _tmp14_;
					_tmp15_ = src_path;
					_tmp16_ = info_name;
					_tmp17_ = g_build_filename (_tmp15_, _tmp16_, NULL);
					src_object_path = _tmp17_;
					_tmp18_ = src_object_path;
					_tmp19_ = g_file_new_for_path (_tmp18_);
					src_object = _tmp19_;
					_tmp20_ = dest_path;
					_tmp21_ = info_name;
					_tmp22_ = g_build_filename (_tmp20_, _tmp21_, NULL);
					dest_object_path = _tmp22_;
					_tmp23_ = dest_object_path;
					_tmp24_ = g_file_new_for_path (_tmp23_);
					dest_object = _tmp24_;
					_tmp25_ = src_object;
					_tmp26_ = dest_object;
					games_file_operations_copy_recursively (_tmp25_, _tmp26_, merge_flag, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_object_unref0 (dest_object);
						_g_free0 (dest_object_path);
						_g_object_unref0 (src_object);
						_g_free0 (src_object_path);
						_g_free0 (info_name);
						_g_object_unref0 (info);
						_g_object_unref0 (enumerator);
						_g_free0 (dest_path);
						_g_free0 (src_path);
						return;
					}
					_g_object_unref0 (dest_object);
					_g_free0 (dest_object_path);
					_g_object_unref0 (src_object);
					_g_free0 (src_object_path);
					_g_free0 (info_name);
				}
			}
			_g_object_unref0 (info);
		}
		_g_object_unref0 (enumerator);
		_g_free0 (dest_path);
		_g_free0 (src_path);
	} else {
		if (src_type == G_FILE_TYPE_REGULAR) {
			g_file_copy (src, dest, G_FILE_COPY_NONE, NULL, NULL, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				return;
			}
		}
	}
}

GamesFileOperations*
games_file_operations_construct (GType object_type)
{
	GamesFileOperations* self = NULL;
	self = (GamesFileOperations*) g_type_create_instance (object_type);
	return self;
}

GamesFileOperations*
games_file_operations_new (void)
{
	return games_file_operations_construct (GAMES_TYPE_FILE_OPERATIONS);
}

static void
games_value_file_operations_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
games_value_file_operations_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		games_file_operations_unref (value->data[0].v_pointer);
	}
}

static void
games_value_file_operations_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = games_file_operations_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
games_value_file_operations_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
games_value_file_operations_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GamesFileOperations * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = games_file_operations_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
games_value_file_operations_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	GamesFileOperations ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = games_file_operations_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
games_param_spec_file_operations (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	GamesParamSpecFileOperations* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GAMES_TYPE_FILE_OPERATIONS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
games_value_get_file_operations (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAMES_TYPE_FILE_OPERATIONS), NULL);
	return value->data[0].v_pointer;
}

void
games_value_set_file_operations (GValue* value,
                                 gpointer v_object)
{
	GamesFileOperations * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAMES_TYPE_FILE_OPERATIONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAMES_TYPE_FILE_OPERATIONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		games_file_operations_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		games_file_operations_unref (old);
	}
}

void
games_value_take_file_operations (GValue* value,
                                  gpointer v_object)
{
	GamesFileOperations * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GAMES_TYPE_FILE_OPERATIONS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GAMES_TYPE_FILE_OPERATIONS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		games_file_operations_unref (old);
	}
}

static void
games_file_operations_class_init (GamesFileOperationsClass * klass,
                                  gpointer klass_data)
{
	games_file_operations_parent_class = g_type_class_peek_parent (klass);
	((GamesFileOperationsClass *) klass)->finalize = games_file_operations_finalize;
}

static void
games_file_operations_instance_init (GamesFileOperations * self,
                                     gpointer klass)
{
	self->ref_count = 1;
}

static void
games_file_operations_finalize (GamesFileOperations * obj)
{
	GamesFileOperations * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_FILE_OPERATIONS, GamesFileOperations);
	g_signal_handlers_destroy (self);
}

static GType
games_file_operations_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { games_value_file_operations_init, games_value_file_operations_free_value, games_value_file_operations_copy_value, games_value_file_operations_peek_pointer, "p", games_value_file_operations_collect_value, "p", games_value_file_operations_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GamesFileOperationsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_file_operations_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesFileOperations), 0, (GInstanceInitFunc) games_file_operations_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType games_file_operations_type_id;
	games_file_operations_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GamesFileOperations", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return games_file_operations_type_id;
}

GType
games_file_operations_get_type (void)
{
	static volatile gsize games_file_operations_type_id__once = 0;
	if (g_once_init_enter (&games_file_operations_type_id__once)) {
		GType games_file_operations_type_id;
		games_file_operations_type_id = games_file_operations_get_type_once ();
		g_once_init_leave (&games_file_operations_type_id__once, games_file_operations_type_id);
	}
	return games_file_operations_type_id__once;
}

gpointer
games_file_operations_ref (gpointer instance)
{
	GamesFileOperations * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
games_file_operations_unref (gpointer instance)
{
	GamesFileOperations * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GAMES_FILE_OPERATIONS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

