/* titlebar-box.c generated by valac 0.56.8, the Vala compiler
 * generated from titlebar-box.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <handy.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <stdlib.h>
#include <string.h>
#include "gnome-games.h"

#define GAMES_TYPE_TITLEBAR_BOX (games_titlebar_box_get_type ())
#define GAMES_TITLEBAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_TITLEBAR_BOX, GamesTitlebarBox))
#define GAMES_TITLEBAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_TITLEBAR_BOX, GamesTitlebarBoxClass))
#define GAMES_IS_TITLEBAR_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_TITLEBAR_BOX))
#define GAMES_IS_TITLEBAR_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_TITLEBAR_BOX))
#define GAMES_TITLEBAR_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_TITLEBAR_BOX, GamesTitlebarBoxClass))

typedef struct _GamesTitlebarBox GamesTitlebarBox;
typedef struct _GamesTitlebarBoxClass GamesTitlebarBoxClass;
typedef struct _GamesTitlebarBoxPrivate GamesTitlebarBoxPrivate;
enum  {
	GAMES_TITLEBAR_BOX_0_PROPERTY,
	GAMES_TITLEBAR_BOX_TITLEBAR_PROPERTY,
	GAMES_TITLEBAR_BOX_CONTENT_PROPERTY,
	GAMES_TITLEBAR_BOX_OVERLAY_PROPERTY,
	GAMES_TITLEBAR_BOX_REVEAL_TITLEBAR_PROPERTY,
	GAMES_TITLEBAR_BOX_OVERLAY_DURATION_PROPERTY,
	GAMES_TITLEBAR_BOX_REVEAL_DURATION_PROPERTY,
	GAMES_TITLEBAR_BOX_NUM_PROPERTIES
};
static GParamSpec* games_titlebar_box_properties[GAMES_TITLEBAR_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GamesTitlebarBox {
	GtkContainer parent_instance;
	GamesTitlebarBoxPrivate * priv;
};

struct _GamesTitlebarBoxClass {
	GtkContainerClass parent_class;
};

struct _GamesTitlebarBoxPrivate {
	GtkWidget* _titlebar;
	GtkWidget* _content;
	gboolean _overlay;
	gboolean _reveal_titlebar;
	gint _overlay_duration;
	gint _reveal_duration;
	gint64 overlay_start_time;
	guint overlay_tick_cb_id;
	gdouble overlay_progress;
	gint64 reveal_start_time;
	guint reveal_tick_cb_id;
	gdouble reveal_progress;
};

static gint GamesTitlebarBox_private_offset;
static gpointer games_titlebar_box_parent_class = NULL;
static GtkBuildableIface * games_titlebar_box_gtk_buildable_parent_iface = NULL;

VALA_EXTERN GType games_titlebar_box_get_type (void) G_GNUC_CONST ;
static void games_titlebar_box_animate_overlay (GamesTitlebarBox* self);
VALA_EXTERN gboolean games_titlebar_box_get_overlay (GamesTitlebarBox* self);
static gboolean games_titlebar_box_overlay_tick_cb (GamesTitlebarBox* self,
                                             GtkWidget* widget,
                                             GdkFrameClock* frame_clock);
static gboolean _games_titlebar_box_overlay_tick_cb_gtk_tick_callback (GtkWidget* widget,
                                                                GdkFrameClock* frame_clock,
                                                                gpointer self);
VALA_EXTERN gint games_titlebar_box_get_overlay_duration (GamesTitlebarBox* self);
static gdouble games_titlebar_box_ease_out_cubic (GamesTitlebarBox* self,
                                           gdouble t);
static void games_titlebar_box_animate_reveal (GamesTitlebarBox* self);
VALA_EXTERN gboolean games_titlebar_box_get_reveal_titlebar (GamesTitlebarBox* self);
static gboolean games_titlebar_box_reveal_tick_cb (GamesTitlebarBox* self,
                                            GtkWidget* widget,
                                            GdkFrameClock* frame_clock);
static gboolean _games_titlebar_box_reveal_tick_cb_gtk_tick_callback (GtkWidget* widget,
                                                               GdkFrameClock* frame_clock,
                                                               gpointer self);
VALA_EXTERN gint games_titlebar_box_get_reveal_duration (GamesTitlebarBox* self);
static void games_titlebar_box_real_get_preferred_width (GtkWidget* base,
                                                  gint* min,
                                                  gint* nat);
VALA_EXTERN GtkWidget* games_titlebar_box_get_titlebar (GamesTitlebarBox* self);
VALA_EXTERN GtkWidget* games_titlebar_box_get_content (GamesTitlebarBox* self);
static gint games_titlebar_box_adjust_for_overlay (GamesTitlebarBox* self,
                                            gint height);
static void games_titlebar_box_real_get_preferred_height (GtkWidget* base,
                                                   gint* min,
                                                   gint* nat);
static void games_titlebar_box_real_size_allocate (GtkWidget* base,
                                            GtkAllocation* alloc);
static void games_titlebar_box_real_add (GtkContainer* base,
                                  GtkWidget* widget);
VALA_EXTERN void games_titlebar_box_set_content (GamesTitlebarBox* self,
                                     GtkWidget* value);
static void games_titlebar_box_real_remove (GtkContainer* base,
                                     GtkWidget* widget);
VALA_EXTERN void games_titlebar_box_set_titlebar (GamesTitlebarBox* self,
                                      GtkWidget* value);
static void games_titlebar_box_real_forall_internal (GtkContainer* base,
                                              gboolean include_internals,
                                              GtkCallback callback,
                                              gpointer callback_target);
static void games_titlebar_box_real_add_child (GtkBuildable* base,
                                        GtkBuilder* builder,
                                        GObject* child,
                                        const gchar* type);
VALA_EXTERN GamesTitlebarBox* games_titlebar_box_new (void);
VALA_EXTERN GamesTitlebarBox* games_titlebar_box_construct (GType object_type);
VALA_EXTERN void games_titlebar_box_set_overlay (GamesTitlebarBox* self,
                                     gboolean value);
VALA_EXTERN void games_titlebar_box_set_reveal_titlebar (GamesTitlebarBox* self,
                                             gboolean value);
VALA_EXTERN void games_titlebar_box_set_overlay_duration (GamesTitlebarBox* self,
                                              gint value);
VALA_EXTERN void games_titlebar_box_set_reveal_duration (GamesTitlebarBox* self,
                                             gint value);
static GObject * games_titlebar_box_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void games_titlebar_box_finalize (GObject * obj);
static GType games_titlebar_box_get_type_once (void);
static void _vala_games_titlebar_box_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_games_titlebar_box_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_titlebar_box_get_instance_private (GamesTitlebarBox* self)
{
	return G_STRUCT_MEMBER_P (self, GamesTitlebarBox_private_offset);
}

static gboolean
_games_titlebar_box_overlay_tick_cb_gtk_tick_callback (GtkWidget* widget,
                                                       GdkFrameClock* frame_clock,
                                                       gpointer self)
{
	gboolean result;
	result = games_titlebar_box_overlay_tick_cb ((GamesTitlebarBox*) self, widget, frame_clock);
	return result;
}

static void
games_titlebar_box_animate_overlay (GamesTitlebarBox* self)
{
	gboolean _tmp0_ = FALSE;
	GdkFrameClock* _tmp4_;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	if (!hdy_get_enable_animations ((GtkWidget*) self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !gtk_widget_get_mapped ((GtkWidget*) self);
	}
	if (_tmp0_) {
		gint _tmp1_ = 0;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = games_titlebar_box_get_overlay (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			_tmp1_ = 1;
		} else {
			_tmp1_ = 0;
		}
		self->priv->overlay_progress = (gdouble) _tmp1_;
		gtk_widget_queue_resize ((GtkWidget*) self);
		return;
	}
	if (self->priv->overlay_tick_cb_id != ((guint) 0)) {
		gtk_widget_remove_tick_callback ((GtkWidget*) self, self->priv->overlay_tick_cb_id);
		self->priv->overlay_tick_cb_id = (guint) 0;
	}
	_tmp4_ = gtk_widget_get_frame_clock ((GtkWidget*) self);
	self->priv->overlay_start_time = gdk_frame_clock_get_frame_time (_tmp4_) / 1000;
	_tmp6_ = games_titlebar_box_get_overlay (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		_tmp5_ = 0;
	} else {
		_tmp5_ = 1;
	}
	self->priv->overlay_progress = (gdouble) _tmp5_;
	self->priv->overlay_tick_cb_id = gtk_widget_add_tick_callback ((GtkWidget*) self, _games_titlebar_box_overlay_tick_cb_gtk_tick_callback, g_object_ref (self), g_object_unref);
}

static gboolean
games_titlebar_box_overlay_tick_cb (GamesTitlebarBox* self,
                                    GtkWidget* widget,
                                    GdkFrameClock* frame_clock)
{
	gint64 frame_time = 0LL;
	gdouble t = 0.0;
	gint _tmp0_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (frame_clock != NULL, FALSE);
	frame_time = gdk_frame_clock_get_frame_time (frame_clock) / 1000;
	_tmp0_ = self->priv->_overlay_duration;
	t = ((gdouble) (frame_time - self->priv->overlay_start_time)) / _tmp0_;
	if (t >= ((gdouble) 1)) {
		gint _tmp1_ = 0;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = games_titlebar_box_get_overlay (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			_tmp1_ = 1;
		} else {
			_tmp1_ = 0;
		}
		self->priv->overlay_progress = (gdouble) _tmp1_;
		self->priv->overlay_tick_cb_id = (guint) 0;
		gtk_widget_queue_resize ((GtkWidget*) self);
		result = FALSE;
		return result;
	}
	self->priv->overlay_progress = games_titlebar_box_ease_out_cubic (self, t);
	_tmp4_ = games_titlebar_box_get_overlay (self);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		self->priv->overlay_progress = 1 - self->priv->overlay_progress;
	}
	gtk_widget_queue_resize ((GtkWidget*) self);
	result = TRUE;
	return result;
}

static gboolean
_games_titlebar_box_reveal_tick_cb_gtk_tick_callback (GtkWidget* widget,
                                                      GdkFrameClock* frame_clock,
                                                      gpointer self)
{
	gboolean result;
	result = games_titlebar_box_reveal_tick_cb ((GamesTitlebarBox*) self, widget, frame_clock);
	return result;
}

static void
games_titlebar_box_animate_reveal (GamesTitlebarBox* self)
{
	gboolean _tmp0_ = FALSE;
	GdkFrameClock* _tmp4_;
	gint _tmp5_ = 0;
	gboolean _tmp6_;
	gboolean _tmp7_;
	g_return_if_fail (self != NULL);
	if (!hdy_get_enable_animations ((GtkWidget*) self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !gtk_widget_get_mapped ((GtkWidget*) self);
	}
	if (_tmp0_) {
		gint _tmp1_ = 0;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = games_titlebar_box_get_reveal_titlebar (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			_tmp1_ = 1;
		} else {
			_tmp1_ = 0;
		}
		self->priv->reveal_progress = (gdouble) _tmp1_;
		gtk_widget_queue_resize ((GtkWidget*) self);
		return;
	}
	if (self->priv->reveal_tick_cb_id != ((guint) 0)) {
		gtk_widget_remove_tick_callback ((GtkWidget*) self, self->priv->reveal_tick_cb_id);
		self->priv->reveal_tick_cb_id = (guint) 0;
	}
	_tmp4_ = gtk_widget_get_frame_clock ((GtkWidget*) self);
	self->priv->reveal_start_time = gdk_frame_clock_get_frame_time (_tmp4_) / 1000;
	_tmp6_ = games_titlebar_box_get_reveal_titlebar (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		_tmp5_ = 0;
	} else {
		_tmp5_ = 1;
	}
	self->priv->reveal_progress = (gdouble) _tmp5_;
	self->priv->reveal_tick_cb_id = gtk_widget_add_tick_callback ((GtkWidget*) self, _games_titlebar_box_reveal_tick_cb_gtk_tick_callback, g_object_ref (self), g_object_unref);
}

static gboolean
games_titlebar_box_reveal_tick_cb (GamesTitlebarBox* self,
                                   GtkWidget* widget,
                                   GdkFrameClock* frame_clock)
{
	gint64 frame_time = 0LL;
	gdouble t = 0.0;
	gint _tmp0_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (frame_clock != NULL, FALSE);
	frame_time = gdk_frame_clock_get_frame_time (frame_clock) / 1000;
	_tmp0_ = self->priv->_reveal_duration;
	t = ((gdouble) (frame_time - self->priv->reveal_start_time)) / _tmp0_;
	if (t >= ((gdouble) 1)) {
		gint _tmp1_ = 0;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = games_titlebar_box_get_reveal_titlebar (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			_tmp1_ = 1;
		} else {
			_tmp1_ = 0;
		}
		self->priv->reveal_progress = (gdouble) _tmp1_;
		self->priv->reveal_tick_cb_id = (guint) 0;
		gtk_widget_queue_resize ((GtkWidget*) self);
		result = FALSE;
		return result;
	}
	self->priv->reveal_progress = games_titlebar_box_ease_out_cubic (self, t);
	_tmp4_ = games_titlebar_box_get_reveal_titlebar (self);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		self->priv->reveal_progress = 1 - self->priv->reveal_progress;
	}
	gtk_widget_queue_resize ((GtkWidget*) self);
	result = TRUE;
	return result;
}

static gdouble
games_titlebar_box_ease_out_cubic (GamesTitlebarBox* self,
                                   gdouble t)
{
	gdouble p = 0.0;
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	p = t - 1;
	result = ((p * p) * p) + 1;
	return result;
}

static void
games_titlebar_box_real_get_preferred_width (GtkWidget* base,
                                             gint* min,
                                             gint* nat)
{
	GamesTitlebarBox * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gint content_min = 0;
	gint content_nat = 0;
	gint titlebar_min = 0;
	gint titlebar_nat = 0;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	self = (GamesTitlebarBox*) base;
	_tmp0_ = games_titlebar_box_get_titlebar (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp2_ = games_titlebar_box_get_titlebar (self);
		_tmp3_ = _tmp2_;
		gtk_widget_get_preferred_width (_tmp3_, &_tmp4_, &_tmp5_);
		titlebar_min = _tmp4_;
		titlebar_nat = _tmp5_;
	} else {
		titlebar_nat = 0;
		titlebar_min = titlebar_nat;
	}
	_tmp6_ = games_titlebar_box_get_content (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GtkWidget* _tmp8_;
		GtkWidget* _tmp9_;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp8_ = games_titlebar_box_get_content (self);
		_tmp9_ = _tmp8_;
		gtk_widget_get_preferred_width (_tmp9_, &_tmp10_, &_tmp11_);
		content_min = _tmp10_;
		content_nat = _tmp11_;
	} else {
		content_nat = 0;
		content_min = content_nat;
	}
	_vala_min = MAX (content_min, titlebar_min);
	_vala_nat = MAX (content_nat, titlebar_nat);
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

static gint
games_titlebar_box_adjust_for_overlay (GamesTitlebarBox* self,
                                       gint height)
{
	gdouble progress = 0.0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	progress = MIN (1 - self->priv->overlay_progress, self->priv->reveal_progress);
	result = (gint) round (height * progress);
	return result;
}

static void
games_titlebar_box_real_get_preferred_height (GtkWidget* base,
                                              gint* min,
                                              gint* nat)
{
	GamesTitlebarBox * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	gint content_min = 0;
	gint content_nat = 0;
	gint titlebar_min = 0;
	gint titlebar_nat = 0;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	self = (GamesTitlebarBox*) base;
	_tmp0_ = games_titlebar_box_get_titlebar (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		_tmp2_ = games_titlebar_box_get_titlebar (self);
		_tmp3_ = _tmp2_;
		gtk_widget_get_preferred_height (_tmp3_, &_tmp4_, &_tmp5_);
		titlebar_min = _tmp4_;
		titlebar_nat = _tmp5_;
	} else {
		titlebar_nat = 0;
		titlebar_min = titlebar_nat;
	}
	_tmp6_ = games_titlebar_box_get_content (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		GtkWidget* _tmp8_;
		GtkWidget* _tmp9_;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp8_ = games_titlebar_box_get_content (self);
		_tmp9_ = _tmp8_;
		gtk_widget_get_preferred_height (_tmp9_, &_tmp10_, &_tmp11_);
		content_min = _tmp10_;
		content_nat = _tmp11_;
	} else {
		content_nat = 0;
		content_min = content_nat;
	}
	_vala_min = MAX (content_min + games_titlebar_box_adjust_for_overlay (self, titlebar_min), titlebar_min);
	_vala_nat = MAX (content_nat + games_titlebar_box_adjust_for_overlay (self, titlebar_nat), titlebar_nat);
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}

static void
games_titlebar_box_real_size_allocate (GtkWidget* base,
                                       GtkAllocation* alloc)
{
	GamesTitlebarBox * self;
	gint titlebar_height = 0;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp12_;
	GtkWidget* _tmp13_;
	GtkAllocation _tmp21_;
	self = (GamesTitlebarBox*) base;
	g_return_if_fail (alloc != NULL);
	titlebar_height = 0;
	_tmp0_ = games_titlebar_box_get_titlebar (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		gint min = 0;
		gint nat = 0;
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		GtkAllocation _tmp8_;
		GtkAllocation _tmp9_;
		GtkAllocation _tmp10_;
		GtkAllocation _tmp11_ = {0};
		_tmp2_ = games_titlebar_box_get_titlebar (self);
		_tmp3_ = _tmp2_;
		gtk_widget_get_preferred_height (_tmp3_, &_tmp4_, &_tmp5_);
		min = _tmp4_;
		nat = _tmp5_;
		titlebar_height = MAX (min, nat);
		_tmp6_ = games_titlebar_box_get_titlebar (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = *alloc;
		_tmp9_ = *alloc;
		_tmp10_ = *alloc;
		_tmp11_.x = _tmp8_.x;
		_tmp11_.y = _tmp9_.y - ((gint) round (titlebar_height * (1 - self->priv->reveal_progress)));
		_tmp11_.width = _tmp10_.width;
		_tmp11_.height = titlebar_height;
		gtk_widget_size_allocate (_tmp7_, &_tmp11_);
	}
	titlebar_height = games_titlebar_box_adjust_for_overlay (self, titlebar_height);
	_tmp12_ = games_titlebar_box_get_content (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		GtkWidget* _tmp14_;
		GtkWidget* _tmp15_;
		GtkAllocation _tmp16_;
		GtkAllocation _tmp17_;
		GtkAllocation _tmp18_;
		GtkAllocation _tmp19_;
		GtkAllocation _tmp20_ = {0};
		_tmp14_ = games_titlebar_box_get_content (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = *alloc;
		_tmp17_ = *alloc;
		_tmp18_ = *alloc;
		_tmp19_ = *alloc;
		_tmp20_.x = _tmp16_.x;
		_tmp20_.y = _tmp17_.y + titlebar_height;
		_tmp20_.width = _tmp18_.width;
		_tmp20_.height = _tmp19_.height - titlebar_height;
		gtk_widget_size_allocate (_tmp15_, &_tmp20_);
	}
	_tmp21_ = *alloc;
	GTK_WIDGET_CLASS (games_titlebar_box_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_container_get_type (), GtkContainer), &_tmp21_);
}

static void
games_titlebar_box_real_add (GtkContainer* base,
                             GtkWidget* widget)
{
	GamesTitlebarBox * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	self = (GamesTitlebarBox*) base;
	g_return_if_fail (widget != NULL);
	_tmp0_ = games_titlebar_box_get_content (self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ == NULL);
	_tmp2_ = games_titlebar_box_get_content (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		games_titlebar_box_set_content (self, widget);
	}
}

static void
games_titlebar_box_real_remove (GtkContainer* base,
                                GtkWidget* widget)
{
	GamesTitlebarBox * self;
	gboolean _tmp0_ = FALSE;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	self = (GamesTitlebarBox*) base;
	g_return_if_fail (widget != NULL);
	_tmp1_ = games_titlebar_box_get_titlebar (self);
	_tmp2_ = _tmp1_;
	if (widget == _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		_tmp3_ = games_titlebar_box_get_content (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = widget == _tmp4_;
	}
	g_return_if_fail (_tmp0_);
	_tmp5_ = games_titlebar_box_get_titlebar (self);
	_tmp6_ = _tmp5_;
	if (widget == _tmp6_) {
		games_titlebar_box_set_titlebar (self, NULL);
	} else {
		games_titlebar_box_set_content (self, NULL);
	}
}

static void
games_titlebar_box_real_forall_internal (GtkContainer* base,
                                         gboolean include_internals,
                                         GtkCallback callback,
                                         gpointer callback_target)
{
	GamesTitlebarBox * self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	self = (GamesTitlebarBox*) base;
	_tmp0_ = games_titlebar_box_get_content (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		_tmp2_ = games_titlebar_box_get_content (self);
		_tmp3_ = _tmp2_;
		callback (_tmp3_, callback_target);
	}
	_tmp4_ = games_titlebar_box_get_titlebar (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		GtkWidget* _tmp6_;
		GtkWidget* _tmp7_;
		_tmp6_ = games_titlebar_box_get_titlebar (self);
		_tmp7_ = _tmp6_;
		callback (_tmp7_, callback_target);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_titlebar_box_real_add_child (GtkBuildable* base,
                                   GtkBuilder* builder,
                                   GObject* child,
                                   const gchar* type)
{
	GamesTitlebarBox * self;
	GtkWidget* widget = NULL;
	GtkWidget* _tmp0_;
	self = (GamesTitlebarBox*) base;
	g_return_if_fail (builder != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (child, gtk_widget_get_type ()) ? ((GtkWidget*) child) : NULL);
	widget = _tmp0_;
	if (g_strcmp0 (type, "titlebar") == 0) {
		GtkWidget* _tmp1_;
		_tmp1_ = widget;
		games_titlebar_box_set_titlebar (self, _tmp1_);
	} else {
		GtkWidget* _tmp2_;
		_tmp2_ = widget;
		games_titlebar_box_set_content (self, _tmp2_);
	}
	_g_object_unref0 (widget);
}

GamesTitlebarBox*
games_titlebar_box_construct (GType object_type)
{
	GamesTitlebarBox * self = NULL;
	self = (GamesTitlebarBox*) g_object_new (object_type, NULL);
	return self;
}

GamesTitlebarBox*
games_titlebar_box_new (void)
{
	return games_titlebar_box_construct (GAMES_TYPE_TITLEBAR_BOX);
}

GtkWidget*
games_titlebar_box_get_titlebar (GamesTitlebarBox* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_titlebar;
	result = _tmp0_;
	return result;
}

void
games_titlebar_box_set_titlebar (GamesTitlebarBox* self,
                                 GtkWidget* value)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_titlebar_box_get_titlebar (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	_tmp2_ = games_titlebar_box_get_titlebar (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		_tmp4_ = games_titlebar_box_get_titlebar (self);
		_tmp5_ = _tmp4_;
		gtk_widget_unparent (_tmp5_);
	}
	_tmp6_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_titlebar);
	self->priv->_titlebar = _tmp6_;
	_tmp7_ = games_titlebar_box_get_titlebar (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		_tmp9_ = games_titlebar_box_get_titlebar (self);
		_tmp10_ = _tmp9_;
		gtk_widget_set_parent (_tmp10_, (GtkWidget*) ((GtkContainer*) self));
	}
	g_object_notify_by_pspec ((GObject *) self, games_titlebar_box_properties[GAMES_TITLEBAR_BOX_TITLEBAR_PROPERTY]);
}

GtkWidget*
games_titlebar_box_get_content (GamesTitlebarBox* self)
{
	GtkWidget* result;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content;
	result = _tmp0_;
	return result;
}

void
games_titlebar_box_set_content (GamesTitlebarBox* self,
                                GtkWidget* value)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp6_;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_titlebar_box_get_content (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	_tmp2_ = games_titlebar_box_get_content (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GtkWidget* _tmp4_;
		GtkWidget* _tmp5_;
		_tmp4_ = games_titlebar_box_get_content (self);
		_tmp5_ = _tmp4_;
		gtk_widget_unparent (_tmp5_);
	}
	_tmp6_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_content);
	self->priv->_content = _tmp6_;
	_tmp7_ = games_titlebar_box_get_content (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		GtkWidget* _tmp9_;
		GtkWidget* _tmp10_;
		_tmp9_ = games_titlebar_box_get_content (self);
		_tmp10_ = _tmp9_;
		gtk_widget_set_parent (_tmp10_, (GtkWidget*) ((GtkContainer*) self));
	}
	g_object_notify_by_pspec ((GObject *) self, games_titlebar_box_properties[GAMES_TITLEBAR_BOX_CONTENT_PROPERTY]);
}

gboolean
games_titlebar_box_get_overlay (GamesTitlebarBox* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overlay;
	return result;
}

void
games_titlebar_box_set_overlay (GamesTitlebarBox* self,
                                gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_titlebar_box_get_overlay (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	self->priv->_overlay = value;
	games_titlebar_box_animate_overlay (self);
	g_object_notify_by_pspec ((GObject *) self, games_titlebar_box_properties[GAMES_TITLEBAR_BOX_OVERLAY_PROPERTY]);
}

gboolean
games_titlebar_box_get_reveal_titlebar (GamesTitlebarBox* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_reveal_titlebar;
	return result;
}

void
games_titlebar_box_set_reveal_titlebar (GamesTitlebarBox* self,
                                        gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_titlebar_box_get_reveal_titlebar (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	self->priv->_reveal_titlebar = value;
	games_titlebar_box_animate_reveal (self);
	g_object_notify_by_pspec ((GObject *) self, games_titlebar_box_properties[GAMES_TITLEBAR_BOX_REVEAL_TITLEBAR_PROPERTY]);
}

gint
games_titlebar_box_get_overlay_duration (GamesTitlebarBox* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_overlay_duration;
	return result;
}

void
games_titlebar_box_set_overlay_duration (GamesTitlebarBox* self,
                                         gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = games_titlebar_box_get_overlay_duration (self);
	if (old_value != value) {
		self->priv->_overlay_duration = value;
		g_object_notify_by_pspec ((GObject *) self, games_titlebar_box_properties[GAMES_TITLEBAR_BOX_OVERLAY_DURATION_PROPERTY]);
	}
}

gint
games_titlebar_box_get_reveal_duration (GamesTitlebarBox* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_reveal_duration;
	return result;
}

void
games_titlebar_box_set_reveal_duration (GamesTitlebarBox* self,
                                        gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = games_titlebar_box_get_reveal_duration (self);
	if (old_value != value) {
		self->priv->_reveal_duration = value;
		g_object_notify_by_pspec ((GObject *) self, games_titlebar_box_properties[GAMES_TITLEBAR_BOX_REVEAL_DURATION_PROPERTY]);
	}
}

static GObject *
games_titlebar_box_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GamesTitlebarBox * self;
	parent_class = G_OBJECT_CLASS (games_titlebar_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_TITLEBAR_BOX, GamesTitlebarBox);
	gtk_widget_set_has_window ((GtkWidget*) self, FALSE);
	games_titlebar_box_set_reveal_titlebar (self, TRUE);
	self->priv->reveal_progress = (gdouble) 1;
	return obj;
}

static void
games_titlebar_box_class_init (GamesTitlebarBoxClass * klass,
                               gpointer klass_data)
{
	games_titlebar_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesTitlebarBox_private_offset);
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*) (GtkWidget*, gint*, gint*)) games_titlebar_box_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*) (GtkWidget*, gint*, gint*)) games_titlebar_box_real_get_preferred_height;
	((GtkWidgetClass *) klass)->size_allocate = (void (*) (GtkWidget*, GtkAllocation*)) games_titlebar_box_real_size_allocate;
	((GtkContainerClass *) klass)->add = (void (*) (GtkContainer*, GtkWidget*)) games_titlebar_box_real_add;
	((GtkContainerClass *) klass)->remove = (void (*) (GtkContainer*, GtkWidget*)) games_titlebar_box_real_remove;
	((GtkContainerClass *) klass)->forall = (void (*) (GtkContainer*, gboolean, GtkCallback, gpointer)) games_titlebar_box_real_forall_internal;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_titlebar_box_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_titlebar_box_set_property;
	G_OBJECT_CLASS (klass)->constructor = games_titlebar_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_titlebar_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_TITLEBAR_BOX_TITLEBAR_PROPERTY, games_titlebar_box_properties[GAMES_TITLEBAR_BOX_TITLEBAR_PROPERTY] = g_param_spec_object ("titlebar", "titlebar", "titlebar", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_TITLEBAR_BOX_CONTENT_PROPERTY, games_titlebar_box_properties[GAMES_TITLEBAR_BOX_CONTENT_PROPERTY] = g_param_spec_object ("content", "content", "content", gtk_widget_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_TITLEBAR_BOX_OVERLAY_PROPERTY, games_titlebar_box_properties[GAMES_TITLEBAR_BOX_OVERLAY_PROPERTY] = g_param_spec_boolean ("overlay", "overlay", "overlay", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_TITLEBAR_BOX_REVEAL_TITLEBAR_PROPERTY, games_titlebar_box_properties[GAMES_TITLEBAR_BOX_REVEAL_TITLEBAR_PROPERTY] = g_param_spec_boolean ("reveal-titlebar", "reveal-titlebar", "reveal-titlebar", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_TITLEBAR_BOX_OVERLAY_DURATION_PROPERTY, games_titlebar_box_properties[GAMES_TITLEBAR_BOX_OVERLAY_DURATION_PROPERTY] = g_param_spec_int ("overlay-duration", "overlay-duration", "overlay-duration", G_MININT, G_MAXINT, 250, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_TITLEBAR_BOX_REVEAL_DURATION_PROPERTY, games_titlebar_box_properties[GAMES_TITLEBAR_BOX_REVEAL_DURATION_PROPERTY] = g_param_spec_int ("reveal-duration", "reveal-duration", "reveal-duration", G_MININT, G_MAXINT, 250, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
games_titlebar_box_gtk_buildable_interface_init (GtkBuildableIface * iface,
                                                 gpointer iface_data)
{
	games_titlebar_box_gtk_buildable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_child = (void (*) (GtkBuildable*, GtkBuilder*, GObject*, const gchar*)) games_titlebar_box_real_add_child;
}

static void
games_titlebar_box_instance_init (GamesTitlebarBox * self,
                                  gpointer klass)
{
	self->priv = games_titlebar_box_get_instance_private (self);
	self->priv->_overlay_duration = 250;
	self->priv->_reveal_duration = 250;
}

static void
games_titlebar_box_finalize (GObject * obj)
{
	GamesTitlebarBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_TITLEBAR_BOX, GamesTitlebarBox);
	_g_object_unref0 (self->priv->_titlebar);
	_g_object_unref0 (self->priv->_content);
	G_OBJECT_CLASS (games_titlebar_box_parent_class)->finalize (obj);
}

static GType
games_titlebar_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesTitlebarBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_titlebar_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesTitlebarBox), 0, (GInstanceInitFunc) games_titlebar_box_instance_init, NULL };
	static const GInterfaceInfo gtk_buildable_info = { (GInterfaceInitFunc) games_titlebar_box_gtk_buildable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType games_titlebar_box_type_id;
	games_titlebar_box_type_id = g_type_register_static (gtk_container_get_type (), "GamesTitlebarBox", &g_define_type_info, 0);
	g_type_add_interface_static (games_titlebar_box_type_id, gtk_buildable_get_type (), &gtk_buildable_info);
	GamesTitlebarBox_private_offset = g_type_add_instance_private (games_titlebar_box_type_id, sizeof (GamesTitlebarBoxPrivate));
	return games_titlebar_box_type_id;
}

GType
games_titlebar_box_get_type (void)
{
	static volatile gsize games_titlebar_box_type_id__once = 0;
	if (g_once_init_enter (&games_titlebar_box_type_id__once)) {
		GType games_titlebar_box_type_id;
		games_titlebar_box_type_id = games_titlebar_box_get_type_once ();
		g_once_init_leave (&games_titlebar_box_type_id__once, games_titlebar_box_type_id);
	}
	return games_titlebar_box_type_id__once;
}

static void
_vala_games_titlebar_box_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GamesTitlebarBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_TITLEBAR_BOX, GamesTitlebarBox);
	switch (property_id) {
		case GAMES_TITLEBAR_BOX_TITLEBAR_PROPERTY:
		g_value_set_object (value, games_titlebar_box_get_titlebar (self));
		break;
		case GAMES_TITLEBAR_BOX_CONTENT_PROPERTY:
		g_value_set_object (value, games_titlebar_box_get_content (self));
		break;
		case GAMES_TITLEBAR_BOX_OVERLAY_PROPERTY:
		g_value_set_boolean (value, games_titlebar_box_get_overlay (self));
		break;
		case GAMES_TITLEBAR_BOX_REVEAL_TITLEBAR_PROPERTY:
		g_value_set_boolean (value, games_titlebar_box_get_reveal_titlebar (self));
		break;
		case GAMES_TITLEBAR_BOX_OVERLAY_DURATION_PROPERTY:
		g_value_set_int (value, games_titlebar_box_get_overlay_duration (self));
		break;
		case GAMES_TITLEBAR_BOX_REVEAL_DURATION_PROPERTY:
		g_value_set_int (value, games_titlebar_box_get_reveal_duration (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_titlebar_box_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GamesTitlebarBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_TITLEBAR_BOX, GamesTitlebarBox);
	switch (property_id) {
		case GAMES_TITLEBAR_BOX_TITLEBAR_PROPERTY:
		games_titlebar_box_set_titlebar (self, g_value_get_object (value));
		break;
		case GAMES_TITLEBAR_BOX_CONTENT_PROPERTY:
		games_titlebar_box_set_content (self, g_value_get_object (value));
		break;
		case GAMES_TITLEBAR_BOX_OVERLAY_PROPERTY:
		games_titlebar_box_set_overlay (self, g_value_get_boolean (value));
		break;
		case GAMES_TITLEBAR_BOX_REVEAL_TITLEBAR_PROPERTY:
		games_titlebar_box_set_reveal_titlebar (self, g_value_get_boolean (value));
		break;
		case GAMES_TITLEBAR_BOX_OVERLAY_DURATION_PROPERTY:
		games_titlebar_box_set_overlay_duration (self, g_value_get_int (value));
		break;
		case GAMES_TITLEBAR_BOX_REVEAL_DURATION_PROPERTY:
		games_titlebar_box_set_reveal_duration (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

