/* games-page.c generated by valac 0.56.8, the Vala compiler
 * generated from games-page.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "gnome-games.h"
#include <libmanette.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <cairo-gobject.h>

#define GAMES_TYPE_GAMES_PAGE (games_games_page_get_type ())
#define GAMES_GAMES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMES_PAGE, GamesGamesPage))
#define GAMES_GAMES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMES_PAGE, GamesGamesPageClass))
#define GAMES_IS_GAMES_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMES_PAGE))
#define GAMES_IS_GAMES_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMES_PAGE))
#define GAMES_GAMES_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMES_PAGE, GamesGamesPageClass))

typedef struct _GamesGamesPage GamesGamesPage;
typedef struct _GamesGamesPageClass GamesGamesPageClass;
typedef struct _GamesGamesPagePrivate GamesGamesPagePrivate;
typedef gboolean (*GamesGamesPageGameFilter) (GamesGame* game, gpointer user_data);

#define GAMES_TYPE_GAME_MODEL (games_game_model_get_type ())
#define GAMES_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModel))
#define GAMES_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))
#define GAMES_IS_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_MODEL))
#define GAMES_IS_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_MODEL))
#define GAMES_GAME_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))

typedef struct _GamesGameModel GamesGameModel;
typedef struct _GamesGameModelClass GamesGameModelClass;

#define GAMES_TYPE_GAME_ICON_VIEW (games_game_icon_view_get_type ())
#define GAMES_GAME_ICON_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_ICON_VIEW, GamesGameIconView))
#define GAMES_GAME_ICON_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_ICON_VIEW, GamesGameIconViewClass))
#define GAMES_IS_GAME_ICON_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_ICON_VIEW))
#define GAMES_IS_GAME_ICON_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_ICON_VIEW))
#define GAMES_GAME_ICON_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_ICON_VIEW, GamesGameIconViewClass))

typedef struct _GamesGameIconView GamesGameIconView;
typedef struct _GamesGameIconViewClass GamesGameIconViewClass;

#define GAMES_TYPE_GAMEPAD_BROWSE (games_gamepad_browse_get_type ())
#define GAMES_GAMEPAD_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD_BROWSE, GamesGamepadBrowse))
#define GAMES_GAMEPAD_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD_BROWSE, GamesGamepadBrowseClass))
#define GAMES_IS_GAMEPAD_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD_BROWSE))
#define GAMES_IS_GAMEPAD_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD_BROWSE))
#define GAMES_GAMEPAD_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD_BROWSE, GamesGamepadBrowseClass))

typedef struct _GamesGamepadBrowse GamesGamepadBrowse;
typedef struct _GamesGamepadBrowseClass GamesGamepadBrowseClass;
enum  {
	GAMES_GAMES_PAGE_0_PROPERTY,
	GAMES_GAMES_PAGE_IS_SELECTION_MODE_PROPERTY,
	GAMES_GAMES_PAGE_GAME_MODEL_PROPERTY,
	GAMES_GAMES_PAGE_HIDE_STARS_PROPERTY,
	GAMES_GAMES_PAGE_IS_ACTIVE_PROPERTY,
	GAMES_GAMES_PAGE_IS_SEARCH_EMPTY_PROPERTY,
	GAMES_GAMES_PAGE_NUM_PROPERTIES
};
static GParamSpec* games_games_page_properties[GAMES_GAMES_PAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block29Data Block29Data;
enum  {
	GAMES_GAMES_PAGE_GAME_ACTIVATED_SIGNAL,
	GAMES_GAMES_PAGE_SELECTED_ITEMS_CHANGED_SIGNAL,
	GAMES_GAMES_PAGE_GAMEPAD_CANCEL_CLICKED_SIGNAL,
	GAMES_GAMES_PAGE_NUM_SIGNALS
};
static guint games_games_page_signals[GAMES_GAMES_PAGE_NUM_SIGNALS] = {0};

struct _GamesGamesPage {
	GtkBin parent_instance;
	GamesGamesPagePrivate * priv;
};

struct _GamesGamesPageClass {
	GtkBinClass parent_class;
};

struct _GamesGamesPagePrivate {
	gchar** filtering_terms;
	gint filtering_terms_length1;
	gint _filtering_terms_size_;
	gboolean _is_selection_mode;
	GamesGamesPageGameFilter game_filter;
	gpointer game_filter_target;
	GamesGameModel* _game_model;
	gboolean _hide_stars;
	GHashTable* selected_games;
	GBinding* window_active_binding;
	gboolean _is_active;
	GtkScrolledWindow* scrolled_window;
	GtkFlowBox* flow_box;
	GamesGamepadBrowse* gamepad_browse;
	gboolean _is_search_empty;
};

struct _Block29Data {
	int _ref_count_;
	GamesGamesPage* self;
	GamesGameIconView* game_icon;
};

static gint GamesGamesPage_private_offset;
static gpointer games_games_page_parent_class = NULL;

VALA_EXTERN GType games_games_page_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_game_model_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_game_icon_view_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_browse_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void games_games_page_set_game_filter (GamesGamesPage* self,
                                       GamesGamesPageGameFilter game_filter,
                                       gpointer game_filter_target);
VALA_EXTERN void games_games_page_on_map (GamesGamesPage* self);
VALA_EXTERN void games_games_page_set_is_active (GamesGamesPage* self,
                                     gboolean value);
static void _games_games_page_on_map_gtk_widget_map (GtkWidget* _sender,
                                              gpointer self);
VALA_EXTERN void games_games_page_on_unmap (GamesGamesPage* self);
static void _games_games_page_on_unmap_gtk_widget_unmap (GtkWidget* _sender,
                                                  gpointer self);
VALA_EXTERN gboolean games_games_page_gamepad_button_press_event (GamesGamesPage* self,
                                                      ManetteEvent* event);
VALA_EXTERN gboolean games_gamepad_browse_gamepad_button_press_event (GamesGamepadBrowse* self,
                                                          ManetteEvent* event);
VALA_EXTERN gboolean games_games_page_gamepad_button_release_event (GamesGamesPage* self,
                                                        ManetteEvent* event);
VALA_EXTERN gboolean games_gamepad_browse_gamepad_button_release_event (GamesGamepadBrowse* self,
                                                            ManetteEvent* event);
VALA_EXTERN gboolean games_games_page_gamepad_absolute_axis_event (GamesGamesPage* self,
                                                       ManetteEvent* event);
VALA_EXTERN gboolean games_gamepad_browse_gamepad_absolute_axis_event (GamesGamepadBrowse* self,
                                                           ManetteEvent* event);
VALA_EXTERN void games_games_page_set_filter (GamesGamesPage* self,
                                  gchar** filtering_terms,
                                  gint filtering_terms_length1);
static gchar** _vala_array_dup22 (gchar** self,
                           gssize length);
static void games_games_page_update_is_search_empty (GamesGamesPage* self);
VALA_EXTERN void games_games_page_reset_scroll_position (GamesGamesPage* self);
VALA_EXTERN gboolean games_games_page_has_game_selected (GamesGamesPage* self);
VALA_EXTERN gboolean games_games_page_select_default_game (GamesGamesPage* self,
                                               GtkDirectionType direction);
VALA_EXTERN void games_games_page_unselect_game (GamesGamesPage* self);
VALA_EXTERN void games_games_page_select_none (GamesGamesPage* self);
VALA_EXTERN void games_game_icon_view_set_checked (GamesGameIconView* self,
                                       gboolean value);
VALA_EXTERN void games_games_page_select_all (GamesGamesPage* self);
static gboolean games_games_page_filter_game (GamesGamesPage* self,
                                       GamesGame* game);
VALA_EXTERN GamesGame* games_game_icon_view_get_game (GamesGameIconView* self);
VALA_EXTERN GamesGame** games_games_page_get_selected_games (GamesGamesPage* self,
                                                 gint* result_length1);
static void _vala_array_add40 (GamesGame** * array,
                        gint* length,
                        gint* size,
                        GamesGame* value);
static gboolean games_games_page_on_gamepad_browse (GamesGamesPage* self,
                                             GtkDirectionType direction);
static gboolean _games_games_page_on_gamepad_browse_games_gamepad_browse_browse (GamesGamepadBrowse* _sender,
                                                                          GtkDirectionType direction,
                                                                          gpointer self);
static gboolean games_games_page_on_gamepad_accept (GamesGamesPage* self);
static gboolean _games_games_page_on_gamepad_accept_games_gamepad_browse_accept (GamesGamepadBrowse* _sender,
                                                                          gpointer self);
static gboolean games_games_page_on_gamepad_cancel (GamesGamesPage* self);
static gboolean _games_games_page_on_gamepad_cancel_games_gamepad_browse_cancel (GamesGamepadBrowse* _sender,
                                                                          gpointer self);
static void games_games_page_on_child_activated (GamesGamesPage* self,
                                          GtkFlowBoxChild* child);
VALA_EXTERN gboolean games_games_page_get_is_selection_mode (GamesGamesPage* self);
VALA_EXTERN gboolean games_game_icon_view_get_checked (GamesGameIconView* self);
static void _games_games_page_on_child_activated_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                        GtkFlowBoxChild* child,
                                                                        gpointer self);
static GtkWidget* games_games_page_add_game (GamesGamesPage* self,
                                      GObject* item);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
VALA_EXTERN GamesGameIconView* games_game_icon_view_new (GamesGame* game);
VALA_EXTERN GamesGameIconView* games_game_icon_view_construct (GType object_type,
                                                   GamesGame* game);
static void __lambda21_ (Block29Data* _data29_);
static void ___lambda21__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN void games_games_page_invalidate_filter (GamesGamesPage* self);
static gboolean games_games_page_filter_box (GamesGamesPage* self,
                                      GtkFlowBoxChild* child);
static gboolean games_games_page_found_games (GamesGamesPage* self);
VALA_EXTERN GamesGameModel* games_games_page_get_game_model (GamesGamesPage* self);
VALA_EXTERN void games_games_page_set_is_search_empty (GamesGamesPage* self,
                                           gboolean value);
static void games_games_page_on_size_allocate (GamesGamesPage* self,
                                        GtkAllocation* allocation);
static void _games_games_page_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                  GtkAllocation* allocation,
                                                                  gpointer self);
VALA_EXTERN GamesGamesPage* games_games_page_new (void);
VALA_EXTERN GamesGamesPage* games_games_page_construct (GType object_type);
VALA_EXTERN void games_games_page_set_is_selection_mode (GamesGamesPage* self,
                                             gboolean value);
VALA_EXTERN void games_games_page_set_game_model (GamesGamesPage* self,
                                      GamesGameModel* value);
static GtkWidget* _games_games_page_add_game_gtk_flow_box_create_widget_func (gpointer item,
                                                                       gpointer self);
VALA_EXTERN gboolean games_games_page_get_hide_stars (GamesGamesPage* self);
VALA_EXTERN void games_games_page_set_hide_stars (GamesGamesPage* self,
                                      gboolean value);
VALA_EXTERN gboolean games_games_page_get_is_active (GamesGamesPage* self);
VALA_EXTERN void games_gamepad_browse_cancel_cursor_movement (GamesGamepadBrowse* self);
VALA_EXTERN gboolean games_games_page_get_is_search_empty (GamesGamesPage* self);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static GObject * games_games_page_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties);
static gboolean _games_games_page_filter_box_gtk_flow_box_filter_func (GtkFlowBoxChild* child,
                                                                gpointer self);
VALA_EXTERN guint games_game_icon_view_hash (GamesGameIconView* key);
static guint _games_game_icon_view_hash_ghash_func (gconstpointer key);
VALA_EXTERN gboolean games_game_icon_view_equal (GamesGameIconView* a,
                                     GamesGameIconView* b);
static gboolean _games_game_icon_view_equal_gequal_func (gconstpointer a,
                                                  gconstpointer b);
static void _g_object_unref0_ (gpointer var);
static void games_games_page_finalize (GObject * obj);
static GType games_games_page_get_type_once (void);
static void _vala_games_games_page_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_games_games_page_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_games_page_get_instance_private (GamesGamesPage* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGamesPage_private_offset);
}

void
games_games_page_set_game_filter (GamesGamesPage* self,
                                  GamesGamesPageGameFilter game_filter,
                                  gpointer game_filter_target)
{
	g_return_if_fail (self != NULL);
	self->priv->game_filter = game_filter;
	self->priv->game_filter_target = game_filter_target;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
games_games_page_on_map (GamesGamesPage* self)
{
	GtkWidget* window = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GBinding* _tmp4_;
	GBinding* _tmp5_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->window_active_binding);
	self->priv->window_active_binding = NULL;
	games_games_page_set_is_active (self, FALSE);
	_tmp0_ = gtk_widget_get_ancestor ((GtkWidget*) self, gtk_window_get_type ());
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	_tmp2_ = window;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (window);
		return;
	}
	_tmp3_ = window;
	_tmp4_ = g_object_bind_property_with_closures ((GObject*) _tmp3_, "is-active", (GObject*) self, "is-active", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->window_active_binding);
	self->priv->window_active_binding = _tmp5_;
	_g_object_unref0 (window);
}

static void
_games_games_page_on_map_gtk_widget_map (GtkWidget* _sender,
                                         gpointer self)
{
	games_games_page_on_map ((GamesGamesPage*) self);
}

void
games_games_page_on_unmap (GamesGamesPage* self)
{
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->window_active_binding);
	self->priv->window_active_binding = NULL;
	games_games_page_set_is_active (self, FALSE);
}

static void
_games_games_page_on_unmap_gtk_widget_unmap (GtkWidget* _sender,
                                             gpointer self)
{
	games_games_page_on_unmap ((GamesGamesPage*) self);
}

gboolean
games_games_page_gamepad_button_press_event (GamesGamesPage* self,
                                             ManetteEvent* event)
{
	GamesGamepadBrowse* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (!gtk_widget_get_mapped ((GtkWidget*) self)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->gamepad_browse;
	result = games_gamepad_browse_gamepad_button_press_event (_tmp0_, event);
	return result;
}

gboolean
games_games_page_gamepad_button_release_event (GamesGamesPage* self,
                                               ManetteEvent* event)
{
	GamesGamepadBrowse* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (!gtk_widget_get_mapped ((GtkWidget*) self)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->gamepad_browse;
	result = games_gamepad_browse_gamepad_button_release_event (_tmp0_, event);
	return result;
}

gboolean
games_games_page_gamepad_absolute_axis_event (GamesGamesPage* self,
                                              ManetteEvent* event)
{
	GamesGamepadBrowse* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (!gtk_widget_get_mapped ((GtkWidget*) self)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->gamepad_browse;
	result = games_gamepad_browse_gamepad_absolute_axis_event (_tmp0_, event);
	return result;
}

static gchar**
_vala_array_dup22 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

void
games_games_page_set_filter (GamesGamesPage* self,
                             gchar** filtering_terms,
                             gint filtering_terms_length1)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	GtkFlowBox* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (filtering_terms != NULL) ? _vala_array_dup22 (filtering_terms, filtering_terms_length1) : filtering_terms;
	_tmp0__length1 = filtering_terms_length1;
	self->priv->filtering_terms = (_vala_array_free (self->priv->filtering_terms, self->priv->filtering_terms_length1, (GDestroyNotify) g_free), NULL);
	self->priv->filtering_terms = _tmp0_;
	self->priv->filtering_terms_length1 = _tmp0__length1;
	self->priv->_filtering_terms_size_ = self->priv->filtering_terms_length1;
	_tmp1_ = self->priv->flow_box;
	gtk_flow_box_invalidate_filter (_tmp1_);
	games_games_page_update_is_search_empty (self);
}

void
games_games_page_reset_scroll_position (GamesGamesPage* self)
{
	GtkAdjustment* adjustment = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scrolled_window;
	_tmp1_ = gtk_scrolled_window_get_vadjustment (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	adjustment = _tmp2_;
	gtk_adjustment_set_value (adjustment, (gdouble) 0);
	_g_object_unref0 (adjustment);
}

gboolean
games_games_page_has_game_selected (GamesGamesPage* self)
{
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->flow_box;
	_tmp1_ = gtk_flow_box_get_selected_children (_tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkFlowBoxChild* child = NULL;
			child = (GtkFlowBoxChild*) child_it->data;
			{
				GtkFlowBoxChild* _tmp2_;
				_tmp2_ = child;
				if (gtk_widget_get_mapped ((GtkWidget*) _tmp2_)) {
					result = TRUE;
					(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
					return result;
				}
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
	result = FALSE;
	return result;
}

gboolean
games_games_page_select_default_game (GamesGamesPage* self,
                                      GtkDirectionType direction)
{
	GtkFlowBoxChild* child = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GtkFlowBox* _tmp2_;
				GtkFlowBoxChild* _tmp3_;
				GtkFlowBoxChild* _tmp4_;
				GtkFlowBoxChild* _tmp5_;
				GtkFlowBoxChild* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->flow_box;
				_tmp3_ = gtk_flow_box_get_child_at_index (_tmp2_, i);
				_tmp4_ = _g_object_ref0 (_tmp3_);
				_g_object_unref0 (child);
				child = _tmp4_;
				_tmp5_ = child;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = child;
				if (gtk_widget_get_mapped ((GtkWidget*) _tmp6_)) {
					GtkFlowBox* _tmp7_;
					GtkFlowBoxChild* _tmp8_;
					GtkFlowBoxChild* _tmp9_;
					gboolean _tmp10_ = FALSE;
					_tmp7_ = self->priv->flow_box;
					_tmp8_ = child;
					gtk_flow_box_select_child (_tmp7_, _tmp8_);
					_tmp9_ = child;
					g_signal_emit_by_name ((GtkWidget*) _tmp9_, "focus", direction, &_tmp10_);
					result = TRUE;
					_g_object_unref0 (child);
					return result;
				}
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (child);
	return result;
}

void
games_games_page_unselect_game (GamesGamesPage* self)
{
	GtkFlowBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->flow_box;
	gtk_flow_box_unselect_all (_tmp0_);
}

void
games_games_page_select_none (GamesGamesPage* self)
{
	GHashTable* _tmp0_;
	GList* _tmp1_;
	GHashTable* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->selected_games;
	_tmp1_ = g_hash_table_get_values (_tmp0_);
	{
		GList* game_icon_view_collection = NULL;
		GList* game_icon_view_it = NULL;
		game_icon_view_collection = _tmp1_;
		for (game_icon_view_it = game_icon_view_collection; game_icon_view_it != NULL; game_icon_view_it = game_icon_view_it->next) {
			GamesGameIconView* game_icon_view = NULL;
			game_icon_view = (GamesGameIconView*) game_icon_view_it->data;
			{
				GamesGameIconView* _tmp2_;
				_tmp2_ = game_icon_view;
				games_game_icon_view_set_checked (_tmp2_, FALSE);
			}
		}
		(game_icon_view_collection == NULL) ? NULL : (game_icon_view_collection = (g_list_free (game_icon_view_collection), NULL));
	}
	_tmp3_ = self->priv->selected_games;
	g_hash_table_remove_all (_tmp3_);
}

void
games_games_page_select_all (GamesGamesPage* self)
{
	GtkFlowBox* _tmp0_;
	GList* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->flow_box;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	{
		GList* child_collection = NULL;
		GList* child_it = NULL;
		child_collection = _tmp1_;
		for (child_it = child_collection; child_it != NULL; child_it = child_it->next) {
			GtkWidget* child = NULL;
			child = (GtkWidget*) child_it->data;
			{
				GamesGameIconView* game_icon_view = NULL;
				GtkWidget* _tmp2_;
				GamesGameIconView* _tmp3_;
				GamesGamesPageGameFilter _tmp4_;
				gpointer _tmp4__target;
				_tmp2_ = child;
				_tmp3_ = _g_object_ref0 (GAMES_IS_GAME_ICON_VIEW (_tmp2_) ? ((GamesGameIconView*) _tmp2_) : NULL);
				game_icon_view = _tmp3_;
				_tmp4_ = self->priv->game_filter;
				_tmp4__target = self->priv->game_filter_target;
				if (_tmp4_ == NULL) {
					gboolean _tmp5_ = FALSE;
					gchar** _tmp6_;
					gint _tmp6__length1;
					GamesGameIconView* _tmp10_;
					_tmp6_ = self->priv->filtering_terms;
					_tmp6__length1 = self->priv->filtering_terms_length1;
					if (_tmp6_ == NULL) {
						_tmp5_ = TRUE;
					} else {
						GamesGameIconView* _tmp7_;
						GamesGame* _tmp8_;
						GamesGame* _tmp9_;
						_tmp7_ = game_icon_view;
						_tmp8_ = games_game_icon_view_get_game (_tmp7_);
						_tmp9_ = _tmp8_;
						_tmp5_ = games_games_page_filter_game (self, _tmp9_);
					}
					_tmp10_ = game_icon_view;
					games_game_icon_view_set_checked (_tmp10_, _tmp5_);
				} else {
					GamesGameIconView* _tmp11_;
					GamesGame* _tmp12_;
					GamesGame* _tmp13_;
					_tmp11_ = game_icon_view;
					_tmp12_ = games_game_icon_view_get_game (_tmp11_);
					_tmp13_ = _tmp12_;
					if (games_games_page_filter_game (self, _tmp13_)) {
						GamesGameIconView* _tmp14_;
						_tmp14_ = game_icon_view;
						games_game_icon_view_set_checked (_tmp14_, TRUE);
					}
				}
				_g_object_unref0 (game_icon_view);
			}
		}
		(child_collection == NULL) ? NULL : (child_collection = (g_list_free (child_collection), NULL));
	}
}

static void
_vala_array_add40 (GamesGame** * array,
                   gint* length,
                   gint* size,
                   GamesGame* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesGame*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GamesGame**
games_games_page_get_selected_games (GamesGamesPage* self,
                                     gint* result_length1)
{
	GamesGame** games = NULL;
	GamesGame** _tmp0_;
	gint games_length1;
	gint _games_size_;
	GHashTable* _tmp1_;
	GList* _tmp2_;
	GamesGame** _tmp7_;
	gint _tmp7__length1;
	GamesGame** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (GamesGame*, 0 + 1);
	games = _tmp0_;
	games_length1 = 0;
	_games_size_ = games_length1;
	_tmp1_ = self->priv->selected_games;
	_tmp2_ = g_hash_table_get_values (_tmp1_);
	{
		GList* game_icon_view_collection = NULL;
		GList* game_icon_view_it = NULL;
		game_icon_view_collection = _tmp2_;
		for (game_icon_view_it = game_icon_view_collection; game_icon_view_it != NULL; game_icon_view_it = game_icon_view_it->next) {
			GamesGameIconView* game_icon_view = NULL;
			game_icon_view = (GamesGameIconView*) game_icon_view_it->data;
			{
				GamesGameIconView* _tmp3_;
				GamesGame* _tmp4_;
				GamesGame* _tmp5_;
				GamesGame* _tmp6_;
				_tmp3_ = game_icon_view;
				_tmp4_ = games_game_icon_view_get_game (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = _g_object_ref0 (_tmp5_);
				_vala_array_add40 (&games, &games_length1, &_games_size_, _tmp6_);
			}
		}
		(game_icon_view_collection == NULL) ? NULL : (game_icon_view_collection = (g_list_free (game_icon_view_collection), NULL));
	}
	_tmp7_ = games;
	_tmp7__length1 = games_length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}

static gboolean
games_games_page_on_gamepad_browse (GamesGamesPage* self,
                                    GtkDirectionType direction)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!games_games_page_has_game_selected (self)) {
		result = games_games_page_select_default_game (self, direction);
		return result;
	}
	switch (direction) {
		case GTK_DIR_UP:
		{
			GtkFlowBox* _tmp0_;
			gboolean _tmp1_ = FALSE;
			_tmp0_ = self->priv->flow_box;
			g_signal_emit_by_name (_tmp0_, "move-cursor", GTK_MOVEMENT_DISPLAY_LINES, -1, &_tmp1_);
			result = _tmp1_;
			return result;
		}
		case GTK_DIR_DOWN:
		{
			GtkFlowBox* _tmp2_;
			gboolean _tmp3_ = FALSE;
			_tmp2_ = self->priv->flow_box;
			g_signal_emit_by_name (_tmp2_, "move-cursor", GTK_MOVEMENT_DISPLAY_LINES, 1, &_tmp3_);
			result = _tmp3_;
			return result;
		}
		case GTK_DIR_LEFT:
		{
			GtkFlowBox* _tmp4_;
			gboolean _tmp5_ = FALSE;
			_tmp4_ = self->priv->flow_box;
			g_signal_emit_by_name (_tmp4_, "move-cursor", GTK_MOVEMENT_VISUAL_POSITIONS, -1, &_tmp5_);
			result = _tmp5_;
			return result;
		}
		case GTK_DIR_RIGHT:
		{
			GtkFlowBox* _tmp6_;
			gboolean _tmp7_ = FALSE;
			_tmp6_ = self->priv->flow_box;
			g_signal_emit_by_name (_tmp6_, "move-cursor", GTK_MOVEMENT_VISUAL_POSITIONS, 1, &_tmp7_);
			result = _tmp7_;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gboolean
_games_games_page_on_gamepad_browse_games_gamepad_browse_browse (GamesGamepadBrowse* _sender,
                                                                 GtkDirectionType direction,
                                                                 gpointer self)
{
	gboolean result;
	result = games_games_page_on_gamepad_browse ((GamesGamesPage*) self, direction);
	return result;
}

static gboolean
games_games_page_on_gamepad_accept (GamesGamesPage* self)
{
	GtkFlowBox* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->flow_box;
	g_signal_emit_by_name (_tmp0_, "activate-cursor-child");
	result = TRUE;
	return result;
}

static gboolean
_games_games_page_on_gamepad_accept_games_gamepad_browse_accept (GamesGamepadBrowse* _sender,
                                                                 gpointer self)
{
	gboolean result;
	result = games_games_page_on_gamepad_accept ((GamesGamesPage*) self);
	return result;
}

static gboolean
games_games_page_on_gamepad_cancel (GamesGamesPage* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit (self, games_games_page_signals[GAMES_GAMES_PAGE_GAMEPAD_CANCEL_CLICKED_SIGNAL], 0, &_tmp0_);
	result = _tmp0_;
	return result;
}

static gboolean
_games_games_page_on_gamepad_cancel_games_gamepad_browse_cancel (GamesGamepadBrowse* _sender,
                                                                 gpointer self)
{
	gboolean result;
	result = games_games_page_on_gamepad_cancel ((GamesGamesPage*) self);
	return result;
}

static void
games_games_page_on_child_activated (GamesGamesPage* self,
                                     GtkFlowBoxChild* child)
{
	GamesGameIconView* game_view = NULL;
	GamesGameIconView* _tmp0_;
	gboolean _tmp1_;
	GamesGameIconView* _tmp6_;
	GamesGame* _tmp7_;
	GamesGame* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (child != NULL);
	_tmp0_ = _g_object_ref0 (GAMES_IS_GAME_ICON_VIEW (child) ? ((GamesGameIconView*) child) : NULL);
	game_view = _tmp0_;
	_tmp1_ = self->priv->_is_selection_mode;
	if (_tmp1_) {
		GamesGameIconView* _tmp2_;
		GamesGameIconView* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = game_view;
		_tmp3_ = game_view;
		_tmp4_ = games_game_icon_view_get_checked (_tmp3_);
		_tmp5_ = _tmp4_;
		games_game_icon_view_set_checked (_tmp2_, !_tmp5_);
		_g_object_unref0 (game_view);
		return;
	}
	_tmp6_ = game_view;
	_tmp7_ = games_game_icon_view_get_game (_tmp6_);
	_tmp8_ = _tmp7_;
	g_signal_emit (self, games_games_page_signals[GAMES_GAMES_PAGE_GAME_ACTIVATED_SIGNAL], 0, _tmp8_);
	_g_object_unref0 (game_view);
}

static void
_games_games_page_on_child_activated_gtk_flow_box_child_activated (GtkFlowBox* _sender,
                                                                   GtkFlowBoxChild* child,
                                                                   gpointer self)
{
	games_games_page_on_child_activated ((GamesGamesPage*) self, child);
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		GamesGamesPage* self;
		self = _data29_->self;
		_g_object_unref0 (_data29_->game_icon);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}

static void
__lambda21_ (Block29Data* _data29_)
{
	GamesGamesPage* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = _data29_->self;
	_tmp0_ = games_game_icon_view_get_checked (_data29_->game_icon);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GHashTable* _tmp2_;
		GamesGameIconView* _tmp3_;
		_tmp2_ = self->priv->selected_games;
		_tmp3_ = _g_object_ref0 (_data29_->game_icon);
		g_hash_table_add (_tmp2_, _tmp3_);
	} else {
		GHashTable* _tmp4_;
		_tmp4_ = self->priv->selected_games;
		g_hash_table_remove (_tmp4_, _data29_->game_icon);
	}
	g_signal_emit (self, games_games_page_signals[GAMES_GAMES_PAGE_SELECTED_ITEMS_CHANGED_SIGNAL], 0);
}

static void
___lambda21__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda21_ (self);
}

static GtkWidget*
games_games_page_add_game (GamesGamesPage* self,
                           GObject* item)
{
	Block29Data* _data29_;
	GamesGameIconView* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = games_game_icon_view_new (GAMES_IS_GAME (item) ? ((GamesGame*) item) : NULL);
	g_object_ref_sink (_tmp0_);
	_data29_->game_icon = _tmp0_;
	g_object_bind_property_with_closures ((GObject*) self, "is-selection-mode", (GObject*) _data29_->game_icon, "is-selection-mode", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	g_signal_connect_data ((GObject*) _data29_->game_icon, "notify::checked", (GCallback) ___lambda21__g_object_notify, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _data29_->game_icon);
	result = _tmp1_;
	block29_data_unref (_data29_);
	_data29_ = NULL;
	return result;
}

void
games_games_page_invalidate_filter (GamesGamesPage* self)
{
	GtkFlowBox* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->flow_box;
	gtk_flow_box_invalidate_filter (_tmp0_);
}

static gboolean
games_games_page_filter_box (GamesGamesPage* self,
                             GtkFlowBoxChild* child)
{
	GamesGameIconView* game_view = NULL;
	GamesGameIconView* _tmp0_;
	GamesGameIconView* _tmp1_;
	GamesGameIconView* _tmp2_;
	GamesGame* _tmp3_;
	GamesGame* _tmp4_;
	GamesGameIconView* _tmp5_;
	GamesGame* _tmp6_;
	GamesGame* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (child != NULL, FALSE);
	_tmp0_ = _g_object_ref0 (GAMES_IS_GAME_ICON_VIEW (child) ? ((GamesGameIconView*) child) : NULL);
	game_view = _tmp0_;
	_tmp1_ = game_view;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (game_view);
		return result;
	}
	_tmp2_ = game_view;
	_tmp3_ = games_game_icon_view_get_game (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_object_unref0 (game_view);
		return result;
	}
	_tmp5_ = game_view;
	_tmp6_ = games_game_icon_view_get_game (_tmp5_);
	_tmp7_ = _tmp6_;
	result = games_games_page_filter_game (self, _tmp7_);
	_g_object_unref0 (game_view);
	return result;
}

static gboolean
games_games_page_filter_game (GamesGamesPage* self,
                              GamesGame* game)
{
	gboolean _tmp0_ = FALSE;
	GamesGamesPageGameFilter _tmp1_;
	gpointer _tmp1__target;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (game != NULL, FALSE);
	_tmp1_ = self->priv->game_filter;
	_tmp1__target = self->priv->game_filter_target;
	if (_tmp1_ != NULL) {
		GamesGamesPageGameFilter _tmp2_;
		gpointer _tmp2__target;
		_tmp2_ = self->priv->game_filter;
		_tmp2__target = self->priv->game_filter_target;
		_tmp0_ = !_tmp2_ (game, _tmp2__target);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = self->priv->filtering_terms;
	_tmp3__length1 = self->priv->filtering_terms_length1;
	result = games_game_matches_search_terms (game, _tmp3_, (gint) _tmp3__length1);
	return result;
}

static gboolean
games_games_page_found_games (GamesGamesPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GamesGameModel* _tmp2_;
				GamesGameModel* _tmp3_;
				GamesGame* game = NULL;
				GamesGameModel* _tmp4_;
				GamesGameModel* _tmp5_;
				GObject* _tmp6_;
				GamesGame* _tmp7_;
				GamesGame* _tmp8_;
				gchar** _tmp9_;
				gint _tmp9__length1;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = games_games_page_get_game_model (self);
				_tmp3_ = _tmp2_;
				if (!(((guint) i) < g_list_model_get_n_items ((GListModel*) _tmp3_))) {
					break;
				}
				_tmp4_ = games_games_page_get_game_model (self);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_list_model_get_item ((GListModel*) _tmp5_, (guint) i);
				_tmp7_ = GAMES_IS_GAME (_tmp6_) ? ((GamesGame*) _tmp6_) : NULL;
				if (_tmp7_ == NULL) {
					_g_object_unref0 (_tmp6_);
				}
				game = _tmp7_;
				_tmp8_ = game;
				_tmp9_ = self->priv->filtering_terms;
				_tmp9__length1 = self->priv->filtering_terms_length1;
				if (games_game_matches_search_terms (_tmp8_, _tmp9_, (gint) _tmp9__length1)) {
					result = TRUE;
					_g_object_unref0 (game);
					return result;
				}
				_g_object_unref0 (game);
			}
		}
	}
	result = FALSE;
	return result;
}

static void
games_games_page_update_is_search_empty (GamesGamesPage* self)
{
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->filtering_terms;
	_tmp1__length1 = self->priv->filtering_terms_length1;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = self->priv->filtering_terms;
		_tmp2__length1 = self->priv->filtering_terms_length1;
		_tmp0_ = _tmp2__length1 == 0;
	}
	if (_tmp0_) {
		games_games_page_set_is_search_empty (self, FALSE);
	}
	games_games_page_set_is_search_empty (self, !games_games_page_found_games (self));
}

static void
games_games_page_on_size_allocate (GamesGamesPage* self,
                                   GtkAllocation* allocation)
{
	GtkAllocation _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	if (_tmp0_.width < 960) {
		GtkStyleContext* _tmp1_;
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_remove_class (_tmp1_, "large");
	} else {
		GtkStyleContext* _tmp2_;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp2_, "large");
	}
}

static void
_games_games_page_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                             GtkAllocation* allocation,
                                                             gpointer self)
{
	games_games_page_on_size_allocate ((GamesGamesPage*) self, allocation);
}

GamesGamesPage*
games_games_page_construct (GType object_type)
{
	GamesGamesPage * self = NULL;
	self = (GamesGamesPage*) g_object_new (object_type, NULL);
	return self;
}

GamesGamesPage*
games_games_page_new (void)
{
	return games_games_page_construct (GAMES_TYPE_GAMES_PAGE);
}

gboolean
games_games_page_get_is_selection_mode (GamesGamesPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_selection_mode;
	return result;
}

void
games_games_page_set_is_selection_mode (GamesGamesPage* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = games_games_page_get_is_selection_mode (self);
	if (old_value != value) {
		self->priv->_is_selection_mode = value;
		g_object_notify_by_pspec ((GObject *) self, games_games_page_properties[GAMES_GAMES_PAGE_IS_SELECTION_MODE_PROPERTY]);
	}
}

GamesGameModel*
games_games_page_get_game_model (GamesGamesPage* self)
{
	GamesGameModel* result;
	GamesGameModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_game_model;
	result = _tmp0_;
	return result;
}

static GtkWidget*
_games_games_page_add_game_gtk_flow_box_create_widget_func (gpointer item,
                                                            gpointer self)
{
	GtkWidget* result;
	result = games_games_page_add_game ((GamesGamesPage*) self, item);
	return result;
}

void
games_games_page_set_game_model (GamesGamesPage* self,
                                 GamesGameModel* value)
{
	GamesGameModel* _tmp0_;
	GtkFlowBox* _tmp1_;
	GamesGameModel* _tmp2_;
	GamesGameModel* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_game_model);
	self->priv->_game_model = _tmp0_;
	_tmp1_ = self->priv->flow_box;
	_tmp2_ = games_games_page_get_game_model (self);
	_tmp3_ = _tmp2_;
	gtk_flow_box_bind_model (_tmp1_, (GListModel*) _tmp3_, _games_games_page_add_game_gtk_flow_box_create_widget_func, g_object_ref (self), g_object_unref);
	g_object_notify_by_pspec ((GObject *) self, games_games_page_properties[GAMES_GAMES_PAGE_GAME_MODEL_PROPERTY]);
}

gboolean
games_games_page_get_hide_stars (GamesGamesPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_hide_stars;
	return result;
}

void
games_games_page_set_hide_stars (GamesGamesPage* self,
                                 gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_hide_stars = value;
	_tmp0_ = games_games_page_get_hide_stars (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		GtkStyleContext* _tmp2_;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp2_, "hide-stars");
	} else {
		GtkStyleContext* _tmp3_;
		_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_remove_class (_tmp3_, "hide-stars");
	}
	g_object_notify_by_pspec ((GObject *) self, games_games_page_properties[GAMES_GAMES_PAGE_HIDE_STARS_PROPERTY]);
}

gboolean
games_games_page_get_is_active (GamesGamesPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_active;
	return result;
}

void
games_games_page_set_is_active (GamesGamesPage* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_is_active == value) {
		return;
	}
	self->priv->_is_active = value;
	if (!self->priv->_is_active) {
		GamesGamepadBrowse* _tmp0_;
		_tmp0_ = self->priv->gamepad_browse;
		games_gamepad_browse_cancel_cursor_movement (_tmp0_);
	}
	g_object_notify_by_pspec ((GObject *) self, games_games_page_properties[GAMES_GAMES_PAGE_IS_ACTIVE_PROPERTY]);
}

gboolean
games_games_page_get_is_search_empty (GamesGamesPage* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_search_empty;
	return result;
}

void
games_games_page_set_is_search_empty (GamesGamesPage* self,
                                      gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = games_games_page_get_is_search_empty (self);
	if (old_value != value) {
		self->priv->_is_search_empty = value;
		g_object_notify_by_pspec ((GObject *) self, games_games_page_properties[GAMES_GAMES_PAGE_IS_SEARCH_EMPTY_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}

static gboolean
_games_games_page_filter_box_gtk_flow_box_filter_func (GtkFlowBoxChild* child,
                                                       gpointer self)
{
	gboolean result;
	result = games_games_page_filter_box ((GamesGamesPage*) self, child);
	return result;
}

static guint
_games_game_icon_view_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = games_game_icon_view_hash ((GamesGameIconView*) key);
	return result;
}

static gboolean
_games_game_icon_view_equal_gequal_func (gconstpointer a,
                                         gconstpointer b)
{
	gboolean result;
	result = games_game_icon_view_equal ((GamesGameIconView*) a, (GamesGameIconView*) b);
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static GObject *
games_games_page_constructor (GType type,
                              guint n_construct_properties,
                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GamesGamesPage * self;
	GtkFlowBox* _tmp0_;
	GtkFlowBox* _tmp1_;
	GHashTable* _tmp2_;
	parent_class = G_OBJECT_CLASS (games_games_page_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMES_PAGE, GamesGamesPage);
	_tmp0_ = self->priv->flow_box;
	gtk_flow_box_set_max_children_per_line (_tmp0_, G_MAXUINT);
	_tmp1_ = self->priv->flow_box;
	gtk_flow_box_set_filter_func (_tmp1_, _games_games_page_filter_box_gtk_flow_box_filter_func, g_object_ref (self), g_object_unref);
	_tmp2_ = g_hash_table_new_full (_games_game_icon_view_hash_ghash_func, _games_game_icon_view_equal_gequal_func, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->selected_games);
	self->priv->selected_games = _tmp2_;
	return obj;
}

static void
games_games_page_class_init (GamesGamesPageClass * klass,
                             gpointer klass_data)
{
	games_games_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesGamesPage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_games_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_games_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = games_games_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_games_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAMES_PAGE_IS_SELECTION_MODE_PROPERTY, games_games_page_properties[GAMES_GAMES_PAGE_IS_SELECTION_MODE_PROPERTY] = g_param_spec_boolean ("is-selection-mode", "is-selection-mode", "is-selection-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAMES_PAGE_GAME_MODEL_PROPERTY, games_games_page_properties[GAMES_GAMES_PAGE_GAME_MODEL_PROPERTY] = g_param_spec_object ("game-model", "game-model", "game-model", GAMES_TYPE_GAME_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAMES_PAGE_HIDE_STARS_PROPERTY, games_games_page_properties[GAMES_GAMES_PAGE_HIDE_STARS_PROPERTY] = g_param_spec_boolean ("hide-stars", "hide-stars", "hide-stars", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAMES_PAGE_IS_ACTIVE_PROPERTY, games_games_page_properties[GAMES_GAMES_PAGE_IS_ACTIVE_PROPERTY] = g_param_spec_boolean ("is-active", "is-active", "is-active", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAMES_PAGE_IS_SEARCH_EMPTY_PROPERTY, games_games_page_properties[GAMES_GAMES_PAGE_IS_SEARCH_EMPTY_PROPERTY] = g_param_spec_boolean ("is-search-empty", "is-search-empty", "is-search-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Games/ui/games-page.ui");
	games_games_page_signals[GAMES_GAMES_PAGE_GAME_ACTIVATED_SIGNAL] = g_signal_new ("game-activated", GAMES_TYPE_GAMES_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GAMES_TYPE_GAME);
	games_games_page_signals[GAMES_GAMES_PAGE_SELECTED_ITEMS_CHANGED_SIGNAL] = g_signal_new ("selected-items-changed", GAMES_TYPE_GAMES_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	games_games_page_signals[GAMES_GAMES_PAGE_GAMEPAD_CANCEL_CLICKED_SIGNAL] = g_signal_new ("gamepad-cancel-clicked", GAMES_TYPE_GAMES_PAGE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "scrolled_window", FALSE, GamesGamesPage_private_offset + G_STRUCT_OFFSET (GamesGamesPagePrivate, scrolled_window));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "flow_box", FALSE, GamesGamesPage_private_offset + G_STRUCT_OFFSET (GamesGamesPagePrivate, flow_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "gamepad_browse", FALSE, GamesGamesPage_private_offset + G_STRUCT_OFFSET (GamesGamesPagePrivate, gamepad_browse));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_map", G_CALLBACK(_games_games_page_on_map_gtk_widget_map));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_unmap", G_CALLBACK(_games_games_page_on_unmap_gtk_widget_unmap));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_gamepad_browse", G_CALLBACK(_games_games_page_on_gamepad_browse_games_gamepad_browse_browse));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_gamepad_accept", G_CALLBACK(_games_games_page_on_gamepad_accept_games_gamepad_browse_accept));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_gamepad_cancel", G_CALLBACK(_games_games_page_on_gamepad_cancel_games_gamepad_browse_cancel));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_child_activated", G_CALLBACK(_games_games_page_on_child_activated_gtk_flow_box_child_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_size_allocate", G_CALLBACK(_games_games_page_on_size_allocate_gtk_widget_size_allocate));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "gamesgamespage");
}

static void
games_games_page_instance_init (GamesGamesPage * self,
                                gpointer klass)
{
	self->priv = games_games_page_get_instance_private (self);
	g_type_ensure (GAMES_TYPE_GAMEPAD_BROWSE);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
games_games_page_finalize (GObject * obj)
{
	GamesGamesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMES_PAGE, GamesGamesPage);
	self->priv->filtering_terms = (_vala_array_free (self->priv->filtering_terms, self->priv->filtering_terms_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_game_model);
	_g_hash_table_unref0 (self->priv->selected_games);
	_g_object_unref0 (self->priv->window_active_binding);
	G_OBJECT_CLASS (games_games_page_parent_class)->finalize (obj);
}

static GType
games_games_page_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGamesPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_games_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGamesPage), 0, (GInstanceInitFunc) games_games_page_instance_init, NULL };
	GType games_games_page_type_id;
	games_games_page_type_id = g_type_register_static (gtk_bin_get_type (), "GamesGamesPage", &g_define_type_info, 0);
	GamesGamesPage_private_offset = g_type_add_instance_private (games_games_page_type_id, sizeof (GamesGamesPagePrivate));
	return games_games_page_type_id;
}

GType
games_games_page_get_type (void)
{
	static volatile gsize games_games_page_type_id__once = 0;
	if (g_once_init_enter (&games_games_page_type_id__once)) {
		GType games_games_page_type_id;
		games_games_page_type_id = games_games_page_get_type_once ();
		g_once_init_leave (&games_games_page_type_id__once, games_games_page_type_id);
	}
	return games_games_page_type_id__once;
}

static void
_vala_games_games_page_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GamesGamesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAMES_PAGE, GamesGamesPage);
	switch (property_id) {
		case GAMES_GAMES_PAGE_IS_SELECTION_MODE_PROPERTY:
		g_value_set_boolean (value, games_games_page_get_is_selection_mode (self));
		break;
		case GAMES_GAMES_PAGE_GAME_MODEL_PROPERTY:
		g_value_set_object (value, games_games_page_get_game_model (self));
		break;
		case GAMES_GAMES_PAGE_HIDE_STARS_PROPERTY:
		g_value_set_boolean (value, games_games_page_get_hide_stars (self));
		break;
		case GAMES_GAMES_PAGE_IS_ACTIVE_PROPERTY:
		g_value_set_boolean (value, games_games_page_get_is_active (self));
		break;
		case GAMES_GAMES_PAGE_IS_SEARCH_EMPTY_PROPERTY:
		g_value_set_boolean (value, games_games_page_get_is_search_empty (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_games_page_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	GamesGamesPage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAMES_PAGE, GamesGamesPage);
	switch (property_id) {
		case GAMES_GAMES_PAGE_IS_SELECTION_MODE_PROPERTY:
		games_games_page_set_is_selection_mode (self, g_value_get_boolean (value));
		break;
		case GAMES_GAMES_PAGE_GAME_MODEL_PROPERTY:
		games_games_page_set_game_model (self, g_value_get_object (value));
		break;
		case GAMES_GAMES_PAGE_HIDE_STARS_PROPERTY:
		games_games_page_set_hide_stars (self, g_value_get_boolean (value));
		break;
		case GAMES_GAMES_PAGE_IS_ACTIVE_PROPERTY:
		games_games_page_set_is_active (self, g_value_get_boolean (value));
		break;
		case GAMES_GAMES_PAGE_IS_SEARCH_EMPTY_PROPERTY:
		games_games_page_set_is_search_empty (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

