/* gamepad-view.c generated by valac 0.56.8, the Vala compiler
 * generated from gamepad-view.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <librsvg/rsvg.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include "gnome-games.h"

#define GAMES_TYPE_GAMEPAD_VIEW (games_gamepad_view_get_type ())
#define GAMES_GAMEPAD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadView))
#define GAMES_GAMEPAD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadViewClass))
#define GAMES_IS_GAMEPAD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD_VIEW))
#define GAMES_IS_GAMEPAD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD_VIEW))
#define GAMES_GAMEPAD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadViewClass))

typedef struct _GamesGamepadView GamesGamepadView;
typedef struct _GamesGamepadViewClass GamesGamepadViewClass;
typedef struct _GamesGamepadViewPrivate GamesGamepadViewPrivate;

#define GAMES_GAMEPAD_VIEW_TYPE_INPUT_STATE (games_gamepad_view_input_state_get_type ())
typedef struct _GamesGamepadViewInputState GamesGamepadViewInputState;

#define GAMES_TYPE_GAMEPAD_VIEW_CONFIGURATION (games_gamepad_view_configuration_get_type ())
typedef struct _GamesGamepadViewConfiguration GamesGamepadViewConfiguration;

#define GAMES_TYPE_GAMEPAD_BUTTON_PATH (games_gamepad_button_path_get_type ())
typedef struct _GamesGamepadButtonPath GamesGamepadButtonPath;

#define GAMES_TYPE_GAMEPAD_INPUT (games_gamepad_input_get_type ())
typedef struct _GamesGamepadInput GamesGamepadInput;

#define GAMES_TYPE_GAMEPAD_ANALOG_PATH (games_gamepad_analog_path_get_type ())
typedef struct _GamesGamepadAnalogPath GamesGamepadAnalogPath;
enum  {
	GAMES_GAMEPAD_VIEW_0_PROPERTY,
	GAMES_GAMEPAD_VIEW_CONFIGURATION_PROPERTY,
	GAMES_GAMEPAD_VIEW_NUM_PROPERTIES
};
static GParamSpec* games_gamepad_view_properties[GAMES_GAMEPAD_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
typedef struct _Block28Data Block28Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GamesGamepadView {
	GtkDrawingArea parent_instance;
	GamesGamepadViewPrivate * priv;
};

struct _GamesGamepadViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GamesGamepadViewInputState {
	gboolean highlight;
	gdouble offset_x;
	gdouble offset_y;
};

struct _GamesGamepadInput {
	guint16 type;
	guint16 code;
};

struct _GamesGamepadButtonPath {
	GamesGamepadInput input;
	gchar* path;
};

struct _GamesGamepadAnalogPath {
	GamesGamepadInput input_x;
	GamesGamepadInput input_y;
	gdouble offset_radius;
	gchar* path;
};

struct _GamesGamepadViewConfiguration {
	gchar* svg_path;
	GamesGamepadButtonPath* button_paths;
	gint button_paths_length1;
	gint _button_paths_size_;
	GamesGamepadAnalogPath* analog_paths;
	gint analog_paths_length1;
	gint _analog_paths_size_;
	gchar** background_paths;
	gint background_paths_length1;
	gint _background_paths_size_;
};

struct _GamesGamepadViewPrivate {
	RsvgHandle* handle;
	GHashTable* input_state;
	GamesGamepadViewConfiguration _configuration;
};

struct _Block28Data {
	int _ref_count_;
	GamesGamepadView* self;
	cairo_t* context;
};

static gint GamesGamepadView_private_offset;
static gpointer games_gamepad_view_parent_class = NULL;

VALA_EXTERN GType games_gamepad_view_get_type (void) G_GNUC_CONST ;
static GType games_gamepad_view_input_state_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GamesGamepadViewInputState* games_gamepad_view_input_state_dup (const GamesGamepadViewInputState* self);
static void games_gamepad_view_input_state_free (GamesGamepadViewInputState* self);
VALA_EXTERN GType games_gamepad_view_configuration_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_button_path_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_input_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGamepadInput* games_gamepad_input_dup (const GamesGamepadInput* self);
VALA_EXTERN void games_gamepad_input_free (GamesGamepadInput* self);
VALA_EXTERN GamesGamepadButtonPath* games_gamepad_button_path_dup (const GamesGamepadButtonPath* self);
VALA_EXTERN void games_gamepad_button_path_free (GamesGamepadButtonPath* self);
VALA_EXTERN void games_gamepad_button_path_copy (const GamesGamepadButtonPath* self,
                                     GamesGamepadButtonPath* dest);
VALA_EXTERN void games_gamepad_button_path_destroy (GamesGamepadButtonPath* self);
VALA_EXTERN GType games_gamepad_analog_path_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGamepadAnalogPath* games_gamepad_analog_path_dup (const GamesGamepadAnalogPath* self);
VALA_EXTERN void games_gamepad_analog_path_free (GamesGamepadAnalogPath* self);
VALA_EXTERN void games_gamepad_analog_path_copy (const GamesGamepadAnalogPath* self,
                                     GamesGamepadAnalogPath* dest);
VALA_EXTERN void games_gamepad_analog_path_destroy (GamesGamepadAnalogPath* self);
VALA_EXTERN GamesGamepadViewConfiguration* games_gamepad_view_configuration_dup (const GamesGamepadViewConfiguration* self);
VALA_EXTERN void games_gamepad_view_configuration_free (GamesGamepadViewConfiguration* self);
VALA_EXTERN void games_gamepad_view_configuration_copy (const GamesGamepadViewConfiguration* self,
                                            GamesGamepadViewConfiguration* dest);
VALA_EXTERN void games_gamepad_view_configuration_destroy (GamesGamepadViewConfiguration* self);
static void games_gamepad_view_get_dimensions (GamesGamepadView* self,
                                        gdouble* width,
                                        gdouble* height);
VALA_EXTERN void games_gamepad_view_reset (GamesGamepadView* self);
static void __lambda79_ (GamesGamepadView* self,
                  const gchar* path,
                  GamesGamepadViewInputState* state);
static void ___lambda79__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
VALA_EXTERN gboolean games_gamepad_view_highlight (GamesGamepadView* self,
                                       GamesGamepadInput* input,
                                       gboolean highlight);
VALA_EXTERN void games_gamepad_view_get_configuration (GamesGamepadView* self,
                                           GamesGamepadViewConfiguration * result);
static gboolean _games_gamepad_input_equal (const GamesGamepadInput * s1,
                                     const GamesGamepadInput * s2);
VALA_EXTERN gboolean games_gamepad_view_set_analog (GamesGamepadView* self,
                                        GamesGamepadInput* input,
                                        gdouble value);
static gboolean games_gamepad_view_real_draw (GtkWidget* base,
                                       cairo_t* context);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
static void games_gamepad_view_calculate_image_dimensions (GamesGamepadView* self,
                                                    gdouble* x,
                                                    gdouble* y,
                                                    gdouble* scale);
static void games_gamepad_view_draw_path (GamesGamepadView* self,
                                   cairo_t* context,
                                   const gchar* path,
                                   GdkRGBA* color,
                                   gdouble offset_x,
                                   gdouble offset_y);
static void __lambda81_ (Block28Data* _data28_,
                  const gchar* path,
                  GamesGamepadViewInputState* state);
static void ___lambda81__gh_func (gconstpointer key,
                           gconstpointer value,
                           gpointer self);
VALA_EXTERN GamesGamepadView* games_gamepad_view_new (void);
VALA_EXTERN GamesGamepadView* games_gamepad_view_construct (GType object_type);
VALA_EXTERN void games_gamepad_view_set_configuration (GamesGamepadView* self,
                                           GamesGamepadViewConfiguration * value);
static gboolean _games_gamepad_view_configuration_equal (const GamesGamepadViewConfiguration * s1,
                                                  const GamesGamepadViewConfiguration * s2);
static guint8* _vala_array_dup21 (guint8* self,
                           gssize length);
static gboolean _games_gamepad_view_configuration___lambda80_ (GamesGamepadView* self);
static gboolean __games_gamepad_view_configuration___lambda80__ghr_func (gconstpointer key,
                                                                  gconstpointer value,
                                                                  gpointer self);
static GObject * games_gamepad_view_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void _vala_GamesGamepadButtonPath_array_free (GamesGamepadButtonPath * array,
                                              gssize array_length);
static void _g_free0_ (gpointer var);
static void _games_gamepad_view_input_state_free0_ (gpointer var);
static void games_gamepad_view_finalize (GObject * obj);
static GType games_gamepad_view_get_type_once (void);
static void _vala_games_gamepad_view_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_games_gamepad_view_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_gamepad_view_get_instance_private (GamesGamepadView* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGamepadView_private_offset);
}

static void
games_gamepad_view_get_dimensions (GamesGamepadView* self,
                                   gdouble* width,
                                   gdouble* height)
{
	gdouble _vala_width = 0.0;
	gdouble _vala_height = 0.0;
	gboolean has_width = FALSE;
	gboolean has_height = FALSE;
	gboolean has_viewbox = FALSE;
	RsvgLength handle_width = {0};
	RsvgLength handle_height = {0};
	RsvgRectangle viewbox = {0};
	RsvgHandle* _tmp0_;
	gboolean _tmp1_ = FALSE;
	RsvgLength _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	RsvgLength _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	RsvgRectangle _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	RsvgLength _tmp8_;
	RsvgLength _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->handle;
	rsvg_handle_get_intrinsic_dimensions (_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	has_width = _tmp1_;
	handle_width = _tmp2_;
	has_height = _tmp3_;
	handle_height = _tmp4_;
	has_viewbox = _tmp5_;
	viewbox = _tmp6_;
	if (has_width) {
		_tmp7_ = has_height;
	} else {
		_tmp7_ = FALSE;
	}
	_vala_assert (_tmp7_, "has_width && has_height");
	_tmp8_ = handle_width;
	_vala_width = _tmp8_.length;
	_tmp9_ = handle_height;
	_vala_height = _tmp9_.length;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static void
__lambda79_ (GamesGamepadView* self,
             const gchar* path,
             GamesGamepadViewInputState* state)
{
	g_return_if_fail (path != NULL);
	(*state).highlight = FALSE;
	(*state).offset_x = (gdouble) 0;
	(*state).offset_y = (gdouble) 0;
}

static void
___lambda79__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda79_ ((GamesGamepadView*) self, (const gchar*) key, (GamesGamepadViewInputState*) value);
}

void
games_gamepad_view_reset (GamesGamepadView* self)
{
	GHashTable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input_state;
	g_hash_table_foreach (_tmp0_, ___lambda79__gh_func, self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static gboolean
_games_gamepad_input_equal (const GamesGamepadInput * s1,
                            const GamesGamepadInput * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->type != s2->type) {
		return FALSE;
	}
	if (s1->code != s2->code) {
		return FALSE;
	}
	return TRUE;
}

gboolean
games_gamepad_view_highlight (GamesGamepadView* self,
                              GamesGamepadInput* input,
                              gboolean highlight)
{
	GamesGamepadViewConfiguration _tmp0_ = {0};
	GamesGamepadViewConfiguration _tmp1_;
	GamesGamepadButtonPath* _tmp2_;
	gint _tmp2__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (input != NULL, FALSE);
	games_gamepad_view_get_configuration (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_.button_paths;
	_tmp2__length1 = _tmp1_.button_paths_length1;
	{
		GamesGamepadButtonPath* path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp2_;
		path_collection_length1 = _tmp2__length1;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			GamesGamepadButtonPath _tmp3_;
			GamesGamepadButtonPath _tmp4_ = {0};
			GamesGamepadButtonPath path = {0};
			_tmp3_ = path_collection[path_it];
			games_gamepad_button_path_copy (&_tmp3_, &_tmp4_);
			path = _tmp4_;
			{
				GamesGamepadInput _tmp5_;
				GamesGamepadButtonPath _tmp6_;
				GamesGamepadInput _tmp7_;
				GHashTable* _tmp8_;
				GamesGamepadButtonPath _tmp9_;
				const gchar* _tmp10_;
				gconstpointer _tmp11_;
				_tmp5_ = *input;
				_tmp6_ = path;
				_tmp7_ = _tmp6_.input;
				if (_games_gamepad_input_equal (&_tmp5_, &_tmp7_) != TRUE) {
					games_gamepad_button_path_destroy (&path);
					continue;
				}
				_tmp8_ = self->priv->input_state;
				_tmp9_ = path;
				_tmp10_ = _tmp9_.path;
				_tmp11_ = g_hash_table_lookup (_tmp8_, _tmp10_);
				(*((GamesGamepadViewInputState*) _tmp11_)).highlight = highlight;
				gtk_widget_queue_draw ((GtkWidget*) self);
				result = TRUE;
				games_gamepad_button_path_destroy (&path);
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

gboolean
games_gamepad_view_set_analog (GamesGamepadView* self,
                               GamesGamepadInput* input,
                               gdouble value)
{
	GamesGamepadViewConfiguration _tmp0_ = {0};
	GamesGamepadViewConfiguration _tmp1_;
	GamesGamepadAnalogPath* _tmp2_;
	gint _tmp2__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (input != NULL, FALSE);
	games_gamepad_view_get_configuration (self, &_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_.analog_paths;
	_tmp2__length1 = _tmp1_.analog_paths_length1;
	{
		GamesGamepadAnalogPath* path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp2_;
		path_collection_length1 = _tmp2__length1;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			GamesGamepadAnalogPath _tmp3_;
			GamesGamepadAnalogPath _tmp4_ = {0};
			GamesGamepadAnalogPath path = {0};
			_tmp3_ = path_collection[path_it];
			games_gamepad_analog_path_copy (&_tmp3_, &_tmp4_);
			path = _tmp4_;
			{
				gboolean _tmp5_ = FALSE;
				GamesGamepadInput _tmp6_;
				GamesGamepadAnalogPath _tmp7_;
				GamesGamepadInput _tmp8_;
				GamesGamepadInput _tmp12_;
				GamesGamepadAnalogPath _tmp13_;
				GamesGamepadInput _tmp14_;
				_tmp6_ = *input;
				_tmp7_ = path;
				_tmp8_ = _tmp7_.input_x;
				if (_games_gamepad_input_equal (&_tmp6_, &_tmp8_) != TRUE) {
					GamesGamepadInput _tmp9_;
					GamesGamepadAnalogPath _tmp10_;
					GamesGamepadInput _tmp11_;
					_tmp9_ = *input;
					_tmp10_ = path;
					_tmp11_ = _tmp10_.input_y;
					_tmp5_ = _games_gamepad_input_equal (&_tmp9_, &_tmp11_) != TRUE;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					games_gamepad_analog_path_destroy (&path);
					continue;
				}
				_tmp12_ = *input;
				_tmp13_ = path;
				_tmp14_ = _tmp13_.input_x;
				if (_games_gamepad_input_equal (&_tmp12_, &_tmp14_) == TRUE) {
					GHashTable* _tmp15_;
					GamesGamepadAnalogPath _tmp16_;
					const gchar* _tmp17_;
					gconstpointer _tmp18_;
					GamesGamepadAnalogPath _tmp19_;
					_tmp15_ = self->priv->input_state;
					_tmp16_ = path;
					_tmp17_ = _tmp16_.path;
					_tmp18_ = g_hash_table_lookup (_tmp15_, _tmp17_);
					_tmp19_ = path;
					(*((GamesGamepadViewInputState*) _tmp18_)).offset_x = value * _tmp19_.offset_radius;
				} else {
					GHashTable* _tmp20_;
					GamesGamepadAnalogPath _tmp21_;
					const gchar* _tmp22_;
					gconstpointer _tmp23_;
					GamesGamepadAnalogPath _tmp24_;
					_tmp20_ = self->priv->input_state;
					_tmp21_ = path;
					_tmp22_ = _tmp21_.path;
					_tmp23_ = g_hash_table_lookup (_tmp20_, _tmp22_);
					_tmp24_ = path;
					(*((GamesGamepadViewInputState*) _tmp23_)).offset_y = value * _tmp24_.offset_radius;
				}
				gtk_widget_queue_draw ((GtkWidget*) self);
				result = TRUE;
				games_gamepad_analog_path_destroy (&path);
				return result;
			}
		}
	}
	result = FALSE;
	return result;
}

static gpointer
_cairo_reference0 (gpointer self)
{
	return self ? cairo_reference (self) : NULL;
}

static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
	g_atomic_int_inc (&_data28_->_ref_count_);
	return _data28_;
}

static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
		GamesGamepadView* self;
		self = _data28_->self;
		_cairo_destroy0 (_data28_->context);
		_g_object_unref0 (self);
		g_slice_free (Block28Data, _data28_);
	}
}

static void
__lambda81_ (Block28Data* _data28_,
             const gchar* path,
             GamesGamepadViewInputState* state)
{
	GamesGamepadView* self;
	const gchar* _tmp0_ = NULL;
	gchar* color_name = NULL;
	gchar* _tmp1_;
	GdkRGBA color = {0};
	GtkStyleContext* _tmp2_;
	GdkRGBA _tmp3_ = {0};
	GdkRGBA _tmp4_;
	self = _data28_->self;
	g_return_if_fail (path != NULL);
	if ((*state).highlight) {
		_tmp0_ = "theme_selected_bg_color";
	} else {
		_tmp0_ = "theme_fg_color";
	}
	_tmp1_ = g_strdup (_tmp0_);
	color_name = _tmp1_;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_lookup_color (_tmp2_, color_name, &_tmp3_);
	color = _tmp3_;
	_tmp4_ = color;
	games_gamepad_view_draw_path (self, _data28_->context, path, &_tmp4_, (*state).offset_x, (*state).offset_y);
	_g_free0 (color_name);
}

static void
___lambda81__gh_func (gconstpointer key,
                      gconstpointer value,
                      gpointer self)
{
	__lambda81_ (self, (const gchar*) key, (GamesGamepadViewInputState*) value);
}

static gboolean
games_gamepad_view_real_draw (GtkWidget* base,
                              cairo_t* context)
{
	GamesGamepadView * self;
	Block28Data* _data28_;
	cairo_t* _tmp0_;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble scale = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	GamesGamepadViewConfiguration _tmp4_ = {0};
	GamesGamepadViewConfiguration _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GHashTable* _tmp12_;
	gboolean result;
	self = (GamesGamepadView*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_data28_ = g_slice_new0 (Block28Data);
	_data28_->_ref_count_ = 1;
	_data28_->self = g_object_ref (self);
	_tmp0_ = _cairo_reference0 (context);
	_cairo_destroy0 (_data28_->context);
	_data28_->context = _tmp0_;
	games_gamepad_view_calculate_image_dimensions (self, &_tmp1_, &_tmp2_, &_tmp3_);
	x = _tmp1_;
	y = _tmp2_;
	scale = _tmp3_;
	cairo_translate (_data28_->context, x, y);
	cairo_scale (_data28_->context, scale, scale);
	games_gamepad_view_get_configuration (self, &_tmp4_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_.background_paths;
	_tmp6__length1 = _tmp5_.background_paths_length1;
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp6_;
		path_collection_length1 = _tmp6__length1;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			gchar* _tmp7_;
			gchar* path = NULL;
			_tmp7_ = g_strdup (path_collection[path_it]);
			path = _tmp7_;
			{
				GdkRGBA color = {0};
				GtkStyleContext* _tmp8_;
				GdkRGBA _tmp9_ = {0};
				const gchar* _tmp10_;
				GdkRGBA _tmp11_;
				_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) self);
				gtk_style_context_lookup_color (_tmp8_, "theme_fg_color", &_tmp9_);
				color = _tmp9_;
				_tmp10_ = path;
				_tmp11_ = color;
				games_gamepad_view_draw_path (self, _data28_->context, _tmp10_, &_tmp11_, (gdouble) 0, (gdouble) 0);
				_g_free0 (path);
			}
		}
	}
	_tmp12_ = self->priv->input_state;
	g_hash_table_foreach (_tmp12_, ___lambda81__gh_func, _data28_);
	result = FALSE;
	block28_data_unref (_data28_);
	_data28_ = NULL;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
games_gamepad_view_draw_path (GamesGamepadView* self,
                              cairo_t* context,
                              const gchar* path,
                              GdkRGBA* color,
                              gdouble offset_x,
                              gdouble offset_y)
{
	RsvgHandle* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	cairo_pattern_t* group = NULL;
	cairo_pattern_t* _tmp4_;
	GdkRGBA _tmp5_;
	GdkRGBA _tmp6_;
	GdkRGBA _tmp7_;
	GdkRGBA _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (color != NULL);
	cairo_push_group (context);
	cairo_translate (context, offset_x, offset_y);
	_tmp0_ = self->priv->handle;
	_tmp1_ = string_to_string (path);
	_tmp2_ = g_strconcat ("#", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	rsvg_handle_render_cairo_sub (_tmp0_, context, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = cairo_pop_group (context);
	group = _tmp4_;
	_tmp5_ = *color;
	_tmp6_ = *color;
	_tmp7_ = *color;
	_tmp8_ = *color;
	cairo_set_source_rgba (context, _tmp5_.red, _tmp6_.green, _tmp7_.blue, _tmp8_.alpha);
	cairo_mask (context, group);
	_cairo_pattern_destroy0 (group);
}

static void
games_gamepad_view_calculate_image_dimensions (GamesGamepadView* self,
                                               gdouble* x,
                                               gdouble* y,
                                               gdouble* scale)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	gdouble _vala_scale = 0.0;
	gdouble width = 0.0;
	gdouble height = 0.0;
	gdouble image_width = 0.0;
	gdouble image_height = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	g_return_if_fail (self != NULL);
	width = (gdouble) gtk_widget_get_allocated_width ((GtkWidget*) self);
	height = (gdouble) gtk_widget_get_allocated_height ((GtkWidget*) self);
	games_gamepad_view_get_dimensions (self, &_tmp0_, &_tmp1_);
	image_width = _tmp0_;
	image_height = _tmp1_;
	_vala_scale = MIN (height / image_height, width / image_width);
	_vala_x = (width - (image_width * _vala_scale)) / 2;
	_vala_y = (height - (image_height * _vala_scale)) / 2;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (scale) {
		*scale = _vala_scale;
	}
}

GamesGamepadView*
games_gamepad_view_construct (GType object_type)
{
	GamesGamepadView * self = NULL;
	self = (GamesGamepadView*) g_object_new (object_type, NULL);
	return self;
}

GamesGamepadView*
games_gamepad_view_new (void)
{
	return games_gamepad_view_construct (GAMES_TYPE_GAMEPAD_VIEW);
}

void
games_gamepad_view_get_configuration (GamesGamepadView* self,
                                      GamesGamepadViewConfiguration * result)
{
	GamesGamepadViewConfiguration _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_configuration;
	*result = _tmp0_;
	return;
}

static gboolean
_games_gamepad_view_configuration_equal (const GamesGamepadViewConfiguration * s1,
                                         const GamesGamepadViewConfiguration * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (g_strcmp0 (s1->svg_path, s2->svg_path)) {
		return FALSE;
	}
	if (s1->button_paths != s2->button_paths) {
		return FALSE;
	}
	if (s1->analog_paths != s2->analog_paths) {
		return FALSE;
	}
	if (s1->background_paths != s2->background_paths) {
		return FALSE;
	}
	return TRUE;
}

static guint8*
_vala_array_dup21 (guint8* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static gboolean
_games_gamepad_view_configuration___lambda80_ (GamesGamepadView* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

static gboolean
__games_gamepad_view_configuration___lambda80__ghr_func (gconstpointer key,
                                                         gconstpointer value,
                                                         gpointer self)
{
	gboolean result;
	result = _games_gamepad_view_configuration___lambda80_ ((GamesGamepadView*) self);
	return result;
}

static gpointer
_games_gamepad_view_input_state_dup0 (gpointer self)
{
	return self ? games_gamepad_view_input_state_dup (self) : NULL;
}

void
games_gamepad_view_set_configuration (GamesGamepadView* self,
                                      GamesGamepadViewConfiguration * value)
{
	GamesGamepadViewConfiguration _tmp0_;
	GamesGamepadViewConfiguration _tmp1_ = {0};
	GamesGamepadViewConfiguration _tmp2_;
	GamesGamepadViewConfiguration _tmp3_;
	GamesGamepadViewConfiguration _tmp4_;
	GamesGamepadViewConfiguration _tmp5_ = {0};
	GamesGamepadViewConfiguration _tmp6_;
	const gchar* _tmp7_;
	gdouble width = 0.0;
	gdouble height = 0.0;
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	GHashTable* _tmp23_;
	GamesGamepadViewConfiguration _tmp24_ = {0};
	GamesGamepadViewConfiguration _tmp25_;
	GamesGamepadButtonPath* _tmp26_;
	gint _tmp26__length1;
	GamesGamepadViewConfiguration _tmp38_ = {0};
	GamesGamepadViewConfiguration _tmp39_;
	GamesGamepadAnalogPath* _tmp40_;
	gint _tmp40__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	games_gamepad_view_get_configuration (self, &_tmp1_);
	_tmp2_ = _tmp1_;
	if (_games_gamepad_view_configuration_equal (&_tmp0_, &_tmp2_) == TRUE) {
		return;
	}
	_tmp3_ = *value;
	_tmp4_ = _tmp3_;
	games_gamepad_view_configuration_copy (&_tmp4_, &_tmp5_);
	games_gamepad_view_configuration_destroy (&self->priv->_configuration);
	self->priv->_configuration = _tmp5_;
	_tmp6_ = *value;
	_tmp7_ = _tmp6_.svg_path;
	if (g_strcmp0 (_tmp7_, "") == 0) {
		return;
	}
	{
		GBytes* bytes = NULL;
		GamesGamepadViewConfiguration _tmp8_;
		const gchar* _tmp9_;
		GBytes* _tmp10_;
		guint8* data = NULL;
		GBytes* _tmp11_;
		gsize _tmp12_ = 0;
		guint8* _tmp13_;
		guint8* _tmp14_;
		gint _tmp14__length1;
		gint data_length1;
		gint _data_size_;
		RsvgHandle* _tmp15_ = NULL;
		guint8* _tmp16_;
		gint _tmp16__length1;
		RsvgHandle* _tmp17_;
		RsvgHandle* _tmp18_;
		_tmp8_ = *value;
		_tmp9_ = _tmp8_.svg_path;
		_tmp10_ = g_resources_lookup_data (_tmp9_, G_RESOURCE_LOOKUP_FLAGS_NONE, &_inner_error0_);
		bytes = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = bytes;
		_tmp13_ = g_bytes_get_data (_tmp11_, &_tmp12_);
		_tmp14_ = (_tmp13_ != NULL) ? _vala_array_dup21 (_tmp13_, _tmp12_) : _tmp13_;
		_tmp14__length1 = _tmp12_;
		data = _tmp14_;
		data_length1 = _tmp14__length1;
		_data_size_ = data_length1;
		_tmp16_ = data;
		_tmp16__length1 = data_length1;
		_tmp17_ = rsvg_handle_new_from_data (_tmp16_, _tmp16__length1, &_inner_error0_);
		_tmp15_ = _tmp17_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			data = (g_free (data), NULL);
			_g_bytes_unref0 (bytes);
			goto __catch0_g_error;
		}
		_tmp18_ = _tmp15_;
		_tmp15_ = NULL;
		_g_object_unref0 (self->priv->handle);
		self->priv->handle = _tmp18_;
		_g_object_unref0 (_tmp15_);
		data = (g_free (data), NULL);
		_g_bytes_unref0 (bytes);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_critical ("gamepad-view.vala:32: Could not set up gamepad view: %s", _tmp20_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	games_gamepad_view_get_dimensions (self, &_tmp21_, &_tmp22_);
	width = _tmp21_;
	height = _tmp22_;
	gtk_widget_set_size_request ((GtkWidget*) self, (gint) width, (gint) height);
	_tmp23_ = self->priv->input_state;
	g_hash_table_foreach_remove (_tmp23_, __games_gamepad_view_configuration___lambda80__ghr_func, self);
	games_gamepad_view_get_configuration (self, &_tmp24_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_.button_paths;
	_tmp26__length1 = _tmp25_.button_paths_length1;
	{
		GamesGamepadButtonPath* path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp26_;
		path_collection_length1 = _tmp26__length1;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			GamesGamepadButtonPath _tmp27_;
			GamesGamepadButtonPath _tmp28_ = {0};
			GamesGamepadButtonPath path = {0};
			_tmp27_ = path_collection[path_it];
			games_gamepad_button_path_copy (&_tmp27_, &_tmp28_);
			path = _tmp28_;
			{
				GHashTable* _tmp29_;
				GamesGamepadButtonPath _tmp30_;
				const gchar* _tmp31_;
				GHashTable* _tmp32_;
				GamesGamepadButtonPath _tmp33_;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				GamesGamepadViewInputState _tmp36_ = {0};
				GamesGamepadViewInputState* _tmp37_;
				_tmp29_ = self->priv->input_state;
				_tmp30_ = path;
				_tmp31_ = _tmp30_.path;
				if (g_hash_table_contains (_tmp29_, _tmp31_)) {
					games_gamepad_button_path_destroy (&path);
					continue;
				}
				_tmp32_ = self->priv->input_state;
				_tmp33_ = path;
				_tmp34_ = _tmp33_.path;
				_tmp35_ = g_strdup (_tmp34_);
				_tmp37_ = _games_gamepad_view_input_state_dup0 (&_tmp36_);
				g_hash_table_insert (_tmp32_, _tmp35_, _tmp37_);
				games_gamepad_button_path_destroy (&path);
			}
		}
	}
	games_gamepad_view_get_configuration (self, &_tmp38_);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_.analog_paths;
	_tmp40__length1 = _tmp39_.analog_paths_length1;
	{
		GamesGamepadAnalogPath* path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp40_;
		path_collection_length1 = _tmp40__length1;
		for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
			GamesGamepadAnalogPath _tmp41_;
			GamesGamepadAnalogPath _tmp42_ = {0};
			GamesGamepadAnalogPath path = {0};
			_tmp41_ = path_collection[path_it];
			games_gamepad_analog_path_copy (&_tmp41_, &_tmp42_);
			path = _tmp42_;
			{
				GHashTable* _tmp43_;
				GamesGamepadAnalogPath _tmp44_;
				const gchar* _tmp45_;
				GHashTable* _tmp46_;
				GamesGamepadAnalogPath _tmp47_;
				const gchar* _tmp48_;
				gchar* _tmp49_;
				GamesGamepadViewInputState _tmp50_ = {0};
				GamesGamepadViewInputState* _tmp51_;
				_tmp43_ = self->priv->input_state;
				_tmp44_ = path;
				_tmp45_ = _tmp44_.path;
				if (g_hash_table_contains (_tmp43_, _tmp45_)) {
					games_gamepad_analog_path_destroy (&path);
					continue;
				}
				_tmp46_ = self->priv->input_state;
				_tmp47_ = path;
				_tmp48_ = _tmp47_.path;
				_tmp49_ = g_strdup (_tmp48_);
				_tmp51_ = _games_gamepad_view_input_state_dup0 (&_tmp50_);
				g_hash_table_insert (_tmp46_, _tmp49_, _tmp51_);
				games_gamepad_analog_path_destroy (&path);
			}
		}
	}
	games_gamepad_view_reset (self);
	g_object_notify_by_pspec ((GObject *) self, games_gamepad_view_properties[GAMES_GAMEPAD_VIEW_CONFIGURATION_PROPERTY]);
}

static GamesGamepadViewInputState*
games_gamepad_view_input_state_dup (const GamesGamepadViewInputState* self)
{
	GamesGamepadViewInputState* dup;
	dup = g_new0 (GamesGamepadViewInputState, 1);
	memcpy (dup, self, sizeof (GamesGamepadViewInputState));
	return dup;
}

static void
games_gamepad_view_input_state_free (GamesGamepadViewInputState* self)
{
	g_free (self);
}

static GType
games_gamepad_view_input_state_get_type_once (void)
{
	GType games_gamepad_view_input_state_type_id;
	games_gamepad_view_input_state_type_id = g_boxed_type_register_static ("GamesGamepadViewInputState", (GBoxedCopyFunc) games_gamepad_view_input_state_dup, (GBoxedFreeFunc) games_gamepad_view_input_state_free);
	return games_gamepad_view_input_state_type_id;
}

static GType
games_gamepad_view_input_state_get_type (void)
{
	static volatile gsize games_gamepad_view_input_state_type_id__once = 0;
	if (g_once_init_enter (&games_gamepad_view_input_state_type_id__once)) {
		GType games_gamepad_view_input_state_type_id;
		games_gamepad_view_input_state_type_id = games_gamepad_view_input_state_get_type_once ();
		g_once_init_leave (&games_gamepad_view_input_state_type_id__once, games_gamepad_view_input_state_type_id);
	}
	return games_gamepad_view_input_state_type_id__once;
}

static void
_vala_GamesGamepadButtonPath_array_free (GamesGamepadButtonPath * array,
                                         gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			games_gamepad_button_path_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_games_gamepad_view_input_state_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (games_gamepad_view_input_state_free (var), NULL));
}

static GObject *
games_gamepad_view_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GamesGamepadView * self;
	RsvgHandle* _tmp0_;
	GamesGamepadButtonPath* _tmp1_;
	GamesGamepadButtonPath* _tmp2_;
	gint _tmp2__length1;
	GamesGamepadViewConfiguration _tmp3_ = {0};
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	parent_class = G_OBJECT_CLASS (games_gamepad_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadView);
	_tmp0_ = rsvg_handle_new ();
	_g_object_unref0 (self->priv->handle);
	self->priv->handle = _tmp0_;
	_tmp1_ = g_new0 (GamesGamepadButtonPath, 0);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 0;
	_g_free0 (_tmp3_.svg_path);
	_tmp3_.svg_path = "";
	_tmp3_.button_paths = (_vala_GamesGamepadButtonPath_array_free (_tmp3_.button_paths, _tmp3_.button_paths_length1), NULL);
	_tmp3_.button_paths = _tmp2_;
	_tmp3_.button_paths_length1 = 0;
	_tmp3_._button_paths_size_ = _tmp3_.button_paths_length1;
	games_gamepad_view_set_configuration (self, &_tmp3_);
	_tmp2_ = (_vala_GamesGamepadButtonPath_array_free (_tmp2_, _tmp2__length1), NULL);
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _games_gamepad_view_input_state_free0_);
	_g_hash_table_unref0 (self->priv->input_state);
	self->priv->input_state = _tmp6_;
	return obj;
}

static void
games_gamepad_view_class_init (GamesGamepadViewClass * klass,
                               gpointer klass_data)
{
	games_gamepad_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesGamepadView_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) games_gamepad_view_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_gamepad_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_gamepad_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = games_gamepad_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_gamepad_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAMEPAD_VIEW_CONFIGURATION_PROPERTY, games_gamepad_view_properties[GAMES_GAMEPAD_VIEW_CONFIGURATION_PROPERTY] = g_param_spec_boxed ("configuration", "configuration", "configuration", GAMES_TYPE_GAMEPAD_VIEW_CONFIGURATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
games_gamepad_view_instance_init (GamesGamepadView * self,
                                  gpointer klass)
{
	self->priv = games_gamepad_view_get_instance_private (self);
}

static void
games_gamepad_view_finalize (GObject * obj)
{
	GamesGamepadView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadView);
	_g_object_unref0 (self->priv->handle);
	_g_hash_table_unref0 (self->priv->input_state);
	games_gamepad_view_configuration_destroy (&self->priv->_configuration);
	G_OBJECT_CLASS (games_gamepad_view_parent_class)->finalize (obj);
}

static GType
games_gamepad_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGamepadViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_gamepad_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGamepadView), 0, (GInstanceInitFunc) games_gamepad_view_instance_init, NULL };
	GType games_gamepad_view_type_id;
	games_gamepad_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GamesGamepadView", &g_define_type_info, 0);
	GamesGamepadView_private_offset = g_type_add_instance_private (games_gamepad_view_type_id, sizeof (GamesGamepadViewPrivate));
	return games_gamepad_view_type_id;
}

GType
games_gamepad_view_get_type (void)
{
	static volatile gsize games_gamepad_view_type_id__once = 0;
	if (g_once_init_enter (&games_gamepad_view_type_id__once)) {
		GType games_gamepad_view_type_id;
		games_gamepad_view_type_id = games_gamepad_view_get_type_once ();
		g_once_init_leave (&games_gamepad_view_type_id__once, games_gamepad_view_type_id);
	}
	return games_gamepad_view_type_id__once;
}

static void
_vala_games_gamepad_view_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GamesGamepadView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadView);
	switch (property_id) {
		case GAMES_GAMEPAD_VIEW_CONFIGURATION_PROPERTY:
		{
			GamesGamepadViewConfiguration boxed;
			games_gamepad_view_get_configuration (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_gamepad_view_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GamesGamepadView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadView);
	switch (property_id) {
		case GAMES_GAMEPAD_VIEW_CONFIGURATION_PROPERTY:
		games_gamepad_view_set_configuration (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

