/* gamepad-browse.c generated by valac 0.56.8, the Vala compiler
 * generated from gamepad-browse.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <libmanette.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include "linux/input-event-codes.h"
#include <string.h>
#include "gnome-games.h"

#define GAMES_GAMEPAD_BROWSE_DEAD_ZONE 0.3

#define GAMES_TYPE_GAMEPAD_BROWSE (games_gamepad_browse_get_type ())
#define GAMES_GAMEPAD_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD_BROWSE, GamesGamepadBrowse))
#define GAMES_GAMEPAD_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD_BROWSE, GamesGamepadBrowseClass))
#define GAMES_IS_GAMEPAD_BROWSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD_BROWSE))
#define GAMES_IS_GAMEPAD_BROWSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD_BROWSE))
#define GAMES_GAMEPAD_BROWSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD_BROWSE, GamesGamepadBrowseClass))

typedef struct _GamesGamepadBrowse GamesGamepadBrowse;
typedef struct _GamesGamepadBrowseClass GamesGamepadBrowseClass;
typedef struct _GamesGamepadBrowsePrivate GamesGamepadBrowsePrivate;
typedef enum  {
	GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_UNKNOWN,
	GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_DIRECTIONAL_PAD,
	GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_ANALOG_STICK
} GamesGamepadBrowseCursorMovementSource;

#define GAMES_GAMEPAD_BROWSE_TYPE_CURSOR_MOVEMENT_SOURCE (games_gamepad_browse_cursor_movement_source_get_type ())
enum  {
	GAMES_GAMEPAD_BROWSE_0_PROPERTY,
	GAMES_GAMEPAD_BROWSE_NUM_PROPERTIES
};
static GParamSpec* games_gamepad_browse_properties[GAMES_GAMEPAD_BROWSE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GAMES_GAMEPAD_BROWSE_BROWSE_SIGNAL,
	GAMES_GAMEPAD_BROWSE_ACCEPT_SIGNAL,
	GAMES_GAMEPAD_BROWSE_CANCEL_SIGNAL,
	GAMES_GAMEPAD_BROWSE_NUM_SIGNALS
};
static guint games_gamepad_browse_signals[GAMES_GAMEPAD_BROWSE_NUM_SIGNALS] = {0};

struct _GamesGamepadBrowse {
	GObject parent_instance;
	GamesGamepadBrowsePrivate * priv;
};

struct _GamesGamepadBrowseClass {
	GObjectClass parent_class;
};

struct _GamesGamepadBrowsePrivate {
	GtkDirectionType cursor_direction;
	GamesGamepadBrowseCursorMovementSource cursor_movement_source;
	ManetteDevice* cursor_movement_device;
	gdouble cursor_speed;
	guint cursor_timeout;
};

static gint GamesGamepadBrowse_private_offset;
static gpointer games_gamepad_browse_parent_class = NULL;

VALA_EXTERN GType games_gamepad_browse_get_type (void) G_GNUC_CONST ;
static GType games_gamepad_browse_cursor_movement_source_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN gboolean games_gamepad_browse_gamepad_button_press_event (GamesGamepadBrowse* self,
                                                          ManetteEvent* event);
static gboolean games_gamepad_browse_move_cursor (GamesGamepadBrowse* self,
                                           GtkDirectionType direction,
                                           GamesGamepadBrowseCursorMovementSource source,
                                           ManetteDevice* device,
                                           gdouble speed);
VALA_EXTERN gboolean games_gamepad_browse_gamepad_button_release_event (GamesGamepadBrowse* self,
                                                            ManetteEvent* event);
static gboolean games_gamepad_browse_cancel_cursor_movement_for_direction (GamesGamepadBrowse* self,
                                                                    GtkDirectionType direction);
VALA_EXTERN gboolean games_gamepad_browse_gamepad_absolute_axis_event (GamesGamepadBrowse* self,
                                                           ManetteEvent* event);
VALA_EXTERN void games_gamepad_browse_cancel_cursor_movement (GamesGamepadBrowse* self);
static gboolean games_gamepad_browse_setup_cursor_cb (GamesGamepadBrowse* self);
static gboolean _games_gamepad_browse_setup_cursor_cb_gsource_func (gpointer self);
VALA_EXTERN GamesGamepadBrowse* games_gamepad_browse_new (void);
VALA_EXTERN GamesGamepadBrowse* games_gamepad_browse_construct (GType object_type);
static void g_cclosure_user_marshal_BOOLEAN__ENUM (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void games_gamepad_browse_finalize (GObject * obj);
static GType games_gamepad_browse_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_gamepad_browse_get_instance_private (GamesGamepadBrowse* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGamepadBrowse_private_offset);
}

static GType
games_gamepad_browse_cursor_movement_source_get_type_once (void)
{
	static const GEnumValue values[] = {{GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_UNKNOWN, "GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_UNKNOWN", "unknown"}, {GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_DIRECTIONAL_PAD, "GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_DIRECTIONAL_PAD", "directional-pad"}, {GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_ANALOG_STICK, "GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_ANALOG_STICK", "analog-stick"}, {0, NULL, NULL}};
	GType games_gamepad_browse_cursor_movement_source_type_id;
	games_gamepad_browse_cursor_movement_source_type_id = g_enum_register_static ("GamesGamepadBrowseCursorMovementSource", values);
	return games_gamepad_browse_cursor_movement_source_type_id;
}

static GType
games_gamepad_browse_cursor_movement_source_get_type (void)
{
	static volatile gsize games_gamepad_browse_cursor_movement_source_type_id__once = 0;
	if (g_once_init_enter (&games_gamepad_browse_cursor_movement_source_type_id__once)) {
		GType games_gamepad_browse_cursor_movement_source_type_id;
		games_gamepad_browse_cursor_movement_source_type_id = games_gamepad_browse_cursor_movement_source_get_type_once ();
		g_once_init_leave (&games_gamepad_browse_cursor_movement_source_type_id__once, games_gamepad_browse_cursor_movement_source_type_id);
	}
	return games_gamepad_browse_cursor_movement_source_type_id__once;
}

gboolean
games_gamepad_browse_gamepad_button_press_event (GamesGamepadBrowse* self,
                                                 ManetteEvent* event)
{
	guint16 button = 0U;
	guint16 _tmp0_ = 0U;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = manette_event_get_button (event, &_tmp0_);
	button = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	switch (button) {
		case BTN_A:
		{
			gboolean _tmp2_ = FALSE;
			g_signal_emit (self, games_gamepad_browse_signals[GAMES_GAMEPAD_BROWSE_ACCEPT_SIGNAL], 0, &_tmp2_);
			result = _tmp2_;
			return result;
		}
		case BTN_B:
		{
			gboolean _tmp3_ = FALSE;
			g_signal_emit (self, games_gamepad_browse_signals[GAMES_GAMEPAD_BROWSE_CANCEL_SIGNAL], 0, &_tmp3_);
			result = _tmp3_;
			return result;
		}
		case BTN_START:
		{
			gboolean _tmp4_ = FALSE;
			g_signal_emit (self, games_gamepad_browse_signals[GAMES_GAMEPAD_BROWSE_ACCEPT_SIGNAL], 0, &_tmp4_);
			result = _tmp4_;
			return result;
		}
		case BTN_DPAD_UP:
		{
			ManetteDevice* _tmp5_;
			_tmp5_ = manette_event_get_device (event);
			result = games_gamepad_browse_move_cursor (self, GTK_DIR_UP, GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_DIRECTIONAL_PAD, _tmp5_, 1.0);
			return result;
		}
		case BTN_DPAD_DOWN:
		{
			ManetteDevice* _tmp6_;
			_tmp6_ = manette_event_get_device (event);
			result = games_gamepad_browse_move_cursor (self, GTK_DIR_DOWN, GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_DIRECTIONAL_PAD, _tmp6_, 1.0);
			return result;
		}
		case BTN_DPAD_LEFT:
		{
			ManetteDevice* _tmp7_;
			_tmp7_ = manette_event_get_device (event);
			result = games_gamepad_browse_move_cursor (self, GTK_DIR_LEFT, GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_DIRECTIONAL_PAD, _tmp7_, 1.0);
			return result;
		}
		case BTN_DPAD_RIGHT:
		{
			ManetteDevice* _tmp8_;
			_tmp8_ = manette_event_get_device (event);
			result = games_gamepad_browse_move_cursor (self, GTK_DIR_RIGHT, GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_DIRECTIONAL_PAD, _tmp8_, 1.0);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

gboolean
games_gamepad_browse_gamepad_button_release_event (GamesGamepadBrowse* self,
                                                   ManetteEvent* event)
{
	guint16 button = 0U;
	guint16 _tmp0_ = 0U;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = manette_event_get_button (event, &_tmp0_);
	button = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	switch (button) {
		case BTN_DPAD_UP:
		{
			gboolean _tmp2_ = FALSE;
			if (self->priv->cursor_movement_source != GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_DIRECTIONAL_PAD) {
				_tmp2_ = TRUE;
			} else {
				ManetteDevice* _tmp3_;
				ManetteDevice* _tmp4_;
				_tmp3_ = self->priv->cursor_movement_device;
				_tmp4_ = manette_event_get_device (event);
				_tmp2_ = _tmp3_ != _tmp4_;
			}
			if (_tmp2_) {
				result = FALSE;
				return result;
			}
			result = games_gamepad_browse_cancel_cursor_movement_for_direction (self, GTK_DIR_UP);
			return result;
		}
		case BTN_DPAD_DOWN:
		{
			gboolean _tmp5_ = FALSE;
			if (self->priv->cursor_movement_source != GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_DIRECTIONAL_PAD) {
				_tmp5_ = TRUE;
			} else {
				ManetteDevice* _tmp6_;
				ManetteDevice* _tmp7_;
				_tmp6_ = self->priv->cursor_movement_device;
				_tmp7_ = manette_event_get_device (event);
				_tmp5_ = _tmp6_ != _tmp7_;
			}
			if (_tmp5_) {
				result = FALSE;
				return result;
			}
			result = games_gamepad_browse_cancel_cursor_movement_for_direction (self, GTK_DIR_DOWN);
			return result;
		}
		case BTN_DPAD_LEFT:
		{
			gboolean _tmp8_ = FALSE;
			if (self->priv->cursor_movement_source != GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_DIRECTIONAL_PAD) {
				_tmp8_ = TRUE;
			} else {
				ManetteDevice* _tmp9_;
				ManetteDevice* _tmp10_;
				_tmp9_ = self->priv->cursor_movement_device;
				_tmp10_ = manette_event_get_device (event);
				_tmp8_ = _tmp9_ != _tmp10_;
			}
			if (_tmp8_) {
				result = FALSE;
				return result;
			}
			result = games_gamepad_browse_cancel_cursor_movement_for_direction (self, GTK_DIR_LEFT);
			return result;
		}
		case BTN_DPAD_RIGHT:
		{
			gboolean _tmp11_ = FALSE;
			if (self->priv->cursor_movement_source != GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_DIRECTIONAL_PAD) {
				_tmp11_ = TRUE;
			} else {
				ManetteDevice* _tmp12_;
				ManetteDevice* _tmp13_;
				_tmp12_ = self->priv->cursor_movement_device;
				_tmp13_ = manette_event_get_device (event);
				_tmp11_ = _tmp12_ != _tmp13_;
			}
			if (_tmp11_) {
				result = FALSE;
				return result;
			}
			result = games_gamepad_browse_cancel_cursor_movement_for_direction (self, GTK_DIR_RIGHT);
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

gboolean
games_gamepad_browse_gamepad_absolute_axis_event (GamesGamepadBrowse* self,
                                                  ManetteEvent* event)
{
	guint16 axis = 0U;
	gdouble value = 0.0;
	guint16 _tmp0_ = 0U;
	gdouble _tmp1_ = 0.0;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = manette_event_get_absolute (event, &_tmp0_, &_tmp1_);
	axis = _tmp0_;
	value = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	switch (axis) {
		case ABS_X:
		{
			if (value > GAMES_GAMEPAD_BROWSE_DEAD_ZONE) {
				ManetteDevice* _tmp3_;
				_tmp3_ = manette_event_get_device (event);
				result = games_gamepad_browse_move_cursor (self, GTK_DIR_RIGHT, GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_ANALOG_STICK, _tmp3_, value * value);
				return result;
			} else {
				if (value < (-GAMES_GAMEPAD_BROWSE_DEAD_ZONE)) {
					ManetteDevice* _tmp4_;
					_tmp4_ = manette_event_get_device (event);
					result = games_gamepad_browse_move_cursor (self, GTK_DIR_LEFT, GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_ANALOG_STICK, _tmp4_, value * value);
					return result;
				} else {
					gboolean _tmp5_ = FALSE;
					gboolean _tmp6_ = FALSE;
					if (self->priv->cursor_movement_source == GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_ANALOG_STICK) {
						ManetteDevice* _tmp7_;
						ManetteDevice* _tmp8_;
						_tmp7_ = self->priv->cursor_movement_device;
						_tmp8_ = manette_event_get_device (event);
						_tmp6_ = _tmp7_ == _tmp8_;
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						gboolean _tmp9_ = FALSE;
						if (self->priv->cursor_direction == GTK_DIR_LEFT) {
							_tmp9_ = TRUE;
						} else {
							_tmp9_ = self->priv->cursor_direction == GTK_DIR_RIGHT;
						}
						_tmp5_ = _tmp9_;
					} else {
						_tmp5_ = FALSE;
					}
					if (_tmp5_) {
						games_gamepad_browse_cancel_cursor_movement (self);
					}
				}
			}
			result = FALSE;
			return result;
		}
		case ABS_Y:
		{
			if (value > GAMES_GAMEPAD_BROWSE_DEAD_ZONE) {
				ManetteDevice* _tmp10_;
				_tmp10_ = manette_event_get_device (event);
				result = games_gamepad_browse_move_cursor (self, GTK_DIR_DOWN, GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_ANALOG_STICK, _tmp10_, value * value);
				return result;
			} else {
				if (value < (-GAMES_GAMEPAD_BROWSE_DEAD_ZONE)) {
					ManetteDevice* _tmp11_;
					_tmp11_ = manette_event_get_device (event);
					result = games_gamepad_browse_move_cursor (self, GTK_DIR_UP, GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_ANALOG_STICK, _tmp11_, value * value);
					return result;
				} else {
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
					if (self->priv->cursor_movement_source == GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_ANALOG_STICK) {
						ManetteDevice* _tmp14_;
						ManetteDevice* _tmp15_;
						_tmp14_ = self->priv->cursor_movement_device;
						_tmp15_ = manette_event_get_device (event);
						_tmp13_ = _tmp14_ == _tmp15_;
					} else {
						_tmp13_ = FALSE;
					}
					if (_tmp13_) {
						gboolean _tmp16_ = FALSE;
						if (self->priv->cursor_direction == GTK_DIR_UP) {
							_tmp16_ = TRUE;
						} else {
							_tmp16_ = self->priv->cursor_direction == GTK_DIR_DOWN;
						}
						_tmp12_ = _tmp16_;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						games_gamepad_browse_cancel_cursor_movement (self);
					}
				}
			}
			result = FALSE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_games_gamepad_browse_setup_cursor_cb_gsource_func (gpointer self)
{
	gboolean result;
	result = games_gamepad_browse_setup_cursor_cb ((GamesGamepadBrowse*) self);
	return result;
}

static gboolean
games_gamepad_browse_move_cursor (GamesGamepadBrowse* self,
                                  GtkDirectionType direction,
                                  GamesGamepadBrowseCursorMovementSource source,
                                  ManetteDevice* device,
                                  gdouble speed)
{
	ManetteDevice* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	self->priv->cursor_movement_source = source;
	_tmp0_ = _g_object_ref0 (device);
	_g_object_unref0 (self->priv->cursor_movement_device);
	self->priv->cursor_movement_device = _tmp0_;
	self->priv->cursor_speed = speed;
	if (self->priv->cursor_timeout != ((guint) 0)) {
		_tmp1_ = self->priv->cursor_direction == direction;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	if (self->priv->cursor_timeout != ((guint) 0)) {
		g_source_remove (self->priv->cursor_timeout);
	}
	self->priv->cursor_timeout = (guint) 0;
	self->priv->cursor_direction = direction;
	g_signal_emit (self, games_gamepad_browse_signals[GAMES_GAMEPAD_BROWSE_BROWSE_SIGNAL], 0, self->priv->cursor_direction, &_tmp2_);
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	self->priv->cursor_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _games_gamepad_browse_setup_cursor_cb_gsource_func, g_object_ref (self), g_object_unref);
	result = TRUE;
	return result;
}

static gboolean
games_gamepad_browse_setup_cursor_cb (GamesGamepadBrowse* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->cursor_speed == ((gdouble) 0)) {
		games_gamepad_browse_cancel_cursor_movement (self);
		result = FALSE;
		return result;
	}
	g_signal_emit (self, games_gamepad_browse_signals[GAMES_GAMEPAD_BROWSE_BROWSE_SIGNAL], 0, self->priv->cursor_direction, &_tmp0_);
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	self->priv->cursor_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (30 / self->priv->cursor_speed), _games_gamepad_browse_setup_cursor_cb_gsource_func, g_object_ref (self), g_object_unref);
	result = FALSE;
	return result;
}

void
games_gamepad_browse_cancel_cursor_movement (GamesGamepadBrowse* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->cursor_timeout != ((guint) 0)) {
		g_source_remove (self->priv->cursor_timeout);
	}
	self->priv->cursor_movement_source = GAMES_GAMEPAD_BROWSE_CURSOR_MOVEMENT_SOURCE_UNKNOWN;
	_g_object_unref0 (self->priv->cursor_movement_device);
	self->priv->cursor_movement_device = NULL;
	self->priv->cursor_timeout = (guint) 0;
	return;
}

static gboolean
games_gamepad_browse_cancel_cursor_movement_for_direction (GamesGamepadBrowse* self,
                                                           GtkDirectionType direction)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->cursor_direction != direction) {
		result = FALSE;
		return result;
	}
	games_gamepad_browse_cancel_cursor_movement (self);
	result = TRUE;
	return result;
}

GamesGamepadBrowse*
games_gamepad_browse_construct (GType object_type)
{
	GamesGamepadBrowse * self = NULL;
	self = (GamesGamepadBrowse*) g_object_new (object_type, NULL);
	return self;
}

GamesGamepadBrowse*
games_gamepad_browse_new (void)
{
	return games_gamepad_browse_construct (GAMES_TYPE_GAMEPAD_BROWSE);
}

static void
g_cclosure_user_marshal_BOOLEAN__ENUM (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__ENUM) (gpointer data1, gint arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__ENUM callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__ENUM) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_enum (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}

static void
g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}

static void
games_gamepad_browse_class_init (GamesGamepadBrowseClass * klass,
                                 gpointer klass_data)
{
	games_gamepad_browse_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesGamepadBrowse_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_gamepad_browse_finalize;
	games_gamepad_browse_signals[GAMES_GAMEPAD_BROWSE_BROWSE_SIGNAL] = g_signal_new ("browse", GAMES_TYPE_GAMEPAD_BROWSE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__ENUM, G_TYPE_BOOLEAN, 1, gtk_direction_type_get_type ());
	games_gamepad_browse_signals[GAMES_GAMEPAD_BROWSE_ACCEPT_SIGNAL] = g_signal_new ("accept", GAMES_TYPE_GAMEPAD_BROWSE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
	games_gamepad_browse_signals[GAMES_GAMEPAD_BROWSE_CANCEL_SIGNAL] = g_signal_new ("cancel", GAMES_TYPE_GAMEPAD_BROWSE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
}

static void
games_gamepad_browse_instance_init (GamesGamepadBrowse * self,
                                    gpointer klass)
{
	self->priv = games_gamepad_browse_get_instance_private (self);
}

static void
games_gamepad_browse_finalize (GObject * obj)
{
	GamesGamepadBrowse * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMEPAD_BROWSE, GamesGamepadBrowse);
	_g_object_unref0 (self->priv->cursor_movement_device);
	G_OBJECT_CLASS (games_gamepad_browse_parent_class)->finalize (obj);
}

static GType
games_gamepad_browse_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGamepadBrowseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_gamepad_browse_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGamepadBrowse), 0, (GInstanceInitFunc) games_gamepad_browse_instance_init, NULL };
	GType games_gamepad_browse_type_id;
	games_gamepad_browse_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesGamepadBrowse", &g_define_type_info, 0);
	GamesGamepadBrowse_private_offset = g_type_add_instance_private (games_gamepad_browse_type_id, sizeof (GamesGamepadBrowsePrivate));
	return games_gamepad_browse_type_id;
}

GType
games_gamepad_browse_get_type (void)
{
	static volatile gsize games_gamepad_browse_type_id__once = 0;
	if (g_once_init_enter (&games_gamepad_browse_type_id__once)) {
		GType games_gamepad_browse_type_id;
		games_gamepad_browse_type_id = games_gamepad_browse_get_type_once ();
		g_once_init_leave (&games_gamepad_browse_type_id__once, games_gamepad_browse_type_id);
	}
	return games_gamepad_browse_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

