/* flash-box.c generated by valac 0.56.8, the Vala compiler
 * generated from flash-box.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <string.h>
#include "gnome-games.h"

#define GAMES_FLASH_BOX_FLASH_DURATION ((gint64) 500)

#define GAMES_TYPE_FLASH_BOX (games_flash_box_get_type ())
#define GAMES_FLASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_FLASH_BOX, GamesFlashBox))
#define GAMES_FLASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_FLASH_BOX, GamesFlashBoxClass))
#define GAMES_IS_FLASH_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_FLASH_BOX))
#define GAMES_IS_FLASH_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_FLASH_BOX))
#define GAMES_FLASH_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_FLASH_BOX, GamesFlashBoxClass))

typedef struct _GamesFlashBox GamesFlashBox;
typedef struct _GamesFlashBoxClass GamesFlashBoxClass;
typedef struct _GamesFlashBoxPrivate GamesFlashBoxPrivate;
enum  {
	GAMES_FLASH_BOX_0_PROPERTY,
	GAMES_FLASH_BOX_NUM_PROPERTIES
};
static GParamSpec* games_flash_box_properties[GAMES_FLASH_BOX_NUM_PROPERTIES];

struct _GamesFlashBox {
	GtkWidget parent_instance;
	GamesFlashBoxPrivate * priv;
};

struct _GamesFlashBoxClass {
	GtkWidgetClass parent_class;
};

struct _GamesFlashBoxPrivate {
	gint64 flash_start_time;
	guint tick_callback_id;
};

static gint GamesFlashBox_private_offset;
static gpointer games_flash_box_parent_class = NULL;

VALA_EXTERN GType games_flash_box_get_type (void) G_GNUC_CONST ;
static gboolean games_flash_box_real_draw (GtkWidget* base,
                                    cairo_t* cr);
VALA_EXTERN void games_flash_box_flash (GamesFlashBox* self);
static gboolean games_flash_box_on_tick (GamesFlashBox* self,
                                  GtkWidget* widget,
                                  GdkFrameClock* frame_clock);
static gboolean _games_flash_box_on_tick_gtk_tick_callback (GtkWidget* widget,
                                                     GdkFrameClock* frame_clock,
                                                     gpointer self);
static gdouble games_flash_box_ease_out_quad (GamesFlashBox* self,
                                       gdouble t);
static void games_flash_box_real_destroy (GtkWidget* base);
VALA_EXTERN GamesFlashBox* games_flash_box_new (void);
VALA_EXTERN GamesFlashBox* games_flash_box_construct (GType object_type);
static GObject * games_flash_box_constructor (GType type,
                                       guint n_construct_properties,
                                       GObjectConstructParam * construct_properties);
static void games_flash_box_finalize (GObject * obj);
static GType games_flash_box_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_flash_box_get_instance_private (GamesFlashBox* self)
{
	return G_STRUCT_MEMBER_P (self, GamesFlashBox_private_offset);
}

static gboolean
games_flash_box_real_draw (GtkWidget* base,
                           cairo_t* cr)
{
	GamesFlashBox * self;
	gint width = 0;
	gint height = 0;
	GtkStyleContext* _tmp0_;
	gboolean result;
	self = (GamesFlashBox*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_render_background (_tmp0_, cr, (gdouble) 0, (gdouble) 0, (gdouble) width, (gdouble) height);
	result = TRUE;
	return result;
}

static gboolean
_games_flash_box_on_tick_gtk_tick_callback (GtkWidget* widget,
                                            GdkFrameClock* frame_clock,
                                            gpointer self)
{
	gboolean result;
	result = games_flash_box_on_tick ((GamesFlashBox*) self, widget, frame_clock);
	return result;
}

void
games_flash_box_flash (GamesFlashBox* self)
{
	GdkFrameClock* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->tick_callback_id == ((guint) 0)) {
		self->priv->tick_callback_id = gtk_widget_add_tick_callback ((GtkWidget*) self, _games_flash_box_on_tick_gtk_tick_callback, g_object_ref (self), g_object_unref);
		gtk_widget_set_visible ((GtkWidget*) self, TRUE);
	}
	_tmp0_ = gtk_widget_get_frame_clock ((GtkWidget*) self);
	self->priv->flash_start_time = gdk_frame_clock_get_frame_time (_tmp0_) / 1000;
	gtk_widget_set_opacity ((GtkWidget*) self, (gdouble) 1);
}

static gboolean
games_flash_box_on_tick (GamesFlashBox* self,
                         GtkWidget* widget,
                         GdkFrameClock* frame_clock)
{
	gint64 frame_time = 0LL;
	gdouble t = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (frame_clock != NULL, FALSE);
	frame_time = gdk_frame_clock_get_frame_time (frame_clock) / 1000;
	t = ((gdouble) (frame_time - self->priv->flash_start_time)) / GAMES_FLASH_BOX_FLASH_DURATION;
	gtk_widget_set_opacity ((GtkWidget*) self, 1 - games_flash_box_ease_out_quad (self, t));
	if (t >= ((gdouble) 1)) {
		gtk_widget_set_opacity ((GtkWidget*) self, (gdouble) 0);
		gtk_widget_set_visible ((GtkWidget*) self, FALSE);
		self->priv->tick_callback_id = (guint) 0;
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gdouble
games_flash_box_ease_out_quad (GamesFlashBox* self,
                               gdouble t)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = t * (2 - t);
	return result;
}

static void
games_flash_box_real_destroy (GtkWidget* base)
{
	GamesFlashBox * self;
	self = (GamesFlashBox*) base;
	if (self->priv->tick_callback_id != ((guint) 0)) {
		gtk_widget_remove_tick_callback ((GtkWidget*) self, self->priv->tick_callback_id);
	}
}

GamesFlashBox*
games_flash_box_construct (GType object_type)
{
	GamesFlashBox * self = NULL;
	self = (GamesFlashBox*) gtk_widget_new (object_type, NULL);
	return self;
}

GamesFlashBox*
games_flash_box_new (void)
{
	return games_flash_box_construct (GAMES_TYPE_FLASH_BOX);
}

static GObject *
games_flash_box_constructor (GType type,
                             guint n_construct_properties,
                             GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GamesFlashBox * self;
	parent_class = G_OBJECT_CLASS (games_flash_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_FLASH_BOX, GamesFlashBox);
	gtk_widget_set_has_window ((GtkWidget*) self, FALSE);
	gtk_widget_set_opacity ((GtkWidget*) self, (gdouble) 0);
	return obj;
}

static void
games_flash_box_class_init (GamesFlashBoxClass * klass,
                            gpointer klass_data)
{
	games_flash_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesFlashBox_private_offset);
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget*, cairo_t*)) games_flash_box_real_draw;
	((GtkWidgetClass *) klass)->destroy = (void (*) (GtkWidget*)) games_flash_box_real_destroy;
	G_OBJECT_CLASS (klass)->constructor = games_flash_box_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_flash_box_finalize;
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "gamesflashbox");
}

static void
games_flash_box_instance_init (GamesFlashBox * self,
                               gpointer klass)
{
	self->priv = games_flash_box_get_instance_private (self);
}

static void
games_flash_box_finalize (GObject * obj)
{
	GamesFlashBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_FLASH_BOX, GamesFlashBox);
	G_OBJECT_CLASS (games_flash_box_parent_class)->finalize (obj);
}

static GType
games_flash_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesFlashBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_flash_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesFlashBox), 0, (GInstanceInitFunc) games_flash_box_instance_init, NULL };
	GType games_flash_box_type_id;
	games_flash_box_type_id = g_type_register_static (gtk_widget_get_type (), "GamesFlashBox", &g_define_type_info, 0);
	GamesFlashBox_private_offset = g_type_add_instance_private (games_flash_box_type_id, sizeof (GamesFlashBoxPrivate));
	return games_flash_box_type_id;
}

GType
games_flash_box_get_type (void)
{
	static volatile gsize games_flash_box_type_id__once = 0;
	if (g_once_init_enter (&games_flash_box_type_id__once)) {
		GType games_flash_box_type_id;
		games_flash_box_type_id = games_flash_box_get_type_once ();
		g_once_init_leave (&games_flash_box_type_id__once, games_flash_box_type_id);
	}
	return games_flash_box_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

