/* application.c generated by valac 0.56.8, the Vala compiler
 * generated from application.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <glib-object.h>
#include <handy.h>
#include <glib.h>
#include <libmanette.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "config.h"
#include <glib-unix.h>
#include <signal.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <libtracker-sparql/tracker-sparql.h>

#define GAMES_APPLICATION_HELP_URI "https://wiki.gnome.org/Apps/Games/Documentation"
#define GAMES_APPLICATION_TEST_QUERY "SELECT nie:isStoredAs(?f) WHERE { GRAPH tracker:Software { ?f fts:matc" \
"h 'test query to check tracker' } }"

#define GAMES_TYPE_DATABASE (games_database_get_type ())
#define GAMES_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DATABASE, GamesDatabase))
#define GAMES_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DATABASE, GamesDatabaseClass))
#define GAMES_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DATABASE))
#define GAMES_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DATABASE))
#define GAMES_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DATABASE, GamesDatabaseClass))

typedef struct _GamesDatabase GamesDatabase;
typedef struct _GamesDatabaseClass GamesDatabaseClass;

#define GAMES_TYPE_PREFERENCES_WINDOW (games_preferences_window_get_type ())
#define GAMES_PREFERENCES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PREFERENCES_WINDOW, GamesPreferencesWindow))
#define GAMES_PREFERENCES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PREFERENCES_WINDOW, GamesPreferencesWindowClass))
#define GAMES_IS_PREFERENCES_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PREFERENCES_WINDOW))
#define GAMES_IS_PREFERENCES_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PREFERENCES_WINDOW))
#define GAMES_PREFERENCES_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PREFERENCES_WINDOW, GamesPreferencesWindowClass))

typedef struct _GamesPreferencesWindow GamesPreferencesWindow;
typedef struct _GamesPreferencesWindowClass GamesPreferencesWindowClass;

#define GAMES_TYPE_APPLICATION_WINDOW (games_application_window_get_type ())
#define GAMES_APPLICATION_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_APPLICATION_WINDOW, GamesApplicationWindow))
#define GAMES_APPLICATION_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_APPLICATION_WINDOW, GamesApplicationWindowClass))
#define GAMES_IS_APPLICATION_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_APPLICATION_WINDOW))
#define GAMES_IS_APPLICATION_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_APPLICATION_WINDOW))
#define GAMES_APPLICATION_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_APPLICATION_WINDOW, GamesApplicationWindowClass))

typedef struct _GamesApplicationWindow GamesApplicationWindow;
typedef struct _GamesApplicationWindowClass GamesApplicationWindowClass;

#define GAMES_TYPE_GAME_COLLECTION (games_game_collection_get_type ())
#define GAMES_GAME_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_COLLECTION, GamesGameCollection))
#define GAMES_GAME_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_COLLECTION, GamesGameCollectionClass))
#define GAMES_IS_GAME_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_COLLECTION))
#define GAMES_IS_GAME_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_COLLECTION))
#define GAMES_GAME_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_COLLECTION, GamesGameCollectionClass))

typedef struct _GamesGameCollection GamesGameCollection;
typedef struct _GamesGameCollectionClass GamesGameCollectionClass;

#define GAMES_TYPE_GAME_MODEL (games_game_model_get_type ())
#define GAMES_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModel))
#define GAMES_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))
#define GAMES_IS_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_MODEL))
#define GAMES_IS_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_MODEL))
#define GAMES_GAME_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))

typedef struct _GamesGameModel GamesGameModel;
typedef struct _GamesGameModelClass GamesGameModelClass;

#define GAMES_TYPE_COLLECTION_MANAGER (games_collection_manager_get_type ())
#define GAMES_COLLECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COLLECTION_MANAGER, GamesCollectionManager))
#define GAMES_COLLECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_COLLECTION_MANAGER, GamesCollectionManagerClass))
#define GAMES_IS_COLLECTION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COLLECTION_MANAGER))
#define GAMES_IS_COLLECTION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_COLLECTION_MANAGER))
#define GAMES_COLLECTION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_COLLECTION_MANAGER, GamesCollectionManagerClass))

typedef struct _GamesCollectionManager GamesCollectionManager;
typedef struct _GamesCollectionManagerClass GamesCollectionManagerClass;

#define GAMES_TYPE_COLLECTION_MODEL (games_collection_model_get_type ())
#define GAMES_COLLECTION_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COLLECTION_MODEL, GamesCollectionModel))
#define GAMES_COLLECTION_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_COLLECTION_MODEL, GamesCollectionModelClass))
#define GAMES_IS_COLLECTION_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COLLECTION_MODEL))
#define GAMES_IS_COLLECTION_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_COLLECTION_MODEL))
#define GAMES_COLLECTION_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_COLLECTION_MODEL, GamesCollectionModelClass))

typedef struct _GamesCollectionModel GamesCollectionModel;
typedef struct _GamesCollectionModelClass GamesCollectionModelClass;
enum  {
	GAMES_APPLICATION_0_PROPERTY,
	GAMES_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* games_application_properties[GAMES_APPLICATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_source_unref0(var) ((var == NULL) ? NULL : (var = (g_source_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _games_uri_unref0(var) ((var == NULL) ? NULL : (var = (games_uri_unref (var), NULL)))
typedef struct _GamesApplicationRunByUidData GamesApplicationRunByUidData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_dict_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_dict_unref (var), NULL)))

#define GAMES_TYPE_COLLECTION (games_collection_get_type ())
#define GAMES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COLLECTION, GamesCollection))
#define GAMES_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COLLECTION))
#define GAMES_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_COLLECTION, GamesCollectionIface))

typedef struct _GamesCollection GamesCollection;
typedef struct _GamesCollectionIface GamesCollectionIface;
typedef enum  {
	GAMES_COLLECTION_TYPE_AUTO,
	GAMES_COLLECTION_TYPE_USER,
	GAMES_COLLECTION_TYPE_PLACEHOLDER
} GamesCollectionType;

#define GAMES_TYPE_COLLECTION_TYPE (games_collection_type_get_type ())

#define GAMES_TYPE_PLATFORM_REGISTER (games_platform_register_get_type ())
#define GAMES_PLATFORM_REGISTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLATFORM_REGISTER, GamesPlatformRegister))
#define GAMES_PLATFORM_REGISTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLATFORM_REGISTER, GamesPlatformRegisterClass))
#define GAMES_IS_PLATFORM_REGISTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLATFORM_REGISTER))
#define GAMES_IS_PLATFORM_REGISTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLATFORM_REGISTER))
#define GAMES_PLATFORM_REGISTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLATFORM_REGISTER, GamesPlatformRegisterClass))

typedef struct _GamesPlatformRegister GamesPlatformRegister;
typedef struct _GamesPlatformRegisterClass GamesPlatformRegisterClass;

#define GAMES_TYPE_RETRO_SIMPLE_TYPE (games_retro_simple_type_get_type ())
typedef struct _GamesRetroSimpleType GamesRetroSimpleType;

#define GAMES_TYPE_RETRO_SIMPLE_GAME_URI_ADAPTER (games_retro_simple_game_uri_adapter_get_type ())
#define GAMES_RETRO_SIMPLE_GAME_URI_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_SIMPLE_GAME_URI_ADAPTER, GamesRetroSimpleGameUriAdapter))
#define GAMES_RETRO_SIMPLE_GAME_URI_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_SIMPLE_GAME_URI_ADAPTER, GamesRetroSimpleGameUriAdapterClass))
#define GAMES_IS_RETRO_SIMPLE_GAME_URI_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_SIMPLE_GAME_URI_ADAPTER))
#define GAMES_IS_RETRO_SIMPLE_GAME_URI_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_SIMPLE_GAME_URI_ADAPTER))
#define GAMES_RETRO_SIMPLE_GAME_URI_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_SIMPLE_GAME_URI_ADAPTER, GamesRetroSimpleGameUriAdapterClass))

typedef struct _GamesRetroSimpleGameUriAdapter GamesRetroSimpleGameUriAdapter;
typedef struct _GamesRetroSimpleGameUriAdapterClass GamesRetroSimpleGameUriAdapterClass;

#define GAMES_TYPE_PLUGIN_REGISTER (games_plugin_register_get_type ())
#define GAMES_PLUGIN_REGISTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLUGIN_REGISTER, GamesPluginRegister))
#define GAMES_PLUGIN_REGISTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLUGIN_REGISTER, GamesPluginRegisterClass))
#define GAMES_IS_PLUGIN_REGISTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLUGIN_REGISTER))
#define GAMES_IS_PLUGIN_REGISTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLUGIN_REGISTER))
#define GAMES_PLUGIN_REGISTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLUGIN_REGISTER, GamesPluginRegisterClass))

typedef struct _GamesPluginRegister GamesPluginRegister;
typedef struct _GamesPluginRegisterClass GamesPluginRegisterClass;

#define GAMES_TYPE_PLUGIN_REGISTER_ITERATOR (games_plugin_register_iterator_get_type ())
#define GAMES_PLUGIN_REGISTER_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLUGIN_REGISTER_ITERATOR, GamesPluginRegisterIterator))
#define GAMES_PLUGIN_REGISTER_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLUGIN_REGISTER_ITERATOR, GamesPluginRegisterIteratorClass))
#define GAMES_IS_PLUGIN_REGISTER_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLUGIN_REGISTER_ITERATOR))
#define GAMES_IS_PLUGIN_REGISTER_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLUGIN_REGISTER_ITERATOR))
#define GAMES_PLUGIN_REGISTER_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLUGIN_REGISTER_ITERATOR, GamesPluginRegisterIteratorClass))

typedef struct _GamesPluginRegisterIterator GamesPluginRegisterIterator;
typedef struct _GamesPluginRegisterIteratorClass GamesPluginRegisterIteratorClass;

#define GAMES_TYPE_PLUGIN_REGISTRAR (games_plugin_registrar_get_type ())
#define GAMES_PLUGIN_REGISTRAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLUGIN_REGISTRAR, GamesPluginRegistrar))
#define GAMES_PLUGIN_REGISTRAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLUGIN_REGISTRAR, GamesPluginRegistrarClass))
#define GAMES_IS_PLUGIN_REGISTRAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLUGIN_REGISTRAR))
#define GAMES_IS_PLUGIN_REGISTRAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLUGIN_REGISTRAR))
#define GAMES_PLUGIN_REGISTRAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLUGIN_REGISTRAR, GamesPluginRegistrarClass))

typedef struct _GamesPluginRegistrar GamesPluginRegistrar;
typedef struct _GamesPluginRegistrarClass GamesPluginRegistrarClass;

#define GAMES_TYPE_PLUGIN_ERROR (games_plugin_error_get_type ())
#define _games_plugin_register_iterator_unref0(var) ((var == NULL) ? NULL : (var = (games_plugin_register_iterator_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _GamesApplicationLoadGameListData GamesApplicationLoadGameListData;
typedef struct _Block23Data Block23Data;
typedef struct _GamesApplicationQuitApplicationInternalData GamesApplicationQuitApplicationInternalData;
#define __vala_ManetteMonitorIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_ManetteMonitorIter_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GamesApplicationPrivate {
	GamesDatabase* database;
	GamesPreferencesWindow* preferences_window;
	GamesApplicationWindow* window;
	gboolean game_list_loaded;
	GamesGameCollection* game_collection;
	GamesGameModel* game_model;
	GamesCoverLoader* cover_loader;
	GamesCollectionManager* collection_manager;
	GamesCollectionModel* collection_model;
	ManetteMonitor* manette_monitor;
	gboolean tracker_failed;
	gboolean initialized;
};

struct _GamesApplicationRunByUidData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesApplication* self;
	gchar* uid;
	GamesGame* game;
	GamesGameCollection* _tmp0_;
	GamesGame* _tmp1_;
	GamesGame* _tmp2_;
	GamesApplicationWindow* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GamesApplicationWindow* _tmp6_;
	GamesGame* _tmp7_;
};

struct _GamesCollectionIface {
	GTypeInterface parent_iface;
	void (*load) (GamesCollection* self);
	gchar* (*get_id) (GamesCollection* self);
	gboolean (*get_hide_stars) (GamesCollection* self);
	GamesGameModel* (*get_game_model) (GamesCollection* self);
	GamesCollectionType (*get_collection_type) (GamesCollection* self);
	void (*add_games) (GamesCollection* self, GamesGame** games, gint games_length1);
	void (*remove_games) (GamesCollection* self, GamesGame** games, gint games_length1);
	void (*on_game_added) (GamesCollection* self, GamesGame* game);
	void (*on_game_removed) (GamesCollection* self, GamesGame* game);
	void (*on_game_replaced) (GamesCollection* self, GamesGame* game, GamesGame* prev_game);
	gboolean (*get_is_empty) (GamesCollection* self);
	const gchar* (*get_title) (GamesCollection* self);
};

struct _GamesRetroSimpleType {
	gchar* mime_type;
	gboolean search_mime_type;
	gchar* platform;
	gchar* prefix;
};

typedef enum  {
	GAMES_PLUGIN_ERROR_INVALID_PLUGIN_DESCRIPTOR,
	GAMES_PLUGIN_ERROR_NOT_A_PLUGIN
} GamesPluginError;
#define GAMES_PLUGIN_ERROR games_plugin_error_quark ()

struct _GamesApplicationLoadGameListData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesApplication* self;
	GamesGameCollection* _tmp0_;
	GamesGameCollection* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GamesApplicationWindow* _tmp4_;
	GamesApplicationWindow* _tmp5_;
};

struct _Block23Data {
	int _ref_count_;
	GamesApplication* self;
	GtkAboutDialog* dialog;
};

struct _GamesApplicationQuitApplicationInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesApplication* self;
	GamesApplicationWindow* _tmp0_;
	gboolean _tmp1_;
	GamesApplicationWindow* _tmp2_;
	GamesApplicationWindow* _tmp3_;
};

static gint GamesApplication_private_offset;
static gpointer games_application_parent_class = NULL;
static gboolean* games_application_is_flatpak;
static gboolean* games_application_is_flatpak = NULL;

VALA_EXTERN GType games_database_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_preferences_window_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_application_window_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_game_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_game_model_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_manager_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_model_get_type (void) G_GNUC_CONST ;
static void games_application_preferences (GamesApplication* self);
static void _games_application_preferences_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void games_application_help (GamesApplication* self);
static void _games_application_help_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static void games_application_about (GamesApplication* self);
static void _games_application_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void games_application_quit_application (GamesApplication* self);
static void _games_application_quit_application_gsimple_action_activate_callback (GSimpleAction* action,
                                                                           GVariant* parameter,
                                                                           gpointer self);
static void _games_application_add_game_files_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
VALA_EXTERN GamesApplication* games_application_new (void);
VALA_EXTERN GamesApplication* games_application_construct (GType object_type);
static void games_application_add_actions (GamesApplication* self);
static void games_application_add_signal_handlers (GamesApplication* self);
static gboolean __lambda69_ (GamesApplication* self);
static gboolean ___lambda69__gsource_func (gpointer self);
static void games_application_make_data_dir (GamesApplication* self);
VALA_EXTERN void games_migrator_bump_to_latest_version (void);
static gboolean* _bool_dup (gboolean* self);
VALA_EXTERN gchar** games_game_collection_get_accepted_mime_types (GamesGameCollection* self,
                                                       gint* result_length1);
static void games_application_add_cached_uri (GamesApplication* self,
                                       GamesUri* uri);
static void _g_free0_ (gpointer var);
static inline void _g_slist_free__g_free0_ (GSList* self);
static void games_application_real_open (GApplication* base,
                                  GFile** files,
                                  gint files_length1,
                                  const gchar* hint);
static void _vala_array_add36 (GamesUri** * array,
                        gint* length,
                        gint* size,
                        GamesUri* value);
static GamesGame* games_application_game_for_uris (GamesApplication* self,
                                            GamesUri** uris,
                                            gint uris_length1);
VALA_EXTERN void games_application_window_show_error (GamesApplicationWindow* self,
                                          const gchar* error_message);
VALA_EXTERN void games_application_window_run_game (GamesApplicationWindow* self,
                                        GamesGame* game,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN void games_application_window_run_game_finish (GamesApplicationWindow* self,
                                               GAsyncResult* _res_);
static void games_application_real_startup (GApplication* base);
static GtkCssProvider* games_application_load_css (const gchar* css);
static void games_application_run_by_uid_data_free (gpointer _data);
static void games_application_run_by_uid (GamesApplication* self,
                                   const gchar* uid,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
static void games_application_run_by_uid_finish (GamesApplication* self,
                                          GAsyncResult* _res_);
static gboolean games_application_run_by_uid_co (GamesApplicationRunByUidData* _data_);
VALA_EXTERN void games_game_collection_query_game_for_uid (GamesGameCollection* self,
                                               const gchar* uid,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN GamesGame* games_game_collection_query_game_for_uid_finish (GamesGameCollection* self,
                                                            GAsyncResult* _res_);
static void games_application_run_by_uid_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static gint games_application_real_command_line (GApplication* base,
                                          GApplicationCommandLine* command_line);
VALA_EXTERN void games_application_window_run_search (GamesApplicationWindow* self,
                                          const gchar* query);
static void _vala_array_add37 (GFile** * array,
                        gint* length,
                        gint* size,
                        GFile* value);
static void games_application_real_activate (GApplication* base);
static void games_application_init_game_sources (GamesApplication* self);
VALA_EXTERN GamesGameModel* games_game_model_new (void);
VALA_EXTERN GamesGameModel* games_game_model_construct (GType object_type);
VALA_EXTERN void games_game_model_add_game (GamesGameModel* self,
                                GamesGame* game);
static void _games_game_model_add_game_games_game_collection_game_added (GamesGameCollection* _sender,
                                                                  GamesGame* game,
                                                                  gpointer self);
VALA_EXTERN void games_game_model_replace_game (GamesGameModel* self,
                                    GamesGame* game,
                                    GamesGame* prev_game);
static void _games_game_model_replace_game_games_game_collection_game_replaced (GamesGameCollection* _sender,
                                                                         GamesGame* game,
                                                                         GamesGame* prev_game,
                                                                         gpointer self);
VALA_EXTERN void games_game_model_remove_game (GamesGameModel* self,
                                   GamesGame* game);
static void _games_game_model_remove_game_games_game_collection_game_removed (GamesGameCollection* _sender,
                                                                       GamesGame* game,
                                                                       gpointer self);
VALA_EXTERN GamesCollectionModel* games_collection_model_new (void);
VALA_EXTERN GamesCollectionModel* games_collection_model_construct (GType object_type);
VALA_EXTERN GamesCollectionManager* games_collection_manager_new (GamesDatabase* database);
VALA_EXTERN GamesCollectionManager* games_collection_manager_construct (GType object_type,
                                                            GamesDatabase* database);
VALA_EXTERN GType games_collection_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void games_collection_model_add_collection (GamesCollectionModel* self,
                                            GamesCollection* collection);
static void _games_collection_model_add_collection_games_collection_manager_collection_added (GamesCollectionManager* _sender,
                                                                                       GamesCollection* collection,
                                                                                       gpointer self);
VALA_EXTERN void games_collection_model_remove_collection (GamesCollectionModel* self,
                                               GamesCollection* collection);
static void _games_collection_model_remove_collection_games_collection_manager_collection_removed (GamesCollectionManager* _sender,
                                                                                            GamesCollection* collection,
                                                                                            gpointer self);
VALA_EXTERN void games_application_load_game_list (GamesApplication* self,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_);
VALA_EXTERN void games_application_load_game_list_finish (GamesApplication* self,
                                              GAsyncResult* _res_);
VALA_EXTERN GamesApplicationWindow* games_application_window_new (GamesApplication* application,
                                                      GamesGameModel* game_model,
                                                      GamesCollectionModel* collection_model);
VALA_EXTERN GamesApplicationWindow* games_application_window_construct (GType object_type,
                                                            GamesApplication* application,
                                                            GamesGameModel* game_model,
                                                            GamesCollectionModel* collection_model);
static void __lambda77_ (GamesApplication* self);
static void ___lambda77__gtk_widget_destroy (GtkWidget* _sender,
                                      gpointer self);
static gboolean games_application_show_loading_notification (GamesApplication* self);
static gboolean _games_application_show_loading_notification_gsource_func (gpointer self);
VALA_EXTERN gboolean games_game_collection_get_paused (GamesGameCollection* self);
VALA_EXTERN void games_application_window_set_loading_notification (GamesApplicationWindow* self,
                                                        gboolean value);
VALA_EXTERN gboolean games_migrator_apply_migration_if_necessary (GamesDatabase* database);
VALA_EXTERN void games_database_prepare_statements (GamesDatabase* self);
VALA_EXTERN GamesGameCollection* games_game_collection_new (GamesDatabase* database);
VALA_EXTERN GamesGameCollection* games_game_collection_construct (GType object_type,
                                                      GamesDatabase* database);
VALA_EXTERN void games_game_collection_add_source (GamesGameCollection* self,
                                       GamesUriSource* source);
VALA_EXTERN GType games_platform_register_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesPlatformRegister* games_platform_register_get_register (void);
VALA_EXTERN GType games_retro_simple_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesRetroSimpleType* games_retro_simple_type_dup (const GamesRetroSimpleType* self);
VALA_EXTERN void games_retro_simple_type_free (GamesRetroSimpleType* self);
VALA_EXTERN void games_retro_simple_type_copy (const GamesRetroSimpleType* self,
                                   GamesRetroSimpleType* dest);
VALA_EXTERN void games_retro_simple_type_destroy (GamesRetroSimpleType* self);
VALA_EXTERN gchar* games_retro_simple_type_get_platform_name (GamesRetroSimpleType *self);
VALA_EXTERN void games_platform_register_add_platform (GamesPlatformRegister* self,
                                           GamesPlatform* platform);
VALA_EXTERN GType games_retro_simple_game_uri_adapter_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesRetroSimpleGameUriAdapter* games_retro_simple_game_uri_adapter_new (GamesRetroSimpleType* simple_type,
                                                                         GamesRetroPlatform* platform);
VALA_EXTERN GamesRetroSimpleGameUriAdapter* games_retro_simple_game_uri_adapter_construct (GType object_type,
                                                                               GamesRetroSimpleType* simple_type,
                                                                               GamesRetroPlatform* platform);
VALA_EXTERN void games_game_collection_add_factory (GamesGameCollection* self,
                                        GamesUriGameFactory* factory);
VALA_EXTERN void games_game_collection_add_runner_factory (GamesGameCollection* self,
                                               GamesRunnerFactory* factory);
VALA_EXTERN GType games_plugin_register_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesPluginRegister* games_plugin_register_get_register (void);
VALA_EXTERN gpointer games_plugin_register_iterator_ref (gpointer instance);
VALA_EXTERN void games_plugin_register_iterator_unref (gpointer instance);
VALA_EXTERN GParamSpec* games_param_spec_plugin_register_iterator (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags);
VALA_EXTERN void games_value_set_plugin_register_iterator (GValue* value,
                                               gpointer v_object);
VALA_EXTERN void games_value_take_plugin_register_iterator (GValue* value,
                                                gpointer v_object);
VALA_EXTERN gpointer games_value_get_plugin_register_iterator (const GValue* value);
VALA_EXTERN GType games_plugin_register_iterator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesPluginRegisterIterator* games_plugin_register_iterator (GamesPluginRegister* self);
VALA_EXTERN gboolean games_plugin_register_iterator_next (GamesPluginRegisterIterator* self);
VALA_EXTERN GType games_plugin_registrar_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesPluginRegistrar* games_plugin_register_iterator_get (GamesPluginRegisterIterator* self);
VALA_EXTERN GQuark games_plugin_error_quark (void);
GType games_plugin_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesPlugin* games_plugin_registrar_get_plugin (GamesPluginRegistrar* self,
                                                GError** error);
VALA_EXTERN GamesGame* games_game_collection_query_game_for_uri (GamesGameCollection* self,
                                                     GamesUri* uri);
VALA_EXTERN void games_database_add_uri (GamesDatabase* self,
                             GamesUri* uri,
                             GError** error);
VALA_EXTERN void games_game_collection_add_uri (GamesGameCollection* self,
                                    GamesUri* uri);
static void games_application_load_game_list_data_free (gpointer _data);
static gboolean games_application_load_game_list_co (GamesApplicationLoadGameListData* _data_);
VALA_EXTERN void games_game_collection_search_games (GamesGameCollection* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN void games_game_collection_search_games_finish (GamesGameCollection* self,
                                                GAsyncResult* _res_);
static void games_application_load_game_list_ready (GObject* source_object,
                                             GAsyncResult* _res_,
                                             gpointer _user_data_);
VALA_EXTERN void games_game_collection_set_paused (GamesGameCollection* self,
                                       gboolean value);
VALA_EXTERN GamesPreferencesWindow* games_preferences_window_new (void);
VALA_EXTERN GamesPreferencesWindow* games_preferences_window_construct (GType object_type);
static void ___lambda67_ (GamesApplication* self);
static void ____lambda67__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void __lambda68_ (Block23Data* _data23_,
                  gint response_id);
static void ___lambda68__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void games_application_quit_application_internal (GamesApplication* self,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static void games_application_quit_application_internal_finish (GamesApplication* self,
                                                         GAsyncResult* _res_);
static void games_application_quit_application_internal_data_free (gpointer _data);
static gboolean games_application_quit_application_internal_co (GamesApplicationQuitApplicationInternalData* _data_);
VALA_EXTERN void games_application_window_quit_game (GamesApplicationWindow* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN gboolean games_application_window_quit_game_finish (GamesApplicationWindow* self,
                                                    GAsyncResult* _res_);
static void games_application_quit_application_internal_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static void games_application_on_gamepad_button_press_event (GamesApplication* self,
                                                      ManetteDevice* device,
                                                      ManetteEvent* event);
VALA_EXTERN gboolean games_application_window_gamepad_button_press_event (GamesApplicationWindow* self,
                                                              ManetteEvent* event);
static void games_application_on_gamepad_button_release_event (GamesApplication* self,
                                                        ManetteEvent* event);
VALA_EXTERN gboolean games_application_window_gamepad_button_release_event (GamesApplicationWindow* self,
                                                                ManetteEvent* event);
static void games_application_on_gamepad_absolute_axis_event (GamesApplication* self,
                                                       ManetteEvent* event);
VALA_EXTERN gboolean games_application_window_gamepad_absolute_axis_event (GamesApplicationWindow* self,
                                                               ManetteEvent* event);
static void games_application_on_device_connected (GamesApplication* self,
                                            ManetteDevice* device);
static void _games_application_on_gamepad_button_press_event_manette_device_button_press_event (ManetteDevice* _sender,
                                                                                         ManetteEvent* event,
                                                                                         gpointer self);
static void _games_application_on_gamepad_button_release_event_manette_device_button_release_event (ManetteDevice* _sender,
                                                                                             ManetteEvent* event,
                                                                                             gpointer self);
static void _games_application_on_gamepad_absolute_axis_event_manette_device_absolute_axis_event (ManetteDevice* _sender,
                                                                                           ManetteEvent* event,
                                                                                           gpointer self);
VALA_EXTERN GamesGameCollection* games_application_get_collection (GamesApplication* self);
VALA_EXTERN GamesCollectionManager* games_application_get_collection_manager (GamesApplication* self);
VALA_EXTERN GamesCoverLoader* games_application_get_cover_loader (GamesApplication* self);
VALA_EXTERN GamesApplication* games_application_get_default (void);
static GObject * games_application_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
VALA_EXTERN GamesDatabase* games_database_new (const gchar* path,
                                   GError** error);
VALA_EXTERN GamesDatabase* games_database_construct (GType object_type,
                                         const gchar* path,
                                         GError** error);
static void _games_application_on_device_connected_manette_monitor_device_connected (ManetteMonitor* _sender,
                                                                              ManetteDevice* device,
                                                                              gpointer self);
static void _vala_ManetteMonitorIter_free (ManetteMonitorIter* self);
static void games_application_finalize (GObject * obj);
static GType games_application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GActionEntry GAMES_APPLICATION_action_entries[5] = {{"preferences", _games_application_preferences_gsimple_action_activate_callback}, {"help", _games_application_help_gsimple_action_activate_callback}, {"about", _games_application_about_gsimple_action_activate_callback}, {"quit", _games_application_quit_application_gsimple_action_activate_callback}, {"add-game-files", _games_application_add_game_files_gsimple_action_activate_callback}};
static const GOptionEntry GAMES_APPLICATION_option_entries[4] = {{"search", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING_ARRAY, NULL, N_ ("Search term")}, {"uid", (gchar) 0, (gint) 0, G_OPTION_ARG_STRING, NULL, N_ ("Run a game by uid")}, {"", (gchar) 0, (gint) 0, G_OPTION_ARG_FILENAME_ARRAY}, {NULL}};
VALA_EXTERN const GamesRetroSimpleType GAMES_RETRO_SIMPLE_TYPES[23];
VALA_EXTERN const gchar* GAMES_CREDITS_AUTHORS[10];
VALA_EXTERN const gchar* GAMES_CREDITS_ARTISTS[4];
VALA_EXTERN const gchar* GAMES_CREDITS_DOCUMENTERS[3];

static inline gpointer
games_application_get_instance_private (GamesApplication* self)
{
	return G_STRUCT_MEMBER_P (self, GamesApplication_private_offset);
}

static void
_games_application_preferences_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	games_application_preferences ((GamesApplication*) self);
}

static void
_games_application_help_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	games_application_help ((GamesApplication*) self);
}

static void
_games_application_about_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	games_application_about ((GamesApplication*) self);
}

static void
_games_application_quit_application_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self)
{
	games_application_quit_application ((GamesApplication*) self);
}

static void
_games_application_add_game_files_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
	games_application_add_game_files ((GamesApplication*) self);
}

GamesApplication*
games_application_construct (GType object_type)
{
	GamesApplication * self = NULL;
	self = (GamesApplication*) g_object_new (object_type, "application-id", APPLICATION_ID, "flags", G_APPLICATION_HANDLES_OPEN | G_APPLICATION_HANDLES_COMMAND_LINE, NULL);
	return self;
}

GamesApplication*
games_application_new (void)
{
	return games_application_construct (GAMES_TYPE_APPLICATION);
}

static void
games_application_add_actions (GamesApplication* self)
{
	g_return_if_fail (self != NULL);
	g_action_map_add_action_entries ((GActionMap*) self, GAMES_APPLICATION_action_entries, (gint) G_N_ELEMENTS (GAMES_APPLICATION_action_entries), self);
}

static gboolean
__lambda69_ (GamesApplication* self)
{
	gboolean result;
	games_application_quit_application (self);
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
___lambda69__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda69_ ((GamesApplication*) self);
	return result;
}

static void
games_application_add_signal_handlers (GamesApplication* self)
{
	GSource* interrupt_source = NULL;
	GSource* _tmp0_;
	GMainContext* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_unix_signal_source_new ((gint) SIGINT);
	interrupt_source = _tmp0_;
	g_source_set_callback (interrupt_source, ___lambda69__gsource_func, g_object_ref (self), g_object_unref);
	_tmp1_ = g_main_context_default ();
	g_source_attach (interrupt_source, _tmp1_);
	_g_source_unref0 (interrupt_source);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
games_application_get_data_dir (void)
{
	gchar* data_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	data_dir = _tmp1_;
	_tmp2_ = string_to_string (data_dir);
	_tmp3_ = g_strconcat (_tmp2_, "/gnome-games", NULL);
	result = _tmp3_;
	_g_free0 (data_dir);
	return result;
}

gchar*
games_application_get_database_path (void)
{
	gchar* data_dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = games_application_get_data_dir ();
	data_dir = _tmp0_;
	_tmp1_ = string_to_string (data_dir);
	_tmp2_ = g_strconcat (_tmp1_, "/database.sqlite3", NULL);
	result = _tmp2_;
	_g_free0 (data_dir);
	return result;
}

gchar*
games_application_get_cache_dir (void)
{
	gchar* cache_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	cache_dir = _tmp1_;
	_tmp2_ = string_to_string (cache_dir);
	_tmp3_ = g_strconcat (_tmp2_, "/gnome-games", NULL);
	result = _tmp3_;
	_g_free0 (cache_dir);
	return result;
}

gchar*
games_application_get_config_dir (void)
{
	gchar* config_dir = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_strdup (_tmp0_);
	config_dir = _tmp1_;
	_tmp2_ = string_to_string (config_dir);
	_tmp3_ = g_strconcat (_tmp2_, "/gnome-games", NULL);
	result = _tmp3_;
	_g_free0 (config_dir);
	return result;
}

gchar*
games_application_get_platforms_dir (void)
{
	gchar* config_dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = games_application_get_config_dir ();
	config_dir = _tmp0_;
	_tmp1_ = string_to_string (config_dir);
	_tmp2_ = g_strconcat (_tmp1_, "/platforms", NULL);
	result = _tmp2_;
	_g_free0 (config_dir);
	return result;
}

gchar*
games_application_get_covers_dir (void)
{
	gchar* cache_dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	_tmp0_ = games_application_get_cache_dir ();
	cache_dir = _tmp0_;
	_tmp1_ = string_to_string (cache_dir);
	_tmp2_ = g_strconcat (_tmp1_, "/covers", NULL);
	result = _tmp2_;
	_g_free0 (cache_dir);
	return result;
}

gchar*
games_application_get_image_cache_dir (const gchar* dir_name,
                                       gint size,
                                       gint scale_factor)
{
	gchar* cache_dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result;
	g_return_val_if_fail (dir_name != NULL, NULL);
	_tmp0_ = games_application_get_cache_dir ();
	cache_dir = _tmp0_;
	_tmp1_ = string_to_string (cache_dir);
	_tmp2_ = string_to_string (dir_name);
	_tmp3_ = g_strdup_printf ("%i", size);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%i", scale_factor);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp1_, "/", _tmp2_, "/", _tmp4_, "@", _tmp6_, "x", NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	result = _tmp8_;
	_g_free0 (cache_dir);
	return result;
}

static void
games_application_make_data_dir (GamesApplication* self)
{
	GFile* data_dir = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_application_get_data_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	data_dir = _tmp3_;
	{
		GFile* _tmp4_;
		GFile* _tmp5_;
		_tmp4_ = data_dir;
		if (g_file_query_exists (_tmp4_, NULL)) {
			_g_object_unref0 (data_dir);
			return;
		}
		_tmp5_ = data_dir;
		g_file_make_directory_with_parents (_tmp5_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		games_migrator_bump_to_latest_version ();
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("application.vala:142: Couldn't create data dir: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (data_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (data_dir);
}

void
games_application_try_make_dir (const gchar* path)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (path != NULL);
	_tmp0_ = g_file_new_for_path (path);
	file = _tmp0_;
	{
		GFile* _tmp1_;
		_tmp1_ = file;
		if (!g_file_query_exists (_tmp1_, NULL)) {
			GFile* _tmp2_;
			_tmp2_ = file;
			g_file_make_directory_with_parents (_tmp2_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_critical ("application.vala:153: Couldn't create dir '%s': %s", path, _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file);
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

gboolean
games_application_is_running_in_flatpak (void)
{
	gboolean* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gboolean _tmp4_;
	gboolean* _tmp5_;
	gboolean* _tmp6_;
	gboolean result;
	_tmp0_ = games_application_is_flatpak;
	if (_tmp0_ != NULL) {
		gboolean* _tmp1_;
		_tmp1_ = games_application_is_flatpak;
		result = *_tmp1_;
		return result;
	}
	_tmp2_ = g_file_new_for_path ("/.flatpak-info");
	file = _tmp2_;
	_tmp3_ = file;
	_tmp4_ = g_file_query_exists (_tmp3_, NULL);
	_tmp5_ = __bool_dup0 (&_tmp4_);
	_g_free0 (games_application_is_flatpak);
	games_application_is_flatpak = _tmp5_;
	_tmp6_ = games_application_is_flatpak;
	result = *_tmp6_;
	_g_object_unref0 (file);
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

void
games_application_add_game_files (GamesApplication* self)
{
	GtkFileChooserDialog* chooser = NULL;
	GamesApplicationWindow* _tmp0_;
	GtkFileChooserDialog* _tmp1_;
	GtkFileChooserDialog* _tmp2_;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp3_;
	GtkFileChooserDialog* _tmp4_;
	GtkFileFilter* _tmp5_;
	GamesGameCollection* _tmp6_;
	gint _tmp7_ = 0;
	gchar** _tmp8_;
	GtkFileChooserDialog* _tmp12_;
	GtkFileChooserDialog* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	_tmp1_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Select game files"), (GtkWindow*) _tmp0_, GTK_FILE_CHOOSER_ACTION_OPEN, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Add"), GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp1_);
	chooser = _tmp1_;
	_tmp2_ = chooser;
	gtk_file_chooser_set_select_multiple ((GtkFileChooser*) _tmp2_, TRUE);
	_tmp3_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp3_);
	filter = _tmp3_;
	_tmp4_ = chooser;
	_tmp5_ = filter;
	gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp4_, _tmp5_);
	_tmp6_ = self->priv->game_collection;
	_tmp8_ = games_game_collection_get_accepted_mime_types (_tmp6_, &_tmp7_);
	{
		gchar** mime_type_collection = NULL;
		gint mime_type_collection_length1 = 0;
		gint _mime_type_collection_size_ = 0;
		gint mime_type_it = 0;
		mime_type_collection = _tmp8_;
		mime_type_collection_length1 = _tmp7_;
		for (mime_type_it = 0; mime_type_it < mime_type_collection_length1; mime_type_it = mime_type_it + 1) {
			gchar* _tmp9_;
			gchar* mime_type = NULL;
			_tmp9_ = g_strdup (mime_type_collection[mime_type_it]);
			mime_type = _tmp9_;
			{
				GtkFileFilter* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = filter;
				_tmp11_ = mime_type;
				gtk_file_filter_add_mime_type (_tmp10_, _tmp11_);
				_g_free0 (mime_type);
			}
		}
		mime_type_collection = (_vala_array_free (mime_type_collection, mime_type_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp12_ = chooser;
	if (gtk_dialog_run ((GtkDialog*) _tmp12_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserDialog* _tmp13_;
		GSList* _tmp14_;
		_tmp13_ = chooser;
		_tmp14_ = gtk_file_chooser_get_uris ((GtkFileChooser*) _tmp13_);
		{
			GSList* uri_string_collection = NULL;
			GSList* uri_string_it = NULL;
			uri_string_collection = _tmp14_;
			for (uri_string_it = uri_string_collection; uri_string_it != NULL; uri_string_it = uri_string_it->next) {
				const gchar* uri_string = NULL;
				uri_string = (const gchar*) uri_string_it->data;
				{
					GamesUri* uri = NULL;
					const gchar* _tmp15_;
					GamesUri* _tmp16_;
					GamesUri* _tmp17_;
					_tmp15_ = uri_string;
					_tmp16_ = games_uri_new (_tmp15_);
					uri = _tmp16_;
					_tmp17_ = uri;
					games_application_add_cached_uri (self, _tmp17_);
					_games_uri_unref0 (uri);
				}
			}
			(uri_string_collection == NULL) ? NULL : (uri_string_collection = (_g_slist_free__g_free0_ (uri_string_collection), NULL));
		}
	}
	_tmp18_ = chooser;
	g_signal_emit_by_name ((GtkDialog*) _tmp18_, "close");
	_g_object_unref0 (filter);
	_g_object_unref0 (chooser);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_vala_array_add36 (GamesUri** * array,
                   gint* length,
                   gint* size,
                   GamesUri* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesUri*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
games_application_real_open (GApplication* base,
                             GFile** files,
                             gint files_length1,
                             const gchar* hint)
{
	GamesApplication * self;
	GamesUri** uris = NULL;
	GamesUri** _tmp0_;
	gint uris_length1;
	gint _uris_size_;
	GFile* file = NULL;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GamesGame* game = NULL;
	GamesUri** _tmp6_;
	gint _tmp6__length1;
	GamesGame* _tmp7_;
	GamesGame* _tmp8_;
	GamesApplicationWindow* _tmp22_;
	GamesGame* _tmp23_;
	GError* _inner_error0_ = NULL;
	self = (GamesApplication*) base;
	g_return_if_fail (hint != NULL);
	g_application_activate ((GApplication*) self);
	if (files_length1 == 0) {
		return;
	}
	_tmp0_ = g_new0 (GamesUri*, 0 + 1);
	uris = _tmp0_;
	uris_length1 = 0;
	_uris_size_ = uris_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* _tmp1_;
			GFile* file = NULL;
			_tmp1_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp1_;
			{
				GFile* _tmp2_;
				GamesUri* _tmp3_;
				_tmp2_ = file;
				_tmp3_ = games_uri_new_from_file (_tmp2_);
				_vala_array_add36 (&uris, &uris_length1, &_uris_size_, _tmp3_);
				_g_object_unref0 (file);
			}
		}
	}
	_tmp4_ = files[0];
	_tmp5_ = _g_object_ref0 (_tmp4_);
	file = _tmp5_;
	_tmp6_ = uris;
	_tmp6__length1 = uris_length1;
	_tmp7_ = games_application_game_for_uris (self, _tmp6_, (gint) _tmp6__length1);
	game = _tmp7_;
	_tmp8_ = game;
	if (_tmp8_ == NULL) {
		gchar* filename = NULL;
		gchar* error_msg = NULL;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		GamesApplicationWindow* _tmp20_;
		const gchar* _tmp21_;
		{
			GFileInfo* fileinfo = NULL;
			GFile* _tmp9_;
			GFileInfo* _tmp10_;
			GFileInfo* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp9_ = file;
			_tmp10_ = g_file_query_info (_tmp9_, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
			fileinfo = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp11_ = fileinfo;
			_tmp12_ = g_file_info_get_display_name (_tmp11_);
			_tmp13_ = g_strdup (_tmp12_);
			_g_free0 (filename);
			filename = _tmp13_;
			_g_object_unref0 (fileinfo);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			GFile* _tmp16_;
			gchar* _tmp17_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			g_critical ("application.vala:213: Couldn't retrieve filename: %s", _tmp15_);
			_tmp16_ = file;
			_tmp17_ = g_file_get_basename (_tmp16_);
			_g_free0 (filename);
			filename = _tmp17_;
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (filename);
			_g_object_unref0 (game);
			_g_object_unref0 (file);
			uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp18_ = filename;
		_tmp19_ = g_strdup_printf (_ ("An unexpected error occurred while trying to run %s"), _tmp18_);
		error_msg = _tmp19_;
		_tmp20_ = self->priv->window;
		_tmp21_ = error_msg;
		games_application_window_show_error (_tmp20_, _tmp21_);
		_g_free0 (error_msg);
		_g_free0 (filename);
		_g_object_unref0 (game);
		_g_object_unref0 (file);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
		return;
	}
	_tmp22_ = self->priv->window;
	_tmp23_ = game;
	games_application_window_run_game (_tmp22_, _tmp23_, NULL, NULL);
	_g_object_unref0 (game);
	_g_object_unref0 (file);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
}

static void
games_application_real_startup (GApplication* base)
{
	GamesApplication * self;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp2_;
	GtkSettings* _tmp3_;
	GtkIconTheme* icon_theme = NULL;
	GtkIconTheme* _tmp4_;
	GtkIconTheme* _tmp5_;
	self = (GamesApplication*) base;
	G_APPLICATION_CLASS (games_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	hdy_init ();
	_tmp0_ = gdk_screen_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	screen = _tmp1_;
	_tmp2_ = games_application_load_css ("gtk-style.css");
	provider = _tmp2_;
	gtk_style_context_add_provider_for_screen (screen, (GtkStyleProvider*) provider, (guint) 600);
	_tmp3_ = gtk_settings_get_default ();
	g_object_set (_tmp3_, "gtk-application-prefer-dark-theme", TRUE, NULL);
	_tmp4_ = gtk_icon_theme_get_default ();
	_tmp5_ = _g_object_ref0 (_tmp4_);
	icon_theme = _tmp5_;
	gtk_icon_theme_add_resource_path (icon_theme, "/org/gnome/Games/icons/");
	gtk_icon_theme_add_resource_path (icon_theme, "/org/gnome/Games/gesture");
	_g_object_unref0 (icon_theme);
	_g_object_unref0 (provider);
	_g_object_unref0 (screen);
}

static void
games_application_run_by_uid_data_free (gpointer _data)
{
	GamesApplicationRunByUidData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uid);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesApplicationRunByUidData, _data_);
}

static void
games_application_run_by_uid (GamesApplication* self,
                              const gchar* uid,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	GamesApplicationRunByUidData* _data_;
	GamesApplication* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	_data_ = g_slice_new0 (GamesApplicationRunByUidData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_application_run_by_uid_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uid);
	_g_free0 (_data_->uid);
	_data_->uid = _tmp1_;
	games_application_run_by_uid_co (_data_);
}

static void
games_application_run_by_uid_finish (GamesApplication* self,
                                     GAsyncResult* _res_)
{
	GamesApplicationRunByUidData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
games_application_run_by_uid_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	GamesApplicationRunByUidData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_application_run_by_uid_co (_data_);
}

static gboolean
games_application_run_by_uid_co (GamesApplicationRunByUidData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->game_collection;
	_data_->_state_ = 1;
	games_game_collection_query_game_for_uid (_data_->_tmp0_, _data_->uid, games_application_run_by_uid_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = games_game_collection_query_game_for_uid_finish (_data_->_tmp0_, _data_->_res_);
	_data_->game = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->game;
	if (_data_->_tmp2_ == NULL) {
		_data_->_tmp3_ = _data_->self->priv->window;
		_data_->_tmp4_ = g_strdup_printf (_ ("Cannot find game with UID “%s”."), _data_->uid);
		_data_->_tmp5_ = _data_->_tmp4_;
		games_application_window_show_error (_data_->_tmp3_, _data_->_tmp5_);
		_g_free0 (_data_->_tmp5_);
		_g_object_unref0 (_data_->game);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = _data_->self->priv->window;
	_data_->_tmp7_ = _data_->game;
	games_application_window_run_game (_data_->_tmp6_, _data_->_tmp7_, NULL, NULL);
	_g_object_unref0 (_data_->game);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gpointer
_g_variant_dict_ref0 (gpointer self)
{
	return self ? g_variant_dict_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

static void
_vala_array_add37 (GFile** * array,
                   gint* length,
                   gint* size,
                   GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gint
games_application_real_command_line (GApplication* base,
                                     GApplicationCommandLine* command_line)
{
	GamesApplication * self;
	GVariantDict* options = NULL;
	GVariantDict* _tmp0_;
	GVariantDict* _tmp1_;
	GVariantDict* _tmp2_;
	GVariantDict* _tmp9_;
	GVariant* files_variant = NULL;
	GVariantDict* _tmp21_;
	const GVariantType* _tmp22_;
	GVariant* _tmp23_;
	GVariant* _tmp24_;
	gint result;
	self = (GamesApplication*) base;
	g_return_val_if_fail (command_line != NULL, 0);
	_tmp0_ = g_application_command_line_get_options_dict (command_line);
	_tmp1_ = _g_variant_dict_ref0 (_tmp0_);
	options = _tmp1_;
	g_application_activate ((GApplication*) self);
	_tmp2_ = options;
	if (g_variant_dict_contains (_tmp2_, "uid")) {
		GVariant* uid = NULL;
		GVariantDict* _tmp3_;
		const GVariantType* _tmp4_;
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		_tmp3_ = options;
		_tmp4_ = G_VARIANT_TYPE_STRING;
		_tmp5_ = g_variant_dict_lookup_value (_tmp3_, "uid", _tmp4_);
		uid = _tmp5_;
		_tmp6_ = uid;
		if (_tmp6_ != NULL) {
			GVariant* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = uid;
			_tmp8_ = g_variant_get_string (_tmp7_, NULL);
			games_application_run_by_uid (self, _tmp8_, NULL, NULL);
		}
		result = 0;
		_g_variant_unref0 (uid);
		_g_variant_dict_unref0 (options);
		return result;
	}
	_tmp9_ = options;
	if (g_variant_dict_contains (_tmp9_, "search")) {
		GVariant* terms_variant = NULL;
		GVariantDict* _tmp10_;
		const GVariantType* _tmp11_;
		GVariant* _tmp12_;
		GVariant* _tmp13_;
		_tmp10_ = options;
		_tmp11_ = G_VARIANT_TYPE_STRING_ARRAY;
		_tmp12_ = g_variant_dict_lookup_value (_tmp10_, "search", _tmp11_);
		terms_variant = _tmp12_;
		_tmp13_ = terms_variant;
		if (_tmp13_ != NULL) {
			const gchar** terms = NULL;
			GVariant* _tmp14_;
			gsize _tmp15_ = 0;
			const gchar** _tmp16_;
			gint terms_length1;
			gint _terms_size_;
			GamesApplicationWindow* _tmp17_;
			const gchar** _tmp18_;
			gint _tmp18__length1;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp14_ = terms_variant;
			_tmp16_ = g_variant_get_strv (_tmp14_, &_tmp15_);
			terms = _tmp16_;
			terms_length1 = _tmp15_;
			_terms_size_ = terms_length1;
			_tmp17_ = self->priv->window;
			_tmp18_ = terms;
			_tmp18__length1 = terms_length1;
			_tmp19_ = _vala_g_strjoinv (" ", _tmp18_, (gint) _tmp18__length1);
			_tmp20_ = _tmp19_;
			games_application_window_run_search (_tmp17_, _tmp20_);
			_g_free0 (_tmp20_);
			terms = (g_free (terms), NULL);
		}
		result = 0;
		_g_variant_unref0 (terms_variant);
		_g_variant_dict_unref0 (options);
		return result;
	}
	_tmp21_ = options;
	_tmp22_ = G_VARIANT_TYPE_BYTESTRING_ARRAY;
	_tmp23_ = g_variant_dict_lookup_value (_tmp21_, "", _tmp22_);
	files_variant = _tmp23_;
	_tmp24_ = files_variant;
	if (_tmp24_ != NULL) {
		const gchar** filenames = NULL;
		GVariant* _tmp25_;
		gsize _tmp26_ = 0;
		const gchar** _tmp27_;
		gint filenames_length1;
		gint _filenames_size_;
		GFile** files = NULL;
		GFile** _tmp28_;
		gint files_length1;
		gint _files_size_;
		const gchar** _tmp29_;
		gint _tmp29__length1;
		GFile** _tmp32_;
		gint _tmp32__length1;
		_tmp25_ = files_variant;
		_tmp27_ = g_variant_get_bytestring_array (_tmp25_, &_tmp26_);
		filenames = _tmp27_;
		filenames_length1 = _tmp26_;
		_filenames_size_ = filenames_length1;
		_tmp28_ = g_new0 (GFile*, 0 + 1);
		files = _tmp28_;
		files_length1 = 0;
		_files_size_ = files_length1;
		_tmp29_ = filenames;
		_tmp29__length1 = filenames_length1;
		{
			const gchar** filename_collection = NULL;
			gint filename_collection_length1 = 0;
			gint _filename_collection_size_ = 0;
			gint filename_it = 0;
			filename_collection = _tmp29_;
			filename_collection_length1 = _tmp29__length1;
			for (filename_it = 0; filename_it < filename_collection_length1; filename_it = filename_it + 1) {
				const gchar* filename = NULL;
				filename = filename_collection[filename_it];
				{
					const gchar* _tmp30_;
					GFile* _tmp31_;
					_tmp30_ = filename;
					_tmp31_ = g_application_command_line_create_file_for_arg (command_line, _tmp30_);
					_vala_array_add37 (&files, &files_length1, &_files_size_, _tmp31_);
				}
			}
		}
		_tmp32_ = files;
		_tmp32__length1 = files_length1;
		g_application_open ((GApplication*) self, _tmp32_, (gint) _tmp32__length1, "");
		files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
		filenames = (g_free (filenames), NULL);
	}
	result = 0;
	_g_variant_unref0 (files_variant);
	_g_variant_dict_unref0 (options);
	return result;
}

static void
_games_game_model_add_game_games_game_collection_game_added (GamesGameCollection* _sender,
                                                             GamesGame* game,
                                                             gpointer self)
{
	games_game_model_add_game ((GamesGameModel*) self, game);
}

static void
_games_game_model_replace_game_games_game_collection_game_replaced (GamesGameCollection* _sender,
                                                                    GamesGame* game,
                                                                    GamesGame* prev_game,
                                                                    gpointer self)
{
	games_game_model_replace_game ((GamesGameModel*) self, game, prev_game);
}

static void
_games_game_model_remove_game_games_game_collection_game_removed (GamesGameCollection* _sender,
                                                                  GamesGame* game,
                                                                  gpointer self)
{
	games_game_model_remove_game ((GamesGameModel*) self, game);
}

static void
_games_collection_model_add_collection_games_collection_manager_collection_added (GamesCollectionManager* _sender,
                                                                                  GamesCollection* collection,
                                                                                  gpointer self)
{
	games_collection_model_add_collection ((GamesCollectionModel*) self, collection);
}

static void
_games_collection_model_remove_collection_games_collection_manager_collection_removed (GamesCollectionManager* _sender,
                                                                                       GamesCollection* collection,
                                                                                       gpointer self)
{
	games_collection_model_remove_collection ((GamesCollectionModel*) self, collection);
}

static void
__lambda77_ (GamesApplication* self)
{
	games_application_quit_application (self);
}

static void
___lambda77__gtk_widget_destroy (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda77_ ((GamesApplication*) self);
}

static gboolean
_games_application_show_loading_notification_gsource_func (gpointer self)
{
	gboolean result;
	result = games_application_show_loading_notification ((GamesApplication*) self);
	return result;
}

static void
games_application_real_activate (GApplication* base)
{
	GamesApplication * self;
	GamesApplicationWindow* _tmp15_;
	GamesGameModel* _tmp17_;
	GamesCollectionModel* _tmp18_;
	GamesApplicationWindow* _tmp19_;
	GamesApplicationWindow* _tmp20_;
	GamesApplicationWindow* _tmp21_;
	self = (GamesApplication*) base;
	if (!self->priv->initialized) {
		GamesGameModel* _tmp0_;
		GamesGameCollection* _tmp1_;
		GamesGameModel* _tmp2_;
		GamesGameCollection* _tmp3_;
		GamesGameModel* _tmp4_;
		GamesGameCollection* _tmp5_;
		GamesGameModel* _tmp6_;
		GamesCollectionModel* _tmp7_;
		GamesDatabase* _tmp8_;
		GamesCollectionManager* _tmp9_;
		GamesCollectionManager* _tmp10_;
		GamesCollectionModel* _tmp11_;
		GamesCollectionManager* _tmp12_;
		GamesCollectionModel* _tmp13_;
		GamesCoverLoader* _tmp14_;
		games_application_init_game_sources (self);
		_tmp0_ = games_game_model_new ();
		_g_object_unref0 (self->priv->game_model);
		self->priv->game_model = _tmp0_;
		_tmp1_ = self->priv->game_collection;
		_tmp2_ = self->priv->game_model;
		g_signal_connect_object (_tmp1_, "game-added", (GCallback) _games_game_model_add_game_games_game_collection_game_added, _tmp2_, 0);
		_tmp3_ = self->priv->game_collection;
		_tmp4_ = self->priv->game_model;
		g_signal_connect_object (_tmp3_, "game-replaced", (GCallback) _games_game_model_replace_game_games_game_collection_game_replaced, _tmp4_, 0);
		_tmp5_ = self->priv->game_collection;
		_tmp6_ = self->priv->game_model;
		g_signal_connect_object (_tmp5_, "game-removed", (GCallback) _games_game_model_remove_game_games_game_collection_game_removed, _tmp6_, 0);
		_tmp7_ = games_collection_model_new ();
		_g_object_unref0 (self->priv->collection_model);
		self->priv->collection_model = _tmp7_;
		_tmp8_ = self->priv->database;
		_tmp9_ = games_collection_manager_new (_tmp8_);
		_g_object_unref0 (self->priv->collection_manager);
		self->priv->collection_manager = _tmp9_;
		_tmp10_ = self->priv->collection_manager;
		_tmp11_ = self->priv->collection_model;
		g_signal_connect_object (_tmp10_, "collection-added", (GCallback) _games_collection_model_add_collection_games_collection_manager_collection_added, _tmp11_, 0);
		_tmp12_ = self->priv->collection_manager;
		_tmp13_ = self->priv->collection_model;
		g_signal_connect_object (_tmp12_, "collection-removed", (GCallback) _games_collection_model_remove_collection_games_collection_manager_collection_removed, _tmp13_, 0);
		games_application_load_game_list (self, NULL, NULL);
		_tmp14_ = games_cover_loader_new ();
		_g_object_unref0 (self->priv->cover_loader);
		self->priv->cover_loader = _tmp14_;
		self->priv->initialized = TRUE;
	}
	_tmp15_ = self->priv->window;
	if (_tmp15_ != NULL) {
		GamesApplicationWindow* _tmp16_;
		_tmp16_ = self->priv->window;
		gtk_window_present_with_time ((GtkWindow*) _tmp16_, gtk_get_current_event_time ());
		return;
	}
	_tmp17_ = self->priv->game_model;
	_tmp18_ = self->priv->collection_model;
	_tmp19_ = games_application_window_new (self, _tmp17_, _tmp18_);
	g_object_ref_sink (_tmp19_);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp19_;
	_tmp20_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp20_, "destroy", (GCallback) ___lambda77__gtk_widget_destroy, self, 0);
	_tmp21_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp21_);
	if (self->priv->tracker_failed) {
		gchar* error_msg = NULL;
		gchar* _tmp22_;
		GamesApplicationWindow* _tmp23_;
		const gchar* _tmp24_;
		_tmp22_ = g_strdup (_ ("Couldn't find Tracker, automatic game discovery may not work."));
		error_msg = _tmp22_;
		_tmp23_ = self->priv->window;
		_tmp24_ = error_msg;
		games_application_window_show_error (_tmp23_, _tmp24_);
		_g_free0 (error_msg);
	}
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _games_application_show_loading_notification_gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
games_application_show_loading_notification (GamesApplication* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->game_list_loaded) {
		GamesGameCollection* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->game_collection;
		_tmp2_ = games_game_collection_get_paused (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GamesApplicationWindow* _tmp4_;
		_tmp4_ = self->priv->window;
		games_application_window_set_loading_notification (_tmp4_, TRUE);
	}
	result = FALSE;
	return result;
}

static void
games_application_init_game_sources (GamesApplication* self)
{
	GamesGameCollection* _tmp0_;
	GamesDatabase* _tmp1_;
	GamesDatabase* _tmp2_;
	GamesTrackerUriSource* tracker_uri_source = NULL;
	GamesDatabase* _tmp11_;
	GamesGameCollection* _tmp12_;
	GamesTrackerUriSource* _tmp13_;
	GHashTable* mime_types = NULL;
	GHashFunc _tmp16_;
	GEqualFunc _tmp17_;
	GHashTable* _tmp18_;
	GamesPlatformRegister* platform_register = NULL;
	GamesPlatformRegister* _tmp19_;
	GamesPluginRegister* _register_ = NULL;
	GamesPluginRegister* _tmp64_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_collection;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = self->priv->database;
	games_migrator_apply_migration_if_necessary (_tmp1_);
	_tmp2_ = self->priv->database;
	games_database_prepare_statements (_tmp2_);
	tracker_uri_source = NULL;
	{
		TrackerSparqlConnection* connection = NULL;
		TrackerSparqlConnection* _tmp3_;
		TrackerSparqlConnection* _tmp4_;
		TrackerSparqlCursor* _tmp5_;
		TrackerSparqlCursor* _tmp6_;
		TrackerSparqlConnection* _tmp7_;
		GamesTrackerUriSource* _tmp8_;
		_tmp3_ = tracker_sparql_connection_bus_new ("org.freedesktop.Tracker3.Miner.Files", NULL, NULL, &_inner_error0_);
		connection = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = connection;
		_tmp5_ = tracker_sparql_connection_query (_tmp4_, GAMES_APPLICATION_TEST_QUERY, NULL, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp6_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (connection);
			goto __catch0_g_error;
		}
		_tmp7_ = connection;
		_tmp8_ = games_tracker_uri_source_new (_tmp7_);
		_g_object_unref0 (tracker_uri_source);
		tracker_uri_source = _tmp8_;
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		self->priv->tracker_failed = TRUE;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		g_critical ("application.vala:355: Couldn't find Tracker: %s", _tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (tracker_uri_source);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp11_ = self->priv->database;
	_tmp12_ = games_game_collection_new (_tmp11_);
	_g_object_unref0 (self->priv->game_collection);
	self->priv->game_collection = _tmp12_;
	_tmp13_ = tracker_uri_source;
	if (_tmp13_ != NULL) {
		GamesGameCollection* _tmp14_;
		GamesTrackerUriSource* _tmp15_;
		_tmp14_ = self->priv->game_collection;
		_tmp15_ = tracker_uri_source;
		games_game_collection_add_source (_tmp14_, (GamesUriSource*) _tmp15_);
	}
	_tmp16_ = g_str_hash;
	_tmp17_ = g_str_equal;
	_tmp18_ = g_hash_table_new_full (_tmp16_, _tmp17_, NULL, _g_free0_);
	mime_types = _tmp18_;
	_tmp19_ = games_platform_register_get_register ();
	platform_register = _tmp19_;
	{
		GamesRetroSimpleType* simple_type_collection = NULL;
		gint simple_type_collection_length1 = 0;
		gint _simple_type_collection_size_ = 0;
		gint simple_type_it = 0;
		simple_type_collection = GAMES_RETRO_SIMPLE_TYPES;
		simple_type_collection_length1 = G_N_ELEMENTS (GAMES_RETRO_SIMPLE_TYPES);
		for (simple_type_it = 0; simple_type_it < simple_type_collection_length1; simple_type_it = simple_type_it + 1) {
			GamesRetroSimpleType simple_type = {0};
			simple_type = simple_type_collection[simple_type_it];
			{
				GHashTable* _tmp20_;
				GamesRetroSimpleType _tmp21_;
				const gchar* _tmp22_;
				gboolean _tmp23_ = FALSE;
				GamesRetroSimpleType _tmp24_;
				gchar* platform_name = NULL;
				gchar* _tmp35_;
				GamesRetroPlatform* platform = NULL;
				GamesRetroSimpleType _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				GamesRetroSimpleType _tmp39_;
				const gchar* _tmp40_;
				gchar* _tmp41_;
				gchar** _tmp42_;
				gchar** _tmp43_;
				gint _tmp43__length1;
				GamesRetroSimpleType _tmp44_;
				const gchar* _tmp45_;
				GamesRetroPlatform* _tmp46_;
				GamesRetroPlatform* _tmp47_;
				GamesPlatformRegister* _tmp48_;
				GamesRetroPlatform* _tmp49_;
				GamesRetroSimpleGameUriAdapter* game_uri_adapter = NULL;
				GamesRetroSimpleType _tmp50_;
				GamesRetroPlatform* _tmp51_;
				GamesRetroSimpleGameUriAdapter* _tmp52_;
				GamesGenericUriGameFactory* factory = NULL;
				GamesRetroSimpleGameUriAdapter* _tmp53_;
				GamesGenericUriGameFactory* _tmp54_;
				GamesGenericUriGameFactory* _tmp55_;
				GamesRetroSimpleType _tmp56_;
				const gchar* _tmp57_;
				GamesGameCollection* _tmp58_;
				GamesGenericUriGameFactory* _tmp59_;
				GamesRetroRunnerFactory* runner_factory = NULL;
				GamesRetroPlatform* _tmp60_;
				GamesRetroRunnerFactory* _tmp61_;
				GamesGameCollection* _tmp62_;
				GamesRetroRunnerFactory* _tmp63_;
				_tmp20_ = mime_types;
				_tmp21_ = simple_type;
				_tmp22_ = _tmp21_.mime_type;
				_vala_assert (!g_hash_table_contains (_tmp20_, _tmp22_), "!mime_types.contains (simple_type.mime_type)");
				_tmp24_ = simple_type;
				if (_tmp24_.search_mime_type) {
					GamesTrackerUriSource* _tmp25_;
					_tmp25_ = tracker_uri_source;
					_tmp23_ = _tmp25_ != NULL;
				} else {
					_tmp23_ = FALSE;
				}
				if (_tmp23_) {
					GHashTable* _tmp26_;
					GamesRetroSimpleType _tmp27_;
					const gchar* _tmp28_;
					gchar* _tmp29_;
					GamesMimeTypeTrackerUriQuery* query = NULL;
					GamesRetroSimpleType _tmp30_;
					const gchar* _tmp31_;
					GamesMimeTypeTrackerUriQuery* _tmp32_;
					GamesTrackerUriSource* _tmp33_;
					GamesMimeTypeTrackerUriQuery* _tmp34_;
					_tmp26_ = mime_types;
					_tmp27_ = simple_type;
					_tmp28_ = _tmp27_.mime_type;
					_tmp29_ = g_strdup (_tmp28_);
					g_hash_table_add (_tmp26_, _tmp29_);
					_tmp30_ = simple_type;
					_tmp31_ = _tmp30_.mime_type;
					_tmp32_ = games_mime_type_tracker_uri_query_new (_tmp31_);
					query = _tmp32_;
					_tmp33_ = tracker_uri_source;
					_tmp34_ = query;
					games_tracker_uri_source_add_query (_tmp33_, (GamesTrackerUriQuery*) _tmp34_);
					_g_object_unref0 (query);
				}
				_tmp35_ = games_retro_simple_type_get_platform_name (&simple_type);
				platform_name = _tmp35_;
				_tmp36_ = simple_type;
				_tmp37_ = _tmp36_.platform;
				_tmp38_ = platform_name;
				_tmp39_ = simple_type;
				_tmp40_ = _tmp39_.mime_type;
				_tmp41_ = g_strdup (_tmp40_);
				_tmp42_ = g_new0 (gchar*, 1 + 1);
				_tmp42_[0] = _tmp41_;
				_tmp43_ = _tmp42_;
				_tmp43__length1 = 1;
				_tmp44_ = simple_type;
				_tmp45_ = _tmp44_.prefix;
				_tmp46_ = games_retro_platform_new (_tmp37_, _tmp38_, _tmp43_, 1, _tmp45_);
				_tmp47_ = _tmp46_;
				_tmp43_ = (_vala_array_free (_tmp43_, _tmp43__length1, (GDestroyNotify) g_free), NULL);
				platform = _tmp47_;
				_tmp48_ = platform_register;
				_tmp49_ = platform;
				games_platform_register_add_platform (_tmp48_, (GamesPlatform*) _tmp49_);
				_tmp50_ = simple_type;
				_tmp51_ = platform;
				_tmp52_ = games_retro_simple_game_uri_adapter_new (&_tmp50_, _tmp51_);
				game_uri_adapter = _tmp52_;
				_tmp53_ = game_uri_adapter;
				_tmp54_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) _tmp53_);
				factory = _tmp54_;
				_tmp55_ = factory;
				_tmp56_ = simple_type;
				_tmp57_ = _tmp56_.mime_type;
				games_generic_uri_game_factory_add_mime_type (_tmp55_, _tmp57_);
				_tmp58_ = self->priv->game_collection;
				_tmp59_ = factory;
				games_game_collection_add_factory (_tmp58_, (GamesUriGameFactory*) _tmp59_);
				_tmp60_ = platform;
				_tmp61_ = games_retro_runner_factory_new (_tmp60_);
				runner_factory = _tmp61_;
				_tmp62_ = self->priv->game_collection;
				_tmp63_ = runner_factory;
				games_game_collection_add_runner_factory (_tmp62_, (GamesRunnerFactory*) _tmp63_);
				_g_object_unref0 (runner_factory);
				_g_object_unref0 (factory);
				_g_object_unref0 (game_uri_adapter);
				_g_object_unref0 (platform);
				_g_free0 (platform_name);
			}
		}
	}
	_tmp64_ = games_plugin_register_get_register ();
	_register_ = _tmp64_;
	{
		GamesPluginRegisterIterator* _plugin_registrar_it = NULL;
		GamesPluginRegister* _tmp65_;
		GamesPluginRegisterIterator* _tmp66_;
		_tmp65_ = _register_;
		_tmp66_ = games_plugin_register_iterator (_tmp65_);
		_plugin_registrar_it = _tmp66_;
		while (TRUE) {
			GamesPluginRegisterIterator* _tmp67_;
			GamesPluginRegistrar* plugin_registrar = NULL;
			GamesPluginRegisterIterator* _tmp68_;
			GamesPluginRegistrar* _tmp69_;
			_tmp67_ = _plugin_registrar_it;
			if (!games_plugin_register_iterator_next (_tmp67_)) {
				break;
			}
			_tmp68_ = _plugin_registrar_it;
			_tmp69_ = games_plugin_register_iterator_get (_tmp68_);
			plugin_registrar = _tmp69_;
			{
				GamesPlugin* plugin = NULL;
				GamesPluginRegistrar* _tmp70_;
				GamesPlugin* _tmp71_;
				GamesTrackerUriSource* _tmp72_;
				GamesPlugin* _tmp86_;
				gint _tmp87_ = 0;
				GamesPlatform** _tmp88_;
				GamesPlugin* _tmp92_;
				gint _tmp93_ = 0;
				GamesUriSource** _tmp94_;
				GamesPlugin* _tmp98_;
				gint _tmp99_ = 0;
				GamesUriGameFactory** _tmp100_;
				GamesPlugin* _tmp104_;
				gint _tmp105_ = 0;
				GamesRunnerFactory** _tmp106_;
				_tmp70_ = plugin_registrar;
				_tmp71_ = games_plugin_registrar_get_plugin (_tmp70_, &_inner_error0_);
				plugin = _tmp71_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp72_ = tracker_uri_source;
				if (_tmp72_ != NULL) {
					GamesPlugin* _tmp73_;
					gint _tmp74_ = 0;
					gchar** _tmp75_;
					_tmp73_ = plugin;
					_tmp75_ = games_plugin_get_mime_types (_tmp73_, &_tmp74_);
					{
						gchar** mime_type_collection = NULL;
						gint mime_type_collection_length1 = 0;
						gint _mime_type_collection_size_ = 0;
						gint mime_type_it = 0;
						mime_type_collection = _tmp75_;
						mime_type_collection_length1 = _tmp74_;
						for (mime_type_it = 0; mime_type_it < mime_type_collection_length1; mime_type_it = mime_type_it + 1) {
							gchar* _tmp76_;
							gchar* mime_type = NULL;
							_tmp76_ = g_strdup (mime_type_collection[mime_type_it]);
							mime_type = _tmp76_;
							{
								GHashTable* _tmp77_;
								const gchar* _tmp78_;
								GHashTable* _tmp79_;
								const gchar* _tmp80_;
								gchar* _tmp81_;
								GamesMimeTypeTrackerUriQuery* query = NULL;
								const gchar* _tmp82_;
								GamesMimeTypeTrackerUriQuery* _tmp83_;
								GamesTrackerUriSource* _tmp84_;
								GamesMimeTypeTrackerUriQuery* _tmp85_;
								_tmp77_ = mime_types;
								_tmp78_ = mime_type;
								if (g_hash_table_contains (_tmp77_, _tmp78_)) {
									_g_free0 (mime_type);
									continue;
								}
								_tmp79_ = mime_types;
								_tmp80_ = mime_type;
								_tmp81_ = g_strdup (_tmp80_);
								g_hash_table_add (_tmp79_, _tmp81_);
								_tmp82_ = mime_type;
								_tmp83_ = games_mime_type_tracker_uri_query_new (_tmp82_);
								query = _tmp83_;
								_tmp84_ = tracker_uri_source;
								_tmp85_ = query;
								games_tracker_uri_source_add_query (_tmp84_, (GamesTrackerUriQuery*) _tmp85_);
								_g_object_unref0 (query);
								_g_free0 (mime_type);
							}
						}
						mime_type_collection = (_vala_array_free (mime_type_collection, mime_type_collection_length1, (GDestroyNotify) g_free), NULL);
					}
				}
				_tmp86_ = plugin;
				_tmp88_ = games_plugin_get_platforms (_tmp86_, &_tmp87_);
				{
					GamesPlatform** platform_collection = NULL;
					gint platform_collection_length1 = 0;
					gint _platform_collection_size_ = 0;
					gint platform_it = 0;
					platform_collection = _tmp88_;
					platform_collection_length1 = _tmp87_;
					for (platform_it = 0; platform_it < platform_collection_length1; platform_it = platform_it + 1) {
						GamesPlatform* _tmp89_;
						GamesPlatform* platform = NULL;
						_tmp89_ = _g_object_ref0 (platform_collection[platform_it]);
						platform = _tmp89_;
						{
							GamesPlatformRegister* _tmp90_;
							GamesPlatform* _tmp91_;
							_tmp90_ = platform_register;
							_tmp91_ = platform;
							games_platform_register_add_platform (_tmp90_, _tmp91_);
							_g_object_unref0 (platform);
						}
					}
					platform_collection = (_vala_array_free (platform_collection, platform_collection_length1, (GDestroyNotify) g_object_unref), NULL);
				}
				_tmp92_ = plugin;
				_tmp94_ = games_plugin_get_uri_sources (_tmp92_, &_tmp93_);
				{
					GamesUriSource** uri_source_collection = NULL;
					gint uri_source_collection_length1 = 0;
					gint _uri_source_collection_size_ = 0;
					gint uri_source_it = 0;
					uri_source_collection = _tmp94_;
					uri_source_collection_length1 = _tmp93_;
					for (uri_source_it = 0; uri_source_it < uri_source_collection_length1; uri_source_it = uri_source_it + 1) {
						GamesUriSource* _tmp95_;
						GamesUriSource* uri_source = NULL;
						_tmp95_ = _g_object_ref0 (uri_source_collection[uri_source_it]);
						uri_source = _tmp95_;
						{
							GamesGameCollection* _tmp96_;
							GamesUriSource* _tmp97_;
							_tmp96_ = self->priv->game_collection;
							_tmp97_ = uri_source;
							games_game_collection_add_source (_tmp96_, _tmp97_);
							_g_object_unref0 (uri_source);
						}
					}
					uri_source_collection = (_vala_array_free (uri_source_collection, uri_source_collection_length1, (GDestroyNotify) g_object_unref), NULL);
				}
				_tmp98_ = plugin;
				_tmp100_ = games_plugin_get_uri_game_factories (_tmp98_, &_tmp99_);
				{
					GamesUriGameFactory** factory_collection = NULL;
					gint factory_collection_length1 = 0;
					gint _factory_collection_size_ = 0;
					gint factory_it = 0;
					factory_collection = _tmp100_;
					factory_collection_length1 = _tmp99_;
					for (factory_it = 0; factory_it < factory_collection_length1; factory_it = factory_it + 1) {
						GamesUriGameFactory* _tmp101_;
						GamesUriGameFactory* factory = NULL;
						_tmp101_ = _g_object_ref0 (factory_collection[factory_it]);
						factory = _tmp101_;
						{
							GamesGameCollection* _tmp102_;
							GamesUriGameFactory* _tmp103_;
							_tmp102_ = self->priv->game_collection;
							_tmp103_ = factory;
							games_game_collection_add_factory (_tmp102_, _tmp103_);
							_g_object_unref0 (factory);
						}
					}
					factory_collection = (_vala_array_free (factory_collection, factory_collection_length1, (GDestroyNotify) g_object_unref), NULL);
				}
				_tmp104_ = plugin;
				_tmp106_ = games_plugin_get_runner_factories (_tmp104_, &_tmp105_);
				{
					GamesRunnerFactory** factory_collection = NULL;
					gint factory_collection_length1 = 0;
					gint _factory_collection_size_ = 0;
					gint factory_it = 0;
					factory_collection = _tmp106_;
					factory_collection_length1 = _tmp105_;
					for (factory_it = 0; factory_it < factory_collection_length1; factory_it = factory_it + 1) {
						GamesRunnerFactory* _tmp107_;
						GamesRunnerFactory* factory = NULL;
						_tmp107_ = _g_object_ref0 (factory_collection[factory_it]);
						factory = _tmp107_;
						{
							GamesGameCollection* _tmp108_;
							GamesRunnerFactory* _tmp109_;
							_tmp108_ = self->priv->game_collection;
							_tmp109_ = factory;
							games_game_collection_add_runner_factory (_tmp108_, _tmp109_);
							_g_object_unref0 (factory);
						}
					}
					factory_collection = (_vala_array_free (factory_collection, factory_collection_length1, (GDestroyNotify) g_object_unref), NULL);
				}
				_g_object_unref0 (plugin);
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp110_;
				const gchar* _tmp111_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp110_ = e;
				_tmp111_ = _tmp110_->message;
				g_debug ("application.vala:420: Error: %s", _tmp111_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (plugin_registrar);
				_games_plugin_register_iterator_unref0 (_plugin_registrar_it);
				_g_object_unref0 (_register_);
				_g_object_unref0 (platform_register);
				_g_hash_table_unref0 (mime_types);
				_g_object_unref0 (tracker_uri_source);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (plugin_registrar);
		}
		_games_plugin_register_iterator_unref0 (_plugin_registrar_it);
	}
	_g_object_unref0 (_register_);
	_g_object_unref0 (platform_register);
	_g_hash_table_unref0 (mime_types);
	_g_object_unref0 (tracker_uri_source);
}

static gpointer
_games_uri_ref0 (gpointer self)
{
	return self ? games_uri_ref (self) : NULL;
}

static GamesGame*
games_application_game_for_uris (GamesApplication* self,
                                 GamesUri** uris,
                                 gint uris_length1)
{
	GamesGameCollection* _tmp2_;
	GamesUri* _tmp3_;
	GamesGame* _tmp4_;
	GamesGame* result;
	g_return_val_if_fail (self != NULL, NULL);
	games_application_init_game_sources (self);
	{
		GamesUri** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = uris;
		uri_collection_length1 = uris_length1;
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
			GamesUri* _tmp0_;
			GamesUri* uri = NULL;
			_tmp0_ = _games_uri_ref0 (uri_collection[uri_it]);
			uri = _tmp0_;
			{
				GamesUri* _tmp1_;
				_tmp1_ = uri;
				games_application_add_cached_uri (self, _tmp1_);
				_games_uri_unref0 (uri);
			}
		}
	}
	_tmp2_ = self->priv->game_collection;
	_tmp3_ = uris[0];
	_tmp4_ = games_game_collection_query_game_for_uri (_tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}

static void
games_application_add_cached_uri (GamesApplication* self,
                                  GamesUri* uri)
{
	GamesGameCollection* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	{
		GamesDatabase* _tmp0_;
		_tmp0_ = self->priv->database;
		if (_tmp0_ != NULL) {
			GamesDatabase* _tmp1_;
			_tmp1_ = self->priv->database;
			games_database_add_uri (_tmp1_, uri, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_debug ("application.vala:440: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp4_ = self->priv->game_collection;
	games_game_collection_add_uri (_tmp4_, uri);
}

static void
games_application_load_game_list_data_free (gpointer _data)
{
	GamesApplicationLoadGameListData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesApplicationLoadGameListData, _data_);
}

void
games_application_load_game_list (GamesApplication* self,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_)
{
	GamesApplicationLoadGameListData* _data_;
	GamesApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GamesApplicationLoadGameListData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_application_load_game_list_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	games_application_load_game_list_co (_data_);
}

void
games_application_load_game_list_finish (GamesApplication* self,
                                         GAsyncResult* _res_)
{
	GamesApplicationLoadGameListData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
games_application_load_game_list_ready (GObject* source_object,
                                        GAsyncResult* _res_,
                                        gpointer _user_data_)
{
	GamesApplicationLoadGameListData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_application_load_game_list_co (_data_);
}

static gboolean
games_application_load_game_list_co (GamesApplicationLoadGameListData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 500, _games_application_show_loading_notification_gsource_func, g_object_ref (_data_->self), g_object_unref);
	_data_->_tmp0_ = _data_->self->priv->game_collection;
	_data_->_state_ = 1;
	games_game_collection_search_games (_data_->_tmp0_, games_application_load_game_list_ready, _data_);
	return FALSE;
	_state_1:
	games_game_collection_search_games_finish (_data_->_tmp0_, _data_->_res_);
	_data_->_tmp1_ = _data_->self->priv->game_collection;
	_data_->_tmp2_ = games_game_collection_get_paused (_data_->_tmp1_);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_tmp3_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->self->priv->game_list_loaded = TRUE;
	_data_->_tmp4_ = _data_->self->priv->window;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = _data_->self->priv->window;
		games_application_window_set_loading_notification (_data_->_tmp5_, FALSE);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
games_application_set_pause_loading (GamesApplication* self,
                                     gboolean paused)
{
	GamesGameCollection* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GamesGameCollection* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game_collection;
	_tmp1_ = games_game_collection_get_paused (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == paused) {
		return;
	}
	_tmp3_ = self->priv->game_collection;
	games_game_collection_set_paused (_tmp3_, paused);
	if (!paused) {
		games_application_load_game_list (self, NULL, NULL);
	}
}

static void
___lambda67_ (GamesApplication* self)
{
	_g_object_unref0 (self->priv->preferences_window);
	self->priv->preferences_window = NULL;
}

static void
____lambda67__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
	___lambda67_ ((GamesApplication*) self);
}

static void
games_application_preferences (GamesApplication* self)
{
	GamesPreferencesWindow* _tmp0_;
	GamesPreferencesWindow* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->preferences_window;
	if (_tmp0_ == NULL) {
		GamesPreferencesWindow* _tmp1_;
		GamesPreferencesWindow* _tmp2_;
		GamesApplicationWindow* _tmp3_;
		GamesPreferencesWindow* _tmp4_;
		GamesPreferencesWindow* _tmp5_;
		_tmp1_ = games_preferences_window_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->preferences_window);
		self->priv->preferences_window = _tmp1_;
		_tmp2_ = self->priv->preferences_window;
		_tmp3_ = self->priv->window;
		gtk_window_set_transient_for ((GtkWindow*) _tmp2_, (GtkWindow*) _tmp3_);
		_tmp4_ = self->priv->preferences_window;
		gtk_window_set_modal ((GtkWindow*) _tmp4_, TRUE);
		_tmp5_ = self->priv->preferences_window;
		g_signal_connect_object ((GtkWidget*) _tmp5_, "destroy", (GCallback) ____lambda67__gtk_widget_destroy, self, 0);
	}
	_tmp6_ = self->priv->preferences_window;
	gtk_window_present_with_time ((GtkWindow*) _tmp6_, gtk_get_current_event_time ());
}

static void
games_application_help (GamesApplication* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_;
		GtkWindow* _tmp1_;
		_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
		_tmp1_ = _tmp0_;
		gtk_show_uri_on_window (_tmp1_, GAMES_APPLICATION_HELP_URI, gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_critical ("application.vala:489: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
	g_atomic_int_inc (&_data23_->_ref_count_);
	return _data23_;
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
		GamesApplication* self;
		self = _data23_->self;
		_g_object_unref0 (_data23_->dialog);
		_g_object_unref0 (self);
		g_slice_free (Block23Data, _data23_);
	}
}

static void
__lambda68_ (Block23Data* _data23_,
             gint response_id)
{
	GamesApplication* self;
	gboolean _tmp0_ = FALSE;
	self = _data23_->self;
	if (response_id == ((gint) GTK_RESPONSE_CANCEL)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = response_id == ((gint) GTK_RESPONSE_DELETE_EVENT);
	}
	if (_tmp0_) {
		gtk_widget_hide_on_delete ((GtkWidget*) _data23_->dialog);
	}
}

static void
___lambda68__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda68_ (self, response_id);
}

static void
games_application_about (GamesApplication* self)
{
	Block23Data* _data23_;
	GtkAboutDialog* _tmp0_;
	GamesApplicationWindow* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_data23_ = g_slice_new0 (Block23Data);
	_data23_->_ref_count_ = 1;
	_data23_->self = g_object_ref (self);
	_tmp0_ = (GtkAboutDialog*) gtk_about_dialog_new ();
	g_object_ref_sink (_tmp0_);
	_data23_->dialog = _tmp0_;
	gtk_window_set_destroy_with_parent ((GtkWindow*) _data23_->dialog, TRUE);
	_tmp1_ = self->priv->window;
	gtk_window_set_transient_for ((GtkWindow*) _data23_->dialog, (GtkWindow*) _tmp1_);
	gtk_window_set_modal ((GtkWindow*) _data23_->dialog, TRUE);
	_tmp2_ = g_strconcat (_ ("GNOME Games"), NAME_SUFFIX, NULL);
	_tmp3_ = _tmp2_;
	gtk_about_dialog_set_program_name (_data23_->dialog, _tmp3_);
	_g_free0 (_tmp3_);
	gtk_about_dialog_set_logo_icon_name (_data23_->dialog, APPLICATION_ID);
	gtk_about_dialog_set_comments (_data23_->dialog, _ ("A video game player for GNOME"));
	gtk_about_dialog_set_version (_data23_->dialog, VERSION);
	gtk_about_dialog_set_website (_data23_->dialog, "https://wiki.gnome.org/Apps/Games");
	gtk_about_dialog_set_website_label (_data23_->dialog, _ ("Learn more about GNOME Games"));
	gtk_about_dialog_set_license_type (_data23_->dialog, GTK_LICENSE_GPL_3_0);
	gtk_about_dialog_set_authors (_data23_->dialog, GAMES_CREDITS_AUTHORS);
	gtk_about_dialog_set_artists (_data23_->dialog, GAMES_CREDITS_ARTISTS);
	gtk_about_dialog_set_documenters (_data23_->dialog, GAMES_CREDITS_DOCUMENTERS);
	gtk_about_dialog_set_translator_credits (_data23_->dialog, _ ("translator-credits"));
	g_signal_connect_data ((GtkDialog*) _data23_->dialog, "response", (GCallback) ___lambda68__gtk_dialog_response, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
	gtk_window_present_with_time ((GtkWindow*) _data23_->dialog, gtk_get_current_event_time ());
	block23_data_unref (_data23_);
	_data23_ = NULL;
}

static void
games_application_quit_application (GamesApplication* self)
{
	g_return_if_fail (self != NULL);
	games_application_quit_application_internal (self, NULL, NULL);
}

static void
games_application_quit_application_internal_data_free (gpointer _data)
{
	GamesApplicationQuitApplicationInternalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesApplicationQuitApplicationInternalData, _data_);
}

static void
games_application_quit_application_internal (GamesApplication* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	GamesApplicationQuitApplicationInternalData* _data_;
	GamesApplication* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GamesApplicationQuitApplicationInternalData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_application_quit_application_internal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	games_application_quit_application_internal_co (_data_);
}

static void
games_application_quit_application_internal_finish (GamesApplication* self,
                                                    GAsyncResult* _res_)
{
	GamesApplicationQuitApplicationInternalData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
games_application_quit_application_internal_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	GamesApplicationQuitApplicationInternalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_application_quit_application_internal_co (_data_);
}

static gboolean
games_application_quit_application_internal_co (GamesApplicationQuitApplicationInternalData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->window;
	if (_data_->_tmp0_ != NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->window;
	if (_data_->_tmp2_ != NULL) {
		_data_->_tmp3_ = _data_->self->priv->window;
		_data_->_state_ = 1;
		games_application_window_quit_game (_data_->_tmp3_, games_application_quit_application_internal_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = !games_application_window_quit_game_finish (_data_->_tmp3_, _data_->_res_);
	} else {
		_data_->_tmp1_ = FALSE;
	}
	if (_data_->_tmp1_) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_application_quit ((GApplication*) _data_->self);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GtkCssProvider*
games_application_load_css (const gchar* css)
{
	GtkCssProvider* provider = NULL;
	GtkCssProvider* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkCssProvider* result;
	g_return_val_if_fail (css != NULL, NULL);
	_tmp0_ = gtk_css_provider_new ();
	provider = _tmp0_;
	_tmp1_ = g_strconcat ("/org/gnome/Games/", css, NULL);
	_tmp2_ = _tmp1_;
	gtk_css_provider_load_from_resource (provider, _tmp2_);
	_g_free0 (_tmp2_);
	result = provider;
	return result;
}

static void
games_application_on_gamepad_button_press_event (GamesApplication* self,
                                                 ManetteDevice* device,
                                                 ManetteEvent* event)
{
	GamesApplicationWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->window;
	games_application_window_gamepad_button_press_event (_tmp0_, event);
}

static void
games_application_on_gamepad_button_release_event (GamesApplication* self,
                                                   ManetteEvent* event)
{
	GamesApplicationWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->window;
	games_application_window_gamepad_button_release_event (_tmp0_, event);
}

static void
games_application_on_gamepad_absolute_axis_event (GamesApplication* self,
                                                  ManetteEvent* event)
{
	GamesApplicationWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = self->priv->window;
	games_application_window_gamepad_absolute_axis_event (_tmp0_, event);
}

static void
_games_application_on_gamepad_button_press_event_manette_device_button_press_event (ManetteDevice* _sender,
                                                                                    ManetteEvent* event,
                                                                                    gpointer self)
{
	games_application_on_gamepad_button_press_event ((GamesApplication*) self, _sender, event);
}

static void
_games_application_on_gamepad_button_release_event_manette_device_button_release_event (ManetteDevice* _sender,
                                                                                        ManetteEvent* event,
                                                                                        gpointer self)
{
	games_application_on_gamepad_button_release_event ((GamesApplication*) self, event);
}

static void
_games_application_on_gamepad_absolute_axis_event_manette_device_absolute_axis_event (ManetteDevice* _sender,
                                                                                      ManetteEvent* event,
                                                                                      gpointer self)
{
	games_application_on_gamepad_absolute_axis_event ((GamesApplication*) self, event);
}

static void
games_application_on_device_connected (GamesApplication* self,
                                       ManetteDevice* device)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_signal_connect_object (device, "button-press-event", (GCallback) _games_application_on_gamepad_button_press_event_manette_device_button_press_event, self, 0);
	g_signal_connect_object (device, "button-release-event", (GCallback) _games_application_on_gamepad_button_release_event_manette_device_button_release_event, self, 0);
	g_signal_connect_object (device, "absolute-axis-event", (GCallback) _games_application_on_gamepad_absolute_axis_event_manette_device_absolute_axis_event, self, 0);
}

void
games_application_import_from (const gchar* archive_path,
                               GError** error)
{
	gchar* data_dir = NULL;
	gchar* _tmp0_;
	gchar** database = NULL;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint database_length1;
	gint _database_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (archive_path != NULL);
	_tmp0_ = games_application_get_data_dir ();
	data_dir = _tmp0_;
	_tmp1_ = games_application_get_database_path ();
	_tmp2_ = g_new0 (gchar*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	database = _tmp2_;
	database_length1 = 1;
	_database_size_ = database_length1;
	games_file_operations_extract_archive (archive_path, data_dir, database, (gint) database_length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_EXTRACTION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			database = (_vala_array_free (database, database_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (data_dir);
			return;
		} else {
			database = (_vala_array_free (database, database_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (data_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	database = (_vala_array_free (database, database_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (data_dir);
}

void
games_application_export_to (const gchar* file_path,
                             GError** error)
{
	GFile* data_dir = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar** database = NULL;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint database_length1;
	gint _database_size_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (file_path != NULL);
	_tmp0_ = games_application_get_data_dir ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	data_dir = _tmp3_;
	_tmp4_ = games_application_get_database_path ();
	_tmp5_ = g_new0 (gchar*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	database = _tmp5_;
	database_length1 = 1;
	_database_size_ = database_length1;
	games_file_operations_compress_dir (file_path, data_dir, database, (gint) database_length1, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_COMPRESSION_ERROR) {
			g_propagate_error (error, _inner_error0_);
			database = (_vala_array_free (database, database_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (data_dir);
			return;
		} else {
			database = (_vala_array_free (database, database_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (data_dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	database = (_vala_array_free (database, database_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (data_dir);
}

GamesGameCollection*
games_application_get_collection (GamesApplication* self)
{
	GamesGameCollection* _tmp0_;
	GamesGameCollection* _tmp1_;
	GamesGameCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->game_collection;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GamesCollectionManager*
games_application_get_collection_manager (GamesApplication* self)
{
	GamesCollectionManager* _tmp0_;
	GamesCollectionManager* _tmp1_;
	GamesCollectionManager* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->collection_manager;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GamesCoverLoader*
games_application_get_cover_loader (GamesApplication* self)
{
	GamesCoverLoader* _tmp0_;
	GamesCoverLoader* _tmp1_;
	GamesCoverLoader* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->cover_loader;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

GamesApplication*
games_application_get_default (void)
{
	GApplication* _tmp0_;
	GamesApplication* _tmp1_;
	GamesApplication* result;
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (GAMES_IS_APPLICATION (_tmp0_) ? ((GamesApplication*) _tmp0_) : NULL);
	result = _tmp1_;
	return result;
}

static void
_games_application_on_device_connected_manette_monitor_device_connected (ManetteMonitor* _sender,
                                                                         ManetteDevice* device,
                                                                         gpointer self)
{
	games_application_on_device_connected ((GamesApplication*) self, device);
}

static void
_vala_ManetteMonitorIter_free (ManetteMonitorIter* self)
{
	g_boxed_free (manette_monitor_iter_get_type (), self);
}

static GObject *
games_application_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GamesApplication * self;
	gchar* database_path = NULL;
	gchar* _tmp0_;
	ManetteMonitor* _tmp7_;
	ManetteMonitorIter* manette_iterator = NULL;
	ManetteMonitor* _tmp8_;
	ManetteMonitorIter* _tmp9_;
	ManetteDevice* manette_device = NULL;
	ManetteMonitor* _tmp15_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (games_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_APPLICATION, GamesApplication);
	g_set_prgname (APPLICATION_ID);
	g_set_application_name (_ ("Games"));
	gtk_window_set_default_icon_name (APPLICATION_ID);
	g_setenv ("PULSE_PROP_media.role", "game", TRUE);
	g_setenv ("PULSE_PROP_application.icon_name", APPLICATION_ID, TRUE);
	g_application_add_main_option_entries ((GApplication*) self, GAMES_APPLICATION_option_entries);
	games_application_add_actions (self);
	games_application_add_signal_handlers (self);
	games_application_make_data_dir (self);
	_tmp0_ = games_application_get_database_path ();
	database_path = _tmp0_;
	{
		GamesDatabase* _tmp1_ = NULL;
		const gchar* _tmp2_;
		GamesDatabase* _tmp3_;
		GamesDatabase* _tmp4_;
		_tmp2_ = database_path;
		_tmp3_ = games_database_new (_tmp2_, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->database);
		self->priv->database = _tmp4_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_debug ("application.vala:65: %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (database_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	_tmp7_ = manette_monitor_new ();
	_g_object_unref0 (self->priv->manette_monitor);
	self->priv->manette_monitor = _tmp7_;
	_tmp8_ = self->priv->manette_monitor;
	_tmp9_ = manette_monitor_iterate (_tmp8_);
	manette_iterator = _tmp9_;
	manette_device = NULL;
	while (TRUE) {
		ManetteMonitorIter* _tmp10_;
		ManetteDevice* _tmp11_ = NULL;
		gboolean _tmp12_;
		ManetteDevice* _tmp13_;
		ManetteDevice* _tmp14_;
		_tmp10_ = manette_iterator;
		_tmp12_ = manette_monitor_iter_next (_tmp10_, &_tmp11_);
		_g_object_unref0 (manette_device);
		_tmp13_ = _g_object_ref0 (_tmp11_);
		manette_device = _tmp13_;
		if (!_tmp12_) {
			break;
		}
		_tmp14_ = manette_device;
		games_application_on_device_connected (self, _tmp14_);
	}
	_tmp15_ = self->priv->manette_monitor;
	g_signal_connect_object (_tmp15_, "device-connected", (GCallback) _games_application_on_device_connected_manette_monitor_device_connected, self, 0);
	_g_object_unref0 (manette_device);
	__vala_ManetteMonitorIter_free0 (manette_iterator);
	_g_free0 (database_path);
	return obj;
}

static void
games_application_class_init (GamesApplicationClass * klass,
                              gpointer klass_data)
{
	games_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesApplication_private_offset);
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) games_application_real_open;
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) games_application_real_startup;
	((GApplicationClass *) klass)->command_line = (gint (*) (GApplication*, GApplicationCommandLine*)) games_application_real_command_line;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) games_application_real_activate;
	G_OBJECT_CLASS (klass)->constructor = games_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_application_finalize;
}

static void
games_application_instance_init (GamesApplication * self,
                                 gpointer klass)
{
	self->priv = games_application_get_instance_private (self);
}

static void
games_application_finalize (GObject * obj)
{
	GamesApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_APPLICATION, GamesApplication);
	_g_object_unref0 (self->priv->database);
	_g_object_unref0 (self->priv->preferences_window);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->game_collection);
	_g_object_unref0 (self->priv->game_model);
	_g_object_unref0 (self->priv->cover_loader);
	_g_object_unref0 (self->priv->collection_manager);
	_g_object_unref0 (self->priv->collection_model);
	_g_object_unref0 (self->priv->manette_monitor);
	G_OBJECT_CLASS (games_application_parent_class)->finalize (obj);
}

static GType
games_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesApplication), 0, (GInstanceInitFunc) games_application_instance_init, NULL };
	GType games_application_type_id;
	games_application_type_id = g_type_register_static (gtk_application_get_type (), "GamesApplication", &g_define_type_info, 0);
	GamesApplication_private_offset = g_type_add_instance_private (games_application_type_id, sizeof (GamesApplicationPrivate));
	return games_application_type_id;
}

GType
games_application_get_type (void)
{
	static volatile gsize games_application_type_id__once = 0;
	if (g_once_init_enter (&games_application_type_id__once)) {
		GType games_application_type_id;
		games_application_type_id = games_application_get_type_once ();
		g_once_init_leave (&games_application_type_id__once, games_application_type_id);
	}
	return games_application_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

