/* tracker-uri-iterator.c generated by valac 0.56.8, the Vala compiler
 * generated from tracker-uri-iterator.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include "gnome-games.h"
#include <libtracker-sparql/tracker-sparql.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define GAMES_TYPE_TRACKER_URI_ITERATOR (games_tracker_uri_iterator_get_type ())
#define GAMES_TRACKER_URI_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_TRACKER_URI_ITERATOR, GamesTrackerUriIterator))
#define GAMES_TRACKER_URI_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_TRACKER_URI_ITERATOR, GamesTrackerUriIteratorClass))
#define GAMES_IS_TRACKER_URI_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_TRACKER_URI_ITERATOR))
#define GAMES_IS_TRACKER_URI_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_TRACKER_URI_ITERATOR))
#define GAMES_TRACKER_URI_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_TRACKER_URI_ITERATOR, GamesTrackerUriIteratorClass))

typedef struct _GamesTrackerUriIterator GamesTrackerUriIterator;
typedef struct _GamesTrackerUriIteratorClass GamesTrackerUriIteratorClass;
typedef struct _GamesTrackerUriIteratorPrivate GamesTrackerUriIteratorPrivate;
enum  {
	GAMES_TRACKER_URI_ITERATOR_0_PROPERTY,
	GAMES_TRACKER_URI_ITERATOR_NUM_PROPERTIES
};
static GParamSpec* games_tracker_uri_iterator_properties[GAMES_TRACKER_URI_ITERATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _games_uri_unref0(var) ((var == NULL) ? NULL : (var = (games_uri_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GamesTrackerUriIterator {
	GObject parent_instance;
	GamesTrackerUriIteratorPrivate * priv;
};

struct _GamesTrackerUriIteratorClass {
	GObjectClass parent_class;
};

struct _GamesTrackerUriIteratorPrivate {
	TrackerSparqlConnection* connection;
	GamesTrackerUriQuery** queries;
	gint queries_length1;
	gint _queries_size_;
	gint query_index;
	GamesUri* uri;
	TrackerSparqlCursor* cursor;
};

static gint GamesTrackerUriIterator_private_offset;
static gpointer games_tracker_uri_iterator_parent_class = NULL;
static GamesUriIteratorIface * games_tracker_uri_iterator_games_uri_iterator_parent_iface = NULL;

VALA_EXTERN GType games_tracker_uri_iterator_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesTrackerUriIterator* games_tracker_uri_iterator_new (TrackerSparqlConnection* connection,
                                                         GamesTrackerUriQuery** queries,
                                                         gint queries_length1);
VALA_EXTERN GamesTrackerUriIterator* games_tracker_uri_iterator_construct (GType object_type,
                                                               TrackerSparqlConnection* connection,
                                                               GamesTrackerUriQuery** queries,
                                                               gint queries_length1);
static GamesTrackerUriQuery** _vala_array_dup18 (GamesTrackerUriQuery** self,
                                          gssize length);
static GamesUri* games_tracker_uri_iterator_real_get (GamesUriIterator* base);
static gboolean games_tracker_uri_iterator_real_next (GamesUriIterator* base);
static gboolean games_tracker_uri_iterator_try_next_for_query (GamesTrackerUriIterator* self,
                                                        GamesTrackerUriQuery* query);
static gboolean games_tracker_uri_iterator_next_for_query (GamesTrackerUriIterator* self,
                                                    GamesTrackerUriQuery* query,
                                                    GError** error);
static void games_tracker_uri_iterator_finalize (GObject * obj);
static GType games_tracker_uri_iterator_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_tracker_uri_iterator_get_instance_private (GamesTrackerUriIterator* self)
{
	return G_STRUCT_MEMBER_P (self, GamesTrackerUriIterator_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GamesTrackerUriQuery**
_vala_array_dup18 (GamesTrackerUriQuery** self,
                   gssize length)
{
	if (length >= 0) {
		GamesTrackerUriQuery** result;
		gssize i;
		result = g_new0 (GamesTrackerUriQuery*, length + 1);
		for (i = 0; i < length; i++) {
			GamesTrackerUriQuery* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

GamesTrackerUriIterator*
games_tracker_uri_iterator_construct (GType object_type,
                                      TrackerSparqlConnection* connection,
                                      GamesTrackerUriQuery** queries,
                                      gint queries_length1)
{
	GamesTrackerUriIterator * self = NULL;
	TrackerSparqlConnection* _tmp0_;
	GamesTrackerUriQuery** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (connection != NULL, NULL);
	self = (GamesTrackerUriIterator*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (connection);
	_g_object_unref0 (self->priv->connection);
	self->priv->connection = _tmp0_;
	_tmp1_ = (queries != NULL) ? _vala_array_dup18 (queries, queries_length1) : queries;
	_tmp1__length1 = queries_length1;
	self->priv->queries = (_vala_array_free (self->priv->queries, self->priv->queries_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->queries = _tmp1_;
	self->priv->queries_length1 = _tmp1__length1;
	self->priv->_queries_size_ = self->priv->queries_length1;
	self->priv->query_index = 0;
	_games_uri_unref0 (self->priv->uri);
	self->priv->uri = NULL;
	_g_object_unref0 (self->priv->cursor);
	self->priv->cursor = NULL;
	return self;
}

GamesTrackerUriIterator*
games_tracker_uri_iterator_new (TrackerSparqlConnection* connection,
                                GamesTrackerUriQuery** queries,
                                gint queries_length1)
{
	return games_tracker_uri_iterator_construct (GAMES_TYPE_TRACKER_URI_ITERATOR, connection, queries, queries_length1);
}

static gpointer
_games_uri_ref0 (gpointer self)
{
	return self ? games_uri_ref (self) : NULL;
}

static GamesUri*
games_tracker_uri_iterator_real_get (GamesUriIterator* base)
{
	GamesTrackerUriIterator * self;
	GamesUri* _tmp0_;
	GamesUri* _tmp1_;
	GamesUri* result;
	self = (GamesTrackerUriIterator*) base;
	_tmp0_ = self->priv->uri;
	_tmp1_ = _games_uri_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
games_tracker_uri_iterator_real_next (GamesUriIterator* base)
{
	GamesTrackerUriIterator * self;
	gboolean result;
	self = (GamesTrackerUriIterator*) base;
	while (TRUE) {
		GamesTrackerUriQuery** _tmp0_;
		gint _tmp0__length1;
		GamesTrackerUriQuery** _tmp1_;
		gint _tmp1__length1;
		GamesTrackerUriQuery* _tmp2_;
		gint _tmp3_;
		_tmp0_ = self->priv->queries;
		_tmp0__length1 = self->priv->queries_length1;
		if (!(self->priv->query_index < _tmp0__length1)) {
			break;
		}
		_tmp1_ = self->priv->queries;
		_tmp1__length1 = self->priv->queries_length1;
		_tmp2_ = _tmp1_[self->priv->query_index];
		if (games_tracker_uri_iterator_try_next_for_query (self, _tmp2_)) {
			result = TRUE;
			return result;
		}
		_tmp3_ = self->priv->query_index;
		self->priv->query_index = _tmp3_ + 1;
	}
	result = FALSE;
	return result;
}

static gboolean
games_tracker_uri_iterator_try_next_for_query (GamesTrackerUriIterator* self,
                                               GamesTrackerUriQuery* query)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (query != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = games_tracker_uri_iterator_next_for_query (self, query, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (_tmp0_) {
			result = TRUE;
			return result;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_debug ("tracker-uri-iterator.vala:39: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp3_;
	}
	_games_uri_unref0 (self->priv->uri);
	self->priv->uri = NULL;
	_g_object_unref0 (self->priv->cursor);
	self->priv->cursor = NULL;
	result = FALSE;
	return result;
}

static gboolean
games_tracker_uri_iterator_next_for_query (GamesTrackerUriIterator* self,
                                           GamesTrackerUriQuery* query,
                                           GError** error)
{
	TrackerSparqlCursor* _tmp0_;
	gboolean _tmp8_ = FALSE;
	TrackerSparqlCursor* _tmp9_;
	TrackerSparqlCursor* _tmp11_;
	const gchar* _tmp12_;
	GamesUri* _tmp13_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (query != NULL, FALSE);
	_tmp0_ = self->priv->cursor;
	if (_tmp0_ == NULL) {
		gchar* sparql = NULL;
		gchar* _tmp1_;
		TrackerSparqlCursor* _tmp2_ = NULL;
		TrackerSparqlConnection* _tmp3_;
		const gchar* _tmp4_;
		TrackerSparqlCursor* _tmp5_;
		TrackerSparqlCursor* _tmp7_;
		_tmp1_ = games_tracker_uri_query_get_query (query);
		sparql = _tmp1_;
		_tmp3_ = self->priv->connection;
		_tmp4_ = sparql;
		_tmp5_ = tracker_sparql_connection_query (_tmp3_, _tmp4_, NULL, &_inner_error0_);
		_tmp2_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp6_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (sparql);
			return _tmp6_;
		}
		_tmp7_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (self->priv->cursor);
		self->priv->cursor = _tmp7_;
		_g_object_unref0 (_tmp2_);
		_g_free0 (sparql);
	}
	_tmp9_ = self->priv->cursor;
	_tmp8_ = tracker_sparql_cursor_next (_tmp9_, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp10_;
	}
	if (!_tmp8_) {
		result = FALSE;
		return result;
	}
	_tmp11_ = self->priv->cursor;
	_tmp12_ = tracker_sparql_cursor_get_string (_tmp11_, 0, NULL);
	_tmp13_ = games_uri_new (_tmp12_);
	_games_uri_unref0 (self->priv->uri);
	self->priv->uri = _tmp13_;
	result = TRUE;
	return result;
}

static void
games_tracker_uri_iterator_class_init (GamesTrackerUriIteratorClass * klass,
                                       gpointer klass_data)
{
	games_tracker_uri_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesTrackerUriIterator_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_tracker_uri_iterator_finalize;
}

static void
games_tracker_uri_iterator_games_uri_iterator_interface_init (GamesUriIteratorIface * iface,
                                                              gpointer iface_data)
{
	games_tracker_uri_iterator_games_uri_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->get = (GamesUri* (*) (GamesUriIterator*)) games_tracker_uri_iterator_real_get;
	iface->next = (gboolean (*) (GamesUriIterator*)) games_tracker_uri_iterator_real_next;
}

static void
games_tracker_uri_iterator_instance_init (GamesTrackerUriIterator * self,
                                          gpointer klass)
{
	self->priv = games_tracker_uri_iterator_get_instance_private (self);
}

static void
games_tracker_uri_iterator_finalize (GObject * obj)
{
	GamesTrackerUriIterator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_TRACKER_URI_ITERATOR, GamesTrackerUriIterator);
	_g_object_unref0 (self->priv->connection);
	self->priv->queries = (_vala_array_free (self->priv->queries, self->priv->queries_length1, (GDestroyNotify) g_object_unref), NULL);
	_games_uri_unref0 (self->priv->uri);
	_g_object_unref0 (self->priv->cursor);
	G_OBJECT_CLASS (games_tracker_uri_iterator_parent_class)->finalize (obj);
}

static GType
games_tracker_uri_iterator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesTrackerUriIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_tracker_uri_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesTrackerUriIterator), 0, (GInstanceInitFunc) games_tracker_uri_iterator_instance_init, NULL };
	static const GInterfaceInfo games_uri_iterator_info = { (GInterfaceInitFunc) games_tracker_uri_iterator_games_uri_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType games_tracker_uri_iterator_type_id;
	games_tracker_uri_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesTrackerUriIterator", &g_define_type_info, 0);
	g_type_add_interface_static (games_tracker_uri_iterator_type_id, GAMES_TYPE_URI_ITERATOR, &games_uri_iterator_info);
	GamesTrackerUriIterator_private_offset = g_type_add_instance_private (games_tracker_uri_iterator_type_id, sizeof (GamesTrackerUriIteratorPrivate));
	return games_tracker_uri_iterator_type_id;
}

GType
games_tracker_uri_iterator_get_type (void)
{
	static volatile gsize games_tracker_uri_iterator_type_id__once = 0;
	if (g_once_init_enter (&games_tracker_uri_iterator_type_id__once)) {
		GType games_tracker_uri_iterator_type_id;
		games_tracker_uri_iterator_type_id = games_tracker_uri_iterator_get_type_once ();
		g_once_init_leave (&games_tracker_uri_iterator_type_id__once, games_tracker_uri_iterator_type_id);
	}
	return games_tracker_uri_iterator_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

