/* retro-runner.c generated by valac 0.56.8, the Vala compiler
 * generated from retro-runner.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <retro-gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include "config.h"
#include <float.h>
#include <math.h>

#define GAMES_TYPE_RETRO_INPUT_MANAGER (games_retro_input_manager_get_type ())
#define GAMES_RETRO_INPUT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_INPUT_MANAGER, GamesRetroInputManager))
#define GAMES_RETRO_INPUT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_INPUT_MANAGER, GamesRetroInputManagerClass))
#define GAMES_IS_RETRO_INPUT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_INPUT_MANAGER))
#define GAMES_IS_RETRO_INPUT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_INPUT_MANAGER))
#define GAMES_RETRO_INPUT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_INPUT_MANAGER, GamesRetroInputManagerClass))

typedef struct _GamesRetroInputManager GamesRetroInputManager;
typedef struct _GamesRetroInputManagerClass GamesRetroInputManagerClass;
enum  {
	GAMES_RETRO_RUNNER_0_PROPERTY,
	GAMES_RETRO_RUNNER_CAN_FULLSCREEN_PROPERTY,
	GAMES_RETRO_RUNNER_CAN_RESUME_PROPERTY,
	GAMES_RETRO_RUNNER_SUPPORTS_SNAPSHOTS_PROPERTY,
	GAMES_RETRO_RUNNER_IS_INTEGRATED_PROPERTY,
	GAMES_RETRO_RUNNER_MEDIA_SET_PROPERTY,
	GAMES_RETRO_RUNNER_INPUT_CAPABILITIES_PROPERTY,
	GAMES_RETRO_RUNNER_INPUT_MODE_PROPERTY,
	GAMES_RETRO_RUNNER_NUM_PROPERTIES
};
static GParamSpec* games_retro_runner_properties[GAMES_RETRO_RUNNER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _Block22Data Block22Data;

#define GAMES_TYPE_RETRO_ERROR (games_retro_error_get_type ())

#define GAMES_TYPE_RETRO_OPTIONS (games_retro_options_get_type ())
#define GAMES_RETRO_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_OPTIONS, GamesRetroOptions))
#define GAMES_RETRO_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_OPTIONS, GamesRetroOptionsClass))
#define GAMES_IS_RETRO_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_OPTIONS))
#define GAMES_IS_RETRO_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_OPTIONS))
#define GAMES_RETRO_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_OPTIONS, GamesRetroOptionsClass))

typedef struct _GamesRetroOptions GamesRetroOptions;
typedef struct _GamesRetroOptionsClass GamesRetroOptionsClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
enum  {
	GAMES_RETRO_RUNNER_CONTROLLERS_CHANGED_SIGNAL,
	GAMES_RETRO_RUNNER_NUM_SIGNALS
};
static guint games_retro_runner_signals[GAMES_RETRO_RUNNER_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GamesRetroRunnerPrivate {
	GamesMediaSet* _media_set;
	GamesInputCapabilities* _input_capabilities;
	RetroCore* core;
	RetroCoreView* view;
	GamesRetroInputManager* input_manager;
	GamesInputMode _input_mode;
	RetroCoreDescriptor* core_descriptor;
	GamesRetroCoreSource* core_source;
	GSettings* settings;
	GamesGame* game;
	GamesSnapshotManager* snapshot_manager;
	GamesSnapshot* previewed_snapshot;
	gchar* tmp_save_dir;
	GdkPixbuf* current_state_pixbuf;
	gboolean _running;
	gboolean core_loaded;
	gboolean is_error;
};

struct _Block22Data {
	int _ref_count_;
	GamesRetroRunner* self;
	gchar** medias_uris;
	gint medias_uris_length1;
	gint _medias_uris_size_;
};

typedef enum  {
	GAMES_RETRO_ERROR_MODULE_NOT_FOUND,
	GAMES_RETRO_ERROR_INVALID_GAME_FILE,
	GAMES_RETRO_ERROR_COULDNT_WRITE_SNAPSHOT,
	GAMES_RETRO_ERROR_COULDNT_LOAD_SNAPSHOT
} GamesRetroError;
#define GAMES_RETRO_ERROR games_retro_error_quark ()

static gint GamesRetroRunner_private_offset;
static gpointer games_retro_runner_parent_class = NULL;
static GamesRunnerIface * games_retro_runner_games_runner_parent_iface = NULL;

VALA_EXTERN GType games_retro_input_manager_get_type (void) G_GNUC_CONST ;
static void games_retro_runner_deinit (GamesRetroRunner* self);
static void games_retro_runner_on_media_number_changed (GamesRetroRunner* self);
static void _games_retro_runner_on_media_number_changed_g_object_notify (GObject* _sender,
                                                                  GParamSpec* pspec,
                                                                  gpointer self);
static void games_retro_runner_on_video_filter_changed (GamesRetroRunner* self);
static GtkWidget* games_retro_runner_real_get_display (GamesRunner* base);
static GamesHeaderBarWidget* games_retro_runner_real_get_extra_widget (GamesRetroRunner* self);
static gchar* games_retro_runner_get_unsupported_system_message (GamesRetroRunner* self);
static gchar* games_retro_runner_get_core_id (GamesRetroRunner* self,
                                       GError** error);
static gchar* games_retro_runner_create_tmp_save_dir (GamesRetroRunner* self,
                                               GError** error);
static gchar* games_retro_runner_get_options_path (GamesRetroRunner* self,
                                            GError** error);
static void games_retro_runner_prepare_core (GamesRetroRunner* self,
                                      GError** error);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
VALA_EXTERN GQuark games_retro_error_quark (void);
GType games_retro_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_retro_options_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesRetroOptions* games_retro_options_new (const gchar* filename,
                                            GError** error);
VALA_EXTERN GamesRetroOptions* games_retro_options_construct (GType object_type,
                                                  const gchar* filename,
                                                  GError** error);
VALA_EXTERN void games_retro_options_apply (GamesRetroOptions* self,
                                RetroCore* core,
                                GError** error);
static void _retro_g_log_retro_core_log (RetroCore* _sender,
                                  const gchar* log_domain,
                                  GLogLevelFlags log_level,
                                  const gchar* message,
                                  gpointer self);
static void _games_runner_stop_retro_core_shutdown (RetroCore* _sender,
                                             gpointer self);
static void __lambda74_ (GamesRetroRunner* self,
                  RetroCore* core,
                  const gchar* _error_);
static void ___lambda74__retro_core_crashed (RetroCore* _sender,
                                      const gchar* message,
                                      gpointer self);
static void __lambda75_ (Block22Data* _data22_,
                  GamesMedia* media);
static void _vala_array_add32 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void ___lambda75__games_media_set_media_callback (GamesMedia* media,
                                                  gpointer self);
VALA_EXTERN GamesRetroInputManager* games_retro_input_manager_new (RetroCore* core,
                                                       RetroCoreView* view);
VALA_EXTERN GamesRetroInputManager* games_retro_input_manager_construct (GType object_type,
                                                             RetroCore* core,
                                                             RetroCoreView* view);
static void __lambda76_ (GamesRetroRunner* self);
static void ___lambda76__games_retro_input_manager_controllers_changed (GamesRetroInputManager* _sender,
                                                                 gpointer self);
static void games_retro_runner_real_prepare (GamesRunner* base,
                                      GError** error);
static gchar* games_retro_runner_get_fallback_save_directory_path (GamesRetroRunner* self,
                                                            GError** error);
static void games_retro_runner_real_start (GamesRunner* base,
                                    GError** error);
static void games_retro_runner_real_resume (GamesRunner* base);
static void games_retro_runner_set_running (GamesRetroRunner* self,
                                     gboolean value);
static void games_retro_runner_real_pause (GamesRunner* base);
static gboolean games_retro_runner_get_running (GamesRetroRunner* self);
static void games_retro_runner_real_stop (GamesRunner* base);
static void _games_retro_runner_on_video_filter_changed_g_settings_changed (GSettings* _sender,
                                                                     const gchar* key,
                                                                     gpointer self);
static GamesSnapshot* games_retro_runner_real_try_create_snapshot (GamesRunner* base,
                                                            gboolean is_automatic);
static void _games_retro_runner_save_to_snapshot_games_snapshot_manager_snapshot_func (GamesSnapshot* snapshot,
                                                                                gpointer self,
                                                                                GError** error);
static void games_retro_runner_real_delete_snapshot (GamesRunner* base,
                                              GamesSnapshot* snapshot);
static void games_retro_runner_real_preview_snapshot (GamesRunner* base,
                                               GamesSnapshot* snapshot);
static void games_retro_runner_real_preview_current_state (GamesRunner* base);
static void games_retro_runner_real_load_previewed_snapshot (GamesRunner* base,
                                                      GError** error);
static GamesSnapshot** games_retro_runner_real_get_snapshots (GamesRunner* base,
                                                       gint* result_length1);
static GamesInputMode* games_retro_runner_real_get_available_input_modes (GamesRunner* base,
                                                                   gint* result_length1);
static void _vala_array_add33 (GamesInputMode* * array,
                        gint* length,
                        gint* size,
                        GamesInputMode value);
static void _vala_array_add34 (GamesInputMode* * array,
                        gint* length,
                        gint* size,
                        GamesInputMode value);
static gboolean games_retro_runner_real_key_press_event (GamesRetroRunner* self,
                                                  guint keyval,
                                                  GdkModifierType state);
static gboolean games_retro_runner_real_gamepad_button_press_event (GamesRetroRunner* self,
                                                             guint16 button);
static void games_retro_runner_save_screenshot (GamesRetroRunner* self,
                                         const gchar* path,
                                         GError** error);
static void games_retro_runner_load_save_ram (GamesRetroRunner* self,
                                       const gchar* save_ram_path,
                                       GError** error);
static void games_retro_runner_real_save_to_snapshot (GamesRetroRunner* self,
                                               GamesSnapshot* snapshot,
                                               GError** error);
static void games_retro_runner_real_load_from_snapshot (GamesRetroRunner* self,
                                                 GamesSnapshot* snapshot,
                                                 GError** error);
static void games_retro_runner_real_reset_with_snapshot (GamesRetroRunner* self,
                                                  GamesSnapshot* last_snapshot,
                                                  GError** error);
VALA_EXTERN void games_retro_input_manager_set_input_mode (GamesRetroInputManager* self,
                                               GamesInputMode value);
static GObject * games_retro_runner_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static void games_retro_runner_finalize (GObject * obj);
static GType games_retro_runner_get_type_once (void);
static void _vala_games_retro_runner_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_games_retro_runner_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_retro_runner_get_instance_private (GamesRetroRunner* self)
{
	return G_STRUCT_MEMBER_P (self, GamesRetroRunner_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_games_retro_runner_on_media_number_changed_g_object_notify (GObject* _sender,
                                                             GParamSpec* pspec,
                                                             gpointer self)
{
	games_retro_runner_on_media_number_changed ((GamesRetroRunner*) self);
}

GamesRetroRunner*
games_retro_runner_construct_from_source (GType object_type,
                                          GamesGame* game,
                                          GamesRetroCoreSource* source)
{
	GamesRetroRunner * self = NULL;
	GamesGame* _tmp0_;
	GamesRetroCoreSource* _tmp1_;
	GamesMediaSet* _tmp2_;
	GamesMediaSet* _tmp3_;
	GamesMediaSet* _tmp4_;
	gboolean _tmp5_ = FALSE;
	GamesMediaSet* _tmp6_;
	GamesMediaSet* _tmp7_;
	GamesMediaSet* _tmp17_;
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (GamesRetroRunner*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp0_;
	_tmp1_ = _g_object_ref0 (source);
	_g_object_unref0 (self->priv->core_source);
	self->priv->core_source = _tmp1_;
	_tmp2_ = games_game_get_media_set (game);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->_media_set);
	self->priv->_media_set = _tmp4_;
	_tmp6_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == NULL) {
		GamesUri* _tmp8_;
		GamesUri* _tmp9_;
		_tmp8_ = games_game_get_uri (game);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_ != NULL;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GamesMedia* media = NULL;
		GamesMedia* _tmp10_;
		GamesMedia* _tmp11_;
		GamesUri* _tmp12_;
		GamesUri* _tmp13_;
		GamesMediaSet* _tmp14_;
		GamesMediaSet* _tmp15_;
		GamesMedia* _tmp16_;
		_tmp10_ = games_media_new (NULL);
		media = _tmp10_;
		_tmp11_ = media;
		_tmp12_ = games_game_get_uri (game);
		_tmp13_ = _tmp12_;
		games_media_add_uri (_tmp11_, _tmp13_);
		_tmp14_ = games_media_set_new ();
		_g_object_unref0 (self->priv->_media_set);
		self->priv->_media_set = _tmp14_;
		_tmp15_ = self->priv->_media_set;
		_tmp16_ = media;
		games_media_set_add_media (_tmp15_, _tmp16_);
		_g_object_unref0 (media);
	}
	_tmp17_ = self->priv->_media_set;
	g_signal_connect_object ((GObject*) _tmp17_, "notify::selected-media-number", (GCallback) _games_retro_runner_on_media_number_changed_g_object_notify, self, 0);
	return self;
}

GamesRetroRunner*
games_retro_runner_new_from_source (GamesGame* game,
                                    GamesRetroCoreSource* source)
{
	return games_retro_runner_construct_from_source (GAMES_TYPE_RETRO_RUNNER, game, source);
}

GamesRetroRunner*
games_retro_runner_construct_from_descriptor (GType object_type,
                                              GamesGame* game,
                                              RetroCoreDescriptor* descriptor)
{
	GamesRetroRunner * self = NULL;
	GamesGame* _tmp0_;
	RetroCoreDescriptor* _tmp1_;
	GamesMediaSet* _tmp2_;
	g_return_val_if_fail (game != NULL, NULL);
	g_return_val_if_fail (descriptor != NULL, NULL);
	self = (GamesRetroRunner*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp0_;
	_tmp1_ = _g_object_ref0 (descriptor);
	_g_object_unref0 (self->priv->core_descriptor);
	self->priv->core_descriptor = _tmp1_;
	_tmp2_ = games_media_set_new ();
	_g_object_unref0 (self->priv->_media_set);
	self->priv->_media_set = _tmp2_;
	return self;
}

GamesRetroRunner*
games_retro_runner_new_from_descriptor (GamesGame* game,
                                        RetroCoreDescriptor* descriptor)
{
	return games_retro_runner_construct_from_descriptor (GAMES_TYPE_RETRO_RUNNER, game, descriptor);
}

static void
games_retro_runner_on_video_filter_changed (GamesRetroRunner* self)
{
	gchar* filter_name = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	RetroVideoFilter filter = 0;
	RetroCoreView* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "video-filter");
	filter_name = _tmp1_;
	filter = retro_video_filter_from_string (filter_name);
	_tmp2_ = self->priv->view;
	retro_core_view_set_filter (_tmp2_, filter);
	_g_free0 (filter_name);
}

static GtkWidget*
games_retro_runner_real_get_display (GamesRunner* base)
{
	GamesRetroRunner * self;
	RetroCoreView* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* result;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->view;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}

static GamesHeaderBarWidget*
games_retro_runner_real_get_extra_widget (GamesRetroRunner* self)
{
	GamesHeaderBarWidget* result;
	result = NULL;
	return result;
}

GamesHeaderBarWidget*
games_retro_runner_get_extra_widget (GamesRetroRunner* self)
{
	GamesRetroRunnerClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = GAMES_RETRO_RUNNER_GET_CLASS (self);
	if (_klass_->get_extra_widget) {
		return _klass_->get_extra_widget (self);
	}
	return NULL;
}

static gchar*
games_retro_runner_get_unsupported_system_message (GamesRetroRunner* self)
{
	gchar* platform_name = NULL;
	GamesGame* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesPlatform* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = games_game_get_platform (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_platform_get_name (_tmp2_);
	platform_name = _tmp3_;
	_tmp4_ = platform_name;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = platform_name;
		_tmp6_ = g_strdup_printf (_ ("The system “%s” isn’t supported yet, but full support is planned."), _tmp5_);
		result = _tmp6_;
		_g_free0 (platform_name);
		return result;
	}
	_tmp7_ = g_strdup (_ ("The system isn’t supported yet, but full support is planned."));
	result = _tmp7_;
	_g_free0 (platform_name);
	return result;
}

static gchar*
games_retro_runner_get_core_id (GamesRetroRunner* self,
                                GError** error)
{
	RetroCoreDescriptor* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->core_descriptor;
	if (_tmp0_ != NULL) {
		RetroCoreDescriptor* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->core_descriptor;
		_tmp2_ = retro_core_descriptor_get_id (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		gchar* _tmp3_ = NULL;
		GamesRetroCoreSource* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->core_source;
		_tmp5_ = games_retro_core_source_get_core_id (_tmp4_, &_inner_error0_);
		_tmp3_ = _tmp5_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
		_tmp6_ = _tmp3_;
		_tmp3_ = NULL;
		result = _tmp6_;
		_g_free0 (_tmp3_);
		return result;
	}
}

static gchar*
games_retro_runner_create_tmp_save_dir (GamesRetroRunner* self,
                                        GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = g_dir_make_tmp ("games_save_dir_XXXXXX", &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_free0 (_tmp0_);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
games_retro_runner_get_options_path (GamesRetroRunner* self,
                                     GError** error)
{
	RetroCore* _tmp0_;
	gchar* core_filename = NULL;
	RetroCore* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* file = NULL;
	GFile* _tmp4_;
	gchar* basename = NULL;
	gchar* _tmp5_;
	gchar* options_name = NULL;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->core;
	_vala_assert (_tmp0_ != NULL, "core != null");
	_tmp1_ = self->priv->core;
	_tmp2_ = retro_core_get_filename (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	core_filename = _tmp3_;
	_tmp4_ = g_file_new_for_path (core_filename);
	file = _tmp4_;
	_tmp5_ = g_file_get_basename (file);
	basename = _tmp5_;
	_tmp7_ = _tmp6_ = g_strsplit (basename, ".", 0);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _vala_array_length (_tmp6_);
	_tmp9_ = _tmp8_[0];
	_tmp10_ = g_strdup (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	options_name = _tmp11_;
	_tmp12_ = options_name;
	_tmp13_ = string_replace (_tmp12_, "_libretro", "");
	_g_free0 (options_name);
	options_name = _tmp13_;
	_tmp14_ = string_to_string (OPTIONS_DIR);
	_tmp15_ = options_name;
	_tmp16_ = string_to_string (_tmp15_);
	_tmp17_ = g_strconcat (_tmp14_, "/", _tmp16_, ".options", NULL);
	result = _tmp17_;
	_g_free0 (options_name);
	_g_free0 (basename);
	_g_object_unref0 (file);
	_g_free0 (core_filename);
	return result;
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
	g_atomic_int_inc (&_data22_->_ref_count_);
	return _data22_;
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
		GamesRetroRunner* self;
		self = _data22_->self;
		_data22_->medias_uris = (_vala_array_free (_data22_->medias_uris, _data22_->medias_uris_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block22Data, _data22_);
	}
}

static void
_retro_g_log_retro_core_log (RetroCore* _sender,
                             const gchar* log_domain,
                             GLogLevelFlags log_level,
                             const gchar* message,
                             gpointer self)
{
	retro_g_log (_sender, log_domain, log_level, message);
}

static void
_games_runner_stop_retro_core_shutdown (RetroCore* _sender,
                                        gpointer self)
{
	games_runner_stop ((GamesRunner*) self);
}

static void
__lambda74_ (GamesRetroRunner* self,
             RetroCore* core,
             const gchar* _error_)
{
	GamesGame* _tmp0_;
	g_return_if_fail (core != NULL);
	g_return_if_fail (_error_ != NULL);
	self->priv->is_error = TRUE;
	_tmp0_ = self->priv->game;
	games_game_update_last_played (_tmp0_);
	g_signal_emit_by_name ((GamesRunner*) self, "crash", _error_);
}

static void
___lambda74__retro_core_crashed (RetroCore* _sender,
                                 const gchar* message,
                                 gpointer self)
{
	__lambda74_ ((GamesRetroRunner*) self, _sender, message);
}

static void
_vala_array_add32 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
__lambda75_ (Block22Data* _data22_,
             GamesMedia* media)
{
	GamesRetroRunner* self;
	GamesUri** uris = NULL;
	gint _tmp0_ = 0;
	GamesUri** _tmp1_;
	gint uris_length1;
	gint _uris_size_;
	gchar* _tmp2_ = NULL;
	GamesUri** _tmp3_;
	gint _tmp3__length1;
	gchar* _tmp8_;
	self = _data22_->self;
	g_return_if_fail (media != NULL);
	_tmp1_ = games_media_get_uris (media, &_tmp0_);
	uris = _tmp1_;
	uris_length1 = _tmp0_;
	_uris_size_ = uris_length1;
	_tmp3_ = uris;
	_tmp3__length1 = uris_length1;
	if (_tmp3__length1 == 0) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp4_;
	} else {
		GamesUri** _tmp5_;
		gint _tmp5__length1;
		GamesUri* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = uris;
		_tmp5__length1 = uris_length1;
		_tmp6_ = _tmp5_[0];
		_tmp7_ = games_uri_to_string (_tmp6_);
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp7_;
	}
	_tmp8_ = g_strdup (_tmp2_);
	_vala_array_add32 (&_data22_->medias_uris, &_data22_->medias_uris_length1, &_data22_->_medias_uris_size_, _tmp8_);
	_g_free0 (_tmp2_);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
}

static void
___lambda75__games_media_set_media_callback (GamesMedia* media,
                                             gpointer self)
{
	__lambda75_ (self, media);
}

static void
__lambda76_ (GamesRetroRunner* self)
{
	g_signal_emit (self, games_retro_runner_signals[GAMES_RETRO_RUNNER_CONTROLLERS_CHANGED_SIGNAL], 0);
}

static void
___lambda76__games_retro_input_manager_controllers_changed (GamesRetroInputManager* _sender,
                                                            gpointer self)
{
	__lambda76_ ((GamesRetroRunner*) self);
}

static void
games_retro_runner_prepare_core (GamesRetroRunner* self,
                                 GError** error)
{
	Block22Data* _data22_;
	gchar* module_path = NULL;
	RetroCoreDescriptor* _tmp0_;
	const gchar* _tmp14_;
	RetroCore* _tmp15_;
	gchar* options_path = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	gchar* platforms_dir = NULL;
	gchar* _tmp24_;
	gchar* platform_id = NULL;
	GamesGame* _tmp25_;
	GamesPlatform* _tmp26_;
	GamesPlatform* _tmp27_;
	gchar* _tmp28_;
	RetroCore* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	RetroCore* _tmp36_;
	const gchar* _tmp37_;
	RetroCore* _tmp38_;
	RetroCore* _tmp39_;
	RetroCore* _tmp40_;
	RetroCoreView* _tmp41_;
	RetroCore* _tmp42_;
	gchar** _tmp43_;
	GamesMediaSet* _tmp44_;
	GamesMediaSet* _tmp45_;
	RetroCore* _tmp46_;
	gchar** _tmp47_;
	gint _tmp47__length1;
	RetroCore* _tmp48_;
	gchar** _tmp49_;
	gint _tmp49__length1;
	RetroCore* _tmp55_;
	RetroCoreView* _tmp56_;
	GamesRetroInputManager* _tmp57_;
	GamesRetroInputManager* _tmp58_;
	gint _tmp59_ = 0;
	GamesInputMode* _tmp60_;
	GamesInputMode* _tmp61_;
	gint _tmp61__length1;
	GamesInputMode _tmp62_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data22_ = g_slice_new0 (Block22Data);
	_data22_->_ref_count_ = 1;
	_data22_->self = g_object_ref (self);
	_tmp0_ = self->priv->core_descriptor;
	if (_tmp0_ != NULL) {
		GFile* module_file = NULL;
		RetroCoreDescriptor* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp8_;
		gchar* _tmp9_;
		_tmp1_ = self->priv->core_descriptor;
		_tmp2_ = retro_core_descriptor_get_module_file (_tmp1_, &_inner_error0_);
		module_file = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (module_path);
			block22_data_unref (_data22_);
			_data22_ = NULL;
			return;
		}
		_tmp3_ = module_file;
		if (_tmp3_ == NULL) {
			gchar* _tmp4_ = NULL;
			RetroCoreDescriptor* _tmp5_;
			gchar* _tmp6_;
			GError* _tmp7_;
			_tmp5_ = self->priv->core_descriptor;
			_tmp6_ = retro_core_descriptor_get_name (_tmp5_, &_inner_error0_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (module_file);
				_g_free0 (module_path);
				block22_data_unref (_data22_);
				_data22_ = NULL;
				return;
			}
			_tmp7_ = g_error_new (GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND, "No module found for “%s”.", _tmp4_);
			_inner_error0_ = _tmp7_;
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp4_);
			_g_object_unref0 (module_file);
			_g_free0 (module_path);
			block22_data_unref (_data22_);
			_data22_ = NULL;
			return;
		}
		_tmp8_ = module_file;
		_tmp9_ = g_file_get_path (_tmp8_);
		_g_free0 (module_path);
		module_path = _tmp9_;
		_g_object_unref0 (module_file);
	} else {
		gchar* _tmp10_ = NULL;
		GamesRetroCoreSource* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = self->priv->core_source;
		_tmp12_ = games_retro_core_source_get_module_path (_tmp11_, &_inner_error0_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (module_path);
			block22_data_unref (_data22_);
			_data22_ = NULL;
			return;
		}
		_tmp13_ = _tmp10_;
		_tmp10_ = NULL;
		_g_free0 (module_path);
		module_path = _tmp13_;
		_g_free0 (_tmp10_);
	}
	_tmp14_ = module_path;
	_tmp15_ = retro_core_new (_tmp14_);
	_g_object_unref0 (self->priv->core);
	self->priv->core = _tmp15_;
	_tmp16_ = games_retro_runner_get_options_path (self, &_inner_error0_);
	options_path = _tmp16_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (module_path);
		block22_data_unref (_data22_);
		_data22_ = NULL;
		return;
	}
	_tmp17_ = options_path;
	if (g_file_test (_tmp17_, G_FILE_TEST_EXISTS)) {
		{
			GamesRetroOptions* options = NULL;
			const gchar* _tmp18_;
			GamesRetroOptions* _tmp19_;
			GamesRetroOptions* _tmp20_;
			RetroCore* _tmp21_;
			_tmp18_ = options_path;
			_tmp19_ = games_retro_options_new (_tmp18_, &_inner_error0_);
			options = _tmp19_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp20_ = options;
			_tmp21_ = self->priv->core;
			games_retro_options_apply (_tmp20_, _tmp21_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (options);
				goto __catch0_g_error;
			}
			_g_object_unref0 (options);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp22_;
			const gchar* _tmp23_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			g_critical ("retro-runner.vala:172: %s", _tmp23_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (options_path);
			_g_free0 (module_path);
			block22_data_unref (_data22_);
			_data22_ = NULL;
			return;
		}
	}
	_tmp24_ = games_application_get_platforms_dir ();
	platforms_dir = _tmp24_;
	_tmp25_ = self->priv->game;
	_tmp26_ = games_game_get_platform (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = games_platform_get_id (_tmp27_);
	platform_id = _tmp28_;
	_tmp29_ = self->priv->core;
	_tmp30_ = platforms_dir;
	_tmp31_ = string_to_string (_tmp30_);
	_tmp32_ = platform_id;
	_tmp33_ = string_to_string (_tmp32_);
	_tmp34_ = g_strconcat (_tmp31_, "/", _tmp33_, "/system", NULL);
	_tmp35_ = _tmp34_;
	retro_core_set_system_directory (_tmp29_, _tmp35_);
	_g_free0 (_tmp35_);
	_tmp36_ = self->priv->core;
	_tmp37_ = self->priv->tmp_save_dir;
	retro_core_set_save_directory (_tmp36_, _tmp37_);
	_tmp38_ = self->priv->core;
	g_signal_connect (_tmp38_, "log", (GCallback) _retro_g_log_retro_core_log, NULL);
	_tmp39_ = self->priv->core;
	g_signal_connect_object (_tmp39_, "shutdown", (GCallback) _games_runner_stop_retro_core_shutdown, (GamesRunner*) self, 0);
	_tmp40_ = self->priv->core;
	g_signal_connect_object (_tmp40_, "crashed", (GCallback) ___lambda74__retro_core_crashed, self, 0);
	_tmp41_ = self->priv->view;
	_tmp42_ = self->priv->core;
	retro_core_view_set_core (_tmp41_, _tmp42_);
	_tmp43_ = g_new0 (gchar*, 0 + 1);
	_data22_->medias_uris = _tmp43_;
	_data22_->medias_uris_length1 = 0;
	_data22_->_medias_uris_size_ = _data22_->medias_uris_length1;
	_tmp44_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp45_ = _tmp44_;
	games_media_set_foreach_media (_tmp45_, ___lambda75__games_media_set_media_callback, _data22_);
	_tmp46_ = self->priv->core;
	_tmp47_ = _data22_->medias_uris;
	_tmp47__length1 = _data22_->medias_uris_length1;
	retro_core_set_medias (_tmp46_, _tmp47_);
	_tmp48_ = self->priv->core;
	retro_core_boot (_tmp48_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (platform_id);
		_g_free0 (platforms_dir);
		_g_free0 (options_path);
		_g_free0 (module_path);
		block22_data_unref (_data22_);
		_data22_ = NULL;
		return;
	}
	_tmp49_ = _data22_->medias_uris;
	_tmp49__length1 = _data22_->medias_uris_length1;
	if (_tmp49__length1 > 0) {
		RetroCore* _tmp50_;
		GamesMediaSet* _tmp51_;
		GamesMediaSet* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		_tmp50_ = self->priv->core;
		_tmp51_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp52_ = _tmp51_;
		_tmp53_ = games_media_set_get_selected_media_number (_tmp52_);
		_tmp54_ = _tmp53_;
		retro_core_set_current_media (_tmp50_, (guint) _tmp54_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (platform_id);
			_g_free0 (platforms_dir);
			_g_free0 (options_path);
			_g_free0 (module_path);
			block22_data_unref (_data22_);
			_data22_ = NULL;
			return;
		}
	}
	_tmp55_ = self->priv->core;
	_tmp56_ = self->priv->view;
	_tmp57_ = games_retro_input_manager_new (_tmp55_, _tmp56_);
	_g_object_unref0 (self->priv->input_manager);
	self->priv->input_manager = _tmp57_;
	_tmp58_ = self->priv->input_manager;
	g_signal_connect_object (_tmp58_, "controllers-changed", (GCallback) ___lambda76__games_retro_input_manager_controllers_changed, self, 0);
	_tmp60_ = games_runner_get_available_input_modes ((GamesRunner*) self, &_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp61__length1 = _tmp59_;
	_tmp62_ = _tmp61_[0];
	games_runner_set_input_mode ((GamesRunner*) self, _tmp62_);
	_tmp61_ = (g_free (_tmp61_), NULL);
	self->priv->core_loaded = TRUE;
	_g_free0 (platform_id);
	_g_free0 (platforms_dir);
	_g_free0 (options_path);
	_g_free0 (module_path);
	block22_data_unref (_data22_);
	_data22_ = NULL;
}

static void
games_retro_runner_real_prepare (GamesRunner* base,
                                 GError** error)
{
	GamesRetroRunner * self;
	GError* _inner_error0_ = NULL;
	self = (GamesRetroRunner*) base;
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		GamesSnapshotManager* _tmp2_ = NULL;
		GamesGame* _tmp3_;
		GamesSnapshotManager* _tmp4_;
		GamesSnapshotManager* _tmp5_;
		GamesSnapshot* snapshot = NULL;
		GamesSnapshotManager* _tmp6_;
		GamesSnapshot* _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GamesSnapshot* _tmp11_;
		GamesSnapshot* _tmp31_;
		GamesSnapshot* _tmp32_;
		_tmp1_ = games_retro_runner_get_core_id (self, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (g_error_matches (_inner_error0_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND)) {
				goto __catch0_games_retro_error_module_not_found;
			}
			if (g_error_matches (_inner_error0_, GAMES_FIRMWARE_ERROR, GAMES_FIRMWARE_ERROR_FIRMWARE_NOT_FOUND)) {
				goto __catch0_games_firmware_error_firmware_not_found;
			}
			goto __catch0_g_error;
		}
		_tmp3_ = self->priv->game;
		_tmp4_ = games_snapshot_manager_new (_tmp3_, _tmp0_, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp0_);
			if (g_error_matches (_inner_error0_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND)) {
				goto __catch0_games_retro_error_module_not_found;
			}
			if (g_error_matches (_inner_error0_, GAMES_FIRMWARE_ERROR, GAMES_FIRMWARE_ERROR_FIRMWARE_NOT_FOUND)) {
				goto __catch0_games_firmware_error_firmware_not_found;
			}
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (self->priv->snapshot_manager);
		self->priv->snapshot_manager = _tmp5_;
		_tmp6_ = self->priv->snapshot_manager;
		_tmp7_ = games_snapshot_manager_get_latest_snapshot (_tmp6_);
		snapshot = _tmp7_;
		_tmp9_ = games_retro_runner_create_tmp_save_dir (self, &_inner_error0_);
		_tmp8_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (snapshot);
			_g_object_unref0 (_tmp2_);
			_g_free0 (_tmp0_);
			if (g_error_matches (_inner_error0_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND)) {
				goto __catch0_games_retro_error_module_not_found;
			}
			if (g_error_matches (_inner_error0_, GAMES_FIRMWARE_ERROR, GAMES_FIRMWARE_ERROR_FIRMWARE_NOT_FOUND)) {
				goto __catch0_games_firmware_error_firmware_not_found;
			}
			goto __catch0_g_error;
		}
		_tmp10_ = _tmp8_;
		_tmp8_ = NULL;
		_g_free0 (self->priv->tmp_save_dir);
		self->priv->tmp_save_dir = _tmp10_;
		_tmp11_ = snapshot;
		if (_tmp11_ != NULL) {
			GamesSnapshot* _tmp12_;
			const gchar* _tmp13_;
			_tmp12_ = snapshot;
			_tmp13_ = self->priv->tmp_save_dir;
			games_snapshot_copy_save_dir_to (_tmp12_, _tmp13_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp8_);
				_g_object_unref0 (snapshot);
				_g_object_unref0 (_tmp2_);
				_g_free0 (_tmp0_);
				if (g_error_matches (_inner_error0_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND)) {
					goto __catch0_games_retro_error_module_not_found;
				}
				if (g_error_matches (_inner_error0_, GAMES_FIRMWARE_ERROR, GAMES_FIRMWARE_ERROR_FIRMWARE_NOT_FOUND)) {
					goto __catch0_games_firmware_error_firmware_not_found;
				}
				goto __catch0_g_error;
			}
		} else {
			gchar* path = NULL;
			gchar* _tmp14_;
			gchar* save_ram_path = NULL;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			GFile* save_dir = NULL;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			gboolean _tmp22_ = FALSE;
			const gchar* _tmp23_;
			GFile* _tmp27_;
			const gchar* _tmp28_;
			GFile* _tmp29_;
			GFile* _tmp30_;
			_tmp14_ = games_retro_runner_get_fallback_save_directory_path (self, &_inner_error0_);
			path = _tmp14_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp8_);
				_g_object_unref0 (snapshot);
				_g_object_unref0 (_tmp2_);
				_g_free0 (_tmp0_);
				if (g_error_matches (_inner_error0_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND)) {
					goto __catch0_games_retro_error_module_not_found;
				}
				if (g_error_matches (_inner_error0_, GAMES_FIRMWARE_ERROR, GAMES_FIRMWARE_ERROR_FIRMWARE_NOT_FOUND)) {
					goto __catch0_games_firmware_error_firmware_not_found;
				}
				goto __catch0_g_error;
			}
			_tmp15_ = path;
			_tmp16_ = g_build_filename (_tmp15_, "save", NULL);
			save_ram_path = _tmp16_;
			_tmp17_ = path;
			_tmp18_ = g_build_filename (_tmp17_, "save-dir", NULL);
			_tmp19_ = _tmp18_;
			_tmp20_ = g_file_new_for_path (_tmp19_);
			_tmp21_ = _tmp20_;
			_g_free0 (_tmp19_);
			save_dir = _tmp21_;
			_tmp23_ = save_ram_path;
			if (g_file_test (_tmp23_, G_FILE_TEST_EXISTS)) {
				RetroCore* _tmp24_;
				_tmp24_ = self->priv->core;
				_tmp22_ = retro_core_get_memory_size (_tmp24_, RETRO_MEMORY_TYPE_SAVE_RAM) > ((gsize) 0);
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				RetroCore* _tmp25_;
				const gchar* _tmp26_;
				_tmp25_ = self->priv->core;
				_tmp26_ = save_ram_path;
				retro_core_load_memory (_tmp25_, RETRO_MEMORY_TYPE_SAVE_RAM, _tmp26_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (save_dir);
					_g_free0 (save_ram_path);
					_g_free0 (path);
					_g_free0 (_tmp8_);
					_g_object_unref0 (snapshot);
					_g_object_unref0 (_tmp2_);
					_g_free0 (_tmp0_);
					if (g_error_matches (_inner_error0_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND)) {
						goto __catch0_games_retro_error_module_not_found;
					}
					if (g_error_matches (_inner_error0_, GAMES_FIRMWARE_ERROR, GAMES_FIRMWARE_ERROR_FIRMWARE_NOT_FOUND)) {
						goto __catch0_games_firmware_error_firmware_not_found;
					}
					goto __catch0_g_error;
				}
			}
			_tmp27_ = save_dir;
			_tmp28_ = self->priv->tmp_save_dir;
			_tmp29_ = g_file_new_for_path (_tmp28_);
			_tmp30_ = _tmp29_;
			games_file_operations_copy_contents (_tmp27_, _tmp30_, &_inner_error0_);
			_g_object_unref0 (_tmp30_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (save_dir);
				_g_free0 (save_ram_path);
				_g_free0 (path);
				_g_free0 (_tmp8_);
				_g_object_unref0 (snapshot);
				_g_object_unref0 (_tmp2_);
				_g_free0 (_tmp0_);
				if (g_error_matches (_inner_error0_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND)) {
					goto __catch0_games_retro_error_module_not_found;
				}
				if (g_error_matches (_inner_error0_, GAMES_FIRMWARE_ERROR, GAMES_FIRMWARE_ERROR_FIRMWARE_NOT_FOUND)) {
					goto __catch0_games_firmware_error_firmware_not_found;
				}
				goto __catch0_g_error;
			}
			_g_object_unref0 (save_dir);
			_g_free0 (save_ram_path);
			_g_free0 (path);
		}
		games_retro_runner_prepare_core (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp8_);
			_g_object_unref0 (snapshot);
			_g_object_unref0 (_tmp2_);
			_g_free0 (_tmp0_);
			if (g_error_matches (_inner_error0_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND)) {
				goto __catch0_games_retro_error_module_not_found;
			}
			if (g_error_matches (_inner_error0_, GAMES_FIRMWARE_ERROR, GAMES_FIRMWARE_ERROR_FIRMWARE_NOT_FOUND)) {
				goto __catch0_games_firmware_error_firmware_not_found;
			}
			goto __catch0_g_error;
		}
		_tmp31_ = snapshot;
		games_retro_runner_reset_with_snapshot (self, _tmp31_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp8_);
			_g_object_unref0 (snapshot);
			_g_object_unref0 (_tmp2_);
			_g_free0 (_tmp0_);
			if (g_error_matches (_inner_error0_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND)) {
				goto __catch0_games_retro_error_module_not_found;
			}
			if (g_error_matches (_inner_error0_, GAMES_FIRMWARE_ERROR, GAMES_FIRMWARE_ERROR_FIRMWARE_NOT_FOUND)) {
				goto __catch0_games_firmware_error_firmware_not_found;
			}
			goto __catch0_g_error;
		}
		_tmp32_ = snapshot;
		if (_tmp32_ != NULL) {
			GamesSnapshot* _tmp33_;
			_tmp33_ = snapshot;
			games_runner_preview_snapshot ((GamesRunner*) self, _tmp33_);
		}
		_g_free0 (_tmp8_);
		_g_object_unref0 (snapshot);
		_g_object_unref0 (_tmp2_);
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_games_retro_error_module_not_found:
	{
		GError* e = NULL;
		GError* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		GError* _tmp38_;
		GError* _tmp39_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp34_ = e;
		_tmp35_ = _tmp34_->message;
		g_debug ("retro-runner.vala:245: %s\n", _tmp35_);
		_tmp36_ = games_retro_runner_get_unsupported_system_message (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_error_new_literal (GAMES_RUNNER_ERROR, GAMES_RUNNER_ERROR_UNSUPPORTED_SYSTEM, _tmp37_);
		_tmp39_ = _tmp38_;
		_g_free0 (_tmp37_);
		_inner_error0_ = _tmp39_;
		_g_error_free0 (e);
		goto __finally0;
	}
	goto __finally0;
	__catch0_games_firmware_error_firmware_not_found:
	{
		GError* e = NULL;
		GError* _tmp40_;
		const gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		GError* _tmp44_;
		GError* _tmp45_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp40_ = e;
		_tmp41_ = _tmp40_->message;
		g_debug ("retro-runner.vala:249: %s\n", _tmp41_);
		_tmp42_ = games_retro_runner_get_unsupported_system_message (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_error_new_literal (GAMES_RUNNER_ERROR, GAMES_RUNNER_ERROR_UNSUPPORTED_SYSTEM, _tmp43_);
		_tmp45_ = _tmp44_;
		_g_free0 (_tmp43_);
		_inner_error0_ = _tmp45_;
		_g_error_free0 (e);
		goto __finally0;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp46_;
		const gchar* _tmp47_;
		GError* _tmp48_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp46_ = e;
		_tmp47_ = _tmp46_->message;
		_tmp48_ = g_error_new_literal (GAMES_RUNNER_ERROR, GAMES_RUNNER_ERROR_OTHER, _tmp47_);
		_inner_error0_ = _tmp48_;
		_g_error_free0 (e);
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == GAMES_RUNNER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
games_retro_runner_real_start (GamesRunner* base,
                               GError** error)
{
	GamesRetroRunner * self;
	self = (GamesRetroRunner*) base;
	_vala_assert (self->priv->core_loaded, "core_loaded");
	games_runner_resume ((GamesRunner*) self);
}

static void
games_retro_runner_real_resume (GamesRunner* base)
{
	GamesRetroRunner * self;
	RetroCore* _tmp0_;
	self = (GamesRetroRunner*) base;
	if (!self->priv->core_loaded) {
		return;
	}
	_tmp0_ = self->priv->core;
	retro_core_run (_tmp0_);
	games_retro_runner_set_running (self, TRUE);
}

static void
games_retro_runner_real_pause (GamesRunner* base)
{
	GamesRetroRunner * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (GamesRetroRunner*) base;
	if (!self->priv->core_loaded) {
		return;
	}
	_tmp0_ = games_retro_runner_get_running (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	if (!self->priv->is_error) {
		RetroCoreView* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		RetroCore* _tmp5_;
		_tmp2_ = self->priv->view;
		_tmp3_ = retro_core_view_get_pixbuf (_tmp2_);
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_g_object_unref0 (self->priv->current_state_pixbuf);
		self->priv->current_state_pixbuf = _tmp4_;
		_tmp5_ = self->priv->core;
		retro_core_stop (_tmp5_);
	}
	games_retro_runner_set_running (self, FALSE);
}

static gchar*
games_retro_runner_get_fallback_save_directory_path (GamesRetroRunner* self,
                                                     GError** error)
{
	GamesUid* uid = NULL;
	GamesGame* _tmp0_;
	GamesUid* _tmp1_;
	GamesUid* _tmp2_;
	GamesUid* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* core_id_prefix = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = games_game_get_uid (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	uid = _tmp3_;
	_tmp5_ = games_retro_runner_get_core_id (self, &_inner_error0_);
	_tmp4_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (uid);
		return NULL;
	}
	_tmp6_ = string_replace (_tmp4_, ".libretro", "");
	core_id_prefix = _tmp6_;
	_tmp7_ = games_application_get_data_dir ();
	_tmp8_ = _tmp7_;
	_tmp9_ = games_uid_to_string (uid);
	_tmp10_ = _tmp9_;
	_tmp11_ = core_id_prefix;
	_tmp12_ = string_to_string (_tmp11_);
	_tmp13_ = g_strconcat (_tmp10_, "-", _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_build_filename (_tmp8_, "savestates", _tmp14_, "global", NULL);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	result = _tmp16_;
	_g_free0 (core_id_prefix);
	_g_free0 (_tmp4_);
	_g_object_unref0 (uid);
	return result;
}

static void
games_retro_runner_real_stop (GamesRunner* base)
{
	GamesRetroRunner * self;
	gboolean _tmp0_ = FALSE;
	GamesGame* _tmp24_;
	GError* _inner_error0_ = NULL;
	self = (GamesRetroRunner*) base;
	if (!self->priv->core_loaded) {
		return;
	}
	if (!self->priv->is_error) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = games_runner_get_supports_snapshots ((GamesRunner*) self);
		_tmp2_ = _tmp1_;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			gchar* path = NULL;
			gchar* _tmp3_;
			RetroCore* _tmp4_;
			GFile* tmp_dir = NULL;
			const gchar* _tmp9_;
			GFile* _tmp10_;
			GFile* dest_dir = NULL;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			GFile* _tmp14_;
			GFile* _tmp15_;
			GFile* _tmp16_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			_tmp3_ = games_retro_runner_get_fallback_save_directory_path (self, &_inner_error0_);
			path = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp4_ = self->priv->core;
			if (retro_core_get_memory_size (_tmp4_, RETRO_MEMORY_TYPE_SAVE_RAM) > ((gsize) 0)) {
				RetroCore* _tmp5_;
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp5_ = self->priv->core;
				_tmp6_ = path;
				_tmp7_ = g_build_filename (_tmp6_, "save", NULL);
				_tmp8_ = _tmp7_;
				retro_core_save_memory (_tmp5_, RETRO_MEMORY_TYPE_SAVE_RAM, _tmp8_, &_inner_error0_);
				_g_free0 (_tmp8_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (path);
					goto __catch0_g_error;
				}
			}
			_tmp9_ = self->priv->tmp_save_dir;
			_tmp10_ = g_file_new_for_path (_tmp9_);
			tmp_dir = _tmp10_;
			_tmp11_ = path;
			_tmp12_ = g_build_filename (_tmp11_, "save-dir", NULL);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_file_new_for_path (_tmp13_);
			_tmp15_ = _tmp14_;
			_g_free0 (_tmp13_);
			dest_dir = _tmp15_;
			_tmp16_ = dest_dir;
			if (g_file_query_exists (_tmp16_, NULL)) {
				GFile* _tmp17_;
				gchar** _tmp18_;
				gchar** _tmp19_;
				gint _tmp19__length1;
				_tmp17_ = dest_dir;
				_tmp18_ = g_new0 (gchar*, 0 + 1);
				_tmp19_ = _tmp18_;
				_tmp19__length1 = 0;
				games_file_operations_delete_files (_tmp17_, _tmp19_, (gint) 0, &_inner_error0_);
				_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (dest_dir);
					_g_object_unref0 (tmp_dir);
					_g_free0 (path);
					goto __catch0_g_error;
				}
			}
			_tmp20_ = tmp_dir;
			_tmp21_ = dest_dir;
			games_file_operations_copy_contents (_tmp20_, _tmp21_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (dest_dir);
				_g_object_unref0 (tmp_dir);
				_g_free0 (path);
				goto __catch0_g_error;
			}
			_g_object_unref0 (dest_dir);
			_g_object_unref0 (tmp_dir);
			_g_free0 (path);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp22_;
			const gchar* _tmp23_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp22_ = e;
			_tmp23_ = _tmp22_->message;
			g_critical ("retro-runner.vala:316: Failed to create snapshot: %s", _tmp23_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp24_ = self->priv->game;
	games_game_update_last_played (_tmp24_);
	games_retro_runner_deinit (self);
	g_signal_emit_by_name ((GamesRunner*) self, "stopped");
}

static void
_games_retro_runner_on_video_filter_changed_g_settings_changed (GSettings* _sender,
                                                                const gchar* key,
                                                                gpointer self)
{
	games_retro_runner_on_video_filter_changed ((GamesRetroRunner*) self);
}

static void
games_retro_runner_deinit (GamesRetroRunner* self)
{
	GSettings* _tmp0_;
	guint _tmp1_;
	GQuark _tmp2_;
	gboolean _tmp3_ = FALSE;
	RetroCoreView* _tmp8_;
	g_return_if_fail (self != NULL);
	if (!self->priv->core_loaded) {
		return;
	}
	_tmp0_ = self->priv->settings;
	g_signal_parse_name ("changed::video-filter", g_settings_get_type (), &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _games_retro_runner_on_video_filter_changed_g_settings_changed, self);
	_g_object_unref0 (self->priv->input_manager);
	self->priv->input_manager = NULL;
	if (!self->priv->is_error) {
		RetroCore* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp4_ = self->priv->core;
		_tmp5_ = retro_core_get_is_initiated (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp3_ = _tmp6_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		RetroCore* _tmp7_;
		_tmp7_ = self->priv->core;
		retro_core_stop (_tmp7_);
	}
	_g_object_unref0 (self->priv->core);
	self->priv->core = NULL;
	_tmp8_ = self->priv->view;
	if (_tmp8_ != NULL) {
		RetroCoreView* _tmp9_;
		_tmp9_ = self->priv->view;
		retro_core_view_set_core (_tmp9_, NULL);
		_g_object_unref0 (self->priv->view);
		self->priv->view = NULL;
	}
	self->priv->_running = FALSE;
	self->priv->core_loaded = FALSE;
}

static void
_games_retro_runner_save_to_snapshot_games_snapshot_manager_snapshot_func (GamesSnapshot* snapshot,
                                                                           gpointer self,
                                                                           GError** error)
{
	games_retro_runner_save_to_snapshot ((GamesRetroRunner*) self, snapshot, error);
}

static GamesSnapshot*
games_retro_runner_real_try_create_snapshot (GamesRunner* base,
                                             gboolean is_automatic)
{
	GamesRetroRunner * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError* _inner_error0_ = NULL;
	GamesSnapshot* result;
	self = (GamesRetroRunner*) base;
	_tmp0_ = games_runner_get_supports_snapshots ((GamesRunner*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		result = NULL;
		return result;
	}
	if (!is_automatic) {
		g_signal_emit_by_name ((GamesRunner*) self, "snapshot-created");
	}
	{
		GamesSnapshot* _tmp2_ = NULL;
		GamesSnapshotManager* _tmp3_;
		GamesSnapshot* _tmp4_;
		GamesSnapshot* _tmp5_;
		_tmp3_ = self->priv->snapshot_manager;
		_tmp4_ = games_snapshot_manager_create_snapshot (_tmp3_, is_automatic, _games_retro_runner_save_to_snapshot_games_snapshot_manager_snapshot_func, self, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		result = _tmp5_;
		_g_object_unref0 (_tmp2_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("retro-runner.vala:358: Failed to create snapshot: %s", _tmp7_);
		result = NULL;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
games_retro_runner_real_delete_snapshot (GamesRunner* base,
                                         GamesSnapshot* snapshot)
{
	GamesRetroRunner * self;
	GamesSnapshotManager* _tmp0_;
	self = (GamesRetroRunner*) base;
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = self->priv->snapshot_manager;
	games_snapshot_manager_delete_snapshot (_tmp0_, snapshot);
}

static void
games_retro_runner_real_preview_snapshot (GamesRunner* base,
                                          GamesSnapshot* snapshot)
{
	GamesRetroRunner * self;
	GamesSnapshot* _tmp0_;
	gchar* screenshot_path = NULL;
	gchar* _tmp1_;
	GdkPixbuf* pixbuf = NULL;
	RetroCoreView* _tmp10_;
	GdkPixbuf* _tmp11_;
	GError* _inner_error0_ = NULL;
	self = (GamesRetroRunner*) base;
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = _g_object_ref0 (snapshot);
	_g_object_unref0 (self->priv->previewed_snapshot);
	self->priv->previewed_snapshot = _tmp0_;
	_tmp1_ = games_snapshot_get_screenshot_path (snapshot);
	screenshot_path = _tmp1_;
	pixbuf = NULL;
	{
		GdkPixbuf* _tmp2_ = NULL;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		gdouble aspect_ratio = 0.0;
		gdouble _tmp5_;
		gdouble _tmp6_;
		_tmp3_ = gdk_pixbuf_new_from_file (screenshot_path, &_inner_error0_);
		_tmp2_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp4_;
		_tmp5_ = games_snapshot_get_screenshot_aspect_ratio (snapshot);
		_tmp6_ = _tmp5_;
		aspect_ratio = _tmp6_;
		if (aspect_ratio != ((gdouble) 0)) {
			GdkPixbuf* _tmp7_;
			_tmp7_ = pixbuf;
			retro_pixbuf_set_aspect_ratio (_tmp7_, (gfloat) aspect_ratio);
		}
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("retro-runner.vala:385: Couldn't load %s: %s", screenshot_path, _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pixbuf);
		_g_free0 (screenshot_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp10_ = self->priv->view;
	_tmp11_ = pixbuf;
	retro_core_view_set_pixbuf (_tmp10_, _tmp11_);
	_g_object_unref0 (pixbuf);
	_g_free0 (screenshot_path);
}

static void
games_retro_runner_real_preview_current_state (GamesRunner* base)
{
	GamesRetroRunner * self;
	RetroCoreView* _tmp0_;
	GdkPixbuf* _tmp1_;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->view;
	_tmp1_ = self->priv->current_state_pixbuf;
	retro_core_view_set_pixbuf (_tmp0_, _tmp1_);
}

static void
games_retro_runner_real_load_previewed_snapshot (GamesRunner* base,
                                                 GError** error)
{
	GamesRetroRunner * self;
	GamesSnapshot* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->previewed_snapshot;
	games_retro_runner_load_from_snapshot (self, _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static GamesSnapshot**
games_retro_runner_real_get_snapshots (GamesRunner* base,
                                       gint* result_length1)
{
	GamesRetroRunner * self;
	GamesSnapshotManager* _tmp0_;
	GamesSnapshotManager* _tmp3_;
	gint _tmp4_ = 0;
	GamesSnapshot** _tmp5_;
	GamesSnapshot** _tmp6_;
	gint _tmp6__length1;
	GamesSnapshot** result;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->snapshot_manager;
	if (_tmp0_ == NULL) {
		GamesSnapshot** _tmp1_;
		GamesSnapshot** _tmp2_;
		gint _tmp2__length1;
		_tmp1_ = g_new0 (GamesSnapshot*, 0 + 1);
		_tmp2_ = _tmp1_;
		_tmp2__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp2__length1;
		}
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->priv->snapshot_manager;
	_tmp5_ = games_snapshot_manager_get_snapshots (_tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static void
_vala_array_add33 (GamesInputMode* * array,
                   gint* length,
                   gint* size,
                   GamesInputMode value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesInputMode, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static void
_vala_array_add34 (GamesInputMode* * array,
                   gint* length,
                   gint* size,
                   GamesInputMode value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesInputMode, *array, *size);
	}
	(*array)[(*length)++] = value;
}

static GamesInputMode*
games_retro_runner_real_get_available_input_modes (GamesRunner* base,
                                                   gint* result_length1)
{
	GamesRetroRunner * self;
	GamesInputCapabilities* _tmp0_;
	GamesInputMode* modes = NULL;
	GamesInputMode* _tmp3_;
	gint modes_length1;
	gint _modes_size_;
	GamesInputCapabilities* _tmp4_;
	GamesInputCapabilities* _tmp5_;
	GamesInputMode* _tmp6_;
	gint _tmp6__length1;
	GamesInputMode* result;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->_input_capabilities;
	if (_tmp0_ == NULL) {
		GamesInputMode* _tmp1_;
		GamesInputMode* _tmp2_;
		gint _tmp2__length1;
		_tmp1_ = g_new0 (GamesInputMode, 1);
		_tmp1_[0] = GAMES_INPUT_MODE_GAMEPAD;
		_tmp2_ = _tmp1_;
		_tmp2__length1 = 1;
		if (result_length1) {
			*result_length1 = _tmp2__length1;
		}
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_new0 (GamesInputMode, 0);
	modes = _tmp3_;
	modes_length1 = 0;
	_modes_size_ = modes_length1;
	_tmp4_ = self->priv->_input_capabilities;
	if (games_input_capabilities_get_allow_gamepad_mode (_tmp4_)) {
		_vala_array_add33 (&modes, &modes_length1, &_modes_size_, GAMES_INPUT_MODE_GAMEPAD);
	}
	_tmp5_ = self->priv->_input_capabilities;
	if (games_input_capabilities_get_allow_keyboard_mode (_tmp5_)) {
		_vala_array_add34 (&modes, &modes_length1, &_modes_size_, GAMES_INPUT_MODE_KEYBOARD);
	}
	_tmp6_ = modes;
	_tmp6__length1 = modes_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

static gboolean
games_retro_runner_real_key_press_event (GamesRetroRunner* self,
                                         guint keyval,
                                         GdkModifierType state)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
games_retro_runner_key_press_event (GamesRetroRunner* self,
                                    guint keyval,
                                    GdkModifierType state)
{
	GamesRetroRunnerClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = GAMES_RETRO_RUNNER_GET_CLASS (self);
	if (_klass_->key_press_event) {
		return _klass_->key_press_event (self, keyval, state);
	}
	return FALSE;
}

static gboolean
games_retro_runner_real_gamepad_button_press_event (GamesRetroRunner* self,
                                                    guint16 button)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
games_retro_runner_gamepad_button_press_event (GamesRetroRunner* self,
                                               guint16 button)
{
	GamesRetroRunnerClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = GAMES_RETRO_RUNNER_GET_CLASS (self);
	if (_klass_->gamepad_button_press_event) {
		return _klass_->gamepad_button_press_event (self, button);
	}
	return FALSE;
}

static void
games_retro_runner_on_media_number_changed (GamesRetroRunner* self)
{
	gint media_number = 0;
	GamesMediaSet* _tmp7_;
	GamesMediaSet* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GamesMedia* media = NULL;
	GamesUri** uris = NULL;
	GamesMedia* _tmp18_;
	gint _tmp19_ = 0;
	GamesUri** _tmp20_;
	gint uris_length1;
	gint _uris_size_;
	GamesUri** _tmp21_;
	gint _tmp21__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!self->priv->core_loaded) {
		return;
	}
	{
		RetroCore* _tmp0_;
		GamesMediaSet* _tmp1_;
		GamesMediaSet* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp0_ = self->priv->core;
		_tmp1_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp2_ = _tmp1_;
		_tmp3_ = games_media_set_get_selected_media_number (_tmp2_);
		_tmp4_ = _tmp3_;
		retro_core_set_current_media (_tmp0_, (guint) _tmp4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_debug ("retro-runner.vala:437: %s", _tmp6_);
		_g_error_free0 (e);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = games_media_set_get_selected_media_number (_tmp8_);
	_tmp10_ = _tmp9_;
	media_number = _tmp10_;
	media = NULL;
	{
		GamesMedia* _tmp11_ = NULL;
		GamesMediaSet* _tmp12_;
		GamesMediaSet* _tmp13_;
		GamesMedia* _tmp14_;
		GamesMedia* _tmp15_;
		_tmp12_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = games_media_set_get_selected_media (_tmp13_, (guint) media_number, &_inner_error0_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		_g_object_unref0 (media);
		media = _tmp15_;
		_g_object_unref0 (_tmp11_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		const gchar* _tmp17_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->message;
		g_warning ("retro-runner.vala:449: %s", _tmp17_);
		_g_error_free0 (e);
		_g_object_unref0 (media);
		return;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (media);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp18_ = media;
	_tmp20_ = games_media_get_uris (_tmp18_, &_tmp19_);
	uris = _tmp20_;
	uris_length1 = _tmp19_;
	_uris_size_ = uris_length1;
	_tmp21_ = uris;
	_tmp21__length1 = uris_length1;
	if (_tmp21__length1 == 0) {
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
		_g_object_unref0 (media);
		return;
	}
	{
		RetroCore* _tmp22_;
		GamesMediaSet* _tmp23_;
		GamesMediaSet* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		_tmp22_ = self->priv->core;
		_tmp23_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp24_ = _tmp23_;
		_tmp25_ = games_media_set_get_selected_media_number (_tmp24_);
		_tmp26_ = _tmp25_;
		retro_core_set_current_media (_tmp22_, (guint) _tmp26_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp27_;
		const gchar* _tmp28_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp27_ = e;
		_tmp28_ = _tmp27_->message;
		g_debug ("retro-runner.vala:462: %s", _tmp28_);
		_g_error_free0 (e);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
		_g_object_unref0 (media);
		return;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
		_g_object_unref0 (media);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
	_g_object_unref0 (media);
}

RetroCore*
games_retro_runner_get_core (GamesRetroRunner* self)
{
	RetroCore* _tmp0_;
	RetroCore* _tmp1_;
	RetroCore* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->core;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
g_date_time_to_string (GDateTime* self)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}

static void
games_retro_runner_save_screenshot (GamesRetroRunner* self,
                                    const gchar* path,
                                    GError** error)
{
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GDateTime* now = NULL;
	GDateTime* _tmp3_;
	gchar* creation_time = NULL;
	GDateTime* _tmp4_;
	gchar* _tmp5_;
	gchar* game_title = NULL;
	GamesGame* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GamesPlatform* platform = NULL;
	GamesGame* _tmp10_;
	GamesPlatform* _tmp11_;
	GamesPlatform* _tmp12_;
	GamesPlatform* _tmp13_;
	gchar* platform_name = NULL;
	GamesPlatform* _tmp14_;
	gchar* _tmp15_;
	gchar* platform_id = NULL;
	GamesPlatform* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	GdkPixbuf* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->current_state_pixbuf;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	pixbuf = _tmp1_;
	_tmp2_ = pixbuf;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (pixbuf);
		return;
	}
	_tmp3_ = g_date_time_new_now_local ();
	now = _tmp3_;
	_tmp4_ = now;
	_tmp5_ = g_date_time_to_string (_tmp4_);
	creation_time = _tmp5_;
	_tmp6_ = self->priv->game;
	_tmp7_ = games_game_get_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	game_title = _tmp9_;
	_tmp10_ = self->priv->game;
	_tmp11_ = games_game_get_platform (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	platform = _tmp13_;
	_tmp14_ = platform;
	_tmp15_ = games_platform_get_name (_tmp14_);
	platform_name = _tmp15_;
	_tmp16_ = platform;
	_tmp17_ = games_platform_get_id (_tmp16_);
	platform_id = _tmp17_;
	_tmp18_ = platform_name;
	if (_tmp18_ == NULL) {
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp19_ = platform_id;
		g_critical ("retro-runner.vala:484: Unknown name for platform %s", _tmp19_);
		_tmp20_ = g_strdup (_ ("Unknown platform"));
		_g_free0 (platform_name);
		platform_name = _tmp20_;
	}
	_tmp21_ = pixbuf;
	_tmp22_ = game_title;
	_tmp23_ = string_to_string (_tmp22_);
	_tmp24_ = platform_name;
	_tmp25_ = string_to_string (_tmp24_);
	_tmp26_ = g_strconcat ("Screenshot of ", _tmp23_, " on ", _tmp25_, NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = creation_time;
	_tmp29_ = string_to_string (_tmp28_);
	_tmp30_ = game_title;
	_tmp31_ = platform_name;
	gdk_pixbuf_save (_tmp21_, path, "png", &_inner_error0_, "tEXt::Software", "GNOME Games", "tEXt::Title", _tmp27_, "tEXt::Creation Time", _tmp29_, "tEXt::Game Title", _tmp30_, "tEXt::Platform", _tmp31_, NULL, NULL);
	_g_free0 (_tmp27_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (platform_id);
		_g_free0 (platform_name);
		_g_object_unref0 (platform);
		_g_free0 (game_title);
		_g_free0 (creation_time);
		_g_date_time_unref0 (now);
		_g_object_unref0 (pixbuf);
		return;
	}
	_g_free0 (platform_id);
	_g_free0 (platform_name);
	_g_object_unref0 (platform);
	_g_free0 (game_title);
	_g_free0 (creation_time);
	_g_date_time_unref0 (now);
	_g_object_unref0 (pixbuf);
}

static void
games_retro_runner_load_save_ram (GamesRetroRunner* self,
                                  const gchar* save_ram_path,
                                  GError** error)
{
	RetroCore* _tmp0_;
	RetroCore* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (save_ram_path != NULL);
	if (!g_file_test (save_ram_path, G_FILE_TEST_EXISTS)) {
		return;
	}
	_tmp0_ = self->priv->core;
	if (retro_core_get_memory_size (_tmp0_, RETRO_MEMORY_TYPE_SAVE_RAM) == ((gsize) 0)) {
		return;
	}
	_tmp1_ = self->priv->core;
	retro_core_load_memory (_tmp1_, RETRO_MEMORY_TYPE_SAVE_RAM, save_ram_path, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
games_retro_runner_real_save_to_snapshot (GamesRetroRunner* self,
                                          GamesSnapshot* snapshot,
                                          GError** error)
{
	RetroCore* _tmp0_;
	GFile* tmp_dir = NULL;
	const gchar* _tmp4_;
	GFile* _tmp5_;
	GFile* dest_dir = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GamesMediaSet* _tmp12_;
	GamesMediaSet* _tmp13_;
	RetroCore* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GdkPixbuf* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = self->priv->core;
	if (retro_core_get_memory_size (_tmp0_, RETRO_MEMORY_TYPE_SAVE_RAM) > ((gsize) 0)) {
		RetroCore* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->core;
		_tmp2_ = games_snapshot_get_save_ram_path (snapshot);
		_tmp3_ = _tmp2_;
		retro_core_save_memory (_tmp1_, RETRO_MEMORY_TYPE_SAVE_RAM, _tmp3_, &_inner_error0_);
		_g_free0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
	_tmp4_ = self->priv->tmp_save_dir;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	tmp_dir = _tmp5_;
	_tmp6_ = games_snapshot_get_save_directory_path (snapshot);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_file_new_for_path (_tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	dest_dir = _tmp9_;
	_tmp10_ = tmp_dir;
	_tmp11_ = dest_dir;
	games_file_operations_copy_contents (_tmp10_, _tmp11_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest_dir);
		_g_object_unref0 (tmp_dir);
		return;
	}
	_tmp12_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp13_ = _tmp12_;
	if (games_media_set_get_size (_tmp13_) > 1) {
		GamesMediaSet* _tmp14_;
		GamesMediaSet* _tmp15_;
		_tmp14_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp15_ = _tmp14_;
		games_snapshot_set_media_data (snapshot, _tmp15_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (dest_dir);
			_g_object_unref0 (tmp_dir);
			return;
		}
	}
	_tmp16_ = self->priv->core;
	_tmp17_ = games_snapshot_get_snapshot_path (snapshot);
	_tmp18_ = _tmp17_;
	retro_core_save_state (_tmp16_, _tmp18_, &_inner_error0_);
	_g_free0 (_tmp18_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest_dir);
		_g_object_unref0 (tmp_dir);
		return;
	}
	_tmp19_ = games_snapshot_get_screenshot_path (snapshot);
	_tmp20_ = _tmp19_;
	games_retro_runner_save_screenshot (self, _tmp20_, &_inner_error0_);
	_g_free0 (_tmp20_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest_dir);
		_g_object_unref0 (tmp_dir);
		return;
	}
	_tmp21_ = self->priv->current_state_pixbuf;
	games_snapshot_set_screenshot_aspect_ratio (snapshot, (gdouble) retro_pixbuf_get_aspect_ratio (_tmp21_));
	_g_object_unref0 (dest_dir);
	_g_object_unref0 (tmp_dir);
}

void
games_retro_runner_save_to_snapshot (GamesRetroRunner* self,
                                     GamesSnapshot* snapshot,
                                     GError** error)
{
	GamesRetroRunnerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GAMES_RETRO_RUNNER_GET_CLASS (self);
	if (_klass_->save_to_snapshot) {
		_klass_->save_to_snapshot (self, snapshot, error);
	}
}

static void
games_retro_runner_real_load_from_snapshot (GamesRetroRunner* self,
                                            GamesSnapshot* snapshot,
                                            GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	RetroCore* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	RetroCore* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (snapshot != NULL);
	_tmp1_ = games_retro_runner_create_tmp_save_dir (self, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_free0 (self->priv->tmp_save_dir);
	self->priv->tmp_save_dir = _tmp2_;
	_tmp3_ = self->priv->tmp_save_dir;
	games_snapshot_copy_save_dir_to (snapshot, _tmp3_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp0_);
		return;
	}
	_tmp4_ = self->priv->core;
	_tmp5_ = self->priv->tmp_save_dir;
	retro_core_set_save_directory (_tmp4_, _tmp5_);
	_tmp6_ = games_snapshot_get_save_ram_path (snapshot);
	_tmp7_ = _tmp6_;
	games_retro_runner_load_save_ram (self, _tmp7_, &_inner_error0_);
	_g_free0 (_tmp7_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp0_);
		return;
	}
	_tmp8_ = self->priv->core;
	_tmp9_ = games_snapshot_get_snapshot_path (snapshot);
	_tmp10_ = _tmp9_;
	retro_core_load_state (_tmp8_, _tmp10_, &_inner_error0_);
	_g_free0 (_tmp10_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (_tmp0_);
		return;
	}
	if (games_snapshot_has_media_data (snapshot)) {
		gint _tmp11_ = 0;
		GamesMediaSet* _tmp12_;
		GamesMediaSet* _tmp13_;
		_tmp11_ = games_snapshot_get_media_data (snapshot, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (_tmp0_);
			return;
		}
		_tmp12_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp13_ = _tmp12_;
		games_media_set_set_selected_media_number (_tmp13_, _tmp11_);
	}
	_g_free0 (_tmp0_);
}

void
games_retro_runner_load_from_snapshot (GamesRetroRunner* self,
                                       GamesSnapshot* snapshot,
                                       GError** error)
{
	GamesRetroRunnerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GAMES_RETRO_RUNNER_GET_CLASS (self);
	if (_klass_->load_from_snapshot) {
		_klass_->load_from_snapshot (self, snapshot, error);
	}
}

static void
games_retro_runner_real_reset_with_snapshot (GamesRetroRunner* self,
                                             GamesSnapshot* last_snapshot,
                                             GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	if (last_snapshot == NULL) {
		return;
	}
	_tmp0_ = games_snapshot_get_save_ram_path (last_snapshot);
	_tmp1_ = _tmp0_;
	games_retro_runner_load_save_ram (self, _tmp1_, &_inner_error0_);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (games_snapshot_has_media_data (last_snapshot)) {
		gint _tmp2_ = 0;
		GamesMediaSet* _tmp3_;
		GamesMediaSet* _tmp4_;
		_tmp2_ = games_snapshot_get_media_data (last_snapshot, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		_tmp3_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp4_ = _tmp3_;
		games_media_set_set_selected_media_number (_tmp4_, _tmp2_);
	}
}

void
games_retro_runner_reset_with_snapshot (GamesRetroRunner* self,
                                        GamesSnapshot* last_snapshot,
                                        GError** error)
{
	GamesRetroRunnerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = GAMES_RETRO_RUNNER_GET_CLASS (self);
	if (_klass_->reset_with_snapshot) {
		_klass_->reset_with_snapshot (self, last_snapshot, error);
	}
}

GamesRetroRunner*
games_retro_runner_construct (GType object_type)
{
	GamesRetroRunner * self = NULL;
	self = (GamesRetroRunner*) g_object_new (object_type, NULL);
	return self;
}

GamesRetroRunner*
games_retro_runner_new (void)
{
	return games_retro_runner_construct (GAMES_TYPE_RETRO_RUNNER);
}

static gboolean
games_retro_runner_real_get_can_fullscreen (GamesRunner* base)
{
	gboolean result;
	GamesRetroRunner* self;
	self = (GamesRetroRunner*) base;
	result = TRUE;
	return result;
}

static gboolean
games_retro_runner_real_get_can_resume (GamesRunner* base)
{
	gboolean result;
	GamesRetroRunner* self;
	GamesSnapshotManager* _tmp0_;
	GamesSnapshotManager* _tmp1_;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->snapshot_manager;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->snapshot_manager;
	result = games_snapshot_manager_has_snapshots (_tmp1_);
	return result;
}

static gboolean
games_retro_runner_real_get_supports_snapshots (GamesRunner* base)
{
	gboolean result;
	GamesRetroRunner* self;
	RetroCore* _tmp0_;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->core;
	result = retro_core_get_can_access_state (_tmp0_);
	return result;
}

static gboolean
games_retro_runner_real_get_is_integrated (GamesRunner* base)
{
	gboolean result;
	GamesRetroRunner* self;
	self = (GamesRetroRunner*) base;
	result = TRUE;
	return result;
}

static GamesMediaSet*
games_retro_runner_real_get_media_set (GamesRunner* base)
{
	GamesMediaSet* result;
	GamesRetroRunner* self;
	GamesMediaSet* _tmp0_;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->_media_set;
	result = _tmp0_;
	return result;
}

GamesInputCapabilities*
games_retro_runner_get_input_capabilities (GamesRetroRunner* self)
{
	GamesInputCapabilities* result;
	GamesInputCapabilities* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_input_capabilities;
	result = _tmp0_;
	return result;
}

void
games_retro_runner_set_input_capabilities (GamesRetroRunner* self,
                                           GamesInputCapabilities* value)
{
	GamesInputCapabilities* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_retro_runner_get_input_capabilities (self);
	if (old_value != value) {
		GamesInputCapabilities* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_input_capabilities);
		self->priv->_input_capabilities = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_retro_runner_properties[GAMES_RETRO_RUNNER_INPUT_CAPABILITIES_PROPERTY]);
	}
}

static GamesInputMode
games_retro_runner_real_get_input_mode (GamesRunner* base)
{
	GamesInputMode result;
	GamesRetroRunner* self;
	self = (GamesRetroRunner*) base;
	result = self->priv->_input_mode;
	return result;
}

static void
games_retro_runner_real_set_input_mode (GamesRunner* base,
                                        GamesInputMode value)
{
	GamesRetroRunner* self;
	GamesRetroInputManager* _tmp0_;
	self = (GamesRetroRunner*) base;
	self->priv->_input_mode = value;
	_tmp0_ = self->priv->input_manager;
	games_retro_input_manager_set_input_mode (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, games_retro_runner_properties[GAMES_RETRO_RUNNER_INPUT_MODE_PROPERTY]);
}

static gboolean
games_retro_runner_get_running (GamesRetroRunner* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_running;
	return result;
}

static void
games_retro_runner_set_running (GamesRetroRunner* self,
                                gboolean value)
{
	RetroCoreView* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	self->priv->_running = value;
	_tmp0_ = self->priv->view;
	_tmp1_ = games_retro_runner_get_running (self);
	_tmp2_ = _tmp1_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, _tmp2_);
}

static GObject *
games_retro_runner_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GamesRetroRunner * self;
	GSettings* _tmp0_;
	RetroCoreView* _tmp1_;
	GSettings* _tmp2_;
	parent_class = G_OBJECT_CLASS (games_retro_runner_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner);
	_tmp0_ = g_settings_new ("org.gnome.Games");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = retro_core_view_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_signal_connect_object (_tmp2_, "changed::video-filter", (GCallback) _games_retro_runner_on_video_filter_changed_g_settings_changed, self, 0);
	games_retro_runner_on_video_filter_changed (self);
	return obj;
}

static void
games_retro_runner_class_init (GamesRetroRunnerClass * klass,
                               gpointer klass_data)
{
	games_retro_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesRetroRunner_private_offset);
	((GamesRetroRunnerClass *) klass)->get_extra_widget = (GamesHeaderBarWidget* (*) (GamesRetroRunner*)) games_retro_runner_real_get_extra_widget;
	((GamesRetroRunnerClass *) klass)->key_press_event = (gboolean (*) (GamesRetroRunner*, guint, GdkModifierType)) games_retro_runner_real_key_press_event;
	((GamesRetroRunnerClass *) klass)->gamepad_button_press_event = (gboolean (*) (GamesRetroRunner*, guint16)) games_retro_runner_real_gamepad_button_press_event;
	((GamesRetroRunnerClass *) klass)->save_to_snapshot = (void (*) (GamesRetroRunner*, GamesSnapshot*, GError**)) games_retro_runner_real_save_to_snapshot;
	((GamesRetroRunnerClass *) klass)->load_from_snapshot = (void (*) (GamesRetroRunner*, GamesSnapshot*, GError**)) games_retro_runner_real_load_from_snapshot;
	((GamesRetroRunnerClass *) klass)->reset_with_snapshot = (void (*) (GamesRetroRunner*, GamesSnapshot*, GError**)) games_retro_runner_real_reset_with_snapshot;
	G_OBJECT_CLASS (klass)->get_property = _vala_games_retro_runner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_retro_runner_set_property;
	G_OBJECT_CLASS (klass)->constructor = games_retro_runner_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_retro_runner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_CAN_FULLSCREEN_PROPERTY, games_retro_runner_properties[GAMES_RETRO_RUNNER_CAN_FULLSCREEN_PROPERTY] = g_param_spec_boolean ("can-fullscreen", "can-fullscreen", "can-fullscreen", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_CAN_RESUME_PROPERTY, games_retro_runner_properties[GAMES_RETRO_RUNNER_CAN_RESUME_PROPERTY] = g_param_spec_boolean ("can-resume", "can-resume", "can-resume", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_SUPPORTS_SNAPSHOTS_PROPERTY, games_retro_runner_properties[GAMES_RETRO_RUNNER_SUPPORTS_SNAPSHOTS_PROPERTY] = g_param_spec_boolean ("supports-snapshots", "supports-snapshots", "supports-snapshots", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_IS_INTEGRATED_PROPERTY, games_retro_runner_properties[GAMES_RETRO_RUNNER_IS_INTEGRATED_PROPERTY] = g_param_spec_boolean ("is-integrated", "is-integrated", "is-integrated", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_MEDIA_SET_PROPERTY, games_retro_runner_properties[GAMES_RETRO_RUNNER_MEDIA_SET_PROPERTY] = g_param_spec_object ("media-set", "media-set", "media-set", GAMES_TYPE_MEDIA_SET, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_INPUT_CAPABILITIES_PROPERTY, games_retro_runner_properties[GAMES_RETRO_RUNNER_INPUT_CAPABILITIES_PROPERTY] = g_param_spec_object ("input-capabilities", "input-capabilities", "input-capabilities", GAMES_TYPE_INPUT_CAPABILITIES, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_INPUT_MODE_PROPERTY, games_retro_runner_properties[GAMES_RETRO_RUNNER_INPUT_MODE_PROPERTY] = g_param_spec_enum ("input-mode", "input-mode", "input-mode", GAMES_TYPE_INPUT_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	games_retro_runner_signals[GAMES_RETRO_RUNNER_CONTROLLERS_CHANGED_SIGNAL] = g_signal_new ("controllers-changed", GAMES_TYPE_RETRO_RUNNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
games_retro_runner_games_runner_interface_init (GamesRunnerIface * iface,
                                                gpointer iface_data)
{
	games_retro_runner_games_runner_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_display = (GtkWidget* (*) (GamesRunner*)) games_retro_runner_real_get_display;
	iface->get_extra_widget = (GamesHeaderBarWidget* (*) (GamesRunner*)) games_retro_runner_get_extra_widget;
	iface->prepare = (void (*) (GamesRunner*, GError**)) games_retro_runner_real_prepare;
	iface->start = (void (*) (GamesRunner*, GError**)) games_retro_runner_real_start;
	iface->resume = (void (*) (GamesRunner*)) games_retro_runner_real_resume;
	iface->pause = (void (*) (GamesRunner*)) games_retro_runner_real_pause;
	iface->stop = (void (*) (GamesRunner*)) games_retro_runner_real_stop;
	iface->try_create_snapshot = (GamesSnapshot* (*) (GamesRunner*, gboolean)) games_retro_runner_real_try_create_snapshot;
	iface->delete_snapshot = (void (*) (GamesRunner*, GamesSnapshot*)) games_retro_runner_real_delete_snapshot;
	iface->preview_snapshot = (void (*) (GamesRunner*, GamesSnapshot*)) games_retro_runner_real_preview_snapshot;
	iface->preview_current_state = (void (*) (GamesRunner*)) games_retro_runner_real_preview_current_state;
	iface->load_previewed_snapshot = (void (*) (GamesRunner*, GError**)) games_retro_runner_real_load_previewed_snapshot;
	iface->get_snapshots = (GamesSnapshot** (*) (GamesRunner*, gint*)) games_retro_runner_real_get_snapshots;
	iface->get_available_input_modes = (GamesInputMode* (*) (GamesRunner*, gint*)) games_retro_runner_real_get_available_input_modes;
	iface->key_press_event = (gboolean (*) (GamesRunner*, guint, GdkModifierType)) games_retro_runner_key_press_event;
	iface->gamepad_button_press_event = (gboolean (*) (GamesRunner*, guint16)) games_retro_runner_gamepad_button_press_event;
	iface->get_can_fullscreen = games_retro_runner_real_get_can_fullscreen;
	iface->get_can_resume = games_retro_runner_real_get_can_resume;
	iface->get_supports_snapshots = games_retro_runner_real_get_supports_snapshots;
	iface->get_is_integrated = games_retro_runner_real_get_is_integrated;
	iface->get_media_set = games_retro_runner_real_get_media_set;
	iface->get_input_mode = games_retro_runner_real_get_input_mode;
	iface->set_input_mode = games_retro_runner_real_set_input_mode;
}

static void
games_retro_runner_instance_init (GamesRetroRunner * self,
                                  gpointer klass)
{
	self->priv = games_retro_runner_get_instance_private (self);
}

static void
games_retro_runner_finalize (GObject * obj)
{
	GamesRetroRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner);
	games_retro_runner_deinit (self);
	_g_object_unref0 (self->priv->_media_set);
	_g_object_unref0 (self->priv->_input_capabilities);
	_g_object_unref0 (self->priv->core);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->input_manager);
	_g_object_unref0 (self->priv->core_descriptor);
	_g_object_unref0 (self->priv->core_source);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game);
	_g_object_unref0 (self->priv->snapshot_manager);
	_g_object_unref0 (self->priv->previewed_snapshot);
	_g_free0 (self->priv->tmp_save_dir);
	_g_object_unref0 (self->priv->current_state_pixbuf);
	G_OBJECT_CLASS (games_retro_runner_parent_class)->finalize (obj);
}

static GType
games_retro_runner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesRetroRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_retro_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesRetroRunner), 0, (GInstanceInitFunc) games_retro_runner_instance_init, NULL };
	static const GInterfaceInfo games_runner_info = { (GInterfaceInitFunc) games_retro_runner_games_runner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType games_retro_runner_type_id;
	games_retro_runner_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesRetroRunner", &g_define_type_info, 0);
	g_type_add_interface_static (games_retro_runner_type_id, GAMES_TYPE_RUNNER, &games_runner_info);
	GamesRetroRunner_private_offset = g_type_add_instance_private (games_retro_runner_type_id, sizeof (GamesRetroRunnerPrivate));
	return games_retro_runner_type_id;
}

GType
games_retro_runner_get_type (void)
{
	static volatile gsize games_retro_runner_type_id__once = 0;
	if (g_once_init_enter (&games_retro_runner_type_id__once)) {
		GType games_retro_runner_type_id;
		games_retro_runner_type_id = games_retro_runner_get_type_once ();
		g_once_init_leave (&games_retro_runner_type_id__once, games_retro_runner_type_id);
	}
	return games_retro_runner_type_id__once;
}

static void
_vala_games_retro_runner_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	GamesRetroRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner);
	switch (property_id) {
		case GAMES_RETRO_RUNNER_CAN_FULLSCREEN_PROPERTY:
		g_value_set_boolean (value, games_runner_get_can_fullscreen ((GamesRunner*) self));
		break;
		case GAMES_RETRO_RUNNER_CAN_RESUME_PROPERTY:
		g_value_set_boolean (value, games_runner_get_can_resume ((GamesRunner*) self));
		break;
		case GAMES_RETRO_RUNNER_SUPPORTS_SNAPSHOTS_PROPERTY:
		g_value_set_boolean (value, games_runner_get_supports_snapshots ((GamesRunner*) self));
		break;
		case GAMES_RETRO_RUNNER_IS_INTEGRATED_PROPERTY:
		g_value_set_boolean (value, games_runner_get_is_integrated ((GamesRunner*) self));
		break;
		case GAMES_RETRO_RUNNER_MEDIA_SET_PROPERTY:
		g_value_set_object (value, games_runner_get_media_set ((GamesRunner*) self));
		break;
		case GAMES_RETRO_RUNNER_INPUT_CAPABILITIES_PROPERTY:
		g_value_set_object (value, games_retro_runner_get_input_capabilities (self));
		break;
		case GAMES_RETRO_RUNNER_INPUT_MODE_PROPERTY:
		g_value_set_enum (value, games_runner_get_input_mode ((GamesRunner*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_retro_runner_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	GamesRetroRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner);
	switch (property_id) {
		case GAMES_RETRO_RUNNER_INPUT_CAPABILITIES_PROPERTY:
		games_retro_runner_set_input_capabilities (self, g_value_get_object (value));
		break;
		case GAMES_RETRO_RUNNER_INPUT_MODE_PROPERTY:
		games_runner_set_input_mode ((GamesRunner*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

