/* retro-core.c generated by valac 0.56.8, the Vala compiler
 * generated from retro-core.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+*/

#include <glib-object.h>
#include "gnome-games.h"
#include <retro-gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define GAMES_TYPE_RETRO_CORE (games_retro_core_get_type ())
#define GAMES_RETRO_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_CORE, GamesRetroCore))
#define GAMES_RETRO_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_CORE, GamesRetroCoreClass))
#define GAMES_IS_RETRO_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_CORE))
#define GAMES_IS_RETRO_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_CORE))
#define GAMES_RETRO_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_CORE, GamesRetroCoreClass))

typedef struct _GamesRetroCore GamesRetroCore;
typedef struct _GamesRetroCoreClass GamesRetroCoreClass;
typedef struct _GamesRetroCorePrivate GamesRetroCorePrivate;
enum  {
	GAMES_RETRO_CORE_0_PROPERTY,
	GAMES_RETRO_CORE_NUM_PROPERTIES
};
static GParamSpec* games_retro_core_properties[GAMES_RETRO_CORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GamesRetroCore {
	GObject parent_instance;
	GamesRetroCorePrivate * priv;
};

struct _GamesRetroCoreClass {
	GObjectClass parent_class;
};

struct _GamesRetroCorePrivate {
	RetroCoreDescriptor* core_descriptor;
};

static gint GamesRetroCore_private_offset;
static gpointer games_retro_core_parent_class = NULL;
static GamesCoreIface * games_retro_core_games_core_parent_iface = NULL;

VALA_EXTERN GType games_retro_core_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesRetroCore* games_retro_core_new (RetroCoreDescriptor* core_descriptor);
VALA_EXTERN GamesRetroCore* games_retro_core_construct (GType object_type,
                                            RetroCoreDescriptor* core_descriptor);
static GamesFirmware** games_retro_core_real_get_all_firmware (GamesCore* base,
                                                        GamesPlatform* platform,
                                                        gint* result_length1,
                                                        GError** error);
static void _vala_array_add24 (GamesFirmware** * array,
                        gint* length,
                        gint* size,
                        GamesFirmware* value);
static void games_retro_core_finalize (GObject * obj);
static GType games_retro_core_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_retro_core_get_instance_private (GamesRetroCore* self)
{
	return G_STRUCT_MEMBER_P (self, GamesRetroCore_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GamesRetroCore*
games_retro_core_construct (GType object_type,
                            RetroCoreDescriptor* core_descriptor)
{
	GamesRetroCore * self = NULL;
	RetroCoreDescriptor* _tmp0_;
	g_return_val_if_fail (core_descriptor != NULL, NULL);
	self = (GamesRetroCore*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (core_descriptor);
	_g_object_unref0 (self->priv->core_descriptor);
	self->priv->core_descriptor = _tmp0_;
	return self;
}

GamesRetroCore*
games_retro_core_new (RetroCoreDescriptor* core_descriptor)
{
	return games_retro_core_construct (GAMES_TYPE_RETRO_CORE, core_descriptor);
}

static void
_vala_array_add24 (GamesFirmware** * array,
                   gint* length,
                   gint* size,
                   GamesFirmware* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesFirmware*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GamesFirmware**
games_retro_core_real_get_all_firmware (GamesCore* base,
                                        GamesPlatform* platform,
                                        gint* result_length1,
                                        GError** error)
{
	GamesRetroCore * self;
	gchar* platform_id = NULL;
	gchar* _tmp0_;
	GamesFirmware** firmware_list = NULL;
	GamesFirmware** _tmp1_;
	gint firmware_list_length1;
	gint _firmware_list_size_;
	gboolean _tmp2_ = FALSE;
	RetroCoreDescriptor* _tmp3_;
	const gchar* _tmp4_;
	GamesFirmware** _tmp16_;
	gint _tmp16__length1;
	GError* _inner_error0_ = NULL;
	GamesFirmware** result;
	self = (GamesRetroCore*) base;
	g_return_val_if_fail (platform != NULL, NULL);
	_tmp0_ = games_platform_get_id (platform);
	platform_id = _tmp0_;
	_tmp1_ = g_new0 (GamesFirmware*, 0 + 1);
	firmware_list = _tmp1_;
	firmware_list_length1 = 0;
	_firmware_list_size_ = firmware_list_length1;
	_tmp3_ = self->priv->core_descriptor;
	_tmp4_ = platform_id;
	_tmp2_ = retro_core_descriptor_has_firmwares (_tmp3_, _tmp4_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		firmware_list = (_vala_array_free (firmware_list, firmware_list_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_free0 (platform_id);
		return NULL;
	}
	if (_tmp2_) {
		gchar** _tmp5_ = NULL;
		RetroCoreDescriptor* _tmp6_;
		const gchar* _tmp7_;
		gsize _tmp8_ = 0;
		gchar** _tmp9_;
		gint _tmp5__length1;
		gint __tmp5__size_;
		_tmp6_ = self->priv->core_descriptor;
		_tmp7_ = platform_id;
		_tmp9_ = retro_core_descriptor_get_firmwares (_tmp6_, _tmp7_, &_tmp8_, &_inner_error0_);
		_tmp5_ = _tmp9_;
		_tmp5__length1 = _tmp8_;
		__tmp5__size_ = _tmp5__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			firmware_list = (_vala_array_free (firmware_list, firmware_list_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_free0 (platform_id);
			return NULL;
		}
		{
			gchar** firmware_collection = NULL;
			gint firmware_collection_length1 = 0;
			gint _firmware_collection_size_ = 0;
			gint firmware_it = 0;
			firmware_collection = _tmp5_;
			firmware_collection_length1 = _tmp5__length1;
			for (firmware_it = 0; firmware_it < firmware_collection_length1; firmware_it = firmware_it + 1) {
				gchar* _tmp10_;
				gchar* firmware = NULL;
				_tmp10_ = g_strdup (firmware_collection[firmware_it]);
				firmware = _tmp10_;
				{
					GamesRetroFirmware* _tmp11_ = NULL;
					const gchar* _tmp12_;
					RetroCoreDescriptor* _tmp13_;
					GamesRetroFirmware* _tmp14_;
					GamesRetroFirmware* _tmp15_;
					_tmp12_ = firmware;
					_tmp13_ = self->priv->core_descriptor;
					_tmp14_ = games_retro_firmware_new (_tmp12_, _tmp13_, &_inner_error0_);
					_tmp11_ = _tmp14_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						g_propagate_error (error, _inner_error0_);
						_g_free0 (firmware);
						_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
						firmware_list = (_vala_array_free (firmware_list, firmware_list_length1, (GDestroyNotify) g_object_unref), NULL);
						_g_free0 (platform_id);
						return NULL;
					}
					_tmp15_ = _tmp11_;
					_tmp11_ = NULL;
					_vala_array_add24 (&firmware_list, &firmware_list_length1, &_firmware_list_size_, (GamesFirmware*) _tmp15_);
					_g_object_unref0 (_tmp11_);
					_g_free0 (firmware);
				}
			}
		}
		_tmp5_ = (_vala_array_free (_tmp5_, _tmp5__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp16_ = firmware_list;
	_tmp16__length1 = firmware_list_length1;
	if (result_length1) {
		*result_length1 = _tmp16__length1;
	}
	result = _tmp16_;
	_g_free0 (platform_id);
	return result;
}

static void
games_retro_core_class_init (GamesRetroCoreClass * klass,
                             gpointer klass_data)
{
	games_retro_core_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesRetroCore_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_retro_core_finalize;
}

static void
games_retro_core_games_core_interface_init (GamesCoreIface * iface,
                                            gpointer iface_data)
{
	games_retro_core_games_core_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_all_firmware = (GamesFirmware** (*) (GamesCore*, GamesPlatform*, gint*, GError**)) games_retro_core_real_get_all_firmware;
}

static void
games_retro_core_instance_init (GamesRetroCore * self,
                                gpointer klass)
{
	self->priv = games_retro_core_get_instance_private (self);
}

static void
games_retro_core_finalize (GObject * obj)
{
	GamesRetroCore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_CORE, GamesRetroCore);
	_g_object_unref0 (self->priv->core_descriptor);
	G_OBJECT_CLASS (games_retro_core_parent_class)->finalize (obj);
}

static GType
games_retro_core_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesRetroCoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_retro_core_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesRetroCore), 0, (GInstanceInitFunc) games_retro_core_instance_init, NULL };
	static const GInterfaceInfo games_core_info = { (GInterfaceInitFunc) games_retro_core_games_core_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType games_retro_core_type_id;
	games_retro_core_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesRetroCore", &g_define_type_info, 0);
	g_type_add_interface_static (games_retro_core_type_id, GAMES_TYPE_CORE, &games_core_info);
	GamesRetroCore_private_offset = g_type_add_instance_private (games_retro_core_type_id, sizeof (GamesRetroCorePrivate));
	return games_retro_core_type_id;
}

GType
games_retro_core_get_type (void)
{
	static volatile gsize games_retro_core_type_id__once = 0;
	if (g_once_init_enter (&games_retro_core_type_id__once)) {
		GType games_retro_core_type_id;
		games_retro_core_type_id = games_retro_core_get_type_once ();
		g_once_init_leave (&games_retro_core_type_id__once, games_retro_core_type_id);
	}
	return games_retro_core_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

