/* retro-core-source.c generated by valac 0.56.8, the Vala compiler
 * generated from retro-core-source.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <retro-gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

enum  {
	GAMES_RETRO_CORE_SOURCE_0_PROPERTY,
	GAMES_RETRO_CORE_SOURCE_NUM_PROPERTIES
};
static GParamSpec* games_retro_core_source_properties[GAMES_RETRO_CORE_SOURCE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_RETRO_ERROR (games_retro_error_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_RETRO_CORE (games_retro_core_get_type ())
#define GAMES_RETRO_CORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_CORE, GamesRetroCore))
#define GAMES_RETRO_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_CORE, GamesRetroCoreClass))
#define GAMES_IS_RETRO_CORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_CORE))
#define GAMES_IS_RETRO_CORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_CORE))
#define GAMES_RETRO_CORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_CORE, GamesRetroCoreClass))

typedef struct _GamesRetroCore GamesRetroCore;
typedef struct _GamesRetroCoreClass GamesRetroCoreClass;

struct _GamesRetroCoreSourcePrivate {
	GamesRetroPlatform* platform;
	RetroCoreDescriptor* core_descriptor;
};

typedef enum  {
	GAMES_RETRO_ERROR_MODULE_NOT_FOUND,
	GAMES_RETRO_ERROR_INVALID_GAME_FILE,
	GAMES_RETRO_ERROR_COULDNT_WRITE_SNAPSHOT,
	GAMES_RETRO_ERROR_COULDNT_LOAD_SNAPSHOT
} GamesRetroError;
#define GAMES_RETRO_ERROR games_retro_error_quark ()

static gint GamesRetroCoreSource_private_offset;
static gpointer games_retro_core_source_parent_class = NULL;

static void games_retro_core_source_ensure_module_is_found (GamesRetroCoreSource* self,
                                                     GError** error);
VALA_EXTERN GQuark games_retro_error_quark (void);
GType games_retro_error_get_type (void) G_GNUC_CONST ;
static void games_retro_core_source_search_module (GamesRetroCoreSource* self,
                                            GError** error);
VALA_EXTERN GType games_retro_core_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesRetroCore* games_retro_core_new (RetroCoreDescriptor* core_descriptor);
VALA_EXTERN GamesRetroCore* games_retro_core_construct (GType object_type,
                                            RetroCoreDescriptor* core_descriptor);
static void games_retro_core_source_finalize (GObject * obj);
static GType games_retro_core_source_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_retro_core_source_get_instance_private (GamesRetroCoreSource* self)
{
	return G_STRUCT_MEMBER_P (self, GamesRetroCoreSource_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GamesRetroCoreSource*
games_retro_core_source_construct (GType object_type,
                                   GamesRetroPlatform* platform)
{
	GamesRetroCoreSource * self = NULL;
	GamesRetroPlatform* _tmp0_;
	g_return_val_if_fail (platform != NULL, NULL);
	self = (GamesRetroCoreSource*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (platform);
	_g_object_unref0 (self->priv->platform);
	self->priv->platform = _tmp0_;
	return self;
}

GamesRetroCoreSource*
games_retro_core_source_new (GamesRetroPlatform* platform)
{
	return games_retro_core_source_construct (GAMES_TYPE_RETRO_CORE_SOURCE, platform);
}

GamesPlatform*
games_retro_core_source_get_platform (GamesRetroCoreSource* self)
{
	GamesRetroPlatform* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesPlatform* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->platform;
	_tmp1_ = _g_object_ref0 ((GamesPlatform*) _tmp0_);
	result = _tmp1_;
	return result;
}

gchar*
games_retro_core_source_get_core_id (GamesRetroCoreSource* self,
                                     GError** error)
{
	RetroCoreDescriptor* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	games_retro_core_source_ensure_module_is_found (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = self->priv->core_descriptor;
	_tmp1_ = retro_core_descriptor_get_id (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_;
		void* ptr = NULL;
		const gchar* _tmp22_;
		void* _tmp23_;
		const gchar* _tmp33_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp20_ = str_array[0];
		if (_tmp20_ != NULL) {
			const gchar* _tmp21_;
			_tmp21_ = str_array[0];
			_tmp19_ = (const gchar*) _tmp21_;
		} else {
			_tmp19_ = "";
		}
		_tmp22_ = res;
		_tmp23_ = g_stpcpy ((void*) _tmp22_, _tmp19_);
		ptr = _tmp23_;
		{
			gboolean _tmp24_ = FALSE;
			i = 1;
			_tmp24_ = TRUE;
			while (TRUE) {
				void* _tmp26_;
				void* _tmp27_;
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp29_;
				void* _tmp31_;
				void* _tmp32_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = i;
					i = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp26_ = ptr;
				_tmp27_ = g_stpcpy (_tmp26_, (const gchar*) separator);
				ptr = _tmp27_;
				_tmp29_ = str_array[i];
				if (_tmp29_ != NULL) {
					const gchar* _tmp30_;
					_tmp30_ = str_array[i];
					_tmp28_ = (const gchar*) _tmp30_;
				} else {
					_tmp28_ = "";
				}
				_tmp31_ = ptr;
				_tmp32_ = g_stpcpy (_tmp31_, _tmp28_);
				ptr = _tmp32_;
			}
		}
		_tmp33_ = res;
		res = NULL;
		result = (gchar*) _tmp33_;
		return result;
	} else {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("");
		result = _tmp34_;
		return result;
	}
}

gchar*
games_retro_core_source_get_module_path (GamesRetroCoreSource* self,
                                         GError** error)
{
	GFile* module_file = NULL;
	RetroCoreDescriptor* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp14_;
	gchar* _tmp15_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	games_retro_core_source_ensure_module_is_found (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp0_ = self->priv->core_descriptor;
	_tmp1_ = retro_core_descriptor_get_module_file (_tmp0_, &_inner_error0_);
	module_file = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = module_file;
	if (_tmp2_ == NULL) {
		gchar** mime_types = NULL;
		GamesRetroPlatform* _tmp3_;
		gint _tmp4_ = 0;
		gchar** _tmp5_;
		gint mime_types_length1;
		gint _mime_types_size_;
		GamesRetroPlatform* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp3_ = self->priv->platform;
		_tmp5_ = games_retro_platform_get_mime_types (_tmp3_, &_tmp4_);
		mime_types = _tmp5_;
		mime_types_length1 = _tmp4_;
		_mime_types_size_ = mime_types_length1;
		_tmp6_ = self->priv->platform;
		_tmp7_ = games_platform_get_id ((GamesPlatform*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = mime_types;
		_tmp9__length1 = mime_types_length1;
		_tmp10_ = _vala_g_strjoinv ("”, “", _tmp9_, (gint) _tmp9__length1);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new (GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND, "No module found for platform “%s” and MIME types [ “%s” ].", _tmp8_, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_g_free0 (_tmp8_);
		_inner_error0_ = _tmp13_;
		g_propagate_error (error, _inner_error0_);
		mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (module_file);
		return NULL;
	}
	_tmp14_ = module_file;
	_tmp15_ = g_file_get_path (_tmp14_);
	result = _tmp15_;
	_g_object_unref0 (module_file);
	return result;
}

static void
games_retro_core_source_ensure_module_is_found (GamesRetroCoreSource* self,
                                                GError** error)
{
	gchar* platform_id = NULL;
	GamesRetroPlatform* _tmp0_;
	gchar* _tmp1_;
	GamesFirmwareManager* firmware_manager = NULL;
	GamesFirmwareManager* _tmp2_;
	RetroCoreDescriptor* _tmp3_;
	GamesRetroCore* core = NULL;
	RetroCoreDescriptor* _tmp13_;
	GamesRetroCore* _tmp14_;
	GamesFirmwareManager* _tmp15_;
	GamesRetroCore* _tmp16_;
	GamesRetroPlatform* _tmp17_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	games_retro_core_source_search_module (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp0_ = self->priv->platform;
	_tmp1_ = games_platform_get_id ((GamesPlatform*) _tmp0_);
	platform_id = _tmp1_;
	_tmp2_ = games_firmware_manager_new ();
	firmware_manager = _tmp2_;
	_tmp3_ = self->priv->core_descriptor;
	if (_tmp3_ == NULL) {
		gchar** mime_types = NULL;
		GamesRetroPlatform* _tmp4_;
		gint _tmp5_ = 0;
		gchar** _tmp6_;
		gint mime_types_length1;
		gint _mime_types_size_;
		const gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GError* _tmp11_;
		GError* _tmp12_;
		_tmp4_ = self->priv->platform;
		_tmp6_ = games_retro_platform_get_mime_types (_tmp4_, &_tmp5_);
		mime_types = _tmp6_;
		mime_types_length1 = _tmp5_;
		_mime_types_size_ = mime_types_length1;
		_tmp7_ = platform_id;
		_tmp8_ = mime_types;
		_tmp8__length1 = mime_types_length1;
		_tmp9_ = _vala_g_strjoinv ("”, “", _tmp8_, (gint) _tmp8__length1);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_error_new (GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND, "No module found for platform “%s” and MIME types [ “%s” ].", _tmp7_, _tmp10_);
		_tmp12_ = _tmp11_;
		_g_free0 (_tmp10_);
		_inner_error0_ = _tmp12_;
		g_propagate_error (error, _inner_error0_);
		mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (firmware_manager);
		_g_free0 (platform_id);
		return;
	}
	_tmp13_ = self->priv->core_descriptor;
	_tmp14_ = games_retro_core_new (_tmp13_);
	core = _tmp14_;
	_tmp15_ = firmware_manager;
	_tmp16_ = core;
	_tmp17_ = self->priv->platform;
	games_firmware_manager_is_all_firmware_valid (_tmp15_, (GamesCore*) _tmp16_, (GamesPlatform*) _tmp17_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (core);
		_g_object_unref0 (firmware_manager);
		_g_free0 (platform_id);
		return;
	}
	_g_object_unref0 (core);
	_g_object_unref0 (firmware_manager);
	_g_free0 (platform_id);
}

static void
games_retro_core_source_search_module (GamesRetroCoreSource* self,
                                       GError** error)
{
	GamesRetroCoreManager* core_manager = NULL;
	GamesRetroCoreManager* _tmp0_;
	RetroCoreDescriptor** core_descriptors = NULL;
	GamesRetroCoreManager* _tmp1_;
	GamesRetroPlatform* _tmp2_;
	gint _tmp3_ = 0;
	RetroCoreDescriptor** _tmp4_;
	gint core_descriptors_length1;
	gint _core_descriptors_size_;
	RetroCoreDescriptor** _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_retro_core_manager_get_instance ();
	core_manager = _tmp0_;
	_tmp1_ = core_manager;
	_tmp2_ = self->priv->platform;
	_tmp4_ = games_retro_core_manager_get_cores_for_platform (_tmp1_, _tmp2_, &_tmp3_);
	core_descriptors = _tmp4_;
	core_descriptors_length1 = _tmp3_;
	_core_descriptors_size_ = core_descriptors_length1;
	_tmp5_ = core_descriptors;
	_tmp5__length1 = core_descriptors_length1;
	if (_tmp5__length1 > 0) {
		RetroCoreDescriptor** _tmp6_;
		gint _tmp6__length1;
		RetroCoreDescriptor* _tmp7_;
		RetroCoreDescriptor* _tmp8_;
		_tmp6_ = core_descriptors;
		_tmp6__length1 = core_descriptors_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (self->priv->core_descriptor);
		self->priv->core_descriptor = _tmp8_;
	}
	core_descriptors = (_vala_array_free (core_descriptors, core_descriptors_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (core_manager);
}

static void
games_retro_core_source_class_init (GamesRetroCoreSourceClass * klass,
                                    gpointer klass_data)
{
	games_retro_core_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesRetroCoreSource_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_retro_core_source_finalize;
}

static void
games_retro_core_source_instance_init (GamesRetroCoreSource * self,
                                       gpointer klass)
{
	self->priv = games_retro_core_source_get_instance_private (self);
}

static void
games_retro_core_source_finalize (GObject * obj)
{
	GamesRetroCoreSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_CORE_SOURCE, GamesRetroCoreSource);
	_g_object_unref0 (self->priv->platform);
	_g_object_unref0 (self->priv->core_descriptor);
	G_OBJECT_CLASS (games_retro_core_source_parent_class)->finalize (obj);
}

static GType
games_retro_core_source_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesRetroCoreSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_retro_core_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesRetroCoreSource), 0, (GInstanceInitFunc) games_retro_core_source_instance_init, NULL };
	GType games_retro_core_source_type_id;
	games_retro_core_source_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesRetroCoreSource", &g_define_type_info, 0);
	GamesRetroCoreSource_private_offset = g_type_add_instance_private (games_retro_core_source_type_id, sizeof (GamesRetroCoreSourcePrivate));
	return games_retro_core_source_type_id;
}

GType
games_retro_core_source_get_type (void)
{
	static volatile gsize games_retro_core_source_type_id__once = 0;
	if (g_once_init_enter (&games_retro_core_source_type_id__once)) {
		GType games_retro_core_source_type_id;
		games_retro_core_source_type_id = games_retro_core_source_get_type_once ();
		g_once_init_leave (&games_retro_core_source_type_id__once, games_retro_core_source_type_id);
	}
	return games_retro_core_source_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

