/* retro-core-manager.c generated by valac 0.56.8, the Vala compiler
 * generated from retro-core-manager.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <retro-gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>

enum  {
	GAMES_RETRO_CORE_MANAGER_0_PROPERTY,
	GAMES_RETRO_CORE_MANAGER_NUM_PROPERTIES
};
static GParamSpec* games_retro_core_manager_properties[GAMES_RETRO_CORE_MANAGER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

struct _GamesRetroCoreManagerPrivate {
	RetroCoreDescriptor** core_descriptors;
	gint core_descriptors_length1;
	gint _core_descriptors_size_;
	GHashTable* core_descriptor_ids;
	gboolean searched;
};

static gint GamesRetroCoreManager_private_offset;
static gpointer games_retro_core_manager_parent_class = NULL;
static GamesRetroCoreManager* games_retro_core_manager_instance;
static GamesRetroCoreManager* games_retro_core_manager_instance = NULL;

static GamesRetroCoreManager* games_retro_core_manager_new (void);
static GamesRetroCoreManager* games_retro_core_manager_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void games_retro_core_manager_search_modules (GamesRetroCoreManager* self);
static void _vala_array_add25 (RetroCoreDescriptor** * array,
                        gint* length,
                        gint* size,
                        RetroCoreDescriptor* value);
static GSettings* games_retro_core_manager_get_settings (GamesRetroCoreManager* self,
                                                  GamesRetroPlatform* platform);
static void _vala_RetroCoreDescriptor_free_function_content_of (gpointer data);
static RetroCoreDescriptor** _vala_array_dup15 (RetroCoreDescriptor** self,
                                         gssize length);
static void games_retro_core_manager_finalize (GObject * obj);
static GType games_retro_core_manager_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_retro_core_manager_get_instance_private (GamesRetroCoreManager* self)
{
	return G_STRUCT_MEMBER_P (self, GamesRetroCoreManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GamesRetroCoreManager*
games_retro_core_manager_get_instance (void)
{
	GamesRetroCoreManager* _tmp0_;
	GamesRetroCoreManager* _tmp2_;
	GamesRetroCoreManager* _tmp3_;
	GamesRetroCoreManager* result;
	_tmp0_ = games_retro_core_manager_instance;
	if (_tmp0_ == NULL) {
		GamesRetroCoreManager* _tmp1_;
		_tmp1_ = games_retro_core_manager_new ();
		_g_object_unref0 (games_retro_core_manager_instance);
		games_retro_core_manager_instance = _tmp1_;
	}
	_tmp2_ = games_retro_core_manager_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static GamesRetroCoreManager*
games_retro_core_manager_construct (GType object_type)
{
	GamesRetroCoreManager * self = NULL;
	RetroCoreDescriptor** _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	self = (GamesRetroCoreManager*) g_object_new (object_type, NULL);
	self->priv->searched = FALSE;
	_tmp0_ = g_new0 (RetroCoreDescriptor*, 0 + 1);
	self->priv->core_descriptors = (_vala_array_free (self->priv->core_descriptors, self->priv->core_descriptors_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->core_descriptors = _tmp0_;
	self->priv->core_descriptors_length1 = 0;
	self->priv->_core_descriptors_size_ = self->priv->core_descriptors_length1;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->core_descriptor_ids);
	self->priv->core_descriptor_ids = _tmp3_;
	return self;
}

static GamesRetroCoreManager*
games_retro_core_manager_new (void)
{
	return games_retro_core_manager_construct (GAMES_TYPE_RETRO_CORE_MANAGER);
}

static void
_vala_array_add25 (RetroCoreDescriptor** * array,
                   gint* length,
                   gint* size,
                   RetroCoreDescriptor* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (RetroCoreDescriptor*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
games_retro_core_manager_search_modules (GamesRetroCoreManager* self)
{
	RetroModuleQuery* modules = NULL;
	RetroModuleQuery* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = retro_module_query_new (TRUE);
	modules = _tmp0_;
	{
		RetroModuleIterator* _core_descriptor_it = NULL;
		RetroModuleQuery* _tmp1_;
		RetroModuleIterator* _tmp2_;
		_tmp1_ = modules;
		_tmp2_ = retro_module_query_iterator (_tmp1_);
		_core_descriptor_it = _tmp2_;
		while (TRUE) {
			RetroModuleIterator* _tmp3_;
			RetroCoreDescriptor* core_descriptor = NULL;
			RetroModuleIterator* _tmp4_;
			RetroCoreDescriptor* _tmp5_;
			_tmp3_ = _core_descriptor_it;
			if (!retro_module_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _core_descriptor_it;
			_tmp5_ = retro_module_iterator_get (_tmp4_);
			core_descriptor = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				RetroCoreDescriptor* _tmp7_;
				GFile* _tmp8_ = NULL;
				RetroCoreDescriptor* _tmp9_;
				GFile* _tmp10_;
				RetroCoreDescriptor* _tmp11_;
				RetroCoreDescriptor* _tmp12_;
				GHashTable* _tmp13_;
				RetroCoreDescriptor* _tmp14_;
				gchar* _tmp15_;
				RetroCoreDescriptor* _tmp16_;
				RetroCoreDescriptor* _tmp17_;
				_tmp7_ = core_descriptor;
				_tmp6_ = retro_core_descriptor_get_is_emulator (_tmp7_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				if (!_tmp6_) {
					_g_object_unref0 (core_descriptor);
					continue;
				}
				_tmp9_ = core_descriptor;
				_tmp10_ = retro_core_descriptor_get_module_file (_tmp9_, &_inner_error0_);
				_tmp8_ = _tmp10_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				if (_tmp8_ == NULL) {
					_g_object_unref0 (_tmp8_);
					_g_object_unref0 (core_descriptor);
					continue;
				}
				_tmp11_ = core_descriptor;
				_tmp12_ = _g_object_ref0 (_tmp11_);
				_vala_array_add25 (&self->priv->core_descriptors, &self->priv->core_descriptors_length1, &self->priv->_core_descriptors_size_, _tmp12_);
				_tmp13_ = self->priv->core_descriptor_ids;
				_tmp14_ = core_descriptor;
				_tmp15_ = retro_core_descriptor_get_id (_tmp14_);
				_tmp16_ = core_descriptor;
				_tmp17_ = _g_object_ref0 (_tmp16_);
				g_hash_table_insert (_tmp13_, _tmp15_, _tmp17_);
				_g_object_unref0 (_tmp8_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp18_;
				const gchar* _tmp19_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp18_ = e;
				_tmp19_ = _tmp18_->message;
				g_debug ("retro-core-manager.vala:37: %s", _tmp19_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (core_descriptor);
				_g_object_unref0 (_core_descriptor_it);
				_g_object_unref0 (modules);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (core_descriptor);
		}
		_g_object_unref0 (_core_descriptor_it);
	}
	_g_object_unref0 (modules);
}

RetroCoreDescriptor*
games_retro_core_manager_get_core_for_id (GamesRetroCoreManager* self,
                                          const gchar* id)
{
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	RetroCoreDescriptor* _tmp3_;
	RetroCoreDescriptor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = self->priv->core_descriptor_ids;
	if (!g_hash_table_contains (_tmp0_, id)) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->core_descriptor_ids;
	_tmp2_ = g_hash_table_lookup (_tmp1_, id);
	_tmp3_ = _g_object_ref0 ((RetroCoreDescriptor*) _tmp2_);
	result = _tmp3_;
	return result;
}

static GSettings*
games_retro_core_manager_get_settings (GamesRetroCoreManager* self,
                                       GamesRetroPlatform* platform)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GSettings* _tmp4_;
	GSettings* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (platform != NULL, NULL);
	_tmp0_ = games_platform_get_id ((GamesPlatform*) platform);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("/org/gnome/Games/platforms/%s/", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	path = _tmp3_;
	_tmp4_ = g_settings_new_with_path ("org.gnome.Games.platforms", path);
	result = _tmp4_;
	_g_free0 (path);
	return result;
}

void
games_retro_core_manager_set_preferred_core (GamesRetroCoreManager* self,
                                             GamesRetroPlatform* platform,
                                             RetroCoreDescriptor* core_descriptor)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (platform != NULL);
	g_return_if_fail (core_descriptor != NULL);
	_tmp0_ = games_retro_core_manager_get_settings (self, platform);
	_tmp1_ = _tmp0_;
	_tmp2_ = retro_core_descriptor_get_id (core_descriptor);
	_tmp3_ = _tmp2_;
	g_settings_set_string (_tmp1_, "preferred-core", _tmp3_);
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
}

RetroCoreDescriptor*
games_retro_core_manager_get_preferred_core (GamesRetroCoreManager* self,
                                             GamesRetroPlatform* platform)
{
	gchar* preferred_core = NULL;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	RetroCoreDescriptor* core_descriptor = NULL;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gconstpointer _tmp6_;
	RetroCoreDescriptor* _tmp7_;
	gboolean _tmp8_ = FALSE;
	RetroCoreDescriptor* _tmp9_;
	RetroCoreDescriptor* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (platform != NULL, NULL);
	if (!self->priv->searched) {
		self->priv->searched = TRUE;
		games_retro_core_manager_search_modules (self);
	}
	_tmp0_ = games_retro_core_manager_get_settings (self, platform);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_settings_get_string (_tmp1_, "preferred-core");
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	preferred_core = _tmp3_;
	_tmp4_ = self->priv->core_descriptor_ids;
	_tmp5_ = preferred_core;
	_tmp6_ = g_hash_table_lookup (_tmp4_, _tmp5_);
	_tmp7_ = _g_object_ref0 ((RetroCoreDescriptor*) _tmp6_);
	core_descriptor = _tmp7_;
	_tmp9_ = core_descriptor;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		RetroCoreDescriptor* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = core_descriptor;
		_tmp11_ = games_platform_get_id ((GamesPlatform*) platform);
		_tmp12_ = _tmp11_;
		_tmp8_ = !retro_core_descriptor_has_platform (_tmp10_, _tmp12_);
		_g_free0 (_tmp12_);
	}
	if (_tmp8_) {
		RetroCoreDescriptor** cores = NULL;
		gint _tmp13_ = 0;
		RetroCoreDescriptor** _tmp14_;
		gint cores_length1;
		gint _cores_size_;
		RetroCoreDescriptor** _tmp15_;
		gint _tmp15__length1;
		_tmp14_ = games_retro_core_manager_get_cores_for_platform (self, platform, &_tmp13_);
		cores = _tmp14_;
		cores_length1 = _tmp13_;
		_cores_size_ = cores_length1;
		_tmp15_ = cores;
		_tmp15__length1 = cores_length1;
		if (_tmp15__length1 > 0) {
			gint _tmp16_ = 0;
			RetroCoreDescriptor** _tmp17_;
			RetroCoreDescriptor** _tmp18_;
			gint _tmp18__length1;
			RetroCoreDescriptor* _tmp19_;
			RetroCoreDescriptor* _tmp20_;
			RetroCoreDescriptor* _tmp21_;
			_tmp17_ = games_retro_core_manager_get_cores_for_platform (self, platform, &_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp18__length1 = _tmp16_;
			_tmp19_ = _tmp18_[0];
			_tmp20_ = _g_object_ref0 (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp18_ = (_vala_array_free (_tmp18_, _tmp18__length1, (GDestroyNotify) g_object_unref), NULL);
			result = _tmp21_;
			cores = (_vala_array_free (cores, cores_length1, (GDestroyNotify) g_object_unref), NULL);
			_g_object_unref0 (core_descriptor);
			_g_free0 (preferred_core);
			return result;
		}
		result = NULL;
		cores = (_vala_array_free (cores, cores_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (core_descriptor);
		_g_free0 (preferred_core);
		return result;
	}
	result = core_descriptor;
	_g_free0 (preferred_core);
	return result;
}

static void
_vala_RetroCoreDescriptor_free_function_content_of (gpointer data)
{
	RetroCoreDescriptor* self;
	self = *((RetroCoreDescriptor**) data);
	_g_object_unref0_ (self);
}

static RetroCoreDescriptor**
_vala_array_dup15 (RetroCoreDescriptor** self,
                   gssize length)
{
	if (length >= 0) {
		RetroCoreDescriptor** result;
		gssize i;
		result = g_new0 (RetroCoreDescriptor*, length + 1);
		for (i = 0; i < length; i++) {
			RetroCoreDescriptor* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

RetroCoreDescriptor**
games_retro_core_manager_get_cores_for_platform (GamesRetroCoreManager* self,
                                                 GamesRetroPlatform* platform,
                                                 gint* result_length1)
{
	gchar* platform_id = NULL;
	gchar* _tmp0_;
	gchar** mime_types = NULL;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint mime_types_length1;
	gint _mime_types_size_;
	GArray* _result_ = NULL;
	GArray* _tmp3_;
	gchar* preferred_core = NULL;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	RetroCoreDescriptor** _tmp8_;
	gint _tmp8__length1;
	GArray* _tmp29_;
	gpointer* _tmp30_;
	gint _tmp30__length1;
	RetroCoreDescriptor** _tmp31_;
	gint _tmp31__length1;
	RetroCoreDescriptor** _tmp32_;
	gint _tmp32__length1;
	GError* _inner_error0_ = NULL;
	RetroCoreDescriptor** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (platform != NULL, NULL);
	if (!self->priv->searched) {
		self->priv->searched = TRUE;
		games_retro_core_manager_search_modules (self);
	}
	_tmp0_ = games_platform_get_id ((GamesPlatform*) platform);
	platform_id = _tmp0_;
	_tmp2_ = games_retro_platform_get_mime_types (platform, &_tmp1_);
	mime_types = _tmp2_;
	mime_types_length1 = _tmp1_;
	_mime_types_size_ = mime_types_length1;
	_tmp3_ = g_array_new (TRUE, TRUE, sizeof (RetroCoreDescriptor*));
	g_array_set_clear_func (_tmp3_, (GDestroyNotify) _vala_RetroCoreDescriptor_free_function_content_of);
	_result_ = _tmp3_;
	_tmp4_ = games_retro_core_manager_get_settings (self, platform);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_settings_get_string (_tmp5_, "preferred-core");
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	preferred_core = _tmp7_;
	_tmp8_ = self->priv->core_descriptors;
	_tmp8__length1 = self->priv->core_descriptors_length1;
	{
		RetroCoreDescriptor** core_descriptor_collection = NULL;
		gint core_descriptor_collection_length1 = 0;
		gint _core_descriptor_collection_size_ = 0;
		gint core_descriptor_it = 0;
		core_descriptor_collection = _tmp8_;
		core_descriptor_collection_length1 = _tmp8__length1;
		for (core_descriptor_it = 0; core_descriptor_it < core_descriptor_collection_length1; core_descriptor_it = core_descriptor_it + 1) {
			RetroCoreDescriptor* _tmp9_;
			RetroCoreDescriptor* core_descriptor = NULL;
			_tmp9_ = _g_object_ref0 (core_descriptor_collection[core_descriptor_it]);
			core_descriptor = _tmp9_;
			{
				{
					RetroCoreDescriptor* _tmp10_;
					const gchar* _tmp11_;
					gboolean _tmp12_ = FALSE;
					RetroCoreDescriptor* _tmp13_;
					const gchar* _tmp14_;
					gchar** _tmp15_;
					gint _tmp15__length1;
					RetroCoreDescriptor* _tmp16_;
					gchar* _tmp17_;
					gchar* _tmp18_;
					const gchar* _tmp19_;
					gboolean _tmp20_;
					_tmp10_ = core_descriptor;
					_tmp11_ = platform_id;
					if (!retro_core_descriptor_has_platform (_tmp10_, _tmp11_)) {
						_g_object_unref0 (core_descriptor);
						continue;
					}
					_tmp13_ = core_descriptor;
					_tmp14_ = platform_id;
					_tmp15_ = mime_types;
					_tmp15__length1 = mime_types_length1;
					_tmp12_ = retro_core_descriptor_get_platform_supports_mime_types (_tmp13_, _tmp14_, _tmp15_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					if (!_tmp12_) {
						_g_object_unref0 (core_descriptor);
						continue;
					}
					_tmp16_ = core_descriptor;
					_tmp17_ = retro_core_descriptor_get_id (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = preferred_core;
					_tmp20_ = g_strcmp0 (_tmp18_, _tmp19_) == 0;
					_g_free0 (_tmp18_);
					if (_tmp20_) {
						GArray* _tmp21_;
						RetroCoreDescriptor* _tmp22_;
						RetroCoreDescriptor* _tmp23_;
						_tmp21_ = _result_;
						_tmp22_ = core_descriptor;
						_tmp23_ = _g_object_ref0 (_tmp22_);
						g_array_prepend_val (_tmp21_, _tmp23_);
					} else {
						GArray* _tmp24_;
						RetroCoreDescriptor* _tmp25_;
						RetroCoreDescriptor* _tmp26_;
						_tmp24_ = _result_;
						_tmp25_ = core_descriptor;
						_tmp26_ = _g_object_ref0 (_tmp25_);
						g_array_append_val (_tmp24_, _tmp26_);
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp27_;
					const gchar* _tmp28_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp27_ = e;
					_tmp28_ = _tmp27_->message;
					g_debug ("retro-core-manager.vala:107: %s", _tmp28_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (core_descriptor);
					_g_free0 (preferred_core);
					_g_array_unref0 (_result_);
					mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (platform_id);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_object_unref0 (core_descriptor);
			}
		}
	}
	_tmp29_ = _result_;
	_tmp30_ = _tmp29_->data;
	_tmp30__length1 = _tmp29_->len;
	_tmp31_ = (_tmp30_ != NULL) ? _vala_array_dup15 (_tmp30_, _tmp30__length1) : _tmp30_;
	_tmp31__length1 = _tmp30__length1;
	_tmp32_ = _tmp31_;
	_tmp32__length1 = _tmp31__length1;
	if (result_length1) {
		*result_length1 = _tmp32__length1;
	}
	result = _tmp32_;
	_g_free0 (preferred_core);
	_g_array_unref0 (_result_);
	mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (platform_id);
	return result;
}

static void
games_retro_core_manager_class_init (GamesRetroCoreManagerClass * klass,
                                     gpointer klass_data)
{
	games_retro_core_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesRetroCoreManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_retro_core_manager_finalize;
}

static void
games_retro_core_manager_instance_init (GamesRetroCoreManager * self,
                                        gpointer klass)
{
	self->priv = games_retro_core_manager_get_instance_private (self);
}

static void
games_retro_core_manager_finalize (GObject * obj)
{
	GamesRetroCoreManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_CORE_MANAGER, GamesRetroCoreManager);
	self->priv->core_descriptors = (_vala_array_free (self->priv->core_descriptors, self->priv->core_descriptors_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (self->priv->core_descriptor_ids);
	G_OBJECT_CLASS (games_retro_core_manager_parent_class)->finalize (obj);
}

static GType
games_retro_core_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesRetroCoreManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_retro_core_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesRetroCoreManager), 0, (GInstanceInitFunc) games_retro_core_manager_instance_init, NULL };
	GType games_retro_core_manager_type_id;
	games_retro_core_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesRetroCoreManager", &g_define_type_info, 0);
	GamesRetroCoreManager_private_offset = g_type_add_instance_private (games_retro_core_manager_type_id, sizeof (GamesRetroCoreManagerPrivate));
	return games_retro_core_manager_type_id;
}

GType
games_retro_core_manager_get_type (void)
{
	static volatile gsize games_retro_core_manager_type_id__once = 0;
	if (g_once_init_enter (&games_retro_core_manager_type_id__once)) {
		GType games_retro_core_manager_type_id;
		games_retro_core_manager_type_id = games_retro_core_manager_get_type_once ();
		g_once_init_leave (&games_retro_core_manager_type_id__once, games_retro_core_manager_type_id);
	}
	return games_retro_core_manager_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

