/* keyboard-tester.c generated by valac 0.56.8, the Vala compiler
 * generated from keyboard-tester.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <retro-gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include "linux/input-event-codes.h"
#include "gnome-games.h"

#define GAMES_TYPE_KEYBOARD_TESTER (games_keyboard_tester_get_type ())
#define GAMES_KEYBOARD_TESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_KEYBOARD_TESTER, GamesKeyboardTester))
#define GAMES_KEYBOARD_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_KEYBOARD_TESTER, GamesKeyboardTesterClass))
#define GAMES_IS_KEYBOARD_TESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_KEYBOARD_TESTER))
#define GAMES_IS_KEYBOARD_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_KEYBOARD_TESTER))
#define GAMES_KEYBOARD_TESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_KEYBOARD_TESTER, GamesKeyboardTesterClass))

typedef struct _GamesKeyboardTester GamesKeyboardTester;
typedef struct _GamesKeyboardTesterClass GamesKeyboardTesterClass;
typedef struct _GamesKeyboardTesterPrivate GamesKeyboardTesterPrivate;

#define GAMES_TYPE_GAMEPAD_VIEW (games_gamepad_view_get_type ())
#define GAMES_GAMEPAD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadView))
#define GAMES_GAMEPAD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadViewClass))
#define GAMES_IS_GAMEPAD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD_VIEW))
#define GAMES_IS_GAMEPAD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD_VIEW))
#define GAMES_GAMEPAD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadViewClass))

typedef struct _GamesGamepadView GamesGamepadView;
typedef struct _GamesGamepadViewClass GamesGamepadViewClass;

#define GAMES_TYPE_GAMEPAD_VIEW_CONFIGURATION (games_gamepad_view_configuration_get_type ())
typedef struct _GamesGamepadViewConfiguration GamesGamepadViewConfiguration;

#define GAMES_TYPE_GAMEPAD_BUTTON_PATH (games_gamepad_button_path_get_type ())
typedef struct _GamesGamepadButtonPath GamesGamepadButtonPath;

#define GAMES_TYPE_GAMEPAD_INPUT (games_gamepad_input_get_type ())
typedef struct _GamesGamepadInput GamesGamepadInput;

#define GAMES_TYPE_GAMEPAD_ANALOG_PATH (games_gamepad_analog_path_get_type ())
typedef struct _GamesGamepadAnalogPath GamesGamepadAnalogPath;
enum  {
	GAMES_KEYBOARD_TESTER_0_PROPERTY,
	GAMES_KEYBOARD_TESTER_MAPPING_PROPERTY,
	GAMES_KEYBOARD_TESTER_CONFIGURATION_PROPERTY,
	GAMES_KEYBOARD_TESTER_NUM_PROPERTIES
};
static GParamSpec* games_keyboard_tester_properties[GAMES_KEYBOARD_TESTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GamesKeyboardTester {
	GtkBin parent_instance;
	GamesKeyboardTesterPrivate * priv;
};

struct _GamesKeyboardTesterClass {
	GtkBinClass parent_class;
};

struct _GamesGamepadInput {
	guint16 type;
	guint16 code;
};

struct _GamesGamepadButtonPath {
	GamesGamepadInput input;
	gchar* path;
};

struct _GamesGamepadAnalogPath {
	GamesGamepadInput input_x;
	GamesGamepadInput input_y;
	gdouble offset_radius;
	gchar* path;
};

struct _GamesGamepadViewConfiguration {
	gchar* svg_path;
	GamesGamepadButtonPath* button_paths;
	gint button_paths_length1;
	gint _button_paths_size_;
	GamesGamepadAnalogPath* analog_paths;
	gint analog_paths_length1;
	gint _analog_paths_size_;
	gchar** background_paths;
	gint background_paths_length1;
	gint _background_paths_size_;
};

struct _GamesKeyboardTesterPrivate {
	GamesGamepadView* gamepad_view;
	RetroKeyJoypadMapping* _mapping;
	GamesGamepadViewConfiguration _configuration;
};

static gint GamesKeyboardTester_private_offset;
static gpointer games_keyboard_tester_parent_class = NULL;

VALA_EXTERN GType games_keyboard_tester_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_view_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_view_configuration_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_button_path_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_input_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGamepadInput* games_gamepad_input_dup (const GamesGamepadInput* self);
VALA_EXTERN void games_gamepad_input_free (GamesGamepadInput* self);
VALA_EXTERN GamesGamepadButtonPath* games_gamepad_button_path_dup (const GamesGamepadButtonPath* self);
VALA_EXTERN void games_gamepad_button_path_free (GamesGamepadButtonPath* self);
VALA_EXTERN void games_gamepad_button_path_copy (const GamesGamepadButtonPath* self,
                                     GamesGamepadButtonPath* dest);
VALA_EXTERN void games_gamepad_button_path_destroy (GamesGamepadButtonPath* self);
VALA_EXTERN GType games_gamepad_analog_path_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGamepadAnalogPath* games_gamepad_analog_path_dup (const GamesGamepadAnalogPath* self);
VALA_EXTERN void games_gamepad_analog_path_free (GamesGamepadAnalogPath* self);
VALA_EXTERN void games_gamepad_analog_path_copy (const GamesGamepadAnalogPath* self,
                                     GamesGamepadAnalogPath* dest);
VALA_EXTERN void games_gamepad_analog_path_destroy (GamesGamepadAnalogPath* self);
VALA_EXTERN GamesGamepadViewConfiguration* games_gamepad_view_configuration_dup (const GamesGamepadViewConfiguration* self);
VALA_EXTERN void games_gamepad_view_configuration_free (GamesGamepadViewConfiguration* self);
VALA_EXTERN void games_gamepad_view_configuration_copy (const GamesGamepadViewConfiguration* self,
                                            GamesGamepadViewConfiguration* dest);
VALA_EXTERN void games_gamepad_view_configuration_destroy (GamesGamepadViewConfiguration* self);
VALA_EXTERN GamesKeyboardTester* games_keyboard_tester_new (GamesGamepadViewConfiguration* configuration);
VALA_EXTERN GamesKeyboardTester* games_keyboard_tester_construct (GType object_type,
                                                      GamesGamepadViewConfiguration* configuration);
VALA_EXTERN void games_keyboard_tester_start (GamesKeyboardTester* self);
VALA_EXTERN void games_gamepad_view_reset (GamesGamepadView* self);
static void games_keyboard_tester_connect_to_keyboard (GamesKeyboardTester* self);
VALA_EXTERN void games_keyboard_tester_stop (GamesKeyboardTester* self);
static void games_keyboard_tester_disconnect_from_keyboard (GamesKeyboardTester* self);
static gboolean games_keyboard_tester_on_key_press_event (GamesKeyboardTester* self,
                                                   GdkEventKey* key);
static gboolean _games_keyboard_tester_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                               GdkEventKey* event,
                                                                               gpointer self);
static gboolean games_keyboard_tester_on_key_release_event (GamesKeyboardTester* self,
                                                     GdkEventKey* key);
static gboolean _games_keyboard_tester_on_key_release_event_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                                   GdkEventKey* event,
                                                                                   gpointer self);
static void games_keyboard_tester_update_gamepad_view (GamesKeyboardTester* self,
                                                GdkEventKey* key,
                                                gboolean highlight);
VALA_EXTERN RetroKeyJoypadMapping* games_keyboard_tester_get_mapping (GamesKeyboardTester* self);
VALA_EXTERN gboolean games_gamepad_view_highlight (GamesGamepadView* self,
                                       GamesGamepadInput* input,
                                       gboolean highlight);
VALA_EXTERN void games_keyboard_tester_set_mapping (GamesKeyboardTester* self,
                                        RetroKeyJoypadMapping* value);
VALA_EXTERN void games_keyboard_tester_get_configuration (GamesKeyboardTester* self,
                                              GamesGamepadViewConfiguration * result);
static void games_keyboard_tester_set_configuration (GamesKeyboardTester* self,
                                              GamesGamepadViewConfiguration * value);
VALA_EXTERN void games_gamepad_view_set_configuration (GamesGamepadView* self,
                                           GamesGamepadViewConfiguration * value);
static void games_keyboard_tester_finalize (GObject * obj);
static GType games_keyboard_tester_get_type_once (void);
static void _vala_games_keyboard_tester_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_games_keyboard_tester_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_keyboard_tester_get_instance_private (GamesKeyboardTester* self)
{
	return G_STRUCT_MEMBER_P (self, GamesKeyboardTester_private_offset);
}

GamesKeyboardTester*
games_keyboard_tester_construct (GType object_type,
                                 GamesGamepadViewConfiguration* configuration)
{
	GamesKeyboardTester * self = NULL;
	GamesGamepadViewConfiguration _tmp0_;
	g_return_val_if_fail (configuration != NULL, NULL);
	_tmp0_ = *configuration;
	self = (GamesKeyboardTester*) g_object_new (object_type, "configuration", &_tmp0_, NULL);
	return self;
}

GamesKeyboardTester*
games_keyboard_tester_new (GamesGamepadViewConfiguration* configuration)
{
	return games_keyboard_tester_construct (GAMES_TYPE_KEYBOARD_TESTER, configuration);
}

void
games_keyboard_tester_start (GamesKeyboardTester* self)
{
	GamesGamepadView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gamepad_view;
	games_gamepad_view_reset (_tmp0_);
	games_keyboard_tester_connect_to_keyboard (self);
}

void
games_keyboard_tester_stop (GamesKeyboardTester* self)
{
	g_return_if_fail (self != NULL);
	games_keyboard_tester_disconnect_from_keyboard (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_games_keyboard_tester_on_key_press_event_gtk_widget_key_press_event (GtkWidget* _sender,
                                                                      GdkEventKey* event,
                                                                      gpointer self)
{
	gboolean result;
	result = games_keyboard_tester_on_key_press_event ((GamesKeyboardTester*) self, event);
	return result;
}

static gboolean
_games_keyboard_tester_on_key_release_event_gtk_widget_key_release_event (GtkWidget* _sender,
                                                                          GdkEventKey* event,
                                                                          gpointer self)
{
	gboolean result;
	result = games_keyboard_tester_on_key_release_event ((GamesKeyboardTester*) self, event);
	return result;
}

static void
games_keyboard_tester_connect_to_keyboard (GamesKeyboardTester* self)
{
	GtkWidget* window = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	g_signal_connect_object (window, "key-press-event", (GCallback) _games_keyboard_tester_on_key_press_event_gtk_widget_key_press_event, self, 0);
	g_signal_connect_object (window, "key-release-event", (GCallback) _games_keyboard_tester_on_key_release_event_gtk_widget_key_release_event, self, 0);
	_g_object_unref0 (window);
}

static void
games_keyboard_tester_disconnect_from_keyboard (GamesKeyboardTester* self)
{
	GtkWidget* window = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	window = _tmp1_;
	g_signal_parse_name ("key-press-event", gtk_widget_get_type (), &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _games_keyboard_tester_on_key_press_event_gtk_widget_key_press_event, self);
	g_signal_parse_name ("key-release-event", gtk_widget_get_type (), &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (window, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _games_keyboard_tester_on_key_release_event_gtk_widget_key_release_event, self);
	_g_object_unref0 (window);
}

static gboolean
games_keyboard_tester_on_key_press_event (GamesKeyboardTester* self,
                                          GdkEventKey* key)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	games_keyboard_tester_update_gamepad_view (self, key, TRUE);
	result = TRUE;
	return result;
}

static gboolean
games_keyboard_tester_on_key_release_event (GamesKeyboardTester* self,
                                            GdkEventKey* key)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	games_keyboard_tester_update_gamepad_view (self, key, FALSE);
	result = TRUE;
	return result;
}

static void
games_keyboard_tester_update_gamepad_view (GamesKeyboardTester* self,
                                           GdkEventKey* key,
                                           gboolean highlight)
{
	gint count = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	count = retro_controller_type_get_id_count (RETRO_CONTROLLER_TYPE_JOYPAD);
	{
		RetroJoypadId joypad_id = 0;
		joypad_id = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				RetroKeyJoypadMapping* _tmp1_;
				if (!_tmp0_) {
					joypad_id += 1;
				}
				_tmp0_ = FALSE;
				if (!(joypad_id < count)) {
					break;
				}
				_tmp1_ = self->priv->_mapping;
				if (retro_key_joypad_mapping_get_button_key (_tmp1_, joypad_id) == key->hardware_keycode) {
					guint16 code = 0U;
					GamesGamepadView* _tmp2_;
					GamesGamepadInput _tmp3_ = {0};
					code = retro_joypad_id_to_button_code (joypad_id);
					_tmp2_ = self->priv->gamepad_view;
					_tmp3_.type = EV_KEY;
					_tmp3_.code = code;
					games_gamepad_view_highlight (_tmp2_, &_tmp3_, highlight);
				}
			}
		}
	}
}

RetroKeyJoypadMapping*
games_keyboard_tester_get_mapping (GamesKeyboardTester* self)
{
	RetroKeyJoypadMapping* result;
	RetroKeyJoypadMapping* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mapping;
	result = _tmp0_;
	return result;
}

void
games_keyboard_tester_set_mapping (GamesKeyboardTester* self,
                                   RetroKeyJoypadMapping* value)
{
	RetroKeyJoypadMapping* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_keyboard_tester_get_mapping (self);
	if (old_value != value) {
		RetroKeyJoypadMapping* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_mapping);
		self->priv->_mapping = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_keyboard_tester_properties[GAMES_KEYBOARD_TESTER_MAPPING_PROPERTY]);
	}
}

void
games_keyboard_tester_get_configuration (GamesKeyboardTester* self,
                                         GamesGamepadViewConfiguration * result)
{
	GamesGamepadViewConfiguration _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_configuration;
	*result = _tmp0_;
	return;
}

static void
games_keyboard_tester_set_configuration (GamesKeyboardTester* self,
                                         GamesGamepadViewConfiguration * value)
{
	GamesGamepadViewConfiguration _tmp0_;
	GamesGamepadViewConfiguration _tmp1_;
	GamesGamepadViewConfiguration _tmp2_ = {0};
	GamesGamepadView* _tmp3_;
	GamesGamepadViewConfiguration _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	_tmp1_ = _tmp0_;
	games_gamepad_view_configuration_copy (&_tmp1_, &_tmp2_);
	games_gamepad_view_configuration_destroy (&self->priv->_configuration);
	self->priv->_configuration = _tmp2_;
	_tmp3_ = self->priv->gamepad_view;
	_tmp4_ = *value;
	games_gamepad_view_set_configuration (_tmp3_, &_tmp4_);
	g_object_notify_by_pspec ((GObject *) self, games_keyboard_tester_properties[GAMES_KEYBOARD_TESTER_CONFIGURATION_PROPERTY]);
}

static void
games_keyboard_tester_class_init (GamesKeyboardTesterClass * klass,
                                  gpointer klass_data)
{
	games_keyboard_tester_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesKeyboardTester_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_keyboard_tester_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_keyboard_tester_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_keyboard_tester_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_KEYBOARD_TESTER_MAPPING_PROPERTY, games_keyboard_tester_properties[GAMES_KEYBOARD_TESTER_MAPPING_PROPERTY] = g_param_spec_object ("mapping", "mapping", "mapping", retro_key_joypad_mapping_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_KEYBOARD_TESTER_CONFIGURATION_PROPERTY, games_keyboard_tester_properties[GAMES_KEYBOARD_TESTER_CONFIGURATION_PROPERTY] = g_param_spec_boxed ("configuration", "configuration", "configuration", GAMES_TYPE_GAMEPAD_VIEW_CONFIGURATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Games/keyboard/keyboard-tester.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "gamepad_view", FALSE, GamesKeyboardTester_private_offset + G_STRUCT_OFFSET (GamesKeyboardTesterPrivate, gamepad_view));
}

static void
games_keyboard_tester_instance_init (GamesKeyboardTester * self,
                                     gpointer klass)
{
	self->priv = games_keyboard_tester_get_instance_private (self);
	g_type_ensure (GAMES_TYPE_GAMEPAD_VIEW);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
games_keyboard_tester_finalize (GObject * obj)
{
	GamesKeyboardTester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_KEYBOARD_TESTER, GamesKeyboardTester);
	_g_object_unref0 (self->priv->_mapping);
	games_gamepad_view_configuration_destroy (&self->priv->_configuration);
	G_OBJECT_CLASS (games_keyboard_tester_parent_class)->finalize (obj);
}

static GType
games_keyboard_tester_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesKeyboardTesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_keyboard_tester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesKeyboardTester), 0, (GInstanceInitFunc) games_keyboard_tester_instance_init, NULL };
	GType games_keyboard_tester_type_id;
	games_keyboard_tester_type_id = g_type_register_static (gtk_bin_get_type (), "GamesKeyboardTester", &g_define_type_info, 0);
	GamesKeyboardTester_private_offset = g_type_add_instance_private (games_keyboard_tester_type_id, sizeof (GamesKeyboardTesterPrivate));
	return games_keyboard_tester_type_id;
}

GType
games_keyboard_tester_get_type (void)
{
	static volatile gsize games_keyboard_tester_type_id__once = 0;
	if (g_once_init_enter (&games_keyboard_tester_type_id__once)) {
		GType games_keyboard_tester_type_id;
		games_keyboard_tester_type_id = games_keyboard_tester_get_type_once ();
		g_once_init_leave (&games_keyboard_tester_type_id__once, games_keyboard_tester_type_id);
	}
	return games_keyboard_tester_type_id__once;
}

static void
_vala_games_keyboard_tester_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GamesKeyboardTester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_KEYBOARD_TESTER, GamesKeyboardTester);
	switch (property_id) {
		case GAMES_KEYBOARD_TESTER_MAPPING_PROPERTY:
		g_value_set_object (value, games_keyboard_tester_get_mapping (self));
		break;
		case GAMES_KEYBOARD_TESTER_CONFIGURATION_PROPERTY:
		{
			GamesGamepadViewConfiguration boxed;
			games_keyboard_tester_get_configuration (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_keyboard_tester_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GamesKeyboardTester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_KEYBOARD_TESTER, GamesKeyboardTester);
	switch (property_id) {
		case GAMES_KEYBOARD_TESTER_MAPPING_PROPERTY:
		games_keyboard_tester_set_mapping (self, g_value_get_object (value));
		break;
		case GAMES_KEYBOARD_TESTER_CONFIGURATION_PROPERTY:
		games_keyboard_tester_set_configuration (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

