/* grilo-cover.c generated by valac 0.56.8, the Vala compiler
 * generated from grilo-cover.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include "gnome-games.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <grilo.h>
#include <libsoup/soup.h>
#include <glib/gstdio.h>

enum  {
	GAMES_GRILO_COVER_0_PROPERTY,
	GAMES_GRILO_COVER_NUM_PROPERTIES
};
static GParamSpec* games_grilo_cover_properties[GAMES_GRILO_COVER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GamesGriloCoverTryFetchCoverData GamesGriloCoverTryFetchCoverData;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _GamesGriloCoverFetchCoverData GamesGriloCoverFetchCoverData;

struct _GamesGriloCoverPrivate {
	GamesGriloMedia* media;
	GamesUid* uid;
	GFile* file;
	gchar* cover_path;
};

struct _GamesGriloCoverTryFetchCoverData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesGriloCover* self;
	gchar* uri;
	GError* e;
	GError* _tmp0_;
	const gchar* _tmp1_;
	GError* _inner_error0_;
};

struct _GamesGriloCoverFetchCoverData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesGriloCover* self;
	gchar* uri;
	gchar* dir;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* cover_path;
	gchar* _tmp2_;
	SoupSession* session;
	SoupSession* _tmp3_;
	SoupMessage* message;
	SoupMessage* _tmp4_;
	GBytes* bytes;
	SoupSession* _tmp5_;
	SoupMessage* _tmp6_;
	GBytes* _tmp7_;
	SoupMessage* _tmp8_;
	guint _tmp9_;
	guint _tmp10_;
	SoupMessage* _tmp11_;
	guint _tmp12_;
	guint _tmp13_;
	SoupMessage* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	GBytes* _tmp18_;
	gsize _tmp19_;
	guint8* _tmp20_;
	GError* e;
	GError* _tmp21_;
	const gchar* _tmp22_;
	GError* _inner_error0_;
};

static gint GamesGriloCover_private_offset;
static gpointer games_grilo_cover_parent_class = NULL;
static GamesCoverIface * games_grilo_cover_games_cover_parent_iface = NULL;

static void games_grilo_cover_on_media_resolved (GamesGriloCover* self);
static void _games_grilo_cover_on_media_resolved_games_grilo_media_resolved (GamesGriloMedia* _sender,
                                                                      gpointer self);
static GFile* games_grilo_cover_real_get_cover (GamesCover* base);
static void games_grilo_cover_load_cover (GamesGriloCover* self,
                                   GError** error);
VALA_EXTERN GrlMedia* games_grilo_media_get_media (GamesGriloMedia* self);
static void games_grilo_cover_try_fetch_cover (GamesGriloCover* self,
                                        const gchar* uri,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
static void games_grilo_cover_try_fetch_cover_finish (GamesGriloCover* self,
                                               GAsyncResult* _res_);
static gchar* games_grilo_cover_get_cover_path (GamesGriloCover* self,
                                         GError** error);
static void games_grilo_cover_try_fetch_cover_data_free (gpointer _data);
static gboolean games_grilo_cover_try_fetch_cover_co (GamesGriloCoverTryFetchCoverData* _data_);
static void games_grilo_cover_fetch_cover (GamesGriloCover* self,
                                    const gchar* uri,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static void games_grilo_cover_fetch_cover_finish (GamesGriloCover* self,
                                           GAsyncResult* _res_,
                                           GError** error);
static void games_grilo_cover_try_fetch_cover_ready (GObject* source_object,
                                              GAsyncResult* _res_,
                                              gpointer _user_data_);
static void games_grilo_cover_fetch_cover_data_free (gpointer _data);
static gboolean games_grilo_cover_fetch_cover_co (GamesGriloCoverFetchCoverData* _data_);
static void games_grilo_cover_fetch_cover_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static void games_grilo_cover_finalize (GObject * obj);
static GType games_grilo_cover_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_grilo_cover_get_instance_private (GamesGriloCover* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGriloCover_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_games_grilo_cover_on_media_resolved_games_grilo_media_resolved (GamesGriloMedia* _sender,
                                                                 gpointer self)
{
	games_grilo_cover_on_media_resolved ((GamesGriloCover*) self);
}

GamesGriloCover*
games_grilo_cover_construct (GType object_type,
                             GamesGriloMedia* media,
                             GamesUid* uid)
{
	GamesGriloCover * self = NULL;
	GamesGriloMedia* _tmp0_;
	GamesUid* _tmp1_;
	g_return_val_if_fail (media != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	self = (GamesGriloCover*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (media);
	_g_object_unref0 (self->priv->media);
	self->priv->media = _tmp0_;
	_tmp1_ = _g_object_ref0 (uid);
	_g_object_unref0 (self->priv->uid);
	self->priv->uid = _tmp1_;
	g_signal_connect_object (media, "resolved", (GCallback) _games_grilo_cover_on_media_resolved_games_grilo_media_resolved, self, 0);
	return self;
}

GamesGriloCover*
games_grilo_cover_new (GamesGriloMedia* media,
                       GamesUid* uid)
{
	return games_grilo_cover_construct (GAMES_TYPE_GRILO_COVER, media, uid);
}

static GFile*
games_grilo_cover_real_get_cover (GamesCover* base)
{
	GamesGriloCover * self;
	GFile* _tmp0_;
	GFile* _tmp7_;
	GamesGriloMedia* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	self = (GamesGriloCover*) base;
	_tmp0_ = self->priv->file;
	if (_tmp0_ != NULL) {
		GFile* _tmp1_;
		GFile* _tmp2_;
		_tmp1_ = self->priv->file;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	{
		games_grilo_cover_load_cover (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("grilo-cover.vala:23: %s", _tmp4_);
		_tmp5_ = self->priv->file;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		result = _tmp6_;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp7_ = self->priv->file;
	if (_tmp7_ != NULL) {
		GFile* _tmp8_;
		GFile* _tmp9_;
		_tmp8_ = self->priv->file;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		result = _tmp9_;
		return result;
	}
	_tmp10_ = self->priv->media;
	games_grilo_media_try_resolve_media (_tmp10_);
	_tmp11_ = self->priv->file;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	result = _tmp12_;
	return result;
}

static void
games_grilo_cover_on_media_resolved (GamesGriloCover* self)
{
	GrlMedia* grl_media = NULL;
	GamesGriloMedia* _tmp0_;
	GrlMedia* _tmp1_;
	GrlMedia* _tmp2_;
	GrlMedia* _tmp3_;
	gchar* uri = NULL;
	GrlMedia* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->media;
	_tmp1_ = games_grilo_media_get_media (_tmp0_);
	grl_media = _tmp1_;
	_tmp2_ = grl_media;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (grl_media);
		return;
	}
	_tmp3_ = grl_media;
	if (grl_data_length ((GrlData*) _tmp3_, GRL_METADATA_KEY_THUMBNAIL) == ((guint) 0)) {
		_g_object_unref0 (grl_media);
		return;
	}
	_tmp4_ = grl_media;
	_tmp5_ = grl_media_get_thumbnail_nth (_tmp4_, (guint) 0);
	_tmp6_ = g_strdup (_tmp5_);
	uri = _tmp6_;
	_tmp7_ = uri;
	games_grilo_cover_try_fetch_cover (self, _tmp7_, NULL, NULL);
	_g_free0 (uri);
	_g_object_unref0 (grl_media);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
games_grilo_cover_get_cover_path (GamesGriloCover* self,
                                  GError** error)
{
	const gchar* _tmp0_;
	gchar* dir = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GamesUid* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->cover_path;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->cover_path;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = games_application_get_covers_dir ();
	dir = _tmp3_;
	_tmp4_ = dir;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = self->priv->uid;
	_tmp7_ = games_uid_to_string (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp5_, "/", _tmp8_, ".cover", NULL);
	_g_free0 (self->priv->cover_path);
	self->priv->cover_path = _tmp9_;
	_g_free0 (_tmp8_);
	_tmp10_ = self->priv->cover_path;
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	_g_free0 (dir);
	return result;
}

static void
games_grilo_cover_try_fetch_cover_data_free (gpointer _data)
{
	GamesGriloCoverTryFetchCoverData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesGriloCoverTryFetchCoverData, _data_);
}

static void
games_grilo_cover_try_fetch_cover (GamesGriloCover* self,
                                   const gchar* uri,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_)
{
	GamesGriloCoverTryFetchCoverData* _data_;
	GamesGriloCover* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (GamesGriloCoverTryFetchCoverData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_grilo_cover_try_fetch_cover_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	games_grilo_cover_try_fetch_cover_co (_data_);
}

static void
games_grilo_cover_try_fetch_cover_finish (GamesGriloCover* self,
                                          GAsyncResult* _res_)
{
	GamesGriloCoverTryFetchCoverData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
games_grilo_cover_try_fetch_cover_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_)
{
	GamesGriloCoverTryFetchCoverData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_grilo_cover_try_fetch_cover_co (_data_);
}

static gboolean
games_grilo_cover_try_fetch_cover_co (GamesGriloCoverTryFetchCoverData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		games_grilo_cover_fetch_cover (_data_->self, _data_->uri, games_grilo_cover_try_fetch_cover_ready, _data_);
		return FALSE;
		_state_1:
		games_grilo_cover_fetch_cover_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp0_ = _data_->e;
		_data_->_tmp1_ = _data_->_tmp0_->message;
		g_warning ("grilo-cover.vala:64: %s", _data_->_tmp1_);
		_g_error_free0 (_data_->e);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_grilo_cover_fetch_cover_data_free (gpointer _data)
{
	GamesGriloCoverFetchCoverData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesGriloCoverFetchCoverData, _data_);
}

static void
games_grilo_cover_fetch_cover (GamesGriloCover* self,
                               const gchar* uri,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	GamesGriloCoverFetchCoverData* _data_;
	GamesGriloCover* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_data_ = g_slice_new0 (GamesGriloCoverFetchCoverData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_grilo_cover_fetch_cover_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uri);
	_g_free0 (_data_->uri);
	_data_->uri = _tmp1_;
	games_grilo_cover_fetch_cover_co (_data_);
}

static void
games_grilo_cover_fetch_cover_finish (GamesGriloCover* self,
                                      GAsyncResult* _res_,
                                      GError** error)
{
	GamesGriloCoverFetchCoverData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
games_grilo_cover_fetch_cover_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	GamesGriloCoverFetchCoverData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	games_grilo_cover_fetch_cover_co (_data_);
}

static gboolean
games_grilo_cover_fetch_cover_co (GamesGriloCoverFetchCoverData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = games_application_get_covers_dir ();
	_data_->dir = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->dir;
	games_application_try_make_dir (_data_->_tmp1_);
	_data_->_tmp2_ = games_grilo_cover_get_cover_path (_data_->self, &_data_->_inner_error0_);
	_data_->cover_path = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->dir);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = soup_session_new ();
	_data_->session = _data_->_tmp3_;
	_data_->_tmp4_ = soup_message_new ("GET", _data_->uri);
	_data_->message = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->session;
	_data_->_tmp6_ = _data_->message;
	_data_->_state_ = 1;
	soup_session_send_and_read_async (_data_->_tmp5_, _data_->_tmp6_, 0, NULL, games_grilo_cover_fetch_cover_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = soup_session_send_and_read_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error0_);
	_data_->bytes = _data_->_tmp7_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->message);
		_g_object_unref0 (_data_->session);
		_g_free0 (_data_->cover_path);
		_g_free0 (_data_->dir);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp8_ = _data_->message;
	g_object_get (_data_->_tmp8_, "status-code", &_data_->_tmp9_, NULL);
	_data_->_tmp10_ = _data_->_tmp9_;
	if (_data_->_tmp10_ != ((guint) SOUP_STATUS_OK)) {
		_data_->_tmp11_ = _data_->message;
		g_object_get (_data_->_tmp11_, "status-code", &_data_->_tmp12_, NULL);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = _data_->message;
		_data_->_tmp15_ = soup_message_get_reason_phrase (_data_->_tmp14_);
		_data_->_tmp16_ = _data_->_tmp15_;
		g_debug ("grilo-cover.vala:82: Failed to load %s: %u %s.", _data_->uri, _data_->_tmp13_, _data_->_tmp16_);
		_g_bytes_unref0 (_data_->bytes);
		_g_object_unref0 (_data_->message);
		_g_object_unref0 (_data_->session);
		_g_free0 (_data_->cover_path);
		_g_free0 (_data_->dir);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp17_ = _data_->cover_path;
		_data_->_tmp18_ = _data_->bytes;
		_data_->_tmp19_ = 0;
		_data_->_tmp20_ = g_bytes_get_data (_data_->_tmp18_, &_data_->_tmp19_);
		g_file_set_contents (_data_->_tmp17_, (const char*) _data_->_tmp20_, (gsize) _data_->_tmp19_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		games_grilo_cover_load_cover (_data_->self, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp21_ = _data_->e;
		_data_->_tmp22_ = _data_->_tmp21_->message;
		g_warning ("grilo-cover.vala:91: %s", _data_->_tmp22_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_bytes_unref0 (_data_->bytes);
		_g_object_unref0 (_data_->message);
		_g_object_unref0 (_data_->session);
		_g_free0 (_data_->cover_path);
		_g_free0 (_data_->dir);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_bytes_unref0 (_data_->bytes);
	_g_object_unref0 (_data_->message);
	_g_object_unref0 (_data_->session);
	_g_free0 (_data_->cover_path);
	_g_free0 (_data_->dir);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
games_grilo_cover_load_cover (GamesGriloCover* self,
                              GError** error)
{
	gchar* cover_path = NULL;
	gchar* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_grilo_cover_get_cover_path (self, &_inner_error0_);
	cover_path = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	if (!g_file_test (cover_path, G_FILE_TEST_EXISTS)) {
		_g_free0 (cover_path);
		return;
	}
	_tmp1_ = g_file_new_for_path (cover_path);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	g_signal_emit_by_name ((GamesCover*) self, "changed");
	_g_free0 (cover_path);
}

static void
games_grilo_cover_class_init (GamesGriloCoverClass * klass,
                              gpointer klass_data)
{
	games_grilo_cover_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesGriloCover_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_grilo_cover_finalize;
}

static void
games_grilo_cover_games_cover_interface_init (GamesCoverIface * iface,
                                              gpointer iface_data)
{
	games_grilo_cover_games_cover_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_cover = (GFile* (*) (GamesCover*)) games_grilo_cover_real_get_cover;
}

static void
games_grilo_cover_instance_init (GamesGriloCover * self,
                                 gpointer klass)
{
	self->priv = games_grilo_cover_get_instance_private (self);
}

static void
games_grilo_cover_finalize (GObject * obj)
{
	GamesGriloCover * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GRILO_COVER, GamesGriloCover);
	_g_object_unref0 (self->priv->media);
	_g_object_unref0 (self->priv->uid);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->cover_path);
	G_OBJECT_CLASS (games_grilo_cover_parent_class)->finalize (obj);
}

static GType
games_grilo_cover_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGriloCoverClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_grilo_cover_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGriloCover), 0, (GInstanceInitFunc) games_grilo_cover_instance_init, NULL };
	static const GInterfaceInfo games_cover_info = { (GInterfaceInitFunc) games_grilo_cover_games_cover_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType games_grilo_cover_type_id;
	games_grilo_cover_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesGriloCover", &g_define_type_info, 0);
	g_type_add_interface_static (games_grilo_cover_type_id, GAMES_TYPE_COVER, &games_cover_info);
	GamesGriloCover_private_offset = g_type_add_instance_private (games_grilo_cover_type_id, sizeof (GamesGriloCoverPrivate));
	return games_grilo_cover_type_id;
}

GType
games_grilo_cover_get_type (void)
{
	static volatile gsize games_grilo_cover_type_id__once = 0;
	if (g_once_init_enter (&games_grilo_cover_type_id__once)) {
		GType games_grilo_cover_type_id;
		games_grilo_cover_type_id = games_grilo_cover_get_type_once ();
		g_once_init_leave (&games_grilo_cover_type_id__once, games_grilo_cover_type_id);
	}
	return games_grilo_cover_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

