/* gamepad-tester.c generated by valac 0.56.8, the Vala compiler
 * generated from gamepad-tester.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <libmanette.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include "linux/input-event-codes.h"
#include "gnome-games.h"

#define GAMES_TYPE_GAMEPAD_TESTER (games_gamepad_tester_get_type ())
#define GAMES_GAMEPAD_TESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD_TESTER, GamesGamepadTester))
#define GAMES_GAMEPAD_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD_TESTER, GamesGamepadTesterClass))
#define GAMES_IS_GAMEPAD_TESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD_TESTER))
#define GAMES_IS_GAMEPAD_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD_TESTER))
#define GAMES_GAMEPAD_TESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD_TESTER, GamesGamepadTesterClass))

typedef struct _GamesGamepadTester GamesGamepadTester;
typedef struct _GamesGamepadTesterClass GamesGamepadTesterClass;
typedef struct _GamesGamepadTesterPrivate GamesGamepadTesterPrivate;

#define GAMES_TYPE_GAMEPAD_VIEW (games_gamepad_view_get_type ())
#define GAMES_GAMEPAD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadView))
#define GAMES_GAMEPAD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadViewClass))
#define GAMES_IS_GAMEPAD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD_VIEW))
#define GAMES_IS_GAMEPAD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD_VIEW))
#define GAMES_GAMEPAD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadViewClass))

typedef struct _GamesGamepadView GamesGamepadView;
typedef struct _GamesGamepadViewClass GamesGamepadViewClass;

#define GAMES_TYPE_GAMEPAD_VIEW_CONFIGURATION (games_gamepad_view_configuration_get_type ())
typedef struct _GamesGamepadViewConfiguration GamesGamepadViewConfiguration;

#define GAMES_TYPE_GAMEPAD_BUTTON_PATH (games_gamepad_button_path_get_type ())
typedef struct _GamesGamepadButtonPath GamesGamepadButtonPath;

#define GAMES_TYPE_GAMEPAD_INPUT (games_gamepad_input_get_type ())
typedef struct _GamesGamepadInput GamesGamepadInput;

#define GAMES_TYPE_GAMEPAD_ANALOG_PATH (games_gamepad_analog_path_get_type ())
typedef struct _GamesGamepadAnalogPath GamesGamepadAnalogPath;
enum  {
	GAMES_GAMEPAD_TESTER_0_PROPERTY,
	GAMES_GAMEPAD_TESTER_DEVICE_PROPERTY,
	GAMES_GAMEPAD_TESTER_CONFIGURATION_PROPERTY,
	GAMES_GAMEPAD_TESTER_NUM_PROPERTIES
};
static GParamSpec* games_gamepad_tester_properties[GAMES_GAMEPAD_TESTER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GamesGamepadTester {
	GtkBin parent_instance;
	GamesGamepadTesterPrivate * priv;
};

struct _GamesGamepadTesterClass {
	GtkBinClass parent_class;
};

struct _GamesGamepadInput {
	guint16 type;
	guint16 code;
};

struct _GamesGamepadButtonPath {
	GamesGamepadInput input;
	gchar* path;
};

struct _GamesGamepadAnalogPath {
	GamesGamepadInput input_x;
	GamesGamepadInput input_y;
	gdouble offset_radius;
	gchar* path;
};

struct _GamesGamepadViewConfiguration {
	gchar* svg_path;
	GamesGamepadButtonPath* button_paths;
	gint button_paths_length1;
	gint _button_paths_size_;
	GamesGamepadAnalogPath* analog_paths;
	gint analog_paths_length1;
	gint _analog_paths_size_;
	gchar** background_paths;
	gint background_paths_length1;
	gint _background_paths_size_;
};

struct _GamesGamepadTesterPrivate {
	GamesGamepadView* gamepad_view;
	gulong gamepad_button_press_event_handler_id;
	gulong gamepad_button_release_event_handler_id;
	gulong gamepad_axis_event_handler_id;
	ManetteDevice* _device;
	GamesGamepadViewConfiguration _configuration;
};

static gint GamesGamepadTester_private_offset;
static gpointer games_gamepad_tester_parent_class = NULL;

VALA_EXTERN GType games_gamepad_tester_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_view_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_view_configuration_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_button_path_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_input_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGamepadInput* games_gamepad_input_dup (const GamesGamepadInput* self);
VALA_EXTERN void games_gamepad_input_free (GamesGamepadInput* self);
VALA_EXTERN GamesGamepadButtonPath* games_gamepad_button_path_dup (const GamesGamepadButtonPath* self);
VALA_EXTERN void games_gamepad_button_path_free (GamesGamepadButtonPath* self);
VALA_EXTERN void games_gamepad_button_path_copy (const GamesGamepadButtonPath* self,
                                     GamesGamepadButtonPath* dest);
VALA_EXTERN void games_gamepad_button_path_destroy (GamesGamepadButtonPath* self);
VALA_EXTERN GType games_gamepad_analog_path_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGamepadAnalogPath* games_gamepad_analog_path_dup (const GamesGamepadAnalogPath* self);
VALA_EXTERN void games_gamepad_analog_path_free (GamesGamepadAnalogPath* self);
VALA_EXTERN void games_gamepad_analog_path_copy (const GamesGamepadAnalogPath* self,
                                     GamesGamepadAnalogPath* dest);
VALA_EXTERN void games_gamepad_analog_path_destroy (GamesGamepadAnalogPath* self);
VALA_EXTERN GamesGamepadViewConfiguration* games_gamepad_view_configuration_dup (const GamesGamepadViewConfiguration* self);
VALA_EXTERN void games_gamepad_view_configuration_free (GamesGamepadViewConfiguration* self);
VALA_EXTERN void games_gamepad_view_configuration_copy (const GamesGamepadViewConfiguration* self,
                                            GamesGamepadViewConfiguration* dest);
VALA_EXTERN void games_gamepad_view_configuration_destroy (GamesGamepadViewConfiguration* self);
VALA_EXTERN GamesGamepadTester* games_gamepad_tester_new (ManetteDevice* device,
                                              GamesGamepadViewConfiguration* configuration);
VALA_EXTERN GamesGamepadTester* games_gamepad_tester_construct (GType object_type,
                                                    ManetteDevice* device,
                                                    GamesGamepadViewConfiguration* configuration);
VALA_EXTERN void games_gamepad_tester_start (GamesGamepadTester* self);
VALA_EXTERN void games_gamepad_view_reset (GamesGamepadView* self);
static void games_gamepad_tester_connect_to_gamepad (GamesGamepadTester* self);
VALA_EXTERN void games_gamepad_tester_stop (GamesGamepadTester* self);
static void games_gamepad_tester_disconnect_from_gamepad (GamesGamepadTester* self);
VALA_EXTERN ManetteDevice* games_gamepad_tester_get_device (GamesGamepadTester* self);
static void games_gamepad_tester_on_button_press_event (GamesGamepadTester* self,
                                                 ManetteEvent* event);
static void _games_gamepad_tester_on_button_press_event_manette_device_button_press_event (ManetteDevice* _sender,
                                                                                    ManetteEvent* event,
                                                                                    gpointer self);
static void games_gamepad_tester_on_button_release_event (GamesGamepadTester* self,
                                                   ManetteEvent* event);
static void _games_gamepad_tester_on_button_release_event_manette_device_button_release_event (ManetteDevice* _sender,
                                                                                        ManetteEvent* event,
                                                                                        gpointer self);
static void games_gamepad_tester_on_absolute_axis_event (GamesGamepadTester* self,
                                                  ManetteEvent* event);
static void _games_gamepad_tester_on_absolute_axis_event_manette_device_absolute_axis_event (ManetteDevice* _sender,
                                                                                      ManetteEvent* event,
                                                                                      gpointer self);
VALA_EXTERN gboolean games_gamepad_view_highlight (GamesGamepadView* self,
                                       GamesGamepadInput* input,
                                       gboolean highlight);
VALA_EXTERN gboolean games_gamepad_view_set_analog (GamesGamepadView* self,
                                        GamesGamepadInput* input,
                                        gdouble value);
static void games_gamepad_tester_set_device (GamesGamepadTester* self,
                                      ManetteDevice* value);
VALA_EXTERN void games_gamepad_tester_get_configuration (GamesGamepadTester* self,
                                             GamesGamepadViewConfiguration * result);
static void games_gamepad_tester_set_configuration (GamesGamepadTester* self,
                                             GamesGamepadViewConfiguration * value);
VALA_EXTERN void games_gamepad_view_set_configuration (GamesGamepadView* self,
                                           GamesGamepadViewConfiguration * value);
static void games_gamepad_tester_finalize (GObject * obj);
static GType games_gamepad_tester_get_type_once (void);
static void _vala_games_gamepad_tester_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_games_gamepad_tester_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_gamepad_tester_get_instance_private (GamesGamepadTester* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGamepadTester_private_offset);
}

GamesGamepadTester*
games_gamepad_tester_construct (GType object_type,
                                ManetteDevice* device,
                                GamesGamepadViewConfiguration* configuration)
{
	GamesGamepadTester * self = NULL;
	GamesGamepadViewConfiguration _tmp0_;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (configuration != NULL, NULL);
	_tmp0_ = *configuration;
	self = (GamesGamepadTester*) g_object_new (object_type, "device", device, "configuration", &_tmp0_, NULL);
	return self;
}

GamesGamepadTester*
games_gamepad_tester_new (ManetteDevice* device,
                          GamesGamepadViewConfiguration* configuration)
{
	return games_gamepad_tester_construct (GAMES_TYPE_GAMEPAD_TESTER, device, configuration);
}

void
games_gamepad_tester_start (GamesGamepadTester* self)
{
	GamesGamepadView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gamepad_view;
	games_gamepad_view_reset (_tmp0_);
	games_gamepad_tester_connect_to_gamepad (self);
}

void
games_gamepad_tester_stop (GamesGamepadTester* self)
{
	g_return_if_fail (self != NULL);
	games_gamepad_tester_disconnect_from_gamepad (self);
}

static void
_games_gamepad_tester_on_button_press_event_manette_device_button_press_event (ManetteDevice* _sender,
                                                                               ManetteEvent* event,
                                                                               gpointer self)
{
	games_gamepad_tester_on_button_press_event ((GamesGamepadTester*) self, event);
}

static void
_games_gamepad_tester_on_button_release_event_manette_device_button_release_event (ManetteDevice* _sender,
                                                                                   ManetteEvent* event,
                                                                                   gpointer self)
{
	games_gamepad_tester_on_button_release_event ((GamesGamepadTester*) self, event);
}

static void
_games_gamepad_tester_on_absolute_axis_event_manette_device_absolute_axis_event (ManetteDevice* _sender,
                                                                                 ManetteEvent* event,
                                                                                 gpointer self)
{
	games_gamepad_tester_on_absolute_axis_event ((GamesGamepadTester*) self, event);
}

static void
games_gamepad_tester_connect_to_gamepad (GamesGamepadTester* self)
{
	ManetteDevice* _tmp0_;
	gulong _tmp1_;
	ManetteDevice* _tmp2_;
	gulong _tmp3_;
	ManetteDevice* _tmp4_;
	gulong _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_device;
	_tmp1_ = g_signal_connect_object (_tmp0_, "button-press-event", (GCallback) _games_gamepad_tester_on_button_press_event_manette_device_button_press_event, self, 0);
	self->priv->gamepad_button_press_event_handler_id = _tmp1_;
	_tmp2_ = self->priv->_device;
	_tmp3_ = g_signal_connect_object (_tmp2_, "button-release-event", (GCallback) _games_gamepad_tester_on_button_release_event_manette_device_button_release_event, self, 0);
	self->priv->gamepad_button_release_event_handler_id = _tmp3_;
	_tmp4_ = self->priv->_device;
	_tmp5_ = g_signal_connect_object (_tmp4_, "absolute-axis-event", (GCallback) _games_gamepad_tester_on_absolute_axis_event_manette_device_absolute_axis_event, self, 0);
	self->priv->gamepad_axis_event_handler_id = _tmp5_;
}

static void
games_gamepad_tester_disconnect_from_gamepad (GamesGamepadTester* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->gamepad_button_press_event_handler_id != ((gulong) 0)) {
		ManetteDevice* _tmp0_;
		_tmp0_ = self->priv->_device;
		g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->gamepad_button_press_event_handler_id);
		self->priv->gamepad_button_press_event_handler_id = (gulong) 0;
	}
	if (self->priv->gamepad_button_release_event_handler_id != ((gulong) 0)) {
		ManetteDevice* _tmp1_;
		_tmp1_ = self->priv->_device;
		g_signal_handler_disconnect ((GObject*) _tmp1_, self->priv->gamepad_button_release_event_handler_id);
		self->priv->gamepad_button_release_event_handler_id = (gulong) 0;
	}
	if (self->priv->gamepad_axis_event_handler_id != ((gulong) 0)) {
		ManetteDevice* _tmp2_;
		_tmp2_ = self->priv->_device;
		g_signal_handler_disconnect ((GObject*) _tmp2_, self->priv->gamepad_axis_event_handler_id);
		self->priv->gamepad_axis_event_handler_id = (gulong) 0;
	}
}

static void
games_gamepad_tester_on_button_press_event (GamesGamepadTester* self,
                                            ManetteEvent* event)
{
	guint16 button = 0U;
	guint16 _tmp0_ = 0U;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp1_ = manette_event_get_button (event, &_tmp0_);
	button = _tmp0_;
	if (_tmp1_) {
		GamesGamepadView* _tmp2_;
		GamesGamepadInput _tmp3_ = {0};
		_tmp2_ = self->priv->gamepad_view;
		_tmp3_.type = EV_KEY;
		_tmp3_.code = button;
		games_gamepad_view_highlight (_tmp2_, &_tmp3_, TRUE);
	}
}

static void
games_gamepad_tester_on_button_release_event (GamesGamepadTester* self,
                                              ManetteEvent* event)
{
	guint16 button = 0U;
	guint16 _tmp0_ = 0U;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp1_ = manette_event_get_button (event, &_tmp0_);
	button = _tmp0_;
	if (_tmp1_) {
		GamesGamepadView* _tmp2_;
		GamesGamepadInput _tmp3_ = {0};
		_tmp2_ = self->priv->gamepad_view;
		_tmp3_.type = EV_KEY;
		_tmp3_.code = button;
		games_gamepad_view_highlight (_tmp2_, &_tmp3_, FALSE);
	}
}

static void
games_gamepad_tester_on_absolute_axis_event (GamesGamepadTester* self,
                                             ManetteEvent* event)
{
	guint16 axis = 0U;
	gdouble value = 0.0;
	guint16 _tmp0_ = 0U;
	gdouble _tmp1_ = 0.0;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp2_ = manette_event_get_absolute (event, &_tmp0_, &_tmp1_);
	axis = _tmp0_;
	value = _tmp1_;
	if (_tmp2_) {
		GamesGamepadView* _tmp3_;
		GamesGamepadInput _tmp4_ = {0};
		_tmp3_ = self->priv->gamepad_view;
		_tmp4_.type = EV_ABS;
		_tmp4_.code = axis;
		games_gamepad_view_set_analog (_tmp3_, &_tmp4_, value);
	}
}

ManetteDevice*
games_gamepad_tester_get_device (GamesGamepadTester* self)
{
	ManetteDevice* result;
	ManetteDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_gamepad_tester_set_device (GamesGamepadTester* self,
                                 ManetteDevice* value)
{
	ManetteDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_gamepad_tester_get_device (self);
	if (old_value != value) {
		ManetteDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_device);
		self->priv->_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_gamepad_tester_properties[GAMES_GAMEPAD_TESTER_DEVICE_PROPERTY]);
	}
}

void
games_gamepad_tester_get_configuration (GamesGamepadTester* self,
                                        GamesGamepadViewConfiguration * result)
{
	GamesGamepadViewConfiguration _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_configuration;
	*result = _tmp0_;
	return;
}

static void
games_gamepad_tester_set_configuration (GamesGamepadTester* self,
                                        GamesGamepadViewConfiguration * value)
{
	GamesGamepadViewConfiguration _tmp0_;
	GamesGamepadViewConfiguration _tmp1_;
	GamesGamepadViewConfiguration _tmp2_ = {0};
	GamesGamepadView* _tmp3_;
	GamesGamepadViewConfiguration _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	_tmp1_ = _tmp0_;
	games_gamepad_view_configuration_copy (&_tmp1_, &_tmp2_);
	games_gamepad_view_configuration_destroy (&self->priv->_configuration);
	self->priv->_configuration = _tmp2_;
	_tmp3_ = self->priv->gamepad_view;
	_tmp4_ = *value;
	games_gamepad_view_set_configuration (_tmp3_, &_tmp4_);
	g_object_notify_by_pspec ((GObject *) self, games_gamepad_tester_properties[GAMES_GAMEPAD_TESTER_CONFIGURATION_PROPERTY]);
}

static void
games_gamepad_tester_class_init (GamesGamepadTesterClass * klass,
                                 gpointer klass_data)
{
	games_gamepad_tester_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesGamepadTester_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_gamepad_tester_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_gamepad_tester_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_gamepad_tester_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAMEPAD_TESTER_DEVICE_PROPERTY, games_gamepad_tester_properties[GAMES_GAMEPAD_TESTER_DEVICE_PROPERTY] = g_param_spec_object ("device", "device", "device", manette_device_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAMEPAD_TESTER_CONFIGURATION_PROPERTY, games_gamepad_tester_properties[GAMES_GAMEPAD_TESTER_CONFIGURATION_PROPERTY] = g_param_spec_boxed ("configuration", "configuration", "configuration", GAMES_TYPE_GAMEPAD_VIEW_CONFIGURATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Games/gamepad/gamepad-tester.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "gamepad_view", FALSE, GamesGamepadTester_private_offset + G_STRUCT_OFFSET (GamesGamepadTesterPrivate, gamepad_view));
}

static void
games_gamepad_tester_instance_init (GamesGamepadTester * self,
                                    gpointer klass)
{
	self->priv = games_gamepad_tester_get_instance_private (self);
	g_type_ensure (GAMES_TYPE_GAMEPAD_VIEW);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
games_gamepad_tester_finalize (GObject * obj)
{
	GamesGamepadTester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMEPAD_TESTER, GamesGamepadTester);
	_g_object_unref0 (self->priv->_device);
	games_gamepad_view_configuration_destroy (&self->priv->_configuration);
	G_OBJECT_CLASS (games_gamepad_tester_parent_class)->finalize (obj);
}

static GType
games_gamepad_tester_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGamepadTesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_gamepad_tester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGamepadTester), 0, (GInstanceInitFunc) games_gamepad_tester_instance_init, NULL };
	GType games_gamepad_tester_type_id;
	games_gamepad_tester_type_id = g_type_register_static (gtk_bin_get_type (), "GamesGamepadTester", &g_define_type_info, 0);
	GamesGamepadTester_private_offset = g_type_add_instance_private (games_gamepad_tester_type_id, sizeof (GamesGamepadTesterPrivate));
	return games_gamepad_tester_type_id;
}

GType
games_gamepad_tester_get_type (void)
{
	static volatile gsize games_gamepad_tester_type_id__once = 0;
	if (g_once_init_enter (&games_gamepad_tester_type_id__once)) {
		GType games_gamepad_tester_type_id;
		games_gamepad_tester_type_id = games_gamepad_tester_get_type_once ();
		g_once_init_leave (&games_gamepad_tester_type_id__once, games_gamepad_tester_type_id);
	}
	return games_gamepad_tester_type_id__once;
}

static void
_vala_games_gamepad_tester_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GamesGamepadTester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAMEPAD_TESTER, GamesGamepadTester);
	switch (property_id) {
		case GAMES_GAMEPAD_TESTER_DEVICE_PROPERTY:
		g_value_set_object (value, games_gamepad_tester_get_device (self));
		break;
		case GAMES_GAMEPAD_TESTER_CONFIGURATION_PROPERTY:
		{
			GamesGamepadViewConfiguration boxed;
			games_gamepad_tester_get_configuration (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_gamepad_tester_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GamesGamepadTester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAMEPAD_TESTER, GamesGamepadTester);
	switch (property_id) {
		case GAMES_GAMEPAD_TESTER_DEVICE_PROPERTY:
		games_gamepad_tester_set_device (self, g_value_get_object (value));
		break;
		case GAMES_GAMEPAD_TESTER_CONFIGURATION_PROPERTY:
		games_gamepad_tester_set_configuration (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

