/* gamepad-mapping-builder.c generated by valac 0.56.8, the Vala compiler
 * generated from gamepad-mapping-builder.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "linux/input-event-codes.h"
#include <float.h>
#include <math.h>
#include "gnome-games.h"

#define GAMES_TYPE_GAMEPAD_MAPPING_BUILDER (games_gamepad_mapping_builder_get_type ())
#define GAMES_GAMEPAD_MAPPING_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER, GamesGamepadMappingBuilder))
#define GAMES_GAMEPAD_MAPPING_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER, GamesGamepadMappingBuilderClass))
#define GAMES_IS_GAMEPAD_MAPPING_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER))
#define GAMES_IS_GAMEPAD_MAPPING_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER))
#define GAMES_GAMEPAD_MAPPING_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER, GamesGamepadMappingBuilderClass))

typedef struct _GamesGamepadMappingBuilder GamesGamepadMappingBuilder;
typedef struct _GamesGamepadMappingBuilderClass GamesGamepadMappingBuilderClass;
typedef struct _GamesGamepadMappingBuilderPrivate GamesGamepadMappingBuilderPrivate;

#define GAMES_GAMEPAD_MAPPING_BUILDER_TYPE_GAMEPAD_INPUT_MAPPING (games_gamepad_mapping_builder_gamepad_input_mapping_get_type ())
typedef struct _GamesGamepadMappingBuilderGamepadInputMapping GamesGamepadMappingBuilderGamepadInputMapping;

#define GAMES_TYPE_GAMEPAD_DPAD (games_gamepad_dpad_get_type ())
typedef struct _GamesGamepadDPad GamesGamepadDPad;

#define GAMES_GAMEPAD_MAPPING_BUILDER_TYPE_GAMEPAD_AXIS_MAPPING (games_gamepad_mapping_builder_gamepad_axis_mapping_get_type ())
typedef struct _GamesGamepadMappingBuilderGamepadAxisMapping GamesGamepadMappingBuilderGamepadAxisMapping;
enum  {
	GAMES_GAMEPAD_MAPPING_BUILDER_0_PROPERTY,
	GAMES_GAMEPAD_MAPPING_BUILDER_NUM_PROPERTIES
};
static GParamSpec* games_gamepad_mapping_builder_properties[GAMES_GAMEPAD_MAPPING_BUILDER_NUM_PROPERTIES];

#define GAMES_GAMEPAD_MAPPING_BUILDER_TYPE_GAMEPAD_INPUT_SOURCE (games_gamepad_mapping_builder_gamepad_input_source_get_type ())
typedef struct _GamesGamepadMappingBuilderGamepadInputSource GamesGamepadMappingBuilderGamepadInputSource;

#define GAMES_TYPE_GAMEPAD_INPUT (games_gamepad_input_get_type ())
typedef struct _GamesGamepadInput GamesGamepadInput;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _games_gamepad_mapping_builder_gamepad_axis_mapping_free0(var) ((var == NULL) ? NULL : (var = (games_gamepad_mapping_builder_gamepad_axis_mapping_free (var), NULL)))

struct _GamesGamepadMappingBuilder {
	GObject parent_instance;
	GamesGamepadMappingBuilderPrivate * priv;
};

struct _GamesGamepadMappingBuilderClass {
	GObjectClass parent_class;
};

struct _GamesGamepadMappingBuilderGamepadInputMapping {
	gchar* source_string;
	gchar* destination_string;
};

struct _GamesGamepadDPad {
	gint32 axis_values[2];
};

struct _GamesGamepadMappingBuilderGamepadAxisMapping {
	gboolean positive_mapped;
	gboolean negative_mapped;
};

struct _GamesGamepadMappingBuilderPrivate {
	GamesGamepadMappingBuilderGamepadInputMapping* mappings;
	gint mappings_length1;
	gint _mappings_size_;
	GamesGamepadDPad* dpads;
	gint dpads_length1;
	gint _dpads_size_;
	GHashTable* axes;
};

struct _GamesGamepadInput {
	guint16 type;
	guint16 code;
};

struct _GamesGamepadMappingBuilderGamepadInputSource {
	GamesGamepadInput input;
	gchar* source;
};

static gint GamesGamepadMappingBuilder_private_offset;
static gpointer games_gamepad_mapping_builder_parent_class = NULL;

VALA_EXTERN GType games_gamepad_mapping_builder_get_type (void) G_GNUC_CONST ;
static GType games_gamepad_mapping_builder_gamepad_input_mapping_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GamesGamepadMappingBuilderGamepadInputMapping* games_gamepad_mapping_builder_gamepad_input_mapping_dup (const GamesGamepadMappingBuilderGamepadInputMapping* self);
static void games_gamepad_mapping_builder_gamepad_input_mapping_free (GamesGamepadMappingBuilderGamepadInputMapping* self);
static void games_gamepad_mapping_builder_gamepad_input_mapping_copy (const GamesGamepadMappingBuilderGamepadInputMapping* self,
                                                               GamesGamepadMappingBuilderGamepadInputMapping* dest);
static void games_gamepad_mapping_builder_gamepad_input_mapping_destroy (GamesGamepadMappingBuilderGamepadInputMapping* self);
VALA_EXTERN GType games_gamepad_dpad_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGamepadDPad* games_gamepad_dpad_dup (const GamesGamepadDPad* self);
VALA_EXTERN void games_gamepad_dpad_free (GamesGamepadDPad* self);
static GType games_gamepad_mapping_builder_gamepad_axis_mapping_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GamesGamepadMappingBuilderGamepadAxisMapping* games_gamepad_mapping_builder_gamepad_axis_mapping_dup (const GamesGamepadMappingBuilderGamepadAxisMapping* self);
static void games_gamepad_mapping_builder_gamepad_axis_mapping_free (GamesGamepadMappingBuilderGamepadAxisMapping* self);
static GType games_gamepad_mapping_builder_gamepad_input_source_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GType games_gamepad_input_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGamepadInput* games_gamepad_input_dup (const GamesGamepadInput* self);
VALA_EXTERN void games_gamepad_input_free (GamesGamepadInput* self);
static GamesGamepadMappingBuilderGamepadInputSource* games_gamepad_mapping_builder_gamepad_input_source_dup (const GamesGamepadMappingBuilderGamepadInputSource* self);
static void games_gamepad_mapping_builder_gamepad_input_source_free (GamesGamepadMappingBuilderGamepadInputSource* self);
static void games_gamepad_mapping_builder_gamepad_input_source_copy (const GamesGamepadMappingBuilderGamepadInputSource* self,
                                                              GamesGamepadMappingBuilderGamepadInputSource* dest);
static void games_gamepad_mapping_builder_gamepad_input_source_destroy (GamesGamepadMappingBuilderGamepadInputSource* self);
static void _vala_GamesGamepadMappingBuilderGamepadInputMapping_array_free (GamesGamepadMappingBuilderGamepadInputMapping * array,
                                                                     gssize array_length);
VALA_EXTERN gchar* games_gamepad_mapping_builder_build_sdl_string (GamesGamepadMappingBuilder* self);
VALA_EXTERN gboolean games_gamepad_mapping_builder_set_button_mapping (GamesGamepadMappingBuilder* self,
                                                           guint8 hardware_index,
                                                           GamesGamepadInput* source);
static gboolean games_gamepad_mapping_builder_add_destination (GamesGamepadMappingBuilder* self,
                                                        const gchar* destination_string,
                                                        GamesGamepadInput* source);
VALA_EXTERN gboolean games_gamepad_mapping_builder_set_axis_mapping (GamesGamepadMappingBuilder* self,
                                                         guint8 hardware_index,
                                                         gint range,
                                                         GamesGamepadInput* source);
VALA_EXTERN gboolean games_gamepad_mapping_builder_set_hat_mapping (GamesGamepadMappingBuilder* self,
                                                        guint8 hardware_index,
                                                        gint32 value,
                                                        GamesGamepadInput* source);
static void _vala_array_add19 (GamesGamepadDPad* * array,
                        gint* length,
                        gint* size,
                        const GamesGamepadDPad* value);
static gboolean games_gamepad_mapping_builder_is_mapping_present (GamesGamepadMappingBuilder* self,
                                                           const gchar* destination_string);
static gchar* games_gamepad_mapping_builder_get_mapping_source (GamesGamepadMappingBuilder* self,
                                                         GamesGamepadInput* input);
static void _vala_array_add20 (GamesGamepadMappingBuilderGamepadInputMapping* * array,
                        gint* length,
                        gint* size,
                        const GamesGamepadMappingBuilderGamepadInputMapping* value);
static gboolean _games_gamepad_input_equal (const GamesGamepadInput * s1,
                                     const GamesGamepadInput * s2);
VALA_EXTERN GamesGamepadMappingBuilder* games_gamepad_mapping_builder_new (void);
VALA_EXTERN GamesGamepadMappingBuilder* games_gamepad_mapping_builder_construct (GType object_type);
static GObject * games_gamepad_mapping_builder_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void _games_gamepad_mapping_builder_gamepad_axis_mapping_free0_ (gpointer var);
static void games_gamepad_mapping_builder_finalize (GObject * obj);
static GType games_gamepad_mapping_builder_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GamesGamepadMappingBuilderGamepadInputSource GAMES_GAMEPAD_MAPPING_BUILDER_INPUT_SOURCES[21] = {{{EV_ABS, ABS_X}, "leftx"}, {{EV_ABS, ABS_Y}, "lefty"}, {{EV_ABS, ABS_RX}, "rightx"}, {{EV_ABS, ABS_RY}, "righty"}, {{EV_KEY, BTN_A}, "a"}, {{EV_KEY, BTN_B}, "b"}, {{EV_KEY, BTN_DPAD_DOWN}, "dpdown"}, {{EV_KEY, BTN_DPAD_LEFT}, "dpleft"}, {{EV_KEY, BTN_DPAD_RIGHT}, "dpright"}, {{EV_KEY, BTN_DPAD_UP}, "dpup"}, {{EV_KEY, BTN_MODE}, "guide"}, {{EV_KEY, BTN_SELECT}, "back"}, {{EV_KEY, BTN_TL}, "leftshoulder"}, {{EV_KEY, BTN_TR}, "rightshoulder"}, {{EV_KEY, BTN_START}, "start"}, {{EV_KEY, BTN_THUMBL}, "leftstick"}, {{EV_KEY, BTN_THUMBR}, "rightstick"}, {{EV_KEY, BTN_TL2}, "lefttrigger"}, {{EV_KEY, BTN_TR2}, "righttrigger"}, {{EV_KEY, BTN_Y}, "x"}, {{EV_KEY, BTN_X}, "y"}};

static inline gpointer
games_gamepad_mapping_builder_get_instance_private (GamesGamepadMappingBuilder* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGamepadMappingBuilder_private_offset);
}

static void
_vala_GamesGamepadMappingBuilderGamepadInputMapping_array_free (GamesGamepadMappingBuilderGamepadInputMapping * array,
                                                                gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			games_gamepad_mapping_builder_gamepad_input_mapping_destroy (&array[i]);
		}
	}
	g_free (array);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
games_gamepad_mapping_builder_build_sdl_string (GamesGamepadMappingBuilder* self)
{
	gchar* sdl_string = NULL;
	gchar* _tmp0_;
	GamesGamepadMappingBuilderGamepadInputMapping* _tmp1_;
	gint _tmp1__length1;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("platform:Linux,");
	sdl_string = _tmp0_;
	_tmp1_ = self->priv->mappings;
	_tmp1__length1 = self->priv->mappings_length1;
	{
		GamesGamepadMappingBuilderGamepadInputMapping* mapping_collection = NULL;
		gint mapping_collection_length1 = 0;
		gint _mapping_collection_size_ = 0;
		gint mapping_it = 0;
		mapping_collection = _tmp1_;
		mapping_collection_length1 = _tmp1__length1;
		for (mapping_it = 0; mapping_it < mapping_collection_length1; mapping_it = mapping_it + 1) {
			GamesGamepadMappingBuilderGamepadInputMapping _tmp2_;
			GamesGamepadMappingBuilderGamepadInputMapping _tmp3_ = {0};
			GamesGamepadMappingBuilderGamepadInputMapping mapping = {0};
			_tmp2_ = mapping_collection[mapping_it];
			games_gamepad_mapping_builder_gamepad_input_mapping_copy (&_tmp2_, &_tmp3_);
			mapping = _tmp3_;
			{
				const gchar* _tmp4_;
				GamesGamepadMappingBuilderGamepadInputMapping _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				GamesGamepadMappingBuilderGamepadInputMapping _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp4_ = sdl_string;
				_tmp5_ = mapping;
				_tmp6_ = _tmp5_.source_string;
				_tmp7_ = string_to_string (_tmp6_);
				_tmp8_ = mapping;
				_tmp9_ = _tmp8_.destination_string;
				_tmp10_ = string_to_string (_tmp9_);
				_tmp11_ = g_strconcat (_tmp7_, ":", _tmp10_, ",", NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (_tmp4_, _tmp12_, NULL);
				_g_free0 (sdl_string);
				sdl_string = _tmp13_;
				_g_free0 (_tmp12_);
				games_gamepad_mapping_builder_gamepad_input_mapping_destroy (&mapping);
			}
		}
	}
	result = sdl_string;
	return result;
}

gboolean
games_gamepad_mapping_builder_set_button_mapping (GamesGamepadMappingBuilder* self,
                                                  guint8 hardware_index,
                                                  GamesGamepadInput* source)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GamesGamepadInput _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("%hhu", hardware_index);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("b", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = *source;
	_tmp5_ = games_gamepad_mapping_builder_add_destination (self, _tmp3_, &_tmp4_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}

static gpointer
_games_gamepad_mapping_builder_gamepad_axis_mapping_dup0 (gpointer self)
{
	return self ? games_gamepad_mapping_builder_gamepad_axis_mapping_dup (self) : NULL;
}

gboolean
games_gamepad_mapping_builder_set_axis_mapping (GamesGamepadMappingBuilder* self,
                                                guint8 hardware_index,
                                                gint range,
                                                GamesGamepadInput* source)
{
	gchar* destination = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean positive = FALSE;
	gboolean negative = FALSE;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	GamesGamepadMappingBuilderGamepadAxisMapping* mapping = NULL;
	GHashTable* _tmp11_;
	const gchar* _tmp12_;
	gconstpointer _tmp13_;
	GamesGamepadMappingBuilderGamepadAxisMapping* _tmp14_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp20_ = FALSE;
	GamesGamepadMappingBuilderGamepadAxisMapping* _tmp21_;
	gboolean _tmp22_ = FALSE;
	GamesGamepadMappingBuilderGamepadAxisMapping* _tmp23_;
	GHashTable* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	GamesGamepadMappingBuilderGamepadAxisMapping _tmp27_ = {0};
	GamesGamepadMappingBuilderGamepadAxisMapping* _tmp28_;
	const gchar* _tmp41_;
	GamesGamepadInput _tmp42_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("%hhu", hardware_index);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("a", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	destination = _tmp3_;
	positive = range >= 0;
	negative = range <= 0;
	_tmp4_ = self->priv->axes;
	_tmp5_ = destination;
	if (!g_hash_table_contains (_tmp4_, _tmp5_)) {
		GHashTable* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		GamesGamepadMappingBuilderGamepadAxisMapping _tmp9_ = {0};
		GamesGamepadMappingBuilderGamepadAxisMapping* _tmp10_;
		_tmp6_ = self->priv->axes;
		_tmp7_ = destination;
		_tmp8_ = g_strdup (_tmp7_);
		_tmp9_.positive_mapped = FALSE;
		_tmp9_.negative_mapped = FALSE;
		_tmp10_ = _games_gamepad_mapping_builder_gamepad_axis_mapping_dup0 (&_tmp9_);
		g_hash_table_insert (_tmp6_, _tmp8_, _tmp10_);
	}
	_tmp11_ = self->priv->axes;
	_tmp12_ = destination;
	_tmp13_ = g_hash_table_lookup (_tmp11_, _tmp12_);
	_tmp14_ = _games_gamepad_mapping_builder_gamepad_axis_mapping_dup0 ((GamesGamepadMappingBuilderGamepadAxisMapping*) _tmp13_);
	mapping = _tmp14_;
	if (positive) {
		GamesGamepadMappingBuilderGamepadAxisMapping* _tmp17_;
		_tmp17_ = mapping;
		_tmp16_ = (*_tmp17_).positive_mapped;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		if (negative) {
			GamesGamepadMappingBuilderGamepadAxisMapping* _tmp19_;
			_tmp19_ = mapping;
			_tmp18_ = (*_tmp19_).negative_mapped;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp15_ = _tmp18_;
	}
	if (_tmp15_) {
		result = FALSE;
		_games_gamepad_mapping_builder_gamepad_axis_mapping_free0 (mapping);
		_g_free0 (destination);
		return result;
	}
	_tmp21_ = mapping;
	if ((*_tmp21_).positive_mapped) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = positive;
	}
	_tmp23_ = mapping;
	if ((*_tmp23_).negative_mapped) {
		_tmp22_ = TRUE;
	} else {
		_tmp22_ = negative;
	}
	_tmp24_ = self->priv->axes;
	_tmp25_ = destination;
	_tmp26_ = g_strdup (_tmp25_);
	_tmp27_.positive_mapped = _tmp20_;
	_tmp27_.negative_mapped = _tmp22_;
	_tmp28_ = _games_gamepad_mapping_builder_gamepad_axis_mapping_dup0 (&_tmp27_);
	g_hash_table_insert (_tmp24_, _tmp26_, _tmp28_);
	if (range > 0) {
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		GamesGamepadInput _tmp33_;
		gboolean _tmp34_;
		_tmp29_ = destination;
		_tmp30_ = string_to_string (_tmp29_);
		_tmp31_ = g_strconcat ("+", _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = *source;
		_tmp34_ = games_gamepad_mapping_builder_add_destination (self, _tmp32_, &_tmp33_);
		_g_free0 (_tmp32_);
		result = _tmp34_;
		_games_gamepad_mapping_builder_gamepad_axis_mapping_free0 (mapping);
		_g_free0 (destination);
		return result;
	}
	if (range < 0) {
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		GamesGamepadInput _tmp39_;
		gboolean _tmp40_;
		_tmp35_ = destination;
		_tmp36_ = string_to_string (_tmp35_);
		_tmp37_ = g_strconcat ("-", _tmp36_, NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = *source;
		_tmp40_ = games_gamepad_mapping_builder_add_destination (self, _tmp38_, &_tmp39_);
		_g_free0 (_tmp38_);
		result = _tmp40_;
		_games_gamepad_mapping_builder_gamepad_axis_mapping_free0 (mapping);
		_g_free0 (destination);
		return result;
	}
	_tmp41_ = destination;
	_tmp42_ = *source;
	result = games_gamepad_mapping_builder_add_destination (self, _tmp41_, &_tmp42_);
	_games_gamepad_mapping_builder_gamepad_axis_mapping_free0 (mapping);
	_g_free0 (destination);
	return result;
}

static void
_vala_array_add19 (GamesGamepadDPad* * array,
                   gint* length,
                   gint* size,
                   const GamesGamepadDPad* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesGamepadDPad, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

gboolean
games_gamepad_mapping_builder_set_hat_mapping (GamesGamepadMappingBuilder* self,
                                               guint8 hardware_index,
                                               gint32 value,
                                               GamesGamepadInput* source)
{
	gint dpad_index = 0;
	gint dpad_axis = 0;
	GamesGamepadDPad dpad = {0};
	GamesGamepadDPad* _tmp2_;
	gint _tmp2__length1;
	GamesGamepadDPad _tmp3_;
	gint32 _tmp4_ = 0;
	gint32 changed_value = 0;
	gint32 dpad_position = 0;
	gdouble dpad_position_2pow = 0.0;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GamesGamepadInput _tmp13_;
	gboolean _tmp14_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	dpad_index = hardware_index / 2;
	dpad_axis = hardware_index % 2;
	while (TRUE) {
		GamesGamepadDPad* _tmp0_;
		gint _tmp0__length1;
		GamesGamepadDPad _tmp1_ = {0};
		_tmp0_ = self->priv->dpads;
		_tmp0__length1 = self->priv->dpads_length1;
		if (!(_tmp0__length1 <= ((gint) hardware_index))) {
			break;
		}
		memset (&_tmp1_, 0, sizeof (GamesGamepadDPad));
		_vala_array_add19 (&self->priv->dpads, &self->priv->dpads_length1, &self->priv->_dpads_size_, &_tmp1_);
	}
	_tmp2_ = self->priv->dpads;
	_tmp2__length1 = self->priv->dpads_length1;
	_tmp3_ = _tmp2_[dpad_index];
	dpad = _tmp3_;
	if (value == ((gint32) 0)) {
		GamesGamepadDPad _tmp5_;
		gint32 _tmp6_;
		_tmp5_ = dpad;
		_tmp6_ = _tmp5_.axis_values[dpad_axis];
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = value;
	}
	changed_value = _tmp4_;
	dpad.axis_values[dpad_axis] = value;
	dpad_position = ((changed_value + dpad_axis) + 4) % 4;
	dpad_position_2pow = pow ((gdouble) 2, (gdouble) dpad_position);
	_tmp7_ = g_strdup_printf ("%i", dpad_index);
	_tmp8_ = _tmp7_;
	_tmp9_ = double_to_string (dpad_position_2pow);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("h", _tmp8_, ".", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = *source;
	_tmp14_ = games_gamepad_mapping_builder_add_destination (self, _tmp12_, &_tmp13_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	result = _tmp14_;
	return result;
}

static void
_vala_array_add20 (GamesGamepadMappingBuilderGamepadInputMapping* * array,
                   gint* length,
                   gint* size,
                   const GamesGamepadMappingBuilderGamepadInputMapping* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesGamepadMappingBuilderGamepadInputMapping, *array, *size);
	}
	(*array)[(*length)++] = *value;
}

static gboolean
games_gamepad_mapping_builder_add_destination (GamesGamepadMappingBuilder* self,
                                               const gchar* destination_string,
                                               GamesGamepadInput* source)
{
	gchar* source_string = NULL;
	GamesGamepadInput _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GamesGamepadMappingBuilderGamepadInputMapping mapping = {0};
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GamesGamepadMappingBuilderGamepadInputMapping _tmp6_ = {0};
	GamesGamepadMappingBuilderGamepadInputMapping _tmp7_;
	GamesGamepadMappingBuilderGamepadInputMapping _tmp8_;
	GamesGamepadMappingBuilderGamepadInputMapping _tmp9_ = {0};
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (destination_string != NULL, FALSE);
	g_return_val_if_fail (source != NULL, FALSE);
	if (games_gamepad_mapping_builder_is_mapping_present (self, destination_string)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = *source;
	_tmp1_ = games_gamepad_mapping_builder_get_mapping_source (self, &_tmp0_);
	source_string = _tmp1_;
	_tmp2_ = source_string;
	if (_tmp2_ == NULL) {
		g_critical ("gamepad-mapping-builder.vala:133: Invalid input");
		result = FALSE;
		_g_free0 (source_string);
		return result;
	}
	_tmp3_ = source_string;
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = g_strdup (destination_string);
	_g_free0 (_tmp6_.source_string);
	_tmp6_.source_string = _tmp4_;
	_g_free0 (_tmp6_.destination_string);
	_tmp6_.destination_string = _tmp5_;
	mapping = _tmp6_;
	_tmp7_ = mapping;
	_tmp8_ = _tmp7_;
	games_gamepad_mapping_builder_gamepad_input_mapping_copy (&_tmp8_, &_tmp9_);
	_vala_array_add20 (&self->priv->mappings, &self->priv->mappings_length1, &self->priv->_mappings_size_, &_tmp9_);
	result = TRUE;
	games_gamepad_mapping_builder_gamepad_input_mapping_destroy (&mapping);
	_g_free0 (source_string);
	return result;
}

static gboolean
games_gamepad_mapping_builder_is_mapping_present (GamesGamepadMappingBuilder* self,
                                                  const gchar* destination_string)
{
	GamesGamepadMappingBuilderGamepadInputMapping* _tmp0_;
	gint _tmp0__length1;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (destination_string != NULL, FALSE);
	_tmp0_ = self->priv->mappings;
	_tmp0__length1 = self->priv->mappings_length1;
	{
		GamesGamepadMappingBuilderGamepadInputMapping* mapping_collection = NULL;
		gint mapping_collection_length1 = 0;
		gint _mapping_collection_size_ = 0;
		gint mapping_it = 0;
		mapping_collection = _tmp0_;
		mapping_collection_length1 = _tmp0__length1;
		for (mapping_it = 0; mapping_it < mapping_collection_length1; mapping_it = mapping_it + 1) {
			GamesGamepadMappingBuilderGamepadInputMapping _tmp1_;
			GamesGamepadMappingBuilderGamepadInputMapping _tmp2_ = {0};
			GamesGamepadMappingBuilderGamepadInputMapping mapping = {0};
			_tmp1_ = mapping_collection[mapping_it];
			games_gamepad_mapping_builder_gamepad_input_mapping_copy (&_tmp1_, &_tmp2_);
			mapping = _tmp2_;
			{
				GamesGamepadMappingBuilderGamepadInputMapping _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = mapping;
				_tmp4_ = _tmp3_.destination_string;
				if (g_strcmp0 (destination_string, _tmp4_) == 0) {
					result = TRUE;
					games_gamepad_mapping_builder_gamepad_input_mapping_destroy (&mapping);
					return result;
				}
				games_gamepad_mapping_builder_gamepad_input_mapping_destroy (&mapping);
			}
		}
	}
	result = FALSE;
	return result;
}

static gboolean
_games_gamepad_input_equal (const GamesGamepadInput * s1,
                            const GamesGamepadInput * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->type != s2->type) {
		return FALSE;
	}
	if (s1->code != s2->code) {
		return FALSE;
	}
	return TRUE;
}

static gchar*
games_gamepad_mapping_builder_get_mapping_source (GamesGamepadMappingBuilder* self,
                                                  GamesGamepadInput* input)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (input != NULL, NULL);
	{
		GamesGamepadMappingBuilderGamepadInputSource* input_source_collection = NULL;
		gint input_source_collection_length1 = 0;
		gint _input_source_collection_size_ = 0;
		gint input_source_it = 0;
		input_source_collection = GAMES_GAMEPAD_MAPPING_BUILDER_INPUT_SOURCES;
		input_source_collection_length1 = G_N_ELEMENTS (GAMES_GAMEPAD_MAPPING_BUILDER_INPUT_SOURCES);
		for (input_source_it = 0; input_source_it < input_source_collection_length1; input_source_it = input_source_it + 1) {
			GamesGamepadMappingBuilderGamepadInputSource input_source = {0};
			input_source = input_source_collection[input_source_it];
			{
				GamesGamepadInput _tmp0_;
				GamesGamepadMappingBuilderGamepadInputSource _tmp1_;
				GamesGamepadInput _tmp2_;
				_tmp0_ = *input;
				_tmp1_ = input_source;
				_tmp2_ = _tmp1_.input;
				if (_games_gamepad_input_equal (&_tmp0_, &_tmp2_) == TRUE) {
					GamesGamepadMappingBuilderGamepadInputSource _tmp3_;
					const gchar* _tmp4_;
					gchar* _tmp5_;
					_tmp3_ = input_source;
					_tmp4_ = _tmp3_.source;
					_tmp5_ = g_strdup (_tmp4_);
					result = _tmp5_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

GamesGamepadMappingBuilder*
games_gamepad_mapping_builder_construct (GType object_type)
{
	GamesGamepadMappingBuilder * self = NULL;
	self = (GamesGamepadMappingBuilder*) g_object_new (object_type, NULL);
	return self;
}

GamesGamepadMappingBuilder*
games_gamepad_mapping_builder_new (void)
{
	return games_gamepad_mapping_builder_construct (GAMES_TYPE_GAMEPAD_MAPPING_BUILDER);
}

static void
games_gamepad_mapping_builder_gamepad_input_source_copy (const GamesGamepadMappingBuilderGamepadInputSource* self,
                                                         GamesGamepadMappingBuilderGamepadInputSource* dest)
{
	GamesGamepadInput _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_tmp0_ = (*self).input;
	(*dest).input = _tmp0_;
	_tmp1_ = (*self).source;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).source);
	(*dest).source = _tmp2_;
}

static void
games_gamepad_mapping_builder_gamepad_input_source_destroy (GamesGamepadMappingBuilderGamepadInputSource* self)
{
	_g_free0 ((*self).source);
}

static GamesGamepadMappingBuilderGamepadInputSource*
games_gamepad_mapping_builder_gamepad_input_source_dup (const GamesGamepadMappingBuilderGamepadInputSource* self)
{
	GamesGamepadMappingBuilderGamepadInputSource* dup;
	dup = g_new0 (GamesGamepadMappingBuilderGamepadInputSource, 1);
	games_gamepad_mapping_builder_gamepad_input_source_copy (self, dup);
	return dup;
}

static void
games_gamepad_mapping_builder_gamepad_input_source_free (GamesGamepadMappingBuilderGamepadInputSource* self)
{
	games_gamepad_mapping_builder_gamepad_input_source_destroy (self);
	g_free (self);
}

static GType
games_gamepad_mapping_builder_gamepad_input_source_get_type_once (void)
{
	GType games_gamepad_mapping_builder_gamepad_input_source_type_id;
	games_gamepad_mapping_builder_gamepad_input_source_type_id = g_boxed_type_register_static ("GamesGamepadMappingBuilderGamepadInputSource", (GBoxedCopyFunc) games_gamepad_mapping_builder_gamepad_input_source_dup, (GBoxedFreeFunc) games_gamepad_mapping_builder_gamepad_input_source_free);
	return games_gamepad_mapping_builder_gamepad_input_source_type_id;
}

static GType
games_gamepad_mapping_builder_gamepad_input_source_get_type (void)
{
	static volatile gsize games_gamepad_mapping_builder_gamepad_input_source_type_id__once = 0;
	if (g_once_init_enter (&games_gamepad_mapping_builder_gamepad_input_source_type_id__once)) {
		GType games_gamepad_mapping_builder_gamepad_input_source_type_id;
		games_gamepad_mapping_builder_gamepad_input_source_type_id = games_gamepad_mapping_builder_gamepad_input_source_get_type_once ();
		g_once_init_leave (&games_gamepad_mapping_builder_gamepad_input_source_type_id__once, games_gamepad_mapping_builder_gamepad_input_source_type_id);
	}
	return games_gamepad_mapping_builder_gamepad_input_source_type_id__once;
}

static void
games_gamepad_mapping_builder_gamepad_input_mapping_copy (const GamesGamepadMappingBuilderGamepadInputMapping* self,
                                                          GamesGamepadMappingBuilderGamepadInputMapping* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).source_string;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).source_string);
	(*dest).source_string = _tmp1_;
	_tmp2_ = (*self).destination_string;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).destination_string);
	(*dest).destination_string = _tmp3_;
}

static void
games_gamepad_mapping_builder_gamepad_input_mapping_destroy (GamesGamepadMappingBuilderGamepadInputMapping* self)
{
	_g_free0 ((*self).source_string);
	_g_free0 ((*self).destination_string);
}

static GamesGamepadMappingBuilderGamepadInputMapping*
games_gamepad_mapping_builder_gamepad_input_mapping_dup (const GamesGamepadMappingBuilderGamepadInputMapping* self)
{
	GamesGamepadMappingBuilderGamepadInputMapping* dup;
	dup = g_new0 (GamesGamepadMappingBuilderGamepadInputMapping, 1);
	games_gamepad_mapping_builder_gamepad_input_mapping_copy (self, dup);
	return dup;
}

static void
games_gamepad_mapping_builder_gamepad_input_mapping_free (GamesGamepadMappingBuilderGamepadInputMapping* self)
{
	games_gamepad_mapping_builder_gamepad_input_mapping_destroy (self);
	g_free (self);
}

static GType
games_gamepad_mapping_builder_gamepad_input_mapping_get_type_once (void)
{
	GType games_gamepad_mapping_builder_gamepad_input_mapping_type_id;
	games_gamepad_mapping_builder_gamepad_input_mapping_type_id = g_boxed_type_register_static ("GamesGamepadMappingBuilderGamepadInputMapping", (GBoxedCopyFunc) games_gamepad_mapping_builder_gamepad_input_mapping_dup, (GBoxedFreeFunc) games_gamepad_mapping_builder_gamepad_input_mapping_free);
	return games_gamepad_mapping_builder_gamepad_input_mapping_type_id;
}

static GType
games_gamepad_mapping_builder_gamepad_input_mapping_get_type (void)
{
	static volatile gsize games_gamepad_mapping_builder_gamepad_input_mapping_type_id__once = 0;
	if (g_once_init_enter (&games_gamepad_mapping_builder_gamepad_input_mapping_type_id__once)) {
		GType games_gamepad_mapping_builder_gamepad_input_mapping_type_id;
		games_gamepad_mapping_builder_gamepad_input_mapping_type_id = games_gamepad_mapping_builder_gamepad_input_mapping_get_type_once ();
		g_once_init_leave (&games_gamepad_mapping_builder_gamepad_input_mapping_type_id__once, games_gamepad_mapping_builder_gamepad_input_mapping_type_id);
	}
	return games_gamepad_mapping_builder_gamepad_input_mapping_type_id__once;
}

static GamesGamepadMappingBuilderGamepadAxisMapping*
games_gamepad_mapping_builder_gamepad_axis_mapping_dup (const GamesGamepadMappingBuilderGamepadAxisMapping* self)
{
	GamesGamepadMappingBuilderGamepadAxisMapping* dup;
	dup = g_new0 (GamesGamepadMappingBuilderGamepadAxisMapping, 1);
	memcpy (dup, self, sizeof (GamesGamepadMappingBuilderGamepadAxisMapping));
	return dup;
}

static void
games_gamepad_mapping_builder_gamepad_axis_mapping_free (GamesGamepadMappingBuilderGamepadAxisMapping* self)
{
	g_free (self);
}

static GType
games_gamepad_mapping_builder_gamepad_axis_mapping_get_type_once (void)
{
	GType games_gamepad_mapping_builder_gamepad_axis_mapping_type_id;
	games_gamepad_mapping_builder_gamepad_axis_mapping_type_id = g_boxed_type_register_static ("GamesGamepadMappingBuilderGamepadAxisMapping", (GBoxedCopyFunc) games_gamepad_mapping_builder_gamepad_axis_mapping_dup, (GBoxedFreeFunc) games_gamepad_mapping_builder_gamepad_axis_mapping_free);
	return games_gamepad_mapping_builder_gamepad_axis_mapping_type_id;
}

static GType
games_gamepad_mapping_builder_gamepad_axis_mapping_get_type (void)
{
	static volatile gsize games_gamepad_mapping_builder_gamepad_axis_mapping_type_id__once = 0;
	if (g_once_init_enter (&games_gamepad_mapping_builder_gamepad_axis_mapping_type_id__once)) {
		GType games_gamepad_mapping_builder_gamepad_axis_mapping_type_id;
		games_gamepad_mapping_builder_gamepad_axis_mapping_type_id = games_gamepad_mapping_builder_gamepad_axis_mapping_get_type_once ();
		g_once_init_leave (&games_gamepad_mapping_builder_gamepad_axis_mapping_type_id__once, games_gamepad_mapping_builder_gamepad_axis_mapping_type_id);
	}
	return games_gamepad_mapping_builder_gamepad_axis_mapping_type_id__once;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_games_gamepad_mapping_builder_gamepad_axis_mapping_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (games_gamepad_mapping_builder_gamepad_axis_mapping_free (var), NULL));
}

static GObject *
games_gamepad_mapping_builder_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GamesGamepadMappingBuilder * self;
	GamesGamepadMappingBuilderGamepadInputMapping* _tmp0_;
	GamesGamepadDPad* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	GHashTable* _tmp4_;
	parent_class = G_OBJECT_CLASS (games_gamepad_mapping_builder_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMEPAD_MAPPING_BUILDER, GamesGamepadMappingBuilder);
	_tmp0_ = g_new0 (GamesGamepadMappingBuilderGamepadInputMapping, 0);
	self->priv->mappings = (_vala_GamesGamepadMappingBuilderGamepadInputMapping_array_free (self->priv->mappings, self->priv->mappings_length1), NULL);
	self->priv->mappings = _tmp0_;
	self->priv->mappings_length1 = 0;
	self->priv->_mappings_size_ = self->priv->mappings_length1;
	_tmp1_ = g_new0 (GamesGamepadDPad, 0);
	self->priv->dpads = (g_free (self->priv->dpads), NULL);
	self->priv->dpads = _tmp1_;
	self->priv->dpads_length1 = 0;
	self->priv->_dpads_size_ = self->priv->dpads_length1;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = g_hash_table_new_full (_tmp2_, _tmp3_, _g_free0_, _games_gamepad_mapping_builder_gamepad_axis_mapping_free0_);
	_g_hash_table_unref0 (self->priv->axes);
	self->priv->axes = _tmp4_;
	return obj;
}

static void
games_gamepad_mapping_builder_class_init (GamesGamepadMappingBuilderClass * klass,
                                          gpointer klass_data)
{
	games_gamepad_mapping_builder_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesGamepadMappingBuilder_private_offset);
	G_OBJECT_CLASS (klass)->constructor = games_gamepad_mapping_builder_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_gamepad_mapping_builder_finalize;
}

static void
games_gamepad_mapping_builder_instance_init (GamesGamepadMappingBuilder * self,
                                             gpointer klass)
{
	self->priv = games_gamepad_mapping_builder_get_instance_private (self);
}

static void
games_gamepad_mapping_builder_finalize (GObject * obj)
{
	GamesGamepadMappingBuilder * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMEPAD_MAPPING_BUILDER, GamesGamepadMappingBuilder);
	self->priv->mappings = (_vala_GamesGamepadMappingBuilderGamepadInputMapping_array_free (self->priv->mappings, self->priv->mappings_length1), NULL);
	self->priv->dpads = (g_free (self->priv->dpads), NULL);
	_g_hash_table_unref0 (self->priv->axes);
	G_OBJECT_CLASS (games_gamepad_mapping_builder_parent_class)->finalize (obj);
}

static GType
games_gamepad_mapping_builder_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGamepadMappingBuilderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_gamepad_mapping_builder_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGamepadMappingBuilder), 0, (GInstanceInitFunc) games_gamepad_mapping_builder_instance_init, NULL };
	GType games_gamepad_mapping_builder_type_id;
	games_gamepad_mapping_builder_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesGamepadMappingBuilder", &g_define_type_info, 0);
	GamesGamepadMappingBuilder_private_offset = g_type_add_instance_private (games_gamepad_mapping_builder_type_id, sizeof (GamesGamepadMappingBuilderPrivate));
	return games_gamepad_mapping_builder_type_id;
}

GType
games_gamepad_mapping_builder_get_type (void)
{
	static volatile gsize games_gamepad_mapping_builder_type_id__once = 0;
	if (g_once_init_enter (&games_gamepad_mapping_builder_type_id__once)) {
		GType games_gamepad_mapping_builder_type_id;
		games_gamepad_mapping_builder_type_id = games_gamepad_mapping_builder_get_type_once ();
		g_once_init_leave (&games_gamepad_mapping_builder_type_id__once, games_gamepad_mapping_builder_type_id);
	}
	return games_gamepad_mapping_builder_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

