/* gamepad-mapper.c generated by valac 0.56.8, the Vala compiler
 * generated from gamepad-mapper.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <libmanette.h>
#include <float.h>
#include <math.h>
#include "linux/input-event-codes.h"
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include "gnome-games.h"

#define GAMES_GAMEPAD_MAPPER_ANALOG_ANIMATION_SPEED 166660.0

#define GAMES_TYPE_GAMEPAD_MAPPER (games_gamepad_mapper_get_type ())
#define GAMES_GAMEPAD_MAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD_MAPPER, GamesGamepadMapper))
#define GAMES_GAMEPAD_MAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD_MAPPER, GamesGamepadMapperClass))
#define GAMES_IS_GAMEPAD_MAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD_MAPPER))
#define GAMES_IS_GAMEPAD_MAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD_MAPPER))
#define GAMES_GAMEPAD_MAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD_MAPPER, GamesGamepadMapperClass))

typedef struct _GamesGamepadMapper GamesGamepadMapper;
typedef struct _GamesGamepadMapperClass GamesGamepadMapperClass;
typedef struct _GamesGamepadMapperPrivate GamesGamepadMapperPrivate;

#define GAMES_TYPE_GAMEPAD_VIEW (games_gamepad_view_get_type ())
#define GAMES_GAMEPAD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadView))
#define GAMES_GAMEPAD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadViewClass))
#define GAMES_IS_GAMEPAD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD_VIEW))
#define GAMES_IS_GAMEPAD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD_VIEW))
#define GAMES_GAMEPAD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD_VIEW, GamesGamepadViewClass))

typedef struct _GamesGamepadView GamesGamepadView;
typedef struct _GamesGamepadViewClass GamesGamepadViewClass;

#define GAMES_TYPE_GAMEPAD_MAPPING_BUILDER (games_gamepad_mapping_builder_get_type ())
#define GAMES_GAMEPAD_MAPPING_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER, GamesGamepadMappingBuilder))
#define GAMES_GAMEPAD_MAPPING_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER, GamesGamepadMappingBuilderClass))
#define GAMES_IS_GAMEPAD_MAPPING_BUILDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER))
#define GAMES_IS_GAMEPAD_MAPPING_BUILDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER))
#define GAMES_GAMEPAD_MAPPING_BUILDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAMEPAD_MAPPING_BUILDER, GamesGamepadMappingBuilderClass))

typedef struct _GamesGamepadMappingBuilder GamesGamepadMappingBuilder;
typedef struct _GamesGamepadMappingBuilderClass GamesGamepadMappingBuilderClass;

#define GAMES_TYPE_GAMEPAD_INPUT (games_gamepad_input_get_type ())
typedef struct _GamesGamepadInput GamesGamepadInput;

#define GAMES_TYPE_GAMEPAD_VIEW_CONFIGURATION (games_gamepad_view_configuration_get_type ())
typedef struct _GamesGamepadViewConfiguration GamesGamepadViewConfiguration;

#define GAMES_TYPE_GAMEPAD_BUTTON_PATH (games_gamepad_button_path_get_type ())
typedef struct _GamesGamepadButtonPath GamesGamepadButtonPath;

#define GAMES_TYPE_GAMEPAD_ANALOG_PATH (games_gamepad_analog_path_get_type ())
typedef struct _GamesGamepadAnalogPath GamesGamepadAnalogPath;
enum  {
	GAMES_GAMEPAD_MAPPER_0_PROPERTY,
	GAMES_GAMEPAD_MAPPER_INFO_MESSAGE_PROPERTY,
	GAMES_GAMEPAD_MAPPER_DEVICE_PROPERTY,
	GAMES_GAMEPAD_MAPPER_CONFIGURATION_PROPERTY,
	GAMES_GAMEPAD_MAPPER_NUM_PROPERTIES
};
static GParamSpec* games_gamepad_mapper_properties[GAMES_GAMEPAD_MAPPER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GAMES_GAMEPAD_MAPPER_FINISHED_SIGNAL,
	GAMES_GAMEPAD_MAPPER_NUM_SIGNALS
};
static guint games_gamepad_mapper_signals[GAMES_GAMEPAD_MAPPER_NUM_SIGNALS] = {0};

struct _GamesGamepadMapper {
	GtkBin parent_instance;
	GamesGamepadMapperPrivate * priv;
};

struct _GamesGamepadMapperClass {
	GtkBinClass parent_class;
};

struct _GamesGamepadInput {
	guint16 type;
	guint16 code;
};

struct _GamesGamepadButtonPath {
	GamesGamepadInput input;
	gchar* path;
};

struct _GamesGamepadAnalogPath {
	GamesGamepadInput input_x;
	GamesGamepadInput input_y;
	gdouble offset_radius;
	gchar* path;
};

struct _GamesGamepadViewConfiguration {
	gchar* svg_path;
	GamesGamepadButtonPath* button_paths;
	gint button_paths_length1;
	gint _button_paths_size_;
	GamesGamepadAnalogPath* analog_paths;
	gint analog_paths_length1;
	gint _analog_paths_size_;
	gchar** background_paths;
	gint background_paths_length1;
	gint _background_paths_size_;
};

struct _GamesGamepadMapperPrivate {
	GamesGamepadView* gamepad_view;
	GamesGamepadMappingBuilder* mapping_builder;
	GamesGamepadInput* mapping_inputs;
	gint mapping_inputs_length1;
	gint _mapping_inputs_size_;
	GamesGamepadInput input;
	guint current_input_index;
	guint tick_cb;
	guint64 animation_start_time;
	gchar* _info_message;
	gulong gamepad_event_handler_id;
	ManetteDevice* _device;
	GamesGamepadViewConfiguration _configuration;
};

static gint GamesGamepadMapper_private_offset;
static gpointer games_gamepad_mapper_parent_class = NULL;

VALA_EXTERN GType games_gamepad_mapper_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_view_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_mapping_builder_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_input_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGamepadInput* games_gamepad_input_dup (const GamesGamepadInput* self);
VALA_EXTERN void games_gamepad_input_free (GamesGamepadInput* self);
VALA_EXTERN GType games_gamepad_view_configuration_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_gamepad_button_path_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGamepadButtonPath* games_gamepad_button_path_dup (const GamesGamepadButtonPath* self);
VALA_EXTERN void games_gamepad_button_path_free (GamesGamepadButtonPath* self);
VALA_EXTERN void games_gamepad_button_path_copy (const GamesGamepadButtonPath* self,
                                     GamesGamepadButtonPath* dest);
VALA_EXTERN void games_gamepad_button_path_destroy (GamesGamepadButtonPath* self);
VALA_EXTERN GType games_gamepad_analog_path_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGamepadAnalogPath* games_gamepad_analog_path_dup (const GamesGamepadAnalogPath* self);
VALA_EXTERN void games_gamepad_analog_path_free (GamesGamepadAnalogPath* self);
VALA_EXTERN void games_gamepad_analog_path_copy (const GamesGamepadAnalogPath* self,
                                     GamesGamepadAnalogPath* dest);
VALA_EXTERN void games_gamepad_analog_path_destroy (GamesGamepadAnalogPath* self);
VALA_EXTERN GamesGamepadViewConfiguration* games_gamepad_view_configuration_dup (const GamesGamepadViewConfiguration* self);
VALA_EXTERN void games_gamepad_view_configuration_free (GamesGamepadViewConfiguration* self);
VALA_EXTERN void games_gamepad_view_configuration_copy (const GamesGamepadViewConfiguration* self,
                                            GamesGamepadViewConfiguration* dest);
VALA_EXTERN void games_gamepad_view_configuration_destroy (GamesGamepadViewConfiguration* self);
VALA_EXTERN GamesGamepadMapper* games_gamepad_mapper_new (ManetteDevice* device,
                                              GamesGamepadViewConfiguration* configuration,
                                              GamesGamepadInput* mapping_inputs,
                                              gint mapping_inputs_length1);
VALA_EXTERN GamesGamepadMapper* games_gamepad_mapper_construct (GType object_type,
                                                    ManetteDevice* device,
                                                    GamesGamepadViewConfiguration* configuration,
                                                    GamesGamepadInput* mapping_inputs,
                                                    gint mapping_inputs_length1);
static GamesGamepadInput* _vala_array_dup9 (GamesGamepadInput* self,
                                     gssize length);
VALA_EXTERN void games_gamepad_mapper_start (GamesGamepadMapper* self);
VALA_EXTERN GamesGamepadMappingBuilder* games_gamepad_mapping_builder_new (void);
VALA_EXTERN GamesGamepadMappingBuilder* games_gamepad_mapping_builder_construct (GType object_type);
static void games_gamepad_mapper_connect_to_gamepad (GamesGamepadMapper* self);
static void games_gamepad_mapper_next_input (GamesGamepadMapper* self);
VALA_EXTERN void games_gamepad_mapper_stop (GamesGamepadMapper* self);
static void games_gamepad_mapper_disconnect_from_gamepad (GamesGamepadMapper* self);
VALA_EXTERN void games_gamepad_mapper_skip (GamesGamepadMapper* self);
VALA_EXTERN ManetteDevice* games_gamepad_mapper_get_device (GamesGamepadMapper* self);
static void games_gamepad_mapper_on_event (GamesGamepadMapper* self,
                                    ManetteEvent* event);
static void _games_gamepad_mapper_on_event_manette_device_event (ManetteDevice* _sender,
                                                          ManetteEvent* event,
                                                          gpointer self);
VALA_EXTERN gboolean games_gamepad_mapping_builder_set_button_mapping (GamesGamepadMappingBuilder* self,
                                                           guint8 hardware_index,
                                                           GamesGamepadInput* source);
VALA_EXTERN gboolean games_gamepad_mapping_builder_set_axis_mapping (GamesGamepadMappingBuilder* self,
                                                         guint8 hardware_index,
                                                         gint range,
                                                         GamesGamepadInput* source);
VALA_EXTERN gboolean games_gamepad_mapping_builder_set_hat_mapping (GamesGamepadMappingBuilder* self,
                                                        guint8 hardware_index,
                                                        gint32 value,
                                                        GamesGamepadInput* source);
VALA_EXTERN gchar* games_gamepad_mapping_builder_build_sdl_string (GamesGamepadMappingBuilder* self);
VALA_EXTERN void games_gamepad_view_reset (GamesGamepadView* self);
VALA_EXTERN gboolean games_gamepad_view_highlight (GamesGamepadView* self,
                                       GamesGamepadInput* input,
                                       gboolean highlight);
static gboolean ___lambda82_ (GamesGamepadMapper* self,
                       GtkWidget* widget,
                       GdkFrameClock* clock);
VALA_EXTERN gboolean games_gamepad_view_set_analog (GamesGamepadView* self,
                                        GamesGamepadInput* input,
                                        gdouble value);
static gboolean ____lambda82__gtk_tick_callback (GtkWidget* widget,
                                          GdkFrameClock* frame_clock,
                                          gpointer self);
static void games_gamepad_mapper_update_info_message (GamesGamepadMapper* self);
static void games_gamepad_mapper_set_info_message (GamesGamepadMapper* self,
                                            const gchar* value);
VALA_EXTERN const gchar* games_gamepad_mapper_get_info_message (GamesGamepadMapper* self);
static void games_gamepad_mapper_set_device (GamesGamepadMapper* self,
                                      ManetteDevice* value);
VALA_EXTERN void games_gamepad_mapper_get_configuration (GamesGamepadMapper* self,
                                             GamesGamepadViewConfiguration * result);
static void games_gamepad_mapper_set_configuration (GamesGamepadMapper* self,
                                             GamesGamepadViewConfiguration * value);
VALA_EXTERN void games_gamepad_view_set_configuration (GamesGamepadView* self,
                                           GamesGamepadViewConfiguration * value);
static void games_gamepad_mapper_finalize (GObject * obj);
static GType games_gamepad_mapper_get_type_once (void);
static void _vala_games_gamepad_mapper_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_games_gamepad_mapper_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
games_gamepad_mapper_get_instance_private (GamesGamepadMapper* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGamepadMapper_private_offset);
}

static GamesGamepadInput*
_vala_array_dup9 (GamesGamepadInput* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (GamesGamepadInput));
	}
	return NULL;
}

GamesGamepadMapper*
games_gamepad_mapper_construct (GType object_type,
                                ManetteDevice* device,
                                GamesGamepadViewConfiguration* configuration,
                                GamesGamepadInput* mapping_inputs,
                                gint mapping_inputs_length1)
{
	GamesGamepadMapper * self = NULL;
	GamesGamepadViewConfiguration _tmp0_;
	GamesGamepadInput* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (device != NULL, NULL);
	g_return_val_if_fail (configuration != NULL, NULL);
	_tmp0_ = *configuration;
	self = (GamesGamepadMapper*) g_object_new (object_type, "device", device, "configuration", &_tmp0_, NULL);
	_tmp1_ = (mapping_inputs != NULL) ? _vala_array_dup9 (mapping_inputs, mapping_inputs_length1) : mapping_inputs;
	_tmp1__length1 = mapping_inputs_length1;
	self->priv->mapping_inputs = (g_free (self->priv->mapping_inputs), NULL);
	self->priv->mapping_inputs = _tmp1_;
	self->priv->mapping_inputs_length1 = _tmp1__length1;
	self->priv->_mapping_inputs_size_ = self->priv->mapping_inputs_length1;
	return self;
}

GamesGamepadMapper*
games_gamepad_mapper_new (ManetteDevice* device,
                          GamesGamepadViewConfiguration* configuration,
                          GamesGamepadInput* mapping_inputs,
                          gint mapping_inputs_length1)
{
	return games_gamepad_mapper_construct (GAMES_TYPE_GAMEPAD_MAPPER, device, configuration, mapping_inputs, mapping_inputs_length1);
}

void
games_gamepad_mapper_start (GamesGamepadMapper* self)
{
	GamesGamepadMappingBuilder* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_gamepad_mapping_builder_new ();
	_g_object_unref0 (self->priv->mapping_builder);
	self->priv->mapping_builder = _tmp0_;
	self->priv->current_input_index = (guint) 0;
	games_gamepad_mapper_connect_to_gamepad (self);
	games_gamepad_mapper_next_input (self);
}

void
games_gamepad_mapper_stop (GamesGamepadMapper* self)
{
	g_return_if_fail (self != NULL);
	games_gamepad_mapper_disconnect_from_gamepad (self);
}

void
games_gamepad_mapper_skip (GamesGamepadMapper* self)
{
	g_return_if_fail (self != NULL);
	games_gamepad_mapper_next_input (self);
}

static void
_games_gamepad_mapper_on_event_manette_device_event (ManetteDevice* _sender,
                                                     ManetteEvent* event,
                                                     gpointer self)
{
	games_gamepad_mapper_on_event ((GamesGamepadMapper*) self, event);
}

static void
games_gamepad_mapper_connect_to_gamepad (GamesGamepadMapper* self)
{
	ManetteDevice* _tmp0_;
	gulong _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_device;
	_tmp1_ = g_signal_connect_object (_tmp0_, "event", (GCallback) _games_gamepad_mapper_on_event_manette_device_event, self, 0);
	self->priv->gamepad_event_handler_id = _tmp1_;
}

static void
games_gamepad_mapper_disconnect_from_gamepad (GamesGamepadMapper* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->gamepad_event_handler_id != ((gulong) 0)) {
		ManetteDevice* _tmp0_;
		_tmp0_ = self->priv->_device;
		g_signal_handler_disconnect ((GObject*) _tmp0_, self->priv->gamepad_event_handler_id);
		self->priv->gamepad_event_handler_id = (gulong) 0;
	}
}

static void
games_gamepad_mapper_on_event (GamesGamepadMapper* self,
                               ManetteEvent* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	switch (manette_event_get_event_type (event)) {
		case MANETTE_EVENT_BUTTON_RELEASE:
		{
			GamesGamepadInput _tmp0_;
			GamesGamepadMappingBuilder* _tmp1_;
			GamesGamepadInput _tmp2_;
			_tmp0_ = self->priv->input;
			if (_tmp0_.type == EV_ABS) {
				return;
			}
			_tmp1_ = self->priv->mapping_builder;
			_tmp2_ = self->priv->input;
			if (!games_gamepad_mapping_builder_set_button_mapping (_tmp1_, (guint8) manette_event_get_hardware_index (event), &_tmp2_)) {
				return;
			}
			break;
		}
		case MANETTE_EVENT_ABSOLUTE:
		{
			guint16 axis = 0U;
			gdouble value = 0.0;
			guint16 _tmp3_ = 0U;
			gdouble _tmp4_ = 0.0;
			gboolean _tmp5_;
			gdouble _tmp6_;
			gint range = 0;
			gboolean _tmp7_ = FALSE;
			gboolean _tmp8_ = FALSE;
			gboolean _tmp9_ = FALSE;
			GamesGamepadInput _tmp10_;
			GamesGamepadMappingBuilder* _tmp15_;
			GamesGamepadInput _tmp16_;
			_tmp5_ = manette_event_get_absolute (event, &_tmp3_, &_tmp4_);
			axis = _tmp3_;
			value = _tmp4_;
			if (!_tmp5_) {
				return;
			}
			_tmp6_ = value;
			if (((-0.8) < _tmp6_) && (_tmp6_ < 0.8)) {
				return;
			}
			range = 0;
			_tmp10_ = self->priv->input;
			if (_tmp10_.code == BTN_DPAD_UP) {
				_tmp9_ = TRUE;
			} else {
				GamesGamepadInput _tmp11_;
				_tmp11_ = self->priv->input;
				_tmp9_ = _tmp11_.code == BTN_DPAD_DOWN;
			}
			if (_tmp9_) {
				_tmp8_ = TRUE;
			} else {
				GamesGamepadInput _tmp12_;
				_tmp12_ = self->priv->input;
				_tmp8_ = _tmp12_.code == BTN_DPAD_LEFT;
			}
			if (_tmp8_) {
				_tmp7_ = TRUE;
			} else {
				GamesGamepadInput _tmp13_;
				_tmp13_ = self->priv->input;
				_tmp7_ = _tmp13_.code == BTN_DPAD_RIGHT;
			}
			if (_tmp7_) {
				gint _tmp14_ = 0;
				if (value > ((gdouble) 0)) {
					_tmp14_ = 1;
				} else {
					_tmp14_ = -1;
				}
				range = _tmp14_;
			}
			_tmp15_ = self->priv->mapping_builder;
			_tmp16_ = self->priv->input;
			if (!games_gamepad_mapping_builder_set_axis_mapping (_tmp15_, (guint8) manette_event_get_hardware_index (event), range, &_tmp16_)) {
				return;
			}
			break;
		}
		case MANETTE_EVENT_HAT:
		{
			guint16 axis = 0U;
			gint8 value = 0;
			guint16 _tmp17_ = 0U;
			gint8 _tmp18_ = 0;
			gboolean _tmp19_;
			GamesGamepadMappingBuilder* _tmp20_;
			GamesGamepadInput _tmp21_;
			_tmp19_ = manette_event_get_hat (event, &_tmp17_, &_tmp18_);
			axis = _tmp17_;
			value = _tmp18_;
			if (!_tmp19_) {
				return;
			}
			if (((gint) value) == 0) {
				return;
			}
			_tmp20_ = self->priv->mapping_builder;
			_tmp21_ = self->priv->input;
			if (!games_gamepad_mapping_builder_set_hat_mapping (_tmp20_, (guint8) manette_event_get_hardware_index (event), (gint32) value, &_tmp21_)) {
				return;
			}
			break;
		}
		default:
		{
			return;
		}
	}
	games_gamepad_mapper_next_input (self);
}

static gboolean
___lambda82_ (GamesGamepadMapper* self,
              GtkWidget* widget,
              GdkFrameClock* clock)
{
	guint64 time = 0ULL;
	gdouble t = 0.0;
	GamesGamepadView* _tmp0_;
	GamesGamepadInput _tmp1_;
	gboolean result;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (clock != NULL, FALSE);
	time = gdk_frame_clock_get_frame_time (clock) - self->priv->animation_start_time;
	t = time / GAMES_GAMEPAD_MAPPER_ANALOG_ANIMATION_SPEED;
	_tmp0_ = self->priv->gamepad_view;
	_tmp1_ = self->priv->input;
	games_gamepad_view_set_analog (_tmp0_, &_tmp1_, sin (t));
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
____lambda82__gtk_tick_callback (GtkWidget* widget,
                                 GdkFrameClock* frame_clock,
                                 gpointer self)
{
	gboolean result;
	result = ___lambda82_ ((GamesGamepadMapper*) self, widget, frame_clock);
	return result;
}

static void
games_gamepad_mapper_next_input (GamesGamepadMapper* self)
{
	GamesGamepadInput* _tmp0_;
	gint _tmp0__length1;
	GamesGamepadView* _tmp4_;
	GamesGamepadInput* _tmp5_;
	gint _tmp5__length1;
	guint _tmp6_;
	GamesGamepadInput _tmp7_;
	GamesGamepadInput _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->mapping_inputs;
	_tmp0__length1 = self->priv->mapping_inputs_length1;
	if (self->priv->current_input_index == ((guint) _tmp0__length1)) {
		gchar* sdl_string = NULL;
		GamesGamepadMappingBuilder* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = self->priv->mapping_builder;
		_tmp2_ = games_gamepad_mapping_builder_build_sdl_string (_tmp1_);
		sdl_string = _tmp2_;
		_tmp3_ = sdl_string;
		g_signal_emit (self, games_gamepad_mapper_signals[GAMES_GAMEPAD_MAPPER_FINISHED_SIGNAL], 0, _tmp3_);
		_g_free0 (sdl_string);
		return;
	}
	if (self->priv->tick_cb != ((guint) 0)) {
		gtk_widget_remove_tick_callback ((GtkWidget*) self, self->priv->tick_cb);
		self->priv->tick_cb = (guint) 0;
	}
	_tmp4_ = self->priv->gamepad_view;
	games_gamepad_view_reset (_tmp4_);
	_tmp5_ = self->priv->mapping_inputs;
	_tmp5__length1 = self->priv->mapping_inputs_length1;
	_tmp6_ = self->priv->current_input_index;
	self->priv->current_input_index = _tmp6_ + 1;
	_tmp7_ = _tmp5_[_tmp6_];
	self->priv->input = _tmp7_;
	_tmp8_ = self->priv->input;
	switch (_tmp8_.type) {
		case EV_KEY:
		{
			GamesGamepadView* _tmp9_;
			GamesGamepadInput _tmp10_;
			_tmp9_ = self->priv->gamepad_view;
			_tmp10_ = self->priv->input;
			games_gamepad_view_highlight (_tmp9_, &_tmp10_, TRUE);
			break;
		}
		case EV_ABS:
		{
			GdkFrameClock* _tmp11_;
			_tmp11_ = gtk_widget_get_frame_clock ((GtkWidget*) self);
			self->priv->animation_start_time = (guint64) gdk_frame_clock_get_frame_time (_tmp11_);
			self->priv->tick_cb = gtk_widget_add_tick_callback ((GtkWidget*) self, ____lambda82__gtk_tick_callback, g_object_ref (self), g_object_unref);
			break;
		}
		default:
		{
			break;
		}
	}
	games_gamepad_mapper_update_info_message (self);
}

static void
games_gamepad_mapper_update_info_message (GamesGamepadMapper* self)
{
	GamesGamepadInput _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->input;
	switch (_tmp0_.type) {
		case EV_KEY:
		{
			games_gamepad_mapper_set_info_message (self, _ ("Press suitable button on your gamepad"));
			break;
		}
		case EV_ABS:
		{
			gboolean _tmp1_ = FALSE;
			GamesGamepadInput _tmp2_;
			_tmp2_ = self->priv->input;
			if (_tmp2_.code == ABS_X) {
				_tmp1_ = TRUE;
			} else {
				GamesGamepadInput _tmp3_;
				_tmp3_ = self->priv->input;
				_tmp1_ = _tmp3_.code == ABS_RX;
			}
			if (_tmp1_) {
				games_gamepad_mapper_set_info_message (self, _ ("Move suitable axis left/right on your gamepad"));
			} else {
				gboolean _tmp4_ = FALSE;
				GamesGamepadInput _tmp5_;
				_tmp5_ = self->priv->input;
				if (_tmp5_.code == ABS_Y) {
					_tmp4_ = TRUE;
				} else {
					GamesGamepadInput _tmp6_;
					_tmp6_ = self->priv->input;
					_tmp4_ = _tmp6_.code == ABS_RY;
				}
				if (_tmp4_) {
					games_gamepad_mapper_set_info_message (self, _ ("Move suitable axis up/down on your gamepad"));
				}
			}
			break;
		}
		default:
		{
			break;
		}
	}
}

const gchar*
games_gamepad_mapper_get_info_message (GamesGamepadMapper* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_info_message;
	result = _tmp0_;
	return result;
}

static void
games_gamepad_mapper_set_info_message (GamesGamepadMapper* self,
                                       const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_gamepad_mapper_get_info_message (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_info_message);
		self->priv->_info_message = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_gamepad_mapper_properties[GAMES_GAMEPAD_MAPPER_INFO_MESSAGE_PROPERTY]);
	}
}

ManetteDevice*
games_gamepad_mapper_get_device (GamesGamepadMapper* self)
{
	ManetteDevice* result;
	ManetteDevice* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_device;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
games_gamepad_mapper_set_device (GamesGamepadMapper* self,
                                 ManetteDevice* value)
{
	ManetteDevice* old_value;
	g_return_if_fail (self != NULL);
	old_value = games_gamepad_mapper_get_device (self);
	if (old_value != value) {
		ManetteDevice* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_device);
		self->priv->_device = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, games_gamepad_mapper_properties[GAMES_GAMEPAD_MAPPER_DEVICE_PROPERTY]);
	}
}

void
games_gamepad_mapper_get_configuration (GamesGamepadMapper* self,
                                        GamesGamepadViewConfiguration * result)
{
	GamesGamepadViewConfiguration _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_configuration;
	*result = _tmp0_;
	return;
}

static void
games_gamepad_mapper_set_configuration (GamesGamepadMapper* self,
                                        GamesGamepadViewConfiguration * value)
{
	GamesGamepadViewConfiguration _tmp0_;
	GamesGamepadViewConfiguration _tmp1_;
	GamesGamepadViewConfiguration _tmp2_ = {0};
	GamesGamepadView* _tmp3_;
	GamesGamepadViewConfiguration _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	_tmp1_ = _tmp0_;
	games_gamepad_view_configuration_copy (&_tmp1_, &_tmp2_);
	games_gamepad_view_configuration_destroy (&self->priv->_configuration);
	self->priv->_configuration = _tmp2_;
	_tmp3_ = self->priv->gamepad_view;
	_tmp4_ = *value;
	games_gamepad_view_set_configuration (_tmp3_, &_tmp4_);
	g_object_notify_by_pspec ((GObject *) self, games_gamepad_mapper_properties[GAMES_GAMEPAD_MAPPER_CONFIGURATION_PROPERTY]);
}

static void
games_gamepad_mapper_class_init (GamesGamepadMapperClass * klass,
                                 gpointer klass_data)
{
	games_gamepad_mapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesGamepadMapper_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_gamepad_mapper_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_gamepad_mapper_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_gamepad_mapper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAMEPAD_MAPPER_INFO_MESSAGE_PROPERTY, games_gamepad_mapper_properties[GAMES_GAMEPAD_MAPPER_INFO_MESSAGE_PROPERTY] = g_param_spec_string ("info-message", "info-message", "info-message", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAMEPAD_MAPPER_DEVICE_PROPERTY, games_gamepad_mapper_properties[GAMES_GAMEPAD_MAPPER_DEVICE_PROPERTY] = g_param_spec_object ("device", "device", "device", manette_device_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAMEPAD_MAPPER_CONFIGURATION_PROPERTY, games_gamepad_mapper_properties[GAMES_GAMEPAD_MAPPER_CONFIGURATION_PROPERTY] = g_param_spec_boxed ("configuration", "configuration", "configuration", GAMES_TYPE_GAMEPAD_VIEW_CONFIGURATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Games/gamepad/gamepad-mapper.ui");
	games_gamepad_mapper_signals[GAMES_GAMEPAD_MAPPER_FINISHED_SIGNAL] = g_signal_new ("finished", GAMES_TYPE_GAMEPAD_MAPPER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "gamepad_view", FALSE, GamesGamepadMapper_private_offset + G_STRUCT_OFFSET (GamesGamepadMapperPrivate, gamepad_view));
}

static void
games_gamepad_mapper_instance_init (GamesGamepadMapper * self,
                                    gpointer klass)
{
	self->priv = games_gamepad_mapper_get_instance_private (self);
	g_type_ensure (GAMES_TYPE_GAMEPAD_VIEW);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
games_gamepad_mapper_finalize (GObject * obj)
{
	GamesGamepadMapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAMEPAD_MAPPER, GamesGamepadMapper);
	_g_object_unref0 (self->priv->mapping_builder);
	self->priv->mapping_inputs = (g_free (self->priv->mapping_inputs), NULL);
	_g_free0 (self->priv->_info_message);
	_g_object_unref0 (self->priv->_device);
	games_gamepad_view_configuration_destroy (&self->priv->_configuration);
	G_OBJECT_CLASS (games_gamepad_mapper_parent_class)->finalize (obj);
}

static GType
games_gamepad_mapper_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGamepadMapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_gamepad_mapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGamepadMapper), 0, (GInstanceInitFunc) games_gamepad_mapper_instance_init, NULL };
	GType games_gamepad_mapper_type_id;
	games_gamepad_mapper_type_id = g_type_register_static (gtk_bin_get_type (), "GamesGamepadMapper", &g_define_type_info, 0);
	GamesGamepadMapper_private_offset = g_type_add_instance_private (games_gamepad_mapper_type_id, sizeof (GamesGamepadMapperPrivate));
	return games_gamepad_mapper_type_id;
}

GType
games_gamepad_mapper_get_type (void)
{
	static volatile gsize games_gamepad_mapper_type_id__once = 0;
	if (g_once_init_enter (&games_gamepad_mapper_type_id__once)) {
		GType games_gamepad_mapper_type_id;
		games_gamepad_mapper_type_id = games_gamepad_mapper_get_type_once ();
		g_once_init_leave (&games_gamepad_mapper_type_id__once, games_gamepad_mapper_type_id);
	}
	return games_gamepad_mapper_type_id__once;
}

static void
_vala_games_gamepad_mapper_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	GamesGamepadMapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAMEPAD_MAPPER, GamesGamepadMapper);
	switch (property_id) {
		case GAMES_GAMEPAD_MAPPER_INFO_MESSAGE_PROPERTY:
		g_value_set_string (value, games_gamepad_mapper_get_info_message (self));
		break;
		case GAMES_GAMEPAD_MAPPER_DEVICE_PROPERTY:
		g_value_set_object (value, games_gamepad_mapper_get_device (self));
		break;
		case GAMES_GAMEPAD_MAPPER_CONFIGURATION_PROPERTY:
		{
			GamesGamepadViewConfiguration boxed;
			games_gamepad_mapper_get_configuration (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_gamepad_mapper_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	GamesGamepadMapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAMEPAD_MAPPER, GamesGamepadMapper);
	switch (property_id) {
		case GAMES_GAMEPAD_MAPPER_INFO_MESSAGE_PROPERTY:
		games_gamepad_mapper_set_info_message (self, g_value_get_string (value));
		break;
		case GAMES_GAMEPAD_MAPPER_DEVICE_PROPERTY:
		games_gamepad_mapper_set_device (self, g_value_get_object (value));
		break;
		case GAMES_GAMEPAD_MAPPER_CONFIGURATION_PROPERTY:
		games_gamepad_mapper_set_configuration (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

