/* game-collection.c generated by valac 0.56.8, the Vala compiler
 * generated from game-collection.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "gnome-games.h"
#include <gio/gio.h>

#define GAMES_TYPE_GAME_COLLECTION (games_game_collection_get_type ())
#define GAMES_GAME_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_COLLECTION, GamesGameCollection))
#define GAMES_GAME_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_COLLECTION, GamesGameCollectionClass))
#define GAMES_IS_GAME_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_COLLECTION))
#define GAMES_IS_GAME_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_COLLECTION))
#define GAMES_GAME_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_COLLECTION, GamesGameCollectionClass))

typedef struct _GamesGameCollection GamesGameCollection;
typedef struct _GamesGameCollectionClass GamesGameCollectionClass;
typedef struct _GamesGameCollectionPrivate GamesGameCollectionPrivate;

#define GAMES_TYPE_DATABASE (games_database_get_type ())
#define GAMES_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DATABASE, GamesDatabase))
#define GAMES_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DATABASE, GamesDatabaseClass))
#define GAMES_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DATABASE))
#define GAMES_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DATABASE))
#define GAMES_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DATABASE, GamesDatabaseClass))

typedef struct _GamesDatabase GamesDatabase;
typedef struct _GamesDatabaseClass GamesDatabaseClass;
enum  {
	GAMES_GAME_COLLECTION_0_PROPERTY,
	GAMES_GAME_COLLECTION_PAUSED_PROPERTY,
	GAMES_GAME_COLLECTION_NUM_PROPERTIES
};
static GParamSpec* games_game_collection_properties[GAMES_GAME_COLLECTION_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_DATABASE_URI_SOURCE (games_database_uri_source_get_type ())
#define GAMES_DATABASE_URI_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DATABASE_URI_SOURCE, GamesDatabaseUriSource))
#define GAMES_DATABASE_URI_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DATABASE_URI_SOURCE, GamesDatabaseUriSourceClass))
#define GAMES_IS_DATABASE_URI_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DATABASE_URI_SOURCE))
#define GAMES_IS_DATABASE_URI_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DATABASE_URI_SOURCE))
#define GAMES_DATABASE_URI_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DATABASE_URI_SOURCE, GamesDatabaseUriSourceClass))

typedef struct _GamesDatabaseUriSource GamesDatabaseUriSource;
typedef struct _GamesDatabaseUriSourceClass GamesDatabaseUriSourceClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block10Data Block10Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _games_uri_unref0(var) ((var == NULL) ? NULL : (var = (games_uri_unref (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _GamesGameCollectionSearchGamesData GamesGameCollectionSearchGamesData;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
typedef struct _GamesGameCollectionQueryGameForUidData GamesGameCollectionQueryGameForUidData;
enum  {
	GAMES_GAME_COLLECTION_GAME_ADDED_SIGNAL,
	GAMES_GAME_COLLECTION_GAME_REPLACED_SIGNAL,
	GAMES_GAME_COLLECTION_GAME_REMOVED_SIGNAL,
	GAMES_GAME_COLLECTION_LOADING_DONE_SIGNAL,
	GAMES_GAME_COLLECTION_NUM_SIGNALS
};
static guint games_game_collection_signals[GAMES_GAME_COLLECTION_NUM_SIGNALS] = {0};

struct _GamesGameCollection {
	GObject parent_instance;
	GamesGameCollectionPrivate * priv;
};

struct _GamesGameCollectionClass {
	GObjectClass parent_class;
};

struct _GamesGameCollectionPrivate {
	GHashTable* games;
	GHashTable* cached_games;
	GamesUriSource** sources;
	gint sources_length1;
	gint _sources_size_;
	GamesUriGameFactory** factories;
	gint factories_length1;
	gint _factories_size_;
	GamesRunnerFactory** runner_factories;
	gint runner_factories_length1;
	gint _runner_factories_size_;
	GamesDatabase* database;
	GHashTable* factories_for_mime_type;
	GHashTable* factories_for_scheme;
	GHashTable* runner_factories_for_platforms;
	GSourceFunc search_games_cb;
	gpointer search_games_cb_target;
	GDestroyNotify search_games_cb_target_destroy_notify;
	gboolean is_preloading_done;
	gboolean is_loading_done;
	gboolean _paused;
};

struct _Block10Data {
	int _ref_count_;
	GamesGameCollection* self;
	GamesGame* game;
};

struct _Block11Data {
	int _ref_count_;
	GamesGameCollection* self;
	GamesGame* game;
};

struct _GamesGameCollectionSearchGamesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesGameCollection* self;
	GSourceFunc _tmp0_;
	gpointer _tmp0__target;
	GThreadFunc run;
	gpointer run_target;
	GThreadFunc _tmp1_;
	gpointer _tmp1__target;
	GThread* _tmp2_;
	GThread* _tmp3_;
};

struct _Block12Data {
	int _ref_count_;
	GamesGameCollection* self;
	GamesGame* prev_game;
	GamesGame* game;
};

struct _Block13Data {
	int _ref_count_;
	Block12Data * _data12_;
	GamesGame* cached_game;
};

struct _Block14Data {
	int _ref_count_;
	GamesGameCollection* self;
	GamesGame* _result_;
	gulong game_added_id;
	gulong loading_done_id;
	gchar* uid;
	gpointer _async_data_;
};

struct _GamesGameCollectionQueryGameForUidData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GamesGameCollection* self;
	gchar* uid;
	GamesGame* result;
	Block14Data* _data14_;
	GHashTable* _tmp0_;
	GHashTable* _tmp1_;
	gconstpointer _tmp2_;
	GamesGame* _tmp3_;
	gulong _tmp4_;
	gulong _tmp5_;
	GamesGame* _tmp6_;
	GamesGame* _tmp7_;
};

static gint GamesGameCollection_private_offset;
static gpointer games_game_collection_parent_class = NULL;

VALA_EXTERN GType games_game_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_database_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesGameCollection* games_game_collection_new (GamesDatabase* database);
VALA_EXTERN GamesGameCollection* games_game_collection_construct (GType object_type,
                                                      GamesDatabase* database);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void _g_array_unref0_ (gpointer var);
static guint _games_platform_hash_ghash_func (gconstpointer key);
static gboolean _games_platform_equal_gequal_func (gconstpointer a,
                                            gconstpointer b);
VALA_EXTERN void games_game_collection_add_source (GamesGameCollection* self,
                                       GamesUriSource* source);
VALA_EXTERN GType games_database_uri_source_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesDatabaseUriSource* games_database_get_uri_source (GamesDatabase* self);
static void _vala_array_add2 (GamesUriSource** * array,
                       gint* length,
                       gint* size,
                       GamesUriSource* value);
VALA_EXTERN void games_game_collection_add_factory (GamesGameCollection* self,
                                        GamesUriGameFactory* factory);
static void _vala_array_add3 (GamesUriGameFactory** * array,
                       gint* length,
                       gint* size,
                       GamesUriGameFactory* value);
static void _vala_GamesUriGameFactory_free_function_content_of (gpointer data);
static void games_game_collection_store_game (GamesGameCollection* self,
                                       GamesGame* game);
static void _games_game_collection_store_game_games_game_callback (GamesGame* game,
                                                            gpointer self);
VALA_EXTERN void games_game_collection_add_runner_factory (GamesGameCollection* self,
                                               GamesRunnerFactory* factory);
static void _vala_array_add4 (GamesRunnerFactory** * array,
                       gint* length,
                       gint* size,
                       GamesRunnerFactory* value);
static void _vala_GamesRunnerFactory_free_function_content_of (gpointer data);
VALA_EXTERN gchar** games_game_collection_get_accepted_mime_types (GamesGameCollection* self,
                                                       gint* result_length1);
static gchar** _vala_array_dup2 (gchar** self,
                          gssize length);
VALA_EXTERN void games_game_collection_add_uri (GamesGameCollection* self,
                                    GamesUri* uri);
static GamesUriGameFactory** games_game_collection_get_factories_for_uri (GamesGameCollection* self,
                                                                   GamesUri* uri,
                                                                   gint* result_length1);
VALA_EXTERN GamesGame* games_game_collection_query_game_for_uri (GamesGameCollection* self,
                                                     GamesUri* uri);
static void _vala_array_add5 (GamesGame** * array,
                       gint* length,
                       gint* size,
                       GamesGame* value);
static void games_game_collection_search_games_data_free (gpointer _data);
VALA_EXTERN void games_game_collection_search_games (GamesGameCollection* self,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN void games_game_collection_search_games_finish (GamesGameCollection* self,
                                                GAsyncResult* _res_);
static gboolean games_game_collection_search_games_co (GamesGameCollectionSearchGamesData* _data_);
static gboolean _games_game_collection_search_games_co_gsource_func (gpointer self);
static void* __lambda8_ (GamesGameCollection* self);
VALA_EXTERN void games_database_list_cached_games (GamesDatabase* self,
                                       GamesGameCallback game_callback,
                                       gpointer game_callback_target,
                                       GError** error);
static void ____lambda9_ (GamesGameCollection* self,
                   GamesGame* game);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gboolean __lambda10_ (Block10Data* _data10_);
static gboolean ___lambda10__gsource_func (gpointer self);
static void _____lambda9__games_game_callback (GamesGame* game,
                                        gpointer self);
VALA_EXTERN gboolean games_game_collection_get_paused (GamesGameCollection* self);
static gboolean __lambda11_ (GamesGameCollection* self,
                      const gchar* uri,
                      GamesGame* game);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
VALA_EXTERN gboolean games_database_remove_game (GamesDatabase* self,
                                     const gchar* uri,
                                     GamesGame* game,
                                     GError** error);
static gboolean ___lambda12_ (Block11Data* _data11_);
static gboolean ____lambda12__gsource_func (gpointer self);
static gboolean ___lambda11__ghr_func (gconstpointer key,
                                gconstpointer value,
                                gpointer self);
static gpointer ___lambda8__gthread_func (gpointer self);
VALA_EXTERN GamesRunner* games_game_collection_create_runner (GamesGameCollection* self,
                                                  GamesGame* game);
static GamesUriGameFactory** games_game_collection_get_factories_for_file (GamesGameCollection* self,
                                                                    GFile* file,
                                                                    gint* result_length1,
                                                                    GError** error);
static void _vala_array_add6 (GamesUriGameFactory** * array,
                       gint* length,
                       gint* size,
                       GamesUriGameFactory* value);
static void _vala_array_add7 (GamesUriGameFactory** * array,
                       gint* length,
                       gint* size,
                       GamesUriGameFactory* value);
static GamesUriGameFactory** _vala_array_dup3 (GamesUriGameFactory** self,
                                        gssize length);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
VALA_EXTERN void games_database_update_game (GamesDatabase* self,
                                 GamesGame* game,
                                 GamesGame* prev_game,
                                 GError** error);
static gboolean ___lambda6_ (Block13Data* _data13_);
static gboolean ____lambda6__gsource_func (gpointer self);
VALA_EXTERN GamesGame* games_database_store_game (GamesDatabase* self,
                                      GamesGame* game,
                                      GError** error);
static gboolean __lambda7_ (Block12Data* _data12_);
static gboolean ___lambda7__gsource_func (gpointer self);
static void games_game_collection_query_game_for_uid_data_free (gpointer _data);
VALA_EXTERN void games_game_collection_query_game_for_uid (GamesGameCollection* self,
                                               const gchar* uid,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN GamesGame* games_game_collection_query_game_for_uid_finish (GamesGameCollection* self,
                                                            GAsyncResult* _res_);
static gboolean games_game_collection_query_game_for_uid_co (GamesGameCollectionQueryGameForUidData* _data_);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static void __lambda13_ (Block14Data* _data14_,
                  GamesGame* game);
static void ___lambda13__games_game_collection_game_added (GamesGameCollection* _sender,
                                                    GamesGame* game,
                                                    gpointer self);
static void __lambda14_ (Block14Data* _data14_);
static void ___lambda14__games_game_collection_loading_done (GamesGameCollection* _sender,
                                                      gpointer self);
VALA_EXTERN void games_game_collection_set_paused (GamesGameCollection* self,
                                       gboolean value);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void games_game_collection_finalize (GObject * obj);
static GType games_game_collection_get_type_once (void);
static void _vala_games_game_collection_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_games_game_collection_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
games_game_collection_get_instance_private (GamesGameCollection* self)
{
	return G_STRUCT_MEMBER_P (self, GamesGameCollection_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_g_array_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_array_unref (var), NULL));
}

static guint
_games_platform_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = games_platform_hash ((GamesPlatform*) key);
	return result;
}

static gboolean
_games_platform_equal_gequal_func (gconstpointer a,
                                   gconstpointer b)
{
	gboolean result;
	result = games_platform_equal ((GamesPlatform*) a, (GamesPlatform*) b);
	return result;
}

GamesGameCollection*
games_game_collection_construct (GType object_type,
                                 GamesDatabase* database)
{
	GamesGameCollection * self = NULL;
	GamesDatabase* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	GHashTable* _tmp13_;
	GamesDatabaseUriSource* _tmp14_;
	GamesDatabaseUriSource* _tmp15_;
	g_return_val_if_fail (database != NULL, NULL);
	self = (GamesGameCollection*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (database);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->games);
	self->priv->games = _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->cached_games);
	self->priv->cached_games = _tmp6_;
	_tmp7_ = g_str_hash;
	_tmp8_ = g_str_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, _g_free0_, _g_array_unref0_);
	_g_hash_table_unref0 (self->priv->factories_for_mime_type);
	self->priv->factories_for_mime_type = _tmp9_;
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, _g_free0_, _g_array_unref0_);
	_g_hash_table_unref0 (self->priv->factories_for_scheme);
	self->priv->factories_for_scheme = _tmp12_;
	_tmp13_ = g_hash_table_new_full (_games_platform_hash_ghash_func, _games_platform_equal_gequal_func, _g_object_unref0_, _g_array_unref0_);
	_g_hash_table_unref0 (self->priv->runner_factories_for_platforms);
	self->priv->runner_factories_for_platforms = _tmp13_;
	_tmp14_ = games_database_get_uri_source (database);
	_tmp15_ = _tmp14_;
	games_game_collection_add_source (self, (GamesUriSource*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	return self;
}

GamesGameCollection*
games_game_collection_new (GamesDatabase* database)
{
	return games_game_collection_construct (GAMES_TYPE_GAME_COLLECTION, database);
}

static void
_vala_array_add2 (GamesUriSource** * array,
                  gint* length,
                  gint* size,
                  GamesUriSource* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesUriSource*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
games_game_collection_add_source (GamesGameCollection* self,
                                  GamesUriSource* source)
{
	GamesUriSource* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = _g_object_ref0 (source);
	_vala_array_add2 (&self->priv->sources, &self->priv->sources_length1, &self->priv->_sources_size_, _tmp0_);
}

static void
_vala_array_add3 (GamesUriGameFactory** * array,
                  gint* length,
                  gint* size,
                  GamesUriGameFactory* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesUriGameFactory*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_GamesUriGameFactory_free_function_content_of (gpointer data)
{
	GamesUriGameFactory* self;
	self = *((GamesUriGameFactory**) data);
	_g_object_unref0_ (self);
}

static void
_games_game_collection_store_game_games_game_callback (GamesGame* game,
                                                       gpointer self)
{
	games_game_collection_store_game ((GamesGameCollection*) self, game);
}

void
games_game_collection_add_factory (GamesGameCollection* self,
                                   GamesUriGameFactory* factory)
{
	GamesUriGameFactory* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	gint _tmp14_ = 0;
	gchar** _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (factory != NULL);
	_tmp0_ = _g_object_ref0 (factory);
	_vala_array_add3 (&self->priv->factories, &self->priv->factories_length1, &self->priv->_factories_size_, _tmp0_);
	_tmp2_ = games_uri_game_factory_get_mime_types (factory, &_tmp1_);
	{
		gchar** mime_type_collection = NULL;
		gint mime_type_collection_length1 = 0;
		gint _mime_type_collection_size_ = 0;
		gint mime_type_it = 0;
		mime_type_collection = _tmp2_;
		mime_type_collection_length1 = _tmp1_;
		for (mime_type_it = 0; mime_type_it < mime_type_collection_length1; mime_type_it = mime_type_it + 1) {
			gchar* _tmp3_;
			gchar* mime_type = NULL;
			_tmp3_ = g_strdup (mime_type_collection[mime_type_it]);
			mime_type = _tmp3_;
			{
				GHashTable* _tmp4_;
				const gchar* _tmp5_;
				GHashTable* _tmp10_;
				const gchar* _tmp11_;
				gconstpointer _tmp12_;
				GamesUriGameFactory* _tmp13_;
				_tmp4_ = self->priv->factories_for_mime_type;
				_tmp5_ = mime_type;
				if (!g_hash_table_contains (_tmp4_, _tmp5_)) {
					GHashTable* _tmp6_;
					const gchar* _tmp7_;
					gchar* _tmp8_;
					GArray* _tmp9_;
					_tmp6_ = self->priv->factories_for_mime_type;
					_tmp7_ = mime_type;
					_tmp8_ = g_strdup (_tmp7_);
					_tmp9_ = g_array_new (TRUE, TRUE, sizeof (GamesUriGameFactory*));
					g_array_set_clear_func (_tmp9_, (GDestroyNotify) _vala_GamesUriGameFactory_free_function_content_of);
					g_hash_table_insert (_tmp6_, _tmp8_, _tmp9_);
				}
				_tmp10_ = self->priv->factories_for_mime_type;
				_tmp11_ = mime_type;
				_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
				_tmp13_ = _g_object_ref0 (factory);
				g_array_append_val ((GArray*) _tmp12_, _tmp13_);
				_g_free0 (mime_type);
			}
		}
		mime_type_collection = (_vala_array_free (mime_type_collection, mime_type_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp15_ = games_uri_game_factory_get_schemes (factory, &_tmp14_);
	{
		gchar** scheme_collection = NULL;
		gint scheme_collection_length1 = 0;
		gint _scheme_collection_size_ = 0;
		gint scheme_it = 0;
		scheme_collection = _tmp15_;
		scheme_collection_length1 = _tmp14_;
		for (scheme_it = 0; scheme_it < scheme_collection_length1; scheme_it = scheme_it + 1) {
			gchar* _tmp16_;
			gchar* scheme = NULL;
			_tmp16_ = g_strdup (scheme_collection[scheme_it]);
			scheme = _tmp16_;
			{
				GHashTable* _tmp17_;
				const gchar* _tmp18_;
				GHashTable* _tmp23_;
				const gchar* _tmp24_;
				gconstpointer _tmp25_;
				GamesUriGameFactory* _tmp26_;
				_tmp17_ = self->priv->factories_for_scheme;
				_tmp18_ = scheme;
				if (!g_hash_table_contains (_tmp17_, _tmp18_)) {
					GHashTable* _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					GArray* _tmp22_;
					_tmp19_ = self->priv->factories_for_scheme;
					_tmp20_ = scheme;
					_tmp21_ = g_strdup (_tmp20_);
					_tmp22_ = g_array_new (TRUE, TRUE, sizeof (GamesUriGameFactory*));
					g_array_set_clear_func (_tmp22_, (GDestroyNotify) _vala_GamesUriGameFactory_free_function_content_of);
					g_hash_table_insert (_tmp19_, _tmp21_, _tmp22_);
				}
				_tmp23_ = self->priv->factories_for_scheme;
				_tmp24_ = scheme;
				_tmp25_ = g_hash_table_lookup (_tmp23_, _tmp24_);
				_tmp26_ = _g_object_ref0 (factory);
				g_array_append_val ((GArray*) _tmp25_, _tmp26_);
				_g_free0 (scheme);
			}
		}
		scheme_collection = (_vala_array_free (scheme_collection, scheme_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	games_uri_game_factory_set_game_added_callback (factory, _games_game_collection_store_game_games_game_callback, self);
}

static void
_vala_array_add4 (GamesRunnerFactory** * array,
                  gint* length,
                  gint* size,
                  GamesRunnerFactory* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesRunnerFactory*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_GamesRunnerFactory_free_function_content_of (gpointer data)
{
	GamesRunnerFactory* self;
	self = *((GamesRunnerFactory**) data);
	_g_object_unref0_ (self);
}

void
games_game_collection_add_runner_factory (GamesGameCollection* self,
                                          GamesRunnerFactory* factory)
{
	GamesRunnerFactory* _tmp0_;
	gint _tmp1_ = 0;
	GamesPlatform** _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (factory != NULL);
	_tmp0_ = _g_object_ref0 (factory);
	_vala_array_add4 (&self->priv->runner_factories, &self->priv->runner_factories_length1, &self->priv->_runner_factories_size_, _tmp0_);
	_tmp2_ = games_runner_factory_get_platforms (factory, &_tmp1_);
	{
		GamesPlatform** platform_collection = NULL;
		gint platform_collection_length1 = 0;
		gint _platform_collection_size_ = 0;
		gint platform_it = 0;
		platform_collection = _tmp2_;
		platform_collection_length1 = _tmp1_;
		for (platform_it = 0; platform_it < platform_collection_length1; platform_it = platform_it + 1) {
			GamesPlatform* _tmp3_;
			GamesPlatform* platform = NULL;
			_tmp3_ = _g_object_ref0 (platform_collection[platform_it]);
			platform = _tmp3_;
			{
				GHashTable* _tmp4_;
				GamesPlatform* _tmp5_;
				GHashTable* _tmp10_;
				GamesPlatform* _tmp11_;
				gconstpointer _tmp12_;
				GamesRunnerFactory* _tmp13_;
				_tmp4_ = self->priv->runner_factories_for_platforms;
				_tmp5_ = platform;
				if (!g_hash_table_contains (_tmp4_, _tmp5_)) {
					GHashTable* _tmp6_;
					GamesPlatform* _tmp7_;
					GamesPlatform* _tmp8_;
					GArray* _tmp9_;
					_tmp6_ = self->priv->runner_factories_for_platforms;
					_tmp7_ = platform;
					_tmp8_ = _g_object_ref0 (_tmp7_);
					_tmp9_ = g_array_new (TRUE, TRUE, sizeof (GamesRunnerFactory*));
					g_array_set_clear_func (_tmp9_, (GDestroyNotify) _vala_GamesRunnerFactory_free_function_content_of);
					g_hash_table_insert (_tmp6_, _tmp8_, _tmp9_);
				}
				_tmp10_ = self->priv->runner_factories_for_platforms;
				_tmp11_ = platform;
				_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
				_tmp13_ = _g_object_ref0 (factory);
				g_array_append_val ((GArray*) _tmp12_, _tmp13_);
				_g_object_unref0 (platform);
			}
		}
		platform_collection = (_vala_array_free (platform_collection, platform_collection_length1, (GDestroyNotify) g_object_unref), NULL);
	}
}

static gchar**
_vala_array_dup2 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar**
games_game_collection_get_accepted_mime_types (GamesGameCollection* self,
                                               gint* result_length1)
{
	GHashTable* _tmp0_;
	guint _tmp1_ = 0;
	gconstpointer* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->factories_for_mime_type;
	_tmp2_ = g_hash_table_get_keys_as_array (_tmp0_, &_tmp1_);
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup2 (_tmp2_, _tmp1_) : _tmp2_;
	_tmp3__length1 = _tmp1_;
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

void
games_game_collection_add_uri (GamesGameCollection* self,
                               GamesUri* uri)
{
	gint _tmp0_ = 0;
	GamesUriGameFactory** _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp1_ = games_game_collection_get_factories_for_uri (self, uri, &_tmp0_);
	{
		GamesUriGameFactory** factory_collection = NULL;
		gint factory_collection_length1 = 0;
		gint _factory_collection_size_ = 0;
		gint factory_it = 0;
		factory_collection = _tmp1_;
		factory_collection_length1 = _tmp0_;
		for (factory_it = 0; factory_it < factory_collection_length1; factory_it = factory_it + 1) {
			GamesUriGameFactory* _tmp2_;
			GamesUriGameFactory* factory = NULL;
			_tmp2_ = _g_object_ref0 (factory_collection[factory_it]);
			factory = _tmp2_;
			{
				GamesUriGameFactory* _tmp3_;
				_tmp3_ = factory;
				games_uri_game_factory_add_uri (_tmp3_, uri);
				_g_object_unref0 (factory);
			}
		}
		factory_collection = (_vala_array_free (factory_collection, factory_collection_length1, (GDestroyNotify) g_object_unref), NULL);
	}
}

static void
_vala_array_add5 (GamesGame** * array,
                  gint* length,
                  gint* size,
                  GamesGame* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesGame*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GamesGame*
games_game_collection_query_game_for_uri (GamesGameCollection* self,
                                          GamesUri* uri)
{
	GamesGame** games = NULL;
	GamesGame** _tmp0_;
	gint games_length1;
	gint _games_size_;
	gint _tmp1_ = 0;
	GamesUriGameFactory** _tmp2_;
	GamesGame** _tmp9_;
	gint _tmp9__length1;
	GamesGame** _tmp10_;
	gint _tmp10__length1;
	GamesGame* _tmp11_;
	GamesGame* _tmp12_;
	GamesGame* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_new0 (GamesGame*, 0 + 1);
	games = _tmp0_;
	games_length1 = 0;
	_games_size_ = games_length1;
	_tmp2_ = games_game_collection_get_factories_for_uri (self, uri, &_tmp1_);
	{
		GamesUriGameFactory** factory_collection = NULL;
		gint factory_collection_length1 = 0;
		gint _factory_collection_size_ = 0;
		gint factory_it = 0;
		factory_collection = _tmp2_;
		factory_collection_length1 = _tmp1_;
		for (factory_it = 0; factory_it < factory_collection_length1; factory_it = factory_it + 1) {
			GamesUriGameFactory* _tmp3_;
			GamesUriGameFactory* factory = NULL;
			_tmp3_ = _g_object_ref0 (factory_collection[factory_it]);
			factory = _tmp3_;
			{
				GamesGame* game = NULL;
				GamesUriGameFactory* _tmp4_;
				GamesGame* _tmp5_;
				GamesGame* _tmp6_;
				_tmp4_ = factory;
				_tmp5_ = games_uri_game_factory_query_game_for_uri (_tmp4_, uri);
				game = _tmp5_;
				_tmp6_ = game;
				if (_tmp6_ != NULL) {
					GamesGame* _tmp7_;
					GamesGame* _tmp8_;
					_tmp7_ = game;
					_tmp8_ = _g_object_ref0 (_tmp7_);
					_vala_array_add5 (&games, &games_length1, &_games_size_, _tmp8_);
				}
				_g_object_unref0 (game);
				_g_object_unref0 (factory);
			}
		}
		factory_collection = (_vala_array_free (factory_collection, factory_collection_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	_tmp9_ = games;
	_tmp9__length1 = games_length1;
	if (_tmp9__length1 != 1) {
		result = NULL;
		games = (_vala_array_free (games, games_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	_tmp10_ = games;
	_tmp10__length1 = games_length1;
	_tmp11_ = _tmp10_[0];
	_tmp12_ = _g_object_ref0 (_tmp11_);
	result = _tmp12_;
	games = (_vala_array_free (games, games_length1, (GDestroyNotify) g_object_unref), NULL);
	return result;
}

static void
games_game_collection_search_games_data_free (gpointer _data)
{
	GamesGameCollectionSearchGamesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesGameCollectionSearchGamesData, _data_);
}

void
games_game_collection_search_games (GamesGameCollection* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	GamesGameCollectionSearchGamesData* _data_;
	GamesGameCollection* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (GamesGameCollectionSearchGamesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_game_collection_search_games_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	games_game_collection_search_games_co (_data_);
}

void
games_game_collection_search_games_finish (GamesGameCollection* self,
                                           GAsyncResult* _res_)
{
	GamesGameCollectionSearchGamesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_games_game_collection_search_games_co_gsource_func (gpointer self)
{
	gboolean result;
	result = games_game_collection_search_games_co (self);
	return result;
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		GamesGameCollection* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->game);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static gboolean
__lambda10_ (Block10Data* _data10_)
{
	GamesGameCollection* self;
	gboolean result;
	self = _data10_->self;
	g_signal_emit (self, games_game_collection_signals[GAMES_GAME_COLLECTION_GAME_ADDED_SIGNAL], 0, _data10_->game);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda10__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda10_ (self);
	return result;
}

static void
____lambda9_ (GamesGameCollection* self,
              GamesGame* game)
{
	Block10Data* _data10_;
	GamesGame* _tmp0_;
	GHashTable* _tmp1_;
	GamesUri* _tmp2_;
	GamesUri* _tmp3_;
	gchar* _tmp4_;
	GamesGame* _tmp5_;
	gchar* uid = NULL;
	GamesUid* _tmp6_;
	GamesUid* _tmp7_;
	gchar* _tmp8_;
	GHashTable* _tmp9_;
	const gchar* _tmp10_;
	GHashTable* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GamesGame* _tmp14_;
	g_return_if_fail (game != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (_data10_->game);
	_data10_->game = _tmp0_;
	_tmp1_ = self->priv->cached_games;
	_tmp2_ = games_game_get_uri (_data10_->game);
	_tmp3_ = _tmp2_;
	_tmp4_ = games_uri_to_string (_tmp3_);
	_tmp5_ = _g_object_ref0 (_data10_->game);
	g_hash_table_insert (_tmp1_, _tmp4_, _tmp5_);
	_tmp6_ = games_game_get_uid (_data10_->game);
	_tmp7_ = _tmp6_;
	_tmp8_ = games_uid_to_string (_tmp7_);
	uid = _tmp8_;
	_tmp9_ = self->priv->games;
	_tmp10_ = uid;
	if (g_hash_table_contains (_tmp9_, _tmp10_)) {
		_g_free0 (uid);
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	_tmp11_ = self->priv->games;
	_tmp12_ = uid;
	_tmp13_ = g_strdup (_tmp12_);
	_tmp14_ = _g_object_ref0 (_data10_->game);
	g_hash_table_insert (_tmp11_, _tmp13_, _tmp14_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda10__gsource_func, block10_data_ref (_data10_), block10_data_unref);
	_g_free0 (uid);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static void
_____lambda9__games_game_callback (GamesGame* game,
                                   gpointer self)
{
	____lambda9_ ((GamesGameCollection*) self, game);
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		GamesGameCollection* self;
		self = _data11_->self;
		_g_object_unref0 (_data11_->game);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static gboolean
___lambda12_ (Block11Data* _data11_)
{
	GamesGameCollection* self;
	gboolean result;
	self = _data11_->self;
	g_signal_emit (self, games_game_collection_signals[GAMES_GAME_COLLECTION_GAME_REMOVED_SIGNAL], 0, _data11_->game);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda12_ (self);
	return result;
}

static gboolean
__lambda11_ (GamesGameCollection* self,
             const gchar* uri,
             GamesGame* game)
{
	Block11Data* _data11_;
	GamesGame* _tmp0_;
	gboolean removed = FALSE;
	gchar* uid = NULL;
	GamesUid* _tmp6_;
	GamesUid* _tmp7_;
	gchar* _tmp8_;
	GHashTable* _tmp9_;
	const gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (uri != NULL, FALSE);
	g_return_val_if_fail (game != NULL, FALSE);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (_data11_->game);
	_data11_->game = _tmp0_;
	removed = FALSE;
	{
		gboolean _tmp1_ = FALSE;
		GamesDatabase* _tmp2_;
		_tmp2_ = self->priv->database;
		_tmp1_ = games_database_remove_game (_tmp2_, uri, _data11_->game, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		removed = _tmp1_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("game-collection.vala:146: Couldn't remove game: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		block11_data_unref (_data11_);
		_data11_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
	_tmp6_ = games_game_get_uid (_data11_->game);
	_tmp7_ = _tmp6_;
	_tmp8_ = games_uid_to_string (_tmp7_);
	uid = _tmp8_;
	_tmp9_ = self->priv->games;
	_tmp10_ = uid;
	g_hash_table_remove (_tmp9_, _tmp10_);
	if (removed) {
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda12__gsource_func, block11_data_ref (_data11_), block11_data_unref);
	}
	result = TRUE;
	_g_free0 (uid);
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return result;
}

static gboolean
___lambda11__ghr_func (gconstpointer key,
                       gconstpointer value,
                       gpointer self)
{
	gboolean result;
	result = __lambda11_ ((GamesGameCollection*) self, (const gchar*) key, (GamesGame*) value);
	return result;
}

static void*
__lambda8_ (GamesGameCollection* self)
{
	GamesUriSource** _tmp5_;
	gint _tmp5__length1;
	GHashTable* _tmp15_;
	GSourceFunc _tmp16_;
	gpointer _tmp16__target;
	GDestroyNotify _tmp16__target_destroy_notify;
	GError* _inner_error0_ = NULL;
	void* result;
	if (!self->priv->is_preloading_done) {
		gboolean _tmp3_;
		{
			GamesDatabase* _tmp0_;
			_tmp0_ = self->priv->database;
			games_database_list_cached_games (_tmp0_, _____lambda9__games_game_callback, self, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp1_;
			const gchar* _tmp2_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp1_ = e;
			_tmp2_ = _tmp1_->message;
			g_critical ("game-collection.vala:120: Couldn't load cached games: %s", _tmp2_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		self->priv->is_preloading_done = TRUE;
		_tmp3_ = self->priv->_paused;
		if (_tmp3_) {
			GSourceFunc _tmp4_;
			gpointer _tmp4__target;
			GDestroyNotify _tmp4__target_destroy_notify;
			_tmp4_ = self->priv->search_games_cb;
			_tmp4__target = self->priv->search_games_cb_target;
			_tmp4__target_destroy_notify = self->priv->search_games_cb_target_destroy_notify;
			self->priv->search_games_cb = NULL;
			self->priv->search_games_cb_target = NULL;
			self->priv->search_games_cb_target_destroy_notify = NULL;
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp4_, _tmp4__target, _tmp4__target_destroy_notify);
			result = NULL;
			return result;
		}
	}
	_tmp5_ = self->priv->sources;
	_tmp5__length1 = self->priv->sources_length1;
	{
		GamesUriSource** source_collection = NULL;
		gint source_collection_length1 = 0;
		gint _source_collection_size_ = 0;
		gint source_it = 0;
		source_collection = _tmp5_;
		source_collection_length1 = _tmp5__length1;
		for (source_it = 0; source_it < source_collection_length1; source_it = source_it + 1) {
			GamesUriSource* _tmp6_;
			GamesUriSource* source = NULL;
			_tmp6_ = _g_object_ref0 (source_collection[source_it]);
			source = _tmp6_;
			{
				{
					GamesUriIterator* _uri_it = NULL;
					GamesUriSource* _tmp7_;
					GamesUriIterator* _tmp8_;
					_tmp7_ = source;
					_tmp8_ = games_uri_source_iterator (_tmp7_);
					_uri_it = _tmp8_;
					while (TRUE) {
						GamesUriIterator* _tmp9_;
						GamesUri* uri = NULL;
						GamesUriIterator* _tmp10_;
						GamesUri* _tmp11_;
						gboolean _tmp12_;
						GamesUri* _tmp14_;
						_tmp9_ = _uri_it;
						if (!games_uri_iterator_next (_tmp9_)) {
							break;
						}
						_tmp10_ = _uri_it;
						_tmp11_ = games_uri_iterator_get (_tmp10_);
						uri = _tmp11_;
						_tmp12_ = self->priv->_paused;
						if (_tmp12_) {
							GSourceFunc _tmp13_;
							gpointer _tmp13__target;
							GDestroyNotify _tmp13__target_destroy_notify;
							_tmp13_ = self->priv->search_games_cb;
							_tmp13__target = self->priv->search_games_cb_target;
							_tmp13__target_destroy_notify = self->priv->search_games_cb_target_destroy_notify;
							self->priv->search_games_cb = NULL;
							self->priv->search_games_cb_target = NULL;
							self->priv->search_games_cb_target_destroy_notify = NULL;
							g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp13_, _tmp13__target, _tmp13__target_destroy_notify);
							result = NULL;
							_games_uri_unref0 (uri);
							_g_object_unref0 (_uri_it);
							_g_object_unref0 (source);
							return result;
						}
						_tmp14_ = uri;
						games_game_collection_add_uri (self, _tmp14_);
						_games_uri_unref0 (uri);
					}
					_g_object_unref0 (_uri_it);
				}
				_g_object_unref0 (source);
			}
		}
	}
	_tmp15_ = self->priv->cached_games;
	g_hash_table_foreach_steal (_tmp15_, ___lambda11__ghr_func, self);
	_tmp16_ = self->priv->search_games_cb;
	_tmp16__target = self->priv->search_games_cb_target;
	_tmp16__target_destroy_notify = self->priv->search_games_cb_target_destroy_notify;
	self->priv->search_games_cb = NULL;
	self->priv->search_games_cb_target = NULL;
	self->priv->search_games_cb_target_destroy_notify = NULL;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp16_, _tmp16__target, _tmp16__target_destroy_notify);
	result = NULL;
	return result;
}

static gpointer
___lambda8__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda8_ ((GamesGameCollection*) self);
	g_object_unref (self);
	return result;
}

static gboolean
games_game_collection_search_games_co (GamesGameCollectionSearchGamesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->search_games_cb;
	_data_->_tmp0__target = _data_->self->priv->search_games_cb_target;
	if (_data_->_tmp0_ != NULL) {
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	(_data_->self->priv->search_games_cb_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->search_games_cb_target_destroy_notify (_data_->self->priv->search_games_cb_target), NULL);
	_data_->self->priv->search_games_cb = NULL;
	_data_->self->priv->search_games_cb_target = NULL;
	_data_->self->priv->search_games_cb_target_destroy_notify = NULL;
	_data_->self->priv->search_games_cb = _games_game_collection_search_games_co_gsource_func;
	_data_->self->priv->search_games_cb_target = _data_;
	_data_->self->priv->search_games_cb_target_destroy_notify = NULL;
	_data_->run = ___lambda8__gthread_func;
	_data_->run_target = g_object_ref (_data_->self);
	_data_->_tmp1_ = _data_->run;
	_data_->_tmp1__target = _data_->run_target;
	_data_->run = NULL;
	_data_->run_target = NULL;
	_data_->_tmp2_ = g_thread_new (NULL, _data_->_tmp1_, _data_->_tmp1__target);
	_data_->_tmp3_ = _data_->_tmp2_;
	_g_thread_unref0 (_data_->_tmp3_);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->self->priv->is_loading_done = TRUE;
	g_signal_emit (_data_->self, games_game_collection_signals[GAMES_GAME_COLLECTION_LOADING_DONE_SIGNAL], 0);
	(_data_->self->priv->search_games_cb_target_destroy_notify == NULL) ? NULL : (_data_->self->priv->search_games_cb_target_destroy_notify (_data_->self->priv->search_games_cb_target), NULL);
	_data_->self->priv->search_games_cb = NULL;
	_data_->self->priv->search_games_cb_target = NULL;
	_data_->self->priv->search_games_cb_target_destroy_notify = NULL;
	_data_->self->priv->search_games_cb = NULL;
	_data_->self->priv->search_games_cb_target = NULL;
	_data_->self->priv->search_games_cb_target_destroy_notify = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

GamesRunner*
games_game_collection_create_runner (GamesGameCollection* self,
                                     GamesGame* game)
{
	GamesPlatform* platform = NULL;
	GamesPlatform* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesPlatform* _tmp2_;
	GHashTable* _tmp3_;
	GamesPlatform* _tmp4_;
	GArray* factories = NULL;
	GHashTable* _tmp5_;
	GamesPlatform* _tmp6_;
	gconstpointer _tmp7_;
	GArray* _tmp8_;
	GArray* _tmp9_;
	GArray* _tmp10_;
	gpointer* _tmp11_;
	gint _tmp11__length1;
	GError* _inner_error0_ = NULL;
	GamesRunner* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (game != NULL, NULL);
	_tmp0_ = games_game_get_platform (game);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	platform = _tmp2_;
	_tmp3_ = self->priv->runner_factories_for_platforms;
	_tmp4_ = platform;
	if (!g_hash_table_contains (_tmp3_, _tmp4_)) {
		result = NULL;
		_g_object_unref0 (platform);
		return result;
	}
	_tmp5_ = self->priv->runner_factories_for_platforms;
	_tmp6_ = platform;
	_tmp7_ = g_hash_table_lookup (_tmp5_, _tmp6_);
	_tmp8_ = _g_array_ref0 ((GArray*) _tmp7_);
	factories = _tmp8_;
	_tmp9_ = factories;
	if (_tmp9_ == NULL) {
		result = NULL;
		_g_array_unref0 (factories);
		_g_object_unref0 (platform);
		return result;
	}
	_tmp10_ = factories;
	_tmp11_ = _tmp10_->data;
	_tmp11__length1 = _tmp10_->len;
	{
		GamesRunnerFactory** factory_collection = NULL;
		gint factory_collection_length1 = 0;
		gint _factory_collection_size_ = 0;
		gint factory_it = 0;
		factory_collection = _tmp11_;
		factory_collection_length1 = _tmp11__length1;
		for (factory_it = 0; factory_it < factory_collection_length1; factory_it = factory_it + 1) {
			GamesRunnerFactory* _tmp12_;
			GamesRunnerFactory* factory = NULL;
			_tmp12_ = _g_object_ref0 (factory_collection[factory_it]);
			factory = _tmp12_;
			{
				{
					GamesRunner* runner = NULL;
					GamesRunnerFactory* _tmp13_;
					GamesRunner* _tmp14_;
					GamesRunner* _tmp15_;
					_tmp13_ = factory;
					_tmp14_ = games_runner_factory_create_runner (_tmp13_, game, &_inner_error0_);
					runner = _tmp14_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp15_ = runner;
					if (_tmp15_ != NULL) {
						result = runner;
						_g_object_unref0 (factory);
						_g_array_unref0 (factories);
						_g_object_unref0 (platform);
						return result;
					}
					_g_object_unref0 (runner);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp16_;
					const gchar* _tmp17_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp16_ = e;
					_tmp17_ = _tmp16_->message;
					g_critical ("game-collection.vala:192: Couldn't create runner: %s", _tmp17_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (factory);
					_g_array_unref0 (factories);
					_g_object_unref0 (platform);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
				_g_object_unref0 (factory);
			}
		}
	}
	result = NULL;
	_g_array_unref0 (factories);
	_g_object_unref0 (platform);
	return result;
}

static void
_vala_array_add6 (GamesUriGameFactory** * array,
                  gint* length,
                  gint* size,
                  GamesUriGameFactory* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesUriGameFactory*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (GamesUriGameFactory** * array,
                  gint* length,
                  gint* size,
                  GamesUriGameFactory* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesUriGameFactory*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GamesUriGameFactory**
games_game_collection_get_factories_for_uri (GamesGameCollection* self,
                                             GamesUri* uri,
                                             gint* result_length1)
{
	GamesUriGameFactory** factories = NULL;
	GamesUriGameFactory** _tmp0_;
	gint factories_length1;
	gint _factories_size_;
	gchar* scheme = NULL;
	const gchar* _tmp7_;
	GHashTable* _tmp18_;
	const gchar* _tmp19_;
	GamesUriGameFactory** _tmp27_;
	gint _tmp27__length1;
	GError* _inner_error0_ = NULL;
	GamesUriGameFactory** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = g_new0 (GamesUriGameFactory*, 0 + 1);
	factories = _tmp0_;
	factories_length1 = 0;
	_factories_size_ = factories_length1;
	{
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = games_uri_get_scheme (uri, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_free0 (scheme);
		scheme = _tmp3_;
		_g_free0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		GamesUriGameFactory** _tmp6_;
		gint _tmp6__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_debug ("game-collection.vala:207: %s", _tmp5_);
		_tmp6_ = factories;
		_tmp6__length1 = factories_length1;
		if (result_length1) {
			*result_length1 = _tmp6__length1;
		}
		result = _tmp6_;
		_g_error_free0 (e);
		_g_free0 (scheme);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (scheme);
		factories = (_vala_array_free (factories, factories_length1, (GDestroyNotify) g_object_unref), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp7_ = scheme;
	if (g_strcmp0 (_tmp7_, "file") == 0) {
		{
			GFile* file = NULL;
			GFile* _tmp8_;
			GamesUriGameFactory** _tmp9_ = NULL;
			GFile* _tmp10_;
			gint _tmp11_ = 0;
			GamesUriGameFactory** _tmp12_;
			gint _tmp9__length1;
			gint __tmp9__size_;
			_tmp8_ = games_uri_to_file (uri);
			file = _tmp8_;
			_tmp10_ = file;
			_tmp12_ = games_game_collection_get_factories_for_file (self, _tmp10_, &_tmp11_, &_inner_error0_);
			_tmp9_ = _tmp12_;
			_tmp9__length1 = _tmp11_;
			__tmp9__size_ = _tmp9__length1;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				goto __catch1_g_error;
			}
			{
				GamesUriGameFactory** factory_collection = NULL;
				gint factory_collection_length1 = 0;
				gint _factory_collection_size_ = 0;
				gint factory_it = 0;
				factory_collection = _tmp9_;
				factory_collection_length1 = _tmp9__length1;
				for (factory_it = 0; factory_it < factory_collection_length1; factory_it = factory_it + 1) {
					GamesUriGameFactory* _tmp13_;
					GamesUriGameFactory* factory = NULL;
					_tmp13_ = _g_object_ref0 (factory_collection[factory_it]);
					factory = _tmp13_;
					{
						GamesUriGameFactory* _tmp14_;
						GamesUriGameFactory* _tmp15_;
						_tmp14_ = factory;
						_tmp15_ = _g_object_ref0 (_tmp14_);
						_vala_array_add6 (&factories, &factories_length1, &_factories_size_, _tmp15_);
						_g_object_unref0 (factory);
					}
				}
			}
			_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_object_unref), NULL);
			_g_object_unref0 (file);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp16_;
			const gchar* _tmp17_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			g_debug ("game-collection.vala:219: %s", _tmp17_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (scheme);
			factories = (_vala_array_free (factories, factories_length1, (GDestroyNotify) g_object_unref), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp18_ = self->priv->factories_for_scheme;
	_tmp19_ = scheme;
	if (g_hash_table_contains (_tmp18_, _tmp19_)) {
		GHashTable* _tmp20_;
		const gchar* _tmp21_;
		gconstpointer _tmp22_;
		gpointer* _tmp23_;
		gint _tmp23__length1;
		_tmp20_ = self->priv->factories_for_scheme;
		_tmp21_ = scheme;
		_tmp22_ = g_hash_table_lookup (_tmp20_, _tmp21_);
		_tmp23_ = ((GArray*) _tmp22_)->data;
		_tmp23__length1 = ((GArray*) _tmp22_)->len;
		{
			GamesUriGameFactory** factory_collection = NULL;
			gint factory_collection_length1 = 0;
			gint _factory_collection_size_ = 0;
			gint factory_it = 0;
			factory_collection = _tmp23_;
			factory_collection_length1 = _tmp23__length1;
			for (factory_it = 0; factory_it < factory_collection_length1; factory_it = factory_it + 1) {
				GamesUriGameFactory* _tmp24_;
				GamesUriGameFactory* factory = NULL;
				_tmp24_ = _g_object_ref0 (factory_collection[factory_it]);
				factory = _tmp24_;
				{
					GamesUriGameFactory* _tmp25_;
					GamesUriGameFactory* _tmp26_;
					_tmp25_ = factory;
					_tmp26_ = _g_object_ref0 (_tmp25_);
					_vala_array_add7 (&factories, &factories_length1, &_factories_size_, _tmp26_);
					_g_object_unref0 (factory);
				}
			}
		}
	}
	_tmp27_ = factories;
	_tmp27__length1 = factories_length1;
	if (result_length1) {
		*result_length1 = _tmp27__length1;
	}
	result = _tmp27_;
	_g_free0 (scheme);
	return result;
}

static GamesUriGameFactory**
_vala_array_dup3 (GamesUriGameFactory** self,
                  gssize length)
{
	if (length >= 0) {
		GamesUriGameFactory** result;
		gssize i;
		result = g_new0 (GamesUriGameFactory*, length + 1);
		for (i = 0; i < length; i++) {
			GamesUriGameFactory* _tmp0_;
			_tmp0_ = _g_object_ref0 (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static GamesUriGameFactory**
games_game_collection_get_factories_for_file (GamesGameCollection* self,
                                              GFile* file,
                                              gint* result_length1,
                                              GError** error)
{
	GFileInfo* file_info = NULL;
	GFileInfo* _tmp2_;
	gchar* mime_type = NULL;
	GFileInfo* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GHashTable* _tmp6_;
	const gchar* _tmp7_;
	GHashTable* _tmp10_;
	const gchar* _tmp11_;
	gconstpointer _tmp12_;
	gpointer* _tmp13_;
	gint _tmp13__length1;
	GamesUriGameFactory** _tmp14_;
	gint _tmp14__length1;
	GamesUriGameFactory** _tmp15_;
	gint _tmp15__length1;
	GError* _inner_error0_ = NULL;
	GamesUriGameFactory** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	if (!g_file_query_exists (file, NULL)) {
		GamesUriGameFactory** _tmp0_;
		GamesUriGameFactory** _tmp1_;
		gint _tmp1__length1;
		_tmp0_ = g_new0 (GamesUriGameFactory*, 0 + 1);
		_tmp1_ = _tmp0_;
		_tmp1__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp1__length1;
		}
		result = _tmp1_;
		return result;
	}
	_tmp2_ = g_file_query_info (file, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	file_info = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = file_info;
	_tmp4_ = g_file_info_get_content_type (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	mime_type = _tmp5_;
	_tmp6_ = self->priv->factories_for_mime_type;
	_tmp7_ = mime_type;
	if (!g_hash_table_contains (_tmp6_, _tmp7_)) {
		GamesUriGameFactory** _tmp8_;
		GamesUriGameFactory** _tmp9_;
		gint _tmp9__length1;
		_tmp8_ = g_new0 (GamesUriGameFactory*, 0 + 1);
		_tmp9_ = _tmp8_;
		_tmp9__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp9__length1;
		}
		result = _tmp9_;
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		return result;
	}
	_tmp10_ = self->priv->factories_for_mime_type;
	_tmp11_ = mime_type;
	_tmp12_ = g_hash_table_lookup (_tmp10_, _tmp11_);
	_tmp13_ = ((GArray*) _tmp12_)->data;
	_tmp13__length1 = ((GArray*) _tmp12_)->len;
	_tmp14_ = (_tmp13_ != NULL) ? _vala_array_dup3 (_tmp13_, _tmp13__length1) : _tmp13_;
	_tmp14__length1 = _tmp13__length1;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _tmp14__length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	_g_free0 (mime_type);
	_g_object_unref0 (file_info);
	return result;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		GamesGameCollection* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->prev_game);
		_g_object_unref0 (_data12_->game);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		GamesGameCollection* self;
		self = _data13_->_data12_->self;
		_g_object_unref0 (_data13_->cached_game);
		block12_data_unref (_data13_->_data12_);
		_data13_->_data12_ = NULL;
		g_slice_free (Block13Data, _data13_);
	}
}

static gpointer
_vala_g_hash_table_take (GHashTable* self,
                         gconstpointer key,
                         gboolean* exists)
{
	gboolean _vala_exists = FALSE;
	GHashTable* ht = NULL;
	void** htp = NULL;
	gconstpointer _tmp0_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	ht = NULL;
	htp = &ht;
	_tmp0_ = g_hash_table_lookup (self, key);
	*htp = _tmp0_;
	_vala_exists = g_hash_table_steal (self, key);
	result = ht;
	if (exists) {
		*exists = _vala_exists;
	}
	return result;
}

static gboolean
___lambda6_ (Block13Data* _data13_)
{
	Block12Data* _data12_;
	GamesGameCollection* self;
	GamesGame* _tmp0_;
	gboolean result;
	_data12_ = _data13_->_data12_;
	self = _data12_->self;
	_tmp0_ = _data13_->cached_game;
	g_signal_emit (self, games_game_collection_signals[GAMES_GAME_COLLECTION_GAME_REPLACED_SIGNAL], 0, _data12_->game, _tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
____lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda6_ (self);
	return result;
}

static gboolean
__lambda7_ (Block12Data* _data12_)
{
	GamesGameCollection* self;
	GamesGame* _tmp0_;
	gboolean result;
	self = _data12_->self;
	_tmp0_ = _data12_->prev_game;
	if (_tmp0_ != NULL) {
		GamesGame* _tmp1_;
		_tmp1_ = _data12_->prev_game;
		g_signal_emit (self, games_game_collection_signals[GAMES_GAME_COLLECTION_GAME_REPLACED_SIGNAL], 0, _data12_->game, _tmp1_);
	} else {
		g_signal_emit (self, games_game_collection_signals[GAMES_GAME_COLLECTION_GAME_ADDED_SIGNAL], 0, _data12_->game);
	}
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda7_ (self);
	return result;
}

static void
games_game_collection_store_game (GamesGameCollection* self,
                                  GamesGame* game)
{
	Block12Data* _data12_;
	GamesGame* _tmp0_;
	gchar* uri = NULL;
	GamesUri* _tmp1_;
	GamesUri* _tmp2_;
	gchar* _tmp3_;
	GHashTable* _tmp4_;
	const gchar* _tmp5_;
	gchar* uid = NULL;
	GamesUid* _tmp19_;
	GamesUid* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_ = FALSE;
	GHashTable* _tmp23_;
	const gchar* _tmp24_;
	GHashTable* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	GamesGame* _tmp29_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (game != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (_data12_->game);
	_data12_->game = _tmp0_;
	_tmp1_ = games_game_get_uri (_data12_->game);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_uri_to_string (_tmp2_);
	uri = _tmp3_;
	_tmp4_ = self->priv->cached_games;
	_tmp5_ = uri;
	if (g_hash_table_contains (_tmp4_, _tmp5_)) {
		Block13Data* _data13_;
		GHashTable* _tmp6_;
		const gchar* _tmp7_;
		gpointer _tmp8_;
		_data13_ = g_slice_new0 (Block13Data);
		_data13_->_ref_count_ = 1;
		_data13_->_data12_ = block12_data_ref (_data12_);
		_tmp6_ = self->priv->cached_games;
		_tmp7_ = uri;
		_tmp8_ = _vala_g_hash_table_take (_tmp6_, _tmp7_, NULL);
		_data13_->cached_game = (GamesGame*) _tmp8_;
		{
			GamesDatabase* _tmp9_;
			GamesGame* _tmp10_;
			_tmp9_ = self->priv->database;
			_tmp10_ = _data13_->cached_game;
			games_database_update_game (_tmp9_, _data12_->game, _tmp10_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp11_;
			const gchar* _tmp12_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp11_ = e;
			_tmp12_ = _tmp11_->message;
			g_warning ("game-collection.vala:251: Couldn't update game: %s", _tmp12_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block13_data_unref (_data13_);
			_data13_ = NULL;
			_g_free0 (uri);
			block12_data_unref (_data12_);
			_data12_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda6__gsource_func, block13_data_ref (_data13_), block13_data_unref);
		block13_data_unref (_data13_);
		_data13_ = NULL;
		_g_free0 (uri);
		block12_data_unref (_data12_);
		_data12_ = NULL;
		return;
	}
	_data12_->prev_game = NULL;
	{
		GamesGame* _tmp13_ = NULL;
		GamesDatabase* _tmp14_;
		GamesGame* _tmp15_;
		GamesGame* _tmp16_;
		_tmp14_ = self->priv->database;
		_tmp15_ = games_database_store_game (_tmp14_, _data12_->game, &_inner_error0_);
		_tmp13_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp16_ = _tmp13_;
		_tmp13_ = NULL;
		_g_object_unref0 (_data12_->prev_game);
		_data12_->prev_game = _tmp16_;
		_g_object_unref0 (_tmp13_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_warning ("game-collection.vala:267: Couldn't cache game: %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (uri);
		block12_data_unref (_data12_);
		_data12_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp19_ = games_game_get_uid (_data12_->game);
	_tmp20_ = _tmp19_;
	_tmp21_ = games_uid_to_string (_tmp20_);
	uid = _tmp21_;
	_tmp23_ = self->priv->games;
	_tmp24_ = uid;
	if (g_hash_table_contains (_tmp23_, _tmp24_)) {
		GamesGame* _tmp25_;
		_tmp25_ = _data12_->prev_game;
		_tmp22_ = _tmp25_ == NULL;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		_g_free0 (uid);
		_g_free0 (uri);
		block12_data_unref (_data12_);
		_data12_ = NULL;
		return;
	}
	_tmp26_ = self->priv->games;
	_tmp27_ = uid;
	_tmp28_ = g_strdup (_tmp27_);
	_tmp29_ = _g_object_ref0 (_data12_->game);
	g_hash_table_insert (_tmp26_, _tmp28_, _tmp29_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda7__gsource_func, block12_data_ref (_data12_), block12_data_unref);
	_g_free0 (uid);
	_g_free0 (uri);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

static void
games_game_collection_query_game_for_uid_data_free (gpointer _data)
{
	GamesGameCollectionQueryGameForUidData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesGameCollectionQueryGameForUidData, _data_);
}

void
games_game_collection_query_game_for_uid (GamesGameCollection* self,
                                          const gchar* uid,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	GamesGameCollectionQueryGameForUidData* _data_;
	GamesGameCollection* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	_data_ = g_slice_new0 (GamesGameCollectionQueryGameForUidData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, games_game_collection_query_game_for_uid_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (uid);
	_g_free0 (_data_->uid);
	_data_->uid = _tmp1_;
	games_game_collection_query_game_for_uid_co (_data_);
}

GamesGame*
games_game_collection_query_game_for_uid_finish (GamesGameCollection* self,
                                                 GAsyncResult* _res_)
{
	GamesGame* result;
	GamesGameCollectionQueryGameForUidData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		GamesGameCollection* self;
		self = _data14_->self;
		_g_object_unref0 (_data14_->_result_);
		_g_free0 (_data14_->uid);
		_g_object_unref0 (self);
		g_slice_free (Block14Data, _data14_);
	}
}

static void
__lambda13_ (Block14Data* _data14_,
             GamesGame* game)
{
	GamesGameCollection* self;
	gchar* game_uid = NULL;
	GamesUid* _tmp0_;
	GamesUid* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	GamesGame* _tmp4_;
	self = _data14_->self;
	g_return_if_fail (game != NULL);
	_tmp0_ = games_game_get_uid (game);
	_tmp1_ = _tmp0_;
	_tmp2_ = games_uid_to_string (_tmp1_);
	game_uid = _tmp2_;
	_tmp3_ = game_uid;
	if (g_strcmp0 (_tmp3_, _data14_->uid) != 0) {
		_g_free0 (game_uid);
		return;
	}
	_tmp4_ = _g_object_ref0 (game);
	_g_object_unref0 (_data14_->_result_);
	_data14_->_result_ = _tmp4_;
	g_signal_handler_disconnect ((GObject*) self, _data14_->game_added_id);
	g_signal_handler_disconnect ((GObject*) self, _data14_->loading_done_id);
	games_game_collection_query_game_for_uid_co (_data14_->_async_data_);
	_g_free0 (game_uid);
}

static void
___lambda13__games_game_collection_game_added (GamesGameCollection* _sender,
                                               GamesGame* game,
                                               gpointer self)
{
	__lambda13_ (self, game);
}

static void
__lambda14_ (Block14Data* _data14_)
{
	GamesGameCollection* self;
	self = _data14_->self;
	g_signal_handler_disconnect ((GObject*) self, _data14_->game_added_id);
	g_signal_handler_disconnect ((GObject*) self, _data14_->loading_done_id);
	games_game_collection_query_game_for_uid_co (_data14_->_async_data_);
}

static void
___lambda14__games_game_collection_loading_done (GamesGameCollection* _sender,
                                                 gpointer self)
{
	__lambda14_ (self);
}

static gboolean
games_game_collection_query_game_for_uid_co (GamesGameCollectionQueryGameForUidData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data14_ = g_slice_new0 (Block14Data);
	_data_->_data14_->_ref_count_ = 1;
	_data_->_data14_->self = g_object_ref (_data_->self);
	_g_free0 (_data_->_data14_->uid);
	_data_->_data14_->uid = _data_->uid;
	_data_->_data14_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->games;
	if (g_hash_table_contains (_data_->_tmp0_, _data_->_data14_->uid)) {
		_data_->_tmp1_ = _data_->self->priv->games;
		_data_->_tmp2_ = g_hash_table_lookup (_data_->_tmp1_, _data_->_data14_->uid);
		_data_->_tmp3_ = _g_object_ref0 ((GamesGame*) _data_->_tmp2_);
		_data_->result = _data_->_tmp3_;
		block14_data_unref (_data_->_data14_);
		_data_->_data14_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->self->priv->is_loading_done) {
		_data_->result = NULL;
		block14_data_unref (_data_->_data14_);
		_data_->_data14_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_data14_->_result_ = NULL;
	_data_->_data14_->game_added_id = (gulong) 0;
	_data_->_data14_->loading_done_id = (gulong) 0;
	_data_->_tmp4_ = g_signal_connect_data (_data_->self, "game-added", (GCallback) ___lambda13__games_game_collection_game_added, block14_data_ref (_data_->_data14_), (GClosureNotify) block14_data_unref, 0);
	_data_->_data14_->game_added_id = _data_->_tmp4_;
	_data_->_tmp5_ = g_signal_connect_data (_data_->self, "loading-done", (GCallback) ___lambda14__games_game_collection_loading_done, block14_data_ref (_data_->_data14_), (GClosureNotify) block14_data_unref, 0);
	_data_->_data14_->loading_done_id = _data_->_tmp5_;
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp6_ = _data_->_data14_->_result_;
	_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp6_);
	_data_->result = _data_->_tmp7_;
	block14_data_unref (_data_->_data14_);
	_data_->_data14_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

gboolean
games_game_collection_get_paused (GamesGameCollection* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_paused;
	return result;
}

void
games_game_collection_set_paused (GamesGameCollection* self,
                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = games_game_collection_get_paused (self);
	if (old_value != value) {
		self->priv->_paused = value;
		g_object_notify_by_pspec ((GObject *) self, games_game_collection_properties[GAMES_GAME_COLLECTION_PAUSED_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
games_game_collection_class_init (GamesGameCollectionClass * klass,
                                  gpointer klass_data)
{
	games_game_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesGameCollection_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_game_collection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_game_collection_set_property;
	G_OBJECT_CLASS (klass)->finalize = games_game_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_GAME_COLLECTION_PAUSED_PROPERTY, games_game_collection_properties[GAMES_GAME_COLLECTION_PAUSED_PROPERTY] = g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	games_game_collection_signals[GAMES_GAME_COLLECTION_GAME_ADDED_SIGNAL] = g_signal_new ("game-added", GAMES_TYPE_GAME_COLLECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GAMES_TYPE_GAME);
	games_game_collection_signals[GAMES_GAME_COLLECTION_GAME_REPLACED_SIGNAL] = g_signal_new ("game-replaced", GAMES_TYPE_GAME_COLLECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, GAMES_TYPE_GAME, GAMES_TYPE_GAME);
	games_game_collection_signals[GAMES_GAME_COLLECTION_GAME_REMOVED_SIGNAL] = g_signal_new ("game-removed", GAMES_TYPE_GAME_COLLECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, GAMES_TYPE_GAME);
	games_game_collection_signals[GAMES_GAME_COLLECTION_LOADING_DONE_SIGNAL] = g_signal_new ("loading-done", GAMES_TYPE_GAME_COLLECTION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
games_game_collection_instance_init (GamesGameCollection * self,
                                     gpointer klass)
{
	self->priv = games_game_collection_get_instance_private (self);
}

static void
games_game_collection_finalize (GObject * obj)
{
	GamesGameCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAME_COLLECTION, GamesGameCollection);
	_g_hash_table_unref0 (self->priv->games);
	_g_hash_table_unref0 (self->priv->cached_games);
	self->priv->sources = (_vala_array_free (self->priv->sources, self->priv->sources_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->factories = (_vala_array_free (self->priv->factories, self->priv->factories_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->runner_factories = (_vala_array_free (self->priv->runner_factories, self->priv->runner_factories_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->priv->database);
	_g_hash_table_unref0 (self->priv->factories_for_mime_type);
	_g_hash_table_unref0 (self->priv->factories_for_scheme);
	_g_hash_table_unref0 (self->priv->runner_factories_for_platforms);
	(self->priv->search_games_cb_target_destroy_notify == NULL) ? NULL : (self->priv->search_games_cb_target_destroy_notify (self->priv->search_games_cb_target), NULL);
	self->priv->search_games_cb = NULL;
	self->priv->search_games_cb_target = NULL;
	self->priv->search_games_cb_target_destroy_notify = NULL;
	G_OBJECT_CLASS (games_game_collection_parent_class)->finalize (obj);
}

static GType
games_game_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGameCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_game_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGameCollection), 0, (GInstanceInitFunc) games_game_collection_instance_init, NULL };
	GType games_game_collection_type_id;
	games_game_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesGameCollection", &g_define_type_info, 0);
	GamesGameCollection_private_offset = g_type_add_instance_private (games_game_collection_type_id, sizeof (GamesGameCollectionPrivate));
	return games_game_collection_type_id;
}

GType
games_game_collection_get_type (void)
{
	static volatile gsize games_game_collection_type_id__once = 0;
	if (g_once_init_enter (&games_game_collection_type_id__once)) {
		GType games_game_collection_type_id;
		games_game_collection_type_id = games_game_collection_get_type_once ();
		g_once_init_leave (&games_game_collection_type_id__once, games_game_collection_type_id);
	}
	return games_game_collection_type_id__once;
}

static void
_vala_games_game_collection_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GamesGameCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAME_COLLECTION, GamesGameCollection);
	switch (property_id) {
		case GAMES_GAME_COLLECTION_PAUSED_PROPERTY:
		g_value_set_boolean (value, games_game_collection_get_paused (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_games_game_collection_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GamesGameCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_GAME_COLLECTION, GamesGameCollection);
	switch (property_id) {
		case GAMES_GAME_COLLECTION_PAUSED_PROPERTY:
		games_game_collection_set_paused (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

